/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/talent/v4/common.proto

package com.google.cloud.talent.v4;

/**
 *
 *
 * <pre>
 * Metadata used for long running operations returned by CTS batch APIs.
 * It's used to replace
 * [google.longrunning.Operation.metadata][google.longrunning.Operation.metadata].
 * </pre>
 *
 * Protobuf type {@code google.cloud.talent.v4.BatchOperationMetadata}
 */
public final class BatchOperationMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.talent.v4.BatchOperationMetadata)
    BatchOperationMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchOperationMetadata.newBuilder() to construct.
  private BatchOperationMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchOperationMetadata() {
    state_ = 0;
    stateDescription_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchOperationMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.talent.v4.CommonProto
        .internal_static_google_cloud_talent_v4_BatchOperationMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.talent.v4.CommonProto
        .internal_static_google_cloud_talent_v4_BatchOperationMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.talent.v4.BatchOperationMetadata.class,
            com.google.cloud.talent.v4.BatchOperationMetadata.Builder.class);
  }

  /** Protobuf enum {@code google.cloud.talent.v4.BatchOperationMetadata.State} */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The batch operation is being prepared for processing.
     * </pre>
     *
     * <code>INITIALIZING = 1;</code>
     */
    INITIALIZING(1),
    /**
     *
     *
     * <pre>
     * The batch operation is actively being processed.
     * </pre>
     *
     * <code>PROCESSING = 2;</code>
     */
    PROCESSING(2),
    /**
     *
     *
     * <pre>
     * The batch operation is processed, and at least one item has been
     * successfully processed.
     * </pre>
     *
     * <code>SUCCEEDED = 3;</code>
     */
    SUCCEEDED(3),
    /**
     *
     *
     * <pre>
     * The batch operation is done and no item has been successfully processed.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    FAILED(4),
    /**
     *
     *
     * <pre>
     * The batch operation is in the process of cancelling after
     * [google.longrunning.Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * is called.
     * </pre>
     *
     * <code>CANCELLING = 5;</code>
     */
    CANCELLING(5),
    /**
     *
     *
     * <pre>
     * The batch operation is done after
     * [google.longrunning.Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * is called. Any items processed before cancelling are returned in the
     * response.
     * </pre>
     *
     * <code>CANCELLED = 6;</code>
     */
    CANCELLED(6),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The batch operation is being prepared for processing.
     * </pre>
     *
     * <code>INITIALIZING = 1;</code>
     */
    public static final int INITIALIZING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The batch operation is actively being processed.
     * </pre>
     *
     * <code>PROCESSING = 2;</code>
     */
    public static final int PROCESSING_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The batch operation is processed, and at least one item has been
     * successfully processed.
     * </pre>
     *
     * <code>SUCCEEDED = 3;</code>
     */
    public static final int SUCCEEDED_VALUE = 3;
    /**
     *
     *
     * <pre>
     * The batch operation is done and no item has been successfully processed.
     * </pre>
     *
     * <code>FAILED = 4;</code>
     */
    public static final int FAILED_VALUE = 4;
    /**
     *
     *
     * <pre>
     * The batch operation is in the process of cancelling after
     * [google.longrunning.Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * is called.
     * </pre>
     *
     * <code>CANCELLING = 5;</code>
     */
    public static final int CANCELLING_VALUE = 5;
    /**
     *
     *
     * <pre>
     * The batch operation is done after
     * [google.longrunning.Operations.CancelOperation][google.longrunning.Operations.CancelOperation]
     * is called. Any items processed before cancelling are returned in the
     * response.
     * </pre>
     *
     * <code>CANCELLED = 6;</code>
     */
    public static final int CANCELLED_VALUE = 6;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return INITIALIZING;
        case 2:
          return PROCESSING;
        case 3:
          return SUCCEEDED;
        case 4:
          return FAILED;
        case 5:
          return CANCELLING;
        case 6:
          return CANCELLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.talent.v4.BatchOperationMetadata.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.talent.v4.BatchOperationMetadata.State)
  }

  public static final int STATE_FIELD_NUMBER = 1;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * The state of a long running operation.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.BatchOperationMetadata.State state = 1;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * The state of a long running operation.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.BatchOperationMetadata.State state = 1;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.BatchOperationMetadata.State getState() {
    com.google.cloud.talent.v4.BatchOperationMetadata.State result =
        com.google.cloud.talent.v4.BatchOperationMetadata.State.forNumber(state_);
    return result == null
        ? com.google.cloud.talent.v4.BatchOperationMetadata.State.UNRECOGNIZED
        : result;
  }

  public static final int STATE_DESCRIPTION_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object stateDescription_ = "";
  /**
   *
   *
   * <pre>
   * More detailed information about operation state.
   * </pre>
   *
   * <code>string state_description = 2;</code>
   *
   * @return The stateDescription.
   */
  @java.lang.Override
  public java.lang.String getStateDescription() {
    java.lang.Object ref = stateDescription_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      stateDescription_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * More detailed information about operation state.
   * </pre>
   *
   * <code>string state_description = 2;</code>
   *
   * @return The bytes for stateDescription.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateDescriptionBytes() {
    java.lang.Object ref = stateDescription_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      stateDescription_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SUCCESS_COUNT_FIELD_NUMBER = 3;
  private int successCount_ = 0;
  /**
   *
   *
   * <pre>
   * Count of successful item(s) inside an operation.
   * </pre>
   *
   * <code>int32 success_count = 3;</code>
   *
   * @return The successCount.
   */
  @java.lang.Override
  public int getSuccessCount() {
    return successCount_;
  }

  public static final int FAILURE_COUNT_FIELD_NUMBER = 4;
  private int failureCount_ = 0;
  /**
   *
   *
   * <pre>
   * Count of failed item(s) inside an operation.
   * </pre>
   *
   * <code>int32 failure_count = 4;</code>
   *
   * @return The failureCount.
   */
  @java.lang.Override
  public int getFailureCount() {
    return failureCount_;
  }

  public static final int TOTAL_COUNT_FIELD_NUMBER = 5;
  private int totalCount_ = 0;
  /**
   *
   *
   * <pre>
   * Count of total item(s) inside an operation.
   * </pre>
   *
   * <code>int32 total_count = 5;</code>
   *
   * @return The totalCount.
   */
  @java.lang.Override
  public int getTotalCount() {
    return totalCount_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * The time when the batch operation is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time when the batch operation is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * The time when the batch operation is created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp updateTime_;
  /**
   *
   *
   * <pre>
   * The time when the batch operation status is updated. The metadata and the
   * [update_time][google.cloud.talent.v4.BatchOperationMetadata.update_time] is
   * refreshed every minute otherwise cached data is returned.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7;</code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return updateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time when the batch operation status is updated. The metadata and the
   * [update_time][google.cloud.talent.v4.BatchOperationMetadata.update_time] is
   * refreshed every minute otherwise cached data is returned.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7;</code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }
  /**
   *
   *
   * <pre>
   * The time when the batch operation status is updated. The metadata and the
   * [update_time][google.cloud.talent.v4.BatchOperationMetadata.update_time] is
   * refreshed every minute otherwise cached data is returned.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int END_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp endTime_;
  /**
   *
   *
   * <pre>
   * The time when the batch operation is finished and
   * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
   * set to `true`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8;</code>
   *
   * @return Whether the endTime field is set.
   */
  @java.lang.Override
  public boolean hasEndTime() {
    return endTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time when the batch operation is finished and
   * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
   * set to `true`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8;</code>
   *
   * @return The endTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getEndTime() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }
  /**
   *
   *
   * <pre>
   * The time when the batch operation is finished and
   * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
   * set to `true`.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp end_time = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
    return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (state_
        != com.google.cloud.talent.v4.BatchOperationMetadata.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateDescription_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, stateDescription_);
    }
    if (successCount_ != 0) {
      output.writeInt32(3, successCount_);
    }
    if (failureCount_ != 0) {
      output.writeInt32(4, failureCount_);
    }
    if (totalCount_ != 0) {
      output.writeInt32(5, totalCount_);
    }
    if (createTime_ != null) {
      output.writeMessage(6, getCreateTime());
    }
    if (updateTime_ != null) {
      output.writeMessage(7, getUpdateTime());
    }
    if (endTime_ != null) {
      output.writeMessage(8, getEndTime());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (state_
        != com.google.cloud.talent.v4.BatchOperationMetadata.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, state_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(stateDescription_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, stateDescription_);
    }
    if (successCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, successCount_);
    }
    if (failureCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, failureCount_);
    }
    if (totalCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, totalCount_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (updateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getUpdateTime());
    }
    if (endTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getEndTime());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.talent.v4.BatchOperationMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.talent.v4.BatchOperationMetadata other =
        (com.google.cloud.talent.v4.BatchOperationMetadata) obj;

    if (state_ != other.state_) return false;
    if (!getStateDescription().equals(other.getStateDescription())) return false;
    if (getSuccessCount() != other.getSuccessCount()) return false;
    if (getFailureCount() != other.getFailureCount()) return false;
    if (getTotalCount() != other.getTotalCount()) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasEndTime() != other.hasEndTime()) return false;
    if (hasEndTime()) {
      if (!getEndTime().equals(other.getEndTime())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    hash = (37 * hash) + STATE_DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getStateDescription().hashCode();
    hash = (37 * hash) + SUCCESS_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getSuccessCount();
    hash = (37 * hash) + FAILURE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getFailureCount();
    hash = (37 * hash) + TOTAL_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getTotalCount();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasEndTime()) {
      hash = (37 * hash) + END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getEndTime().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.talent.v4.BatchOperationMetadata parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.BatchOperationMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.BatchOperationMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.BatchOperationMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.BatchOperationMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.BatchOperationMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.BatchOperationMetadata parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.BatchOperationMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.BatchOperationMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.BatchOperationMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.BatchOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.BatchOperationMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.talent.v4.BatchOperationMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Metadata used for long running operations returned by CTS batch APIs.
   * It's used to replace
   * [google.longrunning.Operation.metadata][google.longrunning.Operation.metadata].
   * </pre>
   *
   * Protobuf type {@code google.cloud.talent.v4.BatchOperationMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.talent.v4.BatchOperationMetadata)
      com.google.cloud.talent.v4.BatchOperationMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.talent.v4.CommonProto
          .internal_static_google_cloud_talent_v4_BatchOperationMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.talent.v4.CommonProto
          .internal_static_google_cloud_talent_v4_BatchOperationMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.talent.v4.BatchOperationMetadata.class,
              com.google.cloud.talent.v4.BatchOperationMetadata.Builder.class);
    }

    // Construct using com.google.cloud.talent.v4.BatchOperationMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      state_ = 0;
      stateDescription_ = "";
      successCount_ = 0;
      failureCount_ = 0;
      totalCount_ = 0;
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.talent.v4.CommonProto
          .internal_static_google_cloud_talent_v4_BatchOperationMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.BatchOperationMetadata getDefaultInstanceForType() {
      return com.google.cloud.talent.v4.BatchOperationMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.BatchOperationMetadata build() {
      com.google.cloud.talent.v4.BatchOperationMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.BatchOperationMetadata buildPartial() {
      com.google.cloud.talent.v4.BatchOperationMetadata result =
          new com.google.cloud.talent.v4.BatchOperationMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.talent.v4.BatchOperationMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.stateDescription_ = stateDescription_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.successCount_ = successCount_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.failureCount_ = failureCount_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.totalCount_ = totalCount_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.endTime_ = endTimeBuilder_ == null ? endTime_ : endTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.talent.v4.BatchOperationMetadata) {
        return mergeFrom((com.google.cloud.talent.v4.BatchOperationMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.talent.v4.BatchOperationMetadata other) {
      if (other == com.google.cloud.talent.v4.BatchOperationMetadata.getDefaultInstance())
        return this;
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (!other.getStateDescription().isEmpty()) {
        stateDescription_ = other.stateDescription_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getSuccessCount() != 0) {
        setSuccessCount(other.getSuccessCount());
      }
      if (other.getFailureCount() != 0) {
        setFailureCount(other.getFailureCount());
      }
      if (other.getTotalCount() != 0) {
        setTotalCount(other.getTotalCount());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasEndTime()) {
        mergeEndTime(other.getEndTime());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                stateDescription_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                successCount_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                failureCount_ = input.readInt32();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                totalCount_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * The state of a long running operation.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.BatchOperationMetadata.State state = 1;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * The state of a long running operation.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.BatchOperationMetadata.State state = 1;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of a long running operation.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.BatchOperationMetadata.State state = 1;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.BatchOperationMetadata.State getState() {
      com.google.cloud.talent.v4.BatchOperationMetadata.State result =
          com.google.cloud.talent.v4.BatchOperationMetadata.State.forNumber(state_);
      return result == null
          ? com.google.cloud.talent.v4.BatchOperationMetadata.State.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The state of a long running operation.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.BatchOperationMetadata.State state = 1;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.talent.v4.BatchOperationMetadata.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The state of a long running operation.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.BatchOperationMetadata.State state = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000001);
      state_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object stateDescription_ = "";
    /**
     *
     *
     * <pre>
     * More detailed information about operation state.
     * </pre>
     *
     * <code>string state_description = 2;</code>
     *
     * @return The stateDescription.
     */
    public java.lang.String getStateDescription() {
      java.lang.Object ref = stateDescription_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stateDescription_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * More detailed information about operation state.
     * </pre>
     *
     * <code>string state_description = 2;</code>
     *
     * @return The bytes for stateDescription.
     */
    public com.google.protobuf.ByteString getStateDescriptionBytes() {
      java.lang.Object ref = stateDescription_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        stateDescription_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * More detailed information about operation state.
     * </pre>
     *
     * <code>string state_description = 2;</code>
     *
     * @param value The stateDescription to set.
     * @return This builder for chaining.
     */
    public Builder setStateDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      stateDescription_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * More detailed information about operation state.
     * </pre>
     *
     * <code>string state_description = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStateDescription() {
      stateDescription_ = getDefaultInstance().getStateDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * More detailed information about operation state.
     * </pre>
     *
     * <code>string state_description = 2;</code>
     *
     * @param value The bytes for stateDescription to set.
     * @return This builder for chaining.
     */
    public Builder setStateDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      stateDescription_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int successCount_;
    /**
     *
     *
     * <pre>
     * Count of successful item(s) inside an operation.
     * </pre>
     *
     * <code>int32 success_count = 3;</code>
     *
     * @return The successCount.
     */
    @java.lang.Override
    public int getSuccessCount() {
      return successCount_;
    }
    /**
     *
     *
     * <pre>
     * Count of successful item(s) inside an operation.
     * </pre>
     *
     * <code>int32 success_count = 3;</code>
     *
     * @param value The successCount to set.
     * @return This builder for chaining.
     */
    public Builder setSuccessCount(int value) {

      successCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Count of successful item(s) inside an operation.
     * </pre>
     *
     * <code>int32 success_count = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSuccessCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      successCount_ = 0;
      onChanged();
      return this;
    }

    private int failureCount_;
    /**
     *
     *
     * <pre>
     * Count of failed item(s) inside an operation.
     * </pre>
     *
     * <code>int32 failure_count = 4;</code>
     *
     * @return The failureCount.
     */
    @java.lang.Override
    public int getFailureCount() {
      return failureCount_;
    }
    /**
     *
     *
     * <pre>
     * Count of failed item(s) inside an operation.
     * </pre>
     *
     * <code>int32 failure_count = 4;</code>
     *
     * @param value The failureCount to set.
     * @return This builder for chaining.
     */
    public Builder setFailureCount(int value) {

      failureCount_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Count of failed item(s) inside an operation.
     * </pre>
     *
     * <code>int32 failure_count = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFailureCount() {
      bitField0_ = (bitField0_ & ~0x00000008);
      failureCount_ = 0;
      onChanged();
      return this;
    }

    private int totalCount_;
    /**
     *
     *
     * <pre>
     * Count of total item(s) inside an operation.
     * </pre>
     *
     * <code>int32 total_count = 5;</code>
     *
     * @return The totalCount.
     */
    @java.lang.Override
    public int getTotalCount() {
      return totalCount_;
    }
    /**
     *
     *
     * <pre>
     * Count of total item(s) inside an operation.
     * </pre>
     *
     * <code>int32 total_count = 5;</code>
     *
     * @param value The totalCount to set.
     * @return This builder for chaining.
     */
    public Builder setTotalCount(int value) {

      totalCount_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Count of total item(s) inside an operation.
     * </pre>
     *
     * <code>int32 total_count = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalCount() {
      bitField0_ = (bitField0_ & ~0x00000010);
      totalCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time when the batch operation is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation is created.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time when the batch operation status is updated. The metadata and the
     * [update_time][google.cloud.talent.v4.BatchOperationMetadata.update_time] is
     * refreshed every minute otherwise cached data is returned.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 7;</code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation status is updated. The metadata and the
     * [update_time][google.cloud.talent.v4.BatchOperationMetadata.update_time] is
     * refreshed every minute otherwise cached data is returned.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 7;</code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation status is updated. The metadata and the
     * [update_time][google.cloud.talent.v4.BatchOperationMetadata.update_time] is
     * refreshed every minute otherwise cached data is returned.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 7;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation status is updated. The metadata and the
     * [update_time][google.cloud.talent.v4.BatchOperationMetadata.update_time] is
     * refreshed every minute otherwise cached data is returned.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 7;</code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation status is updated. The metadata and the
     * [update_time][google.cloud.talent.v4.BatchOperationMetadata.update_time] is
     * refreshed every minute otherwise cached data is returned.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 7;</code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation status is updated. The metadata and the
     * [update_time][google.cloud.talent.v4.BatchOperationMetadata.update_time] is
     * refreshed every minute otherwise cached data is returned.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 7;</code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation status is updated. The metadata and the
     * [update_time][google.cloud.talent.v4.BatchOperationMetadata.update_time] is
     * refreshed every minute otherwise cached data is returned.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation status is updated. The metadata and the
     * [update_time][google.cloud.talent.v4.BatchOperationMetadata.update_time] is
     * refreshed every minute otherwise cached data is returned.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation status is updated. The metadata and the
     * [update_time][google.cloud.talent.v4.BatchOperationMetadata.update_time] is
     * refreshed every minute otherwise cached data is returned.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp update_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp endTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        endTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time when the batch operation is finished and
     * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
     * set to `true`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     *
     * @return Whether the endTime field is set.
     */
    public boolean hasEndTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation is finished and
     * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
     * set to `true`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     *
     * @return The endTime.
     */
    public com.google.protobuf.Timestamp getEndTime() {
      if (endTimeBuilder_ == null) {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      } else {
        return endTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation is finished and
     * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
     * set to `true`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        endTime_ = value;
      } else {
        endTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation is finished and
     * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
     * set to `true`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public Builder setEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (endTimeBuilder_ == null) {
        endTime_ = builderForValue.build();
      } else {
        endTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation is finished and
     * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
     * set to `true`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public Builder mergeEndTime(com.google.protobuf.Timestamp value) {
      if (endTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && endTime_ != null
            && endTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getEndTimeBuilder().mergeFrom(value);
        } else {
          endTime_ = value;
        }
      } else {
        endTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation is finished and
     * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
     * set to `true`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public Builder clearEndTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      endTime_ = null;
      if (endTimeBuilder_ != null) {
        endTimeBuilder_.dispose();
        endTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation is finished and
     * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
     * set to `true`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public com.google.protobuf.Timestamp.Builder getEndTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation is finished and
     * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
     * set to `true`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getEndTimeOrBuilder() {
      if (endTimeBuilder_ != null) {
        return endTimeBuilder_.getMessageOrBuilder();
      } else {
        return endTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : endTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the batch operation is finished and
     * [google.longrunning.Operation.done][google.longrunning.Operation.done] is
     * set to `true`.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_time = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getEndTimeFieldBuilder() {
      if (endTimeBuilder_ == null) {
        endTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getEndTime(), getParentForChildren(), isClean());
        endTime_ = null;
      }
      return endTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.talent.v4.BatchOperationMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.talent.v4.BatchOperationMetadata)
  private static final com.google.cloud.talent.v4.BatchOperationMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.talent.v4.BatchOperationMetadata();
  }

  public static com.google.cloud.talent.v4.BatchOperationMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchOperationMetadata> PARSER =
      new com.google.protobuf.AbstractParser<BatchOperationMetadata>() {
        @java.lang.Override
        public BatchOperationMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchOperationMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchOperationMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.talent.v4.BatchOperationMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
