/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/talent/v4/event.proto

package com.google.cloud.talent.v4;

/**
 *
 *
 * <pre>
 * An event issued when an end user interacts with the application that
 * implements Cloud Talent Solution. Providing this information improves the
 * quality of results for the API clients, enabling the
 * service to perform optimally. The number of events sent must be consistent
 * with other calls, such as job searches, issued to the service by the client.
 * </pre>
 *
 * Protobuf type {@code google.cloud.talent.v4.ClientEvent}
 */
public final class ClientEvent extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.talent.v4.ClientEvent)
    ClientEventOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ClientEvent.newBuilder() to construct.
  private ClientEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ClientEvent() {
    requestId_ = "";
    eventId_ = "";
    eventNotes_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ClientEvent();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.talent.v4.EventProto
        .internal_static_google_cloud_talent_v4_ClientEvent_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.talent.v4.EventProto
        .internal_static_google_cloud_talent_v4_ClientEvent_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.talent.v4.ClientEvent.class,
            com.google.cloud.talent.v4.ClientEvent.Builder.class);
  }

  private int eventCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object event_;

  public enum EventCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    JOB_EVENT(5),
    EVENT_NOT_SET(0);
    private final int value;

    private EventCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static EventCase valueOf(int value) {
      return forNumber(value);
    }

    public static EventCase forNumber(int value) {
      switch (value) {
        case 5:
          return JOB_EVENT;
        case 0:
          return EVENT_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public EventCase getEventCase() {
    return EventCase.forNumber(eventCase_);
  }

  public static final int REQUEST_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requestId_ = "";
  /**
   *
   *
   * <pre>
   * Strongly recommended for the best service experience.
   *
   * A unique ID generated in the API responses. It can be found in
   * [ResponseMetadata.request_id][google.cloud.talent.v4.ResponseMetadata.request_id].
   * </pre>
   *
   * <code>string request_id = 1;</code>
   *
   * @return The requestId.
   */
  @java.lang.Override
  public java.lang.String getRequestId() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requestId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Strongly recommended for the best service experience.
   *
   * A unique ID generated in the API responses. It can be found in
   * [ResponseMetadata.request_id][google.cloud.talent.v4.ResponseMetadata.request_id].
   * </pre>
   *
   * <code>string request_id = 1;</code>
   *
   * @return The bytes for requestId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequestIdBytes() {
    java.lang.Object ref = requestId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requestId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EVENT_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object eventId_ = "";
  /**
   *
   *
   * <pre>
   * Required. A unique identifier, generated by the client application.
   * </pre>
   *
   * <code>string event_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The eventId.
   */
  @java.lang.Override
  public java.lang.String getEventId() {
    java.lang.Object ref = eventId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      eventId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. A unique identifier, generated by the client application.
   * </pre>
   *
   * <code>string event_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for eventId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEventIdBytes() {
    java.lang.Object ref = eventId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      eventId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Required. The timestamp of the event.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The timestamp of the event.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Required. The timestamp of the event.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int JOB_EVENT_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * An event issued when a job seeker interacts with the application that
   * implements Cloud Talent Solution.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.JobEvent job_event = 5;</code>
   *
   * @return Whether the jobEvent field is set.
   */
  @java.lang.Override
  public boolean hasJobEvent() {
    return eventCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * An event issued when a job seeker interacts with the application that
   * implements Cloud Talent Solution.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.JobEvent job_event = 5;</code>
   *
   * @return The jobEvent.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.JobEvent getJobEvent() {
    if (eventCase_ == 5) {
      return (com.google.cloud.talent.v4.JobEvent) event_;
    }
    return com.google.cloud.talent.v4.JobEvent.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * An event issued when a job seeker interacts with the application that
   * implements Cloud Talent Solution.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.JobEvent job_event = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.JobEventOrBuilder getJobEventOrBuilder() {
    if (eventCase_ == 5) {
      return (com.google.cloud.talent.v4.JobEvent) event_;
    }
    return com.google.cloud.talent.v4.JobEvent.getDefaultInstance();
  }

  public static final int EVENT_NOTES_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object eventNotes_ = "";
  /**
   *
   *
   * <pre>
   * Notes about the event provided by recruiters or other users, for example,
   * feedback on why a job was bookmarked.
   * </pre>
   *
   * <code>string event_notes = 9;</code>
   *
   * @return The eventNotes.
   */
  @java.lang.Override
  public java.lang.String getEventNotes() {
    java.lang.Object ref = eventNotes_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      eventNotes_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Notes about the event provided by recruiters or other users, for example,
   * feedback on why a job was bookmarked.
   * </pre>
   *
   * <code>string event_notes = 9;</code>
   *
   * @return The bytes for eventNotes.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEventNotesBytes() {
    java.lang.Object ref = eventNotes_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      eventNotes_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, requestId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(eventId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, eventId_);
    }
    if (createTime_ != null) {
      output.writeMessage(4, getCreateTime());
    }
    if (eventCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.talent.v4.JobEvent) event_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(eventNotes_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, eventNotes_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requestId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, requestId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(eventId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, eventId_);
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    if (eventCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.talent.v4.JobEvent) event_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(eventNotes_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, eventNotes_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.talent.v4.ClientEvent)) {
      return super.equals(obj);
    }
    com.google.cloud.talent.v4.ClientEvent other = (com.google.cloud.talent.v4.ClientEvent) obj;

    if (!getRequestId().equals(other.getRequestId())) return false;
    if (!getEventId().equals(other.getEventId())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (!getEventNotes().equals(other.getEventNotes())) return false;
    if (!getEventCase().equals(other.getEventCase())) return false;
    switch (eventCase_) {
      case 5:
        if (!getJobEvent().equals(other.getJobEvent())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + REQUEST_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequestId().hashCode();
    hash = (37 * hash) + EVENT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getEventId().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    hash = (37 * hash) + EVENT_NOTES_FIELD_NUMBER;
    hash = (53 * hash) + getEventNotes().hashCode();
    switch (eventCase_) {
      case 5:
        hash = (37 * hash) + JOB_EVENT_FIELD_NUMBER;
        hash = (53 * hash) + getJobEvent().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.talent.v4.ClientEvent parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.ClientEvent parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.ClientEvent parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.ClientEvent parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.ClientEvent parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.ClientEvent parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.ClientEvent parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.ClientEvent parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.ClientEvent parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.ClientEvent parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.ClientEvent parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.ClientEvent parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.talent.v4.ClientEvent prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * An event issued when an end user interacts with the application that
   * implements Cloud Talent Solution. Providing this information improves the
   * quality of results for the API clients, enabling the
   * service to perform optimally. The number of events sent must be consistent
   * with other calls, such as job searches, issued to the service by the client.
   * </pre>
   *
   * Protobuf type {@code google.cloud.talent.v4.ClientEvent}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.talent.v4.ClientEvent)
      com.google.cloud.talent.v4.ClientEventOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.talent.v4.EventProto
          .internal_static_google_cloud_talent_v4_ClientEvent_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.talent.v4.EventProto
          .internal_static_google_cloud_talent_v4_ClientEvent_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.talent.v4.ClientEvent.class,
              com.google.cloud.talent.v4.ClientEvent.Builder.class);
    }

    // Construct using com.google.cloud.talent.v4.ClientEvent.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      requestId_ = "";
      eventId_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      if (jobEventBuilder_ != null) {
        jobEventBuilder_.clear();
      }
      eventNotes_ = "";
      eventCase_ = 0;
      event_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.talent.v4.EventProto
          .internal_static_google_cloud_talent_v4_ClientEvent_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.ClientEvent getDefaultInstanceForType() {
      return com.google.cloud.talent.v4.ClientEvent.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.ClientEvent build() {
      com.google.cloud.talent.v4.ClientEvent result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.ClientEvent buildPartial() {
      com.google.cloud.talent.v4.ClientEvent result =
          new com.google.cloud.talent.v4.ClientEvent(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.talent.v4.ClientEvent result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.requestId_ = requestId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.eventId_ = eventId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.eventNotes_ = eventNotes_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.talent.v4.ClientEvent result) {
      result.eventCase_ = eventCase_;
      result.event_ = this.event_;
      if (eventCase_ == 5 && jobEventBuilder_ != null) {
        result.event_ = jobEventBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.talent.v4.ClientEvent) {
        return mergeFrom((com.google.cloud.talent.v4.ClientEvent) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.talent.v4.ClientEvent other) {
      if (other == com.google.cloud.talent.v4.ClientEvent.getDefaultInstance()) return this;
      if (!other.getRequestId().isEmpty()) {
        requestId_ = other.requestId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getEventId().isEmpty()) {
        eventId_ = other.eventId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (!other.getEventNotes().isEmpty()) {
        eventNotes_ = other.eventNotes_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      switch (other.getEventCase()) {
        case JOB_EVENT:
          {
            mergeJobEvent(other.getJobEvent());
            break;
          }
        case EVENT_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                requestId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                eventId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 34:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getJobEventFieldBuilder().getBuilder(), extensionRegistry);
                eventCase_ = 5;
                break;
              } // case 42
            case 74:
              {
                eventNotes_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int eventCase_ = 0;
    private java.lang.Object event_;

    public EventCase getEventCase() {
      return EventCase.forNumber(eventCase_);
    }

    public Builder clearEvent() {
      eventCase_ = 0;
      event_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object requestId_ = "";
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * A unique ID generated in the API responses. It can be found in
     * [ResponseMetadata.request_id][google.cloud.talent.v4.ResponseMetadata.request_id].
     * </pre>
     *
     * <code>string request_id = 1;</code>
     *
     * @return The requestId.
     */
    public java.lang.String getRequestId() {
      java.lang.Object ref = requestId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requestId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * A unique ID generated in the API responses. It can be found in
     * [ResponseMetadata.request_id][google.cloud.talent.v4.ResponseMetadata.request_id].
     * </pre>
     *
     * <code>string request_id = 1;</code>
     *
     * @return The bytes for requestId.
     */
    public com.google.protobuf.ByteString getRequestIdBytes() {
      java.lang.Object ref = requestId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requestId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * A unique ID generated in the API responses. It can be found in
     * [ResponseMetadata.request_id][google.cloud.talent.v4.ResponseMetadata.request_id].
     * </pre>
     *
     * <code>string request_id = 1;</code>
     *
     * @param value The requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requestId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * A unique ID generated in the API responses. It can be found in
     * [ResponseMetadata.request_id][google.cloud.talent.v4.ResponseMetadata.request_id].
     * </pre>
     *
     * <code>string request_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequestId() {
      requestId_ = getDefaultInstance().getRequestId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * A unique ID generated in the API responses. It can be found in
     * [ResponseMetadata.request_id][google.cloud.talent.v4.ResponseMetadata.request_id].
     * </pre>
     *
     * <code>string request_id = 1;</code>
     *
     * @param value The bytes for requestId to set.
     * @return This builder for chaining.
     */
    public Builder setRequestIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requestId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object eventId_ = "";
    /**
     *
     *
     * <pre>
     * Required. A unique identifier, generated by the client application.
     * </pre>
     *
     * <code>string event_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The eventId.
     */
    public java.lang.String getEventId() {
      java.lang.Object ref = eventId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        eventId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A unique identifier, generated by the client application.
     * </pre>
     *
     * <code>string event_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for eventId.
     */
    public com.google.protobuf.ByteString getEventIdBytes() {
      java.lang.Object ref = eventId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        eventId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. A unique identifier, generated by the client application.
     * </pre>
     *
     * <code>string event_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The eventId to set.
     * @return This builder for chaining.
     */
    public Builder setEventId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      eventId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A unique identifier, generated by the client application.
     * </pre>
     *
     * <code>string event_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEventId() {
      eventId_ = getDefaultInstance().getEventId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. A unique identifier, generated by the client application.
     * </pre>
     *
     * <code>string event_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for eventId to set.
     * @return This builder for chaining.
     */
    public Builder setEventIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      eventId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The timestamp of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The timestamp of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The timestamp of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The timestamp of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The timestamp of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The timestamp of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The timestamp of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The timestamp of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The timestamp of the event.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.JobEvent,
            com.google.cloud.talent.v4.JobEvent.Builder,
            com.google.cloud.talent.v4.JobEventOrBuilder>
        jobEventBuilder_;
    /**
     *
     *
     * <pre>
     * An event issued when a job seeker interacts with the application that
     * implements Cloud Talent Solution.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobEvent job_event = 5;</code>
     *
     * @return Whether the jobEvent field is set.
     */
    @java.lang.Override
    public boolean hasJobEvent() {
      return eventCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * An event issued when a job seeker interacts with the application that
     * implements Cloud Talent Solution.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobEvent job_event = 5;</code>
     *
     * @return The jobEvent.
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.JobEvent getJobEvent() {
      if (jobEventBuilder_ == null) {
        if (eventCase_ == 5) {
          return (com.google.cloud.talent.v4.JobEvent) event_;
        }
        return com.google.cloud.talent.v4.JobEvent.getDefaultInstance();
      } else {
        if (eventCase_ == 5) {
          return jobEventBuilder_.getMessage();
        }
        return com.google.cloud.talent.v4.JobEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An event issued when a job seeker interacts with the application that
     * implements Cloud Talent Solution.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobEvent job_event = 5;</code>
     */
    public Builder setJobEvent(com.google.cloud.talent.v4.JobEvent value) {
      if (jobEventBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        event_ = value;
        onChanged();
      } else {
        jobEventBuilder_.setMessage(value);
      }
      eventCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An event issued when a job seeker interacts with the application that
     * implements Cloud Talent Solution.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobEvent job_event = 5;</code>
     */
    public Builder setJobEvent(com.google.cloud.talent.v4.JobEvent.Builder builderForValue) {
      if (jobEventBuilder_ == null) {
        event_ = builderForValue.build();
        onChanged();
      } else {
        jobEventBuilder_.setMessage(builderForValue.build());
      }
      eventCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An event issued when a job seeker interacts with the application that
     * implements Cloud Talent Solution.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobEvent job_event = 5;</code>
     */
    public Builder mergeJobEvent(com.google.cloud.talent.v4.JobEvent value) {
      if (jobEventBuilder_ == null) {
        if (eventCase_ == 5 && event_ != com.google.cloud.talent.v4.JobEvent.getDefaultInstance()) {
          event_ =
              com.google.cloud.talent.v4.JobEvent.newBuilder(
                      (com.google.cloud.talent.v4.JobEvent) event_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          event_ = value;
        }
        onChanged();
      } else {
        if (eventCase_ == 5) {
          jobEventBuilder_.mergeFrom(value);
        } else {
          jobEventBuilder_.setMessage(value);
        }
      }
      eventCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An event issued when a job seeker interacts with the application that
     * implements Cloud Talent Solution.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobEvent job_event = 5;</code>
     */
    public Builder clearJobEvent() {
      if (jobEventBuilder_ == null) {
        if (eventCase_ == 5) {
          eventCase_ = 0;
          event_ = null;
          onChanged();
        }
      } else {
        if (eventCase_ == 5) {
          eventCase_ = 0;
          event_ = null;
        }
        jobEventBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An event issued when a job seeker interacts with the application that
     * implements Cloud Talent Solution.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobEvent job_event = 5;</code>
     */
    public com.google.cloud.talent.v4.JobEvent.Builder getJobEventBuilder() {
      return getJobEventFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An event issued when a job seeker interacts with the application that
     * implements Cloud Talent Solution.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobEvent job_event = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.JobEventOrBuilder getJobEventOrBuilder() {
      if ((eventCase_ == 5) && (jobEventBuilder_ != null)) {
        return jobEventBuilder_.getMessageOrBuilder();
      } else {
        if (eventCase_ == 5) {
          return (com.google.cloud.talent.v4.JobEvent) event_;
        }
        return com.google.cloud.talent.v4.JobEvent.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An event issued when a job seeker interacts with the application that
     * implements Cloud Talent Solution.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobEvent job_event = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.JobEvent,
            com.google.cloud.talent.v4.JobEvent.Builder,
            com.google.cloud.talent.v4.JobEventOrBuilder>
        getJobEventFieldBuilder() {
      if (jobEventBuilder_ == null) {
        if (!(eventCase_ == 5)) {
          event_ = com.google.cloud.talent.v4.JobEvent.getDefaultInstance();
        }
        jobEventBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.talent.v4.JobEvent,
                com.google.cloud.talent.v4.JobEvent.Builder,
                com.google.cloud.talent.v4.JobEventOrBuilder>(
                (com.google.cloud.talent.v4.JobEvent) event_, getParentForChildren(), isClean());
        event_ = null;
      }
      eventCase_ = 5;
      onChanged();
      return jobEventBuilder_;
    }

    private java.lang.Object eventNotes_ = "";
    /**
     *
     *
     * <pre>
     * Notes about the event provided by recruiters or other users, for example,
     * feedback on why a job was bookmarked.
     * </pre>
     *
     * <code>string event_notes = 9;</code>
     *
     * @return The eventNotes.
     */
    public java.lang.String getEventNotes() {
      java.lang.Object ref = eventNotes_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        eventNotes_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Notes about the event provided by recruiters or other users, for example,
     * feedback on why a job was bookmarked.
     * </pre>
     *
     * <code>string event_notes = 9;</code>
     *
     * @return The bytes for eventNotes.
     */
    public com.google.protobuf.ByteString getEventNotesBytes() {
      java.lang.Object ref = eventNotes_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        eventNotes_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Notes about the event provided by recruiters or other users, for example,
     * feedback on why a job was bookmarked.
     * </pre>
     *
     * <code>string event_notes = 9;</code>
     *
     * @param value The eventNotes to set.
     * @return This builder for chaining.
     */
    public Builder setEventNotes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      eventNotes_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Notes about the event provided by recruiters or other users, for example,
     * feedback on why a job was bookmarked.
     * </pre>
     *
     * <code>string event_notes = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEventNotes() {
      eventNotes_ = getDefaultInstance().getEventNotes();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Notes about the event provided by recruiters or other users, for example,
     * feedback on why a job was bookmarked.
     * </pre>
     *
     * <code>string event_notes = 9;</code>
     *
     * @param value The bytes for eventNotes to set.
     * @return This builder for chaining.
     */
    public Builder setEventNotesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      eventNotes_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.talent.v4.ClientEvent)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.talent.v4.ClientEvent)
  private static final com.google.cloud.talent.v4.ClientEvent DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.talent.v4.ClientEvent();
  }

  public static com.google.cloud.talent.v4.ClientEvent getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ClientEvent> PARSER =
      new com.google.protobuf.AbstractParser<ClientEvent>() {
        @java.lang.Override
        public ClientEvent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ClientEvent> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ClientEvent> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.talent.v4.ClientEvent getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
