/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/talent/v4/filters.proto

package com.google.cloud.talent.v4;

/**
 *
 *
 * <pre>
 * Parameters needed for commute search.
 * </pre>
 *
 * Protobuf type {@code google.cloud.talent.v4.CommuteFilter}
 */
public final class CommuteFilter extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.talent.v4.CommuteFilter)
    CommuteFilterOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CommuteFilter.newBuilder() to construct.
  private CommuteFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CommuteFilter() {
    commuteMethod_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CommuteFilter();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.talent.v4.FiltersProto
        .internal_static_google_cloud_talent_v4_CommuteFilter_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.talent.v4.FiltersProto
        .internal_static_google_cloud_talent_v4_CommuteFilter_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.talent.v4.CommuteFilter.class,
            com.google.cloud.talent.v4.CommuteFilter.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The traffic density to use when calculating commute time.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.talent.v4.CommuteFilter.RoadTraffic}
   */
  public enum RoadTraffic implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Road traffic situation isn't specified.
     * </pre>
     *
     * <code>ROAD_TRAFFIC_UNSPECIFIED = 0;</code>
     */
    ROAD_TRAFFIC_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Optimal commute time without considering any traffic impact.
     * </pre>
     *
     * <code>TRAFFIC_FREE = 1;</code>
     */
    TRAFFIC_FREE(1),
    /**
     *
     *
     * <pre>
     * Commute time calculation takes in account the peak traffic impact.
     * </pre>
     *
     * <code>BUSY_HOUR = 2;</code>
     */
    BUSY_HOUR(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Road traffic situation isn't specified.
     * </pre>
     *
     * <code>ROAD_TRAFFIC_UNSPECIFIED = 0;</code>
     */
    public static final int ROAD_TRAFFIC_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Optimal commute time without considering any traffic impact.
     * </pre>
     *
     * <code>TRAFFIC_FREE = 1;</code>
     */
    public static final int TRAFFIC_FREE_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Commute time calculation takes in account the peak traffic impact.
     * </pre>
     *
     * <code>BUSY_HOUR = 2;</code>
     */
    public static final int BUSY_HOUR_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RoadTraffic valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static RoadTraffic forNumber(int value) {
      switch (value) {
        case 0:
          return ROAD_TRAFFIC_UNSPECIFIED;
        case 1:
          return TRAFFIC_FREE;
        case 2:
          return BUSY_HOUR;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<RoadTraffic> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<RoadTraffic> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<RoadTraffic>() {
          public RoadTraffic findValueByNumber(int number) {
            return RoadTraffic.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.talent.v4.CommuteFilter.getDescriptor().getEnumTypes().get(0);
    }

    private static final RoadTraffic[] VALUES = values();

    public static RoadTraffic valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private RoadTraffic(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.talent.v4.CommuteFilter.RoadTraffic)
  }

  private int trafficOptionCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object trafficOption_;

  public enum TrafficOptionCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ROAD_TRAFFIC(5),
    DEPARTURE_TIME(6),
    TRAFFICOPTION_NOT_SET(0);
    private final int value;

    private TrafficOptionCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TrafficOptionCase valueOf(int value) {
      return forNumber(value);
    }

    public static TrafficOptionCase forNumber(int value) {
      switch (value) {
        case 5:
          return ROAD_TRAFFIC;
        case 6:
          return DEPARTURE_TIME;
        case 0:
          return TRAFFICOPTION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TrafficOptionCase getTrafficOptionCase() {
    return TrafficOptionCase.forNumber(trafficOptionCase_);
  }

  public static final int COMMUTE_METHOD_FIELD_NUMBER = 1;
  private int commuteMethod_ = 0;
  /**
   *
   *
   * <pre>
   * Required. The method of transportation to calculate the commute time for.
   * </pre>
   *
   * <code>
   * .google.cloud.talent.v4.CommuteMethod commute_method = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for commuteMethod.
   */
  @java.lang.Override
  public int getCommuteMethodValue() {
    return commuteMethod_;
  }
  /**
   *
   *
   * <pre>
   * Required. The method of transportation to calculate the commute time for.
   * </pre>
   *
   * <code>
   * .google.cloud.talent.v4.CommuteMethod commute_method = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The commuteMethod.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.CommuteMethod getCommuteMethod() {
    com.google.cloud.talent.v4.CommuteMethod result =
        com.google.cloud.talent.v4.CommuteMethod.forNumber(commuteMethod_);
    return result == null ? com.google.cloud.talent.v4.CommuteMethod.UNRECOGNIZED : result;
  }

  public static final int START_COORDINATES_FIELD_NUMBER = 2;
  private com.google.type.LatLng startCoordinates_;
  /**
   *
   *
   * <pre>
   * Required. The latitude and longitude of the location to calculate the
   * commute time from.
   * </pre>
   *
   * <code>.google.type.LatLng start_coordinates = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the startCoordinates field is set.
   */
  @java.lang.Override
  public boolean hasStartCoordinates() {
    return startCoordinates_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The latitude and longitude of the location to calculate the
   * commute time from.
   * </pre>
   *
   * <code>.google.type.LatLng start_coordinates = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The startCoordinates.
   */
  @java.lang.Override
  public com.google.type.LatLng getStartCoordinates() {
    return startCoordinates_ == null
        ? com.google.type.LatLng.getDefaultInstance()
        : startCoordinates_;
  }
  /**
   *
   *
   * <pre>
   * Required. The latitude and longitude of the location to calculate the
   * commute time from.
   * </pre>
   *
   * <code>.google.type.LatLng start_coordinates = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.type.LatLngOrBuilder getStartCoordinatesOrBuilder() {
    return startCoordinates_ == null
        ? com.google.type.LatLng.getDefaultInstance()
        : startCoordinates_;
  }

  public static final int TRAVEL_DURATION_FIELD_NUMBER = 3;
  private com.google.protobuf.Duration travelDuration_;
  /**
   *
   *
   * <pre>
   * Required. The maximum travel time in seconds. The maximum allowed value is
   * `3600s` (one hour). Format is `123s`.
   * </pre>
   *
   * <code>.google.protobuf.Duration travel_duration = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the travelDuration field is set.
   */
  @java.lang.Override
  public boolean hasTravelDuration() {
    return travelDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The maximum travel time in seconds. The maximum allowed value is
   * `3600s` (one hour). Format is `123s`.
   * </pre>
   *
   * <code>.google.protobuf.Duration travel_duration = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The travelDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTravelDuration() {
    return travelDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : travelDuration_;
  }
  /**
   *
   *
   * <pre>
   * Required. The maximum travel time in seconds. The maximum allowed value is
   * `3600s` (one hour). Format is `123s`.
   * </pre>
   *
   * <code>.google.protobuf.Duration travel_duration = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTravelDurationOrBuilder() {
    return travelDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : travelDuration_;
  }

  public static final int ALLOW_IMPRECISE_ADDRESSES_FIELD_NUMBER = 4;
  private boolean allowImpreciseAddresses_ = false;
  /**
   *
   *
   * <pre>
   * If `true`, jobs without street level addresses may also be returned.
   * For city level addresses, the city center is used. For state and coarser
   * level addresses, text matching is used.
   * If this field is set to `false` or isn't specified, only jobs that include
   * street level addresses will be returned by commute search.
   * </pre>
   *
   * <code>bool allow_imprecise_addresses = 4;</code>
   *
   * @return The allowImpreciseAddresses.
   */
  @java.lang.Override
  public boolean getAllowImpreciseAddresses() {
    return allowImpreciseAddresses_;
  }

  public static final int ROAD_TRAFFIC_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * Specifies the traffic density to use when calculating commute time.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.CommuteFilter.RoadTraffic road_traffic = 5;</code>
   *
   * @return Whether the roadTraffic field is set.
   */
  public boolean hasRoadTraffic() {
    return trafficOptionCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * Specifies the traffic density to use when calculating commute time.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.CommuteFilter.RoadTraffic road_traffic = 5;</code>
   *
   * @return The enum numeric value on the wire for roadTraffic.
   */
  public int getRoadTrafficValue() {
    if (trafficOptionCase_ == 5) {
      return (java.lang.Integer) trafficOption_;
    }
    return 0;
  }
  /**
   *
   *
   * <pre>
   * Specifies the traffic density to use when calculating commute time.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.CommuteFilter.RoadTraffic road_traffic = 5;</code>
   *
   * @return The roadTraffic.
   */
  public com.google.cloud.talent.v4.CommuteFilter.RoadTraffic getRoadTraffic() {
    if (trafficOptionCase_ == 5) {
      com.google.cloud.talent.v4.CommuteFilter.RoadTraffic result =
          com.google.cloud.talent.v4.CommuteFilter.RoadTraffic.forNumber(
              (java.lang.Integer) trafficOption_);
      return result == null
          ? com.google.cloud.talent.v4.CommuteFilter.RoadTraffic.UNRECOGNIZED
          : result;
    }
    return com.google.cloud.talent.v4.CommuteFilter.RoadTraffic.ROAD_TRAFFIC_UNSPECIFIED;
  }

  public static final int DEPARTURE_TIME_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * The departure time used to calculate traffic impact, represented as
   * [google.type.TimeOfDay][google.type.TimeOfDay] in local time zone.
   *
   * Currently traffic model is restricted to hour level resolution.
   * </pre>
   *
   * <code>.google.type.TimeOfDay departure_time = 6;</code>
   *
   * @return Whether the departureTime field is set.
   */
  @java.lang.Override
  public boolean hasDepartureTime() {
    return trafficOptionCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * The departure time used to calculate traffic impact, represented as
   * [google.type.TimeOfDay][google.type.TimeOfDay] in local time zone.
   *
   * Currently traffic model is restricted to hour level resolution.
   * </pre>
   *
   * <code>.google.type.TimeOfDay departure_time = 6;</code>
   *
   * @return The departureTime.
   */
  @java.lang.Override
  public com.google.type.TimeOfDay getDepartureTime() {
    if (trafficOptionCase_ == 6) {
      return (com.google.type.TimeOfDay) trafficOption_;
    }
    return com.google.type.TimeOfDay.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The departure time used to calculate traffic impact, represented as
   * [google.type.TimeOfDay][google.type.TimeOfDay] in local time zone.
   *
   * Currently traffic model is restricted to hour level resolution.
   * </pre>
   *
   * <code>.google.type.TimeOfDay departure_time = 6;</code>
   */
  @java.lang.Override
  public com.google.type.TimeOfDayOrBuilder getDepartureTimeOrBuilder() {
    if (trafficOptionCase_ == 6) {
      return (com.google.type.TimeOfDay) trafficOption_;
    }
    return com.google.type.TimeOfDay.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (commuteMethod_
        != com.google.cloud.talent.v4.CommuteMethod.COMMUTE_METHOD_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, commuteMethod_);
    }
    if (startCoordinates_ != null) {
      output.writeMessage(2, getStartCoordinates());
    }
    if (travelDuration_ != null) {
      output.writeMessage(3, getTravelDuration());
    }
    if (allowImpreciseAddresses_ != false) {
      output.writeBool(4, allowImpreciseAddresses_);
    }
    if (trafficOptionCase_ == 5) {
      output.writeEnum(5, ((java.lang.Integer) trafficOption_));
    }
    if (trafficOptionCase_ == 6) {
      output.writeMessage(6, (com.google.type.TimeOfDay) trafficOption_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (commuteMethod_
        != com.google.cloud.talent.v4.CommuteMethod.COMMUTE_METHOD_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, commuteMethod_);
    }
    if (startCoordinates_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getStartCoordinates());
    }
    if (travelDuration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTravelDuration());
    }
    if (allowImpreciseAddresses_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, allowImpreciseAddresses_);
    }
    if (trafficOptionCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeEnumSize(
              5, ((java.lang.Integer) trafficOption_));
    }
    if (trafficOptionCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.type.TimeOfDay) trafficOption_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.talent.v4.CommuteFilter)) {
      return super.equals(obj);
    }
    com.google.cloud.talent.v4.CommuteFilter other = (com.google.cloud.talent.v4.CommuteFilter) obj;

    if (commuteMethod_ != other.commuteMethod_) return false;
    if (hasStartCoordinates() != other.hasStartCoordinates()) return false;
    if (hasStartCoordinates()) {
      if (!getStartCoordinates().equals(other.getStartCoordinates())) return false;
    }
    if (hasTravelDuration() != other.hasTravelDuration()) return false;
    if (hasTravelDuration()) {
      if (!getTravelDuration().equals(other.getTravelDuration())) return false;
    }
    if (getAllowImpreciseAddresses() != other.getAllowImpreciseAddresses()) return false;
    if (!getTrafficOptionCase().equals(other.getTrafficOptionCase())) return false;
    switch (trafficOptionCase_) {
      case 5:
        if (getRoadTrafficValue() != other.getRoadTrafficValue()) return false;
        break;
      case 6:
        if (!getDepartureTime().equals(other.getDepartureTime())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + COMMUTE_METHOD_FIELD_NUMBER;
    hash = (53 * hash) + commuteMethod_;
    if (hasStartCoordinates()) {
      hash = (37 * hash) + START_COORDINATES_FIELD_NUMBER;
      hash = (53 * hash) + getStartCoordinates().hashCode();
    }
    if (hasTravelDuration()) {
      hash = (37 * hash) + TRAVEL_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getTravelDuration().hashCode();
    }
    hash = (37 * hash) + ALLOW_IMPRECISE_ADDRESSES_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowImpreciseAddresses());
    switch (trafficOptionCase_) {
      case 5:
        hash = (37 * hash) + ROAD_TRAFFIC_FIELD_NUMBER;
        hash = (53 * hash) + getRoadTrafficValue();
        break;
      case 6:
        hash = (37 * hash) + DEPARTURE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getDepartureTime().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.talent.v4.CommuteFilter parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.CommuteFilter parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.CommuteFilter parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.CommuteFilter parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.CommuteFilter parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.CommuteFilter parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.CommuteFilter parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.CommuteFilter parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.CommuteFilter parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.CommuteFilter parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.CommuteFilter parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.CommuteFilter parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.talent.v4.CommuteFilter prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Parameters needed for commute search.
   * </pre>
   *
   * Protobuf type {@code google.cloud.talent.v4.CommuteFilter}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.talent.v4.CommuteFilter)
      com.google.cloud.talent.v4.CommuteFilterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.talent.v4.FiltersProto
          .internal_static_google_cloud_talent_v4_CommuteFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.talent.v4.FiltersProto
          .internal_static_google_cloud_talent_v4_CommuteFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.talent.v4.CommuteFilter.class,
              com.google.cloud.talent.v4.CommuteFilter.Builder.class);
    }

    // Construct using com.google.cloud.talent.v4.CommuteFilter.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      commuteMethod_ = 0;
      startCoordinates_ = null;
      if (startCoordinatesBuilder_ != null) {
        startCoordinatesBuilder_.dispose();
        startCoordinatesBuilder_ = null;
      }
      travelDuration_ = null;
      if (travelDurationBuilder_ != null) {
        travelDurationBuilder_.dispose();
        travelDurationBuilder_ = null;
      }
      allowImpreciseAddresses_ = false;
      if (departureTimeBuilder_ != null) {
        departureTimeBuilder_.clear();
      }
      trafficOptionCase_ = 0;
      trafficOption_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.talent.v4.FiltersProto
          .internal_static_google_cloud_talent_v4_CommuteFilter_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.CommuteFilter getDefaultInstanceForType() {
      return com.google.cloud.talent.v4.CommuteFilter.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.CommuteFilter build() {
      com.google.cloud.talent.v4.CommuteFilter result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.CommuteFilter buildPartial() {
      com.google.cloud.talent.v4.CommuteFilter result =
          new com.google.cloud.talent.v4.CommuteFilter(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.talent.v4.CommuteFilter result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.commuteMethod_ = commuteMethod_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.startCoordinates_ =
            startCoordinatesBuilder_ == null ? startCoordinates_ : startCoordinatesBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.travelDuration_ =
            travelDurationBuilder_ == null ? travelDuration_ : travelDurationBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.allowImpreciseAddresses_ = allowImpreciseAddresses_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.talent.v4.CommuteFilter result) {
      result.trafficOptionCase_ = trafficOptionCase_;
      result.trafficOption_ = this.trafficOption_;
      if (trafficOptionCase_ == 6 && departureTimeBuilder_ != null) {
        result.trafficOption_ = departureTimeBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.talent.v4.CommuteFilter) {
        return mergeFrom((com.google.cloud.talent.v4.CommuteFilter) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.talent.v4.CommuteFilter other) {
      if (other == com.google.cloud.talent.v4.CommuteFilter.getDefaultInstance()) return this;
      if (other.commuteMethod_ != 0) {
        setCommuteMethodValue(other.getCommuteMethodValue());
      }
      if (other.hasStartCoordinates()) {
        mergeStartCoordinates(other.getStartCoordinates());
      }
      if (other.hasTravelDuration()) {
        mergeTravelDuration(other.getTravelDuration());
      }
      if (other.getAllowImpreciseAddresses() != false) {
        setAllowImpreciseAddresses(other.getAllowImpreciseAddresses());
      }
      switch (other.getTrafficOptionCase()) {
        case ROAD_TRAFFIC:
          {
            setRoadTrafficValue(other.getRoadTrafficValue());
            break;
          }
        case DEPARTURE_TIME:
          {
            mergeDepartureTime(other.getDepartureTime());
            break;
          }
        case TRAFFICOPTION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                commuteMethod_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(
                    getStartCoordinatesFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getTravelDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                allowImpreciseAddresses_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                int rawValue = input.readEnum();
                trafficOptionCase_ = 5;
                trafficOption_ = rawValue;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getDepartureTimeFieldBuilder().getBuilder(), extensionRegistry);
                trafficOptionCase_ = 6;
                break;
              } // case 50
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int trafficOptionCase_ = 0;
    private java.lang.Object trafficOption_;

    public TrafficOptionCase getTrafficOptionCase() {
      return TrafficOptionCase.forNumber(trafficOptionCase_);
    }

    public Builder clearTrafficOption() {
      trafficOptionCase_ = 0;
      trafficOption_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private int commuteMethod_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The method of transportation to calculate the commute time for.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.CommuteMethod commute_method = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for commuteMethod.
     */
    @java.lang.Override
    public int getCommuteMethodValue() {
      return commuteMethod_;
    }
    /**
     *
     *
     * <pre>
     * Required. The method of transportation to calculate the commute time for.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.CommuteMethod commute_method = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for commuteMethod to set.
     * @return This builder for chaining.
     */
    public Builder setCommuteMethodValue(int value) {
      commuteMethod_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The method of transportation to calculate the commute time for.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.CommuteMethod commute_method = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The commuteMethod.
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.CommuteMethod getCommuteMethod() {
      com.google.cloud.talent.v4.CommuteMethod result =
          com.google.cloud.talent.v4.CommuteMethod.forNumber(commuteMethod_);
      return result == null ? com.google.cloud.talent.v4.CommuteMethod.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Required. The method of transportation to calculate the commute time for.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.CommuteMethod commute_method = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The commuteMethod to set.
     * @return This builder for chaining.
     */
    public Builder setCommuteMethod(com.google.cloud.talent.v4.CommuteMethod value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      commuteMethod_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The method of transportation to calculate the commute time for.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.CommuteMethod commute_method = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCommuteMethod() {
      bitField0_ = (bitField0_ & ~0x00000001);
      commuteMethod_ = 0;
      onChanged();
      return this;
    }

    private com.google.type.LatLng startCoordinates_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.LatLng, com.google.type.LatLng.Builder, com.google.type.LatLngOrBuilder>
        startCoordinatesBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The latitude and longitude of the location to calculate the
     * commute time from.
     * </pre>
     *
     * <code>.google.type.LatLng start_coordinates = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the startCoordinates field is set.
     */
    public boolean hasStartCoordinates() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The latitude and longitude of the location to calculate the
     * commute time from.
     * </pre>
     *
     * <code>.google.type.LatLng start_coordinates = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The startCoordinates.
     */
    public com.google.type.LatLng getStartCoordinates() {
      if (startCoordinatesBuilder_ == null) {
        return startCoordinates_ == null
            ? com.google.type.LatLng.getDefaultInstance()
            : startCoordinates_;
      } else {
        return startCoordinatesBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The latitude and longitude of the location to calculate the
     * commute time from.
     * </pre>
     *
     * <code>.google.type.LatLng start_coordinates = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setStartCoordinates(com.google.type.LatLng value) {
      if (startCoordinatesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startCoordinates_ = value;
      } else {
        startCoordinatesBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The latitude and longitude of the location to calculate the
     * commute time from.
     * </pre>
     *
     * <code>.google.type.LatLng start_coordinates = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setStartCoordinates(com.google.type.LatLng.Builder builderForValue) {
      if (startCoordinatesBuilder_ == null) {
        startCoordinates_ = builderForValue.build();
      } else {
        startCoordinatesBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The latitude and longitude of the location to calculate the
     * commute time from.
     * </pre>
     *
     * <code>.google.type.LatLng start_coordinates = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeStartCoordinates(com.google.type.LatLng value) {
      if (startCoordinatesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && startCoordinates_ != null
            && startCoordinates_ != com.google.type.LatLng.getDefaultInstance()) {
          getStartCoordinatesBuilder().mergeFrom(value);
        } else {
          startCoordinates_ = value;
        }
      } else {
        startCoordinatesBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The latitude and longitude of the location to calculate the
     * commute time from.
     * </pre>
     *
     * <code>.google.type.LatLng start_coordinates = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearStartCoordinates() {
      bitField0_ = (bitField0_ & ~0x00000002);
      startCoordinates_ = null;
      if (startCoordinatesBuilder_ != null) {
        startCoordinatesBuilder_.dispose();
        startCoordinatesBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The latitude and longitude of the location to calculate the
     * commute time from.
     * </pre>
     *
     * <code>.google.type.LatLng start_coordinates = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.type.LatLng.Builder getStartCoordinatesBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getStartCoordinatesFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The latitude and longitude of the location to calculate the
     * commute time from.
     * </pre>
     *
     * <code>.google.type.LatLng start_coordinates = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.type.LatLngOrBuilder getStartCoordinatesOrBuilder() {
      if (startCoordinatesBuilder_ != null) {
        return startCoordinatesBuilder_.getMessageOrBuilder();
      } else {
        return startCoordinates_ == null
            ? com.google.type.LatLng.getDefaultInstance()
            : startCoordinates_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The latitude and longitude of the location to calculate the
     * commute time from.
     * </pre>
     *
     * <code>.google.type.LatLng start_coordinates = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.LatLng, com.google.type.LatLng.Builder, com.google.type.LatLngOrBuilder>
        getStartCoordinatesFieldBuilder() {
      if (startCoordinatesBuilder_ == null) {
        startCoordinatesBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.LatLng,
                com.google.type.LatLng.Builder,
                com.google.type.LatLngOrBuilder>(
                getStartCoordinates(), getParentForChildren(), isClean());
        startCoordinates_ = null;
      }
      return startCoordinatesBuilder_;
    }

    private com.google.protobuf.Duration travelDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        travelDurationBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The maximum travel time in seconds. The maximum allowed value is
     * `3600s` (one hour). Format is `123s`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration travel_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the travelDuration field is set.
     */
    public boolean hasTravelDuration() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The maximum travel time in seconds. The maximum allowed value is
     * `3600s` (one hour). Format is `123s`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration travel_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The travelDuration.
     */
    public com.google.protobuf.Duration getTravelDuration() {
      if (travelDurationBuilder_ == null) {
        return travelDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : travelDuration_;
      } else {
        return travelDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The maximum travel time in seconds. The maximum allowed value is
     * `3600s` (one hour). Format is `123s`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration travel_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTravelDuration(com.google.protobuf.Duration value) {
      if (travelDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        travelDuration_ = value;
      } else {
        travelDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The maximum travel time in seconds. The maximum allowed value is
     * `3600s` (one hour). Format is `123s`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration travel_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setTravelDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (travelDurationBuilder_ == null) {
        travelDuration_ = builderForValue.build();
      } else {
        travelDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The maximum travel time in seconds. The maximum allowed value is
     * `3600s` (one hour). Format is `123s`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration travel_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeTravelDuration(com.google.protobuf.Duration value) {
      if (travelDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && travelDuration_ != null
            && travelDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTravelDurationBuilder().mergeFrom(value);
        } else {
          travelDuration_ = value;
        }
      } else {
        travelDurationBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The maximum travel time in seconds. The maximum allowed value is
     * `3600s` (one hour). Format is `123s`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration travel_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearTravelDuration() {
      bitField0_ = (bitField0_ & ~0x00000004);
      travelDuration_ = null;
      if (travelDurationBuilder_ != null) {
        travelDurationBuilder_.dispose();
        travelDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The maximum travel time in seconds. The maximum allowed value is
     * `3600s` (one hour). Format is `123s`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration travel_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.Duration.Builder getTravelDurationBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getTravelDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The maximum travel time in seconds. The maximum allowed value is
     * `3600s` (one hour). Format is `123s`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration travel_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.DurationOrBuilder getTravelDurationOrBuilder() {
      if (travelDurationBuilder_ != null) {
        return travelDurationBuilder_.getMessageOrBuilder();
      } else {
        return travelDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : travelDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The maximum travel time in seconds. The maximum allowed value is
     * `3600s` (one hour). Format is `123s`.
     * </pre>
     *
     * <code>
     * .google.protobuf.Duration travel_duration = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTravelDurationFieldBuilder() {
      if (travelDurationBuilder_ == null) {
        travelDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTravelDuration(), getParentForChildren(), isClean());
        travelDuration_ = null;
      }
      return travelDurationBuilder_;
    }

    private boolean allowImpreciseAddresses_;
    /**
     *
     *
     * <pre>
     * If `true`, jobs without street level addresses may also be returned.
     * For city level addresses, the city center is used. For state and coarser
     * level addresses, text matching is used.
     * If this field is set to `false` or isn't specified, only jobs that include
     * street level addresses will be returned by commute search.
     * </pre>
     *
     * <code>bool allow_imprecise_addresses = 4;</code>
     *
     * @return The allowImpreciseAddresses.
     */
    @java.lang.Override
    public boolean getAllowImpreciseAddresses() {
      return allowImpreciseAddresses_;
    }
    /**
     *
     *
     * <pre>
     * If `true`, jobs without street level addresses may also be returned.
     * For city level addresses, the city center is used. For state and coarser
     * level addresses, text matching is used.
     * If this field is set to `false` or isn't specified, only jobs that include
     * street level addresses will be returned by commute search.
     * </pre>
     *
     * <code>bool allow_imprecise_addresses = 4;</code>
     *
     * @param value The allowImpreciseAddresses to set.
     * @return This builder for chaining.
     */
    public Builder setAllowImpreciseAddresses(boolean value) {

      allowImpreciseAddresses_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If `true`, jobs without street level addresses may also be returned.
     * For city level addresses, the city center is used. For state and coarser
     * level addresses, text matching is used.
     * If this field is set to `false` or isn't specified, only jobs that include
     * street level addresses will be returned by commute search.
     * </pre>
     *
     * <code>bool allow_imprecise_addresses = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowImpreciseAddresses() {
      bitField0_ = (bitField0_ & ~0x00000008);
      allowImpreciseAddresses_ = false;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the traffic density to use when calculating commute time.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CommuteFilter.RoadTraffic road_traffic = 5;</code>
     *
     * @return Whether the roadTraffic field is set.
     */
    @java.lang.Override
    public boolean hasRoadTraffic() {
      return trafficOptionCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * Specifies the traffic density to use when calculating commute time.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CommuteFilter.RoadTraffic road_traffic = 5;</code>
     *
     * @return The enum numeric value on the wire for roadTraffic.
     */
    @java.lang.Override
    public int getRoadTrafficValue() {
      if (trafficOptionCase_ == 5) {
        return ((java.lang.Integer) trafficOption_).intValue();
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * Specifies the traffic density to use when calculating commute time.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CommuteFilter.RoadTraffic road_traffic = 5;</code>
     *
     * @param value The enum numeric value on the wire for roadTraffic to set.
     * @return This builder for chaining.
     */
    public Builder setRoadTrafficValue(int value) {
      trafficOptionCase_ = 5;
      trafficOption_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the traffic density to use when calculating commute time.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CommuteFilter.RoadTraffic road_traffic = 5;</code>
     *
     * @return The roadTraffic.
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.CommuteFilter.RoadTraffic getRoadTraffic() {
      if (trafficOptionCase_ == 5) {
        com.google.cloud.talent.v4.CommuteFilter.RoadTraffic result =
            com.google.cloud.talent.v4.CommuteFilter.RoadTraffic.forNumber(
                (java.lang.Integer) trafficOption_);
        return result == null
            ? com.google.cloud.talent.v4.CommuteFilter.RoadTraffic.UNRECOGNIZED
            : result;
      }
      return com.google.cloud.talent.v4.CommuteFilter.RoadTraffic.ROAD_TRAFFIC_UNSPECIFIED;
    }
    /**
     *
     *
     * <pre>
     * Specifies the traffic density to use when calculating commute time.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CommuteFilter.RoadTraffic road_traffic = 5;</code>
     *
     * @param value The roadTraffic to set.
     * @return This builder for chaining.
     */
    public Builder setRoadTraffic(com.google.cloud.talent.v4.CommuteFilter.RoadTraffic value) {
      if (value == null) {
        throw new NullPointerException();
      }
      trafficOptionCase_ = 5;
      trafficOption_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies the traffic density to use when calculating commute time.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CommuteFilter.RoadTraffic road_traffic = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRoadTraffic() {
      if (trafficOptionCase_ == 5) {
        trafficOptionCase_ = 0;
        trafficOption_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.TimeOfDay,
            com.google.type.TimeOfDay.Builder,
            com.google.type.TimeOfDayOrBuilder>
        departureTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The departure time used to calculate traffic impact, represented as
     * [google.type.TimeOfDay][google.type.TimeOfDay] in local time zone.
     *
     * Currently traffic model is restricted to hour level resolution.
     * </pre>
     *
     * <code>.google.type.TimeOfDay departure_time = 6;</code>
     *
     * @return Whether the departureTime field is set.
     */
    @java.lang.Override
    public boolean hasDepartureTime() {
      return trafficOptionCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * The departure time used to calculate traffic impact, represented as
     * [google.type.TimeOfDay][google.type.TimeOfDay] in local time zone.
     *
     * Currently traffic model is restricted to hour level resolution.
     * </pre>
     *
     * <code>.google.type.TimeOfDay departure_time = 6;</code>
     *
     * @return The departureTime.
     */
    @java.lang.Override
    public com.google.type.TimeOfDay getDepartureTime() {
      if (departureTimeBuilder_ == null) {
        if (trafficOptionCase_ == 6) {
          return (com.google.type.TimeOfDay) trafficOption_;
        }
        return com.google.type.TimeOfDay.getDefaultInstance();
      } else {
        if (trafficOptionCase_ == 6) {
          return departureTimeBuilder_.getMessage();
        }
        return com.google.type.TimeOfDay.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The departure time used to calculate traffic impact, represented as
     * [google.type.TimeOfDay][google.type.TimeOfDay] in local time zone.
     *
     * Currently traffic model is restricted to hour level resolution.
     * </pre>
     *
     * <code>.google.type.TimeOfDay departure_time = 6;</code>
     */
    public Builder setDepartureTime(com.google.type.TimeOfDay value) {
      if (departureTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        trafficOption_ = value;
        onChanged();
      } else {
        departureTimeBuilder_.setMessage(value);
      }
      trafficOptionCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The departure time used to calculate traffic impact, represented as
     * [google.type.TimeOfDay][google.type.TimeOfDay] in local time zone.
     *
     * Currently traffic model is restricted to hour level resolution.
     * </pre>
     *
     * <code>.google.type.TimeOfDay departure_time = 6;</code>
     */
    public Builder setDepartureTime(com.google.type.TimeOfDay.Builder builderForValue) {
      if (departureTimeBuilder_ == null) {
        trafficOption_ = builderForValue.build();
        onChanged();
      } else {
        departureTimeBuilder_.setMessage(builderForValue.build());
      }
      trafficOptionCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The departure time used to calculate traffic impact, represented as
     * [google.type.TimeOfDay][google.type.TimeOfDay] in local time zone.
     *
     * Currently traffic model is restricted to hour level resolution.
     * </pre>
     *
     * <code>.google.type.TimeOfDay departure_time = 6;</code>
     */
    public Builder mergeDepartureTime(com.google.type.TimeOfDay value) {
      if (departureTimeBuilder_ == null) {
        if (trafficOptionCase_ == 6
            && trafficOption_ != com.google.type.TimeOfDay.getDefaultInstance()) {
          trafficOption_ =
              com.google.type.TimeOfDay.newBuilder((com.google.type.TimeOfDay) trafficOption_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          trafficOption_ = value;
        }
        onChanged();
      } else {
        if (trafficOptionCase_ == 6) {
          departureTimeBuilder_.mergeFrom(value);
        } else {
          departureTimeBuilder_.setMessage(value);
        }
      }
      trafficOptionCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The departure time used to calculate traffic impact, represented as
     * [google.type.TimeOfDay][google.type.TimeOfDay] in local time zone.
     *
     * Currently traffic model is restricted to hour level resolution.
     * </pre>
     *
     * <code>.google.type.TimeOfDay departure_time = 6;</code>
     */
    public Builder clearDepartureTime() {
      if (departureTimeBuilder_ == null) {
        if (trafficOptionCase_ == 6) {
          trafficOptionCase_ = 0;
          trafficOption_ = null;
          onChanged();
        }
      } else {
        if (trafficOptionCase_ == 6) {
          trafficOptionCase_ = 0;
          trafficOption_ = null;
        }
        departureTimeBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The departure time used to calculate traffic impact, represented as
     * [google.type.TimeOfDay][google.type.TimeOfDay] in local time zone.
     *
     * Currently traffic model is restricted to hour level resolution.
     * </pre>
     *
     * <code>.google.type.TimeOfDay departure_time = 6;</code>
     */
    public com.google.type.TimeOfDay.Builder getDepartureTimeBuilder() {
      return getDepartureTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The departure time used to calculate traffic impact, represented as
     * [google.type.TimeOfDay][google.type.TimeOfDay] in local time zone.
     *
     * Currently traffic model is restricted to hour level resolution.
     * </pre>
     *
     * <code>.google.type.TimeOfDay departure_time = 6;</code>
     */
    @java.lang.Override
    public com.google.type.TimeOfDayOrBuilder getDepartureTimeOrBuilder() {
      if ((trafficOptionCase_ == 6) && (departureTimeBuilder_ != null)) {
        return departureTimeBuilder_.getMessageOrBuilder();
      } else {
        if (trafficOptionCase_ == 6) {
          return (com.google.type.TimeOfDay) trafficOption_;
        }
        return com.google.type.TimeOfDay.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The departure time used to calculate traffic impact, represented as
     * [google.type.TimeOfDay][google.type.TimeOfDay] in local time zone.
     *
     * Currently traffic model is restricted to hour level resolution.
     * </pre>
     *
     * <code>.google.type.TimeOfDay departure_time = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.TimeOfDay,
            com.google.type.TimeOfDay.Builder,
            com.google.type.TimeOfDayOrBuilder>
        getDepartureTimeFieldBuilder() {
      if (departureTimeBuilder_ == null) {
        if (!(trafficOptionCase_ == 6)) {
          trafficOption_ = com.google.type.TimeOfDay.getDefaultInstance();
        }
        departureTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.TimeOfDay,
                com.google.type.TimeOfDay.Builder,
                com.google.type.TimeOfDayOrBuilder>(
                (com.google.type.TimeOfDay) trafficOption_, getParentForChildren(), isClean());
        trafficOption_ = null;
      }
      trafficOptionCase_ = 6;
      onChanged();
      return departureTimeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.talent.v4.CommuteFilter)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.talent.v4.CommuteFilter)
  private static final com.google.cloud.talent.v4.CommuteFilter DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.talent.v4.CommuteFilter();
  }

  public static com.google.cloud.talent.v4.CommuteFilter getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CommuteFilter> PARSER =
      new com.google.protobuf.AbstractParser<CommuteFilter>() {
        @java.lang.Override
        public CommuteFilter parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CommuteFilter> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CommuteFilter> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.talent.v4.CommuteFilter getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
