/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/talent/v4/company.proto

package com.google.cloud.talent.v4;

/**
 *
 *
 * <pre>
 * A Company resource represents a company in the service. A company is the
 * entity that owns job postings, that is, the hiring entity responsible for
 * employing applicants for the job position.
 * </pre>
 *
 * Protobuf type {@code google.cloud.talent.v4.Company}
 */
public final class Company extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.talent.v4.Company)
    CompanyOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Company.newBuilder() to construct.
  private Company(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Company() {
    name_ = "";
    displayName_ = "";
    externalId_ = "";
    size_ = 0;
    headquartersAddress_ = "";
    eeoText_ = "";
    websiteUri_ = "";
    careerSiteUri_ = "";
    imageUri_ = "";
    keywordSearchableJobCustomAttributes_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Company();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.talent.v4.CompanyProto
        .internal_static_google_cloud_talent_v4_Company_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.talent.v4.CompanyProto
        .internal_static_google_cloud_talent_v4_Company_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.talent.v4.Company.class,
            com.google.cloud.talent.v4.Company.Builder.class);
  }

  public interface DerivedInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.talent.v4.Company.DerivedInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A structured headquarters location of the company, resolved from
     * [Company.headquarters_address][google.cloud.talent.v4.Company.headquarters_address]
     * if provided.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Location headquarters_location = 1;</code>
     *
     * @return Whether the headquartersLocation field is set.
     */
    boolean hasHeadquartersLocation();
    /**
     *
     *
     * <pre>
     * A structured headquarters location of the company, resolved from
     * [Company.headquarters_address][google.cloud.talent.v4.Company.headquarters_address]
     * if provided.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Location headquarters_location = 1;</code>
     *
     * @return The headquartersLocation.
     */
    com.google.cloud.talent.v4.Location getHeadquartersLocation();
    /**
     *
     *
     * <pre>
     * A structured headquarters location of the company, resolved from
     * [Company.headquarters_address][google.cloud.talent.v4.Company.headquarters_address]
     * if provided.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Location headquarters_location = 1;</code>
     */
    com.google.cloud.talent.v4.LocationOrBuilder getHeadquartersLocationOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Derived details about the company.
   * </pre>
   *
   * Protobuf type {@code google.cloud.talent.v4.Company.DerivedInfo}
   */
  public static final class DerivedInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.talent.v4.Company.DerivedInfo)
      DerivedInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DerivedInfo.newBuilder() to construct.
    private DerivedInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DerivedInfo() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DerivedInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.talent.v4.CompanyProto
          .internal_static_google_cloud_talent_v4_Company_DerivedInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.talent.v4.CompanyProto
          .internal_static_google_cloud_talent_v4_Company_DerivedInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.talent.v4.Company.DerivedInfo.class,
              com.google.cloud.talent.v4.Company.DerivedInfo.Builder.class);
    }

    public static final int HEADQUARTERS_LOCATION_FIELD_NUMBER = 1;
    private com.google.cloud.talent.v4.Location headquartersLocation_;
    /**
     *
     *
     * <pre>
     * A structured headquarters location of the company, resolved from
     * [Company.headquarters_address][google.cloud.talent.v4.Company.headquarters_address]
     * if provided.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Location headquarters_location = 1;</code>
     *
     * @return Whether the headquartersLocation field is set.
     */
    @java.lang.Override
    public boolean hasHeadquartersLocation() {
      return headquartersLocation_ != null;
    }
    /**
     *
     *
     * <pre>
     * A structured headquarters location of the company, resolved from
     * [Company.headquarters_address][google.cloud.talent.v4.Company.headquarters_address]
     * if provided.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Location headquarters_location = 1;</code>
     *
     * @return The headquartersLocation.
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.Location getHeadquartersLocation() {
      return headquartersLocation_ == null
          ? com.google.cloud.talent.v4.Location.getDefaultInstance()
          : headquartersLocation_;
    }
    /**
     *
     *
     * <pre>
     * A structured headquarters location of the company, resolved from
     * [Company.headquarters_address][google.cloud.talent.v4.Company.headquarters_address]
     * if provided.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Location headquarters_location = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.LocationOrBuilder getHeadquartersLocationOrBuilder() {
      return headquartersLocation_ == null
          ? com.google.cloud.talent.v4.Location.getDefaultInstance()
          : headquartersLocation_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (headquartersLocation_ != null) {
        output.writeMessage(1, getHeadquartersLocation());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (headquartersLocation_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(1, getHeadquartersLocation());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.talent.v4.Company.DerivedInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.talent.v4.Company.DerivedInfo other =
          (com.google.cloud.talent.v4.Company.DerivedInfo) obj;

      if (hasHeadquartersLocation() != other.hasHeadquartersLocation()) return false;
      if (hasHeadquartersLocation()) {
        if (!getHeadquartersLocation().equals(other.getHeadquartersLocation())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasHeadquartersLocation()) {
        hash = (37 * hash) + HEADQUARTERS_LOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getHeadquartersLocation().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.talent.v4.Company.DerivedInfo parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.Company.DerivedInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.Company.DerivedInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.Company.DerivedInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.Company.DerivedInfo parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.Company.DerivedInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.Company.DerivedInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.Company.DerivedInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.Company.DerivedInfo parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.Company.DerivedInfo parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.Company.DerivedInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.Company.DerivedInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.talent.v4.Company.DerivedInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Derived details about the company.
     * </pre>
     *
     * Protobuf type {@code google.cloud.talent.v4.Company.DerivedInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.talent.v4.Company.DerivedInfo)
        com.google.cloud.talent.v4.Company.DerivedInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.talent.v4.CompanyProto
            .internal_static_google_cloud_talent_v4_Company_DerivedInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.talent.v4.CompanyProto
            .internal_static_google_cloud_talent_v4_Company_DerivedInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.talent.v4.Company.DerivedInfo.class,
                com.google.cloud.talent.v4.Company.DerivedInfo.Builder.class);
      }

      // Construct using com.google.cloud.talent.v4.Company.DerivedInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        headquartersLocation_ = null;
        if (headquartersLocationBuilder_ != null) {
          headquartersLocationBuilder_.dispose();
          headquartersLocationBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.talent.v4.CompanyProto
            .internal_static_google_cloud_talent_v4_Company_DerivedInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.Company.DerivedInfo getDefaultInstanceForType() {
        return com.google.cloud.talent.v4.Company.DerivedInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.Company.DerivedInfo build() {
        com.google.cloud.talent.v4.Company.DerivedInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.Company.DerivedInfo buildPartial() {
        com.google.cloud.talent.v4.Company.DerivedInfo result =
            new com.google.cloud.talent.v4.Company.DerivedInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.talent.v4.Company.DerivedInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.headquartersLocation_ =
              headquartersLocationBuilder_ == null
                  ? headquartersLocation_
                  : headquartersLocationBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.talent.v4.Company.DerivedInfo) {
          return mergeFrom((com.google.cloud.talent.v4.Company.DerivedInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.talent.v4.Company.DerivedInfo other) {
        if (other == com.google.cloud.talent.v4.Company.DerivedInfo.getDefaultInstance())
          return this;
        if (other.hasHeadquartersLocation()) {
          mergeHeadquartersLocation(other.getHeadquartersLocation());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getHeadquartersLocationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.talent.v4.Location headquartersLocation_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.talent.v4.Location,
              com.google.cloud.talent.v4.Location.Builder,
              com.google.cloud.talent.v4.LocationOrBuilder>
          headquartersLocationBuilder_;
      /**
       *
       *
       * <pre>
       * A structured headquarters location of the company, resolved from
       * [Company.headquarters_address][google.cloud.talent.v4.Company.headquarters_address]
       * if provided.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Location headquarters_location = 1;</code>
       *
       * @return Whether the headquartersLocation field is set.
       */
      public boolean hasHeadquartersLocation() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * A structured headquarters location of the company, resolved from
       * [Company.headquarters_address][google.cloud.talent.v4.Company.headquarters_address]
       * if provided.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Location headquarters_location = 1;</code>
       *
       * @return The headquartersLocation.
       */
      public com.google.cloud.talent.v4.Location getHeadquartersLocation() {
        if (headquartersLocationBuilder_ == null) {
          return headquartersLocation_ == null
              ? com.google.cloud.talent.v4.Location.getDefaultInstance()
              : headquartersLocation_;
        } else {
          return headquartersLocationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * A structured headquarters location of the company, resolved from
       * [Company.headquarters_address][google.cloud.talent.v4.Company.headquarters_address]
       * if provided.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Location headquarters_location = 1;</code>
       */
      public Builder setHeadquartersLocation(com.google.cloud.talent.v4.Location value) {
        if (headquartersLocationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          headquartersLocation_ = value;
        } else {
          headquartersLocationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A structured headquarters location of the company, resolved from
       * [Company.headquarters_address][google.cloud.talent.v4.Company.headquarters_address]
       * if provided.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Location headquarters_location = 1;</code>
       */
      public Builder setHeadquartersLocation(
          com.google.cloud.talent.v4.Location.Builder builderForValue) {
        if (headquartersLocationBuilder_ == null) {
          headquartersLocation_ = builderForValue.build();
        } else {
          headquartersLocationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A structured headquarters location of the company, resolved from
       * [Company.headquarters_address][google.cloud.talent.v4.Company.headquarters_address]
       * if provided.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Location headquarters_location = 1;</code>
       */
      public Builder mergeHeadquartersLocation(com.google.cloud.talent.v4.Location value) {
        if (headquartersLocationBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && headquartersLocation_ != null
              && headquartersLocation_
                  != com.google.cloud.talent.v4.Location.getDefaultInstance()) {
            getHeadquartersLocationBuilder().mergeFrom(value);
          } else {
            headquartersLocation_ = value;
          }
        } else {
          headquartersLocationBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A structured headquarters location of the company, resolved from
       * [Company.headquarters_address][google.cloud.talent.v4.Company.headquarters_address]
       * if provided.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Location headquarters_location = 1;</code>
       */
      public Builder clearHeadquartersLocation() {
        bitField0_ = (bitField0_ & ~0x00000001);
        headquartersLocation_ = null;
        if (headquartersLocationBuilder_ != null) {
          headquartersLocationBuilder_.dispose();
          headquartersLocationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A structured headquarters location of the company, resolved from
       * [Company.headquarters_address][google.cloud.talent.v4.Company.headquarters_address]
       * if provided.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Location headquarters_location = 1;</code>
       */
      public com.google.cloud.talent.v4.Location.Builder getHeadquartersLocationBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getHeadquartersLocationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * A structured headquarters location of the company, resolved from
       * [Company.headquarters_address][google.cloud.talent.v4.Company.headquarters_address]
       * if provided.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Location headquarters_location = 1;</code>
       */
      public com.google.cloud.talent.v4.LocationOrBuilder getHeadquartersLocationOrBuilder() {
        if (headquartersLocationBuilder_ != null) {
          return headquartersLocationBuilder_.getMessageOrBuilder();
        } else {
          return headquartersLocation_ == null
              ? com.google.cloud.talent.v4.Location.getDefaultInstance()
              : headquartersLocation_;
        }
      }
      /**
       *
       *
       * <pre>
       * A structured headquarters location of the company, resolved from
       * [Company.headquarters_address][google.cloud.talent.v4.Company.headquarters_address]
       * if provided.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Location headquarters_location = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.talent.v4.Location,
              com.google.cloud.talent.v4.Location.Builder,
              com.google.cloud.talent.v4.LocationOrBuilder>
          getHeadquartersLocationFieldBuilder() {
        if (headquartersLocationBuilder_ == null) {
          headquartersLocationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.talent.v4.Location,
                  com.google.cloud.talent.v4.Location.Builder,
                  com.google.cloud.talent.v4.LocationOrBuilder>(
                  getHeadquartersLocation(), getParentForChildren(), isClean());
          headquartersLocation_ = null;
        }
        return headquartersLocationBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.talent.v4.Company.DerivedInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.talent.v4.Company.DerivedInfo)
    private static final com.google.cloud.talent.v4.Company.DerivedInfo DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.talent.v4.Company.DerivedInfo();
    }

    public static com.google.cloud.talent.v4.Company.DerivedInfo getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DerivedInfo> PARSER =
        new com.google.protobuf.AbstractParser<DerivedInfo>() {
          @java.lang.Override
          public DerivedInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DerivedInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DerivedInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.Company.DerivedInfo getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required during company update.
   *
   * The resource name for a company. This is generated by the service when a
   * company is created.
   *
   * The format is
   * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}", for
   * example, "projects/foo/tenants/bar/companies/baz".
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required during company update.
   *
   * The resource name for a company. This is generated by the service when a
   * company is created.
   *
   * The format is
   * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}", for
   * example, "projects/foo/tenants/bar/companies/baz".
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Required. The display name of the company, for example, "Google LLC".
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The display name of the company, for example, "Google LLC".
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXTERNAL_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object externalId_ = "";
  /**
   *
   *
   * <pre>
   * Required. Client side company identifier, used to uniquely identify the
   * company.
   *
   * The maximum number of allowed characters is 255.
   * </pre>
   *
   * <code>string external_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The externalId.
   */
  @java.lang.Override
  public java.lang.String getExternalId() {
    java.lang.Object ref = externalId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      externalId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Client side company identifier, used to uniquely identify the
   * company.
   *
   * The maximum number of allowed characters is 255.
   * </pre>
   *
   * <code>string external_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for externalId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getExternalIdBytes() {
    java.lang.Object ref = externalId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      externalId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SIZE_FIELD_NUMBER = 4;
  private int size_ = 0;
  /**
   *
   *
   * <pre>
   * The employer's company size.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.CompanySize size = 4;</code>
   *
   * @return The enum numeric value on the wire for size.
   */
  @java.lang.Override
  public int getSizeValue() {
    return size_;
  }
  /**
   *
   *
   * <pre>
   * The employer's company size.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.CompanySize size = 4;</code>
   *
   * @return The size.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.CompanySize getSize() {
    com.google.cloud.talent.v4.CompanySize result =
        com.google.cloud.talent.v4.CompanySize.forNumber(size_);
    return result == null ? com.google.cloud.talent.v4.CompanySize.UNRECOGNIZED : result;
  }

  public static final int HEADQUARTERS_ADDRESS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object headquartersAddress_ = "";
  /**
   *
   *
   * <pre>
   * The street address of the company's main headquarters, which may be
   * different from the job location. The service attempts
   * to geolocate the provided address, and populates a more specific
   * location wherever possible in
   * [DerivedInfo.headquarters_location][google.cloud.talent.v4.Company.DerivedInfo.headquarters_location].
   * </pre>
   *
   * <code>string headquarters_address = 5;</code>
   *
   * @return The headquartersAddress.
   */
  @java.lang.Override
  public java.lang.String getHeadquartersAddress() {
    java.lang.Object ref = headquartersAddress_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      headquartersAddress_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The street address of the company's main headquarters, which may be
   * different from the job location. The service attempts
   * to geolocate the provided address, and populates a more specific
   * location wherever possible in
   * [DerivedInfo.headquarters_location][google.cloud.talent.v4.Company.DerivedInfo.headquarters_location].
   * </pre>
   *
   * <code>string headquarters_address = 5;</code>
   *
   * @return The bytes for headquartersAddress.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHeadquartersAddressBytes() {
    java.lang.Object ref = headquartersAddress_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      headquartersAddress_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HIRING_AGENCY_FIELD_NUMBER = 6;
  private boolean hiringAgency_ = false;
  /**
   *
   *
   * <pre>
   * Set to true if it is the hiring agency that post jobs for other
   * employers.
   *
   * Defaults to false if not provided.
   * </pre>
   *
   * <code>bool hiring_agency = 6;</code>
   *
   * @return The hiringAgency.
   */
  @java.lang.Override
  public boolean getHiringAgency() {
    return hiringAgency_;
  }

  public static final int EEO_TEXT_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object eeoText_ = "";
  /**
   *
   *
   * <pre>
   * Equal Employment Opportunity legal disclaimer text to be
   * associated with all jobs, and typically to be displayed in all
   * roles.
   *
   * The maximum number of allowed characters is 500.
   * </pre>
   *
   * <code>string eeo_text = 7;</code>
   *
   * @return The eeoText.
   */
  @java.lang.Override
  public java.lang.String getEeoText() {
    java.lang.Object ref = eeoText_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      eeoText_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Equal Employment Opportunity legal disclaimer text to be
   * associated with all jobs, and typically to be displayed in all
   * roles.
   *
   * The maximum number of allowed characters is 500.
   * </pre>
   *
   * <code>string eeo_text = 7;</code>
   *
   * @return The bytes for eeoText.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEeoTextBytes() {
    java.lang.Object ref = eeoText_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      eeoText_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int WEBSITE_URI_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object websiteUri_ = "";
  /**
   *
   *
   * <pre>
   * The URI representing the company's primary web site or home page,
   * for example, "https://www.google.com".
   *
   * The maximum number of allowed characters is 255.
   * </pre>
   *
   * <code>string website_uri = 8;</code>
   *
   * @return The websiteUri.
   */
  @java.lang.Override
  public java.lang.String getWebsiteUri() {
    java.lang.Object ref = websiteUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      websiteUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URI representing the company's primary web site or home page,
   * for example, "https://www.google.com".
   *
   * The maximum number of allowed characters is 255.
   * </pre>
   *
   * <code>string website_uri = 8;</code>
   *
   * @return The bytes for websiteUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getWebsiteUriBytes() {
    java.lang.Object ref = websiteUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      websiteUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CAREER_SITE_URI_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object careerSiteUri_ = "";
  /**
   *
   *
   * <pre>
   * The URI to employer's career site or careers page on the employer's web
   * site, for example, "https://careers.google.com".
   * </pre>
   *
   * <code>string career_site_uri = 9;</code>
   *
   * @return The careerSiteUri.
   */
  @java.lang.Override
  public java.lang.String getCareerSiteUri() {
    java.lang.Object ref = careerSiteUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      careerSiteUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The URI to employer's career site or careers page on the employer's web
   * site, for example, "https://careers.google.com".
   * </pre>
   *
   * <code>string career_site_uri = 9;</code>
   *
   * @return The bytes for careerSiteUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCareerSiteUriBytes() {
    java.lang.Object ref = careerSiteUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      careerSiteUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IMAGE_URI_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object imageUri_ = "";
  /**
   *
   *
   * <pre>
   * A URI that hosts the employer's company logo.
   * </pre>
   *
   * <code>string image_uri = 10;</code>
   *
   * @return The imageUri.
   */
  @java.lang.Override
  public java.lang.String getImageUri() {
    java.lang.Object ref = imageUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      imageUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A URI that hosts the employer's company logo.
   * </pre>
   *
   * <code>string image_uri = 10;</code>
   *
   * @return The bytes for imageUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getImageUriBytes() {
    java.lang.Object ref = imageUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      imageUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int KEYWORD_SEARCHABLE_JOB_CUSTOM_ATTRIBUTES_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList keywordSearchableJobCustomAttributes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * This field is deprecated. Please set the searchability of the custom
   * attribute in the
   * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes] going
   * forward.
   *
   * A list of keys of filterable
   * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes],
   * whose corresponding `string_values` are used in keyword searches. Jobs with
   * `string_values` under these specified field keys are returned if any
   * of the values match the search keyword. Custom field values with
   * parenthesis, brackets and special symbols are not searchable as-is,
   * and those keyword queries must be surrounded by quotes.
   * </pre>
   *
   * <code>repeated string keyword_searchable_job_custom_attributes = 11 [deprecated = true];</code>
   *
   * @deprecated google.cloud.talent.v4.Company.keyword_searchable_job_custom_attributes is
   *     deprecated. See google/cloud/talent/v4/company.proto;l=112
   * @return A list containing the keywordSearchableJobCustomAttributes.
   */
  @java.lang.Deprecated
  public com.google.protobuf.ProtocolStringList getKeywordSearchableJobCustomAttributesList() {
    return keywordSearchableJobCustomAttributes_;
  }
  /**
   *
   *
   * <pre>
   * This field is deprecated. Please set the searchability of the custom
   * attribute in the
   * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes] going
   * forward.
   *
   * A list of keys of filterable
   * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes],
   * whose corresponding `string_values` are used in keyword searches. Jobs with
   * `string_values` under these specified field keys are returned if any
   * of the values match the search keyword. Custom field values with
   * parenthesis, brackets and special symbols are not searchable as-is,
   * and those keyword queries must be surrounded by quotes.
   * </pre>
   *
   * <code>repeated string keyword_searchable_job_custom_attributes = 11 [deprecated = true];</code>
   *
   * @deprecated google.cloud.talent.v4.Company.keyword_searchable_job_custom_attributes is
   *     deprecated. See google/cloud/talent/v4/company.proto;l=112
   * @return The count of keywordSearchableJobCustomAttributes.
   */
  @java.lang.Deprecated
  public int getKeywordSearchableJobCustomAttributesCount() {
    return keywordSearchableJobCustomAttributes_.size();
  }
  /**
   *
   *
   * <pre>
   * This field is deprecated. Please set the searchability of the custom
   * attribute in the
   * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes] going
   * forward.
   *
   * A list of keys of filterable
   * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes],
   * whose corresponding `string_values` are used in keyword searches. Jobs with
   * `string_values` under these specified field keys are returned if any
   * of the values match the search keyword. Custom field values with
   * parenthesis, brackets and special symbols are not searchable as-is,
   * and those keyword queries must be surrounded by quotes.
   * </pre>
   *
   * <code>repeated string keyword_searchable_job_custom_attributes = 11 [deprecated = true];</code>
   *
   * @deprecated google.cloud.talent.v4.Company.keyword_searchable_job_custom_attributes is
   *     deprecated. See google/cloud/talent/v4/company.proto;l=112
   * @param index The index of the element to return.
   * @return The keywordSearchableJobCustomAttributes at the given index.
   */
  @java.lang.Deprecated
  public java.lang.String getKeywordSearchableJobCustomAttributes(int index) {
    return keywordSearchableJobCustomAttributes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * This field is deprecated. Please set the searchability of the custom
   * attribute in the
   * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes] going
   * forward.
   *
   * A list of keys of filterable
   * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes],
   * whose corresponding `string_values` are used in keyword searches. Jobs with
   * `string_values` under these specified field keys are returned if any
   * of the values match the search keyword. Custom field values with
   * parenthesis, brackets and special symbols are not searchable as-is,
   * and those keyword queries must be surrounded by quotes.
   * </pre>
   *
   * <code>repeated string keyword_searchable_job_custom_attributes = 11 [deprecated = true];</code>
   *
   * @deprecated google.cloud.talent.v4.Company.keyword_searchable_job_custom_attributes is
   *     deprecated. See google/cloud/talent/v4/company.proto;l=112
   * @param index The index of the value to return.
   * @return The bytes of the keywordSearchableJobCustomAttributes at the given index.
   */
  @java.lang.Deprecated
  public com.google.protobuf.ByteString getKeywordSearchableJobCustomAttributesBytes(int index) {
    return keywordSearchableJobCustomAttributes_.getByteString(index);
  }

  public static final int DERIVED_INFO_FIELD_NUMBER = 12;
  private com.google.cloud.talent.v4.Company.DerivedInfo derivedInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Derived details about the company.
   * </pre>
   *
   * <code>
   * .google.cloud.talent.v4.Company.DerivedInfo derived_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the derivedInfo field is set.
   */
  @java.lang.Override
  public boolean hasDerivedInfo() {
    return derivedInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Derived details about the company.
   * </pre>
   *
   * <code>
   * .google.cloud.talent.v4.Company.DerivedInfo derived_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The derivedInfo.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.Company.DerivedInfo getDerivedInfo() {
    return derivedInfo_ == null
        ? com.google.cloud.talent.v4.Company.DerivedInfo.getDefaultInstance()
        : derivedInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Derived details about the company.
   * </pre>
   *
   * <code>
   * .google.cloud.talent.v4.Company.DerivedInfo derived_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.Company.DerivedInfoOrBuilder getDerivedInfoOrBuilder() {
    return derivedInfo_ == null
        ? com.google.cloud.talent.v4.Company.DerivedInfo.getDefaultInstance()
        : derivedInfo_;
  }

  public static final int SUSPENDED_FIELD_NUMBER = 13;
  private boolean suspended_ = false;
  /**
   *
   *
   * <pre>
   * Output only. Indicates whether a company is flagged to be suspended from
   * public availability by the service when job content appears suspicious,
   * abusive, or spammy.
   * </pre>
   *
   * <code>bool suspended = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The suspended.
   */
  @java.lang.Override
  public boolean getSuspended() {
    return suspended_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(externalId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, externalId_);
    }
    if (size_ != com.google.cloud.talent.v4.CompanySize.COMPANY_SIZE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, size_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(headquartersAddress_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, headquartersAddress_);
    }
    if (hiringAgency_ != false) {
      output.writeBool(6, hiringAgency_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(eeoText_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, eeoText_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(websiteUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, websiteUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(careerSiteUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, careerSiteUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, imageUri_);
    }
    for (int i = 0; i < keywordSearchableJobCustomAttributes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(
          output, 11, keywordSearchableJobCustomAttributes_.getRaw(i));
    }
    if (derivedInfo_ != null) {
      output.writeMessage(12, getDerivedInfo());
    }
    if (suspended_ != false) {
      output.writeBool(13, suspended_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(externalId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, externalId_);
    }
    if (size_ != com.google.cloud.talent.v4.CompanySize.COMPANY_SIZE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, size_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(headquartersAddress_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, headquartersAddress_);
    }
    if (hiringAgency_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, hiringAgency_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(eeoText_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, eeoText_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(websiteUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, websiteUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(careerSiteUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, careerSiteUri_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, imageUri_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < keywordSearchableJobCustomAttributes_.size(); i++) {
        dataSize += computeStringSizeNoTag(keywordSearchableJobCustomAttributes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getKeywordSearchableJobCustomAttributesList().size();
    }
    if (derivedInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getDerivedInfo());
    }
    if (suspended_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, suspended_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.talent.v4.Company)) {
      return super.equals(obj);
    }
    com.google.cloud.talent.v4.Company other = (com.google.cloud.talent.v4.Company) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getExternalId().equals(other.getExternalId())) return false;
    if (size_ != other.size_) return false;
    if (!getHeadquartersAddress().equals(other.getHeadquartersAddress())) return false;
    if (getHiringAgency() != other.getHiringAgency()) return false;
    if (!getEeoText().equals(other.getEeoText())) return false;
    if (!getWebsiteUri().equals(other.getWebsiteUri())) return false;
    if (!getCareerSiteUri().equals(other.getCareerSiteUri())) return false;
    if (!getImageUri().equals(other.getImageUri())) return false;
    if (!getKeywordSearchableJobCustomAttributesList()
        .equals(other.getKeywordSearchableJobCustomAttributesList())) return false;
    if (hasDerivedInfo() != other.hasDerivedInfo()) return false;
    if (hasDerivedInfo()) {
      if (!getDerivedInfo().equals(other.getDerivedInfo())) return false;
    }
    if (getSuspended() != other.getSuspended()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + EXTERNAL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getExternalId().hashCode();
    hash = (37 * hash) + SIZE_FIELD_NUMBER;
    hash = (53 * hash) + size_;
    hash = (37 * hash) + HEADQUARTERS_ADDRESS_FIELD_NUMBER;
    hash = (53 * hash) + getHeadquartersAddress().hashCode();
    hash = (37 * hash) + HIRING_AGENCY_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getHiringAgency());
    hash = (37 * hash) + EEO_TEXT_FIELD_NUMBER;
    hash = (53 * hash) + getEeoText().hashCode();
    hash = (37 * hash) + WEBSITE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getWebsiteUri().hashCode();
    hash = (37 * hash) + CAREER_SITE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getCareerSiteUri().hashCode();
    hash = (37 * hash) + IMAGE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getImageUri().hashCode();
    if (getKeywordSearchableJobCustomAttributesCount() > 0) {
      hash = (37 * hash) + KEYWORD_SEARCHABLE_JOB_CUSTOM_ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + getKeywordSearchableJobCustomAttributesList().hashCode();
    }
    if (hasDerivedInfo()) {
      hash = (37 * hash) + DERIVED_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getDerivedInfo().hashCode();
    }
    hash = (37 * hash) + SUSPENDED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSuspended());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.talent.v4.Company parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.Company parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.Company parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.Company parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.Company parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.Company parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.Company parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.Company parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.Company parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.Company parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.Company parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.Company parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.talent.v4.Company prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Company resource represents a company in the service. A company is the
   * entity that owns job postings, that is, the hiring entity responsible for
   * employing applicants for the job position.
   * </pre>
   *
   * Protobuf type {@code google.cloud.talent.v4.Company}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.talent.v4.Company)
      com.google.cloud.talent.v4.CompanyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.talent.v4.CompanyProto
          .internal_static_google_cloud_talent_v4_Company_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.talent.v4.CompanyProto
          .internal_static_google_cloud_talent_v4_Company_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.talent.v4.Company.class,
              com.google.cloud.talent.v4.Company.Builder.class);
    }

    // Construct using com.google.cloud.talent.v4.Company.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      externalId_ = "";
      size_ = 0;
      headquartersAddress_ = "";
      hiringAgency_ = false;
      eeoText_ = "";
      websiteUri_ = "";
      careerSiteUri_ = "";
      imageUri_ = "";
      keywordSearchableJobCustomAttributes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      derivedInfo_ = null;
      if (derivedInfoBuilder_ != null) {
        derivedInfoBuilder_.dispose();
        derivedInfoBuilder_ = null;
      }
      suspended_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.talent.v4.CompanyProto
          .internal_static_google_cloud_talent_v4_Company_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.Company getDefaultInstanceForType() {
      return com.google.cloud.talent.v4.Company.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.Company build() {
      com.google.cloud.talent.v4.Company result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.Company buildPartial() {
      com.google.cloud.talent.v4.Company result = new com.google.cloud.talent.v4.Company(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.talent.v4.Company result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.externalId_ = externalId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.size_ = size_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.headquartersAddress_ = headquartersAddress_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.hiringAgency_ = hiringAgency_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.eeoText_ = eeoText_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.websiteUri_ = websiteUri_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.careerSiteUri_ = careerSiteUri_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.imageUri_ = imageUri_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        keywordSearchableJobCustomAttributes_.makeImmutable();
        result.keywordSearchableJobCustomAttributes_ = keywordSearchableJobCustomAttributes_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.derivedInfo_ =
            derivedInfoBuilder_ == null ? derivedInfo_ : derivedInfoBuilder_.build();
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.suspended_ = suspended_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.talent.v4.Company) {
        return mergeFrom((com.google.cloud.talent.v4.Company) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.talent.v4.Company other) {
      if (other == com.google.cloud.talent.v4.Company.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getExternalId().isEmpty()) {
        externalId_ = other.externalId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.size_ != 0) {
        setSizeValue(other.getSizeValue());
      }
      if (!other.getHeadquartersAddress().isEmpty()) {
        headquartersAddress_ = other.headquartersAddress_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getHiringAgency() != false) {
        setHiringAgency(other.getHiringAgency());
      }
      if (!other.getEeoText().isEmpty()) {
        eeoText_ = other.eeoText_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.getWebsiteUri().isEmpty()) {
        websiteUri_ = other.websiteUri_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (!other.getCareerSiteUri().isEmpty()) {
        careerSiteUri_ = other.careerSiteUri_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (!other.getImageUri().isEmpty()) {
        imageUri_ = other.imageUri_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.keywordSearchableJobCustomAttributes_.isEmpty()) {
        if (keywordSearchableJobCustomAttributes_.isEmpty()) {
          keywordSearchableJobCustomAttributes_ = other.keywordSearchableJobCustomAttributes_;
          bitField0_ |= 0x00000400;
        } else {
          ensureKeywordSearchableJobCustomAttributesIsMutable();
          keywordSearchableJobCustomAttributes_.addAll(other.keywordSearchableJobCustomAttributes_);
        }
        onChanged();
      }
      if (other.hasDerivedInfo()) {
        mergeDerivedInfo(other.getDerivedInfo());
      }
      if (other.getSuspended() != false) {
        setSuspended(other.getSuspended());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                externalId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                size_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                headquartersAddress_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                hiringAgency_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                eeoText_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                websiteUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                careerSiteUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                imageUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureKeywordSearchableJobCustomAttributesIsMutable();
                keywordSearchableJobCustomAttributes_.add(s);
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getDerivedInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 104:
              {
                suspended_ = input.readBool();
                bitField0_ |= 0x00001000;
                break;
              } // case 104
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required during company update.
     *
     * The resource name for a company. This is generated by the service when a
     * company is created.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}", for
     * example, "projects/foo/tenants/bar/companies/baz".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required during company update.
     *
     * The resource name for a company. This is generated by the service when a
     * company is created.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}", for
     * example, "projects/foo/tenants/bar/companies/baz".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required during company update.
     *
     * The resource name for a company. This is generated by the service when a
     * company is created.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}", for
     * example, "projects/foo/tenants/bar/companies/baz".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required during company update.
     *
     * The resource name for a company. This is generated by the service when a
     * company is created.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}", for
     * example, "projects/foo/tenants/bar/companies/baz".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required during company update.
     *
     * The resource name for a company. This is generated by the service when a
     * company is created.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}", for
     * example, "projects/foo/tenants/bar/companies/baz".
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Required. The display name of the company, for example, "Google LLC".
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the company, for example, "Google LLC".
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the company, for example, "Google LLC".
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the company, for example, "Google LLC".
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The display name of the company, for example, "Google LLC".
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object externalId_ = "";
    /**
     *
     *
     * <pre>
     * Required. Client side company identifier, used to uniquely identify the
     * company.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string external_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The externalId.
     */
    public java.lang.String getExternalId() {
      java.lang.Object ref = externalId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        externalId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Client side company identifier, used to uniquely identify the
     * company.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string external_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for externalId.
     */
    public com.google.protobuf.ByteString getExternalIdBytes() {
      java.lang.Object ref = externalId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        externalId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Client side company identifier, used to uniquely identify the
     * company.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string external_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The externalId to set.
     * @return This builder for chaining.
     */
    public Builder setExternalId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      externalId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Client side company identifier, used to uniquely identify the
     * company.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string external_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExternalId() {
      externalId_ = getDefaultInstance().getExternalId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Client side company identifier, used to uniquely identify the
     * company.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string external_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for externalId to set.
     * @return This builder for chaining.
     */
    public Builder setExternalIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      externalId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int size_ = 0;
    /**
     *
     *
     * <pre>
     * The employer's company size.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompanySize size = 4;</code>
     *
     * @return The enum numeric value on the wire for size.
     */
    @java.lang.Override
    public int getSizeValue() {
      return size_;
    }
    /**
     *
     *
     * <pre>
     * The employer's company size.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompanySize size = 4;</code>
     *
     * @param value The enum numeric value on the wire for size to set.
     * @return This builder for chaining.
     */
    public Builder setSizeValue(int value) {
      size_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The employer's company size.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompanySize size = 4;</code>
     *
     * @return The size.
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.CompanySize getSize() {
      com.google.cloud.talent.v4.CompanySize result =
          com.google.cloud.talent.v4.CompanySize.forNumber(size_);
      return result == null ? com.google.cloud.talent.v4.CompanySize.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The employer's company size.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompanySize size = 4;</code>
     *
     * @param value The size to set.
     * @return This builder for chaining.
     */
    public Builder setSize(com.google.cloud.talent.v4.CompanySize value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      size_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The employer's company size.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompanySize size = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSize() {
      bitField0_ = (bitField0_ & ~0x00000008);
      size_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object headquartersAddress_ = "";
    /**
     *
     *
     * <pre>
     * The street address of the company's main headquarters, which may be
     * different from the job location. The service attempts
     * to geolocate the provided address, and populates a more specific
     * location wherever possible in
     * [DerivedInfo.headquarters_location][google.cloud.talent.v4.Company.DerivedInfo.headquarters_location].
     * </pre>
     *
     * <code>string headquarters_address = 5;</code>
     *
     * @return The headquartersAddress.
     */
    public java.lang.String getHeadquartersAddress() {
      java.lang.Object ref = headquartersAddress_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        headquartersAddress_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The street address of the company's main headquarters, which may be
     * different from the job location. The service attempts
     * to geolocate the provided address, and populates a more specific
     * location wherever possible in
     * [DerivedInfo.headquarters_location][google.cloud.talent.v4.Company.DerivedInfo.headquarters_location].
     * </pre>
     *
     * <code>string headquarters_address = 5;</code>
     *
     * @return The bytes for headquartersAddress.
     */
    public com.google.protobuf.ByteString getHeadquartersAddressBytes() {
      java.lang.Object ref = headquartersAddress_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        headquartersAddress_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The street address of the company's main headquarters, which may be
     * different from the job location. The service attempts
     * to geolocate the provided address, and populates a more specific
     * location wherever possible in
     * [DerivedInfo.headquarters_location][google.cloud.talent.v4.Company.DerivedInfo.headquarters_location].
     * </pre>
     *
     * <code>string headquarters_address = 5;</code>
     *
     * @param value The headquartersAddress to set.
     * @return This builder for chaining.
     */
    public Builder setHeadquartersAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      headquartersAddress_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The street address of the company's main headquarters, which may be
     * different from the job location. The service attempts
     * to geolocate the provided address, and populates a more specific
     * location wherever possible in
     * [DerivedInfo.headquarters_location][google.cloud.talent.v4.Company.DerivedInfo.headquarters_location].
     * </pre>
     *
     * <code>string headquarters_address = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHeadquartersAddress() {
      headquartersAddress_ = getDefaultInstance().getHeadquartersAddress();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The street address of the company's main headquarters, which may be
     * different from the job location. The service attempts
     * to geolocate the provided address, and populates a more specific
     * location wherever possible in
     * [DerivedInfo.headquarters_location][google.cloud.talent.v4.Company.DerivedInfo.headquarters_location].
     * </pre>
     *
     * <code>string headquarters_address = 5;</code>
     *
     * @param value The bytes for headquartersAddress to set.
     * @return This builder for chaining.
     */
    public Builder setHeadquartersAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      headquartersAddress_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private boolean hiringAgency_;
    /**
     *
     *
     * <pre>
     * Set to true if it is the hiring agency that post jobs for other
     * employers.
     *
     * Defaults to false if not provided.
     * </pre>
     *
     * <code>bool hiring_agency = 6;</code>
     *
     * @return The hiringAgency.
     */
    @java.lang.Override
    public boolean getHiringAgency() {
      return hiringAgency_;
    }
    /**
     *
     *
     * <pre>
     * Set to true if it is the hiring agency that post jobs for other
     * employers.
     *
     * Defaults to false if not provided.
     * </pre>
     *
     * <code>bool hiring_agency = 6;</code>
     *
     * @param value The hiringAgency to set.
     * @return This builder for chaining.
     */
    public Builder setHiringAgency(boolean value) {

      hiringAgency_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Set to true if it is the hiring agency that post jobs for other
     * employers.
     *
     * Defaults to false if not provided.
     * </pre>
     *
     * <code>bool hiring_agency = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHiringAgency() {
      bitField0_ = (bitField0_ & ~0x00000020);
      hiringAgency_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object eeoText_ = "";
    /**
     *
     *
     * <pre>
     * Equal Employment Opportunity legal disclaimer text to be
     * associated with all jobs, and typically to be displayed in all
     * roles.
     *
     * The maximum number of allowed characters is 500.
     * </pre>
     *
     * <code>string eeo_text = 7;</code>
     *
     * @return The eeoText.
     */
    public java.lang.String getEeoText() {
      java.lang.Object ref = eeoText_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        eeoText_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Equal Employment Opportunity legal disclaimer text to be
     * associated with all jobs, and typically to be displayed in all
     * roles.
     *
     * The maximum number of allowed characters is 500.
     * </pre>
     *
     * <code>string eeo_text = 7;</code>
     *
     * @return The bytes for eeoText.
     */
    public com.google.protobuf.ByteString getEeoTextBytes() {
      java.lang.Object ref = eeoText_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        eeoText_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Equal Employment Opportunity legal disclaimer text to be
     * associated with all jobs, and typically to be displayed in all
     * roles.
     *
     * The maximum number of allowed characters is 500.
     * </pre>
     *
     * <code>string eeo_text = 7;</code>
     *
     * @param value The eeoText to set.
     * @return This builder for chaining.
     */
    public Builder setEeoText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      eeoText_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Equal Employment Opportunity legal disclaimer text to be
     * associated with all jobs, and typically to be displayed in all
     * roles.
     *
     * The maximum number of allowed characters is 500.
     * </pre>
     *
     * <code>string eeo_text = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEeoText() {
      eeoText_ = getDefaultInstance().getEeoText();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Equal Employment Opportunity legal disclaimer text to be
     * associated with all jobs, and typically to be displayed in all
     * roles.
     *
     * The maximum number of allowed characters is 500.
     * </pre>
     *
     * <code>string eeo_text = 7;</code>
     *
     * @param value The bytes for eeoText to set.
     * @return This builder for chaining.
     */
    public Builder setEeoTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      eeoText_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private java.lang.Object websiteUri_ = "";
    /**
     *
     *
     * <pre>
     * The URI representing the company's primary web site or home page,
     * for example, "https://www.google.com".
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string website_uri = 8;</code>
     *
     * @return The websiteUri.
     */
    public java.lang.String getWebsiteUri() {
      java.lang.Object ref = websiteUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        websiteUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI representing the company's primary web site or home page,
     * for example, "https://www.google.com".
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string website_uri = 8;</code>
     *
     * @return The bytes for websiteUri.
     */
    public com.google.protobuf.ByteString getWebsiteUriBytes() {
      java.lang.Object ref = websiteUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        websiteUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI representing the company's primary web site or home page,
     * for example, "https://www.google.com".
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string website_uri = 8;</code>
     *
     * @param value The websiteUri to set.
     * @return This builder for chaining.
     */
    public Builder setWebsiteUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      websiteUri_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI representing the company's primary web site or home page,
     * for example, "https://www.google.com".
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string website_uri = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearWebsiteUri() {
      websiteUri_ = getDefaultInstance().getWebsiteUri();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI representing the company's primary web site or home page,
     * for example, "https://www.google.com".
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string website_uri = 8;</code>
     *
     * @param value The bytes for websiteUri to set.
     * @return This builder for chaining.
     */
    public Builder setWebsiteUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      websiteUri_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object careerSiteUri_ = "";
    /**
     *
     *
     * <pre>
     * The URI to employer's career site or careers page on the employer's web
     * site, for example, "https://careers.google.com".
     * </pre>
     *
     * <code>string career_site_uri = 9;</code>
     *
     * @return The careerSiteUri.
     */
    public java.lang.String getCareerSiteUri() {
      java.lang.Object ref = careerSiteUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        careerSiteUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI to employer's career site or careers page on the employer's web
     * site, for example, "https://careers.google.com".
     * </pre>
     *
     * <code>string career_site_uri = 9;</code>
     *
     * @return The bytes for careerSiteUri.
     */
    public com.google.protobuf.ByteString getCareerSiteUriBytes() {
      java.lang.Object ref = careerSiteUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        careerSiteUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI to employer's career site or careers page on the employer's web
     * site, for example, "https://careers.google.com".
     * </pre>
     *
     * <code>string career_site_uri = 9;</code>
     *
     * @param value The careerSiteUri to set.
     * @return This builder for chaining.
     */
    public Builder setCareerSiteUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      careerSiteUri_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI to employer's career site or careers page on the employer's web
     * site, for example, "https://careers.google.com".
     * </pre>
     *
     * <code>string career_site_uri = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCareerSiteUri() {
      careerSiteUri_ = getDefaultInstance().getCareerSiteUri();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The URI to employer's career site or careers page on the employer's web
     * site, for example, "https://careers.google.com".
     * </pre>
     *
     * <code>string career_site_uri = 9;</code>
     *
     * @param value The bytes for careerSiteUri to set.
     * @return This builder for chaining.
     */
    public Builder setCareerSiteUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      careerSiteUri_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private java.lang.Object imageUri_ = "";
    /**
     *
     *
     * <pre>
     * A URI that hosts the employer's company logo.
     * </pre>
     *
     * <code>string image_uri = 10;</code>
     *
     * @return The imageUri.
     */
    public java.lang.String getImageUri() {
      java.lang.Object ref = imageUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        imageUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A URI that hosts the employer's company logo.
     * </pre>
     *
     * <code>string image_uri = 10;</code>
     *
     * @return The bytes for imageUri.
     */
    public com.google.protobuf.ByteString getImageUriBytes() {
      java.lang.Object ref = imageUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        imageUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A URI that hosts the employer's company logo.
     * </pre>
     *
     * <code>string image_uri = 10;</code>
     *
     * @param value The imageUri to set.
     * @return This builder for chaining.
     */
    public Builder setImageUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      imageUri_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A URI that hosts the employer's company logo.
     * </pre>
     *
     * <code>string image_uri = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImageUri() {
      imageUri_ = getDefaultInstance().getImageUri();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A URI that hosts the employer's company logo.
     * </pre>
     *
     * <code>string image_uri = 10;</code>
     *
     * @param value The bytes for imageUri to set.
     * @return This builder for chaining.
     */
    public Builder setImageUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      imageUri_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList keywordSearchableJobCustomAttributes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureKeywordSearchableJobCustomAttributesIsMutable() {
      if (!keywordSearchableJobCustomAttributes_.isModifiable()) {
        keywordSearchableJobCustomAttributes_ =
            new com.google.protobuf.LazyStringArrayList(keywordSearchableJobCustomAttributes_);
      }
      bitField0_ |= 0x00000400;
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated. Please set the searchability of the custom
     * attribute in the
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes] going
     * forward.
     *
     * A list of keys of filterable
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes],
     * whose corresponding `string_values` are used in keyword searches. Jobs with
     * `string_values` under these specified field keys are returned if any
     * of the values match the search keyword. Custom field values with
     * parenthesis, brackets and special symbols are not searchable as-is,
     * and those keyword queries must be surrounded by quotes.
     * </pre>
     *
     * <code>repeated string keyword_searchable_job_custom_attributes = 11 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.talent.v4.Company.keyword_searchable_job_custom_attributes is
     *     deprecated. See google/cloud/talent/v4/company.proto;l=112
     * @return A list containing the keywordSearchableJobCustomAttributes.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ProtocolStringList getKeywordSearchableJobCustomAttributesList() {
      keywordSearchableJobCustomAttributes_.makeImmutable();
      return keywordSearchableJobCustomAttributes_;
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated. Please set the searchability of the custom
     * attribute in the
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes] going
     * forward.
     *
     * A list of keys of filterable
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes],
     * whose corresponding `string_values` are used in keyword searches. Jobs with
     * `string_values` under these specified field keys are returned if any
     * of the values match the search keyword. Custom field values with
     * parenthesis, brackets and special symbols are not searchable as-is,
     * and those keyword queries must be surrounded by quotes.
     * </pre>
     *
     * <code>repeated string keyword_searchable_job_custom_attributes = 11 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.talent.v4.Company.keyword_searchable_job_custom_attributes is
     *     deprecated. See google/cloud/talent/v4/company.proto;l=112
     * @return The count of keywordSearchableJobCustomAttributes.
     */
    @java.lang.Deprecated
    public int getKeywordSearchableJobCustomAttributesCount() {
      return keywordSearchableJobCustomAttributes_.size();
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated. Please set the searchability of the custom
     * attribute in the
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes] going
     * forward.
     *
     * A list of keys of filterable
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes],
     * whose corresponding `string_values` are used in keyword searches. Jobs with
     * `string_values` under these specified field keys are returned if any
     * of the values match the search keyword. Custom field values with
     * parenthesis, brackets and special symbols are not searchable as-is,
     * and those keyword queries must be surrounded by quotes.
     * </pre>
     *
     * <code>repeated string keyword_searchable_job_custom_attributes = 11 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.talent.v4.Company.keyword_searchable_job_custom_attributes is
     *     deprecated. See google/cloud/talent/v4/company.proto;l=112
     * @param index The index of the element to return.
     * @return The keywordSearchableJobCustomAttributes at the given index.
     */
    @java.lang.Deprecated
    public java.lang.String getKeywordSearchableJobCustomAttributes(int index) {
      return keywordSearchableJobCustomAttributes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated. Please set the searchability of the custom
     * attribute in the
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes] going
     * forward.
     *
     * A list of keys of filterable
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes],
     * whose corresponding `string_values` are used in keyword searches. Jobs with
     * `string_values` under these specified field keys are returned if any
     * of the values match the search keyword. Custom field values with
     * parenthesis, brackets and special symbols are not searchable as-is,
     * and those keyword queries must be surrounded by quotes.
     * </pre>
     *
     * <code>repeated string keyword_searchable_job_custom_attributes = 11 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.talent.v4.Company.keyword_searchable_job_custom_attributes is
     *     deprecated. See google/cloud/talent/v4/company.proto;l=112
     * @param index The index of the value to return.
     * @return The bytes of the keywordSearchableJobCustomAttributes at the given index.
     */
    @java.lang.Deprecated
    public com.google.protobuf.ByteString getKeywordSearchableJobCustomAttributesBytes(int index) {
      return keywordSearchableJobCustomAttributes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated. Please set the searchability of the custom
     * attribute in the
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes] going
     * forward.
     *
     * A list of keys of filterable
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes],
     * whose corresponding `string_values` are used in keyword searches. Jobs with
     * `string_values` under these specified field keys are returned if any
     * of the values match the search keyword. Custom field values with
     * parenthesis, brackets and special symbols are not searchable as-is,
     * and those keyword queries must be surrounded by quotes.
     * </pre>
     *
     * <code>repeated string keyword_searchable_job_custom_attributes = 11 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.talent.v4.Company.keyword_searchable_job_custom_attributes is
     *     deprecated. See google/cloud/talent/v4/company.proto;l=112
     * @param index The index to set the value at.
     * @param value The keywordSearchableJobCustomAttributes to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setKeywordSearchableJobCustomAttributes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureKeywordSearchableJobCustomAttributesIsMutable();
      keywordSearchableJobCustomAttributes_.set(index, value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated. Please set the searchability of the custom
     * attribute in the
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes] going
     * forward.
     *
     * A list of keys of filterable
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes],
     * whose corresponding `string_values` are used in keyword searches. Jobs with
     * `string_values` under these specified field keys are returned if any
     * of the values match the search keyword. Custom field values with
     * parenthesis, brackets and special symbols are not searchable as-is,
     * and those keyword queries must be surrounded by quotes.
     * </pre>
     *
     * <code>repeated string keyword_searchable_job_custom_attributes = 11 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.talent.v4.Company.keyword_searchable_job_custom_attributes is
     *     deprecated. See google/cloud/talent/v4/company.proto;l=112
     * @param value The keywordSearchableJobCustomAttributes to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addKeywordSearchableJobCustomAttributes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureKeywordSearchableJobCustomAttributesIsMutable();
      keywordSearchableJobCustomAttributes_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated. Please set the searchability of the custom
     * attribute in the
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes] going
     * forward.
     *
     * A list of keys of filterable
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes],
     * whose corresponding `string_values` are used in keyword searches. Jobs with
     * `string_values` under these specified field keys are returned if any
     * of the values match the search keyword. Custom field values with
     * parenthesis, brackets and special symbols are not searchable as-is,
     * and those keyword queries must be surrounded by quotes.
     * </pre>
     *
     * <code>repeated string keyword_searchable_job_custom_attributes = 11 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.talent.v4.Company.keyword_searchable_job_custom_attributes is
     *     deprecated. See google/cloud/talent/v4/company.proto;l=112
     * @param values The keywordSearchableJobCustomAttributes to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addAllKeywordSearchableJobCustomAttributes(
        java.lang.Iterable<java.lang.String> values) {
      ensureKeywordSearchableJobCustomAttributesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, keywordSearchableJobCustomAttributes_);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated. Please set the searchability of the custom
     * attribute in the
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes] going
     * forward.
     *
     * A list of keys of filterable
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes],
     * whose corresponding `string_values` are used in keyword searches. Jobs with
     * `string_values` under these specified field keys are returned if any
     * of the values match the search keyword. Custom field values with
     * parenthesis, brackets and special symbols are not searchable as-is,
     * and those keyword queries must be surrounded by quotes.
     * </pre>
     *
     * <code>repeated string keyword_searchable_job_custom_attributes = 11 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.talent.v4.Company.keyword_searchable_job_custom_attributes is
     *     deprecated. See google/cloud/talent/v4/company.proto;l=112
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearKeywordSearchableJobCustomAttributes() {
      keywordSearchableJobCustomAttributes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated. Please set the searchability of the custom
     * attribute in the
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes] going
     * forward.
     *
     * A list of keys of filterable
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes],
     * whose corresponding `string_values` are used in keyword searches. Jobs with
     * `string_values` under these specified field keys are returned if any
     * of the values match the search keyword. Custom field values with
     * parenthesis, brackets and special symbols are not searchable as-is,
     * and those keyword queries must be surrounded by quotes.
     * </pre>
     *
     * <code>repeated string keyword_searchable_job_custom_attributes = 11 [deprecated = true];
     * </code>
     *
     * @deprecated google.cloud.talent.v4.Company.keyword_searchable_job_custom_attributes is
     *     deprecated. See google/cloud/talent/v4/company.proto;l=112
     * @param value The bytes of the keywordSearchableJobCustomAttributes to add.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder addKeywordSearchableJobCustomAttributesBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureKeywordSearchableJobCustomAttributesIsMutable();
      keywordSearchableJobCustomAttributes_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private com.google.cloud.talent.v4.Company.DerivedInfo derivedInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.Company.DerivedInfo,
            com.google.cloud.talent.v4.Company.DerivedInfo.Builder,
            com.google.cloud.talent.v4.Company.DerivedInfoOrBuilder>
        derivedInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Derived details about the company.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.Company.DerivedInfo derived_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the derivedInfo field is set.
     */
    public boolean hasDerivedInfo() {
      return ((bitField0_ & 0x00000800) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Derived details about the company.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.Company.DerivedInfo derived_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The derivedInfo.
     */
    public com.google.cloud.talent.v4.Company.DerivedInfo getDerivedInfo() {
      if (derivedInfoBuilder_ == null) {
        return derivedInfo_ == null
            ? com.google.cloud.talent.v4.Company.DerivedInfo.getDefaultInstance()
            : derivedInfo_;
      } else {
        return derivedInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Derived details about the company.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.Company.DerivedInfo derived_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDerivedInfo(com.google.cloud.talent.v4.Company.DerivedInfo value) {
      if (derivedInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        derivedInfo_ = value;
      } else {
        derivedInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Derived details about the company.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.Company.DerivedInfo derived_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDerivedInfo(
        com.google.cloud.talent.v4.Company.DerivedInfo.Builder builderForValue) {
      if (derivedInfoBuilder_ == null) {
        derivedInfo_ = builderForValue.build();
      } else {
        derivedInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Derived details about the company.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.Company.DerivedInfo derived_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDerivedInfo(com.google.cloud.talent.v4.Company.DerivedInfo value) {
      if (derivedInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && derivedInfo_ != null
            && derivedInfo_
                != com.google.cloud.talent.v4.Company.DerivedInfo.getDefaultInstance()) {
          getDerivedInfoBuilder().mergeFrom(value);
        } else {
          derivedInfo_ = value;
        }
      } else {
        derivedInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Derived details about the company.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.Company.DerivedInfo derived_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDerivedInfo() {
      bitField0_ = (bitField0_ & ~0x00000800);
      derivedInfo_ = null;
      if (derivedInfoBuilder_ != null) {
        derivedInfoBuilder_.dispose();
        derivedInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Derived details about the company.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.Company.DerivedInfo derived_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.talent.v4.Company.DerivedInfo.Builder getDerivedInfoBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getDerivedInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Derived details about the company.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.Company.DerivedInfo derived_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.talent.v4.Company.DerivedInfoOrBuilder getDerivedInfoOrBuilder() {
      if (derivedInfoBuilder_ != null) {
        return derivedInfoBuilder_.getMessageOrBuilder();
      } else {
        return derivedInfo_ == null
            ? com.google.cloud.talent.v4.Company.DerivedInfo.getDefaultInstance()
            : derivedInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Derived details about the company.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.Company.DerivedInfo derived_info = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.Company.DerivedInfo,
            com.google.cloud.talent.v4.Company.DerivedInfo.Builder,
            com.google.cloud.talent.v4.Company.DerivedInfoOrBuilder>
        getDerivedInfoFieldBuilder() {
      if (derivedInfoBuilder_ == null) {
        derivedInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.talent.v4.Company.DerivedInfo,
                com.google.cloud.talent.v4.Company.DerivedInfo.Builder,
                com.google.cloud.talent.v4.Company.DerivedInfoOrBuilder>(
                getDerivedInfo(), getParentForChildren(), isClean());
        derivedInfo_ = null;
      }
      return derivedInfoBuilder_;
    }

    private boolean suspended_;
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether a company is flagged to be suspended from
     * public availability by the service when job content appears suspicious,
     * abusive, or spammy.
     * </pre>
     *
     * <code>bool suspended = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The suspended.
     */
    @java.lang.Override
    public boolean getSuspended() {
      return suspended_;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether a company is flagged to be suspended from
     * public availability by the service when job content appears suspicious,
     * abusive, or spammy.
     * </pre>
     *
     * <code>bool suspended = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The suspended to set.
     * @return This builder for chaining.
     */
    public Builder setSuspended(boolean value) {

      suspended_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Indicates whether a company is flagged to be suspended from
     * public availability by the service when job content appears suspicious,
     * abusive, or spammy.
     * </pre>
     *
     * <code>bool suspended = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSuspended() {
      bitField0_ = (bitField0_ & ~0x00001000);
      suspended_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.talent.v4.Company)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.talent.v4.Company)
  private static final com.google.cloud.talent.v4.Company DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.talent.v4.Company();
  }

  public static com.google.cloud.talent.v4.Company getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Company> PARSER =
      new com.google.protobuf.AbstractParser<Company>() {
        @java.lang.Override
        public Company parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Company> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Company> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.talent.v4.Company getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
