/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/talent/v4/completion_service.proto

package com.google.cloud.talent.v4;

/**
 *
 *
 * <pre>
 * Response of auto-complete query.
 * </pre>
 *
 * Protobuf type {@code google.cloud.talent.v4.CompleteQueryResponse}
 */
public final class CompleteQueryResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.talent.v4.CompleteQueryResponse)
    CompleteQueryResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CompleteQueryResponse.newBuilder() to construct.
  private CompleteQueryResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CompleteQueryResponse() {
    completionResults_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CompleteQueryResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.talent.v4.CompletionServiceProto
        .internal_static_google_cloud_talent_v4_CompleteQueryResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.talent.v4.CompletionServiceProto
        .internal_static_google_cloud_talent_v4_CompleteQueryResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.talent.v4.CompleteQueryResponse.class,
            com.google.cloud.talent.v4.CompleteQueryResponse.Builder.class);
  }

  public interface CompletionResultOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.talent.v4.CompleteQueryResponse.CompletionResult)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The suggestion.
     */
    java.lang.String getSuggestion();
    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The bytes for suggestion.
     */
    com.google.protobuf.ByteString getSuggestionBytes();

    /**
     *
     *
     * <pre>
     * The completion topic.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompleteQueryRequest.CompletionType type = 2;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();
    /**
     *
     *
     * <pre>
     * The completion topic.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompleteQueryRequest.CompletionType type = 2;</code>
     *
     * @return The type.
     */
    com.google.cloud.talent.v4.CompleteQueryRequest.CompletionType getType();

    /**
     *
     *
     * <pre>
     * The URI of the company image for
     * [COMPANY_NAME][google.cloud.talent.v4.CompleteQueryRequest.CompletionType.COMPANY_NAME].
     * </pre>
     *
     * <code>string image_uri = 3;</code>
     *
     * @return The imageUri.
     */
    java.lang.String getImageUri();
    /**
     *
     *
     * <pre>
     * The URI of the company image for
     * [COMPANY_NAME][google.cloud.talent.v4.CompleteQueryRequest.CompletionType.COMPANY_NAME].
     * </pre>
     *
     * <code>string image_uri = 3;</code>
     *
     * @return The bytes for imageUri.
     */
    com.google.protobuf.ByteString getImageUriBytes();
  }
  /**
   *
   *
   * <pre>
   * Resource that represents completion results.
   * </pre>
   *
   * Protobuf type {@code google.cloud.talent.v4.CompleteQueryResponse.CompletionResult}
   */
  public static final class CompletionResult extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.talent.v4.CompleteQueryResponse.CompletionResult)
      CompletionResultOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CompletionResult.newBuilder() to construct.
    private CompletionResult(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CompletionResult() {
      suggestion_ = "";
      type_ = 0;
      imageUri_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CompletionResult();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.talent.v4.CompletionServiceProto
          .internal_static_google_cloud_talent_v4_CompleteQueryResponse_CompletionResult_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.talent.v4.CompletionServiceProto
          .internal_static_google_cloud_talent_v4_CompleteQueryResponse_CompletionResult_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult.class,
              com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult.Builder.class);
    }

    public static final int SUGGESTION_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object suggestion_ = "";
    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The suggestion.
     */
    @java.lang.Override
    public java.lang.String getSuggestion() {
      java.lang.Object ref = suggestion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        suggestion_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The suggestion for the query.
     * </pre>
     *
     * <code>string suggestion = 1;</code>
     *
     * @return The bytes for suggestion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSuggestionBytes() {
      java.lang.Object ref = suggestion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        suggestion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TYPE_FIELD_NUMBER = 2;
    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * The completion topic.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompleteQueryRequest.CompletionType type = 2;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * The completion topic.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompleteQueryRequest.CompletionType type = 2;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.CompleteQueryRequest.CompletionType getType() {
      com.google.cloud.talent.v4.CompleteQueryRequest.CompletionType result =
          com.google.cloud.talent.v4.CompleteQueryRequest.CompletionType.forNumber(type_);
      return result == null
          ? com.google.cloud.talent.v4.CompleteQueryRequest.CompletionType.UNRECOGNIZED
          : result;
    }

    public static final int IMAGE_URI_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object imageUri_ = "";
    /**
     *
     *
     * <pre>
     * The URI of the company image for
     * [COMPANY_NAME][google.cloud.talent.v4.CompleteQueryRequest.CompletionType.COMPANY_NAME].
     * </pre>
     *
     * <code>string image_uri = 3;</code>
     *
     * @return The imageUri.
     */
    @java.lang.Override
    public java.lang.String getImageUri() {
      java.lang.Object ref = imageUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        imageUri_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The URI of the company image for
     * [COMPANY_NAME][google.cloud.talent.v4.CompleteQueryRequest.CompletionType.COMPANY_NAME].
     * </pre>
     *
     * <code>string image_uri = 3;</code>
     *
     * @return The bytes for imageUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getImageUriBytes() {
      java.lang.Object ref = imageUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        imageUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suggestion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, suggestion_);
      }
      if (type_
          != com.google.cloud.talent.v4.CompleteQueryRequest.CompletionType
              .COMPLETION_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, type_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, imageUri_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(suggestion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, suggestion_);
      }
      if (type_
          != com.google.cloud.talent.v4.CompleteQueryRequest.CompletionType
              .COMPLETION_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, type_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, imageUri_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult)) {
        return super.equals(obj);
      }
      com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult other =
          (com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult) obj;

      if (!getSuggestion().equals(other.getSuggestion())) return false;
      if (type_ != other.type_) return false;
      if (!getImageUri().equals(other.getImageUri())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SUGGESTION_FIELD_NUMBER;
      hash = (53 * hash) + getSuggestion().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (37 * hash) + IMAGE_URI_FIELD_NUMBER;
      hash = (53 * hash) + getImageUri().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Resource that represents completion results.
     * </pre>
     *
     * Protobuf type {@code google.cloud.talent.v4.CompleteQueryResponse.CompletionResult}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.talent.v4.CompleteQueryResponse.CompletionResult)
        com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResultOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.talent.v4.CompletionServiceProto
            .internal_static_google_cloud_talent_v4_CompleteQueryResponse_CompletionResult_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.talent.v4.CompletionServiceProto
            .internal_static_google_cloud_talent_v4_CompleteQueryResponse_CompletionResult_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult.class,
                com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult.Builder.class);
      }

      // Construct using
      // com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        suggestion_ = "";
        type_ = 0;
        imageUri_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.talent.v4.CompletionServiceProto
            .internal_static_google_cloud_talent_v4_CompleteQueryResponse_CompletionResult_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult
          getDefaultInstanceForType() {
        return com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult build() {
        com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult buildPartial() {
        com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult result =
            new com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.suggestion_ = suggestion_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.type_ = type_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.imageUri_ = imageUri_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult) {
          return mergeFrom(
              (com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult other) {
        if (other
            == com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult
                .getDefaultInstance()) return this;
        if (!other.getSuggestion().isEmpty()) {
          suggestion_ = other.suggestion_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (!other.getImageUri().isEmpty()) {
          imageUri_ = other.imageUri_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  suggestion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  type_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  imageUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object suggestion_ = "";
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @return The suggestion.
       */
      public java.lang.String getSuggestion() {
        java.lang.Object ref = suggestion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          suggestion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @return The bytes for suggestion.
       */
      public com.google.protobuf.ByteString getSuggestionBytes() {
        java.lang.Object ref = suggestion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          suggestion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @param value The suggestion to set.
       * @return This builder for chaining.
       */
      public Builder setSuggestion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        suggestion_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSuggestion() {
        suggestion_ = getDefaultInstance().getSuggestion();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The suggestion for the query.
       * </pre>
       *
       * <code>string suggestion = 1;</code>
       *
       * @param value The bytes for suggestion to set.
       * @return This builder for chaining.
       */
      public Builder setSuggestionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        suggestion_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int type_ = 0;
      /**
       *
       *
       * <pre>
       * The completion topic.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.CompleteQueryRequest.CompletionType type = 2;</code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }
      /**
       *
       *
       * <pre>
       * The completion topic.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.CompleteQueryRequest.CompletionType type = 2;</code>
       *
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The completion topic.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.CompleteQueryRequest.CompletionType type = 2;</code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.cloud.talent.v4.CompleteQueryRequest.CompletionType getType() {
        com.google.cloud.talent.v4.CompleteQueryRequest.CompletionType result =
            com.google.cloud.talent.v4.CompleteQueryRequest.CompletionType.forNumber(type_);
        return result == null
            ? com.google.cloud.talent.v4.CompleteQueryRequest.CompletionType.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * The completion topic.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.CompleteQueryRequest.CompletionType type = 2;</code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(com.google.cloud.talent.v4.CompleteQueryRequest.CompletionType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The completion topic.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.CompleteQueryRequest.CompletionType type = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000002);
        type_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object imageUri_ = "";
      /**
       *
       *
       * <pre>
       * The URI of the company image for
       * [COMPANY_NAME][google.cloud.talent.v4.CompleteQueryRequest.CompletionType.COMPANY_NAME].
       * </pre>
       *
       * <code>string image_uri = 3;</code>
       *
       * @return The imageUri.
       */
      public java.lang.String getImageUri() {
        java.lang.Object ref = imageUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          imageUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The URI of the company image for
       * [COMPANY_NAME][google.cloud.talent.v4.CompleteQueryRequest.CompletionType.COMPANY_NAME].
       * </pre>
       *
       * <code>string image_uri = 3;</code>
       *
       * @return The bytes for imageUri.
       */
      public com.google.protobuf.ByteString getImageUriBytes() {
        java.lang.Object ref = imageUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          imageUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The URI of the company image for
       * [COMPANY_NAME][google.cloud.talent.v4.CompleteQueryRequest.CompletionType.COMPANY_NAME].
       * </pre>
       *
       * <code>string image_uri = 3;</code>
       *
       * @param value The imageUri to set.
       * @return This builder for chaining.
       */
      public Builder setImageUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        imageUri_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The URI of the company image for
       * [COMPANY_NAME][google.cloud.talent.v4.CompleteQueryRequest.CompletionType.COMPANY_NAME].
       * </pre>
       *
       * <code>string image_uri = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearImageUri() {
        imageUri_ = getDefaultInstance().getImageUri();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The URI of the company image for
       * [COMPANY_NAME][google.cloud.talent.v4.CompleteQueryRequest.CompletionType.COMPANY_NAME].
       * </pre>
       *
       * <code>string image_uri = 3;</code>
       *
       * @param value The bytes for imageUri to set.
       * @return This builder for chaining.
       */
      public Builder setImageUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        imageUri_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.talent.v4.CompleteQueryResponse.CompletionResult)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.talent.v4.CompleteQueryResponse.CompletionResult)
    private static final com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult();
    }

    public static com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CompletionResult> PARSER =
        new com.google.protobuf.AbstractParser<CompletionResult>() {
          @java.lang.Override
          public CompletionResult parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CompletionResult> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CompletionResult> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int COMPLETION_RESULTS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult>
      completionResults_;
  /**
   *
   *
   * <pre>
   * Results of the matching job/company candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult>
      getCompletionResultsList() {
    return completionResults_;
  }
  /**
   *
   *
   * <pre>
   * Results of the matching job/company candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResultOrBuilder>
      getCompletionResultsOrBuilderList() {
    return completionResults_;
  }
  /**
   *
   *
   * <pre>
   * Results of the matching job/company candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
   * </code>
   */
  @java.lang.Override
  public int getCompletionResultsCount() {
    return completionResults_.size();
  }
  /**
   *
   *
   * <pre>
   * Results of the matching job/company candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult getCompletionResults(
      int index) {
    return completionResults_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Results of the matching job/company candidates.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResultOrBuilder
      getCompletionResultsOrBuilder(int index) {
    return completionResults_.get(index);
  }

  public static final int METADATA_FIELD_NUMBER = 2;
  private com.google.cloud.talent.v4.ResponseMetadata metadata_;
  /**
   *
   *
   * <pre>
   * Additional information for the API invocation, such as the request
   * tracking id.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 2;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return metadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * Additional information for the API invocation, such as the request
   * tracking id.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 2;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.ResponseMetadata getMetadata() {
    return metadata_ == null
        ? com.google.cloud.talent.v4.ResponseMetadata.getDefaultInstance()
        : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Additional information for the API invocation, such as the request
   * tracking id.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.ResponseMetadataOrBuilder getMetadataOrBuilder() {
    return metadata_ == null
        ? com.google.cloud.talent.v4.ResponseMetadata.getDefaultInstance()
        : metadata_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < completionResults_.size(); i++) {
      output.writeMessage(1, completionResults_.get(i));
    }
    if (metadata_ != null) {
      output.writeMessage(2, getMetadata());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < completionResults_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, completionResults_.get(i));
    }
    if (metadata_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMetadata());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.talent.v4.CompleteQueryResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.talent.v4.CompleteQueryResponse other =
        (com.google.cloud.talent.v4.CompleteQueryResponse) obj;

    if (!getCompletionResultsList().equals(other.getCompletionResultsList())) return false;
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getCompletionResultsCount() > 0) {
      hash = (37 * hash) + COMPLETION_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getCompletionResultsList().hashCode();
    }
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.talent.v4.CompleteQueryResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.CompleteQueryResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.CompleteQueryResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.CompleteQueryResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.CompleteQueryResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.CompleteQueryResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.CompleteQueryResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.CompleteQueryResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.CompleteQueryResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.CompleteQueryResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.CompleteQueryResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.CompleteQueryResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.talent.v4.CompleteQueryResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response of auto-complete query.
   * </pre>
   *
   * Protobuf type {@code google.cloud.talent.v4.CompleteQueryResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.talent.v4.CompleteQueryResponse)
      com.google.cloud.talent.v4.CompleteQueryResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.talent.v4.CompletionServiceProto
          .internal_static_google_cloud_talent_v4_CompleteQueryResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.talent.v4.CompletionServiceProto
          .internal_static_google_cloud_talent_v4_CompleteQueryResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.talent.v4.CompleteQueryResponse.class,
              com.google.cloud.talent.v4.CompleteQueryResponse.Builder.class);
    }

    // Construct using com.google.cloud.talent.v4.CompleteQueryResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (completionResultsBuilder_ == null) {
        completionResults_ = java.util.Collections.emptyList();
      } else {
        completionResults_ = null;
        completionResultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.talent.v4.CompletionServiceProto
          .internal_static_google_cloud_talent_v4_CompleteQueryResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.CompleteQueryResponse getDefaultInstanceForType() {
      return com.google.cloud.talent.v4.CompleteQueryResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.CompleteQueryResponse build() {
      com.google.cloud.talent.v4.CompleteQueryResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.CompleteQueryResponse buildPartial() {
      com.google.cloud.talent.v4.CompleteQueryResponse result =
          new com.google.cloud.talent.v4.CompleteQueryResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.talent.v4.CompleteQueryResponse result) {
      if (completionResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          completionResults_ = java.util.Collections.unmodifiableList(completionResults_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.completionResults_ = completionResults_;
      } else {
        result.completionResults_ = completionResultsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.talent.v4.CompleteQueryResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.talent.v4.CompleteQueryResponse) {
        return mergeFrom((com.google.cloud.talent.v4.CompleteQueryResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.talent.v4.CompleteQueryResponse other) {
      if (other == com.google.cloud.talent.v4.CompleteQueryResponse.getDefaultInstance())
        return this;
      if (completionResultsBuilder_ == null) {
        if (!other.completionResults_.isEmpty()) {
          if (completionResults_.isEmpty()) {
            completionResults_ = other.completionResults_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureCompletionResultsIsMutable();
            completionResults_.addAll(other.completionResults_);
          }
          onChanged();
        }
      } else {
        if (!other.completionResults_.isEmpty()) {
          if (completionResultsBuilder_.isEmpty()) {
            completionResultsBuilder_.dispose();
            completionResultsBuilder_ = null;
            completionResults_ = other.completionResults_;
            bitField0_ = (bitField0_ & ~0x00000001);
            completionResultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCompletionResultsFieldBuilder()
                    : null;
          } else {
            completionResultsBuilder_.addAllMessages(other.completionResults_);
          }
        }
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult m =
                    input.readMessage(
                        com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult.parser(),
                        extensionRegistry);
                if (completionResultsBuilder_ == null) {
                  ensureCompletionResultsIsMutable();
                  completionResults_.add(m);
                } else {
                  completionResultsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult>
        completionResults_ = java.util.Collections.emptyList();

    private void ensureCompletionResultsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        completionResults_ =
            new java.util.ArrayList<
                com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult>(
                completionResults_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult,
            com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult.Builder,
            com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResultOrBuilder>
        completionResultsBuilder_;

    /**
     *
     *
     * <pre>
     * Results of the matching job/company candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult>
        getCompletionResultsList() {
      if (completionResultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(completionResults_);
      } else {
        return completionResultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matching job/company candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public int getCompletionResultsCount() {
      if (completionResultsBuilder_ == null) {
        return completionResults_.size();
      } else {
        return completionResultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matching job/company candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult getCompletionResults(
        int index) {
      if (completionResultsBuilder_ == null) {
        return completionResults_.get(index);
      } else {
        return completionResultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matching job/company candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public Builder setCompletionResults(
        int index, com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult value) {
      if (completionResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCompletionResultsIsMutable();
        completionResults_.set(index, value);
        onChanged();
      } else {
        completionResultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matching job/company candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public Builder setCompletionResults(
        int index,
        com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult.Builder builderForValue) {
      if (completionResultsBuilder_ == null) {
        ensureCompletionResultsIsMutable();
        completionResults_.set(index, builderForValue.build());
        onChanged();
      } else {
        completionResultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matching job/company candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public Builder addCompletionResults(
        com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult value) {
      if (completionResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCompletionResultsIsMutable();
        completionResults_.add(value);
        onChanged();
      } else {
        completionResultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matching job/company candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public Builder addCompletionResults(
        int index, com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult value) {
      if (completionResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCompletionResultsIsMutable();
        completionResults_.add(index, value);
        onChanged();
      } else {
        completionResultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matching job/company candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public Builder addCompletionResults(
        com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult.Builder builderForValue) {
      if (completionResultsBuilder_ == null) {
        ensureCompletionResultsIsMutable();
        completionResults_.add(builderForValue.build());
        onChanged();
      } else {
        completionResultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matching job/company candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public Builder addCompletionResults(
        int index,
        com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult.Builder builderForValue) {
      if (completionResultsBuilder_ == null) {
        ensureCompletionResultsIsMutable();
        completionResults_.add(index, builderForValue.build());
        onChanged();
      } else {
        completionResultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matching job/company candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public Builder addAllCompletionResults(
        java.lang.Iterable<
                ? extends com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult>
            values) {
      if (completionResultsBuilder_ == null) {
        ensureCompletionResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, completionResults_);
        onChanged();
      } else {
        completionResultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matching job/company candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public Builder clearCompletionResults() {
      if (completionResultsBuilder_ == null) {
        completionResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        completionResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matching job/company candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public Builder removeCompletionResults(int index) {
      if (completionResultsBuilder_ == null) {
        ensureCompletionResultsIsMutable();
        completionResults_.remove(index);
        onChanged();
      } else {
        completionResultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Results of the matching job/company candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult.Builder
        getCompletionResultsBuilder(int index) {
      return getCompletionResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Results of the matching job/company candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResultOrBuilder
        getCompletionResultsOrBuilder(int index) {
      if (completionResultsBuilder_ == null) {
        return completionResults_.get(index);
      } else {
        return completionResultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matching job/company candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResultOrBuilder>
        getCompletionResultsOrBuilderList() {
      if (completionResultsBuilder_ != null) {
        return completionResultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(completionResults_);
      }
    }
    /**
     *
     *
     * <pre>
     * Results of the matching job/company candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult.Builder
        addCompletionResultsBuilder() {
      return getCompletionResultsFieldBuilder()
          .addBuilder(
              com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Results of the matching job/company candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult.Builder
        addCompletionResultsBuilder(int index) {
      return getCompletionResultsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Results of the matching job/company candidates.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.talent.v4.CompleteQueryResponse.CompletionResult completion_results = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult.Builder>
        getCompletionResultsBuilderList() {
      return getCompletionResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult,
            com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult.Builder,
            com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResultOrBuilder>
        getCompletionResultsFieldBuilder() {
      if (completionResultsBuilder_ == null) {
        completionResultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult,
                com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResult.Builder,
                com.google.cloud.talent.v4.CompleteQueryResponse.CompletionResultOrBuilder>(
                completionResults_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        completionResults_ = null;
      }
      return completionResultsBuilder_;
    }

    private com.google.cloud.talent.v4.ResponseMetadata metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.ResponseMetadata,
            com.google.cloud.talent.v4.ResponseMetadata.Builder,
            com.google.cloud.talent.v4.ResponseMetadataOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 2;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 2;</code>
     *
     * @return The metadata.
     */
    public com.google.cloud.talent.v4.ResponseMetadata getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null
            ? com.google.cloud.talent.v4.ResponseMetadata.getDefaultInstance()
            : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 2;</code>
     */
    public Builder setMetadata(com.google.cloud.talent.v4.ResponseMetadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 2;</code>
     */
    public Builder setMetadata(
        com.google.cloud.talent.v4.ResponseMetadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 2;</code>
     */
    public Builder mergeMetadata(com.google.cloud.talent.v4.ResponseMetadata value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && metadata_ != null
            && metadata_ != com.google.cloud.talent.v4.ResponseMetadata.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 2;</code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000002);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 2;</code>
     */
    public com.google.cloud.talent.v4.ResponseMetadata.Builder getMetadataBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 2;</code>
     */
    public com.google.cloud.talent.v4.ResponseMetadataOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null
            ? com.google.cloud.talent.v4.ResponseMetadata.getDefaultInstance()
            : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.ResponseMetadata,
            com.google.cloud.talent.v4.ResponseMetadata.Builder,
            com.google.cloud.talent.v4.ResponseMetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.talent.v4.ResponseMetadata,
                com.google.cloud.talent.v4.ResponseMetadata.Builder,
                com.google.cloud.talent.v4.ResponseMetadataOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.talent.v4.CompleteQueryResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.talent.v4.CompleteQueryResponse)
  private static final com.google.cloud.talent.v4.CompleteQueryResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.talent.v4.CompleteQueryResponse();
  }

  public static com.google.cloud.talent.v4.CompleteQueryResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CompleteQueryResponse> PARSER =
      new com.google.protobuf.AbstractParser<CompleteQueryResponse>() {
        @java.lang.Override
        public CompleteQueryResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CompleteQueryResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CompleteQueryResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.talent.v4.CompleteQueryResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
