/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/talent/v4/common.proto

package com.google.cloud.talent.v4;

/**
 *
 *
 * <pre>
 * Custom attribute values that are either filterable or non-filterable.
 * </pre>
 *
 * Protobuf type {@code google.cloud.talent.v4.CustomAttribute}
 */
public final class CustomAttribute extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.talent.v4.CustomAttribute)
    CustomAttributeOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CustomAttribute.newBuilder() to construct.
  private CustomAttribute(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CustomAttribute() {
    stringValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
    longValues_ = emptyLongList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CustomAttribute();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.talent.v4.CommonProto
        .internal_static_google_cloud_talent_v4_CustomAttribute_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.talent.v4.CommonProto
        .internal_static_google_cloud_talent_v4_CustomAttribute_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.talent.v4.CustomAttribute.class,
            com.google.cloud.talent.v4.CustomAttribute.Builder.class);
  }

  public static final int STRING_VALUES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList stringValues_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Exactly one of
   * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
   * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
   * specified.
   *
   * This field is used to perform a string match (`CASE_SENSITIVE_MATCH` or
   * `CASE_INSENSITIVE_MATCH`) search.
   * For filterable `string_value`s, a maximum total number of 200 values
   * is allowed, with each `string_value` has a byte size of no more than
   * 500B. For unfilterable `string_values`, the maximum total byte size of
   * unfilterable `string_values` is 50KB.
   *
   * Empty string isn't allowed.
   * </pre>
   *
   * <code>repeated string string_values = 1;</code>
   *
   * @return A list containing the stringValues.
   */
  public com.google.protobuf.ProtocolStringList getStringValuesList() {
    return stringValues_;
  }
  /**
   *
   *
   * <pre>
   * Exactly one of
   * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
   * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
   * specified.
   *
   * This field is used to perform a string match (`CASE_SENSITIVE_MATCH` or
   * `CASE_INSENSITIVE_MATCH`) search.
   * For filterable `string_value`s, a maximum total number of 200 values
   * is allowed, with each `string_value` has a byte size of no more than
   * 500B. For unfilterable `string_values`, the maximum total byte size of
   * unfilterable `string_values` is 50KB.
   *
   * Empty string isn't allowed.
   * </pre>
   *
   * <code>repeated string string_values = 1;</code>
   *
   * @return The count of stringValues.
   */
  public int getStringValuesCount() {
    return stringValues_.size();
  }
  /**
   *
   *
   * <pre>
   * Exactly one of
   * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
   * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
   * specified.
   *
   * This field is used to perform a string match (`CASE_SENSITIVE_MATCH` or
   * `CASE_INSENSITIVE_MATCH`) search.
   * For filterable `string_value`s, a maximum total number of 200 values
   * is allowed, with each `string_value` has a byte size of no more than
   * 500B. For unfilterable `string_values`, the maximum total byte size of
   * unfilterable `string_values` is 50KB.
   *
   * Empty string isn't allowed.
   * </pre>
   *
   * <code>repeated string string_values = 1;</code>
   *
   * @param index The index of the element to return.
   * @return The stringValues at the given index.
   */
  public java.lang.String getStringValues(int index) {
    return stringValues_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Exactly one of
   * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
   * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
   * specified.
   *
   * This field is used to perform a string match (`CASE_SENSITIVE_MATCH` or
   * `CASE_INSENSITIVE_MATCH`) search.
   * For filterable `string_value`s, a maximum total number of 200 values
   * is allowed, with each `string_value` has a byte size of no more than
   * 500B. For unfilterable `string_values`, the maximum total byte size of
   * unfilterable `string_values` is 50KB.
   *
   * Empty string isn't allowed.
   * </pre>
   *
   * <code>repeated string string_values = 1;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the stringValues at the given index.
   */
  public com.google.protobuf.ByteString getStringValuesBytes(int index) {
    return stringValues_.getByteString(index);
  }

  public static final int LONG_VALUES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.Internal.LongList longValues_;
  /**
   *
   *
   * <pre>
   * Exactly one of
   * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
   * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
   * specified.
   *
   * This field is used to perform number range search.
   * (`EQ`, `GT`, `GE`, `LE`, `LT`) over filterable `long_value`.
   *
   * Currently at most 1
   * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] is
   * supported.
   * </pre>
   *
   * <code>repeated int64 long_values = 2;</code>
   *
   * @return A list containing the longValues.
   */
  @java.lang.Override
  public java.util.List<java.lang.Long> getLongValuesList() {
    return longValues_;
  }
  /**
   *
   *
   * <pre>
   * Exactly one of
   * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
   * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
   * specified.
   *
   * This field is used to perform number range search.
   * (`EQ`, `GT`, `GE`, `LE`, `LT`) over filterable `long_value`.
   *
   * Currently at most 1
   * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] is
   * supported.
   * </pre>
   *
   * <code>repeated int64 long_values = 2;</code>
   *
   * @return The count of longValues.
   */
  public int getLongValuesCount() {
    return longValues_.size();
  }
  /**
   *
   *
   * <pre>
   * Exactly one of
   * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
   * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
   * specified.
   *
   * This field is used to perform number range search.
   * (`EQ`, `GT`, `GE`, `LE`, `LT`) over filterable `long_value`.
   *
   * Currently at most 1
   * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] is
   * supported.
   * </pre>
   *
   * <code>repeated int64 long_values = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The longValues at the given index.
   */
  public long getLongValues(int index) {
    return longValues_.getLong(index);
  }

  private int longValuesMemoizedSerializedSize = -1;

  public static final int FILTERABLE_FIELD_NUMBER = 3;
  private boolean filterable_ = false;
  /**
   *
   *
   * <pre>
   * If the `filterable` flag is true, the custom field values may be used for
   * custom attribute filters
   * [JobQuery.custom_attribute_filter][google.cloud.talent.v4.JobQuery.custom_attribute_filter].
   * If false, these values may not be used for custom attribute filters.
   *
   * Default is false.
   * </pre>
   *
   * <code>bool filterable = 3;</code>
   *
   * @return The filterable.
   */
  @java.lang.Override
  public boolean getFilterable() {
    return filterable_;
  }

  public static final int KEYWORD_SEARCHABLE_FIELD_NUMBER = 4;
  private boolean keywordSearchable_ = false;
  /**
   *
   *
   * <pre>
   * If the `keyword_searchable` flag is true, the keywords in custom fields are
   * searchable by keyword match.
   * If false, the values are not searchable by keyword match.
   *
   * Default is false.
   * </pre>
   *
   * <code>bool keyword_searchable = 4;</code>
   *
   * @return The keywordSearchable.
   */
  @java.lang.Override
  public boolean getKeywordSearchable() {
    return keywordSearchable_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    for (int i = 0; i < stringValues_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, stringValues_.getRaw(i));
    }
    if (getLongValuesList().size() > 0) {
      output.writeUInt32NoTag(18);
      output.writeUInt32NoTag(longValuesMemoizedSerializedSize);
    }
    for (int i = 0; i < longValues_.size(); i++) {
      output.writeInt64NoTag(longValues_.getLong(i));
    }
    if (filterable_ != false) {
      output.writeBool(3, filterable_);
    }
    if (keywordSearchable_ != false) {
      output.writeBool(4, keywordSearchable_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < stringValues_.size(); i++) {
        dataSize += computeStringSizeNoTag(stringValues_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getStringValuesList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < longValues_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeInt64SizeNoTag(longValues_.getLong(i));
      }
      size += dataSize;
      if (!getLongValuesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
      }
      longValuesMemoizedSerializedSize = dataSize;
    }
    if (filterable_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, filterable_);
    }
    if (keywordSearchable_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, keywordSearchable_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.talent.v4.CustomAttribute)) {
      return super.equals(obj);
    }
    com.google.cloud.talent.v4.CustomAttribute other =
        (com.google.cloud.talent.v4.CustomAttribute) obj;

    if (!getStringValuesList().equals(other.getStringValuesList())) return false;
    if (!getLongValuesList().equals(other.getLongValuesList())) return false;
    if (getFilterable() != other.getFilterable()) return false;
    if (getKeywordSearchable() != other.getKeywordSearchable()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getStringValuesCount() > 0) {
      hash = (37 * hash) + STRING_VALUES_FIELD_NUMBER;
      hash = (53 * hash) + getStringValuesList().hashCode();
    }
    if (getLongValuesCount() > 0) {
      hash = (37 * hash) + LONG_VALUES_FIELD_NUMBER;
      hash = (53 * hash) + getLongValuesList().hashCode();
    }
    hash = (37 * hash) + FILTERABLE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getFilterable());
    hash = (37 * hash) + KEYWORD_SEARCHABLE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getKeywordSearchable());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.talent.v4.CustomAttribute parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.CustomAttribute parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.CustomAttribute parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.CustomAttribute parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.CustomAttribute parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.CustomAttribute parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.CustomAttribute parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.CustomAttribute parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.CustomAttribute parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.CustomAttribute parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.CustomAttribute parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.CustomAttribute parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.talent.v4.CustomAttribute prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Custom attribute values that are either filterable or non-filterable.
   * </pre>
   *
   * Protobuf type {@code google.cloud.talent.v4.CustomAttribute}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.talent.v4.CustomAttribute)
      com.google.cloud.talent.v4.CustomAttributeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.talent.v4.CommonProto
          .internal_static_google_cloud_talent_v4_CustomAttribute_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.talent.v4.CommonProto
          .internal_static_google_cloud_talent_v4_CustomAttribute_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.talent.v4.CustomAttribute.class,
              com.google.cloud.talent.v4.CustomAttribute.Builder.class);
    }

    // Construct using com.google.cloud.talent.v4.CustomAttribute.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      stringValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
      longValues_ = emptyLongList();
      filterable_ = false;
      keywordSearchable_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.talent.v4.CommonProto
          .internal_static_google_cloud_talent_v4_CustomAttribute_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.CustomAttribute getDefaultInstanceForType() {
      return com.google.cloud.talent.v4.CustomAttribute.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.CustomAttribute build() {
      com.google.cloud.talent.v4.CustomAttribute result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.CustomAttribute buildPartial() {
      com.google.cloud.talent.v4.CustomAttribute result =
          new com.google.cloud.talent.v4.CustomAttribute(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.talent.v4.CustomAttribute result) {
      if (((bitField0_ & 0x00000002) != 0)) {
        longValues_.makeImmutable();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.longValues_ = longValues_;
    }

    private void buildPartial0(com.google.cloud.talent.v4.CustomAttribute result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        stringValues_.makeImmutable();
        result.stringValues_ = stringValues_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.filterable_ = filterable_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.keywordSearchable_ = keywordSearchable_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.talent.v4.CustomAttribute) {
        return mergeFrom((com.google.cloud.talent.v4.CustomAttribute) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.talent.v4.CustomAttribute other) {
      if (other == com.google.cloud.talent.v4.CustomAttribute.getDefaultInstance()) return this;
      if (!other.stringValues_.isEmpty()) {
        if (stringValues_.isEmpty()) {
          stringValues_ = other.stringValues_;
          bitField0_ |= 0x00000001;
        } else {
          ensureStringValuesIsMutable();
          stringValues_.addAll(other.stringValues_);
        }
        onChanged();
      }
      if (!other.longValues_.isEmpty()) {
        if (longValues_.isEmpty()) {
          longValues_ = other.longValues_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensureLongValuesIsMutable();
          longValues_.addAll(other.longValues_);
        }
        onChanged();
      }
      if (other.getFilterable() != false) {
        setFilterable(other.getFilterable());
      }
      if (other.getKeywordSearchable() != false) {
        setKeywordSearchable(other.getKeywordSearchable());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureStringValuesIsMutable();
                stringValues_.add(s);
                break;
              } // case 10
            case 16:
              {
                long v = input.readInt64();
                ensureLongValuesIsMutable();
                longValues_.addLong(v);
                break;
              } // case 16
            case 18:
              {
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                ensureLongValuesIsMutable();
                while (input.getBytesUntilLimit() > 0) {
                  longValues_.addLong(input.readInt64());
                }
                input.popLimit(limit);
                break;
              } // case 18
            case 24:
              {
                filterable_ = input.readBool();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 32:
              {
                keywordSearchable_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList stringValues_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureStringValuesIsMutable() {
      if (!stringValues_.isModifiable()) {
        stringValues_ = new com.google.protobuf.LazyStringArrayList(stringValues_);
      }
      bitField0_ |= 0x00000001;
    }
    /**
     *
     *
     * <pre>
     * Exactly one of
     * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
     * specified.
     *
     * This field is used to perform a string match (`CASE_SENSITIVE_MATCH` or
     * `CASE_INSENSITIVE_MATCH`) search.
     * For filterable `string_value`s, a maximum total number of 200 values
     * is allowed, with each `string_value` has a byte size of no more than
     * 500B. For unfilterable `string_values`, the maximum total byte size of
     * unfilterable `string_values` is 50KB.
     *
     * Empty string isn't allowed.
     * </pre>
     *
     * <code>repeated string string_values = 1;</code>
     *
     * @return A list containing the stringValues.
     */
    public com.google.protobuf.ProtocolStringList getStringValuesList() {
      stringValues_.makeImmutable();
      return stringValues_;
    }
    /**
     *
     *
     * <pre>
     * Exactly one of
     * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
     * specified.
     *
     * This field is used to perform a string match (`CASE_SENSITIVE_MATCH` or
     * `CASE_INSENSITIVE_MATCH`) search.
     * For filterable `string_value`s, a maximum total number of 200 values
     * is allowed, with each `string_value` has a byte size of no more than
     * 500B. For unfilterable `string_values`, the maximum total byte size of
     * unfilterable `string_values` is 50KB.
     *
     * Empty string isn't allowed.
     * </pre>
     *
     * <code>repeated string string_values = 1;</code>
     *
     * @return The count of stringValues.
     */
    public int getStringValuesCount() {
      return stringValues_.size();
    }
    /**
     *
     *
     * <pre>
     * Exactly one of
     * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
     * specified.
     *
     * This field is used to perform a string match (`CASE_SENSITIVE_MATCH` or
     * `CASE_INSENSITIVE_MATCH`) search.
     * For filterable `string_value`s, a maximum total number of 200 values
     * is allowed, with each `string_value` has a byte size of no more than
     * 500B. For unfilterable `string_values`, the maximum total byte size of
     * unfilterable `string_values` is 50KB.
     *
     * Empty string isn't allowed.
     * </pre>
     *
     * <code>repeated string string_values = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The stringValues at the given index.
     */
    public java.lang.String getStringValues(int index) {
      return stringValues_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Exactly one of
     * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
     * specified.
     *
     * This field is used to perform a string match (`CASE_SENSITIVE_MATCH` or
     * `CASE_INSENSITIVE_MATCH`) search.
     * For filterable `string_value`s, a maximum total number of 200 values
     * is allowed, with each `string_value` has a byte size of no more than
     * 500B. For unfilterable `string_values`, the maximum total byte size of
     * unfilterable `string_values` is 50KB.
     *
     * Empty string isn't allowed.
     * </pre>
     *
     * <code>repeated string string_values = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the stringValues at the given index.
     */
    public com.google.protobuf.ByteString getStringValuesBytes(int index) {
      return stringValues_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Exactly one of
     * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
     * specified.
     *
     * This field is used to perform a string match (`CASE_SENSITIVE_MATCH` or
     * `CASE_INSENSITIVE_MATCH`) search.
     * For filterable `string_value`s, a maximum total number of 200 values
     * is allowed, with each `string_value` has a byte size of no more than
     * 500B. For unfilterable `string_values`, the maximum total byte size of
     * unfilterable `string_values` is 50KB.
     *
     * Empty string isn't allowed.
     * </pre>
     *
     * <code>repeated string string_values = 1;</code>
     *
     * @param index The index to set the value at.
     * @param value The stringValues to set.
     * @return This builder for chaining.
     */
    public Builder setStringValues(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStringValuesIsMutable();
      stringValues_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exactly one of
     * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
     * specified.
     *
     * This field is used to perform a string match (`CASE_SENSITIVE_MATCH` or
     * `CASE_INSENSITIVE_MATCH`) search.
     * For filterable `string_value`s, a maximum total number of 200 values
     * is allowed, with each `string_value` has a byte size of no more than
     * 500B. For unfilterable `string_values`, the maximum total byte size of
     * unfilterable `string_values` is 50KB.
     *
     * Empty string isn't allowed.
     * </pre>
     *
     * <code>repeated string string_values = 1;</code>
     *
     * @param value The stringValues to add.
     * @return This builder for chaining.
     */
    public Builder addStringValues(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureStringValuesIsMutable();
      stringValues_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exactly one of
     * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
     * specified.
     *
     * This field is used to perform a string match (`CASE_SENSITIVE_MATCH` or
     * `CASE_INSENSITIVE_MATCH`) search.
     * For filterable `string_value`s, a maximum total number of 200 values
     * is allowed, with each `string_value` has a byte size of no more than
     * 500B. For unfilterable `string_values`, the maximum total byte size of
     * unfilterable `string_values` is 50KB.
     *
     * Empty string isn't allowed.
     * </pre>
     *
     * <code>repeated string string_values = 1;</code>
     *
     * @param values The stringValues to add.
     * @return This builder for chaining.
     */
    public Builder addAllStringValues(java.lang.Iterable<java.lang.String> values) {
      ensureStringValuesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, stringValues_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exactly one of
     * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
     * specified.
     *
     * This field is used to perform a string match (`CASE_SENSITIVE_MATCH` or
     * `CASE_INSENSITIVE_MATCH`) search.
     * For filterable `string_value`s, a maximum total number of 200 values
     * is allowed, with each `string_value` has a byte size of no more than
     * 500B. For unfilterable `string_values`, the maximum total byte size of
     * unfilterable `string_values` is 50KB.
     *
     * Empty string isn't allowed.
     * </pre>
     *
     * <code>repeated string string_values = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStringValues() {
      stringValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exactly one of
     * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
     * specified.
     *
     * This field is used to perform a string match (`CASE_SENSITIVE_MATCH` or
     * `CASE_INSENSITIVE_MATCH`) search.
     * For filterable `string_value`s, a maximum total number of 200 values
     * is allowed, with each `string_value` has a byte size of no more than
     * 500B. For unfilterable `string_values`, the maximum total byte size of
     * unfilterable `string_values` is 50KB.
     *
     * Empty string isn't allowed.
     * </pre>
     *
     * <code>repeated string string_values = 1;</code>
     *
     * @param value The bytes of the stringValues to add.
     * @return This builder for chaining.
     */
    public Builder addStringValuesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureStringValuesIsMutable();
      stringValues_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Internal.LongList longValues_ = emptyLongList();

    private void ensureLongValuesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        longValues_ = mutableCopy(longValues_);
        bitField0_ |= 0x00000002;
      }
    }
    /**
     *
     *
     * <pre>
     * Exactly one of
     * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
     * specified.
     *
     * This field is used to perform number range search.
     * (`EQ`, `GT`, `GE`, `LE`, `LT`) over filterable `long_value`.
     *
     * Currently at most 1
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] is
     * supported.
     * </pre>
     *
     * <code>repeated int64 long_values = 2;</code>
     *
     * @return A list containing the longValues.
     */
    public java.util.List<java.lang.Long> getLongValuesList() {
      return ((bitField0_ & 0x00000002) != 0)
          ? java.util.Collections.unmodifiableList(longValues_)
          : longValues_;
    }
    /**
     *
     *
     * <pre>
     * Exactly one of
     * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
     * specified.
     *
     * This field is used to perform number range search.
     * (`EQ`, `GT`, `GE`, `LE`, `LT`) over filterable `long_value`.
     *
     * Currently at most 1
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] is
     * supported.
     * </pre>
     *
     * <code>repeated int64 long_values = 2;</code>
     *
     * @return The count of longValues.
     */
    public int getLongValuesCount() {
      return longValues_.size();
    }
    /**
     *
     *
     * <pre>
     * Exactly one of
     * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
     * specified.
     *
     * This field is used to perform number range search.
     * (`EQ`, `GT`, `GE`, `LE`, `LT`) over filterable `long_value`.
     *
     * Currently at most 1
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] is
     * supported.
     * </pre>
     *
     * <code>repeated int64 long_values = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The longValues at the given index.
     */
    public long getLongValues(int index) {
      return longValues_.getLong(index);
    }
    /**
     *
     *
     * <pre>
     * Exactly one of
     * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
     * specified.
     *
     * This field is used to perform number range search.
     * (`EQ`, `GT`, `GE`, `LE`, `LT`) over filterable `long_value`.
     *
     * Currently at most 1
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] is
     * supported.
     * </pre>
     *
     * <code>repeated int64 long_values = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The longValues to set.
     * @return This builder for chaining.
     */
    public Builder setLongValues(int index, long value) {

      ensureLongValuesIsMutable();
      longValues_.setLong(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exactly one of
     * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
     * specified.
     *
     * This field is used to perform number range search.
     * (`EQ`, `GT`, `GE`, `LE`, `LT`) over filterable `long_value`.
     *
     * Currently at most 1
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] is
     * supported.
     * </pre>
     *
     * <code>repeated int64 long_values = 2;</code>
     *
     * @param value The longValues to add.
     * @return This builder for chaining.
     */
    public Builder addLongValues(long value) {

      ensureLongValuesIsMutable();
      longValues_.addLong(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exactly one of
     * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
     * specified.
     *
     * This field is used to perform number range search.
     * (`EQ`, `GT`, `GE`, `LE`, `LT`) over filterable `long_value`.
     *
     * Currently at most 1
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] is
     * supported.
     * </pre>
     *
     * <code>repeated int64 long_values = 2;</code>
     *
     * @param values The longValues to add.
     * @return This builder for chaining.
     */
    public Builder addAllLongValues(java.lang.Iterable<? extends java.lang.Long> values) {
      ensureLongValuesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, longValues_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Exactly one of
     * [string_values][google.cloud.talent.v4.CustomAttribute.string_values] or
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] must be
     * specified.
     *
     * This field is used to perform number range search.
     * (`EQ`, `GT`, `GE`, `LE`, `LT`) over filterable `long_value`.
     *
     * Currently at most 1
     * [long_values][google.cloud.talent.v4.CustomAttribute.long_values] is
     * supported.
     * </pre>
     *
     * <code>repeated int64 long_values = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLongValues() {
      longValues_ = emptyLongList();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    private boolean filterable_;
    /**
     *
     *
     * <pre>
     * If the `filterable` flag is true, the custom field values may be used for
     * custom attribute filters
     * [JobQuery.custom_attribute_filter][google.cloud.talent.v4.JobQuery.custom_attribute_filter].
     * If false, these values may not be used for custom attribute filters.
     *
     * Default is false.
     * </pre>
     *
     * <code>bool filterable = 3;</code>
     *
     * @return The filterable.
     */
    @java.lang.Override
    public boolean getFilterable() {
      return filterable_;
    }
    /**
     *
     *
     * <pre>
     * If the `filterable` flag is true, the custom field values may be used for
     * custom attribute filters
     * [JobQuery.custom_attribute_filter][google.cloud.talent.v4.JobQuery.custom_attribute_filter].
     * If false, these values may not be used for custom attribute filters.
     *
     * Default is false.
     * </pre>
     *
     * <code>bool filterable = 3;</code>
     *
     * @param value The filterable to set.
     * @return This builder for chaining.
     */
    public Builder setFilterable(boolean value) {

      filterable_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the `filterable` flag is true, the custom field values may be used for
     * custom attribute filters
     * [JobQuery.custom_attribute_filter][google.cloud.talent.v4.JobQuery.custom_attribute_filter].
     * If false, these values may not be used for custom attribute filters.
     *
     * Default is false.
     * </pre>
     *
     * <code>bool filterable = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilterable() {
      bitField0_ = (bitField0_ & ~0x00000004);
      filterable_ = false;
      onChanged();
      return this;
    }

    private boolean keywordSearchable_;
    /**
     *
     *
     * <pre>
     * If the `keyword_searchable` flag is true, the keywords in custom fields are
     * searchable by keyword match.
     * If false, the values are not searchable by keyword match.
     *
     * Default is false.
     * </pre>
     *
     * <code>bool keyword_searchable = 4;</code>
     *
     * @return The keywordSearchable.
     */
    @java.lang.Override
    public boolean getKeywordSearchable() {
      return keywordSearchable_;
    }
    /**
     *
     *
     * <pre>
     * If the `keyword_searchable` flag is true, the keywords in custom fields are
     * searchable by keyword match.
     * If false, the values are not searchable by keyword match.
     *
     * Default is false.
     * </pre>
     *
     * <code>bool keyword_searchable = 4;</code>
     *
     * @param value The keywordSearchable to set.
     * @return This builder for chaining.
     */
    public Builder setKeywordSearchable(boolean value) {

      keywordSearchable_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If the `keyword_searchable` flag is true, the keywords in custom fields are
     * searchable by keyword match.
     * If false, the values are not searchable by keyword match.
     *
     * Default is false.
     * </pre>
     *
     * <code>bool keyword_searchable = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKeywordSearchable() {
      bitField0_ = (bitField0_ & ~0x00000008);
      keywordSearchable_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.talent.v4.CustomAttribute)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.talent.v4.CustomAttribute)
  private static final com.google.cloud.talent.v4.CustomAttribute DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.talent.v4.CustomAttribute();
  }

  public static com.google.cloud.talent.v4.CustomAttribute getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CustomAttribute> PARSER =
      new com.google.protobuf.AbstractParser<CustomAttribute>() {
        @java.lang.Override
        public CustomAttribute parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CustomAttribute> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CustomAttribute> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.talent.v4.CustomAttribute getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
