/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/talent/v4/job.proto

package com.google.cloud.talent.v4;

/**
 *
 *
 * <pre>
 * A Job resource represents a job posting (also referred to as a "job listing"
 * or "job requisition"). A job belongs to a
 * [Company][google.cloud.talent.v4.Company], which is the hiring entity
 * responsible for the job.
 * </pre>
 *
 * Protobuf type {@code google.cloud.talent.v4.Job}
 */
public final class Job extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.talent.v4.Job)
    JobOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Job.newBuilder() to construct.
  private Job(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Job() {
    name_ = "";
    company_ = "";
    requisitionId_ = "";
    title_ = "";
    description_ = "";
    addresses_ = com.google.protobuf.LazyStringArrayList.emptyList();
    jobBenefits_ = java.util.Collections.emptyList();
    degreeTypes_ = java.util.Collections.emptyList();
    department_ = "";
    employmentTypes_ = java.util.Collections.emptyList();
    incentives_ = "";
    languageCode_ = "";
    jobLevel_ = 0;
    qualifications_ = "";
    responsibilities_ = "";
    postingRegion_ = 0;
    visibility_ = 0;
    companyDisplayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Job();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.talent.v4.JobProto
        .internal_static_google_cloud_talent_v4_Job_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 10:
        return internalGetCustomAttributes();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.talent.v4.JobProto
        .internal_static_google_cloud_talent_v4_Job_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.talent.v4.Job.class, com.google.cloud.talent.v4.Job.Builder.class);
  }

  public interface ApplicationInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.talent.v4.Job.ApplicationInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Use this field to specify email address(es) to which resumes or
     * applications can be sent.
     *
     * The maximum number of allowed characters for each entry is 255.
     * </pre>
     *
     * <code>repeated string emails = 1;</code>
     *
     * @return A list containing the emails.
     */
    java.util.List<java.lang.String> getEmailsList();
    /**
     *
     *
     * <pre>
     * Use this field to specify email address(es) to which resumes or
     * applications can be sent.
     *
     * The maximum number of allowed characters for each entry is 255.
     * </pre>
     *
     * <code>repeated string emails = 1;</code>
     *
     * @return The count of emails.
     */
    int getEmailsCount();
    /**
     *
     *
     * <pre>
     * Use this field to specify email address(es) to which resumes or
     * applications can be sent.
     *
     * The maximum number of allowed characters for each entry is 255.
     * </pre>
     *
     * <code>repeated string emails = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The emails at the given index.
     */
    java.lang.String getEmails(int index);
    /**
     *
     *
     * <pre>
     * Use this field to specify email address(es) to which resumes or
     * applications can be sent.
     *
     * The maximum number of allowed characters for each entry is 255.
     * </pre>
     *
     * <code>repeated string emails = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the emails at the given index.
     */
    com.google.protobuf.ByteString getEmailsBytes(int index);

    /**
     *
     *
     * <pre>
     * Use this field to provide instructions, such as "Mail your application
     * to ...", that a candidate can follow to apply for the job.
     *
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     *
     * The maximum number of allowed characters is 3,000.
     * </pre>
     *
     * <code>string instruction = 2;</code>
     *
     * @return The instruction.
     */
    java.lang.String getInstruction();
    /**
     *
     *
     * <pre>
     * Use this field to provide instructions, such as "Mail your application
     * to ...", that a candidate can follow to apply for the job.
     *
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     *
     * The maximum number of allowed characters is 3,000.
     * </pre>
     *
     * <code>string instruction = 2;</code>
     *
     * @return The bytes for instruction.
     */
    com.google.protobuf.ByteString getInstructionBytes();

    /**
     *
     *
     * <pre>
     * Use this URI field to direct an applicant to a website, for example to
     * link to an online application form.
     *
     * The maximum number of allowed characters for each entry is 2,000.
     * </pre>
     *
     * <code>repeated string uris = 3;</code>
     *
     * @return A list containing the uris.
     */
    java.util.List<java.lang.String> getUrisList();
    /**
     *
     *
     * <pre>
     * Use this URI field to direct an applicant to a website, for example to
     * link to an online application form.
     *
     * The maximum number of allowed characters for each entry is 2,000.
     * </pre>
     *
     * <code>repeated string uris = 3;</code>
     *
     * @return The count of uris.
     */
    int getUrisCount();
    /**
     *
     *
     * <pre>
     * Use this URI field to direct an applicant to a website, for example to
     * link to an online application form.
     *
     * The maximum number of allowed characters for each entry is 2,000.
     * </pre>
     *
     * <code>repeated string uris = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The uris at the given index.
     */
    java.lang.String getUris(int index);
    /**
     *
     *
     * <pre>
     * Use this URI field to direct an applicant to a website, for example to
     * link to an online application form.
     *
     * The maximum number of allowed characters for each entry is 2,000.
     * </pre>
     *
     * <code>repeated string uris = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the uris at the given index.
     */
    com.google.protobuf.ByteString getUrisBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * Application related details of a job posting.
   * </pre>
   *
   * Protobuf type {@code google.cloud.talent.v4.Job.ApplicationInfo}
   */
  public static final class ApplicationInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.talent.v4.Job.ApplicationInfo)
      ApplicationInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ApplicationInfo.newBuilder() to construct.
    private ApplicationInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ApplicationInfo() {
      emails_ = com.google.protobuf.LazyStringArrayList.emptyList();
      instruction_ = "";
      uris_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ApplicationInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.talent.v4.JobProto
          .internal_static_google_cloud_talent_v4_Job_ApplicationInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.talent.v4.JobProto
          .internal_static_google_cloud_talent_v4_Job_ApplicationInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.talent.v4.Job.ApplicationInfo.class,
              com.google.cloud.talent.v4.Job.ApplicationInfo.Builder.class);
    }

    public static final int EMAILS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList emails_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Use this field to specify email address(es) to which resumes or
     * applications can be sent.
     *
     * The maximum number of allowed characters for each entry is 255.
     * </pre>
     *
     * <code>repeated string emails = 1;</code>
     *
     * @return A list containing the emails.
     */
    public com.google.protobuf.ProtocolStringList getEmailsList() {
      return emails_;
    }
    /**
     *
     *
     * <pre>
     * Use this field to specify email address(es) to which resumes or
     * applications can be sent.
     *
     * The maximum number of allowed characters for each entry is 255.
     * </pre>
     *
     * <code>repeated string emails = 1;</code>
     *
     * @return The count of emails.
     */
    public int getEmailsCount() {
      return emails_.size();
    }
    /**
     *
     *
     * <pre>
     * Use this field to specify email address(es) to which resumes or
     * applications can be sent.
     *
     * The maximum number of allowed characters for each entry is 255.
     * </pre>
     *
     * <code>repeated string emails = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The emails at the given index.
     */
    public java.lang.String getEmails(int index) {
      return emails_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Use this field to specify email address(es) to which resumes or
     * applications can be sent.
     *
     * The maximum number of allowed characters for each entry is 255.
     * </pre>
     *
     * <code>repeated string emails = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the emails at the given index.
     */
    public com.google.protobuf.ByteString getEmailsBytes(int index) {
      return emails_.getByteString(index);
    }

    public static final int INSTRUCTION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object instruction_ = "";
    /**
     *
     *
     * <pre>
     * Use this field to provide instructions, such as "Mail your application
     * to ...", that a candidate can follow to apply for the job.
     *
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     *
     * The maximum number of allowed characters is 3,000.
     * </pre>
     *
     * <code>string instruction = 2;</code>
     *
     * @return The instruction.
     */
    @java.lang.Override
    public java.lang.String getInstruction() {
      java.lang.Object ref = instruction_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instruction_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Use this field to provide instructions, such as "Mail your application
     * to ...", that a candidate can follow to apply for the job.
     *
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     *
     * The maximum number of allowed characters is 3,000.
     * </pre>
     *
     * <code>string instruction = 2;</code>
     *
     * @return The bytes for instruction.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getInstructionBytes() {
      java.lang.Object ref = instruction_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instruction_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int URIS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList uris_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    /**
     *
     *
     * <pre>
     * Use this URI field to direct an applicant to a website, for example to
     * link to an online application form.
     *
     * The maximum number of allowed characters for each entry is 2,000.
     * </pre>
     *
     * <code>repeated string uris = 3;</code>
     *
     * @return A list containing the uris.
     */
    public com.google.protobuf.ProtocolStringList getUrisList() {
      return uris_;
    }
    /**
     *
     *
     * <pre>
     * Use this URI field to direct an applicant to a website, for example to
     * link to an online application form.
     *
     * The maximum number of allowed characters for each entry is 2,000.
     * </pre>
     *
     * <code>repeated string uris = 3;</code>
     *
     * @return The count of uris.
     */
    public int getUrisCount() {
      return uris_.size();
    }
    /**
     *
     *
     * <pre>
     * Use this URI field to direct an applicant to a website, for example to
     * link to an online application form.
     *
     * The maximum number of allowed characters for each entry is 2,000.
     * </pre>
     *
     * <code>repeated string uris = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The uris at the given index.
     */
    public java.lang.String getUris(int index) {
      return uris_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Use this URI field to direct an applicant to a website, for example to
     * link to an online application form.
     *
     * The maximum number of allowed characters for each entry is 2,000.
     * </pre>
     *
     * <code>repeated string uris = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the uris at the given index.
     */
    public com.google.protobuf.ByteString getUrisBytes(int index) {
      return uris_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < emails_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, emails_.getRaw(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instruction_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, instruction_);
      }
      for (int i = 0; i < uris_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, uris_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < emails_.size(); i++) {
          dataSize += computeStringSizeNoTag(emails_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getEmailsList().size();
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(instruction_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, instruction_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < uris_.size(); i++) {
          dataSize += computeStringSizeNoTag(uris_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getUrisList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.talent.v4.Job.ApplicationInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.talent.v4.Job.ApplicationInfo other =
          (com.google.cloud.talent.v4.Job.ApplicationInfo) obj;

      if (!getEmailsList().equals(other.getEmailsList())) return false;
      if (!getInstruction().equals(other.getInstruction())) return false;
      if (!getUrisList().equals(other.getUrisList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getEmailsCount() > 0) {
        hash = (37 * hash) + EMAILS_FIELD_NUMBER;
        hash = (53 * hash) + getEmailsList().hashCode();
      }
      hash = (37 * hash) + INSTRUCTION_FIELD_NUMBER;
      hash = (53 * hash) + getInstruction().hashCode();
      if (getUrisCount() > 0) {
        hash = (37 * hash) + URIS_FIELD_NUMBER;
        hash = (53 * hash) + getUrisList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.talent.v4.Job.ApplicationInfo parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.Job.ApplicationInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.Job.ApplicationInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.Job.ApplicationInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.Job.ApplicationInfo parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.Job.ApplicationInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.Job.ApplicationInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.Job.ApplicationInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.Job.ApplicationInfo parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.Job.ApplicationInfo parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.Job.ApplicationInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.Job.ApplicationInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.talent.v4.Job.ApplicationInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Application related details of a job posting.
     * </pre>
     *
     * Protobuf type {@code google.cloud.talent.v4.Job.ApplicationInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.talent.v4.Job.ApplicationInfo)
        com.google.cloud.talent.v4.Job.ApplicationInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.talent.v4.JobProto
            .internal_static_google_cloud_talent_v4_Job_ApplicationInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.talent.v4.JobProto
            .internal_static_google_cloud_talent_v4_Job_ApplicationInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.talent.v4.Job.ApplicationInfo.class,
                com.google.cloud.talent.v4.Job.ApplicationInfo.Builder.class);
      }

      // Construct using com.google.cloud.talent.v4.Job.ApplicationInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        emails_ = com.google.protobuf.LazyStringArrayList.emptyList();
        instruction_ = "";
        uris_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.talent.v4.JobProto
            .internal_static_google_cloud_talent_v4_Job_ApplicationInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.Job.ApplicationInfo getDefaultInstanceForType() {
        return com.google.cloud.talent.v4.Job.ApplicationInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.Job.ApplicationInfo build() {
        com.google.cloud.talent.v4.Job.ApplicationInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.Job.ApplicationInfo buildPartial() {
        com.google.cloud.talent.v4.Job.ApplicationInfo result =
            new com.google.cloud.talent.v4.Job.ApplicationInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.talent.v4.Job.ApplicationInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          emails_.makeImmutable();
          result.emails_ = emails_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.instruction_ = instruction_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          uris_.makeImmutable();
          result.uris_ = uris_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.talent.v4.Job.ApplicationInfo) {
          return mergeFrom((com.google.cloud.talent.v4.Job.ApplicationInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.talent.v4.Job.ApplicationInfo other) {
        if (other == com.google.cloud.talent.v4.Job.ApplicationInfo.getDefaultInstance())
          return this;
        if (!other.emails_.isEmpty()) {
          if (emails_.isEmpty()) {
            emails_ = other.emails_;
            bitField0_ |= 0x00000001;
          } else {
            ensureEmailsIsMutable();
            emails_.addAll(other.emails_);
          }
          onChanged();
        }
        if (!other.getInstruction().isEmpty()) {
          instruction_ = other.instruction_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.uris_.isEmpty()) {
          if (uris_.isEmpty()) {
            uris_ = other.uris_;
            bitField0_ |= 0x00000004;
          } else {
            ensureUrisIsMutable();
            uris_.addAll(other.uris_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureEmailsIsMutable();
                  emails_.add(s);
                  break;
                } // case 10
              case 18:
                {
                  instruction_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureUrisIsMutable();
                  uris_.add(s);
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList emails_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureEmailsIsMutable() {
        if (!emails_.isModifiable()) {
          emails_ = new com.google.protobuf.LazyStringArrayList(emails_);
        }
        bitField0_ |= 0x00000001;
      }
      /**
       *
       *
       * <pre>
       * Use this field to specify email address(es) to which resumes or
       * applications can be sent.
       *
       * The maximum number of allowed characters for each entry is 255.
       * </pre>
       *
       * <code>repeated string emails = 1;</code>
       *
       * @return A list containing the emails.
       */
      public com.google.protobuf.ProtocolStringList getEmailsList() {
        emails_.makeImmutable();
        return emails_;
      }
      /**
       *
       *
       * <pre>
       * Use this field to specify email address(es) to which resumes or
       * applications can be sent.
       *
       * The maximum number of allowed characters for each entry is 255.
       * </pre>
       *
       * <code>repeated string emails = 1;</code>
       *
       * @return The count of emails.
       */
      public int getEmailsCount() {
        return emails_.size();
      }
      /**
       *
       *
       * <pre>
       * Use this field to specify email address(es) to which resumes or
       * applications can be sent.
       *
       * The maximum number of allowed characters for each entry is 255.
       * </pre>
       *
       * <code>repeated string emails = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The emails at the given index.
       */
      public java.lang.String getEmails(int index) {
        return emails_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Use this field to specify email address(es) to which resumes or
       * applications can be sent.
       *
       * The maximum number of allowed characters for each entry is 255.
       * </pre>
       *
       * <code>repeated string emails = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the emails at the given index.
       */
      public com.google.protobuf.ByteString getEmailsBytes(int index) {
        return emails_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Use this field to specify email address(es) to which resumes or
       * applications can be sent.
       *
       * The maximum number of allowed characters for each entry is 255.
       * </pre>
       *
       * <code>repeated string emails = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The emails to set.
       * @return This builder for chaining.
       */
      public Builder setEmails(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEmailsIsMutable();
        emails_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Use this field to specify email address(es) to which resumes or
       * applications can be sent.
       *
       * The maximum number of allowed characters for each entry is 255.
       * </pre>
       *
       * <code>repeated string emails = 1;</code>
       *
       * @param value The emails to add.
       * @return This builder for chaining.
       */
      public Builder addEmails(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEmailsIsMutable();
        emails_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Use this field to specify email address(es) to which resumes or
       * applications can be sent.
       *
       * The maximum number of allowed characters for each entry is 255.
       * </pre>
       *
       * <code>repeated string emails = 1;</code>
       *
       * @param values The emails to add.
       * @return This builder for chaining.
       */
      public Builder addAllEmails(java.lang.Iterable<java.lang.String> values) {
        ensureEmailsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, emails_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Use this field to specify email address(es) to which resumes or
       * applications can be sent.
       *
       * The maximum number of allowed characters for each entry is 255.
       * </pre>
       *
       * <code>repeated string emails = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEmails() {
        emails_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Use this field to specify email address(es) to which resumes or
       * applications can be sent.
       *
       * The maximum number of allowed characters for each entry is 255.
       * </pre>
       *
       * <code>repeated string emails = 1;</code>
       *
       * @param value The bytes of the emails to add.
       * @return This builder for chaining.
       */
      public Builder addEmailsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureEmailsIsMutable();
        emails_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object instruction_ = "";
      /**
       *
       *
       * <pre>
       * Use this field to provide instructions, such as "Mail your application
       * to ...", that a candidate can follow to apply for the job.
       *
       * This field accepts and sanitizes HTML input, and also accepts
       * bold, italic, ordered list, and unordered list markup tags.
       *
       * The maximum number of allowed characters is 3,000.
       * </pre>
       *
       * <code>string instruction = 2;</code>
       *
       * @return The instruction.
       */
      public java.lang.String getInstruction() {
        java.lang.Object ref = instruction_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          instruction_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Use this field to provide instructions, such as "Mail your application
       * to ...", that a candidate can follow to apply for the job.
       *
       * This field accepts and sanitizes HTML input, and also accepts
       * bold, italic, ordered list, and unordered list markup tags.
       *
       * The maximum number of allowed characters is 3,000.
       * </pre>
       *
       * <code>string instruction = 2;</code>
       *
       * @return The bytes for instruction.
       */
      public com.google.protobuf.ByteString getInstructionBytes() {
        java.lang.Object ref = instruction_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          instruction_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Use this field to provide instructions, such as "Mail your application
       * to ...", that a candidate can follow to apply for the job.
       *
       * This field accepts and sanitizes HTML input, and also accepts
       * bold, italic, ordered list, and unordered list markup tags.
       *
       * The maximum number of allowed characters is 3,000.
       * </pre>
       *
       * <code>string instruction = 2;</code>
       *
       * @param value The instruction to set.
       * @return This builder for chaining.
       */
      public Builder setInstruction(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        instruction_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Use this field to provide instructions, such as "Mail your application
       * to ...", that a candidate can follow to apply for the job.
       *
       * This field accepts and sanitizes HTML input, and also accepts
       * bold, italic, ordered list, and unordered list markup tags.
       *
       * The maximum number of allowed characters is 3,000.
       * </pre>
       *
       * <code>string instruction = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearInstruction() {
        instruction_ = getDefaultInstance().getInstruction();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Use this field to provide instructions, such as "Mail your application
       * to ...", that a candidate can follow to apply for the job.
       *
       * This field accepts and sanitizes HTML input, and also accepts
       * bold, italic, ordered list, and unordered list markup tags.
       *
       * The maximum number of allowed characters is 3,000.
       * </pre>
       *
       * <code>string instruction = 2;</code>
       *
       * @param value The bytes for instruction to set.
       * @return This builder for chaining.
       */
      public Builder setInstructionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        instruction_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList uris_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureUrisIsMutable() {
        if (!uris_.isModifiable()) {
          uris_ = new com.google.protobuf.LazyStringArrayList(uris_);
        }
        bitField0_ |= 0x00000004;
      }
      /**
       *
       *
       * <pre>
       * Use this URI field to direct an applicant to a website, for example to
       * link to an online application form.
       *
       * The maximum number of allowed characters for each entry is 2,000.
       * </pre>
       *
       * <code>repeated string uris = 3;</code>
       *
       * @return A list containing the uris.
       */
      public com.google.protobuf.ProtocolStringList getUrisList() {
        uris_.makeImmutable();
        return uris_;
      }
      /**
       *
       *
       * <pre>
       * Use this URI field to direct an applicant to a website, for example to
       * link to an online application form.
       *
       * The maximum number of allowed characters for each entry is 2,000.
       * </pre>
       *
       * <code>repeated string uris = 3;</code>
       *
       * @return The count of uris.
       */
      public int getUrisCount() {
        return uris_.size();
      }
      /**
       *
       *
       * <pre>
       * Use this URI field to direct an applicant to a website, for example to
       * link to an online application form.
       *
       * The maximum number of allowed characters for each entry is 2,000.
       * </pre>
       *
       * <code>repeated string uris = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The uris at the given index.
       */
      public java.lang.String getUris(int index) {
        return uris_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Use this URI field to direct an applicant to a website, for example to
       * link to an online application form.
       *
       * The maximum number of allowed characters for each entry is 2,000.
       * </pre>
       *
       * <code>repeated string uris = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the uris at the given index.
       */
      public com.google.protobuf.ByteString getUrisBytes(int index) {
        return uris_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Use this URI field to direct an applicant to a website, for example to
       * link to an online application form.
       *
       * The maximum number of allowed characters for each entry is 2,000.
       * </pre>
       *
       * <code>repeated string uris = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The uris to set.
       * @return This builder for chaining.
       */
      public Builder setUris(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUrisIsMutable();
        uris_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Use this URI field to direct an applicant to a website, for example to
       * link to an online application form.
       *
       * The maximum number of allowed characters for each entry is 2,000.
       * </pre>
       *
       * <code>repeated string uris = 3;</code>
       *
       * @param value The uris to add.
       * @return This builder for chaining.
       */
      public Builder addUris(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureUrisIsMutable();
        uris_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Use this URI field to direct an applicant to a website, for example to
       * link to an online application form.
       *
       * The maximum number of allowed characters for each entry is 2,000.
       * </pre>
       *
       * <code>repeated string uris = 3;</code>
       *
       * @param values The uris to add.
       * @return This builder for chaining.
       */
      public Builder addAllUris(java.lang.Iterable<java.lang.String> values) {
        ensureUrisIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, uris_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Use this URI field to direct an applicant to a website, for example to
       * link to an online application form.
       *
       * The maximum number of allowed characters for each entry is 2,000.
       * </pre>
       *
       * <code>repeated string uris = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUris() {
        uris_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Use this URI field to direct an applicant to a website, for example to
       * link to an online application form.
       *
       * The maximum number of allowed characters for each entry is 2,000.
       * </pre>
       *
       * <code>repeated string uris = 3;</code>
       *
       * @param value The bytes of the uris to add.
       * @return This builder for chaining.
       */
      public Builder addUrisBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureUrisIsMutable();
        uris_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.talent.v4.Job.ApplicationInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.talent.v4.Job.ApplicationInfo)
    private static final com.google.cloud.talent.v4.Job.ApplicationInfo DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.talent.v4.Job.ApplicationInfo();
    }

    public static com.google.cloud.talent.v4.Job.ApplicationInfo getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ApplicationInfo> PARSER =
        new com.google.protobuf.AbstractParser<ApplicationInfo>() {
          @java.lang.Override
          public ApplicationInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ApplicationInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ApplicationInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.Job.ApplicationInfo getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DerivedInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.talent.v4.Job.DerivedInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Structured locations of the job, resolved from
     * [Job.addresses][google.cloud.talent.v4.Job.addresses].
     *
     * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
     * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
     * same order.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
     */
    java.util.List<com.google.cloud.talent.v4.Location> getLocationsList();
    /**
     *
     *
     * <pre>
     * Structured locations of the job, resolved from
     * [Job.addresses][google.cloud.talent.v4.Job.addresses].
     *
     * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
     * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
     * same order.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
     */
    com.google.cloud.talent.v4.Location getLocations(int index);
    /**
     *
     *
     * <pre>
     * Structured locations of the job, resolved from
     * [Job.addresses][google.cloud.talent.v4.Job.addresses].
     *
     * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
     * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
     * same order.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
     */
    int getLocationsCount();
    /**
     *
     *
     * <pre>
     * Structured locations of the job, resolved from
     * [Job.addresses][google.cloud.talent.v4.Job.addresses].
     *
     * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
     * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
     * same order.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
     */
    java.util.List<? extends com.google.cloud.talent.v4.LocationOrBuilder>
        getLocationsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Structured locations of the job, resolved from
     * [Job.addresses][google.cloud.talent.v4.Job.addresses].
     *
     * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
     * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
     * same order.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
     */
    com.google.cloud.talent.v4.LocationOrBuilder getLocationsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Job categories derived from [Job.title][google.cloud.talent.v4.Job.title]
     * and [Job.description][google.cloud.talent.v4.Job.description].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 3;</code>
     *
     * @return A list containing the jobCategories.
     */
    java.util.List<com.google.cloud.talent.v4.JobCategory> getJobCategoriesList();
    /**
     *
     *
     * <pre>
     * Job categories derived from [Job.title][google.cloud.talent.v4.Job.title]
     * and [Job.description][google.cloud.talent.v4.Job.description].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 3;</code>
     *
     * @return The count of jobCategories.
     */
    int getJobCategoriesCount();
    /**
     *
     *
     * <pre>
     * Job categories derived from [Job.title][google.cloud.talent.v4.Job.title]
     * and [Job.description][google.cloud.talent.v4.Job.description].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The jobCategories at the given index.
     */
    com.google.cloud.talent.v4.JobCategory getJobCategories(int index);
    /**
     *
     *
     * <pre>
     * Job categories derived from [Job.title][google.cloud.talent.v4.Job.title]
     * and [Job.description][google.cloud.talent.v4.Job.description].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 3;</code>
     *
     * @return A list containing the enum numeric values on the wire for jobCategories.
     */
    java.util.List<java.lang.Integer> getJobCategoriesValueList();
    /**
     *
     *
     * <pre>
     * Job categories derived from [Job.title][google.cloud.talent.v4.Job.title]
     * and [Job.description][google.cloud.talent.v4.Job.description].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of jobCategories at the given index.
     */
    int getJobCategoriesValue(int index);
  }
  /**
   *
   *
   * <pre>
   * Derived details about the job posting.
   * </pre>
   *
   * Protobuf type {@code google.cloud.talent.v4.Job.DerivedInfo}
   */
  public static final class DerivedInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.talent.v4.Job.DerivedInfo)
      DerivedInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DerivedInfo.newBuilder() to construct.
    private DerivedInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DerivedInfo() {
      locations_ = java.util.Collections.emptyList();
      jobCategories_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DerivedInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.talent.v4.JobProto
          .internal_static_google_cloud_talent_v4_Job_DerivedInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.talent.v4.JobProto
          .internal_static_google_cloud_talent_v4_Job_DerivedInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.talent.v4.Job.DerivedInfo.class,
              com.google.cloud.talent.v4.Job.DerivedInfo.Builder.class);
    }

    public static final int LOCATIONS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.talent.v4.Location> locations_;
    /**
     *
     *
     * <pre>
     * Structured locations of the job, resolved from
     * [Job.addresses][google.cloud.talent.v4.Job.addresses].
     *
     * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
     * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
     * same order.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.talent.v4.Location> getLocationsList() {
      return locations_;
    }
    /**
     *
     *
     * <pre>
     * Structured locations of the job, resolved from
     * [Job.addresses][google.cloud.talent.v4.Job.addresses].
     *
     * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
     * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
     * same order.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.talent.v4.LocationOrBuilder>
        getLocationsOrBuilderList() {
      return locations_;
    }
    /**
     *
     *
     * <pre>
     * Structured locations of the job, resolved from
     * [Job.addresses][google.cloud.talent.v4.Job.addresses].
     *
     * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
     * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
     * same order.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
     */
    @java.lang.Override
    public int getLocationsCount() {
      return locations_.size();
    }
    /**
     *
     *
     * <pre>
     * Structured locations of the job, resolved from
     * [Job.addresses][google.cloud.talent.v4.Job.addresses].
     *
     * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
     * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
     * same order.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.Location getLocations(int index) {
      return locations_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Structured locations of the job, resolved from
     * [Job.addresses][google.cloud.talent.v4.Job.addresses].
     *
     * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
     * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
     * same order.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.LocationOrBuilder getLocationsOrBuilder(int index) {
      return locations_.get(index);
    }

    public static final int JOB_CATEGORIES_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private java.util.List<java.lang.Integer> jobCategories_;

    private static final com.google.protobuf.Internal.ListAdapter.Converter<
            java.lang.Integer, com.google.cloud.talent.v4.JobCategory>
        jobCategories_converter_ =
            new com.google.protobuf.Internal.ListAdapter.Converter<
                java.lang.Integer, com.google.cloud.talent.v4.JobCategory>() {
              public com.google.cloud.talent.v4.JobCategory convert(java.lang.Integer from) {
                com.google.cloud.talent.v4.JobCategory result =
                    com.google.cloud.talent.v4.JobCategory.forNumber(from);
                return result == null
                    ? com.google.cloud.talent.v4.JobCategory.UNRECOGNIZED
                    : result;
              }
            };
    /**
     *
     *
     * <pre>
     * Job categories derived from [Job.title][google.cloud.talent.v4.Job.title]
     * and [Job.description][google.cloud.talent.v4.Job.description].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 3;</code>
     *
     * @return A list containing the jobCategories.
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.talent.v4.JobCategory> getJobCategoriesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.talent.v4.JobCategory>(
          jobCategories_, jobCategories_converter_);
    }
    /**
     *
     *
     * <pre>
     * Job categories derived from [Job.title][google.cloud.talent.v4.Job.title]
     * and [Job.description][google.cloud.talent.v4.Job.description].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 3;</code>
     *
     * @return The count of jobCategories.
     */
    @java.lang.Override
    public int getJobCategoriesCount() {
      return jobCategories_.size();
    }
    /**
     *
     *
     * <pre>
     * Job categories derived from [Job.title][google.cloud.talent.v4.Job.title]
     * and [Job.description][google.cloud.talent.v4.Job.description].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The jobCategories at the given index.
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.JobCategory getJobCategories(int index) {
      return jobCategories_converter_.convert(jobCategories_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Job categories derived from [Job.title][google.cloud.talent.v4.Job.title]
     * and [Job.description][google.cloud.talent.v4.Job.description].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 3;</code>
     *
     * @return A list containing the enum numeric values on the wire for jobCategories.
     */
    @java.lang.Override
    public java.util.List<java.lang.Integer> getJobCategoriesValueList() {
      return jobCategories_;
    }
    /**
     *
     *
     * <pre>
     * Job categories derived from [Job.title][google.cloud.talent.v4.Job.title]
     * and [Job.description][google.cloud.talent.v4.Job.description].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of jobCategories at the given index.
     */
    @java.lang.Override
    public int getJobCategoriesValue(int index) {
      return jobCategories_.get(index);
    }

    private int jobCategoriesMemoizedSerializedSize;

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      for (int i = 0; i < locations_.size(); i++) {
        output.writeMessage(1, locations_.get(i));
      }
      if (getJobCategoriesList().size() > 0) {
        output.writeUInt32NoTag(26);
        output.writeUInt32NoTag(jobCategoriesMemoizedSerializedSize);
      }
      for (int i = 0; i < jobCategories_.size(); i++) {
        output.writeEnumNoTag(jobCategories_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < locations_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, locations_.get(i));
      }
      {
        int dataSize = 0;
        for (int i = 0; i < jobCategories_.size(); i++) {
          dataSize +=
              com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(jobCategories_.get(i));
        }
        size += dataSize;
        if (!getJobCategoriesList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
        }
        jobCategoriesMemoizedSerializedSize = dataSize;
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.talent.v4.Job.DerivedInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.talent.v4.Job.DerivedInfo other =
          (com.google.cloud.talent.v4.Job.DerivedInfo) obj;

      if (!getLocationsList().equals(other.getLocationsList())) return false;
      if (!jobCategories_.equals(other.jobCategories_)) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getLocationsCount() > 0) {
        hash = (37 * hash) + LOCATIONS_FIELD_NUMBER;
        hash = (53 * hash) + getLocationsList().hashCode();
      }
      if (getJobCategoriesCount() > 0) {
        hash = (37 * hash) + JOB_CATEGORIES_FIELD_NUMBER;
        hash = (53 * hash) + jobCategories_.hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.talent.v4.Job.DerivedInfo parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.Job.DerivedInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.Job.DerivedInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.Job.DerivedInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.Job.DerivedInfo parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.Job.DerivedInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.Job.DerivedInfo parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.Job.DerivedInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.Job.DerivedInfo parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.Job.DerivedInfo parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.Job.DerivedInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.Job.DerivedInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.talent.v4.Job.DerivedInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Derived details about the job posting.
     * </pre>
     *
     * Protobuf type {@code google.cloud.talent.v4.Job.DerivedInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.talent.v4.Job.DerivedInfo)
        com.google.cloud.talent.v4.Job.DerivedInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.talent.v4.JobProto
            .internal_static_google_cloud_talent_v4_Job_DerivedInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.talent.v4.JobProto
            .internal_static_google_cloud_talent_v4_Job_DerivedInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.talent.v4.Job.DerivedInfo.class,
                com.google.cloud.talent.v4.Job.DerivedInfo.Builder.class);
      }

      // Construct using com.google.cloud.talent.v4.Job.DerivedInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (locationsBuilder_ == null) {
          locations_ = java.util.Collections.emptyList();
        } else {
          locations_ = null;
          locationsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        jobCategories_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.talent.v4.JobProto
            .internal_static_google_cloud_talent_v4_Job_DerivedInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.Job.DerivedInfo getDefaultInstanceForType() {
        return com.google.cloud.talent.v4.Job.DerivedInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.Job.DerivedInfo build() {
        com.google.cloud.talent.v4.Job.DerivedInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.Job.DerivedInfo buildPartial() {
        com.google.cloud.talent.v4.Job.DerivedInfo result =
            new com.google.cloud.talent.v4.Job.DerivedInfo(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(com.google.cloud.talent.v4.Job.DerivedInfo result) {
        if (locationsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            locations_ = java.util.Collections.unmodifiableList(locations_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.locations_ = locations_;
        } else {
          result.locations_ = locationsBuilder_.build();
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          jobCategories_ = java.util.Collections.unmodifiableList(jobCategories_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.jobCategories_ = jobCategories_;
      }

      private void buildPartial0(com.google.cloud.talent.v4.Job.DerivedInfo result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.talent.v4.Job.DerivedInfo) {
          return mergeFrom((com.google.cloud.talent.v4.Job.DerivedInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.talent.v4.Job.DerivedInfo other) {
        if (other == com.google.cloud.talent.v4.Job.DerivedInfo.getDefaultInstance()) return this;
        if (locationsBuilder_ == null) {
          if (!other.locations_.isEmpty()) {
            if (locations_.isEmpty()) {
              locations_ = other.locations_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureLocationsIsMutable();
              locations_.addAll(other.locations_);
            }
            onChanged();
          }
        } else {
          if (!other.locations_.isEmpty()) {
            if (locationsBuilder_.isEmpty()) {
              locationsBuilder_.dispose();
              locationsBuilder_ = null;
              locations_ = other.locations_;
              bitField0_ = (bitField0_ & ~0x00000001);
              locationsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getLocationsFieldBuilder()
                      : null;
            } else {
              locationsBuilder_.addAllMessages(other.locations_);
            }
          }
        }
        if (!other.jobCategories_.isEmpty()) {
          if (jobCategories_.isEmpty()) {
            jobCategories_ = other.jobCategories_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureJobCategoriesIsMutable();
            jobCategories_.addAll(other.jobCategories_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.talent.v4.Location m =
                      input.readMessage(
                          com.google.cloud.talent.v4.Location.parser(), extensionRegistry);
                  if (locationsBuilder_ == null) {
                    ensureLocationsIsMutable();
                    locations_.add(m);
                  } else {
                    locationsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 24:
                {
                  int tmpRaw = input.readEnum();
                  ensureJobCategoriesIsMutable();
                  jobCategories_.add(tmpRaw);
                  break;
                } // case 24
              case 26:
                {
                  int length = input.readRawVarint32();
                  int oldLimit = input.pushLimit(length);
                  while (input.getBytesUntilLimit() > 0) {
                    int tmpRaw = input.readEnum();
                    ensureJobCategoriesIsMutable();
                    jobCategories_.add(tmpRaw);
                  }
                  input.popLimit(oldLimit);
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.talent.v4.Location> locations_ =
          java.util.Collections.emptyList();

      private void ensureLocationsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          locations_ = new java.util.ArrayList<com.google.cloud.talent.v4.Location>(locations_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.talent.v4.Location,
              com.google.cloud.talent.v4.Location.Builder,
              com.google.cloud.talent.v4.LocationOrBuilder>
          locationsBuilder_;

      /**
       *
       *
       * <pre>
       * Structured locations of the job, resolved from
       * [Job.addresses][google.cloud.talent.v4.Job.addresses].
       *
       * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
       * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
       * same order.
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
       */
      public java.util.List<com.google.cloud.talent.v4.Location> getLocationsList() {
        if (locationsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(locations_);
        } else {
          return locationsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Structured locations of the job, resolved from
       * [Job.addresses][google.cloud.talent.v4.Job.addresses].
       *
       * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
       * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
       * same order.
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
       */
      public int getLocationsCount() {
        if (locationsBuilder_ == null) {
          return locations_.size();
        } else {
          return locationsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Structured locations of the job, resolved from
       * [Job.addresses][google.cloud.talent.v4.Job.addresses].
       *
       * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
       * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
       * same order.
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
       */
      public com.google.cloud.talent.v4.Location getLocations(int index) {
        if (locationsBuilder_ == null) {
          return locations_.get(index);
        } else {
          return locationsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Structured locations of the job, resolved from
       * [Job.addresses][google.cloud.talent.v4.Job.addresses].
       *
       * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
       * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
       * same order.
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
       */
      public Builder setLocations(int index, com.google.cloud.talent.v4.Location value) {
        if (locationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLocationsIsMutable();
          locations_.set(index, value);
          onChanged();
        } else {
          locationsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Structured locations of the job, resolved from
       * [Job.addresses][google.cloud.talent.v4.Job.addresses].
       *
       * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
       * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
       * same order.
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
       */
      public Builder setLocations(
          int index, com.google.cloud.talent.v4.Location.Builder builderForValue) {
        if (locationsBuilder_ == null) {
          ensureLocationsIsMutable();
          locations_.set(index, builderForValue.build());
          onChanged();
        } else {
          locationsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Structured locations of the job, resolved from
       * [Job.addresses][google.cloud.talent.v4.Job.addresses].
       *
       * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
       * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
       * same order.
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
       */
      public Builder addLocations(com.google.cloud.talent.v4.Location value) {
        if (locationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLocationsIsMutable();
          locations_.add(value);
          onChanged();
        } else {
          locationsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Structured locations of the job, resolved from
       * [Job.addresses][google.cloud.talent.v4.Job.addresses].
       *
       * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
       * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
       * same order.
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
       */
      public Builder addLocations(int index, com.google.cloud.talent.v4.Location value) {
        if (locationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureLocationsIsMutable();
          locations_.add(index, value);
          onChanged();
        } else {
          locationsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Structured locations of the job, resolved from
       * [Job.addresses][google.cloud.talent.v4.Job.addresses].
       *
       * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
       * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
       * same order.
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
       */
      public Builder addLocations(com.google.cloud.talent.v4.Location.Builder builderForValue) {
        if (locationsBuilder_ == null) {
          ensureLocationsIsMutable();
          locations_.add(builderForValue.build());
          onChanged();
        } else {
          locationsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Structured locations of the job, resolved from
       * [Job.addresses][google.cloud.talent.v4.Job.addresses].
       *
       * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
       * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
       * same order.
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
       */
      public Builder addLocations(
          int index, com.google.cloud.talent.v4.Location.Builder builderForValue) {
        if (locationsBuilder_ == null) {
          ensureLocationsIsMutable();
          locations_.add(index, builderForValue.build());
          onChanged();
        } else {
          locationsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Structured locations of the job, resolved from
       * [Job.addresses][google.cloud.talent.v4.Job.addresses].
       *
       * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
       * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
       * same order.
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
       */
      public Builder addAllLocations(
          java.lang.Iterable<? extends com.google.cloud.talent.v4.Location> values) {
        if (locationsBuilder_ == null) {
          ensureLocationsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, locations_);
          onChanged();
        } else {
          locationsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Structured locations of the job, resolved from
       * [Job.addresses][google.cloud.talent.v4.Job.addresses].
       *
       * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
       * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
       * same order.
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
       */
      public Builder clearLocations() {
        if (locationsBuilder_ == null) {
          locations_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          locationsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Structured locations of the job, resolved from
       * [Job.addresses][google.cloud.talent.v4.Job.addresses].
       *
       * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
       * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
       * same order.
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
       */
      public Builder removeLocations(int index) {
        if (locationsBuilder_ == null) {
          ensureLocationsIsMutable();
          locations_.remove(index);
          onChanged();
        } else {
          locationsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Structured locations of the job, resolved from
       * [Job.addresses][google.cloud.talent.v4.Job.addresses].
       *
       * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
       * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
       * same order.
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
       */
      public com.google.cloud.talent.v4.Location.Builder getLocationsBuilder(int index) {
        return getLocationsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Structured locations of the job, resolved from
       * [Job.addresses][google.cloud.talent.v4.Job.addresses].
       *
       * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
       * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
       * same order.
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
       */
      public com.google.cloud.talent.v4.LocationOrBuilder getLocationsOrBuilder(int index) {
        if (locationsBuilder_ == null) {
          return locations_.get(index);
        } else {
          return locationsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Structured locations of the job, resolved from
       * [Job.addresses][google.cloud.talent.v4.Job.addresses].
       *
       * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
       * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
       * same order.
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
       */
      public java.util.List<? extends com.google.cloud.talent.v4.LocationOrBuilder>
          getLocationsOrBuilderList() {
        if (locationsBuilder_ != null) {
          return locationsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(locations_);
        }
      }
      /**
       *
       *
       * <pre>
       * Structured locations of the job, resolved from
       * [Job.addresses][google.cloud.talent.v4.Job.addresses].
       *
       * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
       * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
       * same order.
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
       */
      public com.google.cloud.talent.v4.Location.Builder addLocationsBuilder() {
        return getLocationsFieldBuilder()
            .addBuilder(com.google.cloud.talent.v4.Location.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Structured locations of the job, resolved from
       * [Job.addresses][google.cloud.talent.v4.Job.addresses].
       *
       * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
       * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
       * same order.
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
       */
      public com.google.cloud.talent.v4.Location.Builder addLocationsBuilder(int index) {
        return getLocationsFieldBuilder()
            .addBuilder(index, com.google.cloud.talent.v4.Location.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Structured locations of the job, resolved from
       * [Job.addresses][google.cloud.talent.v4.Job.addresses].
       *
       * [locations][google.cloud.talent.v4.Job.DerivedInfo.locations] are exactly
       * matched to [Job.addresses][google.cloud.talent.v4.Job.addresses] in the
       * same order.
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.Location locations = 1;</code>
       */
      public java.util.List<com.google.cloud.talent.v4.Location.Builder> getLocationsBuilderList() {
        return getLocationsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.talent.v4.Location,
              com.google.cloud.talent.v4.Location.Builder,
              com.google.cloud.talent.v4.LocationOrBuilder>
          getLocationsFieldBuilder() {
        if (locationsBuilder_ == null) {
          locationsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.talent.v4.Location,
                  com.google.cloud.talent.v4.Location.Builder,
                  com.google.cloud.talent.v4.LocationOrBuilder>(
                  locations_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          locations_ = null;
        }
        return locationsBuilder_;
      }

      private java.util.List<java.lang.Integer> jobCategories_ = java.util.Collections.emptyList();

      private void ensureJobCategoriesIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          jobCategories_ = new java.util.ArrayList<java.lang.Integer>(jobCategories_);
          bitField0_ |= 0x00000002;
        }
      }
      /**
       *
       *
       * <pre>
       * Job categories derived from [Job.title][google.cloud.talent.v4.Job.title]
       * and [Job.description][google.cloud.talent.v4.Job.description].
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 3;</code>
       *
       * @return A list containing the jobCategories.
       */
      public java.util.List<com.google.cloud.talent.v4.JobCategory> getJobCategoriesList() {
        return new com.google.protobuf.Internal.ListAdapter<
            java.lang.Integer, com.google.cloud.talent.v4.JobCategory>(
            jobCategories_, jobCategories_converter_);
      }
      /**
       *
       *
       * <pre>
       * Job categories derived from [Job.title][google.cloud.talent.v4.Job.title]
       * and [Job.description][google.cloud.talent.v4.Job.description].
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 3;</code>
       *
       * @return The count of jobCategories.
       */
      public int getJobCategoriesCount() {
        return jobCategories_.size();
      }
      /**
       *
       *
       * <pre>
       * Job categories derived from [Job.title][google.cloud.talent.v4.Job.title]
       * and [Job.description][google.cloud.talent.v4.Job.description].
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The jobCategories at the given index.
       */
      public com.google.cloud.talent.v4.JobCategory getJobCategories(int index) {
        return jobCategories_converter_.convert(jobCategories_.get(index));
      }
      /**
       *
       *
       * <pre>
       * Job categories derived from [Job.title][google.cloud.talent.v4.Job.title]
       * and [Job.description][google.cloud.talent.v4.Job.description].
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The jobCategories to set.
       * @return This builder for chaining.
       */
      public Builder setJobCategories(int index, com.google.cloud.talent.v4.JobCategory value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureJobCategoriesIsMutable();
        jobCategories_.set(index, value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Job categories derived from [Job.title][google.cloud.talent.v4.Job.title]
       * and [Job.description][google.cloud.talent.v4.Job.description].
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 3;</code>
       *
       * @param value The jobCategories to add.
       * @return This builder for chaining.
       */
      public Builder addJobCategories(com.google.cloud.talent.v4.JobCategory value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureJobCategoriesIsMutable();
        jobCategories_.add(value.getNumber());
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Job categories derived from [Job.title][google.cloud.talent.v4.Job.title]
       * and [Job.description][google.cloud.talent.v4.Job.description].
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 3;</code>
       *
       * @param values The jobCategories to add.
       * @return This builder for chaining.
       */
      public Builder addAllJobCategories(
          java.lang.Iterable<? extends com.google.cloud.talent.v4.JobCategory> values) {
        ensureJobCategoriesIsMutable();
        for (com.google.cloud.talent.v4.JobCategory value : values) {
          jobCategories_.add(value.getNumber());
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Job categories derived from [Job.title][google.cloud.talent.v4.Job.title]
       * and [Job.description][google.cloud.talent.v4.Job.description].
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearJobCategories() {
        jobCategories_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Job categories derived from [Job.title][google.cloud.talent.v4.Job.title]
       * and [Job.description][google.cloud.talent.v4.Job.description].
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 3;</code>
       *
       * @return A list containing the enum numeric values on the wire for jobCategories.
       */
      public java.util.List<java.lang.Integer> getJobCategoriesValueList() {
        return java.util.Collections.unmodifiableList(jobCategories_);
      }
      /**
       *
       *
       * <pre>
       * Job categories derived from [Job.title][google.cloud.talent.v4.Job.title]
       * and [Job.description][google.cloud.talent.v4.Job.description].
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The enum numeric value on the wire of jobCategories at the given index.
       */
      public int getJobCategoriesValue(int index) {
        return jobCategories_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Job categories derived from [Job.title][google.cloud.talent.v4.Job.title]
       * and [Job.description][google.cloud.talent.v4.Job.description].
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The enum numeric value on the wire for jobCategories to set.
       * @return This builder for chaining.
       */
      public Builder setJobCategoriesValue(int index, int value) {
        ensureJobCategoriesIsMutable();
        jobCategories_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Job categories derived from [Job.title][google.cloud.talent.v4.Job.title]
       * and [Job.description][google.cloud.talent.v4.Job.description].
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 3;</code>
       *
       * @param value The enum numeric value on the wire for jobCategories to add.
       * @return This builder for chaining.
       */
      public Builder addJobCategoriesValue(int value) {
        ensureJobCategoriesIsMutable();
        jobCategories_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Job categories derived from [Job.title][google.cloud.talent.v4.Job.title]
       * and [Job.description][google.cloud.talent.v4.Job.description].
       * </pre>
       *
       * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 3;</code>
       *
       * @param values The enum numeric values on the wire for jobCategories to add.
       * @return This builder for chaining.
       */
      public Builder addAllJobCategoriesValue(java.lang.Iterable<java.lang.Integer> values) {
        ensureJobCategoriesIsMutable();
        for (int value : values) {
          jobCategories_.add(value);
        }
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.talent.v4.Job.DerivedInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.talent.v4.Job.DerivedInfo)
    private static final com.google.cloud.talent.v4.Job.DerivedInfo DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.talent.v4.Job.DerivedInfo();
    }

    public static com.google.cloud.talent.v4.Job.DerivedInfo getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DerivedInfo> PARSER =
        new com.google.protobuf.AbstractParser<DerivedInfo>() {
          @java.lang.Override
          public DerivedInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DerivedInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DerivedInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.Job.DerivedInfo getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ProcessingOptionsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.talent.v4.Job.ProcessingOptions)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * If set to `true`, the service does not attempt to resolve a
     * more precise address for the job.
     * </pre>
     *
     * <code>bool disable_street_address_resolution = 1;</code>
     *
     * @return The disableStreetAddressResolution.
     */
    boolean getDisableStreetAddressResolution();

    /**
     *
     *
     * <pre>
     * Option for job HTML content sanitization. Applied fields are:
     *
     * * description
     * * applicationInfo.instruction
     * * incentives
     * * qualifications
     * * responsibilities
     *
     * HTML tags in these fields may be stripped if sanitiazation isn't
     * disabled.
     *
     * Defaults to
     * [HtmlSanitization.SIMPLE_FORMATTING_ONLY][google.cloud.talent.v4.HtmlSanitization.SIMPLE_FORMATTING_ONLY].
     * </pre>
     *
     * <code>.google.cloud.talent.v4.HtmlSanitization html_sanitization = 2;</code>
     *
     * @return The enum numeric value on the wire for htmlSanitization.
     */
    int getHtmlSanitizationValue();
    /**
     *
     *
     * <pre>
     * Option for job HTML content sanitization. Applied fields are:
     *
     * * description
     * * applicationInfo.instruction
     * * incentives
     * * qualifications
     * * responsibilities
     *
     * HTML tags in these fields may be stripped if sanitiazation isn't
     * disabled.
     *
     * Defaults to
     * [HtmlSanitization.SIMPLE_FORMATTING_ONLY][google.cloud.talent.v4.HtmlSanitization.SIMPLE_FORMATTING_ONLY].
     * </pre>
     *
     * <code>.google.cloud.talent.v4.HtmlSanitization html_sanitization = 2;</code>
     *
     * @return The htmlSanitization.
     */
    com.google.cloud.talent.v4.HtmlSanitization getHtmlSanitization();
  }
  /**
   *
   *
   * <pre>
   * Options for job processing.
   * </pre>
   *
   * Protobuf type {@code google.cloud.talent.v4.Job.ProcessingOptions}
   */
  public static final class ProcessingOptions extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.talent.v4.Job.ProcessingOptions)
      ProcessingOptionsOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ProcessingOptions.newBuilder() to construct.
    private ProcessingOptions(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ProcessingOptions() {
      htmlSanitization_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ProcessingOptions();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.talent.v4.JobProto
          .internal_static_google_cloud_talent_v4_Job_ProcessingOptions_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.talent.v4.JobProto
          .internal_static_google_cloud_talent_v4_Job_ProcessingOptions_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.talent.v4.Job.ProcessingOptions.class,
              com.google.cloud.talent.v4.Job.ProcessingOptions.Builder.class);
    }

    public static final int DISABLE_STREET_ADDRESS_RESOLUTION_FIELD_NUMBER = 1;
    private boolean disableStreetAddressResolution_ = false;
    /**
     *
     *
     * <pre>
     * If set to `true`, the service does not attempt to resolve a
     * more precise address for the job.
     * </pre>
     *
     * <code>bool disable_street_address_resolution = 1;</code>
     *
     * @return The disableStreetAddressResolution.
     */
    @java.lang.Override
    public boolean getDisableStreetAddressResolution() {
      return disableStreetAddressResolution_;
    }

    public static final int HTML_SANITIZATION_FIELD_NUMBER = 2;
    private int htmlSanitization_ = 0;
    /**
     *
     *
     * <pre>
     * Option for job HTML content sanitization. Applied fields are:
     *
     * * description
     * * applicationInfo.instruction
     * * incentives
     * * qualifications
     * * responsibilities
     *
     * HTML tags in these fields may be stripped if sanitiazation isn't
     * disabled.
     *
     * Defaults to
     * [HtmlSanitization.SIMPLE_FORMATTING_ONLY][google.cloud.talent.v4.HtmlSanitization.SIMPLE_FORMATTING_ONLY].
     * </pre>
     *
     * <code>.google.cloud.talent.v4.HtmlSanitization html_sanitization = 2;</code>
     *
     * @return The enum numeric value on the wire for htmlSanitization.
     */
    @java.lang.Override
    public int getHtmlSanitizationValue() {
      return htmlSanitization_;
    }
    /**
     *
     *
     * <pre>
     * Option for job HTML content sanitization. Applied fields are:
     *
     * * description
     * * applicationInfo.instruction
     * * incentives
     * * qualifications
     * * responsibilities
     *
     * HTML tags in these fields may be stripped if sanitiazation isn't
     * disabled.
     *
     * Defaults to
     * [HtmlSanitization.SIMPLE_FORMATTING_ONLY][google.cloud.talent.v4.HtmlSanitization.SIMPLE_FORMATTING_ONLY].
     * </pre>
     *
     * <code>.google.cloud.talent.v4.HtmlSanitization html_sanitization = 2;</code>
     *
     * @return The htmlSanitization.
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.HtmlSanitization getHtmlSanitization() {
      com.google.cloud.talent.v4.HtmlSanitization result =
          com.google.cloud.talent.v4.HtmlSanitization.forNumber(htmlSanitization_);
      return result == null ? com.google.cloud.talent.v4.HtmlSanitization.UNRECOGNIZED : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (disableStreetAddressResolution_ != false) {
        output.writeBool(1, disableStreetAddressResolution_);
      }
      if (htmlSanitization_
          != com.google.cloud.talent.v4.HtmlSanitization.HTML_SANITIZATION_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, htmlSanitization_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (disableStreetAddressResolution_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                1, disableStreetAddressResolution_);
      }
      if (htmlSanitization_
          != com.google.cloud.talent.v4.HtmlSanitization.HTML_SANITIZATION_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, htmlSanitization_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.talent.v4.Job.ProcessingOptions)) {
        return super.equals(obj);
      }
      com.google.cloud.talent.v4.Job.ProcessingOptions other =
          (com.google.cloud.talent.v4.Job.ProcessingOptions) obj;

      if (getDisableStreetAddressResolution() != other.getDisableStreetAddressResolution())
        return false;
      if (htmlSanitization_ != other.htmlSanitization_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DISABLE_STREET_ADDRESS_RESOLUTION_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashBoolean(getDisableStreetAddressResolution());
      hash = (37 * hash) + HTML_SANITIZATION_FIELD_NUMBER;
      hash = (53 * hash) + htmlSanitization_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.talent.v4.Job.ProcessingOptions parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.Job.ProcessingOptions parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.Job.ProcessingOptions parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.Job.ProcessingOptions parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.Job.ProcessingOptions parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.Job.ProcessingOptions parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.Job.ProcessingOptions parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.Job.ProcessingOptions parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.Job.ProcessingOptions parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.Job.ProcessingOptions parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.Job.ProcessingOptions parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.Job.ProcessingOptions parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.cloud.talent.v4.Job.ProcessingOptions prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Options for job processing.
     * </pre>
     *
     * Protobuf type {@code google.cloud.talent.v4.Job.ProcessingOptions}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.talent.v4.Job.ProcessingOptions)
        com.google.cloud.talent.v4.Job.ProcessingOptionsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.talent.v4.JobProto
            .internal_static_google_cloud_talent_v4_Job_ProcessingOptions_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.talent.v4.JobProto
            .internal_static_google_cloud_talent_v4_Job_ProcessingOptions_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.talent.v4.Job.ProcessingOptions.class,
                com.google.cloud.talent.v4.Job.ProcessingOptions.Builder.class);
      }

      // Construct using com.google.cloud.talent.v4.Job.ProcessingOptions.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        disableStreetAddressResolution_ = false;
        htmlSanitization_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.talent.v4.JobProto
            .internal_static_google_cloud_talent_v4_Job_ProcessingOptions_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.Job.ProcessingOptions getDefaultInstanceForType() {
        return com.google.cloud.talent.v4.Job.ProcessingOptions.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.Job.ProcessingOptions build() {
        com.google.cloud.talent.v4.Job.ProcessingOptions result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.Job.ProcessingOptions buildPartial() {
        com.google.cloud.talent.v4.Job.ProcessingOptions result =
            new com.google.cloud.talent.v4.Job.ProcessingOptions(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.talent.v4.Job.ProcessingOptions result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.disableStreetAddressResolution_ = disableStreetAddressResolution_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.htmlSanitization_ = htmlSanitization_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.talent.v4.Job.ProcessingOptions) {
          return mergeFrom((com.google.cloud.talent.v4.Job.ProcessingOptions) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.talent.v4.Job.ProcessingOptions other) {
        if (other == com.google.cloud.talent.v4.Job.ProcessingOptions.getDefaultInstance())
          return this;
        if (other.getDisableStreetAddressResolution() != false) {
          setDisableStreetAddressResolution(other.getDisableStreetAddressResolution());
        }
        if (other.htmlSanitization_ != 0) {
          setHtmlSanitizationValue(other.getHtmlSanitizationValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  disableStreetAddressResolution_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  htmlSanitization_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean disableStreetAddressResolution_;
      /**
       *
       *
       * <pre>
       * If set to `true`, the service does not attempt to resolve a
       * more precise address for the job.
       * </pre>
       *
       * <code>bool disable_street_address_resolution = 1;</code>
       *
       * @return The disableStreetAddressResolution.
       */
      @java.lang.Override
      public boolean getDisableStreetAddressResolution() {
        return disableStreetAddressResolution_;
      }
      /**
       *
       *
       * <pre>
       * If set to `true`, the service does not attempt to resolve a
       * more precise address for the job.
       * </pre>
       *
       * <code>bool disable_street_address_resolution = 1;</code>
       *
       * @param value The disableStreetAddressResolution to set.
       * @return This builder for chaining.
       */
      public Builder setDisableStreetAddressResolution(boolean value) {

        disableStreetAddressResolution_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If set to `true`, the service does not attempt to resolve a
       * more precise address for the job.
       * </pre>
       *
       * <code>bool disable_street_address_resolution = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDisableStreetAddressResolution() {
        bitField0_ = (bitField0_ & ~0x00000001);
        disableStreetAddressResolution_ = false;
        onChanged();
        return this;
      }

      private int htmlSanitization_ = 0;
      /**
       *
       *
       * <pre>
       * Option for job HTML content sanitization. Applied fields are:
       *
       * * description
       * * applicationInfo.instruction
       * * incentives
       * * qualifications
       * * responsibilities
       *
       * HTML tags in these fields may be stripped if sanitiazation isn't
       * disabled.
       *
       * Defaults to
       * [HtmlSanitization.SIMPLE_FORMATTING_ONLY][google.cloud.talent.v4.HtmlSanitization.SIMPLE_FORMATTING_ONLY].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.HtmlSanitization html_sanitization = 2;</code>
       *
       * @return The enum numeric value on the wire for htmlSanitization.
       */
      @java.lang.Override
      public int getHtmlSanitizationValue() {
        return htmlSanitization_;
      }
      /**
       *
       *
       * <pre>
       * Option for job HTML content sanitization. Applied fields are:
       *
       * * description
       * * applicationInfo.instruction
       * * incentives
       * * qualifications
       * * responsibilities
       *
       * HTML tags in these fields may be stripped if sanitiazation isn't
       * disabled.
       *
       * Defaults to
       * [HtmlSanitization.SIMPLE_FORMATTING_ONLY][google.cloud.talent.v4.HtmlSanitization.SIMPLE_FORMATTING_ONLY].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.HtmlSanitization html_sanitization = 2;</code>
       *
       * @param value The enum numeric value on the wire for htmlSanitization to set.
       * @return This builder for chaining.
       */
      public Builder setHtmlSanitizationValue(int value) {
        htmlSanitization_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Option for job HTML content sanitization. Applied fields are:
       *
       * * description
       * * applicationInfo.instruction
       * * incentives
       * * qualifications
       * * responsibilities
       *
       * HTML tags in these fields may be stripped if sanitiazation isn't
       * disabled.
       *
       * Defaults to
       * [HtmlSanitization.SIMPLE_FORMATTING_ONLY][google.cloud.talent.v4.HtmlSanitization.SIMPLE_FORMATTING_ONLY].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.HtmlSanitization html_sanitization = 2;</code>
       *
       * @return The htmlSanitization.
       */
      @java.lang.Override
      public com.google.cloud.talent.v4.HtmlSanitization getHtmlSanitization() {
        com.google.cloud.talent.v4.HtmlSanitization result =
            com.google.cloud.talent.v4.HtmlSanitization.forNumber(htmlSanitization_);
        return result == null ? com.google.cloud.talent.v4.HtmlSanitization.UNRECOGNIZED : result;
      }
      /**
       *
       *
       * <pre>
       * Option for job HTML content sanitization. Applied fields are:
       *
       * * description
       * * applicationInfo.instruction
       * * incentives
       * * qualifications
       * * responsibilities
       *
       * HTML tags in these fields may be stripped if sanitiazation isn't
       * disabled.
       *
       * Defaults to
       * [HtmlSanitization.SIMPLE_FORMATTING_ONLY][google.cloud.talent.v4.HtmlSanitization.SIMPLE_FORMATTING_ONLY].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.HtmlSanitization html_sanitization = 2;</code>
       *
       * @param value The htmlSanitization to set.
       * @return This builder for chaining.
       */
      public Builder setHtmlSanitization(com.google.cloud.talent.v4.HtmlSanitization value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        htmlSanitization_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Option for job HTML content sanitization. Applied fields are:
       *
       * * description
       * * applicationInfo.instruction
       * * incentives
       * * qualifications
       * * responsibilities
       *
       * HTML tags in these fields may be stripped if sanitiazation isn't
       * disabled.
       *
       * Defaults to
       * [HtmlSanitization.SIMPLE_FORMATTING_ONLY][google.cloud.talent.v4.HtmlSanitization.SIMPLE_FORMATTING_ONLY].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.HtmlSanitization html_sanitization = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHtmlSanitization() {
        bitField0_ = (bitField0_ & ~0x00000002);
        htmlSanitization_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.talent.v4.Job.ProcessingOptions)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.talent.v4.Job.ProcessingOptions)
    private static final com.google.cloud.talent.v4.Job.ProcessingOptions DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.talent.v4.Job.ProcessingOptions();
    }

    public static com.google.cloud.talent.v4.Job.ProcessingOptions getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ProcessingOptions> PARSER =
        new com.google.protobuf.AbstractParser<ProcessingOptions>() {
          @java.lang.Override
          public ProcessingOptions parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ProcessingOptions> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ProcessingOptions> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.Job.ProcessingOptions getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required during job update.
   *
   * The resource name for the job. This is generated by the service when a
   * job is created.
   *
   * The format is
   * "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}". For
   * example, "projects/foo/tenants/bar/jobs/baz".
   *
   * Use of this field in job queries and API calls is preferred over the use of
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id] since this
   * value is unique.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required during job update.
   *
   * The resource name for the job. This is generated by the service when a
   * job is created.
   *
   * The format is
   * "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}". For
   * example, "projects/foo/tenants/bar/jobs/baz".
   *
   * Use of this field in job queries and API calls is preferred over the use of
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id] since this
   * value is unique.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COMPANY_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object company_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the company listing the job.
   *
   * The format is
   * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
   * example, "projects/foo/tenants/bar/companies/baz".
   * </pre>
   *
   * <code>
   * string company = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The company.
   */
  @java.lang.Override
  public java.lang.String getCompany() {
    java.lang.Object ref = company_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      company_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the company listing the job.
   *
   * The format is
   * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
   * example, "projects/foo/tenants/bar/companies/baz".
   * </pre>
   *
   * <code>
   * string company = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for company.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCompanyBytes() {
    java.lang.Object ref = company_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      company_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REQUISITION_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object requisitionId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The requisition ID, also referred to as the posting ID, is
   * assigned by the client to identify a job. This field is intended to be used
   * by clients for client identification and tracking of postings. A job isn't
   * allowed to be created if there is another job with the same
   * [company][google.cloud.talent.v4.Job.name],
   * [language_code][google.cloud.talent.v4.Job.language_code] and
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
   *
   * The maximum number of allowed characters is 255.
   * </pre>
   *
   * <code>string requisition_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The requisitionId.
   */
  @java.lang.Override
  public java.lang.String getRequisitionId() {
    java.lang.Object ref = requisitionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      requisitionId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The requisition ID, also referred to as the posting ID, is
   * assigned by the client to identify a job. This field is intended to be used
   * by clients for client identification and tracking of postings. A job isn't
   * allowed to be created if there is another job with the same
   * [company][google.cloud.talent.v4.Job.name],
   * [language_code][google.cloud.talent.v4.Job.language_code] and
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
   *
   * The maximum number of allowed characters is 255.
   * </pre>
   *
   * <code>string requisition_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for requisitionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRequisitionIdBytes() {
    java.lang.Object ref = requisitionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      requisitionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TITLE_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object title_ = "";
  /**
   *
   *
   * <pre>
   * Required. The title of the job, such as "Software Engineer"
   *
   * The maximum number of allowed characters is 500.
   * </pre>
   *
   * <code>string title = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The title.
   */
  @java.lang.Override
  public java.lang.String getTitle() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      title_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The title of the job, such as "Software Engineer"
   *
   * The maximum number of allowed characters is 500.
   * </pre>
   *
   * <code>string title = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for title.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTitleBytes() {
    java.lang.Object ref = title_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      title_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Required. The description of the job, which typically includes a
   * multi-paragraph description of the company and related information.
   * Separate fields are provided on the job object for
   * [responsibilities][google.cloud.talent.v4.Job.responsibilities],
   * [qualifications][google.cloud.talent.v4.Job.qualifications], and other job
   * characteristics. Use of these separate job fields is recommended.
   *
   * This field accepts and sanitizes HTML input, and also accepts
   * bold, italic, ordered list, and unordered list markup tags.
   *
   * The maximum number of allowed characters is 100,000.
   * </pre>
   *
   * <code>string description = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The description of the job, which typically includes a
   * multi-paragraph description of the company and related information.
   * Separate fields are provided on the job object for
   * [responsibilities][google.cloud.talent.v4.Job.responsibilities],
   * [qualifications][google.cloud.talent.v4.Job.qualifications], and other job
   * characteristics. Use of these separate job fields is recommended.
   *
   * This field accepts and sanitizes HTML input, and also accepts
   * bold, italic, ordered list, and unordered list markup tags.
   *
   * The maximum number of allowed characters is 100,000.
   * </pre>
   *
   * <code>string description = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ADDRESSES_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList addresses_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Strongly recommended for the best service experience.
   *
   * Location(s) where the employer is looking to hire for this job posting.
   *
   * Specifying the full street address(es) of the hiring location enables
   * better API results, especially job searches by commute time.
   *
   * At most 50 locations are allowed for best search performance. If a job has
   * more locations, it is suggested to split it into multiple jobs with unique
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id]s (e.g. 'ReqA'
   * becomes 'ReqA-1', 'ReqA-2', and so on.) as multiple jobs with the same
   * [company][google.cloud.talent.v4.Job.company],
   * [language_code][google.cloud.talent.v4.Job.language_code] and
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id] are not
   * allowed. If the original
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id] must be
   * preserved, a custom field should be used for storage. It is also suggested
   * to group the locations that close to each other in the same job for better
   * search experience.
   *
   * Jobs with multiple addresses must have their addresses with the same
   * [LocationType][] to allow location filtering to work properly. (For
   * example, a Job with addresses "1600 Amphitheatre Parkway, Mountain View,
   * CA, USA" and "London, UK" may not have location filters applied correctly
   * at search time since the first is a [LocationType.STREET_ADDRESS][] and the
   * second is a [LocationType.LOCALITY][].) If a job needs to have multiple
   * addresses, it is suggested to split it into multiple jobs with same
   * LocationTypes.
   *
   * The maximum number of allowed characters is 500.
   * </pre>
   *
   * <code>repeated string addresses = 6;</code>
   *
   * @return A list containing the addresses.
   */
  public com.google.protobuf.ProtocolStringList getAddressesList() {
    return addresses_;
  }
  /**
   *
   *
   * <pre>
   * Strongly recommended for the best service experience.
   *
   * Location(s) where the employer is looking to hire for this job posting.
   *
   * Specifying the full street address(es) of the hiring location enables
   * better API results, especially job searches by commute time.
   *
   * At most 50 locations are allowed for best search performance. If a job has
   * more locations, it is suggested to split it into multiple jobs with unique
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id]s (e.g. 'ReqA'
   * becomes 'ReqA-1', 'ReqA-2', and so on.) as multiple jobs with the same
   * [company][google.cloud.talent.v4.Job.company],
   * [language_code][google.cloud.talent.v4.Job.language_code] and
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id] are not
   * allowed. If the original
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id] must be
   * preserved, a custom field should be used for storage. It is also suggested
   * to group the locations that close to each other in the same job for better
   * search experience.
   *
   * Jobs with multiple addresses must have their addresses with the same
   * [LocationType][] to allow location filtering to work properly. (For
   * example, a Job with addresses "1600 Amphitheatre Parkway, Mountain View,
   * CA, USA" and "London, UK" may not have location filters applied correctly
   * at search time since the first is a [LocationType.STREET_ADDRESS][] and the
   * second is a [LocationType.LOCALITY][].) If a job needs to have multiple
   * addresses, it is suggested to split it into multiple jobs with same
   * LocationTypes.
   *
   * The maximum number of allowed characters is 500.
   * </pre>
   *
   * <code>repeated string addresses = 6;</code>
   *
   * @return The count of addresses.
   */
  public int getAddressesCount() {
    return addresses_.size();
  }
  /**
   *
   *
   * <pre>
   * Strongly recommended for the best service experience.
   *
   * Location(s) where the employer is looking to hire for this job posting.
   *
   * Specifying the full street address(es) of the hiring location enables
   * better API results, especially job searches by commute time.
   *
   * At most 50 locations are allowed for best search performance. If a job has
   * more locations, it is suggested to split it into multiple jobs with unique
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id]s (e.g. 'ReqA'
   * becomes 'ReqA-1', 'ReqA-2', and so on.) as multiple jobs with the same
   * [company][google.cloud.talent.v4.Job.company],
   * [language_code][google.cloud.talent.v4.Job.language_code] and
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id] are not
   * allowed. If the original
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id] must be
   * preserved, a custom field should be used for storage. It is also suggested
   * to group the locations that close to each other in the same job for better
   * search experience.
   *
   * Jobs with multiple addresses must have their addresses with the same
   * [LocationType][] to allow location filtering to work properly. (For
   * example, a Job with addresses "1600 Amphitheatre Parkway, Mountain View,
   * CA, USA" and "London, UK" may not have location filters applied correctly
   * at search time since the first is a [LocationType.STREET_ADDRESS][] and the
   * second is a [LocationType.LOCALITY][].) If a job needs to have multiple
   * addresses, it is suggested to split it into multiple jobs with same
   * LocationTypes.
   *
   * The maximum number of allowed characters is 500.
   * </pre>
   *
   * <code>repeated string addresses = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The addresses at the given index.
   */
  public java.lang.String getAddresses(int index) {
    return addresses_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Strongly recommended for the best service experience.
   *
   * Location(s) where the employer is looking to hire for this job posting.
   *
   * Specifying the full street address(es) of the hiring location enables
   * better API results, especially job searches by commute time.
   *
   * At most 50 locations are allowed for best search performance. If a job has
   * more locations, it is suggested to split it into multiple jobs with unique
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id]s (e.g. 'ReqA'
   * becomes 'ReqA-1', 'ReqA-2', and so on.) as multiple jobs with the same
   * [company][google.cloud.talent.v4.Job.company],
   * [language_code][google.cloud.talent.v4.Job.language_code] and
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id] are not
   * allowed. If the original
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id] must be
   * preserved, a custom field should be used for storage. It is also suggested
   * to group the locations that close to each other in the same job for better
   * search experience.
   *
   * Jobs with multiple addresses must have their addresses with the same
   * [LocationType][] to allow location filtering to work properly. (For
   * example, a Job with addresses "1600 Amphitheatre Parkway, Mountain View,
   * CA, USA" and "London, UK" may not have location filters applied correctly
   * at search time since the first is a [LocationType.STREET_ADDRESS][] and the
   * second is a [LocationType.LOCALITY][].) If a job needs to have multiple
   * addresses, it is suggested to split it into multiple jobs with same
   * LocationTypes.
   *
   * The maximum number of allowed characters is 500.
   * </pre>
   *
   * <code>repeated string addresses = 6;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the addresses at the given index.
   */
  public com.google.protobuf.ByteString getAddressesBytes(int index) {
    return addresses_.getByteString(index);
  }

  public static final int APPLICATION_INFO_FIELD_NUMBER = 7;
  private com.google.cloud.talent.v4.Job.ApplicationInfo applicationInfo_;
  /**
   *
   *
   * <pre>
   * Job application information.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.Job.ApplicationInfo application_info = 7;</code>
   *
   * @return Whether the applicationInfo field is set.
   */
  @java.lang.Override
  public boolean hasApplicationInfo() {
    return applicationInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Job application information.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.Job.ApplicationInfo application_info = 7;</code>
   *
   * @return The applicationInfo.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.Job.ApplicationInfo getApplicationInfo() {
    return applicationInfo_ == null
        ? com.google.cloud.talent.v4.Job.ApplicationInfo.getDefaultInstance()
        : applicationInfo_;
  }
  /**
   *
   *
   * <pre>
   * Job application information.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.Job.ApplicationInfo application_info = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.Job.ApplicationInfoOrBuilder getApplicationInfoOrBuilder() {
    return applicationInfo_ == null
        ? com.google.cloud.talent.v4.Job.ApplicationInfo.getDefaultInstance()
        : applicationInfo_;
  }

  public static final int JOB_BENEFITS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> jobBenefits_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.talent.v4.JobBenefit>
      jobBenefits_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.talent.v4.JobBenefit>() {
            public com.google.cloud.talent.v4.JobBenefit convert(java.lang.Integer from) {
              com.google.cloud.talent.v4.JobBenefit result =
                  com.google.cloud.talent.v4.JobBenefit.forNumber(from);
              return result == null ? com.google.cloud.talent.v4.JobBenefit.UNRECOGNIZED : result;
            }
          };
  /**
   *
   *
   * <pre>
   * The benefits included with the job.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
   *
   * @return A list containing the jobBenefits.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.talent.v4.JobBenefit> getJobBenefitsList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.talent.v4.JobBenefit>(
        jobBenefits_, jobBenefits_converter_);
  }
  /**
   *
   *
   * <pre>
   * The benefits included with the job.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
   *
   * @return The count of jobBenefits.
   */
  @java.lang.Override
  public int getJobBenefitsCount() {
    return jobBenefits_.size();
  }
  /**
   *
   *
   * <pre>
   * The benefits included with the job.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
   *
   * @param index The index of the element to return.
   * @return The jobBenefits at the given index.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.JobBenefit getJobBenefits(int index) {
    return jobBenefits_converter_.convert(jobBenefits_.get(index));
  }
  /**
   *
   *
   * <pre>
   * The benefits included with the job.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
   *
   * @return A list containing the enum numeric values on the wire for jobBenefits.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getJobBenefitsValueList() {
    return jobBenefits_;
  }
  /**
   *
   *
   * <pre>
   * The benefits included with the job.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of jobBenefits at the given index.
   */
  @java.lang.Override
  public int getJobBenefitsValue(int index) {
    return jobBenefits_.get(index);
  }

  private int jobBenefitsMemoizedSerializedSize;

  public static final int COMPENSATION_INFO_FIELD_NUMBER = 9;
  private com.google.cloud.talent.v4.CompensationInfo compensationInfo_;
  /**
   *
   *
   * <pre>
   * Job compensation information (a.k.a. "pay rate") i.e., the compensation
   * that will paid to the employee.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.CompensationInfo compensation_info = 9;</code>
   *
   * @return Whether the compensationInfo field is set.
   */
  @java.lang.Override
  public boolean hasCompensationInfo() {
    return compensationInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Job compensation information (a.k.a. "pay rate") i.e., the compensation
   * that will paid to the employee.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.CompensationInfo compensation_info = 9;</code>
   *
   * @return The compensationInfo.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.CompensationInfo getCompensationInfo() {
    return compensationInfo_ == null
        ? com.google.cloud.talent.v4.CompensationInfo.getDefaultInstance()
        : compensationInfo_;
  }
  /**
   *
   *
   * <pre>
   * Job compensation information (a.k.a. "pay rate") i.e., the compensation
   * that will paid to the employee.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.CompensationInfo compensation_info = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.CompensationInfoOrBuilder getCompensationInfoOrBuilder() {
    return compensationInfo_ == null
        ? com.google.cloud.talent.v4.CompensationInfo.getDefaultInstance()
        : compensationInfo_;
  }

  public static final int CUSTOM_ATTRIBUTES_FIELD_NUMBER = 10;

  private static final class CustomAttributesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.talent.v4.CustomAttribute>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.talent.v4.CustomAttribute>newDefaultInstance(
                    com.google.cloud.talent.v4.JobProto
                        .internal_static_google_cloud_talent_v4_Job_CustomAttributesEntry_descriptor,
                    com.google.protobuf.WireFormat.FieldType.STRING,
                    "",
                    com.google.protobuf.WireFormat.FieldType.MESSAGE,
                    com.google.cloud.talent.v4.CustomAttribute.getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, com.google.cloud.talent.v4.CustomAttribute>
      customAttributes_;

  private com.google.protobuf.MapField<java.lang.String, com.google.cloud.talent.v4.CustomAttribute>
      internalGetCustomAttributes() {
    if (customAttributes_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          CustomAttributesDefaultEntryHolder.defaultEntry);
    }
    return customAttributes_;
  }

  public int getCustomAttributesCount() {
    return internalGetCustomAttributes().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * A map of fields to hold both filterable and non-filterable custom job
   * attributes that are not covered by the provided structured fields.
   *
   * The keys of the map are strings up to 64 bytes and must match the
   * pattern: `[a-zA-Z][a-zA-Z0-9_]*`. For example, key0LikeThis or
   * KEY_1_LIKE_THIS.
   *
   * At most 100 filterable and at most 100 unfilterable keys are supported.
   * For filterable `string_values`, across all keys at most 200 values are
   * allowed, with each string no more than 255 characters. For unfilterable
   * `string_values`, the maximum total size of `string_values` across all keys
   * is 50KB.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.talent.v4.CustomAttribute&gt; custom_attributes = 10;</code>
   */
  @java.lang.Override
  public boolean containsCustomAttributes(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetCustomAttributes().getMap().containsKey(key);
  }
  /** Use {@link #getCustomAttributesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.talent.v4.CustomAttribute>
      getCustomAttributes() {
    return getCustomAttributesMap();
  }
  /**
   *
   *
   * <pre>
   * A map of fields to hold both filterable and non-filterable custom job
   * attributes that are not covered by the provided structured fields.
   *
   * The keys of the map are strings up to 64 bytes and must match the
   * pattern: `[a-zA-Z][a-zA-Z0-9_]*`. For example, key0LikeThis or
   * KEY_1_LIKE_THIS.
   *
   * At most 100 filterable and at most 100 unfilterable keys are supported.
   * For filterable `string_values`, across all keys at most 200 values are
   * allowed, with each string no more than 255 characters. For unfilterable
   * `string_values`, the maximum total size of `string_values` across all keys
   * is 50KB.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.talent.v4.CustomAttribute&gt; custom_attributes = 10;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.talent.v4.CustomAttribute>
      getCustomAttributesMap() {
    return internalGetCustomAttributes().getMap();
  }
  /**
   *
   *
   * <pre>
   * A map of fields to hold both filterable and non-filterable custom job
   * attributes that are not covered by the provided structured fields.
   *
   * The keys of the map are strings up to 64 bytes and must match the
   * pattern: `[a-zA-Z][a-zA-Z0-9_]*`. For example, key0LikeThis or
   * KEY_1_LIKE_THIS.
   *
   * At most 100 filterable and at most 100 unfilterable keys are supported.
   * For filterable `string_values`, across all keys at most 200 values are
   * allowed, with each string no more than 255 characters. For unfilterable
   * `string_values`, the maximum total size of `string_values` across all keys
   * is 50KB.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.talent.v4.CustomAttribute&gt; custom_attributes = 10;</code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.talent.v4.CustomAttribute getCustomAttributesOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.talent.v4.CustomAttribute defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.talent.v4.CustomAttribute> map =
        internalGetCustomAttributes().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * A map of fields to hold both filterable and non-filterable custom job
   * attributes that are not covered by the provided structured fields.
   *
   * The keys of the map are strings up to 64 bytes and must match the
   * pattern: `[a-zA-Z][a-zA-Z0-9_]*`. For example, key0LikeThis or
   * KEY_1_LIKE_THIS.
   *
   * At most 100 filterable and at most 100 unfilterable keys are supported.
   * For filterable `string_values`, across all keys at most 200 values are
   * allowed, with each string no more than 255 characters. For unfilterable
   * `string_values`, the maximum total size of `string_values` across all keys
   * is 50KB.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.talent.v4.CustomAttribute&gt; custom_attributes = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.CustomAttribute getCustomAttributesOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.talent.v4.CustomAttribute> map =
        internalGetCustomAttributes().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int DEGREE_TYPES_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> degreeTypes_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.talent.v4.DegreeType>
      degreeTypes_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.talent.v4.DegreeType>() {
            public com.google.cloud.talent.v4.DegreeType convert(java.lang.Integer from) {
              com.google.cloud.talent.v4.DegreeType result =
                  com.google.cloud.talent.v4.DegreeType.forNumber(from);
              return result == null ? com.google.cloud.talent.v4.DegreeType.UNRECOGNIZED : result;
            }
          };
  /**
   *
   *
   * <pre>
   * The desired education degrees for the job, such as Bachelors, Masters.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
   *
   * @return A list containing the degreeTypes.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.talent.v4.DegreeType> getDegreeTypesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.talent.v4.DegreeType>(
        degreeTypes_, degreeTypes_converter_);
  }
  /**
   *
   *
   * <pre>
   * The desired education degrees for the job, such as Bachelors, Masters.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
   *
   * @return The count of degreeTypes.
   */
  @java.lang.Override
  public int getDegreeTypesCount() {
    return degreeTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * The desired education degrees for the job, such as Bachelors, Masters.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
   *
   * @param index The index of the element to return.
   * @return The degreeTypes at the given index.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.DegreeType getDegreeTypes(int index) {
    return degreeTypes_converter_.convert(degreeTypes_.get(index));
  }
  /**
   *
   *
   * <pre>
   * The desired education degrees for the job, such as Bachelors, Masters.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
   *
   * @return A list containing the enum numeric values on the wire for degreeTypes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getDegreeTypesValueList() {
    return degreeTypes_;
  }
  /**
   *
   *
   * <pre>
   * The desired education degrees for the job, such as Bachelors, Masters.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of degreeTypes at the given index.
   */
  @java.lang.Override
  public int getDegreeTypesValue(int index) {
    return degreeTypes_.get(index);
  }

  private int degreeTypesMemoizedSerializedSize;

  public static final int DEPARTMENT_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object department_ = "";
  /**
   *
   *
   * <pre>
   * The department or functional area within the company with the open
   * position.
   *
   * The maximum number of allowed characters is 255.
   * </pre>
   *
   * <code>string department = 12;</code>
   *
   * @return The department.
   */
  @java.lang.Override
  public java.lang.String getDepartment() {
    java.lang.Object ref = department_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      department_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The department or functional area within the company with the open
   * position.
   *
   * The maximum number of allowed characters is 255.
   * </pre>
   *
   * <code>string department = 12;</code>
   *
   * @return The bytes for department.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDepartmentBytes() {
    java.lang.Object ref = department_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      department_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EMPLOYMENT_TYPES_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> employmentTypes_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.talent.v4.EmploymentType>
      employmentTypes_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.talent.v4.EmploymentType>() {
            public com.google.cloud.talent.v4.EmploymentType convert(java.lang.Integer from) {
              com.google.cloud.talent.v4.EmploymentType result =
                  com.google.cloud.talent.v4.EmploymentType.forNumber(from);
              return result == null
                  ? com.google.cloud.talent.v4.EmploymentType.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * The employment type(s) of a job, for example,
   * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
   * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
   *
   * @return A list containing the employmentTypes.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.talent.v4.EmploymentType> getEmploymentTypesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.talent.v4.EmploymentType>(
        employmentTypes_, employmentTypes_converter_);
  }
  /**
   *
   *
   * <pre>
   * The employment type(s) of a job, for example,
   * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
   * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
   *
   * @return The count of employmentTypes.
   */
  @java.lang.Override
  public int getEmploymentTypesCount() {
    return employmentTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * The employment type(s) of a job, for example,
   * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
   * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
   *
   * @param index The index of the element to return.
   * @return The employmentTypes at the given index.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.EmploymentType getEmploymentTypes(int index) {
    return employmentTypes_converter_.convert(employmentTypes_.get(index));
  }
  /**
   *
   *
   * <pre>
   * The employment type(s) of a job, for example,
   * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
   * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
   *
   * @return A list containing the enum numeric values on the wire for employmentTypes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getEmploymentTypesValueList() {
    return employmentTypes_;
  }
  /**
   *
   *
   * <pre>
   * The employment type(s) of a job, for example,
   * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
   * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of employmentTypes at the given index.
   */
  @java.lang.Override
  public int getEmploymentTypesValue(int index) {
    return employmentTypes_.get(index);
  }

  private int employmentTypesMemoizedSerializedSize;

  public static final int INCENTIVES_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private volatile java.lang.Object incentives_ = "";
  /**
   *
   *
   * <pre>
   * A description of bonus, commission, and other compensation
   * incentives associated with the job not including salary or pay.
   *
   * The maximum number of allowed characters is 10,000.
   * </pre>
   *
   * <code>string incentives = 14;</code>
   *
   * @return The incentives.
   */
  @java.lang.Override
  public java.lang.String getIncentives() {
    java.lang.Object ref = incentives_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      incentives_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A description of bonus, commission, and other compensation
   * incentives associated with the job not including salary or pay.
   *
   * The maximum number of allowed characters is 10,000.
   * </pre>
   *
   * <code>string incentives = 14;</code>
   *
   * @return The bytes for incentives.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIncentivesBytes() {
    java.lang.Object ref = incentives_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      incentives_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * The language of the posting. This field is distinct from
   * any requirements for fluency that are associated with the job.
   *
   * Language codes must be in BCP-47 format, such as "en-US" or "sr-Latn".
   * For more information, see
   * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47){:
   * class="external" target="_blank" }.
   *
   * If this field is unspecified and
   * [Job.description][google.cloud.talent.v4.Job.description] is present,
   * detected language code based on
   * [Job.description][google.cloud.talent.v4.Job.description] is assigned,
   * otherwise defaults to 'en_US'.
   * </pre>
   *
   * <code>string language_code = 15;</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The language of the posting. This field is distinct from
   * any requirements for fluency that are associated with the job.
   *
   * Language codes must be in BCP-47 format, such as "en-US" or "sr-Latn".
   * For more information, see
   * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47){:
   * class="external" target="_blank" }.
   *
   * If this field is unspecified and
   * [Job.description][google.cloud.talent.v4.Job.description] is present,
   * detected language code based on
   * [Job.description][google.cloud.talent.v4.Job.description] is assigned,
   * otherwise defaults to 'en_US'.
   * </pre>
   *
   * <code>string language_code = 15;</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int JOB_LEVEL_FIELD_NUMBER = 16;
  private int jobLevel_ = 0;
  /**
   *
   *
   * <pre>
   * The experience level associated with the job, such as "Entry Level".
   * </pre>
   *
   * <code>.google.cloud.talent.v4.JobLevel job_level = 16;</code>
   *
   * @return The enum numeric value on the wire for jobLevel.
   */
  @java.lang.Override
  public int getJobLevelValue() {
    return jobLevel_;
  }
  /**
   *
   *
   * <pre>
   * The experience level associated with the job, such as "Entry Level".
   * </pre>
   *
   * <code>.google.cloud.talent.v4.JobLevel job_level = 16;</code>
   *
   * @return The jobLevel.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.JobLevel getJobLevel() {
    com.google.cloud.talent.v4.JobLevel result =
        com.google.cloud.talent.v4.JobLevel.forNumber(jobLevel_);
    return result == null ? com.google.cloud.talent.v4.JobLevel.UNRECOGNIZED : result;
  }

  public static final int PROMOTION_VALUE_FIELD_NUMBER = 17;
  private int promotionValue_ = 0;
  /**
   *
   *
   * <pre>
   * A promotion value of the job, as determined by the client.
   * The value determines the sort order of the jobs returned when searching for
   * jobs using the featured jobs search call, with higher promotional values
   * being returned first and ties being resolved by relevance sort. Only the
   * jobs with a promotionValue &gt;0 are returned in a FEATURED_JOB_SEARCH.
   *
   * Default value is 0, and negative values are treated as 0.
   * </pre>
   *
   * <code>int32 promotion_value = 17;</code>
   *
   * @return The promotionValue.
   */
  @java.lang.Override
  public int getPromotionValue() {
    return promotionValue_;
  }

  public static final int QUALIFICATIONS_FIELD_NUMBER = 18;

  @SuppressWarnings("serial")
  private volatile java.lang.Object qualifications_ = "";
  /**
   *
   *
   * <pre>
   * A description of the qualifications required to perform the
   * job. The use of this field is recommended
   * as an alternative to using the more general
   * [description][google.cloud.talent.v4.Job.description] field.
   *
   * This field accepts and sanitizes HTML input, and also accepts
   * bold, italic, ordered list, and unordered list markup tags.
   *
   * The maximum number of allowed characters is 10,000.
   * </pre>
   *
   * <code>string qualifications = 18;</code>
   *
   * @return The qualifications.
   */
  @java.lang.Override
  public java.lang.String getQualifications() {
    java.lang.Object ref = qualifications_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      qualifications_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A description of the qualifications required to perform the
   * job. The use of this field is recommended
   * as an alternative to using the more general
   * [description][google.cloud.talent.v4.Job.description] field.
   *
   * This field accepts and sanitizes HTML input, and also accepts
   * bold, italic, ordered list, and unordered list markup tags.
   *
   * The maximum number of allowed characters is 10,000.
   * </pre>
   *
   * <code>string qualifications = 18;</code>
   *
   * @return The bytes for qualifications.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQualificationsBytes() {
    java.lang.Object ref = qualifications_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      qualifications_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESPONSIBILITIES_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private volatile java.lang.Object responsibilities_ = "";
  /**
   *
   *
   * <pre>
   * A description of job responsibilities. The use of this field is
   * recommended as an alternative to using the more general
   * [description][google.cloud.talent.v4.Job.description] field.
   *
   * This field accepts and sanitizes HTML input, and also accepts
   * bold, italic, ordered list, and unordered list markup tags.
   *
   * The maximum number of allowed characters is 10,000.
   * </pre>
   *
   * <code>string responsibilities = 19;</code>
   *
   * @return The responsibilities.
   */
  @java.lang.Override
  public java.lang.String getResponsibilities() {
    java.lang.Object ref = responsibilities_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      responsibilities_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A description of job responsibilities. The use of this field is
   * recommended as an alternative to using the more general
   * [description][google.cloud.talent.v4.Job.description] field.
   *
   * This field accepts and sanitizes HTML input, and also accepts
   * bold, italic, ordered list, and unordered list markup tags.
   *
   * The maximum number of allowed characters is 10,000.
   * </pre>
   *
   * <code>string responsibilities = 19;</code>
   *
   * @return The bytes for responsibilities.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getResponsibilitiesBytes() {
    java.lang.Object ref = responsibilities_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      responsibilities_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int POSTING_REGION_FIELD_NUMBER = 20;
  private int postingRegion_ = 0;
  /**
   *
   *
   * <pre>
   * The job [PostingRegion][google.cloud.talent.v4.PostingRegion] (for example,
   * state, country) throughout which the job is available. If this field is
   * set, a [LocationFilter][google.cloud.talent.v4.LocationFilter] in a search
   * query within the job region finds this job posting if an exact location
   * match isn't specified. If this field is set to
   * [PostingRegion.NATION][google.cloud.talent.v4.PostingRegion.NATION] or
   * [PostingRegion.ADMINISTRATIVE_AREA][google.cloud.talent.v4.PostingRegion.ADMINISTRATIVE_AREA],
   * setting job [Job.addresses][google.cloud.talent.v4.Job.addresses] to the
   * same location level as this field is strongly recommended.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.PostingRegion posting_region = 20;</code>
   *
   * @return The enum numeric value on the wire for postingRegion.
   */
  @java.lang.Override
  public int getPostingRegionValue() {
    return postingRegion_;
  }
  /**
   *
   *
   * <pre>
   * The job [PostingRegion][google.cloud.talent.v4.PostingRegion] (for example,
   * state, country) throughout which the job is available. If this field is
   * set, a [LocationFilter][google.cloud.talent.v4.LocationFilter] in a search
   * query within the job region finds this job posting if an exact location
   * match isn't specified. If this field is set to
   * [PostingRegion.NATION][google.cloud.talent.v4.PostingRegion.NATION] or
   * [PostingRegion.ADMINISTRATIVE_AREA][google.cloud.talent.v4.PostingRegion.ADMINISTRATIVE_AREA],
   * setting job [Job.addresses][google.cloud.talent.v4.Job.addresses] to the
   * same location level as this field is strongly recommended.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.PostingRegion posting_region = 20;</code>
   *
   * @return The postingRegion.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.PostingRegion getPostingRegion() {
    com.google.cloud.talent.v4.PostingRegion result =
        com.google.cloud.talent.v4.PostingRegion.forNumber(postingRegion_);
    return result == null ? com.google.cloud.talent.v4.PostingRegion.UNRECOGNIZED : result;
  }

  public static final int VISIBILITY_FIELD_NUMBER = 21;
  private int visibility_ = 0;
  /**
   *
   *
   * <pre>
   * Deprecated. The job is only visible to the owner.
   *
   * The visibility of the job.
   *
   * Defaults to
   * [Visibility.ACCOUNT_ONLY][google.cloud.talent.v4.Visibility.ACCOUNT_ONLY]
   * if not specified.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.Visibility visibility = 21 [deprecated = true];</code>
   *
   * @deprecated google.cloud.talent.v4.Job.visibility is deprecated. See
   *     google/cloud/talent/v4/job.proto;l=295
   * @return The enum numeric value on the wire for visibility.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getVisibilityValue() {
    return visibility_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated. The job is only visible to the owner.
   *
   * The visibility of the job.
   *
   * Defaults to
   * [Visibility.ACCOUNT_ONLY][google.cloud.talent.v4.Visibility.ACCOUNT_ONLY]
   * if not specified.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.Visibility visibility = 21 [deprecated = true];</code>
   *
   * @deprecated google.cloud.talent.v4.Job.visibility is deprecated. See
   *     google/cloud/talent/v4/job.proto;l=295
   * @return The visibility.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.talent.v4.Visibility getVisibility() {
    com.google.cloud.talent.v4.Visibility result =
        com.google.cloud.talent.v4.Visibility.forNumber(visibility_);
    return result == null ? com.google.cloud.talent.v4.Visibility.UNRECOGNIZED : result;
  }

  public static final int JOB_START_TIME_FIELD_NUMBER = 22;
  private com.google.protobuf.Timestamp jobStartTime_;
  /**
   *
   *
   * <pre>
   * The start timestamp of the job in UTC time zone. Typically this field
   * is used for contracting engagements. Invalid timestamps are ignored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp job_start_time = 22;</code>
   *
   * @return Whether the jobStartTime field is set.
   */
  @java.lang.Override
  public boolean hasJobStartTime() {
    return jobStartTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The start timestamp of the job in UTC time zone. Typically this field
   * is used for contracting engagements. Invalid timestamps are ignored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp job_start_time = 22;</code>
   *
   * @return The jobStartTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getJobStartTime() {
    return jobStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : jobStartTime_;
  }
  /**
   *
   *
   * <pre>
   * The start timestamp of the job in UTC time zone. Typically this field
   * is used for contracting engagements. Invalid timestamps are ignored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp job_start_time = 22;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getJobStartTimeOrBuilder() {
    return jobStartTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : jobStartTime_;
  }

  public static final int JOB_END_TIME_FIELD_NUMBER = 23;
  private com.google.protobuf.Timestamp jobEndTime_;
  /**
   *
   *
   * <pre>
   * The end timestamp of the job. Typically this field is used for contracting
   * engagements. Invalid timestamps are ignored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp job_end_time = 23;</code>
   *
   * @return Whether the jobEndTime field is set.
   */
  @java.lang.Override
  public boolean hasJobEndTime() {
    return jobEndTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The end timestamp of the job. Typically this field is used for contracting
   * engagements. Invalid timestamps are ignored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp job_end_time = 23;</code>
   *
   * @return The jobEndTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getJobEndTime() {
    return jobEndTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : jobEndTime_;
  }
  /**
   *
   *
   * <pre>
   * The end timestamp of the job. Typically this field is used for contracting
   * engagements. Invalid timestamps are ignored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp job_end_time = 23;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getJobEndTimeOrBuilder() {
    return jobEndTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : jobEndTime_;
  }

  public static final int POSTING_PUBLISH_TIME_FIELD_NUMBER = 24;
  private com.google.protobuf.Timestamp postingPublishTime_;
  /**
   *
   *
   * <pre>
   * The timestamp this job posting was most recently published. The default
   * value is the time the request arrives at the server. Invalid timestamps are
   * ignored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp posting_publish_time = 24;</code>
   *
   * @return Whether the postingPublishTime field is set.
   */
  @java.lang.Override
  public boolean hasPostingPublishTime() {
    return postingPublishTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The timestamp this job posting was most recently published. The default
   * value is the time the request arrives at the server. Invalid timestamps are
   * ignored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp posting_publish_time = 24;</code>
   *
   * @return The postingPublishTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getPostingPublishTime() {
    return postingPublishTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : postingPublishTime_;
  }
  /**
   *
   *
   * <pre>
   * The timestamp this job posting was most recently published. The default
   * value is the time the request arrives at the server. Invalid timestamps are
   * ignored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp posting_publish_time = 24;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getPostingPublishTimeOrBuilder() {
    return postingPublishTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : postingPublishTime_;
  }

  public static final int POSTING_EXPIRE_TIME_FIELD_NUMBER = 25;
  private com.google.protobuf.Timestamp postingExpireTime_;
  /**
   *
   *
   * <pre>
   * Strongly recommended for the best service experience.
   *
   * The expiration timestamp of the job. After this timestamp, the
   * job is marked as expired, and it no longer appears in search results. The
   * expired job can't be listed by the
   * [ListJobs][google.cloud.talent.v4.JobService.ListJobs] API, but it can be
   * retrieved with the [GetJob][google.cloud.talent.v4.JobService.GetJob] API
   * or updated with the
   * [UpdateJob][google.cloud.talent.v4.JobService.UpdateJob] API or deleted
   * with the [DeleteJob][google.cloud.talent.v4.JobService.DeleteJob] API. An
   * expired job can be updated and opened again by using a future expiration
   * timestamp. Updating an expired job fails if there is another existing open
   * job with same [company][google.cloud.talent.v4.Job.company],
   * [language_code][google.cloud.talent.v4.Job.language_code] and
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
   *
   * The expired jobs are retained in our system for 90 days. However, the
   * overall expired job count cannot exceed 3 times the maximum number of
   * open jobs over previous 7 days. If this threshold is exceeded,
   * expired jobs are cleaned out in order of earliest expire time.
   * Expired jobs are no longer accessible after they are cleaned
   * out.
   *
   * Invalid timestamps are ignored, and treated as expire time not provided.
   *
   * If the timestamp is before the instant request is made, the job
   * is treated as expired immediately on creation. This kind of job can
   * not be updated. And when creating a job with past timestamp, the
   * [posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   * must be set before
   * [posting_expire_time][google.cloud.talent.v4.Job.posting_expire_time]. The
   * purpose of this feature is to allow other objects, such as [Application][],
   * to refer a job that didn't exist in the system prior to becoming expired.
   * If you want to modify a job that was expired on creation, delete it and
   * create a new one.
   *
   * If this value isn't provided at the time of job creation or is invalid,
   * the job posting expires after 30 days from the job's creation time. For
   * example, if the job was created on 2017/01/01 13:00AM UTC with an
   * unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC.
   *
   * If this value isn't provided on job update, it depends on the field masks
   * set by
   * [UpdateJobRequest.update_mask][google.cloud.talent.v4.UpdateJobRequest.update_mask].
   * If the field masks include
   * [job_end_time][google.cloud.talent.v4.Job.job_end_time], or the masks are
   * empty meaning that every field is updated, the job posting expires after 30
   * days from the job's last update time. Otherwise the expiration date isn't
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp posting_expire_time = 25;</code>
   *
   * @return Whether the postingExpireTime field is set.
   */
  @java.lang.Override
  public boolean hasPostingExpireTime() {
    return postingExpireTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Strongly recommended for the best service experience.
   *
   * The expiration timestamp of the job. After this timestamp, the
   * job is marked as expired, and it no longer appears in search results. The
   * expired job can't be listed by the
   * [ListJobs][google.cloud.talent.v4.JobService.ListJobs] API, but it can be
   * retrieved with the [GetJob][google.cloud.talent.v4.JobService.GetJob] API
   * or updated with the
   * [UpdateJob][google.cloud.talent.v4.JobService.UpdateJob] API or deleted
   * with the [DeleteJob][google.cloud.talent.v4.JobService.DeleteJob] API. An
   * expired job can be updated and opened again by using a future expiration
   * timestamp. Updating an expired job fails if there is another existing open
   * job with same [company][google.cloud.talent.v4.Job.company],
   * [language_code][google.cloud.talent.v4.Job.language_code] and
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
   *
   * The expired jobs are retained in our system for 90 days. However, the
   * overall expired job count cannot exceed 3 times the maximum number of
   * open jobs over previous 7 days. If this threshold is exceeded,
   * expired jobs are cleaned out in order of earliest expire time.
   * Expired jobs are no longer accessible after they are cleaned
   * out.
   *
   * Invalid timestamps are ignored, and treated as expire time not provided.
   *
   * If the timestamp is before the instant request is made, the job
   * is treated as expired immediately on creation. This kind of job can
   * not be updated. And when creating a job with past timestamp, the
   * [posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   * must be set before
   * [posting_expire_time][google.cloud.talent.v4.Job.posting_expire_time]. The
   * purpose of this feature is to allow other objects, such as [Application][],
   * to refer a job that didn't exist in the system prior to becoming expired.
   * If you want to modify a job that was expired on creation, delete it and
   * create a new one.
   *
   * If this value isn't provided at the time of job creation or is invalid,
   * the job posting expires after 30 days from the job's creation time. For
   * example, if the job was created on 2017/01/01 13:00AM UTC with an
   * unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC.
   *
   * If this value isn't provided on job update, it depends on the field masks
   * set by
   * [UpdateJobRequest.update_mask][google.cloud.talent.v4.UpdateJobRequest.update_mask].
   * If the field masks include
   * [job_end_time][google.cloud.talent.v4.Job.job_end_time], or the masks are
   * empty meaning that every field is updated, the job posting expires after 30
   * days from the job's last update time. Otherwise the expiration date isn't
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp posting_expire_time = 25;</code>
   *
   * @return The postingExpireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getPostingExpireTime() {
    return postingExpireTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : postingExpireTime_;
  }
  /**
   *
   *
   * <pre>
   * Strongly recommended for the best service experience.
   *
   * The expiration timestamp of the job. After this timestamp, the
   * job is marked as expired, and it no longer appears in search results. The
   * expired job can't be listed by the
   * [ListJobs][google.cloud.talent.v4.JobService.ListJobs] API, but it can be
   * retrieved with the [GetJob][google.cloud.talent.v4.JobService.GetJob] API
   * or updated with the
   * [UpdateJob][google.cloud.talent.v4.JobService.UpdateJob] API or deleted
   * with the [DeleteJob][google.cloud.talent.v4.JobService.DeleteJob] API. An
   * expired job can be updated and opened again by using a future expiration
   * timestamp. Updating an expired job fails if there is another existing open
   * job with same [company][google.cloud.talent.v4.Job.company],
   * [language_code][google.cloud.talent.v4.Job.language_code] and
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
   *
   * The expired jobs are retained in our system for 90 days. However, the
   * overall expired job count cannot exceed 3 times the maximum number of
   * open jobs over previous 7 days. If this threshold is exceeded,
   * expired jobs are cleaned out in order of earliest expire time.
   * Expired jobs are no longer accessible after they are cleaned
   * out.
   *
   * Invalid timestamps are ignored, and treated as expire time not provided.
   *
   * If the timestamp is before the instant request is made, the job
   * is treated as expired immediately on creation. This kind of job can
   * not be updated. And when creating a job with past timestamp, the
   * [posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   * must be set before
   * [posting_expire_time][google.cloud.talent.v4.Job.posting_expire_time]. The
   * purpose of this feature is to allow other objects, such as [Application][],
   * to refer a job that didn't exist in the system prior to becoming expired.
   * If you want to modify a job that was expired on creation, delete it and
   * create a new one.
   *
   * If this value isn't provided at the time of job creation or is invalid,
   * the job posting expires after 30 days from the job's creation time. For
   * example, if the job was created on 2017/01/01 13:00AM UTC with an
   * unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC.
   *
   * If this value isn't provided on job update, it depends on the field masks
   * set by
   * [UpdateJobRequest.update_mask][google.cloud.talent.v4.UpdateJobRequest.update_mask].
   * If the field masks include
   * [job_end_time][google.cloud.talent.v4.Job.job_end_time], or the masks are
   * empty meaning that every field is updated, the job posting expires after 30
   * days from the job's last update time. Otherwise the expiration date isn't
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp posting_expire_time = 25;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getPostingExpireTimeOrBuilder() {
    return postingExpireTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : postingExpireTime_;
  }

  public static final int POSTING_CREATE_TIME_FIELD_NUMBER = 26;
  private com.google.protobuf.Timestamp postingCreateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this job posting was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp posting_create_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the postingCreateTime field is set.
   */
  @java.lang.Override
  public boolean hasPostingCreateTime() {
    return postingCreateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this job posting was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp posting_create_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The postingCreateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getPostingCreateTime() {
    return postingCreateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : postingCreateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this job posting was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp posting_create_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getPostingCreateTimeOrBuilder() {
    return postingCreateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : postingCreateTime_;
  }

  public static final int POSTING_UPDATE_TIME_FIELD_NUMBER = 27;
  private com.google.protobuf.Timestamp postingUpdateTime_;
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this job posting was last updated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp posting_update_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the postingUpdateTime field is set.
   */
  @java.lang.Override
  public boolean hasPostingUpdateTime() {
    return postingUpdateTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this job posting was last updated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp posting_update_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The postingUpdateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getPostingUpdateTime() {
    return postingUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : postingUpdateTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this job posting was last updated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp posting_update_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getPostingUpdateTimeOrBuilder() {
    return postingUpdateTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : postingUpdateTime_;
  }

  public static final int COMPANY_DISPLAY_NAME_FIELD_NUMBER = 28;

  @SuppressWarnings("serial")
  private volatile java.lang.Object companyDisplayName_ = "";
  /**
   *
   *
   * <pre>
   * Output only. Display name of the company listing the job.
   * </pre>
   *
   * <code>string company_display_name = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The companyDisplayName.
   */
  @java.lang.Override
  public java.lang.String getCompanyDisplayName() {
    java.lang.Object ref = companyDisplayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      companyDisplayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. Display name of the company listing the job.
   * </pre>
   *
   * <code>string company_display_name = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for companyDisplayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCompanyDisplayNameBytes() {
    java.lang.Object ref = companyDisplayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      companyDisplayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DERIVED_INFO_FIELD_NUMBER = 29;
  private com.google.cloud.talent.v4.Job.DerivedInfo derivedInfo_;
  /**
   *
   *
   * <pre>
   * Output only. Derived details about the job posting.
   * </pre>
   *
   * <code>
   * .google.cloud.talent.v4.Job.DerivedInfo derived_info = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the derivedInfo field is set.
   */
  @java.lang.Override
  public boolean hasDerivedInfo() {
    return derivedInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. Derived details about the job posting.
   * </pre>
   *
   * <code>
   * .google.cloud.talent.v4.Job.DerivedInfo derived_info = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The derivedInfo.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.Job.DerivedInfo getDerivedInfo() {
    return derivedInfo_ == null
        ? com.google.cloud.talent.v4.Job.DerivedInfo.getDefaultInstance()
        : derivedInfo_;
  }
  /**
   *
   *
   * <pre>
   * Output only. Derived details about the job posting.
   * </pre>
   *
   * <code>
   * .google.cloud.talent.v4.Job.DerivedInfo derived_info = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.Job.DerivedInfoOrBuilder getDerivedInfoOrBuilder() {
    return derivedInfo_ == null
        ? com.google.cloud.talent.v4.Job.DerivedInfo.getDefaultInstance()
        : derivedInfo_;
  }

  public static final int PROCESSING_OPTIONS_FIELD_NUMBER = 30;
  private com.google.cloud.talent.v4.Job.ProcessingOptions processingOptions_;
  /**
   *
   *
   * <pre>
   * Options for job processing.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.Job.ProcessingOptions processing_options = 30;</code>
   *
   * @return Whether the processingOptions field is set.
   */
  @java.lang.Override
  public boolean hasProcessingOptions() {
    return processingOptions_ != null;
  }
  /**
   *
   *
   * <pre>
   * Options for job processing.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.Job.ProcessingOptions processing_options = 30;</code>
   *
   * @return The processingOptions.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.Job.ProcessingOptions getProcessingOptions() {
    return processingOptions_ == null
        ? com.google.cloud.talent.v4.Job.ProcessingOptions.getDefaultInstance()
        : processingOptions_;
  }
  /**
   *
   *
   * <pre>
   * Options for job processing.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.Job.ProcessingOptions processing_options = 30;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.Job.ProcessingOptionsOrBuilder getProcessingOptionsOrBuilder() {
    return processingOptions_ == null
        ? com.google.cloud.talent.v4.Job.ProcessingOptions.getDefaultInstance()
        : processingOptions_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(company_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, company_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requisitionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, requisitionId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, title_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, description_);
    }
    for (int i = 0; i < addresses_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, addresses_.getRaw(i));
    }
    if (applicationInfo_ != null) {
      output.writeMessage(7, getApplicationInfo());
    }
    if (getJobBenefitsList().size() > 0) {
      output.writeUInt32NoTag(66);
      output.writeUInt32NoTag(jobBenefitsMemoizedSerializedSize);
    }
    for (int i = 0; i < jobBenefits_.size(); i++) {
      output.writeEnumNoTag(jobBenefits_.get(i));
    }
    if (compensationInfo_ != null) {
      output.writeMessage(9, getCompensationInfo());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetCustomAttributes(), CustomAttributesDefaultEntryHolder.defaultEntry, 10);
    if (getDegreeTypesList().size() > 0) {
      output.writeUInt32NoTag(90);
      output.writeUInt32NoTag(degreeTypesMemoizedSerializedSize);
    }
    for (int i = 0; i < degreeTypes_.size(); i++) {
      output.writeEnumNoTag(degreeTypes_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(department_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, department_);
    }
    if (getEmploymentTypesList().size() > 0) {
      output.writeUInt32NoTag(106);
      output.writeUInt32NoTag(employmentTypesMemoizedSerializedSize);
    }
    for (int i = 0; i < employmentTypes_.size(); i++) {
      output.writeEnumNoTag(employmentTypes_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(incentives_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, incentives_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, languageCode_);
    }
    if (jobLevel_ != com.google.cloud.talent.v4.JobLevel.JOB_LEVEL_UNSPECIFIED.getNumber()) {
      output.writeEnum(16, jobLevel_);
    }
    if (promotionValue_ != 0) {
      output.writeInt32(17, promotionValue_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(qualifications_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, qualifications_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(responsibilities_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, responsibilities_);
    }
    if (postingRegion_
        != com.google.cloud.talent.v4.PostingRegion.POSTING_REGION_UNSPECIFIED.getNumber()) {
      output.writeEnum(20, postingRegion_);
    }
    if (visibility_ != com.google.cloud.talent.v4.Visibility.VISIBILITY_UNSPECIFIED.getNumber()) {
      output.writeEnum(21, visibility_);
    }
    if (jobStartTime_ != null) {
      output.writeMessage(22, getJobStartTime());
    }
    if (jobEndTime_ != null) {
      output.writeMessage(23, getJobEndTime());
    }
    if (postingPublishTime_ != null) {
      output.writeMessage(24, getPostingPublishTime());
    }
    if (postingExpireTime_ != null) {
      output.writeMessage(25, getPostingExpireTime());
    }
    if (postingCreateTime_ != null) {
      output.writeMessage(26, getPostingCreateTime());
    }
    if (postingUpdateTime_ != null) {
      output.writeMessage(27, getPostingUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(companyDisplayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 28, companyDisplayName_);
    }
    if (derivedInfo_ != null) {
      output.writeMessage(29, getDerivedInfo());
    }
    if (processingOptions_ != null) {
      output.writeMessage(30, getProcessingOptions());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(company_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, company_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requisitionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, requisitionId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(title_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, title_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, description_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < addresses_.size(); i++) {
        dataSize += computeStringSizeNoTag(addresses_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAddressesList().size();
    }
    if (applicationInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getApplicationInfo());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < jobBenefits_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(jobBenefits_.get(i));
      }
      size += dataSize;
      if (!getJobBenefitsList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      jobBenefitsMemoizedSerializedSize = dataSize;
    }
    if (compensationInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getCompensationInfo());
    }
    for (java.util.Map.Entry<java.lang.String, com.google.cloud.talent.v4.CustomAttribute> entry :
        internalGetCustomAttributes().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, com.google.cloud.talent.v4.CustomAttribute>
          customAttributes__ =
              CustomAttributesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, customAttributes__);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < degreeTypes_.size(); i++) {
        dataSize += com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(degreeTypes_.get(i));
      }
      size += dataSize;
      if (!getDegreeTypesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      degreeTypesMemoizedSerializedSize = dataSize;
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(department_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, department_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < employmentTypes_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(employmentTypes_.get(i));
      }
      size += dataSize;
      if (!getEmploymentTypesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      employmentTypesMemoizedSerializedSize = dataSize;
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(incentives_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, incentives_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, languageCode_);
    }
    if (jobLevel_ != com.google.cloud.talent.v4.JobLevel.JOB_LEVEL_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(16, jobLevel_);
    }
    if (promotionValue_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(17, promotionValue_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(qualifications_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, qualifications_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(responsibilities_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, responsibilities_);
    }
    if (postingRegion_
        != com.google.cloud.talent.v4.PostingRegion.POSTING_REGION_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(20, postingRegion_);
    }
    if (visibility_ != com.google.cloud.talent.v4.Visibility.VISIBILITY_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(21, visibility_);
    }
    if (jobStartTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(22, getJobStartTime());
    }
    if (jobEndTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(23, getJobEndTime());
    }
    if (postingPublishTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(24, getPostingPublishTime());
    }
    if (postingExpireTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(25, getPostingExpireTime());
    }
    if (postingCreateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(26, getPostingCreateTime());
    }
    if (postingUpdateTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(27, getPostingUpdateTime());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(companyDisplayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(28, companyDisplayName_);
    }
    if (derivedInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(29, getDerivedInfo());
    }
    if (processingOptions_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(30, getProcessingOptions());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.talent.v4.Job)) {
      return super.equals(obj);
    }
    com.google.cloud.talent.v4.Job other = (com.google.cloud.talent.v4.Job) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getCompany().equals(other.getCompany())) return false;
    if (!getRequisitionId().equals(other.getRequisitionId())) return false;
    if (!getTitle().equals(other.getTitle())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (!getAddressesList().equals(other.getAddressesList())) return false;
    if (hasApplicationInfo() != other.hasApplicationInfo()) return false;
    if (hasApplicationInfo()) {
      if (!getApplicationInfo().equals(other.getApplicationInfo())) return false;
    }
    if (!jobBenefits_.equals(other.jobBenefits_)) return false;
    if (hasCompensationInfo() != other.hasCompensationInfo()) return false;
    if (hasCompensationInfo()) {
      if (!getCompensationInfo().equals(other.getCompensationInfo())) return false;
    }
    if (!internalGetCustomAttributes().equals(other.internalGetCustomAttributes())) return false;
    if (!degreeTypes_.equals(other.degreeTypes_)) return false;
    if (!getDepartment().equals(other.getDepartment())) return false;
    if (!employmentTypes_.equals(other.employmentTypes_)) return false;
    if (!getIncentives().equals(other.getIncentives())) return false;
    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (jobLevel_ != other.jobLevel_) return false;
    if (getPromotionValue() != other.getPromotionValue()) return false;
    if (!getQualifications().equals(other.getQualifications())) return false;
    if (!getResponsibilities().equals(other.getResponsibilities())) return false;
    if (postingRegion_ != other.postingRegion_) return false;
    if (visibility_ != other.visibility_) return false;
    if (hasJobStartTime() != other.hasJobStartTime()) return false;
    if (hasJobStartTime()) {
      if (!getJobStartTime().equals(other.getJobStartTime())) return false;
    }
    if (hasJobEndTime() != other.hasJobEndTime()) return false;
    if (hasJobEndTime()) {
      if (!getJobEndTime().equals(other.getJobEndTime())) return false;
    }
    if (hasPostingPublishTime() != other.hasPostingPublishTime()) return false;
    if (hasPostingPublishTime()) {
      if (!getPostingPublishTime().equals(other.getPostingPublishTime())) return false;
    }
    if (hasPostingExpireTime() != other.hasPostingExpireTime()) return false;
    if (hasPostingExpireTime()) {
      if (!getPostingExpireTime().equals(other.getPostingExpireTime())) return false;
    }
    if (hasPostingCreateTime() != other.hasPostingCreateTime()) return false;
    if (hasPostingCreateTime()) {
      if (!getPostingCreateTime().equals(other.getPostingCreateTime())) return false;
    }
    if (hasPostingUpdateTime() != other.hasPostingUpdateTime()) return false;
    if (hasPostingUpdateTime()) {
      if (!getPostingUpdateTime().equals(other.getPostingUpdateTime())) return false;
    }
    if (!getCompanyDisplayName().equals(other.getCompanyDisplayName())) return false;
    if (hasDerivedInfo() != other.hasDerivedInfo()) return false;
    if (hasDerivedInfo()) {
      if (!getDerivedInfo().equals(other.getDerivedInfo())) return false;
    }
    if (hasProcessingOptions() != other.hasProcessingOptions()) return false;
    if (hasProcessingOptions()) {
      if (!getProcessingOptions().equals(other.getProcessingOptions())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + COMPANY_FIELD_NUMBER;
    hash = (53 * hash) + getCompany().hashCode();
    hash = (37 * hash) + REQUISITION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getRequisitionId().hashCode();
    hash = (37 * hash) + TITLE_FIELD_NUMBER;
    hash = (53 * hash) + getTitle().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (getAddressesCount() > 0) {
      hash = (37 * hash) + ADDRESSES_FIELD_NUMBER;
      hash = (53 * hash) + getAddressesList().hashCode();
    }
    if (hasApplicationInfo()) {
      hash = (37 * hash) + APPLICATION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getApplicationInfo().hashCode();
    }
    if (getJobBenefitsCount() > 0) {
      hash = (37 * hash) + JOB_BENEFITS_FIELD_NUMBER;
      hash = (53 * hash) + jobBenefits_.hashCode();
    }
    if (hasCompensationInfo()) {
      hash = (37 * hash) + COMPENSATION_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getCompensationInfo().hashCode();
    }
    if (!internalGetCustomAttributes().getMap().isEmpty()) {
      hash = (37 * hash) + CUSTOM_ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetCustomAttributes().hashCode();
    }
    if (getDegreeTypesCount() > 0) {
      hash = (37 * hash) + DEGREE_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + degreeTypes_.hashCode();
    }
    hash = (37 * hash) + DEPARTMENT_FIELD_NUMBER;
    hash = (53 * hash) + getDepartment().hashCode();
    if (getEmploymentTypesCount() > 0) {
      hash = (37 * hash) + EMPLOYMENT_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + employmentTypes_.hashCode();
    }
    hash = (37 * hash) + INCENTIVES_FIELD_NUMBER;
    hash = (53 * hash) + getIncentives().hashCode();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    hash = (37 * hash) + JOB_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + jobLevel_;
    hash = (37 * hash) + PROMOTION_VALUE_FIELD_NUMBER;
    hash = (53 * hash) + getPromotionValue();
    hash = (37 * hash) + QUALIFICATIONS_FIELD_NUMBER;
    hash = (53 * hash) + getQualifications().hashCode();
    hash = (37 * hash) + RESPONSIBILITIES_FIELD_NUMBER;
    hash = (53 * hash) + getResponsibilities().hashCode();
    hash = (37 * hash) + POSTING_REGION_FIELD_NUMBER;
    hash = (53 * hash) + postingRegion_;
    hash = (37 * hash) + VISIBILITY_FIELD_NUMBER;
    hash = (53 * hash) + visibility_;
    if (hasJobStartTime()) {
      hash = (37 * hash) + JOB_START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getJobStartTime().hashCode();
    }
    if (hasJobEndTime()) {
      hash = (37 * hash) + JOB_END_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getJobEndTime().hashCode();
    }
    if (hasPostingPublishTime()) {
      hash = (37 * hash) + POSTING_PUBLISH_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getPostingPublishTime().hashCode();
    }
    if (hasPostingExpireTime()) {
      hash = (37 * hash) + POSTING_EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getPostingExpireTime().hashCode();
    }
    if (hasPostingCreateTime()) {
      hash = (37 * hash) + POSTING_CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getPostingCreateTime().hashCode();
    }
    if (hasPostingUpdateTime()) {
      hash = (37 * hash) + POSTING_UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getPostingUpdateTime().hashCode();
    }
    hash = (37 * hash) + COMPANY_DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getCompanyDisplayName().hashCode();
    if (hasDerivedInfo()) {
      hash = (37 * hash) + DERIVED_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getDerivedInfo().hashCode();
    }
    if (hasProcessingOptions()) {
      hash = (37 * hash) + PROCESSING_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getProcessingOptions().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.talent.v4.Job parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.Job parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.Job parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.Job parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.Job parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.Job parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.Job parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.Job parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.Job parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.Job parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.Job parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.Job parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.talent.v4.Job prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A Job resource represents a job posting (also referred to as a "job listing"
   * or "job requisition"). A job belongs to a
   * [Company][google.cloud.talent.v4.Company], which is the hiring entity
   * responsible for the job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.talent.v4.Job}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.talent.v4.Job)
      com.google.cloud.talent.v4.JobOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.talent.v4.JobProto
          .internal_static_google_cloud_talent_v4_Job_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 10:
          return internalGetCustomAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 10:
          return internalGetMutableCustomAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.talent.v4.JobProto
          .internal_static_google_cloud_talent_v4_Job_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.talent.v4.Job.class, com.google.cloud.talent.v4.Job.Builder.class);
    }

    // Construct using com.google.cloud.talent.v4.Job.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      company_ = "";
      requisitionId_ = "";
      title_ = "";
      description_ = "";
      addresses_ = com.google.protobuf.LazyStringArrayList.emptyList();
      applicationInfo_ = null;
      if (applicationInfoBuilder_ != null) {
        applicationInfoBuilder_.dispose();
        applicationInfoBuilder_ = null;
      }
      jobBenefits_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      compensationInfo_ = null;
      if (compensationInfoBuilder_ != null) {
        compensationInfoBuilder_.dispose();
        compensationInfoBuilder_ = null;
      }
      internalGetMutableCustomAttributes().clear();
      degreeTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);
      department_ = "";
      employmentTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00001000);
      incentives_ = "";
      languageCode_ = "";
      jobLevel_ = 0;
      promotionValue_ = 0;
      qualifications_ = "";
      responsibilities_ = "";
      postingRegion_ = 0;
      visibility_ = 0;
      jobStartTime_ = null;
      if (jobStartTimeBuilder_ != null) {
        jobStartTimeBuilder_.dispose();
        jobStartTimeBuilder_ = null;
      }
      jobEndTime_ = null;
      if (jobEndTimeBuilder_ != null) {
        jobEndTimeBuilder_.dispose();
        jobEndTimeBuilder_ = null;
      }
      postingPublishTime_ = null;
      if (postingPublishTimeBuilder_ != null) {
        postingPublishTimeBuilder_.dispose();
        postingPublishTimeBuilder_ = null;
      }
      postingExpireTime_ = null;
      if (postingExpireTimeBuilder_ != null) {
        postingExpireTimeBuilder_.dispose();
        postingExpireTimeBuilder_ = null;
      }
      postingCreateTime_ = null;
      if (postingCreateTimeBuilder_ != null) {
        postingCreateTimeBuilder_.dispose();
        postingCreateTimeBuilder_ = null;
      }
      postingUpdateTime_ = null;
      if (postingUpdateTimeBuilder_ != null) {
        postingUpdateTimeBuilder_.dispose();
        postingUpdateTimeBuilder_ = null;
      }
      companyDisplayName_ = "";
      derivedInfo_ = null;
      if (derivedInfoBuilder_ != null) {
        derivedInfoBuilder_.dispose();
        derivedInfoBuilder_ = null;
      }
      processingOptions_ = null;
      if (processingOptionsBuilder_ != null) {
        processingOptionsBuilder_.dispose();
        processingOptionsBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.talent.v4.JobProto
          .internal_static_google_cloud_talent_v4_Job_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.Job getDefaultInstanceForType() {
      return com.google.cloud.talent.v4.Job.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.Job build() {
      com.google.cloud.talent.v4.Job result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.Job buildPartial() {
      com.google.cloud.talent.v4.Job result = new com.google.cloud.talent.v4.Job(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.talent.v4.Job result) {
      if (((bitField0_ & 0x00000080) != 0)) {
        jobBenefits_ = java.util.Collections.unmodifiableList(jobBenefits_);
        bitField0_ = (bitField0_ & ~0x00000080);
      }
      result.jobBenefits_ = jobBenefits_;
      if (((bitField0_ & 0x00000400) != 0)) {
        degreeTypes_ = java.util.Collections.unmodifiableList(degreeTypes_);
        bitField0_ = (bitField0_ & ~0x00000400);
      }
      result.degreeTypes_ = degreeTypes_;
      if (((bitField0_ & 0x00001000) != 0)) {
        employmentTypes_ = java.util.Collections.unmodifiableList(employmentTypes_);
        bitField0_ = (bitField0_ & ~0x00001000);
      }
      result.employmentTypes_ = employmentTypes_;
    }

    private void buildPartial0(com.google.cloud.talent.v4.Job result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.company_ = company_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.requisitionId_ = requisitionId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.title_ = title_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        addresses_.makeImmutable();
        result.addresses_ = addresses_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.applicationInfo_ =
            applicationInfoBuilder_ == null ? applicationInfo_ : applicationInfoBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.compensationInfo_ =
            compensationInfoBuilder_ == null ? compensationInfo_ : compensationInfoBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.customAttributes_ = internalGetCustomAttributes();
        result.customAttributes_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.department_ = department_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.incentives_ = incentives_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.languageCode_ = languageCode_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.jobLevel_ = jobLevel_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.promotionValue_ = promotionValue_;
      }
      if (((from_bitField0_ & 0x00020000) != 0)) {
        result.qualifications_ = qualifications_;
      }
      if (((from_bitField0_ & 0x00040000) != 0)) {
        result.responsibilities_ = responsibilities_;
      }
      if (((from_bitField0_ & 0x00080000) != 0)) {
        result.postingRegion_ = postingRegion_;
      }
      if (((from_bitField0_ & 0x00100000) != 0)) {
        result.visibility_ = visibility_;
      }
      if (((from_bitField0_ & 0x00200000) != 0)) {
        result.jobStartTime_ =
            jobStartTimeBuilder_ == null ? jobStartTime_ : jobStartTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00400000) != 0)) {
        result.jobEndTime_ = jobEndTimeBuilder_ == null ? jobEndTime_ : jobEndTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00800000) != 0)) {
        result.postingPublishTime_ =
            postingPublishTimeBuilder_ == null
                ? postingPublishTime_
                : postingPublishTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x01000000) != 0)) {
        result.postingExpireTime_ =
            postingExpireTimeBuilder_ == null
                ? postingExpireTime_
                : postingExpireTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x02000000) != 0)) {
        result.postingCreateTime_ =
            postingCreateTimeBuilder_ == null
                ? postingCreateTime_
                : postingCreateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x04000000) != 0)) {
        result.postingUpdateTime_ =
            postingUpdateTimeBuilder_ == null
                ? postingUpdateTime_
                : postingUpdateTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x08000000) != 0)) {
        result.companyDisplayName_ = companyDisplayName_;
      }
      if (((from_bitField0_ & 0x10000000) != 0)) {
        result.derivedInfo_ =
            derivedInfoBuilder_ == null ? derivedInfo_ : derivedInfoBuilder_.build();
      }
      if (((from_bitField0_ & 0x20000000) != 0)) {
        result.processingOptions_ =
            processingOptionsBuilder_ == null
                ? processingOptions_
                : processingOptionsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.talent.v4.Job) {
        return mergeFrom((com.google.cloud.talent.v4.Job) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.talent.v4.Job other) {
      if (other == com.google.cloud.talent.v4.Job.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getCompany().isEmpty()) {
        company_ = other.company_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getRequisitionId().isEmpty()) {
        requisitionId_ = other.requisitionId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getTitle().isEmpty()) {
        title_ = other.title_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (!other.addresses_.isEmpty()) {
        if (addresses_.isEmpty()) {
          addresses_ = other.addresses_;
          bitField0_ |= 0x00000020;
        } else {
          ensureAddressesIsMutable();
          addresses_.addAll(other.addresses_);
        }
        onChanged();
      }
      if (other.hasApplicationInfo()) {
        mergeApplicationInfo(other.getApplicationInfo());
      }
      if (!other.jobBenefits_.isEmpty()) {
        if (jobBenefits_.isEmpty()) {
          jobBenefits_ = other.jobBenefits_;
          bitField0_ = (bitField0_ & ~0x00000080);
        } else {
          ensureJobBenefitsIsMutable();
          jobBenefits_.addAll(other.jobBenefits_);
        }
        onChanged();
      }
      if (other.hasCompensationInfo()) {
        mergeCompensationInfo(other.getCompensationInfo());
      }
      internalGetMutableCustomAttributes().mergeFrom(other.internalGetCustomAttributes());
      bitField0_ |= 0x00000200;
      if (!other.degreeTypes_.isEmpty()) {
        if (degreeTypes_.isEmpty()) {
          degreeTypes_ = other.degreeTypes_;
          bitField0_ = (bitField0_ & ~0x00000400);
        } else {
          ensureDegreeTypesIsMutable();
          degreeTypes_.addAll(other.degreeTypes_);
        }
        onChanged();
      }
      if (!other.getDepartment().isEmpty()) {
        department_ = other.department_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (!other.employmentTypes_.isEmpty()) {
        if (employmentTypes_.isEmpty()) {
          employmentTypes_ = other.employmentTypes_;
          bitField0_ = (bitField0_ & ~0x00001000);
        } else {
          ensureEmploymentTypesIsMutable();
          employmentTypes_.addAll(other.employmentTypes_);
        }
        onChanged();
      }
      if (!other.getIncentives().isEmpty()) {
        incentives_ = other.incentives_;
        bitField0_ |= 0x00002000;
        onChanged();
      }
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00004000;
        onChanged();
      }
      if (other.jobLevel_ != 0) {
        setJobLevelValue(other.getJobLevelValue());
      }
      if (other.getPromotionValue() != 0) {
        setPromotionValue(other.getPromotionValue());
      }
      if (!other.getQualifications().isEmpty()) {
        qualifications_ = other.qualifications_;
        bitField0_ |= 0x00020000;
        onChanged();
      }
      if (!other.getResponsibilities().isEmpty()) {
        responsibilities_ = other.responsibilities_;
        bitField0_ |= 0x00040000;
        onChanged();
      }
      if (other.postingRegion_ != 0) {
        setPostingRegionValue(other.getPostingRegionValue());
      }
      if (other.visibility_ != 0) {
        setVisibilityValue(other.getVisibilityValue());
      }
      if (other.hasJobStartTime()) {
        mergeJobStartTime(other.getJobStartTime());
      }
      if (other.hasJobEndTime()) {
        mergeJobEndTime(other.getJobEndTime());
      }
      if (other.hasPostingPublishTime()) {
        mergePostingPublishTime(other.getPostingPublishTime());
      }
      if (other.hasPostingExpireTime()) {
        mergePostingExpireTime(other.getPostingExpireTime());
      }
      if (other.hasPostingCreateTime()) {
        mergePostingCreateTime(other.getPostingCreateTime());
      }
      if (other.hasPostingUpdateTime()) {
        mergePostingUpdateTime(other.getPostingUpdateTime());
      }
      if (!other.getCompanyDisplayName().isEmpty()) {
        companyDisplayName_ = other.companyDisplayName_;
        bitField0_ |= 0x08000000;
        onChanged();
      }
      if (other.hasDerivedInfo()) {
        mergeDerivedInfo(other.getDerivedInfo());
      }
      if (other.hasProcessingOptions()) {
        mergeProcessingOptions(other.getProcessingOptions());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                company_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                requisitionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                title_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAddressesIsMutable();
                addresses_.add(s);
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getApplicationInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 64:
              {
                int tmpRaw = input.readEnum();
                ensureJobBenefitsIsMutable();
                jobBenefits_.add(tmpRaw);
                break;
              } // case 64
            case 66:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureJobBenefitsIsMutable();
                  jobBenefits_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 66
            case 74:
              {
                input.readMessage(
                    getCompensationInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.talent.v4.CustomAttribute>
                    customAttributes__ =
                        input.readMessage(
                            CustomAttributesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableCustomAttributes()
                    .getMutableMap()
                    .put(customAttributes__.getKey(), customAttributes__.getValue());
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 88:
              {
                int tmpRaw = input.readEnum();
                ensureDegreeTypesIsMutable();
                degreeTypes_.add(tmpRaw);
                break;
              } // case 88
            case 90:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureDegreeTypesIsMutable();
                  degreeTypes_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 90
            case 98:
              {
                department_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 104:
              {
                int tmpRaw = input.readEnum();
                ensureEmploymentTypesIsMutable();
                employmentTypes_.add(tmpRaw);
                break;
              } // case 104
            case 106:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureEmploymentTypesIsMutable();
                  employmentTypes_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 106
            case 114:
              {
                incentives_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00002000;
                break;
              } // case 114
            case 122:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00004000;
                break;
              } // case 122
            case 128:
              {
                jobLevel_ = input.readEnum();
                bitField0_ |= 0x00008000;
                break;
              } // case 128
            case 136:
              {
                promotionValue_ = input.readInt32();
                bitField0_ |= 0x00010000;
                break;
              } // case 136
            case 146:
              {
                qualifications_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00020000;
                break;
              } // case 146
            case 154:
              {
                responsibilities_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00040000;
                break;
              } // case 154
            case 160:
              {
                postingRegion_ = input.readEnum();
                bitField0_ |= 0x00080000;
                break;
              } // case 160
            case 168:
              {
                visibility_ = input.readEnum();
                bitField0_ |= 0x00100000;
                break;
              } // case 168
            case 178:
              {
                input.readMessage(getJobStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00200000;
                break;
              } // case 178
            case 186:
              {
                input.readMessage(getJobEndTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00400000;
                break;
              } // case 186
            case 194:
              {
                input.readMessage(
                    getPostingPublishTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00800000;
                break;
              } // case 194
            case 202:
              {
                input.readMessage(
                    getPostingExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x01000000;
                break;
              } // case 202
            case 210:
              {
                input.readMessage(
                    getPostingCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x02000000;
                break;
              } // case 210
            case 218:
              {
                input.readMessage(
                    getPostingUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x04000000;
                break;
              } // case 218
            case 226:
              {
                companyDisplayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x08000000;
                break;
              } // case 226
            case 234:
              {
                input.readMessage(getDerivedInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x10000000;
                break;
              } // case 234
            case 242:
              {
                input.readMessage(
                    getProcessingOptionsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x20000000;
                break;
              } // case 242
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required during job update.
     *
     * The resource name for the job. This is generated by the service when a
     * job is created.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}". For
     * example, "projects/foo/tenants/bar/jobs/baz".
     *
     * Use of this field in job queries and API calls is preferred over the use of
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] since this
     * value is unique.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required during job update.
     *
     * The resource name for the job. This is generated by the service when a
     * job is created.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}". For
     * example, "projects/foo/tenants/bar/jobs/baz".
     *
     * Use of this field in job queries and API calls is preferred over the use of
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] since this
     * value is unique.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required during job update.
     *
     * The resource name for the job. This is generated by the service when a
     * job is created.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}". For
     * example, "projects/foo/tenants/bar/jobs/baz".
     *
     * Use of this field in job queries and API calls is preferred over the use of
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] since this
     * value is unique.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required during job update.
     *
     * The resource name for the job. This is generated by the service when a
     * job is created.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}". For
     * example, "projects/foo/tenants/bar/jobs/baz".
     *
     * Use of this field in job queries and API calls is preferred over the use of
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] since this
     * value is unique.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required during job update.
     *
     * The resource name for the job. This is generated by the service when a
     * job is created.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}". For
     * example, "projects/foo/tenants/bar/jobs/baz".
     *
     * Use of this field in job queries and API calls is preferred over the use of
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] since this
     * value is unique.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object company_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the company listing the job.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
     * example, "projects/foo/tenants/bar/companies/baz".
     * </pre>
     *
     * <code>
     * string company = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The company.
     */
    public java.lang.String getCompany() {
      java.lang.Object ref = company_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        company_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the company listing the job.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
     * example, "projects/foo/tenants/bar/companies/baz".
     * </pre>
     *
     * <code>
     * string company = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for company.
     */
    public com.google.protobuf.ByteString getCompanyBytes() {
      java.lang.Object ref = company_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        company_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the company listing the job.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
     * example, "projects/foo/tenants/bar/companies/baz".
     * </pre>
     *
     * <code>
     * string company = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The company to set.
     * @return This builder for chaining.
     */
    public Builder setCompany(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      company_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the company listing the job.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
     * example, "projects/foo/tenants/bar/companies/baz".
     * </pre>
     *
     * <code>
     * string company = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCompany() {
      company_ = getDefaultInstance().getCompany();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the company listing the job.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
     * example, "projects/foo/tenants/bar/companies/baz".
     * </pre>
     *
     * <code>
     * string company = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for company to set.
     * @return This builder for chaining.
     */
    public Builder setCompanyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      company_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object requisitionId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The requisition ID, also referred to as the posting ID, is
     * assigned by the client to identify a job. This field is intended to be used
     * by clients for client identification and tracking of postings. A job isn't
     * allowed to be created if there is another job with the same
     * [company][google.cloud.talent.v4.Job.name],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string requisition_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The requisitionId.
     */
    public java.lang.String getRequisitionId() {
      java.lang.Object ref = requisitionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requisitionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The requisition ID, also referred to as the posting ID, is
     * assigned by the client to identify a job. This field is intended to be used
     * by clients for client identification and tracking of postings. A job isn't
     * allowed to be created if there is another job with the same
     * [company][google.cloud.talent.v4.Job.name],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string requisition_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for requisitionId.
     */
    public com.google.protobuf.ByteString getRequisitionIdBytes() {
      java.lang.Object ref = requisitionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requisitionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The requisition ID, also referred to as the posting ID, is
     * assigned by the client to identify a job. This field is intended to be used
     * by clients for client identification and tracking of postings. A job isn't
     * allowed to be created if there is another job with the same
     * [company][google.cloud.talent.v4.Job.name],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string requisition_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The requisitionId to set.
     * @return This builder for chaining.
     */
    public Builder setRequisitionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      requisitionId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The requisition ID, also referred to as the posting ID, is
     * assigned by the client to identify a job. This field is intended to be used
     * by clients for client identification and tracking of postings. A job isn't
     * allowed to be created if there is another job with the same
     * [company][google.cloud.talent.v4.Job.name],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string requisition_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequisitionId() {
      requisitionId_ = getDefaultInstance().getRequisitionId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The requisition ID, also referred to as the posting ID, is
     * assigned by the client to identify a job. This field is intended to be used
     * by clients for client identification and tracking of postings. A job isn't
     * allowed to be created if there is another job with the same
     * [company][google.cloud.talent.v4.Job.name],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string requisition_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for requisitionId to set.
     * @return This builder for chaining.
     */
    public Builder setRequisitionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      requisitionId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object title_ = "";
    /**
     *
     *
     * <pre>
     * Required. The title of the job, such as "Software Engineer"
     *
     * The maximum number of allowed characters is 500.
     * </pre>
     *
     * <code>string title = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The title.
     */
    public java.lang.String getTitle() {
      java.lang.Object ref = title_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        title_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The title of the job, such as "Software Engineer"
     *
     * The maximum number of allowed characters is 500.
     * </pre>
     *
     * <code>string title = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for title.
     */
    public com.google.protobuf.ByteString getTitleBytes() {
      java.lang.Object ref = title_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        title_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The title of the job, such as "Software Engineer"
     *
     * The maximum number of allowed characters is 500.
     * </pre>
     *
     * <code>string title = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The title to set.
     * @return This builder for chaining.
     */
    public Builder setTitle(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      title_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The title of the job, such as "Software Engineer"
     *
     * The maximum number of allowed characters is 500.
     * </pre>
     *
     * <code>string title = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTitle() {
      title_ = getDefaultInstance().getTitle();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The title of the job, such as "Software Engineer"
     *
     * The maximum number of allowed characters is 500.
     * </pre>
     *
     * <code>string title = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for title to set.
     * @return This builder for chaining.
     */
    public Builder setTitleBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      title_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Required. The description of the job, which typically includes a
     * multi-paragraph description of the company and related information.
     * Separate fields are provided on the job object for
     * [responsibilities][google.cloud.talent.v4.Job.responsibilities],
     * [qualifications][google.cloud.talent.v4.Job.qualifications], and other job
     * characteristics. Use of these separate job fields is recommended.
     *
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     *
     * The maximum number of allowed characters is 100,000.
     * </pre>
     *
     * <code>string description = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The description of the job, which typically includes a
     * multi-paragraph description of the company and related information.
     * Separate fields are provided on the job object for
     * [responsibilities][google.cloud.talent.v4.Job.responsibilities],
     * [qualifications][google.cloud.talent.v4.Job.qualifications], and other job
     * characteristics. Use of these separate job fields is recommended.
     *
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     *
     * The maximum number of allowed characters is 100,000.
     * </pre>
     *
     * <code>string description = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The description of the job, which typically includes a
     * multi-paragraph description of the company and related information.
     * Separate fields are provided on the job object for
     * [responsibilities][google.cloud.talent.v4.Job.responsibilities],
     * [qualifications][google.cloud.talent.v4.Job.qualifications], and other job
     * characteristics. Use of these separate job fields is recommended.
     *
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     *
     * The maximum number of allowed characters is 100,000.
     * </pre>
     *
     * <code>string description = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The description of the job, which typically includes a
     * multi-paragraph description of the company and related information.
     * Separate fields are provided on the job object for
     * [responsibilities][google.cloud.talent.v4.Job.responsibilities],
     * [qualifications][google.cloud.talent.v4.Job.qualifications], and other job
     * characteristics. Use of these separate job fields is recommended.
     *
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     *
     * The maximum number of allowed characters is 100,000.
     * </pre>
     *
     * <code>string description = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The description of the job, which typically includes a
     * multi-paragraph description of the company and related information.
     * Separate fields are provided on the job object for
     * [responsibilities][google.cloud.talent.v4.Job.responsibilities],
     * [qualifications][google.cloud.talent.v4.Job.qualifications], and other job
     * characteristics. Use of these separate job fields is recommended.
     *
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     *
     * The maximum number of allowed characters is 100,000.
     * </pre>
     *
     * <code>string description = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList addresses_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAddressesIsMutable() {
      if (!addresses_.isModifiable()) {
        addresses_ = new com.google.protobuf.LazyStringArrayList(addresses_);
      }
      bitField0_ |= 0x00000020;
    }
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * Location(s) where the employer is looking to hire for this job posting.
     *
     * Specifying the full street address(es) of the hiring location enables
     * better API results, especially job searches by commute time.
     *
     * At most 50 locations are allowed for best search performance. If a job has
     * more locations, it is suggested to split it into multiple jobs with unique
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id]s (e.g. 'ReqA'
     * becomes 'ReqA-1', 'ReqA-2', and so on.) as multiple jobs with the same
     * [company][google.cloud.talent.v4.Job.company],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] are not
     * allowed. If the original
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] must be
     * preserved, a custom field should be used for storage. It is also suggested
     * to group the locations that close to each other in the same job for better
     * search experience.
     *
     * Jobs with multiple addresses must have their addresses with the same
     * [LocationType][] to allow location filtering to work properly. (For
     * example, a Job with addresses "1600 Amphitheatre Parkway, Mountain View,
     * CA, USA" and "London, UK" may not have location filters applied correctly
     * at search time since the first is a [LocationType.STREET_ADDRESS][] and the
     * second is a [LocationType.LOCALITY][].) If a job needs to have multiple
     * addresses, it is suggested to split it into multiple jobs with same
     * LocationTypes.
     *
     * The maximum number of allowed characters is 500.
     * </pre>
     *
     * <code>repeated string addresses = 6;</code>
     *
     * @return A list containing the addresses.
     */
    public com.google.protobuf.ProtocolStringList getAddressesList() {
      addresses_.makeImmutable();
      return addresses_;
    }
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * Location(s) where the employer is looking to hire for this job posting.
     *
     * Specifying the full street address(es) of the hiring location enables
     * better API results, especially job searches by commute time.
     *
     * At most 50 locations are allowed for best search performance. If a job has
     * more locations, it is suggested to split it into multiple jobs with unique
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id]s (e.g. 'ReqA'
     * becomes 'ReqA-1', 'ReqA-2', and so on.) as multiple jobs with the same
     * [company][google.cloud.talent.v4.Job.company],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] are not
     * allowed. If the original
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] must be
     * preserved, a custom field should be used for storage. It is also suggested
     * to group the locations that close to each other in the same job for better
     * search experience.
     *
     * Jobs with multiple addresses must have their addresses with the same
     * [LocationType][] to allow location filtering to work properly. (For
     * example, a Job with addresses "1600 Amphitheatre Parkway, Mountain View,
     * CA, USA" and "London, UK" may not have location filters applied correctly
     * at search time since the first is a [LocationType.STREET_ADDRESS][] and the
     * second is a [LocationType.LOCALITY][].) If a job needs to have multiple
     * addresses, it is suggested to split it into multiple jobs with same
     * LocationTypes.
     *
     * The maximum number of allowed characters is 500.
     * </pre>
     *
     * <code>repeated string addresses = 6;</code>
     *
     * @return The count of addresses.
     */
    public int getAddressesCount() {
      return addresses_.size();
    }
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * Location(s) where the employer is looking to hire for this job posting.
     *
     * Specifying the full street address(es) of the hiring location enables
     * better API results, especially job searches by commute time.
     *
     * At most 50 locations are allowed for best search performance. If a job has
     * more locations, it is suggested to split it into multiple jobs with unique
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id]s (e.g. 'ReqA'
     * becomes 'ReqA-1', 'ReqA-2', and so on.) as multiple jobs with the same
     * [company][google.cloud.talent.v4.Job.company],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] are not
     * allowed. If the original
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] must be
     * preserved, a custom field should be used for storage. It is also suggested
     * to group the locations that close to each other in the same job for better
     * search experience.
     *
     * Jobs with multiple addresses must have their addresses with the same
     * [LocationType][] to allow location filtering to work properly. (For
     * example, a Job with addresses "1600 Amphitheatre Parkway, Mountain View,
     * CA, USA" and "London, UK" may not have location filters applied correctly
     * at search time since the first is a [LocationType.STREET_ADDRESS][] and the
     * second is a [LocationType.LOCALITY][].) If a job needs to have multiple
     * addresses, it is suggested to split it into multiple jobs with same
     * LocationTypes.
     *
     * The maximum number of allowed characters is 500.
     * </pre>
     *
     * <code>repeated string addresses = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The addresses at the given index.
     */
    public java.lang.String getAddresses(int index) {
      return addresses_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * Location(s) where the employer is looking to hire for this job posting.
     *
     * Specifying the full street address(es) of the hiring location enables
     * better API results, especially job searches by commute time.
     *
     * At most 50 locations are allowed for best search performance. If a job has
     * more locations, it is suggested to split it into multiple jobs with unique
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id]s (e.g. 'ReqA'
     * becomes 'ReqA-1', 'ReqA-2', and so on.) as multiple jobs with the same
     * [company][google.cloud.talent.v4.Job.company],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] are not
     * allowed. If the original
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] must be
     * preserved, a custom field should be used for storage. It is also suggested
     * to group the locations that close to each other in the same job for better
     * search experience.
     *
     * Jobs with multiple addresses must have their addresses with the same
     * [LocationType][] to allow location filtering to work properly. (For
     * example, a Job with addresses "1600 Amphitheatre Parkway, Mountain View,
     * CA, USA" and "London, UK" may not have location filters applied correctly
     * at search time since the first is a [LocationType.STREET_ADDRESS][] and the
     * second is a [LocationType.LOCALITY][].) If a job needs to have multiple
     * addresses, it is suggested to split it into multiple jobs with same
     * LocationTypes.
     *
     * The maximum number of allowed characters is 500.
     * </pre>
     *
     * <code>repeated string addresses = 6;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the addresses at the given index.
     */
    public com.google.protobuf.ByteString getAddressesBytes(int index) {
      return addresses_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * Location(s) where the employer is looking to hire for this job posting.
     *
     * Specifying the full street address(es) of the hiring location enables
     * better API results, especially job searches by commute time.
     *
     * At most 50 locations are allowed for best search performance. If a job has
     * more locations, it is suggested to split it into multiple jobs with unique
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id]s (e.g. 'ReqA'
     * becomes 'ReqA-1', 'ReqA-2', and so on.) as multiple jobs with the same
     * [company][google.cloud.talent.v4.Job.company],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] are not
     * allowed. If the original
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] must be
     * preserved, a custom field should be used for storage. It is also suggested
     * to group the locations that close to each other in the same job for better
     * search experience.
     *
     * Jobs with multiple addresses must have their addresses with the same
     * [LocationType][] to allow location filtering to work properly. (For
     * example, a Job with addresses "1600 Amphitheatre Parkway, Mountain View,
     * CA, USA" and "London, UK" may not have location filters applied correctly
     * at search time since the first is a [LocationType.STREET_ADDRESS][] and the
     * second is a [LocationType.LOCALITY][].) If a job needs to have multiple
     * addresses, it is suggested to split it into multiple jobs with same
     * LocationTypes.
     *
     * The maximum number of allowed characters is 500.
     * </pre>
     *
     * <code>repeated string addresses = 6;</code>
     *
     * @param index The index to set the value at.
     * @param value The addresses to set.
     * @return This builder for chaining.
     */
    public Builder setAddresses(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAddressesIsMutable();
      addresses_.set(index, value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * Location(s) where the employer is looking to hire for this job posting.
     *
     * Specifying the full street address(es) of the hiring location enables
     * better API results, especially job searches by commute time.
     *
     * At most 50 locations are allowed for best search performance. If a job has
     * more locations, it is suggested to split it into multiple jobs with unique
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id]s (e.g. 'ReqA'
     * becomes 'ReqA-1', 'ReqA-2', and so on.) as multiple jobs with the same
     * [company][google.cloud.talent.v4.Job.company],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] are not
     * allowed. If the original
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] must be
     * preserved, a custom field should be used for storage. It is also suggested
     * to group the locations that close to each other in the same job for better
     * search experience.
     *
     * Jobs with multiple addresses must have their addresses with the same
     * [LocationType][] to allow location filtering to work properly. (For
     * example, a Job with addresses "1600 Amphitheatre Parkway, Mountain View,
     * CA, USA" and "London, UK" may not have location filters applied correctly
     * at search time since the first is a [LocationType.STREET_ADDRESS][] and the
     * second is a [LocationType.LOCALITY][].) If a job needs to have multiple
     * addresses, it is suggested to split it into multiple jobs with same
     * LocationTypes.
     *
     * The maximum number of allowed characters is 500.
     * </pre>
     *
     * <code>repeated string addresses = 6;</code>
     *
     * @param value The addresses to add.
     * @return This builder for chaining.
     */
    public Builder addAddresses(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAddressesIsMutable();
      addresses_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * Location(s) where the employer is looking to hire for this job posting.
     *
     * Specifying the full street address(es) of the hiring location enables
     * better API results, especially job searches by commute time.
     *
     * At most 50 locations are allowed for best search performance. If a job has
     * more locations, it is suggested to split it into multiple jobs with unique
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id]s (e.g. 'ReqA'
     * becomes 'ReqA-1', 'ReqA-2', and so on.) as multiple jobs with the same
     * [company][google.cloud.talent.v4.Job.company],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] are not
     * allowed. If the original
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] must be
     * preserved, a custom field should be used for storage. It is also suggested
     * to group the locations that close to each other in the same job for better
     * search experience.
     *
     * Jobs with multiple addresses must have their addresses with the same
     * [LocationType][] to allow location filtering to work properly. (For
     * example, a Job with addresses "1600 Amphitheatre Parkway, Mountain View,
     * CA, USA" and "London, UK" may not have location filters applied correctly
     * at search time since the first is a [LocationType.STREET_ADDRESS][] and the
     * second is a [LocationType.LOCALITY][].) If a job needs to have multiple
     * addresses, it is suggested to split it into multiple jobs with same
     * LocationTypes.
     *
     * The maximum number of allowed characters is 500.
     * </pre>
     *
     * <code>repeated string addresses = 6;</code>
     *
     * @param values The addresses to add.
     * @return This builder for chaining.
     */
    public Builder addAllAddresses(java.lang.Iterable<java.lang.String> values) {
      ensureAddressesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, addresses_);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * Location(s) where the employer is looking to hire for this job posting.
     *
     * Specifying the full street address(es) of the hiring location enables
     * better API results, especially job searches by commute time.
     *
     * At most 50 locations are allowed for best search performance. If a job has
     * more locations, it is suggested to split it into multiple jobs with unique
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id]s (e.g. 'ReqA'
     * becomes 'ReqA-1', 'ReqA-2', and so on.) as multiple jobs with the same
     * [company][google.cloud.talent.v4.Job.company],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] are not
     * allowed. If the original
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] must be
     * preserved, a custom field should be used for storage. It is also suggested
     * to group the locations that close to each other in the same job for better
     * search experience.
     *
     * Jobs with multiple addresses must have their addresses with the same
     * [LocationType][] to allow location filtering to work properly. (For
     * example, a Job with addresses "1600 Amphitheatre Parkway, Mountain View,
     * CA, USA" and "London, UK" may not have location filters applied correctly
     * at search time since the first is a [LocationType.STREET_ADDRESS][] and the
     * second is a [LocationType.LOCALITY][].) If a job needs to have multiple
     * addresses, it is suggested to split it into multiple jobs with same
     * LocationTypes.
     *
     * The maximum number of allowed characters is 500.
     * </pre>
     *
     * <code>repeated string addresses = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAddresses() {
      addresses_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000020);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * Location(s) where the employer is looking to hire for this job posting.
     *
     * Specifying the full street address(es) of the hiring location enables
     * better API results, especially job searches by commute time.
     *
     * At most 50 locations are allowed for best search performance. If a job has
     * more locations, it is suggested to split it into multiple jobs with unique
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id]s (e.g. 'ReqA'
     * becomes 'ReqA-1', 'ReqA-2', and so on.) as multiple jobs with the same
     * [company][google.cloud.talent.v4.Job.company],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] are not
     * allowed. If the original
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id] must be
     * preserved, a custom field should be used for storage. It is also suggested
     * to group the locations that close to each other in the same job for better
     * search experience.
     *
     * Jobs with multiple addresses must have their addresses with the same
     * [LocationType][] to allow location filtering to work properly. (For
     * example, a Job with addresses "1600 Amphitheatre Parkway, Mountain View,
     * CA, USA" and "London, UK" may not have location filters applied correctly
     * at search time since the first is a [LocationType.STREET_ADDRESS][] and the
     * second is a [LocationType.LOCALITY][].) If a job needs to have multiple
     * addresses, it is suggested to split it into multiple jobs with same
     * LocationTypes.
     *
     * The maximum number of allowed characters is 500.
     * </pre>
     *
     * <code>repeated string addresses = 6;</code>
     *
     * @param value The bytes of the addresses to add.
     * @return This builder for chaining.
     */
    public Builder addAddressesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAddressesIsMutable();
      addresses_.add(value);
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private com.google.cloud.talent.v4.Job.ApplicationInfo applicationInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.Job.ApplicationInfo,
            com.google.cloud.talent.v4.Job.ApplicationInfo.Builder,
            com.google.cloud.talent.v4.Job.ApplicationInfoOrBuilder>
        applicationInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Job application information.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job.ApplicationInfo application_info = 7;</code>
     *
     * @return Whether the applicationInfo field is set.
     */
    public boolean hasApplicationInfo() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Job application information.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job.ApplicationInfo application_info = 7;</code>
     *
     * @return The applicationInfo.
     */
    public com.google.cloud.talent.v4.Job.ApplicationInfo getApplicationInfo() {
      if (applicationInfoBuilder_ == null) {
        return applicationInfo_ == null
            ? com.google.cloud.talent.v4.Job.ApplicationInfo.getDefaultInstance()
            : applicationInfo_;
      } else {
        return applicationInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Job application information.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job.ApplicationInfo application_info = 7;</code>
     */
    public Builder setApplicationInfo(com.google.cloud.talent.v4.Job.ApplicationInfo value) {
      if (applicationInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        applicationInfo_ = value;
      } else {
        applicationInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Job application information.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job.ApplicationInfo application_info = 7;</code>
     */
    public Builder setApplicationInfo(
        com.google.cloud.talent.v4.Job.ApplicationInfo.Builder builderForValue) {
      if (applicationInfoBuilder_ == null) {
        applicationInfo_ = builderForValue.build();
      } else {
        applicationInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Job application information.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job.ApplicationInfo application_info = 7;</code>
     */
    public Builder mergeApplicationInfo(com.google.cloud.talent.v4.Job.ApplicationInfo value) {
      if (applicationInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && applicationInfo_ != null
            && applicationInfo_
                != com.google.cloud.talent.v4.Job.ApplicationInfo.getDefaultInstance()) {
          getApplicationInfoBuilder().mergeFrom(value);
        } else {
          applicationInfo_ = value;
        }
      } else {
        applicationInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Job application information.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job.ApplicationInfo application_info = 7;</code>
     */
    public Builder clearApplicationInfo() {
      bitField0_ = (bitField0_ & ~0x00000040);
      applicationInfo_ = null;
      if (applicationInfoBuilder_ != null) {
        applicationInfoBuilder_.dispose();
        applicationInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Job application information.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job.ApplicationInfo application_info = 7;</code>
     */
    public com.google.cloud.talent.v4.Job.ApplicationInfo.Builder getApplicationInfoBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getApplicationInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Job application information.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job.ApplicationInfo application_info = 7;</code>
     */
    public com.google.cloud.talent.v4.Job.ApplicationInfoOrBuilder getApplicationInfoOrBuilder() {
      if (applicationInfoBuilder_ != null) {
        return applicationInfoBuilder_.getMessageOrBuilder();
      } else {
        return applicationInfo_ == null
            ? com.google.cloud.talent.v4.Job.ApplicationInfo.getDefaultInstance()
            : applicationInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Job application information.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job.ApplicationInfo application_info = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.Job.ApplicationInfo,
            com.google.cloud.talent.v4.Job.ApplicationInfo.Builder,
            com.google.cloud.talent.v4.Job.ApplicationInfoOrBuilder>
        getApplicationInfoFieldBuilder() {
      if (applicationInfoBuilder_ == null) {
        applicationInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.talent.v4.Job.ApplicationInfo,
                com.google.cloud.talent.v4.Job.ApplicationInfo.Builder,
                com.google.cloud.talent.v4.Job.ApplicationInfoOrBuilder>(
                getApplicationInfo(), getParentForChildren(), isClean());
        applicationInfo_ = null;
      }
      return applicationInfoBuilder_;
    }

    private java.util.List<java.lang.Integer> jobBenefits_ = java.util.Collections.emptyList();

    private void ensureJobBenefitsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        jobBenefits_ = new java.util.ArrayList<java.lang.Integer>(jobBenefits_);
        bitField0_ |= 0x00000080;
      }
    }
    /**
     *
     *
     * <pre>
     * The benefits included with the job.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
     *
     * @return A list containing the jobBenefits.
     */
    public java.util.List<com.google.cloud.talent.v4.JobBenefit> getJobBenefitsList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.talent.v4.JobBenefit>(
          jobBenefits_, jobBenefits_converter_);
    }
    /**
     *
     *
     * <pre>
     * The benefits included with the job.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
     *
     * @return The count of jobBenefits.
     */
    public int getJobBenefitsCount() {
      return jobBenefits_.size();
    }
    /**
     *
     *
     * <pre>
     * The benefits included with the job.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The jobBenefits at the given index.
     */
    public com.google.cloud.talent.v4.JobBenefit getJobBenefits(int index) {
      return jobBenefits_converter_.convert(jobBenefits_.get(index));
    }
    /**
     *
     *
     * <pre>
     * The benefits included with the job.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
     *
     * @param index The index to set the value at.
     * @param value The jobBenefits to set.
     * @return This builder for chaining.
     */
    public Builder setJobBenefits(int index, com.google.cloud.talent.v4.JobBenefit value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureJobBenefitsIsMutable();
      jobBenefits_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The benefits included with the job.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
     *
     * @param value The jobBenefits to add.
     * @return This builder for chaining.
     */
    public Builder addJobBenefits(com.google.cloud.talent.v4.JobBenefit value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureJobBenefitsIsMutable();
      jobBenefits_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The benefits included with the job.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
     *
     * @param values The jobBenefits to add.
     * @return This builder for chaining.
     */
    public Builder addAllJobBenefits(
        java.lang.Iterable<? extends com.google.cloud.talent.v4.JobBenefit> values) {
      ensureJobBenefitsIsMutable();
      for (com.google.cloud.talent.v4.JobBenefit value : values) {
        jobBenefits_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The benefits included with the job.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJobBenefits() {
      jobBenefits_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The benefits included with the job.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
     *
     * @return A list containing the enum numeric values on the wire for jobBenefits.
     */
    public java.util.List<java.lang.Integer> getJobBenefitsValueList() {
      return java.util.Collections.unmodifiableList(jobBenefits_);
    }
    /**
     *
     *
     * <pre>
     * The benefits included with the job.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of jobBenefits at the given index.
     */
    public int getJobBenefitsValue(int index) {
      return jobBenefits_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The benefits included with the job.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for jobBenefits to set.
     * @return This builder for chaining.
     */
    public Builder setJobBenefitsValue(int index, int value) {
      ensureJobBenefitsIsMutable();
      jobBenefits_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The benefits included with the job.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
     *
     * @param value The enum numeric value on the wire for jobBenefits to add.
     * @return This builder for chaining.
     */
    public Builder addJobBenefitsValue(int value) {
      ensureJobBenefitsIsMutable();
      jobBenefits_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The benefits included with the job.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
     *
     * @param values The enum numeric values on the wire for jobBenefits to add.
     * @return This builder for chaining.
     */
    public Builder addAllJobBenefitsValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureJobBenefitsIsMutable();
      for (int value : values) {
        jobBenefits_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.cloud.talent.v4.CompensationInfo compensationInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.CompensationInfo,
            com.google.cloud.talent.v4.CompensationInfo.Builder,
            com.google.cloud.talent.v4.CompensationInfoOrBuilder>
        compensationInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Job compensation information (a.k.a. "pay rate") i.e., the compensation
     * that will paid to the employee.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompensationInfo compensation_info = 9;</code>
     *
     * @return Whether the compensationInfo field is set.
     */
    public boolean hasCompensationInfo() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Job compensation information (a.k.a. "pay rate") i.e., the compensation
     * that will paid to the employee.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompensationInfo compensation_info = 9;</code>
     *
     * @return The compensationInfo.
     */
    public com.google.cloud.talent.v4.CompensationInfo getCompensationInfo() {
      if (compensationInfoBuilder_ == null) {
        return compensationInfo_ == null
            ? com.google.cloud.talent.v4.CompensationInfo.getDefaultInstance()
            : compensationInfo_;
      } else {
        return compensationInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Job compensation information (a.k.a. "pay rate") i.e., the compensation
     * that will paid to the employee.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompensationInfo compensation_info = 9;</code>
     */
    public Builder setCompensationInfo(com.google.cloud.talent.v4.CompensationInfo value) {
      if (compensationInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        compensationInfo_ = value;
      } else {
        compensationInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Job compensation information (a.k.a. "pay rate") i.e., the compensation
     * that will paid to the employee.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompensationInfo compensation_info = 9;</code>
     */
    public Builder setCompensationInfo(
        com.google.cloud.talent.v4.CompensationInfo.Builder builderForValue) {
      if (compensationInfoBuilder_ == null) {
        compensationInfo_ = builderForValue.build();
      } else {
        compensationInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Job compensation information (a.k.a. "pay rate") i.e., the compensation
     * that will paid to the employee.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompensationInfo compensation_info = 9;</code>
     */
    public Builder mergeCompensationInfo(com.google.cloud.talent.v4.CompensationInfo value) {
      if (compensationInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && compensationInfo_ != null
            && compensationInfo_
                != com.google.cloud.talent.v4.CompensationInfo.getDefaultInstance()) {
          getCompensationInfoBuilder().mergeFrom(value);
        } else {
          compensationInfo_ = value;
        }
      } else {
        compensationInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Job compensation information (a.k.a. "pay rate") i.e., the compensation
     * that will paid to the employee.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompensationInfo compensation_info = 9;</code>
     */
    public Builder clearCompensationInfo() {
      bitField0_ = (bitField0_ & ~0x00000100);
      compensationInfo_ = null;
      if (compensationInfoBuilder_ != null) {
        compensationInfoBuilder_.dispose();
        compensationInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Job compensation information (a.k.a. "pay rate") i.e., the compensation
     * that will paid to the employee.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompensationInfo compensation_info = 9;</code>
     */
    public com.google.cloud.talent.v4.CompensationInfo.Builder getCompensationInfoBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getCompensationInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Job compensation information (a.k.a. "pay rate") i.e., the compensation
     * that will paid to the employee.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompensationInfo compensation_info = 9;</code>
     */
    public com.google.cloud.talent.v4.CompensationInfoOrBuilder getCompensationInfoOrBuilder() {
      if (compensationInfoBuilder_ != null) {
        return compensationInfoBuilder_.getMessageOrBuilder();
      } else {
        return compensationInfo_ == null
            ? com.google.cloud.talent.v4.CompensationInfo.getDefaultInstance()
            : compensationInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Job compensation information (a.k.a. "pay rate") i.e., the compensation
     * that will paid to the employee.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompensationInfo compensation_info = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.CompensationInfo,
            com.google.cloud.talent.v4.CompensationInfo.Builder,
            com.google.cloud.talent.v4.CompensationInfoOrBuilder>
        getCompensationInfoFieldBuilder() {
      if (compensationInfoBuilder_ == null) {
        compensationInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.talent.v4.CompensationInfo,
                com.google.cloud.talent.v4.CompensationInfo.Builder,
                com.google.cloud.talent.v4.CompensationInfoOrBuilder>(
                getCompensationInfo(), getParentForChildren(), isClean());
        compensationInfo_ = null;
      }
      return compensationInfoBuilder_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.talent.v4.CustomAttribute>
        customAttributes_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.talent.v4.CustomAttribute>
        internalGetCustomAttributes() {
      if (customAttributes_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            CustomAttributesDefaultEntryHolder.defaultEntry);
      }
      return customAttributes_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.talent.v4.CustomAttribute>
        internalGetMutableCustomAttributes() {
      if (customAttributes_ == null) {
        customAttributes_ =
            com.google.protobuf.MapField.newMapField(
                CustomAttributesDefaultEntryHolder.defaultEntry);
      }
      if (!customAttributes_.isMutable()) {
        customAttributes_ = customAttributes_.copy();
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return customAttributes_;
    }

    public int getCustomAttributesCount() {
      return internalGetCustomAttributes().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * A map of fields to hold both filterable and non-filterable custom job
     * attributes that are not covered by the provided structured fields.
     *
     * The keys of the map are strings up to 64 bytes and must match the
     * pattern: `[a-zA-Z][a-zA-Z0-9_]*`. For example, key0LikeThis or
     * KEY_1_LIKE_THIS.
     *
     * At most 100 filterable and at most 100 unfilterable keys are supported.
     * For filterable `string_values`, across all keys at most 200 values are
     * allowed, with each string no more than 255 characters. For unfilterable
     * `string_values`, the maximum total size of `string_values` across all keys
     * is 50KB.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.talent.v4.CustomAttribute&gt; custom_attributes = 10;
     * </code>
     */
    @java.lang.Override
    public boolean containsCustomAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetCustomAttributes().getMap().containsKey(key);
    }
    /** Use {@link #getCustomAttributesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.talent.v4.CustomAttribute>
        getCustomAttributes() {
      return getCustomAttributesMap();
    }
    /**
     *
     *
     * <pre>
     * A map of fields to hold both filterable and non-filterable custom job
     * attributes that are not covered by the provided structured fields.
     *
     * The keys of the map are strings up to 64 bytes and must match the
     * pattern: `[a-zA-Z][a-zA-Z0-9_]*`. For example, key0LikeThis or
     * KEY_1_LIKE_THIS.
     *
     * At most 100 filterable and at most 100 unfilterable keys are supported.
     * For filterable `string_values`, across all keys at most 200 values are
     * allowed, with each string no more than 255 characters. For unfilterable
     * `string_values`, the maximum total size of `string_values` across all keys
     * is 50KB.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.talent.v4.CustomAttribute&gt; custom_attributes = 10;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, com.google.cloud.talent.v4.CustomAttribute>
        getCustomAttributesMap() {
      return internalGetCustomAttributes().getMap();
    }
    /**
     *
     *
     * <pre>
     * A map of fields to hold both filterable and non-filterable custom job
     * attributes that are not covered by the provided structured fields.
     *
     * The keys of the map are strings up to 64 bytes and must match the
     * pattern: `[a-zA-Z][a-zA-Z0-9_]*`. For example, key0LikeThis or
     * KEY_1_LIKE_THIS.
     *
     * At most 100 filterable and at most 100 unfilterable keys are supported.
     * For filterable `string_values`, across all keys at most 200 values are
     * allowed, with each string no more than 255 characters. For unfilterable
     * `string_values`, the maximum total size of `string_values` across all keys
     * is 50KB.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.talent.v4.CustomAttribute&gt; custom_attributes = 10;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.talent.v4.CustomAttribute getCustomAttributesOrDefault(
        java.lang.String key,
        /* nullable */
        com.google.cloud.talent.v4.CustomAttribute defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.talent.v4.CustomAttribute> map =
          internalGetCustomAttributes().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * A map of fields to hold both filterable and non-filterable custom job
     * attributes that are not covered by the provided structured fields.
     *
     * The keys of the map are strings up to 64 bytes and must match the
     * pattern: `[a-zA-Z][a-zA-Z0-9_]*`. For example, key0LikeThis or
     * KEY_1_LIKE_THIS.
     *
     * At most 100 filterable and at most 100 unfilterable keys are supported.
     * For filterable `string_values`, across all keys at most 200 values are
     * allowed, with each string no more than 255 characters. For unfilterable
     * `string_values`, the maximum total size of `string_values` across all keys
     * is 50KB.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.talent.v4.CustomAttribute&gt; custom_attributes = 10;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.CustomAttribute getCustomAttributesOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.talent.v4.CustomAttribute> map =
          internalGetCustomAttributes().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearCustomAttributes() {
      bitField0_ = (bitField0_ & ~0x00000200);
      internalGetMutableCustomAttributes().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map of fields to hold both filterable and non-filterable custom job
     * attributes that are not covered by the provided structured fields.
     *
     * The keys of the map are strings up to 64 bytes and must match the
     * pattern: `[a-zA-Z][a-zA-Z0-9_]*`. For example, key0LikeThis or
     * KEY_1_LIKE_THIS.
     *
     * At most 100 filterable and at most 100 unfilterable keys are supported.
     * For filterable `string_values`, across all keys at most 200 values are
     * allowed, with each string no more than 255 characters. For unfilterable
     * `string_values`, the maximum total size of `string_values` across all keys
     * is 50KB.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.talent.v4.CustomAttribute&gt; custom_attributes = 10;
     * </code>
     */
    public Builder removeCustomAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableCustomAttributes().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, com.google.cloud.talent.v4.CustomAttribute>
        getMutableCustomAttributes() {
      bitField0_ |= 0x00000200;
      return internalGetMutableCustomAttributes().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * A map of fields to hold both filterable and non-filterable custom job
     * attributes that are not covered by the provided structured fields.
     *
     * The keys of the map are strings up to 64 bytes and must match the
     * pattern: `[a-zA-Z][a-zA-Z0-9_]*`. For example, key0LikeThis or
     * KEY_1_LIKE_THIS.
     *
     * At most 100 filterable and at most 100 unfilterable keys are supported.
     * For filterable `string_values`, across all keys at most 200 values are
     * allowed, with each string no more than 255 characters. For unfilterable
     * `string_values`, the maximum total size of `string_values` across all keys
     * is 50KB.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.talent.v4.CustomAttribute&gt; custom_attributes = 10;
     * </code>
     */
    public Builder putCustomAttributes(
        java.lang.String key, com.google.cloud.talent.v4.CustomAttribute value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableCustomAttributes().getMutableMap().put(key, value);
      bitField0_ |= 0x00000200;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A map of fields to hold both filterable and non-filterable custom job
     * attributes that are not covered by the provided structured fields.
     *
     * The keys of the map are strings up to 64 bytes and must match the
     * pattern: `[a-zA-Z][a-zA-Z0-9_]*`. For example, key0LikeThis or
     * KEY_1_LIKE_THIS.
     *
     * At most 100 filterable and at most 100 unfilterable keys are supported.
     * For filterable `string_values`, across all keys at most 200 values are
     * allowed, with each string no more than 255 characters. For unfilterable
     * `string_values`, the maximum total size of `string_values` across all keys
     * is 50KB.
     * </pre>
     *
     * <code>map&lt;string, .google.cloud.talent.v4.CustomAttribute&gt; custom_attributes = 10;
     * </code>
     */
    public Builder putAllCustomAttributes(
        java.util.Map<java.lang.String, com.google.cloud.talent.v4.CustomAttribute> values) {
      internalGetMutableCustomAttributes().getMutableMap().putAll(values);
      bitField0_ |= 0x00000200;
      return this;
    }

    private java.util.List<java.lang.Integer> degreeTypes_ = java.util.Collections.emptyList();

    private void ensureDegreeTypesIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        degreeTypes_ = new java.util.ArrayList<java.lang.Integer>(degreeTypes_);
        bitField0_ |= 0x00000400;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired education degrees for the job, such as Bachelors, Masters.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
     *
     * @return A list containing the degreeTypes.
     */
    public java.util.List<com.google.cloud.talent.v4.DegreeType> getDegreeTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.talent.v4.DegreeType>(
          degreeTypes_, degreeTypes_converter_);
    }
    /**
     *
     *
     * <pre>
     * The desired education degrees for the job, such as Bachelors, Masters.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
     *
     * @return The count of degreeTypes.
     */
    public int getDegreeTypesCount() {
      return degreeTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * The desired education degrees for the job, such as Bachelors, Masters.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
     *
     * @param index The index of the element to return.
     * @return The degreeTypes at the given index.
     */
    public com.google.cloud.talent.v4.DegreeType getDegreeTypes(int index) {
      return degreeTypes_converter_.convert(degreeTypes_.get(index));
    }
    /**
     *
     *
     * <pre>
     * The desired education degrees for the job, such as Bachelors, Masters.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
     *
     * @param index The index to set the value at.
     * @param value The degreeTypes to set.
     * @return This builder for chaining.
     */
    public Builder setDegreeTypes(int index, com.google.cloud.talent.v4.DegreeType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDegreeTypesIsMutable();
      degreeTypes_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired education degrees for the job, such as Bachelors, Masters.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
     *
     * @param value The degreeTypes to add.
     * @return This builder for chaining.
     */
    public Builder addDegreeTypes(com.google.cloud.talent.v4.DegreeType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureDegreeTypesIsMutable();
      degreeTypes_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired education degrees for the job, such as Bachelors, Masters.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
     *
     * @param values The degreeTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllDegreeTypes(
        java.lang.Iterable<? extends com.google.cloud.talent.v4.DegreeType> values) {
      ensureDegreeTypesIsMutable();
      for (com.google.cloud.talent.v4.DegreeType value : values) {
        degreeTypes_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired education degrees for the job, such as Bachelors, Masters.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDegreeTypes() {
      degreeTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired education degrees for the job, such as Bachelors, Masters.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
     *
     * @return A list containing the enum numeric values on the wire for degreeTypes.
     */
    public java.util.List<java.lang.Integer> getDegreeTypesValueList() {
      return java.util.Collections.unmodifiableList(degreeTypes_);
    }
    /**
     *
     *
     * <pre>
     * The desired education degrees for the job, such as Bachelors, Masters.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of degreeTypes at the given index.
     */
    public int getDegreeTypesValue(int index) {
      return degreeTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The desired education degrees for the job, such as Bachelors, Masters.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for degreeTypes to set.
     * @return This builder for chaining.
     */
    public Builder setDegreeTypesValue(int index, int value) {
      ensureDegreeTypesIsMutable();
      degreeTypes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired education degrees for the job, such as Bachelors, Masters.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
     *
     * @param value The enum numeric value on the wire for degreeTypes to add.
     * @return This builder for chaining.
     */
    public Builder addDegreeTypesValue(int value) {
      ensureDegreeTypesIsMutable();
      degreeTypes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired education degrees for the job, such as Bachelors, Masters.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
     *
     * @param values The enum numeric values on the wire for degreeTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllDegreeTypesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureDegreeTypesIsMutable();
      for (int value : values) {
        degreeTypes_.add(value);
      }
      onChanged();
      return this;
    }

    private java.lang.Object department_ = "";
    /**
     *
     *
     * <pre>
     * The department or functional area within the company with the open
     * position.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string department = 12;</code>
     *
     * @return The department.
     */
    public java.lang.String getDepartment() {
      java.lang.Object ref = department_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        department_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The department or functional area within the company with the open
     * position.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string department = 12;</code>
     *
     * @return The bytes for department.
     */
    public com.google.protobuf.ByteString getDepartmentBytes() {
      java.lang.Object ref = department_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        department_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The department or functional area within the company with the open
     * position.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string department = 12;</code>
     *
     * @param value The department to set.
     * @return This builder for chaining.
     */
    public Builder setDepartment(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      department_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The department or functional area within the company with the open
     * position.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string department = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDepartment() {
      department_ = getDefaultInstance().getDepartment();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The department or functional area within the company with the open
     * position.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string department = 12;</code>
     *
     * @param value The bytes for department to set.
     * @return This builder for chaining.
     */
    public Builder setDepartmentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      department_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> employmentTypes_ = java.util.Collections.emptyList();

    private void ensureEmploymentTypesIsMutable() {
      if (!((bitField0_ & 0x00001000) != 0)) {
        employmentTypes_ = new java.util.ArrayList<java.lang.Integer>(employmentTypes_);
        bitField0_ |= 0x00001000;
      }
    }
    /**
     *
     *
     * <pre>
     * The employment type(s) of a job, for example,
     * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
     * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
     *
     * @return A list containing the employmentTypes.
     */
    public java.util.List<com.google.cloud.talent.v4.EmploymentType> getEmploymentTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.talent.v4.EmploymentType>(
          employmentTypes_, employmentTypes_converter_);
    }
    /**
     *
     *
     * <pre>
     * The employment type(s) of a job, for example,
     * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
     * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
     *
     * @return The count of employmentTypes.
     */
    public int getEmploymentTypesCount() {
      return employmentTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * The employment type(s) of a job, for example,
     * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
     * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
     *
     * @param index The index of the element to return.
     * @return The employmentTypes at the given index.
     */
    public com.google.cloud.talent.v4.EmploymentType getEmploymentTypes(int index) {
      return employmentTypes_converter_.convert(employmentTypes_.get(index));
    }
    /**
     *
     *
     * <pre>
     * The employment type(s) of a job, for example,
     * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
     * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
     *
     * @param index The index to set the value at.
     * @param value The employmentTypes to set.
     * @return This builder for chaining.
     */
    public Builder setEmploymentTypes(int index, com.google.cloud.talent.v4.EmploymentType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEmploymentTypesIsMutable();
      employmentTypes_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The employment type(s) of a job, for example,
     * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
     * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
     *
     * @param value The employmentTypes to add.
     * @return This builder for chaining.
     */
    public Builder addEmploymentTypes(com.google.cloud.talent.v4.EmploymentType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEmploymentTypesIsMutable();
      employmentTypes_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The employment type(s) of a job, for example,
     * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
     * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
     *
     * @param values The employmentTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllEmploymentTypes(
        java.lang.Iterable<? extends com.google.cloud.talent.v4.EmploymentType> values) {
      ensureEmploymentTypesIsMutable();
      for (com.google.cloud.talent.v4.EmploymentType value : values) {
        employmentTypes_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The employment type(s) of a job, for example,
     * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
     * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEmploymentTypes() {
      employmentTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The employment type(s) of a job, for example,
     * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
     * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
     *
     * @return A list containing the enum numeric values on the wire for employmentTypes.
     */
    public java.util.List<java.lang.Integer> getEmploymentTypesValueList() {
      return java.util.Collections.unmodifiableList(employmentTypes_);
    }
    /**
     *
     *
     * <pre>
     * The employment type(s) of a job, for example,
     * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
     * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of employmentTypes at the given index.
     */
    public int getEmploymentTypesValue(int index) {
      return employmentTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The employment type(s) of a job, for example,
     * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
     * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for employmentTypes to set.
     * @return This builder for chaining.
     */
    public Builder setEmploymentTypesValue(int index, int value) {
      ensureEmploymentTypesIsMutable();
      employmentTypes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The employment type(s) of a job, for example,
     * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
     * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
     *
     * @param value The enum numeric value on the wire for employmentTypes to add.
     * @return This builder for chaining.
     */
    public Builder addEmploymentTypesValue(int value) {
      ensureEmploymentTypesIsMutable();
      employmentTypes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The employment type(s) of a job, for example,
     * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
     * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
     *
     * @param values The enum numeric values on the wire for employmentTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllEmploymentTypesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureEmploymentTypesIsMutable();
      for (int value : values) {
        employmentTypes_.add(value);
      }
      onChanged();
      return this;
    }

    private java.lang.Object incentives_ = "";
    /**
     *
     *
     * <pre>
     * A description of bonus, commission, and other compensation
     * incentives associated with the job not including salary or pay.
     *
     * The maximum number of allowed characters is 10,000.
     * </pre>
     *
     * <code>string incentives = 14;</code>
     *
     * @return The incentives.
     */
    public java.lang.String getIncentives() {
      java.lang.Object ref = incentives_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        incentives_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A description of bonus, commission, and other compensation
     * incentives associated with the job not including salary or pay.
     *
     * The maximum number of allowed characters is 10,000.
     * </pre>
     *
     * <code>string incentives = 14;</code>
     *
     * @return The bytes for incentives.
     */
    public com.google.protobuf.ByteString getIncentivesBytes() {
      java.lang.Object ref = incentives_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        incentives_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A description of bonus, commission, and other compensation
     * incentives associated with the job not including salary or pay.
     *
     * The maximum number of allowed characters is 10,000.
     * </pre>
     *
     * <code>string incentives = 14;</code>
     *
     * @param value The incentives to set.
     * @return This builder for chaining.
     */
    public Builder setIncentives(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      incentives_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of bonus, commission, and other compensation
     * incentives associated with the job not including salary or pay.
     *
     * The maximum number of allowed characters is 10,000.
     * </pre>
     *
     * <code>string incentives = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIncentives() {
      incentives_ = getDefaultInstance().getIncentives();
      bitField0_ = (bitField0_ & ~0x00002000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of bonus, commission, and other compensation
     * incentives associated with the job not including salary or pay.
     *
     * The maximum number of allowed characters is 10,000.
     * </pre>
     *
     * <code>string incentives = 14;</code>
     *
     * @param value The bytes for incentives to set.
     * @return This builder for chaining.
     */
    public Builder setIncentivesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      incentives_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * The language of the posting. This field is distinct from
     * any requirements for fluency that are associated with the job.
     *
     * Language codes must be in BCP-47 format, such as "en-US" or "sr-Latn".
     * For more information, see
     * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47){:
     * class="external" target="_blank" }.
     *
     * If this field is unspecified and
     * [Job.description][google.cloud.talent.v4.Job.description] is present,
     * detected language code based on
     * [Job.description][google.cloud.talent.v4.Job.description] is assigned,
     * otherwise defaults to 'en_US'.
     * </pre>
     *
     * <code>string language_code = 15;</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The language of the posting. This field is distinct from
     * any requirements for fluency that are associated with the job.
     *
     * Language codes must be in BCP-47 format, such as "en-US" or "sr-Latn".
     * For more information, see
     * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47){:
     * class="external" target="_blank" }.
     *
     * If this field is unspecified and
     * [Job.description][google.cloud.talent.v4.Job.description] is present,
     * detected language code based on
     * [Job.description][google.cloud.talent.v4.Job.description] is assigned,
     * otherwise defaults to 'en_US'.
     * </pre>
     *
     * <code>string language_code = 15;</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The language of the posting. This field is distinct from
     * any requirements for fluency that are associated with the job.
     *
     * Language codes must be in BCP-47 format, such as "en-US" or "sr-Latn".
     * For more information, see
     * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47){:
     * class="external" target="_blank" }.
     *
     * If this field is unspecified and
     * [Job.description][google.cloud.talent.v4.Job.description] is present,
     * detected language code based on
     * [Job.description][google.cloud.talent.v4.Job.description] is assigned,
     * otherwise defaults to 'en_US'.
     * </pre>
     *
     * <code>string language_code = 15;</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The language of the posting. This field is distinct from
     * any requirements for fluency that are associated with the job.
     *
     * Language codes must be in BCP-47 format, such as "en-US" or "sr-Latn".
     * For more information, see
     * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47){:
     * class="external" target="_blank" }.
     *
     * If this field is unspecified and
     * [Job.description][google.cloud.talent.v4.Job.description] is present,
     * detected language code based on
     * [Job.description][google.cloud.talent.v4.Job.description] is assigned,
     * otherwise defaults to 'en_US'.
     * </pre>
     *
     * <code>string language_code = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00004000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The language of the posting. This field is distinct from
     * any requirements for fluency that are associated with the job.
     *
     * Language codes must be in BCP-47 format, such as "en-US" or "sr-Latn".
     * For more information, see
     * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47){:
     * class="external" target="_blank" }.
     *
     * If this field is unspecified and
     * [Job.description][google.cloud.talent.v4.Job.description] is present,
     * detected language code based on
     * [Job.description][google.cloud.talent.v4.Job.description] is assigned,
     * otherwise defaults to 'en_US'.
     * </pre>
     *
     * <code>string language_code = 15;</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private int jobLevel_ = 0;
    /**
     *
     *
     * <pre>
     * The experience level associated with the job, such as "Entry Level".
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobLevel job_level = 16;</code>
     *
     * @return The enum numeric value on the wire for jobLevel.
     */
    @java.lang.Override
    public int getJobLevelValue() {
      return jobLevel_;
    }
    /**
     *
     *
     * <pre>
     * The experience level associated with the job, such as "Entry Level".
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobLevel job_level = 16;</code>
     *
     * @param value The enum numeric value on the wire for jobLevel to set.
     * @return This builder for chaining.
     */
    public Builder setJobLevelValue(int value) {
      jobLevel_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The experience level associated with the job, such as "Entry Level".
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobLevel job_level = 16;</code>
     *
     * @return The jobLevel.
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.JobLevel getJobLevel() {
      com.google.cloud.talent.v4.JobLevel result =
          com.google.cloud.talent.v4.JobLevel.forNumber(jobLevel_);
      return result == null ? com.google.cloud.talent.v4.JobLevel.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The experience level associated with the job, such as "Entry Level".
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobLevel job_level = 16;</code>
     *
     * @param value The jobLevel to set.
     * @return This builder for chaining.
     */
    public Builder setJobLevel(com.google.cloud.talent.v4.JobLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00008000;
      jobLevel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The experience level associated with the job, such as "Entry Level".
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobLevel job_level = 16;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJobLevel() {
      bitField0_ = (bitField0_ & ~0x00008000);
      jobLevel_ = 0;
      onChanged();
      return this;
    }

    private int promotionValue_;
    /**
     *
     *
     * <pre>
     * A promotion value of the job, as determined by the client.
     * The value determines the sort order of the jobs returned when searching for
     * jobs using the featured jobs search call, with higher promotional values
     * being returned first and ties being resolved by relevance sort. Only the
     * jobs with a promotionValue &gt;0 are returned in a FEATURED_JOB_SEARCH.
     *
     * Default value is 0, and negative values are treated as 0.
     * </pre>
     *
     * <code>int32 promotion_value = 17;</code>
     *
     * @return The promotionValue.
     */
    @java.lang.Override
    public int getPromotionValue() {
      return promotionValue_;
    }
    /**
     *
     *
     * <pre>
     * A promotion value of the job, as determined by the client.
     * The value determines the sort order of the jobs returned when searching for
     * jobs using the featured jobs search call, with higher promotional values
     * being returned first and ties being resolved by relevance sort. Only the
     * jobs with a promotionValue &gt;0 are returned in a FEATURED_JOB_SEARCH.
     *
     * Default value is 0, and negative values are treated as 0.
     * </pre>
     *
     * <code>int32 promotion_value = 17;</code>
     *
     * @param value The promotionValue to set.
     * @return This builder for chaining.
     */
    public Builder setPromotionValue(int value) {

      promotionValue_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A promotion value of the job, as determined by the client.
     * The value determines the sort order of the jobs returned when searching for
     * jobs using the featured jobs search call, with higher promotional values
     * being returned first and ties being resolved by relevance sort. Only the
     * jobs with a promotionValue &gt;0 are returned in a FEATURED_JOB_SEARCH.
     *
     * Default value is 0, and negative values are treated as 0.
     * </pre>
     *
     * <code>int32 promotion_value = 17;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPromotionValue() {
      bitField0_ = (bitField0_ & ~0x00010000);
      promotionValue_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object qualifications_ = "";
    /**
     *
     *
     * <pre>
     * A description of the qualifications required to perform the
     * job. The use of this field is recommended
     * as an alternative to using the more general
     * [description][google.cloud.talent.v4.Job.description] field.
     *
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     *
     * The maximum number of allowed characters is 10,000.
     * </pre>
     *
     * <code>string qualifications = 18;</code>
     *
     * @return The qualifications.
     */
    public java.lang.String getQualifications() {
      java.lang.Object ref = qualifications_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        qualifications_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A description of the qualifications required to perform the
     * job. The use of this field is recommended
     * as an alternative to using the more general
     * [description][google.cloud.talent.v4.Job.description] field.
     *
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     *
     * The maximum number of allowed characters is 10,000.
     * </pre>
     *
     * <code>string qualifications = 18;</code>
     *
     * @return The bytes for qualifications.
     */
    public com.google.protobuf.ByteString getQualificationsBytes() {
      java.lang.Object ref = qualifications_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        qualifications_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A description of the qualifications required to perform the
     * job. The use of this field is recommended
     * as an alternative to using the more general
     * [description][google.cloud.talent.v4.Job.description] field.
     *
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     *
     * The maximum number of allowed characters is 10,000.
     * </pre>
     *
     * <code>string qualifications = 18;</code>
     *
     * @param value The qualifications to set.
     * @return This builder for chaining.
     */
    public Builder setQualifications(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      qualifications_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of the qualifications required to perform the
     * job. The use of this field is recommended
     * as an alternative to using the more general
     * [description][google.cloud.talent.v4.Job.description] field.
     *
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     *
     * The maximum number of allowed characters is 10,000.
     * </pre>
     *
     * <code>string qualifications = 18;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQualifications() {
      qualifications_ = getDefaultInstance().getQualifications();
      bitField0_ = (bitField0_ & ~0x00020000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of the qualifications required to perform the
     * job. The use of this field is recommended
     * as an alternative to using the more general
     * [description][google.cloud.talent.v4.Job.description] field.
     *
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     *
     * The maximum number of allowed characters is 10,000.
     * </pre>
     *
     * <code>string qualifications = 18;</code>
     *
     * @param value The bytes for qualifications to set.
     * @return This builder for chaining.
     */
    public Builder setQualificationsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      qualifications_ = value;
      bitField0_ |= 0x00020000;
      onChanged();
      return this;
    }

    private java.lang.Object responsibilities_ = "";
    /**
     *
     *
     * <pre>
     * A description of job responsibilities. The use of this field is
     * recommended as an alternative to using the more general
     * [description][google.cloud.talent.v4.Job.description] field.
     *
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     *
     * The maximum number of allowed characters is 10,000.
     * </pre>
     *
     * <code>string responsibilities = 19;</code>
     *
     * @return The responsibilities.
     */
    public java.lang.String getResponsibilities() {
      java.lang.Object ref = responsibilities_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        responsibilities_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A description of job responsibilities. The use of this field is
     * recommended as an alternative to using the more general
     * [description][google.cloud.talent.v4.Job.description] field.
     *
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     *
     * The maximum number of allowed characters is 10,000.
     * </pre>
     *
     * <code>string responsibilities = 19;</code>
     *
     * @return The bytes for responsibilities.
     */
    public com.google.protobuf.ByteString getResponsibilitiesBytes() {
      java.lang.Object ref = responsibilities_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        responsibilities_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A description of job responsibilities. The use of this field is
     * recommended as an alternative to using the more general
     * [description][google.cloud.talent.v4.Job.description] field.
     *
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     *
     * The maximum number of allowed characters is 10,000.
     * </pre>
     *
     * <code>string responsibilities = 19;</code>
     *
     * @param value The responsibilities to set.
     * @return This builder for chaining.
     */
    public Builder setResponsibilities(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      responsibilities_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of job responsibilities. The use of this field is
     * recommended as an alternative to using the more general
     * [description][google.cloud.talent.v4.Job.description] field.
     *
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     *
     * The maximum number of allowed characters is 10,000.
     * </pre>
     *
     * <code>string responsibilities = 19;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResponsibilities() {
      responsibilities_ = getDefaultInstance().getResponsibilities();
      bitField0_ = (bitField0_ & ~0x00040000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A description of job responsibilities. The use of this field is
     * recommended as an alternative to using the more general
     * [description][google.cloud.talent.v4.Job.description] field.
     *
     * This field accepts and sanitizes HTML input, and also accepts
     * bold, italic, ordered list, and unordered list markup tags.
     *
     * The maximum number of allowed characters is 10,000.
     * </pre>
     *
     * <code>string responsibilities = 19;</code>
     *
     * @param value The bytes for responsibilities to set.
     * @return This builder for chaining.
     */
    public Builder setResponsibilitiesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      responsibilities_ = value;
      bitField0_ |= 0x00040000;
      onChanged();
      return this;
    }

    private int postingRegion_ = 0;
    /**
     *
     *
     * <pre>
     * The job [PostingRegion][google.cloud.talent.v4.PostingRegion] (for example,
     * state, country) throughout which the job is available. If this field is
     * set, a [LocationFilter][google.cloud.talent.v4.LocationFilter] in a search
     * query within the job region finds this job posting if an exact location
     * match isn't specified. If this field is set to
     * [PostingRegion.NATION][google.cloud.talent.v4.PostingRegion.NATION] or
     * [PostingRegion.ADMINISTRATIVE_AREA][google.cloud.talent.v4.PostingRegion.ADMINISTRATIVE_AREA],
     * setting job [Job.addresses][google.cloud.talent.v4.Job.addresses] to the
     * same location level as this field is strongly recommended.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.PostingRegion posting_region = 20;</code>
     *
     * @return The enum numeric value on the wire for postingRegion.
     */
    @java.lang.Override
    public int getPostingRegionValue() {
      return postingRegion_;
    }
    /**
     *
     *
     * <pre>
     * The job [PostingRegion][google.cloud.talent.v4.PostingRegion] (for example,
     * state, country) throughout which the job is available. If this field is
     * set, a [LocationFilter][google.cloud.talent.v4.LocationFilter] in a search
     * query within the job region finds this job posting if an exact location
     * match isn't specified. If this field is set to
     * [PostingRegion.NATION][google.cloud.talent.v4.PostingRegion.NATION] or
     * [PostingRegion.ADMINISTRATIVE_AREA][google.cloud.talent.v4.PostingRegion.ADMINISTRATIVE_AREA],
     * setting job [Job.addresses][google.cloud.talent.v4.Job.addresses] to the
     * same location level as this field is strongly recommended.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.PostingRegion posting_region = 20;</code>
     *
     * @param value The enum numeric value on the wire for postingRegion to set.
     * @return This builder for chaining.
     */
    public Builder setPostingRegionValue(int value) {
      postingRegion_ = value;
      bitField0_ |= 0x00080000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The job [PostingRegion][google.cloud.talent.v4.PostingRegion] (for example,
     * state, country) throughout which the job is available. If this field is
     * set, a [LocationFilter][google.cloud.talent.v4.LocationFilter] in a search
     * query within the job region finds this job posting if an exact location
     * match isn't specified. If this field is set to
     * [PostingRegion.NATION][google.cloud.talent.v4.PostingRegion.NATION] or
     * [PostingRegion.ADMINISTRATIVE_AREA][google.cloud.talent.v4.PostingRegion.ADMINISTRATIVE_AREA],
     * setting job [Job.addresses][google.cloud.talent.v4.Job.addresses] to the
     * same location level as this field is strongly recommended.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.PostingRegion posting_region = 20;</code>
     *
     * @return The postingRegion.
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.PostingRegion getPostingRegion() {
      com.google.cloud.talent.v4.PostingRegion result =
          com.google.cloud.talent.v4.PostingRegion.forNumber(postingRegion_);
      return result == null ? com.google.cloud.talent.v4.PostingRegion.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The job [PostingRegion][google.cloud.talent.v4.PostingRegion] (for example,
     * state, country) throughout which the job is available. If this field is
     * set, a [LocationFilter][google.cloud.talent.v4.LocationFilter] in a search
     * query within the job region finds this job posting if an exact location
     * match isn't specified. If this field is set to
     * [PostingRegion.NATION][google.cloud.talent.v4.PostingRegion.NATION] or
     * [PostingRegion.ADMINISTRATIVE_AREA][google.cloud.talent.v4.PostingRegion.ADMINISTRATIVE_AREA],
     * setting job [Job.addresses][google.cloud.talent.v4.Job.addresses] to the
     * same location level as this field is strongly recommended.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.PostingRegion posting_region = 20;</code>
     *
     * @param value The postingRegion to set.
     * @return This builder for chaining.
     */
    public Builder setPostingRegion(com.google.cloud.talent.v4.PostingRegion value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00080000;
      postingRegion_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The job [PostingRegion][google.cloud.talent.v4.PostingRegion] (for example,
     * state, country) throughout which the job is available. If this field is
     * set, a [LocationFilter][google.cloud.talent.v4.LocationFilter] in a search
     * query within the job region finds this job posting if an exact location
     * match isn't specified. If this field is set to
     * [PostingRegion.NATION][google.cloud.talent.v4.PostingRegion.NATION] or
     * [PostingRegion.ADMINISTRATIVE_AREA][google.cloud.talent.v4.PostingRegion.ADMINISTRATIVE_AREA],
     * setting job [Job.addresses][google.cloud.talent.v4.Job.addresses] to the
     * same location level as this field is strongly recommended.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.PostingRegion posting_region = 20;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPostingRegion() {
      bitField0_ = (bitField0_ & ~0x00080000);
      postingRegion_ = 0;
      onChanged();
      return this;
    }

    private int visibility_ = 0;
    /**
     *
     *
     * <pre>
     * Deprecated. The job is only visible to the owner.
     *
     * The visibility of the job.
     *
     * Defaults to
     * [Visibility.ACCOUNT_ONLY][google.cloud.talent.v4.Visibility.ACCOUNT_ONLY]
     * if not specified.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Visibility visibility = 21 [deprecated = true];</code>
     *
     * @deprecated google.cloud.talent.v4.Job.visibility is deprecated. See
     *     google/cloud/talent/v4/job.proto;l=295
     * @return The enum numeric value on the wire for visibility.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public int getVisibilityValue() {
      return visibility_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The job is only visible to the owner.
     *
     * The visibility of the job.
     *
     * Defaults to
     * [Visibility.ACCOUNT_ONLY][google.cloud.talent.v4.Visibility.ACCOUNT_ONLY]
     * if not specified.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Visibility visibility = 21 [deprecated = true];</code>
     *
     * @deprecated google.cloud.talent.v4.Job.visibility is deprecated. See
     *     google/cloud/talent/v4/job.proto;l=295
     * @param value The enum numeric value on the wire for visibility to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setVisibilityValue(int value) {
      visibility_ = value;
      bitField0_ |= 0x00100000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The job is only visible to the owner.
     *
     * The visibility of the job.
     *
     * Defaults to
     * [Visibility.ACCOUNT_ONLY][google.cloud.talent.v4.Visibility.ACCOUNT_ONLY]
     * if not specified.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Visibility visibility = 21 [deprecated = true];</code>
     *
     * @deprecated google.cloud.talent.v4.Job.visibility is deprecated. See
     *     google/cloud/talent/v4/job.proto;l=295
     * @return The visibility.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public com.google.cloud.talent.v4.Visibility getVisibility() {
      com.google.cloud.talent.v4.Visibility result =
          com.google.cloud.talent.v4.Visibility.forNumber(visibility_);
      return result == null ? com.google.cloud.talent.v4.Visibility.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The job is only visible to the owner.
     *
     * The visibility of the job.
     *
     * Defaults to
     * [Visibility.ACCOUNT_ONLY][google.cloud.talent.v4.Visibility.ACCOUNT_ONLY]
     * if not specified.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Visibility visibility = 21 [deprecated = true];</code>
     *
     * @deprecated google.cloud.talent.v4.Job.visibility is deprecated. See
     *     google/cloud/talent/v4/job.proto;l=295
     * @param value The visibility to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setVisibility(com.google.cloud.talent.v4.Visibility value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00100000;
      visibility_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. The job is only visible to the owner.
     *
     * The visibility of the job.
     *
     * Defaults to
     * [Visibility.ACCOUNT_ONLY][google.cloud.talent.v4.Visibility.ACCOUNT_ONLY]
     * if not specified.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Visibility visibility = 21 [deprecated = true];</code>
     *
     * @deprecated google.cloud.talent.v4.Job.visibility is deprecated. See
     *     google/cloud/talent/v4/job.proto;l=295
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearVisibility() {
      bitField0_ = (bitField0_ & ~0x00100000);
      visibility_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp jobStartTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        jobStartTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The start timestamp of the job in UTC time zone. Typically this field
     * is used for contracting engagements. Invalid timestamps are ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_start_time = 22;</code>
     *
     * @return Whether the jobStartTime field is set.
     */
    public boolean hasJobStartTime() {
      return ((bitField0_ & 0x00200000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The start timestamp of the job in UTC time zone. Typically this field
     * is used for contracting engagements. Invalid timestamps are ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_start_time = 22;</code>
     *
     * @return The jobStartTime.
     */
    public com.google.protobuf.Timestamp getJobStartTime() {
      if (jobStartTimeBuilder_ == null) {
        return jobStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : jobStartTime_;
      } else {
        return jobStartTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The start timestamp of the job in UTC time zone. Typically this field
     * is used for contracting engagements. Invalid timestamps are ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_start_time = 22;</code>
     */
    public Builder setJobStartTime(com.google.protobuf.Timestamp value) {
      if (jobStartTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobStartTime_ = value;
      } else {
        jobStartTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The start timestamp of the job in UTC time zone. Typically this field
     * is used for contracting engagements. Invalid timestamps are ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_start_time = 22;</code>
     */
    public Builder setJobStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (jobStartTimeBuilder_ == null) {
        jobStartTime_ = builderForValue.build();
      } else {
        jobStartTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The start timestamp of the job in UTC time zone. Typically this field
     * is used for contracting engagements. Invalid timestamps are ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_start_time = 22;</code>
     */
    public Builder mergeJobStartTime(com.google.protobuf.Timestamp value) {
      if (jobStartTimeBuilder_ == null) {
        if (((bitField0_ & 0x00200000) != 0)
            && jobStartTime_ != null
            && jobStartTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getJobStartTimeBuilder().mergeFrom(value);
        } else {
          jobStartTime_ = value;
        }
      } else {
        jobStartTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00200000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The start timestamp of the job in UTC time zone. Typically this field
     * is used for contracting engagements. Invalid timestamps are ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_start_time = 22;</code>
     */
    public Builder clearJobStartTime() {
      bitField0_ = (bitField0_ & ~0x00200000);
      jobStartTime_ = null;
      if (jobStartTimeBuilder_ != null) {
        jobStartTimeBuilder_.dispose();
        jobStartTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The start timestamp of the job in UTC time zone. Typically this field
     * is used for contracting engagements. Invalid timestamps are ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_start_time = 22;</code>
     */
    public com.google.protobuf.Timestamp.Builder getJobStartTimeBuilder() {
      bitField0_ |= 0x00200000;
      onChanged();
      return getJobStartTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The start timestamp of the job in UTC time zone. Typically this field
     * is used for contracting engagements. Invalid timestamps are ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_start_time = 22;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getJobStartTimeOrBuilder() {
      if (jobStartTimeBuilder_ != null) {
        return jobStartTimeBuilder_.getMessageOrBuilder();
      } else {
        return jobStartTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : jobStartTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The start timestamp of the job in UTC time zone. Typically this field
     * is used for contracting engagements. Invalid timestamps are ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_start_time = 22;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getJobStartTimeFieldBuilder() {
      if (jobStartTimeBuilder_ == null) {
        jobStartTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getJobStartTime(), getParentForChildren(), isClean());
        jobStartTime_ = null;
      }
      return jobStartTimeBuilder_;
    }

    private com.google.protobuf.Timestamp jobEndTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        jobEndTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The end timestamp of the job. Typically this field is used for contracting
     * engagements. Invalid timestamps are ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_end_time = 23;</code>
     *
     * @return Whether the jobEndTime field is set.
     */
    public boolean hasJobEndTime() {
      return ((bitField0_ & 0x00400000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The end timestamp of the job. Typically this field is used for contracting
     * engagements. Invalid timestamps are ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_end_time = 23;</code>
     *
     * @return The jobEndTime.
     */
    public com.google.protobuf.Timestamp getJobEndTime() {
      if (jobEndTimeBuilder_ == null) {
        return jobEndTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : jobEndTime_;
      } else {
        return jobEndTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The end timestamp of the job. Typically this field is used for contracting
     * engagements. Invalid timestamps are ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_end_time = 23;</code>
     */
    public Builder setJobEndTime(com.google.protobuf.Timestamp value) {
      if (jobEndTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobEndTime_ = value;
      } else {
        jobEndTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end timestamp of the job. Typically this field is used for contracting
     * engagements. Invalid timestamps are ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_end_time = 23;</code>
     */
    public Builder setJobEndTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (jobEndTimeBuilder_ == null) {
        jobEndTime_ = builderForValue.build();
      } else {
        jobEndTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end timestamp of the job. Typically this field is used for contracting
     * engagements. Invalid timestamps are ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_end_time = 23;</code>
     */
    public Builder mergeJobEndTime(com.google.protobuf.Timestamp value) {
      if (jobEndTimeBuilder_ == null) {
        if (((bitField0_ & 0x00400000) != 0)
            && jobEndTime_ != null
            && jobEndTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getJobEndTimeBuilder().mergeFrom(value);
        } else {
          jobEndTime_ = value;
        }
      } else {
        jobEndTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00400000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end timestamp of the job. Typically this field is used for contracting
     * engagements. Invalid timestamps are ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_end_time = 23;</code>
     */
    public Builder clearJobEndTime() {
      bitField0_ = (bitField0_ & ~0x00400000);
      jobEndTime_ = null;
      if (jobEndTimeBuilder_ != null) {
        jobEndTimeBuilder_.dispose();
        jobEndTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The end timestamp of the job. Typically this field is used for contracting
     * engagements. Invalid timestamps are ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_end_time = 23;</code>
     */
    public com.google.protobuf.Timestamp.Builder getJobEndTimeBuilder() {
      bitField0_ |= 0x00400000;
      onChanged();
      return getJobEndTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The end timestamp of the job. Typically this field is used for contracting
     * engagements. Invalid timestamps are ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_end_time = 23;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getJobEndTimeOrBuilder() {
      if (jobEndTimeBuilder_ != null) {
        return jobEndTimeBuilder_.getMessageOrBuilder();
      } else {
        return jobEndTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : jobEndTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The end timestamp of the job. Typically this field is used for contracting
     * engagements. Invalid timestamps are ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp job_end_time = 23;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getJobEndTimeFieldBuilder() {
      if (jobEndTimeBuilder_ == null) {
        jobEndTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getJobEndTime(), getParentForChildren(), isClean());
        jobEndTime_ = null;
      }
      return jobEndTimeBuilder_;
    }

    private com.google.protobuf.Timestamp postingPublishTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        postingPublishTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The timestamp this job posting was most recently published. The default
     * value is the time the request arrives at the server. Invalid timestamps are
     * ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp posting_publish_time = 24;</code>
     *
     * @return Whether the postingPublishTime field is set.
     */
    public boolean hasPostingPublishTime() {
      return ((bitField0_ & 0x00800000) != 0);
    }
    /**
     *
     *
     * <pre>
     * The timestamp this job posting was most recently published. The default
     * value is the time the request arrives at the server. Invalid timestamps are
     * ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp posting_publish_time = 24;</code>
     *
     * @return The postingPublishTime.
     */
    public com.google.protobuf.Timestamp getPostingPublishTime() {
      if (postingPublishTimeBuilder_ == null) {
        return postingPublishTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : postingPublishTime_;
      } else {
        return postingPublishTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp this job posting was most recently published. The default
     * value is the time the request arrives at the server. Invalid timestamps are
     * ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp posting_publish_time = 24;</code>
     */
    public Builder setPostingPublishTime(com.google.protobuf.Timestamp value) {
      if (postingPublishTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        postingPublishTime_ = value;
      } else {
        postingPublishTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp this job posting was most recently published. The default
     * value is the time the request arrives at the server. Invalid timestamps are
     * ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp posting_publish_time = 24;</code>
     */
    public Builder setPostingPublishTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (postingPublishTimeBuilder_ == null) {
        postingPublishTime_ = builderForValue.build();
      } else {
        postingPublishTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp this job posting was most recently published. The default
     * value is the time the request arrives at the server. Invalid timestamps are
     * ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp posting_publish_time = 24;</code>
     */
    public Builder mergePostingPublishTime(com.google.protobuf.Timestamp value) {
      if (postingPublishTimeBuilder_ == null) {
        if (((bitField0_ & 0x00800000) != 0)
            && postingPublishTime_ != null
            && postingPublishTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getPostingPublishTimeBuilder().mergeFrom(value);
        } else {
          postingPublishTime_ = value;
        }
      } else {
        postingPublishTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00800000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp this job posting was most recently published. The default
     * value is the time the request arrives at the server. Invalid timestamps are
     * ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp posting_publish_time = 24;</code>
     */
    public Builder clearPostingPublishTime() {
      bitField0_ = (bitField0_ & ~0x00800000);
      postingPublishTime_ = null;
      if (postingPublishTimeBuilder_ != null) {
        postingPublishTimeBuilder_.dispose();
        postingPublishTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The timestamp this job posting was most recently published. The default
     * value is the time the request arrives at the server. Invalid timestamps are
     * ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp posting_publish_time = 24;</code>
     */
    public com.google.protobuf.Timestamp.Builder getPostingPublishTimeBuilder() {
      bitField0_ |= 0x00800000;
      onChanged();
      return getPostingPublishTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The timestamp this job posting was most recently published. The default
     * value is the time the request arrives at the server. Invalid timestamps are
     * ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp posting_publish_time = 24;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getPostingPublishTimeOrBuilder() {
      if (postingPublishTimeBuilder_ != null) {
        return postingPublishTimeBuilder_.getMessageOrBuilder();
      } else {
        return postingPublishTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : postingPublishTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The timestamp this job posting was most recently published. The default
     * value is the time the request arrives at the server. Invalid timestamps are
     * ignored.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp posting_publish_time = 24;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getPostingPublishTimeFieldBuilder() {
      if (postingPublishTimeBuilder_ == null) {
        postingPublishTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getPostingPublishTime(), getParentForChildren(), isClean());
        postingPublishTime_ = null;
      }
      return postingPublishTimeBuilder_;
    }

    private com.google.protobuf.Timestamp postingExpireTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        postingExpireTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * The expiration timestamp of the job. After this timestamp, the
     * job is marked as expired, and it no longer appears in search results. The
     * expired job can't be listed by the
     * [ListJobs][google.cloud.talent.v4.JobService.ListJobs] API, but it can be
     * retrieved with the [GetJob][google.cloud.talent.v4.JobService.GetJob] API
     * or updated with the
     * [UpdateJob][google.cloud.talent.v4.JobService.UpdateJob] API or deleted
     * with the [DeleteJob][google.cloud.talent.v4.JobService.DeleteJob] API. An
     * expired job can be updated and opened again by using a future expiration
     * timestamp. Updating an expired job fails if there is another existing open
     * job with same [company][google.cloud.talent.v4.Job.company],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
     *
     * The expired jobs are retained in our system for 90 days. However, the
     * overall expired job count cannot exceed 3 times the maximum number of
     * open jobs over previous 7 days. If this threshold is exceeded,
     * expired jobs are cleaned out in order of earliest expire time.
     * Expired jobs are no longer accessible after they are cleaned
     * out.
     *
     * Invalid timestamps are ignored, and treated as expire time not provided.
     *
     * If the timestamp is before the instant request is made, the job
     * is treated as expired immediately on creation. This kind of job can
     * not be updated. And when creating a job with past timestamp, the
     * [posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     * must be set before
     * [posting_expire_time][google.cloud.talent.v4.Job.posting_expire_time]. The
     * purpose of this feature is to allow other objects, such as [Application][],
     * to refer a job that didn't exist in the system prior to becoming expired.
     * If you want to modify a job that was expired on creation, delete it and
     * create a new one.
     *
     * If this value isn't provided at the time of job creation or is invalid,
     * the job posting expires after 30 days from the job's creation time. For
     * example, if the job was created on 2017/01/01 13:00AM UTC with an
     * unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC.
     *
     * If this value isn't provided on job update, it depends on the field masks
     * set by
     * [UpdateJobRequest.update_mask][google.cloud.talent.v4.UpdateJobRequest.update_mask].
     * If the field masks include
     * [job_end_time][google.cloud.talent.v4.Job.job_end_time], or the masks are
     * empty meaning that every field is updated, the job posting expires after 30
     * days from the job's last update time. Otherwise the expiration date isn't
     * updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp posting_expire_time = 25;</code>
     *
     * @return Whether the postingExpireTime field is set.
     */
    public boolean hasPostingExpireTime() {
      return ((bitField0_ & 0x01000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * The expiration timestamp of the job. After this timestamp, the
     * job is marked as expired, and it no longer appears in search results. The
     * expired job can't be listed by the
     * [ListJobs][google.cloud.talent.v4.JobService.ListJobs] API, but it can be
     * retrieved with the [GetJob][google.cloud.talent.v4.JobService.GetJob] API
     * or updated with the
     * [UpdateJob][google.cloud.talent.v4.JobService.UpdateJob] API or deleted
     * with the [DeleteJob][google.cloud.talent.v4.JobService.DeleteJob] API. An
     * expired job can be updated and opened again by using a future expiration
     * timestamp. Updating an expired job fails if there is another existing open
     * job with same [company][google.cloud.talent.v4.Job.company],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
     *
     * The expired jobs are retained in our system for 90 days. However, the
     * overall expired job count cannot exceed 3 times the maximum number of
     * open jobs over previous 7 days. If this threshold is exceeded,
     * expired jobs are cleaned out in order of earliest expire time.
     * Expired jobs are no longer accessible after they are cleaned
     * out.
     *
     * Invalid timestamps are ignored, and treated as expire time not provided.
     *
     * If the timestamp is before the instant request is made, the job
     * is treated as expired immediately on creation. This kind of job can
     * not be updated. And when creating a job with past timestamp, the
     * [posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     * must be set before
     * [posting_expire_time][google.cloud.talent.v4.Job.posting_expire_time]. The
     * purpose of this feature is to allow other objects, such as [Application][],
     * to refer a job that didn't exist in the system prior to becoming expired.
     * If you want to modify a job that was expired on creation, delete it and
     * create a new one.
     *
     * If this value isn't provided at the time of job creation or is invalid,
     * the job posting expires after 30 days from the job's creation time. For
     * example, if the job was created on 2017/01/01 13:00AM UTC with an
     * unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC.
     *
     * If this value isn't provided on job update, it depends on the field masks
     * set by
     * [UpdateJobRequest.update_mask][google.cloud.talent.v4.UpdateJobRequest.update_mask].
     * If the field masks include
     * [job_end_time][google.cloud.talent.v4.Job.job_end_time], or the masks are
     * empty meaning that every field is updated, the job posting expires after 30
     * days from the job's last update time. Otherwise the expiration date isn't
     * updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp posting_expire_time = 25;</code>
     *
     * @return The postingExpireTime.
     */
    public com.google.protobuf.Timestamp getPostingExpireTime() {
      if (postingExpireTimeBuilder_ == null) {
        return postingExpireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : postingExpireTime_;
      } else {
        return postingExpireTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * The expiration timestamp of the job. After this timestamp, the
     * job is marked as expired, and it no longer appears in search results. The
     * expired job can't be listed by the
     * [ListJobs][google.cloud.talent.v4.JobService.ListJobs] API, but it can be
     * retrieved with the [GetJob][google.cloud.talent.v4.JobService.GetJob] API
     * or updated with the
     * [UpdateJob][google.cloud.talent.v4.JobService.UpdateJob] API or deleted
     * with the [DeleteJob][google.cloud.talent.v4.JobService.DeleteJob] API. An
     * expired job can be updated and opened again by using a future expiration
     * timestamp. Updating an expired job fails if there is another existing open
     * job with same [company][google.cloud.talent.v4.Job.company],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
     *
     * The expired jobs are retained in our system for 90 days. However, the
     * overall expired job count cannot exceed 3 times the maximum number of
     * open jobs over previous 7 days. If this threshold is exceeded,
     * expired jobs are cleaned out in order of earliest expire time.
     * Expired jobs are no longer accessible after they are cleaned
     * out.
     *
     * Invalid timestamps are ignored, and treated as expire time not provided.
     *
     * If the timestamp is before the instant request is made, the job
     * is treated as expired immediately on creation. This kind of job can
     * not be updated. And when creating a job with past timestamp, the
     * [posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     * must be set before
     * [posting_expire_time][google.cloud.talent.v4.Job.posting_expire_time]. The
     * purpose of this feature is to allow other objects, such as [Application][],
     * to refer a job that didn't exist in the system prior to becoming expired.
     * If you want to modify a job that was expired on creation, delete it and
     * create a new one.
     *
     * If this value isn't provided at the time of job creation or is invalid,
     * the job posting expires after 30 days from the job's creation time. For
     * example, if the job was created on 2017/01/01 13:00AM UTC with an
     * unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC.
     *
     * If this value isn't provided on job update, it depends on the field masks
     * set by
     * [UpdateJobRequest.update_mask][google.cloud.talent.v4.UpdateJobRequest.update_mask].
     * If the field masks include
     * [job_end_time][google.cloud.talent.v4.Job.job_end_time], or the masks are
     * empty meaning that every field is updated, the job posting expires after 30
     * days from the job's last update time. Otherwise the expiration date isn't
     * updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp posting_expire_time = 25;</code>
     */
    public Builder setPostingExpireTime(com.google.protobuf.Timestamp value) {
      if (postingExpireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        postingExpireTime_ = value;
      } else {
        postingExpireTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * The expiration timestamp of the job. After this timestamp, the
     * job is marked as expired, and it no longer appears in search results. The
     * expired job can't be listed by the
     * [ListJobs][google.cloud.talent.v4.JobService.ListJobs] API, but it can be
     * retrieved with the [GetJob][google.cloud.talent.v4.JobService.GetJob] API
     * or updated with the
     * [UpdateJob][google.cloud.talent.v4.JobService.UpdateJob] API or deleted
     * with the [DeleteJob][google.cloud.talent.v4.JobService.DeleteJob] API. An
     * expired job can be updated and opened again by using a future expiration
     * timestamp. Updating an expired job fails if there is another existing open
     * job with same [company][google.cloud.talent.v4.Job.company],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
     *
     * The expired jobs are retained in our system for 90 days. However, the
     * overall expired job count cannot exceed 3 times the maximum number of
     * open jobs over previous 7 days. If this threshold is exceeded,
     * expired jobs are cleaned out in order of earliest expire time.
     * Expired jobs are no longer accessible after they are cleaned
     * out.
     *
     * Invalid timestamps are ignored, and treated as expire time not provided.
     *
     * If the timestamp is before the instant request is made, the job
     * is treated as expired immediately on creation. This kind of job can
     * not be updated. And when creating a job with past timestamp, the
     * [posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     * must be set before
     * [posting_expire_time][google.cloud.talent.v4.Job.posting_expire_time]. The
     * purpose of this feature is to allow other objects, such as [Application][],
     * to refer a job that didn't exist in the system prior to becoming expired.
     * If you want to modify a job that was expired on creation, delete it and
     * create a new one.
     *
     * If this value isn't provided at the time of job creation or is invalid,
     * the job posting expires after 30 days from the job's creation time. For
     * example, if the job was created on 2017/01/01 13:00AM UTC with an
     * unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC.
     *
     * If this value isn't provided on job update, it depends on the field masks
     * set by
     * [UpdateJobRequest.update_mask][google.cloud.talent.v4.UpdateJobRequest.update_mask].
     * If the field masks include
     * [job_end_time][google.cloud.talent.v4.Job.job_end_time], or the masks are
     * empty meaning that every field is updated, the job posting expires after 30
     * days from the job's last update time. Otherwise the expiration date isn't
     * updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp posting_expire_time = 25;</code>
     */
    public Builder setPostingExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (postingExpireTimeBuilder_ == null) {
        postingExpireTime_ = builderForValue.build();
      } else {
        postingExpireTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * The expiration timestamp of the job. After this timestamp, the
     * job is marked as expired, and it no longer appears in search results. The
     * expired job can't be listed by the
     * [ListJobs][google.cloud.talent.v4.JobService.ListJobs] API, but it can be
     * retrieved with the [GetJob][google.cloud.talent.v4.JobService.GetJob] API
     * or updated with the
     * [UpdateJob][google.cloud.talent.v4.JobService.UpdateJob] API or deleted
     * with the [DeleteJob][google.cloud.talent.v4.JobService.DeleteJob] API. An
     * expired job can be updated and opened again by using a future expiration
     * timestamp. Updating an expired job fails if there is another existing open
     * job with same [company][google.cloud.talent.v4.Job.company],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
     *
     * The expired jobs are retained in our system for 90 days. However, the
     * overall expired job count cannot exceed 3 times the maximum number of
     * open jobs over previous 7 days. If this threshold is exceeded,
     * expired jobs are cleaned out in order of earliest expire time.
     * Expired jobs are no longer accessible after they are cleaned
     * out.
     *
     * Invalid timestamps are ignored, and treated as expire time not provided.
     *
     * If the timestamp is before the instant request is made, the job
     * is treated as expired immediately on creation. This kind of job can
     * not be updated. And when creating a job with past timestamp, the
     * [posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     * must be set before
     * [posting_expire_time][google.cloud.talent.v4.Job.posting_expire_time]. The
     * purpose of this feature is to allow other objects, such as [Application][],
     * to refer a job that didn't exist in the system prior to becoming expired.
     * If you want to modify a job that was expired on creation, delete it and
     * create a new one.
     *
     * If this value isn't provided at the time of job creation or is invalid,
     * the job posting expires after 30 days from the job's creation time. For
     * example, if the job was created on 2017/01/01 13:00AM UTC with an
     * unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC.
     *
     * If this value isn't provided on job update, it depends on the field masks
     * set by
     * [UpdateJobRequest.update_mask][google.cloud.talent.v4.UpdateJobRequest.update_mask].
     * If the field masks include
     * [job_end_time][google.cloud.talent.v4.Job.job_end_time], or the masks are
     * empty meaning that every field is updated, the job posting expires after 30
     * days from the job's last update time. Otherwise the expiration date isn't
     * updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp posting_expire_time = 25;</code>
     */
    public Builder mergePostingExpireTime(com.google.protobuf.Timestamp value) {
      if (postingExpireTimeBuilder_ == null) {
        if (((bitField0_ & 0x01000000) != 0)
            && postingExpireTime_ != null
            && postingExpireTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getPostingExpireTimeBuilder().mergeFrom(value);
        } else {
          postingExpireTime_ = value;
        }
      } else {
        postingExpireTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x01000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * The expiration timestamp of the job. After this timestamp, the
     * job is marked as expired, and it no longer appears in search results. The
     * expired job can't be listed by the
     * [ListJobs][google.cloud.talent.v4.JobService.ListJobs] API, but it can be
     * retrieved with the [GetJob][google.cloud.talent.v4.JobService.GetJob] API
     * or updated with the
     * [UpdateJob][google.cloud.talent.v4.JobService.UpdateJob] API or deleted
     * with the [DeleteJob][google.cloud.talent.v4.JobService.DeleteJob] API. An
     * expired job can be updated and opened again by using a future expiration
     * timestamp. Updating an expired job fails if there is another existing open
     * job with same [company][google.cloud.talent.v4.Job.company],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
     *
     * The expired jobs are retained in our system for 90 days. However, the
     * overall expired job count cannot exceed 3 times the maximum number of
     * open jobs over previous 7 days. If this threshold is exceeded,
     * expired jobs are cleaned out in order of earliest expire time.
     * Expired jobs are no longer accessible after they are cleaned
     * out.
     *
     * Invalid timestamps are ignored, and treated as expire time not provided.
     *
     * If the timestamp is before the instant request is made, the job
     * is treated as expired immediately on creation. This kind of job can
     * not be updated. And when creating a job with past timestamp, the
     * [posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     * must be set before
     * [posting_expire_time][google.cloud.talent.v4.Job.posting_expire_time]. The
     * purpose of this feature is to allow other objects, such as [Application][],
     * to refer a job that didn't exist in the system prior to becoming expired.
     * If you want to modify a job that was expired on creation, delete it and
     * create a new one.
     *
     * If this value isn't provided at the time of job creation or is invalid,
     * the job posting expires after 30 days from the job's creation time. For
     * example, if the job was created on 2017/01/01 13:00AM UTC with an
     * unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC.
     *
     * If this value isn't provided on job update, it depends on the field masks
     * set by
     * [UpdateJobRequest.update_mask][google.cloud.talent.v4.UpdateJobRequest.update_mask].
     * If the field masks include
     * [job_end_time][google.cloud.talent.v4.Job.job_end_time], or the masks are
     * empty meaning that every field is updated, the job posting expires after 30
     * days from the job's last update time. Otherwise the expiration date isn't
     * updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp posting_expire_time = 25;</code>
     */
    public Builder clearPostingExpireTime() {
      bitField0_ = (bitField0_ & ~0x01000000);
      postingExpireTime_ = null;
      if (postingExpireTimeBuilder_ != null) {
        postingExpireTimeBuilder_.dispose();
        postingExpireTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * The expiration timestamp of the job. After this timestamp, the
     * job is marked as expired, and it no longer appears in search results. The
     * expired job can't be listed by the
     * [ListJobs][google.cloud.talent.v4.JobService.ListJobs] API, but it can be
     * retrieved with the [GetJob][google.cloud.talent.v4.JobService.GetJob] API
     * or updated with the
     * [UpdateJob][google.cloud.talent.v4.JobService.UpdateJob] API or deleted
     * with the [DeleteJob][google.cloud.talent.v4.JobService.DeleteJob] API. An
     * expired job can be updated and opened again by using a future expiration
     * timestamp. Updating an expired job fails if there is another existing open
     * job with same [company][google.cloud.talent.v4.Job.company],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
     *
     * The expired jobs are retained in our system for 90 days. However, the
     * overall expired job count cannot exceed 3 times the maximum number of
     * open jobs over previous 7 days. If this threshold is exceeded,
     * expired jobs are cleaned out in order of earliest expire time.
     * Expired jobs are no longer accessible after they are cleaned
     * out.
     *
     * Invalid timestamps are ignored, and treated as expire time not provided.
     *
     * If the timestamp is before the instant request is made, the job
     * is treated as expired immediately on creation. This kind of job can
     * not be updated. And when creating a job with past timestamp, the
     * [posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     * must be set before
     * [posting_expire_time][google.cloud.talent.v4.Job.posting_expire_time]. The
     * purpose of this feature is to allow other objects, such as [Application][],
     * to refer a job that didn't exist in the system prior to becoming expired.
     * If you want to modify a job that was expired on creation, delete it and
     * create a new one.
     *
     * If this value isn't provided at the time of job creation or is invalid,
     * the job posting expires after 30 days from the job's creation time. For
     * example, if the job was created on 2017/01/01 13:00AM UTC with an
     * unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC.
     *
     * If this value isn't provided on job update, it depends on the field masks
     * set by
     * [UpdateJobRequest.update_mask][google.cloud.talent.v4.UpdateJobRequest.update_mask].
     * If the field masks include
     * [job_end_time][google.cloud.talent.v4.Job.job_end_time], or the masks are
     * empty meaning that every field is updated, the job posting expires after 30
     * days from the job's last update time. Otherwise the expiration date isn't
     * updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp posting_expire_time = 25;</code>
     */
    public com.google.protobuf.Timestamp.Builder getPostingExpireTimeBuilder() {
      bitField0_ |= 0x01000000;
      onChanged();
      return getPostingExpireTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * The expiration timestamp of the job. After this timestamp, the
     * job is marked as expired, and it no longer appears in search results. The
     * expired job can't be listed by the
     * [ListJobs][google.cloud.talent.v4.JobService.ListJobs] API, but it can be
     * retrieved with the [GetJob][google.cloud.talent.v4.JobService.GetJob] API
     * or updated with the
     * [UpdateJob][google.cloud.talent.v4.JobService.UpdateJob] API or deleted
     * with the [DeleteJob][google.cloud.talent.v4.JobService.DeleteJob] API. An
     * expired job can be updated and opened again by using a future expiration
     * timestamp. Updating an expired job fails if there is another existing open
     * job with same [company][google.cloud.talent.v4.Job.company],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
     *
     * The expired jobs are retained in our system for 90 days. However, the
     * overall expired job count cannot exceed 3 times the maximum number of
     * open jobs over previous 7 days. If this threshold is exceeded,
     * expired jobs are cleaned out in order of earliest expire time.
     * Expired jobs are no longer accessible after they are cleaned
     * out.
     *
     * Invalid timestamps are ignored, and treated as expire time not provided.
     *
     * If the timestamp is before the instant request is made, the job
     * is treated as expired immediately on creation. This kind of job can
     * not be updated. And when creating a job with past timestamp, the
     * [posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     * must be set before
     * [posting_expire_time][google.cloud.talent.v4.Job.posting_expire_time]. The
     * purpose of this feature is to allow other objects, such as [Application][],
     * to refer a job that didn't exist in the system prior to becoming expired.
     * If you want to modify a job that was expired on creation, delete it and
     * create a new one.
     *
     * If this value isn't provided at the time of job creation or is invalid,
     * the job posting expires after 30 days from the job's creation time. For
     * example, if the job was created on 2017/01/01 13:00AM UTC with an
     * unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC.
     *
     * If this value isn't provided on job update, it depends on the field masks
     * set by
     * [UpdateJobRequest.update_mask][google.cloud.talent.v4.UpdateJobRequest.update_mask].
     * If the field masks include
     * [job_end_time][google.cloud.talent.v4.Job.job_end_time], or the masks are
     * empty meaning that every field is updated, the job posting expires after 30
     * days from the job's last update time. Otherwise the expiration date isn't
     * updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp posting_expire_time = 25;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getPostingExpireTimeOrBuilder() {
      if (postingExpireTimeBuilder_ != null) {
        return postingExpireTimeBuilder_.getMessageOrBuilder();
      } else {
        return postingExpireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : postingExpireTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Strongly recommended for the best service experience.
     *
     * The expiration timestamp of the job. After this timestamp, the
     * job is marked as expired, and it no longer appears in search results. The
     * expired job can't be listed by the
     * [ListJobs][google.cloud.talent.v4.JobService.ListJobs] API, but it can be
     * retrieved with the [GetJob][google.cloud.talent.v4.JobService.GetJob] API
     * or updated with the
     * [UpdateJob][google.cloud.talent.v4.JobService.UpdateJob] API or deleted
     * with the [DeleteJob][google.cloud.talent.v4.JobService.DeleteJob] API. An
     * expired job can be updated and opened again by using a future expiration
     * timestamp. Updating an expired job fails if there is another existing open
     * job with same [company][google.cloud.talent.v4.Job.company],
     * [language_code][google.cloud.talent.v4.Job.language_code] and
     * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
     *
     * The expired jobs are retained in our system for 90 days. However, the
     * overall expired job count cannot exceed 3 times the maximum number of
     * open jobs over previous 7 days. If this threshold is exceeded,
     * expired jobs are cleaned out in order of earliest expire time.
     * Expired jobs are no longer accessible after they are cleaned
     * out.
     *
     * Invalid timestamps are ignored, and treated as expire time not provided.
     *
     * If the timestamp is before the instant request is made, the job
     * is treated as expired immediately on creation. This kind of job can
     * not be updated. And when creating a job with past timestamp, the
     * [posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     * must be set before
     * [posting_expire_time][google.cloud.talent.v4.Job.posting_expire_time]. The
     * purpose of this feature is to allow other objects, such as [Application][],
     * to refer a job that didn't exist in the system prior to becoming expired.
     * If you want to modify a job that was expired on creation, delete it and
     * create a new one.
     *
     * If this value isn't provided at the time of job creation or is invalid,
     * the job posting expires after 30 days from the job's creation time. For
     * example, if the job was created on 2017/01/01 13:00AM UTC with an
     * unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC.
     *
     * If this value isn't provided on job update, it depends on the field masks
     * set by
     * [UpdateJobRequest.update_mask][google.cloud.talent.v4.UpdateJobRequest.update_mask].
     * If the field masks include
     * [job_end_time][google.cloud.talent.v4.Job.job_end_time], or the masks are
     * empty meaning that every field is updated, the job posting expires after 30
     * days from the job's last update time. Otherwise the expiration date isn't
     * updated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp posting_expire_time = 25;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getPostingExpireTimeFieldBuilder() {
      if (postingExpireTimeBuilder_ == null) {
        postingExpireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getPostingExpireTime(), getParentForChildren(), isClean());
        postingExpireTime_ = null;
      }
      return postingExpireTimeBuilder_;
    }

    private com.google.protobuf.Timestamp postingCreateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        postingCreateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this job posting was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp posting_create_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the postingCreateTime field is set.
     */
    public boolean hasPostingCreateTime() {
      return ((bitField0_ & 0x02000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this job posting was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp posting_create_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The postingCreateTime.
     */
    public com.google.protobuf.Timestamp getPostingCreateTime() {
      if (postingCreateTimeBuilder_ == null) {
        return postingCreateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : postingCreateTime_;
      } else {
        return postingCreateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this job posting was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp posting_create_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPostingCreateTime(com.google.protobuf.Timestamp value) {
      if (postingCreateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        postingCreateTime_ = value;
      } else {
        postingCreateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this job posting was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp posting_create_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPostingCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (postingCreateTimeBuilder_ == null) {
        postingCreateTime_ = builderForValue.build();
      } else {
        postingCreateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this job posting was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp posting_create_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePostingCreateTime(com.google.protobuf.Timestamp value) {
      if (postingCreateTimeBuilder_ == null) {
        if (((bitField0_ & 0x02000000) != 0)
            && postingCreateTime_ != null
            && postingCreateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getPostingCreateTimeBuilder().mergeFrom(value);
        } else {
          postingCreateTime_ = value;
        }
      } else {
        postingCreateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x02000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this job posting was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp posting_create_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPostingCreateTime() {
      bitField0_ = (bitField0_ & ~0x02000000);
      postingCreateTime_ = null;
      if (postingCreateTimeBuilder_ != null) {
        postingCreateTimeBuilder_.dispose();
        postingCreateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this job posting was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp posting_create_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getPostingCreateTimeBuilder() {
      bitField0_ |= 0x02000000;
      onChanged();
      return getPostingCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this job posting was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp posting_create_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getPostingCreateTimeOrBuilder() {
      if (postingCreateTimeBuilder_ != null) {
        return postingCreateTimeBuilder_.getMessageOrBuilder();
      } else {
        return postingCreateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : postingCreateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this job posting was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp posting_create_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getPostingCreateTimeFieldBuilder() {
      if (postingCreateTimeBuilder_ == null) {
        postingCreateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getPostingCreateTime(), getParentForChildren(), isClean());
        postingCreateTime_ = null;
      }
      return postingCreateTimeBuilder_;
    }

    private com.google.protobuf.Timestamp postingUpdateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        postingUpdateTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this job posting was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp posting_update_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the postingUpdateTime field is set.
     */
    public boolean hasPostingUpdateTime() {
      return ((bitField0_ & 0x04000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this job posting was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp posting_update_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The postingUpdateTime.
     */
    public com.google.protobuf.Timestamp getPostingUpdateTime() {
      if (postingUpdateTimeBuilder_ == null) {
        return postingUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : postingUpdateTime_;
      } else {
        return postingUpdateTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this job posting was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp posting_update_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPostingUpdateTime(com.google.protobuf.Timestamp value) {
      if (postingUpdateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        postingUpdateTime_ = value;
      } else {
        postingUpdateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this job posting was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp posting_update_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setPostingUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (postingUpdateTimeBuilder_ == null) {
        postingUpdateTime_ = builderForValue.build();
      } else {
        postingUpdateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this job posting was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp posting_update_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergePostingUpdateTime(com.google.protobuf.Timestamp value) {
      if (postingUpdateTimeBuilder_ == null) {
        if (((bitField0_ & 0x04000000) != 0)
            && postingUpdateTime_ != null
            && postingUpdateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getPostingUpdateTimeBuilder().mergeFrom(value);
        } else {
          postingUpdateTime_ = value;
        }
      } else {
        postingUpdateTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x04000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this job posting was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp posting_update_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearPostingUpdateTime() {
      bitField0_ = (bitField0_ & ~0x04000000);
      postingUpdateTime_ = null;
      if (postingUpdateTimeBuilder_ != null) {
        postingUpdateTimeBuilder_.dispose();
        postingUpdateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this job posting was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp posting_update_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getPostingUpdateTimeBuilder() {
      bitField0_ |= 0x04000000;
      onChanged();
      return getPostingUpdateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this job posting was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp posting_update_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getPostingUpdateTimeOrBuilder() {
      if (postingUpdateTimeBuilder_ != null) {
        return postingUpdateTimeBuilder_.getMessageOrBuilder();
      } else {
        return postingUpdateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : postingUpdateTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The timestamp when this job posting was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp posting_update_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getPostingUpdateTimeFieldBuilder() {
      if (postingUpdateTimeBuilder_ == null) {
        postingUpdateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getPostingUpdateTime(), getParentForChildren(), isClean());
        postingUpdateTime_ = null;
      }
      return postingUpdateTimeBuilder_;
    }

    private java.lang.Object companyDisplayName_ = "";
    /**
     *
     *
     * <pre>
     * Output only. Display name of the company listing the job.
     * </pre>
     *
     * <code>string company_display_name = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The companyDisplayName.
     */
    public java.lang.String getCompanyDisplayName() {
      java.lang.Object ref = companyDisplayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        companyDisplayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Display name of the company listing the job.
     * </pre>
     *
     * <code>string company_display_name = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for companyDisplayName.
     */
    public com.google.protobuf.ByteString getCompanyDisplayNameBytes() {
      java.lang.Object ref = companyDisplayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        companyDisplayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Display name of the company listing the job.
     * </pre>
     *
     * <code>string company_display_name = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The companyDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setCompanyDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      companyDisplayName_ = value;
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Display name of the company listing the job.
     * </pre>
     *
     * <code>string company_display_name = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCompanyDisplayName() {
      companyDisplayName_ = getDefaultInstance().getCompanyDisplayName();
      bitField0_ = (bitField0_ & ~0x08000000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Display name of the company listing the job.
     * </pre>
     *
     * <code>string company_display_name = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for companyDisplayName to set.
     * @return This builder for chaining.
     */
    public Builder setCompanyDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      companyDisplayName_ = value;
      bitField0_ |= 0x08000000;
      onChanged();
      return this;
    }

    private com.google.cloud.talent.v4.Job.DerivedInfo derivedInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.Job.DerivedInfo,
            com.google.cloud.talent.v4.Job.DerivedInfo.Builder,
            com.google.cloud.talent.v4.Job.DerivedInfoOrBuilder>
        derivedInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. Derived details about the job posting.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.Job.DerivedInfo derived_info = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the derivedInfo field is set.
     */
    public boolean hasDerivedInfo() {
      return ((bitField0_ & 0x10000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. Derived details about the job posting.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.Job.DerivedInfo derived_info = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The derivedInfo.
     */
    public com.google.cloud.talent.v4.Job.DerivedInfo getDerivedInfo() {
      if (derivedInfoBuilder_ == null) {
        return derivedInfo_ == null
            ? com.google.cloud.talent.v4.Job.DerivedInfo.getDefaultInstance()
            : derivedInfo_;
      } else {
        return derivedInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Derived details about the job posting.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.Job.DerivedInfo derived_info = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDerivedInfo(com.google.cloud.talent.v4.Job.DerivedInfo value) {
      if (derivedInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        derivedInfo_ = value;
      } else {
        derivedInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Derived details about the job posting.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.Job.DerivedInfo derived_info = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setDerivedInfo(
        com.google.cloud.talent.v4.Job.DerivedInfo.Builder builderForValue) {
      if (derivedInfoBuilder_ == null) {
        derivedInfo_ = builderForValue.build();
      } else {
        derivedInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Derived details about the job posting.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.Job.DerivedInfo derived_info = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeDerivedInfo(com.google.cloud.talent.v4.Job.DerivedInfo value) {
      if (derivedInfoBuilder_ == null) {
        if (((bitField0_ & 0x10000000) != 0)
            && derivedInfo_ != null
            && derivedInfo_ != com.google.cloud.talent.v4.Job.DerivedInfo.getDefaultInstance()) {
          getDerivedInfoBuilder().mergeFrom(value);
        } else {
          derivedInfo_ = value;
        }
      } else {
        derivedInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x10000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Derived details about the job posting.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.Job.DerivedInfo derived_info = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearDerivedInfo() {
      bitField0_ = (bitField0_ & ~0x10000000);
      derivedInfo_ = null;
      if (derivedInfoBuilder_ != null) {
        derivedInfoBuilder_.dispose();
        derivedInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. Derived details about the job posting.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.Job.DerivedInfo derived_info = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.talent.v4.Job.DerivedInfo.Builder getDerivedInfoBuilder() {
      bitField0_ |= 0x10000000;
      onChanged();
      return getDerivedInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. Derived details about the job posting.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.Job.DerivedInfo derived_info = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.talent.v4.Job.DerivedInfoOrBuilder getDerivedInfoOrBuilder() {
      if (derivedInfoBuilder_ != null) {
        return derivedInfoBuilder_.getMessageOrBuilder();
      } else {
        return derivedInfo_ == null
            ? com.google.cloud.talent.v4.Job.DerivedInfo.getDefaultInstance()
            : derivedInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. Derived details about the job posting.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.Job.DerivedInfo derived_info = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.Job.DerivedInfo,
            com.google.cloud.talent.v4.Job.DerivedInfo.Builder,
            com.google.cloud.talent.v4.Job.DerivedInfoOrBuilder>
        getDerivedInfoFieldBuilder() {
      if (derivedInfoBuilder_ == null) {
        derivedInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.talent.v4.Job.DerivedInfo,
                com.google.cloud.talent.v4.Job.DerivedInfo.Builder,
                com.google.cloud.talent.v4.Job.DerivedInfoOrBuilder>(
                getDerivedInfo(), getParentForChildren(), isClean());
        derivedInfo_ = null;
      }
      return derivedInfoBuilder_;
    }

    private com.google.cloud.talent.v4.Job.ProcessingOptions processingOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.Job.ProcessingOptions,
            com.google.cloud.talent.v4.Job.ProcessingOptions.Builder,
            com.google.cloud.talent.v4.Job.ProcessingOptionsOrBuilder>
        processingOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * Options for job processing.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job.ProcessingOptions processing_options = 30;</code>
     *
     * @return Whether the processingOptions field is set.
     */
    public boolean hasProcessingOptions() {
      return ((bitField0_ & 0x20000000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Options for job processing.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job.ProcessingOptions processing_options = 30;</code>
     *
     * @return The processingOptions.
     */
    public com.google.cloud.talent.v4.Job.ProcessingOptions getProcessingOptions() {
      if (processingOptionsBuilder_ == null) {
        return processingOptions_ == null
            ? com.google.cloud.talent.v4.Job.ProcessingOptions.getDefaultInstance()
            : processingOptions_;
      } else {
        return processingOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Options for job processing.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job.ProcessingOptions processing_options = 30;</code>
     */
    public Builder setProcessingOptions(com.google.cloud.talent.v4.Job.ProcessingOptions value) {
      if (processingOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        processingOptions_ = value;
      } else {
        processingOptionsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options for job processing.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job.ProcessingOptions processing_options = 30;</code>
     */
    public Builder setProcessingOptions(
        com.google.cloud.talent.v4.Job.ProcessingOptions.Builder builderForValue) {
      if (processingOptionsBuilder_ == null) {
        processingOptions_ = builderForValue.build();
      } else {
        processingOptionsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options for job processing.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job.ProcessingOptions processing_options = 30;</code>
     */
    public Builder mergeProcessingOptions(com.google.cloud.talent.v4.Job.ProcessingOptions value) {
      if (processingOptionsBuilder_ == null) {
        if (((bitField0_ & 0x20000000) != 0)
            && processingOptions_ != null
            && processingOptions_
                != com.google.cloud.talent.v4.Job.ProcessingOptions.getDefaultInstance()) {
          getProcessingOptionsBuilder().mergeFrom(value);
        } else {
          processingOptions_ = value;
        }
      } else {
        processingOptionsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x20000000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options for job processing.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job.ProcessingOptions processing_options = 30;</code>
     */
    public Builder clearProcessingOptions() {
      bitField0_ = (bitField0_ & ~0x20000000);
      processingOptions_ = null;
      if (processingOptionsBuilder_ != null) {
        processingOptionsBuilder_.dispose();
        processingOptionsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Options for job processing.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job.ProcessingOptions processing_options = 30;</code>
     */
    public com.google.cloud.talent.v4.Job.ProcessingOptions.Builder getProcessingOptionsBuilder() {
      bitField0_ |= 0x20000000;
      onChanged();
      return getProcessingOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Options for job processing.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job.ProcessingOptions processing_options = 30;</code>
     */
    public com.google.cloud.talent.v4.Job.ProcessingOptionsOrBuilder
        getProcessingOptionsOrBuilder() {
      if (processingOptionsBuilder_ != null) {
        return processingOptionsBuilder_.getMessageOrBuilder();
      } else {
        return processingOptions_ == null
            ? com.google.cloud.talent.v4.Job.ProcessingOptions.getDefaultInstance()
            : processingOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * Options for job processing.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job.ProcessingOptions processing_options = 30;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.Job.ProcessingOptions,
            com.google.cloud.talent.v4.Job.ProcessingOptions.Builder,
            com.google.cloud.talent.v4.Job.ProcessingOptionsOrBuilder>
        getProcessingOptionsFieldBuilder() {
      if (processingOptionsBuilder_ == null) {
        processingOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.talent.v4.Job.ProcessingOptions,
                com.google.cloud.talent.v4.Job.ProcessingOptions.Builder,
                com.google.cloud.talent.v4.Job.ProcessingOptionsOrBuilder>(
                getProcessingOptions(), getParentForChildren(), isClean());
        processingOptions_ = null;
      }
      return processingOptionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.talent.v4.Job)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.talent.v4.Job)
  private static final com.google.cloud.talent.v4.Job DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.talent.v4.Job();
  }

  public static com.google.cloud.talent.v4.Job getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Job> PARSER =
      new com.google.protobuf.AbstractParser<Job>() {
        @java.lang.Override
        public Job parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Job> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Job> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.talent.v4.Job getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
