/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/talent/v4/job.proto

package com.google.cloud.talent.v4;

public interface JobOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.talent.v4.Job)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required during job update.
   *
   * The resource name for the job. This is generated by the service when a
   * job is created.
   *
   * The format is
   * "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}". For
   * example, "projects/foo/tenants/bar/jobs/baz".
   *
   * Use of this field in job queries and API calls is preferred over the use of
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id] since this
   * value is unique.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();
  /**
   *
   *
   * <pre>
   * Required during job update.
   *
   * The resource name for the job. This is generated by the service when a
   * job is created.
   *
   * The format is
   * "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}". For
   * example, "projects/foo/tenants/bar/jobs/baz".
   *
   * Use of this field in job queries and API calls is preferred over the use of
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id] since this
   * value is unique.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Required. The resource name of the company listing the job.
   *
   * The format is
   * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
   * example, "projects/foo/tenants/bar/companies/baz".
   * </pre>
   *
   * <code>
   * string company = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The company.
   */
  java.lang.String getCompany();
  /**
   *
   *
   * <pre>
   * Required. The resource name of the company listing the job.
   *
   * The format is
   * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
   * example, "projects/foo/tenants/bar/companies/baz".
   * </pre>
   *
   * <code>
   * string company = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for company.
   */
  com.google.protobuf.ByteString getCompanyBytes();

  /**
   *
   *
   * <pre>
   * Required. The requisition ID, also referred to as the posting ID, is
   * assigned by the client to identify a job. This field is intended to be used
   * by clients for client identification and tracking of postings. A job isn't
   * allowed to be created if there is another job with the same
   * [company][google.cloud.talent.v4.Job.name],
   * [language_code][google.cloud.talent.v4.Job.language_code] and
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
   *
   * The maximum number of allowed characters is 255.
   * </pre>
   *
   * <code>string requisition_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The requisitionId.
   */
  java.lang.String getRequisitionId();
  /**
   *
   *
   * <pre>
   * Required. The requisition ID, also referred to as the posting ID, is
   * assigned by the client to identify a job. This field is intended to be used
   * by clients for client identification and tracking of postings. A job isn't
   * allowed to be created if there is another job with the same
   * [company][google.cloud.talent.v4.Job.name],
   * [language_code][google.cloud.talent.v4.Job.language_code] and
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
   *
   * The maximum number of allowed characters is 255.
   * </pre>
   *
   * <code>string requisition_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for requisitionId.
   */
  com.google.protobuf.ByteString getRequisitionIdBytes();

  /**
   *
   *
   * <pre>
   * Required. The title of the job, such as "Software Engineer"
   *
   * The maximum number of allowed characters is 500.
   * </pre>
   *
   * <code>string title = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The title.
   */
  java.lang.String getTitle();
  /**
   *
   *
   * <pre>
   * Required. The title of the job, such as "Software Engineer"
   *
   * The maximum number of allowed characters is 500.
   * </pre>
   *
   * <code>string title = 4 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for title.
   */
  com.google.protobuf.ByteString getTitleBytes();

  /**
   *
   *
   * <pre>
   * Required. The description of the job, which typically includes a
   * multi-paragraph description of the company and related information.
   * Separate fields are provided on the job object for
   * [responsibilities][google.cloud.talent.v4.Job.responsibilities],
   * [qualifications][google.cloud.talent.v4.Job.qualifications], and other job
   * characteristics. Use of these separate job fields is recommended.
   *
   * This field accepts and sanitizes HTML input, and also accepts
   * bold, italic, ordered list, and unordered list markup tags.
   *
   * The maximum number of allowed characters is 100,000.
   * </pre>
   *
   * <code>string description = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();
  /**
   *
   *
   * <pre>
   * Required. The description of the job, which typically includes a
   * multi-paragraph description of the company and related information.
   * Separate fields are provided on the job object for
   * [responsibilities][google.cloud.talent.v4.Job.responsibilities],
   * [qualifications][google.cloud.talent.v4.Job.qualifications], and other job
   * characteristics. Use of these separate job fields is recommended.
   *
   * This field accepts and sanitizes HTML input, and also accepts
   * bold, italic, ordered list, and unordered list markup tags.
   *
   * The maximum number of allowed characters is 100,000.
   * </pre>
   *
   * <code>string description = 5 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * Strongly recommended for the best service experience.
   *
   * Location(s) where the employer is looking to hire for this job posting.
   *
   * Specifying the full street address(es) of the hiring location enables
   * better API results, especially job searches by commute time.
   *
   * At most 50 locations are allowed for best search performance. If a job has
   * more locations, it is suggested to split it into multiple jobs with unique
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id]s (e.g. 'ReqA'
   * becomes 'ReqA-1', 'ReqA-2', and so on.) as multiple jobs with the same
   * [company][google.cloud.talent.v4.Job.company],
   * [language_code][google.cloud.talent.v4.Job.language_code] and
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id] are not
   * allowed. If the original
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id] must be
   * preserved, a custom field should be used for storage. It is also suggested
   * to group the locations that close to each other in the same job for better
   * search experience.
   *
   * Jobs with multiple addresses must have their addresses with the same
   * [LocationType][] to allow location filtering to work properly. (For
   * example, a Job with addresses "1600 Amphitheatre Parkway, Mountain View,
   * CA, USA" and "London, UK" may not have location filters applied correctly
   * at search time since the first is a [LocationType.STREET_ADDRESS][] and the
   * second is a [LocationType.LOCALITY][].) If a job needs to have multiple
   * addresses, it is suggested to split it into multiple jobs with same
   * LocationTypes.
   *
   * The maximum number of allowed characters is 500.
   * </pre>
   *
   * <code>repeated string addresses = 6;</code>
   *
   * @return A list containing the addresses.
   */
  java.util.List<java.lang.String> getAddressesList();
  /**
   *
   *
   * <pre>
   * Strongly recommended for the best service experience.
   *
   * Location(s) where the employer is looking to hire for this job posting.
   *
   * Specifying the full street address(es) of the hiring location enables
   * better API results, especially job searches by commute time.
   *
   * At most 50 locations are allowed for best search performance. If a job has
   * more locations, it is suggested to split it into multiple jobs with unique
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id]s (e.g. 'ReqA'
   * becomes 'ReqA-1', 'ReqA-2', and so on.) as multiple jobs with the same
   * [company][google.cloud.talent.v4.Job.company],
   * [language_code][google.cloud.talent.v4.Job.language_code] and
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id] are not
   * allowed. If the original
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id] must be
   * preserved, a custom field should be used for storage. It is also suggested
   * to group the locations that close to each other in the same job for better
   * search experience.
   *
   * Jobs with multiple addresses must have their addresses with the same
   * [LocationType][] to allow location filtering to work properly. (For
   * example, a Job with addresses "1600 Amphitheatre Parkway, Mountain View,
   * CA, USA" and "London, UK" may not have location filters applied correctly
   * at search time since the first is a [LocationType.STREET_ADDRESS][] and the
   * second is a [LocationType.LOCALITY][].) If a job needs to have multiple
   * addresses, it is suggested to split it into multiple jobs with same
   * LocationTypes.
   *
   * The maximum number of allowed characters is 500.
   * </pre>
   *
   * <code>repeated string addresses = 6;</code>
   *
   * @return The count of addresses.
   */
  int getAddressesCount();
  /**
   *
   *
   * <pre>
   * Strongly recommended for the best service experience.
   *
   * Location(s) where the employer is looking to hire for this job posting.
   *
   * Specifying the full street address(es) of the hiring location enables
   * better API results, especially job searches by commute time.
   *
   * At most 50 locations are allowed for best search performance. If a job has
   * more locations, it is suggested to split it into multiple jobs with unique
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id]s (e.g. 'ReqA'
   * becomes 'ReqA-1', 'ReqA-2', and so on.) as multiple jobs with the same
   * [company][google.cloud.talent.v4.Job.company],
   * [language_code][google.cloud.talent.v4.Job.language_code] and
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id] are not
   * allowed. If the original
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id] must be
   * preserved, a custom field should be used for storage. It is also suggested
   * to group the locations that close to each other in the same job for better
   * search experience.
   *
   * Jobs with multiple addresses must have their addresses with the same
   * [LocationType][] to allow location filtering to work properly. (For
   * example, a Job with addresses "1600 Amphitheatre Parkway, Mountain View,
   * CA, USA" and "London, UK" may not have location filters applied correctly
   * at search time since the first is a [LocationType.STREET_ADDRESS][] and the
   * second is a [LocationType.LOCALITY][].) If a job needs to have multiple
   * addresses, it is suggested to split it into multiple jobs with same
   * LocationTypes.
   *
   * The maximum number of allowed characters is 500.
   * </pre>
   *
   * <code>repeated string addresses = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The addresses at the given index.
   */
  java.lang.String getAddresses(int index);
  /**
   *
   *
   * <pre>
   * Strongly recommended for the best service experience.
   *
   * Location(s) where the employer is looking to hire for this job posting.
   *
   * Specifying the full street address(es) of the hiring location enables
   * better API results, especially job searches by commute time.
   *
   * At most 50 locations are allowed for best search performance. If a job has
   * more locations, it is suggested to split it into multiple jobs with unique
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id]s (e.g. 'ReqA'
   * becomes 'ReqA-1', 'ReqA-2', and so on.) as multiple jobs with the same
   * [company][google.cloud.talent.v4.Job.company],
   * [language_code][google.cloud.talent.v4.Job.language_code] and
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id] are not
   * allowed. If the original
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id] must be
   * preserved, a custom field should be used for storage. It is also suggested
   * to group the locations that close to each other in the same job for better
   * search experience.
   *
   * Jobs with multiple addresses must have their addresses with the same
   * [LocationType][] to allow location filtering to work properly. (For
   * example, a Job with addresses "1600 Amphitheatre Parkway, Mountain View,
   * CA, USA" and "London, UK" may not have location filters applied correctly
   * at search time since the first is a [LocationType.STREET_ADDRESS][] and the
   * second is a [LocationType.LOCALITY][].) If a job needs to have multiple
   * addresses, it is suggested to split it into multiple jobs with same
   * LocationTypes.
   *
   * The maximum number of allowed characters is 500.
   * </pre>
   *
   * <code>repeated string addresses = 6;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the addresses at the given index.
   */
  com.google.protobuf.ByteString getAddressesBytes(int index);

  /**
   *
   *
   * <pre>
   * Job application information.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.Job.ApplicationInfo application_info = 7;</code>
   *
   * @return Whether the applicationInfo field is set.
   */
  boolean hasApplicationInfo();
  /**
   *
   *
   * <pre>
   * Job application information.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.Job.ApplicationInfo application_info = 7;</code>
   *
   * @return The applicationInfo.
   */
  com.google.cloud.talent.v4.Job.ApplicationInfo getApplicationInfo();
  /**
   *
   *
   * <pre>
   * Job application information.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.Job.ApplicationInfo application_info = 7;</code>
   */
  com.google.cloud.talent.v4.Job.ApplicationInfoOrBuilder getApplicationInfoOrBuilder();

  /**
   *
   *
   * <pre>
   * The benefits included with the job.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
   *
   * @return A list containing the jobBenefits.
   */
  java.util.List<com.google.cloud.talent.v4.JobBenefit> getJobBenefitsList();
  /**
   *
   *
   * <pre>
   * The benefits included with the job.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
   *
   * @return The count of jobBenefits.
   */
  int getJobBenefitsCount();
  /**
   *
   *
   * <pre>
   * The benefits included with the job.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
   *
   * @param index The index of the element to return.
   * @return The jobBenefits at the given index.
   */
  com.google.cloud.talent.v4.JobBenefit getJobBenefits(int index);
  /**
   *
   *
   * <pre>
   * The benefits included with the job.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
   *
   * @return A list containing the enum numeric values on the wire for jobBenefits.
   */
  java.util.List<java.lang.Integer> getJobBenefitsValueList();
  /**
   *
   *
   * <pre>
   * The benefits included with the job.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.JobBenefit job_benefits = 8;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of jobBenefits at the given index.
   */
  int getJobBenefitsValue(int index);

  /**
   *
   *
   * <pre>
   * Job compensation information (a.k.a. "pay rate") i.e., the compensation
   * that will paid to the employee.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.CompensationInfo compensation_info = 9;</code>
   *
   * @return Whether the compensationInfo field is set.
   */
  boolean hasCompensationInfo();
  /**
   *
   *
   * <pre>
   * Job compensation information (a.k.a. "pay rate") i.e., the compensation
   * that will paid to the employee.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.CompensationInfo compensation_info = 9;</code>
   *
   * @return The compensationInfo.
   */
  com.google.cloud.talent.v4.CompensationInfo getCompensationInfo();
  /**
   *
   *
   * <pre>
   * Job compensation information (a.k.a. "pay rate") i.e., the compensation
   * that will paid to the employee.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.CompensationInfo compensation_info = 9;</code>
   */
  com.google.cloud.talent.v4.CompensationInfoOrBuilder getCompensationInfoOrBuilder();

  /**
   *
   *
   * <pre>
   * A map of fields to hold both filterable and non-filterable custom job
   * attributes that are not covered by the provided structured fields.
   *
   * The keys of the map are strings up to 64 bytes and must match the
   * pattern: `[a-zA-Z][a-zA-Z0-9_]*`. For example, key0LikeThis or
   * KEY_1_LIKE_THIS.
   *
   * At most 100 filterable and at most 100 unfilterable keys are supported.
   * For filterable `string_values`, across all keys at most 200 values are
   * allowed, with each string no more than 255 characters. For unfilterable
   * `string_values`, the maximum total size of `string_values` across all keys
   * is 50KB.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.talent.v4.CustomAttribute&gt; custom_attributes = 10;</code>
   */
  int getCustomAttributesCount();
  /**
   *
   *
   * <pre>
   * A map of fields to hold both filterable and non-filterable custom job
   * attributes that are not covered by the provided structured fields.
   *
   * The keys of the map are strings up to 64 bytes and must match the
   * pattern: `[a-zA-Z][a-zA-Z0-9_]*`. For example, key0LikeThis or
   * KEY_1_LIKE_THIS.
   *
   * At most 100 filterable and at most 100 unfilterable keys are supported.
   * For filterable `string_values`, across all keys at most 200 values are
   * allowed, with each string no more than 255 characters. For unfilterable
   * `string_values`, the maximum total size of `string_values` across all keys
   * is 50KB.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.talent.v4.CustomAttribute&gt; custom_attributes = 10;</code>
   */
  boolean containsCustomAttributes(java.lang.String key);
  /** Use {@link #getCustomAttributesMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, com.google.cloud.talent.v4.CustomAttribute> getCustomAttributes();
  /**
   *
   *
   * <pre>
   * A map of fields to hold both filterable and non-filterable custom job
   * attributes that are not covered by the provided structured fields.
   *
   * The keys of the map are strings up to 64 bytes and must match the
   * pattern: `[a-zA-Z][a-zA-Z0-9_]*`. For example, key0LikeThis or
   * KEY_1_LIKE_THIS.
   *
   * At most 100 filterable and at most 100 unfilterable keys are supported.
   * For filterable `string_values`, across all keys at most 200 values are
   * allowed, with each string no more than 255 characters. For unfilterable
   * `string_values`, the maximum total size of `string_values` across all keys
   * is 50KB.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.talent.v4.CustomAttribute&gt; custom_attributes = 10;</code>
   */
  java.util.Map<java.lang.String, com.google.cloud.talent.v4.CustomAttribute>
      getCustomAttributesMap();
  /**
   *
   *
   * <pre>
   * A map of fields to hold both filterable and non-filterable custom job
   * attributes that are not covered by the provided structured fields.
   *
   * The keys of the map are strings up to 64 bytes and must match the
   * pattern: `[a-zA-Z][a-zA-Z0-9_]*`. For example, key0LikeThis or
   * KEY_1_LIKE_THIS.
   *
   * At most 100 filterable and at most 100 unfilterable keys are supported.
   * For filterable `string_values`, across all keys at most 200 values are
   * allowed, with each string no more than 255 characters. For unfilterable
   * `string_values`, the maximum total size of `string_values` across all keys
   * is 50KB.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.talent.v4.CustomAttribute&gt; custom_attributes = 10;</code>
   */
  /* nullable */
  com.google.cloud.talent.v4.CustomAttribute getCustomAttributesOrDefault(
      java.lang.String key,
      /* nullable */
      com.google.cloud.talent.v4.CustomAttribute defaultValue);
  /**
   *
   *
   * <pre>
   * A map of fields to hold both filterable and non-filterable custom job
   * attributes that are not covered by the provided structured fields.
   *
   * The keys of the map are strings up to 64 bytes and must match the
   * pattern: `[a-zA-Z][a-zA-Z0-9_]*`. For example, key0LikeThis or
   * KEY_1_LIKE_THIS.
   *
   * At most 100 filterable and at most 100 unfilterable keys are supported.
   * For filterable `string_values`, across all keys at most 200 values are
   * allowed, with each string no more than 255 characters. For unfilterable
   * `string_values`, the maximum total size of `string_values` across all keys
   * is 50KB.
   * </pre>
   *
   * <code>map&lt;string, .google.cloud.talent.v4.CustomAttribute&gt; custom_attributes = 10;</code>
   */
  com.google.cloud.talent.v4.CustomAttribute getCustomAttributesOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * The desired education degrees for the job, such as Bachelors, Masters.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
   *
   * @return A list containing the degreeTypes.
   */
  java.util.List<com.google.cloud.talent.v4.DegreeType> getDegreeTypesList();
  /**
   *
   *
   * <pre>
   * The desired education degrees for the job, such as Bachelors, Masters.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
   *
   * @return The count of degreeTypes.
   */
  int getDegreeTypesCount();
  /**
   *
   *
   * <pre>
   * The desired education degrees for the job, such as Bachelors, Masters.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
   *
   * @param index The index of the element to return.
   * @return The degreeTypes at the given index.
   */
  com.google.cloud.talent.v4.DegreeType getDegreeTypes(int index);
  /**
   *
   *
   * <pre>
   * The desired education degrees for the job, such as Bachelors, Masters.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
   *
   * @return A list containing the enum numeric values on the wire for degreeTypes.
   */
  java.util.List<java.lang.Integer> getDegreeTypesValueList();
  /**
   *
   *
   * <pre>
   * The desired education degrees for the job, such as Bachelors, Masters.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.DegreeType degree_types = 11;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of degreeTypes at the given index.
   */
  int getDegreeTypesValue(int index);

  /**
   *
   *
   * <pre>
   * The department or functional area within the company with the open
   * position.
   *
   * The maximum number of allowed characters is 255.
   * </pre>
   *
   * <code>string department = 12;</code>
   *
   * @return The department.
   */
  java.lang.String getDepartment();
  /**
   *
   *
   * <pre>
   * The department or functional area within the company with the open
   * position.
   *
   * The maximum number of allowed characters is 255.
   * </pre>
   *
   * <code>string department = 12;</code>
   *
   * @return The bytes for department.
   */
  com.google.protobuf.ByteString getDepartmentBytes();

  /**
   *
   *
   * <pre>
   * The employment type(s) of a job, for example,
   * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
   * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
   *
   * @return A list containing the employmentTypes.
   */
  java.util.List<com.google.cloud.talent.v4.EmploymentType> getEmploymentTypesList();
  /**
   *
   *
   * <pre>
   * The employment type(s) of a job, for example,
   * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
   * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
   *
   * @return The count of employmentTypes.
   */
  int getEmploymentTypesCount();
  /**
   *
   *
   * <pre>
   * The employment type(s) of a job, for example,
   * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
   * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
   *
   * @param index The index of the element to return.
   * @return The employmentTypes at the given index.
   */
  com.google.cloud.talent.v4.EmploymentType getEmploymentTypes(int index);
  /**
   *
   *
   * <pre>
   * The employment type(s) of a job, for example,
   * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
   * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
   *
   * @return A list containing the enum numeric values on the wire for employmentTypes.
   */
  java.util.List<java.lang.Integer> getEmploymentTypesValueList();
  /**
   *
   *
   * <pre>
   * The employment type(s) of a job, for example,
   * [full time][google.cloud.talent.v4.EmploymentType.FULL_TIME] or
   * [part time][google.cloud.talent.v4.EmploymentType.PART_TIME].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 13;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of employmentTypes at the given index.
   */
  int getEmploymentTypesValue(int index);

  /**
   *
   *
   * <pre>
   * A description of bonus, commission, and other compensation
   * incentives associated with the job not including salary or pay.
   *
   * The maximum number of allowed characters is 10,000.
   * </pre>
   *
   * <code>string incentives = 14;</code>
   *
   * @return The incentives.
   */
  java.lang.String getIncentives();
  /**
   *
   *
   * <pre>
   * A description of bonus, commission, and other compensation
   * incentives associated with the job not including salary or pay.
   *
   * The maximum number of allowed characters is 10,000.
   * </pre>
   *
   * <code>string incentives = 14;</code>
   *
   * @return The bytes for incentives.
   */
  com.google.protobuf.ByteString getIncentivesBytes();

  /**
   *
   *
   * <pre>
   * The language of the posting. This field is distinct from
   * any requirements for fluency that are associated with the job.
   *
   * Language codes must be in BCP-47 format, such as "en-US" or "sr-Latn".
   * For more information, see
   * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47){:
   * class="external" target="_blank" }.
   *
   * If this field is unspecified and
   * [Job.description][google.cloud.talent.v4.Job.description] is present,
   * detected language code based on
   * [Job.description][google.cloud.talent.v4.Job.description] is assigned,
   * otherwise defaults to 'en_US'.
   * </pre>
   *
   * <code>string language_code = 15;</code>
   *
   * @return The languageCode.
   */
  java.lang.String getLanguageCode();
  /**
   *
   *
   * <pre>
   * The language of the posting. This field is distinct from
   * any requirements for fluency that are associated with the job.
   *
   * Language codes must be in BCP-47 format, such as "en-US" or "sr-Latn".
   * For more information, see
   * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47){:
   * class="external" target="_blank" }.
   *
   * If this field is unspecified and
   * [Job.description][google.cloud.talent.v4.Job.description] is present,
   * detected language code based on
   * [Job.description][google.cloud.talent.v4.Job.description] is assigned,
   * otherwise defaults to 'en_US'.
   * </pre>
   *
   * <code>string language_code = 15;</code>
   *
   * @return The bytes for languageCode.
   */
  com.google.protobuf.ByteString getLanguageCodeBytes();

  /**
   *
   *
   * <pre>
   * The experience level associated with the job, such as "Entry Level".
   * </pre>
   *
   * <code>.google.cloud.talent.v4.JobLevel job_level = 16;</code>
   *
   * @return The enum numeric value on the wire for jobLevel.
   */
  int getJobLevelValue();
  /**
   *
   *
   * <pre>
   * The experience level associated with the job, such as "Entry Level".
   * </pre>
   *
   * <code>.google.cloud.talent.v4.JobLevel job_level = 16;</code>
   *
   * @return The jobLevel.
   */
  com.google.cloud.talent.v4.JobLevel getJobLevel();

  /**
   *
   *
   * <pre>
   * A promotion value of the job, as determined by the client.
   * The value determines the sort order of the jobs returned when searching for
   * jobs using the featured jobs search call, with higher promotional values
   * being returned first and ties being resolved by relevance sort. Only the
   * jobs with a promotionValue &gt;0 are returned in a FEATURED_JOB_SEARCH.
   *
   * Default value is 0, and negative values are treated as 0.
   * </pre>
   *
   * <code>int32 promotion_value = 17;</code>
   *
   * @return The promotionValue.
   */
  int getPromotionValue();

  /**
   *
   *
   * <pre>
   * A description of the qualifications required to perform the
   * job. The use of this field is recommended
   * as an alternative to using the more general
   * [description][google.cloud.talent.v4.Job.description] field.
   *
   * This field accepts and sanitizes HTML input, and also accepts
   * bold, italic, ordered list, and unordered list markup tags.
   *
   * The maximum number of allowed characters is 10,000.
   * </pre>
   *
   * <code>string qualifications = 18;</code>
   *
   * @return The qualifications.
   */
  java.lang.String getQualifications();
  /**
   *
   *
   * <pre>
   * A description of the qualifications required to perform the
   * job. The use of this field is recommended
   * as an alternative to using the more general
   * [description][google.cloud.talent.v4.Job.description] field.
   *
   * This field accepts and sanitizes HTML input, and also accepts
   * bold, italic, ordered list, and unordered list markup tags.
   *
   * The maximum number of allowed characters is 10,000.
   * </pre>
   *
   * <code>string qualifications = 18;</code>
   *
   * @return The bytes for qualifications.
   */
  com.google.protobuf.ByteString getQualificationsBytes();

  /**
   *
   *
   * <pre>
   * A description of job responsibilities. The use of this field is
   * recommended as an alternative to using the more general
   * [description][google.cloud.talent.v4.Job.description] field.
   *
   * This field accepts and sanitizes HTML input, and also accepts
   * bold, italic, ordered list, and unordered list markup tags.
   *
   * The maximum number of allowed characters is 10,000.
   * </pre>
   *
   * <code>string responsibilities = 19;</code>
   *
   * @return The responsibilities.
   */
  java.lang.String getResponsibilities();
  /**
   *
   *
   * <pre>
   * A description of job responsibilities. The use of this field is
   * recommended as an alternative to using the more general
   * [description][google.cloud.talent.v4.Job.description] field.
   *
   * This field accepts and sanitizes HTML input, and also accepts
   * bold, italic, ordered list, and unordered list markup tags.
   *
   * The maximum number of allowed characters is 10,000.
   * </pre>
   *
   * <code>string responsibilities = 19;</code>
   *
   * @return The bytes for responsibilities.
   */
  com.google.protobuf.ByteString getResponsibilitiesBytes();

  /**
   *
   *
   * <pre>
   * The job [PostingRegion][google.cloud.talent.v4.PostingRegion] (for example,
   * state, country) throughout which the job is available. If this field is
   * set, a [LocationFilter][google.cloud.talent.v4.LocationFilter] in a search
   * query within the job region finds this job posting if an exact location
   * match isn't specified. If this field is set to
   * [PostingRegion.NATION][google.cloud.talent.v4.PostingRegion.NATION] or
   * [PostingRegion.ADMINISTRATIVE_AREA][google.cloud.talent.v4.PostingRegion.ADMINISTRATIVE_AREA],
   * setting job [Job.addresses][google.cloud.talent.v4.Job.addresses] to the
   * same location level as this field is strongly recommended.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.PostingRegion posting_region = 20;</code>
   *
   * @return The enum numeric value on the wire for postingRegion.
   */
  int getPostingRegionValue();
  /**
   *
   *
   * <pre>
   * The job [PostingRegion][google.cloud.talent.v4.PostingRegion] (for example,
   * state, country) throughout which the job is available. If this field is
   * set, a [LocationFilter][google.cloud.talent.v4.LocationFilter] in a search
   * query within the job region finds this job posting if an exact location
   * match isn't specified. If this field is set to
   * [PostingRegion.NATION][google.cloud.talent.v4.PostingRegion.NATION] or
   * [PostingRegion.ADMINISTRATIVE_AREA][google.cloud.talent.v4.PostingRegion.ADMINISTRATIVE_AREA],
   * setting job [Job.addresses][google.cloud.talent.v4.Job.addresses] to the
   * same location level as this field is strongly recommended.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.PostingRegion posting_region = 20;</code>
   *
   * @return The postingRegion.
   */
  com.google.cloud.talent.v4.PostingRegion getPostingRegion();

  /**
   *
   *
   * <pre>
   * Deprecated. The job is only visible to the owner.
   *
   * The visibility of the job.
   *
   * Defaults to
   * [Visibility.ACCOUNT_ONLY][google.cloud.talent.v4.Visibility.ACCOUNT_ONLY]
   * if not specified.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.Visibility visibility = 21 [deprecated = true];</code>
   *
   * @deprecated google.cloud.talent.v4.Job.visibility is deprecated. See
   *     google/cloud/talent/v4/job.proto;l=295
   * @return The enum numeric value on the wire for visibility.
   */
  @java.lang.Deprecated
  int getVisibilityValue();
  /**
   *
   *
   * <pre>
   * Deprecated. The job is only visible to the owner.
   *
   * The visibility of the job.
   *
   * Defaults to
   * [Visibility.ACCOUNT_ONLY][google.cloud.talent.v4.Visibility.ACCOUNT_ONLY]
   * if not specified.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.Visibility visibility = 21 [deprecated = true];</code>
   *
   * @deprecated google.cloud.talent.v4.Job.visibility is deprecated. See
   *     google/cloud/talent/v4/job.proto;l=295
   * @return The visibility.
   */
  @java.lang.Deprecated
  com.google.cloud.talent.v4.Visibility getVisibility();

  /**
   *
   *
   * <pre>
   * The start timestamp of the job in UTC time zone. Typically this field
   * is used for contracting engagements. Invalid timestamps are ignored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp job_start_time = 22;</code>
   *
   * @return Whether the jobStartTime field is set.
   */
  boolean hasJobStartTime();
  /**
   *
   *
   * <pre>
   * The start timestamp of the job in UTC time zone. Typically this field
   * is used for contracting engagements. Invalid timestamps are ignored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp job_start_time = 22;</code>
   *
   * @return The jobStartTime.
   */
  com.google.protobuf.Timestamp getJobStartTime();
  /**
   *
   *
   * <pre>
   * The start timestamp of the job in UTC time zone. Typically this field
   * is used for contracting engagements. Invalid timestamps are ignored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp job_start_time = 22;</code>
   */
  com.google.protobuf.TimestampOrBuilder getJobStartTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * The end timestamp of the job. Typically this field is used for contracting
   * engagements. Invalid timestamps are ignored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp job_end_time = 23;</code>
   *
   * @return Whether the jobEndTime field is set.
   */
  boolean hasJobEndTime();
  /**
   *
   *
   * <pre>
   * The end timestamp of the job. Typically this field is used for contracting
   * engagements. Invalid timestamps are ignored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp job_end_time = 23;</code>
   *
   * @return The jobEndTime.
   */
  com.google.protobuf.Timestamp getJobEndTime();
  /**
   *
   *
   * <pre>
   * The end timestamp of the job. Typically this field is used for contracting
   * engagements. Invalid timestamps are ignored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp job_end_time = 23;</code>
   */
  com.google.protobuf.TimestampOrBuilder getJobEndTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * The timestamp this job posting was most recently published. The default
   * value is the time the request arrives at the server. Invalid timestamps are
   * ignored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp posting_publish_time = 24;</code>
   *
   * @return Whether the postingPublishTime field is set.
   */
  boolean hasPostingPublishTime();
  /**
   *
   *
   * <pre>
   * The timestamp this job posting was most recently published. The default
   * value is the time the request arrives at the server. Invalid timestamps are
   * ignored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp posting_publish_time = 24;</code>
   *
   * @return The postingPublishTime.
   */
  com.google.protobuf.Timestamp getPostingPublishTime();
  /**
   *
   *
   * <pre>
   * The timestamp this job posting was most recently published. The default
   * value is the time the request arrives at the server. Invalid timestamps are
   * ignored.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp posting_publish_time = 24;</code>
   */
  com.google.protobuf.TimestampOrBuilder getPostingPublishTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Strongly recommended for the best service experience.
   *
   * The expiration timestamp of the job. After this timestamp, the
   * job is marked as expired, and it no longer appears in search results. The
   * expired job can't be listed by the
   * [ListJobs][google.cloud.talent.v4.JobService.ListJobs] API, but it can be
   * retrieved with the [GetJob][google.cloud.talent.v4.JobService.GetJob] API
   * or updated with the
   * [UpdateJob][google.cloud.talent.v4.JobService.UpdateJob] API or deleted
   * with the [DeleteJob][google.cloud.talent.v4.JobService.DeleteJob] API. An
   * expired job can be updated and opened again by using a future expiration
   * timestamp. Updating an expired job fails if there is another existing open
   * job with same [company][google.cloud.talent.v4.Job.company],
   * [language_code][google.cloud.talent.v4.Job.language_code] and
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
   *
   * The expired jobs are retained in our system for 90 days. However, the
   * overall expired job count cannot exceed 3 times the maximum number of
   * open jobs over previous 7 days. If this threshold is exceeded,
   * expired jobs are cleaned out in order of earliest expire time.
   * Expired jobs are no longer accessible after they are cleaned
   * out.
   *
   * Invalid timestamps are ignored, and treated as expire time not provided.
   *
   * If the timestamp is before the instant request is made, the job
   * is treated as expired immediately on creation. This kind of job can
   * not be updated. And when creating a job with past timestamp, the
   * [posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   * must be set before
   * [posting_expire_time][google.cloud.talent.v4.Job.posting_expire_time]. The
   * purpose of this feature is to allow other objects, such as [Application][],
   * to refer a job that didn't exist in the system prior to becoming expired.
   * If you want to modify a job that was expired on creation, delete it and
   * create a new one.
   *
   * If this value isn't provided at the time of job creation or is invalid,
   * the job posting expires after 30 days from the job's creation time. For
   * example, if the job was created on 2017/01/01 13:00AM UTC with an
   * unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC.
   *
   * If this value isn't provided on job update, it depends on the field masks
   * set by
   * [UpdateJobRequest.update_mask][google.cloud.talent.v4.UpdateJobRequest.update_mask].
   * If the field masks include
   * [job_end_time][google.cloud.talent.v4.Job.job_end_time], or the masks are
   * empty meaning that every field is updated, the job posting expires after 30
   * days from the job's last update time. Otherwise the expiration date isn't
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp posting_expire_time = 25;</code>
   *
   * @return Whether the postingExpireTime field is set.
   */
  boolean hasPostingExpireTime();
  /**
   *
   *
   * <pre>
   * Strongly recommended for the best service experience.
   *
   * The expiration timestamp of the job. After this timestamp, the
   * job is marked as expired, and it no longer appears in search results. The
   * expired job can't be listed by the
   * [ListJobs][google.cloud.talent.v4.JobService.ListJobs] API, but it can be
   * retrieved with the [GetJob][google.cloud.talent.v4.JobService.GetJob] API
   * or updated with the
   * [UpdateJob][google.cloud.talent.v4.JobService.UpdateJob] API or deleted
   * with the [DeleteJob][google.cloud.talent.v4.JobService.DeleteJob] API. An
   * expired job can be updated and opened again by using a future expiration
   * timestamp. Updating an expired job fails if there is another existing open
   * job with same [company][google.cloud.talent.v4.Job.company],
   * [language_code][google.cloud.talent.v4.Job.language_code] and
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
   *
   * The expired jobs are retained in our system for 90 days. However, the
   * overall expired job count cannot exceed 3 times the maximum number of
   * open jobs over previous 7 days. If this threshold is exceeded,
   * expired jobs are cleaned out in order of earliest expire time.
   * Expired jobs are no longer accessible after they are cleaned
   * out.
   *
   * Invalid timestamps are ignored, and treated as expire time not provided.
   *
   * If the timestamp is before the instant request is made, the job
   * is treated as expired immediately on creation. This kind of job can
   * not be updated. And when creating a job with past timestamp, the
   * [posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   * must be set before
   * [posting_expire_time][google.cloud.talent.v4.Job.posting_expire_time]. The
   * purpose of this feature is to allow other objects, such as [Application][],
   * to refer a job that didn't exist in the system prior to becoming expired.
   * If you want to modify a job that was expired on creation, delete it and
   * create a new one.
   *
   * If this value isn't provided at the time of job creation or is invalid,
   * the job posting expires after 30 days from the job's creation time. For
   * example, if the job was created on 2017/01/01 13:00AM UTC with an
   * unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC.
   *
   * If this value isn't provided on job update, it depends on the field masks
   * set by
   * [UpdateJobRequest.update_mask][google.cloud.talent.v4.UpdateJobRequest.update_mask].
   * If the field masks include
   * [job_end_time][google.cloud.talent.v4.Job.job_end_time], or the masks are
   * empty meaning that every field is updated, the job posting expires after 30
   * days from the job's last update time. Otherwise the expiration date isn't
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp posting_expire_time = 25;</code>
   *
   * @return The postingExpireTime.
   */
  com.google.protobuf.Timestamp getPostingExpireTime();
  /**
   *
   *
   * <pre>
   * Strongly recommended for the best service experience.
   *
   * The expiration timestamp of the job. After this timestamp, the
   * job is marked as expired, and it no longer appears in search results. The
   * expired job can't be listed by the
   * [ListJobs][google.cloud.talent.v4.JobService.ListJobs] API, but it can be
   * retrieved with the [GetJob][google.cloud.talent.v4.JobService.GetJob] API
   * or updated with the
   * [UpdateJob][google.cloud.talent.v4.JobService.UpdateJob] API or deleted
   * with the [DeleteJob][google.cloud.talent.v4.JobService.DeleteJob] API. An
   * expired job can be updated and opened again by using a future expiration
   * timestamp. Updating an expired job fails if there is another existing open
   * job with same [company][google.cloud.talent.v4.Job.company],
   * [language_code][google.cloud.talent.v4.Job.language_code] and
   * [requisition_id][google.cloud.talent.v4.Job.requisition_id].
   *
   * The expired jobs are retained in our system for 90 days. However, the
   * overall expired job count cannot exceed 3 times the maximum number of
   * open jobs over previous 7 days. If this threshold is exceeded,
   * expired jobs are cleaned out in order of earliest expire time.
   * Expired jobs are no longer accessible after they are cleaned
   * out.
   *
   * Invalid timestamps are ignored, and treated as expire time not provided.
   *
   * If the timestamp is before the instant request is made, the job
   * is treated as expired immediately on creation. This kind of job can
   * not be updated. And when creating a job with past timestamp, the
   * [posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   * must be set before
   * [posting_expire_time][google.cloud.talent.v4.Job.posting_expire_time]. The
   * purpose of this feature is to allow other objects, such as [Application][],
   * to refer a job that didn't exist in the system prior to becoming expired.
   * If you want to modify a job that was expired on creation, delete it and
   * create a new one.
   *
   * If this value isn't provided at the time of job creation or is invalid,
   * the job posting expires after 30 days from the job's creation time. For
   * example, if the job was created on 2017/01/01 13:00AM UTC with an
   * unspecified expiration date, the job expires after 2017/01/31 13:00AM UTC.
   *
   * If this value isn't provided on job update, it depends on the field masks
   * set by
   * [UpdateJobRequest.update_mask][google.cloud.talent.v4.UpdateJobRequest.update_mask].
   * If the field masks include
   * [job_end_time][google.cloud.talent.v4.Job.job_end_time], or the masks are
   * empty meaning that every field is updated, the job posting expires after 30
   * days from the job's last update time. Otherwise the expiration date isn't
   * updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp posting_expire_time = 25;</code>
   */
  com.google.protobuf.TimestampOrBuilder getPostingExpireTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this job posting was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp posting_create_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the postingCreateTime field is set.
   */
  boolean hasPostingCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this job posting was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp posting_create_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The postingCreateTime.
   */
  com.google.protobuf.Timestamp getPostingCreateTime();
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this job posting was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp posting_create_time = 26 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getPostingCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this job posting was last updated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp posting_update_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the postingUpdateTime field is set.
   */
  boolean hasPostingUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this job posting was last updated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp posting_update_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The postingUpdateTime.
   */
  com.google.protobuf.Timestamp getPostingUpdateTime();
  /**
   *
   *
   * <pre>
   * Output only. The timestamp when this job posting was last updated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp posting_update_time = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getPostingUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Display name of the company listing the job.
   * </pre>
   *
   * <code>string company_display_name = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The companyDisplayName.
   */
  java.lang.String getCompanyDisplayName();
  /**
   *
   *
   * <pre>
   * Output only. Display name of the company listing the job.
   * </pre>
   *
   * <code>string company_display_name = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for companyDisplayName.
   */
  com.google.protobuf.ByteString getCompanyDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. Derived details about the job posting.
   * </pre>
   *
   * <code>
   * .google.cloud.talent.v4.Job.DerivedInfo derived_info = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the derivedInfo field is set.
   */
  boolean hasDerivedInfo();
  /**
   *
   *
   * <pre>
   * Output only. Derived details about the job posting.
   * </pre>
   *
   * <code>
   * .google.cloud.talent.v4.Job.DerivedInfo derived_info = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The derivedInfo.
   */
  com.google.cloud.talent.v4.Job.DerivedInfo getDerivedInfo();
  /**
   *
   *
   * <pre>
   * Output only. Derived details about the job posting.
   * </pre>
   *
   * <code>
   * .google.cloud.talent.v4.Job.DerivedInfo derived_info = 29 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.talent.v4.Job.DerivedInfoOrBuilder getDerivedInfoOrBuilder();

  /**
   *
   *
   * <pre>
   * Options for job processing.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.Job.ProcessingOptions processing_options = 30;</code>
   *
   * @return Whether the processingOptions field is set.
   */
  boolean hasProcessingOptions();
  /**
   *
   *
   * <pre>
   * Options for job processing.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.Job.ProcessingOptions processing_options = 30;</code>
   *
   * @return The processingOptions.
   */
  com.google.cloud.talent.v4.Job.ProcessingOptions getProcessingOptions();
  /**
   *
   *
   * <pre>
   * Options for job processing.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.Job.ProcessingOptions processing_options = 30;</code>
   */
  com.google.cloud.talent.v4.Job.ProcessingOptionsOrBuilder getProcessingOptionsOrBuilder();
}
