/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/talent/v4/filters.proto

package com.google.cloud.talent.v4;

/**
 *
 *
 * <pre>
 * The query required to perform a search query.
 * </pre>
 *
 * Protobuf type {@code google.cloud.talent.v4.JobQuery}
 */
public final class JobQuery extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.talent.v4.JobQuery)
    JobQueryOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use JobQuery.newBuilder() to construct.
  private JobQuery(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private JobQuery() {
    query_ = "";
    queryLanguageCode_ = "";
    companies_ = com.google.protobuf.LazyStringArrayList.emptyList();
    locationFilters_ = java.util.Collections.emptyList();
    jobCategories_ = java.util.Collections.emptyList();
    companyDisplayNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
    customAttributeFilter_ = "";
    employmentTypes_ = java.util.Collections.emptyList();
    languageCodes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    excludedJobs_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new JobQuery();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.talent.v4.FiltersProto
        .internal_static_google_cloud_talent_v4_JobQuery_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.talent.v4.FiltersProto
        .internal_static_google_cloud_talent_v4_JobQuery_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.talent.v4.JobQuery.class,
            com.google.cloud.talent.v4.JobQuery.Builder.class);
  }

  public static final int QUERY_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object query_ = "";
  /**
   *
   *
   * <pre>
   * The query string that matches against the job title, description, and
   * location fields.
   *
   * The maximum number of allowed characters is 255.
   * </pre>
   *
   * <code>string query = 1;</code>
   *
   * @return The query.
   */
  @java.lang.Override
  public java.lang.String getQuery() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      query_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The query string that matches against the job title, description, and
   * location fields.
   *
   * The maximum number of allowed characters is 255.
   * </pre>
   *
   * <code>string query = 1;</code>
   *
   * @return The bytes for query.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQueryBytes() {
    java.lang.Object ref = query_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      query_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int QUERY_LANGUAGE_CODE_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private volatile java.lang.Object queryLanguageCode_ = "";
  /**
   *
   *
   * <pre>
   * The language code of [query][google.cloud.talent.v4.JobQuery.query]. For
   * example, "en-US". This field helps to better interpret the query.
   *
   * If a value isn't specified, the query language code is automatically
   * detected, which may not be accurate.
   *
   * Language code should be in BCP-47 format, such as "en-US" or "sr-Latn".
   * For more information, see
   * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
   * </pre>
   *
   * <code>string query_language_code = 14;</code>
   *
   * @return The queryLanguageCode.
   */
  @java.lang.Override
  public java.lang.String getQueryLanguageCode() {
    java.lang.Object ref = queryLanguageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      queryLanguageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The language code of [query][google.cloud.talent.v4.JobQuery.query]. For
   * example, "en-US". This field helps to better interpret the query.
   *
   * If a value isn't specified, the query language code is automatically
   * detected, which may not be accurate.
   *
   * Language code should be in BCP-47 format, such as "en-US" or "sr-Latn".
   * For more information, see
   * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
   * </pre>
   *
   * <code>string query_language_code = 14;</code>
   *
   * @return The bytes for queryLanguageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getQueryLanguageCodeBytes() {
    java.lang.Object ref = queryLanguageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      queryLanguageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COMPANIES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList companies_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * This filter specifies the company entities to search against.
   *
   * If a value isn't specified, jobs are searched for against all
   * companies.
   *
   * If multiple values are specified, jobs are searched against the
   * companies specified.
   *
   * The format is
   * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
   * example, "projects/foo/tenants/bar/companies/baz".
   *
   * At most 20 company filters are allowed.
   * </pre>
   *
   * <code>repeated string companies = 2;</code>
   *
   * @return A list containing the companies.
   */
  public com.google.protobuf.ProtocolStringList getCompaniesList() {
    return companies_;
  }
  /**
   *
   *
   * <pre>
   * This filter specifies the company entities to search against.
   *
   * If a value isn't specified, jobs are searched for against all
   * companies.
   *
   * If multiple values are specified, jobs are searched against the
   * companies specified.
   *
   * The format is
   * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
   * example, "projects/foo/tenants/bar/companies/baz".
   *
   * At most 20 company filters are allowed.
   * </pre>
   *
   * <code>repeated string companies = 2;</code>
   *
   * @return The count of companies.
   */
  public int getCompaniesCount() {
    return companies_.size();
  }
  /**
   *
   *
   * <pre>
   * This filter specifies the company entities to search against.
   *
   * If a value isn't specified, jobs are searched for against all
   * companies.
   *
   * If multiple values are specified, jobs are searched against the
   * companies specified.
   *
   * The format is
   * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
   * example, "projects/foo/tenants/bar/companies/baz".
   *
   * At most 20 company filters are allowed.
   * </pre>
   *
   * <code>repeated string companies = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The companies at the given index.
   */
  public java.lang.String getCompanies(int index) {
    return companies_.get(index);
  }
  /**
   *
   *
   * <pre>
   * This filter specifies the company entities to search against.
   *
   * If a value isn't specified, jobs are searched for against all
   * companies.
   *
   * If multiple values are specified, jobs are searched against the
   * companies specified.
   *
   * The format is
   * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
   * example, "projects/foo/tenants/bar/companies/baz".
   *
   * At most 20 company filters are allowed.
   * </pre>
   *
   * <code>repeated string companies = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the companies at the given index.
   */
  public com.google.protobuf.ByteString getCompaniesBytes(int index) {
    return companies_.getByteString(index);
  }

  public static final int LOCATION_FILTERS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.talent.v4.LocationFilter> locationFilters_;
  /**
   *
   *
   * <pre>
   * The location filter specifies geo-regions containing the jobs to
   * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
   * for more information.
   *
   * If a location value isn't specified, jobs fitting the other search
   * criteria are retrieved regardless of where they're located.
   *
   * If multiple values are specified, jobs are retrieved from any of the
   * specified locations. If different values are specified for the
   * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
   * parameter, the maximum provided distance is used for all locations.
   *
   * At most 5 location filters are allowed.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.talent.v4.LocationFilter> getLocationFiltersList() {
    return locationFilters_;
  }
  /**
   *
   *
   * <pre>
   * The location filter specifies geo-regions containing the jobs to
   * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
   * for more information.
   *
   * If a location value isn't specified, jobs fitting the other search
   * criteria are retrieved regardless of where they're located.
   *
   * If multiple values are specified, jobs are retrieved from any of the
   * specified locations. If different values are specified for the
   * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
   * parameter, the maximum provided distance is used for all locations.
   *
   * At most 5 location filters are allowed.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.talent.v4.LocationFilterOrBuilder>
      getLocationFiltersOrBuilderList() {
    return locationFilters_;
  }
  /**
   *
   *
   * <pre>
   * The location filter specifies geo-regions containing the jobs to
   * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
   * for more information.
   *
   * If a location value isn't specified, jobs fitting the other search
   * criteria are retrieved regardless of where they're located.
   *
   * If multiple values are specified, jobs are retrieved from any of the
   * specified locations. If different values are specified for the
   * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
   * parameter, the maximum provided distance is used for all locations.
   *
   * At most 5 location filters are allowed.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
   */
  @java.lang.Override
  public int getLocationFiltersCount() {
    return locationFilters_.size();
  }
  /**
   *
   *
   * <pre>
   * The location filter specifies geo-regions containing the jobs to
   * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
   * for more information.
   *
   * If a location value isn't specified, jobs fitting the other search
   * criteria are retrieved regardless of where they're located.
   *
   * If multiple values are specified, jobs are retrieved from any of the
   * specified locations. If different values are specified for the
   * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
   * parameter, the maximum provided distance is used for all locations.
   *
   * At most 5 location filters are allowed.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.LocationFilter getLocationFilters(int index) {
    return locationFilters_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The location filter specifies geo-regions containing the jobs to
   * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
   * for more information.
   *
   * If a location value isn't specified, jobs fitting the other search
   * criteria are retrieved regardless of where they're located.
   *
   * If multiple values are specified, jobs are retrieved from any of the
   * specified locations. If different values are specified for the
   * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
   * parameter, the maximum provided distance is used for all locations.
   *
   * At most 5 location filters are allowed.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.LocationFilterOrBuilder getLocationFiltersOrBuilder(int index) {
    return locationFilters_.get(index);
  }

  public static final int JOB_CATEGORIES_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> jobCategories_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.talent.v4.JobCategory>
      jobCategories_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.talent.v4.JobCategory>() {
            public com.google.cloud.talent.v4.JobCategory convert(java.lang.Integer from) {
              com.google.cloud.talent.v4.JobCategory result =
                  com.google.cloud.talent.v4.JobCategory.forNumber(from);
              return result == null ? com.google.cloud.talent.v4.JobCategory.UNRECOGNIZED : result;
            }
          };
  /**
   *
   *
   * <pre>
   * The category filter specifies the categories of jobs to search against.
   * See [JobCategory][google.cloud.talent.v4.JobCategory] for more information.
   *
   * If a value isn't specified, jobs from any category are searched against.
   *
   * If multiple values are specified, jobs from any of the specified
   * categories are searched against.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 4;</code>
   *
   * @return A list containing the jobCategories.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.talent.v4.JobCategory> getJobCategoriesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.talent.v4.JobCategory>(
        jobCategories_, jobCategories_converter_);
  }
  /**
   *
   *
   * <pre>
   * The category filter specifies the categories of jobs to search against.
   * See [JobCategory][google.cloud.talent.v4.JobCategory] for more information.
   *
   * If a value isn't specified, jobs from any category are searched against.
   *
   * If multiple values are specified, jobs from any of the specified
   * categories are searched against.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 4;</code>
   *
   * @return The count of jobCategories.
   */
  @java.lang.Override
  public int getJobCategoriesCount() {
    return jobCategories_.size();
  }
  /**
   *
   *
   * <pre>
   * The category filter specifies the categories of jobs to search against.
   * See [JobCategory][google.cloud.talent.v4.JobCategory] for more information.
   *
   * If a value isn't specified, jobs from any category are searched against.
   *
   * If multiple values are specified, jobs from any of the specified
   * categories are searched against.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 4;</code>
   *
   * @param index The index of the element to return.
   * @return The jobCategories at the given index.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.JobCategory getJobCategories(int index) {
    return jobCategories_converter_.convert(jobCategories_.get(index));
  }
  /**
   *
   *
   * <pre>
   * The category filter specifies the categories of jobs to search against.
   * See [JobCategory][google.cloud.talent.v4.JobCategory] for more information.
   *
   * If a value isn't specified, jobs from any category are searched against.
   *
   * If multiple values are specified, jobs from any of the specified
   * categories are searched against.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 4;</code>
   *
   * @return A list containing the enum numeric values on the wire for jobCategories.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getJobCategoriesValueList() {
    return jobCategories_;
  }
  /**
   *
   *
   * <pre>
   * The category filter specifies the categories of jobs to search against.
   * See [JobCategory][google.cloud.talent.v4.JobCategory] for more information.
   *
   * If a value isn't specified, jobs from any category are searched against.
   *
   * If multiple values are specified, jobs from any of the specified
   * categories are searched against.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 4;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of jobCategories at the given index.
   */
  @java.lang.Override
  public int getJobCategoriesValue(int index) {
    return jobCategories_.get(index);
  }

  private int jobCategoriesMemoizedSerializedSize;

  public static final int COMMUTE_FILTER_FIELD_NUMBER = 5;
  private com.google.cloud.talent.v4.CommuteFilter commuteFilter_;
  /**
   *
   *
   * <pre>
   * Allows filtering jobs by commute time with different travel methods (for
   *  example, driving or public transit).
   *
   * Note: This only works when you specify a
   * [CommuteMethod][google.cloud.talent.v4.CommuteMethod]. In this case,
   * [location_filters][google.cloud.talent.v4.JobQuery.location_filters] is
   * ignored.
   *
   *  Currently we don't support sorting by commute time.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.CommuteFilter commute_filter = 5;</code>
   *
   * @return Whether the commuteFilter field is set.
   */
  @java.lang.Override
  public boolean hasCommuteFilter() {
    return commuteFilter_ != null;
  }
  /**
   *
   *
   * <pre>
   * Allows filtering jobs by commute time with different travel methods (for
   *  example, driving or public transit).
   *
   * Note: This only works when you specify a
   * [CommuteMethod][google.cloud.talent.v4.CommuteMethod]. In this case,
   * [location_filters][google.cloud.talent.v4.JobQuery.location_filters] is
   * ignored.
   *
   *  Currently we don't support sorting by commute time.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.CommuteFilter commute_filter = 5;</code>
   *
   * @return The commuteFilter.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.CommuteFilter getCommuteFilter() {
    return commuteFilter_ == null
        ? com.google.cloud.talent.v4.CommuteFilter.getDefaultInstance()
        : commuteFilter_;
  }
  /**
   *
   *
   * <pre>
   * Allows filtering jobs by commute time with different travel methods (for
   *  example, driving or public transit).
   *
   * Note: This only works when you specify a
   * [CommuteMethod][google.cloud.talent.v4.CommuteMethod]. In this case,
   * [location_filters][google.cloud.talent.v4.JobQuery.location_filters] is
   * ignored.
   *
   *  Currently we don't support sorting by commute time.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.CommuteFilter commute_filter = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.CommuteFilterOrBuilder getCommuteFilterOrBuilder() {
    return commuteFilter_ == null
        ? com.google.cloud.talent.v4.CommuteFilter.getDefaultInstance()
        : commuteFilter_;
  }

  public static final int COMPANY_DISPLAY_NAMES_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList companyDisplayNames_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * This filter specifies the company
   * [Company.display_name][google.cloud.talent.v4.Company.display_name] of the
   * jobs to search against. The company name must match the value exactly.
   *
   * Alternatively, the value being searched for can be wrapped in different
   * match operators.
   * `SUBSTRING_MATCH([value])`
   * The company name must contain a case insensitive substring match of the
   * value. Using this function may increase latency.
   *
   * Sample Value: `SUBSTRING_MATCH(google)`
   *
   * `MULTI_WORD_TOKEN_MATCH([value])`
   * The value will be treated as a multi word token and the company name must
   * contain a case insensitive match of the value. Using this function may
   * increase latency.
   *
   * Sample Value: `MULTI_WORD_TOKEN_MATCH(google)`
   *
   * If a value isn't specified, jobs within the search results are
   * associated with any company.
   *
   * If multiple values are specified, jobs within the search results may be
   * associated with any of the specified companies.
   *
   * At most 20 company display name filters are allowed.
   * </pre>
   *
   * <code>repeated string company_display_names = 6;</code>
   *
   * @return A list containing the companyDisplayNames.
   */
  public com.google.protobuf.ProtocolStringList getCompanyDisplayNamesList() {
    return companyDisplayNames_;
  }
  /**
   *
   *
   * <pre>
   * This filter specifies the company
   * [Company.display_name][google.cloud.talent.v4.Company.display_name] of the
   * jobs to search against. The company name must match the value exactly.
   *
   * Alternatively, the value being searched for can be wrapped in different
   * match operators.
   * `SUBSTRING_MATCH([value])`
   * The company name must contain a case insensitive substring match of the
   * value. Using this function may increase latency.
   *
   * Sample Value: `SUBSTRING_MATCH(google)`
   *
   * `MULTI_WORD_TOKEN_MATCH([value])`
   * The value will be treated as a multi word token and the company name must
   * contain a case insensitive match of the value. Using this function may
   * increase latency.
   *
   * Sample Value: `MULTI_WORD_TOKEN_MATCH(google)`
   *
   * If a value isn't specified, jobs within the search results are
   * associated with any company.
   *
   * If multiple values are specified, jobs within the search results may be
   * associated with any of the specified companies.
   *
   * At most 20 company display name filters are allowed.
   * </pre>
   *
   * <code>repeated string company_display_names = 6;</code>
   *
   * @return The count of companyDisplayNames.
   */
  public int getCompanyDisplayNamesCount() {
    return companyDisplayNames_.size();
  }
  /**
   *
   *
   * <pre>
   * This filter specifies the company
   * [Company.display_name][google.cloud.talent.v4.Company.display_name] of the
   * jobs to search against. The company name must match the value exactly.
   *
   * Alternatively, the value being searched for can be wrapped in different
   * match operators.
   * `SUBSTRING_MATCH([value])`
   * The company name must contain a case insensitive substring match of the
   * value. Using this function may increase latency.
   *
   * Sample Value: `SUBSTRING_MATCH(google)`
   *
   * `MULTI_WORD_TOKEN_MATCH([value])`
   * The value will be treated as a multi word token and the company name must
   * contain a case insensitive match of the value. Using this function may
   * increase latency.
   *
   * Sample Value: `MULTI_WORD_TOKEN_MATCH(google)`
   *
   * If a value isn't specified, jobs within the search results are
   * associated with any company.
   *
   * If multiple values are specified, jobs within the search results may be
   * associated with any of the specified companies.
   *
   * At most 20 company display name filters are allowed.
   * </pre>
   *
   * <code>repeated string company_display_names = 6;</code>
   *
   * @param index The index of the element to return.
   * @return The companyDisplayNames at the given index.
   */
  public java.lang.String getCompanyDisplayNames(int index) {
    return companyDisplayNames_.get(index);
  }
  /**
   *
   *
   * <pre>
   * This filter specifies the company
   * [Company.display_name][google.cloud.talent.v4.Company.display_name] of the
   * jobs to search against. The company name must match the value exactly.
   *
   * Alternatively, the value being searched for can be wrapped in different
   * match operators.
   * `SUBSTRING_MATCH([value])`
   * The company name must contain a case insensitive substring match of the
   * value. Using this function may increase latency.
   *
   * Sample Value: `SUBSTRING_MATCH(google)`
   *
   * `MULTI_WORD_TOKEN_MATCH([value])`
   * The value will be treated as a multi word token and the company name must
   * contain a case insensitive match of the value. Using this function may
   * increase latency.
   *
   * Sample Value: `MULTI_WORD_TOKEN_MATCH(google)`
   *
   * If a value isn't specified, jobs within the search results are
   * associated with any company.
   *
   * If multiple values are specified, jobs within the search results may be
   * associated with any of the specified companies.
   *
   * At most 20 company display name filters are allowed.
   * </pre>
   *
   * <code>repeated string company_display_names = 6;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the companyDisplayNames at the given index.
   */
  public com.google.protobuf.ByteString getCompanyDisplayNamesBytes(int index) {
    return companyDisplayNames_.getByteString(index);
  }

  public static final int COMPENSATION_FILTER_FIELD_NUMBER = 7;
  private com.google.cloud.talent.v4.CompensationFilter compensationFilter_;
  /**
   *
   *
   * <pre>
   * This search filter is applied only to
   * [Job.compensation_info][google.cloud.talent.v4.Job.compensation_info]. For
   * example, if the filter is specified as "Hourly job with per-hour
   * compensation &gt; $15", only jobs meeting these criteria are searched. If a
   * filter isn't defined, all open jobs are searched.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.CompensationFilter compensation_filter = 7;</code>
   *
   * @return Whether the compensationFilter field is set.
   */
  @java.lang.Override
  public boolean hasCompensationFilter() {
    return compensationFilter_ != null;
  }
  /**
   *
   *
   * <pre>
   * This search filter is applied only to
   * [Job.compensation_info][google.cloud.talent.v4.Job.compensation_info]. For
   * example, if the filter is specified as "Hourly job with per-hour
   * compensation &gt; $15", only jobs meeting these criteria are searched. If a
   * filter isn't defined, all open jobs are searched.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.CompensationFilter compensation_filter = 7;</code>
   *
   * @return The compensationFilter.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.CompensationFilter getCompensationFilter() {
    return compensationFilter_ == null
        ? com.google.cloud.talent.v4.CompensationFilter.getDefaultInstance()
        : compensationFilter_;
  }
  /**
   *
   *
   * <pre>
   * This search filter is applied only to
   * [Job.compensation_info][google.cloud.talent.v4.Job.compensation_info]. For
   * example, if the filter is specified as "Hourly job with per-hour
   * compensation &gt; $15", only jobs meeting these criteria are searched. If a
   * filter isn't defined, all open jobs are searched.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.CompensationFilter compensation_filter = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.CompensationFilterOrBuilder getCompensationFilterOrBuilder() {
    return compensationFilter_ == null
        ? com.google.cloud.talent.v4.CompensationFilter.getDefaultInstance()
        : compensationFilter_;
  }

  public static final int CUSTOM_ATTRIBUTE_FILTER_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object customAttributeFilter_ = "";
  /**
   *
   *
   * <pre>
   * This filter specifies a structured syntax to match against the
   * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes]
   * marked as `filterable`.
   *
   * The syntax for this expression is a subset of SQL syntax.
   *
   * Supported operators are: `=`, `!=`, `&lt;`, `&lt;=`, `&gt;`, and `&gt;=` where the
   * left of the operator is a custom field key and the right of the operator
   * is a number or a quoted string. You must escape backslash (&#92;&#92;) and
   * quote (&#92;") characters.
   *
   * Supported functions are `LOWER([field_name])` to
   * perform a case insensitive match and `EMPTY([field_name])` to filter on the
   * existence of a key.
   *
   * Boolean expressions (AND/OR/NOT) are supported up to 3 levels of
   * nesting (for example, "((A AND B AND C) OR NOT D) AND E"), a maximum of 100
   * comparisons or functions are allowed in the expression. The expression
   * must be &lt; 10000 bytes in length.
   *
   * Sample Query:
   * `(LOWER(driving_license)="class &#92;"a&#92;"" OR EMPTY(driving_license)) AND
   * driving_years &gt; 10`
   * </pre>
   *
   * <code>string custom_attribute_filter = 8;</code>
   *
   * @return The customAttributeFilter.
   */
  @java.lang.Override
  public java.lang.String getCustomAttributeFilter() {
    java.lang.Object ref = customAttributeFilter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      customAttributeFilter_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * This filter specifies a structured syntax to match against the
   * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes]
   * marked as `filterable`.
   *
   * The syntax for this expression is a subset of SQL syntax.
   *
   * Supported operators are: `=`, `!=`, `&lt;`, `&lt;=`, `&gt;`, and `&gt;=` where the
   * left of the operator is a custom field key and the right of the operator
   * is a number or a quoted string. You must escape backslash (&#92;&#92;) and
   * quote (&#92;") characters.
   *
   * Supported functions are `LOWER([field_name])` to
   * perform a case insensitive match and `EMPTY([field_name])` to filter on the
   * existence of a key.
   *
   * Boolean expressions (AND/OR/NOT) are supported up to 3 levels of
   * nesting (for example, "((A AND B AND C) OR NOT D) AND E"), a maximum of 100
   * comparisons or functions are allowed in the expression. The expression
   * must be &lt; 10000 bytes in length.
   *
   * Sample Query:
   * `(LOWER(driving_license)="class &#92;"a&#92;"" OR EMPTY(driving_license)) AND
   * driving_years &gt; 10`
   * </pre>
   *
   * <code>string custom_attribute_filter = 8;</code>
   *
   * @return The bytes for customAttributeFilter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCustomAttributeFilterBytes() {
    java.lang.Object ref = customAttributeFilter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      customAttributeFilter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISABLE_SPELL_CHECK_FIELD_NUMBER = 9;
  private boolean disableSpellCheck_ = false;
  /**
   *
   *
   * <pre>
   * This flag controls the spell-check feature. If false, the
   * service attempts to correct a misspelled query,
   * for example, "enginee" is corrected to "engineer".
   *
   * Defaults to false: a spell check is performed.
   * </pre>
   *
   * <code>bool disable_spell_check = 9;</code>
   *
   * @return The disableSpellCheck.
   */
  @java.lang.Override
  public boolean getDisableSpellCheck() {
    return disableSpellCheck_;
  }

  public static final int EMPLOYMENT_TYPES_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> employmentTypes_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer, com.google.cloud.talent.v4.EmploymentType>
      employmentTypes_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer, com.google.cloud.talent.v4.EmploymentType>() {
            public com.google.cloud.talent.v4.EmploymentType convert(java.lang.Integer from) {
              com.google.cloud.talent.v4.EmploymentType result =
                  com.google.cloud.talent.v4.EmploymentType.forNumber(from);
              return result == null
                  ? com.google.cloud.talent.v4.EmploymentType.UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * The employment type filter specifies the employment type of jobs to
   * search against, such as
   * [EmploymentType.FULL_TIME][google.cloud.talent.v4.EmploymentType.FULL_TIME].
   *
   * If a value isn't specified, jobs in the search results includes any
   * employment type.
   *
   * If multiple values are specified, jobs in the search results include
   * any of the specified employment types.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 10;</code>
   *
   * @return A list containing the employmentTypes.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.talent.v4.EmploymentType> getEmploymentTypesList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer, com.google.cloud.talent.v4.EmploymentType>(
        employmentTypes_, employmentTypes_converter_);
  }
  /**
   *
   *
   * <pre>
   * The employment type filter specifies the employment type of jobs to
   * search against, such as
   * [EmploymentType.FULL_TIME][google.cloud.talent.v4.EmploymentType.FULL_TIME].
   *
   * If a value isn't specified, jobs in the search results includes any
   * employment type.
   *
   * If multiple values are specified, jobs in the search results include
   * any of the specified employment types.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 10;</code>
   *
   * @return The count of employmentTypes.
   */
  @java.lang.Override
  public int getEmploymentTypesCount() {
    return employmentTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * The employment type filter specifies the employment type of jobs to
   * search against, such as
   * [EmploymentType.FULL_TIME][google.cloud.talent.v4.EmploymentType.FULL_TIME].
   *
   * If a value isn't specified, jobs in the search results includes any
   * employment type.
   *
   * If multiple values are specified, jobs in the search results include
   * any of the specified employment types.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 10;</code>
   *
   * @param index The index of the element to return.
   * @return The employmentTypes at the given index.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.EmploymentType getEmploymentTypes(int index) {
    return employmentTypes_converter_.convert(employmentTypes_.get(index));
  }
  /**
   *
   *
   * <pre>
   * The employment type filter specifies the employment type of jobs to
   * search against, such as
   * [EmploymentType.FULL_TIME][google.cloud.talent.v4.EmploymentType.FULL_TIME].
   *
   * If a value isn't specified, jobs in the search results includes any
   * employment type.
   *
   * If multiple values are specified, jobs in the search results include
   * any of the specified employment types.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 10;</code>
   *
   * @return A list containing the enum numeric values on the wire for employmentTypes.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getEmploymentTypesValueList() {
    return employmentTypes_;
  }
  /**
   *
   *
   * <pre>
   * The employment type filter specifies the employment type of jobs to
   * search against, such as
   * [EmploymentType.FULL_TIME][google.cloud.talent.v4.EmploymentType.FULL_TIME].
   *
   * If a value isn't specified, jobs in the search results includes any
   * employment type.
   *
   * If multiple values are specified, jobs in the search results include
   * any of the specified employment types.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 10;</code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of employmentTypes at the given index.
   */
  @java.lang.Override
  public int getEmploymentTypesValue(int index) {
    return employmentTypes_.get(index);
  }

  private int employmentTypesMemoizedSerializedSize;

  public static final int LANGUAGE_CODES_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList languageCodes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * This filter specifies the locale of jobs to search against,
   * for example, "en-US".
   *
   * If a value isn't specified, the search results can contain jobs in any
   * locale.
   *
   *
   * Language codes should be in BCP-47 format, such as "en-US" or "sr-Latn".
   * For more information, see
   * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
   *
   * At most 10 language code filters are allowed.
   * </pre>
   *
   * <code>repeated string language_codes = 11;</code>
   *
   * @return A list containing the languageCodes.
   */
  public com.google.protobuf.ProtocolStringList getLanguageCodesList() {
    return languageCodes_;
  }
  /**
   *
   *
   * <pre>
   * This filter specifies the locale of jobs to search against,
   * for example, "en-US".
   *
   * If a value isn't specified, the search results can contain jobs in any
   * locale.
   *
   *
   * Language codes should be in BCP-47 format, such as "en-US" or "sr-Latn".
   * For more information, see
   * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
   *
   * At most 10 language code filters are allowed.
   * </pre>
   *
   * <code>repeated string language_codes = 11;</code>
   *
   * @return The count of languageCodes.
   */
  public int getLanguageCodesCount() {
    return languageCodes_.size();
  }
  /**
   *
   *
   * <pre>
   * This filter specifies the locale of jobs to search against,
   * for example, "en-US".
   *
   * If a value isn't specified, the search results can contain jobs in any
   * locale.
   *
   *
   * Language codes should be in BCP-47 format, such as "en-US" or "sr-Latn".
   * For more information, see
   * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
   *
   * At most 10 language code filters are allowed.
   * </pre>
   *
   * <code>repeated string language_codes = 11;</code>
   *
   * @param index The index of the element to return.
   * @return The languageCodes at the given index.
   */
  public java.lang.String getLanguageCodes(int index) {
    return languageCodes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * This filter specifies the locale of jobs to search against,
   * for example, "en-US".
   *
   * If a value isn't specified, the search results can contain jobs in any
   * locale.
   *
   *
   * Language codes should be in BCP-47 format, such as "en-US" or "sr-Latn".
   * For more information, see
   * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
   *
   * At most 10 language code filters are allowed.
   * </pre>
   *
   * <code>repeated string language_codes = 11;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the languageCodes at the given index.
   */
  public com.google.protobuf.ByteString getLanguageCodesBytes(int index) {
    return languageCodes_.getByteString(index);
  }

  public static final int PUBLISH_TIME_RANGE_FIELD_NUMBER = 12;
  private com.google.cloud.talent.v4.TimestampRange publishTimeRange_;
  /**
   *
   *
   * <pre>
   * Jobs published within a range specified by this filter are searched
   * against.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.TimestampRange publish_time_range = 12;</code>
   *
   * @return Whether the publishTimeRange field is set.
   */
  @java.lang.Override
  public boolean hasPublishTimeRange() {
    return publishTimeRange_ != null;
  }
  /**
   *
   *
   * <pre>
   * Jobs published within a range specified by this filter are searched
   * against.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.TimestampRange publish_time_range = 12;</code>
   *
   * @return The publishTimeRange.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.TimestampRange getPublishTimeRange() {
    return publishTimeRange_ == null
        ? com.google.cloud.talent.v4.TimestampRange.getDefaultInstance()
        : publishTimeRange_;
  }
  /**
   *
   *
   * <pre>
   * Jobs published within a range specified by this filter are searched
   * against.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.TimestampRange publish_time_range = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.TimestampRangeOrBuilder getPublishTimeRangeOrBuilder() {
    return publishTimeRange_ == null
        ? com.google.cloud.talent.v4.TimestampRange.getDefaultInstance()
        : publishTimeRange_;
  }

  public static final int EXCLUDED_JOBS_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList excludedJobs_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * This filter specifies a list of job names to be excluded during search.
   *
   * At most 400 excluded job names are allowed.
   * </pre>
   *
   * <code>repeated string excluded_jobs = 13;</code>
   *
   * @return A list containing the excludedJobs.
   */
  public com.google.protobuf.ProtocolStringList getExcludedJobsList() {
    return excludedJobs_;
  }
  /**
   *
   *
   * <pre>
   * This filter specifies a list of job names to be excluded during search.
   *
   * At most 400 excluded job names are allowed.
   * </pre>
   *
   * <code>repeated string excluded_jobs = 13;</code>
   *
   * @return The count of excludedJobs.
   */
  public int getExcludedJobsCount() {
    return excludedJobs_.size();
  }
  /**
   *
   *
   * <pre>
   * This filter specifies a list of job names to be excluded during search.
   *
   * At most 400 excluded job names are allowed.
   * </pre>
   *
   * <code>repeated string excluded_jobs = 13;</code>
   *
   * @param index The index of the element to return.
   * @return The excludedJobs at the given index.
   */
  public java.lang.String getExcludedJobs(int index) {
    return excludedJobs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * This filter specifies a list of job names to be excluded during search.
   *
   * At most 400 excluded job names are allowed.
   * </pre>
   *
   * <code>repeated string excluded_jobs = 13;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the excludedJobs at the given index.
   */
  public com.google.protobuf.ByteString getExcludedJobsBytes(int index) {
    return excludedJobs_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, query_);
    }
    for (int i = 0; i < companies_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, companies_.getRaw(i));
    }
    for (int i = 0; i < locationFilters_.size(); i++) {
      output.writeMessage(3, locationFilters_.get(i));
    }
    if (getJobCategoriesList().size() > 0) {
      output.writeUInt32NoTag(34);
      output.writeUInt32NoTag(jobCategoriesMemoizedSerializedSize);
    }
    for (int i = 0; i < jobCategories_.size(); i++) {
      output.writeEnumNoTag(jobCategories_.get(i));
    }
    if (commuteFilter_ != null) {
      output.writeMessage(5, getCommuteFilter());
    }
    for (int i = 0; i < companyDisplayNames_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, companyDisplayNames_.getRaw(i));
    }
    if (compensationFilter_ != null) {
      output.writeMessage(7, getCompensationFilter());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(customAttributeFilter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, customAttributeFilter_);
    }
    if (disableSpellCheck_ != false) {
      output.writeBool(9, disableSpellCheck_);
    }
    if (getEmploymentTypesList().size() > 0) {
      output.writeUInt32NoTag(82);
      output.writeUInt32NoTag(employmentTypesMemoizedSerializedSize);
    }
    for (int i = 0; i < employmentTypes_.size(); i++) {
      output.writeEnumNoTag(employmentTypes_.get(i));
    }
    for (int i = 0; i < languageCodes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, languageCodes_.getRaw(i));
    }
    if (publishTimeRange_ != null) {
      output.writeMessage(12, getPublishTimeRange());
    }
    for (int i = 0; i < excludedJobs_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, excludedJobs_.getRaw(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(queryLanguageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 14, queryLanguageCode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(query_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, query_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < companies_.size(); i++) {
        dataSize += computeStringSizeNoTag(companies_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getCompaniesList().size();
    }
    for (int i = 0; i < locationFilters_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, locationFilters_.get(i));
    }
    {
      int dataSize = 0;
      for (int i = 0; i < jobCategories_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(jobCategories_.get(i));
      }
      size += dataSize;
      if (!getJobCategoriesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      jobCategoriesMemoizedSerializedSize = dataSize;
    }
    if (commuteFilter_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCommuteFilter());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < companyDisplayNames_.size(); i++) {
        dataSize += computeStringSizeNoTag(companyDisplayNames_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getCompanyDisplayNamesList().size();
    }
    if (compensationFilter_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCompensationFilter());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(customAttributeFilter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, customAttributeFilter_);
    }
    if (disableSpellCheck_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(9, disableSpellCheck_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < employmentTypes_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(employmentTypes_.get(i));
      }
      size += dataSize;
      if (!getEmploymentTypesList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      employmentTypesMemoizedSerializedSize = dataSize;
    }
    {
      int dataSize = 0;
      for (int i = 0; i < languageCodes_.size(); i++) {
        dataSize += computeStringSizeNoTag(languageCodes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getLanguageCodesList().size();
    }
    if (publishTimeRange_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getPublishTimeRange());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < excludedJobs_.size(); i++) {
        dataSize += computeStringSizeNoTag(excludedJobs_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getExcludedJobsList().size();
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(queryLanguageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(14, queryLanguageCode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.talent.v4.JobQuery)) {
      return super.equals(obj);
    }
    com.google.cloud.talent.v4.JobQuery other = (com.google.cloud.talent.v4.JobQuery) obj;

    if (!getQuery().equals(other.getQuery())) return false;
    if (!getQueryLanguageCode().equals(other.getQueryLanguageCode())) return false;
    if (!getCompaniesList().equals(other.getCompaniesList())) return false;
    if (!getLocationFiltersList().equals(other.getLocationFiltersList())) return false;
    if (!jobCategories_.equals(other.jobCategories_)) return false;
    if (hasCommuteFilter() != other.hasCommuteFilter()) return false;
    if (hasCommuteFilter()) {
      if (!getCommuteFilter().equals(other.getCommuteFilter())) return false;
    }
    if (!getCompanyDisplayNamesList().equals(other.getCompanyDisplayNamesList())) return false;
    if (hasCompensationFilter() != other.hasCompensationFilter()) return false;
    if (hasCompensationFilter()) {
      if (!getCompensationFilter().equals(other.getCompensationFilter())) return false;
    }
    if (!getCustomAttributeFilter().equals(other.getCustomAttributeFilter())) return false;
    if (getDisableSpellCheck() != other.getDisableSpellCheck()) return false;
    if (!employmentTypes_.equals(other.employmentTypes_)) return false;
    if (!getLanguageCodesList().equals(other.getLanguageCodesList())) return false;
    if (hasPublishTimeRange() != other.hasPublishTimeRange()) return false;
    if (hasPublishTimeRange()) {
      if (!getPublishTimeRange().equals(other.getPublishTimeRange())) return false;
    }
    if (!getExcludedJobsList().equals(other.getExcludedJobsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + QUERY_FIELD_NUMBER;
    hash = (53 * hash) + getQuery().hashCode();
    hash = (37 * hash) + QUERY_LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getQueryLanguageCode().hashCode();
    if (getCompaniesCount() > 0) {
      hash = (37 * hash) + COMPANIES_FIELD_NUMBER;
      hash = (53 * hash) + getCompaniesList().hashCode();
    }
    if (getLocationFiltersCount() > 0) {
      hash = (37 * hash) + LOCATION_FILTERS_FIELD_NUMBER;
      hash = (53 * hash) + getLocationFiltersList().hashCode();
    }
    if (getJobCategoriesCount() > 0) {
      hash = (37 * hash) + JOB_CATEGORIES_FIELD_NUMBER;
      hash = (53 * hash) + jobCategories_.hashCode();
    }
    if (hasCommuteFilter()) {
      hash = (37 * hash) + COMMUTE_FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getCommuteFilter().hashCode();
    }
    if (getCompanyDisplayNamesCount() > 0) {
      hash = (37 * hash) + COMPANY_DISPLAY_NAMES_FIELD_NUMBER;
      hash = (53 * hash) + getCompanyDisplayNamesList().hashCode();
    }
    if (hasCompensationFilter()) {
      hash = (37 * hash) + COMPENSATION_FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getCompensationFilter().hashCode();
    }
    hash = (37 * hash) + CUSTOM_ATTRIBUTE_FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getCustomAttributeFilter().hashCode();
    hash = (37 * hash) + DISABLE_SPELL_CHECK_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableSpellCheck());
    if (getEmploymentTypesCount() > 0) {
      hash = (37 * hash) + EMPLOYMENT_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + employmentTypes_.hashCode();
    }
    if (getLanguageCodesCount() > 0) {
      hash = (37 * hash) + LANGUAGE_CODES_FIELD_NUMBER;
      hash = (53 * hash) + getLanguageCodesList().hashCode();
    }
    if (hasPublishTimeRange()) {
      hash = (37 * hash) + PUBLISH_TIME_RANGE_FIELD_NUMBER;
      hash = (53 * hash) + getPublishTimeRange().hashCode();
    }
    if (getExcludedJobsCount() > 0) {
      hash = (37 * hash) + EXCLUDED_JOBS_FIELD_NUMBER;
      hash = (53 * hash) + getExcludedJobsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.talent.v4.JobQuery parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.JobQuery parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.JobQuery parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.JobQuery parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.JobQuery parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.JobQuery parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.JobQuery parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.JobQuery parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.JobQuery parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.JobQuery parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.JobQuery parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.JobQuery parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.talent.v4.JobQuery prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The query required to perform a search query.
   * </pre>
   *
   * Protobuf type {@code google.cloud.talent.v4.JobQuery}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.talent.v4.JobQuery)
      com.google.cloud.talent.v4.JobQueryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.talent.v4.FiltersProto
          .internal_static_google_cloud_talent_v4_JobQuery_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.talent.v4.FiltersProto
          .internal_static_google_cloud_talent_v4_JobQuery_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.talent.v4.JobQuery.class,
              com.google.cloud.talent.v4.JobQuery.Builder.class);
    }

    // Construct using com.google.cloud.talent.v4.JobQuery.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      query_ = "";
      queryLanguageCode_ = "";
      companies_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (locationFiltersBuilder_ == null) {
        locationFilters_ = java.util.Collections.emptyList();
      } else {
        locationFilters_ = null;
        locationFiltersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      jobCategories_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      commuteFilter_ = null;
      if (commuteFilterBuilder_ != null) {
        commuteFilterBuilder_.dispose();
        commuteFilterBuilder_ = null;
      }
      companyDisplayNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
      compensationFilter_ = null;
      if (compensationFilterBuilder_ != null) {
        compensationFilterBuilder_.dispose();
        compensationFilterBuilder_ = null;
      }
      customAttributeFilter_ = "";
      disableSpellCheck_ = false;
      employmentTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);
      languageCodes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      publishTimeRange_ = null;
      if (publishTimeRangeBuilder_ != null) {
        publishTimeRangeBuilder_.dispose();
        publishTimeRangeBuilder_ = null;
      }
      excludedJobs_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.talent.v4.FiltersProto
          .internal_static_google_cloud_talent_v4_JobQuery_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.JobQuery getDefaultInstanceForType() {
      return com.google.cloud.talent.v4.JobQuery.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.JobQuery build() {
      com.google.cloud.talent.v4.JobQuery result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.JobQuery buildPartial() {
      com.google.cloud.talent.v4.JobQuery result = new com.google.cloud.talent.v4.JobQuery(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.talent.v4.JobQuery result) {
      if (locationFiltersBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          locationFilters_ = java.util.Collections.unmodifiableList(locationFilters_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.locationFilters_ = locationFilters_;
      } else {
        result.locationFilters_ = locationFiltersBuilder_.build();
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        jobCategories_ = java.util.Collections.unmodifiableList(jobCategories_);
        bitField0_ = (bitField0_ & ~0x00000010);
      }
      result.jobCategories_ = jobCategories_;
      if (((bitField0_ & 0x00000400) != 0)) {
        employmentTypes_ = java.util.Collections.unmodifiableList(employmentTypes_);
        bitField0_ = (bitField0_ & ~0x00000400);
      }
      result.employmentTypes_ = employmentTypes_;
    }

    private void buildPartial0(com.google.cloud.talent.v4.JobQuery result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.query_ = query_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.queryLanguageCode_ = queryLanguageCode_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        companies_.makeImmutable();
        result.companies_ = companies_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.commuteFilter_ =
            commuteFilterBuilder_ == null ? commuteFilter_ : commuteFilterBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        companyDisplayNames_.makeImmutable();
        result.companyDisplayNames_ = companyDisplayNames_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.compensationFilter_ =
            compensationFilterBuilder_ == null
                ? compensationFilter_
                : compensationFilterBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.customAttributeFilter_ = customAttributeFilter_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.disableSpellCheck_ = disableSpellCheck_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        languageCodes_.makeImmutable();
        result.languageCodes_ = languageCodes_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.publishTimeRange_ =
            publishTimeRangeBuilder_ == null ? publishTimeRange_ : publishTimeRangeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        excludedJobs_.makeImmutable();
        result.excludedJobs_ = excludedJobs_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.talent.v4.JobQuery) {
        return mergeFrom((com.google.cloud.talent.v4.JobQuery) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.talent.v4.JobQuery other) {
      if (other == com.google.cloud.talent.v4.JobQuery.getDefaultInstance()) return this;
      if (!other.getQuery().isEmpty()) {
        query_ = other.query_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getQueryLanguageCode().isEmpty()) {
        queryLanguageCode_ = other.queryLanguageCode_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.companies_.isEmpty()) {
        if (companies_.isEmpty()) {
          companies_ = other.companies_;
          bitField0_ |= 0x00000004;
        } else {
          ensureCompaniesIsMutable();
          companies_.addAll(other.companies_);
        }
        onChanged();
      }
      if (locationFiltersBuilder_ == null) {
        if (!other.locationFilters_.isEmpty()) {
          if (locationFilters_.isEmpty()) {
            locationFilters_ = other.locationFilters_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureLocationFiltersIsMutable();
            locationFilters_.addAll(other.locationFilters_);
          }
          onChanged();
        }
      } else {
        if (!other.locationFilters_.isEmpty()) {
          if (locationFiltersBuilder_.isEmpty()) {
            locationFiltersBuilder_.dispose();
            locationFiltersBuilder_ = null;
            locationFilters_ = other.locationFilters_;
            bitField0_ = (bitField0_ & ~0x00000008);
            locationFiltersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLocationFiltersFieldBuilder()
                    : null;
          } else {
            locationFiltersBuilder_.addAllMessages(other.locationFilters_);
          }
        }
      }
      if (!other.jobCategories_.isEmpty()) {
        if (jobCategories_.isEmpty()) {
          jobCategories_ = other.jobCategories_;
          bitField0_ = (bitField0_ & ~0x00000010);
        } else {
          ensureJobCategoriesIsMutable();
          jobCategories_.addAll(other.jobCategories_);
        }
        onChanged();
      }
      if (other.hasCommuteFilter()) {
        mergeCommuteFilter(other.getCommuteFilter());
      }
      if (!other.companyDisplayNames_.isEmpty()) {
        if (companyDisplayNames_.isEmpty()) {
          companyDisplayNames_ = other.companyDisplayNames_;
          bitField0_ |= 0x00000040;
        } else {
          ensureCompanyDisplayNamesIsMutable();
          companyDisplayNames_.addAll(other.companyDisplayNames_);
        }
        onChanged();
      }
      if (other.hasCompensationFilter()) {
        mergeCompensationFilter(other.getCompensationFilter());
      }
      if (!other.getCustomAttributeFilter().isEmpty()) {
        customAttributeFilter_ = other.customAttributeFilter_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.getDisableSpellCheck() != false) {
        setDisableSpellCheck(other.getDisableSpellCheck());
      }
      if (!other.employmentTypes_.isEmpty()) {
        if (employmentTypes_.isEmpty()) {
          employmentTypes_ = other.employmentTypes_;
          bitField0_ = (bitField0_ & ~0x00000400);
        } else {
          ensureEmploymentTypesIsMutable();
          employmentTypes_.addAll(other.employmentTypes_);
        }
        onChanged();
      }
      if (!other.languageCodes_.isEmpty()) {
        if (languageCodes_.isEmpty()) {
          languageCodes_ = other.languageCodes_;
          bitField0_ |= 0x00000800;
        } else {
          ensureLanguageCodesIsMutable();
          languageCodes_.addAll(other.languageCodes_);
        }
        onChanged();
      }
      if (other.hasPublishTimeRange()) {
        mergePublishTimeRange(other.getPublishTimeRange());
      }
      if (!other.excludedJobs_.isEmpty()) {
        if (excludedJobs_.isEmpty()) {
          excludedJobs_ = other.excludedJobs_;
          bitField0_ |= 0x00002000;
        } else {
          ensureExcludedJobsIsMutable();
          excludedJobs_.addAll(other.excludedJobs_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                query_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCompaniesIsMutable();
                companies_.add(s);
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.talent.v4.LocationFilter m =
                    input.readMessage(
                        com.google.cloud.talent.v4.LocationFilter.parser(), extensionRegistry);
                if (locationFiltersBuilder_ == null) {
                  ensureLocationFiltersIsMutable();
                  locationFilters_.add(m);
                } else {
                  locationFiltersBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 32:
              {
                int tmpRaw = input.readEnum();
                ensureJobCategoriesIsMutable();
                jobCategories_.add(tmpRaw);
                break;
              } // case 32
            case 34:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureJobCategoriesIsMutable();
                  jobCategories_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getCommuteFilterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCompanyDisplayNamesIsMutable();
                companyDisplayNames_.add(s);
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getCompensationFilterFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 58
            case 66:
              {
                customAttributeFilter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 66
            case 72:
              {
                disableSpellCheck_ = input.readBool();
                bitField0_ |= 0x00000200;
                break;
              } // case 72
            case 80:
              {
                int tmpRaw = input.readEnum();
                ensureEmploymentTypesIsMutable();
                employmentTypes_.add(tmpRaw);
                break;
              } // case 80
            case 82:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureEmploymentTypesIsMutable();
                  employmentTypes_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 82
            case 90:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureLanguageCodesIsMutable();
                languageCodes_.add(s);
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getPublishTimeRangeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 98
            case 106:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureExcludedJobsIsMutable();
                excludedJobs_.add(s);
                break;
              } // case 106
            case 114:
              {
                queryLanguageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 114
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object query_ = "";
    /**
     *
     *
     * <pre>
     * The query string that matches against the job title, description, and
     * location fields.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string query = 1;</code>
     *
     * @return The query.
     */
    public java.lang.String getQuery() {
      java.lang.Object ref = query_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        query_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The query string that matches against the job title, description, and
     * location fields.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string query = 1;</code>
     *
     * @return The bytes for query.
     */
    public com.google.protobuf.ByteString getQueryBytes() {
      java.lang.Object ref = query_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        query_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The query string that matches against the job title, description, and
     * location fields.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string query = 1;</code>
     *
     * @param value The query to set.
     * @return This builder for chaining.
     */
    public Builder setQuery(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      query_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The query string that matches against the job title, description, and
     * location fields.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string query = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQuery() {
      query_ = getDefaultInstance().getQuery();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The query string that matches against the job title, description, and
     * location fields.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string query = 1;</code>
     *
     * @param value The bytes for query to set.
     * @return This builder for chaining.
     */
    public Builder setQueryBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      query_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object queryLanguageCode_ = "";
    /**
     *
     *
     * <pre>
     * The language code of [query][google.cloud.talent.v4.JobQuery.query]. For
     * example, "en-US". This field helps to better interpret the query.
     *
     * If a value isn't specified, the query language code is automatically
     * detected, which may not be accurate.
     *
     * Language code should be in BCP-47 format, such as "en-US" or "sr-Latn".
     * For more information, see
     * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
     * </pre>
     *
     * <code>string query_language_code = 14;</code>
     *
     * @return The queryLanguageCode.
     */
    public java.lang.String getQueryLanguageCode() {
      java.lang.Object ref = queryLanguageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        queryLanguageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The language code of [query][google.cloud.talent.v4.JobQuery.query]. For
     * example, "en-US". This field helps to better interpret the query.
     *
     * If a value isn't specified, the query language code is automatically
     * detected, which may not be accurate.
     *
     * Language code should be in BCP-47 format, such as "en-US" or "sr-Latn".
     * For more information, see
     * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
     * </pre>
     *
     * <code>string query_language_code = 14;</code>
     *
     * @return The bytes for queryLanguageCode.
     */
    public com.google.protobuf.ByteString getQueryLanguageCodeBytes() {
      java.lang.Object ref = queryLanguageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        queryLanguageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The language code of [query][google.cloud.talent.v4.JobQuery.query]. For
     * example, "en-US". This field helps to better interpret the query.
     *
     * If a value isn't specified, the query language code is automatically
     * detected, which may not be accurate.
     *
     * Language code should be in BCP-47 format, such as "en-US" or "sr-Latn".
     * For more information, see
     * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
     * </pre>
     *
     * <code>string query_language_code = 14;</code>
     *
     * @param value The queryLanguageCode to set.
     * @return This builder for chaining.
     */
    public Builder setQueryLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      queryLanguageCode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The language code of [query][google.cloud.talent.v4.JobQuery.query]. For
     * example, "en-US". This field helps to better interpret the query.
     *
     * If a value isn't specified, the query language code is automatically
     * detected, which may not be accurate.
     *
     * Language code should be in BCP-47 format, such as "en-US" or "sr-Latn".
     * For more information, see
     * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
     * </pre>
     *
     * <code>string query_language_code = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearQueryLanguageCode() {
      queryLanguageCode_ = getDefaultInstance().getQueryLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The language code of [query][google.cloud.talent.v4.JobQuery.query]. For
     * example, "en-US". This field helps to better interpret the query.
     *
     * If a value isn't specified, the query language code is automatically
     * detected, which may not be accurate.
     *
     * Language code should be in BCP-47 format, such as "en-US" or "sr-Latn".
     * For more information, see
     * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
     * </pre>
     *
     * <code>string query_language_code = 14;</code>
     *
     * @param value The bytes for queryLanguageCode to set.
     * @return This builder for chaining.
     */
    public Builder setQueryLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      queryLanguageCode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList companies_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureCompaniesIsMutable() {
      if (!companies_.isModifiable()) {
        companies_ = new com.google.protobuf.LazyStringArrayList(companies_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the company entities to search against.
     *
     * If a value isn't specified, jobs are searched for against all
     * companies.
     *
     * If multiple values are specified, jobs are searched against the
     * companies specified.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
     * example, "projects/foo/tenants/bar/companies/baz".
     *
     * At most 20 company filters are allowed.
     * </pre>
     *
     * <code>repeated string companies = 2;</code>
     *
     * @return A list containing the companies.
     */
    public com.google.protobuf.ProtocolStringList getCompaniesList() {
      companies_.makeImmutable();
      return companies_;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the company entities to search against.
     *
     * If a value isn't specified, jobs are searched for against all
     * companies.
     *
     * If multiple values are specified, jobs are searched against the
     * companies specified.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
     * example, "projects/foo/tenants/bar/companies/baz".
     *
     * At most 20 company filters are allowed.
     * </pre>
     *
     * <code>repeated string companies = 2;</code>
     *
     * @return The count of companies.
     */
    public int getCompaniesCount() {
      return companies_.size();
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the company entities to search against.
     *
     * If a value isn't specified, jobs are searched for against all
     * companies.
     *
     * If multiple values are specified, jobs are searched against the
     * companies specified.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
     * example, "projects/foo/tenants/bar/companies/baz".
     *
     * At most 20 company filters are allowed.
     * </pre>
     *
     * <code>repeated string companies = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The companies at the given index.
     */
    public java.lang.String getCompanies(int index) {
      return companies_.get(index);
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the company entities to search against.
     *
     * If a value isn't specified, jobs are searched for against all
     * companies.
     *
     * If multiple values are specified, jobs are searched against the
     * companies specified.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
     * example, "projects/foo/tenants/bar/companies/baz".
     *
     * At most 20 company filters are allowed.
     * </pre>
     *
     * <code>repeated string companies = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the companies at the given index.
     */
    public com.google.protobuf.ByteString getCompaniesBytes(int index) {
      return companies_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the company entities to search against.
     *
     * If a value isn't specified, jobs are searched for against all
     * companies.
     *
     * If multiple values are specified, jobs are searched against the
     * companies specified.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
     * example, "projects/foo/tenants/bar/companies/baz".
     *
     * At most 20 company filters are allowed.
     * </pre>
     *
     * <code>repeated string companies = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The companies to set.
     * @return This builder for chaining.
     */
    public Builder setCompanies(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCompaniesIsMutable();
      companies_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the company entities to search against.
     *
     * If a value isn't specified, jobs are searched for against all
     * companies.
     *
     * If multiple values are specified, jobs are searched against the
     * companies specified.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
     * example, "projects/foo/tenants/bar/companies/baz".
     *
     * At most 20 company filters are allowed.
     * </pre>
     *
     * <code>repeated string companies = 2;</code>
     *
     * @param value The companies to add.
     * @return This builder for chaining.
     */
    public Builder addCompanies(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCompaniesIsMutable();
      companies_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the company entities to search against.
     *
     * If a value isn't specified, jobs are searched for against all
     * companies.
     *
     * If multiple values are specified, jobs are searched against the
     * companies specified.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
     * example, "projects/foo/tenants/bar/companies/baz".
     *
     * At most 20 company filters are allowed.
     * </pre>
     *
     * <code>repeated string companies = 2;</code>
     *
     * @param values The companies to add.
     * @return This builder for chaining.
     */
    public Builder addAllCompanies(java.lang.Iterable<java.lang.String> values) {
      ensureCompaniesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, companies_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the company entities to search against.
     *
     * If a value isn't specified, jobs are searched for against all
     * companies.
     *
     * If multiple values are specified, jobs are searched against the
     * companies specified.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
     * example, "projects/foo/tenants/bar/companies/baz".
     *
     * At most 20 company filters are allowed.
     * </pre>
     *
     * <code>repeated string companies = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCompanies() {
      companies_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the company entities to search against.
     *
     * If a value isn't specified, jobs are searched for against all
     * companies.
     *
     * If multiple values are specified, jobs are searched against the
     * companies specified.
     *
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/companies/{company_id}". For
     * example, "projects/foo/tenants/bar/companies/baz".
     *
     * At most 20 company filters are allowed.
     * </pre>
     *
     * <code>repeated string companies = 2;</code>
     *
     * @param value The bytes of the companies to add.
     * @return This builder for chaining.
     */
    public Builder addCompaniesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCompaniesIsMutable();
      companies_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.talent.v4.LocationFilter> locationFilters_ =
        java.util.Collections.emptyList();

    private void ensureLocationFiltersIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        locationFilters_ =
            new java.util.ArrayList<com.google.cloud.talent.v4.LocationFilter>(locationFilters_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.talent.v4.LocationFilter,
            com.google.cloud.talent.v4.LocationFilter.Builder,
            com.google.cloud.talent.v4.LocationFilterOrBuilder>
        locationFiltersBuilder_;

    /**
     *
     *
     * <pre>
     * The location filter specifies geo-regions containing the jobs to
     * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
     * for more information.
     *
     * If a location value isn't specified, jobs fitting the other search
     * criteria are retrieved regardless of where they're located.
     *
     * If multiple values are specified, jobs are retrieved from any of the
     * specified locations. If different values are specified for the
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
     * parameter, the maximum provided distance is used for all locations.
     *
     * At most 5 location filters are allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
     */
    public java.util.List<com.google.cloud.talent.v4.LocationFilter> getLocationFiltersList() {
      if (locationFiltersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(locationFilters_);
      } else {
        return locationFiltersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The location filter specifies geo-regions containing the jobs to
     * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
     * for more information.
     *
     * If a location value isn't specified, jobs fitting the other search
     * criteria are retrieved regardless of where they're located.
     *
     * If multiple values are specified, jobs are retrieved from any of the
     * specified locations. If different values are specified for the
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
     * parameter, the maximum provided distance is used for all locations.
     *
     * At most 5 location filters are allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
     */
    public int getLocationFiltersCount() {
      if (locationFiltersBuilder_ == null) {
        return locationFilters_.size();
      } else {
        return locationFiltersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The location filter specifies geo-regions containing the jobs to
     * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
     * for more information.
     *
     * If a location value isn't specified, jobs fitting the other search
     * criteria are retrieved regardless of where they're located.
     *
     * If multiple values are specified, jobs are retrieved from any of the
     * specified locations. If different values are specified for the
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
     * parameter, the maximum provided distance is used for all locations.
     *
     * At most 5 location filters are allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
     */
    public com.google.cloud.talent.v4.LocationFilter getLocationFilters(int index) {
      if (locationFiltersBuilder_ == null) {
        return locationFilters_.get(index);
      } else {
        return locationFiltersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The location filter specifies geo-regions containing the jobs to
     * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
     * for more information.
     *
     * If a location value isn't specified, jobs fitting the other search
     * criteria are retrieved regardless of where they're located.
     *
     * If multiple values are specified, jobs are retrieved from any of the
     * specified locations. If different values are specified for the
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
     * parameter, the maximum provided distance is used for all locations.
     *
     * At most 5 location filters are allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
     */
    public Builder setLocationFilters(int index, com.google.cloud.talent.v4.LocationFilter value) {
      if (locationFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocationFiltersIsMutable();
        locationFilters_.set(index, value);
        onChanged();
      } else {
        locationFiltersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location filter specifies geo-regions containing the jobs to
     * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
     * for more information.
     *
     * If a location value isn't specified, jobs fitting the other search
     * criteria are retrieved regardless of where they're located.
     *
     * If multiple values are specified, jobs are retrieved from any of the
     * specified locations. If different values are specified for the
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
     * parameter, the maximum provided distance is used for all locations.
     *
     * At most 5 location filters are allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
     */
    public Builder setLocationFilters(
        int index, com.google.cloud.talent.v4.LocationFilter.Builder builderForValue) {
      if (locationFiltersBuilder_ == null) {
        ensureLocationFiltersIsMutable();
        locationFilters_.set(index, builderForValue.build());
        onChanged();
      } else {
        locationFiltersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location filter specifies geo-regions containing the jobs to
     * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
     * for more information.
     *
     * If a location value isn't specified, jobs fitting the other search
     * criteria are retrieved regardless of where they're located.
     *
     * If multiple values are specified, jobs are retrieved from any of the
     * specified locations. If different values are specified for the
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
     * parameter, the maximum provided distance is used for all locations.
     *
     * At most 5 location filters are allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
     */
    public Builder addLocationFilters(com.google.cloud.talent.v4.LocationFilter value) {
      if (locationFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocationFiltersIsMutable();
        locationFilters_.add(value);
        onChanged();
      } else {
        locationFiltersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location filter specifies geo-regions containing the jobs to
     * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
     * for more information.
     *
     * If a location value isn't specified, jobs fitting the other search
     * criteria are retrieved regardless of where they're located.
     *
     * If multiple values are specified, jobs are retrieved from any of the
     * specified locations. If different values are specified for the
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
     * parameter, the maximum provided distance is used for all locations.
     *
     * At most 5 location filters are allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
     */
    public Builder addLocationFilters(int index, com.google.cloud.talent.v4.LocationFilter value) {
      if (locationFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocationFiltersIsMutable();
        locationFilters_.add(index, value);
        onChanged();
      } else {
        locationFiltersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location filter specifies geo-regions containing the jobs to
     * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
     * for more information.
     *
     * If a location value isn't specified, jobs fitting the other search
     * criteria are retrieved regardless of where they're located.
     *
     * If multiple values are specified, jobs are retrieved from any of the
     * specified locations. If different values are specified for the
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
     * parameter, the maximum provided distance is used for all locations.
     *
     * At most 5 location filters are allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
     */
    public Builder addLocationFilters(
        com.google.cloud.talent.v4.LocationFilter.Builder builderForValue) {
      if (locationFiltersBuilder_ == null) {
        ensureLocationFiltersIsMutable();
        locationFilters_.add(builderForValue.build());
        onChanged();
      } else {
        locationFiltersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location filter specifies geo-regions containing the jobs to
     * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
     * for more information.
     *
     * If a location value isn't specified, jobs fitting the other search
     * criteria are retrieved regardless of where they're located.
     *
     * If multiple values are specified, jobs are retrieved from any of the
     * specified locations. If different values are specified for the
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
     * parameter, the maximum provided distance is used for all locations.
     *
     * At most 5 location filters are allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
     */
    public Builder addLocationFilters(
        int index, com.google.cloud.talent.v4.LocationFilter.Builder builderForValue) {
      if (locationFiltersBuilder_ == null) {
        ensureLocationFiltersIsMutable();
        locationFilters_.add(index, builderForValue.build());
        onChanged();
      } else {
        locationFiltersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location filter specifies geo-regions containing the jobs to
     * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
     * for more information.
     *
     * If a location value isn't specified, jobs fitting the other search
     * criteria are retrieved regardless of where they're located.
     *
     * If multiple values are specified, jobs are retrieved from any of the
     * specified locations. If different values are specified for the
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
     * parameter, the maximum provided distance is used for all locations.
     *
     * At most 5 location filters are allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
     */
    public Builder addAllLocationFilters(
        java.lang.Iterable<? extends com.google.cloud.talent.v4.LocationFilter> values) {
      if (locationFiltersBuilder_ == null) {
        ensureLocationFiltersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, locationFilters_);
        onChanged();
      } else {
        locationFiltersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location filter specifies geo-regions containing the jobs to
     * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
     * for more information.
     *
     * If a location value isn't specified, jobs fitting the other search
     * criteria are retrieved regardless of where they're located.
     *
     * If multiple values are specified, jobs are retrieved from any of the
     * specified locations. If different values are specified for the
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
     * parameter, the maximum provided distance is used for all locations.
     *
     * At most 5 location filters are allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
     */
    public Builder clearLocationFilters() {
      if (locationFiltersBuilder_ == null) {
        locationFilters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        locationFiltersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location filter specifies geo-regions containing the jobs to
     * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
     * for more information.
     *
     * If a location value isn't specified, jobs fitting the other search
     * criteria are retrieved regardless of where they're located.
     *
     * If multiple values are specified, jobs are retrieved from any of the
     * specified locations. If different values are specified for the
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
     * parameter, the maximum provided distance is used for all locations.
     *
     * At most 5 location filters are allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
     */
    public Builder removeLocationFilters(int index) {
      if (locationFiltersBuilder_ == null) {
        ensureLocationFiltersIsMutable();
        locationFilters_.remove(index);
        onChanged();
      } else {
        locationFiltersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location filter specifies geo-regions containing the jobs to
     * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
     * for more information.
     *
     * If a location value isn't specified, jobs fitting the other search
     * criteria are retrieved regardless of where they're located.
     *
     * If multiple values are specified, jobs are retrieved from any of the
     * specified locations. If different values are specified for the
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
     * parameter, the maximum provided distance is used for all locations.
     *
     * At most 5 location filters are allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
     */
    public com.google.cloud.talent.v4.LocationFilter.Builder getLocationFiltersBuilder(int index) {
      return getLocationFiltersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The location filter specifies geo-regions containing the jobs to
     * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
     * for more information.
     *
     * If a location value isn't specified, jobs fitting the other search
     * criteria are retrieved regardless of where they're located.
     *
     * If multiple values are specified, jobs are retrieved from any of the
     * specified locations. If different values are specified for the
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
     * parameter, the maximum provided distance is used for all locations.
     *
     * At most 5 location filters are allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
     */
    public com.google.cloud.talent.v4.LocationFilterOrBuilder getLocationFiltersOrBuilder(
        int index) {
      if (locationFiltersBuilder_ == null) {
        return locationFilters_.get(index);
      } else {
        return locationFiltersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The location filter specifies geo-regions containing the jobs to
     * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
     * for more information.
     *
     * If a location value isn't specified, jobs fitting the other search
     * criteria are retrieved regardless of where they're located.
     *
     * If multiple values are specified, jobs are retrieved from any of the
     * specified locations. If different values are specified for the
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
     * parameter, the maximum provided distance is used for all locations.
     *
     * At most 5 location filters are allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.talent.v4.LocationFilterOrBuilder>
        getLocationFiltersOrBuilderList() {
      if (locationFiltersBuilder_ != null) {
        return locationFiltersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(locationFilters_);
      }
    }
    /**
     *
     *
     * <pre>
     * The location filter specifies geo-regions containing the jobs to
     * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
     * for more information.
     *
     * If a location value isn't specified, jobs fitting the other search
     * criteria are retrieved regardless of where they're located.
     *
     * If multiple values are specified, jobs are retrieved from any of the
     * specified locations. If different values are specified for the
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
     * parameter, the maximum provided distance is used for all locations.
     *
     * At most 5 location filters are allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
     */
    public com.google.cloud.talent.v4.LocationFilter.Builder addLocationFiltersBuilder() {
      return getLocationFiltersFieldBuilder()
          .addBuilder(com.google.cloud.talent.v4.LocationFilter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The location filter specifies geo-regions containing the jobs to
     * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
     * for more information.
     *
     * If a location value isn't specified, jobs fitting the other search
     * criteria are retrieved regardless of where they're located.
     *
     * If multiple values are specified, jobs are retrieved from any of the
     * specified locations. If different values are specified for the
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
     * parameter, the maximum provided distance is used for all locations.
     *
     * At most 5 location filters are allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
     */
    public com.google.cloud.talent.v4.LocationFilter.Builder addLocationFiltersBuilder(int index) {
      return getLocationFiltersFieldBuilder()
          .addBuilder(index, com.google.cloud.talent.v4.LocationFilter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The location filter specifies geo-regions containing the jobs to
     * search against. See [LocationFilter][google.cloud.talent.v4.LocationFilter]
     * for more information.
     *
     * If a location value isn't specified, jobs fitting the other search
     * criteria are retrieved regardless of where they're located.
     *
     * If multiple values are specified, jobs are retrieved from any of the
     * specified locations. If different values are specified for the
     * [LocationFilter.distance_in_miles][google.cloud.talent.v4.LocationFilter.distance_in_miles]
     * parameter, the maximum provided distance is used for all locations.
     *
     * At most 5 location filters are allowed.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.LocationFilter location_filters = 3;</code>
     */
    public java.util.List<com.google.cloud.talent.v4.LocationFilter.Builder>
        getLocationFiltersBuilderList() {
      return getLocationFiltersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.talent.v4.LocationFilter,
            com.google.cloud.talent.v4.LocationFilter.Builder,
            com.google.cloud.talent.v4.LocationFilterOrBuilder>
        getLocationFiltersFieldBuilder() {
      if (locationFiltersBuilder_ == null) {
        locationFiltersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.talent.v4.LocationFilter,
                com.google.cloud.talent.v4.LocationFilter.Builder,
                com.google.cloud.talent.v4.LocationFilterOrBuilder>(
                locationFilters_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        locationFilters_ = null;
      }
      return locationFiltersBuilder_;
    }

    private java.util.List<java.lang.Integer> jobCategories_ = java.util.Collections.emptyList();

    private void ensureJobCategoriesIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        jobCategories_ = new java.util.ArrayList<java.lang.Integer>(jobCategories_);
        bitField0_ |= 0x00000010;
      }
    }
    /**
     *
     *
     * <pre>
     * The category filter specifies the categories of jobs to search against.
     * See [JobCategory][google.cloud.talent.v4.JobCategory] for more information.
     *
     * If a value isn't specified, jobs from any category are searched against.
     *
     * If multiple values are specified, jobs from any of the specified
     * categories are searched against.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 4;</code>
     *
     * @return A list containing the jobCategories.
     */
    public java.util.List<com.google.cloud.talent.v4.JobCategory> getJobCategoriesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.talent.v4.JobCategory>(
          jobCategories_, jobCategories_converter_);
    }
    /**
     *
     *
     * <pre>
     * The category filter specifies the categories of jobs to search against.
     * See [JobCategory][google.cloud.talent.v4.JobCategory] for more information.
     *
     * If a value isn't specified, jobs from any category are searched against.
     *
     * If multiple values are specified, jobs from any of the specified
     * categories are searched against.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 4;</code>
     *
     * @return The count of jobCategories.
     */
    public int getJobCategoriesCount() {
      return jobCategories_.size();
    }
    /**
     *
     *
     * <pre>
     * The category filter specifies the categories of jobs to search against.
     * See [JobCategory][google.cloud.talent.v4.JobCategory] for more information.
     *
     * If a value isn't specified, jobs from any category are searched against.
     *
     * If multiple values are specified, jobs from any of the specified
     * categories are searched against.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 4;</code>
     *
     * @param index The index of the element to return.
     * @return The jobCategories at the given index.
     */
    public com.google.cloud.talent.v4.JobCategory getJobCategories(int index) {
      return jobCategories_converter_.convert(jobCategories_.get(index));
    }
    /**
     *
     *
     * <pre>
     * The category filter specifies the categories of jobs to search against.
     * See [JobCategory][google.cloud.talent.v4.JobCategory] for more information.
     *
     * If a value isn't specified, jobs from any category are searched against.
     *
     * If multiple values are specified, jobs from any of the specified
     * categories are searched against.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The jobCategories to set.
     * @return This builder for chaining.
     */
    public Builder setJobCategories(int index, com.google.cloud.talent.v4.JobCategory value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureJobCategoriesIsMutable();
      jobCategories_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category filter specifies the categories of jobs to search against.
     * See [JobCategory][google.cloud.talent.v4.JobCategory] for more information.
     *
     * If a value isn't specified, jobs from any category are searched against.
     *
     * If multiple values are specified, jobs from any of the specified
     * categories are searched against.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 4;</code>
     *
     * @param value The jobCategories to add.
     * @return This builder for chaining.
     */
    public Builder addJobCategories(com.google.cloud.talent.v4.JobCategory value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureJobCategoriesIsMutable();
      jobCategories_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category filter specifies the categories of jobs to search against.
     * See [JobCategory][google.cloud.talent.v4.JobCategory] for more information.
     *
     * If a value isn't specified, jobs from any category are searched against.
     *
     * If multiple values are specified, jobs from any of the specified
     * categories are searched against.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 4;</code>
     *
     * @param values The jobCategories to add.
     * @return This builder for chaining.
     */
    public Builder addAllJobCategories(
        java.lang.Iterable<? extends com.google.cloud.talent.v4.JobCategory> values) {
      ensureJobCategoriesIsMutable();
      for (com.google.cloud.talent.v4.JobCategory value : values) {
        jobCategories_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category filter specifies the categories of jobs to search against.
     * See [JobCategory][google.cloud.talent.v4.JobCategory] for more information.
     *
     * If a value isn't specified, jobs from any category are searched against.
     *
     * If multiple values are specified, jobs from any of the specified
     * categories are searched against.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJobCategories() {
      jobCategories_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category filter specifies the categories of jobs to search against.
     * See [JobCategory][google.cloud.talent.v4.JobCategory] for more information.
     *
     * If a value isn't specified, jobs from any category are searched against.
     *
     * If multiple values are specified, jobs from any of the specified
     * categories are searched against.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 4;</code>
     *
     * @return A list containing the enum numeric values on the wire for jobCategories.
     */
    public java.util.List<java.lang.Integer> getJobCategoriesValueList() {
      return java.util.Collections.unmodifiableList(jobCategories_);
    }
    /**
     *
     *
     * <pre>
     * The category filter specifies the categories of jobs to search against.
     * See [JobCategory][google.cloud.talent.v4.JobCategory] for more information.
     *
     * If a value isn't specified, jobs from any category are searched against.
     *
     * If multiple values are specified, jobs from any of the specified
     * categories are searched against.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 4;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of jobCategories at the given index.
     */
    public int getJobCategoriesValue(int index) {
      return jobCategories_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The category filter specifies the categories of jobs to search against.
     * See [JobCategory][google.cloud.talent.v4.JobCategory] for more information.
     *
     * If a value isn't specified, jobs from any category are searched against.
     *
     * If multiple values are specified, jobs from any of the specified
     * categories are searched against.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 4;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for jobCategories to set.
     * @return This builder for chaining.
     */
    public Builder setJobCategoriesValue(int index, int value) {
      ensureJobCategoriesIsMutable();
      jobCategories_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category filter specifies the categories of jobs to search against.
     * See [JobCategory][google.cloud.talent.v4.JobCategory] for more information.
     *
     * If a value isn't specified, jobs from any category are searched against.
     *
     * If multiple values are specified, jobs from any of the specified
     * categories are searched against.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 4;</code>
     *
     * @param value The enum numeric value on the wire for jobCategories to add.
     * @return This builder for chaining.
     */
    public Builder addJobCategoriesValue(int value) {
      ensureJobCategoriesIsMutable();
      jobCategories_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The category filter specifies the categories of jobs to search against.
     * See [JobCategory][google.cloud.talent.v4.JobCategory] for more information.
     *
     * If a value isn't specified, jobs from any category are searched against.
     *
     * If multiple values are specified, jobs from any of the specified
     * categories are searched against.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.JobCategory job_categories = 4;</code>
     *
     * @param values The enum numeric values on the wire for jobCategories to add.
     * @return This builder for chaining.
     */
    public Builder addAllJobCategoriesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureJobCategoriesIsMutable();
      for (int value : values) {
        jobCategories_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.cloud.talent.v4.CommuteFilter commuteFilter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.CommuteFilter,
            com.google.cloud.talent.v4.CommuteFilter.Builder,
            com.google.cloud.talent.v4.CommuteFilterOrBuilder>
        commuteFilterBuilder_;
    /**
     *
     *
     * <pre>
     * Allows filtering jobs by commute time with different travel methods (for
     *  example, driving or public transit).
     *
     * Note: This only works when you specify a
     * [CommuteMethod][google.cloud.talent.v4.CommuteMethod]. In this case,
     * [location_filters][google.cloud.talent.v4.JobQuery.location_filters] is
     * ignored.
     *
     *  Currently we don't support sorting by commute time.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CommuteFilter commute_filter = 5;</code>
     *
     * @return Whether the commuteFilter field is set.
     */
    public boolean hasCommuteFilter() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Allows filtering jobs by commute time with different travel methods (for
     *  example, driving or public transit).
     *
     * Note: This only works when you specify a
     * [CommuteMethod][google.cloud.talent.v4.CommuteMethod]. In this case,
     * [location_filters][google.cloud.talent.v4.JobQuery.location_filters] is
     * ignored.
     *
     *  Currently we don't support sorting by commute time.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CommuteFilter commute_filter = 5;</code>
     *
     * @return The commuteFilter.
     */
    public com.google.cloud.talent.v4.CommuteFilter getCommuteFilter() {
      if (commuteFilterBuilder_ == null) {
        return commuteFilter_ == null
            ? com.google.cloud.talent.v4.CommuteFilter.getDefaultInstance()
            : commuteFilter_;
      } else {
        return commuteFilterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Allows filtering jobs by commute time with different travel methods (for
     *  example, driving or public transit).
     *
     * Note: This only works when you specify a
     * [CommuteMethod][google.cloud.talent.v4.CommuteMethod]. In this case,
     * [location_filters][google.cloud.talent.v4.JobQuery.location_filters] is
     * ignored.
     *
     *  Currently we don't support sorting by commute time.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CommuteFilter commute_filter = 5;</code>
     */
    public Builder setCommuteFilter(com.google.cloud.talent.v4.CommuteFilter value) {
      if (commuteFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        commuteFilter_ = value;
      } else {
        commuteFilterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allows filtering jobs by commute time with different travel methods (for
     *  example, driving or public transit).
     *
     * Note: This only works when you specify a
     * [CommuteMethod][google.cloud.talent.v4.CommuteMethod]. In this case,
     * [location_filters][google.cloud.talent.v4.JobQuery.location_filters] is
     * ignored.
     *
     *  Currently we don't support sorting by commute time.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CommuteFilter commute_filter = 5;</code>
     */
    public Builder setCommuteFilter(
        com.google.cloud.talent.v4.CommuteFilter.Builder builderForValue) {
      if (commuteFilterBuilder_ == null) {
        commuteFilter_ = builderForValue.build();
      } else {
        commuteFilterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allows filtering jobs by commute time with different travel methods (for
     *  example, driving or public transit).
     *
     * Note: This only works when you specify a
     * [CommuteMethod][google.cloud.talent.v4.CommuteMethod]. In this case,
     * [location_filters][google.cloud.talent.v4.JobQuery.location_filters] is
     * ignored.
     *
     *  Currently we don't support sorting by commute time.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CommuteFilter commute_filter = 5;</code>
     */
    public Builder mergeCommuteFilter(com.google.cloud.talent.v4.CommuteFilter value) {
      if (commuteFilterBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && commuteFilter_ != null
            && commuteFilter_ != com.google.cloud.talent.v4.CommuteFilter.getDefaultInstance()) {
          getCommuteFilterBuilder().mergeFrom(value);
        } else {
          commuteFilter_ = value;
        }
      } else {
        commuteFilterBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allows filtering jobs by commute time with different travel methods (for
     *  example, driving or public transit).
     *
     * Note: This only works when you specify a
     * [CommuteMethod][google.cloud.talent.v4.CommuteMethod]. In this case,
     * [location_filters][google.cloud.talent.v4.JobQuery.location_filters] is
     * ignored.
     *
     *  Currently we don't support sorting by commute time.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CommuteFilter commute_filter = 5;</code>
     */
    public Builder clearCommuteFilter() {
      bitField0_ = (bitField0_ & ~0x00000020);
      commuteFilter_ = null;
      if (commuteFilterBuilder_ != null) {
        commuteFilterBuilder_.dispose();
        commuteFilterBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allows filtering jobs by commute time with different travel methods (for
     *  example, driving or public transit).
     *
     * Note: This only works when you specify a
     * [CommuteMethod][google.cloud.talent.v4.CommuteMethod]. In this case,
     * [location_filters][google.cloud.talent.v4.JobQuery.location_filters] is
     * ignored.
     *
     *  Currently we don't support sorting by commute time.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CommuteFilter commute_filter = 5;</code>
     */
    public com.google.cloud.talent.v4.CommuteFilter.Builder getCommuteFilterBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCommuteFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Allows filtering jobs by commute time with different travel methods (for
     *  example, driving or public transit).
     *
     * Note: This only works when you specify a
     * [CommuteMethod][google.cloud.talent.v4.CommuteMethod]. In this case,
     * [location_filters][google.cloud.talent.v4.JobQuery.location_filters] is
     * ignored.
     *
     *  Currently we don't support sorting by commute time.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CommuteFilter commute_filter = 5;</code>
     */
    public com.google.cloud.talent.v4.CommuteFilterOrBuilder getCommuteFilterOrBuilder() {
      if (commuteFilterBuilder_ != null) {
        return commuteFilterBuilder_.getMessageOrBuilder();
      } else {
        return commuteFilter_ == null
            ? com.google.cloud.talent.v4.CommuteFilter.getDefaultInstance()
            : commuteFilter_;
      }
    }
    /**
     *
     *
     * <pre>
     * Allows filtering jobs by commute time with different travel methods (for
     *  example, driving or public transit).
     *
     * Note: This only works when you specify a
     * [CommuteMethod][google.cloud.talent.v4.CommuteMethod]. In this case,
     * [location_filters][google.cloud.talent.v4.JobQuery.location_filters] is
     * ignored.
     *
     *  Currently we don't support sorting by commute time.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CommuteFilter commute_filter = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.CommuteFilter,
            com.google.cloud.talent.v4.CommuteFilter.Builder,
            com.google.cloud.talent.v4.CommuteFilterOrBuilder>
        getCommuteFilterFieldBuilder() {
      if (commuteFilterBuilder_ == null) {
        commuteFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.talent.v4.CommuteFilter,
                com.google.cloud.talent.v4.CommuteFilter.Builder,
                com.google.cloud.talent.v4.CommuteFilterOrBuilder>(
                getCommuteFilter(), getParentForChildren(), isClean());
        commuteFilter_ = null;
      }
      return commuteFilterBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList companyDisplayNames_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureCompanyDisplayNamesIsMutable() {
      if (!companyDisplayNames_.isModifiable()) {
        companyDisplayNames_ = new com.google.protobuf.LazyStringArrayList(companyDisplayNames_);
      }
      bitField0_ |= 0x00000040;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the company
     * [Company.display_name][google.cloud.talent.v4.Company.display_name] of the
     * jobs to search against. The company name must match the value exactly.
     *
     * Alternatively, the value being searched for can be wrapped in different
     * match operators.
     * `SUBSTRING_MATCH([value])`
     * The company name must contain a case insensitive substring match of the
     * value. Using this function may increase latency.
     *
     * Sample Value: `SUBSTRING_MATCH(google)`
     *
     * `MULTI_WORD_TOKEN_MATCH([value])`
     * The value will be treated as a multi word token and the company name must
     * contain a case insensitive match of the value. Using this function may
     * increase latency.
     *
     * Sample Value: `MULTI_WORD_TOKEN_MATCH(google)`
     *
     * If a value isn't specified, jobs within the search results are
     * associated with any company.
     *
     * If multiple values are specified, jobs within the search results may be
     * associated with any of the specified companies.
     *
     * At most 20 company display name filters are allowed.
     * </pre>
     *
     * <code>repeated string company_display_names = 6;</code>
     *
     * @return A list containing the companyDisplayNames.
     */
    public com.google.protobuf.ProtocolStringList getCompanyDisplayNamesList() {
      companyDisplayNames_.makeImmutable();
      return companyDisplayNames_;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the company
     * [Company.display_name][google.cloud.talent.v4.Company.display_name] of the
     * jobs to search against. The company name must match the value exactly.
     *
     * Alternatively, the value being searched for can be wrapped in different
     * match operators.
     * `SUBSTRING_MATCH([value])`
     * The company name must contain a case insensitive substring match of the
     * value. Using this function may increase latency.
     *
     * Sample Value: `SUBSTRING_MATCH(google)`
     *
     * `MULTI_WORD_TOKEN_MATCH([value])`
     * The value will be treated as a multi word token and the company name must
     * contain a case insensitive match of the value. Using this function may
     * increase latency.
     *
     * Sample Value: `MULTI_WORD_TOKEN_MATCH(google)`
     *
     * If a value isn't specified, jobs within the search results are
     * associated with any company.
     *
     * If multiple values are specified, jobs within the search results may be
     * associated with any of the specified companies.
     *
     * At most 20 company display name filters are allowed.
     * </pre>
     *
     * <code>repeated string company_display_names = 6;</code>
     *
     * @return The count of companyDisplayNames.
     */
    public int getCompanyDisplayNamesCount() {
      return companyDisplayNames_.size();
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the company
     * [Company.display_name][google.cloud.talent.v4.Company.display_name] of the
     * jobs to search against. The company name must match the value exactly.
     *
     * Alternatively, the value being searched for can be wrapped in different
     * match operators.
     * `SUBSTRING_MATCH([value])`
     * The company name must contain a case insensitive substring match of the
     * value. Using this function may increase latency.
     *
     * Sample Value: `SUBSTRING_MATCH(google)`
     *
     * `MULTI_WORD_TOKEN_MATCH([value])`
     * The value will be treated as a multi word token and the company name must
     * contain a case insensitive match of the value. Using this function may
     * increase latency.
     *
     * Sample Value: `MULTI_WORD_TOKEN_MATCH(google)`
     *
     * If a value isn't specified, jobs within the search results are
     * associated with any company.
     *
     * If multiple values are specified, jobs within the search results may be
     * associated with any of the specified companies.
     *
     * At most 20 company display name filters are allowed.
     * </pre>
     *
     * <code>repeated string company_display_names = 6;</code>
     *
     * @param index The index of the element to return.
     * @return The companyDisplayNames at the given index.
     */
    public java.lang.String getCompanyDisplayNames(int index) {
      return companyDisplayNames_.get(index);
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the company
     * [Company.display_name][google.cloud.talent.v4.Company.display_name] of the
     * jobs to search against. The company name must match the value exactly.
     *
     * Alternatively, the value being searched for can be wrapped in different
     * match operators.
     * `SUBSTRING_MATCH([value])`
     * The company name must contain a case insensitive substring match of the
     * value. Using this function may increase latency.
     *
     * Sample Value: `SUBSTRING_MATCH(google)`
     *
     * `MULTI_WORD_TOKEN_MATCH([value])`
     * The value will be treated as a multi word token and the company name must
     * contain a case insensitive match of the value. Using this function may
     * increase latency.
     *
     * Sample Value: `MULTI_WORD_TOKEN_MATCH(google)`
     *
     * If a value isn't specified, jobs within the search results are
     * associated with any company.
     *
     * If multiple values are specified, jobs within the search results may be
     * associated with any of the specified companies.
     *
     * At most 20 company display name filters are allowed.
     * </pre>
     *
     * <code>repeated string company_display_names = 6;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the companyDisplayNames at the given index.
     */
    public com.google.protobuf.ByteString getCompanyDisplayNamesBytes(int index) {
      return companyDisplayNames_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the company
     * [Company.display_name][google.cloud.talent.v4.Company.display_name] of the
     * jobs to search against. The company name must match the value exactly.
     *
     * Alternatively, the value being searched for can be wrapped in different
     * match operators.
     * `SUBSTRING_MATCH([value])`
     * The company name must contain a case insensitive substring match of the
     * value. Using this function may increase latency.
     *
     * Sample Value: `SUBSTRING_MATCH(google)`
     *
     * `MULTI_WORD_TOKEN_MATCH([value])`
     * The value will be treated as a multi word token and the company name must
     * contain a case insensitive match of the value. Using this function may
     * increase latency.
     *
     * Sample Value: `MULTI_WORD_TOKEN_MATCH(google)`
     *
     * If a value isn't specified, jobs within the search results are
     * associated with any company.
     *
     * If multiple values are specified, jobs within the search results may be
     * associated with any of the specified companies.
     *
     * At most 20 company display name filters are allowed.
     * </pre>
     *
     * <code>repeated string company_display_names = 6;</code>
     *
     * @param index The index to set the value at.
     * @param value The companyDisplayNames to set.
     * @return This builder for chaining.
     */
    public Builder setCompanyDisplayNames(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCompanyDisplayNamesIsMutable();
      companyDisplayNames_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the company
     * [Company.display_name][google.cloud.talent.v4.Company.display_name] of the
     * jobs to search against. The company name must match the value exactly.
     *
     * Alternatively, the value being searched for can be wrapped in different
     * match operators.
     * `SUBSTRING_MATCH([value])`
     * The company name must contain a case insensitive substring match of the
     * value. Using this function may increase latency.
     *
     * Sample Value: `SUBSTRING_MATCH(google)`
     *
     * `MULTI_WORD_TOKEN_MATCH([value])`
     * The value will be treated as a multi word token and the company name must
     * contain a case insensitive match of the value. Using this function may
     * increase latency.
     *
     * Sample Value: `MULTI_WORD_TOKEN_MATCH(google)`
     *
     * If a value isn't specified, jobs within the search results are
     * associated with any company.
     *
     * If multiple values are specified, jobs within the search results may be
     * associated with any of the specified companies.
     *
     * At most 20 company display name filters are allowed.
     * </pre>
     *
     * <code>repeated string company_display_names = 6;</code>
     *
     * @param value The companyDisplayNames to add.
     * @return This builder for chaining.
     */
    public Builder addCompanyDisplayNames(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCompanyDisplayNamesIsMutable();
      companyDisplayNames_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the company
     * [Company.display_name][google.cloud.talent.v4.Company.display_name] of the
     * jobs to search against. The company name must match the value exactly.
     *
     * Alternatively, the value being searched for can be wrapped in different
     * match operators.
     * `SUBSTRING_MATCH([value])`
     * The company name must contain a case insensitive substring match of the
     * value. Using this function may increase latency.
     *
     * Sample Value: `SUBSTRING_MATCH(google)`
     *
     * `MULTI_WORD_TOKEN_MATCH([value])`
     * The value will be treated as a multi word token and the company name must
     * contain a case insensitive match of the value. Using this function may
     * increase latency.
     *
     * Sample Value: `MULTI_WORD_TOKEN_MATCH(google)`
     *
     * If a value isn't specified, jobs within the search results are
     * associated with any company.
     *
     * If multiple values are specified, jobs within the search results may be
     * associated with any of the specified companies.
     *
     * At most 20 company display name filters are allowed.
     * </pre>
     *
     * <code>repeated string company_display_names = 6;</code>
     *
     * @param values The companyDisplayNames to add.
     * @return This builder for chaining.
     */
    public Builder addAllCompanyDisplayNames(java.lang.Iterable<java.lang.String> values) {
      ensureCompanyDisplayNamesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, companyDisplayNames_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the company
     * [Company.display_name][google.cloud.talent.v4.Company.display_name] of the
     * jobs to search against. The company name must match the value exactly.
     *
     * Alternatively, the value being searched for can be wrapped in different
     * match operators.
     * `SUBSTRING_MATCH([value])`
     * The company name must contain a case insensitive substring match of the
     * value. Using this function may increase latency.
     *
     * Sample Value: `SUBSTRING_MATCH(google)`
     *
     * `MULTI_WORD_TOKEN_MATCH([value])`
     * The value will be treated as a multi word token and the company name must
     * contain a case insensitive match of the value. Using this function may
     * increase latency.
     *
     * Sample Value: `MULTI_WORD_TOKEN_MATCH(google)`
     *
     * If a value isn't specified, jobs within the search results are
     * associated with any company.
     *
     * If multiple values are specified, jobs within the search results may be
     * associated with any of the specified companies.
     *
     * At most 20 company display name filters are allowed.
     * </pre>
     *
     * <code>repeated string company_display_names = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCompanyDisplayNames() {
      companyDisplayNames_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the company
     * [Company.display_name][google.cloud.talent.v4.Company.display_name] of the
     * jobs to search against. The company name must match the value exactly.
     *
     * Alternatively, the value being searched for can be wrapped in different
     * match operators.
     * `SUBSTRING_MATCH([value])`
     * The company name must contain a case insensitive substring match of the
     * value. Using this function may increase latency.
     *
     * Sample Value: `SUBSTRING_MATCH(google)`
     *
     * `MULTI_WORD_TOKEN_MATCH([value])`
     * The value will be treated as a multi word token and the company name must
     * contain a case insensitive match of the value. Using this function may
     * increase latency.
     *
     * Sample Value: `MULTI_WORD_TOKEN_MATCH(google)`
     *
     * If a value isn't specified, jobs within the search results are
     * associated with any company.
     *
     * If multiple values are specified, jobs within the search results may be
     * associated with any of the specified companies.
     *
     * At most 20 company display name filters are allowed.
     * </pre>
     *
     * <code>repeated string company_display_names = 6;</code>
     *
     * @param value The bytes of the companyDisplayNames to add.
     * @return This builder for chaining.
     */
    public Builder addCompanyDisplayNamesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCompanyDisplayNamesIsMutable();
      companyDisplayNames_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.cloud.talent.v4.CompensationFilter compensationFilter_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.CompensationFilter,
            com.google.cloud.talent.v4.CompensationFilter.Builder,
            com.google.cloud.talent.v4.CompensationFilterOrBuilder>
        compensationFilterBuilder_;
    /**
     *
     *
     * <pre>
     * This search filter is applied only to
     * [Job.compensation_info][google.cloud.talent.v4.Job.compensation_info]. For
     * example, if the filter is specified as "Hourly job with per-hour
     * compensation &gt; $15", only jobs meeting these criteria are searched. If a
     * filter isn't defined, all open jobs are searched.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompensationFilter compensation_filter = 7;</code>
     *
     * @return Whether the compensationFilter field is set.
     */
    public boolean hasCompensationFilter() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * This search filter is applied only to
     * [Job.compensation_info][google.cloud.talent.v4.Job.compensation_info]. For
     * example, if the filter is specified as "Hourly job with per-hour
     * compensation &gt; $15", only jobs meeting these criteria are searched. If a
     * filter isn't defined, all open jobs are searched.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompensationFilter compensation_filter = 7;</code>
     *
     * @return The compensationFilter.
     */
    public com.google.cloud.talent.v4.CompensationFilter getCompensationFilter() {
      if (compensationFilterBuilder_ == null) {
        return compensationFilter_ == null
            ? com.google.cloud.talent.v4.CompensationFilter.getDefaultInstance()
            : compensationFilter_;
      } else {
        return compensationFilterBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * This search filter is applied only to
     * [Job.compensation_info][google.cloud.talent.v4.Job.compensation_info]. For
     * example, if the filter is specified as "Hourly job with per-hour
     * compensation &gt; $15", only jobs meeting these criteria are searched. If a
     * filter isn't defined, all open jobs are searched.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompensationFilter compensation_filter = 7;</code>
     */
    public Builder setCompensationFilter(com.google.cloud.talent.v4.CompensationFilter value) {
      if (compensationFilterBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        compensationFilter_ = value;
      } else {
        compensationFilterBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This search filter is applied only to
     * [Job.compensation_info][google.cloud.talent.v4.Job.compensation_info]. For
     * example, if the filter is specified as "Hourly job with per-hour
     * compensation &gt; $15", only jobs meeting these criteria are searched. If a
     * filter isn't defined, all open jobs are searched.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompensationFilter compensation_filter = 7;</code>
     */
    public Builder setCompensationFilter(
        com.google.cloud.talent.v4.CompensationFilter.Builder builderForValue) {
      if (compensationFilterBuilder_ == null) {
        compensationFilter_ = builderForValue.build();
      } else {
        compensationFilterBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This search filter is applied only to
     * [Job.compensation_info][google.cloud.talent.v4.Job.compensation_info]. For
     * example, if the filter is specified as "Hourly job with per-hour
     * compensation &gt; $15", only jobs meeting these criteria are searched. If a
     * filter isn't defined, all open jobs are searched.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompensationFilter compensation_filter = 7;</code>
     */
    public Builder mergeCompensationFilter(com.google.cloud.talent.v4.CompensationFilter value) {
      if (compensationFilterBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && compensationFilter_ != null
            && compensationFilter_
                != com.google.cloud.talent.v4.CompensationFilter.getDefaultInstance()) {
          getCompensationFilterBuilder().mergeFrom(value);
        } else {
          compensationFilter_ = value;
        }
      } else {
        compensationFilterBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This search filter is applied only to
     * [Job.compensation_info][google.cloud.talent.v4.Job.compensation_info]. For
     * example, if the filter is specified as "Hourly job with per-hour
     * compensation &gt; $15", only jobs meeting these criteria are searched. If a
     * filter isn't defined, all open jobs are searched.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompensationFilter compensation_filter = 7;</code>
     */
    public Builder clearCompensationFilter() {
      bitField0_ = (bitField0_ & ~0x00000080);
      compensationFilter_ = null;
      if (compensationFilterBuilder_ != null) {
        compensationFilterBuilder_.dispose();
        compensationFilterBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This search filter is applied only to
     * [Job.compensation_info][google.cloud.talent.v4.Job.compensation_info]. For
     * example, if the filter is specified as "Hourly job with per-hour
     * compensation &gt; $15", only jobs meeting these criteria are searched. If a
     * filter isn't defined, all open jobs are searched.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompensationFilter compensation_filter = 7;</code>
     */
    public com.google.cloud.talent.v4.CompensationFilter.Builder getCompensationFilterBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getCompensationFilterFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * This search filter is applied only to
     * [Job.compensation_info][google.cloud.talent.v4.Job.compensation_info]. For
     * example, if the filter is specified as "Hourly job with per-hour
     * compensation &gt; $15", only jobs meeting these criteria are searched. If a
     * filter isn't defined, all open jobs are searched.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompensationFilter compensation_filter = 7;</code>
     */
    public com.google.cloud.talent.v4.CompensationFilterOrBuilder getCompensationFilterOrBuilder() {
      if (compensationFilterBuilder_ != null) {
        return compensationFilterBuilder_.getMessageOrBuilder();
      } else {
        return compensationFilter_ == null
            ? com.google.cloud.talent.v4.CompensationFilter.getDefaultInstance()
            : compensationFilter_;
      }
    }
    /**
     *
     *
     * <pre>
     * This search filter is applied only to
     * [Job.compensation_info][google.cloud.talent.v4.Job.compensation_info]. For
     * example, if the filter is specified as "Hourly job with per-hour
     * compensation &gt; $15", only jobs meeting these criteria are searched. If a
     * filter isn't defined, all open jobs are searched.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.CompensationFilter compensation_filter = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.CompensationFilter,
            com.google.cloud.talent.v4.CompensationFilter.Builder,
            com.google.cloud.talent.v4.CompensationFilterOrBuilder>
        getCompensationFilterFieldBuilder() {
      if (compensationFilterBuilder_ == null) {
        compensationFilterBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.talent.v4.CompensationFilter,
                com.google.cloud.talent.v4.CompensationFilter.Builder,
                com.google.cloud.talent.v4.CompensationFilterOrBuilder>(
                getCompensationFilter(), getParentForChildren(), isClean());
        compensationFilter_ = null;
      }
      return compensationFilterBuilder_;
    }

    private java.lang.Object customAttributeFilter_ = "";
    /**
     *
     *
     * <pre>
     * This filter specifies a structured syntax to match against the
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes]
     * marked as `filterable`.
     *
     * The syntax for this expression is a subset of SQL syntax.
     *
     * Supported operators are: `=`, `!=`, `&lt;`, `&lt;=`, `&gt;`, and `&gt;=` where the
     * left of the operator is a custom field key and the right of the operator
     * is a number or a quoted string. You must escape backslash (&#92;&#92;) and
     * quote (&#92;") characters.
     *
     * Supported functions are `LOWER([field_name])` to
     * perform a case insensitive match and `EMPTY([field_name])` to filter on the
     * existence of a key.
     *
     * Boolean expressions (AND/OR/NOT) are supported up to 3 levels of
     * nesting (for example, "((A AND B AND C) OR NOT D) AND E"), a maximum of 100
     * comparisons or functions are allowed in the expression. The expression
     * must be &lt; 10000 bytes in length.
     *
     * Sample Query:
     * `(LOWER(driving_license)="class &#92;"a&#92;"" OR EMPTY(driving_license)) AND
     * driving_years &gt; 10`
     * </pre>
     *
     * <code>string custom_attribute_filter = 8;</code>
     *
     * @return The customAttributeFilter.
     */
    public java.lang.String getCustomAttributeFilter() {
      java.lang.Object ref = customAttributeFilter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        customAttributeFilter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This filter specifies a structured syntax to match against the
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes]
     * marked as `filterable`.
     *
     * The syntax for this expression is a subset of SQL syntax.
     *
     * Supported operators are: `=`, `!=`, `&lt;`, `&lt;=`, `&gt;`, and `&gt;=` where the
     * left of the operator is a custom field key and the right of the operator
     * is a number or a quoted string. You must escape backslash (&#92;&#92;) and
     * quote (&#92;") characters.
     *
     * Supported functions are `LOWER([field_name])` to
     * perform a case insensitive match and `EMPTY([field_name])` to filter on the
     * existence of a key.
     *
     * Boolean expressions (AND/OR/NOT) are supported up to 3 levels of
     * nesting (for example, "((A AND B AND C) OR NOT D) AND E"), a maximum of 100
     * comparisons or functions are allowed in the expression. The expression
     * must be &lt; 10000 bytes in length.
     *
     * Sample Query:
     * `(LOWER(driving_license)="class &#92;"a&#92;"" OR EMPTY(driving_license)) AND
     * driving_years &gt; 10`
     * </pre>
     *
     * <code>string custom_attribute_filter = 8;</code>
     *
     * @return The bytes for customAttributeFilter.
     */
    public com.google.protobuf.ByteString getCustomAttributeFilterBytes() {
      java.lang.Object ref = customAttributeFilter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        customAttributeFilter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * This filter specifies a structured syntax to match against the
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes]
     * marked as `filterable`.
     *
     * The syntax for this expression is a subset of SQL syntax.
     *
     * Supported operators are: `=`, `!=`, `&lt;`, `&lt;=`, `&gt;`, and `&gt;=` where the
     * left of the operator is a custom field key and the right of the operator
     * is a number or a quoted string. You must escape backslash (&#92;&#92;) and
     * quote (&#92;") characters.
     *
     * Supported functions are `LOWER([field_name])` to
     * perform a case insensitive match and `EMPTY([field_name])` to filter on the
     * existence of a key.
     *
     * Boolean expressions (AND/OR/NOT) are supported up to 3 levels of
     * nesting (for example, "((A AND B AND C) OR NOT D) AND E"), a maximum of 100
     * comparisons or functions are allowed in the expression. The expression
     * must be &lt; 10000 bytes in length.
     *
     * Sample Query:
     * `(LOWER(driving_license)="class &#92;"a&#92;"" OR EMPTY(driving_license)) AND
     * driving_years &gt; 10`
     * </pre>
     *
     * <code>string custom_attribute_filter = 8;</code>
     *
     * @param value The customAttributeFilter to set.
     * @return This builder for chaining.
     */
    public Builder setCustomAttributeFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      customAttributeFilter_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies a structured syntax to match against the
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes]
     * marked as `filterable`.
     *
     * The syntax for this expression is a subset of SQL syntax.
     *
     * Supported operators are: `=`, `!=`, `&lt;`, `&lt;=`, `&gt;`, and `&gt;=` where the
     * left of the operator is a custom field key and the right of the operator
     * is a number or a quoted string. You must escape backslash (&#92;&#92;) and
     * quote (&#92;") characters.
     *
     * Supported functions are `LOWER([field_name])` to
     * perform a case insensitive match and `EMPTY([field_name])` to filter on the
     * existence of a key.
     *
     * Boolean expressions (AND/OR/NOT) are supported up to 3 levels of
     * nesting (for example, "((A AND B AND C) OR NOT D) AND E"), a maximum of 100
     * comparisons or functions are allowed in the expression. The expression
     * must be &lt; 10000 bytes in length.
     *
     * Sample Query:
     * `(LOWER(driving_license)="class &#92;"a&#92;"" OR EMPTY(driving_license)) AND
     * driving_years &gt; 10`
     * </pre>
     *
     * <code>string custom_attribute_filter = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomAttributeFilter() {
      customAttributeFilter_ = getDefaultInstance().getCustomAttributeFilter();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies a structured syntax to match against the
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes]
     * marked as `filterable`.
     *
     * The syntax for this expression is a subset of SQL syntax.
     *
     * Supported operators are: `=`, `!=`, `&lt;`, `&lt;=`, `&gt;`, and `&gt;=` where the
     * left of the operator is a custom field key and the right of the operator
     * is a number or a quoted string. You must escape backslash (&#92;&#92;) and
     * quote (&#92;") characters.
     *
     * Supported functions are `LOWER([field_name])` to
     * perform a case insensitive match and `EMPTY([field_name])` to filter on the
     * existence of a key.
     *
     * Boolean expressions (AND/OR/NOT) are supported up to 3 levels of
     * nesting (for example, "((A AND B AND C) OR NOT D) AND E"), a maximum of 100
     * comparisons or functions are allowed in the expression. The expression
     * must be &lt; 10000 bytes in length.
     *
     * Sample Query:
     * `(LOWER(driving_license)="class &#92;"a&#92;"" OR EMPTY(driving_license)) AND
     * driving_years &gt; 10`
     * </pre>
     *
     * <code>string custom_attribute_filter = 8;</code>
     *
     * @param value The bytes for customAttributeFilter to set.
     * @return This builder for chaining.
     */
    public Builder setCustomAttributeFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      customAttributeFilter_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private boolean disableSpellCheck_;
    /**
     *
     *
     * <pre>
     * This flag controls the spell-check feature. If false, the
     * service attempts to correct a misspelled query,
     * for example, "enginee" is corrected to "engineer".
     *
     * Defaults to false: a spell check is performed.
     * </pre>
     *
     * <code>bool disable_spell_check = 9;</code>
     *
     * @return The disableSpellCheck.
     */
    @java.lang.Override
    public boolean getDisableSpellCheck() {
      return disableSpellCheck_;
    }
    /**
     *
     *
     * <pre>
     * This flag controls the spell-check feature. If false, the
     * service attempts to correct a misspelled query,
     * for example, "enginee" is corrected to "engineer".
     *
     * Defaults to false: a spell check is performed.
     * </pre>
     *
     * <code>bool disable_spell_check = 9;</code>
     *
     * @param value The disableSpellCheck to set.
     * @return This builder for chaining.
     */
    public Builder setDisableSpellCheck(boolean value) {

      disableSpellCheck_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This flag controls the spell-check feature. If false, the
     * service attempts to correct a misspelled query,
     * for example, "enginee" is corrected to "engineer".
     *
     * Defaults to false: a spell check is performed.
     * </pre>
     *
     * <code>bool disable_spell_check = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisableSpellCheck() {
      bitField0_ = (bitField0_ & ~0x00000200);
      disableSpellCheck_ = false;
      onChanged();
      return this;
    }

    private java.util.List<java.lang.Integer> employmentTypes_ = java.util.Collections.emptyList();

    private void ensureEmploymentTypesIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        employmentTypes_ = new java.util.ArrayList<java.lang.Integer>(employmentTypes_);
        bitField0_ |= 0x00000400;
      }
    }
    /**
     *
     *
     * <pre>
     * The employment type filter specifies the employment type of jobs to
     * search against, such as
     * [EmploymentType.FULL_TIME][google.cloud.talent.v4.EmploymentType.FULL_TIME].
     *
     * If a value isn't specified, jobs in the search results includes any
     * employment type.
     *
     * If multiple values are specified, jobs in the search results include
     * any of the specified employment types.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 10;</code>
     *
     * @return A list containing the employmentTypes.
     */
    public java.util.List<com.google.cloud.talent.v4.EmploymentType> getEmploymentTypesList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer, com.google.cloud.talent.v4.EmploymentType>(
          employmentTypes_, employmentTypes_converter_);
    }
    /**
     *
     *
     * <pre>
     * The employment type filter specifies the employment type of jobs to
     * search against, such as
     * [EmploymentType.FULL_TIME][google.cloud.talent.v4.EmploymentType.FULL_TIME].
     *
     * If a value isn't specified, jobs in the search results includes any
     * employment type.
     *
     * If multiple values are specified, jobs in the search results include
     * any of the specified employment types.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 10;</code>
     *
     * @return The count of employmentTypes.
     */
    public int getEmploymentTypesCount() {
      return employmentTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * The employment type filter specifies the employment type of jobs to
     * search against, such as
     * [EmploymentType.FULL_TIME][google.cloud.talent.v4.EmploymentType.FULL_TIME].
     *
     * If a value isn't specified, jobs in the search results includes any
     * employment type.
     *
     * If multiple values are specified, jobs in the search results include
     * any of the specified employment types.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 10;</code>
     *
     * @param index The index of the element to return.
     * @return The employmentTypes at the given index.
     */
    public com.google.cloud.talent.v4.EmploymentType getEmploymentTypes(int index) {
      return employmentTypes_converter_.convert(employmentTypes_.get(index));
    }
    /**
     *
     *
     * <pre>
     * The employment type filter specifies the employment type of jobs to
     * search against, such as
     * [EmploymentType.FULL_TIME][google.cloud.talent.v4.EmploymentType.FULL_TIME].
     *
     * If a value isn't specified, jobs in the search results includes any
     * employment type.
     *
     * If multiple values are specified, jobs in the search results include
     * any of the specified employment types.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 10;</code>
     *
     * @param index The index to set the value at.
     * @param value The employmentTypes to set.
     * @return This builder for chaining.
     */
    public Builder setEmploymentTypes(int index, com.google.cloud.talent.v4.EmploymentType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEmploymentTypesIsMutable();
      employmentTypes_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The employment type filter specifies the employment type of jobs to
     * search against, such as
     * [EmploymentType.FULL_TIME][google.cloud.talent.v4.EmploymentType.FULL_TIME].
     *
     * If a value isn't specified, jobs in the search results includes any
     * employment type.
     *
     * If multiple values are specified, jobs in the search results include
     * any of the specified employment types.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 10;</code>
     *
     * @param value The employmentTypes to add.
     * @return This builder for chaining.
     */
    public Builder addEmploymentTypes(com.google.cloud.talent.v4.EmploymentType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEmploymentTypesIsMutable();
      employmentTypes_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The employment type filter specifies the employment type of jobs to
     * search against, such as
     * [EmploymentType.FULL_TIME][google.cloud.talent.v4.EmploymentType.FULL_TIME].
     *
     * If a value isn't specified, jobs in the search results includes any
     * employment type.
     *
     * If multiple values are specified, jobs in the search results include
     * any of the specified employment types.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 10;</code>
     *
     * @param values The employmentTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllEmploymentTypes(
        java.lang.Iterable<? extends com.google.cloud.talent.v4.EmploymentType> values) {
      ensureEmploymentTypesIsMutable();
      for (com.google.cloud.talent.v4.EmploymentType value : values) {
        employmentTypes_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The employment type filter specifies the employment type of jobs to
     * search against, such as
     * [EmploymentType.FULL_TIME][google.cloud.talent.v4.EmploymentType.FULL_TIME].
     *
     * If a value isn't specified, jobs in the search results includes any
     * employment type.
     *
     * If multiple values are specified, jobs in the search results include
     * any of the specified employment types.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEmploymentTypes() {
      employmentTypes_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The employment type filter specifies the employment type of jobs to
     * search against, such as
     * [EmploymentType.FULL_TIME][google.cloud.talent.v4.EmploymentType.FULL_TIME].
     *
     * If a value isn't specified, jobs in the search results includes any
     * employment type.
     *
     * If multiple values are specified, jobs in the search results include
     * any of the specified employment types.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 10;</code>
     *
     * @return A list containing the enum numeric values on the wire for employmentTypes.
     */
    public java.util.List<java.lang.Integer> getEmploymentTypesValueList() {
      return java.util.Collections.unmodifiableList(employmentTypes_);
    }
    /**
     *
     *
     * <pre>
     * The employment type filter specifies the employment type of jobs to
     * search against, such as
     * [EmploymentType.FULL_TIME][google.cloud.talent.v4.EmploymentType.FULL_TIME].
     *
     * If a value isn't specified, jobs in the search results includes any
     * employment type.
     *
     * If multiple values are specified, jobs in the search results include
     * any of the specified employment types.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 10;</code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of employmentTypes at the given index.
     */
    public int getEmploymentTypesValue(int index) {
      return employmentTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * The employment type filter specifies the employment type of jobs to
     * search against, such as
     * [EmploymentType.FULL_TIME][google.cloud.talent.v4.EmploymentType.FULL_TIME].
     *
     * If a value isn't specified, jobs in the search results includes any
     * employment type.
     *
     * If multiple values are specified, jobs in the search results include
     * any of the specified employment types.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 10;</code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for employmentTypes to set.
     * @return This builder for chaining.
     */
    public Builder setEmploymentTypesValue(int index, int value) {
      ensureEmploymentTypesIsMutable();
      employmentTypes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The employment type filter specifies the employment type of jobs to
     * search against, such as
     * [EmploymentType.FULL_TIME][google.cloud.talent.v4.EmploymentType.FULL_TIME].
     *
     * If a value isn't specified, jobs in the search results includes any
     * employment type.
     *
     * If multiple values are specified, jobs in the search results include
     * any of the specified employment types.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 10;</code>
     *
     * @param value The enum numeric value on the wire for employmentTypes to add.
     * @return This builder for chaining.
     */
    public Builder addEmploymentTypesValue(int value) {
      ensureEmploymentTypesIsMutable();
      employmentTypes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The employment type filter specifies the employment type of jobs to
     * search against, such as
     * [EmploymentType.FULL_TIME][google.cloud.talent.v4.EmploymentType.FULL_TIME].
     *
     * If a value isn't specified, jobs in the search results includes any
     * employment type.
     *
     * If multiple values are specified, jobs in the search results include
     * any of the specified employment types.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.EmploymentType employment_types = 10;</code>
     *
     * @param values The enum numeric values on the wire for employmentTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllEmploymentTypesValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureEmploymentTypesIsMutable();
      for (int value : values) {
        employmentTypes_.add(value);
      }
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList languageCodes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureLanguageCodesIsMutable() {
      if (!languageCodes_.isModifiable()) {
        languageCodes_ = new com.google.protobuf.LazyStringArrayList(languageCodes_);
      }
      bitField0_ |= 0x00000800;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the locale of jobs to search against,
     * for example, "en-US".
     *
     * If a value isn't specified, the search results can contain jobs in any
     * locale.
     *
     *
     * Language codes should be in BCP-47 format, such as "en-US" or "sr-Latn".
     * For more information, see
     * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
     *
     * At most 10 language code filters are allowed.
     * </pre>
     *
     * <code>repeated string language_codes = 11;</code>
     *
     * @return A list containing the languageCodes.
     */
    public com.google.protobuf.ProtocolStringList getLanguageCodesList() {
      languageCodes_.makeImmutable();
      return languageCodes_;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the locale of jobs to search against,
     * for example, "en-US".
     *
     * If a value isn't specified, the search results can contain jobs in any
     * locale.
     *
     *
     * Language codes should be in BCP-47 format, such as "en-US" or "sr-Latn".
     * For more information, see
     * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
     *
     * At most 10 language code filters are allowed.
     * </pre>
     *
     * <code>repeated string language_codes = 11;</code>
     *
     * @return The count of languageCodes.
     */
    public int getLanguageCodesCount() {
      return languageCodes_.size();
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the locale of jobs to search against,
     * for example, "en-US".
     *
     * If a value isn't specified, the search results can contain jobs in any
     * locale.
     *
     *
     * Language codes should be in BCP-47 format, such as "en-US" or "sr-Latn".
     * For more information, see
     * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
     *
     * At most 10 language code filters are allowed.
     * </pre>
     *
     * <code>repeated string language_codes = 11;</code>
     *
     * @param index The index of the element to return.
     * @return The languageCodes at the given index.
     */
    public java.lang.String getLanguageCodes(int index) {
      return languageCodes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the locale of jobs to search against,
     * for example, "en-US".
     *
     * If a value isn't specified, the search results can contain jobs in any
     * locale.
     *
     *
     * Language codes should be in BCP-47 format, such as "en-US" or "sr-Latn".
     * For more information, see
     * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
     *
     * At most 10 language code filters are allowed.
     * </pre>
     *
     * <code>repeated string language_codes = 11;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the languageCodes at the given index.
     */
    public com.google.protobuf.ByteString getLanguageCodesBytes(int index) {
      return languageCodes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the locale of jobs to search against,
     * for example, "en-US".
     *
     * If a value isn't specified, the search results can contain jobs in any
     * locale.
     *
     *
     * Language codes should be in BCP-47 format, such as "en-US" or "sr-Latn".
     * For more information, see
     * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
     *
     * At most 10 language code filters are allowed.
     * </pre>
     *
     * <code>repeated string language_codes = 11;</code>
     *
     * @param index The index to set the value at.
     * @param value The languageCodes to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLanguageCodesIsMutable();
      languageCodes_.set(index, value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the locale of jobs to search against,
     * for example, "en-US".
     *
     * If a value isn't specified, the search results can contain jobs in any
     * locale.
     *
     *
     * Language codes should be in BCP-47 format, such as "en-US" or "sr-Latn".
     * For more information, see
     * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
     *
     * At most 10 language code filters are allowed.
     * </pre>
     *
     * <code>repeated string language_codes = 11;</code>
     *
     * @param value The languageCodes to add.
     * @return This builder for chaining.
     */
    public Builder addLanguageCodes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureLanguageCodesIsMutable();
      languageCodes_.add(value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the locale of jobs to search against,
     * for example, "en-US".
     *
     * If a value isn't specified, the search results can contain jobs in any
     * locale.
     *
     *
     * Language codes should be in BCP-47 format, such as "en-US" or "sr-Latn".
     * For more information, see
     * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
     *
     * At most 10 language code filters are allowed.
     * </pre>
     *
     * <code>repeated string language_codes = 11;</code>
     *
     * @param values The languageCodes to add.
     * @return This builder for chaining.
     */
    public Builder addAllLanguageCodes(java.lang.Iterable<java.lang.String> values) {
      ensureLanguageCodesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, languageCodes_);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the locale of jobs to search against,
     * for example, "en-US".
     *
     * If a value isn't specified, the search results can contain jobs in any
     * locale.
     *
     *
     * Language codes should be in BCP-47 format, such as "en-US" or "sr-Latn".
     * For more information, see
     * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
     *
     * At most 10 language code filters are allowed.
     * </pre>
     *
     * <code>repeated string language_codes = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCodes() {
      languageCodes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000800);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies the locale of jobs to search against,
     * for example, "en-US".
     *
     * If a value isn't specified, the search results can contain jobs in any
     * locale.
     *
     *
     * Language codes should be in BCP-47 format, such as "en-US" or "sr-Latn".
     * For more information, see
     * [Tags for Identifying Languages](https://tools.ietf.org/html/bcp47).
     *
     * At most 10 language code filters are allowed.
     * </pre>
     *
     * <code>repeated string language_codes = 11;</code>
     *
     * @param value The bytes of the languageCodes to add.
     * @return This builder for chaining.
     */
    public Builder addLanguageCodesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureLanguageCodesIsMutable();
      languageCodes_.add(value);
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private com.google.cloud.talent.v4.TimestampRange publishTimeRange_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.TimestampRange,
            com.google.cloud.talent.v4.TimestampRange.Builder,
            com.google.cloud.talent.v4.TimestampRangeOrBuilder>
        publishTimeRangeBuilder_;
    /**
     *
     *
     * <pre>
     * Jobs published within a range specified by this filter are searched
     * against.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.TimestampRange publish_time_range = 12;</code>
     *
     * @return Whether the publishTimeRange field is set.
     */
    public boolean hasPublishTimeRange() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Jobs published within a range specified by this filter are searched
     * against.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.TimestampRange publish_time_range = 12;</code>
     *
     * @return The publishTimeRange.
     */
    public com.google.cloud.talent.v4.TimestampRange getPublishTimeRange() {
      if (publishTimeRangeBuilder_ == null) {
        return publishTimeRange_ == null
            ? com.google.cloud.talent.v4.TimestampRange.getDefaultInstance()
            : publishTimeRange_;
      } else {
        return publishTimeRangeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Jobs published within a range specified by this filter are searched
     * against.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.TimestampRange publish_time_range = 12;</code>
     */
    public Builder setPublishTimeRange(com.google.cloud.talent.v4.TimestampRange value) {
      if (publishTimeRangeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        publishTimeRange_ = value;
      } else {
        publishTimeRangeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Jobs published within a range specified by this filter are searched
     * against.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.TimestampRange publish_time_range = 12;</code>
     */
    public Builder setPublishTimeRange(
        com.google.cloud.talent.v4.TimestampRange.Builder builderForValue) {
      if (publishTimeRangeBuilder_ == null) {
        publishTimeRange_ = builderForValue.build();
      } else {
        publishTimeRangeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Jobs published within a range specified by this filter are searched
     * against.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.TimestampRange publish_time_range = 12;</code>
     */
    public Builder mergePublishTimeRange(com.google.cloud.talent.v4.TimestampRange value) {
      if (publishTimeRangeBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && publishTimeRange_ != null
            && publishTimeRange_
                != com.google.cloud.talent.v4.TimestampRange.getDefaultInstance()) {
          getPublishTimeRangeBuilder().mergeFrom(value);
        } else {
          publishTimeRange_ = value;
        }
      } else {
        publishTimeRangeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Jobs published within a range specified by this filter are searched
     * against.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.TimestampRange publish_time_range = 12;</code>
     */
    public Builder clearPublishTimeRange() {
      bitField0_ = (bitField0_ & ~0x00001000);
      publishTimeRange_ = null;
      if (publishTimeRangeBuilder_ != null) {
        publishTimeRangeBuilder_.dispose();
        publishTimeRangeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Jobs published within a range specified by this filter are searched
     * against.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.TimestampRange publish_time_range = 12;</code>
     */
    public com.google.cloud.talent.v4.TimestampRange.Builder getPublishTimeRangeBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getPublishTimeRangeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Jobs published within a range specified by this filter are searched
     * against.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.TimestampRange publish_time_range = 12;</code>
     */
    public com.google.cloud.talent.v4.TimestampRangeOrBuilder getPublishTimeRangeOrBuilder() {
      if (publishTimeRangeBuilder_ != null) {
        return publishTimeRangeBuilder_.getMessageOrBuilder();
      } else {
        return publishTimeRange_ == null
            ? com.google.cloud.talent.v4.TimestampRange.getDefaultInstance()
            : publishTimeRange_;
      }
    }
    /**
     *
     *
     * <pre>
     * Jobs published within a range specified by this filter are searched
     * against.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.TimestampRange publish_time_range = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.TimestampRange,
            com.google.cloud.talent.v4.TimestampRange.Builder,
            com.google.cloud.talent.v4.TimestampRangeOrBuilder>
        getPublishTimeRangeFieldBuilder() {
      if (publishTimeRangeBuilder_ == null) {
        publishTimeRangeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.talent.v4.TimestampRange,
                com.google.cloud.talent.v4.TimestampRange.Builder,
                com.google.cloud.talent.v4.TimestampRangeOrBuilder>(
                getPublishTimeRange(), getParentForChildren(), isClean());
        publishTimeRange_ = null;
      }
      return publishTimeRangeBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList excludedJobs_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureExcludedJobsIsMutable() {
      if (!excludedJobs_.isModifiable()) {
        excludedJobs_ = new com.google.protobuf.LazyStringArrayList(excludedJobs_);
      }
      bitField0_ |= 0x00002000;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies a list of job names to be excluded during search.
     *
     * At most 400 excluded job names are allowed.
     * </pre>
     *
     * <code>repeated string excluded_jobs = 13;</code>
     *
     * @return A list containing the excludedJobs.
     */
    public com.google.protobuf.ProtocolStringList getExcludedJobsList() {
      excludedJobs_.makeImmutable();
      return excludedJobs_;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies a list of job names to be excluded during search.
     *
     * At most 400 excluded job names are allowed.
     * </pre>
     *
     * <code>repeated string excluded_jobs = 13;</code>
     *
     * @return The count of excludedJobs.
     */
    public int getExcludedJobsCount() {
      return excludedJobs_.size();
    }
    /**
     *
     *
     * <pre>
     * This filter specifies a list of job names to be excluded during search.
     *
     * At most 400 excluded job names are allowed.
     * </pre>
     *
     * <code>repeated string excluded_jobs = 13;</code>
     *
     * @param index The index of the element to return.
     * @return The excludedJobs at the given index.
     */
    public java.lang.String getExcludedJobs(int index) {
      return excludedJobs_.get(index);
    }
    /**
     *
     *
     * <pre>
     * This filter specifies a list of job names to be excluded during search.
     *
     * At most 400 excluded job names are allowed.
     * </pre>
     *
     * <code>repeated string excluded_jobs = 13;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludedJobs at the given index.
     */
    public com.google.protobuf.ByteString getExcludedJobsBytes(int index) {
      return excludedJobs_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * This filter specifies a list of job names to be excluded during search.
     *
     * At most 400 excluded job names are allowed.
     * </pre>
     *
     * <code>repeated string excluded_jobs = 13;</code>
     *
     * @param index The index to set the value at.
     * @param value The excludedJobs to set.
     * @return This builder for chaining.
     */
    public Builder setExcludedJobs(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExcludedJobsIsMutable();
      excludedJobs_.set(index, value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies a list of job names to be excluded during search.
     *
     * At most 400 excluded job names are allowed.
     * </pre>
     *
     * <code>repeated string excluded_jobs = 13;</code>
     *
     * @param value The excludedJobs to add.
     * @return This builder for chaining.
     */
    public Builder addExcludedJobs(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExcludedJobsIsMutable();
      excludedJobs_.add(value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies a list of job names to be excluded during search.
     *
     * At most 400 excluded job names are allowed.
     * </pre>
     *
     * <code>repeated string excluded_jobs = 13;</code>
     *
     * @param values The excludedJobs to add.
     * @return This builder for chaining.
     */
    public Builder addAllExcludedJobs(java.lang.Iterable<java.lang.String> values) {
      ensureExcludedJobsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, excludedJobs_);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies a list of job names to be excluded during search.
     *
     * At most 400 excluded job names are allowed.
     * </pre>
     *
     * <code>repeated string excluded_jobs = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExcludedJobs() {
      excludedJobs_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00002000);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This filter specifies a list of job names to be excluded during search.
     *
     * At most 400 excluded job names are allowed.
     * </pre>
     *
     * <code>repeated string excluded_jobs = 13;</code>
     *
     * @param value The bytes of the excludedJobs to add.
     * @return This builder for chaining.
     */
    public Builder addExcludedJobsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureExcludedJobsIsMutable();
      excludedJobs_.add(value);
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.talent.v4.JobQuery)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.talent.v4.JobQuery)
  private static final com.google.cloud.talent.v4.JobQuery DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.talent.v4.JobQuery();
  }

  public static com.google.cloud.talent.v4.JobQuery getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<JobQuery> PARSER =
      new com.google.protobuf.AbstractParser<JobQuery>() {
        @java.lang.Override
        public JobQuery parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<JobQuery> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<JobQuery> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.talent.v4.JobQuery getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
