/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/talent/v4/company_service.proto

package com.google.cloud.talent.v4;

/**
 *
 *
 * <pre>
 * The List companies response object.
 * </pre>
 *
 * Protobuf type {@code google.cloud.talent.v4.ListCompaniesResponse}
 */
public final class ListCompaniesResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.talent.v4.ListCompaniesResponse)
    ListCompaniesResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListCompaniesResponse.newBuilder() to construct.
  private ListCompaniesResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListCompaniesResponse() {
    companies_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListCompaniesResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.talent.v4.CompanyServiceProto
        .internal_static_google_cloud_talent_v4_ListCompaniesResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.talent.v4.CompanyServiceProto
        .internal_static_google_cloud_talent_v4_ListCompaniesResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.talent.v4.ListCompaniesResponse.class,
            com.google.cloud.talent.v4.ListCompaniesResponse.Builder.class);
  }

  public static final int COMPANIES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.talent.v4.Company> companies_;
  /**
   *
   *
   * <pre>
   * Companies for the current client.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.talent.v4.Company> getCompaniesList() {
    return companies_;
  }
  /**
   *
   *
   * <pre>
   * Companies for the current client.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.talent.v4.CompanyOrBuilder>
      getCompaniesOrBuilderList() {
    return companies_;
  }
  /**
   *
   *
   * <pre>
   * Companies for the current client.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
   */
  @java.lang.Override
  public int getCompaniesCount() {
    return companies_.size();
  }
  /**
   *
   *
   * <pre>
   * Companies for the current client.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.Company getCompanies(int index) {
    return companies_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Companies for the current client.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.CompanyOrBuilder getCompaniesOrBuilder(int index) {
    return companies_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";
  /**
   *
   *
   * <pre>
   * A token to retrieve the next page of results.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A token to retrieve the next page of results.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METADATA_FIELD_NUMBER = 3;
  private com.google.cloud.talent.v4.ResponseMetadata metadata_;
  /**
   *
   *
   * <pre>
   * Additional information for the API invocation, such as the request
   * tracking id.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return metadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * Additional information for the API invocation, such as the request
   * tracking id.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.ResponseMetadata getMetadata() {
    return metadata_ == null
        ? com.google.cloud.talent.v4.ResponseMetadata.getDefaultInstance()
        : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Additional information for the API invocation, such as the request
   * tracking id.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.ResponseMetadataOrBuilder getMetadataOrBuilder() {
    return metadata_ == null
        ? com.google.cloud.talent.v4.ResponseMetadata.getDefaultInstance()
        : metadata_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < companies_.size(); i++) {
      output.writeMessage(1, companies_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    if (metadata_ != null) {
      output.writeMessage(3, getMetadata());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < companies_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, companies_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    if (metadata_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getMetadata());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.talent.v4.ListCompaniesResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.talent.v4.ListCompaniesResponse other =
        (com.google.cloud.talent.v4.ListCompaniesResponse) obj;

    if (!getCompaniesList().equals(other.getCompaniesList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getCompaniesCount() > 0) {
      hash = (37 * hash) + COMPANIES_FIELD_NUMBER;
      hash = (53 * hash) + getCompaniesList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.talent.v4.ListCompaniesResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.ListCompaniesResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.ListCompaniesResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.ListCompaniesResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.ListCompaniesResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.ListCompaniesResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.ListCompaniesResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.ListCompaniesResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.ListCompaniesResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.ListCompaniesResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.ListCompaniesResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.ListCompaniesResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.talent.v4.ListCompaniesResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The List companies response object.
   * </pre>
   *
   * Protobuf type {@code google.cloud.talent.v4.ListCompaniesResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.talent.v4.ListCompaniesResponse)
      com.google.cloud.talent.v4.ListCompaniesResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.talent.v4.CompanyServiceProto
          .internal_static_google_cloud_talent_v4_ListCompaniesResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.talent.v4.CompanyServiceProto
          .internal_static_google_cloud_talent_v4_ListCompaniesResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.talent.v4.ListCompaniesResponse.class,
              com.google.cloud.talent.v4.ListCompaniesResponse.Builder.class);
    }

    // Construct using com.google.cloud.talent.v4.ListCompaniesResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (companiesBuilder_ == null) {
        companies_ = java.util.Collections.emptyList();
      } else {
        companies_ = null;
        companiesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.talent.v4.CompanyServiceProto
          .internal_static_google_cloud_talent_v4_ListCompaniesResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.ListCompaniesResponse getDefaultInstanceForType() {
      return com.google.cloud.talent.v4.ListCompaniesResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.ListCompaniesResponse build() {
      com.google.cloud.talent.v4.ListCompaniesResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.ListCompaniesResponse buildPartial() {
      com.google.cloud.talent.v4.ListCompaniesResponse result =
          new com.google.cloud.talent.v4.ListCompaniesResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.talent.v4.ListCompaniesResponse result) {
      if (companiesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          companies_ = java.util.Collections.unmodifiableList(companies_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.companies_ = companies_;
      } else {
        result.companies_ = companiesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.talent.v4.ListCompaniesResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.talent.v4.ListCompaniesResponse) {
        return mergeFrom((com.google.cloud.talent.v4.ListCompaniesResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.talent.v4.ListCompaniesResponse other) {
      if (other == com.google.cloud.talent.v4.ListCompaniesResponse.getDefaultInstance())
        return this;
      if (companiesBuilder_ == null) {
        if (!other.companies_.isEmpty()) {
          if (companies_.isEmpty()) {
            companies_ = other.companies_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureCompaniesIsMutable();
            companies_.addAll(other.companies_);
          }
          onChanged();
        }
      } else {
        if (!other.companies_.isEmpty()) {
          if (companiesBuilder_.isEmpty()) {
            companiesBuilder_.dispose();
            companiesBuilder_ = null;
            companies_ = other.companies_;
            bitField0_ = (bitField0_ & ~0x00000001);
            companiesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCompaniesFieldBuilder()
                    : null;
          } else {
            companiesBuilder_.addAllMessages(other.companies_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.talent.v4.Company m =
                    input.readMessage(
                        com.google.cloud.talent.v4.Company.parser(), extensionRegistry);
                if (companiesBuilder_ == null) {
                  ensureCompaniesIsMutable();
                  companies_.add(m);
                } else {
                  companiesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.talent.v4.Company> companies_ =
        java.util.Collections.emptyList();

    private void ensureCompaniesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        companies_ = new java.util.ArrayList<com.google.cloud.talent.v4.Company>(companies_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.talent.v4.Company,
            com.google.cloud.talent.v4.Company.Builder,
            com.google.cloud.talent.v4.CompanyOrBuilder>
        companiesBuilder_;

    /**
     *
     *
     * <pre>
     * Companies for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
     */
    public java.util.List<com.google.cloud.talent.v4.Company> getCompaniesList() {
      if (companiesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(companies_);
      } else {
        return companiesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Companies for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
     */
    public int getCompaniesCount() {
      if (companiesBuilder_ == null) {
        return companies_.size();
      } else {
        return companiesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Companies for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
     */
    public com.google.cloud.talent.v4.Company getCompanies(int index) {
      if (companiesBuilder_ == null) {
        return companies_.get(index);
      } else {
        return companiesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Companies for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
     */
    public Builder setCompanies(int index, com.google.cloud.talent.v4.Company value) {
      if (companiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCompaniesIsMutable();
        companies_.set(index, value);
        onChanged();
      } else {
        companiesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Companies for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
     */
    public Builder setCompanies(
        int index, com.google.cloud.talent.v4.Company.Builder builderForValue) {
      if (companiesBuilder_ == null) {
        ensureCompaniesIsMutable();
        companies_.set(index, builderForValue.build());
        onChanged();
      } else {
        companiesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Companies for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
     */
    public Builder addCompanies(com.google.cloud.talent.v4.Company value) {
      if (companiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCompaniesIsMutable();
        companies_.add(value);
        onChanged();
      } else {
        companiesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Companies for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
     */
    public Builder addCompanies(int index, com.google.cloud.talent.v4.Company value) {
      if (companiesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCompaniesIsMutable();
        companies_.add(index, value);
        onChanged();
      } else {
        companiesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Companies for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
     */
    public Builder addCompanies(com.google.cloud.talent.v4.Company.Builder builderForValue) {
      if (companiesBuilder_ == null) {
        ensureCompaniesIsMutable();
        companies_.add(builderForValue.build());
        onChanged();
      } else {
        companiesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Companies for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
     */
    public Builder addCompanies(
        int index, com.google.cloud.talent.v4.Company.Builder builderForValue) {
      if (companiesBuilder_ == null) {
        ensureCompaniesIsMutable();
        companies_.add(index, builderForValue.build());
        onChanged();
      } else {
        companiesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Companies for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
     */
    public Builder addAllCompanies(
        java.lang.Iterable<? extends com.google.cloud.talent.v4.Company> values) {
      if (companiesBuilder_ == null) {
        ensureCompaniesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, companies_);
        onChanged();
      } else {
        companiesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Companies for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
     */
    public Builder clearCompanies() {
      if (companiesBuilder_ == null) {
        companies_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        companiesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Companies for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
     */
    public Builder removeCompanies(int index) {
      if (companiesBuilder_ == null) {
        ensureCompaniesIsMutable();
        companies_.remove(index);
        onChanged();
      } else {
        companiesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Companies for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
     */
    public com.google.cloud.talent.v4.Company.Builder getCompaniesBuilder(int index) {
      return getCompaniesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Companies for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
     */
    public com.google.cloud.talent.v4.CompanyOrBuilder getCompaniesOrBuilder(int index) {
      if (companiesBuilder_ == null) {
        return companies_.get(index);
      } else {
        return companiesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Companies for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.talent.v4.CompanyOrBuilder>
        getCompaniesOrBuilderList() {
      if (companiesBuilder_ != null) {
        return companiesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(companies_);
      }
    }
    /**
     *
     *
     * <pre>
     * Companies for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
     */
    public com.google.cloud.talent.v4.Company.Builder addCompaniesBuilder() {
      return getCompaniesFieldBuilder()
          .addBuilder(com.google.cloud.talent.v4.Company.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Companies for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
     */
    public com.google.cloud.talent.v4.Company.Builder addCompaniesBuilder(int index) {
      return getCompaniesFieldBuilder()
          .addBuilder(index, com.google.cloud.talent.v4.Company.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Companies for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Company companies = 1;</code>
     */
    public java.util.List<com.google.cloud.talent.v4.Company.Builder> getCompaniesBuilderList() {
      return getCompaniesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.talent.v4.Company,
            com.google.cloud.talent.v4.Company.Builder,
            com.google.cloud.talent.v4.CompanyOrBuilder>
        getCompaniesFieldBuilder() {
      if (companiesBuilder_ == null) {
        companiesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.talent.v4.Company,
                com.google.cloud.talent.v4.Company.Builder,
                com.google.cloud.talent.v4.CompanyOrBuilder>(
                companies_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        companies_ = null;
      }
      return companiesBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * A token to retrieve the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A token to retrieve the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A token to retrieve the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A token to retrieve the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A token to retrieve the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.talent.v4.ResponseMetadata metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.ResponseMetadata,
            com.google.cloud.talent.v4.ResponseMetadata.Builder,
            com.google.cloud.talent.v4.ResponseMetadataOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
     *
     * @return The metadata.
     */
    public com.google.cloud.talent.v4.ResponseMetadata getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null
            ? com.google.cloud.talent.v4.ResponseMetadata.getDefaultInstance()
            : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
     */
    public Builder setMetadata(com.google.cloud.talent.v4.ResponseMetadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
     */
    public Builder setMetadata(
        com.google.cloud.talent.v4.ResponseMetadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
     */
    public Builder mergeMetadata(com.google.cloud.talent.v4.ResponseMetadata value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && metadata_ != null
            && metadata_ != com.google.cloud.talent.v4.ResponseMetadata.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000004);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
     */
    public com.google.cloud.talent.v4.ResponseMetadata.Builder getMetadataBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
     */
    public com.google.cloud.talent.v4.ResponseMetadataOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null
            ? com.google.cloud.talent.v4.ResponseMetadata.getDefaultInstance()
            : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.ResponseMetadata,
            com.google.cloud.talent.v4.ResponseMetadata.Builder,
            com.google.cloud.talent.v4.ResponseMetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.talent.v4.ResponseMetadata,
                com.google.cloud.talent.v4.ResponseMetadata.Builder,
                com.google.cloud.talent.v4.ResponseMetadataOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.talent.v4.ListCompaniesResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.talent.v4.ListCompaniesResponse)
  private static final com.google.cloud.talent.v4.ListCompaniesResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.talent.v4.ListCompaniesResponse();
  }

  public static com.google.cloud.talent.v4.ListCompaniesResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListCompaniesResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListCompaniesResponse>() {
        @java.lang.Override
        public ListCompaniesResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListCompaniesResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListCompaniesResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.talent.v4.ListCompaniesResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
