/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/talent/v4/tenant_service.proto

package com.google.cloud.talent.v4;

/**
 *
 *
 * <pre>
 * The List tenants response object.
 * </pre>
 *
 * Protobuf type {@code google.cloud.talent.v4.ListTenantsResponse}
 */
public final class ListTenantsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.talent.v4.ListTenantsResponse)
    ListTenantsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListTenantsResponse.newBuilder() to construct.
  private ListTenantsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListTenantsResponse() {
    tenants_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListTenantsResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.talent.v4.TenantServiceProto
        .internal_static_google_cloud_talent_v4_ListTenantsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.talent.v4.TenantServiceProto
        .internal_static_google_cloud_talent_v4_ListTenantsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.talent.v4.ListTenantsResponse.class,
            com.google.cloud.talent.v4.ListTenantsResponse.Builder.class);
  }

  public static final int TENANTS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.talent.v4.Tenant> tenants_;
  /**
   *
   *
   * <pre>
   * Tenants for the current client.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.talent.v4.Tenant> getTenantsList() {
    return tenants_;
  }
  /**
   *
   *
   * <pre>
   * Tenants for the current client.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.talent.v4.TenantOrBuilder>
      getTenantsOrBuilderList() {
    return tenants_;
  }
  /**
   *
   *
   * <pre>
   * Tenants for the current client.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
   */
  @java.lang.Override
  public int getTenantsCount() {
    return tenants_.size();
  }
  /**
   *
   *
   * <pre>
   * Tenants for the current client.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.Tenant getTenants(int index) {
    return tenants_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Tenants for the current client.
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.TenantOrBuilder getTenantsOrBuilder(int index) {
    return tenants_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";
  /**
   *
   *
   * <pre>
   * A token to retrieve the next page of results.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * A token to retrieve the next page of results.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METADATA_FIELD_NUMBER = 3;
  private com.google.cloud.talent.v4.ResponseMetadata metadata_;
  /**
   *
   *
   * <pre>
   * Additional information for the API invocation, such as the request
   * tracking id.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return metadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * Additional information for the API invocation, such as the request
   * tracking id.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.ResponseMetadata getMetadata() {
    return metadata_ == null
        ? com.google.cloud.talent.v4.ResponseMetadata.getDefaultInstance()
        : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Additional information for the API invocation, such as the request
   * tracking id.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.ResponseMetadataOrBuilder getMetadataOrBuilder() {
    return metadata_ == null
        ? com.google.cloud.talent.v4.ResponseMetadata.getDefaultInstance()
        : metadata_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < tenants_.size(); i++) {
      output.writeMessage(1, tenants_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    if (metadata_ != null) {
      output.writeMessage(3, getMetadata());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < tenants_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, tenants_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    if (metadata_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getMetadata());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.talent.v4.ListTenantsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.talent.v4.ListTenantsResponse other =
        (com.google.cloud.talent.v4.ListTenantsResponse) obj;

    if (!getTenantsList().equals(other.getTenantsList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getTenantsCount() > 0) {
      hash = (37 * hash) + TENANTS_FIELD_NUMBER;
      hash = (53 * hash) + getTenantsList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.talent.v4.ListTenantsResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.ListTenantsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.ListTenantsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.ListTenantsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.ListTenantsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.ListTenantsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.ListTenantsResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.ListTenantsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.ListTenantsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.ListTenantsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.ListTenantsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.ListTenantsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.talent.v4.ListTenantsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The List tenants response object.
   * </pre>
   *
   * Protobuf type {@code google.cloud.talent.v4.ListTenantsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.talent.v4.ListTenantsResponse)
      com.google.cloud.talent.v4.ListTenantsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.talent.v4.TenantServiceProto
          .internal_static_google_cloud_talent_v4_ListTenantsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.talent.v4.TenantServiceProto
          .internal_static_google_cloud_talent_v4_ListTenantsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.talent.v4.ListTenantsResponse.class,
              com.google.cloud.talent.v4.ListTenantsResponse.Builder.class);
    }

    // Construct using com.google.cloud.talent.v4.ListTenantsResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (tenantsBuilder_ == null) {
        tenants_ = java.util.Collections.emptyList();
      } else {
        tenants_ = null;
        tenantsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.talent.v4.TenantServiceProto
          .internal_static_google_cloud_talent_v4_ListTenantsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.ListTenantsResponse getDefaultInstanceForType() {
      return com.google.cloud.talent.v4.ListTenantsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.ListTenantsResponse build() {
      com.google.cloud.talent.v4.ListTenantsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.ListTenantsResponse buildPartial() {
      com.google.cloud.talent.v4.ListTenantsResponse result =
          new com.google.cloud.talent.v4.ListTenantsResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.talent.v4.ListTenantsResponse result) {
      if (tenantsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          tenants_ = java.util.Collections.unmodifiableList(tenants_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.tenants_ = tenants_;
      } else {
        result.tenants_ = tenantsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.talent.v4.ListTenantsResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.talent.v4.ListTenantsResponse) {
        return mergeFrom((com.google.cloud.talent.v4.ListTenantsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.talent.v4.ListTenantsResponse other) {
      if (other == com.google.cloud.talent.v4.ListTenantsResponse.getDefaultInstance()) return this;
      if (tenantsBuilder_ == null) {
        if (!other.tenants_.isEmpty()) {
          if (tenants_.isEmpty()) {
            tenants_ = other.tenants_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureTenantsIsMutable();
            tenants_.addAll(other.tenants_);
          }
          onChanged();
        }
      } else {
        if (!other.tenants_.isEmpty()) {
          if (tenantsBuilder_.isEmpty()) {
            tenantsBuilder_.dispose();
            tenantsBuilder_ = null;
            tenants_ = other.tenants_;
            bitField0_ = (bitField0_ & ~0x00000001);
            tenantsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTenantsFieldBuilder()
                    : null;
          } else {
            tenantsBuilder_.addAllMessages(other.tenants_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.talent.v4.Tenant m =
                    input.readMessage(
                        com.google.cloud.talent.v4.Tenant.parser(), extensionRegistry);
                if (tenantsBuilder_ == null) {
                  ensureTenantsIsMutable();
                  tenants_.add(m);
                } else {
                  tenantsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.talent.v4.Tenant> tenants_ =
        java.util.Collections.emptyList();

    private void ensureTenantsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        tenants_ = new java.util.ArrayList<com.google.cloud.talent.v4.Tenant>(tenants_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.talent.v4.Tenant,
            com.google.cloud.talent.v4.Tenant.Builder,
            com.google.cloud.talent.v4.TenantOrBuilder>
        tenantsBuilder_;

    /**
     *
     *
     * <pre>
     * Tenants for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
     */
    public java.util.List<com.google.cloud.talent.v4.Tenant> getTenantsList() {
      if (tenantsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(tenants_);
      } else {
        return tenantsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Tenants for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
     */
    public int getTenantsCount() {
      if (tenantsBuilder_ == null) {
        return tenants_.size();
      } else {
        return tenantsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Tenants for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
     */
    public com.google.cloud.talent.v4.Tenant getTenants(int index) {
      if (tenantsBuilder_ == null) {
        return tenants_.get(index);
      } else {
        return tenantsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Tenants for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
     */
    public Builder setTenants(int index, com.google.cloud.talent.v4.Tenant value) {
      if (tenantsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTenantsIsMutable();
        tenants_.set(index, value);
        onChanged();
      } else {
        tenantsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tenants for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
     */
    public Builder setTenants(
        int index, com.google.cloud.talent.v4.Tenant.Builder builderForValue) {
      if (tenantsBuilder_ == null) {
        ensureTenantsIsMutable();
        tenants_.set(index, builderForValue.build());
        onChanged();
      } else {
        tenantsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tenants for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
     */
    public Builder addTenants(com.google.cloud.talent.v4.Tenant value) {
      if (tenantsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTenantsIsMutable();
        tenants_.add(value);
        onChanged();
      } else {
        tenantsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tenants for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
     */
    public Builder addTenants(int index, com.google.cloud.talent.v4.Tenant value) {
      if (tenantsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTenantsIsMutable();
        tenants_.add(index, value);
        onChanged();
      } else {
        tenantsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tenants for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
     */
    public Builder addTenants(com.google.cloud.talent.v4.Tenant.Builder builderForValue) {
      if (tenantsBuilder_ == null) {
        ensureTenantsIsMutable();
        tenants_.add(builderForValue.build());
        onChanged();
      } else {
        tenantsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tenants for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
     */
    public Builder addTenants(
        int index, com.google.cloud.talent.v4.Tenant.Builder builderForValue) {
      if (tenantsBuilder_ == null) {
        ensureTenantsIsMutable();
        tenants_.add(index, builderForValue.build());
        onChanged();
      } else {
        tenantsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tenants for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
     */
    public Builder addAllTenants(
        java.lang.Iterable<? extends com.google.cloud.talent.v4.Tenant> values) {
      if (tenantsBuilder_ == null) {
        ensureTenantsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tenants_);
        onChanged();
      } else {
        tenantsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tenants for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
     */
    public Builder clearTenants() {
      if (tenantsBuilder_ == null) {
        tenants_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        tenantsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tenants for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
     */
    public Builder removeTenants(int index) {
      if (tenantsBuilder_ == null) {
        ensureTenantsIsMutable();
        tenants_.remove(index);
        onChanged();
      } else {
        tenantsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Tenants for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
     */
    public com.google.cloud.talent.v4.Tenant.Builder getTenantsBuilder(int index) {
      return getTenantsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Tenants for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
     */
    public com.google.cloud.talent.v4.TenantOrBuilder getTenantsOrBuilder(int index) {
      if (tenantsBuilder_ == null) {
        return tenants_.get(index);
      } else {
        return tenantsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Tenants for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.talent.v4.TenantOrBuilder>
        getTenantsOrBuilderList() {
      if (tenantsBuilder_ != null) {
        return tenantsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(tenants_);
      }
    }
    /**
     *
     *
     * <pre>
     * Tenants for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
     */
    public com.google.cloud.talent.v4.Tenant.Builder addTenantsBuilder() {
      return getTenantsFieldBuilder()
          .addBuilder(com.google.cloud.talent.v4.Tenant.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Tenants for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
     */
    public com.google.cloud.talent.v4.Tenant.Builder addTenantsBuilder(int index) {
      return getTenantsFieldBuilder()
          .addBuilder(index, com.google.cloud.talent.v4.Tenant.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Tenants for the current client.
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Tenant tenants = 1;</code>
     */
    public java.util.List<com.google.cloud.talent.v4.Tenant.Builder> getTenantsBuilderList() {
      return getTenantsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.talent.v4.Tenant,
            com.google.cloud.talent.v4.Tenant.Builder,
            com.google.cloud.talent.v4.TenantOrBuilder>
        getTenantsFieldBuilder() {
      if (tenantsBuilder_ == null) {
        tenantsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.talent.v4.Tenant,
                com.google.cloud.talent.v4.Tenant.Builder,
                com.google.cloud.talent.v4.TenantOrBuilder>(
                tenants_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        tenants_ = null;
      }
      return tenantsBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * A token to retrieve the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A token to retrieve the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * A token to retrieve the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A token to retrieve the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A token to retrieve the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.talent.v4.ResponseMetadata metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.ResponseMetadata,
            com.google.cloud.talent.v4.ResponseMetadata.Builder,
            com.google.cloud.talent.v4.ResponseMetadataOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
     *
     * @return The metadata.
     */
    public com.google.cloud.talent.v4.ResponseMetadata getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null
            ? com.google.cloud.talent.v4.ResponseMetadata.getDefaultInstance()
            : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
     */
    public Builder setMetadata(com.google.cloud.talent.v4.ResponseMetadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
     */
    public Builder setMetadata(
        com.google.cloud.talent.v4.ResponseMetadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
     */
    public Builder mergeMetadata(com.google.cloud.talent.v4.ResponseMetadata value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && metadata_ != null
            && metadata_ != com.google.cloud.talent.v4.ResponseMetadata.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000004);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
     */
    public com.google.cloud.talent.v4.ResponseMetadata.Builder getMetadataBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
     */
    public com.google.cloud.talent.v4.ResponseMetadataOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null
            ? com.google.cloud.talent.v4.ResponseMetadata.getDefaultInstance()
            : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.ResponseMetadata,
            com.google.cloud.talent.v4.ResponseMetadata.Builder,
            com.google.cloud.talent.v4.ResponseMetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.talent.v4.ResponseMetadata,
                com.google.cloud.talent.v4.ResponseMetadata.Builder,
                com.google.cloud.talent.v4.ResponseMetadataOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.talent.v4.ListTenantsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.talent.v4.ListTenantsResponse)
  private static final com.google.cloud.talent.v4.ListTenantsResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.talent.v4.ListTenantsResponse();
  }

  public static com.google.cloud.talent.v4.ListTenantsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListTenantsResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListTenantsResponse>() {
        @java.lang.Override
        public ListTenantsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListTenantsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListTenantsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.talent.v4.ListTenantsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
