/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/talent/v4/filters.proto

package com.google.cloud.talent.v4;

/**
 *
 *
 * <pre>
 * Geographic region of the search.
 * </pre>
 *
 * Protobuf type {@code google.cloud.talent.v4.LocationFilter}
 */
public final class LocationFilter extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.talent.v4.LocationFilter)
    LocationFilterOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use LocationFilter.newBuilder() to construct.
  private LocationFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private LocationFilter() {
    address_ = "";
    regionCode_ = "";
    telecommutePreference_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new LocationFilter();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.talent.v4.FiltersProto
        .internal_static_google_cloud_talent_v4_LocationFilter_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.talent.v4.FiltersProto
        .internal_static_google_cloud_talent_v4_LocationFilter_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.talent.v4.LocationFilter.class,
            com.google.cloud.talent.v4.LocationFilter.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specify whether to include telecommute jobs.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.talent.v4.LocationFilter.TelecommutePreference}
   */
  public enum TelecommutePreference implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value if the telecommute preference isn't specified.
     * </pre>
     *
     * <code>TELECOMMUTE_PREFERENCE_UNSPECIFIED = 0;</code>
     */
    TELECOMMUTE_PREFERENCE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Deprecated: Ignore telecommute status of jobs. Use
     * TELECOMMUTE_JOBS_EXCLUDED if want to exclude telecommute jobs.
     * </pre>
     *
     * <code>TELECOMMUTE_EXCLUDED = 1 [deprecated = true];</code>
     */
    @java.lang.Deprecated
    TELECOMMUTE_EXCLUDED(1),
    /**
     *
     *
     * <pre>
     * Allow telecommute jobs.
     * </pre>
     *
     * <code>TELECOMMUTE_ALLOWED = 2;</code>
     */
    TELECOMMUTE_ALLOWED(2),
    /**
     *
     *
     * <pre>
     * Exclude telecommute jobs.
     * </pre>
     *
     * <code>TELECOMMUTE_JOBS_EXCLUDED = 3;</code>
     */
    TELECOMMUTE_JOBS_EXCLUDED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value if the telecommute preference isn't specified.
     * </pre>
     *
     * <code>TELECOMMUTE_PREFERENCE_UNSPECIFIED = 0;</code>
     */
    public static final int TELECOMMUTE_PREFERENCE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Deprecated: Ignore telecommute status of jobs. Use
     * TELECOMMUTE_JOBS_EXCLUDED if want to exclude telecommute jobs.
     * </pre>
     *
     * <code>TELECOMMUTE_EXCLUDED = 1 [deprecated = true];</code>
     */
    @java.lang.Deprecated public static final int TELECOMMUTE_EXCLUDED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Allow telecommute jobs.
     * </pre>
     *
     * <code>TELECOMMUTE_ALLOWED = 2;</code>
     */
    public static final int TELECOMMUTE_ALLOWED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Exclude telecommute jobs.
     * </pre>
     *
     * <code>TELECOMMUTE_JOBS_EXCLUDED = 3;</code>
     */
    public static final int TELECOMMUTE_JOBS_EXCLUDED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TelecommutePreference valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TelecommutePreference forNumber(int value) {
      switch (value) {
        case 0:
          return TELECOMMUTE_PREFERENCE_UNSPECIFIED;
        case 1:
          return TELECOMMUTE_EXCLUDED;
        case 2:
          return TELECOMMUTE_ALLOWED;
        case 3:
          return TELECOMMUTE_JOBS_EXCLUDED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TelecommutePreference>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TelecommutePreference>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<TelecommutePreference>() {
              public TelecommutePreference findValueByNumber(int number) {
                return TelecommutePreference.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.talent.v4.LocationFilter.getDescriptor().getEnumTypes().get(0);
    }

    private static final TelecommutePreference[] VALUES = values();

    public static TelecommutePreference valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TelecommutePreference(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.talent.v4.LocationFilter.TelecommutePreference)
  }

  public static final int ADDRESS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object address_ = "";
  /**
   *
   *
   * <pre>
   * The address name, such as "Mountain View" or "Bay Area".
   * </pre>
   *
   * <code>string address = 1;</code>
   *
   * @return The address.
   */
  @java.lang.Override
  public java.lang.String getAddress() {
    java.lang.Object ref = address_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      address_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The address name, such as "Mountain View" or "Bay Area".
   * </pre>
   *
   * <code>string address = 1;</code>
   *
   * @return The bytes for address.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAddressBytes() {
    java.lang.Object ref = address_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      address_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int REGION_CODE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object regionCode_ = "";
  /**
   *
   *
   * <pre>
   * CLDR region code of the country/region. This field may be used in two ways:
   *
   * 1) If telecommute preference is not set, this field is used address
   * ambiguity of the user-input address. For example, "Liverpool" may refer to
   * "Liverpool, NY, US" or "Liverpool, UK". This region code biases the
   * address resolution toward a specific country or territory. If this field is
   * not set, address resolution is biased toward the United States by default.
   *
   * 2) If telecommute preference is set to TELECOMMUTE_ALLOWED, the
   * telecommute location filter will be limited to the region specified in this
   * field. If this field is not set, the telecommute job locations will not be
   *
   * See
   * https://unicode-org.github.io/cldr-staging/charts/latest/supplemental/territory_information.html
   * for details. Example: "CH" for Switzerland.
   * </pre>
   *
   * <code>string region_code = 2;</code>
   *
   * @return The regionCode.
   */
  @java.lang.Override
  public java.lang.String getRegionCode() {
    java.lang.Object ref = regionCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      regionCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * CLDR region code of the country/region. This field may be used in two ways:
   *
   * 1) If telecommute preference is not set, this field is used address
   * ambiguity of the user-input address. For example, "Liverpool" may refer to
   * "Liverpool, NY, US" or "Liverpool, UK". This region code biases the
   * address resolution toward a specific country or territory. If this field is
   * not set, address resolution is biased toward the United States by default.
   *
   * 2) If telecommute preference is set to TELECOMMUTE_ALLOWED, the
   * telecommute location filter will be limited to the region specified in this
   * field. If this field is not set, the telecommute job locations will not be
   *
   * See
   * https://unicode-org.github.io/cldr-staging/charts/latest/supplemental/territory_information.html
   * for details. Example: "CH" for Switzerland.
   * </pre>
   *
   * <code>string region_code = 2;</code>
   *
   * @return The bytes for regionCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRegionCodeBytes() {
    java.lang.Object ref = regionCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      regionCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LAT_LNG_FIELD_NUMBER = 3;
  private com.google.type.LatLng latLng_;
  /**
   *
   *
   * <pre>
   * The latitude and longitude of the geographic center to search from. This
   * field is ignored if `address` is provided.
   * </pre>
   *
   * <code>.google.type.LatLng lat_lng = 3;</code>
   *
   * @return Whether the latLng field is set.
   */
  @java.lang.Override
  public boolean hasLatLng() {
    return latLng_ != null;
  }
  /**
   *
   *
   * <pre>
   * The latitude and longitude of the geographic center to search from. This
   * field is ignored if `address` is provided.
   * </pre>
   *
   * <code>.google.type.LatLng lat_lng = 3;</code>
   *
   * @return The latLng.
   */
  @java.lang.Override
  public com.google.type.LatLng getLatLng() {
    return latLng_ == null ? com.google.type.LatLng.getDefaultInstance() : latLng_;
  }
  /**
   *
   *
   * <pre>
   * The latitude and longitude of the geographic center to search from. This
   * field is ignored if `address` is provided.
   * </pre>
   *
   * <code>.google.type.LatLng lat_lng = 3;</code>
   */
  @java.lang.Override
  public com.google.type.LatLngOrBuilder getLatLngOrBuilder() {
    return latLng_ == null ? com.google.type.LatLng.getDefaultInstance() : latLng_;
  }

  public static final int DISTANCE_IN_MILES_FIELD_NUMBER = 4;
  private double distanceInMiles_ = 0D;
  /**
   *
   *
   * <pre>
   * The distance_in_miles is applied when the location being searched for is
   * identified as a city or smaller. This field is ignored if the location
   * being searched for is a state or larger.
   * </pre>
   *
   * <code>double distance_in_miles = 4;</code>
   *
   * @return The distanceInMiles.
   */
  @java.lang.Override
  public double getDistanceInMiles() {
    return distanceInMiles_;
  }

  public static final int TELECOMMUTE_PREFERENCE_FIELD_NUMBER = 5;
  private int telecommutePreference_ = 0;
  /**
   *
   *
   * <pre>
   * Allows the client to return jobs without a
   * set location, specifically, telecommuting jobs (telecommuting is considered
   * by the service as a special location).
   * [Job.posting_region][google.cloud.talent.v4.Job.posting_region] indicates
   * if a job permits telecommuting. If this field is set to
   * [TelecommutePreference.TELECOMMUTE_ALLOWED][google.cloud.talent.v4.LocationFilter.TelecommutePreference.TELECOMMUTE_ALLOWED],
   * telecommuting jobs are searched, and
   * [address][google.cloud.talent.v4.LocationFilter.address] and
   * [lat_lng][google.cloud.talent.v4.LocationFilter.lat_lng] are ignored. If
   * not set or set to
   * [TelecommutePreference.TELECOMMUTE_EXCLUDED][google.cloud.talent.v4.LocationFilter.TelecommutePreference.TELECOMMUTE_EXCLUDED],
   * the telecommute status of the jobs is ignored. Jobs that have
   * [PostingRegion.TELECOMMUTE][google.cloud.talent.v4.PostingRegion.TELECOMMUTE]
   * and have additional [Job.addresses][google.cloud.talent.v4.Job.addresses]
   * may still be matched based on other location filters using
   * [address][google.cloud.talent.v4.LocationFilter.address] or [latlng][].
   *
   * This filter can be used by itself to search exclusively for telecommuting
   * jobs, or it can be combined with another location
   * filter to search for a combination of job locations,
   * such as "Mountain View" or "telecommuting" jobs. However, when used in
   * combination with other location filters, telecommuting jobs can be
   * treated as less relevant than other jobs in the search response.
   *
   * This field is only used for job search requests.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.LocationFilter.TelecommutePreference telecommute_preference = 5;
   * </code>
   *
   * @return The enum numeric value on the wire for telecommutePreference.
   */
  @java.lang.Override
  public int getTelecommutePreferenceValue() {
    return telecommutePreference_;
  }
  /**
   *
   *
   * <pre>
   * Allows the client to return jobs without a
   * set location, specifically, telecommuting jobs (telecommuting is considered
   * by the service as a special location).
   * [Job.posting_region][google.cloud.talent.v4.Job.posting_region] indicates
   * if a job permits telecommuting. If this field is set to
   * [TelecommutePreference.TELECOMMUTE_ALLOWED][google.cloud.talent.v4.LocationFilter.TelecommutePreference.TELECOMMUTE_ALLOWED],
   * telecommuting jobs are searched, and
   * [address][google.cloud.talent.v4.LocationFilter.address] and
   * [lat_lng][google.cloud.talent.v4.LocationFilter.lat_lng] are ignored. If
   * not set or set to
   * [TelecommutePreference.TELECOMMUTE_EXCLUDED][google.cloud.talent.v4.LocationFilter.TelecommutePreference.TELECOMMUTE_EXCLUDED],
   * the telecommute status of the jobs is ignored. Jobs that have
   * [PostingRegion.TELECOMMUTE][google.cloud.talent.v4.PostingRegion.TELECOMMUTE]
   * and have additional [Job.addresses][google.cloud.talent.v4.Job.addresses]
   * may still be matched based on other location filters using
   * [address][google.cloud.talent.v4.LocationFilter.address] or [latlng][].
   *
   * This filter can be used by itself to search exclusively for telecommuting
   * jobs, or it can be combined with another location
   * filter to search for a combination of job locations,
   * such as "Mountain View" or "telecommuting" jobs. However, when used in
   * combination with other location filters, telecommuting jobs can be
   * treated as less relevant than other jobs in the search response.
   *
   * This field is only used for job search requests.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.LocationFilter.TelecommutePreference telecommute_preference = 5;
   * </code>
   *
   * @return The telecommutePreference.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.LocationFilter.TelecommutePreference
      getTelecommutePreference() {
    com.google.cloud.talent.v4.LocationFilter.TelecommutePreference result =
        com.google.cloud.talent.v4.LocationFilter.TelecommutePreference.forNumber(
            telecommutePreference_);
    return result == null
        ? com.google.cloud.talent.v4.LocationFilter.TelecommutePreference.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(address_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, address_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(regionCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, regionCode_);
    }
    if (latLng_ != null) {
      output.writeMessage(3, getLatLng());
    }
    if (java.lang.Double.doubleToRawLongBits(distanceInMiles_) != 0) {
      output.writeDouble(4, distanceInMiles_);
    }
    if (telecommutePreference_
        != com.google.cloud.talent.v4.LocationFilter.TelecommutePreference
            .TELECOMMUTE_PREFERENCE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, telecommutePreference_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(address_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, address_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(regionCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, regionCode_);
    }
    if (latLng_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getLatLng());
    }
    if (java.lang.Double.doubleToRawLongBits(distanceInMiles_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(4, distanceInMiles_);
    }
    if (telecommutePreference_
        != com.google.cloud.talent.v4.LocationFilter.TelecommutePreference
            .TELECOMMUTE_PREFERENCE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, telecommutePreference_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.talent.v4.LocationFilter)) {
      return super.equals(obj);
    }
    com.google.cloud.talent.v4.LocationFilter other =
        (com.google.cloud.talent.v4.LocationFilter) obj;

    if (!getAddress().equals(other.getAddress())) return false;
    if (!getRegionCode().equals(other.getRegionCode())) return false;
    if (hasLatLng() != other.hasLatLng()) return false;
    if (hasLatLng()) {
      if (!getLatLng().equals(other.getLatLng())) return false;
    }
    if (java.lang.Double.doubleToLongBits(getDistanceInMiles())
        != java.lang.Double.doubleToLongBits(other.getDistanceInMiles())) return false;
    if (telecommutePreference_ != other.telecommutePreference_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ADDRESS_FIELD_NUMBER;
    hash = (53 * hash) + getAddress().hashCode();
    hash = (37 * hash) + REGION_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getRegionCode().hashCode();
    if (hasLatLng()) {
      hash = (37 * hash) + LAT_LNG_FIELD_NUMBER;
      hash = (53 * hash) + getLatLng().hashCode();
    }
    hash = (37 * hash) + DISTANCE_IN_MILES_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getDistanceInMiles()));
    hash = (37 * hash) + TELECOMMUTE_PREFERENCE_FIELD_NUMBER;
    hash = (53 * hash) + telecommutePreference_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.talent.v4.LocationFilter parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.LocationFilter parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.LocationFilter parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.LocationFilter parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.LocationFilter parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.LocationFilter parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.LocationFilter parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.LocationFilter parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.LocationFilter parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.LocationFilter parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.LocationFilter parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.LocationFilter parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.talent.v4.LocationFilter prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Geographic region of the search.
   * </pre>
   *
   * Protobuf type {@code google.cloud.talent.v4.LocationFilter}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.talent.v4.LocationFilter)
      com.google.cloud.talent.v4.LocationFilterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.talent.v4.FiltersProto
          .internal_static_google_cloud_talent_v4_LocationFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.talent.v4.FiltersProto
          .internal_static_google_cloud_talent_v4_LocationFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.talent.v4.LocationFilter.class,
              com.google.cloud.talent.v4.LocationFilter.Builder.class);
    }

    // Construct using com.google.cloud.talent.v4.LocationFilter.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      address_ = "";
      regionCode_ = "";
      latLng_ = null;
      if (latLngBuilder_ != null) {
        latLngBuilder_.dispose();
        latLngBuilder_ = null;
      }
      distanceInMiles_ = 0D;
      telecommutePreference_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.talent.v4.FiltersProto
          .internal_static_google_cloud_talent_v4_LocationFilter_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.LocationFilter getDefaultInstanceForType() {
      return com.google.cloud.talent.v4.LocationFilter.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.LocationFilter build() {
      com.google.cloud.talent.v4.LocationFilter result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.LocationFilter buildPartial() {
      com.google.cloud.talent.v4.LocationFilter result =
          new com.google.cloud.talent.v4.LocationFilter(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.talent.v4.LocationFilter result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.address_ = address_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.regionCode_ = regionCode_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.latLng_ = latLngBuilder_ == null ? latLng_ : latLngBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.distanceInMiles_ = distanceInMiles_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.telecommutePreference_ = telecommutePreference_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.talent.v4.LocationFilter) {
        return mergeFrom((com.google.cloud.talent.v4.LocationFilter) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.talent.v4.LocationFilter other) {
      if (other == com.google.cloud.talent.v4.LocationFilter.getDefaultInstance()) return this;
      if (!other.getAddress().isEmpty()) {
        address_ = other.address_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getRegionCode().isEmpty()) {
        regionCode_ = other.regionCode_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasLatLng()) {
        mergeLatLng(other.getLatLng());
      }
      if (other.getDistanceInMiles() != 0D) {
        setDistanceInMiles(other.getDistanceInMiles());
      }
      if (other.telecommutePreference_ != 0) {
        setTelecommutePreferenceValue(other.getTelecommutePreferenceValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                address_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                regionCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getLatLngFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 33:
              {
                distanceInMiles_ = input.readDouble();
                bitField0_ |= 0x00000008;
                break;
              } // case 33
            case 40:
              {
                telecommutePreference_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object address_ = "";
    /**
     *
     *
     * <pre>
     * The address name, such as "Mountain View" or "Bay Area".
     * </pre>
     *
     * <code>string address = 1;</code>
     *
     * @return The address.
     */
    public java.lang.String getAddress() {
      java.lang.Object ref = address_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        address_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The address name, such as "Mountain View" or "Bay Area".
     * </pre>
     *
     * <code>string address = 1;</code>
     *
     * @return The bytes for address.
     */
    public com.google.protobuf.ByteString getAddressBytes() {
      java.lang.Object ref = address_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        address_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The address name, such as "Mountain View" or "Bay Area".
     * </pre>
     *
     * <code>string address = 1;</code>
     *
     * @param value The address to set.
     * @return This builder for chaining.
     */
    public Builder setAddress(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      address_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The address name, such as "Mountain View" or "Bay Area".
     * </pre>
     *
     * <code>string address = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAddress() {
      address_ = getDefaultInstance().getAddress();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The address name, such as "Mountain View" or "Bay Area".
     * </pre>
     *
     * <code>string address = 1;</code>
     *
     * @param value The bytes for address to set.
     * @return This builder for chaining.
     */
    public Builder setAddressBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      address_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object regionCode_ = "";
    /**
     *
     *
     * <pre>
     * CLDR region code of the country/region. This field may be used in two ways:
     *
     * 1) If telecommute preference is not set, this field is used address
     * ambiguity of the user-input address. For example, "Liverpool" may refer to
     * "Liverpool, NY, US" or "Liverpool, UK". This region code biases the
     * address resolution toward a specific country or territory. If this field is
     * not set, address resolution is biased toward the United States by default.
     *
     * 2) If telecommute preference is set to TELECOMMUTE_ALLOWED, the
     * telecommute location filter will be limited to the region specified in this
     * field. If this field is not set, the telecommute job locations will not be
     *
     * See
     * https://unicode-org.github.io/cldr-staging/charts/latest/supplemental/territory_information.html
     * for details. Example: "CH" for Switzerland.
     * </pre>
     *
     * <code>string region_code = 2;</code>
     *
     * @return The regionCode.
     */
    public java.lang.String getRegionCode() {
      java.lang.Object ref = regionCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        regionCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * CLDR region code of the country/region. This field may be used in two ways:
     *
     * 1) If telecommute preference is not set, this field is used address
     * ambiguity of the user-input address. For example, "Liverpool" may refer to
     * "Liverpool, NY, US" or "Liverpool, UK". This region code biases the
     * address resolution toward a specific country or territory. If this field is
     * not set, address resolution is biased toward the United States by default.
     *
     * 2) If telecommute preference is set to TELECOMMUTE_ALLOWED, the
     * telecommute location filter will be limited to the region specified in this
     * field. If this field is not set, the telecommute job locations will not be
     *
     * See
     * https://unicode-org.github.io/cldr-staging/charts/latest/supplemental/territory_information.html
     * for details. Example: "CH" for Switzerland.
     * </pre>
     *
     * <code>string region_code = 2;</code>
     *
     * @return The bytes for regionCode.
     */
    public com.google.protobuf.ByteString getRegionCodeBytes() {
      java.lang.Object ref = regionCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        regionCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * CLDR region code of the country/region. This field may be used in two ways:
     *
     * 1) If telecommute preference is not set, this field is used address
     * ambiguity of the user-input address. For example, "Liverpool" may refer to
     * "Liverpool, NY, US" or "Liverpool, UK". This region code biases the
     * address resolution toward a specific country or territory. If this field is
     * not set, address resolution is biased toward the United States by default.
     *
     * 2) If telecommute preference is set to TELECOMMUTE_ALLOWED, the
     * telecommute location filter will be limited to the region specified in this
     * field. If this field is not set, the telecommute job locations will not be
     *
     * See
     * https://unicode-org.github.io/cldr-staging/charts/latest/supplemental/territory_information.html
     * for details. Example: "CH" for Switzerland.
     * </pre>
     *
     * <code>string region_code = 2;</code>
     *
     * @param value The regionCode to set.
     * @return This builder for chaining.
     */
    public Builder setRegionCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      regionCode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CLDR region code of the country/region. This field may be used in two ways:
     *
     * 1) If telecommute preference is not set, this field is used address
     * ambiguity of the user-input address. For example, "Liverpool" may refer to
     * "Liverpool, NY, US" or "Liverpool, UK". This region code biases the
     * address resolution toward a specific country or territory. If this field is
     * not set, address resolution is biased toward the United States by default.
     *
     * 2) If telecommute preference is set to TELECOMMUTE_ALLOWED, the
     * telecommute location filter will be limited to the region specified in this
     * field. If this field is not set, the telecommute job locations will not be
     *
     * See
     * https://unicode-org.github.io/cldr-staging/charts/latest/supplemental/territory_information.html
     * for details. Example: "CH" for Switzerland.
     * </pre>
     *
     * <code>string region_code = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRegionCode() {
      regionCode_ = getDefaultInstance().getRegionCode();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * CLDR region code of the country/region. This field may be used in two ways:
     *
     * 1) If telecommute preference is not set, this field is used address
     * ambiguity of the user-input address. For example, "Liverpool" may refer to
     * "Liverpool, NY, US" or "Liverpool, UK". This region code biases the
     * address resolution toward a specific country or territory. If this field is
     * not set, address resolution is biased toward the United States by default.
     *
     * 2) If telecommute preference is set to TELECOMMUTE_ALLOWED, the
     * telecommute location filter will be limited to the region specified in this
     * field. If this field is not set, the telecommute job locations will not be
     *
     * See
     * https://unicode-org.github.io/cldr-staging/charts/latest/supplemental/territory_information.html
     * for details. Example: "CH" for Switzerland.
     * </pre>
     *
     * <code>string region_code = 2;</code>
     *
     * @param value The bytes for regionCode to set.
     * @return This builder for chaining.
     */
    public Builder setRegionCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      regionCode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.type.LatLng latLng_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.LatLng, com.google.type.LatLng.Builder, com.google.type.LatLngOrBuilder>
        latLngBuilder_;
    /**
     *
     *
     * <pre>
     * The latitude and longitude of the geographic center to search from. This
     * field is ignored if `address` is provided.
     * </pre>
     *
     * <code>.google.type.LatLng lat_lng = 3;</code>
     *
     * @return Whether the latLng field is set.
     */
    public boolean hasLatLng() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The latitude and longitude of the geographic center to search from. This
     * field is ignored if `address` is provided.
     * </pre>
     *
     * <code>.google.type.LatLng lat_lng = 3;</code>
     *
     * @return The latLng.
     */
    public com.google.type.LatLng getLatLng() {
      if (latLngBuilder_ == null) {
        return latLng_ == null ? com.google.type.LatLng.getDefaultInstance() : latLng_;
      } else {
        return latLngBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The latitude and longitude of the geographic center to search from. This
     * field is ignored if `address` is provided.
     * </pre>
     *
     * <code>.google.type.LatLng lat_lng = 3;</code>
     */
    public Builder setLatLng(com.google.type.LatLng value) {
      if (latLngBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        latLng_ = value;
      } else {
        latLngBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The latitude and longitude of the geographic center to search from. This
     * field is ignored if `address` is provided.
     * </pre>
     *
     * <code>.google.type.LatLng lat_lng = 3;</code>
     */
    public Builder setLatLng(com.google.type.LatLng.Builder builderForValue) {
      if (latLngBuilder_ == null) {
        latLng_ = builderForValue.build();
      } else {
        latLngBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The latitude and longitude of the geographic center to search from. This
     * field is ignored if `address` is provided.
     * </pre>
     *
     * <code>.google.type.LatLng lat_lng = 3;</code>
     */
    public Builder mergeLatLng(com.google.type.LatLng value) {
      if (latLngBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && latLng_ != null
            && latLng_ != com.google.type.LatLng.getDefaultInstance()) {
          getLatLngBuilder().mergeFrom(value);
        } else {
          latLng_ = value;
        }
      } else {
        latLngBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The latitude and longitude of the geographic center to search from. This
     * field is ignored if `address` is provided.
     * </pre>
     *
     * <code>.google.type.LatLng lat_lng = 3;</code>
     */
    public Builder clearLatLng() {
      bitField0_ = (bitField0_ & ~0x00000004);
      latLng_ = null;
      if (latLngBuilder_ != null) {
        latLngBuilder_.dispose();
        latLngBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The latitude and longitude of the geographic center to search from. This
     * field is ignored if `address` is provided.
     * </pre>
     *
     * <code>.google.type.LatLng lat_lng = 3;</code>
     */
    public com.google.type.LatLng.Builder getLatLngBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getLatLngFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The latitude and longitude of the geographic center to search from. This
     * field is ignored if `address` is provided.
     * </pre>
     *
     * <code>.google.type.LatLng lat_lng = 3;</code>
     */
    public com.google.type.LatLngOrBuilder getLatLngOrBuilder() {
      if (latLngBuilder_ != null) {
        return latLngBuilder_.getMessageOrBuilder();
      } else {
        return latLng_ == null ? com.google.type.LatLng.getDefaultInstance() : latLng_;
      }
    }
    /**
     *
     *
     * <pre>
     * The latitude and longitude of the geographic center to search from. This
     * field is ignored if `address` is provided.
     * </pre>
     *
     * <code>.google.type.LatLng lat_lng = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.type.LatLng, com.google.type.LatLng.Builder, com.google.type.LatLngOrBuilder>
        getLatLngFieldBuilder() {
      if (latLngBuilder_ == null) {
        latLngBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.type.LatLng,
                com.google.type.LatLng.Builder,
                com.google.type.LatLngOrBuilder>(getLatLng(), getParentForChildren(), isClean());
        latLng_ = null;
      }
      return latLngBuilder_;
    }

    private double distanceInMiles_;
    /**
     *
     *
     * <pre>
     * The distance_in_miles is applied when the location being searched for is
     * identified as a city or smaller. This field is ignored if the location
     * being searched for is a state or larger.
     * </pre>
     *
     * <code>double distance_in_miles = 4;</code>
     *
     * @return The distanceInMiles.
     */
    @java.lang.Override
    public double getDistanceInMiles() {
      return distanceInMiles_;
    }
    /**
     *
     *
     * <pre>
     * The distance_in_miles is applied when the location being searched for is
     * identified as a city or smaller. This field is ignored if the location
     * being searched for is a state or larger.
     * </pre>
     *
     * <code>double distance_in_miles = 4;</code>
     *
     * @param value The distanceInMiles to set.
     * @return This builder for chaining.
     */
    public Builder setDistanceInMiles(double value) {

      distanceInMiles_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The distance_in_miles is applied when the location being searched for is
     * identified as a city or smaller. This field is ignored if the location
     * being searched for is a state or larger.
     * </pre>
     *
     * <code>double distance_in_miles = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDistanceInMiles() {
      bitField0_ = (bitField0_ & ~0x00000008);
      distanceInMiles_ = 0D;
      onChanged();
      return this;
    }

    private int telecommutePreference_ = 0;
    /**
     *
     *
     * <pre>
     * Allows the client to return jobs without a
     * set location, specifically, telecommuting jobs (telecommuting is considered
     * by the service as a special location).
     * [Job.posting_region][google.cloud.talent.v4.Job.posting_region] indicates
     * if a job permits telecommuting. If this field is set to
     * [TelecommutePreference.TELECOMMUTE_ALLOWED][google.cloud.talent.v4.LocationFilter.TelecommutePreference.TELECOMMUTE_ALLOWED],
     * telecommuting jobs are searched, and
     * [address][google.cloud.talent.v4.LocationFilter.address] and
     * [lat_lng][google.cloud.talent.v4.LocationFilter.lat_lng] are ignored. If
     * not set or set to
     * [TelecommutePreference.TELECOMMUTE_EXCLUDED][google.cloud.talent.v4.LocationFilter.TelecommutePreference.TELECOMMUTE_EXCLUDED],
     * the telecommute status of the jobs is ignored. Jobs that have
     * [PostingRegion.TELECOMMUTE][google.cloud.talent.v4.PostingRegion.TELECOMMUTE]
     * and have additional [Job.addresses][google.cloud.talent.v4.Job.addresses]
     * may still be matched based on other location filters using
     * [address][google.cloud.talent.v4.LocationFilter.address] or [latlng][].
     *
     * This filter can be used by itself to search exclusively for telecommuting
     * jobs, or it can be combined with another location
     * filter to search for a combination of job locations,
     * such as "Mountain View" or "telecommuting" jobs. However, when used in
     * combination with other location filters, telecommuting jobs can be
     * treated as less relevant than other jobs in the search response.
     *
     * This field is only used for job search requests.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.LocationFilter.TelecommutePreference telecommute_preference = 5;
     * </code>
     *
     * @return The enum numeric value on the wire for telecommutePreference.
     */
    @java.lang.Override
    public int getTelecommutePreferenceValue() {
      return telecommutePreference_;
    }
    /**
     *
     *
     * <pre>
     * Allows the client to return jobs without a
     * set location, specifically, telecommuting jobs (telecommuting is considered
     * by the service as a special location).
     * [Job.posting_region][google.cloud.talent.v4.Job.posting_region] indicates
     * if a job permits telecommuting. If this field is set to
     * [TelecommutePreference.TELECOMMUTE_ALLOWED][google.cloud.talent.v4.LocationFilter.TelecommutePreference.TELECOMMUTE_ALLOWED],
     * telecommuting jobs are searched, and
     * [address][google.cloud.talent.v4.LocationFilter.address] and
     * [lat_lng][google.cloud.talent.v4.LocationFilter.lat_lng] are ignored. If
     * not set or set to
     * [TelecommutePreference.TELECOMMUTE_EXCLUDED][google.cloud.talent.v4.LocationFilter.TelecommutePreference.TELECOMMUTE_EXCLUDED],
     * the telecommute status of the jobs is ignored. Jobs that have
     * [PostingRegion.TELECOMMUTE][google.cloud.talent.v4.PostingRegion.TELECOMMUTE]
     * and have additional [Job.addresses][google.cloud.talent.v4.Job.addresses]
     * may still be matched based on other location filters using
     * [address][google.cloud.talent.v4.LocationFilter.address] or [latlng][].
     *
     * This filter can be used by itself to search exclusively for telecommuting
     * jobs, or it can be combined with another location
     * filter to search for a combination of job locations,
     * such as "Mountain View" or "telecommuting" jobs. However, when used in
     * combination with other location filters, telecommuting jobs can be
     * treated as less relevant than other jobs in the search response.
     *
     * This field is only used for job search requests.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.LocationFilter.TelecommutePreference telecommute_preference = 5;
     * </code>
     *
     * @param value The enum numeric value on the wire for telecommutePreference to set.
     * @return This builder for chaining.
     */
    public Builder setTelecommutePreferenceValue(int value) {
      telecommutePreference_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allows the client to return jobs without a
     * set location, specifically, telecommuting jobs (telecommuting is considered
     * by the service as a special location).
     * [Job.posting_region][google.cloud.talent.v4.Job.posting_region] indicates
     * if a job permits telecommuting. If this field is set to
     * [TelecommutePreference.TELECOMMUTE_ALLOWED][google.cloud.talent.v4.LocationFilter.TelecommutePreference.TELECOMMUTE_ALLOWED],
     * telecommuting jobs are searched, and
     * [address][google.cloud.talent.v4.LocationFilter.address] and
     * [lat_lng][google.cloud.talent.v4.LocationFilter.lat_lng] are ignored. If
     * not set or set to
     * [TelecommutePreference.TELECOMMUTE_EXCLUDED][google.cloud.talent.v4.LocationFilter.TelecommutePreference.TELECOMMUTE_EXCLUDED],
     * the telecommute status of the jobs is ignored. Jobs that have
     * [PostingRegion.TELECOMMUTE][google.cloud.talent.v4.PostingRegion.TELECOMMUTE]
     * and have additional [Job.addresses][google.cloud.talent.v4.Job.addresses]
     * may still be matched based on other location filters using
     * [address][google.cloud.talent.v4.LocationFilter.address] or [latlng][].
     *
     * This filter can be used by itself to search exclusively for telecommuting
     * jobs, or it can be combined with another location
     * filter to search for a combination of job locations,
     * such as "Mountain View" or "telecommuting" jobs. However, when used in
     * combination with other location filters, telecommuting jobs can be
     * treated as less relevant than other jobs in the search response.
     *
     * This field is only used for job search requests.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.LocationFilter.TelecommutePreference telecommute_preference = 5;
     * </code>
     *
     * @return The telecommutePreference.
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.LocationFilter.TelecommutePreference
        getTelecommutePreference() {
      com.google.cloud.talent.v4.LocationFilter.TelecommutePreference result =
          com.google.cloud.talent.v4.LocationFilter.TelecommutePreference.forNumber(
              telecommutePreference_);
      return result == null
          ? com.google.cloud.talent.v4.LocationFilter.TelecommutePreference.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Allows the client to return jobs without a
     * set location, specifically, telecommuting jobs (telecommuting is considered
     * by the service as a special location).
     * [Job.posting_region][google.cloud.talent.v4.Job.posting_region] indicates
     * if a job permits telecommuting. If this field is set to
     * [TelecommutePreference.TELECOMMUTE_ALLOWED][google.cloud.talent.v4.LocationFilter.TelecommutePreference.TELECOMMUTE_ALLOWED],
     * telecommuting jobs are searched, and
     * [address][google.cloud.talent.v4.LocationFilter.address] and
     * [lat_lng][google.cloud.talent.v4.LocationFilter.lat_lng] are ignored. If
     * not set or set to
     * [TelecommutePreference.TELECOMMUTE_EXCLUDED][google.cloud.talent.v4.LocationFilter.TelecommutePreference.TELECOMMUTE_EXCLUDED],
     * the telecommute status of the jobs is ignored. Jobs that have
     * [PostingRegion.TELECOMMUTE][google.cloud.talent.v4.PostingRegion.TELECOMMUTE]
     * and have additional [Job.addresses][google.cloud.talent.v4.Job.addresses]
     * may still be matched based on other location filters using
     * [address][google.cloud.talent.v4.LocationFilter.address] or [latlng][].
     *
     * This filter can be used by itself to search exclusively for telecommuting
     * jobs, or it can be combined with another location
     * filter to search for a combination of job locations,
     * such as "Mountain View" or "telecommuting" jobs. However, when used in
     * combination with other location filters, telecommuting jobs can be
     * treated as less relevant than other jobs in the search response.
     *
     * This field is only used for job search requests.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.LocationFilter.TelecommutePreference telecommute_preference = 5;
     * </code>
     *
     * @param value The telecommutePreference to set.
     * @return This builder for chaining.
     */
    public Builder setTelecommutePreference(
        com.google.cloud.talent.v4.LocationFilter.TelecommutePreference value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      telecommutePreference_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Allows the client to return jobs without a
     * set location, specifically, telecommuting jobs (telecommuting is considered
     * by the service as a special location).
     * [Job.posting_region][google.cloud.talent.v4.Job.posting_region] indicates
     * if a job permits telecommuting. If this field is set to
     * [TelecommutePreference.TELECOMMUTE_ALLOWED][google.cloud.talent.v4.LocationFilter.TelecommutePreference.TELECOMMUTE_ALLOWED],
     * telecommuting jobs are searched, and
     * [address][google.cloud.talent.v4.LocationFilter.address] and
     * [lat_lng][google.cloud.talent.v4.LocationFilter.lat_lng] are ignored. If
     * not set or set to
     * [TelecommutePreference.TELECOMMUTE_EXCLUDED][google.cloud.talent.v4.LocationFilter.TelecommutePreference.TELECOMMUTE_EXCLUDED],
     * the telecommute status of the jobs is ignored. Jobs that have
     * [PostingRegion.TELECOMMUTE][google.cloud.talent.v4.PostingRegion.TELECOMMUTE]
     * and have additional [Job.addresses][google.cloud.talent.v4.Job.addresses]
     * may still be matched based on other location filters using
     * [address][google.cloud.talent.v4.LocationFilter.address] or [latlng][].
     *
     * This filter can be used by itself to search exclusively for telecommuting
     * jobs, or it can be combined with another location
     * filter to search for a combination of job locations,
     * such as "Mountain View" or "telecommuting" jobs. However, when used in
     * combination with other location filters, telecommuting jobs can be
     * treated as less relevant than other jobs in the search response.
     *
     * This field is only used for job search requests.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.LocationFilter.TelecommutePreference telecommute_preference = 5;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTelecommutePreference() {
      bitField0_ = (bitField0_ & ~0x00000010);
      telecommutePreference_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.talent.v4.LocationFilter)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.talent.v4.LocationFilter)
  private static final com.google.cloud.talent.v4.LocationFilter DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.talent.v4.LocationFilter();
  }

  public static com.google.cloud.talent.v4.LocationFilter getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<LocationFilter> PARSER =
      new com.google.protobuf.AbstractParser<LocationFilter>() {
        @java.lang.Override
        public LocationFilter parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<LocationFilter> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<LocationFilter> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.talent.v4.LocationFilter getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
