/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/talent/v4/common.proto

package com.google.cloud.talent.v4;

/**
 *
 *
 * <pre>
 * Meta information related to the job searcher or entity
 * conducting the job search. This information is used to improve the
 * performance of the service.
 * </pre>
 *
 * Protobuf type {@code google.cloud.talent.v4.RequestMetadata}
 */
public final class RequestMetadata extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.talent.v4.RequestMetadata)
    RequestMetadataOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RequestMetadata.newBuilder() to construct.
  private RequestMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RequestMetadata() {
    domain_ = "";
    sessionId_ = "";
    userId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RequestMetadata();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.talent.v4.CommonProto
        .internal_static_google_cloud_talent_v4_RequestMetadata_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.talent.v4.CommonProto
        .internal_static_google_cloud_talent_v4_RequestMetadata_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.talent.v4.RequestMetadata.class,
            com.google.cloud.talent.v4.RequestMetadata.Builder.class);
  }

  public static final int DOMAIN_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object domain_ = "";
  /**
   *
   *
   * <pre>
   * Required if
   * [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
   * is unset or `false`.
   *
   * The client-defined scope or source of the service call, which typically
   * is the domain on
   * which the service has been implemented and is currently being run.
   *
   * For example, if the service is being run by client &lt;em&gt;Foo, Inc.&lt;/em&gt;, on
   * job board www.foo.com and career site www.bar.com, then this field is
   * set to "foo.com" for use on the job board, and "bar.com" for use on the
   * career site.
   *
   * Note that any improvements to the model for a particular tenant site rely
   * on this field being set correctly to a unique domain.
   *
   * The maximum number of allowed characters is 255.
   * </pre>
   *
   * <code>string domain = 1;</code>
   *
   * @return The domain.
   */
  @java.lang.Override
  public java.lang.String getDomain() {
    java.lang.Object ref = domain_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      domain_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required if
   * [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
   * is unset or `false`.
   *
   * The client-defined scope or source of the service call, which typically
   * is the domain on
   * which the service has been implemented and is currently being run.
   *
   * For example, if the service is being run by client &lt;em&gt;Foo, Inc.&lt;/em&gt;, on
   * job board www.foo.com and career site www.bar.com, then this field is
   * set to "foo.com" for use on the job board, and "bar.com" for use on the
   * career site.
   *
   * Note that any improvements to the model for a particular tenant site rely
   * on this field being set correctly to a unique domain.
   *
   * The maximum number of allowed characters is 255.
   * </pre>
   *
   * <code>string domain = 1;</code>
   *
   * @return The bytes for domain.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDomainBytes() {
    java.lang.Object ref = domain_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      domain_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SESSION_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sessionId_ = "";
  /**
   *
   *
   * <pre>
   * Required if
   * [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
   * is unset or `false`.
   *
   * A unique session identification string. A session is defined as the
   * duration of an end user's interaction with the service over a certain
   * period.
   * Obfuscate this field for privacy concerns before
   * providing it to the service.
   *
   * Note that any improvements to the model for a particular tenant site rely
   * on this field being set correctly to a unique session ID.
   *
   * The maximum number of allowed characters is 255.
   * </pre>
   *
   * <code>string session_id = 2;</code>
   *
   * @return The sessionId.
   */
  @java.lang.Override
  public java.lang.String getSessionId() {
    java.lang.Object ref = sessionId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sessionId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required if
   * [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
   * is unset or `false`.
   *
   * A unique session identification string. A session is defined as the
   * duration of an end user's interaction with the service over a certain
   * period.
   * Obfuscate this field for privacy concerns before
   * providing it to the service.
   *
   * Note that any improvements to the model for a particular tenant site rely
   * on this field being set correctly to a unique session ID.
   *
   * The maximum number of allowed characters is 255.
   * </pre>
   *
   * <code>string session_id = 2;</code>
   *
   * @return The bytes for sessionId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSessionIdBytes() {
    java.lang.Object ref = sessionId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sessionId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int USER_ID_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object userId_ = "";
  /**
   *
   *
   * <pre>
   * Required if
   * [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
   * is unset or `false`.
   *
   * A unique user identification string, as determined by the client.
   * To have the strongest positive impact on search quality
   * make sure the client-level is unique.
   * Obfuscate this field for privacy concerns before
   * providing it to the service.
   *
   * Note that any improvements to the model for a particular tenant site rely
   * on this field being set correctly to a unique user ID.
   *
   * The maximum number of allowed characters is 255.
   * </pre>
   *
   * <code>string user_id = 3;</code>
   *
   * @return The userId.
   */
  @java.lang.Override
  public java.lang.String getUserId() {
    java.lang.Object ref = userId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      userId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required if
   * [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
   * is unset or `false`.
   *
   * A unique user identification string, as determined by the client.
   * To have the strongest positive impact on search quality
   * make sure the client-level is unique.
   * Obfuscate this field for privacy concerns before
   * providing it to the service.
   *
   * Note that any improvements to the model for a particular tenant site rely
   * on this field being set correctly to a unique user ID.
   *
   * The maximum number of allowed characters is 255.
   * </pre>
   *
   * <code>string user_id = 3;</code>
   *
   * @return The bytes for userId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getUserIdBytes() {
    java.lang.Object ref = userId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      userId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ALLOW_MISSING_IDS_FIELD_NUMBER = 4;
  private boolean allowMissingIds_ = false;
  /**
   *
   *
   * <pre>
   * Only set when any of
   * [domain][google.cloud.talent.v4.RequestMetadata.domain],
   * [session_id][google.cloud.talent.v4.RequestMetadata.session_id] and
   * [user_id][google.cloud.talent.v4.RequestMetadata.user_id] isn't available
   * for some reason. It is highly recommended not to set this field and provide
   * accurate [domain][google.cloud.talent.v4.RequestMetadata.domain],
   * [session_id][google.cloud.talent.v4.RequestMetadata.session_id] and
   * [user_id][google.cloud.talent.v4.RequestMetadata.user_id] for the best
   * service experience.
   * </pre>
   *
   * <code>bool allow_missing_ids = 4;</code>
   *
   * @return The allowMissingIds.
   */
  @java.lang.Override
  public boolean getAllowMissingIds() {
    return allowMissingIds_;
  }

  public static final int DEVICE_INFO_FIELD_NUMBER = 5;
  private com.google.cloud.talent.v4.DeviceInfo deviceInfo_;
  /**
   *
   *
   * <pre>
   * The type of device used by the job seeker at the time of the call to the
   * service.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.DeviceInfo device_info = 5;</code>
   *
   * @return Whether the deviceInfo field is set.
   */
  @java.lang.Override
  public boolean hasDeviceInfo() {
    return deviceInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * The type of device used by the job seeker at the time of the call to the
   * service.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.DeviceInfo device_info = 5;</code>
   *
   * @return The deviceInfo.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.DeviceInfo getDeviceInfo() {
    return deviceInfo_ == null
        ? com.google.cloud.talent.v4.DeviceInfo.getDefaultInstance()
        : deviceInfo_;
  }
  /**
   *
   *
   * <pre>
   * The type of device used by the job seeker at the time of the call to the
   * service.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.DeviceInfo device_info = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.DeviceInfoOrBuilder getDeviceInfoOrBuilder() {
    return deviceInfo_ == null
        ? com.google.cloud.talent.v4.DeviceInfo.getDefaultInstance()
        : deviceInfo_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domain_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, domain_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sessionId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, sessionId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, userId_);
    }
    if (allowMissingIds_ != false) {
      output.writeBool(4, allowMissingIds_);
    }
    if (deviceInfo_ != null) {
      output.writeMessage(5, getDeviceInfo());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(domain_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, domain_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sessionId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, sessionId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(userId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, userId_);
    }
    if (allowMissingIds_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(4, allowMissingIds_);
    }
    if (deviceInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getDeviceInfo());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.talent.v4.RequestMetadata)) {
      return super.equals(obj);
    }
    com.google.cloud.talent.v4.RequestMetadata other =
        (com.google.cloud.talent.v4.RequestMetadata) obj;

    if (!getDomain().equals(other.getDomain())) return false;
    if (!getSessionId().equals(other.getSessionId())) return false;
    if (!getUserId().equals(other.getUserId())) return false;
    if (getAllowMissingIds() != other.getAllowMissingIds()) return false;
    if (hasDeviceInfo() != other.hasDeviceInfo()) return false;
    if (hasDeviceInfo()) {
      if (!getDeviceInfo().equals(other.getDeviceInfo())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DOMAIN_FIELD_NUMBER;
    hash = (53 * hash) + getDomain().hashCode();
    hash = (37 * hash) + SESSION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getSessionId().hashCode();
    hash = (37 * hash) + USER_ID_FIELD_NUMBER;
    hash = (53 * hash) + getUserId().hashCode();
    hash = (37 * hash) + ALLOW_MISSING_IDS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAllowMissingIds());
    if (hasDeviceInfo()) {
      hash = (37 * hash) + DEVICE_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getDeviceInfo().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.talent.v4.RequestMetadata parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.RequestMetadata parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.RequestMetadata parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.RequestMetadata parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.RequestMetadata parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.RequestMetadata parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.RequestMetadata parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.RequestMetadata parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.RequestMetadata parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.RequestMetadata parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.RequestMetadata parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.RequestMetadata parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.talent.v4.RequestMetadata prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Meta information related to the job searcher or entity
   * conducting the job search. This information is used to improve the
   * performance of the service.
   * </pre>
   *
   * Protobuf type {@code google.cloud.talent.v4.RequestMetadata}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.talent.v4.RequestMetadata)
      com.google.cloud.talent.v4.RequestMetadataOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.talent.v4.CommonProto
          .internal_static_google_cloud_talent_v4_RequestMetadata_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.talent.v4.CommonProto
          .internal_static_google_cloud_talent_v4_RequestMetadata_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.talent.v4.RequestMetadata.class,
              com.google.cloud.talent.v4.RequestMetadata.Builder.class);
    }

    // Construct using com.google.cloud.talent.v4.RequestMetadata.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      domain_ = "";
      sessionId_ = "";
      userId_ = "";
      allowMissingIds_ = false;
      deviceInfo_ = null;
      if (deviceInfoBuilder_ != null) {
        deviceInfoBuilder_.dispose();
        deviceInfoBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.talent.v4.CommonProto
          .internal_static_google_cloud_talent_v4_RequestMetadata_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.RequestMetadata getDefaultInstanceForType() {
      return com.google.cloud.talent.v4.RequestMetadata.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.RequestMetadata build() {
      com.google.cloud.talent.v4.RequestMetadata result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.RequestMetadata buildPartial() {
      com.google.cloud.talent.v4.RequestMetadata result =
          new com.google.cloud.talent.v4.RequestMetadata(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.talent.v4.RequestMetadata result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.domain_ = domain_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.sessionId_ = sessionId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.userId_ = userId_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.allowMissingIds_ = allowMissingIds_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.deviceInfo_ = deviceInfoBuilder_ == null ? deviceInfo_ : deviceInfoBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.talent.v4.RequestMetadata) {
        return mergeFrom((com.google.cloud.talent.v4.RequestMetadata) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.talent.v4.RequestMetadata other) {
      if (other == com.google.cloud.talent.v4.RequestMetadata.getDefaultInstance()) return this;
      if (!other.getDomain().isEmpty()) {
        domain_ = other.domain_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getSessionId().isEmpty()) {
        sessionId_ = other.sessionId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getUserId().isEmpty()) {
        userId_ = other.userId_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.getAllowMissingIds() != false) {
        setAllowMissingIds(other.getAllowMissingIds());
      }
      if (other.hasDeviceInfo()) {
        mergeDeviceInfo(other.getDeviceInfo());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                domain_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                sessionId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                userId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                allowMissingIds_ = input.readBool();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                input.readMessage(getDeviceInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object domain_ = "";
    /**
     *
     *
     * <pre>
     * Required if
     * [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
     * is unset or `false`.
     *
     * The client-defined scope or source of the service call, which typically
     * is the domain on
     * which the service has been implemented and is currently being run.
     *
     * For example, if the service is being run by client &lt;em&gt;Foo, Inc.&lt;/em&gt;, on
     * job board www.foo.com and career site www.bar.com, then this field is
     * set to "foo.com" for use on the job board, and "bar.com" for use on the
     * career site.
     *
     * Note that any improvements to the model for a particular tenant site rely
     * on this field being set correctly to a unique domain.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string domain = 1;</code>
     *
     * @return The domain.
     */
    public java.lang.String getDomain() {
      java.lang.Object ref = domain_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        domain_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required if
     * [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
     * is unset or `false`.
     *
     * The client-defined scope or source of the service call, which typically
     * is the domain on
     * which the service has been implemented and is currently being run.
     *
     * For example, if the service is being run by client &lt;em&gt;Foo, Inc.&lt;/em&gt;, on
     * job board www.foo.com and career site www.bar.com, then this field is
     * set to "foo.com" for use on the job board, and "bar.com" for use on the
     * career site.
     *
     * Note that any improvements to the model for a particular tenant site rely
     * on this field being set correctly to a unique domain.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string domain = 1;</code>
     *
     * @return The bytes for domain.
     */
    public com.google.protobuf.ByteString getDomainBytes() {
      java.lang.Object ref = domain_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        domain_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required if
     * [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
     * is unset or `false`.
     *
     * The client-defined scope or source of the service call, which typically
     * is the domain on
     * which the service has been implemented and is currently being run.
     *
     * For example, if the service is being run by client &lt;em&gt;Foo, Inc.&lt;/em&gt;, on
     * job board www.foo.com and career site www.bar.com, then this field is
     * set to "foo.com" for use on the job board, and "bar.com" for use on the
     * career site.
     *
     * Note that any improvements to the model for a particular tenant site rely
     * on this field being set correctly to a unique domain.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string domain = 1;</code>
     *
     * @param value The domain to set.
     * @return This builder for chaining.
     */
    public Builder setDomain(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      domain_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required if
     * [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
     * is unset or `false`.
     *
     * The client-defined scope or source of the service call, which typically
     * is the domain on
     * which the service has been implemented and is currently being run.
     *
     * For example, if the service is being run by client &lt;em&gt;Foo, Inc.&lt;/em&gt;, on
     * job board www.foo.com and career site www.bar.com, then this field is
     * set to "foo.com" for use on the job board, and "bar.com" for use on the
     * career site.
     *
     * Note that any improvements to the model for a particular tenant site rely
     * on this field being set correctly to a unique domain.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string domain = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDomain() {
      domain_ = getDefaultInstance().getDomain();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required if
     * [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
     * is unset or `false`.
     *
     * The client-defined scope or source of the service call, which typically
     * is the domain on
     * which the service has been implemented and is currently being run.
     *
     * For example, if the service is being run by client &lt;em&gt;Foo, Inc.&lt;/em&gt;, on
     * job board www.foo.com and career site www.bar.com, then this field is
     * set to "foo.com" for use on the job board, and "bar.com" for use on the
     * career site.
     *
     * Note that any improvements to the model for a particular tenant site rely
     * on this field being set correctly to a unique domain.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string domain = 1;</code>
     *
     * @param value The bytes for domain to set.
     * @return This builder for chaining.
     */
    public Builder setDomainBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      domain_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object sessionId_ = "";
    /**
     *
     *
     * <pre>
     * Required if
     * [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
     * is unset or `false`.
     *
     * A unique session identification string. A session is defined as the
     * duration of an end user's interaction with the service over a certain
     * period.
     * Obfuscate this field for privacy concerns before
     * providing it to the service.
     *
     * Note that any improvements to the model for a particular tenant site rely
     * on this field being set correctly to a unique session ID.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string session_id = 2;</code>
     *
     * @return The sessionId.
     */
    public java.lang.String getSessionId() {
      java.lang.Object ref = sessionId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sessionId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required if
     * [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
     * is unset or `false`.
     *
     * A unique session identification string. A session is defined as the
     * duration of an end user's interaction with the service over a certain
     * period.
     * Obfuscate this field for privacy concerns before
     * providing it to the service.
     *
     * Note that any improvements to the model for a particular tenant site rely
     * on this field being set correctly to a unique session ID.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string session_id = 2;</code>
     *
     * @return The bytes for sessionId.
     */
    public com.google.protobuf.ByteString getSessionIdBytes() {
      java.lang.Object ref = sessionId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sessionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required if
     * [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
     * is unset or `false`.
     *
     * A unique session identification string. A session is defined as the
     * duration of an end user's interaction with the service over a certain
     * period.
     * Obfuscate this field for privacy concerns before
     * providing it to the service.
     *
     * Note that any improvements to the model for a particular tenant site rely
     * on this field being set correctly to a unique session ID.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string session_id = 2;</code>
     *
     * @param value The sessionId to set.
     * @return This builder for chaining.
     */
    public Builder setSessionId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sessionId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required if
     * [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
     * is unset or `false`.
     *
     * A unique session identification string. A session is defined as the
     * duration of an end user's interaction with the service over a certain
     * period.
     * Obfuscate this field for privacy concerns before
     * providing it to the service.
     *
     * Note that any improvements to the model for a particular tenant site rely
     * on this field being set correctly to a unique session ID.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string session_id = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSessionId() {
      sessionId_ = getDefaultInstance().getSessionId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required if
     * [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
     * is unset or `false`.
     *
     * A unique session identification string. A session is defined as the
     * duration of an end user's interaction with the service over a certain
     * period.
     * Obfuscate this field for privacy concerns before
     * providing it to the service.
     *
     * Note that any improvements to the model for a particular tenant site rely
     * on this field being set correctly to a unique session ID.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string session_id = 2;</code>
     *
     * @param value The bytes for sessionId to set.
     * @return This builder for chaining.
     */
    public Builder setSessionIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sessionId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object userId_ = "";
    /**
     *
     *
     * <pre>
     * Required if
     * [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
     * is unset or `false`.
     *
     * A unique user identification string, as determined by the client.
     * To have the strongest positive impact on search quality
     * make sure the client-level is unique.
     * Obfuscate this field for privacy concerns before
     * providing it to the service.
     *
     * Note that any improvements to the model for a particular tenant site rely
     * on this field being set correctly to a unique user ID.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string user_id = 3;</code>
     *
     * @return The userId.
     */
    public java.lang.String getUserId() {
      java.lang.Object ref = userId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        userId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required if
     * [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
     * is unset or `false`.
     *
     * A unique user identification string, as determined by the client.
     * To have the strongest positive impact on search quality
     * make sure the client-level is unique.
     * Obfuscate this field for privacy concerns before
     * providing it to the service.
     *
     * Note that any improvements to the model for a particular tenant site rely
     * on this field being set correctly to a unique user ID.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string user_id = 3;</code>
     *
     * @return The bytes for userId.
     */
    public com.google.protobuf.ByteString getUserIdBytes() {
      java.lang.Object ref = userId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        userId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required if
     * [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
     * is unset or `false`.
     *
     * A unique user identification string, as determined by the client.
     * To have the strongest positive impact on search quality
     * make sure the client-level is unique.
     * Obfuscate this field for privacy concerns before
     * providing it to the service.
     *
     * Note that any improvements to the model for a particular tenant site rely
     * on this field being set correctly to a unique user ID.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string user_id = 3;</code>
     *
     * @param value The userId to set.
     * @return This builder for chaining.
     */
    public Builder setUserId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      userId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required if
     * [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
     * is unset or `false`.
     *
     * A unique user identification string, as determined by the client.
     * To have the strongest positive impact on search quality
     * make sure the client-level is unique.
     * Obfuscate this field for privacy concerns before
     * providing it to the service.
     *
     * Note that any improvements to the model for a particular tenant site rely
     * on this field being set correctly to a unique user ID.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string user_id = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUserId() {
      userId_ = getDefaultInstance().getUserId();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required if
     * [allow_missing_ids][google.cloud.talent.v4.RequestMetadata.allow_missing_ids]
     * is unset or `false`.
     *
     * A unique user identification string, as determined by the client.
     * To have the strongest positive impact on search quality
     * make sure the client-level is unique.
     * Obfuscate this field for privacy concerns before
     * providing it to the service.
     *
     * Note that any improvements to the model for a particular tenant site rely
     * on this field being set correctly to a unique user ID.
     *
     * The maximum number of allowed characters is 255.
     * </pre>
     *
     * <code>string user_id = 3;</code>
     *
     * @param value The bytes for userId to set.
     * @return This builder for chaining.
     */
    public Builder setUserIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      userId_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private boolean allowMissingIds_;
    /**
     *
     *
     * <pre>
     * Only set when any of
     * [domain][google.cloud.talent.v4.RequestMetadata.domain],
     * [session_id][google.cloud.talent.v4.RequestMetadata.session_id] and
     * [user_id][google.cloud.talent.v4.RequestMetadata.user_id] isn't available
     * for some reason. It is highly recommended not to set this field and provide
     * accurate [domain][google.cloud.talent.v4.RequestMetadata.domain],
     * [session_id][google.cloud.talent.v4.RequestMetadata.session_id] and
     * [user_id][google.cloud.talent.v4.RequestMetadata.user_id] for the best
     * service experience.
     * </pre>
     *
     * <code>bool allow_missing_ids = 4;</code>
     *
     * @return The allowMissingIds.
     */
    @java.lang.Override
    public boolean getAllowMissingIds() {
      return allowMissingIds_;
    }
    /**
     *
     *
     * <pre>
     * Only set when any of
     * [domain][google.cloud.talent.v4.RequestMetadata.domain],
     * [session_id][google.cloud.talent.v4.RequestMetadata.session_id] and
     * [user_id][google.cloud.talent.v4.RequestMetadata.user_id] isn't available
     * for some reason. It is highly recommended not to set this field and provide
     * accurate [domain][google.cloud.talent.v4.RequestMetadata.domain],
     * [session_id][google.cloud.talent.v4.RequestMetadata.session_id] and
     * [user_id][google.cloud.talent.v4.RequestMetadata.user_id] for the best
     * service experience.
     * </pre>
     *
     * <code>bool allow_missing_ids = 4;</code>
     *
     * @param value The allowMissingIds to set.
     * @return This builder for chaining.
     */
    public Builder setAllowMissingIds(boolean value) {

      allowMissingIds_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Only set when any of
     * [domain][google.cloud.talent.v4.RequestMetadata.domain],
     * [session_id][google.cloud.talent.v4.RequestMetadata.session_id] and
     * [user_id][google.cloud.talent.v4.RequestMetadata.user_id] isn't available
     * for some reason. It is highly recommended not to set this field and provide
     * accurate [domain][google.cloud.talent.v4.RequestMetadata.domain],
     * [session_id][google.cloud.talent.v4.RequestMetadata.session_id] and
     * [user_id][google.cloud.talent.v4.RequestMetadata.user_id] for the best
     * service experience.
     * </pre>
     *
     * <code>bool allow_missing_ids = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowMissingIds() {
      bitField0_ = (bitField0_ & ~0x00000008);
      allowMissingIds_ = false;
      onChanged();
      return this;
    }

    private com.google.cloud.talent.v4.DeviceInfo deviceInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.DeviceInfo,
            com.google.cloud.talent.v4.DeviceInfo.Builder,
            com.google.cloud.talent.v4.DeviceInfoOrBuilder>
        deviceInfoBuilder_;
    /**
     *
     *
     * <pre>
     * The type of device used by the job seeker at the time of the call to the
     * service.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.DeviceInfo device_info = 5;</code>
     *
     * @return Whether the deviceInfo field is set.
     */
    public boolean hasDeviceInfo() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The type of device used by the job seeker at the time of the call to the
     * service.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.DeviceInfo device_info = 5;</code>
     *
     * @return The deviceInfo.
     */
    public com.google.cloud.talent.v4.DeviceInfo getDeviceInfo() {
      if (deviceInfoBuilder_ == null) {
        return deviceInfo_ == null
            ? com.google.cloud.talent.v4.DeviceInfo.getDefaultInstance()
            : deviceInfo_;
      } else {
        return deviceInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The type of device used by the job seeker at the time of the call to the
     * service.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.DeviceInfo device_info = 5;</code>
     */
    public Builder setDeviceInfo(com.google.cloud.talent.v4.DeviceInfo value) {
      if (deviceInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deviceInfo_ = value;
      } else {
        deviceInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of device used by the job seeker at the time of the call to the
     * service.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.DeviceInfo device_info = 5;</code>
     */
    public Builder setDeviceInfo(com.google.cloud.talent.v4.DeviceInfo.Builder builderForValue) {
      if (deviceInfoBuilder_ == null) {
        deviceInfo_ = builderForValue.build();
      } else {
        deviceInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of device used by the job seeker at the time of the call to the
     * service.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.DeviceInfo device_info = 5;</code>
     */
    public Builder mergeDeviceInfo(com.google.cloud.talent.v4.DeviceInfo value) {
      if (deviceInfoBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && deviceInfo_ != null
            && deviceInfo_ != com.google.cloud.talent.v4.DeviceInfo.getDefaultInstance()) {
          getDeviceInfoBuilder().mergeFrom(value);
        } else {
          deviceInfo_ = value;
        }
      } else {
        deviceInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of device used by the job seeker at the time of the call to the
     * service.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.DeviceInfo device_info = 5;</code>
     */
    public Builder clearDeviceInfo() {
      bitField0_ = (bitField0_ & ~0x00000010);
      deviceInfo_ = null;
      if (deviceInfoBuilder_ != null) {
        deviceInfoBuilder_.dispose();
        deviceInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The type of device used by the job seeker at the time of the call to the
     * service.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.DeviceInfo device_info = 5;</code>
     */
    public com.google.cloud.talent.v4.DeviceInfo.Builder getDeviceInfoBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getDeviceInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The type of device used by the job seeker at the time of the call to the
     * service.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.DeviceInfo device_info = 5;</code>
     */
    public com.google.cloud.talent.v4.DeviceInfoOrBuilder getDeviceInfoOrBuilder() {
      if (deviceInfoBuilder_ != null) {
        return deviceInfoBuilder_.getMessageOrBuilder();
      } else {
        return deviceInfo_ == null
            ? com.google.cloud.talent.v4.DeviceInfo.getDefaultInstance()
            : deviceInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * The type of device used by the job seeker at the time of the call to the
     * service.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.DeviceInfo device_info = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.DeviceInfo,
            com.google.cloud.talent.v4.DeviceInfo.Builder,
            com.google.cloud.talent.v4.DeviceInfoOrBuilder>
        getDeviceInfoFieldBuilder() {
      if (deviceInfoBuilder_ == null) {
        deviceInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.talent.v4.DeviceInfo,
                com.google.cloud.talent.v4.DeviceInfo.Builder,
                com.google.cloud.talent.v4.DeviceInfoOrBuilder>(
                getDeviceInfo(), getParentForChildren(), isClean());
        deviceInfo_ = null;
      }
      return deviceInfoBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.talent.v4.RequestMetadata)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.talent.v4.RequestMetadata)
  private static final com.google.cloud.talent.v4.RequestMetadata DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.talent.v4.RequestMetadata();
  }

  public static com.google.cloud.talent.v4.RequestMetadata getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RequestMetadata> PARSER =
      new com.google.protobuf.AbstractParser<RequestMetadata>() {
        @java.lang.Override
        public RequestMetadata parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RequestMetadata> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RequestMetadata> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.talent.v4.RequestMetadata getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
