/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/talent/v4/job_service.proto

package com.google.cloud.talent.v4;

/**
 *
 *
 * <pre>
 * The Request body of the `SearchJobs` call.
 * </pre>
 *
 * Protobuf type {@code google.cloud.talent.v4.SearchJobsRequest}
 */
public final class SearchJobsRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.talent.v4.SearchJobsRequest)
    SearchJobsRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SearchJobsRequest.newBuilder() to construct.
  private SearchJobsRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SearchJobsRequest() {
    parent_ = "";
    searchMode_ = 0;
    histogramQueries_ = java.util.Collections.emptyList();
    jobView_ = 0;
    pageToken_ = "";
    orderBy_ = "";
    diversificationLevel_ = 0;
    keywordMatchMode_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SearchJobsRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.talent.v4.JobServiceProto
        .internal_static_google_cloud_talent_v4_SearchJobsRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.talent.v4.JobServiceProto
        .internal_static_google_cloud_talent_v4_SearchJobsRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.talent.v4.SearchJobsRequest.class,
            com.google.cloud.talent.v4.SearchJobsRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * A string-represented enumeration of the job search mode. The service
   * operate differently for different modes of service.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.talent.v4.SearchJobsRequest.SearchMode}
   */
  public enum SearchMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The mode of the search method isn't specified. The default search
     * behavior is identical to JOB_SEARCH search behavior.
     * </pre>
     *
     * <code>SEARCH_MODE_UNSPECIFIED = 0;</code>
     */
    SEARCH_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The job search matches against all jobs, and featured jobs
     * (jobs with promotionValue &gt; 0) are not specially handled.
     * </pre>
     *
     * <code>JOB_SEARCH = 1;</code>
     */
    JOB_SEARCH(1),
    /**
     *
     *
     * <pre>
     * The job search matches only against featured jobs (jobs with a
     * promotionValue &gt; 0). This method doesn't return any jobs having a
     * promotionValue &lt;= 0. The search results order is determined by the
     * promotionValue (jobs with a higher promotionValue are returned higher up
     * in the search results), with relevance being used as a tiebreaker.
     * </pre>
     *
     * <code>FEATURED_JOB_SEARCH = 2;</code>
     */
    FEATURED_JOB_SEARCH(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The mode of the search method isn't specified. The default search
     * behavior is identical to JOB_SEARCH search behavior.
     * </pre>
     *
     * <code>SEARCH_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int SEARCH_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The job search matches against all jobs, and featured jobs
     * (jobs with promotionValue &gt; 0) are not specially handled.
     * </pre>
     *
     * <code>JOB_SEARCH = 1;</code>
     */
    public static final int JOB_SEARCH_VALUE = 1;
    /**
     *
     *
     * <pre>
     * The job search matches only against featured jobs (jobs with a
     * promotionValue &gt; 0). This method doesn't return any jobs having a
     * promotionValue &lt;= 0. The search results order is determined by the
     * promotionValue (jobs with a higher promotionValue are returned higher up
     * in the search results), with relevance being used as a tiebreaker.
     * </pre>
     *
     * <code>FEATURED_JOB_SEARCH = 2;</code>
     */
    public static final int FEATURED_JOB_SEARCH_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SearchMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static SearchMode forNumber(int value) {
      switch (value) {
        case 0:
          return SEARCH_MODE_UNSPECIFIED;
        case 1:
          return JOB_SEARCH;
        case 2:
          return FEATURED_JOB_SEARCH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<SearchMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<SearchMode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<SearchMode>() {
          public SearchMode findValueByNumber(int number) {
            return SearchMode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.talent.v4.SearchJobsRequest.getDescriptor().getEnumTypes().get(0);
    }

    private static final SearchMode[] VALUES = values();

    public static SearchMode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private SearchMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.talent.v4.SearchJobsRequest.SearchMode)
  }

  /**
   *
   *
   * <pre>
   * Controls whether highly similar jobs are returned next to each other in
   * the search results. Jobs are identified as highly similar based on
   * their titles, job categories, and locations. Highly similar results are
   * clustered so that only one representative job of the cluster is
   * displayed to the job seeker higher up in the results, with the other jobs
   * being displayed lower down in the results.
   *
   * If you are using pageToken to page through the result set,
   * latency might be lower but we can't guarantee that all results are
   * returned. If you are using page offset, latency might be higher but all
   * results are returned.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel}
   */
  public enum DiversificationLevel implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The diversification level isn't specified.
     * </pre>
     *
     * <code>DIVERSIFICATION_LEVEL_UNSPECIFIED = 0;</code>
     */
    DIVERSIFICATION_LEVEL_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Disables diversification. Jobs that would normally be pushed to the last
     * page would not have their positions altered. This may result in highly
     * similar jobs appearing in sequence in the search results.
     * </pre>
     *
     * <code>DISABLED = 1;</code>
     */
    DISABLED(1),
    /**
     *
     *
     * <pre>
     * Default diversifying behavior. The result list is ordered so that
     * highly similar results are pushed to the end of the last page of search
     * results.
     * </pre>
     *
     * <code>SIMPLE = 2;</code>
     */
    SIMPLE(2),
    /**
     *
     *
     * <pre>
     * Only one job from the same company will be shown at once, other jobs
     * under same company are pushed to the end of the last page of search
     * result.
     * </pre>
     *
     * <code>ONE_PER_COMPANY = 3;</code>
     */
    ONE_PER_COMPANY(3),
    /**
     *
     *
     * <pre>
     * Similar to ONE_PER_COMPANY, but it allows at most two jobs in the
     * same company to be shown at once, the other jobs under same company are
     * pushed to the end of the last page of search result.
     * </pre>
     *
     * <code>TWO_PER_COMPANY = 4;</code>
     */
    TWO_PER_COMPANY(4),
    /**
     *
     *
     * <pre>
     * Similar to ONE_PER_COMPANY, but it allows at most three jobs in the
     * same company to be shown at once, the other jobs under same company are
     * dropped.
     * </pre>
     *
     * <code>MAX_THREE_PER_COMPANY = 6;</code>
     */
    MAX_THREE_PER_COMPANY(6),
    /**
     *
     *
     * <pre>
     * The result list is ordered such that somewhat similar results are pushed
     * to the end of the last page of the search results. This option is
     * recommended if SIMPLE diversification does not diversify enough.
     * </pre>
     *
     * <code>DIVERSIFY_BY_LOOSER_SIMILARITY = 5;</code>
     */
    DIVERSIFY_BY_LOOSER_SIMILARITY(5),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The diversification level isn't specified.
     * </pre>
     *
     * <code>DIVERSIFICATION_LEVEL_UNSPECIFIED = 0;</code>
     */
    public static final int DIVERSIFICATION_LEVEL_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Disables diversification. Jobs that would normally be pushed to the last
     * page would not have their positions altered. This may result in highly
     * similar jobs appearing in sequence in the search results.
     * </pre>
     *
     * <code>DISABLED = 1;</code>
     */
    public static final int DISABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Default diversifying behavior. The result list is ordered so that
     * highly similar results are pushed to the end of the last page of search
     * results.
     * </pre>
     *
     * <code>SIMPLE = 2;</code>
     */
    public static final int SIMPLE_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Only one job from the same company will be shown at once, other jobs
     * under same company are pushed to the end of the last page of search
     * result.
     * </pre>
     *
     * <code>ONE_PER_COMPANY = 3;</code>
     */
    public static final int ONE_PER_COMPANY_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Similar to ONE_PER_COMPANY, but it allows at most two jobs in the
     * same company to be shown at once, the other jobs under same company are
     * pushed to the end of the last page of search result.
     * </pre>
     *
     * <code>TWO_PER_COMPANY = 4;</code>
     */
    public static final int TWO_PER_COMPANY_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Similar to ONE_PER_COMPANY, but it allows at most three jobs in the
     * same company to be shown at once, the other jobs under same company are
     * dropped.
     * </pre>
     *
     * <code>MAX_THREE_PER_COMPANY = 6;</code>
     */
    public static final int MAX_THREE_PER_COMPANY_VALUE = 6;
    /**
     *
     *
     * <pre>
     * The result list is ordered such that somewhat similar results are pushed
     * to the end of the last page of the search results. This option is
     * recommended if SIMPLE diversification does not diversify enough.
     * </pre>
     *
     * <code>DIVERSIFY_BY_LOOSER_SIMILARITY = 5;</code>
     */
    public static final int DIVERSIFY_BY_LOOSER_SIMILARITY_VALUE = 5;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DiversificationLevel valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static DiversificationLevel forNumber(int value) {
      switch (value) {
        case 0:
          return DIVERSIFICATION_LEVEL_UNSPECIFIED;
        case 1:
          return DISABLED;
        case 2:
          return SIMPLE;
        case 3:
          return ONE_PER_COMPANY;
        case 4:
          return TWO_PER_COMPANY;
        case 6:
          return MAX_THREE_PER_COMPANY;
        case 5:
          return DIVERSIFY_BY_LOOSER_SIMILARITY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<DiversificationLevel>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<DiversificationLevel>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<DiversificationLevel>() {
              public DiversificationLevel findValueByNumber(int number) {
                return DiversificationLevel.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.talent.v4.SearchJobsRequest.getDescriptor().getEnumTypes().get(1);
    }

    private static final DiversificationLevel[] VALUES = values();

    public static DiversificationLevel valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private DiversificationLevel(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel)
  }

  /**
   *
   *
   * <pre>
   * Controls what keyword matching behavior the search has. When keyword
   * matching is enabled, a keyword match returns jobs that may not match given
   * category filters when there are matching keywords. For example, for the
   * query "program manager" with KeywordMatchMode set to KEYWORD_MATCH_ALL, a
   * job posting with the title "software developer," which doesn't fall into
   * "program manager" ontology, and "program manager" appearing in its
   * description will be surfaced.
   *
   * For queries like "cloud" that don't contain title or
   * location specific ontology, jobs with "cloud" keyword matches are returned
   * regardless of this enum's value.
   *
   * Use
   * [Company.keyword_searchable_job_custom_attributes][google.cloud.talent.v4.Company.keyword_searchable_job_custom_attributes]
   * if company-specific globally matched custom field/attribute string values
   * are needed. Enabling keyword match improves recall of subsequent search
   * requests.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode}
   */
  public enum KeywordMatchMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The keyword match option isn't specified. Defaults to
     * [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL]
     * behavior.
     * </pre>
     *
     * <code>KEYWORD_MATCH_MODE_UNSPECIFIED = 0;</code>
     */
    KEYWORD_MATCH_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Disables keyword matching.
     * </pre>
     *
     * <code>KEYWORD_MATCH_DISABLED = 1;</code>
     */
    KEYWORD_MATCH_DISABLED(1),
    /**
     *
     *
     * <pre>
     * Enable keyword matching over
     * [Job.title][google.cloud.talent.v4.Job.title],
     * [Job.description][google.cloud.talent.v4.Job.description],
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name],
     * [Job.addresses][google.cloud.talent.v4.Job.addresses],
     * [Job.qualifications][google.cloud.talent.v4.Job.qualifications], and
     * keyword searchable
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes]
     * fields.
     * </pre>
     *
     * <code>KEYWORD_MATCH_ALL = 2;</code>
     */
    KEYWORD_MATCH_ALL(2),
    /**
     *
     *
     * <pre>
     * Only enable keyword matching over
     * [Job.title][google.cloud.talent.v4.Job.title].
     * </pre>
     *
     * <code>KEYWORD_MATCH_TITLE_ONLY = 3;</code>
     */
    KEYWORD_MATCH_TITLE_ONLY(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The keyword match option isn't specified. Defaults to
     * [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL]
     * behavior.
     * </pre>
     *
     * <code>KEYWORD_MATCH_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int KEYWORD_MATCH_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Disables keyword matching.
     * </pre>
     *
     * <code>KEYWORD_MATCH_DISABLED = 1;</code>
     */
    public static final int KEYWORD_MATCH_DISABLED_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Enable keyword matching over
     * [Job.title][google.cloud.talent.v4.Job.title],
     * [Job.description][google.cloud.talent.v4.Job.description],
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name],
     * [Job.addresses][google.cloud.talent.v4.Job.addresses],
     * [Job.qualifications][google.cloud.talent.v4.Job.qualifications], and
     * keyword searchable
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes]
     * fields.
     * </pre>
     *
     * <code>KEYWORD_MATCH_ALL = 2;</code>
     */
    public static final int KEYWORD_MATCH_ALL_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Only enable keyword matching over
     * [Job.title][google.cloud.talent.v4.Job.title].
     * </pre>
     *
     * <code>KEYWORD_MATCH_TITLE_ONLY = 3;</code>
     */
    public static final int KEYWORD_MATCH_TITLE_ONLY_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static KeywordMatchMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static KeywordMatchMode forNumber(int value) {
      switch (value) {
        case 0:
          return KEYWORD_MATCH_MODE_UNSPECIFIED;
        case 1:
          return KEYWORD_MATCH_DISABLED;
        case 2:
          return KEYWORD_MATCH_ALL;
        case 3:
          return KEYWORD_MATCH_TITLE_ONLY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<KeywordMatchMode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<KeywordMatchMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<KeywordMatchMode>() {
              public KeywordMatchMode findValueByNumber(int number) {
                return KeywordMatchMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.talent.v4.SearchJobsRequest.getDescriptor().getEnumTypes().get(2);
    }

    private static final KeywordMatchMode[] VALUES = values();

    public static KeywordMatchMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private KeywordMatchMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode)
  }

  public interface CustomRankingInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Controls over how important the score of
     * [CustomRankingInfo.ranking_expression][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ranking_expression]
     * gets applied to job's final ranking position.
     *
     * An error is thrown if not specified.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel importance_level = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for importanceLevel.
     */
    int getImportanceLevelValue();
    /**
     *
     *
     * <pre>
     * Required. Controls over how important the score of
     * [CustomRankingInfo.ranking_expression][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ranking_expression]
     * gets applied to job's final ranking position.
     *
     * An error is thrown if not specified.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel importance_level = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The importanceLevel.
     */
    com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel
        getImportanceLevel();

    /**
     *
     *
     * <pre>
     * Required. Controls over how job documents get ranked on top of existing
     * relevance score (determined by API algorithm). A combination of the
     * ranking expression and relevance score is used to determine job's final
     * ranking position.
     *
     * The syntax for this expression is a subset of Google SQL syntax.
     *
     * Supported operators are: +, -, *, /, where the left and right side of
     * the operator is either a numeric
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes]
     * key, integer/double value or an expression that can be evaluated to a
     * number.
     *
     * Parenthesis are supported to adjust calculation precedence. The
     * expression must be &lt; 200 characters in length.
     *
     * The expression is considered invalid for a job if the expression
     * references custom attributes that are not populated on the job or if the
     * expression results in a divide by zero. If an expression is invalid for a
     * job, that job is demoted to the end of the results.
     *
     * Sample ranking expression
     * (year + 25) * 0.25 - (freshness / 0.5)
     * </pre>
     *
     * <code>string ranking_expression = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The rankingExpression.
     */
    java.lang.String getRankingExpression();
    /**
     *
     *
     * <pre>
     * Required. Controls over how job documents get ranked on top of existing
     * relevance score (determined by API algorithm). A combination of the
     * ranking expression and relevance score is used to determine job's final
     * ranking position.
     *
     * The syntax for this expression is a subset of Google SQL syntax.
     *
     * Supported operators are: +, -, *, /, where the left and right side of
     * the operator is either a numeric
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes]
     * key, integer/double value or an expression that can be evaluated to a
     * number.
     *
     * Parenthesis are supported to adjust calculation precedence. The
     * expression must be &lt; 200 characters in length.
     *
     * The expression is considered invalid for a job if the expression
     * references custom attributes that are not populated on the job or if the
     * expression results in a divide by zero. If an expression is invalid for a
     * job, that job is demoted to the end of the results.
     *
     * Sample ranking expression
     * (year + 25) * 0.25 - (freshness / 0.5)
     * </pre>
     *
     * <code>string ranking_expression = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for rankingExpression.
     */
    com.google.protobuf.ByteString getRankingExpressionBytes();
  }
  /**
   *
   *
   * <pre>
   * Custom ranking information for
   * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
   * </pre>
   *
   * Protobuf type {@code google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo}
   */
  public static final class CustomRankingInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo)
      CustomRankingInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CustomRankingInfo.newBuilder() to construct.
    private CustomRankingInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CustomRankingInfo() {
      importanceLevel_ = 0;
      rankingExpression_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CustomRankingInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.talent.v4.JobServiceProto
          .internal_static_google_cloud_talent_v4_SearchJobsRequest_CustomRankingInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.talent.v4.JobServiceProto
          .internal_static_google_cloud_talent_v4_SearchJobsRequest_CustomRankingInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.class,
              com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The importance level for
     * [CustomRankingInfo.ranking_expression][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ranking_expression].
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel}
     */
    public enum ImportanceLevel implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Default value if the importance level isn't specified.
       * </pre>
       *
       * <code>IMPORTANCE_LEVEL_UNSPECIFIED = 0;</code>
       */
      IMPORTANCE_LEVEL_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The given ranking expression is of None importance, existing relevance
       * score (determined by API algorithm) dominates job's final ranking
       * position.
       * </pre>
       *
       * <code>NONE = 1;</code>
       */
      NONE(1),
      /**
       *
       *
       * <pre>
       * The given ranking expression is of Low importance in terms of job's
       * final ranking position compared to existing relevance
       * score (determined by API algorithm).
       * </pre>
       *
       * <code>LOW = 2;</code>
       */
      LOW(2),
      /**
       *
       *
       * <pre>
       * The given ranking expression is of Mild importance in terms of job's
       * final ranking position compared to existing relevance
       * score (determined by API algorithm).
       * </pre>
       *
       * <code>MILD = 3;</code>
       */
      MILD(3),
      /**
       *
       *
       * <pre>
       * The given ranking expression is of Medium importance in terms of job's
       * final ranking position compared to existing relevance
       * score (determined by API algorithm).
       * </pre>
       *
       * <code>MEDIUM = 4;</code>
       */
      MEDIUM(4),
      /**
       *
       *
       * <pre>
       * The given ranking expression is of High importance in terms of job's
       * final ranking position compared to existing relevance
       * score (determined by API algorithm).
       * </pre>
       *
       * <code>HIGH = 5;</code>
       */
      HIGH(5),
      /**
       *
       *
       * <pre>
       * The given ranking expression is of Extreme importance, and dominates
       * job's final ranking position with existing relevance
       * score (determined by API algorithm) ignored.
       * </pre>
       *
       * <code>EXTREME = 6;</code>
       */
      EXTREME(6),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Default value if the importance level isn't specified.
       * </pre>
       *
       * <code>IMPORTANCE_LEVEL_UNSPECIFIED = 0;</code>
       */
      public static final int IMPORTANCE_LEVEL_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * The given ranking expression is of None importance, existing relevance
       * score (determined by API algorithm) dominates job's final ranking
       * position.
       * </pre>
       *
       * <code>NONE = 1;</code>
       */
      public static final int NONE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * The given ranking expression is of Low importance in terms of job's
       * final ranking position compared to existing relevance
       * score (determined by API algorithm).
       * </pre>
       *
       * <code>LOW = 2;</code>
       */
      public static final int LOW_VALUE = 2;
      /**
       *
       *
       * <pre>
       * The given ranking expression is of Mild importance in terms of job's
       * final ranking position compared to existing relevance
       * score (determined by API algorithm).
       * </pre>
       *
       * <code>MILD = 3;</code>
       */
      public static final int MILD_VALUE = 3;
      /**
       *
       *
       * <pre>
       * The given ranking expression is of Medium importance in terms of job's
       * final ranking position compared to existing relevance
       * score (determined by API algorithm).
       * </pre>
       *
       * <code>MEDIUM = 4;</code>
       */
      public static final int MEDIUM_VALUE = 4;
      /**
       *
       *
       * <pre>
       * The given ranking expression is of High importance in terms of job's
       * final ranking position compared to existing relevance
       * score (determined by API algorithm).
       * </pre>
       *
       * <code>HIGH = 5;</code>
       */
      public static final int HIGH_VALUE = 5;
      /**
       *
       *
       * <pre>
       * The given ranking expression is of Extreme importance, and dominates
       * job's final ranking position with existing relevance
       * score (determined by API algorithm) ignored.
       * </pre>
       *
       * <code>EXTREME = 6;</code>
       */
      public static final int EXTREME_VALUE = 6;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ImportanceLevel valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ImportanceLevel forNumber(int value) {
        switch (value) {
          case 0:
            return IMPORTANCE_LEVEL_UNSPECIFIED;
          case 1:
            return NONE;
          case 2:
            return LOW;
          case 3:
            return MILD;
          case 4:
            return MEDIUM;
          case 5:
            return HIGH;
          case 6:
            return EXTREME;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ImportanceLevel>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<ImportanceLevel>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<ImportanceLevel>() {
                public ImportanceLevel findValueByNumber(int number) {
                  return ImportanceLevel.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final ImportanceLevel[] VALUES = values();

      public static ImportanceLevel valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ImportanceLevel(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel)
    }

    public static final int IMPORTANCE_LEVEL_FIELD_NUMBER = 1;
    private int importanceLevel_ = 0;
    /**
     *
     *
     * <pre>
     * Required. Controls over how important the score of
     * [CustomRankingInfo.ranking_expression][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ranking_expression]
     * gets applied to job's final ranking position.
     *
     * An error is thrown if not specified.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel importance_level = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for importanceLevel.
     */
    @java.lang.Override
    public int getImportanceLevelValue() {
      return importanceLevel_;
    }
    /**
     *
     *
     * <pre>
     * Required. Controls over how important the score of
     * [CustomRankingInfo.ranking_expression][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ranking_expression]
     * gets applied to job's final ranking position.
     *
     * An error is thrown if not specified.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel importance_level = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The importanceLevel.
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel
        getImportanceLevel() {
      com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel result =
          com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel.forNumber(
              importanceLevel_);
      return result == null
          ? com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel
              .UNRECOGNIZED
          : result;
    }

    public static final int RANKING_EXPRESSION_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object rankingExpression_ = "";
    /**
     *
     *
     * <pre>
     * Required. Controls over how job documents get ranked on top of existing
     * relevance score (determined by API algorithm). A combination of the
     * ranking expression and relevance score is used to determine job's final
     * ranking position.
     *
     * The syntax for this expression is a subset of Google SQL syntax.
     *
     * Supported operators are: +, -, *, /, where the left and right side of
     * the operator is either a numeric
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes]
     * key, integer/double value or an expression that can be evaluated to a
     * number.
     *
     * Parenthesis are supported to adjust calculation precedence. The
     * expression must be &lt; 200 characters in length.
     *
     * The expression is considered invalid for a job if the expression
     * references custom attributes that are not populated on the job or if the
     * expression results in a divide by zero. If an expression is invalid for a
     * job, that job is demoted to the end of the results.
     *
     * Sample ranking expression
     * (year + 25) * 0.25 - (freshness / 0.5)
     * </pre>
     *
     * <code>string ranking_expression = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The rankingExpression.
     */
    @java.lang.Override
    public java.lang.String getRankingExpression() {
      java.lang.Object ref = rankingExpression_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        rankingExpression_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Controls over how job documents get ranked on top of existing
     * relevance score (determined by API algorithm). A combination of the
     * ranking expression and relevance score is used to determine job's final
     * ranking position.
     *
     * The syntax for this expression is a subset of Google SQL syntax.
     *
     * Supported operators are: +, -, *, /, where the left and right side of
     * the operator is either a numeric
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes]
     * key, integer/double value or an expression that can be evaluated to a
     * number.
     *
     * Parenthesis are supported to adjust calculation precedence. The
     * expression must be &lt; 200 characters in length.
     *
     * The expression is considered invalid for a job if the expression
     * references custom attributes that are not populated on the job or if the
     * expression results in a divide by zero. If an expression is invalid for a
     * job, that job is demoted to the end of the results.
     *
     * Sample ranking expression
     * (year + 25) * 0.25 - (freshness / 0.5)
     * </pre>
     *
     * <code>string ranking_expression = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for rankingExpression.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRankingExpressionBytes() {
      java.lang.Object ref = rankingExpression_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        rankingExpression_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (importanceLevel_
          != com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel
              .IMPORTANCE_LEVEL_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, importanceLevel_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rankingExpression_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, rankingExpression_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (importanceLevel_
          != com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel
              .IMPORTANCE_LEVEL_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, importanceLevel_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(rankingExpression_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, rankingExpression_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo other =
          (com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo) obj;

      if (importanceLevel_ != other.importanceLevel_) return false;
      if (!getRankingExpression().equals(other.getRankingExpression())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + IMPORTANCE_LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + importanceLevel_;
      hash = (37 * hash) + RANKING_EXPRESSION_FIELD_NUMBER;
      hash = (53 * hash) + getRankingExpression().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Custom ranking information for
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * Protobuf type {@code google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo)
        com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.talent.v4.JobServiceProto
            .internal_static_google_cloud_talent_v4_SearchJobsRequest_CustomRankingInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.talent.v4.JobServiceProto
            .internal_static_google_cloud_talent_v4_SearchJobsRequest_CustomRankingInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.class,
                com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.Builder.class);
      }

      // Construct using com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        importanceLevel_ = 0;
        rankingExpression_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.talent.v4.JobServiceProto
            .internal_static_google_cloud_talent_v4_SearchJobsRequest_CustomRankingInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo
          getDefaultInstanceForType() {
        return com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo build() {
        com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo buildPartial() {
        com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo result =
            new com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.importanceLevel_ = importanceLevel_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.rankingExpression_ = rankingExpression_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo) {
          return mergeFrom((com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo other) {
        if (other
            == com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.getDefaultInstance())
          return this;
        if (other.importanceLevel_ != 0) {
          setImportanceLevelValue(other.getImportanceLevelValue());
        }
        if (!other.getRankingExpression().isEmpty()) {
          rankingExpression_ = other.rankingExpression_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  importanceLevel_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  rankingExpression_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int importanceLevel_ = 0;
      /**
       *
       *
       * <pre>
       * Required. Controls over how important the score of
       * [CustomRankingInfo.ranking_expression][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ranking_expression]
       * gets applied to job's final ranking position.
       *
       * An error is thrown if not specified.
       * </pre>
       *
       * <code>
       * .google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel importance_level = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for importanceLevel.
       */
      @java.lang.Override
      public int getImportanceLevelValue() {
        return importanceLevel_;
      }
      /**
       *
       *
       * <pre>
       * Required. Controls over how important the score of
       * [CustomRankingInfo.ranking_expression][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ranking_expression]
       * gets applied to job's final ranking position.
       *
       * An error is thrown if not specified.
       * </pre>
       *
       * <code>
       * .google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel importance_level = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for importanceLevel to set.
       * @return This builder for chaining.
       */
      public Builder setImportanceLevelValue(int value) {
        importanceLevel_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Controls over how important the score of
       * [CustomRankingInfo.ranking_expression][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ranking_expression]
       * gets applied to job's final ranking position.
       *
       * An error is thrown if not specified.
       * </pre>
       *
       * <code>
       * .google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel importance_level = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The importanceLevel.
       */
      @java.lang.Override
      public com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel
          getImportanceLevel() {
        com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel result =
            com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel
                .forNumber(importanceLevel_);
        return result == null
            ? com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel
                .UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Required. Controls over how important the score of
       * [CustomRankingInfo.ranking_expression][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ranking_expression]
       * gets applied to job's final ranking position.
       *
       * An error is thrown if not specified.
       * </pre>
       *
       * <code>
       * .google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel importance_level = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The importanceLevel to set.
       * @return This builder for chaining.
       */
      public Builder setImportanceLevel(
          com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        importanceLevel_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Controls over how important the score of
       * [CustomRankingInfo.ranking_expression][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ranking_expression]
       * gets applied to job's final ranking position.
       *
       * An error is thrown if not specified.
       * </pre>
       *
       * <code>
       * .google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ImportanceLevel importance_level = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearImportanceLevel() {
        bitField0_ = (bitField0_ & ~0x00000001);
        importanceLevel_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object rankingExpression_ = "";
      /**
       *
       *
       * <pre>
       * Required. Controls over how job documents get ranked on top of existing
       * relevance score (determined by API algorithm). A combination of the
       * ranking expression and relevance score is used to determine job's final
       * ranking position.
       *
       * The syntax for this expression is a subset of Google SQL syntax.
       *
       * Supported operators are: +, -, *, /, where the left and right side of
       * the operator is either a numeric
       * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes]
       * key, integer/double value or an expression that can be evaluated to a
       * number.
       *
       * Parenthesis are supported to adjust calculation precedence. The
       * expression must be &lt; 200 characters in length.
       *
       * The expression is considered invalid for a job if the expression
       * references custom attributes that are not populated on the job or if the
       * expression results in a divide by zero. If an expression is invalid for a
       * job, that job is demoted to the end of the results.
       *
       * Sample ranking expression
       * (year + 25) * 0.25 - (freshness / 0.5)
       * </pre>
       *
       * <code>string ranking_expression = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The rankingExpression.
       */
      public java.lang.String getRankingExpression() {
        java.lang.Object ref = rankingExpression_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          rankingExpression_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Controls over how job documents get ranked on top of existing
       * relevance score (determined by API algorithm). A combination of the
       * ranking expression and relevance score is used to determine job's final
       * ranking position.
       *
       * The syntax for this expression is a subset of Google SQL syntax.
       *
       * Supported operators are: +, -, *, /, where the left and right side of
       * the operator is either a numeric
       * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes]
       * key, integer/double value or an expression that can be evaluated to a
       * number.
       *
       * Parenthesis are supported to adjust calculation precedence. The
       * expression must be &lt; 200 characters in length.
       *
       * The expression is considered invalid for a job if the expression
       * references custom attributes that are not populated on the job or if the
       * expression results in a divide by zero. If an expression is invalid for a
       * job, that job is demoted to the end of the results.
       *
       * Sample ranking expression
       * (year + 25) * 0.25 - (freshness / 0.5)
       * </pre>
       *
       * <code>string ranking_expression = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for rankingExpression.
       */
      public com.google.protobuf.ByteString getRankingExpressionBytes() {
        java.lang.Object ref = rankingExpression_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          rankingExpression_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. Controls over how job documents get ranked on top of existing
       * relevance score (determined by API algorithm). A combination of the
       * ranking expression and relevance score is used to determine job's final
       * ranking position.
       *
       * The syntax for this expression is a subset of Google SQL syntax.
       *
       * Supported operators are: +, -, *, /, where the left and right side of
       * the operator is either a numeric
       * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes]
       * key, integer/double value or an expression that can be evaluated to a
       * number.
       *
       * Parenthesis are supported to adjust calculation precedence. The
       * expression must be &lt; 200 characters in length.
       *
       * The expression is considered invalid for a job if the expression
       * references custom attributes that are not populated on the job or if the
       * expression results in a divide by zero. If an expression is invalid for a
       * job, that job is demoted to the end of the results.
       *
       * Sample ranking expression
       * (year + 25) * 0.25 - (freshness / 0.5)
       * </pre>
       *
       * <code>string ranking_expression = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The rankingExpression to set.
       * @return This builder for chaining.
       */
      public Builder setRankingExpression(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        rankingExpression_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Controls over how job documents get ranked on top of existing
       * relevance score (determined by API algorithm). A combination of the
       * ranking expression and relevance score is used to determine job's final
       * ranking position.
       *
       * The syntax for this expression is a subset of Google SQL syntax.
       *
       * Supported operators are: +, -, *, /, where the left and right side of
       * the operator is either a numeric
       * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes]
       * key, integer/double value or an expression that can be evaluated to a
       * number.
       *
       * Parenthesis are supported to adjust calculation precedence. The
       * expression must be &lt; 200 characters in length.
       *
       * The expression is considered invalid for a job if the expression
       * references custom attributes that are not populated on the job or if the
       * expression results in a divide by zero. If an expression is invalid for a
       * job, that job is demoted to the end of the results.
       *
       * Sample ranking expression
       * (year + 25) * 0.25 - (freshness / 0.5)
       * </pre>
       *
       * <code>string ranking_expression = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRankingExpression() {
        rankingExpression_ = getDefaultInstance().getRankingExpression();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. Controls over how job documents get ranked on top of existing
       * relevance score (determined by API algorithm). A combination of the
       * ranking expression and relevance score is used to determine job's final
       * ranking position.
       *
       * The syntax for this expression is a subset of Google SQL syntax.
       *
       * Supported operators are: +, -, *, /, where the left and right side of
       * the operator is either a numeric
       * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes]
       * key, integer/double value or an expression that can be evaluated to a
       * number.
       *
       * Parenthesis are supported to adjust calculation precedence. The
       * expression must be &lt; 200 characters in length.
       *
       * The expression is considered invalid for a job if the expression
       * references custom attributes that are not populated on the job or if the
       * expression results in a divide by zero. If an expression is invalid for a
       * job, that job is demoted to the end of the results.
       *
       * Sample ranking expression
       * (year + 25) * 0.25 - (freshness / 0.5)
       * </pre>
       *
       * <code>string ranking_expression = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for rankingExpression to set.
       * @return This builder for chaining.
       */
      public Builder setRankingExpressionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        rankingExpression_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo)
    private static final com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo();
    }

    public static com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CustomRankingInfo> PARSER =
        new com.google.protobuf.AbstractParser<CustomRankingInfo>() {
          @java.lang.Override
          public CustomRankingInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CustomRankingInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CustomRankingInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the tenant to search within.
   *
   * The format is "projects/{project_id}/tenants/{tenant_id}". For example,
   * "projects/foo/tenants/bar".
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the tenant to search within.
   *
   * The format is "projects/{project_id}/tenants/{tenant_id}". For example,
   * "projects/foo/tenants/bar".
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SEARCH_MODE_FIELD_NUMBER = 2;
  private int searchMode_ = 0;
  /**
   *
   *
   * <pre>
   * Mode of a search.
   *
   * Defaults to
   * [SearchMode.JOB_SEARCH][google.cloud.talent.v4.SearchJobsRequest.SearchMode.JOB_SEARCH].
   * </pre>
   *
   * <code>.google.cloud.talent.v4.SearchJobsRequest.SearchMode search_mode = 2;</code>
   *
   * @return The enum numeric value on the wire for searchMode.
   */
  @java.lang.Override
  public int getSearchModeValue() {
    return searchMode_;
  }
  /**
   *
   *
   * <pre>
   * Mode of a search.
   *
   * Defaults to
   * [SearchMode.JOB_SEARCH][google.cloud.talent.v4.SearchJobsRequest.SearchMode.JOB_SEARCH].
   * </pre>
   *
   * <code>.google.cloud.talent.v4.SearchJobsRequest.SearchMode search_mode = 2;</code>
   *
   * @return The searchMode.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.SearchJobsRequest.SearchMode getSearchMode() {
    com.google.cloud.talent.v4.SearchJobsRequest.SearchMode result =
        com.google.cloud.talent.v4.SearchJobsRequest.SearchMode.forNumber(searchMode_);
    return result == null
        ? com.google.cloud.talent.v4.SearchJobsRequest.SearchMode.UNRECOGNIZED
        : result;
  }

  public static final int REQUEST_METADATA_FIELD_NUMBER = 3;
  private com.google.cloud.talent.v4.RequestMetadata requestMetadata_;
  /**
   *
   *
   * <pre>
   * Required. The meta information collected about the job searcher, used to
   * improve the search quality of the service. The identifiers (such as
   * `user_id`) are provided by users, and must be unique and consistent.
   * </pre>
   *
   * <code>
   * .google.cloud.talent.v4.RequestMetadata request_metadata = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the requestMetadata field is set.
   */
  @java.lang.Override
  public boolean hasRequestMetadata() {
    return requestMetadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The meta information collected about the job searcher, used to
   * improve the search quality of the service. The identifiers (such as
   * `user_id`) are provided by users, and must be unique and consistent.
   * </pre>
   *
   * <code>
   * .google.cloud.talent.v4.RequestMetadata request_metadata = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The requestMetadata.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.RequestMetadata getRequestMetadata() {
    return requestMetadata_ == null
        ? com.google.cloud.talent.v4.RequestMetadata.getDefaultInstance()
        : requestMetadata_;
  }
  /**
   *
   *
   * <pre>
   * Required. The meta information collected about the job searcher, used to
   * improve the search quality of the service. The identifiers (such as
   * `user_id`) are provided by users, and must be unique and consistent.
   * </pre>
   *
   * <code>
   * .google.cloud.talent.v4.RequestMetadata request_metadata = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.RequestMetadataOrBuilder getRequestMetadataOrBuilder() {
    return requestMetadata_ == null
        ? com.google.cloud.talent.v4.RequestMetadata.getDefaultInstance()
        : requestMetadata_;
  }

  public static final int JOB_QUERY_FIELD_NUMBER = 4;
  private com.google.cloud.talent.v4.JobQuery jobQuery_;
  /**
   *
   *
   * <pre>
   * Query used to search against jobs, such as keyword, location filters, etc.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.JobQuery job_query = 4;</code>
   *
   * @return Whether the jobQuery field is set.
   */
  @java.lang.Override
  public boolean hasJobQuery() {
    return jobQuery_ != null;
  }
  /**
   *
   *
   * <pre>
   * Query used to search against jobs, such as keyword, location filters, etc.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.JobQuery job_query = 4;</code>
   *
   * @return The jobQuery.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.JobQuery getJobQuery() {
    return jobQuery_ == null ? com.google.cloud.talent.v4.JobQuery.getDefaultInstance() : jobQuery_;
  }
  /**
   *
   *
   * <pre>
   * Query used to search against jobs, such as keyword, location filters, etc.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.JobQuery job_query = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.JobQueryOrBuilder getJobQueryOrBuilder() {
    return jobQuery_ == null ? com.google.cloud.talent.v4.JobQuery.getDefaultInstance() : jobQuery_;
  }

  public static final int ENABLE_BROADENING_FIELD_NUMBER = 5;
  private boolean enableBroadening_ = false;
  /**
   *
   *
   * <pre>
   * Controls whether to broaden the search when it produces sparse results.
   * Broadened queries append results to the end of the matching results
   * list.
   *
   * Defaults to false.
   * </pre>
   *
   * <code>bool enable_broadening = 5;</code>
   *
   * @return The enableBroadening.
   */
  @java.lang.Override
  public boolean getEnableBroadening() {
    return enableBroadening_;
  }

  public static final int HISTOGRAM_QUERIES_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.talent.v4.HistogramQuery> histogramQueries_;
  /**
   *
   *
   * <pre>
   * An expression specifies a histogram request against matching jobs.
   *
   * Expression syntax is an aggregation function call with histogram facets and
   * other options.
   *
   * Available aggregation function calls are:
   * * `count(string_histogram_facet)`: Count the number of matching entities,
   * for each distinct attribute value.
   * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
   * matching entities within each bucket.
   *
   * A maximum of 200 histogram buckets are supported.
   *
   * Data types:
   *
   * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
   * * String: string like "any string with backslash escape for quote(&#92;")."
   * * Number: whole number and floating point number like 10, -1 and -0.01.
   * * List: list of elements with comma(,) separator surrounded by square
   * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
   *
   * Built-in constants:
   *
   * * MIN (minimum number similar to java Double.MIN_VALUE)
   * * MAX (maximum number similar to java Double.MAX_VALUE)
   *
   * Built-in functions:
   *
   * * bucket(start, end[, label]): bucket built-in function creates a bucket
   * with range of [start, end). Note that the end is exclusive, for example,
   * bucket(1, MAX, "positive number") or bucket(1, 10).
   *
   * Job histogram facets:
   *
   * * company_display_name: histogram by
   * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
   * * employment_type: histogram by
   * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
   * example,
   *   "FULL_TIME", "PART_TIME".
   * * company_size (DEPRECATED): histogram by
   * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
   * "MEDIUM", "BIG".
   * * publish_time_in_day: histogram by the
   * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   *   in days.
   *   Must specify list of numeric buckets in spec.
   * * publish_time_in_month: histogram by the
   * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   *   in months.
   *   Must specify list of numeric buckets in spec.
   * * publish_time_in_year: histogram by the
   * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   *   in years.
   *   Must specify list of numeric buckets in spec.
   * * degree_types: histogram by the
   * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
   *   "Bachelors", "Masters".
   * * job_level: histogram by the
   * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
   *   Level".
   * * country: histogram by the country code of jobs, for example, "US", "FR".
   * * admin1: histogram by the admin1 code of jobs, which is a global
   *   placeholder referring to the state, province, or the particular term a
   *   country uses to define the geographic structure below the country level,
   *   for example, "CA", "IL".
   * * city: histogram by a combination of the "city name, admin1 code". For
   *   example,  "Mountain View, CA", "New York, NY".
   * * admin1_country: histogram by a combination of the "admin1 code, country",
   *   for example, "CA, US", "IL, US".
   * * city_coordinate: histogram by the city center's GPS coordinates (latitude
   *   and longitude), for example, 37.4038522,-122.0987765. Since the
   *   coordinates of a city center can change, customers may need to refresh
   *   them periodically.
   * * locale: histogram by the
   * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
   * "en-US",
   *   "fr-FR".
   * * language: histogram by the language subtag of the
   * [Job.language_code][google.cloud.talent.v4.Job.language_code],
   *   for example, "en", "fr".
   * * category: histogram by the
   * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
   *   "COMPUTER_AND_IT", "HEALTHCARE".
   * * base_compensation_unit: histogram by the
   *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
   *   of base salary, for example, "WEEKLY", "MONTHLY".
   * * base_compensation: histogram by the base salary. Must specify list of
   *   numeric buckets to group results by.
   * * annualized_base_compensation: histogram by the base annualized salary.
   *   Must specify list of numeric buckets to group results by.
   * * annualized_total_compensation: histogram by the total annualized salary.
   *   Must specify list of numeric buckets to group results by.
   * * string_custom_attribute: histogram by string
   * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
   *   Values can be accessed via square bracket notations like
   *   string_custom_attribute["key1"].
   * * numeric_custom_attribute: histogram by numeric
   * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
   *   Values can be accessed via square bracket notations like
   *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
   *   group results by.
   *
   * Example expressions:
   *
   * * `count(admin1)`
   * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
   * bucket(100000, MAX)])`
   * * `count(string_custom_attribute["some-string-custom-attribute"])`
   * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
   *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.talent.v4.HistogramQuery> getHistogramQueriesList() {
    return histogramQueries_;
  }
  /**
   *
   *
   * <pre>
   * An expression specifies a histogram request against matching jobs.
   *
   * Expression syntax is an aggregation function call with histogram facets and
   * other options.
   *
   * Available aggregation function calls are:
   * * `count(string_histogram_facet)`: Count the number of matching entities,
   * for each distinct attribute value.
   * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
   * matching entities within each bucket.
   *
   * A maximum of 200 histogram buckets are supported.
   *
   * Data types:
   *
   * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
   * * String: string like "any string with backslash escape for quote(&#92;")."
   * * Number: whole number and floating point number like 10, -1 and -0.01.
   * * List: list of elements with comma(,) separator surrounded by square
   * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
   *
   * Built-in constants:
   *
   * * MIN (minimum number similar to java Double.MIN_VALUE)
   * * MAX (maximum number similar to java Double.MAX_VALUE)
   *
   * Built-in functions:
   *
   * * bucket(start, end[, label]): bucket built-in function creates a bucket
   * with range of [start, end). Note that the end is exclusive, for example,
   * bucket(1, MAX, "positive number") or bucket(1, 10).
   *
   * Job histogram facets:
   *
   * * company_display_name: histogram by
   * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
   * * employment_type: histogram by
   * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
   * example,
   *   "FULL_TIME", "PART_TIME".
   * * company_size (DEPRECATED): histogram by
   * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
   * "MEDIUM", "BIG".
   * * publish_time_in_day: histogram by the
   * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   *   in days.
   *   Must specify list of numeric buckets in spec.
   * * publish_time_in_month: histogram by the
   * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   *   in months.
   *   Must specify list of numeric buckets in spec.
   * * publish_time_in_year: histogram by the
   * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   *   in years.
   *   Must specify list of numeric buckets in spec.
   * * degree_types: histogram by the
   * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
   *   "Bachelors", "Masters".
   * * job_level: histogram by the
   * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
   *   Level".
   * * country: histogram by the country code of jobs, for example, "US", "FR".
   * * admin1: histogram by the admin1 code of jobs, which is a global
   *   placeholder referring to the state, province, or the particular term a
   *   country uses to define the geographic structure below the country level,
   *   for example, "CA", "IL".
   * * city: histogram by a combination of the "city name, admin1 code". For
   *   example,  "Mountain View, CA", "New York, NY".
   * * admin1_country: histogram by a combination of the "admin1 code, country",
   *   for example, "CA, US", "IL, US".
   * * city_coordinate: histogram by the city center's GPS coordinates (latitude
   *   and longitude), for example, 37.4038522,-122.0987765. Since the
   *   coordinates of a city center can change, customers may need to refresh
   *   them periodically.
   * * locale: histogram by the
   * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
   * "en-US",
   *   "fr-FR".
   * * language: histogram by the language subtag of the
   * [Job.language_code][google.cloud.talent.v4.Job.language_code],
   *   for example, "en", "fr".
   * * category: histogram by the
   * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
   *   "COMPUTER_AND_IT", "HEALTHCARE".
   * * base_compensation_unit: histogram by the
   *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
   *   of base salary, for example, "WEEKLY", "MONTHLY".
   * * base_compensation: histogram by the base salary. Must specify list of
   *   numeric buckets to group results by.
   * * annualized_base_compensation: histogram by the base annualized salary.
   *   Must specify list of numeric buckets to group results by.
   * * annualized_total_compensation: histogram by the total annualized salary.
   *   Must specify list of numeric buckets to group results by.
   * * string_custom_attribute: histogram by string
   * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
   *   Values can be accessed via square bracket notations like
   *   string_custom_attribute["key1"].
   * * numeric_custom_attribute: histogram by numeric
   * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
   *   Values can be accessed via square bracket notations like
   *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
   *   group results by.
   *
   * Example expressions:
   *
   * * `count(admin1)`
   * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
   * bucket(100000, MAX)])`
   * * `count(string_custom_attribute["some-string-custom-attribute"])`
   * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
   *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.talent.v4.HistogramQueryOrBuilder>
      getHistogramQueriesOrBuilderList() {
    return histogramQueries_;
  }
  /**
   *
   *
   * <pre>
   * An expression specifies a histogram request against matching jobs.
   *
   * Expression syntax is an aggregation function call with histogram facets and
   * other options.
   *
   * Available aggregation function calls are:
   * * `count(string_histogram_facet)`: Count the number of matching entities,
   * for each distinct attribute value.
   * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
   * matching entities within each bucket.
   *
   * A maximum of 200 histogram buckets are supported.
   *
   * Data types:
   *
   * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
   * * String: string like "any string with backslash escape for quote(&#92;")."
   * * Number: whole number and floating point number like 10, -1 and -0.01.
   * * List: list of elements with comma(,) separator surrounded by square
   * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
   *
   * Built-in constants:
   *
   * * MIN (minimum number similar to java Double.MIN_VALUE)
   * * MAX (maximum number similar to java Double.MAX_VALUE)
   *
   * Built-in functions:
   *
   * * bucket(start, end[, label]): bucket built-in function creates a bucket
   * with range of [start, end). Note that the end is exclusive, for example,
   * bucket(1, MAX, "positive number") or bucket(1, 10).
   *
   * Job histogram facets:
   *
   * * company_display_name: histogram by
   * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
   * * employment_type: histogram by
   * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
   * example,
   *   "FULL_TIME", "PART_TIME".
   * * company_size (DEPRECATED): histogram by
   * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
   * "MEDIUM", "BIG".
   * * publish_time_in_day: histogram by the
   * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   *   in days.
   *   Must specify list of numeric buckets in spec.
   * * publish_time_in_month: histogram by the
   * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   *   in months.
   *   Must specify list of numeric buckets in spec.
   * * publish_time_in_year: histogram by the
   * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   *   in years.
   *   Must specify list of numeric buckets in spec.
   * * degree_types: histogram by the
   * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
   *   "Bachelors", "Masters".
   * * job_level: histogram by the
   * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
   *   Level".
   * * country: histogram by the country code of jobs, for example, "US", "FR".
   * * admin1: histogram by the admin1 code of jobs, which is a global
   *   placeholder referring to the state, province, or the particular term a
   *   country uses to define the geographic structure below the country level,
   *   for example, "CA", "IL".
   * * city: histogram by a combination of the "city name, admin1 code". For
   *   example,  "Mountain View, CA", "New York, NY".
   * * admin1_country: histogram by a combination of the "admin1 code, country",
   *   for example, "CA, US", "IL, US".
   * * city_coordinate: histogram by the city center's GPS coordinates (latitude
   *   and longitude), for example, 37.4038522,-122.0987765. Since the
   *   coordinates of a city center can change, customers may need to refresh
   *   them periodically.
   * * locale: histogram by the
   * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
   * "en-US",
   *   "fr-FR".
   * * language: histogram by the language subtag of the
   * [Job.language_code][google.cloud.talent.v4.Job.language_code],
   *   for example, "en", "fr".
   * * category: histogram by the
   * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
   *   "COMPUTER_AND_IT", "HEALTHCARE".
   * * base_compensation_unit: histogram by the
   *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
   *   of base salary, for example, "WEEKLY", "MONTHLY".
   * * base_compensation: histogram by the base salary. Must specify list of
   *   numeric buckets to group results by.
   * * annualized_base_compensation: histogram by the base annualized salary.
   *   Must specify list of numeric buckets to group results by.
   * * annualized_total_compensation: histogram by the total annualized salary.
   *   Must specify list of numeric buckets to group results by.
   * * string_custom_attribute: histogram by string
   * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
   *   Values can be accessed via square bracket notations like
   *   string_custom_attribute["key1"].
   * * numeric_custom_attribute: histogram by numeric
   * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
   *   Values can be accessed via square bracket notations like
   *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
   *   group results by.
   *
   * Example expressions:
   *
   * * `count(admin1)`
   * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
   * bucket(100000, MAX)])`
   * * `count(string_custom_attribute["some-string-custom-attribute"])`
   * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
   *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
   */
  @java.lang.Override
  public int getHistogramQueriesCount() {
    return histogramQueries_.size();
  }
  /**
   *
   *
   * <pre>
   * An expression specifies a histogram request against matching jobs.
   *
   * Expression syntax is an aggregation function call with histogram facets and
   * other options.
   *
   * Available aggregation function calls are:
   * * `count(string_histogram_facet)`: Count the number of matching entities,
   * for each distinct attribute value.
   * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
   * matching entities within each bucket.
   *
   * A maximum of 200 histogram buckets are supported.
   *
   * Data types:
   *
   * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
   * * String: string like "any string with backslash escape for quote(&#92;")."
   * * Number: whole number and floating point number like 10, -1 and -0.01.
   * * List: list of elements with comma(,) separator surrounded by square
   * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
   *
   * Built-in constants:
   *
   * * MIN (minimum number similar to java Double.MIN_VALUE)
   * * MAX (maximum number similar to java Double.MAX_VALUE)
   *
   * Built-in functions:
   *
   * * bucket(start, end[, label]): bucket built-in function creates a bucket
   * with range of [start, end). Note that the end is exclusive, for example,
   * bucket(1, MAX, "positive number") or bucket(1, 10).
   *
   * Job histogram facets:
   *
   * * company_display_name: histogram by
   * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
   * * employment_type: histogram by
   * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
   * example,
   *   "FULL_TIME", "PART_TIME".
   * * company_size (DEPRECATED): histogram by
   * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
   * "MEDIUM", "BIG".
   * * publish_time_in_day: histogram by the
   * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   *   in days.
   *   Must specify list of numeric buckets in spec.
   * * publish_time_in_month: histogram by the
   * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   *   in months.
   *   Must specify list of numeric buckets in spec.
   * * publish_time_in_year: histogram by the
   * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   *   in years.
   *   Must specify list of numeric buckets in spec.
   * * degree_types: histogram by the
   * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
   *   "Bachelors", "Masters".
   * * job_level: histogram by the
   * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
   *   Level".
   * * country: histogram by the country code of jobs, for example, "US", "FR".
   * * admin1: histogram by the admin1 code of jobs, which is a global
   *   placeholder referring to the state, province, or the particular term a
   *   country uses to define the geographic structure below the country level,
   *   for example, "CA", "IL".
   * * city: histogram by a combination of the "city name, admin1 code". For
   *   example,  "Mountain View, CA", "New York, NY".
   * * admin1_country: histogram by a combination of the "admin1 code, country",
   *   for example, "CA, US", "IL, US".
   * * city_coordinate: histogram by the city center's GPS coordinates (latitude
   *   and longitude), for example, 37.4038522,-122.0987765. Since the
   *   coordinates of a city center can change, customers may need to refresh
   *   them periodically.
   * * locale: histogram by the
   * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
   * "en-US",
   *   "fr-FR".
   * * language: histogram by the language subtag of the
   * [Job.language_code][google.cloud.talent.v4.Job.language_code],
   *   for example, "en", "fr".
   * * category: histogram by the
   * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
   *   "COMPUTER_AND_IT", "HEALTHCARE".
   * * base_compensation_unit: histogram by the
   *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
   *   of base salary, for example, "WEEKLY", "MONTHLY".
   * * base_compensation: histogram by the base salary. Must specify list of
   *   numeric buckets to group results by.
   * * annualized_base_compensation: histogram by the base annualized salary.
   *   Must specify list of numeric buckets to group results by.
   * * annualized_total_compensation: histogram by the total annualized salary.
   *   Must specify list of numeric buckets to group results by.
   * * string_custom_attribute: histogram by string
   * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
   *   Values can be accessed via square bracket notations like
   *   string_custom_attribute["key1"].
   * * numeric_custom_attribute: histogram by numeric
   * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
   *   Values can be accessed via square bracket notations like
   *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
   *   group results by.
   *
   * Example expressions:
   *
   * * `count(admin1)`
   * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
   * bucket(100000, MAX)])`
   * * `count(string_custom_attribute["some-string-custom-attribute"])`
   * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
   *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.HistogramQuery getHistogramQueries(int index) {
    return histogramQueries_.get(index);
  }
  /**
   *
   *
   * <pre>
   * An expression specifies a histogram request against matching jobs.
   *
   * Expression syntax is an aggregation function call with histogram facets and
   * other options.
   *
   * Available aggregation function calls are:
   * * `count(string_histogram_facet)`: Count the number of matching entities,
   * for each distinct attribute value.
   * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
   * matching entities within each bucket.
   *
   * A maximum of 200 histogram buckets are supported.
   *
   * Data types:
   *
   * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
   * * String: string like "any string with backslash escape for quote(&#92;")."
   * * Number: whole number and floating point number like 10, -1 and -0.01.
   * * List: list of elements with comma(,) separator surrounded by square
   * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
   *
   * Built-in constants:
   *
   * * MIN (minimum number similar to java Double.MIN_VALUE)
   * * MAX (maximum number similar to java Double.MAX_VALUE)
   *
   * Built-in functions:
   *
   * * bucket(start, end[, label]): bucket built-in function creates a bucket
   * with range of [start, end). Note that the end is exclusive, for example,
   * bucket(1, MAX, "positive number") or bucket(1, 10).
   *
   * Job histogram facets:
   *
   * * company_display_name: histogram by
   * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
   * * employment_type: histogram by
   * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
   * example,
   *   "FULL_TIME", "PART_TIME".
   * * company_size (DEPRECATED): histogram by
   * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
   * "MEDIUM", "BIG".
   * * publish_time_in_day: histogram by the
   * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   *   in days.
   *   Must specify list of numeric buckets in spec.
   * * publish_time_in_month: histogram by the
   * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   *   in months.
   *   Must specify list of numeric buckets in spec.
   * * publish_time_in_year: histogram by the
   * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   *   in years.
   *   Must specify list of numeric buckets in spec.
   * * degree_types: histogram by the
   * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
   *   "Bachelors", "Masters".
   * * job_level: histogram by the
   * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
   *   Level".
   * * country: histogram by the country code of jobs, for example, "US", "FR".
   * * admin1: histogram by the admin1 code of jobs, which is a global
   *   placeholder referring to the state, province, or the particular term a
   *   country uses to define the geographic structure below the country level,
   *   for example, "CA", "IL".
   * * city: histogram by a combination of the "city name, admin1 code". For
   *   example,  "Mountain View, CA", "New York, NY".
   * * admin1_country: histogram by a combination of the "admin1 code, country",
   *   for example, "CA, US", "IL, US".
   * * city_coordinate: histogram by the city center's GPS coordinates (latitude
   *   and longitude), for example, 37.4038522,-122.0987765. Since the
   *   coordinates of a city center can change, customers may need to refresh
   *   them periodically.
   * * locale: histogram by the
   * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
   * "en-US",
   *   "fr-FR".
   * * language: histogram by the language subtag of the
   * [Job.language_code][google.cloud.talent.v4.Job.language_code],
   *   for example, "en", "fr".
   * * category: histogram by the
   * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
   *   "COMPUTER_AND_IT", "HEALTHCARE".
   * * base_compensation_unit: histogram by the
   *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
   *   of base salary, for example, "WEEKLY", "MONTHLY".
   * * base_compensation: histogram by the base salary. Must specify list of
   *   numeric buckets to group results by.
   * * annualized_base_compensation: histogram by the base annualized salary.
   *   Must specify list of numeric buckets to group results by.
   * * annualized_total_compensation: histogram by the total annualized salary.
   *   Must specify list of numeric buckets to group results by.
   * * string_custom_attribute: histogram by string
   * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
   *   Values can be accessed via square bracket notations like
   *   string_custom_attribute["key1"].
   * * numeric_custom_attribute: histogram by numeric
   * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
   *   Values can be accessed via square bracket notations like
   *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
   *   group results by.
   *
   * Example expressions:
   *
   * * `count(admin1)`
   * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
   * bucket(100000, MAX)])`
   * * `count(string_custom_attribute["some-string-custom-attribute"])`
   * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
   *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.HistogramQueryOrBuilder getHistogramQueriesOrBuilder(
      int index) {
    return histogramQueries_.get(index);
  }

  public static final int JOB_VIEW_FIELD_NUMBER = 8;
  private int jobView_ = 0;
  /**
   *
   *
   * <pre>
   * The desired job attributes returned for jobs in the search response.
   * Defaults to
   * [JobView.JOB_VIEW_SMALL][google.cloud.talent.v4.JobView.JOB_VIEW_SMALL] if
   * no value is specified.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.JobView job_view = 8;</code>
   *
   * @return The enum numeric value on the wire for jobView.
   */
  @java.lang.Override
  public int getJobViewValue() {
    return jobView_;
  }
  /**
   *
   *
   * <pre>
   * The desired job attributes returned for jobs in the search response.
   * Defaults to
   * [JobView.JOB_VIEW_SMALL][google.cloud.talent.v4.JobView.JOB_VIEW_SMALL] if
   * no value is specified.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.JobView job_view = 8;</code>
   *
   * @return The jobView.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.JobView getJobView() {
    com.google.cloud.talent.v4.JobView result =
        com.google.cloud.talent.v4.JobView.forNumber(jobView_);
    return result == null ? com.google.cloud.talent.v4.JobView.UNRECOGNIZED : result;
  }

  public static final int OFFSET_FIELD_NUMBER = 9;
  private int offset_ = 0;
  /**
   *
   *
   * <pre>
   * An integer that specifies the current offset (that is, starting result
   * location, amongst the jobs deemed by the API as relevant) in search
   * results. This field is only considered if
   * [page_token][google.cloud.talent.v4.SearchJobsRequest.page_token] is unset.
   *
   * The maximum allowed value is 5000. Otherwise an error is thrown.
   *
   * For example, 0 means to  return results starting from the first matching
   * job, and 10 means to return from the 11th job. This can be used for
   * pagination, (for example, pageSize = 10 and offset = 10 means to return
   * from the second page).
   * </pre>
   *
   * <code>int32 offset = 9;</code>
   *
   * @return The offset.
   */
  @java.lang.Override
  public int getOffset() {
    return offset_;
  }

  public static final int MAX_PAGE_SIZE_FIELD_NUMBER = 10;
  private int maxPageSize_ = 0;
  /**
   *
   *
   * <pre>
   * A limit on the number of jobs returned in the search results.
   * Increasing this value above the default value of 10 can increase search
   * response time. The value can be between 1 and 100.
   * </pre>
   *
   * <code>int32 max_page_size = 10;</code>
   *
   * @return The maxPageSize.
   */
  @java.lang.Override
  public int getMaxPageSize() {
    return maxPageSize_;
  }

  public static final int PAGE_TOKEN_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pageToken_ = "";
  /**
   *
   *
   * <pre>
   * The token specifying the current offset within
   * search results. See
   * [SearchJobsResponse.next_page_token][google.cloud.talent.v4.SearchJobsResponse.next_page_token]
   * for an explanation of how to obtain the next set of query results.
   * </pre>
   *
   * <code>string page_token = 11;</code>
   *
   * @return The pageToken.
   */
  @java.lang.Override
  public java.lang.String getPageToken() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The token specifying the current offset within
   * search results. See
   * [SearchJobsResponse.next_page_token][google.cloud.talent.v4.SearchJobsResponse.next_page_token]
   * for an explanation of how to obtain the next set of query results.
   * </pre>
   *
   * <code>string page_token = 11;</code>
   *
   * @return The bytes for pageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPageTokenBytes() {
    java.lang.Object ref = pageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ORDER_BY_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object orderBy_ = "";
  /**
   *
   *
   * <pre>
   * The criteria determining how search results are sorted. Default is
   * `"relevance desc"`.
   *
   * Supported options are:
   *
   * * `"relevance desc"`: By relevance descending, as determined by the API
   *   algorithms. Relevance thresholding of query results is only available
   *   with this ordering.
   * * `"posting_publish_time desc"`: By
   * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   *   descending.
   * * `"posting_update_time desc"`: By
   * [Job.posting_update_time][google.cloud.talent.v4.Job.posting_update_time]
   *   descending.
   * * `"title"`: By [Job.title][google.cloud.talent.v4.Job.title] ascending.
   * * `"title desc"`: By [Job.title][google.cloud.talent.v4.Job.title]
   * descending.
   * * `"annualized_base_compensation"`: By job's
   *   [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_base_compensation_range]
   *   ascending. Jobs whose annualized base compensation is unspecified are put
   *   at the end of search results.
   * * `"annualized_base_compensation desc"`: By job's
   *   [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_base_compensation_range]
   *   descending. Jobs whose annualized base compensation is unspecified are
   *   put at the end of search results.
   * * `"annualized_total_compensation"`: By job's
   *   [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_total_compensation_range]
   *   ascending. Jobs whose annualized base compensation is unspecified are put
   *   at the end of search results.
   * * `"annualized_total_compensation desc"`: By job's
   *   [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_total_compensation_range]
   *   descending. Jobs whose annualized base compensation is unspecified are
   *   put at the end of search results.
   * * `"custom_ranking desc"`: By the relevance score adjusted to the
   *   [SearchJobsRequest.CustomRankingInfo.ranking_expression][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ranking_expression]
   *   with weight factor assigned by
   *   [SearchJobsRequest.CustomRankingInfo.importance_level][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.importance_level]
   *   in descending order.
   * * Location sorting: Use the special syntax to order jobs by distance:&lt;br&gt;
   *   `"distance_from('Hawaii')"`: Order by distance from Hawaii.&lt;br&gt;
   *   `"distance_from(19.89, 155.5)"`: Order by distance from a coordinate.&lt;br&gt;
   *   `"distance_from('Hawaii'), distance_from('Puerto Rico')"`: Order by
   *   multiple locations. See details below.&lt;br&gt;
   *   `"distance_from('Hawaii'), distance_from(19.89, 155.5)"`: Order by
   *   multiple locations. See details below.&lt;br&gt;
   *   The string can have a maximum of 256 characters. When multiple distance
   *   centers are provided, a job that is close to any of the distance centers
   *   would have a high rank. When a job has multiple locations, the job
   *   location closest to one of the distance centers will be used. Jobs that
   *   don't have locations will be ranked at the bottom. Distance is calculated
   *   with a precision of 11.3 meters (37.4 feet). Diversification strategy is
   *   still applied unless explicitly disabled in
   *   [diversification_level][google.cloud.talent.v4.SearchJobsRequest.diversification_level].
   * </pre>
   *
   * <code>string order_by = 12;</code>
   *
   * @return The orderBy.
   */
  @java.lang.Override
  public java.lang.String getOrderBy() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      orderBy_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The criteria determining how search results are sorted. Default is
   * `"relevance desc"`.
   *
   * Supported options are:
   *
   * * `"relevance desc"`: By relevance descending, as determined by the API
   *   algorithms. Relevance thresholding of query results is only available
   *   with this ordering.
   * * `"posting_publish_time desc"`: By
   * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
   *   descending.
   * * `"posting_update_time desc"`: By
   * [Job.posting_update_time][google.cloud.talent.v4.Job.posting_update_time]
   *   descending.
   * * `"title"`: By [Job.title][google.cloud.talent.v4.Job.title] ascending.
   * * `"title desc"`: By [Job.title][google.cloud.talent.v4.Job.title]
   * descending.
   * * `"annualized_base_compensation"`: By job's
   *   [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_base_compensation_range]
   *   ascending. Jobs whose annualized base compensation is unspecified are put
   *   at the end of search results.
   * * `"annualized_base_compensation desc"`: By job's
   *   [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_base_compensation_range]
   *   descending. Jobs whose annualized base compensation is unspecified are
   *   put at the end of search results.
   * * `"annualized_total_compensation"`: By job's
   *   [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_total_compensation_range]
   *   ascending. Jobs whose annualized base compensation is unspecified are put
   *   at the end of search results.
   * * `"annualized_total_compensation desc"`: By job's
   *   [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_total_compensation_range]
   *   descending. Jobs whose annualized base compensation is unspecified are
   *   put at the end of search results.
   * * `"custom_ranking desc"`: By the relevance score adjusted to the
   *   [SearchJobsRequest.CustomRankingInfo.ranking_expression][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ranking_expression]
   *   with weight factor assigned by
   *   [SearchJobsRequest.CustomRankingInfo.importance_level][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.importance_level]
   *   in descending order.
   * * Location sorting: Use the special syntax to order jobs by distance:&lt;br&gt;
   *   `"distance_from('Hawaii')"`: Order by distance from Hawaii.&lt;br&gt;
   *   `"distance_from(19.89, 155.5)"`: Order by distance from a coordinate.&lt;br&gt;
   *   `"distance_from('Hawaii'), distance_from('Puerto Rico')"`: Order by
   *   multiple locations. See details below.&lt;br&gt;
   *   `"distance_from('Hawaii'), distance_from(19.89, 155.5)"`: Order by
   *   multiple locations. See details below.&lt;br&gt;
   *   The string can have a maximum of 256 characters. When multiple distance
   *   centers are provided, a job that is close to any of the distance centers
   *   would have a high rank. When a job has multiple locations, the job
   *   location closest to one of the distance centers will be used. Jobs that
   *   don't have locations will be ranked at the bottom. Distance is calculated
   *   with a precision of 11.3 meters (37.4 feet). Diversification strategy is
   *   still applied unless explicitly disabled in
   *   [diversification_level][google.cloud.talent.v4.SearchJobsRequest.diversification_level].
   * </pre>
   *
   * <code>string order_by = 12;</code>
   *
   * @return The bytes for orderBy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOrderByBytes() {
    java.lang.Object ref = orderBy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      orderBy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DIVERSIFICATION_LEVEL_FIELD_NUMBER = 13;
  private int diversificationLevel_ = 0;
  /**
   *
   *
   * <pre>
   * Controls whether highly similar jobs are returned next to each other in
   * the search results. Jobs are identified as highly similar based on
   * their titles, job categories, and locations. Highly similar results are
   * clustered so that only one representative job of the cluster is
   * displayed to the job seeker higher up in the results, with the other jobs
   * being displayed lower down in the results.
   *
   * Defaults to
   * [DiversificationLevel.SIMPLE][google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel.SIMPLE]
   * if no value is specified.
   * </pre>
   *
   * <code>
   * .google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel diversification_level = 13;
   * </code>
   *
   * @return The enum numeric value on the wire for diversificationLevel.
   */
  @java.lang.Override
  public int getDiversificationLevelValue() {
    return diversificationLevel_;
  }
  /**
   *
   *
   * <pre>
   * Controls whether highly similar jobs are returned next to each other in
   * the search results. Jobs are identified as highly similar based on
   * their titles, job categories, and locations. Highly similar results are
   * clustered so that only one representative job of the cluster is
   * displayed to the job seeker higher up in the results, with the other jobs
   * being displayed lower down in the results.
   *
   * Defaults to
   * [DiversificationLevel.SIMPLE][google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel.SIMPLE]
   * if no value is specified.
   * </pre>
   *
   * <code>
   * .google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel diversification_level = 13;
   * </code>
   *
   * @return The diversificationLevel.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel
      getDiversificationLevel() {
    com.google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel result =
        com.google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel.forNumber(
            diversificationLevel_);
    return result == null
        ? com.google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel.UNRECOGNIZED
        : result;
  }

  public static final int CUSTOM_RANKING_INFO_FIELD_NUMBER = 14;
  private com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo customRankingInfo_;
  /**
   *
   *
   * <pre>
   * Controls over how job documents get ranked on top of existing relevance
   * score (determined by API algorithm).
   * </pre>
   *
   * <code>.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo custom_ranking_info = 14;
   * </code>
   *
   * @return Whether the customRankingInfo field is set.
   */
  @java.lang.Override
  public boolean hasCustomRankingInfo() {
    return customRankingInfo_ != null;
  }
  /**
   *
   *
   * <pre>
   * Controls over how job documents get ranked on top of existing relevance
   * score (determined by API algorithm).
   * </pre>
   *
   * <code>.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo custom_ranking_info = 14;
   * </code>
   *
   * @return The customRankingInfo.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo getCustomRankingInfo() {
    return customRankingInfo_ == null
        ? com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.getDefaultInstance()
        : customRankingInfo_;
  }
  /**
   *
   *
   * <pre>
   * Controls over how job documents get ranked on top of existing relevance
   * score (determined by API algorithm).
   * </pre>
   *
   * <code>.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo custom_ranking_info = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfoOrBuilder
      getCustomRankingInfoOrBuilder() {
    return customRankingInfo_ == null
        ? com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.getDefaultInstance()
        : customRankingInfo_;
  }

  public static final int DISABLE_KEYWORD_MATCH_FIELD_NUMBER = 16;
  private boolean disableKeywordMatch_ = false;
  /**
   *
   *
   * <pre>
   * This field is deprecated. Please use
   * [SearchJobsRequest.keyword_match_mode][google.cloud.talent.v4.SearchJobsRequest.keyword_match_mode]
   * going forward.
   *
   * To migrate, disable_keyword_match set to false maps to
   * [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL],
   * and disable_keyword_match set to true maps to
   * [KeywordMatchMode.KEYWORD_MATCH_DISABLED][google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_DISABLED].
   * If
   * [SearchJobsRequest.keyword_match_mode][google.cloud.talent.v4.SearchJobsRequest.keyword_match_mode]
   * is set, this field is ignored.
   *
   * Controls whether to disable exact keyword match on
   * [Job.title][google.cloud.talent.v4.Job.title],
   * [Job.description][google.cloud.talent.v4.Job.description],
   * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name],
   * [Job.addresses][google.cloud.talent.v4.Job.addresses],
   * [Job.qualifications][google.cloud.talent.v4.Job.qualifications]. When
   * disable keyword match is turned off, a keyword match returns jobs that do
   * not match given category filters when there are matching keywords. For
   * example, for the query "program manager," a result is returned even if the
   * job posting has the title "software developer," which doesn't fall into
   * "program manager" ontology, but does have "program manager" appearing in
   * its description.
   *
   * For queries like "cloud" that don't contain title or
   * location specific ontology, jobs with "cloud" keyword matches are returned
   * regardless of this flag's value.
   *
   * Use
   * [Company.keyword_searchable_job_custom_attributes][google.cloud.talent.v4.Company.keyword_searchable_job_custom_attributes]
   * if company-specific globally matched custom field/attribute string values
   * are needed. Enabling keyword match improves recall of subsequent search
   * requests.
   *
   * Defaults to false.
   * </pre>
   *
   * <code>bool disable_keyword_match = 16 [deprecated = true];</code>
   *
   * @deprecated google.cloud.talent.v4.SearchJobsRequest.disable_keyword_match is deprecated. See
   *     google/cloud/talent/v4/job_service.proto;l=804
   * @return The disableKeywordMatch.
   */
  @java.lang.Override
  @java.lang.Deprecated
  public boolean getDisableKeywordMatch() {
    return disableKeywordMatch_;
  }

  public static final int KEYWORD_MATCH_MODE_FIELD_NUMBER = 18;
  private int keywordMatchMode_ = 0;
  /**
   *
   *
   * <pre>
   * Controls what keyword match options to use. If both keyword_match_mode and
   * disable_keyword_match are set, keyword_match_mode will take precedence.
   *
   * Defaults to
   * [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL]
   * if no value is specified.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode keyword_match_mode = 18;
   * </code>
   *
   * @return The enum numeric value on the wire for keywordMatchMode.
   */
  @java.lang.Override
  public int getKeywordMatchModeValue() {
    return keywordMatchMode_;
  }
  /**
   *
   *
   * <pre>
   * Controls what keyword match options to use. If both keyword_match_mode and
   * disable_keyword_match are set, keyword_match_mode will take precedence.
   *
   * Defaults to
   * [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL]
   * if no value is specified.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode keyword_match_mode = 18;
   * </code>
   *
   * @return The keywordMatchMode.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode getKeywordMatchMode() {
    com.google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode result =
        com.google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode.forNumber(keywordMatchMode_);
    return result == null
        ? com.google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (searchMode_
        != com.google.cloud.talent.v4.SearchJobsRequest.SearchMode.SEARCH_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, searchMode_);
    }
    if (requestMetadata_ != null) {
      output.writeMessage(3, getRequestMetadata());
    }
    if (jobQuery_ != null) {
      output.writeMessage(4, getJobQuery());
    }
    if (enableBroadening_ != false) {
      output.writeBool(5, enableBroadening_);
    }
    for (int i = 0; i < histogramQueries_.size(); i++) {
      output.writeMessage(7, histogramQueries_.get(i));
    }
    if (jobView_ != com.google.cloud.talent.v4.JobView.JOB_VIEW_UNSPECIFIED.getNumber()) {
      output.writeEnum(8, jobView_);
    }
    if (offset_ != 0) {
      output.writeInt32(9, offset_);
    }
    if (maxPageSize_ != 0) {
      output.writeInt32(10, maxPageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, orderBy_);
    }
    if (diversificationLevel_
        != com.google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel
            .DIVERSIFICATION_LEVEL_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(13, diversificationLevel_);
    }
    if (customRankingInfo_ != null) {
      output.writeMessage(14, getCustomRankingInfo());
    }
    if (disableKeywordMatch_ != false) {
      output.writeBool(16, disableKeywordMatch_);
    }
    if (keywordMatchMode_
        != com.google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode
            .KEYWORD_MATCH_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(18, keywordMatchMode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (searchMode_
        != com.google.cloud.talent.v4.SearchJobsRequest.SearchMode.SEARCH_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, searchMode_);
    }
    if (requestMetadata_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getRequestMetadata());
    }
    if (jobQuery_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getJobQuery());
    }
    if (enableBroadening_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, enableBroadening_);
    }
    for (int i = 0; i < histogramQueries_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, histogramQueries_.get(i));
    }
    if (jobView_ != com.google.cloud.talent.v4.JobView.JOB_VIEW_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, jobView_);
    }
    if (offset_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(9, offset_);
    }
    if (maxPageSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(10, maxPageSize_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, pageToken_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(orderBy_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, orderBy_);
    }
    if (diversificationLevel_
        != com.google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel
            .DIVERSIFICATION_LEVEL_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(13, diversificationLevel_);
    }
    if (customRankingInfo_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getCustomRankingInfo());
    }
    if (disableKeywordMatch_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(16, disableKeywordMatch_);
    }
    if (keywordMatchMode_
        != com.google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode
            .KEYWORD_MATCH_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(18, keywordMatchMode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.talent.v4.SearchJobsRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.talent.v4.SearchJobsRequest other =
        (com.google.cloud.talent.v4.SearchJobsRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (searchMode_ != other.searchMode_) return false;
    if (hasRequestMetadata() != other.hasRequestMetadata()) return false;
    if (hasRequestMetadata()) {
      if (!getRequestMetadata().equals(other.getRequestMetadata())) return false;
    }
    if (hasJobQuery() != other.hasJobQuery()) return false;
    if (hasJobQuery()) {
      if (!getJobQuery().equals(other.getJobQuery())) return false;
    }
    if (getEnableBroadening() != other.getEnableBroadening()) return false;
    if (!getHistogramQueriesList().equals(other.getHistogramQueriesList())) return false;
    if (jobView_ != other.jobView_) return false;
    if (getOffset() != other.getOffset()) return false;
    if (getMaxPageSize() != other.getMaxPageSize()) return false;
    if (!getPageToken().equals(other.getPageToken())) return false;
    if (!getOrderBy().equals(other.getOrderBy())) return false;
    if (diversificationLevel_ != other.diversificationLevel_) return false;
    if (hasCustomRankingInfo() != other.hasCustomRankingInfo()) return false;
    if (hasCustomRankingInfo()) {
      if (!getCustomRankingInfo().equals(other.getCustomRankingInfo())) return false;
    }
    if (getDisableKeywordMatch() != other.getDisableKeywordMatch()) return false;
    if (keywordMatchMode_ != other.keywordMatchMode_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + SEARCH_MODE_FIELD_NUMBER;
    hash = (53 * hash) + searchMode_;
    if (hasRequestMetadata()) {
      hash = (37 * hash) + REQUEST_METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getRequestMetadata().hashCode();
    }
    if (hasJobQuery()) {
      hash = (37 * hash) + JOB_QUERY_FIELD_NUMBER;
      hash = (53 * hash) + getJobQuery().hashCode();
    }
    hash = (37 * hash) + ENABLE_BROADENING_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getEnableBroadening());
    if (getHistogramQueriesCount() > 0) {
      hash = (37 * hash) + HISTOGRAM_QUERIES_FIELD_NUMBER;
      hash = (53 * hash) + getHistogramQueriesList().hashCode();
    }
    hash = (37 * hash) + JOB_VIEW_FIELD_NUMBER;
    hash = (53 * hash) + jobView_;
    hash = (37 * hash) + OFFSET_FIELD_NUMBER;
    hash = (53 * hash) + getOffset();
    hash = (37 * hash) + MAX_PAGE_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getMaxPageSize();
    hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getPageToken().hashCode();
    hash = (37 * hash) + ORDER_BY_FIELD_NUMBER;
    hash = (53 * hash) + getOrderBy().hashCode();
    hash = (37 * hash) + DIVERSIFICATION_LEVEL_FIELD_NUMBER;
    hash = (53 * hash) + diversificationLevel_;
    if (hasCustomRankingInfo()) {
      hash = (37 * hash) + CUSTOM_RANKING_INFO_FIELD_NUMBER;
      hash = (53 * hash) + getCustomRankingInfo().hashCode();
    }
    hash = (37 * hash) + DISABLE_KEYWORD_MATCH_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDisableKeywordMatch());
    hash = (37 * hash) + KEYWORD_MATCH_MODE_FIELD_NUMBER;
    hash = (53 * hash) + keywordMatchMode_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.talent.v4.SearchJobsRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.SearchJobsRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.SearchJobsRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.SearchJobsRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.SearchJobsRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.SearchJobsRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.SearchJobsRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.SearchJobsRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.SearchJobsRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.SearchJobsRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.SearchJobsRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.SearchJobsRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.talent.v4.SearchJobsRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The Request body of the `SearchJobs` call.
   * </pre>
   *
   * Protobuf type {@code google.cloud.talent.v4.SearchJobsRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.talent.v4.SearchJobsRequest)
      com.google.cloud.talent.v4.SearchJobsRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.talent.v4.JobServiceProto
          .internal_static_google_cloud_talent_v4_SearchJobsRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.talent.v4.JobServiceProto
          .internal_static_google_cloud_talent_v4_SearchJobsRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.talent.v4.SearchJobsRequest.class,
              com.google.cloud.talent.v4.SearchJobsRequest.Builder.class);
    }

    // Construct using com.google.cloud.talent.v4.SearchJobsRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      searchMode_ = 0;
      requestMetadata_ = null;
      if (requestMetadataBuilder_ != null) {
        requestMetadataBuilder_.dispose();
        requestMetadataBuilder_ = null;
      }
      jobQuery_ = null;
      if (jobQueryBuilder_ != null) {
        jobQueryBuilder_.dispose();
        jobQueryBuilder_ = null;
      }
      enableBroadening_ = false;
      if (histogramQueriesBuilder_ == null) {
        histogramQueries_ = java.util.Collections.emptyList();
      } else {
        histogramQueries_ = null;
        histogramQueriesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      jobView_ = 0;
      offset_ = 0;
      maxPageSize_ = 0;
      pageToken_ = "";
      orderBy_ = "";
      diversificationLevel_ = 0;
      customRankingInfo_ = null;
      if (customRankingInfoBuilder_ != null) {
        customRankingInfoBuilder_.dispose();
        customRankingInfoBuilder_ = null;
      }
      disableKeywordMatch_ = false;
      keywordMatchMode_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.talent.v4.JobServiceProto
          .internal_static_google_cloud_talent_v4_SearchJobsRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.SearchJobsRequest getDefaultInstanceForType() {
      return com.google.cloud.talent.v4.SearchJobsRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.SearchJobsRequest build() {
      com.google.cloud.talent.v4.SearchJobsRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.SearchJobsRequest buildPartial() {
      com.google.cloud.talent.v4.SearchJobsRequest result =
          new com.google.cloud.talent.v4.SearchJobsRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.talent.v4.SearchJobsRequest result) {
      if (histogramQueriesBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          histogramQueries_ = java.util.Collections.unmodifiableList(histogramQueries_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.histogramQueries_ = histogramQueries_;
      } else {
        result.histogramQueries_ = histogramQueriesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.talent.v4.SearchJobsRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.searchMode_ = searchMode_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.requestMetadata_ =
            requestMetadataBuilder_ == null ? requestMetadata_ : requestMetadataBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.jobQuery_ = jobQueryBuilder_ == null ? jobQuery_ : jobQueryBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.enableBroadening_ = enableBroadening_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.jobView_ = jobView_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.offset_ = offset_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.maxPageSize_ = maxPageSize_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.pageToken_ = pageToken_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.orderBy_ = orderBy_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.diversificationLevel_ = diversificationLevel_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.customRankingInfo_ =
            customRankingInfoBuilder_ == null
                ? customRankingInfo_
                : customRankingInfoBuilder_.build();
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.disableKeywordMatch_ = disableKeywordMatch_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.keywordMatchMode_ = keywordMatchMode_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.talent.v4.SearchJobsRequest) {
        return mergeFrom((com.google.cloud.talent.v4.SearchJobsRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.talent.v4.SearchJobsRequest other) {
      if (other == com.google.cloud.talent.v4.SearchJobsRequest.getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.searchMode_ != 0) {
        setSearchModeValue(other.getSearchModeValue());
      }
      if (other.hasRequestMetadata()) {
        mergeRequestMetadata(other.getRequestMetadata());
      }
      if (other.hasJobQuery()) {
        mergeJobQuery(other.getJobQuery());
      }
      if (other.getEnableBroadening() != false) {
        setEnableBroadening(other.getEnableBroadening());
      }
      if (histogramQueriesBuilder_ == null) {
        if (!other.histogramQueries_.isEmpty()) {
          if (histogramQueries_.isEmpty()) {
            histogramQueries_ = other.histogramQueries_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureHistogramQueriesIsMutable();
            histogramQueries_.addAll(other.histogramQueries_);
          }
          onChanged();
        }
      } else {
        if (!other.histogramQueries_.isEmpty()) {
          if (histogramQueriesBuilder_.isEmpty()) {
            histogramQueriesBuilder_.dispose();
            histogramQueriesBuilder_ = null;
            histogramQueries_ = other.histogramQueries_;
            bitField0_ = (bitField0_ & ~0x00000020);
            histogramQueriesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getHistogramQueriesFieldBuilder()
                    : null;
          } else {
            histogramQueriesBuilder_.addAllMessages(other.histogramQueries_);
          }
        }
      }
      if (other.jobView_ != 0) {
        setJobViewValue(other.getJobViewValue());
      }
      if (other.getOffset() != 0) {
        setOffset(other.getOffset());
      }
      if (other.getMaxPageSize() != 0) {
        setMaxPageSize(other.getMaxPageSize());
      }
      if (!other.getPageToken().isEmpty()) {
        pageToken_ = other.pageToken_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (!other.getOrderBy().isEmpty()) {
        orderBy_ = other.orderBy_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      if (other.diversificationLevel_ != 0) {
        setDiversificationLevelValue(other.getDiversificationLevelValue());
      }
      if (other.hasCustomRankingInfo()) {
        mergeCustomRankingInfo(other.getCustomRankingInfo());
      }
      if (other.getDisableKeywordMatch() != false) {
        setDisableKeywordMatch(other.getDisableKeywordMatch());
      }
      if (other.keywordMatchMode_ != 0) {
        setKeywordMatchModeValue(other.getKeywordMatchModeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                searchMode_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(getRequestMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getJobQueryFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                enableBroadening_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 58:
              {
                com.google.cloud.talent.v4.HistogramQuery m =
                    input.readMessage(
                        com.google.cloud.talent.v4.HistogramQuery.parser(), extensionRegistry);
                if (histogramQueriesBuilder_ == null) {
                  ensureHistogramQueriesIsMutable();
                  histogramQueries_.add(m);
                } else {
                  histogramQueriesBuilder_.addMessage(m);
                }
                break;
              } // case 58
            case 64:
              {
                jobView_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 64
            case 72:
              {
                offset_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 72
            case 80:
              {
                maxPageSize_ = input.readInt32();
                bitField0_ |= 0x00000100;
                break;
              } // case 80
            case 90:
              {
                pageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 90
            case 98:
              {
                orderBy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case 98
            case 104:
              {
                diversificationLevel_ = input.readEnum();
                bitField0_ |= 0x00000800;
                break;
              } // case 104
            case 114:
              {
                input.readMessage(
                    getCustomRankingInfoFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 114
            case 128:
              {
                disableKeywordMatch_ = input.readBool();
                bitField0_ |= 0x00002000;
                break;
              } // case 128
            case 144:
              {
                keywordMatchMode_ = input.readEnum();
                bitField0_ |= 0x00004000;
                break;
              } // case 144
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the tenant to search within.
     *
     * The format is "projects/{project_id}/tenants/{tenant_id}". For example,
     * "projects/foo/tenants/bar".
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the tenant to search within.
     *
     * The format is "projects/{project_id}/tenants/{tenant_id}". For example,
     * "projects/foo/tenants/bar".
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the tenant to search within.
     *
     * The format is "projects/{project_id}/tenants/{tenant_id}". For example,
     * "projects/foo/tenants/bar".
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the tenant to search within.
     *
     * The format is "projects/{project_id}/tenants/{tenant_id}". For example,
     * "projects/foo/tenants/bar".
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the tenant to search within.
     *
     * The format is "projects/{project_id}/tenants/{tenant_id}". For example,
     * "projects/foo/tenants/bar".
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int searchMode_ = 0;
    /**
     *
     *
     * <pre>
     * Mode of a search.
     *
     * Defaults to
     * [SearchMode.JOB_SEARCH][google.cloud.talent.v4.SearchJobsRequest.SearchMode.JOB_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsRequest.SearchMode search_mode = 2;</code>
     *
     * @return The enum numeric value on the wire for searchMode.
     */
    @java.lang.Override
    public int getSearchModeValue() {
      return searchMode_;
    }
    /**
     *
     *
     * <pre>
     * Mode of a search.
     *
     * Defaults to
     * [SearchMode.JOB_SEARCH][google.cloud.talent.v4.SearchJobsRequest.SearchMode.JOB_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsRequest.SearchMode search_mode = 2;</code>
     *
     * @param value The enum numeric value on the wire for searchMode to set.
     * @return This builder for chaining.
     */
    public Builder setSearchModeValue(int value) {
      searchMode_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mode of a search.
     *
     * Defaults to
     * [SearchMode.JOB_SEARCH][google.cloud.talent.v4.SearchJobsRequest.SearchMode.JOB_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsRequest.SearchMode search_mode = 2;</code>
     *
     * @return The searchMode.
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.SearchJobsRequest.SearchMode getSearchMode() {
      com.google.cloud.talent.v4.SearchJobsRequest.SearchMode result =
          com.google.cloud.talent.v4.SearchJobsRequest.SearchMode.forNumber(searchMode_);
      return result == null
          ? com.google.cloud.talent.v4.SearchJobsRequest.SearchMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Mode of a search.
     *
     * Defaults to
     * [SearchMode.JOB_SEARCH][google.cloud.talent.v4.SearchJobsRequest.SearchMode.JOB_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsRequest.SearchMode search_mode = 2;</code>
     *
     * @param value The searchMode to set.
     * @return This builder for chaining.
     */
    public Builder setSearchMode(com.google.cloud.talent.v4.SearchJobsRequest.SearchMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      searchMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Mode of a search.
     *
     * Defaults to
     * [SearchMode.JOB_SEARCH][google.cloud.talent.v4.SearchJobsRequest.SearchMode.JOB_SEARCH].
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsRequest.SearchMode search_mode = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSearchMode() {
      bitField0_ = (bitField0_ & ~0x00000002);
      searchMode_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.talent.v4.RequestMetadata requestMetadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.RequestMetadata,
            com.google.cloud.talent.v4.RequestMetadata.Builder,
            com.google.cloud.talent.v4.RequestMetadataOrBuilder>
        requestMetadataBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The meta information collected about the job searcher, used to
     * improve the search quality of the service. The identifiers (such as
     * `user_id`) are provided by users, and must be unique and consistent.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.RequestMetadata request_metadata = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the requestMetadata field is set.
     */
    public boolean hasRequestMetadata() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The meta information collected about the job searcher, used to
     * improve the search quality of the service. The identifiers (such as
     * `user_id`) are provided by users, and must be unique and consistent.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.RequestMetadata request_metadata = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The requestMetadata.
     */
    public com.google.cloud.talent.v4.RequestMetadata getRequestMetadata() {
      if (requestMetadataBuilder_ == null) {
        return requestMetadata_ == null
            ? com.google.cloud.talent.v4.RequestMetadata.getDefaultInstance()
            : requestMetadata_;
      } else {
        return requestMetadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The meta information collected about the job searcher, used to
     * improve the search quality of the service. The identifiers (such as
     * `user_id`) are provided by users, and must be unique and consistent.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.RequestMetadata request_metadata = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRequestMetadata(com.google.cloud.talent.v4.RequestMetadata value) {
      if (requestMetadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        requestMetadata_ = value;
      } else {
        requestMetadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The meta information collected about the job searcher, used to
     * improve the search quality of the service. The identifiers (such as
     * `user_id`) are provided by users, and must be unique and consistent.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.RequestMetadata request_metadata = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setRequestMetadata(
        com.google.cloud.talent.v4.RequestMetadata.Builder builderForValue) {
      if (requestMetadataBuilder_ == null) {
        requestMetadata_ = builderForValue.build();
      } else {
        requestMetadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The meta information collected about the job searcher, used to
     * improve the search quality of the service. The identifiers (such as
     * `user_id`) are provided by users, and must be unique and consistent.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.RequestMetadata request_metadata = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeRequestMetadata(com.google.cloud.talent.v4.RequestMetadata value) {
      if (requestMetadataBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && requestMetadata_ != null
            && requestMetadata_
                != com.google.cloud.talent.v4.RequestMetadata.getDefaultInstance()) {
          getRequestMetadataBuilder().mergeFrom(value);
        } else {
          requestMetadata_ = value;
        }
      } else {
        requestMetadataBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The meta information collected about the job searcher, used to
     * improve the search quality of the service. The identifiers (such as
     * `user_id`) are provided by users, and must be unique and consistent.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.RequestMetadata request_metadata = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearRequestMetadata() {
      bitField0_ = (bitField0_ & ~0x00000004);
      requestMetadata_ = null;
      if (requestMetadataBuilder_ != null) {
        requestMetadataBuilder_.dispose();
        requestMetadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The meta information collected about the job searcher, used to
     * improve the search quality of the service. The identifiers (such as
     * `user_id`) are provided by users, and must be unique and consistent.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.RequestMetadata request_metadata = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.talent.v4.RequestMetadata.Builder getRequestMetadataBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getRequestMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The meta information collected about the job searcher, used to
     * improve the search quality of the service. The identifiers (such as
     * `user_id`) are provided by users, and must be unique and consistent.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.RequestMetadata request_metadata = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.talent.v4.RequestMetadataOrBuilder getRequestMetadataOrBuilder() {
      if (requestMetadataBuilder_ != null) {
        return requestMetadataBuilder_.getMessageOrBuilder();
      } else {
        return requestMetadata_ == null
            ? com.google.cloud.talent.v4.RequestMetadata.getDefaultInstance()
            : requestMetadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The meta information collected about the job searcher, used to
     * improve the search quality of the service. The identifiers (such as
     * `user_id`) are provided by users, and must be unique and consistent.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.RequestMetadata request_metadata = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.RequestMetadata,
            com.google.cloud.talent.v4.RequestMetadata.Builder,
            com.google.cloud.talent.v4.RequestMetadataOrBuilder>
        getRequestMetadataFieldBuilder() {
      if (requestMetadataBuilder_ == null) {
        requestMetadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.talent.v4.RequestMetadata,
                com.google.cloud.talent.v4.RequestMetadata.Builder,
                com.google.cloud.talent.v4.RequestMetadataOrBuilder>(
                getRequestMetadata(), getParentForChildren(), isClean());
        requestMetadata_ = null;
      }
      return requestMetadataBuilder_;
    }

    private com.google.cloud.talent.v4.JobQuery jobQuery_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.JobQuery,
            com.google.cloud.talent.v4.JobQuery.Builder,
            com.google.cloud.talent.v4.JobQueryOrBuilder>
        jobQueryBuilder_;
    /**
     *
     *
     * <pre>
     * Query used to search against jobs, such as keyword, location filters, etc.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobQuery job_query = 4;</code>
     *
     * @return Whether the jobQuery field is set.
     */
    public boolean hasJobQuery() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Query used to search against jobs, such as keyword, location filters, etc.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobQuery job_query = 4;</code>
     *
     * @return The jobQuery.
     */
    public com.google.cloud.talent.v4.JobQuery getJobQuery() {
      if (jobQueryBuilder_ == null) {
        return jobQuery_ == null
            ? com.google.cloud.talent.v4.JobQuery.getDefaultInstance()
            : jobQuery_;
      } else {
        return jobQueryBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Query used to search against jobs, such as keyword, location filters, etc.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobQuery job_query = 4;</code>
     */
    public Builder setJobQuery(com.google.cloud.talent.v4.JobQuery value) {
      if (jobQueryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobQuery_ = value;
      } else {
        jobQueryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query used to search against jobs, such as keyword, location filters, etc.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobQuery job_query = 4;</code>
     */
    public Builder setJobQuery(com.google.cloud.talent.v4.JobQuery.Builder builderForValue) {
      if (jobQueryBuilder_ == null) {
        jobQuery_ = builderForValue.build();
      } else {
        jobQueryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query used to search against jobs, such as keyword, location filters, etc.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobQuery job_query = 4;</code>
     */
    public Builder mergeJobQuery(com.google.cloud.talent.v4.JobQuery value) {
      if (jobQueryBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && jobQuery_ != null
            && jobQuery_ != com.google.cloud.talent.v4.JobQuery.getDefaultInstance()) {
          getJobQueryBuilder().mergeFrom(value);
        } else {
          jobQuery_ = value;
        }
      } else {
        jobQueryBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query used to search against jobs, such as keyword, location filters, etc.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobQuery job_query = 4;</code>
     */
    public Builder clearJobQuery() {
      bitField0_ = (bitField0_ & ~0x00000008);
      jobQuery_ = null;
      if (jobQueryBuilder_ != null) {
        jobQueryBuilder_.dispose();
        jobQueryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Query used to search against jobs, such as keyword, location filters, etc.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobQuery job_query = 4;</code>
     */
    public com.google.cloud.talent.v4.JobQuery.Builder getJobQueryBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getJobQueryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Query used to search against jobs, such as keyword, location filters, etc.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobQuery job_query = 4;</code>
     */
    public com.google.cloud.talent.v4.JobQueryOrBuilder getJobQueryOrBuilder() {
      if (jobQueryBuilder_ != null) {
        return jobQueryBuilder_.getMessageOrBuilder();
      } else {
        return jobQuery_ == null
            ? com.google.cloud.talent.v4.JobQuery.getDefaultInstance()
            : jobQuery_;
      }
    }
    /**
     *
     *
     * <pre>
     * Query used to search against jobs, such as keyword, location filters, etc.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobQuery job_query = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.JobQuery,
            com.google.cloud.talent.v4.JobQuery.Builder,
            com.google.cloud.talent.v4.JobQueryOrBuilder>
        getJobQueryFieldBuilder() {
      if (jobQueryBuilder_ == null) {
        jobQueryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.talent.v4.JobQuery,
                com.google.cloud.talent.v4.JobQuery.Builder,
                com.google.cloud.talent.v4.JobQueryOrBuilder>(
                getJobQuery(), getParentForChildren(), isClean());
        jobQuery_ = null;
      }
      return jobQueryBuilder_;
    }

    private boolean enableBroadening_;
    /**
     *
     *
     * <pre>
     * Controls whether to broaden the search when it produces sparse results.
     * Broadened queries append results to the end of the matching results
     * list.
     *
     * Defaults to false.
     * </pre>
     *
     * <code>bool enable_broadening = 5;</code>
     *
     * @return The enableBroadening.
     */
    @java.lang.Override
    public boolean getEnableBroadening() {
      return enableBroadening_;
    }
    /**
     *
     *
     * <pre>
     * Controls whether to broaden the search when it produces sparse results.
     * Broadened queries append results to the end of the matching results
     * list.
     *
     * Defaults to false.
     * </pre>
     *
     * <code>bool enable_broadening = 5;</code>
     *
     * @param value The enableBroadening to set.
     * @return This builder for chaining.
     */
    public Builder setEnableBroadening(boolean value) {

      enableBroadening_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls whether to broaden the search when it produces sparse results.
     * Broadened queries append results to the end of the matching results
     * list.
     *
     * Defaults to false.
     * </pre>
     *
     * <code>bool enable_broadening = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableBroadening() {
      bitField0_ = (bitField0_ & ~0x00000010);
      enableBroadening_ = false;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.talent.v4.HistogramQuery> histogramQueries_ =
        java.util.Collections.emptyList();

    private void ensureHistogramQueriesIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        histogramQueries_ =
            new java.util.ArrayList<com.google.cloud.talent.v4.HistogramQuery>(histogramQueries_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.talent.v4.HistogramQuery,
            com.google.cloud.talent.v4.HistogramQuery.Builder,
            com.google.cloud.talent.v4.HistogramQueryOrBuilder>
        histogramQueriesBuilder_;

    /**
     *
     *
     * <pre>
     * An expression specifies a histogram request against matching jobs.
     *
     * Expression syntax is an aggregation function call with histogram facets and
     * other options.
     *
     * Available aggregation function calls are:
     * * `count(string_histogram_facet)`: Count the number of matching entities,
     * for each distinct attribute value.
     * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
     * matching entities within each bucket.
     *
     * A maximum of 200 histogram buckets are supported.
     *
     * Data types:
     *
     * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
     * * String: string like "any string with backslash escape for quote(&#92;")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
     *
     * Built-in constants:
     *
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     *
     * Built-in functions:
     *
     * * bucket(start, end[, label]): bucket built-in function creates a bucket
     * with range of [start, end). Note that the end is exclusive, for example,
     * bucket(1, MAX, "positive number") or bucket(1, 10).
     *
     * Job histogram facets:
     *
     * * company_display_name: histogram by
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
     * * employment_type: histogram by
     * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
     * example,
     *   "FULL_TIME", "PART_TIME".
     * * company_size (DEPRECATED): histogram by
     * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
     * "MEDIUM", "BIG".
     * * publish_time_in_day: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in days.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_month: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in months.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_year: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in years.
     *   Must specify list of numeric buckets in spec.
     * * degree_types: histogram by the
     * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
     *   "Bachelors", "Masters".
     * * job_level: histogram by the
     * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
     *   Level".
     * * country: histogram by the country code of jobs, for example, "US", "FR".
     * * admin1: histogram by the admin1 code of jobs, which is a global
     *   placeholder referring to the state, province, or the particular term a
     *   country uses to define the geographic structure below the country level,
     *   for example, "CA", "IL".
     * * city: histogram by a combination of the "city name, admin1 code". For
     *   example,  "Mountain View, CA", "New York, NY".
     * * admin1_country: histogram by a combination of the "admin1 code, country",
     *   for example, "CA, US", "IL, US".
     * * city_coordinate: histogram by the city center's GPS coordinates (latitude
     *   and longitude), for example, 37.4038522,-122.0987765. Since the
     *   coordinates of a city center can change, customers may need to refresh
     *   them periodically.
     * * locale: histogram by the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
     * "en-US",
     *   "fr-FR".
     * * language: histogram by the language subtag of the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code],
     *   for example, "en", "fr".
     * * category: histogram by the
     * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
     *   "COMPUTER_AND_IT", "HEALTHCARE".
     * * base_compensation_unit: histogram by the
     *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
     *   of base salary, for example, "WEEKLY", "MONTHLY".
     * * base_compensation: histogram by the base salary. Must specify list of
     *   numeric buckets to group results by.
     * * annualized_base_compensation: histogram by the base annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * annualized_total_compensation: histogram by the total annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * string_custom_attribute: histogram by string
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   string_custom_attribute["key1"].
     * * numeric_custom_attribute: histogram by numeric
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
     *   group results by.
     *
     * Example expressions:
     *
     * * `count(admin1)`
     * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
     * bucket(100000, MAX)])`
     * * `count(string_custom_attribute["some-string-custom-attribute"])`
     * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
     *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
     */
    public java.util.List<com.google.cloud.talent.v4.HistogramQuery> getHistogramQueriesList() {
      if (histogramQueriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(histogramQueries_);
      } else {
        return histogramQueriesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * An expression specifies a histogram request against matching jobs.
     *
     * Expression syntax is an aggregation function call with histogram facets and
     * other options.
     *
     * Available aggregation function calls are:
     * * `count(string_histogram_facet)`: Count the number of matching entities,
     * for each distinct attribute value.
     * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
     * matching entities within each bucket.
     *
     * A maximum of 200 histogram buckets are supported.
     *
     * Data types:
     *
     * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
     * * String: string like "any string with backslash escape for quote(&#92;")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
     *
     * Built-in constants:
     *
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     *
     * Built-in functions:
     *
     * * bucket(start, end[, label]): bucket built-in function creates a bucket
     * with range of [start, end). Note that the end is exclusive, for example,
     * bucket(1, MAX, "positive number") or bucket(1, 10).
     *
     * Job histogram facets:
     *
     * * company_display_name: histogram by
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
     * * employment_type: histogram by
     * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
     * example,
     *   "FULL_TIME", "PART_TIME".
     * * company_size (DEPRECATED): histogram by
     * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
     * "MEDIUM", "BIG".
     * * publish_time_in_day: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in days.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_month: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in months.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_year: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in years.
     *   Must specify list of numeric buckets in spec.
     * * degree_types: histogram by the
     * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
     *   "Bachelors", "Masters".
     * * job_level: histogram by the
     * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
     *   Level".
     * * country: histogram by the country code of jobs, for example, "US", "FR".
     * * admin1: histogram by the admin1 code of jobs, which is a global
     *   placeholder referring to the state, province, or the particular term a
     *   country uses to define the geographic structure below the country level,
     *   for example, "CA", "IL".
     * * city: histogram by a combination of the "city name, admin1 code". For
     *   example,  "Mountain View, CA", "New York, NY".
     * * admin1_country: histogram by a combination of the "admin1 code, country",
     *   for example, "CA, US", "IL, US".
     * * city_coordinate: histogram by the city center's GPS coordinates (latitude
     *   and longitude), for example, 37.4038522,-122.0987765. Since the
     *   coordinates of a city center can change, customers may need to refresh
     *   them periodically.
     * * locale: histogram by the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
     * "en-US",
     *   "fr-FR".
     * * language: histogram by the language subtag of the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code],
     *   for example, "en", "fr".
     * * category: histogram by the
     * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
     *   "COMPUTER_AND_IT", "HEALTHCARE".
     * * base_compensation_unit: histogram by the
     *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
     *   of base salary, for example, "WEEKLY", "MONTHLY".
     * * base_compensation: histogram by the base salary. Must specify list of
     *   numeric buckets to group results by.
     * * annualized_base_compensation: histogram by the base annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * annualized_total_compensation: histogram by the total annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * string_custom_attribute: histogram by string
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   string_custom_attribute["key1"].
     * * numeric_custom_attribute: histogram by numeric
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
     *   group results by.
     *
     * Example expressions:
     *
     * * `count(admin1)`
     * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
     * bucket(100000, MAX)])`
     * * `count(string_custom_attribute["some-string-custom-attribute"])`
     * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
     *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
     */
    public int getHistogramQueriesCount() {
      if (histogramQueriesBuilder_ == null) {
        return histogramQueries_.size();
      } else {
        return histogramQueriesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * An expression specifies a histogram request against matching jobs.
     *
     * Expression syntax is an aggregation function call with histogram facets and
     * other options.
     *
     * Available aggregation function calls are:
     * * `count(string_histogram_facet)`: Count the number of matching entities,
     * for each distinct attribute value.
     * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
     * matching entities within each bucket.
     *
     * A maximum of 200 histogram buckets are supported.
     *
     * Data types:
     *
     * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
     * * String: string like "any string with backslash escape for quote(&#92;")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
     *
     * Built-in constants:
     *
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     *
     * Built-in functions:
     *
     * * bucket(start, end[, label]): bucket built-in function creates a bucket
     * with range of [start, end). Note that the end is exclusive, for example,
     * bucket(1, MAX, "positive number") or bucket(1, 10).
     *
     * Job histogram facets:
     *
     * * company_display_name: histogram by
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
     * * employment_type: histogram by
     * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
     * example,
     *   "FULL_TIME", "PART_TIME".
     * * company_size (DEPRECATED): histogram by
     * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
     * "MEDIUM", "BIG".
     * * publish_time_in_day: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in days.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_month: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in months.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_year: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in years.
     *   Must specify list of numeric buckets in spec.
     * * degree_types: histogram by the
     * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
     *   "Bachelors", "Masters".
     * * job_level: histogram by the
     * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
     *   Level".
     * * country: histogram by the country code of jobs, for example, "US", "FR".
     * * admin1: histogram by the admin1 code of jobs, which is a global
     *   placeholder referring to the state, province, or the particular term a
     *   country uses to define the geographic structure below the country level,
     *   for example, "CA", "IL".
     * * city: histogram by a combination of the "city name, admin1 code". For
     *   example,  "Mountain View, CA", "New York, NY".
     * * admin1_country: histogram by a combination of the "admin1 code, country",
     *   for example, "CA, US", "IL, US".
     * * city_coordinate: histogram by the city center's GPS coordinates (latitude
     *   and longitude), for example, 37.4038522,-122.0987765. Since the
     *   coordinates of a city center can change, customers may need to refresh
     *   them periodically.
     * * locale: histogram by the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
     * "en-US",
     *   "fr-FR".
     * * language: histogram by the language subtag of the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code],
     *   for example, "en", "fr".
     * * category: histogram by the
     * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
     *   "COMPUTER_AND_IT", "HEALTHCARE".
     * * base_compensation_unit: histogram by the
     *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
     *   of base salary, for example, "WEEKLY", "MONTHLY".
     * * base_compensation: histogram by the base salary. Must specify list of
     *   numeric buckets to group results by.
     * * annualized_base_compensation: histogram by the base annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * annualized_total_compensation: histogram by the total annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * string_custom_attribute: histogram by string
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   string_custom_attribute["key1"].
     * * numeric_custom_attribute: histogram by numeric
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
     *   group results by.
     *
     * Example expressions:
     *
     * * `count(admin1)`
     * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
     * bucket(100000, MAX)])`
     * * `count(string_custom_attribute["some-string-custom-attribute"])`
     * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
     *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
     */
    public com.google.cloud.talent.v4.HistogramQuery getHistogramQueries(int index) {
      if (histogramQueriesBuilder_ == null) {
        return histogramQueries_.get(index);
      } else {
        return histogramQueriesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * An expression specifies a histogram request against matching jobs.
     *
     * Expression syntax is an aggregation function call with histogram facets and
     * other options.
     *
     * Available aggregation function calls are:
     * * `count(string_histogram_facet)`: Count the number of matching entities,
     * for each distinct attribute value.
     * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
     * matching entities within each bucket.
     *
     * A maximum of 200 histogram buckets are supported.
     *
     * Data types:
     *
     * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
     * * String: string like "any string with backslash escape for quote(&#92;")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
     *
     * Built-in constants:
     *
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     *
     * Built-in functions:
     *
     * * bucket(start, end[, label]): bucket built-in function creates a bucket
     * with range of [start, end). Note that the end is exclusive, for example,
     * bucket(1, MAX, "positive number") or bucket(1, 10).
     *
     * Job histogram facets:
     *
     * * company_display_name: histogram by
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
     * * employment_type: histogram by
     * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
     * example,
     *   "FULL_TIME", "PART_TIME".
     * * company_size (DEPRECATED): histogram by
     * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
     * "MEDIUM", "BIG".
     * * publish_time_in_day: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in days.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_month: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in months.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_year: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in years.
     *   Must specify list of numeric buckets in spec.
     * * degree_types: histogram by the
     * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
     *   "Bachelors", "Masters".
     * * job_level: histogram by the
     * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
     *   Level".
     * * country: histogram by the country code of jobs, for example, "US", "FR".
     * * admin1: histogram by the admin1 code of jobs, which is a global
     *   placeholder referring to the state, province, or the particular term a
     *   country uses to define the geographic structure below the country level,
     *   for example, "CA", "IL".
     * * city: histogram by a combination of the "city name, admin1 code". For
     *   example,  "Mountain View, CA", "New York, NY".
     * * admin1_country: histogram by a combination of the "admin1 code, country",
     *   for example, "CA, US", "IL, US".
     * * city_coordinate: histogram by the city center's GPS coordinates (latitude
     *   and longitude), for example, 37.4038522,-122.0987765. Since the
     *   coordinates of a city center can change, customers may need to refresh
     *   them periodically.
     * * locale: histogram by the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
     * "en-US",
     *   "fr-FR".
     * * language: histogram by the language subtag of the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code],
     *   for example, "en", "fr".
     * * category: histogram by the
     * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
     *   "COMPUTER_AND_IT", "HEALTHCARE".
     * * base_compensation_unit: histogram by the
     *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
     *   of base salary, for example, "WEEKLY", "MONTHLY".
     * * base_compensation: histogram by the base salary. Must specify list of
     *   numeric buckets to group results by.
     * * annualized_base_compensation: histogram by the base annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * annualized_total_compensation: histogram by the total annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * string_custom_attribute: histogram by string
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   string_custom_attribute["key1"].
     * * numeric_custom_attribute: histogram by numeric
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
     *   group results by.
     *
     * Example expressions:
     *
     * * `count(admin1)`
     * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
     * bucket(100000, MAX)])`
     * * `count(string_custom_attribute["some-string-custom-attribute"])`
     * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
     *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
     */
    public Builder setHistogramQueries(int index, com.google.cloud.talent.v4.HistogramQuery value) {
      if (histogramQueriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHistogramQueriesIsMutable();
        histogramQueries_.set(index, value);
        onChanged();
      } else {
        histogramQueriesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression specifies a histogram request against matching jobs.
     *
     * Expression syntax is an aggregation function call with histogram facets and
     * other options.
     *
     * Available aggregation function calls are:
     * * `count(string_histogram_facet)`: Count the number of matching entities,
     * for each distinct attribute value.
     * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
     * matching entities within each bucket.
     *
     * A maximum of 200 histogram buckets are supported.
     *
     * Data types:
     *
     * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
     * * String: string like "any string with backslash escape for quote(&#92;")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
     *
     * Built-in constants:
     *
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     *
     * Built-in functions:
     *
     * * bucket(start, end[, label]): bucket built-in function creates a bucket
     * with range of [start, end). Note that the end is exclusive, for example,
     * bucket(1, MAX, "positive number") or bucket(1, 10).
     *
     * Job histogram facets:
     *
     * * company_display_name: histogram by
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
     * * employment_type: histogram by
     * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
     * example,
     *   "FULL_TIME", "PART_TIME".
     * * company_size (DEPRECATED): histogram by
     * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
     * "MEDIUM", "BIG".
     * * publish_time_in_day: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in days.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_month: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in months.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_year: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in years.
     *   Must specify list of numeric buckets in spec.
     * * degree_types: histogram by the
     * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
     *   "Bachelors", "Masters".
     * * job_level: histogram by the
     * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
     *   Level".
     * * country: histogram by the country code of jobs, for example, "US", "FR".
     * * admin1: histogram by the admin1 code of jobs, which is a global
     *   placeholder referring to the state, province, or the particular term a
     *   country uses to define the geographic structure below the country level,
     *   for example, "CA", "IL".
     * * city: histogram by a combination of the "city name, admin1 code". For
     *   example,  "Mountain View, CA", "New York, NY".
     * * admin1_country: histogram by a combination of the "admin1 code, country",
     *   for example, "CA, US", "IL, US".
     * * city_coordinate: histogram by the city center's GPS coordinates (latitude
     *   and longitude), for example, 37.4038522,-122.0987765. Since the
     *   coordinates of a city center can change, customers may need to refresh
     *   them periodically.
     * * locale: histogram by the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
     * "en-US",
     *   "fr-FR".
     * * language: histogram by the language subtag of the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code],
     *   for example, "en", "fr".
     * * category: histogram by the
     * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
     *   "COMPUTER_AND_IT", "HEALTHCARE".
     * * base_compensation_unit: histogram by the
     *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
     *   of base salary, for example, "WEEKLY", "MONTHLY".
     * * base_compensation: histogram by the base salary. Must specify list of
     *   numeric buckets to group results by.
     * * annualized_base_compensation: histogram by the base annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * annualized_total_compensation: histogram by the total annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * string_custom_attribute: histogram by string
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   string_custom_attribute["key1"].
     * * numeric_custom_attribute: histogram by numeric
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
     *   group results by.
     *
     * Example expressions:
     *
     * * `count(admin1)`
     * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
     * bucket(100000, MAX)])`
     * * `count(string_custom_attribute["some-string-custom-attribute"])`
     * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
     *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
     */
    public Builder setHistogramQueries(
        int index, com.google.cloud.talent.v4.HistogramQuery.Builder builderForValue) {
      if (histogramQueriesBuilder_ == null) {
        ensureHistogramQueriesIsMutable();
        histogramQueries_.set(index, builderForValue.build());
        onChanged();
      } else {
        histogramQueriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression specifies a histogram request against matching jobs.
     *
     * Expression syntax is an aggregation function call with histogram facets and
     * other options.
     *
     * Available aggregation function calls are:
     * * `count(string_histogram_facet)`: Count the number of matching entities,
     * for each distinct attribute value.
     * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
     * matching entities within each bucket.
     *
     * A maximum of 200 histogram buckets are supported.
     *
     * Data types:
     *
     * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
     * * String: string like "any string with backslash escape for quote(&#92;")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
     *
     * Built-in constants:
     *
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     *
     * Built-in functions:
     *
     * * bucket(start, end[, label]): bucket built-in function creates a bucket
     * with range of [start, end). Note that the end is exclusive, for example,
     * bucket(1, MAX, "positive number") or bucket(1, 10).
     *
     * Job histogram facets:
     *
     * * company_display_name: histogram by
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
     * * employment_type: histogram by
     * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
     * example,
     *   "FULL_TIME", "PART_TIME".
     * * company_size (DEPRECATED): histogram by
     * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
     * "MEDIUM", "BIG".
     * * publish_time_in_day: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in days.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_month: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in months.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_year: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in years.
     *   Must specify list of numeric buckets in spec.
     * * degree_types: histogram by the
     * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
     *   "Bachelors", "Masters".
     * * job_level: histogram by the
     * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
     *   Level".
     * * country: histogram by the country code of jobs, for example, "US", "FR".
     * * admin1: histogram by the admin1 code of jobs, which is a global
     *   placeholder referring to the state, province, or the particular term a
     *   country uses to define the geographic structure below the country level,
     *   for example, "CA", "IL".
     * * city: histogram by a combination of the "city name, admin1 code". For
     *   example,  "Mountain View, CA", "New York, NY".
     * * admin1_country: histogram by a combination of the "admin1 code, country",
     *   for example, "CA, US", "IL, US".
     * * city_coordinate: histogram by the city center's GPS coordinates (latitude
     *   and longitude), for example, 37.4038522,-122.0987765. Since the
     *   coordinates of a city center can change, customers may need to refresh
     *   them periodically.
     * * locale: histogram by the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
     * "en-US",
     *   "fr-FR".
     * * language: histogram by the language subtag of the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code],
     *   for example, "en", "fr".
     * * category: histogram by the
     * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
     *   "COMPUTER_AND_IT", "HEALTHCARE".
     * * base_compensation_unit: histogram by the
     *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
     *   of base salary, for example, "WEEKLY", "MONTHLY".
     * * base_compensation: histogram by the base salary. Must specify list of
     *   numeric buckets to group results by.
     * * annualized_base_compensation: histogram by the base annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * annualized_total_compensation: histogram by the total annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * string_custom_attribute: histogram by string
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   string_custom_attribute["key1"].
     * * numeric_custom_attribute: histogram by numeric
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
     *   group results by.
     *
     * Example expressions:
     *
     * * `count(admin1)`
     * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
     * bucket(100000, MAX)])`
     * * `count(string_custom_attribute["some-string-custom-attribute"])`
     * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
     *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
     */
    public Builder addHistogramQueries(com.google.cloud.talent.v4.HistogramQuery value) {
      if (histogramQueriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHistogramQueriesIsMutable();
        histogramQueries_.add(value);
        onChanged();
      } else {
        histogramQueriesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression specifies a histogram request against matching jobs.
     *
     * Expression syntax is an aggregation function call with histogram facets and
     * other options.
     *
     * Available aggregation function calls are:
     * * `count(string_histogram_facet)`: Count the number of matching entities,
     * for each distinct attribute value.
     * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
     * matching entities within each bucket.
     *
     * A maximum of 200 histogram buckets are supported.
     *
     * Data types:
     *
     * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
     * * String: string like "any string with backslash escape for quote(&#92;")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
     *
     * Built-in constants:
     *
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     *
     * Built-in functions:
     *
     * * bucket(start, end[, label]): bucket built-in function creates a bucket
     * with range of [start, end). Note that the end is exclusive, for example,
     * bucket(1, MAX, "positive number") or bucket(1, 10).
     *
     * Job histogram facets:
     *
     * * company_display_name: histogram by
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
     * * employment_type: histogram by
     * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
     * example,
     *   "FULL_TIME", "PART_TIME".
     * * company_size (DEPRECATED): histogram by
     * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
     * "MEDIUM", "BIG".
     * * publish_time_in_day: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in days.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_month: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in months.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_year: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in years.
     *   Must specify list of numeric buckets in spec.
     * * degree_types: histogram by the
     * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
     *   "Bachelors", "Masters".
     * * job_level: histogram by the
     * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
     *   Level".
     * * country: histogram by the country code of jobs, for example, "US", "FR".
     * * admin1: histogram by the admin1 code of jobs, which is a global
     *   placeholder referring to the state, province, or the particular term a
     *   country uses to define the geographic structure below the country level,
     *   for example, "CA", "IL".
     * * city: histogram by a combination of the "city name, admin1 code". For
     *   example,  "Mountain View, CA", "New York, NY".
     * * admin1_country: histogram by a combination of the "admin1 code, country",
     *   for example, "CA, US", "IL, US".
     * * city_coordinate: histogram by the city center's GPS coordinates (latitude
     *   and longitude), for example, 37.4038522,-122.0987765. Since the
     *   coordinates of a city center can change, customers may need to refresh
     *   them periodically.
     * * locale: histogram by the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
     * "en-US",
     *   "fr-FR".
     * * language: histogram by the language subtag of the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code],
     *   for example, "en", "fr".
     * * category: histogram by the
     * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
     *   "COMPUTER_AND_IT", "HEALTHCARE".
     * * base_compensation_unit: histogram by the
     *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
     *   of base salary, for example, "WEEKLY", "MONTHLY".
     * * base_compensation: histogram by the base salary. Must specify list of
     *   numeric buckets to group results by.
     * * annualized_base_compensation: histogram by the base annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * annualized_total_compensation: histogram by the total annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * string_custom_attribute: histogram by string
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   string_custom_attribute["key1"].
     * * numeric_custom_attribute: histogram by numeric
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
     *   group results by.
     *
     * Example expressions:
     *
     * * `count(admin1)`
     * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
     * bucket(100000, MAX)])`
     * * `count(string_custom_attribute["some-string-custom-attribute"])`
     * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
     *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
     */
    public Builder addHistogramQueries(int index, com.google.cloud.talent.v4.HistogramQuery value) {
      if (histogramQueriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHistogramQueriesIsMutable();
        histogramQueries_.add(index, value);
        onChanged();
      } else {
        histogramQueriesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression specifies a histogram request against matching jobs.
     *
     * Expression syntax is an aggregation function call with histogram facets and
     * other options.
     *
     * Available aggregation function calls are:
     * * `count(string_histogram_facet)`: Count the number of matching entities,
     * for each distinct attribute value.
     * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
     * matching entities within each bucket.
     *
     * A maximum of 200 histogram buckets are supported.
     *
     * Data types:
     *
     * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
     * * String: string like "any string with backslash escape for quote(&#92;")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
     *
     * Built-in constants:
     *
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     *
     * Built-in functions:
     *
     * * bucket(start, end[, label]): bucket built-in function creates a bucket
     * with range of [start, end). Note that the end is exclusive, for example,
     * bucket(1, MAX, "positive number") or bucket(1, 10).
     *
     * Job histogram facets:
     *
     * * company_display_name: histogram by
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
     * * employment_type: histogram by
     * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
     * example,
     *   "FULL_TIME", "PART_TIME".
     * * company_size (DEPRECATED): histogram by
     * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
     * "MEDIUM", "BIG".
     * * publish_time_in_day: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in days.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_month: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in months.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_year: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in years.
     *   Must specify list of numeric buckets in spec.
     * * degree_types: histogram by the
     * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
     *   "Bachelors", "Masters".
     * * job_level: histogram by the
     * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
     *   Level".
     * * country: histogram by the country code of jobs, for example, "US", "FR".
     * * admin1: histogram by the admin1 code of jobs, which is a global
     *   placeholder referring to the state, province, or the particular term a
     *   country uses to define the geographic structure below the country level,
     *   for example, "CA", "IL".
     * * city: histogram by a combination of the "city name, admin1 code". For
     *   example,  "Mountain View, CA", "New York, NY".
     * * admin1_country: histogram by a combination of the "admin1 code, country",
     *   for example, "CA, US", "IL, US".
     * * city_coordinate: histogram by the city center's GPS coordinates (latitude
     *   and longitude), for example, 37.4038522,-122.0987765. Since the
     *   coordinates of a city center can change, customers may need to refresh
     *   them periodically.
     * * locale: histogram by the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
     * "en-US",
     *   "fr-FR".
     * * language: histogram by the language subtag of the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code],
     *   for example, "en", "fr".
     * * category: histogram by the
     * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
     *   "COMPUTER_AND_IT", "HEALTHCARE".
     * * base_compensation_unit: histogram by the
     *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
     *   of base salary, for example, "WEEKLY", "MONTHLY".
     * * base_compensation: histogram by the base salary. Must specify list of
     *   numeric buckets to group results by.
     * * annualized_base_compensation: histogram by the base annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * annualized_total_compensation: histogram by the total annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * string_custom_attribute: histogram by string
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   string_custom_attribute["key1"].
     * * numeric_custom_attribute: histogram by numeric
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
     *   group results by.
     *
     * Example expressions:
     *
     * * `count(admin1)`
     * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
     * bucket(100000, MAX)])`
     * * `count(string_custom_attribute["some-string-custom-attribute"])`
     * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
     *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
     */
    public Builder addHistogramQueries(
        com.google.cloud.talent.v4.HistogramQuery.Builder builderForValue) {
      if (histogramQueriesBuilder_ == null) {
        ensureHistogramQueriesIsMutable();
        histogramQueries_.add(builderForValue.build());
        onChanged();
      } else {
        histogramQueriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression specifies a histogram request against matching jobs.
     *
     * Expression syntax is an aggregation function call with histogram facets and
     * other options.
     *
     * Available aggregation function calls are:
     * * `count(string_histogram_facet)`: Count the number of matching entities,
     * for each distinct attribute value.
     * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
     * matching entities within each bucket.
     *
     * A maximum of 200 histogram buckets are supported.
     *
     * Data types:
     *
     * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
     * * String: string like "any string with backslash escape for quote(&#92;")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
     *
     * Built-in constants:
     *
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     *
     * Built-in functions:
     *
     * * bucket(start, end[, label]): bucket built-in function creates a bucket
     * with range of [start, end). Note that the end is exclusive, for example,
     * bucket(1, MAX, "positive number") or bucket(1, 10).
     *
     * Job histogram facets:
     *
     * * company_display_name: histogram by
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
     * * employment_type: histogram by
     * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
     * example,
     *   "FULL_TIME", "PART_TIME".
     * * company_size (DEPRECATED): histogram by
     * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
     * "MEDIUM", "BIG".
     * * publish_time_in_day: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in days.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_month: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in months.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_year: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in years.
     *   Must specify list of numeric buckets in spec.
     * * degree_types: histogram by the
     * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
     *   "Bachelors", "Masters".
     * * job_level: histogram by the
     * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
     *   Level".
     * * country: histogram by the country code of jobs, for example, "US", "FR".
     * * admin1: histogram by the admin1 code of jobs, which is a global
     *   placeholder referring to the state, province, or the particular term a
     *   country uses to define the geographic structure below the country level,
     *   for example, "CA", "IL".
     * * city: histogram by a combination of the "city name, admin1 code". For
     *   example,  "Mountain View, CA", "New York, NY".
     * * admin1_country: histogram by a combination of the "admin1 code, country",
     *   for example, "CA, US", "IL, US".
     * * city_coordinate: histogram by the city center's GPS coordinates (latitude
     *   and longitude), for example, 37.4038522,-122.0987765. Since the
     *   coordinates of a city center can change, customers may need to refresh
     *   them periodically.
     * * locale: histogram by the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
     * "en-US",
     *   "fr-FR".
     * * language: histogram by the language subtag of the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code],
     *   for example, "en", "fr".
     * * category: histogram by the
     * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
     *   "COMPUTER_AND_IT", "HEALTHCARE".
     * * base_compensation_unit: histogram by the
     *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
     *   of base salary, for example, "WEEKLY", "MONTHLY".
     * * base_compensation: histogram by the base salary. Must specify list of
     *   numeric buckets to group results by.
     * * annualized_base_compensation: histogram by the base annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * annualized_total_compensation: histogram by the total annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * string_custom_attribute: histogram by string
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   string_custom_attribute["key1"].
     * * numeric_custom_attribute: histogram by numeric
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
     *   group results by.
     *
     * Example expressions:
     *
     * * `count(admin1)`
     * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
     * bucket(100000, MAX)])`
     * * `count(string_custom_attribute["some-string-custom-attribute"])`
     * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
     *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
     */
    public Builder addHistogramQueries(
        int index, com.google.cloud.talent.v4.HistogramQuery.Builder builderForValue) {
      if (histogramQueriesBuilder_ == null) {
        ensureHistogramQueriesIsMutable();
        histogramQueries_.add(index, builderForValue.build());
        onChanged();
      } else {
        histogramQueriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression specifies a histogram request against matching jobs.
     *
     * Expression syntax is an aggregation function call with histogram facets and
     * other options.
     *
     * Available aggregation function calls are:
     * * `count(string_histogram_facet)`: Count the number of matching entities,
     * for each distinct attribute value.
     * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
     * matching entities within each bucket.
     *
     * A maximum of 200 histogram buckets are supported.
     *
     * Data types:
     *
     * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
     * * String: string like "any string with backslash escape for quote(&#92;")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
     *
     * Built-in constants:
     *
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     *
     * Built-in functions:
     *
     * * bucket(start, end[, label]): bucket built-in function creates a bucket
     * with range of [start, end). Note that the end is exclusive, for example,
     * bucket(1, MAX, "positive number") or bucket(1, 10).
     *
     * Job histogram facets:
     *
     * * company_display_name: histogram by
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
     * * employment_type: histogram by
     * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
     * example,
     *   "FULL_TIME", "PART_TIME".
     * * company_size (DEPRECATED): histogram by
     * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
     * "MEDIUM", "BIG".
     * * publish_time_in_day: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in days.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_month: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in months.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_year: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in years.
     *   Must specify list of numeric buckets in spec.
     * * degree_types: histogram by the
     * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
     *   "Bachelors", "Masters".
     * * job_level: histogram by the
     * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
     *   Level".
     * * country: histogram by the country code of jobs, for example, "US", "FR".
     * * admin1: histogram by the admin1 code of jobs, which is a global
     *   placeholder referring to the state, province, or the particular term a
     *   country uses to define the geographic structure below the country level,
     *   for example, "CA", "IL".
     * * city: histogram by a combination of the "city name, admin1 code". For
     *   example,  "Mountain View, CA", "New York, NY".
     * * admin1_country: histogram by a combination of the "admin1 code, country",
     *   for example, "CA, US", "IL, US".
     * * city_coordinate: histogram by the city center's GPS coordinates (latitude
     *   and longitude), for example, 37.4038522,-122.0987765. Since the
     *   coordinates of a city center can change, customers may need to refresh
     *   them periodically.
     * * locale: histogram by the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
     * "en-US",
     *   "fr-FR".
     * * language: histogram by the language subtag of the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code],
     *   for example, "en", "fr".
     * * category: histogram by the
     * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
     *   "COMPUTER_AND_IT", "HEALTHCARE".
     * * base_compensation_unit: histogram by the
     *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
     *   of base salary, for example, "WEEKLY", "MONTHLY".
     * * base_compensation: histogram by the base salary. Must specify list of
     *   numeric buckets to group results by.
     * * annualized_base_compensation: histogram by the base annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * annualized_total_compensation: histogram by the total annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * string_custom_attribute: histogram by string
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   string_custom_attribute["key1"].
     * * numeric_custom_attribute: histogram by numeric
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
     *   group results by.
     *
     * Example expressions:
     *
     * * `count(admin1)`
     * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
     * bucket(100000, MAX)])`
     * * `count(string_custom_attribute["some-string-custom-attribute"])`
     * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
     *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
     */
    public Builder addAllHistogramQueries(
        java.lang.Iterable<? extends com.google.cloud.talent.v4.HistogramQuery> values) {
      if (histogramQueriesBuilder_ == null) {
        ensureHistogramQueriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, histogramQueries_);
        onChanged();
      } else {
        histogramQueriesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression specifies a histogram request against matching jobs.
     *
     * Expression syntax is an aggregation function call with histogram facets and
     * other options.
     *
     * Available aggregation function calls are:
     * * `count(string_histogram_facet)`: Count the number of matching entities,
     * for each distinct attribute value.
     * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
     * matching entities within each bucket.
     *
     * A maximum of 200 histogram buckets are supported.
     *
     * Data types:
     *
     * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
     * * String: string like "any string with backslash escape for quote(&#92;")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
     *
     * Built-in constants:
     *
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     *
     * Built-in functions:
     *
     * * bucket(start, end[, label]): bucket built-in function creates a bucket
     * with range of [start, end). Note that the end is exclusive, for example,
     * bucket(1, MAX, "positive number") or bucket(1, 10).
     *
     * Job histogram facets:
     *
     * * company_display_name: histogram by
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
     * * employment_type: histogram by
     * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
     * example,
     *   "FULL_TIME", "PART_TIME".
     * * company_size (DEPRECATED): histogram by
     * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
     * "MEDIUM", "BIG".
     * * publish_time_in_day: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in days.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_month: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in months.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_year: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in years.
     *   Must specify list of numeric buckets in spec.
     * * degree_types: histogram by the
     * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
     *   "Bachelors", "Masters".
     * * job_level: histogram by the
     * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
     *   Level".
     * * country: histogram by the country code of jobs, for example, "US", "FR".
     * * admin1: histogram by the admin1 code of jobs, which is a global
     *   placeholder referring to the state, province, or the particular term a
     *   country uses to define the geographic structure below the country level,
     *   for example, "CA", "IL".
     * * city: histogram by a combination of the "city name, admin1 code". For
     *   example,  "Mountain View, CA", "New York, NY".
     * * admin1_country: histogram by a combination of the "admin1 code, country",
     *   for example, "CA, US", "IL, US".
     * * city_coordinate: histogram by the city center's GPS coordinates (latitude
     *   and longitude), for example, 37.4038522,-122.0987765. Since the
     *   coordinates of a city center can change, customers may need to refresh
     *   them periodically.
     * * locale: histogram by the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
     * "en-US",
     *   "fr-FR".
     * * language: histogram by the language subtag of the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code],
     *   for example, "en", "fr".
     * * category: histogram by the
     * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
     *   "COMPUTER_AND_IT", "HEALTHCARE".
     * * base_compensation_unit: histogram by the
     *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
     *   of base salary, for example, "WEEKLY", "MONTHLY".
     * * base_compensation: histogram by the base salary. Must specify list of
     *   numeric buckets to group results by.
     * * annualized_base_compensation: histogram by the base annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * annualized_total_compensation: histogram by the total annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * string_custom_attribute: histogram by string
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   string_custom_attribute["key1"].
     * * numeric_custom_attribute: histogram by numeric
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
     *   group results by.
     *
     * Example expressions:
     *
     * * `count(admin1)`
     * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
     * bucket(100000, MAX)])`
     * * `count(string_custom_attribute["some-string-custom-attribute"])`
     * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
     *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
     */
    public Builder clearHistogramQueries() {
      if (histogramQueriesBuilder_ == null) {
        histogramQueries_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        histogramQueriesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression specifies a histogram request against matching jobs.
     *
     * Expression syntax is an aggregation function call with histogram facets and
     * other options.
     *
     * Available aggregation function calls are:
     * * `count(string_histogram_facet)`: Count the number of matching entities,
     * for each distinct attribute value.
     * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
     * matching entities within each bucket.
     *
     * A maximum of 200 histogram buckets are supported.
     *
     * Data types:
     *
     * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
     * * String: string like "any string with backslash escape for quote(&#92;")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
     *
     * Built-in constants:
     *
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     *
     * Built-in functions:
     *
     * * bucket(start, end[, label]): bucket built-in function creates a bucket
     * with range of [start, end). Note that the end is exclusive, for example,
     * bucket(1, MAX, "positive number") or bucket(1, 10).
     *
     * Job histogram facets:
     *
     * * company_display_name: histogram by
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
     * * employment_type: histogram by
     * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
     * example,
     *   "FULL_TIME", "PART_TIME".
     * * company_size (DEPRECATED): histogram by
     * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
     * "MEDIUM", "BIG".
     * * publish_time_in_day: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in days.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_month: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in months.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_year: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in years.
     *   Must specify list of numeric buckets in spec.
     * * degree_types: histogram by the
     * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
     *   "Bachelors", "Masters".
     * * job_level: histogram by the
     * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
     *   Level".
     * * country: histogram by the country code of jobs, for example, "US", "FR".
     * * admin1: histogram by the admin1 code of jobs, which is a global
     *   placeholder referring to the state, province, or the particular term a
     *   country uses to define the geographic structure below the country level,
     *   for example, "CA", "IL".
     * * city: histogram by a combination of the "city name, admin1 code". For
     *   example,  "Mountain View, CA", "New York, NY".
     * * admin1_country: histogram by a combination of the "admin1 code, country",
     *   for example, "CA, US", "IL, US".
     * * city_coordinate: histogram by the city center's GPS coordinates (latitude
     *   and longitude), for example, 37.4038522,-122.0987765. Since the
     *   coordinates of a city center can change, customers may need to refresh
     *   them periodically.
     * * locale: histogram by the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
     * "en-US",
     *   "fr-FR".
     * * language: histogram by the language subtag of the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code],
     *   for example, "en", "fr".
     * * category: histogram by the
     * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
     *   "COMPUTER_AND_IT", "HEALTHCARE".
     * * base_compensation_unit: histogram by the
     *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
     *   of base salary, for example, "WEEKLY", "MONTHLY".
     * * base_compensation: histogram by the base salary. Must specify list of
     *   numeric buckets to group results by.
     * * annualized_base_compensation: histogram by the base annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * annualized_total_compensation: histogram by the total annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * string_custom_attribute: histogram by string
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   string_custom_attribute["key1"].
     * * numeric_custom_attribute: histogram by numeric
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
     *   group results by.
     *
     * Example expressions:
     *
     * * `count(admin1)`
     * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
     * bucket(100000, MAX)])`
     * * `count(string_custom_attribute["some-string-custom-attribute"])`
     * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
     *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
     */
    public Builder removeHistogramQueries(int index) {
      if (histogramQueriesBuilder_ == null) {
        ensureHistogramQueriesIsMutable();
        histogramQueries_.remove(index);
        onChanged();
      } else {
        histogramQueriesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An expression specifies a histogram request against matching jobs.
     *
     * Expression syntax is an aggregation function call with histogram facets and
     * other options.
     *
     * Available aggregation function calls are:
     * * `count(string_histogram_facet)`: Count the number of matching entities,
     * for each distinct attribute value.
     * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
     * matching entities within each bucket.
     *
     * A maximum of 200 histogram buckets are supported.
     *
     * Data types:
     *
     * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
     * * String: string like "any string with backslash escape for quote(&#92;")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
     *
     * Built-in constants:
     *
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     *
     * Built-in functions:
     *
     * * bucket(start, end[, label]): bucket built-in function creates a bucket
     * with range of [start, end). Note that the end is exclusive, for example,
     * bucket(1, MAX, "positive number") or bucket(1, 10).
     *
     * Job histogram facets:
     *
     * * company_display_name: histogram by
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
     * * employment_type: histogram by
     * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
     * example,
     *   "FULL_TIME", "PART_TIME".
     * * company_size (DEPRECATED): histogram by
     * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
     * "MEDIUM", "BIG".
     * * publish_time_in_day: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in days.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_month: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in months.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_year: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in years.
     *   Must specify list of numeric buckets in spec.
     * * degree_types: histogram by the
     * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
     *   "Bachelors", "Masters".
     * * job_level: histogram by the
     * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
     *   Level".
     * * country: histogram by the country code of jobs, for example, "US", "FR".
     * * admin1: histogram by the admin1 code of jobs, which is a global
     *   placeholder referring to the state, province, or the particular term a
     *   country uses to define the geographic structure below the country level,
     *   for example, "CA", "IL".
     * * city: histogram by a combination of the "city name, admin1 code". For
     *   example,  "Mountain View, CA", "New York, NY".
     * * admin1_country: histogram by a combination of the "admin1 code, country",
     *   for example, "CA, US", "IL, US".
     * * city_coordinate: histogram by the city center's GPS coordinates (latitude
     *   and longitude), for example, 37.4038522,-122.0987765. Since the
     *   coordinates of a city center can change, customers may need to refresh
     *   them periodically.
     * * locale: histogram by the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
     * "en-US",
     *   "fr-FR".
     * * language: histogram by the language subtag of the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code],
     *   for example, "en", "fr".
     * * category: histogram by the
     * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
     *   "COMPUTER_AND_IT", "HEALTHCARE".
     * * base_compensation_unit: histogram by the
     *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
     *   of base salary, for example, "WEEKLY", "MONTHLY".
     * * base_compensation: histogram by the base salary. Must specify list of
     *   numeric buckets to group results by.
     * * annualized_base_compensation: histogram by the base annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * annualized_total_compensation: histogram by the total annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * string_custom_attribute: histogram by string
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   string_custom_attribute["key1"].
     * * numeric_custom_attribute: histogram by numeric
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
     *   group results by.
     *
     * Example expressions:
     *
     * * `count(admin1)`
     * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
     * bucket(100000, MAX)])`
     * * `count(string_custom_attribute["some-string-custom-attribute"])`
     * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
     *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
     */
    public com.google.cloud.talent.v4.HistogramQuery.Builder getHistogramQueriesBuilder(int index) {
      return getHistogramQueriesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * An expression specifies a histogram request against matching jobs.
     *
     * Expression syntax is an aggregation function call with histogram facets and
     * other options.
     *
     * Available aggregation function calls are:
     * * `count(string_histogram_facet)`: Count the number of matching entities,
     * for each distinct attribute value.
     * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
     * matching entities within each bucket.
     *
     * A maximum of 200 histogram buckets are supported.
     *
     * Data types:
     *
     * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
     * * String: string like "any string with backslash escape for quote(&#92;")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
     *
     * Built-in constants:
     *
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     *
     * Built-in functions:
     *
     * * bucket(start, end[, label]): bucket built-in function creates a bucket
     * with range of [start, end). Note that the end is exclusive, for example,
     * bucket(1, MAX, "positive number") or bucket(1, 10).
     *
     * Job histogram facets:
     *
     * * company_display_name: histogram by
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
     * * employment_type: histogram by
     * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
     * example,
     *   "FULL_TIME", "PART_TIME".
     * * company_size (DEPRECATED): histogram by
     * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
     * "MEDIUM", "BIG".
     * * publish_time_in_day: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in days.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_month: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in months.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_year: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in years.
     *   Must specify list of numeric buckets in spec.
     * * degree_types: histogram by the
     * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
     *   "Bachelors", "Masters".
     * * job_level: histogram by the
     * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
     *   Level".
     * * country: histogram by the country code of jobs, for example, "US", "FR".
     * * admin1: histogram by the admin1 code of jobs, which is a global
     *   placeholder referring to the state, province, or the particular term a
     *   country uses to define the geographic structure below the country level,
     *   for example, "CA", "IL".
     * * city: histogram by a combination of the "city name, admin1 code". For
     *   example,  "Mountain View, CA", "New York, NY".
     * * admin1_country: histogram by a combination of the "admin1 code, country",
     *   for example, "CA, US", "IL, US".
     * * city_coordinate: histogram by the city center's GPS coordinates (latitude
     *   and longitude), for example, 37.4038522,-122.0987765. Since the
     *   coordinates of a city center can change, customers may need to refresh
     *   them periodically.
     * * locale: histogram by the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
     * "en-US",
     *   "fr-FR".
     * * language: histogram by the language subtag of the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code],
     *   for example, "en", "fr".
     * * category: histogram by the
     * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
     *   "COMPUTER_AND_IT", "HEALTHCARE".
     * * base_compensation_unit: histogram by the
     *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
     *   of base salary, for example, "WEEKLY", "MONTHLY".
     * * base_compensation: histogram by the base salary. Must specify list of
     *   numeric buckets to group results by.
     * * annualized_base_compensation: histogram by the base annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * annualized_total_compensation: histogram by the total annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * string_custom_attribute: histogram by string
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   string_custom_attribute["key1"].
     * * numeric_custom_attribute: histogram by numeric
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
     *   group results by.
     *
     * Example expressions:
     *
     * * `count(admin1)`
     * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
     * bucket(100000, MAX)])`
     * * `count(string_custom_attribute["some-string-custom-attribute"])`
     * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
     *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
     */
    public com.google.cloud.talent.v4.HistogramQueryOrBuilder getHistogramQueriesOrBuilder(
        int index) {
      if (histogramQueriesBuilder_ == null) {
        return histogramQueries_.get(index);
      } else {
        return histogramQueriesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * An expression specifies a histogram request against matching jobs.
     *
     * Expression syntax is an aggregation function call with histogram facets and
     * other options.
     *
     * Available aggregation function calls are:
     * * `count(string_histogram_facet)`: Count the number of matching entities,
     * for each distinct attribute value.
     * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
     * matching entities within each bucket.
     *
     * A maximum of 200 histogram buckets are supported.
     *
     * Data types:
     *
     * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
     * * String: string like "any string with backslash escape for quote(&#92;")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
     *
     * Built-in constants:
     *
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     *
     * Built-in functions:
     *
     * * bucket(start, end[, label]): bucket built-in function creates a bucket
     * with range of [start, end). Note that the end is exclusive, for example,
     * bucket(1, MAX, "positive number") or bucket(1, 10).
     *
     * Job histogram facets:
     *
     * * company_display_name: histogram by
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
     * * employment_type: histogram by
     * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
     * example,
     *   "FULL_TIME", "PART_TIME".
     * * company_size (DEPRECATED): histogram by
     * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
     * "MEDIUM", "BIG".
     * * publish_time_in_day: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in days.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_month: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in months.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_year: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in years.
     *   Must specify list of numeric buckets in spec.
     * * degree_types: histogram by the
     * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
     *   "Bachelors", "Masters".
     * * job_level: histogram by the
     * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
     *   Level".
     * * country: histogram by the country code of jobs, for example, "US", "FR".
     * * admin1: histogram by the admin1 code of jobs, which is a global
     *   placeholder referring to the state, province, or the particular term a
     *   country uses to define the geographic structure below the country level,
     *   for example, "CA", "IL".
     * * city: histogram by a combination of the "city name, admin1 code". For
     *   example,  "Mountain View, CA", "New York, NY".
     * * admin1_country: histogram by a combination of the "admin1 code, country",
     *   for example, "CA, US", "IL, US".
     * * city_coordinate: histogram by the city center's GPS coordinates (latitude
     *   and longitude), for example, 37.4038522,-122.0987765. Since the
     *   coordinates of a city center can change, customers may need to refresh
     *   them periodically.
     * * locale: histogram by the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
     * "en-US",
     *   "fr-FR".
     * * language: histogram by the language subtag of the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code],
     *   for example, "en", "fr".
     * * category: histogram by the
     * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
     *   "COMPUTER_AND_IT", "HEALTHCARE".
     * * base_compensation_unit: histogram by the
     *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
     *   of base salary, for example, "WEEKLY", "MONTHLY".
     * * base_compensation: histogram by the base salary. Must specify list of
     *   numeric buckets to group results by.
     * * annualized_base_compensation: histogram by the base annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * annualized_total_compensation: histogram by the total annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * string_custom_attribute: histogram by string
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   string_custom_attribute["key1"].
     * * numeric_custom_attribute: histogram by numeric
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
     *   group results by.
     *
     * Example expressions:
     *
     * * `count(admin1)`
     * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
     * bucket(100000, MAX)])`
     * * `count(string_custom_attribute["some-string-custom-attribute"])`
     * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
     *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
     */
    public java.util.List<? extends com.google.cloud.talent.v4.HistogramQueryOrBuilder>
        getHistogramQueriesOrBuilderList() {
      if (histogramQueriesBuilder_ != null) {
        return histogramQueriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(histogramQueries_);
      }
    }
    /**
     *
     *
     * <pre>
     * An expression specifies a histogram request against matching jobs.
     *
     * Expression syntax is an aggregation function call with histogram facets and
     * other options.
     *
     * Available aggregation function calls are:
     * * `count(string_histogram_facet)`: Count the number of matching entities,
     * for each distinct attribute value.
     * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
     * matching entities within each bucket.
     *
     * A maximum of 200 histogram buckets are supported.
     *
     * Data types:
     *
     * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
     * * String: string like "any string with backslash escape for quote(&#92;")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
     *
     * Built-in constants:
     *
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     *
     * Built-in functions:
     *
     * * bucket(start, end[, label]): bucket built-in function creates a bucket
     * with range of [start, end). Note that the end is exclusive, for example,
     * bucket(1, MAX, "positive number") or bucket(1, 10).
     *
     * Job histogram facets:
     *
     * * company_display_name: histogram by
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
     * * employment_type: histogram by
     * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
     * example,
     *   "FULL_TIME", "PART_TIME".
     * * company_size (DEPRECATED): histogram by
     * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
     * "MEDIUM", "BIG".
     * * publish_time_in_day: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in days.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_month: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in months.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_year: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in years.
     *   Must specify list of numeric buckets in spec.
     * * degree_types: histogram by the
     * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
     *   "Bachelors", "Masters".
     * * job_level: histogram by the
     * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
     *   Level".
     * * country: histogram by the country code of jobs, for example, "US", "FR".
     * * admin1: histogram by the admin1 code of jobs, which is a global
     *   placeholder referring to the state, province, or the particular term a
     *   country uses to define the geographic structure below the country level,
     *   for example, "CA", "IL".
     * * city: histogram by a combination of the "city name, admin1 code". For
     *   example,  "Mountain View, CA", "New York, NY".
     * * admin1_country: histogram by a combination of the "admin1 code, country",
     *   for example, "CA, US", "IL, US".
     * * city_coordinate: histogram by the city center's GPS coordinates (latitude
     *   and longitude), for example, 37.4038522,-122.0987765. Since the
     *   coordinates of a city center can change, customers may need to refresh
     *   them periodically.
     * * locale: histogram by the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
     * "en-US",
     *   "fr-FR".
     * * language: histogram by the language subtag of the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code],
     *   for example, "en", "fr".
     * * category: histogram by the
     * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
     *   "COMPUTER_AND_IT", "HEALTHCARE".
     * * base_compensation_unit: histogram by the
     *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
     *   of base salary, for example, "WEEKLY", "MONTHLY".
     * * base_compensation: histogram by the base salary. Must specify list of
     *   numeric buckets to group results by.
     * * annualized_base_compensation: histogram by the base annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * annualized_total_compensation: histogram by the total annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * string_custom_attribute: histogram by string
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   string_custom_attribute["key1"].
     * * numeric_custom_attribute: histogram by numeric
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
     *   group results by.
     *
     * Example expressions:
     *
     * * `count(admin1)`
     * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
     * bucket(100000, MAX)])`
     * * `count(string_custom_attribute["some-string-custom-attribute"])`
     * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
     *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
     */
    public com.google.cloud.talent.v4.HistogramQuery.Builder addHistogramQueriesBuilder() {
      return getHistogramQueriesFieldBuilder()
          .addBuilder(com.google.cloud.talent.v4.HistogramQuery.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * An expression specifies a histogram request against matching jobs.
     *
     * Expression syntax is an aggregation function call with histogram facets and
     * other options.
     *
     * Available aggregation function calls are:
     * * `count(string_histogram_facet)`: Count the number of matching entities,
     * for each distinct attribute value.
     * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
     * matching entities within each bucket.
     *
     * A maximum of 200 histogram buckets are supported.
     *
     * Data types:
     *
     * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
     * * String: string like "any string with backslash escape for quote(&#92;")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
     *
     * Built-in constants:
     *
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     *
     * Built-in functions:
     *
     * * bucket(start, end[, label]): bucket built-in function creates a bucket
     * with range of [start, end). Note that the end is exclusive, for example,
     * bucket(1, MAX, "positive number") or bucket(1, 10).
     *
     * Job histogram facets:
     *
     * * company_display_name: histogram by
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
     * * employment_type: histogram by
     * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
     * example,
     *   "FULL_TIME", "PART_TIME".
     * * company_size (DEPRECATED): histogram by
     * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
     * "MEDIUM", "BIG".
     * * publish_time_in_day: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in days.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_month: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in months.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_year: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in years.
     *   Must specify list of numeric buckets in spec.
     * * degree_types: histogram by the
     * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
     *   "Bachelors", "Masters".
     * * job_level: histogram by the
     * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
     *   Level".
     * * country: histogram by the country code of jobs, for example, "US", "FR".
     * * admin1: histogram by the admin1 code of jobs, which is a global
     *   placeholder referring to the state, province, or the particular term a
     *   country uses to define the geographic structure below the country level,
     *   for example, "CA", "IL".
     * * city: histogram by a combination of the "city name, admin1 code". For
     *   example,  "Mountain View, CA", "New York, NY".
     * * admin1_country: histogram by a combination of the "admin1 code, country",
     *   for example, "CA, US", "IL, US".
     * * city_coordinate: histogram by the city center's GPS coordinates (latitude
     *   and longitude), for example, 37.4038522,-122.0987765. Since the
     *   coordinates of a city center can change, customers may need to refresh
     *   them periodically.
     * * locale: histogram by the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
     * "en-US",
     *   "fr-FR".
     * * language: histogram by the language subtag of the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code],
     *   for example, "en", "fr".
     * * category: histogram by the
     * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
     *   "COMPUTER_AND_IT", "HEALTHCARE".
     * * base_compensation_unit: histogram by the
     *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
     *   of base salary, for example, "WEEKLY", "MONTHLY".
     * * base_compensation: histogram by the base salary. Must specify list of
     *   numeric buckets to group results by.
     * * annualized_base_compensation: histogram by the base annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * annualized_total_compensation: histogram by the total annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * string_custom_attribute: histogram by string
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   string_custom_attribute["key1"].
     * * numeric_custom_attribute: histogram by numeric
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
     *   group results by.
     *
     * Example expressions:
     *
     * * `count(admin1)`
     * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
     * bucket(100000, MAX)])`
     * * `count(string_custom_attribute["some-string-custom-attribute"])`
     * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
     *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
     */
    public com.google.cloud.talent.v4.HistogramQuery.Builder addHistogramQueriesBuilder(int index) {
      return getHistogramQueriesFieldBuilder()
          .addBuilder(index, com.google.cloud.talent.v4.HistogramQuery.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * An expression specifies a histogram request against matching jobs.
     *
     * Expression syntax is an aggregation function call with histogram facets and
     * other options.
     *
     * Available aggregation function calls are:
     * * `count(string_histogram_facet)`: Count the number of matching entities,
     * for each distinct attribute value.
     * * `count(numeric_histogram_facet, list of buckets)`: Count the number of
     * matching entities within each bucket.
     *
     * A maximum of 200 histogram buckets are supported.
     *
     * Data types:
     *
     * * Histogram facet: facet names with format `[a-zA-Z][a-zA-Z0-9_]+`.
     * * String: string like "any string with backslash escape for quote(&#92;")."
     * * Number: whole number and floating point number like 10, -1 and -0.01.
     * * List: list of elements with comma(,) separator surrounded by square
     * brackets, for example, [1, 2, 3] and ["one", "two", "three"].
     *
     * Built-in constants:
     *
     * * MIN (minimum number similar to java Double.MIN_VALUE)
     * * MAX (maximum number similar to java Double.MAX_VALUE)
     *
     * Built-in functions:
     *
     * * bucket(start, end[, label]): bucket built-in function creates a bucket
     * with range of [start, end). Note that the end is exclusive, for example,
     * bucket(1, MAX, "positive number") or bucket(1, 10).
     *
     * Job histogram facets:
     *
     * * company_display_name: histogram by
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name].
     * * employment_type: histogram by
     * [Job.employment_types][google.cloud.talent.v4.Job.employment_types], for
     * example,
     *   "FULL_TIME", "PART_TIME".
     * * company_size (DEPRECATED): histogram by
     * [CompanySize][google.cloud.talent.v4.CompanySize], for example, "SMALL",
     * "MEDIUM", "BIG".
     * * publish_time_in_day: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in days.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_month: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in months.
     *   Must specify list of numeric buckets in spec.
     * * publish_time_in_year: histogram by the
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   in years.
     *   Must specify list of numeric buckets in spec.
     * * degree_types: histogram by the
     * [Job.degree_types][google.cloud.talent.v4.Job.degree_types], for example,
     *   "Bachelors", "Masters".
     * * job_level: histogram by the
     * [Job.job_level][google.cloud.talent.v4.Job.job_level], for example, "Entry
     *   Level".
     * * country: histogram by the country code of jobs, for example, "US", "FR".
     * * admin1: histogram by the admin1 code of jobs, which is a global
     *   placeholder referring to the state, province, or the particular term a
     *   country uses to define the geographic structure below the country level,
     *   for example, "CA", "IL".
     * * city: histogram by a combination of the "city name, admin1 code". For
     *   example,  "Mountain View, CA", "New York, NY".
     * * admin1_country: histogram by a combination of the "admin1 code, country",
     *   for example, "CA, US", "IL, US".
     * * city_coordinate: histogram by the city center's GPS coordinates (latitude
     *   and longitude), for example, 37.4038522,-122.0987765. Since the
     *   coordinates of a city center can change, customers may need to refresh
     *   them periodically.
     * * locale: histogram by the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code], for example,
     * "en-US",
     *   "fr-FR".
     * * language: histogram by the language subtag of the
     * [Job.language_code][google.cloud.talent.v4.Job.language_code],
     *   for example, "en", "fr".
     * * category: histogram by the
     * [JobCategory][google.cloud.talent.v4.JobCategory], for example,
     *   "COMPUTER_AND_IT", "HEALTHCARE".
     * * base_compensation_unit: histogram by the
     *   [CompensationInfo.CompensationUnit][google.cloud.talent.v4.CompensationInfo.CompensationUnit]
     *   of base salary, for example, "WEEKLY", "MONTHLY".
     * * base_compensation: histogram by the base salary. Must specify list of
     *   numeric buckets to group results by.
     * * annualized_base_compensation: histogram by the base annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * annualized_total_compensation: histogram by the total annualized salary.
     *   Must specify list of numeric buckets to group results by.
     * * string_custom_attribute: histogram by string
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   string_custom_attribute["key1"].
     * * numeric_custom_attribute: histogram by numeric
     * [Job.custom_attributes][google.cloud.talent.v4.Job.custom_attributes].
     *   Values can be accessed via square bracket notations like
     *   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
     *   group results by.
     *
     * Example expressions:
     *
     * * `count(admin1)`
     * * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
     * bucket(100000, MAX)])`
     * * `count(string_custom_attribute["some-string-custom-attribute"])`
     * * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
     *   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative")])`
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQuery histogram_queries = 7;</code>
     */
    public java.util.List<com.google.cloud.talent.v4.HistogramQuery.Builder>
        getHistogramQueriesBuilderList() {
      return getHistogramQueriesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.talent.v4.HistogramQuery,
            com.google.cloud.talent.v4.HistogramQuery.Builder,
            com.google.cloud.talent.v4.HistogramQueryOrBuilder>
        getHistogramQueriesFieldBuilder() {
      if (histogramQueriesBuilder_ == null) {
        histogramQueriesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.talent.v4.HistogramQuery,
                com.google.cloud.talent.v4.HistogramQuery.Builder,
                com.google.cloud.talent.v4.HistogramQueryOrBuilder>(
                histogramQueries_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        histogramQueries_ = null;
      }
      return histogramQueriesBuilder_;
    }

    private int jobView_ = 0;
    /**
     *
     *
     * <pre>
     * The desired job attributes returned for jobs in the search response.
     * Defaults to
     * [JobView.JOB_VIEW_SMALL][google.cloud.talent.v4.JobView.JOB_VIEW_SMALL] if
     * no value is specified.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobView job_view = 8;</code>
     *
     * @return The enum numeric value on the wire for jobView.
     */
    @java.lang.Override
    public int getJobViewValue() {
      return jobView_;
    }
    /**
     *
     *
     * <pre>
     * The desired job attributes returned for jobs in the search response.
     * Defaults to
     * [JobView.JOB_VIEW_SMALL][google.cloud.talent.v4.JobView.JOB_VIEW_SMALL] if
     * no value is specified.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobView job_view = 8;</code>
     *
     * @param value The enum numeric value on the wire for jobView to set.
     * @return This builder for chaining.
     */
    public Builder setJobViewValue(int value) {
      jobView_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired job attributes returned for jobs in the search response.
     * Defaults to
     * [JobView.JOB_VIEW_SMALL][google.cloud.talent.v4.JobView.JOB_VIEW_SMALL] if
     * no value is specified.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobView job_view = 8;</code>
     *
     * @return The jobView.
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.JobView getJobView() {
      com.google.cloud.talent.v4.JobView result =
          com.google.cloud.talent.v4.JobView.forNumber(jobView_);
      return result == null ? com.google.cloud.talent.v4.JobView.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The desired job attributes returned for jobs in the search response.
     * Defaults to
     * [JobView.JOB_VIEW_SMALL][google.cloud.talent.v4.JobView.JOB_VIEW_SMALL] if
     * no value is specified.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobView job_view = 8;</code>
     *
     * @param value The jobView to set.
     * @return This builder for chaining.
     */
    public Builder setJobView(com.google.cloud.talent.v4.JobView value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      jobView_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired job attributes returned for jobs in the search response.
     * Defaults to
     * [JobView.JOB_VIEW_SMALL][google.cloud.talent.v4.JobView.JOB_VIEW_SMALL] if
     * no value is specified.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.JobView job_view = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearJobView() {
      bitField0_ = (bitField0_ & ~0x00000040);
      jobView_ = 0;
      onChanged();
      return this;
    }

    private int offset_;
    /**
     *
     *
     * <pre>
     * An integer that specifies the current offset (that is, starting result
     * location, amongst the jobs deemed by the API as relevant) in search
     * results. This field is only considered if
     * [page_token][google.cloud.talent.v4.SearchJobsRequest.page_token] is unset.
     *
     * The maximum allowed value is 5000. Otherwise an error is thrown.
     *
     * For example, 0 means to  return results starting from the first matching
     * job, and 10 means to return from the 11th job. This can be used for
     * pagination, (for example, pageSize = 10 and offset = 10 means to return
     * from the second page).
     * </pre>
     *
     * <code>int32 offset = 9;</code>
     *
     * @return The offset.
     */
    @java.lang.Override
    public int getOffset() {
      return offset_;
    }
    /**
     *
     *
     * <pre>
     * An integer that specifies the current offset (that is, starting result
     * location, amongst the jobs deemed by the API as relevant) in search
     * results. This field is only considered if
     * [page_token][google.cloud.talent.v4.SearchJobsRequest.page_token] is unset.
     *
     * The maximum allowed value is 5000. Otherwise an error is thrown.
     *
     * For example, 0 means to  return results starting from the first matching
     * job, and 10 means to return from the 11th job. This can be used for
     * pagination, (for example, pageSize = 10 and offset = 10 means to return
     * from the second page).
     * </pre>
     *
     * <code>int32 offset = 9;</code>
     *
     * @param value The offset to set.
     * @return This builder for chaining.
     */
    public Builder setOffset(int value) {

      offset_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * An integer that specifies the current offset (that is, starting result
     * location, amongst the jobs deemed by the API as relevant) in search
     * results. This field is only considered if
     * [page_token][google.cloud.talent.v4.SearchJobsRequest.page_token] is unset.
     *
     * The maximum allowed value is 5000. Otherwise an error is thrown.
     *
     * For example, 0 means to  return results starting from the first matching
     * job, and 10 means to return from the 11th job. This can be used for
     * pagination, (for example, pageSize = 10 and offset = 10 means to return
     * from the second page).
     * </pre>
     *
     * <code>int32 offset = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOffset() {
      bitField0_ = (bitField0_ & ~0x00000080);
      offset_ = 0;
      onChanged();
      return this;
    }

    private int maxPageSize_;
    /**
     *
     *
     * <pre>
     * A limit on the number of jobs returned in the search results.
     * Increasing this value above the default value of 10 can increase search
     * response time. The value can be between 1 and 100.
     * </pre>
     *
     * <code>int32 max_page_size = 10;</code>
     *
     * @return The maxPageSize.
     */
    @java.lang.Override
    public int getMaxPageSize() {
      return maxPageSize_;
    }
    /**
     *
     *
     * <pre>
     * A limit on the number of jobs returned in the search results.
     * Increasing this value above the default value of 10 can increase search
     * response time. The value can be between 1 and 100.
     * </pre>
     *
     * <code>int32 max_page_size = 10;</code>
     *
     * @param value The maxPageSize to set.
     * @return This builder for chaining.
     */
    public Builder setMaxPageSize(int value) {

      maxPageSize_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A limit on the number of jobs returned in the search results.
     * Increasing this value above the default value of 10 can increase search
     * response time. The value can be between 1 and 100.
     * </pre>
     *
     * <code>int32 max_page_size = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxPageSize() {
      bitField0_ = (bitField0_ & ~0x00000100);
      maxPageSize_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pageToken_ = "";
    /**
     *
     *
     * <pre>
     * The token specifying the current offset within
     * search results. See
     * [SearchJobsResponse.next_page_token][google.cloud.talent.v4.SearchJobsResponse.next_page_token]
     * for an explanation of how to obtain the next set of query results.
     * </pre>
     *
     * <code>string page_token = 11;</code>
     *
     * @return The pageToken.
     */
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The token specifying the current offset within
     * search results. See
     * [SearchJobsResponse.next_page_token][google.cloud.talent.v4.SearchJobsResponse.next_page_token]
     * for an explanation of how to obtain the next set of query results.
     * </pre>
     *
     * <code>string page_token = 11;</code>
     *
     * @return The bytes for pageToken.
     */
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The token specifying the current offset within
     * search results. See
     * [SearchJobsResponse.next_page_token][google.cloud.talent.v4.SearchJobsResponse.next_page_token]
     * for an explanation of how to obtain the next set of query results.
     * </pre>
     *
     * <code>string page_token = 11;</code>
     *
     * @param value The pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pageToken_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The token specifying the current offset within
     * search results. See
     * [SearchJobsResponse.next_page_token][google.cloud.talent.v4.SearchJobsResponse.next_page_token]
     * for an explanation of how to obtain the next set of query results.
     * </pre>
     *
     * <code>string page_token = 11;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPageToken() {
      pageToken_ = getDefaultInstance().getPageToken();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The token specifying the current offset within
     * search results. See
     * [SearchJobsResponse.next_page_token][google.cloud.talent.v4.SearchJobsResponse.next_page_token]
     * for an explanation of how to obtain the next set of query results.
     * </pre>
     *
     * <code>string page_token = 11;</code>
     *
     * @param value The bytes for pageToken to set.
     * @return This builder for chaining.
     */
    public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pageToken_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private java.lang.Object orderBy_ = "";
    /**
     *
     *
     * <pre>
     * The criteria determining how search results are sorted. Default is
     * `"relevance desc"`.
     *
     * Supported options are:
     *
     * * `"relevance desc"`: By relevance descending, as determined by the API
     *   algorithms. Relevance thresholding of query results is only available
     *   with this ordering.
     * * `"posting_publish_time desc"`: By
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   descending.
     * * `"posting_update_time desc"`: By
     * [Job.posting_update_time][google.cloud.talent.v4.Job.posting_update_time]
     *   descending.
     * * `"title"`: By [Job.title][google.cloud.talent.v4.Job.title] ascending.
     * * `"title desc"`: By [Job.title][google.cloud.talent.v4.Job.title]
     * descending.
     * * `"annualized_base_compensation"`: By job's
     *   [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_base_compensation_range]
     *   ascending. Jobs whose annualized base compensation is unspecified are put
     *   at the end of search results.
     * * `"annualized_base_compensation desc"`: By job's
     *   [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_base_compensation_range]
     *   descending. Jobs whose annualized base compensation is unspecified are
     *   put at the end of search results.
     * * `"annualized_total_compensation"`: By job's
     *   [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_total_compensation_range]
     *   ascending. Jobs whose annualized base compensation is unspecified are put
     *   at the end of search results.
     * * `"annualized_total_compensation desc"`: By job's
     *   [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_total_compensation_range]
     *   descending. Jobs whose annualized base compensation is unspecified are
     *   put at the end of search results.
     * * `"custom_ranking desc"`: By the relevance score adjusted to the
     *   [SearchJobsRequest.CustomRankingInfo.ranking_expression][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ranking_expression]
     *   with weight factor assigned by
     *   [SearchJobsRequest.CustomRankingInfo.importance_level][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.importance_level]
     *   in descending order.
     * * Location sorting: Use the special syntax to order jobs by distance:&lt;br&gt;
     *   `"distance_from('Hawaii')"`: Order by distance from Hawaii.&lt;br&gt;
     *   `"distance_from(19.89, 155.5)"`: Order by distance from a coordinate.&lt;br&gt;
     *   `"distance_from('Hawaii'), distance_from('Puerto Rico')"`: Order by
     *   multiple locations. See details below.&lt;br&gt;
     *   `"distance_from('Hawaii'), distance_from(19.89, 155.5)"`: Order by
     *   multiple locations. See details below.&lt;br&gt;
     *   The string can have a maximum of 256 characters. When multiple distance
     *   centers are provided, a job that is close to any of the distance centers
     *   would have a high rank. When a job has multiple locations, the job
     *   location closest to one of the distance centers will be used. Jobs that
     *   don't have locations will be ranked at the bottom. Distance is calculated
     *   with a precision of 11.3 meters (37.4 feet). Diversification strategy is
     *   still applied unless explicitly disabled in
     *   [diversification_level][google.cloud.talent.v4.SearchJobsRequest.diversification_level].
     * </pre>
     *
     * <code>string order_by = 12;</code>
     *
     * @return The orderBy.
     */
    public java.lang.String getOrderBy() {
      java.lang.Object ref = orderBy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        orderBy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The criteria determining how search results are sorted. Default is
     * `"relevance desc"`.
     *
     * Supported options are:
     *
     * * `"relevance desc"`: By relevance descending, as determined by the API
     *   algorithms. Relevance thresholding of query results is only available
     *   with this ordering.
     * * `"posting_publish_time desc"`: By
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   descending.
     * * `"posting_update_time desc"`: By
     * [Job.posting_update_time][google.cloud.talent.v4.Job.posting_update_time]
     *   descending.
     * * `"title"`: By [Job.title][google.cloud.talent.v4.Job.title] ascending.
     * * `"title desc"`: By [Job.title][google.cloud.talent.v4.Job.title]
     * descending.
     * * `"annualized_base_compensation"`: By job's
     *   [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_base_compensation_range]
     *   ascending. Jobs whose annualized base compensation is unspecified are put
     *   at the end of search results.
     * * `"annualized_base_compensation desc"`: By job's
     *   [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_base_compensation_range]
     *   descending. Jobs whose annualized base compensation is unspecified are
     *   put at the end of search results.
     * * `"annualized_total_compensation"`: By job's
     *   [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_total_compensation_range]
     *   ascending. Jobs whose annualized base compensation is unspecified are put
     *   at the end of search results.
     * * `"annualized_total_compensation desc"`: By job's
     *   [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_total_compensation_range]
     *   descending. Jobs whose annualized base compensation is unspecified are
     *   put at the end of search results.
     * * `"custom_ranking desc"`: By the relevance score adjusted to the
     *   [SearchJobsRequest.CustomRankingInfo.ranking_expression][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ranking_expression]
     *   with weight factor assigned by
     *   [SearchJobsRequest.CustomRankingInfo.importance_level][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.importance_level]
     *   in descending order.
     * * Location sorting: Use the special syntax to order jobs by distance:&lt;br&gt;
     *   `"distance_from('Hawaii')"`: Order by distance from Hawaii.&lt;br&gt;
     *   `"distance_from(19.89, 155.5)"`: Order by distance from a coordinate.&lt;br&gt;
     *   `"distance_from('Hawaii'), distance_from('Puerto Rico')"`: Order by
     *   multiple locations. See details below.&lt;br&gt;
     *   `"distance_from('Hawaii'), distance_from(19.89, 155.5)"`: Order by
     *   multiple locations. See details below.&lt;br&gt;
     *   The string can have a maximum of 256 characters. When multiple distance
     *   centers are provided, a job that is close to any of the distance centers
     *   would have a high rank. When a job has multiple locations, the job
     *   location closest to one of the distance centers will be used. Jobs that
     *   don't have locations will be ranked at the bottom. Distance is calculated
     *   with a precision of 11.3 meters (37.4 feet). Diversification strategy is
     *   still applied unless explicitly disabled in
     *   [diversification_level][google.cloud.talent.v4.SearchJobsRequest.diversification_level].
     * </pre>
     *
     * <code>string order_by = 12;</code>
     *
     * @return The bytes for orderBy.
     */
    public com.google.protobuf.ByteString getOrderByBytes() {
      java.lang.Object ref = orderBy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        orderBy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The criteria determining how search results are sorted. Default is
     * `"relevance desc"`.
     *
     * Supported options are:
     *
     * * `"relevance desc"`: By relevance descending, as determined by the API
     *   algorithms. Relevance thresholding of query results is only available
     *   with this ordering.
     * * `"posting_publish_time desc"`: By
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   descending.
     * * `"posting_update_time desc"`: By
     * [Job.posting_update_time][google.cloud.talent.v4.Job.posting_update_time]
     *   descending.
     * * `"title"`: By [Job.title][google.cloud.talent.v4.Job.title] ascending.
     * * `"title desc"`: By [Job.title][google.cloud.talent.v4.Job.title]
     * descending.
     * * `"annualized_base_compensation"`: By job's
     *   [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_base_compensation_range]
     *   ascending. Jobs whose annualized base compensation is unspecified are put
     *   at the end of search results.
     * * `"annualized_base_compensation desc"`: By job's
     *   [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_base_compensation_range]
     *   descending. Jobs whose annualized base compensation is unspecified are
     *   put at the end of search results.
     * * `"annualized_total_compensation"`: By job's
     *   [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_total_compensation_range]
     *   ascending. Jobs whose annualized base compensation is unspecified are put
     *   at the end of search results.
     * * `"annualized_total_compensation desc"`: By job's
     *   [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_total_compensation_range]
     *   descending. Jobs whose annualized base compensation is unspecified are
     *   put at the end of search results.
     * * `"custom_ranking desc"`: By the relevance score adjusted to the
     *   [SearchJobsRequest.CustomRankingInfo.ranking_expression][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ranking_expression]
     *   with weight factor assigned by
     *   [SearchJobsRequest.CustomRankingInfo.importance_level][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.importance_level]
     *   in descending order.
     * * Location sorting: Use the special syntax to order jobs by distance:&lt;br&gt;
     *   `"distance_from('Hawaii')"`: Order by distance from Hawaii.&lt;br&gt;
     *   `"distance_from(19.89, 155.5)"`: Order by distance from a coordinate.&lt;br&gt;
     *   `"distance_from('Hawaii'), distance_from('Puerto Rico')"`: Order by
     *   multiple locations. See details below.&lt;br&gt;
     *   `"distance_from('Hawaii'), distance_from(19.89, 155.5)"`: Order by
     *   multiple locations. See details below.&lt;br&gt;
     *   The string can have a maximum of 256 characters. When multiple distance
     *   centers are provided, a job that is close to any of the distance centers
     *   would have a high rank. When a job has multiple locations, the job
     *   location closest to one of the distance centers will be used. Jobs that
     *   don't have locations will be ranked at the bottom. Distance is calculated
     *   with a precision of 11.3 meters (37.4 feet). Diversification strategy is
     *   still applied unless explicitly disabled in
     *   [diversification_level][google.cloud.talent.v4.SearchJobsRequest.diversification_level].
     * </pre>
     *
     * <code>string order_by = 12;</code>
     *
     * @param value The orderBy to set.
     * @return This builder for chaining.
     */
    public Builder setOrderBy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      orderBy_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The criteria determining how search results are sorted. Default is
     * `"relevance desc"`.
     *
     * Supported options are:
     *
     * * `"relevance desc"`: By relevance descending, as determined by the API
     *   algorithms. Relevance thresholding of query results is only available
     *   with this ordering.
     * * `"posting_publish_time desc"`: By
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   descending.
     * * `"posting_update_time desc"`: By
     * [Job.posting_update_time][google.cloud.talent.v4.Job.posting_update_time]
     *   descending.
     * * `"title"`: By [Job.title][google.cloud.talent.v4.Job.title] ascending.
     * * `"title desc"`: By [Job.title][google.cloud.talent.v4.Job.title]
     * descending.
     * * `"annualized_base_compensation"`: By job's
     *   [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_base_compensation_range]
     *   ascending. Jobs whose annualized base compensation is unspecified are put
     *   at the end of search results.
     * * `"annualized_base_compensation desc"`: By job's
     *   [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_base_compensation_range]
     *   descending. Jobs whose annualized base compensation is unspecified are
     *   put at the end of search results.
     * * `"annualized_total_compensation"`: By job's
     *   [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_total_compensation_range]
     *   ascending. Jobs whose annualized base compensation is unspecified are put
     *   at the end of search results.
     * * `"annualized_total_compensation desc"`: By job's
     *   [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_total_compensation_range]
     *   descending. Jobs whose annualized base compensation is unspecified are
     *   put at the end of search results.
     * * `"custom_ranking desc"`: By the relevance score adjusted to the
     *   [SearchJobsRequest.CustomRankingInfo.ranking_expression][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ranking_expression]
     *   with weight factor assigned by
     *   [SearchJobsRequest.CustomRankingInfo.importance_level][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.importance_level]
     *   in descending order.
     * * Location sorting: Use the special syntax to order jobs by distance:&lt;br&gt;
     *   `"distance_from('Hawaii')"`: Order by distance from Hawaii.&lt;br&gt;
     *   `"distance_from(19.89, 155.5)"`: Order by distance from a coordinate.&lt;br&gt;
     *   `"distance_from('Hawaii'), distance_from('Puerto Rico')"`: Order by
     *   multiple locations. See details below.&lt;br&gt;
     *   `"distance_from('Hawaii'), distance_from(19.89, 155.5)"`: Order by
     *   multiple locations. See details below.&lt;br&gt;
     *   The string can have a maximum of 256 characters. When multiple distance
     *   centers are provided, a job that is close to any of the distance centers
     *   would have a high rank. When a job has multiple locations, the job
     *   location closest to one of the distance centers will be used. Jobs that
     *   don't have locations will be ranked at the bottom. Distance is calculated
     *   with a precision of 11.3 meters (37.4 feet). Diversification strategy is
     *   still applied unless explicitly disabled in
     *   [diversification_level][google.cloud.talent.v4.SearchJobsRequest.diversification_level].
     * </pre>
     *
     * <code>string order_by = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOrderBy() {
      orderBy_ = getDefaultInstance().getOrderBy();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The criteria determining how search results are sorted. Default is
     * `"relevance desc"`.
     *
     * Supported options are:
     *
     * * `"relevance desc"`: By relevance descending, as determined by the API
     *   algorithms. Relevance thresholding of query results is only available
     *   with this ordering.
     * * `"posting_publish_time desc"`: By
     * [Job.posting_publish_time][google.cloud.talent.v4.Job.posting_publish_time]
     *   descending.
     * * `"posting_update_time desc"`: By
     * [Job.posting_update_time][google.cloud.talent.v4.Job.posting_update_time]
     *   descending.
     * * `"title"`: By [Job.title][google.cloud.talent.v4.Job.title] ascending.
     * * `"title desc"`: By [Job.title][google.cloud.talent.v4.Job.title]
     * descending.
     * * `"annualized_base_compensation"`: By job's
     *   [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_base_compensation_range]
     *   ascending. Jobs whose annualized base compensation is unspecified are put
     *   at the end of search results.
     * * `"annualized_base_compensation desc"`: By job's
     *   [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_base_compensation_range]
     *   descending. Jobs whose annualized base compensation is unspecified are
     *   put at the end of search results.
     * * `"annualized_total_compensation"`: By job's
     *   [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_total_compensation_range]
     *   ascending. Jobs whose annualized base compensation is unspecified are put
     *   at the end of search results.
     * * `"annualized_total_compensation desc"`: By job's
     *   [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4.CompensationInfo.annualized_total_compensation_range]
     *   descending. Jobs whose annualized base compensation is unspecified are
     *   put at the end of search results.
     * * `"custom_ranking desc"`: By the relevance score adjusted to the
     *   [SearchJobsRequest.CustomRankingInfo.ranking_expression][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.ranking_expression]
     *   with weight factor assigned by
     *   [SearchJobsRequest.CustomRankingInfo.importance_level][google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.importance_level]
     *   in descending order.
     * * Location sorting: Use the special syntax to order jobs by distance:&lt;br&gt;
     *   `"distance_from('Hawaii')"`: Order by distance from Hawaii.&lt;br&gt;
     *   `"distance_from(19.89, 155.5)"`: Order by distance from a coordinate.&lt;br&gt;
     *   `"distance_from('Hawaii'), distance_from('Puerto Rico')"`: Order by
     *   multiple locations. See details below.&lt;br&gt;
     *   `"distance_from('Hawaii'), distance_from(19.89, 155.5)"`: Order by
     *   multiple locations. See details below.&lt;br&gt;
     *   The string can have a maximum of 256 characters. When multiple distance
     *   centers are provided, a job that is close to any of the distance centers
     *   would have a high rank. When a job has multiple locations, the job
     *   location closest to one of the distance centers will be used. Jobs that
     *   don't have locations will be ranked at the bottom. Distance is calculated
     *   with a precision of 11.3 meters (37.4 feet). Diversification strategy is
     *   still applied unless explicitly disabled in
     *   [diversification_level][google.cloud.talent.v4.SearchJobsRequest.diversification_level].
     * </pre>
     *
     * <code>string order_by = 12;</code>
     *
     * @param value The bytes for orderBy to set.
     * @return This builder for chaining.
     */
    public Builder setOrderByBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      orderBy_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private int diversificationLevel_ = 0;
    /**
     *
     *
     * <pre>
     * Controls whether highly similar jobs are returned next to each other in
     * the search results. Jobs are identified as highly similar based on
     * their titles, job categories, and locations. Highly similar results are
     * clustered so that only one representative job of the cluster is
     * displayed to the job seeker higher up in the results, with the other jobs
     * being displayed lower down in the results.
     *
     * Defaults to
     * [DiversificationLevel.SIMPLE][google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel.SIMPLE]
     * if no value is specified.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel diversification_level = 13;
     * </code>
     *
     * @return The enum numeric value on the wire for diversificationLevel.
     */
    @java.lang.Override
    public int getDiversificationLevelValue() {
      return diversificationLevel_;
    }
    /**
     *
     *
     * <pre>
     * Controls whether highly similar jobs are returned next to each other in
     * the search results. Jobs are identified as highly similar based on
     * their titles, job categories, and locations. Highly similar results are
     * clustered so that only one representative job of the cluster is
     * displayed to the job seeker higher up in the results, with the other jobs
     * being displayed lower down in the results.
     *
     * Defaults to
     * [DiversificationLevel.SIMPLE][google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel.SIMPLE]
     * if no value is specified.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel diversification_level = 13;
     * </code>
     *
     * @param value The enum numeric value on the wire for diversificationLevel to set.
     * @return This builder for chaining.
     */
    public Builder setDiversificationLevelValue(int value) {
      diversificationLevel_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls whether highly similar jobs are returned next to each other in
     * the search results. Jobs are identified as highly similar based on
     * their titles, job categories, and locations. Highly similar results are
     * clustered so that only one representative job of the cluster is
     * displayed to the job seeker higher up in the results, with the other jobs
     * being displayed lower down in the results.
     *
     * Defaults to
     * [DiversificationLevel.SIMPLE][google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel.SIMPLE]
     * if no value is specified.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel diversification_level = 13;
     * </code>
     *
     * @return The diversificationLevel.
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel
        getDiversificationLevel() {
      com.google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel result =
          com.google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel.forNumber(
              diversificationLevel_);
      return result == null
          ? com.google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Controls whether highly similar jobs are returned next to each other in
     * the search results. Jobs are identified as highly similar based on
     * their titles, job categories, and locations. Highly similar results are
     * clustered so that only one representative job of the cluster is
     * displayed to the job seeker higher up in the results, with the other jobs
     * being displayed lower down in the results.
     *
     * Defaults to
     * [DiversificationLevel.SIMPLE][google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel.SIMPLE]
     * if no value is specified.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel diversification_level = 13;
     * </code>
     *
     * @param value The diversificationLevel to set.
     * @return This builder for chaining.
     */
    public Builder setDiversificationLevel(
        com.google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      diversificationLevel_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls whether highly similar jobs are returned next to each other in
     * the search results. Jobs are identified as highly similar based on
     * their titles, job categories, and locations. Highly similar results are
     * clustered so that only one representative job of the cluster is
     * displayed to the job seeker higher up in the results, with the other jobs
     * being displayed lower down in the results.
     *
     * Defaults to
     * [DiversificationLevel.SIMPLE][google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel.SIMPLE]
     * if no value is specified.
     * </pre>
     *
     * <code>
     * .google.cloud.talent.v4.SearchJobsRequest.DiversificationLevel diversification_level = 13;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDiversificationLevel() {
      bitField0_ = (bitField0_ & ~0x00000800);
      diversificationLevel_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo customRankingInfo_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo,
            com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.Builder,
            com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfoOrBuilder>
        customRankingInfoBuilder_;
    /**
     *
     *
     * <pre>
     * Controls over how job documents get ranked on top of existing relevance
     * score (determined by API algorithm).
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo custom_ranking_info = 14;
     * </code>
     *
     * @return Whether the customRankingInfo field is set.
     */
    public boolean hasCustomRankingInfo() {
      return ((bitField0_ & 0x00001000) != 0);
    }
    /**
     *
     *
     * <pre>
     * Controls over how job documents get ranked on top of existing relevance
     * score (determined by API algorithm).
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo custom_ranking_info = 14;
     * </code>
     *
     * @return The customRankingInfo.
     */
    public com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo getCustomRankingInfo() {
      if (customRankingInfoBuilder_ == null) {
        return customRankingInfo_ == null
            ? com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.getDefaultInstance()
            : customRankingInfo_;
      } else {
        return customRankingInfoBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Controls over how job documents get ranked on top of existing relevance
     * score (determined by API algorithm).
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo custom_ranking_info = 14;
     * </code>
     */
    public Builder setCustomRankingInfo(
        com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo value) {
      if (customRankingInfoBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        customRankingInfo_ = value;
      } else {
        customRankingInfoBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls over how job documents get ranked on top of existing relevance
     * score (determined by API algorithm).
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo custom_ranking_info = 14;
     * </code>
     */
    public Builder setCustomRankingInfo(
        com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.Builder builderForValue) {
      if (customRankingInfoBuilder_ == null) {
        customRankingInfo_ = builderForValue.build();
      } else {
        customRankingInfoBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls over how job documents get ranked on top of existing relevance
     * score (determined by API algorithm).
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo custom_ranking_info = 14;
     * </code>
     */
    public Builder mergeCustomRankingInfo(
        com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo value) {
      if (customRankingInfoBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && customRankingInfo_ != null
            && customRankingInfo_
                != com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo
                    .getDefaultInstance()) {
          getCustomRankingInfoBuilder().mergeFrom(value);
        } else {
          customRankingInfo_ = value;
        }
      } else {
        customRankingInfoBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls over how job documents get ranked on top of existing relevance
     * score (determined by API algorithm).
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo custom_ranking_info = 14;
     * </code>
     */
    public Builder clearCustomRankingInfo() {
      bitField0_ = (bitField0_ & ~0x00001000);
      customRankingInfo_ = null;
      if (customRankingInfoBuilder_ != null) {
        customRankingInfoBuilder_.dispose();
        customRankingInfoBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls over how job documents get ranked on top of existing relevance
     * score (determined by API algorithm).
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo custom_ranking_info = 14;
     * </code>
     */
    public com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.Builder
        getCustomRankingInfoBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getCustomRankingInfoFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Controls over how job documents get ranked on top of existing relevance
     * score (determined by API algorithm).
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo custom_ranking_info = 14;
     * </code>
     */
    public com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfoOrBuilder
        getCustomRankingInfoOrBuilder() {
      if (customRankingInfoBuilder_ != null) {
        return customRankingInfoBuilder_.getMessageOrBuilder();
      } else {
        return customRankingInfo_ == null
            ? com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.getDefaultInstance()
            : customRankingInfo_;
      }
    }
    /**
     *
     *
     * <pre>
     * Controls over how job documents get ranked on top of existing relevance
     * score (determined by API algorithm).
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo custom_ranking_info = 14;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo,
            com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.Builder,
            com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfoOrBuilder>
        getCustomRankingInfoFieldBuilder() {
      if (customRankingInfoBuilder_ == null) {
        customRankingInfoBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo,
                com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfo.Builder,
                com.google.cloud.talent.v4.SearchJobsRequest.CustomRankingInfoOrBuilder>(
                getCustomRankingInfo(), getParentForChildren(), isClean());
        customRankingInfo_ = null;
      }
      return customRankingInfoBuilder_;
    }

    private boolean disableKeywordMatch_;
    /**
     *
     *
     * <pre>
     * This field is deprecated. Please use
     * [SearchJobsRequest.keyword_match_mode][google.cloud.talent.v4.SearchJobsRequest.keyword_match_mode]
     * going forward.
     *
     * To migrate, disable_keyword_match set to false maps to
     * [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL],
     * and disable_keyword_match set to true maps to
     * [KeywordMatchMode.KEYWORD_MATCH_DISABLED][google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_DISABLED].
     * If
     * [SearchJobsRequest.keyword_match_mode][google.cloud.talent.v4.SearchJobsRequest.keyword_match_mode]
     * is set, this field is ignored.
     *
     * Controls whether to disable exact keyword match on
     * [Job.title][google.cloud.talent.v4.Job.title],
     * [Job.description][google.cloud.talent.v4.Job.description],
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name],
     * [Job.addresses][google.cloud.talent.v4.Job.addresses],
     * [Job.qualifications][google.cloud.talent.v4.Job.qualifications]. When
     * disable keyword match is turned off, a keyword match returns jobs that do
     * not match given category filters when there are matching keywords. For
     * example, for the query "program manager," a result is returned even if the
     * job posting has the title "software developer," which doesn't fall into
     * "program manager" ontology, but does have "program manager" appearing in
     * its description.
     *
     * For queries like "cloud" that don't contain title or
     * location specific ontology, jobs with "cloud" keyword matches are returned
     * regardless of this flag's value.
     *
     * Use
     * [Company.keyword_searchable_job_custom_attributes][google.cloud.talent.v4.Company.keyword_searchable_job_custom_attributes]
     * if company-specific globally matched custom field/attribute string values
     * are needed. Enabling keyword match improves recall of subsequent search
     * requests.
     *
     * Defaults to false.
     * </pre>
     *
     * <code>bool disable_keyword_match = 16 [deprecated = true];</code>
     *
     * @deprecated google.cloud.talent.v4.SearchJobsRequest.disable_keyword_match is deprecated. See
     *     google/cloud/talent/v4/job_service.proto;l=804
     * @return The disableKeywordMatch.
     */
    @java.lang.Override
    @java.lang.Deprecated
    public boolean getDisableKeywordMatch() {
      return disableKeywordMatch_;
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated. Please use
     * [SearchJobsRequest.keyword_match_mode][google.cloud.talent.v4.SearchJobsRequest.keyword_match_mode]
     * going forward.
     *
     * To migrate, disable_keyword_match set to false maps to
     * [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL],
     * and disable_keyword_match set to true maps to
     * [KeywordMatchMode.KEYWORD_MATCH_DISABLED][google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_DISABLED].
     * If
     * [SearchJobsRequest.keyword_match_mode][google.cloud.talent.v4.SearchJobsRequest.keyword_match_mode]
     * is set, this field is ignored.
     *
     * Controls whether to disable exact keyword match on
     * [Job.title][google.cloud.talent.v4.Job.title],
     * [Job.description][google.cloud.talent.v4.Job.description],
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name],
     * [Job.addresses][google.cloud.talent.v4.Job.addresses],
     * [Job.qualifications][google.cloud.talent.v4.Job.qualifications]. When
     * disable keyword match is turned off, a keyword match returns jobs that do
     * not match given category filters when there are matching keywords. For
     * example, for the query "program manager," a result is returned even if the
     * job posting has the title "software developer," which doesn't fall into
     * "program manager" ontology, but does have "program manager" appearing in
     * its description.
     *
     * For queries like "cloud" that don't contain title or
     * location specific ontology, jobs with "cloud" keyword matches are returned
     * regardless of this flag's value.
     *
     * Use
     * [Company.keyword_searchable_job_custom_attributes][google.cloud.talent.v4.Company.keyword_searchable_job_custom_attributes]
     * if company-specific globally matched custom field/attribute string values
     * are needed. Enabling keyword match improves recall of subsequent search
     * requests.
     *
     * Defaults to false.
     * </pre>
     *
     * <code>bool disable_keyword_match = 16 [deprecated = true];</code>
     *
     * @deprecated google.cloud.talent.v4.SearchJobsRequest.disable_keyword_match is deprecated. See
     *     google/cloud/talent/v4/job_service.proto;l=804
     * @param value The disableKeywordMatch to set.
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder setDisableKeywordMatch(boolean value) {

      disableKeywordMatch_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * This field is deprecated. Please use
     * [SearchJobsRequest.keyword_match_mode][google.cloud.talent.v4.SearchJobsRequest.keyword_match_mode]
     * going forward.
     *
     * To migrate, disable_keyword_match set to false maps to
     * [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL],
     * and disable_keyword_match set to true maps to
     * [KeywordMatchMode.KEYWORD_MATCH_DISABLED][google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_DISABLED].
     * If
     * [SearchJobsRequest.keyword_match_mode][google.cloud.talent.v4.SearchJobsRequest.keyword_match_mode]
     * is set, this field is ignored.
     *
     * Controls whether to disable exact keyword match on
     * [Job.title][google.cloud.talent.v4.Job.title],
     * [Job.description][google.cloud.talent.v4.Job.description],
     * [Job.company_display_name][google.cloud.talent.v4.Job.company_display_name],
     * [Job.addresses][google.cloud.talent.v4.Job.addresses],
     * [Job.qualifications][google.cloud.talent.v4.Job.qualifications]. When
     * disable keyword match is turned off, a keyword match returns jobs that do
     * not match given category filters when there are matching keywords. For
     * example, for the query "program manager," a result is returned even if the
     * job posting has the title "software developer," which doesn't fall into
     * "program manager" ontology, but does have "program manager" appearing in
     * its description.
     *
     * For queries like "cloud" that don't contain title or
     * location specific ontology, jobs with "cloud" keyword matches are returned
     * regardless of this flag's value.
     *
     * Use
     * [Company.keyword_searchable_job_custom_attributes][google.cloud.talent.v4.Company.keyword_searchable_job_custom_attributes]
     * if company-specific globally matched custom field/attribute string values
     * are needed. Enabling keyword match improves recall of subsequent search
     * requests.
     *
     * Defaults to false.
     * </pre>
     *
     * <code>bool disable_keyword_match = 16 [deprecated = true];</code>
     *
     * @deprecated google.cloud.talent.v4.SearchJobsRequest.disable_keyword_match is deprecated. See
     *     google/cloud/talent/v4/job_service.proto;l=804
     * @return This builder for chaining.
     */
    @java.lang.Deprecated
    public Builder clearDisableKeywordMatch() {
      bitField0_ = (bitField0_ & ~0x00002000);
      disableKeywordMatch_ = false;
      onChanged();
      return this;
    }

    private int keywordMatchMode_ = 0;
    /**
     *
     *
     * <pre>
     * Controls what keyword match options to use. If both keyword_match_mode and
     * disable_keyword_match are set, keyword_match_mode will take precedence.
     *
     * Defaults to
     * [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL]
     * if no value is specified.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode keyword_match_mode = 18;
     * </code>
     *
     * @return The enum numeric value on the wire for keywordMatchMode.
     */
    @java.lang.Override
    public int getKeywordMatchModeValue() {
      return keywordMatchMode_;
    }
    /**
     *
     *
     * <pre>
     * Controls what keyword match options to use. If both keyword_match_mode and
     * disable_keyword_match are set, keyword_match_mode will take precedence.
     *
     * Defaults to
     * [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL]
     * if no value is specified.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode keyword_match_mode = 18;
     * </code>
     *
     * @param value The enum numeric value on the wire for keywordMatchMode to set.
     * @return This builder for chaining.
     */
    public Builder setKeywordMatchModeValue(int value) {
      keywordMatchMode_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls what keyword match options to use. If both keyword_match_mode and
     * disable_keyword_match are set, keyword_match_mode will take precedence.
     *
     * Defaults to
     * [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL]
     * if no value is specified.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode keyword_match_mode = 18;
     * </code>
     *
     * @return The keywordMatchMode.
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode getKeywordMatchMode() {
      com.google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode result =
          com.google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode.forNumber(
              keywordMatchMode_);
      return result == null
          ? com.google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Controls what keyword match options to use. If both keyword_match_mode and
     * disable_keyword_match are set, keyword_match_mode will take precedence.
     *
     * Defaults to
     * [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL]
     * if no value is specified.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode keyword_match_mode = 18;
     * </code>
     *
     * @param value The keywordMatchMode to set.
     * @return This builder for chaining.
     */
    public Builder setKeywordMatchMode(
        com.google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00004000;
      keywordMatchMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Controls what keyword match options to use. If both keyword_match_mode and
     * disable_keyword_match are set, keyword_match_mode will take precedence.
     *
     * Defaults to
     * [KeywordMatchMode.KEYWORD_MATCH_ALL][google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode.KEYWORD_MATCH_ALL]
     * if no value is specified.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsRequest.KeywordMatchMode keyword_match_mode = 18;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKeywordMatchMode() {
      bitField0_ = (bitField0_ & ~0x00004000);
      keywordMatchMode_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.talent.v4.SearchJobsRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.talent.v4.SearchJobsRequest)
  private static final com.google.cloud.talent.v4.SearchJobsRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.talent.v4.SearchJobsRequest();
  }

  public static com.google.cloud.talent.v4.SearchJobsRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SearchJobsRequest> PARSER =
      new com.google.protobuf.AbstractParser<SearchJobsRequest>() {
        @java.lang.Override
        public SearchJobsRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SearchJobsRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchJobsRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.talent.v4.SearchJobsRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
