/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/talent/v4/job_service.proto

package com.google.cloud.talent.v4;

/**
 *
 *
 * <pre>
 * Response for SearchJob method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.talent.v4.SearchJobsResponse}
 */
public final class SearchJobsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.talent.v4.SearchJobsResponse)
    SearchJobsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SearchJobsResponse.newBuilder() to construct.
  private SearchJobsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SearchJobsResponse() {
    matchingJobs_ = java.util.Collections.emptyList();
    histogramQueryResults_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
    locationFilters_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SearchJobsResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.talent.v4.JobServiceProto
        .internal_static_google_cloud_talent_v4_SearchJobsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.talent.v4.JobServiceProto
        .internal_static_google_cloud_talent_v4_SearchJobsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.talent.v4.SearchJobsResponse.class,
            com.google.cloud.talent.v4.SearchJobsResponse.Builder.class);
  }

  public interface MatchingJobOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.talent.v4.SearchJobsResponse.MatchingJob)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Job resource that matches the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job job = 1;</code>
     *
     * @return Whether the job field is set.
     */
    boolean hasJob();
    /**
     *
     *
     * <pre>
     * Job resource that matches the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job job = 1;</code>
     *
     * @return The job.
     */
    com.google.cloud.talent.v4.Job getJob();
    /**
     *
     *
     * <pre>
     * Job resource that matches the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job job = 1;</code>
     */
    com.google.cloud.talent.v4.JobOrBuilder getJobOrBuilder();

    /**
     *
     *
     * <pre>
     * A summary of the job with core information that's displayed on the search
     * results listing page.
     * </pre>
     *
     * <code>string job_summary = 2;</code>
     *
     * @return The jobSummary.
     */
    java.lang.String getJobSummary();
    /**
     *
     *
     * <pre>
     * A summary of the job with core information that's displayed on the search
     * results listing page.
     * </pre>
     *
     * <code>string job_summary = 2;</code>
     *
     * @return The bytes for jobSummary.
     */
    com.google.protobuf.ByteString getJobSummaryBytes();

    /**
     *
     *
     * <pre>
     * Contains snippets of text from the
     * [Job.title][google.cloud.talent.v4.Job.title] field most closely matching
     * a search query's keywords, if available. The matching query keywords are
     * enclosed in HTML bold tags.
     * </pre>
     *
     * <code>string job_title_snippet = 3;</code>
     *
     * @return The jobTitleSnippet.
     */
    java.lang.String getJobTitleSnippet();
    /**
     *
     *
     * <pre>
     * Contains snippets of text from the
     * [Job.title][google.cloud.talent.v4.Job.title] field most closely matching
     * a search query's keywords, if available. The matching query keywords are
     * enclosed in HTML bold tags.
     * </pre>
     *
     * <code>string job_title_snippet = 3;</code>
     *
     * @return The bytes for jobTitleSnippet.
     */
    com.google.protobuf.ByteString getJobTitleSnippetBytes();

    /**
     *
     *
     * <pre>
     * Contains snippets of text from the
     * [Job.description][google.cloud.talent.v4.Job.description] and similar
     * fields that most closely match a search query's keywords, if available.
     * All HTML tags in the original fields are stripped when returned in this
     * field, and matching query keywords are enclosed in HTML bold tags.
     * </pre>
     *
     * <code>string search_text_snippet = 4;</code>
     *
     * @return The searchTextSnippet.
     */
    java.lang.String getSearchTextSnippet();
    /**
     *
     *
     * <pre>
     * Contains snippets of text from the
     * [Job.description][google.cloud.talent.v4.Job.description] and similar
     * fields that most closely match a search query's keywords, if available.
     * All HTML tags in the original fields are stripped when returned in this
     * field, and matching query keywords are enclosed in HTML bold tags.
     * </pre>
     *
     * <code>string search_text_snippet = 4;</code>
     *
     * @return The bytes for searchTextSnippet.
     */
    com.google.protobuf.ByteString getSearchTextSnippetBytes();

    /**
     *
     *
     * <pre>
     * Commute information which is generated based on specified
     *  [CommuteFilter][google.cloud.talent.v4.CommuteFilter].
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo commute_info = 5;</code>
     *
     * @return Whether the commuteInfo field is set.
     */
    boolean hasCommuteInfo();
    /**
     *
     *
     * <pre>
     * Commute information which is generated based on specified
     *  [CommuteFilter][google.cloud.talent.v4.CommuteFilter].
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo commute_info = 5;</code>
     *
     * @return The commuteInfo.
     */
    com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo getCommuteInfo();
    /**
     *
     *
     * <pre>
     * Commute information which is generated based on specified
     *  [CommuteFilter][google.cloud.talent.v4.CommuteFilter].
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo commute_info = 5;</code>
     */
    com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfoOrBuilder getCommuteInfoOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Job entry with metadata inside
   * [SearchJobsResponse][google.cloud.talent.v4.SearchJobsResponse].
   * </pre>
   *
   * Protobuf type {@code google.cloud.talent.v4.SearchJobsResponse.MatchingJob}
   */
  public static final class MatchingJob extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.talent.v4.SearchJobsResponse.MatchingJob)
      MatchingJobOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MatchingJob.newBuilder() to construct.
    private MatchingJob(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MatchingJob() {
      jobSummary_ = "";
      jobTitleSnippet_ = "";
      searchTextSnippet_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MatchingJob();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.talent.v4.JobServiceProto
          .internal_static_google_cloud_talent_v4_SearchJobsResponse_MatchingJob_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.talent.v4.JobServiceProto
          .internal_static_google_cloud_talent_v4_SearchJobsResponse_MatchingJob_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob.class,
              com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob.Builder.class);
    }

    public static final int JOB_FIELD_NUMBER = 1;
    private com.google.cloud.talent.v4.Job job_;
    /**
     *
     *
     * <pre>
     * Job resource that matches the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job job = 1;</code>
     *
     * @return Whether the job field is set.
     */
    @java.lang.Override
    public boolean hasJob() {
      return job_ != null;
    }
    /**
     *
     *
     * <pre>
     * Job resource that matches the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job job = 1;</code>
     *
     * @return The job.
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.Job getJob() {
      return job_ == null ? com.google.cloud.talent.v4.Job.getDefaultInstance() : job_;
    }
    /**
     *
     *
     * <pre>
     * Job resource that matches the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Job job = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.JobOrBuilder getJobOrBuilder() {
      return job_ == null ? com.google.cloud.talent.v4.Job.getDefaultInstance() : job_;
    }

    public static final int JOB_SUMMARY_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object jobSummary_ = "";
    /**
     *
     *
     * <pre>
     * A summary of the job with core information that's displayed on the search
     * results listing page.
     * </pre>
     *
     * <code>string job_summary = 2;</code>
     *
     * @return The jobSummary.
     */
    @java.lang.Override
    public java.lang.String getJobSummary() {
      java.lang.Object ref = jobSummary_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jobSummary_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A summary of the job with core information that's displayed on the search
     * results listing page.
     * </pre>
     *
     * <code>string job_summary = 2;</code>
     *
     * @return The bytes for jobSummary.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getJobSummaryBytes() {
      java.lang.Object ref = jobSummary_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        jobSummary_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int JOB_TITLE_SNIPPET_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object jobTitleSnippet_ = "";
    /**
     *
     *
     * <pre>
     * Contains snippets of text from the
     * [Job.title][google.cloud.talent.v4.Job.title] field most closely matching
     * a search query's keywords, if available. The matching query keywords are
     * enclosed in HTML bold tags.
     * </pre>
     *
     * <code>string job_title_snippet = 3;</code>
     *
     * @return The jobTitleSnippet.
     */
    @java.lang.Override
    public java.lang.String getJobTitleSnippet() {
      java.lang.Object ref = jobTitleSnippet_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        jobTitleSnippet_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Contains snippets of text from the
     * [Job.title][google.cloud.talent.v4.Job.title] field most closely matching
     * a search query's keywords, if available. The matching query keywords are
     * enclosed in HTML bold tags.
     * </pre>
     *
     * <code>string job_title_snippet = 3;</code>
     *
     * @return The bytes for jobTitleSnippet.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getJobTitleSnippetBytes() {
      java.lang.Object ref = jobTitleSnippet_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        jobTitleSnippet_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SEARCH_TEXT_SNIPPET_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object searchTextSnippet_ = "";
    /**
     *
     *
     * <pre>
     * Contains snippets of text from the
     * [Job.description][google.cloud.talent.v4.Job.description] and similar
     * fields that most closely match a search query's keywords, if available.
     * All HTML tags in the original fields are stripped when returned in this
     * field, and matching query keywords are enclosed in HTML bold tags.
     * </pre>
     *
     * <code>string search_text_snippet = 4;</code>
     *
     * @return The searchTextSnippet.
     */
    @java.lang.Override
    public java.lang.String getSearchTextSnippet() {
      java.lang.Object ref = searchTextSnippet_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        searchTextSnippet_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Contains snippets of text from the
     * [Job.description][google.cloud.talent.v4.Job.description] and similar
     * fields that most closely match a search query's keywords, if available.
     * All HTML tags in the original fields are stripped when returned in this
     * field, and matching query keywords are enclosed in HTML bold tags.
     * </pre>
     *
     * <code>string search_text_snippet = 4;</code>
     *
     * @return The bytes for searchTextSnippet.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSearchTextSnippetBytes() {
      java.lang.Object ref = searchTextSnippet_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        searchTextSnippet_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COMMUTE_INFO_FIELD_NUMBER = 5;
    private com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo commuteInfo_;
    /**
     *
     *
     * <pre>
     * Commute information which is generated based on specified
     *  [CommuteFilter][google.cloud.talent.v4.CommuteFilter].
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo commute_info = 5;</code>
     *
     * @return Whether the commuteInfo field is set.
     */
    @java.lang.Override
    public boolean hasCommuteInfo() {
      return commuteInfo_ != null;
    }
    /**
     *
     *
     * <pre>
     * Commute information which is generated based on specified
     *  [CommuteFilter][google.cloud.talent.v4.CommuteFilter].
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo commute_info = 5;</code>
     *
     * @return The commuteInfo.
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo getCommuteInfo() {
      return commuteInfo_ == null
          ? com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo.getDefaultInstance()
          : commuteInfo_;
    }
    /**
     *
     *
     * <pre>
     * Commute information which is generated based on specified
     *  [CommuteFilter][google.cloud.talent.v4.CommuteFilter].
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo commute_info = 5;</code>
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfoOrBuilder
        getCommuteInfoOrBuilder() {
      return commuteInfo_ == null
          ? com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo.getDefaultInstance()
          : commuteInfo_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (job_ != null) {
        output.writeMessage(1, getJob());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobSummary_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, jobSummary_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobTitleSnippet_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, jobTitleSnippet_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(searchTextSnippet_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, searchTextSnippet_);
      }
      if (commuteInfo_ != null) {
        output.writeMessage(5, getCommuteInfo());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (job_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getJob());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobSummary_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, jobSummary_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(jobTitleSnippet_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, jobTitleSnippet_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(searchTextSnippet_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, searchTextSnippet_);
      }
      if (commuteInfo_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCommuteInfo());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob)) {
        return super.equals(obj);
      }
      com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob other =
          (com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob) obj;

      if (hasJob() != other.hasJob()) return false;
      if (hasJob()) {
        if (!getJob().equals(other.getJob())) return false;
      }
      if (!getJobSummary().equals(other.getJobSummary())) return false;
      if (!getJobTitleSnippet().equals(other.getJobTitleSnippet())) return false;
      if (!getSearchTextSnippet().equals(other.getSearchTextSnippet())) return false;
      if (hasCommuteInfo() != other.hasCommuteInfo()) return false;
      if (hasCommuteInfo()) {
        if (!getCommuteInfo().equals(other.getCommuteInfo())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasJob()) {
        hash = (37 * hash) + JOB_FIELD_NUMBER;
        hash = (53 * hash) + getJob().hashCode();
      }
      hash = (37 * hash) + JOB_SUMMARY_FIELD_NUMBER;
      hash = (53 * hash) + getJobSummary().hashCode();
      hash = (37 * hash) + JOB_TITLE_SNIPPET_FIELD_NUMBER;
      hash = (53 * hash) + getJobTitleSnippet().hashCode();
      hash = (37 * hash) + SEARCH_TEXT_SNIPPET_FIELD_NUMBER;
      hash = (53 * hash) + getSearchTextSnippet().hashCode();
      if (hasCommuteInfo()) {
        hash = (37 * hash) + COMMUTE_INFO_FIELD_NUMBER;
        hash = (53 * hash) + getCommuteInfo().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Job entry with metadata inside
     * [SearchJobsResponse][google.cloud.talent.v4.SearchJobsResponse].
     * </pre>
     *
     * Protobuf type {@code google.cloud.talent.v4.SearchJobsResponse.MatchingJob}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.talent.v4.SearchJobsResponse.MatchingJob)
        com.google.cloud.talent.v4.SearchJobsResponse.MatchingJobOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.talent.v4.JobServiceProto
            .internal_static_google_cloud_talent_v4_SearchJobsResponse_MatchingJob_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.talent.v4.JobServiceProto
            .internal_static_google_cloud_talent_v4_SearchJobsResponse_MatchingJob_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob.class,
                com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob.Builder.class);
      }

      // Construct using com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        job_ = null;
        if (jobBuilder_ != null) {
          jobBuilder_.dispose();
          jobBuilder_ = null;
        }
        jobSummary_ = "";
        jobTitleSnippet_ = "";
        searchTextSnippet_ = "";
        commuteInfo_ = null;
        if (commuteInfoBuilder_ != null) {
          commuteInfoBuilder_.dispose();
          commuteInfoBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.talent.v4.JobServiceProto
            .internal_static_google_cloud_talent_v4_SearchJobsResponse_MatchingJob_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob getDefaultInstanceForType() {
        return com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob build() {
        com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob buildPartial() {
        com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob result =
            new com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.job_ = jobBuilder_ == null ? job_ : jobBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.jobSummary_ = jobSummary_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.jobTitleSnippet_ = jobTitleSnippet_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.searchTextSnippet_ = searchTextSnippet_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.commuteInfo_ =
              commuteInfoBuilder_ == null ? commuteInfo_ : commuteInfoBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob) {
          return mergeFrom((com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob other) {
        if (other == com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob.getDefaultInstance())
          return this;
        if (other.hasJob()) {
          mergeJob(other.getJob());
        }
        if (!other.getJobSummary().isEmpty()) {
          jobSummary_ = other.jobSummary_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getJobTitleSnippet().isEmpty()) {
          jobTitleSnippet_ = other.jobTitleSnippet_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getSearchTextSnippet().isEmpty()) {
          searchTextSnippet_ = other.searchTextSnippet_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (other.hasCommuteInfo()) {
          mergeCommuteInfo(other.getCommuteInfo());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getJobFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  jobSummary_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  jobTitleSnippet_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  searchTextSnippet_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(getCommuteInfoFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.talent.v4.Job job_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.talent.v4.Job,
              com.google.cloud.talent.v4.Job.Builder,
              com.google.cloud.talent.v4.JobOrBuilder>
          jobBuilder_;
      /**
       *
       *
       * <pre>
       * Job resource that matches the specified
       * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Job job = 1;</code>
       *
       * @return Whether the job field is set.
       */
      public boolean hasJob() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Job resource that matches the specified
       * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Job job = 1;</code>
       *
       * @return The job.
       */
      public com.google.cloud.talent.v4.Job getJob() {
        if (jobBuilder_ == null) {
          return job_ == null ? com.google.cloud.talent.v4.Job.getDefaultInstance() : job_;
        } else {
          return jobBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Job resource that matches the specified
       * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Job job = 1;</code>
       */
      public Builder setJob(com.google.cloud.talent.v4.Job value) {
        if (jobBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          job_ = value;
        } else {
          jobBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Job resource that matches the specified
       * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Job job = 1;</code>
       */
      public Builder setJob(com.google.cloud.talent.v4.Job.Builder builderForValue) {
        if (jobBuilder_ == null) {
          job_ = builderForValue.build();
        } else {
          jobBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Job resource that matches the specified
       * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Job job = 1;</code>
       */
      public Builder mergeJob(com.google.cloud.talent.v4.Job value) {
        if (jobBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && job_ != null
              && job_ != com.google.cloud.talent.v4.Job.getDefaultInstance()) {
            getJobBuilder().mergeFrom(value);
          } else {
            job_ = value;
          }
        } else {
          jobBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Job resource that matches the specified
       * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Job job = 1;</code>
       */
      public Builder clearJob() {
        bitField0_ = (bitField0_ & ~0x00000001);
        job_ = null;
        if (jobBuilder_ != null) {
          jobBuilder_.dispose();
          jobBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Job resource that matches the specified
       * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Job job = 1;</code>
       */
      public com.google.cloud.talent.v4.Job.Builder getJobBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getJobFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Job resource that matches the specified
       * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Job job = 1;</code>
       */
      public com.google.cloud.talent.v4.JobOrBuilder getJobOrBuilder() {
        if (jobBuilder_ != null) {
          return jobBuilder_.getMessageOrBuilder();
        } else {
          return job_ == null ? com.google.cloud.talent.v4.Job.getDefaultInstance() : job_;
        }
      }
      /**
       *
       *
       * <pre>
       * Job resource that matches the specified
       * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Job job = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.talent.v4.Job,
              com.google.cloud.talent.v4.Job.Builder,
              com.google.cloud.talent.v4.JobOrBuilder>
          getJobFieldBuilder() {
        if (jobBuilder_ == null) {
          jobBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.talent.v4.Job,
                  com.google.cloud.talent.v4.Job.Builder,
                  com.google.cloud.talent.v4.JobOrBuilder>(
                  getJob(), getParentForChildren(), isClean());
          job_ = null;
        }
        return jobBuilder_;
      }

      private java.lang.Object jobSummary_ = "";
      /**
       *
       *
       * <pre>
       * A summary of the job with core information that's displayed on the search
       * results listing page.
       * </pre>
       *
       * <code>string job_summary = 2;</code>
       *
       * @return The jobSummary.
       */
      public java.lang.String getJobSummary() {
        java.lang.Object ref = jobSummary_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          jobSummary_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A summary of the job with core information that's displayed on the search
       * results listing page.
       * </pre>
       *
       * <code>string job_summary = 2;</code>
       *
       * @return The bytes for jobSummary.
       */
      public com.google.protobuf.ByteString getJobSummaryBytes() {
        java.lang.Object ref = jobSummary_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          jobSummary_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A summary of the job with core information that's displayed on the search
       * results listing page.
       * </pre>
       *
       * <code>string job_summary = 2;</code>
       *
       * @param value The jobSummary to set.
       * @return This builder for chaining.
       */
      public Builder setJobSummary(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobSummary_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A summary of the job with core information that's displayed on the search
       * results listing page.
       * </pre>
       *
       * <code>string job_summary = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearJobSummary() {
        jobSummary_ = getDefaultInstance().getJobSummary();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A summary of the job with core information that's displayed on the search
       * results listing page.
       * </pre>
       *
       * <code>string job_summary = 2;</code>
       *
       * @param value The bytes for jobSummary to set.
       * @return This builder for chaining.
       */
      public Builder setJobSummaryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        jobSummary_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object jobTitleSnippet_ = "";
      /**
       *
       *
       * <pre>
       * Contains snippets of text from the
       * [Job.title][google.cloud.talent.v4.Job.title] field most closely matching
       * a search query's keywords, if available. The matching query keywords are
       * enclosed in HTML bold tags.
       * </pre>
       *
       * <code>string job_title_snippet = 3;</code>
       *
       * @return The jobTitleSnippet.
       */
      public java.lang.String getJobTitleSnippet() {
        java.lang.Object ref = jobTitleSnippet_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          jobTitleSnippet_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Contains snippets of text from the
       * [Job.title][google.cloud.talent.v4.Job.title] field most closely matching
       * a search query's keywords, if available. The matching query keywords are
       * enclosed in HTML bold tags.
       * </pre>
       *
       * <code>string job_title_snippet = 3;</code>
       *
       * @return The bytes for jobTitleSnippet.
       */
      public com.google.protobuf.ByteString getJobTitleSnippetBytes() {
        java.lang.Object ref = jobTitleSnippet_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          jobTitleSnippet_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Contains snippets of text from the
       * [Job.title][google.cloud.talent.v4.Job.title] field most closely matching
       * a search query's keywords, if available. The matching query keywords are
       * enclosed in HTML bold tags.
       * </pre>
       *
       * <code>string job_title_snippet = 3;</code>
       *
       * @param value The jobTitleSnippet to set.
       * @return This builder for chaining.
       */
      public Builder setJobTitleSnippet(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        jobTitleSnippet_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Contains snippets of text from the
       * [Job.title][google.cloud.talent.v4.Job.title] field most closely matching
       * a search query's keywords, if available. The matching query keywords are
       * enclosed in HTML bold tags.
       * </pre>
       *
       * <code>string job_title_snippet = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearJobTitleSnippet() {
        jobTitleSnippet_ = getDefaultInstance().getJobTitleSnippet();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Contains snippets of text from the
       * [Job.title][google.cloud.talent.v4.Job.title] field most closely matching
       * a search query's keywords, if available. The matching query keywords are
       * enclosed in HTML bold tags.
       * </pre>
       *
       * <code>string job_title_snippet = 3;</code>
       *
       * @param value The bytes for jobTitleSnippet to set.
       * @return This builder for chaining.
       */
      public Builder setJobTitleSnippetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        jobTitleSnippet_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object searchTextSnippet_ = "";
      /**
       *
       *
       * <pre>
       * Contains snippets of text from the
       * [Job.description][google.cloud.talent.v4.Job.description] and similar
       * fields that most closely match a search query's keywords, if available.
       * All HTML tags in the original fields are stripped when returned in this
       * field, and matching query keywords are enclosed in HTML bold tags.
       * </pre>
       *
       * <code>string search_text_snippet = 4;</code>
       *
       * @return The searchTextSnippet.
       */
      public java.lang.String getSearchTextSnippet() {
        java.lang.Object ref = searchTextSnippet_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          searchTextSnippet_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Contains snippets of text from the
       * [Job.description][google.cloud.talent.v4.Job.description] and similar
       * fields that most closely match a search query's keywords, if available.
       * All HTML tags in the original fields are stripped when returned in this
       * field, and matching query keywords are enclosed in HTML bold tags.
       * </pre>
       *
       * <code>string search_text_snippet = 4;</code>
       *
       * @return The bytes for searchTextSnippet.
       */
      public com.google.protobuf.ByteString getSearchTextSnippetBytes() {
        java.lang.Object ref = searchTextSnippet_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          searchTextSnippet_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Contains snippets of text from the
       * [Job.description][google.cloud.talent.v4.Job.description] and similar
       * fields that most closely match a search query's keywords, if available.
       * All HTML tags in the original fields are stripped when returned in this
       * field, and matching query keywords are enclosed in HTML bold tags.
       * </pre>
       *
       * <code>string search_text_snippet = 4;</code>
       *
       * @param value The searchTextSnippet to set.
       * @return This builder for chaining.
       */
      public Builder setSearchTextSnippet(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        searchTextSnippet_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Contains snippets of text from the
       * [Job.description][google.cloud.talent.v4.Job.description] and similar
       * fields that most closely match a search query's keywords, if available.
       * All HTML tags in the original fields are stripped when returned in this
       * field, and matching query keywords are enclosed in HTML bold tags.
       * </pre>
       *
       * <code>string search_text_snippet = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSearchTextSnippet() {
        searchTextSnippet_ = getDefaultInstance().getSearchTextSnippet();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Contains snippets of text from the
       * [Job.description][google.cloud.talent.v4.Job.description] and similar
       * fields that most closely match a search query's keywords, if available.
       * All HTML tags in the original fields are stripped when returned in this
       * field, and matching query keywords are enclosed in HTML bold tags.
       * </pre>
       *
       * <code>string search_text_snippet = 4;</code>
       *
       * @param value The bytes for searchTextSnippet to set.
       * @return This builder for chaining.
       */
      public Builder setSearchTextSnippetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        searchTextSnippet_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo commuteInfo_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo,
              com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo.Builder,
              com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfoOrBuilder>
          commuteInfoBuilder_;
      /**
       *
       *
       * <pre>
       * Commute information which is generated based on specified
       *  [CommuteFilter][google.cloud.talent.v4.CommuteFilter].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo commute_info = 5;</code>
       *
       * @return Whether the commuteInfo field is set.
       */
      public boolean hasCommuteInfo() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * Commute information which is generated based on specified
       *  [CommuteFilter][google.cloud.talent.v4.CommuteFilter].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo commute_info = 5;</code>
       *
       * @return The commuteInfo.
       */
      public com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo getCommuteInfo() {
        if (commuteInfoBuilder_ == null) {
          return commuteInfo_ == null
              ? com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo.getDefaultInstance()
              : commuteInfo_;
        } else {
          return commuteInfoBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Commute information which is generated based on specified
       *  [CommuteFilter][google.cloud.talent.v4.CommuteFilter].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo commute_info = 5;</code>
       */
      public Builder setCommuteInfo(
          com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo value) {
        if (commuteInfoBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          commuteInfo_ = value;
        } else {
          commuteInfoBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Commute information which is generated based on specified
       *  [CommuteFilter][google.cloud.talent.v4.CommuteFilter].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo commute_info = 5;</code>
       */
      public Builder setCommuteInfo(
          com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo.Builder builderForValue) {
        if (commuteInfoBuilder_ == null) {
          commuteInfo_ = builderForValue.build();
        } else {
          commuteInfoBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Commute information which is generated based on specified
       *  [CommuteFilter][google.cloud.talent.v4.CommuteFilter].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo commute_info = 5;</code>
       */
      public Builder mergeCommuteInfo(
          com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo value) {
        if (commuteInfoBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && commuteInfo_ != null
              && commuteInfo_
                  != com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo
                      .getDefaultInstance()) {
            getCommuteInfoBuilder().mergeFrom(value);
          } else {
            commuteInfo_ = value;
          }
        } else {
          commuteInfoBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Commute information which is generated based on specified
       *  [CommuteFilter][google.cloud.talent.v4.CommuteFilter].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo commute_info = 5;</code>
       */
      public Builder clearCommuteInfo() {
        bitField0_ = (bitField0_ & ~0x00000010);
        commuteInfo_ = null;
        if (commuteInfoBuilder_ != null) {
          commuteInfoBuilder_.dispose();
          commuteInfoBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Commute information which is generated based on specified
       *  [CommuteFilter][google.cloud.talent.v4.CommuteFilter].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo commute_info = 5;</code>
       */
      public com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo.Builder
          getCommuteInfoBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getCommuteInfoFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Commute information which is generated based on specified
       *  [CommuteFilter][google.cloud.talent.v4.CommuteFilter].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo commute_info = 5;</code>
       */
      public com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfoOrBuilder
          getCommuteInfoOrBuilder() {
        if (commuteInfoBuilder_ != null) {
          return commuteInfoBuilder_.getMessageOrBuilder();
        } else {
          return commuteInfo_ == null
              ? com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo.getDefaultInstance()
              : commuteInfo_;
        }
      }
      /**
       *
       *
       * <pre>
       * Commute information which is generated based on specified
       *  [CommuteFilter][google.cloud.talent.v4.CommuteFilter].
       * </pre>
       *
       * <code>.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo commute_info = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo,
              com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo.Builder,
              com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfoOrBuilder>
          getCommuteInfoFieldBuilder() {
        if (commuteInfoBuilder_ == null) {
          commuteInfoBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo,
                  com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo.Builder,
                  com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfoOrBuilder>(
                  getCommuteInfo(), getParentForChildren(), isClean());
          commuteInfo_ = null;
        }
        return commuteInfoBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.talent.v4.SearchJobsResponse.MatchingJob)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.talent.v4.SearchJobsResponse.MatchingJob)
    private static final com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob();
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MatchingJob> PARSER =
        new com.google.protobuf.AbstractParser<MatchingJob>() {
          @java.lang.Override
          public MatchingJob parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MatchingJob> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MatchingJob> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface CommuteInfoOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.talent.v4.SearchJobsResponse.CommuteInfo)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Location used as the destination in the commute calculation.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Location job_location = 1;</code>
     *
     * @return Whether the jobLocation field is set.
     */
    boolean hasJobLocation();
    /**
     *
     *
     * <pre>
     * Location used as the destination in the commute calculation.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Location job_location = 1;</code>
     *
     * @return The jobLocation.
     */
    com.google.cloud.talent.v4.Location getJobLocation();
    /**
     *
     *
     * <pre>
     * Location used as the destination in the commute calculation.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Location job_location = 1;</code>
     */
    com.google.cloud.talent.v4.LocationOrBuilder getJobLocationOrBuilder();

    /**
     *
     *
     * <pre>
     * The number of seconds required to travel to the job location from the
     * query location. A duration of 0 seconds indicates that the job isn't
     * reachable within the requested duration, but was returned as part of an
     * expanded query.
     * </pre>
     *
     * <code>.google.protobuf.Duration travel_duration = 2;</code>
     *
     * @return Whether the travelDuration field is set.
     */
    boolean hasTravelDuration();
    /**
     *
     *
     * <pre>
     * The number of seconds required to travel to the job location from the
     * query location. A duration of 0 seconds indicates that the job isn't
     * reachable within the requested duration, but was returned as part of an
     * expanded query.
     * </pre>
     *
     * <code>.google.protobuf.Duration travel_duration = 2;</code>
     *
     * @return The travelDuration.
     */
    com.google.protobuf.Duration getTravelDuration();
    /**
     *
     *
     * <pre>
     * The number of seconds required to travel to the job location from the
     * query location. A duration of 0 seconds indicates that the job isn't
     * reachable within the requested duration, but was returned as part of an
     * expanded query.
     * </pre>
     *
     * <code>.google.protobuf.Duration travel_duration = 2;</code>
     */
    com.google.protobuf.DurationOrBuilder getTravelDurationOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Commute details related to this job.
   * </pre>
   *
   * Protobuf type {@code google.cloud.talent.v4.SearchJobsResponse.CommuteInfo}
   */
  public static final class CommuteInfo extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.talent.v4.SearchJobsResponse.CommuteInfo)
      CommuteInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CommuteInfo.newBuilder() to construct.
    private CommuteInfo(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CommuteInfo() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CommuteInfo();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.talent.v4.JobServiceProto
          .internal_static_google_cloud_talent_v4_SearchJobsResponse_CommuteInfo_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.talent.v4.JobServiceProto
          .internal_static_google_cloud_talent_v4_SearchJobsResponse_CommuteInfo_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo.class,
              com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo.Builder.class);
    }

    public static final int JOB_LOCATION_FIELD_NUMBER = 1;
    private com.google.cloud.talent.v4.Location jobLocation_;
    /**
     *
     *
     * <pre>
     * Location used as the destination in the commute calculation.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Location job_location = 1;</code>
     *
     * @return Whether the jobLocation field is set.
     */
    @java.lang.Override
    public boolean hasJobLocation() {
      return jobLocation_ != null;
    }
    /**
     *
     *
     * <pre>
     * Location used as the destination in the commute calculation.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Location job_location = 1;</code>
     *
     * @return The jobLocation.
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.Location getJobLocation() {
      return jobLocation_ == null
          ? com.google.cloud.talent.v4.Location.getDefaultInstance()
          : jobLocation_;
    }
    /**
     *
     *
     * <pre>
     * Location used as the destination in the commute calculation.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.Location job_location = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.talent.v4.LocationOrBuilder getJobLocationOrBuilder() {
      return jobLocation_ == null
          ? com.google.cloud.talent.v4.Location.getDefaultInstance()
          : jobLocation_;
    }

    public static final int TRAVEL_DURATION_FIELD_NUMBER = 2;
    private com.google.protobuf.Duration travelDuration_;
    /**
     *
     *
     * <pre>
     * The number of seconds required to travel to the job location from the
     * query location. A duration of 0 seconds indicates that the job isn't
     * reachable within the requested duration, but was returned as part of an
     * expanded query.
     * </pre>
     *
     * <code>.google.protobuf.Duration travel_duration = 2;</code>
     *
     * @return Whether the travelDuration field is set.
     */
    @java.lang.Override
    public boolean hasTravelDuration() {
      return travelDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * The number of seconds required to travel to the job location from the
     * query location. A duration of 0 seconds indicates that the job isn't
     * reachable within the requested duration, but was returned as part of an
     * expanded query.
     * </pre>
     *
     * <code>.google.protobuf.Duration travel_duration = 2;</code>
     *
     * @return The travelDuration.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getTravelDuration() {
      return travelDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : travelDuration_;
    }
    /**
     *
     *
     * <pre>
     * The number of seconds required to travel to the job location from the
     * query location. A duration of 0 seconds indicates that the job isn't
     * reachable within the requested duration, but was returned as part of an
     * expanded query.
     * </pre>
     *
     * <code>.google.protobuf.Duration travel_duration = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getTravelDurationOrBuilder() {
      return travelDuration_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : travelDuration_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (jobLocation_ != null) {
        output.writeMessage(1, getJobLocation());
      }
      if (travelDuration_ != null) {
        output.writeMessage(2, getTravelDuration());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (jobLocation_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getJobLocation());
      }
      if (travelDuration_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTravelDuration());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo)) {
        return super.equals(obj);
      }
      com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo other =
          (com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo) obj;

      if (hasJobLocation() != other.hasJobLocation()) return false;
      if (hasJobLocation()) {
        if (!getJobLocation().equals(other.getJobLocation())) return false;
      }
      if (hasTravelDuration() != other.hasTravelDuration()) return false;
      if (hasTravelDuration()) {
        if (!getTravelDuration().equals(other.getTravelDuration())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasJobLocation()) {
        hash = (37 * hash) + JOB_LOCATION_FIELD_NUMBER;
        hash = (53 * hash) + getJobLocation().hashCode();
      }
      if (hasTravelDuration()) {
        hash = (37 * hash) + TRAVEL_DURATION_FIELD_NUMBER;
        hash = (53 * hash) + getTravelDuration().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Commute details related to this job.
     * </pre>
     *
     * Protobuf type {@code google.cloud.talent.v4.SearchJobsResponse.CommuteInfo}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.talent.v4.SearchJobsResponse.CommuteInfo)
        com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfoOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.talent.v4.JobServiceProto
            .internal_static_google_cloud_talent_v4_SearchJobsResponse_CommuteInfo_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.talent.v4.JobServiceProto
            .internal_static_google_cloud_talent_v4_SearchJobsResponse_CommuteInfo_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo.class,
                com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo.Builder.class);
      }

      // Construct using com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        jobLocation_ = null;
        if (jobLocationBuilder_ != null) {
          jobLocationBuilder_.dispose();
          jobLocationBuilder_ = null;
        }
        travelDuration_ = null;
        if (travelDurationBuilder_ != null) {
          travelDurationBuilder_.dispose();
          travelDurationBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.talent.v4.JobServiceProto
            .internal_static_google_cloud_talent_v4_SearchJobsResponse_CommuteInfo_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo getDefaultInstanceForType() {
        return com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo build() {
        com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo buildPartial() {
        com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo result =
            new com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.jobLocation_ =
              jobLocationBuilder_ == null ? jobLocation_ : jobLocationBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.travelDuration_ =
              travelDurationBuilder_ == null ? travelDuration_ : travelDurationBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo) {
          return mergeFrom((com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo other) {
        if (other == com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo.getDefaultInstance())
          return this;
        if (other.hasJobLocation()) {
          mergeJobLocation(other.getJobLocation());
        }
        if (other.hasTravelDuration()) {
          mergeTravelDuration(other.getTravelDuration());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getJobLocationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getTravelDurationFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.talent.v4.Location jobLocation_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.talent.v4.Location,
              com.google.cloud.talent.v4.Location.Builder,
              com.google.cloud.talent.v4.LocationOrBuilder>
          jobLocationBuilder_;
      /**
       *
       *
       * <pre>
       * Location used as the destination in the commute calculation.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Location job_location = 1;</code>
       *
       * @return Whether the jobLocation field is set.
       */
      public boolean hasJobLocation() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Location used as the destination in the commute calculation.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Location job_location = 1;</code>
       *
       * @return The jobLocation.
       */
      public com.google.cloud.talent.v4.Location getJobLocation() {
        if (jobLocationBuilder_ == null) {
          return jobLocation_ == null
              ? com.google.cloud.talent.v4.Location.getDefaultInstance()
              : jobLocation_;
        } else {
          return jobLocationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Location used as the destination in the commute calculation.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Location job_location = 1;</code>
       */
      public Builder setJobLocation(com.google.cloud.talent.v4.Location value) {
        if (jobLocationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          jobLocation_ = value;
        } else {
          jobLocationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Location used as the destination in the commute calculation.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Location job_location = 1;</code>
       */
      public Builder setJobLocation(com.google.cloud.talent.v4.Location.Builder builderForValue) {
        if (jobLocationBuilder_ == null) {
          jobLocation_ = builderForValue.build();
        } else {
          jobLocationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Location used as the destination in the commute calculation.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Location job_location = 1;</code>
       */
      public Builder mergeJobLocation(com.google.cloud.talent.v4.Location value) {
        if (jobLocationBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && jobLocation_ != null
              && jobLocation_ != com.google.cloud.talent.v4.Location.getDefaultInstance()) {
            getJobLocationBuilder().mergeFrom(value);
          } else {
            jobLocation_ = value;
          }
        } else {
          jobLocationBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Location used as the destination in the commute calculation.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Location job_location = 1;</code>
       */
      public Builder clearJobLocation() {
        bitField0_ = (bitField0_ & ~0x00000001);
        jobLocation_ = null;
        if (jobLocationBuilder_ != null) {
          jobLocationBuilder_.dispose();
          jobLocationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Location used as the destination in the commute calculation.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Location job_location = 1;</code>
       */
      public com.google.cloud.talent.v4.Location.Builder getJobLocationBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getJobLocationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Location used as the destination in the commute calculation.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Location job_location = 1;</code>
       */
      public com.google.cloud.talent.v4.LocationOrBuilder getJobLocationOrBuilder() {
        if (jobLocationBuilder_ != null) {
          return jobLocationBuilder_.getMessageOrBuilder();
        } else {
          return jobLocation_ == null
              ? com.google.cloud.talent.v4.Location.getDefaultInstance()
              : jobLocation_;
        }
      }
      /**
       *
       *
       * <pre>
       * Location used as the destination in the commute calculation.
       * </pre>
       *
       * <code>.google.cloud.talent.v4.Location job_location = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.talent.v4.Location,
              com.google.cloud.talent.v4.Location.Builder,
              com.google.cloud.talent.v4.LocationOrBuilder>
          getJobLocationFieldBuilder() {
        if (jobLocationBuilder_ == null) {
          jobLocationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.talent.v4.Location,
                  com.google.cloud.talent.v4.Location.Builder,
                  com.google.cloud.talent.v4.LocationOrBuilder>(
                  getJobLocation(), getParentForChildren(), isClean());
          jobLocation_ = null;
        }
        return jobLocationBuilder_;
      }

      private com.google.protobuf.Duration travelDuration_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          travelDurationBuilder_;
      /**
       *
       *
       * <pre>
       * The number of seconds required to travel to the job location from the
       * query location. A duration of 0 seconds indicates that the job isn't
       * reachable within the requested duration, but was returned as part of an
       * expanded query.
       * </pre>
       *
       * <code>.google.protobuf.Duration travel_duration = 2;</code>
       *
       * @return Whether the travelDuration field is set.
       */
      public boolean hasTravelDuration() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * The number of seconds required to travel to the job location from the
       * query location. A duration of 0 seconds indicates that the job isn't
       * reachable within the requested duration, but was returned as part of an
       * expanded query.
       * </pre>
       *
       * <code>.google.protobuf.Duration travel_duration = 2;</code>
       *
       * @return The travelDuration.
       */
      public com.google.protobuf.Duration getTravelDuration() {
        if (travelDurationBuilder_ == null) {
          return travelDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : travelDuration_;
        } else {
          return travelDurationBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The number of seconds required to travel to the job location from the
       * query location. A duration of 0 seconds indicates that the job isn't
       * reachable within the requested duration, but was returned as part of an
       * expanded query.
       * </pre>
       *
       * <code>.google.protobuf.Duration travel_duration = 2;</code>
       */
      public Builder setTravelDuration(com.google.protobuf.Duration value) {
        if (travelDurationBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          travelDuration_ = value;
        } else {
          travelDurationBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of seconds required to travel to the job location from the
       * query location. A duration of 0 seconds indicates that the job isn't
       * reachable within the requested duration, but was returned as part of an
       * expanded query.
       * </pre>
       *
       * <code>.google.protobuf.Duration travel_duration = 2;</code>
       */
      public Builder setTravelDuration(com.google.protobuf.Duration.Builder builderForValue) {
        if (travelDurationBuilder_ == null) {
          travelDuration_ = builderForValue.build();
        } else {
          travelDurationBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of seconds required to travel to the job location from the
       * query location. A duration of 0 seconds indicates that the job isn't
       * reachable within the requested duration, but was returned as part of an
       * expanded query.
       * </pre>
       *
       * <code>.google.protobuf.Duration travel_duration = 2;</code>
       */
      public Builder mergeTravelDuration(com.google.protobuf.Duration value) {
        if (travelDurationBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && travelDuration_ != null
              && travelDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getTravelDurationBuilder().mergeFrom(value);
          } else {
            travelDuration_ = value;
          }
        } else {
          travelDurationBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of seconds required to travel to the job location from the
       * query location. A duration of 0 seconds indicates that the job isn't
       * reachable within the requested duration, but was returned as part of an
       * expanded query.
       * </pre>
       *
       * <code>.google.protobuf.Duration travel_duration = 2;</code>
       */
      public Builder clearTravelDuration() {
        bitField0_ = (bitField0_ & ~0x00000002);
        travelDuration_ = null;
        if (travelDurationBuilder_ != null) {
          travelDurationBuilder_.dispose();
          travelDurationBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of seconds required to travel to the job location from the
       * query location. A duration of 0 seconds indicates that the job isn't
       * reachable within the requested duration, but was returned as part of an
       * expanded query.
       * </pre>
       *
       * <code>.google.protobuf.Duration travel_duration = 2;</code>
       */
      public com.google.protobuf.Duration.Builder getTravelDurationBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getTravelDurationFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The number of seconds required to travel to the job location from the
       * query location. A duration of 0 seconds indicates that the job isn't
       * reachable within the requested duration, but was returned as part of an
       * expanded query.
       * </pre>
       *
       * <code>.google.protobuf.Duration travel_duration = 2;</code>
       */
      public com.google.protobuf.DurationOrBuilder getTravelDurationOrBuilder() {
        if (travelDurationBuilder_ != null) {
          return travelDurationBuilder_.getMessageOrBuilder();
        } else {
          return travelDuration_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : travelDuration_;
        }
      }
      /**
       *
       *
       * <pre>
       * The number of seconds required to travel to the job location from the
       * query location. A duration of 0 seconds indicates that the job isn't
       * reachable within the requested duration, but was returned as part of an
       * expanded query.
       * </pre>
       *
       * <code>.google.protobuf.Duration travel_duration = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getTravelDurationFieldBuilder() {
        if (travelDurationBuilder_ == null) {
          travelDurationBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getTravelDuration(), getParentForChildren(), isClean());
          travelDuration_ = null;
        }
        return travelDurationBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.talent.v4.SearchJobsResponse.CommuteInfo)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.talent.v4.SearchJobsResponse.CommuteInfo)
    private static final com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo();
    }

    public static com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CommuteInfo> PARSER =
        new com.google.protobuf.AbstractParser<CommuteInfo>() {
          @java.lang.Override
          public CommuteInfo parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CommuteInfo> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CommuteInfo> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.SearchJobsResponse.CommuteInfo getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int MATCHING_JOBS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob> matchingJobs_;
  /**
   *
   *
   * <pre>
   * The Job entities that match the specified
   * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob>
      getMatchingJobsList() {
    return matchingJobs_;
  }
  /**
   *
   *
   * <pre>
   * The Job entities that match the specified
   * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.talent.v4.SearchJobsResponse.MatchingJobOrBuilder>
      getMatchingJobsOrBuilderList() {
    return matchingJobs_;
  }
  /**
   *
   *
   * <pre>
   * The Job entities that match the specified
   * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;</code>
   */
  @java.lang.Override
  public int getMatchingJobsCount() {
    return matchingJobs_.size();
  }
  /**
   *
   *
   * <pre>
   * The Job entities that match the specified
   * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob getMatchingJobs(int index) {
    return matchingJobs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The Job entities that match the specified
   * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.SearchJobsResponse.MatchingJobOrBuilder
      getMatchingJobsOrBuilder(int index) {
    return matchingJobs_.get(index);
  }

  public static final int HISTOGRAM_QUERY_RESULTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.talent.v4.HistogramQueryResult> histogramQueryResults_;
  /**
   *
   *
   * <pre>
   * The histogram results that match with specified
   * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.talent.v4.HistogramQueryResult>
      getHistogramQueryResultsList() {
    return histogramQueryResults_;
  }
  /**
   *
   *
   * <pre>
   * The histogram results that match with specified
   * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.talent.v4.HistogramQueryResultOrBuilder>
      getHistogramQueryResultsOrBuilderList() {
    return histogramQueryResults_;
  }
  /**
   *
   *
   * <pre>
   * The histogram results that match with specified
   * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;</code>
   */
  @java.lang.Override
  public int getHistogramQueryResultsCount() {
    return histogramQueryResults_.size();
  }
  /**
   *
   *
   * <pre>
   * The histogram results that match with specified
   * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.HistogramQueryResult getHistogramQueryResults(int index) {
    return histogramQueryResults_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The histogram results that match with specified
   * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.HistogramQueryResultOrBuilder getHistogramQueryResultsOrBuilder(
      int index) {
    return histogramQueryResults_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";
  /**
   *
   *
   * <pre>
   * The token that specifies the starting position of the next page of results.
   * This field is empty if there are no more results.
   * </pre>
   *
   * <code>string next_page_token = 3;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The token that specifies the starting position of the next page of results.
   * This field is empty if there are no more results.
   * </pre>
   *
   * <code>string next_page_token = 3;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LOCATION_FILTERS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.talent.v4.Location> locationFilters_;
  /**
   *
   *
   * <pre>
   * The location filters that the service applied to the specified query. If
   * any filters are lat-lng based, the
   * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
   * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.talent.v4.Location> getLocationFiltersList() {
    return locationFilters_;
  }
  /**
   *
   *
   * <pre>
   * The location filters that the service applied to the specified query. If
   * any filters are lat-lng based, the
   * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
   * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.talent.v4.LocationOrBuilder>
      getLocationFiltersOrBuilderList() {
    return locationFilters_;
  }
  /**
   *
   *
   * <pre>
   * The location filters that the service applied to the specified query. If
   * any filters are lat-lng based, the
   * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
   * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
   */
  @java.lang.Override
  public int getLocationFiltersCount() {
    return locationFilters_.size();
  }
  /**
   *
   *
   * <pre>
   * The location filters that the service applied to the specified query. If
   * any filters are lat-lng based, the
   * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
   * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.Location getLocationFilters(int index) {
    return locationFilters_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The location filters that the service applied to the specified query. If
   * any filters are lat-lng based, the
   * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
   * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
   * </pre>
   *
   * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.LocationOrBuilder getLocationFiltersOrBuilder(int index) {
    return locationFilters_.get(index);
  }

  public static final int TOTAL_SIZE_FIELD_NUMBER = 6;
  private int totalSize_ = 0;
  /**
   *
   *
   * <pre>
   * Number of jobs that match the specified query.
   *
   * Note: This size is precise only if the total is less than 100,000.
   * </pre>
   *
   * <code>int32 total_size = 6;</code>
   *
   * @return The totalSize.
   */
  @java.lang.Override
  public int getTotalSize() {
    return totalSize_;
  }

  public static final int METADATA_FIELD_NUMBER = 7;
  private com.google.cloud.talent.v4.ResponseMetadata metadata_;
  /**
   *
   *
   * <pre>
   * Additional information for the API invocation, such as the request
   * tracking id.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 7;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return metadata_ != null;
  }
  /**
   *
   *
   * <pre>
   * Additional information for the API invocation, such as the request
   * tracking id.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 7;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.ResponseMetadata getMetadata() {
    return metadata_ == null
        ? com.google.cloud.talent.v4.ResponseMetadata.getDefaultInstance()
        : metadata_;
  }
  /**
   *
   *
   * <pre>
   * Additional information for the API invocation, such as the request
   * tracking id.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.ResponseMetadataOrBuilder getMetadataOrBuilder() {
    return metadata_ == null
        ? com.google.cloud.talent.v4.ResponseMetadata.getDefaultInstance()
        : metadata_;
  }

  public static final int BROADENED_QUERY_JOBS_COUNT_FIELD_NUMBER = 8;
  private int broadenedQueryJobsCount_ = 0;
  /**
   *
   *
   * <pre>
   * If query broadening is enabled, we may append additional results from the
   * broadened query. This number indicates how many of the jobs returned in the
   * jobs field are from the broadened query. These results are always at the
   * end of the jobs list. In particular, a value of 0, or if the field isn't
   * set, all the jobs in the jobs list are from the original
   * (without broadening) query. If this field is non-zero, subsequent requests
   * with offset after this result set should contain all broadened results.
   * </pre>
   *
   * <code>int32 broadened_query_jobs_count = 8;</code>
   *
   * @return The broadenedQueryJobsCount.
   */
  @java.lang.Override
  public int getBroadenedQueryJobsCount() {
    return broadenedQueryJobsCount_;
  }

  public static final int SPELL_CORRECTION_FIELD_NUMBER = 9;
  private com.google.cloud.talent.v4.SpellingCorrection spellCorrection_;
  /**
   *
   *
   * <pre>
   * The spell checking result, and correction.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.SpellingCorrection spell_correction = 9;</code>
   *
   * @return Whether the spellCorrection field is set.
   */
  @java.lang.Override
  public boolean hasSpellCorrection() {
    return spellCorrection_ != null;
  }
  /**
   *
   *
   * <pre>
   * The spell checking result, and correction.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.SpellingCorrection spell_correction = 9;</code>
   *
   * @return The spellCorrection.
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.SpellingCorrection getSpellCorrection() {
    return spellCorrection_ == null
        ? com.google.cloud.talent.v4.SpellingCorrection.getDefaultInstance()
        : spellCorrection_;
  }
  /**
   *
   *
   * <pre>
   * The spell checking result, and correction.
   * </pre>
   *
   * <code>.google.cloud.talent.v4.SpellingCorrection spell_correction = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.talent.v4.SpellingCorrectionOrBuilder getSpellCorrectionOrBuilder() {
    return spellCorrection_ == null
        ? com.google.cloud.talent.v4.SpellingCorrection.getDefaultInstance()
        : spellCorrection_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < matchingJobs_.size(); i++) {
      output.writeMessage(1, matchingJobs_.get(i));
    }
    for (int i = 0; i < histogramQueryResults_.size(); i++) {
      output.writeMessage(2, histogramQueryResults_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, nextPageToken_);
    }
    for (int i = 0; i < locationFilters_.size(); i++) {
      output.writeMessage(4, locationFilters_.get(i));
    }
    if (totalSize_ != 0) {
      output.writeInt32(6, totalSize_);
    }
    if (metadata_ != null) {
      output.writeMessage(7, getMetadata());
    }
    if (broadenedQueryJobsCount_ != 0) {
      output.writeInt32(8, broadenedQueryJobsCount_);
    }
    if (spellCorrection_ != null) {
      output.writeMessage(9, getSpellCorrection());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < matchingJobs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, matchingJobs_.get(i));
    }
    for (int i = 0; i < histogramQueryResults_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, histogramQueryResults_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, nextPageToken_);
    }
    for (int i = 0; i < locationFilters_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, locationFilters_.get(i));
    }
    if (totalSize_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, totalSize_);
    }
    if (metadata_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getMetadata());
    }
    if (broadenedQueryJobsCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(8, broadenedQueryJobsCount_);
    }
    if (spellCorrection_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getSpellCorrection());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.talent.v4.SearchJobsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.talent.v4.SearchJobsResponse other =
        (com.google.cloud.talent.v4.SearchJobsResponse) obj;

    if (!getMatchingJobsList().equals(other.getMatchingJobsList())) return false;
    if (!getHistogramQueryResultsList().equals(other.getHistogramQueryResultsList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getLocationFiltersList().equals(other.getLocationFiltersList())) return false;
    if (getTotalSize() != other.getTotalSize()) return false;
    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (getBroadenedQueryJobsCount() != other.getBroadenedQueryJobsCount()) return false;
    if (hasSpellCorrection() != other.hasSpellCorrection()) return false;
    if (hasSpellCorrection()) {
      if (!getSpellCorrection().equals(other.getSpellCorrection())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getMatchingJobsCount() > 0) {
      hash = (37 * hash) + MATCHING_JOBS_FIELD_NUMBER;
      hash = (53 * hash) + getMatchingJobsList().hashCode();
    }
    if (getHistogramQueryResultsCount() > 0) {
      hash = (37 * hash) + HISTOGRAM_QUERY_RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getHistogramQueryResultsList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    if (getLocationFiltersCount() > 0) {
      hash = (37 * hash) + LOCATION_FILTERS_FIELD_NUMBER;
      hash = (53 * hash) + getLocationFiltersList().hashCode();
    }
    hash = (37 * hash) + TOTAL_SIZE_FIELD_NUMBER;
    hash = (53 * hash) + getTotalSize();
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    hash = (37 * hash) + BROADENED_QUERY_JOBS_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getBroadenedQueryJobsCount();
    if (hasSpellCorrection()) {
      hash = (37 * hash) + SPELL_CORRECTION_FIELD_NUMBER;
      hash = (53 * hash) + getSpellCorrection().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.talent.v4.SearchJobsResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.SearchJobsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.SearchJobsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.SearchJobsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.SearchJobsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.talent.v4.SearchJobsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.SearchJobsResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.SearchJobsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.SearchJobsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.SearchJobsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.talent.v4.SearchJobsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.talent.v4.SearchJobsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.talent.v4.SearchJobsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response for SearchJob method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.talent.v4.SearchJobsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.talent.v4.SearchJobsResponse)
      com.google.cloud.talent.v4.SearchJobsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.talent.v4.JobServiceProto
          .internal_static_google_cloud_talent_v4_SearchJobsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.talent.v4.JobServiceProto
          .internal_static_google_cloud_talent_v4_SearchJobsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.talent.v4.SearchJobsResponse.class,
              com.google.cloud.talent.v4.SearchJobsResponse.Builder.class);
    }

    // Construct using com.google.cloud.talent.v4.SearchJobsResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (matchingJobsBuilder_ == null) {
        matchingJobs_ = java.util.Collections.emptyList();
      } else {
        matchingJobs_ = null;
        matchingJobsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      if (histogramQueryResultsBuilder_ == null) {
        histogramQueryResults_ = java.util.Collections.emptyList();
      } else {
        histogramQueryResults_ = null;
        histogramQueryResultsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      nextPageToken_ = "";
      if (locationFiltersBuilder_ == null) {
        locationFilters_ = java.util.Collections.emptyList();
      } else {
        locationFilters_ = null;
        locationFiltersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      totalSize_ = 0;
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      broadenedQueryJobsCount_ = 0;
      spellCorrection_ = null;
      if (spellCorrectionBuilder_ != null) {
        spellCorrectionBuilder_.dispose();
        spellCorrectionBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.talent.v4.JobServiceProto
          .internal_static_google_cloud_talent_v4_SearchJobsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.SearchJobsResponse getDefaultInstanceForType() {
      return com.google.cloud.talent.v4.SearchJobsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.SearchJobsResponse build() {
      com.google.cloud.talent.v4.SearchJobsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.talent.v4.SearchJobsResponse buildPartial() {
      com.google.cloud.talent.v4.SearchJobsResponse result =
          new com.google.cloud.talent.v4.SearchJobsResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.talent.v4.SearchJobsResponse result) {
      if (matchingJobsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          matchingJobs_ = java.util.Collections.unmodifiableList(matchingJobs_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.matchingJobs_ = matchingJobs_;
      } else {
        result.matchingJobs_ = matchingJobsBuilder_.build();
      }
      if (histogramQueryResultsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          histogramQueryResults_ = java.util.Collections.unmodifiableList(histogramQueryResults_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.histogramQueryResults_ = histogramQueryResults_;
      } else {
        result.histogramQueryResults_ = histogramQueryResultsBuilder_.build();
      }
      if (locationFiltersBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          locationFilters_ = java.util.Collections.unmodifiableList(locationFilters_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.locationFilters_ = locationFilters_;
      } else {
        result.locationFilters_ = locationFiltersBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.talent.v4.SearchJobsResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.totalSize_ = totalSize_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.broadenedQueryJobsCount_ = broadenedQueryJobsCount_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.spellCorrection_ =
            spellCorrectionBuilder_ == null ? spellCorrection_ : spellCorrectionBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.talent.v4.SearchJobsResponse) {
        return mergeFrom((com.google.cloud.talent.v4.SearchJobsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.talent.v4.SearchJobsResponse other) {
      if (other == com.google.cloud.talent.v4.SearchJobsResponse.getDefaultInstance()) return this;
      if (matchingJobsBuilder_ == null) {
        if (!other.matchingJobs_.isEmpty()) {
          if (matchingJobs_.isEmpty()) {
            matchingJobs_ = other.matchingJobs_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureMatchingJobsIsMutable();
            matchingJobs_.addAll(other.matchingJobs_);
          }
          onChanged();
        }
      } else {
        if (!other.matchingJobs_.isEmpty()) {
          if (matchingJobsBuilder_.isEmpty()) {
            matchingJobsBuilder_.dispose();
            matchingJobsBuilder_ = null;
            matchingJobs_ = other.matchingJobs_;
            bitField0_ = (bitField0_ & ~0x00000001);
            matchingJobsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMatchingJobsFieldBuilder()
                    : null;
          } else {
            matchingJobsBuilder_.addAllMessages(other.matchingJobs_);
          }
        }
      }
      if (histogramQueryResultsBuilder_ == null) {
        if (!other.histogramQueryResults_.isEmpty()) {
          if (histogramQueryResults_.isEmpty()) {
            histogramQueryResults_ = other.histogramQueryResults_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureHistogramQueryResultsIsMutable();
            histogramQueryResults_.addAll(other.histogramQueryResults_);
          }
          onChanged();
        }
      } else {
        if (!other.histogramQueryResults_.isEmpty()) {
          if (histogramQueryResultsBuilder_.isEmpty()) {
            histogramQueryResultsBuilder_.dispose();
            histogramQueryResultsBuilder_ = null;
            histogramQueryResults_ = other.histogramQueryResults_;
            bitField0_ = (bitField0_ & ~0x00000002);
            histogramQueryResultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getHistogramQueryResultsFieldBuilder()
                    : null;
          } else {
            histogramQueryResultsBuilder_.addAllMessages(other.histogramQueryResults_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (locationFiltersBuilder_ == null) {
        if (!other.locationFilters_.isEmpty()) {
          if (locationFilters_.isEmpty()) {
            locationFilters_ = other.locationFilters_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureLocationFiltersIsMutable();
            locationFilters_.addAll(other.locationFilters_);
          }
          onChanged();
        }
      } else {
        if (!other.locationFilters_.isEmpty()) {
          if (locationFiltersBuilder_.isEmpty()) {
            locationFiltersBuilder_.dispose();
            locationFiltersBuilder_ = null;
            locationFilters_ = other.locationFilters_;
            bitField0_ = (bitField0_ & ~0x00000008);
            locationFiltersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLocationFiltersFieldBuilder()
                    : null;
          } else {
            locationFiltersBuilder_.addAllMessages(other.locationFilters_);
          }
        }
      }
      if (other.getTotalSize() != 0) {
        setTotalSize(other.getTotalSize());
      }
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      if (other.getBroadenedQueryJobsCount() != 0) {
        setBroadenedQueryJobsCount(other.getBroadenedQueryJobsCount());
      }
      if (other.hasSpellCorrection()) {
        mergeSpellCorrection(other.getSpellCorrection());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob m =
                    input.readMessage(
                        com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob.parser(),
                        extensionRegistry);
                if (matchingJobsBuilder_ == null) {
                  ensureMatchingJobsIsMutable();
                  matchingJobs_.add(m);
                } else {
                  matchingJobsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.talent.v4.HistogramQueryResult m =
                    input.readMessage(
                        com.google.cloud.talent.v4.HistogramQueryResult.parser(),
                        extensionRegistry);
                if (histogramQueryResultsBuilder_ == null) {
                  ensureHistogramQueryResultsIsMutable();
                  histogramQueryResults_.add(m);
                } else {
                  histogramQueryResultsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.talent.v4.Location m =
                    input.readMessage(
                        com.google.cloud.talent.v4.Location.parser(), extensionRegistry);
                if (locationFiltersBuilder_ == null) {
                  ensureLocationFiltersIsMutable();
                  locationFilters_.add(m);
                } else {
                  locationFiltersBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 48:
              {
                totalSize_ = input.readInt32();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            case 58:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 64:
              {
                broadenedQueryJobsCount_ = input.readInt32();
                bitField0_ |= 0x00000040;
                break;
              } // case 64
            case 74:
              {
                input.readMessage(getSpellCorrectionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob>
        matchingJobs_ = java.util.Collections.emptyList();

    private void ensureMatchingJobsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        matchingJobs_ =
            new java.util.ArrayList<com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob>(
                matchingJobs_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob,
            com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob.Builder,
            com.google.cloud.talent.v4.SearchJobsResponse.MatchingJobOrBuilder>
        matchingJobsBuilder_;

    /**
     *
     *
     * <pre>
     * The Job entities that match the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob>
        getMatchingJobsList() {
      if (matchingJobsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(matchingJobs_);
      } else {
        return matchingJobsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The Job entities that match the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;
     * </code>
     */
    public int getMatchingJobsCount() {
      if (matchingJobsBuilder_ == null) {
        return matchingJobs_.size();
      } else {
        return matchingJobsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The Job entities that match the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;
     * </code>
     */
    public com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob getMatchingJobs(int index) {
      if (matchingJobsBuilder_ == null) {
        return matchingJobs_.get(index);
      } else {
        return matchingJobsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The Job entities that match the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;
     * </code>
     */
    public Builder setMatchingJobs(
        int index, com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob value) {
      if (matchingJobsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMatchingJobsIsMutable();
        matchingJobs_.set(index, value);
        onChanged();
      } else {
        matchingJobsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Job entities that match the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;
     * </code>
     */
    public Builder setMatchingJobs(
        int index,
        com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob.Builder builderForValue) {
      if (matchingJobsBuilder_ == null) {
        ensureMatchingJobsIsMutable();
        matchingJobs_.set(index, builderForValue.build());
        onChanged();
      } else {
        matchingJobsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Job entities that match the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;
     * </code>
     */
    public Builder addMatchingJobs(
        com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob value) {
      if (matchingJobsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMatchingJobsIsMutable();
        matchingJobs_.add(value);
        onChanged();
      } else {
        matchingJobsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Job entities that match the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;
     * </code>
     */
    public Builder addMatchingJobs(
        int index, com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob value) {
      if (matchingJobsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMatchingJobsIsMutable();
        matchingJobs_.add(index, value);
        onChanged();
      } else {
        matchingJobsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Job entities that match the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;
     * </code>
     */
    public Builder addMatchingJobs(
        com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob.Builder builderForValue) {
      if (matchingJobsBuilder_ == null) {
        ensureMatchingJobsIsMutable();
        matchingJobs_.add(builderForValue.build());
        onChanged();
      } else {
        matchingJobsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Job entities that match the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;
     * </code>
     */
    public Builder addMatchingJobs(
        int index,
        com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob.Builder builderForValue) {
      if (matchingJobsBuilder_ == null) {
        ensureMatchingJobsIsMutable();
        matchingJobs_.add(index, builderForValue.build());
        onChanged();
      } else {
        matchingJobsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Job entities that match the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;
     * </code>
     */
    public Builder addAllMatchingJobs(
        java.lang.Iterable<? extends com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob>
            values) {
      if (matchingJobsBuilder_ == null) {
        ensureMatchingJobsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, matchingJobs_);
        onChanged();
      } else {
        matchingJobsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Job entities that match the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;
     * </code>
     */
    public Builder clearMatchingJobs() {
      if (matchingJobsBuilder_ == null) {
        matchingJobs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        matchingJobsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Job entities that match the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;
     * </code>
     */
    public Builder removeMatchingJobs(int index) {
      if (matchingJobsBuilder_ == null) {
        ensureMatchingJobsIsMutable();
        matchingJobs_.remove(index);
        onChanged();
      } else {
        matchingJobsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The Job entities that match the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;
     * </code>
     */
    public com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob.Builder getMatchingJobsBuilder(
        int index) {
      return getMatchingJobsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The Job entities that match the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;
     * </code>
     */
    public com.google.cloud.talent.v4.SearchJobsResponse.MatchingJobOrBuilder
        getMatchingJobsOrBuilder(int index) {
      if (matchingJobsBuilder_ == null) {
        return matchingJobs_.get(index);
      } else {
        return matchingJobsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The Job entities that match the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.talent.v4.SearchJobsResponse.MatchingJobOrBuilder>
        getMatchingJobsOrBuilderList() {
      if (matchingJobsBuilder_ != null) {
        return matchingJobsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(matchingJobs_);
      }
    }
    /**
     *
     *
     * <pre>
     * The Job entities that match the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;
     * </code>
     */
    public com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob.Builder
        addMatchingJobsBuilder() {
      return getMatchingJobsFieldBuilder()
          .addBuilder(
              com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The Job entities that match the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;
     * </code>
     */
    public com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob.Builder addMatchingJobsBuilder(
        int index) {
      return getMatchingJobsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The Job entities that match the specified
     * [SearchJobsRequest][google.cloud.talent.v4.SearchJobsRequest].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.SearchJobsResponse.MatchingJob matching_jobs = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob.Builder>
        getMatchingJobsBuilderList() {
      return getMatchingJobsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob,
            com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob.Builder,
            com.google.cloud.talent.v4.SearchJobsResponse.MatchingJobOrBuilder>
        getMatchingJobsFieldBuilder() {
      if (matchingJobsBuilder_ == null) {
        matchingJobsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob,
                com.google.cloud.talent.v4.SearchJobsResponse.MatchingJob.Builder,
                com.google.cloud.talent.v4.SearchJobsResponse.MatchingJobOrBuilder>(
                matchingJobs_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        matchingJobs_ = null;
      }
      return matchingJobsBuilder_;
    }

    private java.util.List<com.google.cloud.talent.v4.HistogramQueryResult> histogramQueryResults_ =
        java.util.Collections.emptyList();

    private void ensureHistogramQueryResultsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        histogramQueryResults_ =
            new java.util.ArrayList<com.google.cloud.talent.v4.HistogramQueryResult>(
                histogramQueryResults_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.talent.v4.HistogramQueryResult,
            com.google.cloud.talent.v4.HistogramQueryResult.Builder,
            com.google.cloud.talent.v4.HistogramQueryResultOrBuilder>
        histogramQueryResultsBuilder_;

    /**
     *
     *
     * <pre>
     * The histogram results that match with specified
     * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.talent.v4.HistogramQueryResult>
        getHistogramQueryResultsList() {
      if (histogramQueryResultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(histogramQueryResults_);
      } else {
        return histogramQueryResultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The histogram results that match with specified
     * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;
     * </code>
     */
    public int getHistogramQueryResultsCount() {
      if (histogramQueryResultsBuilder_ == null) {
        return histogramQueryResults_.size();
      } else {
        return histogramQueryResultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The histogram results that match with specified
     * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;
     * </code>
     */
    public com.google.cloud.talent.v4.HistogramQueryResult getHistogramQueryResults(int index) {
      if (histogramQueryResultsBuilder_ == null) {
        return histogramQueryResults_.get(index);
      } else {
        return histogramQueryResultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The histogram results that match with specified
     * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;
     * </code>
     */
    public Builder setHistogramQueryResults(
        int index, com.google.cloud.talent.v4.HistogramQueryResult value) {
      if (histogramQueryResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHistogramQueryResultsIsMutable();
        histogramQueryResults_.set(index, value);
        onChanged();
      } else {
        histogramQueryResultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The histogram results that match with specified
     * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;
     * </code>
     */
    public Builder setHistogramQueryResults(
        int index, com.google.cloud.talent.v4.HistogramQueryResult.Builder builderForValue) {
      if (histogramQueryResultsBuilder_ == null) {
        ensureHistogramQueryResultsIsMutable();
        histogramQueryResults_.set(index, builderForValue.build());
        onChanged();
      } else {
        histogramQueryResultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The histogram results that match with specified
     * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;
     * </code>
     */
    public Builder addHistogramQueryResults(com.google.cloud.talent.v4.HistogramQueryResult value) {
      if (histogramQueryResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHistogramQueryResultsIsMutable();
        histogramQueryResults_.add(value);
        onChanged();
      } else {
        histogramQueryResultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The histogram results that match with specified
     * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;
     * </code>
     */
    public Builder addHistogramQueryResults(
        int index, com.google.cloud.talent.v4.HistogramQueryResult value) {
      if (histogramQueryResultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHistogramQueryResultsIsMutable();
        histogramQueryResults_.add(index, value);
        onChanged();
      } else {
        histogramQueryResultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The histogram results that match with specified
     * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;
     * </code>
     */
    public Builder addHistogramQueryResults(
        com.google.cloud.talent.v4.HistogramQueryResult.Builder builderForValue) {
      if (histogramQueryResultsBuilder_ == null) {
        ensureHistogramQueryResultsIsMutable();
        histogramQueryResults_.add(builderForValue.build());
        onChanged();
      } else {
        histogramQueryResultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The histogram results that match with specified
     * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;
     * </code>
     */
    public Builder addHistogramQueryResults(
        int index, com.google.cloud.talent.v4.HistogramQueryResult.Builder builderForValue) {
      if (histogramQueryResultsBuilder_ == null) {
        ensureHistogramQueryResultsIsMutable();
        histogramQueryResults_.add(index, builderForValue.build());
        onChanged();
      } else {
        histogramQueryResultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The histogram results that match with specified
     * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;
     * </code>
     */
    public Builder addAllHistogramQueryResults(
        java.lang.Iterable<? extends com.google.cloud.talent.v4.HistogramQueryResult> values) {
      if (histogramQueryResultsBuilder_ == null) {
        ensureHistogramQueryResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, histogramQueryResults_);
        onChanged();
      } else {
        histogramQueryResultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The histogram results that match with specified
     * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;
     * </code>
     */
    public Builder clearHistogramQueryResults() {
      if (histogramQueryResultsBuilder_ == null) {
        histogramQueryResults_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        histogramQueryResultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The histogram results that match with specified
     * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;
     * </code>
     */
    public Builder removeHistogramQueryResults(int index) {
      if (histogramQueryResultsBuilder_ == null) {
        ensureHistogramQueryResultsIsMutable();
        histogramQueryResults_.remove(index);
        onChanged();
      } else {
        histogramQueryResultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The histogram results that match with specified
     * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;
     * </code>
     */
    public com.google.cloud.talent.v4.HistogramQueryResult.Builder getHistogramQueryResultsBuilder(
        int index) {
      return getHistogramQueryResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The histogram results that match with specified
     * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;
     * </code>
     */
    public com.google.cloud.talent.v4.HistogramQueryResultOrBuilder
        getHistogramQueryResultsOrBuilder(int index) {
      if (histogramQueryResultsBuilder_ == null) {
        return histogramQueryResults_.get(index);
      } else {
        return histogramQueryResultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The histogram results that match with specified
     * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.talent.v4.HistogramQueryResultOrBuilder>
        getHistogramQueryResultsOrBuilderList() {
      if (histogramQueryResultsBuilder_ != null) {
        return histogramQueryResultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(histogramQueryResults_);
      }
    }
    /**
     *
     *
     * <pre>
     * The histogram results that match with specified
     * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;
     * </code>
     */
    public com.google.cloud.talent.v4.HistogramQueryResult.Builder
        addHistogramQueryResultsBuilder() {
      return getHistogramQueryResultsFieldBuilder()
          .addBuilder(com.google.cloud.talent.v4.HistogramQueryResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The histogram results that match with specified
     * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;
     * </code>
     */
    public com.google.cloud.talent.v4.HistogramQueryResult.Builder addHistogramQueryResultsBuilder(
        int index) {
      return getHistogramQueryResultsFieldBuilder()
          .addBuilder(index, com.google.cloud.talent.v4.HistogramQueryResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The histogram results that match with specified
     * [SearchJobsRequest.histogram_queries][google.cloud.talent.v4.SearchJobsRequest.histogram_queries].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.HistogramQueryResult histogram_query_results = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.talent.v4.HistogramQueryResult.Builder>
        getHistogramQueryResultsBuilderList() {
      return getHistogramQueryResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.talent.v4.HistogramQueryResult,
            com.google.cloud.talent.v4.HistogramQueryResult.Builder,
            com.google.cloud.talent.v4.HistogramQueryResultOrBuilder>
        getHistogramQueryResultsFieldBuilder() {
      if (histogramQueryResultsBuilder_ == null) {
        histogramQueryResultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.talent.v4.HistogramQueryResult,
                com.google.cloud.talent.v4.HistogramQueryResult.Builder,
                com.google.cloud.talent.v4.HistogramQueryResultOrBuilder>(
                histogramQueryResults_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        histogramQueryResults_ = null;
      }
      return histogramQueryResultsBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * The token that specifies the starting position of the next page of results.
     * This field is empty if there are no more results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The token that specifies the starting position of the next page of results.
     * This field is empty if there are no more results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The token that specifies the starting position of the next page of results.
     * This field is empty if there are no more results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The token that specifies the starting position of the next page of results.
     * This field is empty if there are no more results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The token that specifies the starting position of the next page of results.
     * This field is empty if there are no more results.
     * </pre>
     *
     * <code>string next_page_token = 3;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.talent.v4.Location> locationFilters_ =
        java.util.Collections.emptyList();

    private void ensureLocationFiltersIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        locationFilters_ =
            new java.util.ArrayList<com.google.cloud.talent.v4.Location>(locationFilters_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.talent.v4.Location,
            com.google.cloud.talent.v4.Location.Builder,
            com.google.cloud.talent.v4.LocationOrBuilder>
        locationFiltersBuilder_;

    /**
     *
     *
     * <pre>
     * The location filters that the service applied to the specified query. If
     * any filters are lat-lng based, the
     * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
     * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
     */
    public java.util.List<com.google.cloud.talent.v4.Location> getLocationFiltersList() {
      if (locationFiltersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(locationFilters_);
      } else {
        return locationFiltersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The location filters that the service applied to the specified query. If
     * any filters are lat-lng based, the
     * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
     * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
     */
    public int getLocationFiltersCount() {
      if (locationFiltersBuilder_ == null) {
        return locationFilters_.size();
      } else {
        return locationFiltersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The location filters that the service applied to the specified query. If
     * any filters are lat-lng based, the
     * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
     * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
     */
    public com.google.cloud.talent.v4.Location getLocationFilters(int index) {
      if (locationFiltersBuilder_ == null) {
        return locationFilters_.get(index);
      } else {
        return locationFiltersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The location filters that the service applied to the specified query. If
     * any filters are lat-lng based, the
     * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
     * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
     */
    public Builder setLocationFilters(int index, com.google.cloud.talent.v4.Location value) {
      if (locationFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocationFiltersIsMutable();
        locationFilters_.set(index, value);
        onChanged();
      } else {
        locationFiltersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location filters that the service applied to the specified query. If
     * any filters are lat-lng based, the
     * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
     * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
     */
    public Builder setLocationFilters(
        int index, com.google.cloud.talent.v4.Location.Builder builderForValue) {
      if (locationFiltersBuilder_ == null) {
        ensureLocationFiltersIsMutable();
        locationFilters_.set(index, builderForValue.build());
        onChanged();
      } else {
        locationFiltersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location filters that the service applied to the specified query. If
     * any filters are lat-lng based, the
     * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
     * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
     */
    public Builder addLocationFilters(com.google.cloud.talent.v4.Location value) {
      if (locationFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocationFiltersIsMutable();
        locationFilters_.add(value);
        onChanged();
      } else {
        locationFiltersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location filters that the service applied to the specified query. If
     * any filters are lat-lng based, the
     * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
     * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
     */
    public Builder addLocationFilters(int index, com.google.cloud.talent.v4.Location value) {
      if (locationFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLocationFiltersIsMutable();
        locationFilters_.add(index, value);
        onChanged();
      } else {
        locationFiltersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location filters that the service applied to the specified query. If
     * any filters are lat-lng based, the
     * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
     * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
     */
    public Builder addLocationFilters(com.google.cloud.talent.v4.Location.Builder builderForValue) {
      if (locationFiltersBuilder_ == null) {
        ensureLocationFiltersIsMutable();
        locationFilters_.add(builderForValue.build());
        onChanged();
      } else {
        locationFiltersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location filters that the service applied to the specified query. If
     * any filters are lat-lng based, the
     * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
     * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
     */
    public Builder addLocationFilters(
        int index, com.google.cloud.talent.v4.Location.Builder builderForValue) {
      if (locationFiltersBuilder_ == null) {
        ensureLocationFiltersIsMutable();
        locationFilters_.add(index, builderForValue.build());
        onChanged();
      } else {
        locationFiltersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location filters that the service applied to the specified query. If
     * any filters are lat-lng based, the
     * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
     * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
     */
    public Builder addAllLocationFilters(
        java.lang.Iterable<? extends com.google.cloud.talent.v4.Location> values) {
      if (locationFiltersBuilder_ == null) {
        ensureLocationFiltersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, locationFilters_);
        onChanged();
      } else {
        locationFiltersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location filters that the service applied to the specified query. If
     * any filters are lat-lng based, the
     * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
     * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
     */
    public Builder clearLocationFilters() {
      if (locationFiltersBuilder_ == null) {
        locationFilters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        locationFiltersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location filters that the service applied to the specified query. If
     * any filters are lat-lng based, the
     * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
     * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
     */
    public Builder removeLocationFilters(int index) {
      if (locationFiltersBuilder_ == null) {
        ensureLocationFiltersIsMutable();
        locationFilters_.remove(index);
        onChanged();
      } else {
        locationFiltersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The location filters that the service applied to the specified query. If
     * any filters are lat-lng based, the
     * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
     * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
     */
    public com.google.cloud.talent.v4.Location.Builder getLocationFiltersBuilder(int index) {
      return getLocationFiltersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The location filters that the service applied to the specified query. If
     * any filters are lat-lng based, the
     * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
     * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
     */
    public com.google.cloud.talent.v4.LocationOrBuilder getLocationFiltersOrBuilder(int index) {
      if (locationFiltersBuilder_ == null) {
        return locationFilters_.get(index);
      } else {
        return locationFiltersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The location filters that the service applied to the specified query. If
     * any filters are lat-lng based, the
     * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
     * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
     */
    public java.util.List<? extends com.google.cloud.talent.v4.LocationOrBuilder>
        getLocationFiltersOrBuilderList() {
      if (locationFiltersBuilder_ != null) {
        return locationFiltersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(locationFilters_);
      }
    }
    /**
     *
     *
     * <pre>
     * The location filters that the service applied to the specified query. If
     * any filters are lat-lng based, the
     * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
     * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
     */
    public com.google.cloud.talent.v4.Location.Builder addLocationFiltersBuilder() {
      return getLocationFiltersFieldBuilder()
          .addBuilder(com.google.cloud.talent.v4.Location.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The location filters that the service applied to the specified query. If
     * any filters are lat-lng based, the
     * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
     * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
     */
    public com.google.cloud.talent.v4.Location.Builder addLocationFiltersBuilder(int index) {
      return getLocationFiltersFieldBuilder()
          .addBuilder(index, com.google.cloud.talent.v4.Location.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The location filters that the service applied to the specified query. If
     * any filters are lat-lng based, the
     * [Location.location_type][google.cloud.talent.v4.Location.location_type] is
     * [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
     * </pre>
     *
     * <code>repeated .google.cloud.talent.v4.Location location_filters = 4;</code>
     */
    public java.util.List<com.google.cloud.talent.v4.Location.Builder>
        getLocationFiltersBuilderList() {
      return getLocationFiltersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.talent.v4.Location,
            com.google.cloud.talent.v4.Location.Builder,
            com.google.cloud.talent.v4.LocationOrBuilder>
        getLocationFiltersFieldBuilder() {
      if (locationFiltersBuilder_ == null) {
        locationFiltersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.talent.v4.Location,
                com.google.cloud.talent.v4.Location.Builder,
                com.google.cloud.talent.v4.LocationOrBuilder>(
                locationFilters_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        locationFilters_ = null;
      }
      return locationFiltersBuilder_;
    }

    private int totalSize_;
    /**
     *
     *
     * <pre>
     * Number of jobs that match the specified query.
     *
     * Note: This size is precise only if the total is less than 100,000.
     * </pre>
     *
     * <code>int32 total_size = 6;</code>
     *
     * @return The totalSize.
     */
    @java.lang.Override
    public int getTotalSize() {
      return totalSize_;
    }
    /**
     *
     *
     * <pre>
     * Number of jobs that match the specified query.
     *
     * Note: This size is precise only if the total is less than 100,000.
     * </pre>
     *
     * <code>int32 total_size = 6;</code>
     *
     * @param value The totalSize to set.
     * @return This builder for chaining.
     */
    public Builder setTotalSize(int value) {

      totalSize_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of jobs that match the specified query.
     *
     * Note: This size is precise only if the total is less than 100,000.
     * </pre>
     *
     * <code>int32 total_size = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTotalSize() {
      bitField0_ = (bitField0_ & ~0x00000010);
      totalSize_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.talent.v4.ResponseMetadata metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.ResponseMetadata,
            com.google.cloud.talent.v4.ResponseMetadata.Builder,
            com.google.cloud.talent.v4.ResponseMetadataOrBuilder>
        metadataBuilder_;
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 7;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 7;</code>
     *
     * @return The metadata.
     */
    public com.google.cloud.talent.v4.ResponseMetadata getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null
            ? com.google.cloud.talent.v4.ResponseMetadata.getDefaultInstance()
            : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 7;</code>
     */
    public Builder setMetadata(com.google.cloud.talent.v4.ResponseMetadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 7;</code>
     */
    public Builder setMetadata(
        com.google.cloud.talent.v4.ResponseMetadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 7;</code>
     */
    public Builder mergeMetadata(com.google.cloud.talent.v4.ResponseMetadata value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && metadata_ != null
            && metadata_ != com.google.cloud.talent.v4.ResponseMetadata.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 7;</code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000020);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 7;</code>
     */
    public com.google.cloud.talent.v4.ResponseMetadata.Builder getMetadataBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 7;</code>
     */
    public com.google.cloud.talent.v4.ResponseMetadataOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null
            ? com.google.cloud.talent.v4.ResponseMetadata.getDefaultInstance()
            : metadata_;
      }
    }
    /**
     *
     *
     * <pre>
     * Additional information for the API invocation, such as the request
     * tracking id.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.ResponseMetadata metadata = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.ResponseMetadata,
            com.google.cloud.talent.v4.ResponseMetadata.Builder,
            com.google.cloud.talent.v4.ResponseMetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.talent.v4.ResponseMetadata,
                com.google.cloud.talent.v4.ResponseMetadata.Builder,
                com.google.cloud.talent.v4.ResponseMetadataOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    private int broadenedQueryJobsCount_;
    /**
     *
     *
     * <pre>
     * If query broadening is enabled, we may append additional results from the
     * broadened query. This number indicates how many of the jobs returned in the
     * jobs field are from the broadened query. These results are always at the
     * end of the jobs list. In particular, a value of 0, or if the field isn't
     * set, all the jobs in the jobs list are from the original
     * (without broadening) query. If this field is non-zero, subsequent requests
     * with offset after this result set should contain all broadened results.
     * </pre>
     *
     * <code>int32 broadened_query_jobs_count = 8;</code>
     *
     * @return The broadenedQueryJobsCount.
     */
    @java.lang.Override
    public int getBroadenedQueryJobsCount() {
      return broadenedQueryJobsCount_;
    }
    /**
     *
     *
     * <pre>
     * If query broadening is enabled, we may append additional results from the
     * broadened query. This number indicates how many of the jobs returned in the
     * jobs field are from the broadened query. These results are always at the
     * end of the jobs list. In particular, a value of 0, or if the field isn't
     * set, all the jobs in the jobs list are from the original
     * (without broadening) query. If this field is non-zero, subsequent requests
     * with offset after this result set should contain all broadened results.
     * </pre>
     *
     * <code>int32 broadened_query_jobs_count = 8;</code>
     *
     * @param value The broadenedQueryJobsCount to set.
     * @return This builder for chaining.
     */
    public Builder setBroadenedQueryJobsCount(int value) {

      broadenedQueryJobsCount_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If query broadening is enabled, we may append additional results from the
     * broadened query. This number indicates how many of the jobs returned in the
     * jobs field are from the broadened query. These results are always at the
     * end of the jobs list. In particular, a value of 0, or if the field isn't
     * set, all the jobs in the jobs list are from the original
     * (without broadening) query. If this field is non-zero, subsequent requests
     * with offset after this result set should contain all broadened results.
     * </pre>
     *
     * <code>int32 broadened_query_jobs_count = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBroadenedQueryJobsCount() {
      bitField0_ = (bitField0_ & ~0x00000040);
      broadenedQueryJobsCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.talent.v4.SpellingCorrection spellCorrection_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.SpellingCorrection,
            com.google.cloud.talent.v4.SpellingCorrection.Builder,
            com.google.cloud.talent.v4.SpellingCorrectionOrBuilder>
        spellCorrectionBuilder_;
    /**
     *
     *
     * <pre>
     * The spell checking result, and correction.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SpellingCorrection spell_correction = 9;</code>
     *
     * @return Whether the spellCorrection field is set.
     */
    public boolean hasSpellCorrection() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The spell checking result, and correction.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SpellingCorrection spell_correction = 9;</code>
     *
     * @return The spellCorrection.
     */
    public com.google.cloud.talent.v4.SpellingCorrection getSpellCorrection() {
      if (spellCorrectionBuilder_ == null) {
        return spellCorrection_ == null
            ? com.google.cloud.talent.v4.SpellingCorrection.getDefaultInstance()
            : spellCorrection_;
      } else {
        return spellCorrectionBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The spell checking result, and correction.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SpellingCorrection spell_correction = 9;</code>
     */
    public Builder setSpellCorrection(com.google.cloud.talent.v4.SpellingCorrection value) {
      if (spellCorrectionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        spellCorrection_ = value;
      } else {
        spellCorrectionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The spell checking result, and correction.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SpellingCorrection spell_correction = 9;</code>
     */
    public Builder setSpellCorrection(
        com.google.cloud.talent.v4.SpellingCorrection.Builder builderForValue) {
      if (spellCorrectionBuilder_ == null) {
        spellCorrection_ = builderForValue.build();
      } else {
        spellCorrectionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The spell checking result, and correction.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SpellingCorrection spell_correction = 9;</code>
     */
    public Builder mergeSpellCorrection(com.google.cloud.talent.v4.SpellingCorrection value) {
      if (spellCorrectionBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && spellCorrection_ != null
            && spellCorrection_
                != com.google.cloud.talent.v4.SpellingCorrection.getDefaultInstance()) {
          getSpellCorrectionBuilder().mergeFrom(value);
        } else {
          spellCorrection_ = value;
        }
      } else {
        spellCorrectionBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The spell checking result, and correction.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SpellingCorrection spell_correction = 9;</code>
     */
    public Builder clearSpellCorrection() {
      bitField0_ = (bitField0_ & ~0x00000080);
      spellCorrection_ = null;
      if (spellCorrectionBuilder_ != null) {
        spellCorrectionBuilder_.dispose();
        spellCorrectionBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The spell checking result, and correction.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SpellingCorrection spell_correction = 9;</code>
     */
    public com.google.cloud.talent.v4.SpellingCorrection.Builder getSpellCorrectionBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getSpellCorrectionFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The spell checking result, and correction.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SpellingCorrection spell_correction = 9;</code>
     */
    public com.google.cloud.talent.v4.SpellingCorrectionOrBuilder getSpellCorrectionOrBuilder() {
      if (spellCorrectionBuilder_ != null) {
        return spellCorrectionBuilder_.getMessageOrBuilder();
      } else {
        return spellCorrection_ == null
            ? com.google.cloud.talent.v4.SpellingCorrection.getDefaultInstance()
            : spellCorrection_;
      }
    }
    /**
     *
     *
     * <pre>
     * The spell checking result, and correction.
     * </pre>
     *
     * <code>.google.cloud.talent.v4.SpellingCorrection spell_correction = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.talent.v4.SpellingCorrection,
            com.google.cloud.talent.v4.SpellingCorrection.Builder,
            com.google.cloud.talent.v4.SpellingCorrectionOrBuilder>
        getSpellCorrectionFieldBuilder() {
      if (spellCorrectionBuilder_ == null) {
        spellCorrectionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.talent.v4.SpellingCorrection,
                com.google.cloud.talent.v4.SpellingCorrection.Builder,
                com.google.cloud.talent.v4.SpellingCorrectionOrBuilder>(
                getSpellCorrection(), getParentForChildren(), isClean());
        spellCorrection_ = null;
      }
      return spellCorrectionBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.talent.v4.SearchJobsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.talent.v4.SearchJobsResponse)
  private static final com.google.cloud.talent.v4.SearchJobsResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.talent.v4.SearchJobsResponse();
  }

  public static com.google.cloud.talent.v4.SearchJobsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SearchJobsResponse> PARSER =
      new com.google.protobuf.AbstractParser<SearchJobsResponse>() {
        @java.lang.Override
        public SearchJobsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SearchJobsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SearchJobsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.talent.v4.SearchJobsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
