/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/tasks/v2/queue.proto

package com.google.cloud.tasks.v2;

/**
 *
 *
 * <pre>
 * A queue is a container of related tasks. Queues are configured to manage
 * how those tasks are dispatched. Configurable properties include rate limits,
 * retry options, queue types, and others.
 * </pre>
 *
 * Protobuf type {@code google.cloud.tasks.v2.Queue}
 */
public final class Queue extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.tasks.v2.Queue)
    QueueOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Queue.newBuilder() to construct.
  private Queue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Queue() {
    name_ = "";
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Queue();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.tasks.v2.QueueProto
        .internal_static_google_cloud_tasks_v2_Queue_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.tasks.v2.QueueProto
        .internal_static_google_cloud_tasks_v2_Queue_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.tasks.v2.Queue.class, com.google.cloud.tasks.v2.Queue.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * State of the queue.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.tasks.v2.Queue.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The queue is running. Tasks can be dispatched.
     * If the queue was created using Cloud Tasks and the queue has
     * had no activity (method calls or task dispatches) for 30 days,
     * the queue may take a few minutes to re-activate. Some method
     * calls may return [NOT_FOUND][google.rpc.Code.NOT_FOUND] and
     * tasks may not be dispatched for a few minutes until the queue
     * has been re-activated.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    RUNNING(1),
    /**
     *
     *
     * <pre>
     * Tasks are paused by the user. If the queue is paused then Cloud
     * Tasks will stop delivering tasks from it, but more tasks can
     * still be added to it by the user.
     * </pre>
     *
     * <code>PAUSED = 2;</code>
     */
    PAUSED(2),
    /**
     *
     *
     * <pre>
     * The queue is disabled.
     * A queue becomes `DISABLED` when
     * [queue.yaml](https://cloud.google.com/appengine/docs/python/config/queueref)
     * or
     * [queue.xml](https://cloud.google.com/appengine/docs/standard/java/config/queueref)
     * is uploaded which does not contain the queue. You cannot directly disable
     * a queue.
     * When a queue is disabled, tasks can still be added to a queue
     * but the tasks are not dispatched.
     * To permanently delete this queue and all of its tasks, call
     * [DeleteQueue][google.cloud.tasks.v2.CloudTasks.DeleteQueue].
     * </pre>
     *
     * <code>DISABLED = 3;</code>
     */
    DISABLED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The queue is running. Tasks can be dispatched.
     * If the queue was created using Cloud Tasks and the queue has
     * had no activity (method calls or task dispatches) for 30 days,
     * the queue may take a few minutes to re-activate. Some method
     * calls may return [NOT_FOUND][google.rpc.Code.NOT_FOUND] and
     * tasks may not be dispatched for a few minutes until the queue
     * has been re-activated.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    public static final int RUNNING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Tasks are paused by the user. If the queue is paused then Cloud
     * Tasks will stop delivering tasks from it, but more tasks can
     * still be added to it by the user.
     * </pre>
     *
     * <code>PAUSED = 2;</code>
     */
    public static final int PAUSED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The queue is disabled.
     * A queue becomes `DISABLED` when
     * [queue.yaml](https://cloud.google.com/appengine/docs/python/config/queueref)
     * or
     * [queue.xml](https://cloud.google.com/appengine/docs/standard/java/config/queueref)
     * is uploaded which does not contain the queue. You cannot directly disable
     * a queue.
     * When a queue is disabled, tasks can still be added to a queue
     * but the tasks are not dispatched.
     * To permanently delete this queue and all of its tasks, call
     * [DeleteQueue][google.cloud.tasks.v2.CloudTasks.DeleteQueue].
     * </pre>
     *
     * <code>DISABLED = 3;</code>
     */
    public static final int DISABLED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return RUNNING;
        case 2:
          return PAUSED;
        case 3:
          return DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.tasks.v2.Queue.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.tasks.v2.Queue.State)
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Caller-specified and required in [CreateQueue][google.cloud.tasks.v2.CloudTasks.CreateQueue],
   * after which it becomes output only.
   * The queue name.
   * The queue name must have the following format:
   * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
   * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
   *    hyphens (-), colons (:), or periods (.).
   *    For more information, see
   *    [Identifying
   *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
   * * `LOCATION_ID` is the canonical ID for the queue's location.
   *    The list of available locations can be obtained by calling
   *    [ListLocations][google.cloud.location.Locations.ListLocations].
   *    For more information, see https://cloud.google.com/about/locations/.
   * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
   *   hyphens (-). The maximum length is 100 characters.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Caller-specified and required in [CreateQueue][google.cloud.tasks.v2.CloudTasks.CreateQueue],
   * after which it becomes output only.
   * The queue name.
   * The queue name must have the following format:
   * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
   * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
   *    hyphens (-), colons (:), or periods (.).
   *    For more information, see
   *    [Identifying
   *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
   * * `LOCATION_ID` is the canonical ID for the queue's location.
   *    The list of available locations can be obtained by calling
   *    [ListLocations][google.cloud.location.Locations.ListLocations].
   *    For more information, see https://cloud.google.com/about/locations/.
   * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
   *   hyphens (-). The maximum length is 100 characters.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APP_ENGINE_ROUTING_OVERRIDE_FIELD_NUMBER = 2;
  private com.google.cloud.tasks.v2.AppEngineRouting appEngineRoutingOverride_;
  /**
   *
   *
   * <pre>
   * Overrides for
   * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
   * These settings apply only to
   * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in this queue.
   * [Http tasks][google.cloud.tasks.v2.HttpRequest] are not affected.
   * If set, `app_engine_routing_override` is used for all
   * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in the queue, no matter what the
   * setting is for the
   * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
   * </pre>
   *
   * <code>.google.cloud.tasks.v2.AppEngineRouting app_engine_routing_override = 2;</code>
   *
   * @return Whether the appEngineRoutingOverride field is set.
   */
  @java.lang.Override
  public boolean hasAppEngineRoutingOverride() {
    return appEngineRoutingOverride_ != null;
  }
  /**
   *
   *
   * <pre>
   * Overrides for
   * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
   * These settings apply only to
   * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in this queue.
   * [Http tasks][google.cloud.tasks.v2.HttpRequest] are not affected.
   * If set, `app_engine_routing_override` is used for all
   * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in the queue, no matter what the
   * setting is for the
   * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
   * </pre>
   *
   * <code>.google.cloud.tasks.v2.AppEngineRouting app_engine_routing_override = 2;</code>
   *
   * @return The appEngineRoutingOverride.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2.AppEngineRouting getAppEngineRoutingOverride() {
    return appEngineRoutingOverride_ == null
        ? com.google.cloud.tasks.v2.AppEngineRouting.getDefaultInstance()
        : appEngineRoutingOverride_;
  }
  /**
   *
   *
   * <pre>
   * Overrides for
   * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
   * These settings apply only to
   * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in this queue.
   * [Http tasks][google.cloud.tasks.v2.HttpRequest] are not affected.
   * If set, `app_engine_routing_override` is used for all
   * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in the queue, no matter what the
   * setting is for the
   * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
   * </pre>
   *
   * <code>.google.cloud.tasks.v2.AppEngineRouting app_engine_routing_override = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2.AppEngineRoutingOrBuilder
      getAppEngineRoutingOverrideOrBuilder() {
    return appEngineRoutingOverride_ == null
        ? com.google.cloud.tasks.v2.AppEngineRouting.getDefaultInstance()
        : appEngineRoutingOverride_;
  }

  public static final int RATE_LIMITS_FIELD_NUMBER = 3;
  private com.google.cloud.tasks.v2.RateLimits rateLimits_;
  /**
   *
   *
   * <pre>
   * Rate limits for task dispatches.
   * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2.Queue.retry_config] are
   * related because they both control task attempts. However they control task
   * attempts in different ways:
   * * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] controls the total rate of
   *   dispatches from a queue (i.e. all traffic dispatched from the
   *   queue, regardless of whether the dispatch is from a first
   *   attempt or a retry).
   * * [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls what happens to
   *   particular a task after its first attempt fails. That is,
   *   [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls task retries (the
   *   second attempt, third attempt, etc).
   * The queue's actual dispatch rate is the result of:
   * * Number of tasks in the queue
   * * User-specified throttling: [rate_limits][google.cloud.tasks.v2.Queue.rate_limits],
   *   [retry_config][google.cloud.tasks.v2.Queue.retry_config], and the
   *   [queue's state][google.cloud.tasks.v2.Queue.state].
   * * System throttling due to `429` (Too Many Requests) or `503` (Service
   *   Unavailable) responses from the worker, high error rates, or to smooth
   *   sudden large traffic spikes.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2.RateLimits rate_limits = 3;</code>
   *
   * @return Whether the rateLimits field is set.
   */
  @java.lang.Override
  public boolean hasRateLimits() {
    return rateLimits_ != null;
  }
  /**
   *
   *
   * <pre>
   * Rate limits for task dispatches.
   * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2.Queue.retry_config] are
   * related because they both control task attempts. However they control task
   * attempts in different ways:
   * * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] controls the total rate of
   *   dispatches from a queue (i.e. all traffic dispatched from the
   *   queue, regardless of whether the dispatch is from a first
   *   attempt or a retry).
   * * [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls what happens to
   *   particular a task after its first attempt fails. That is,
   *   [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls task retries (the
   *   second attempt, third attempt, etc).
   * The queue's actual dispatch rate is the result of:
   * * Number of tasks in the queue
   * * User-specified throttling: [rate_limits][google.cloud.tasks.v2.Queue.rate_limits],
   *   [retry_config][google.cloud.tasks.v2.Queue.retry_config], and the
   *   [queue's state][google.cloud.tasks.v2.Queue.state].
   * * System throttling due to `429` (Too Many Requests) or `503` (Service
   *   Unavailable) responses from the worker, high error rates, or to smooth
   *   sudden large traffic spikes.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2.RateLimits rate_limits = 3;</code>
   *
   * @return The rateLimits.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2.RateLimits getRateLimits() {
    return rateLimits_ == null
        ? com.google.cloud.tasks.v2.RateLimits.getDefaultInstance()
        : rateLimits_;
  }
  /**
   *
   *
   * <pre>
   * Rate limits for task dispatches.
   * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2.Queue.retry_config] are
   * related because they both control task attempts. However they control task
   * attempts in different ways:
   * * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] controls the total rate of
   *   dispatches from a queue (i.e. all traffic dispatched from the
   *   queue, regardless of whether the dispatch is from a first
   *   attempt or a retry).
   * * [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls what happens to
   *   particular a task after its first attempt fails. That is,
   *   [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls task retries (the
   *   second attempt, third attempt, etc).
   * The queue's actual dispatch rate is the result of:
   * * Number of tasks in the queue
   * * User-specified throttling: [rate_limits][google.cloud.tasks.v2.Queue.rate_limits],
   *   [retry_config][google.cloud.tasks.v2.Queue.retry_config], and the
   *   [queue's state][google.cloud.tasks.v2.Queue.state].
   * * System throttling due to `429` (Too Many Requests) or `503` (Service
   *   Unavailable) responses from the worker, high error rates, or to smooth
   *   sudden large traffic spikes.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2.RateLimits rate_limits = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2.RateLimitsOrBuilder getRateLimitsOrBuilder() {
    return rateLimits_ == null
        ? com.google.cloud.tasks.v2.RateLimits.getDefaultInstance()
        : rateLimits_;
  }

  public static final int RETRY_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.tasks.v2.RetryConfig retryConfig_;
  /**
   *
   *
   * <pre>
   * Settings that determine the retry behavior.
   * * For tasks created using Cloud Tasks: the queue-level retry settings
   *   apply to all tasks in the queue that were created using Cloud Tasks.
   *   Retry settings cannot be set on individual tasks.
   * * For tasks created using the App Engine SDK: the queue-level retry
   *   settings apply to all tasks in the queue which do not have retry settings
   *   explicitly set on the task and were created by the App Engine SDK. See
   *   [App Engine
   *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
   * </pre>
   *
   * <code>.google.cloud.tasks.v2.RetryConfig retry_config = 4;</code>
   *
   * @return Whether the retryConfig field is set.
   */
  @java.lang.Override
  public boolean hasRetryConfig() {
    return retryConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Settings that determine the retry behavior.
   * * For tasks created using Cloud Tasks: the queue-level retry settings
   *   apply to all tasks in the queue that were created using Cloud Tasks.
   *   Retry settings cannot be set on individual tasks.
   * * For tasks created using the App Engine SDK: the queue-level retry
   *   settings apply to all tasks in the queue which do not have retry settings
   *   explicitly set on the task and were created by the App Engine SDK. See
   *   [App Engine
   *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
   * </pre>
   *
   * <code>.google.cloud.tasks.v2.RetryConfig retry_config = 4;</code>
   *
   * @return The retryConfig.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2.RetryConfig getRetryConfig() {
    return retryConfig_ == null
        ? com.google.cloud.tasks.v2.RetryConfig.getDefaultInstance()
        : retryConfig_;
  }
  /**
   *
   *
   * <pre>
   * Settings that determine the retry behavior.
   * * For tasks created using Cloud Tasks: the queue-level retry settings
   *   apply to all tasks in the queue that were created using Cloud Tasks.
   *   Retry settings cannot be set on individual tasks.
   * * For tasks created using the App Engine SDK: the queue-level retry
   *   settings apply to all tasks in the queue which do not have retry settings
   *   explicitly set on the task and were created by the App Engine SDK. See
   *   [App Engine
   *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
   * </pre>
   *
   * <code>.google.cloud.tasks.v2.RetryConfig retry_config = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2.RetryConfigOrBuilder getRetryConfigOrBuilder() {
    return retryConfig_ == null
        ? com.google.cloud.tasks.v2.RetryConfig.getDefaultInstance()
        : retryConfig_;
  }

  public static final int STATE_FIELD_NUMBER = 5;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The state of the queue.
   * `state` can only be changed by called
   * [PauseQueue][google.cloud.tasks.v2.CloudTasks.PauseQueue],
   * [ResumeQueue][google.cloud.tasks.v2.CloudTasks.ResumeQueue], or uploading
   * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
   * [UpdateQueue][google.cloud.tasks.v2.CloudTasks.UpdateQueue] cannot be used to change `state`.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2.Queue.State state = 5;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The state of the queue.
   * `state` can only be changed by called
   * [PauseQueue][google.cloud.tasks.v2.CloudTasks.PauseQueue],
   * [ResumeQueue][google.cloud.tasks.v2.CloudTasks.ResumeQueue], or uploading
   * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
   * [UpdateQueue][google.cloud.tasks.v2.CloudTasks.UpdateQueue] cannot be used to change `state`.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2.Queue.State state = 5;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2.Queue.State getState() {
    com.google.cloud.tasks.v2.Queue.State result =
        com.google.cloud.tasks.v2.Queue.State.forNumber(state_);
    return result == null ? com.google.cloud.tasks.v2.Queue.State.UNRECOGNIZED : result;
  }

  public static final int PURGE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp purgeTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last time this queue was purged.
   * All tasks that were [created][google.cloud.tasks.v2.Task.create_time] before this time
   * were purged.
   * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2.CloudTasks.PurgeQueue], the
   * [App Engine Task Queue SDK, or the Cloud
   * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
   * Purge time will be truncated to the nearest microsecond. Purge
   * time will be unset if the queue has never been purged.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp purge_time = 6;</code>
   *
   * @return Whether the purgeTime field is set.
   */
  @java.lang.Override
  public boolean hasPurgeTime() {
    return purgeTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last time this queue was purged.
   * All tasks that were [created][google.cloud.tasks.v2.Task.create_time] before this time
   * were purged.
   * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2.CloudTasks.PurgeQueue], the
   * [App Engine Task Queue SDK, or the Cloud
   * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
   * Purge time will be truncated to the nearest microsecond. Purge
   * time will be unset if the queue has never been purged.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp purge_time = 6;</code>
   *
   * @return The purgeTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getPurgeTime() {
    return purgeTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : purgeTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last time this queue was purged.
   * All tasks that were [created][google.cloud.tasks.v2.Task.create_time] before this time
   * were purged.
   * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2.CloudTasks.PurgeQueue], the
   * [App Engine Task Queue SDK, or the Cloud
   * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
   * Purge time will be truncated to the nearest microsecond. Purge
   * time will be unset if the queue has never been purged.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp purge_time = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getPurgeTimeOrBuilder() {
    return purgeTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : purgeTime_;
  }

  public static final int STACKDRIVER_LOGGING_CONFIG_FIELD_NUMBER = 9;
  private com.google.cloud.tasks.v2.StackdriverLoggingConfig stackdriverLoggingConfig_;
  /**
   *
   *
   * <pre>
   * Configuration options for writing logs to
   * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
   * field is unset, then no logs are written.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2.StackdriverLoggingConfig stackdriver_logging_config = 9;</code>
   *
   * @return Whether the stackdriverLoggingConfig field is set.
   */
  @java.lang.Override
  public boolean hasStackdriverLoggingConfig() {
    return stackdriverLoggingConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Configuration options for writing logs to
   * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
   * field is unset, then no logs are written.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2.StackdriverLoggingConfig stackdriver_logging_config = 9;</code>
   *
   * @return The stackdriverLoggingConfig.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2.StackdriverLoggingConfig getStackdriverLoggingConfig() {
    return stackdriverLoggingConfig_ == null
        ? com.google.cloud.tasks.v2.StackdriverLoggingConfig.getDefaultInstance()
        : stackdriverLoggingConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration options for writing logs to
   * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
   * field is unset, then no logs are written.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2.StackdriverLoggingConfig stackdriver_logging_config = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2.StackdriverLoggingConfigOrBuilder
      getStackdriverLoggingConfigOrBuilder() {
    return stackdriverLoggingConfig_ == null
        ? com.google.cloud.tasks.v2.StackdriverLoggingConfig.getDefaultInstance()
        : stackdriverLoggingConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (appEngineRoutingOverride_ != null) {
      output.writeMessage(2, getAppEngineRoutingOverride());
    }
    if (rateLimits_ != null) {
      output.writeMessage(3, getRateLimits());
    }
    if (retryConfig_ != null) {
      output.writeMessage(4, getRetryConfig());
    }
    if (state_ != com.google.cloud.tasks.v2.Queue.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(5, state_);
    }
    if (purgeTime_ != null) {
      output.writeMessage(6, getPurgeTime());
    }
    if (stackdriverLoggingConfig_ != null) {
      output.writeMessage(9, getStackdriverLoggingConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (appEngineRoutingOverride_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, getAppEngineRoutingOverride());
    }
    if (rateLimits_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getRateLimits());
    }
    if (retryConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getRetryConfig());
    }
    if (state_ != com.google.cloud.tasks.v2.Queue.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, state_);
    }
    if (purgeTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getPurgeTime());
    }
    if (stackdriverLoggingConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, getStackdriverLoggingConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.tasks.v2.Queue)) {
      return super.equals(obj);
    }
    com.google.cloud.tasks.v2.Queue other = (com.google.cloud.tasks.v2.Queue) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasAppEngineRoutingOverride() != other.hasAppEngineRoutingOverride()) return false;
    if (hasAppEngineRoutingOverride()) {
      if (!getAppEngineRoutingOverride().equals(other.getAppEngineRoutingOverride())) return false;
    }
    if (hasRateLimits() != other.hasRateLimits()) return false;
    if (hasRateLimits()) {
      if (!getRateLimits().equals(other.getRateLimits())) return false;
    }
    if (hasRetryConfig() != other.hasRetryConfig()) return false;
    if (hasRetryConfig()) {
      if (!getRetryConfig().equals(other.getRetryConfig())) return false;
    }
    if (state_ != other.state_) return false;
    if (hasPurgeTime() != other.hasPurgeTime()) return false;
    if (hasPurgeTime()) {
      if (!getPurgeTime().equals(other.getPurgeTime())) return false;
    }
    if (hasStackdriverLoggingConfig() != other.hasStackdriverLoggingConfig()) return false;
    if (hasStackdriverLoggingConfig()) {
      if (!getStackdriverLoggingConfig().equals(other.getStackdriverLoggingConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasAppEngineRoutingOverride()) {
      hash = (37 * hash) + APP_ENGINE_ROUTING_OVERRIDE_FIELD_NUMBER;
      hash = (53 * hash) + getAppEngineRoutingOverride().hashCode();
    }
    if (hasRateLimits()) {
      hash = (37 * hash) + RATE_LIMITS_FIELD_NUMBER;
      hash = (53 * hash) + getRateLimits().hashCode();
    }
    if (hasRetryConfig()) {
      hash = (37 * hash) + RETRY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRetryConfig().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasPurgeTime()) {
      hash = (37 * hash) + PURGE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getPurgeTime().hashCode();
    }
    if (hasStackdriverLoggingConfig()) {
      hash = (37 * hash) + STACKDRIVER_LOGGING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getStackdriverLoggingConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.tasks.v2.Queue parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2.Queue parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2.Queue parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2.Queue parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2.Queue parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2.Queue parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2.Queue parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2.Queue parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2.Queue parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2.Queue parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2.Queue parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2.Queue parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.tasks.v2.Queue prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A queue is a container of related tasks. Queues are configured to manage
   * how those tasks are dispatched. Configurable properties include rate limits,
   * retry options, queue types, and others.
   * </pre>
   *
   * Protobuf type {@code google.cloud.tasks.v2.Queue}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.tasks.v2.Queue)
      com.google.cloud.tasks.v2.QueueOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.tasks.v2.QueueProto
          .internal_static_google_cloud_tasks_v2_Queue_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.tasks.v2.QueueProto
          .internal_static_google_cloud_tasks_v2_Queue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.tasks.v2.Queue.class, com.google.cloud.tasks.v2.Queue.Builder.class);
    }

    // Construct using com.google.cloud.tasks.v2.Queue.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      appEngineRoutingOverride_ = null;
      if (appEngineRoutingOverrideBuilder_ != null) {
        appEngineRoutingOverrideBuilder_.dispose();
        appEngineRoutingOverrideBuilder_ = null;
      }
      rateLimits_ = null;
      if (rateLimitsBuilder_ != null) {
        rateLimitsBuilder_.dispose();
        rateLimitsBuilder_ = null;
      }
      retryConfig_ = null;
      if (retryConfigBuilder_ != null) {
        retryConfigBuilder_.dispose();
        retryConfigBuilder_ = null;
      }
      state_ = 0;
      purgeTime_ = null;
      if (purgeTimeBuilder_ != null) {
        purgeTimeBuilder_.dispose();
        purgeTimeBuilder_ = null;
      }
      stackdriverLoggingConfig_ = null;
      if (stackdriverLoggingConfigBuilder_ != null) {
        stackdriverLoggingConfigBuilder_.dispose();
        stackdriverLoggingConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.tasks.v2.QueueProto
          .internal_static_google_cloud_tasks_v2_Queue_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2.Queue getDefaultInstanceForType() {
      return com.google.cloud.tasks.v2.Queue.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2.Queue build() {
      com.google.cloud.tasks.v2.Queue result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2.Queue buildPartial() {
      com.google.cloud.tasks.v2.Queue result = new com.google.cloud.tasks.v2.Queue(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.tasks.v2.Queue result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.appEngineRoutingOverride_ =
            appEngineRoutingOverrideBuilder_ == null
                ? appEngineRoutingOverride_
                : appEngineRoutingOverrideBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.rateLimits_ = rateLimitsBuilder_ == null ? rateLimits_ : rateLimitsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.retryConfig_ =
            retryConfigBuilder_ == null ? retryConfig_ : retryConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.purgeTime_ = purgeTimeBuilder_ == null ? purgeTime_ : purgeTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.stackdriverLoggingConfig_ =
            stackdriverLoggingConfigBuilder_ == null
                ? stackdriverLoggingConfig_
                : stackdriverLoggingConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.tasks.v2.Queue) {
        return mergeFrom((com.google.cloud.tasks.v2.Queue) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.tasks.v2.Queue other) {
      if (other == com.google.cloud.tasks.v2.Queue.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasAppEngineRoutingOverride()) {
        mergeAppEngineRoutingOverride(other.getAppEngineRoutingOverride());
      }
      if (other.hasRateLimits()) {
        mergeRateLimits(other.getRateLimits());
      }
      if (other.hasRetryConfig()) {
        mergeRetryConfig(other.getRetryConfig());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasPurgeTime()) {
        mergePurgeTime(other.getPurgeTime());
      }
      if (other.hasStackdriverLoggingConfig()) {
        mergeStackdriverLoggingConfig(other.getStackdriverLoggingConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getAppEngineRoutingOverrideFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getRateLimitsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getRetryConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 40:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getPurgeTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 74:
              {
                input.readMessage(
                    getStackdriverLoggingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 74
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Caller-specified and required in [CreateQueue][google.cloud.tasks.v2.CloudTasks.CreateQueue],
     * after which it becomes output only.
     * The queue name.
     * The queue name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the queue's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Caller-specified and required in [CreateQueue][google.cloud.tasks.v2.CloudTasks.CreateQueue],
     * after which it becomes output only.
     * The queue name.
     * The queue name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the queue's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Caller-specified and required in [CreateQueue][google.cloud.tasks.v2.CloudTasks.CreateQueue],
     * after which it becomes output only.
     * The queue name.
     * The queue name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the queue's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Caller-specified and required in [CreateQueue][google.cloud.tasks.v2.CloudTasks.CreateQueue],
     * after which it becomes output only.
     * The queue name.
     * The queue name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the queue's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Caller-specified and required in [CreateQueue][google.cloud.tasks.v2.CloudTasks.CreateQueue],
     * after which it becomes output only.
     * The queue name.
     * The queue name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the queue's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.tasks.v2.AppEngineRouting appEngineRoutingOverride_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2.AppEngineRouting,
            com.google.cloud.tasks.v2.AppEngineRouting.Builder,
            com.google.cloud.tasks.v2.AppEngineRoutingOrBuilder>
        appEngineRoutingOverrideBuilder_;
    /**
     *
     *
     * <pre>
     * Overrides for
     * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
     * These settings apply only to
     * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in this queue.
     * [Http tasks][google.cloud.tasks.v2.HttpRequest] are not affected.
     * If set, `app_engine_routing_override` is used for all
     * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in the queue, no matter what the
     * setting is for the
     * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.AppEngineRouting app_engine_routing_override = 2;</code>
     *
     * @return Whether the appEngineRoutingOverride field is set.
     */
    public boolean hasAppEngineRoutingOverride() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Overrides for
     * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
     * These settings apply only to
     * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in this queue.
     * [Http tasks][google.cloud.tasks.v2.HttpRequest] are not affected.
     * If set, `app_engine_routing_override` is used for all
     * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in the queue, no matter what the
     * setting is for the
     * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.AppEngineRouting app_engine_routing_override = 2;</code>
     *
     * @return The appEngineRoutingOverride.
     */
    public com.google.cloud.tasks.v2.AppEngineRouting getAppEngineRoutingOverride() {
      if (appEngineRoutingOverrideBuilder_ == null) {
        return appEngineRoutingOverride_ == null
            ? com.google.cloud.tasks.v2.AppEngineRouting.getDefaultInstance()
            : appEngineRoutingOverride_;
      } else {
        return appEngineRoutingOverrideBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Overrides for
     * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
     * These settings apply only to
     * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in this queue.
     * [Http tasks][google.cloud.tasks.v2.HttpRequest] are not affected.
     * If set, `app_engine_routing_override` is used for all
     * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in the queue, no matter what the
     * setting is for the
     * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.AppEngineRouting app_engine_routing_override = 2;</code>
     */
    public Builder setAppEngineRoutingOverride(com.google.cloud.tasks.v2.AppEngineRouting value) {
      if (appEngineRoutingOverrideBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        appEngineRoutingOverride_ = value;
      } else {
        appEngineRoutingOverrideBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Overrides for
     * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
     * These settings apply only to
     * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in this queue.
     * [Http tasks][google.cloud.tasks.v2.HttpRequest] are not affected.
     * If set, `app_engine_routing_override` is used for all
     * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in the queue, no matter what the
     * setting is for the
     * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.AppEngineRouting app_engine_routing_override = 2;</code>
     */
    public Builder setAppEngineRoutingOverride(
        com.google.cloud.tasks.v2.AppEngineRouting.Builder builderForValue) {
      if (appEngineRoutingOverrideBuilder_ == null) {
        appEngineRoutingOverride_ = builderForValue.build();
      } else {
        appEngineRoutingOverrideBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Overrides for
     * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
     * These settings apply only to
     * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in this queue.
     * [Http tasks][google.cloud.tasks.v2.HttpRequest] are not affected.
     * If set, `app_engine_routing_override` is used for all
     * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in the queue, no matter what the
     * setting is for the
     * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.AppEngineRouting app_engine_routing_override = 2;</code>
     */
    public Builder mergeAppEngineRoutingOverride(com.google.cloud.tasks.v2.AppEngineRouting value) {
      if (appEngineRoutingOverrideBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && appEngineRoutingOverride_ != null
            && appEngineRoutingOverride_
                != com.google.cloud.tasks.v2.AppEngineRouting.getDefaultInstance()) {
          getAppEngineRoutingOverrideBuilder().mergeFrom(value);
        } else {
          appEngineRoutingOverride_ = value;
        }
      } else {
        appEngineRoutingOverrideBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Overrides for
     * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
     * These settings apply only to
     * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in this queue.
     * [Http tasks][google.cloud.tasks.v2.HttpRequest] are not affected.
     * If set, `app_engine_routing_override` is used for all
     * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in the queue, no matter what the
     * setting is for the
     * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.AppEngineRouting app_engine_routing_override = 2;</code>
     */
    public Builder clearAppEngineRoutingOverride() {
      bitField0_ = (bitField0_ & ~0x00000002);
      appEngineRoutingOverride_ = null;
      if (appEngineRoutingOverrideBuilder_ != null) {
        appEngineRoutingOverrideBuilder_.dispose();
        appEngineRoutingOverrideBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Overrides for
     * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
     * These settings apply only to
     * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in this queue.
     * [Http tasks][google.cloud.tasks.v2.HttpRequest] are not affected.
     * If set, `app_engine_routing_override` is used for all
     * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in the queue, no matter what the
     * setting is for the
     * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.AppEngineRouting app_engine_routing_override = 2;</code>
     */
    public com.google.cloud.tasks.v2.AppEngineRouting.Builder getAppEngineRoutingOverrideBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getAppEngineRoutingOverrideFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Overrides for
     * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
     * These settings apply only to
     * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in this queue.
     * [Http tasks][google.cloud.tasks.v2.HttpRequest] are not affected.
     * If set, `app_engine_routing_override` is used for all
     * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in the queue, no matter what the
     * setting is for the
     * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.AppEngineRouting app_engine_routing_override = 2;</code>
     */
    public com.google.cloud.tasks.v2.AppEngineRoutingOrBuilder
        getAppEngineRoutingOverrideOrBuilder() {
      if (appEngineRoutingOverrideBuilder_ != null) {
        return appEngineRoutingOverrideBuilder_.getMessageOrBuilder();
      } else {
        return appEngineRoutingOverride_ == null
            ? com.google.cloud.tasks.v2.AppEngineRouting.getDefaultInstance()
            : appEngineRoutingOverride_;
      }
    }
    /**
     *
     *
     * <pre>
     * Overrides for
     * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
     * These settings apply only to
     * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in this queue.
     * [Http tasks][google.cloud.tasks.v2.HttpRequest] are not affected.
     * If set, `app_engine_routing_override` is used for all
     * [App Engine tasks][google.cloud.tasks.v2.AppEngineHttpRequest] in the queue, no matter what the
     * setting is for the
     * [task-level app_engine_routing][google.cloud.tasks.v2.AppEngineHttpRequest.app_engine_routing].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.AppEngineRouting app_engine_routing_override = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2.AppEngineRouting,
            com.google.cloud.tasks.v2.AppEngineRouting.Builder,
            com.google.cloud.tasks.v2.AppEngineRoutingOrBuilder>
        getAppEngineRoutingOverrideFieldBuilder() {
      if (appEngineRoutingOverrideBuilder_ == null) {
        appEngineRoutingOverrideBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2.AppEngineRouting,
                com.google.cloud.tasks.v2.AppEngineRouting.Builder,
                com.google.cloud.tasks.v2.AppEngineRoutingOrBuilder>(
                getAppEngineRoutingOverride(), getParentForChildren(), isClean());
        appEngineRoutingOverride_ = null;
      }
      return appEngineRoutingOverrideBuilder_;
    }

    private com.google.cloud.tasks.v2.RateLimits rateLimits_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2.RateLimits,
            com.google.cloud.tasks.v2.RateLimits.Builder,
            com.google.cloud.tasks.v2.RateLimitsOrBuilder>
        rateLimitsBuilder_;
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2.Queue.retry_config] are
     * related because they both control task attempts. However they control task
     * attempts in different ways:
     * * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] controls the total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls task retries (the
     *   second attempt, third attempt, etc).
     * The queue's actual dispatch rate is the result of:
     * * Number of tasks in the queue
     * * User-specified throttling: [rate_limits][google.cloud.tasks.v2.Queue.rate_limits],
     *   [retry_config][google.cloud.tasks.v2.Queue.retry_config], and the
     *   [queue's state][google.cloud.tasks.v2.Queue.state].
     * * System throttling due to `429` (Too Many Requests) or `503` (Service
     *   Unavailable) responses from the worker, high error rates, or to smooth
     *   sudden large traffic spikes.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.RateLimits rate_limits = 3;</code>
     *
     * @return Whether the rateLimits field is set.
     */
    public boolean hasRateLimits() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2.Queue.retry_config] are
     * related because they both control task attempts. However they control task
     * attempts in different ways:
     * * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] controls the total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls task retries (the
     *   second attempt, third attempt, etc).
     * The queue's actual dispatch rate is the result of:
     * * Number of tasks in the queue
     * * User-specified throttling: [rate_limits][google.cloud.tasks.v2.Queue.rate_limits],
     *   [retry_config][google.cloud.tasks.v2.Queue.retry_config], and the
     *   [queue's state][google.cloud.tasks.v2.Queue.state].
     * * System throttling due to `429` (Too Many Requests) or `503` (Service
     *   Unavailable) responses from the worker, high error rates, or to smooth
     *   sudden large traffic spikes.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.RateLimits rate_limits = 3;</code>
     *
     * @return The rateLimits.
     */
    public com.google.cloud.tasks.v2.RateLimits getRateLimits() {
      if (rateLimitsBuilder_ == null) {
        return rateLimits_ == null
            ? com.google.cloud.tasks.v2.RateLimits.getDefaultInstance()
            : rateLimits_;
      } else {
        return rateLimitsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2.Queue.retry_config] are
     * related because they both control task attempts. However they control task
     * attempts in different ways:
     * * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] controls the total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls task retries (the
     *   second attempt, third attempt, etc).
     * The queue's actual dispatch rate is the result of:
     * * Number of tasks in the queue
     * * User-specified throttling: [rate_limits][google.cloud.tasks.v2.Queue.rate_limits],
     *   [retry_config][google.cloud.tasks.v2.Queue.retry_config], and the
     *   [queue's state][google.cloud.tasks.v2.Queue.state].
     * * System throttling due to `429` (Too Many Requests) or `503` (Service
     *   Unavailable) responses from the worker, high error rates, or to smooth
     *   sudden large traffic spikes.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.RateLimits rate_limits = 3;</code>
     */
    public Builder setRateLimits(com.google.cloud.tasks.v2.RateLimits value) {
      if (rateLimitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rateLimits_ = value;
      } else {
        rateLimitsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2.Queue.retry_config] are
     * related because they both control task attempts. However they control task
     * attempts in different ways:
     * * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] controls the total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls task retries (the
     *   second attempt, third attempt, etc).
     * The queue's actual dispatch rate is the result of:
     * * Number of tasks in the queue
     * * User-specified throttling: [rate_limits][google.cloud.tasks.v2.Queue.rate_limits],
     *   [retry_config][google.cloud.tasks.v2.Queue.retry_config], and the
     *   [queue's state][google.cloud.tasks.v2.Queue.state].
     * * System throttling due to `429` (Too Many Requests) or `503` (Service
     *   Unavailable) responses from the worker, high error rates, or to smooth
     *   sudden large traffic spikes.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.RateLimits rate_limits = 3;</code>
     */
    public Builder setRateLimits(com.google.cloud.tasks.v2.RateLimits.Builder builderForValue) {
      if (rateLimitsBuilder_ == null) {
        rateLimits_ = builderForValue.build();
      } else {
        rateLimitsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2.Queue.retry_config] are
     * related because they both control task attempts. However they control task
     * attempts in different ways:
     * * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] controls the total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls task retries (the
     *   second attempt, third attempt, etc).
     * The queue's actual dispatch rate is the result of:
     * * Number of tasks in the queue
     * * User-specified throttling: [rate_limits][google.cloud.tasks.v2.Queue.rate_limits],
     *   [retry_config][google.cloud.tasks.v2.Queue.retry_config], and the
     *   [queue's state][google.cloud.tasks.v2.Queue.state].
     * * System throttling due to `429` (Too Many Requests) or `503` (Service
     *   Unavailable) responses from the worker, high error rates, or to smooth
     *   sudden large traffic spikes.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.RateLimits rate_limits = 3;</code>
     */
    public Builder mergeRateLimits(com.google.cloud.tasks.v2.RateLimits value) {
      if (rateLimitsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && rateLimits_ != null
            && rateLimits_ != com.google.cloud.tasks.v2.RateLimits.getDefaultInstance()) {
          getRateLimitsBuilder().mergeFrom(value);
        } else {
          rateLimits_ = value;
        }
      } else {
        rateLimitsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2.Queue.retry_config] are
     * related because they both control task attempts. However they control task
     * attempts in different ways:
     * * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] controls the total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls task retries (the
     *   second attempt, third attempt, etc).
     * The queue's actual dispatch rate is the result of:
     * * Number of tasks in the queue
     * * User-specified throttling: [rate_limits][google.cloud.tasks.v2.Queue.rate_limits],
     *   [retry_config][google.cloud.tasks.v2.Queue.retry_config], and the
     *   [queue's state][google.cloud.tasks.v2.Queue.state].
     * * System throttling due to `429` (Too Many Requests) or `503` (Service
     *   Unavailable) responses from the worker, high error rates, or to smooth
     *   sudden large traffic spikes.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.RateLimits rate_limits = 3;</code>
     */
    public Builder clearRateLimits() {
      bitField0_ = (bitField0_ & ~0x00000004);
      rateLimits_ = null;
      if (rateLimitsBuilder_ != null) {
        rateLimitsBuilder_.dispose();
        rateLimitsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2.Queue.retry_config] are
     * related because they both control task attempts. However they control task
     * attempts in different ways:
     * * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] controls the total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls task retries (the
     *   second attempt, third attempt, etc).
     * The queue's actual dispatch rate is the result of:
     * * Number of tasks in the queue
     * * User-specified throttling: [rate_limits][google.cloud.tasks.v2.Queue.rate_limits],
     *   [retry_config][google.cloud.tasks.v2.Queue.retry_config], and the
     *   [queue's state][google.cloud.tasks.v2.Queue.state].
     * * System throttling due to `429` (Too Many Requests) or `503` (Service
     *   Unavailable) responses from the worker, high error rates, or to smooth
     *   sudden large traffic spikes.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.RateLimits rate_limits = 3;</code>
     */
    public com.google.cloud.tasks.v2.RateLimits.Builder getRateLimitsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getRateLimitsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2.Queue.retry_config] are
     * related because they both control task attempts. However they control task
     * attempts in different ways:
     * * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] controls the total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls task retries (the
     *   second attempt, third attempt, etc).
     * The queue's actual dispatch rate is the result of:
     * * Number of tasks in the queue
     * * User-specified throttling: [rate_limits][google.cloud.tasks.v2.Queue.rate_limits],
     *   [retry_config][google.cloud.tasks.v2.Queue.retry_config], and the
     *   [queue's state][google.cloud.tasks.v2.Queue.state].
     * * System throttling due to `429` (Too Many Requests) or `503` (Service
     *   Unavailable) responses from the worker, high error rates, or to smooth
     *   sudden large traffic spikes.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.RateLimits rate_limits = 3;</code>
     */
    public com.google.cloud.tasks.v2.RateLimitsOrBuilder getRateLimitsOrBuilder() {
      if (rateLimitsBuilder_ != null) {
        return rateLimitsBuilder_.getMessageOrBuilder();
      } else {
        return rateLimits_ == null
            ? com.google.cloud.tasks.v2.RateLimits.getDefaultInstance()
            : rateLimits_;
      }
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2.Queue.retry_config] are
     * related because they both control task attempts. However they control task
     * attempts in different ways:
     * * [rate_limits][google.cloud.tasks.v2.Queue.rate_limits] controls the total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2.Queue.retry_config] controls task retries (the
     *   second attempt, third attempt, etc).
     * The queue's actual dispatch rate is the result of:
     * * Number of tasks in the queue
     * * User-specified throttling: [rate_limits][google.cloud.tasks.v2.Queue.rate_limits],
     *   [retry_config][google.cloud.tasks.v2.Queue.retry_config], and the
     *   [queue's state][google.cloud.tasks.v2.Queue.state].
     * * System throttling due to `429` (Too Many Requests) or `503` (Service
     *   Unavailable) responses from the worker, high error rates, or to smooth
     *   sudden large traffic spikes.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.RateLimits rate_limits = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2.RateLimits,
            com.google.cloud.tasks.v2.RateLimits.Builder,
            com.google.cloud.tasks.v2.RateLimitsOrBuilder>
        getRateLimitsFieldBuilder() {
      if (rateLimitsBuilder_ == null) {
        rateLimitsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2.RateLimits,
                com.google.cloud.tasks.v2.RateLimits.Builder,
                com.google.cloud.tasks.v2.RateLimitsOrBuilder>(
                getRateLimits(), getParentForChildren(), isClean());
        rateLimits_ = null;
      }
      return rateLimitsBuilder_;
    }

    private com.google.cloud.tasks.v2.RetryConfig retryConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2.RetryConfig,
            com.google.cloud.tasks.v2.RetryConfig.Builder,
            com.google.cloud.tasks.v2.RetryConfigOrBuilder>
        retryConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.RetryConfig retry_config = 4;</code>
     *
     * @return Whether the retryConfig field is set.
     */
    public boolean hasRetryConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.RetryConfig retry_config = 4;</code>
     *
     * @return The retryConfig.
     */
    public com.google.cloud.tasks.v2.RetryConfig getRetryConfig() {
      if (retryConfigBuilder_ == null) {
        return retryConfig_ == null
            ? com.google.cloud.tasks.v2.RetryConfig.getDefaultInstance()
            : retryConfig_;
      } else {
        return retryConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.RetryConfig retry_config = 4;</code>
     */
    public Builder setRetryConfig(com.google.cloud.tasks.v2.RetryConfig value) {
      if (retryConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retryConfig_ = value;
      } else {
        retryConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.RetryConfig retry_config = 4;</code>
     */
    public Builder setRetryConfig(com.google.cloud.tasks.v2.RetryConfig.Builder builderForValue) {
      if (retryConfigBuilder_ == null) {
        retryConfig_ = builderForValue.build();
      } else {
        retryConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.RetryConfig retry_config = 4;</code>
     */
    public Builder mergeRetryConfig(com.google.cloud.tasks.v2.RetryConfig value) {
      if (retryConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && retryConfig_ != null
            && retryConfig_ != com.google.cloud.tasks.v2.RetryConfig.getDefaultInstance()) {
          getRetryConfigBuilder().mergeFrom(value);
        } else {
          retryConfig_ = value;
        }
      } else {
        retryConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.RetryConfig retry_config = 4;</code>
     */
    public Builder clearRetryConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      retryConfig_ = null;
      if (retryConfigBuilder_ != null) {
        retryConfigBuilder_.dispose();
        retryConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.RetryConfig retry_config = 4;</code>
     */
    public com.google.cloud.tasks.v2.RetryConfig.Builder getRetryConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getRetryConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.RetryConfig retry_config = 4;</code>
     */
    public com.google.cloud.tasks.v2.RetryConfigOrBuilder getRetryConfigOrBuilder() {
      if (retryConfigBuilder_ != null) {
        return retryConfigBuilder_.getMessageOrBuilder();
      } else {
        return retryConfig_ == null
            ? com.google.cloud.tasks.v2.RetryConfig.getDefaultInstance()
            : retryConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.RetryConfig retry_config = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2.RetryConfig,
            com.google.cloud.tasks.v2.RetryConfig.Builder,
            com.google.cloud.tasks.v2.RetryConfigOrBuilder>
        getRetryConfigFieldBuilder() {
      if (retryConfigBuilder_ == null) {
        retryConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2.RetryConfig,
                com.google.cloud.tasks.v2.RetryConfig.Builder,
                com.google.cloud.tasks.v2.RetryConfigOrBuilder>(
                getRetryConfig(), getParentForChildren(), isClean());
        retryConfig_ = null;
      }
      return retryConfigBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of the queue.
     * `state` can only be changed by called
     * [PauseQueue][google.cloud.tasks.v2.CloudTasks.PauseQueue],
     * [ResumeQueue][google.cloud.tasks.v2.CloudTasks.ResumeQueue], or uploading
     * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     * [UpdateQueue][google.cloud.tasks.v2.CloudTasks.UpdateQueue] cannot be used to change `state`.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.Queue.State state = 5;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the queue.
     * `state` can only be changed by called
     * [PauseQueue][google.cloud.tasks.v2.CloudTasks.PauseQueue],
     * [ResumeQueue][google.cloud.tasks.v2.CloudTasks.ResumeQueue], or uploading
     * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     * [UpdateQueue][google.cloud.tasks.v2.CloudTasks.UpdateQueue] cannot be used to change `state`.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.Queue.State state = 5;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the queue.
     * `state` can only be changed by called
     * [PauseQueue][google.cloud.tasks.v2.CloudTasks.PauseQueue],
     * [ResumeQueue][google.cloud.tasks.v2.CloudTasks.ResumeQueue], or uploading
     * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     * [UpdateQueue][google.cloud.tasks.v2.CloudTasks.UpdateQueue] cannot be used to change `state`.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.Queue.State state = 5;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2.Queue.State getState() {
      com.google.cloud.tasks.v2.Queue.State result =
          com.google.cloud.tasks.v2.Queue.State.forNumber(state_);
      return result == null ? com.google.cloud.tasks.v2.Queue.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the queue.
     * `state` can only be changed by called
     * [PauseQueue][google.cloud.tasks.v2.CloudTasks.PauseQueue],
     * [ResumeQueue][google.cloud.tasks.v2.CloudTasks.ResumeQueue], or uploading
     * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     * [UpdateQueue][google.cloud.tasks.v2.CloudTasks.UpdateQueue] cannot be used to change `state`.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.Queue.State state = 5;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.tasks.v2.Queue.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the queue.
     * `state` can only be changed by called
     * [PauseQueue][google.cloud.tasks.v2.CloudTasks.PauseQueue],
     * [ResumeQueue][google.cloud.tasks.v2.CloudTasks.ResumeQueue], or uploading
     * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     * [UpdateQueue][google.cloud.tasks.v2.CloudTasks.UpdateQueue] cannot be used to change `state`.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.Queue.State state = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000010);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp purgeTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        purgeTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2.Task.create_time] before this time
     * were purged.
     * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2.CloudTasks.PurgeQueue], the
     * [App Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 6;</code>
     *
     * @return Whether the purgeTime field is set.
     */
    public boolean hasPurgeTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2.Task.create_time] before this time
     * were purged.
     * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2.CloudTasks.PurgeQueue], the
     * [App Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 6;</code>
     *
     * @return The purgeTime.
     */
    public com.google.protobuf.Timestamp getPurgeTime() {
      if (purgeTimeBuilder_ == null) {
        return purgeTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : purgeTime_;
      } else {
        return purgeTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2.Task.create_time] before this time
     * were purged.
     * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2.CloudTasks.PurgeQueue], the
     * [App Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 6;</code>
     */
    public Builder setPurgeTime(com.google.protobuf.Timestamp value) {
      if (purgeTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        purgeTime_ = value;
      } else {
        purgeTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2.Task.create_time] before this time
     * were purged.
     * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2.CloudTasks.PurgeQueue], the
     * [App Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 6;</code>
     */
    public Builder setPurgeTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (purgeTimeBuilder_ == null) {
        purgeTime_ = builderForValue.build();
      } else {
        purgeTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2.Task.create_time] before this time
     * were purged.
     * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2.CloudTasks.PurgeQueue], the
     * [App Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 6;</code>
     */
    public Builder mergePurgeTime(com.google.protobuf.Timestamp value) {
      if (purgeTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && purgeTime_ != null
            && purgeTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getPurgeTimeBuilder().mergeFrom(value);
        } else {
          purgeTime_ = value;
        }
      } else {
        purgeTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2.Task.create_time] before this time
     * were purged.
     * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2.CloudTasks.PurgeQueue], the
     * [App Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 6;</code>
     */
    public Builder clearPurgeTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      purgeTime_ = null;
      if (purgeTimeBuilder_ != null) {
        purgeTimeBuilder_.dispose();
        purgeTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2.Task.create_time] before this time
     * were purged.
     * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2.CloudTasks.PurgeQueue], the
     * [App Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 6;</code>
     */
    public com.google.protobuf.Timestamp.Builder getPurgeTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getPurgeTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2.Task.create_time] before this time
     * were purged.
     * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2.CloudTasks.PurgeQueue], the
     * [App Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 6;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getPurgeTimeOrBuilder() {
      if (purgeTimeBuilder_ != null) {
        return purgeTimeBuilder_.getMessageOrBuilder();
      } else {
        return purgeTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : purgeTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2.Task.create_time] before this time
     * were purged.
     * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2.CloudTasks.PurgeQueue], the
     * [App Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getPurgeTimeFieldBuilder() {
      if (purgeTimeBuilder_ == null) {
        purgeTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getPurgeTime(), getParentForChildren(), isClean());
        purgeTime_ = null;
      }
      return purgeTimeBuilder_;
    }

    private com.google.cloud.tasks.v2.StackdriverLoggingConfig stackdriverLoggingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2.StackdriverLoggingConfig,
            com.google.cloud.tasks.v2.StackdriverLoggingConfig.Builder,
            com.google.cloud.tasks.v2.StackdriverLoggingConfigOrBuilder>
        stackdriverLoggingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration options for writing logs to
     * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
     * field is unset, then no logs are written.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.StackdriverLoggingConfig stackdriver_logging_config = 9;</code>
     *
     * @return Whether the stackdriverLoggingConfig field is set.
     */
    public boolean hasStackdriverLoggingConfig() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration options for writing logs to
     * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
     * field is unset, then no logs are written.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.StackdriverLoggingConfig stackdriver_logging_config = 9;</code>
     *
     * @return The stackdriverLoggingConfig.
     */
    public com.google.cloud.tasks.v2.StackdriverLoggingConfig getStackdriverLoggingConfig() {
      if (stackdriverLoggingConfigBuilder_ == null) {
        return stackdriverLoggingConfig_ == null
            ? com.google.cloud.tasks.v2.StackdriverLoggingConfig.getDefaultInstance()
            : stackdriverLoggingConfig_;
      } else {
        return stackdriverLoggingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration options for writing logs to
     * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
     * field is unset, then no logs are written.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.StackdriverLoggingConfig stackdriver_logging_config = 9;</code>
     */
    public Builder setStackdriverLoggingConfig(
        com.google.cloud.tasks.v2.StackdriverLoggingConfig value) {
      if (stackdriverLoggingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stackdriverLoggingConfig_ = value;
      } else {
        stackdriverLoggingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for writing logs to
     * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
     * field is unset, then no logs are written.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.StackdriverLoggingConfig stackdriver_logging_config = 9;</code>
     */
    public Builder setStackdriverLoggingConfig(
        com.google.cloud.tasks.v2.StackdriverLoggingConfig.Builder builderForValue) {
      if (stackdriverLoggingConfigBuilder_ == null) {
        stackdriverLoggingConfig_ = builderForValue.build();
      } else {
        stackdriverLoggingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for writing logs to
     * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
     * field is unset, then no logs are written.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.StackdriverLoggingConfig stackdriver_logging_config = 9;</code>
     */
    public Builder mergeStackdriverLoggingConfig(
        com.google.cloud.tasks.v2.StackdriverLoggingConfig value) {
      if (stackdriverLoggingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && stackdriverLoggingConfig_ != null
            && stackdriverLoggingConfig_
                != com.google.cloud.tasks.v2.StackdriverLoggingConfig.getDefaultInstance()) {
          getStackdriverLoggingConfigBuilder().mergeFrom(value);
        } else {
          stackdriverLoggingConfig_ = value;
        }
      } else {
        stackdriverLoggingConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for writing logs to
     * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
     * field is unset, then no logs are written.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.StackdriverLoggingConfig stackdriver_logging_config = 9;</code>
     */
    public Builder clearStackdriverLoggingConfig() {
      bitField0_ = (bitField0_ & ~0x00000040);
      stackdriverLoggingConfig_ = null;
      if (stackdriverLoggingConfigBuilder_ != null) {
        stackdriverLoggingConfigBuilder_.dispose();
        stackdriverLoggingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for writing logs to
     * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
     * field is unset, then no logs are written.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.StackdriverLoggingConfig stackdriver_logging_config = 9;</code>
     */
    public com.google.cloud.tasks.v2.StackdriverLoggingConfig.Builder
        getStackdriverLoggingConfigBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getStackdriverLoggingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration options for writing logs to
     * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
     * field is unset, then no logs are written.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.StackdriverLoggingConfig stackdriver_logging_config = 9;</code>
     */
    public com.google.cloud.tasks.v2.StackdriverLoggingConfigOrBuilder
        getStackdriverLoggingConfigOrBuilder() {
      if (stackdriverLoggingConfigBuilder_ != null) {
        return stackdriverLoggingConfigBuilder_.getMessageOrBuilder();
      } else {
        return stackdriverLoggingConfig_ == null
            ? com.google.cloud.tasks.v2.StackdriverLoggingConfig.getDefaultInstance()
            : stackdriverLoggingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration options for writing logs to
     * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
     * field is unset, then no logs are written.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.StackdriverLoggingConfig stackdriver_logging_config = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2.StackdriverLoggingConfig,
            com.google.cloud.tasks.v2.StackdriverLoggingConfig.Builder,
            com.google.cloud.tasks.v2.StackdriverLoggingConfigOrBuilder>
        getStackdriverLoggingConfigFieldBuilder() {
      if (stackdriverLoggingConfigBuilder_ == null) {
        stackdriverLoggingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2.StackdriverLoggingConfig,
                com.google.cloud.tasks.v2.StackdriverLoggingConfig.Builder,
                com.google.cloud.tasks.v2.StackdriverLoggingConfigOrBuilder>(
                getStackdriverLoggingConfig(), getParentForChildren(), isClean());
        stackdriverLoggingConfig_ = null;
      }
      return stackdriverLoggingConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.tasks.v2.Queue)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.tasks.v2.Queue)
  private static final com.google.cloud.tasks.v2.Queue DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.tasks.v2.Queue();
  }

  public static com.google.cloud.tasks.v2.Queue getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Queue> PARSER =
      new com.google.protobuf.AbstractParser<Queue>() {
        @java.lang.Override
        public Queue parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Queue> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Queue> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.tasks.v2.Queue getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
