/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/tasks/v2/cloudtasks.proto

package com.google.cloud.tasks.v2;

/**
 *
 *
 * <pre>
 * Request message for
 * [CreateTask][google.cloud.tasks.v2.CloudTasks.CreateTask].
 * </pre>
 *
 * Protobuf type {@code google.cloud.tasks.v2.CreateTaskRequest}
 */
public final class CreateTaskRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.tasks.v2.CreateTaskRequest)
    CreateTaskRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CreateTaskRequest.newBuilder() to construct.
  private CreateTaskRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CreateTaskRequest() {
    parent_ = "";
    responseView_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CreateTaskRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.tasks.v2.CloudTasksProto
        .internal_static_google_cloud_tasks_v2_CreateTaskRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.tasks.v2.CloudTasksProto
        .internal_static_google_cloud_tasks_v2_CreateTaskRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.tasks.v2.CreateTaskRequest.class,
            com.google.cloud.tasks.v2.CreateTaskRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The queue name. For example:
   * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
   *
   * The queue must already exist.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The queue name. For example:
   * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
   *
   * The queue must already exist.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TASK_FIELD_NUMBER = 2;
  private com.google.cloud.tasks.v2.Task task_;
  /**
   *
   *
   * <pre>
   * Required. The task to add.
   *
   * Task names have the following format:
   * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`.
   * The user can optionally specify a task
   * [name][google.cloud.tasks.v2.Task.name]. If a name is not specified then
   * the system will generate a random unique task id, which will be set in the
   * task returned in the [response][google.cloud.tasks.v2.Task.name].
   *
   * If [schedule_time][google.cloud.tasks.v2.Task.schedule_time] is not set or
   * is in the past then Cloud Tasks will set it to the current time.
   *
   * Task De-duplication:
   *
   * Explicitly specifying a task ID enables task de-duplication.  If
   * a task's ID is identical to that of an existing task or a task
   * that was deleted or executed recently then the call will fail
   * with [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS].
   * If the task's queue was created using Cloud Tasks, then another task with
   * the same name can't be created for ~1hour after the original task was
   * deleted or executed. If the task's queue was created using queue.yaml or
   * queue.xml, then another task with the same name can't be created
   * for ~9days after the original task was deleted or executed.
   *
   * Because there is an extra lookup cost to identify duplicate task
   * names, these [CreateTask][google.cloud.tasks.v2.CloudTasks.CreateTask]
   * calls have significantly increased latency. Using hashed strings for the
   * task id or for the prefix of the task id is recommended. Choosing task ids
   * that are sequential or have sequential prefixes, for example using a
   * timestamp, causes an increase in latency and error rates in all
   * task commands. The infrastructure relies on an approximately
   * uniform distribution of task ids to store and serve tasks
   * efficiently.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2.Task task = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the task field is set.
   */
  @java.lang.Override
  public boolean hasTask() {
    return task_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The task to add.
   *
   * Task names have the following format:
   * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`.
   * The user can optionally specify a task
   * [name][google.cloud.tasks.v2.Task.name]. If a name is not specified then
   * the system will generate a random unique task id, which will be set in the
   * task returned in the [response][google.cloud.tasks.v2.Task.name].
   *
   * If [schedule_time][google.cloud.tasks.v2.Task.schedule_time] is not set or
   * is in the past then Cloud Tasks will set it to the current time.
   *
   * Task De-duplication:
   *
   * Explicitly specifying a task ID enables task de-duplication.  If
   * a task's ID is identical to that of an existing task or a task
   * that was deleted or executed recently then the call will fail
   * with [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS].
   * If the task's queue was created using Cloud Tasks, then another task with
   * the same name can't be created for ~1hour after the original task was
   * deleted or executed. If the task's queue was created using queue.yaml or
   * queue.xml, then another task with the same name can't be created
   * for ~9days after the original task was deleted or executed.
   *
   * Because there is an extra lookup cost to identify duplicate task
   * names, these [CreateTask][google.cloud.tasks.v2.CloudTasks.CreateTask]
   * calls have significantly increased latency. Using hashed strings for the
   * task id or for the prefix of the task id is recommended. Choosing task ids
   * that are sequential or have sequential prefixes, for example using a
   * timestamp, causes an increase in latency and error rates in all
   * task commands. The infrastructure relies on an approximately
   * uniform distribution of task ids to store and serve tasks
   * efficiently.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2.Task task = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The task.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2.Task getTask() {
    return task_ == null ? com.google.cloud.tasks.v2.Task.getDefaultInstance() : task_;
  }
  /**
   *
   *
   * <pre>
   * Required. The task to add.
   *
   * Task names have the following format:
   * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`.
   * The user can optionally specify a task
   * [name][google.cloud.tasks.v2.Task.name]. If a name is not specified then
   * the system will generate a random unique task id, which will be set in the
   * task returned in the [response][google.cloud.tasks.v2.Task.name].
   *
   * If [schedule_time][google.cloud.tasks.v2.Task.schedule_time] is not set or
   * is in the past then Cloud Tasks will set it to the current time.
   *
   * Task De-duplication:
   *
   * Explicitly specifying a task ID enables task de-duplication.  If
   * a task's ID is identical to that of an existing task or a task
   * that was deleted or executed recently then the call will fail
   * with [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS].
   * If the task's queue was created using Cloud Tasks, then another task with
   * the same name can't be created for ~1hour after the original task was
   * deleted or executed. If the task's queue was created using queue.yaml or
   * queue.xml, then another task with the same name can't be created
   * for ~9days after the original task was deleted or executed.
   *
   * Because there is an extra lookup cost to identify duplicate task
   * names, these [CreateTask][google.cloud.tasks.v2.CloudTasks.CreateTask]
   * calls have significantly increased latency. Using hashed strings for the
   * task id or for the prefix of the task id is recommended. Choosing task ids
   * that are sequential or have sequential prefixes, for example using a
   * timestamp, causes an increase in latency and error rates in all
   * task commands. The infrastructure relies on an approximately
   * uniform distribution of task ids to store and serve tasks
   * efficiently.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2.Task task = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2.TaskOrBuilder getTaskOrBuilder() {
    return task_ == null ? com.google.cloud.tasks.v2.Task.getDefaultInstance() : task_;
  }

  public static final int RESPONSE_VIEW_FIELD_NUMBER = 3;
  private int responseView_ = 0;
  /**
   *
   *
   * <pre>
   * The response_view specifies which subset of the
   * [Task][google.cloud.tasks.v2.Task] will be returned.
   *
   * By default response_view is [BASIC][google.cloud.tasks.v2.Task.View.BASIC];
   * not all information is retrieved by default because some data, such as
   * payloads, might be desirable to return only when needed because
   * of its large size or because of the sensitivity of data that it
   * contains.
   *
   * Authorization for [FULL][google.cloud.tasks.v2.Task.View.FULL] requires
   * `cloudtasks.tasks.fullView` [Google IAM](https://cloud.google.com/iam/)
   * permission on the [Task][google.cloud.tasks.v2.Task] resource.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2.Task.View response_view = 3;</code>
   *
   * @return The enum numeric value on the wire for responseView.
   */
  @java.lang.Override
  public int getResponseViewValue() {
    return responseView_;
  }
  /**
   *
   *
   * <pre>
   * The response_view specifies which subset of the
   * [Task][google.cloud.tasks.v2.Task] will be returned.
   *
   * By default response_view is [BASIC][google.cloud.tasks.v2.Task.View.BASIC];
   * not all information is retrieved by default because some data, such as
   * payloads, might be desirable to return only when needed because
   * of its large size or because of the sensitivity of data that it
   * contains.
   *
   * Authorization for [FULL][google.cloud.tasks.v2.Task.View.FULL] requires
   * `cloudtasks.tasks.fullView` [Google IAM](https://cloud.google.com/iam/)
   * permission on the [Task][google.cloud.tasks.v2.Task] resource.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2.Task.View response_view = 3;</code>
   *
   * @return The responseView.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2.Task.View getResponseView() {
    com.google.cloud.tasks.v2.Task.View result =
        com.google.cloud.tasks.v2.Task.View.forNumber(responseView_);
    return result == null ? com.google.cloud.tasks.v2.Task.View.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (task_ != null) {
      output.writeMessage(2, getTask());
    }
    if (responseView_ != com.google.cloud.tasks.v2.Task.View.VIEW_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, responseView_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (task_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getTask());
    }
    if (responseView_ != com.google.cloud.tasks.v2.Task.View.VIEW_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, responseView_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.tasks.v2.CreateTaskRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.tasks.v2.CreateTaskRequest other =
        (com.google.cloud.tasks.v2.CreateTaskRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasTask() != other.hasTask()) return false;
    if (hasTask()) {
      if (!getTask().equals(other.getTask())) return false;
    }
    if (responseView_ != other.responseView_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasTask()) {
      hash = (37 * hash) + TASK_FIELD_NUMBER;
      hash = (53 * hash) + getTask().hashCode();
    }
    hash = (37 * hash) + RESPONSE_VIEW_FIELD_NUMBER;
    hash = (53 * hash) + responseView_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.tasks.v2.CreateTaskRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2.CreateTaskRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2.CreateTaskRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2.CreateTaskRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2.CreateTaskRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2.CreateTaskRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2.CreateTaskRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2.CreateTaskRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2.CreateTaskRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2.CreateTaskRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2.CreateTaskRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2.CreateTaskRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.tasks.v2.CreateTaskRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [CreateTask][google.cloud.tasks.v2.CloudTasks.CreateTask].
   * </pre>
   *
   * Protobuf type {@code google.cloud.tasks.v2.CreateTaskRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.tasks.v2.CreateTaskRequest)
      com.google.cloud.tasks.v2.CreateTaskRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.tasks.v2.CloudTasksProto
          .internal_static_google_cloud_tasks_v2_CreateTaskRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.tasks.v2.CloudTasksProto
          .internal_static_google_cloud_tasks_v2_CreateTaskRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.tasks.v2.CreateTaskRequest.class,
              com.google.cloud.tasks.v2.CreateTaskRequest.Builder.class);
    }

    // Construct using com.google.cloud.tasks.v2.CreateTaskRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      task_ = null;
      if (taskBuilder_ != null) {
        taskBuilder_.dispose();
        taskBuilder_ = null;
      }
      responseView_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.tasks.v2.CloudTasksProto
          .internal_static_google_cloud_tasks_v2_CreateTaskRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2.CreateTaskRequest getDefaultInstanceForType() {
      return com.google.cloud.tasks.v2.CreateTaskRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2.CreateTaskRequest build() {
      com.google.cloud.tasks.v2.CreateTaskRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2.CreateTaskRequest buildPartial() {
      com.google.cloud.tasks.v2.CreateTaskRequest result =
          new com.google.cloud.tasks.v2.CreateTaskRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.tasks.v2.CreateTaskRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.task_ = taskBuilder_ == null ? task_ : taskBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.responseView_ = responseView_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.tasks.v2.CreateTaskRequest) {
        return mergeFrom((com.google.cloud.tasks.v2.CreateTaskRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.tasks.v2.CreateTaskRequest other) {
      if (other == com.google.cloud.tasks.v2.CreateTaskRequest.getDefaultInstance()) return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasTask()) {
        mergeTask(other.getTask());
      }
      if (other.responseView_ != 0) {
        setResponseViewValue(other.getResponseViewValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getTaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                responseView_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The queue name. For example:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     *
     * The queue must already exist.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The queue name. For example:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     *
     * The queue must already exist.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The queue name. For example:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     *
     * The queue must already exist.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The queue name. For example:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     *
     * The queue must already exist.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The queue name. For example:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     *
     * The queue must already exist.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.tasks.v2.Task task_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2.Task,
            com.google.cloud.tasks.v2.Task.Builder,
            com.google.cloud.tasks.v2.TaskOrBuilder>
        taskBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The task to add.
     *
     * Task names have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`.
     * The user can optionally specify a task
     * [name][google.cloud.tasks.v2.Task.name]. If a name is not specified then
     * the system will generate a random unique task id, which will be set in the
     * task returned in the [response][google.cloud.tasks.v2.Task.name].
     *
     * If [schedule_time][google.cloud.tasks.v2.Task.schedule_time] is not set or
     * is in the past then Cloud Tasks will set it to the current time.
     *
     * Task De-duplication:
     *
     * Explicitly specifying a task ID enables task de-duplication.  If
     * a task's ID is identical to that of an existing task or a task
     * that was deleted or executed recently then the call will fail
     * with [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS].
     * If the task's queue was created using Cloud Tasks, then another task with
     * the same name can't be created for ~1hour after the original task was
     * deleted or executed. If the task's queue was created using queue.yaml or
     * queue.xml, then another task with the same name can't be created
     * for ~9days after the original task was deleted or executed.
     *
     * Because there is an extra lookup cost to identify duplicate task
     * names, these [CreateTask][google.cloud.tasks.v2.CloudTasks.CreateTask]
     * calls have significantly increased latency. Using hashed strings for the
     * task id or for the prefix of the task id is recommended. Choosing task ids
     * that are sequential or have sequential prefixes, for example using a
     * timestamp, causes an increase in latency and error rates in all
     * task commands. The infrastructure relies on an approximately
     * uniform distribution of task ids to store and serve tasks
     * efficiently.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.Task task = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the task field is set.
     */
    public boolean hasTask() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The task to add.
     *
     * Task names have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`.
     * The user can optionally specify a task
     * [name][google.cloud.tasks.v2.Task.name]. If a name is not specified then
     * the system will generate a random unique task id, which will be set in the
     * task returned in the [response][google.cloud.tasks.v2.Task.name].
     *
     * If [schedule_time][google.cloud.tasks.v2.Task.schedule_time] is not set or
     * is in the past then Cloud Tasks will set it to the current time.
     *
     * Task De-duplication:
     *
     * Explicitly specifying a task ID enables task de-duplication.  If
     * a task's ID is identical to that of an existing task or a task
     * that was deleted or executed recently then the call will fail
     * with [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS].
     * If the task's queue was created using Cloud Tasks, then another task with
     * the same name can't be created for ~1hour after the original task was
     * deleted or executed. If the task's queue was created using queue.yaml or
     * queue.xml, then another task with the same name can't be created
     * for ~9days after the original task was deleted or executed.
     *
     * Because there is an extra lookup cost to identify duplicate task
     * names, these [CreateTask][google.cloud.tasks.v2.CloudTasks.CreateTask]
     * calls have significantly increased latency. Using hashed strings for the
     * task id or for the prefix of the task id is recommended. Choosing task ids
     * that are sequential or have sequential prefixes, for example using a
     * timestamp, causes an increase in latency and error rates in all
     * task commands. The infrastructure relies on an approximately
     * uniform distribution of task ids to store and serve tasks
     * efficiently.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.Task task = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The task.
     */
    public com.google.cloud.tasks.v2.Task getTask() {
      if (taskBuilder_ == null) {
        return task_ == null ? com.google.cloud.tasks.v2.Task.getDefaultInstance() : task_;
      } else {
        return taskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The task to add.
     *
     * Task names have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`.
     * The user can optionally specify a task
     * [name][google.cloud.tasks.v2.Task.name]. If a name is not specified then
     * the system will generate a random unique task id, which will be set in the
     * task returned in the [response][google.cloud.tasks.v2.Task.name].
     *
     * If [schedule_time][google.cloud.tasks.v2.Task.schedule_time] is not set or
     * is in the past then Cloud Tasks will set it to the current time.
     *
     * Task De-duplication:
     *
     * Explicitly specifying a task ID enables task de-duplication.  If
     * a task's ID is identical to that of an existing task or a task
     * that was deleted or executed recently then the call will fail
     * with [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS].
     * If the task's queue was created using Cloud Tasks, then another task with
     * the same name can't be created for ~1hour after the original task was
     * deleted or executed. If the task's queue was created using queue.yaml or
     * queue.xml, then another task with the same name can't be created
     * for ~9days after the original task was deleted or executed.
     *
     * Because there is an extra lookup cost to identify duplicate task
     * names, these [CreateTask][google.cloud.tasks.v2.CloudTasks.CreateTask]
     * calls have significantly increased latency. Using hashed strings for the
     * task id or for the prefix of the task id is recommended. Choosing task ids
     * that are sequential or have sequential prefixes, for example using a
     * timestamp, causes an increase in latency and error rates in all
     * task commands. The infrastructure relies on an approximately
     * uniform distribution of task ids to store and serve tasks
     * efficiently.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.Task task = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setTask(com.google.cloud.tasks.v2.Task value) {
      if (taskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        task_ = value;
      } else {
        taskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The task to add.
     *
     * Task names have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`.
     * The user can optionally specify a task
     * [name][google.cloud.tasks.v2.Task.name]. If a name is not specified then
     * the system will generate a random unique task id, which will be set in the
     * task returned in the [response][google.cloud.tasks.v2.Task.name].
     *
     * If [schedule_time][google.cloud.tasks.v2.Task.schedule_time] is not set or
     * is in the past then Cloud Tasks will set it to the current time.
     *
     * Task De-duplication:
     *
     * Explicitly specifying a task ID enables task de-duplication.  If
     * a task's ID is identical to that of an existing task or a task
     * that was deleted or executed recently then the call will fail
     * with [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS].
     * If the task's queue was created using Cloud Tasks, then another task with
     * the same name can't be created for ~1hour after the original task was
     * deleted or executed. If the task's queue was created using queue.yaml or
     * queue.xml, then another task with the same name can't be created
     * for ~9days after the original task was deleted or executed.
     *
     * Because there is an extra lookup cost to identify duplicate task
     * names, these [CreateTask][google.cloud.tasks.v2.CloudTasks.CreateTask]
     * calls have significantly increased latency. Using hashed strings for the
     * task id or for the prefix of the task id is recommended. Choosing task ids
     * that are sequential or have sequential prefixes, for example using a
     * timestamp, causes an increase in latency and error rates in all
     * task commands. The infrastructure relies on an approximately
     * uniform distribution of task ids to store and serve tasks
     * efficiently.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.Task task = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setTask(com.google.cloud.tasks.v2.Task.Builder builderForValue) {
      if (taskBuilder_ == null) {
        task_ = builderForValue.build();
      } else {
        taskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The task to add.
     *
     * Task names have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`.
     * The user can optionally specify a task
     * [name][google.cloud.tasks.v2.Task.name]. If a name is not specified then
     * the system will generate a random unique task id, which will be set in the
     * task returned in the [response][google.cloud.tasks.v2.Task.name].
     *
     * If [schedule_time][google.cloud.tasks.v2.Task.schedule_time] is not set or
     * is in the past then Cloud Tasks will set it to the current time.
     *
     * Task De-duplication:
     *
     * Explicitly specifying a task ID enables task de-duplication.  If
     * a task's ID is identical to that of an existing task or a task
     * that was deleted or executed recently then the call will fail
     * with [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS].
     * If the task's queue was created using Cloud Tasks, then another task with
     * the same name can't be created for ~1hour after the original task was
     * deleted or executed. If the task's queue was created using queue.yaml or
     * queue.xml, then another task with the same name can't be created
     * for ~9days after the original task was deleted or executed.
     *
     * Because there is an extra lookup cost to identify duplicate task
     * names, these [CreateTask][google.cloud.tasks.v2.CloudTasks.CreateTask]
     * calls have significantly increased latency. Using hashed strings for the
     * task id or for the prefix of the task id is recommended. Choosing task ids
     * that are sequential or have sequential prefixes, for example using a
     * timestamp, causes an increase in latency and error rates in all
     * task commands. The infrastructure relies on an approximately
     * uniform distribution of task ids to store and serve tasks
     * efficiently.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.Task task = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder mergeTask(com.google.cloud.tasks.v2.Task value) {
      if (taskBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && task_ != null
            && task_ != com.google.cloud.tasks.v2.Task.getDefaultInstance()) {
          getTaskBuilder().mergeFrom(value);
        } else {
          task_ = value;
        }
      } else {
        taskBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The task to add.
     *
     * Task names have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`.
     * The user can optionally specify a task
     * [name][google.cloud.tasks.v2.Task.name]. If a name is not specified then
     * the system will generate a random unique task id, which will be set in the
     * task returned in the [response][google.cloud.tasks.v2.Task.name].
     *
     * If [schedule_time][google.cloud.tasks.v2.Task.schedule_time] is not set or
     * is in the past then Cloud Tasks will set it to the current time.
     *
     * Task De-duplication:
     *
     * Explicitly specifying a task ID enables task de-duplication.  If
     * a task's ID is identical to that of an existing task or a task
     * that was deleted or executed recently then the call will fail
     * with [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS].
     * If the task's queue was created using Cloud Tasks, then another task with
     * the same name can't be created for ~1hour after the original task was
     * deleted or executed. If the task's queue was created using queue.yaml or
     * queue.xml, then another task with the same name can't be created
     * for ~9days after the original task was deleted or executed.
     *
     * Because there is an extra lookup cost to identify duplicate task
     * names, these [CreateTask][google.cloud.tasks.v2.CloudTasks.CreateTask]
     * calls have significantly increased latency. Using hashed strings for the
     * task id or for the prefix of the task id is recommended. Choosing task ids
     * that are sequential or have sequential prefixes, for example using a
     * timestamp, causes an increase in latency and error rates in all
     * task commands. The infrastructure relies on an approximately
     * uniform distribution of task ids to store and serve tasks
     * efficiently.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.Task task = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder clearTask() {
      bitField0_ = (bitField0_ & ~0x00000002);
      task_ = null;
      if (taskBuilder_ != null) {
        taskBuilder_.dispose();
        taskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The task to add.
     *
     * Task names have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`.
     * The user can optionally specify a task
     * [name][google.cloud.tasks.v2.Task.name]. If a name is not specified then
     * the system will generate a random unique task id, which will be set in the
     * task returned in the [response][google.cloud.tasks.v2.Task.name].
     *
     * If [schedule_time][google.cloud.tasks.v2.Task.schedule_time] is not set or
     * is in the past then Cloud Tasks will set it to the current time.
     *
     * Task De-duplication:
     *
     * Explicitly specifying a task ID enables task de-duplication.  If
     * a task's ID is identical to that of an existing task or a task
     * that was deleted or executed recently then the call will fail
     * with [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS].
     * If the task's queue was created using Cloud Tasks, then another task with
     * the same name can't be created for ~1hour after the original task was
     * deleted or executed. If the task's queue was created using queue.yaml or
     * queue.xml, then another task with the same name can't be created
     * for ~9days after the original task was deleted or executed.
     *
     * Because there is an extra lookup cost to identify duplicate task
     * names, these [CreateTask][google.cloud.tasks.v2.CloudTasks.CreateTask]
     * calls have significantly increased latency. Using hashed strings for the
     * task id or for the prefix of the task id is recommended. Choosing task ids
     * that are sequential or have sequential prefixes, for example using a
     * timestamp, causes an increase in latency and error rates in all
     * task commands. The infrastructure relies on an approximately
     * uniform distribution of task ids to store and serve tasks
     * efficiently.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.Task task = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.cloud.tasks.v2.Task.Builder getTaskBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getTaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The task to add.
     *
     * Task names have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`.
     * The user can optionally specify a task
     * [name][google.cloud.tasks.v2.Task.name]. If a name is not specified then
     * the system will generate a random unique task id, which will be set in the
     * task returned in the [response][google.cloud.tasks.v2.Task.name].
     *
     * If [schedule_time][google.cloud.tasks.v2.Task.schedule_time] is not set or
     * is in the past then Cloud Tasks will set it to the current time.
     *
     * Task De-duplication:
     *
     * Explicitly specifying a task ID enables task de-duplication.  If
     * a task's ID is identical to that of an existing task or a task
     * that was deleted or executed recently then the call will fail
     * with [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS].
     * If the task's queue was created using Cloud Tasks, then another task with
     * the same name can't be created for ~1hour after the original task was
     * deleted or executed. If the task's queue was created using queue.yaml or
     * queue.xml, then another task with the same name can't be created
     * for ~9days after the original task was deleted or executed.
     *
     * Because there is an extra lookup cost to identify duplicate task
     * names, these [CreateTask][google.cloud.tasks.v2.CloudTasks.CreateTask]
     * calls have significantly increased latency. Using hashed strings for the
     * task id or for the prefix of the task id is recommended. Choosing task ids
     * that are sequential or have sequential prefixes, for example using a
     * timestamp, causes an increase in latency and error rates in all
     * task commands. The infrastructure relies on an approximately
     * uniform distribution of task ids to store and serve tasks
     * efficiently.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.Task task = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.cloud.tasks.v2.TaskOrBuilder getTaskOrBuilder() {
      if (taskBuilder_ != null) {
        return taskBuilder_.getMessageOrBuilder();
      } else {
        return task_ == null ? com.google.cloud.tasks.v2.Task.getDefaultInstance() : task_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The task to add.
     *
     * Task names have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`.
     * The user can optionally specify a task
     * [name][google.cloud.tasks.v2.Task.name]. If a name is not specified then
     * the system will generate a random unique task id, which will be set in the
     * task returned in the [response][google.cloud.tasks.v2.Task.name].
     *
     * If [schedule_time][google.cloud.tasks.v2.Task.schedule_time] is not set or
     * is in the past then Cloud Tasks will set it to the current time.
     *
     * Task De-duplication:
     *
     * Explicitly specifying a task ID enables task de-duplication.  If
     * a task's ID is identical to that of an existing task or a task
     * that was deleted or executed recently then the call will fail
     * with [ALREADY_EXISTS][google.rpc.Code.ALREADY_EXISTS].
     * If the task's queue was created using Cloud Tasks, then another task with
     * the same name can't be created for ~1hour after the original task was
     * deleted or executed. If the task's queue was created using queue.yaml or
     * queue.xml, then another task with the same name can't be created
     * for ~9days after the original task was deleted or executed.
     *
     * Because there is an extra lookup cost to identify duplicate task
     * names, these [CreateTask][google.cloud.tasks.v2.CloudTasks.CreateTask]
     * calls have significantly increased latency. Using hashed strings for the
     * task id or for the prefix of the task id is recommended. Choosing task ids
     * that are sequential or have sequential prefixes, for example using a
     * timestamp, causes an increase in latency and error rates in all
     * task commands. The infrastructure relies on an approximately
     * uniform distribution of task ids to store and serve tasks
     * efficiently.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.Task task = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2.Task,
            com.google.cloud.tasks.v2.Task.Builder,
            com.google.cloud.tasks.v2.TaskOrBuilder>
        getTaskFieldBuilder() {
      if (taskBuilder_ == null) {
        taskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2.Task,
                com.google.cloud.tasks.v2.Task.Builder,
                com.google.cloud.tasks.v2.TaskOrBuilder>(
                getTask(), getParentForChildren(), isClean());
        task_ = null;
      }
      return taskBuilder_;
    }

    private int responseView_ = 0;
    /**
     *
     *
     * <pre>
     * The response_view specifies which subset of the
     * [Task][google.cloud.tasks.v2.Task] will be returned.
     *
     * By default response_view is [BASIC][google.cloud.tasks.v2.Task.View.BASIC];
     * not all information is retrieved by default because some data, such as
     * payloads, might be desirable to return only when needed because
     * of its large size or because of the sensitivity of data that it
     * contains.
     *
     * Authorization for [FULL][google.cloud.tasks.v2.Task.View.FULL] requires
     * `cloudtasks.tasks.fullView` [Google IAM](https://cloud.google.com/iam/)
     * permission on the [Task][google.cloud.tasks.v2.Task] resource.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.Task.View response_view = 3;</code>
     *
     * @return The enum numeric value on the wire for responseView.
     */
    @java.lang.Override
    public int getResponseViewValue() {
      return responseView_;
    }
    /**
     *
     *
     * <pre>
     * The response_view specifies which subset of the
     * [Task][google.cloud.tasks.v2.Task] will be returned.
     *
     * By default response_view is [BASIC][google.cloud.tasks.v2.Task.View.BASIC];
     * not all information is retrieved by default because some data, such as
     * payloads, might be desirable to return only when needed because
     * of its large size or because of the sensitivity of data that it
     * contains.
     *
     * Authorization for [FULL][google.cloud.tasks.v2.Task.View.FULL] requires
     * `cloudtasks.tasks.fullView` [Google IAM](https://cloud.google.com/iam/)
     * permission on the [Task][google.cloud.tasks.v2.Task] resource.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.Task.View response_view = 3;</code>
     *
     * @param value The enum numeric value on the wire for responseView to set.
     * @return This builder for chaining.
     */
    public Builder setResponseViewValue(int value) {
      responseView_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The response_view specifies which subset of the
     * [Task][google.cloud.tasks.v2.Task] will be returned.
     *
     * By default response_view is [BASIC][google.cloud.tasks.v2.Task.View.BASIC];
     * not all information is retrieved by default because some data, such as
     * payloads, might be desirable to return only when needed because
     * of its large size or because of the sensitivity of data that it
     * contains.
     *
     * Authorization for [FULL][google.cloud.tasks.v2.Task.View.FULL] requires
     * `cloudtasks.tasks.fullView` [Google IAM](https://cloud.google.com/iam/)
     * permission on the [Task][google.cloud.tasks.v2.Task] resource.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.Task.View response_view = 3;</code>
     *
     * @return The responseView.
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2.Task.View getResponseView() {
      com.google.cloud.tasks.v2.Task.View result =
          com.google.cloud.tasks.v2.Task.View.forNumber(responseView_);
      return result == null ? com.google.cloud.tasks.v2.Task.View.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The response_view specifies which subset of the
     * [Task][google.cloud.tasks.v2.Task] will be returned.
     *
     * By default response_view is [BASIC][google.cloud.tasks.v2.Task.View.BASIC];
     * not all information is retrieved by default because some data, such as
     * payloads, might be desirable to return only when needed because
     * of its large size or because of the sensitivity of data that it
     * contains.
     *
     * Authorization for [FULL][google.cloud.tasks.v2.Task.View.FULL] requires
     * `cloudtasks.tasks.fullView` [Google IAM](https://cloud.google.com/iam/)
     * permission on the [Task][google.cloud.tasks.v2.Task] resource.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.Task.View response_view = 3;</code>
     *
     * @param value The responseView to set.
     * @return This builder for chaining.
     */
    public Builder setResponseView(com.google.cloud.tasks.v2.Task.View value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      responseView_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The response_view specifies which subset of the
     * [Task][google.cloud.tasks.v2.Task] will be returned.
     *
     * By default response_view is [BASIC][google.cloud.tasks.v2.Task.View.BASIC];
     * not all information is retrieved by default because some data, such as
     * payloads, might be desirable to return only when needed because
     * of its large size or because of the sensitivity of data that it
     * contains.
     *
     * Authorization for [FULL][google.cloud.tasks.v2.Task.View.FULL] requires
     * `cloudtasks.tasks.fullView` [Google IAM](https://cloud.google.com/iam/)
     * permission on the [Task][google.cloud.tasks.v2.Task] resource.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2.Task.View response_view = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResponseView() {
      bitField0_ = (bitField0_ & ~0x00000004);
      responseView_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.tasks.v2.CreateTaskRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.tasks.v2.CreateTaskRequest)
  private static final com.google.cloud.tasks.v2.CreateTaskRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.tasks.v2.CreateTaskRequest();
  }

  public static com.google.cloud.tasks.v2.CreateTaskRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CreateTaskRequest> PARSER =
      new com.google.protobuf.AbstractParser<CreateTaskRequest>() {
        @java.lang.Override
        public CreateTaskRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CreateTaskRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CreateTaskRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.tasks.v2.CreateTaskRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
