/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/tasks/v2beta2/queue.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.tasks.v2beta2;

/**
 *
 *
 * <pre>
 * A queue is a container of related tasks. Queues are configured to manage
 * how those tasks are dispatched. Configurable properties include rate limits,
 * retry options, target types, and others.
 * </pre>
 *
 * Protobuf type {@code google.cloud.tasks.v2beta2.Queue}
 */
public final class Queue extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.tasks.v2beta2.Queue)
    QueueOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Queue.newBuilder() to construct.
  private Queue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Queue() {
    name_ = "";
    state_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Queue();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.tasks.v2beta2.QueueProto
        .internal_static_google_cloud_tasks_v2beta2_Queue_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.tasks.v2beta2.QueueProto
        .internal_static_google_cloud_tasks_v2beta2_Queue_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.tasks.v2beta2.Queue.class,
            com.google.cloud.tasks.v2beta2.Queue.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * State of the queue.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.tasks.v2beta2.Queue.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The queue is running. Tasks can be dispatched.
     *
     * If the queue was created using Cloud Tasks and the queue has
     * had no activity (method calls or task dispatches) for 30 days,
     * the queue may take a few minutes to re-activate. Some method
     * calls may return [NOT_FOUND][google.rpc.Code.NOT_FOUND] and
     * tasks may not be dispatched for a few minutes until the queue
     * has been re-activated.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    RUNNING(1),
    /**
     *
     *
     * <pre>
     * Tasks are paused by the user. If the queue is paused then Cloud
     * Tasks will stop delivering tasks from it, but more tasks can
     * still be added to it by the user. When a pull queue is paused,
     * all [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] calls
     * will return a [FAILED_PRECONDITION][google.rpc.Code.FAILED_PRECONDITION].
     * </pre>
     *
     * <code>PAUSED = 2;</code>
     */
    PAUSED(2),
    /**
     *
     *
     * <pre>
     * The queue is disabled.
     *
     * A queue becomes `DISABLED` when
     * [queue.yaml](https://cloud.google.com/appengine/docs/python/config/queueref)
     * or
     * [queue.xml](https://cloud.google.com/appengine/docs/standard/java/config/queueref)
     * is uploaded which does not contain the queue. You cannot directly disable
     * a queue.
     *
     * When a queue is disabled, tasks can still be added to a queue
     * but the tasks are not dispatched and
     * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] calls
     * return a `FAILED_PRECONDITION` error.
     *
     * To permanently delete this queue and all of its tasks, call
     * [DeleteQueue][google.cloud.tasks.v2beta2.CloudTasks.DeleteQueue].
     * </pre>
     *
     * <code>DISABLED = 3;</code>
     */
    DISABLED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The queue is running. Tasks can be dispatched.
     *
     * If the queue was created using Cloud Tasks and the queue has
     * had no activity (method calls or task dispatches) for 30 days,
     * the queue may take a few minutes to re-activate. Some method
     * calls may return [NOT_FOUND][google.rpc.Code.NOT_FOUND] and
     * tasks may not be dispatched for a few minutes until the queue
     * has been re-activated.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    public static final int RUNNING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Tasks are paused by the user. If the queue is paused then Cloud
     * Tasks will stop delivering tasks from it, but more tasks can
     * still be added to it by the user. When a pull queue is paused,
     * all [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] calls
     * will return a [FAILED_PRECONDITION][google.rpc.Code.FAILED_PRECONDITION].
     * </pre>
     *
     * <code>PAUSED = 2;</code>
     */
    public static final int PAUSED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The queue is disabled.
     *
     * A queue becomes `DISABLED` when
     * [queue.yaml](https://cloud.google.com/appengine/docs/python/config/queueref)
     * or
     * [queue.xml](https://cloud.google.com/appengine/docs/standard/java/config/queueref)
     * is uploaded which does not contain the queue. You cannot directly disable
     * a queue.
     *
     * When a queue is disabled, tasks can still be added to a queue
     * but the tasks are not dispatched and
     * [LeaseTasks][google.cloud.tasks.v2beta2.CloudTasks.LeaseTasks] calls
     * return a `FAILED_PRECONDITION` error.
     *
     * To permanently delete this queue and all of its tasks, call
     * [DeleteQueue][google.cloud.tasks.v2beta2.CloudTasks.DeleteQueue].
     * </pre>
     *
     * <code>DISABLED = 3;</code>
     */
    public static final int DISABLED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return RUNNING;
        case 2:
          return PAUSED;
        case 3:
          return DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.tasks.v2beta2.Queue.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.tasks.v2beta2.Queue.State)
  }

  private int bitField0_;
  private int targetTypeCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object targetType_;

  public enum TargetTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    APP_ENGINE_HTTP_TARGET(3),
    PULL_TARGET(4),
    HTTP_TARGET(17),
    TARGETTYPE_NOT_SET(0);
    private final int value;

    private TargetTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TargetTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static TargetTypeCase forNumber(int value) {
      switch (value) {
        case 3:
          return APP_ENGINE_HTTP_TARGET;
        case 4:
          return PULL_TARGET;
        case 17:
          return HTTP_TARGET;
        case 0:
          return TARGETTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public TargetTypeCase getTargetTypeCase() {
    return TargetTypeCase.forNumber(targetTypeCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Caller-specified and required in
   * [CreateQueue][google.cloud.tasks.v2beta2.CloudTasks.CreateQueue], after
   * which it becomes output only.
   *
   * The queue name.
   *
   * The queue name must have the following format:
   * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
   *
   * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
   *    hyphens (-), colons (:), or periods (.).
   *    For more information, see
   *    [Identifying
   *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
   * * `LOCATION_ID` is the canonical ID for the queue's location.
   *    The list of available locations can be obtained by calling
   *    [ListLocations][google.cloud.location.Locations.ListLocations].
   *    For more information, see https://cloud.google.com/about/locations/.
   * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
   *   hyphens (-). The maximum length is 100 characters.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Caller-specified and required in
   * [CreateQueue][google.cloud.tasks.v2beta2.CloudTasks.CreateQueue], after
   * which it becomes output only.
   *
   * The queue name.
   *
   * The queue name must have the following format:
   * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
   *
   * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
   *    hyphens (-), colons (:), or periods (.).
   *    For more information, see
   *    [Identifying
   *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
   * * `LOCATION_ID` is the canonical ID for the queue's location.
   *    The list of available locations can be obtained by calling
   *    [ListLocations][google.cloud.location.Locations.ListLocations].
   *    For more information, see https://cloud.google.com/about/locations/.
   * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
   *   hyphens (-). The maximum length is 100 characters.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APP_ENGINE_HTTP_TARGET_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * App Engine HTTP target.
   *
   * An App Engine queue is a queue that has an
   * [AppEngineHttpTarget][google.cloud.tasks.v2beta2.AppEngineHttpTarget].
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta2.AppEngineHttpTarget app_engine_http_target = 3;</code>
   *
   * @return Whether the appEngineHttpTarget field is set.
   */
  @java.lang.Override
  public boolean hasAppEngineHttpTarget() {
    return targetTypeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * App Engine HTTP target.
   *
   * An App Engine queue is a queue that has an
   * [AppEngineHttpTarget][google.cloud.tasks.v2beta2.AppEngineHttpTarget].
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta2.AppEngineHttpTarget app_engine_http_target = 3;</code>
   *
   * @return The appEngineHttpTarget.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta2.AppEngineHttpTarget getAppEngineHttpTarget() {
    if (targetTypeCase_ == 3) {
      return (com.google.cloud.tasks.v2beta2.AppEngineHttpTarget) targetType_;
    }
    return com.google.cloud.tasks.v2beta2.AppEngineHttpTarget.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * App Engine HTTP target.
   *
   * An App Engine queue is a queue that has an
   * [AppEngineHttpTarget][google.cloud.tasks.v2beta2.AppEngineHttpTarget].
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta2.AppEngineHttpTarget app_engine_http_target = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta2.AppEngineHttpTargetOrBuilder
      getAppEngineHttpTargetOrBuilder() {
    if (targetTypeCase_ == 3) {
      return (com.google.cloud.tasks.v2beta2.AppEngineHttpTarget) targetType_;
    }
    return com.google.cloud.tasks.v2beta2.AppEngineHttpTarget.getDefaultInstance();
  }

  public static final int PULL_TARGET_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * Pull target.
   *
   * A pull queue is a queue that has a
   * [PullTarget][google.cloud.tasks.v2beta2.PullTarget].
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta2.PullTarget pull_target = 4;</code>
   *
   * @return Whether the pullTarget field is set.
   */
  @java.lang.Override
  public boolean hasPullTarget() {
    return targetTypeCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * Pull target.
   *
   * A pull queue is a queue that has a
   * [PullTarget][google.cloud.tasks.v2beta2.PullTarget].
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta2.PullTarget pull_target = 4;</code>
   *
   * @return The pullTarget.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta2.PullTarget getPullTarget() {
    if (targetTypeCase_ == 4) {
      return (com.google.cloud.tasks.v2beta2.PullTarget) targetType_;
    }
    return com.google.cloud.tasks.v2beta2.PullTarget.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Pull target.
   *
   * A pull queue is a queue that has a
   * [PullTarget][google.cloud.tasks.v2beta2.PullTarget].
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta2.PullTarget pull_target = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta2.PullTargetOrBuilder getPullTargetOrBuilder() {
    if (targetTypeCase_ == 4) {
      return (com.google.cloud.tasks.v2beta2.PullTarget) targetType_;
    }
    return com.google.cloud.tasks.v2beta2.PullTarget.getDefaultInstance();
  }

  public static final int HTTP_TARGET_FIELD_NUMBER = 17;
  /**
   *
   *
   * <pre>
   * An http_target is used to override the target values for HTTP tasks.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta2.HttpTarget http_target = 17;</code>
   *
   * @return Whether the httpTarget field is set.
   */
  @java.lang.Override
  public boolean hasHttpTarget() {
    return targetTypeCase_ == 17;
  }
  /**
   *
   *
   * <pre>
   * An http_target is used to override the target values for HTTP tasks.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta2.HttpTarget http_target = 17;</code>
   *
   * @return The httpTarget.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta2.HttpTarget getHttpTarget() {
    if (targetTypeCase_ == 17) {
      return (com.google.cloud.tasks.v2beta2.HttpTarget) targetType_;
    }
    return com.google.cloud.tasks.v2beta2.HttpTarget.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * An http_target is used to override the target values for HTTP tasks.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta2.HttpTarget http_target = 17;</code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta2.HttpTargetOrBuilder getHttpTargetOrBuilder() {
    if (targetTypeCase_ == 17) {
      return (com.google.cloud.tasks.v2beta2.HttpTarget) targetType_;
    }
    return com.google.cloud.tasks.v2beta2.HttpTarget.getDefaultInstance();
  }

  public static final int RATE_LIMITS_FIELD_NUMBER = 5;
  private com.google.cloud.tasks.v2beta2.RateLimits rateLimits_;
  /**
   *
   *
   * <pre>
   * Rate limits for task dispatches.
   *
   * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] and
   * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] are related
   * because they both control task attempts however they control how tasks are
   * attempted in different ways:
   *
   * * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] controls the
   * total rate of
   *   dispatches from a queue (i.e. all traffic dispatched from the
   *   queue, regardless of whether the dispatch is from a first
   *   attempt or a retry).
   * * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
   * what happens to
   *   particular a task after its first attempt fails. That is,
   *   [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
   *   task retries (the second attempt, third attempt, etc).
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta2.RateLimits rate_limits = 5;</code>
   *
   * @return Whether the rateLimits field is set.
   */
  @java.lang.Override
  public boolean hasRateLimits() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Rate limits for task dispatches.
   *
   * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] and
   * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] are related
   * because they both control task attempts however they control how tasks are
   * attempted in different ways:
   *
   * * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] controls the
   * total rate of
   *   dispatches from a queue (i.e. all traffic dispatched from the
   *   queue, regardless of whether the dispatch is from a first
   *   attempt or a retry).
   * * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
   * what happens to
   *   particular a task after its first attempt fails. That is,
   *   [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
   *   task retries (the second attempt, third attempt, etc).
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta2.RateLimits rate_limits = 5;</code>
   *
   * @return The rateLimits.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta2.RateLimits getRateLimits() {
    return rateLimits_ == null
        ? com.google.cloud.tasks.v2beta2.RateLimits.getDefaultInstance()
        : rateLimits_;
  }
  /**
   *
   *
   * <pre>
   * Rate limits for task dispatches.
   *
   * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] and
   * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] are related
   * because they both control task attempts however they control how tasks are
   * attempted in different ways:
   *
   * * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] controls the
   * total rate of
   *   dispatches from a queue (i.e. all traffic dispatched from the
   *   queue, regardless of whether the dispatch is from a first
   *   attempt or a retry).
   * * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
   * what happens to
   *   particular a task after its first attempt fails. That is,
   *   [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
   *   task retries (the second attempt, third attempt, etc).
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta2.RateLimits rate_limits = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta2.RateLimitsOrBuilder getRateLimitsOrBuilder() {
    return rateLimits_ == null
        ? com.google.cloud.tasks.v2beta2.RateLimits.getDefaultInstance()
        : rateLimits_;
  }

  public static final int RETRY_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.tasks.v2beta2.RetryConfig retryConfig_;
  /**
   *
   *
   * <pre>
   * Settings that determine the retry behavior.
   *
   * * For tasks created using Cloud Tasks: the queue-level retry settings
   *   apply to all tasks in the queue that were created using Cloud Tasks.
   *   Retry settings cannot be set on individual tasks.
   * * For tasks created using the App Engine SDK: the queue-level retry
   *   settings apply to all tasks in the queue which do not have retry settings
   *   explicitly set on the task and were created by the App Engine SDK. See
   *   [App Engine
   *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta2.RetryConfig retry_config = 6;</code>
   *
   * @return Whether the retryConfig field is set.
   */
  @java.lang.Override
  public boolean hasRetryConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Settings that determine the retry behavior.
   *
   * * For tasks created using Cloud Tasks: the queue-level retry settings
   *   apply to all tasks in the queue that were created using Cloud Tasks.
   *   Retry settings cannot be set on individual tasks.
   * * For tasks created using the App Engine SDK: the queue-level retry
   *   settings apply to all tasks in the queue which do not have retry settings
   *   explicitly set on the task and were created by the App Engine SDK. See
   *   [App Engine
   *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta2.RetryConfig retry_config = 6;</code>
   *
   * @return The retryConfig.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta2.RetryConfig getRetryConfig() {
    return retryConfig_ == null
        ? com.google.cloud.tasks.v2beta2.RetryConfig.getDefaultInstance()
        : retryConfig_;
  }
  /**
   *
   *
   * <pre>
   * Settings that determine the retry behavior.
   *
   * * For tasks created using Cloud Tasks: the queue-level retry settings
   *   apply to all tasks in the queue that were created using Cloud Tasks.
   *   Retry settings cannot be set on individual tasks.
   * * For tasks created using the App Engine SDK: the queue-level retry
   *   settings apply to all tasks in the queue which do not have retry settings
   *   explicitly set on the task and were created by the App Engine SDK. See
   *   [App Engine
   *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta2.RetryConfig retry_config = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta2.RetryConfigOrBuilder getRetryConfigOrBuilder() {
    return retryConfig_ == null
        ? com.google.cloud.tasks.v2beta2.RetryConfig.getDefaultInstance()
        : retryConfig_;
  }

  public static final int STATE_FIELD_NUMBER = 7;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The state of the queue.
   *
   * `state` can only be changed by called
   * [PauseQueue][google.cloud.tasks.v2beta2.CloudTasks.PauseQueue],
   * [ResumeQueue][google.cloud.tasks.v2beta2.CloudTasks.ResumeQueue], or
   * uploading
   * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
   * [UpdateQueue][google.cloud.tasks.v2beta2.CloudTasks.UpdateQueue] cannot be
   * used to change `state`.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta2.Queue.State state = 7;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The state of the queue.
   *
   * `state` can only be changed by called
   * [PauseQueue][google.cloud.tasks.v2beta2.CloudTasks.PauseQueue],
   * [ResumeQueue][google.cloud.tasks.v2beta2.CloudTasks.ResumeQueue], or
   * uploading
   * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
   * [UpdateQueue][google.cloud.tasks.v2beta2.CloudTasks.UpdateQueue] cannot be
   * used to change `state`.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta2.Queue.State state = 7;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta2.Queue.State getState() {
    com.google.cloud.tasks.v2beta2.Queue.State result =
        com.google.cloud.tasks.v2beta2.Queue.State.forNumber(state_);
    return result == null ? com.google.cloud.tasks.v2beta2.Queue.State.UNRECOGNIZED : result;
  }

  public static final int PURGE_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp purgeTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last time this queue was purged.
   *
   * All tasks that were [created][google.cloud.tasks.v2beta2.Task.create_time]
   * before this time were purged.
   *
   * A queue can be purged using
   * [PurgeQueue][google.cloud.tasks.v2beta2.CloudTasks.PurgeQueue], the [App
   * Engine Task Queue SDK, or the Cloud
   * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
   *
   * Purge time will be truncated to the nearest microsecond. Purge
   * time will be unset if the queue has never been purged.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp purge_time = 8;</code>
   *
   * @return Whether the purgeTime field is set.
   */
  @java.lang.Override
  public boolean hasPurgeTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The last time this queue was purged.
   *
   * All tasks that were [created][google.cloud.tasks.v2beta2.Task.create_time]
   * before this time were purged.
   *
   * A queue can be purged using
   * [PurgeQueue][google.cloud.tasks.v2beta2.CloudTasks.PurgeQueue], the [App
   * Engine Task Queue SDK, or the Cloud
   * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
   *
   * Purge time will be truncated to the nearest microsecond. Purge
   * time will be unset if the queue has never been purged.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp purge_time = 8;</code>
   *
   * @return The purgeTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getPurgeTime() {
    return purgeTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : purgeTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last time this queue was purged.
   *
   * All tasks that were [created][google.cloud.tasks.v2beta2.Task.create_time]
   * before this time were purged.
   *
   * A queue can be purged using
   * [PurgeQueue][google.cloud.tasks.v2beta2.CloudTasks.PurgeQueue], the [App
   * Engine Task Queue SDK, or the Cloud
   * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
   *
   * Purge time will be truncated to the nearest microsecond. Purge
   * time will be unset if the queue has never been purged.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp purge_time = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getPurgeTimeOrBuilder() {
    return purgeTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : purgeTime_;
  }

  public static final int TASK_TTL_FIELD_NUMBER = 9;
  private com.google.protobuf.Duration taskTtl_;
  /**
   *
   *
   * <pre>
   * The maximum amount of time that a task will be retained in
   * this queue.
   *
   * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
   * After a task has lived for `task_ttl`, the task will be deleted
   * regardless of whether it was dispatched or not.
   *
   * The `task_ttl` for queues created via queue.yaml/xml is equal to the
   * maximum duration because there is a
   * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
   * these queues. To view the maximum valid duration, see the documentation for
   * [Duration][google.protobuf.Duration].
   * </pre>
   *
   * <code>.google.protobuf.Duration task_ttl = 9;</code>
   *
   * @return Whether the taskTtl field is set.
   */
  @java.lang.Override
  public boolean hasTaskTtl() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * The maximum amount of time that a task will be retained in
   * this queue.
   *
   * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
   * After a task has lived for `task_ttl`, the task will be deleted
   * regardless of whether it was dispatched or not.
   *
   * The `task_ttl` for queues created via queue.yaml/xml is equal to the
   * maximum duration because there is a
   * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
   * these queues. To view the maximum valid duration, see the documentation for
   * [Duration][google.protobuf.Duration].
   * </pre>
   *
   * <code>.google.protobuf.Duration task_ttl = 9;</code>
   *
   * @return The taskTtl.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTaskTtl() {
    return taskTtl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : taskTtl_;
  }
  /**
   *
   *
   * <pre>
   * The maximum amount of time that a task will be retained in
   * this queue.
   *
   * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
   * After a task has lived for `task_ttl`, the task will be deleted
   * regardless of whether it was dispatched or not.
   *
   * The `task_ttl` for queues created via queue.yaml/xml is equal to the
   * maximum duration because there is a
   * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
   * these queues. To view the maximum valid duration, see the documentation for
   * [Duration][google.protobuf.Duration].
   * </pre>
   *
   * <code>.google.protobuf.Duration task_ttl = 9;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTaskTtlOrBuilder() {
    return taskTtl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : taskTtl_;
  }

  public static final int TOMBSTONE_TTL_FIELD_NUMBER = 10;
  private com.google.protobuf.Duration tombstoneTtl_;
  /**
   *
   *
   * <pre>
   * The task tombstone time to live (TTL).
   *
   * After a task is deleted or completed, the task's tombstone is
   * retained for the length of time specified by `tombstone_ttl`.
   * The tombstone is used by task de-duplication; another task with the same
   * name can't be created until the tombstone has expired. For more information
   * about task de-duplication, see the documentation for
   * [CreateTaskRequest][google.cloud.tasks.v2beta2.CreateTaskRequest.task].
   *
   * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
   * </pre>
   *
   * <code>.google.protobuf.Duration tombstone_ttl = 10;</code>
   *
   * @return Whether the tombstoneTtl field is set.
   */
  @java.lang.Override
  public boolean hasTombstoneTtl() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * The task tombstone time to live (TTL).
   *
   * After a task is deleted or completed, the task's tombstone is
   * retained for the length of time specified by `tombstone_ttl`.
   * The tombstone is used by task de-duplication; another task with the same
   * name can't be created until the tombstone has expired. For more information
   * about task de-duplication, see the documentation for
   * [CreateTaskRequest][google.cloud.tasks.v2beta2.CreateTaskRequest.task].
   *
   * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
   * </pre>
   *
   * <code>.google.protobuf.Duration tombstone_ttl = 10;</code>
   *
   * @return The tombstoneTtl.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTombstoneTtl() {
    return tombstoneTtl_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : tombstoneTtl_;
  }
  /**
   *
   *
   * <pre>
   * The task tombstone time to live (TTL).
   *
   * After a task is deleted or completed, the task's tombstone is
   * retained for the length of time specified by `tombstone_ttl`.
   * The tombstone is used by task de-duplication; another task with the same
   * name can't be created until the tombstone has expired. For more information
   * about task de-duplication, see the documentation for
   * [CreateTaskRequest][google.cloud.tasks.v2beta2.CreateTaskRequest.task].
   *
   * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
   * </pre>
   *
   * <code>.google.protobuf.Duration tombstone_ttl = 10;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTombstoneTtlOrBuilder() {
    return tombstoneTtl_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : tombstoneTtl_;
  }

  public static final int STATS_FIELD_NUMBER = 16;
  private com.google.cloud.tasks.v2beta2.QueueStats stats_;
  /**
   *
   *
   * <pre>
   * Output only. The realtime, informational statistics for a queue. In order
   * to receive the statistics the caller should include this field in the
   * FieldMask.
   * </pre>
   *
   * <code>
   * .google.cloud.tasks.v2beta2.QueueStats stats = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the stats field is set.
   */
  @java.lang.Override
  public boolean hasStats() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   *
   *
   * <pre>
   * Output only. The realtime, informational statistics for a queue. In order
   * to receive the statistics the caller should include this field in the
   * FieldMask.
   * </pre>
   *
   * <code>
   * .google.cloud.tasks.v2beta2.QueueStats stats = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The stats.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta2.QueueStats getStats() {
    return stats_ == null ? com.google.cloud.tasks.v2beta2.QueueStats.getDefaultInstance() : stats_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The realtime, informational statistics for a queue. In order
   * to receive the statistics the caller should include this field in the
   * FieldMask.
   * </pre>
   *
   * <code>
   * .google.cloud.tasks.v2beta2.QueueStats stats = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta2.QueueStatsOrBuilder getStatsOrBuilder() {
    return stats_ == null ? com.google.cloud.tasks.v2beta2.QueueStats.getDefaultInstance() : stats_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (targetTypeCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.tasks.v2beta2.AppEngineHttpTarget) targetType_);
    }
    if (targetTypeCase_ == 4) {
      output.writeMessage(4, (com.google.cloud.tasks.v2beta2.PullTarget) targetType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(5, getRateLimits());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getRetryConfig());
    }
    if (state_ != com.google.cloud.tasks.v2beta2.Queue.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(7, state_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getPurgeTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(9, getTaskTtl());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(10, getTombstoneTtl());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(16, getStats());
    }
    if (targetTypeCase_ == 17) {
      output.writeMessage(17, (com.google.cloud.tasks.v2beta2.HttpTarget) targetType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (targetTypeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.tasks.v2beta2.AppEngineHttpTarget) targetType_);
    }
    if (targetTypeCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.cloud.tasks.v2beta2.PullTarget) targetType_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getRateLimits());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getRetryConfig());
    }
    if (state_ != com.google.cloud.tasks.v2beta2.Queue.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, state_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getPurgeTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getTaskTtl());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getTombstoneTtl());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getStats());
    }
    if (targetTypeCase_ == 17) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              17, (com.google.cloud.tasks.v2beta2.HttpTarget) targetType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.tasks.v2beta2.Queue)) {
      return super.equals(obj);
    }
    com.google.cloud.tasks.v2beta2.Queue other = (com.google.cloud.tasks.v2beta2.Queue) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasRateLimits() != other.hasRateLimits()) return false;
    if (hasRateLimits()) {
      if (!getRateLimits().equals(other.getRateLimits())) return false;
    }
    if (hasRetryConfig() != other.hasRetryConfig()) return false;
    if (hasRetryConfig()) {
      if (!getRetryConfig().equals(other.getRetryConfig())) return false;
    }
    if (state_ != other.state_) return false;
    if (hasPurgeTime() != other.hasPurgeTime()) return false;
    if (hasPurgeTime()) {
      if (!getPurgeTime().equals(other.getPurgeTime())) return false;
    }
    if (hasTaskTtl() != other.hasTaskTtl()) return false;
    if (hasTaskTtl()) {
      if (!getTaskTtl().equals(other.getTaskTtl())) return false;
    }
    if (hasTombstoneTtl() != other.hasTombstoneTtl()) return false;
    if (hasTombstoneTtl()) {
      if (!getTombstoneTtl().equals(other.getTombstoneTtl())) return false;
    }
    if (hasStats() != other.hasStats()) return false;
    if (hasStats()) {
      if (!getStats().equals(other.getStats())) return false;
    }
    if (!getTargetTypeCase().equals(other.getTargetTypeCase())) return false;
    switch (targetTypeCase_) {
      case 3:
        if (!getAppEngineHttpTarget().equals(other.getAppEngineHttpTarget())) return false;
        break;
      case 4:
        if (!getPullTarget().equals(other.getPullTarget())) return false;
        break;
      case 17:
        if (!getHttpTarget().equals(other.getHttpTarget())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasRateLimits()) {
      hash = (37 * hash) + RATE_LIMITS_FIELD_NUMBER;
      hash = (53 * hash) + getRateLimits().hashCode();
    }
    if (hasRetryConfig()) {
      hash = (37 * hash) + RETRY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRetryConfig().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasPurgeTime()) {
      hash = (37 * hash) + PURGE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getPurgeTime().hashCode();
    }
    if (hasTaskTtl()) {
      hash = (37 * hash) + TASK_TTL_FIELD_NUMBER;
      hash = (53 * hash) + getTaskTtl().hashCode();
    }
    if (hasTombstoneTtl()) {
      hash = (37 * hash) + TOMBSTONE_TTL_FIELD_NUMBER;
      hash = (53 * hash) + getTombstoneTtl().hashCode();
    }
    if (hasStats()) {
      hash = (37 * hash) + STATS_FIELD_NUMBER;
      hash = (53 * hash) + getStats().hashCode();
    }
    switch (targetTypeCase_) {
      case 3:
        hash = (37 * hash) + APP_ENGINE_HTTP_TARGET_FIELD_NUMBER;
        hash = (53 * hash) + getAppEngineHttpTarget().hashCode();
        break;
      case 4:
        hash = (37 * hash) + PULL_TARGET_FIELD_NUMBER;
        hash = (53 * hash) + getPullTarget().hashCode();
        break;
      case 17:
        hash = (37 * hash) + HTTP_TARGET_FIELD_NUMBER;
        hash = (53 * hash) + getHttpTarget().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.tasks.v2beta2.Queue parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta2.Queue parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta2.Queue parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta2.Queue parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta2.Queue parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta2.Queue parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta2.Queue parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta2.Queue parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta2.Queue parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta2.Queue parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta2.Queue parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta2.Queue parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.tasks.v2beta2.Queue prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A queue is a container of related tasks. Queues are configured to manage
   * how those tasks are dispatched. Configurable properties include rate limits,
   * retry options, target types, and others.
   * </pre>
   *
   * Protobuf type {@code google.cloud.tasks.v2beta2.Queue}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.tasks.v2beta2.Queue)
      com.google.cloud.tasks.v2beta2.QueueOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.tasks.v2beta2.QueueProto
          .internal_static_google_cloud_tasks_v2beta2_Queue_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.tasks.v2beta2.QueueProto
          .internal_static_google_cloud_tasks_v2beta2_Queue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.tasks.v2beta2.Queue.class,
              com.google.cloud.tasks.v2beta2.Queue.Builder.class);
    }

    // Construct using com.google.cloud.tasks.v2beta2.Queue.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getRateLimitsFieldBuilder();
        getRetryConfigFieldBuilder();
        getPurgeTimeFieldBuilder();
        getTaskTtlFieldBuilder();
        getTombstoneTtlFieldBuilder();
        getStatsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      if (appEngineHttpTargetBuilder_ != null) {
        appEngineHttpTargetBuilder_.clear();
      }
      if (pullTargetBuilder_ != null) {
        pullTargetBuilder_.clear();
      }
      if (httpTargetBuilder_ != null) {
        httpTargetBuilder_.clear();
      }
      rateLimits_ = null;
      if (rateLimitsBuilder_ != null) {
        rateLimitsBuilder_.dispose();
        rateLimitsBuilder_ = null;
      }
      retryConfig_ = null;
      if (retryConfigBuilder_ != null) {
        retryConfigBuilder_.dispose();
        retryConfigBuilder_ = null;
      }
      state_ = 0;
      purgeTime_ = null;
      if (purgeTimeBuilder_ != null) {
        purgeTimeBuilder_.dispose();
        purgeTimeBuilder_ = null;
      }
      taskTtl_ = null;
      if (taskTtlBuilder_ != null) {
        taskTtlBuilder_.dispose();
        taskTtlBuilder_ = null;
      }
      tombstoneTtl_ = null;
      if (tombstoneTtlBuilder_ != null) {
        tombstoneTtlBuilder_.dispose();
        tombstoneTtlBuilder_ = null;
      }
      stats_ = null;
      if (statsBuilder_ != null) {
        statsBuilder_.dispose();
        statsBuilder_ = null;
      }
      targetTypeCase_ = 0;
      targetType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.tasks.v2beta2.QueueProto
          .internal_static_google_cloud_tasks_v2beta2_Queue_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta2.Queue getDefaultInstanceForType() {
      return com.google.cloud.tasks.v2beta2.Queue.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta2.Queue build() {
      com.google.cloud.tasks.v2beta2.Queue result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta2.Queue buildPartial() {
      com.google.cloud.tasks.v2beta2.Queue result = new com.google.cloud.tasks.v2beta2.Queue(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.tasks.v2beta2.Queue result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.rateLimits_ = rateLimitsBuilder_ == null ? rateLimits_ : rateLimitsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.retryConfig_ =
            retryConfigBuilder_ == null ? retryConfig_ : retryConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.purgeTime_ = purgeTimeBuilder_ == null ? purgeTime_ : purgeTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.taskTtl_ = taskTtlBuilder_ == null ? taskTtl_ : taskTtlBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.tombstoneTtl_ =
            tombstoneTtlBuilder_ == null ? tombstoneTtl_ : tombstoneTtlBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.stats_ = statsBuilder_ == null ? stats_ : statsBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.tasks.v2beta2.Queue result) {
      result.targetTypeCase_ = targetTypeCase_;
      result.targetType_ = this.targetType_;
      if (targetTypeCase_ == 3 && appEngineHttpTargetBuilder_ != null) {
        result.targetType_ = appEngineHttpTargetBuilder_.build();
      }
      if (targetTypeCase_ == 4 && pullTargetBuilder_ != null) {
        result.targetType_ = pullTargetBuilder_.build();
      }
      if (targetTypeCase_ == 17 && httpTargetBuilder_ != null) {
        result.targetType_ = httpTargetBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.tasks.v2beta2.Queue) {
        return mergeFrom((com.google.cloud.tasks.v2beta2.Queue) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.tasks.v2beta2.Queue other) {
      if (other == com.google.cloud.tasks.v2beta2.Queue.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasRateLimits()) {
        mergeRateLimits(other.getRateLimits());
      }
      if (other.hasRetryConfig()) {
        mergeRetryConfig(other.getRetryConfig());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasPurgeTime()) {
        mergePurgeTime(other.getPurgeTime());
      }
      if (other.hasTaskTtl()) {
        mergeTaskTtl(other.getTaskTtl());
      }
      if (other.hasTombstoneTtl()) {
        mergeTombstoneTtl(other.getTombstoneTtl());
      }
      if (other.hasStats()) {
        mergeStats(other.getStats());
      }
      switch (other.getTargetTypeCase()) {
        case APP_ENGINE_HTTP_TARGET:
          {
            mergeAppEngineHttpTarget(other.getAppEngineHttpTarget());
            break;
          }
        case PULL_TARGET:
          {
            mergePullTarget(other.getPullTarget());
            break;
          }
        case HTTP_TARGET:
          {
            mergeHttpTarget(other.getHttpTarget());
            break;
          }
        case TARGETTYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(
                    getAppEngineHttpTargetFieldBuilder().getBuilder(), extensionRegistry);
                targetTypeCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getPullTargetFieldBuilder().getBuilder(), extensionRegistry);
                targetTypeCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getRateLimitsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getRetryConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 56:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 66:
              {
                input.readMessage(getPurgeTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getTaskTtlFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getTombstoneTtlFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 130:
              {
                input.readMessage(getStatsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 130
            case 138:
              {
                input.readMessage(getHttpTargetFieldBuilder().getBuilder(), extensionRegistry);
                targetTypeCase_ = 17;
                break;
              } // case 138
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int targetTypeCase_ = 0;
    private java.lang.Object targetType_;

    public TargetTypeCase getTargetTypeCase() {
      return TargetTypeCase.forNumber(targetTypeCase_);
    }

    public Builder clearTargetType() {
      targetTypeCase_ = 0;
      targetType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Caller-specified and required in
     * [CreateQueue][google.cloud.tasks.v2beta2.CloudTasks.CreateQueue], after
     * which it becomes output only.
     *
     * The queue name.
     *
     * The queue name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     *
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the queue's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Caller-specified and required in
     * [CreateQueue][google.cloud.tasks.v2beta2.CloudTasks.CreateQueue], after
     * which it becomes output only.
     *
     * The queue name.
     *
     * The queue name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     *
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the queue's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Caller-specified and required in
     * [CreateQueue][google.cloud.tasks.v2beta2.CloudTasks.CreateQueue], after
     * which it becomes output only.
     *
     * The queue name.
     *
     * The queue name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     *
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the queue's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Caller-specified and required in
     * [CreateQueue][google.cloud.tasks.v2beta2.CloudTasks.CreateQueue], after
     * which it becomes output only.
     *
     * The queue name.
     *
     * The queue name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     *
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the queue's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Caller-specified and required in
     * [CreateQueue][google.cloud.tasks.v2beta2.CloudTasks.CreateQueue], after
     * which it becomes output only.
     *
     * The queue name.
     *
     * The queue name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     *
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the queue's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta2.AppEngineHttpTarget,
            com.google.cloud.tasks.v2beta2.AppEngineHttpTarget.Builder,
            com.google.cloud.tasks.v2beta2.AppEngineHttpTargetOrBuilder>
        appEngineHttpTargetBuilder_;
    /**
     *
     *
     * <pre>
     * App Engine HTTP target.
     *
     * An App Engine queue is a queue that has an
     * [AppEngineHttpTarget][google.cloud.tasks.v2beta2.AppEngineHttpTarget].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.AppEngineHttpTarget app_engine_http_target = 3;</code>
     *
     * @return Whether the appEngineHttpTarget field is set.
     */
    @java.lang.Override
    public boolean hasAppEngineHttpTarget() {
      return targetTypeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * App Engine HTTP target.
     *
     * An App Engine queue is a queue that has an
     * [AppEngineHttpTarget][google.cloud.tasks.v2beta2.AppEngineHttpTarget].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.AppEngineHttpTarget app_engine_http_target = 3;</code>
     *
     * @return The appEngineHttpTarget.
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2beta2.AppEngineHttpTarget getAppEngineHttpTarget() {
      if (appEngineHttpTargetBuilder_ == null) {
        if (targetTypeCase_ == 3) {
          return (com.google.cloud.tasks.v2beta2.AppEngineHttpTarget) targetType_;
        }
        return com.google.cloud.tasks.v2beta2.AppEngineHttpTarget.getDefaultInstance();
      } else {
        if (targetTypeCase_ == 3) {
          return appEngineHttpTargetBuilder_.getMessage();
        }
        return com.google.cloud.tasks.v2beta2.AppEngineHttpTarget.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * App Engine HTTP target.
     *
     * An App Engine queue is a queue that has an
     * [AppEngineHttpTarget][google.cloud.tasks.v2beta2.AppEngineHttpTarget].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.AppEngineHttpTarget app_engine_http_target = 3;</code>
     */
    public Builder setAppEngineHttpTarget(
        com.google.cloud.tasks.v2beta2.AppEngineHttpTarget value) {
      if (appEngineHttpTargetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        targetType_ = value;
        onChanged();
      } else {
        appEngineHttpTargetBuilder_.setMessage(value);
      }
      targetTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * App Engine HTTP target.
     *
     * An App Engine queue is a queue that has an
     * [AppEngineHttpTarget][google.cloud.tasks.v2beta2.AppEngineHttpTarget].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.AppEngineHttpTarget app_engine_http_target = 3;</code>
     */
    public Builder setAppEngineHttpTarget(
        com.google.cloud.tasks.v2beta2.AppEngineHttpTarget.Builder builderForValue) {
      if (appEngineHttpTargetBuilder_ == null) {
        targetType_ = builderForValue.build();
        onChanged();
      } else {
        appEngineHttpTargetBuilder_.setMessage(builderForValue.build());
      }
      targetTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * App Engine HTTP target.
     *
     * An App Engine queue is a queue that has an
     * [AppEngineHttpTarget][google.cloud.tasks.v2beta2.AppEngineHttpTarget].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.AppEngineHttpTarget app_engine_http_target = 3;</code>
     */
    public Builder mergeAppEngineHttpTarget(
        com.google.cloud.tasks.v2beta2.AppEngineHttpTarget value) {
      if (appEngineHttpTargetBuilder_ == null) {
        if (targetTypeCase_ == 3
            && targetType_
                != com.google.cloud.tasks.v2beta2.AppEngineHttpTarget.getDefaultInstance()) {
          targetType_ =
              com.google.cloud.tasks.v2beta2.AppEngineHttpTarget.newBuilder(
                      (com.google.cloud.tasks.v2beta2.AppEngineHttpTarget) targetType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          targetType_ = value;
        }
        onChanged();
      } else {
        if (targetTypeCase_ == 3) {
          appEngineHttpTargetBuilder_.mergeFrom(value);
        } else {
          appEngineHttpTargetBuilder_.setMessage(value);
        }
      }
      targetTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * App Engine HTTP target.
     *
     * An App Engine queue is a queue that has an
     * [AppEngineHttpTarget][google.cloud.tasks.v2beta2.AppEngineHttpTarget].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.AppEngineHttpTarget app_engine_http_target = 3;</code>
     */
    public Builder clearAppEngineHttpTarget() {
      if (appEngineHttpTargetBuilder_ == null) {
        if (targetTypeCase_ == 3) {
          targetTypeCase_ = 0;
          targetType_ = null;
          onChanged();
        }
      } else {
        if (targetTypeCase_ == 3) {
          targetTypeCase_ = 0;
          targetType_ = null;
        }
        appEngineHttpTargetBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * App Engine HTTP target.
     *
     * An App Engine queue is a queue that has an
     * [AppEngineHttpTarget][google.cloud.tasks.v2beta2.AppEngineHttpTarget].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.AppEngineHttpTarget app_engine_http_target = 3;</code>
     */
    public com.google.cloud.tasks.v2beta2.AppEngineHttpTarget.Builder
        getAppEngineHttpTargetBuilder() {
      return getAppEngineHttpTargetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * App Engine HTTP target.
     *
     * An App Engine queue is a queue that has an
     * [AppEngineHttpTarget][google.cloud.tasks.v2beta2.AppEngineHttpTarget].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.AppEngineHttpTarget app_engine_http_target = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2beta2.AppEngineHttpTargetOrBuilder
        getAppEngineHttpTargetOrBuilder() {
      if ((targetTypeCase_ == 3) && (appEngineHttpTargetBuilder_ != null)) {
        return appEngineHttpTargetBuilder_.getMessageOrBuilder();
      } else {
        if (targetTypeCase_ == 3) {
          return (com.google.cloud.tasks.v2beta2.AppEngineHttpTarget) targetType_;
        }
        return com.google.cloud.tasks.v2beta2.AppEngineHttpTarget.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * App Engine HTTP target.
     *
     * An App Engine queue is a queue that has an
     * [AppEngineHttpTarget][google.cloud.tasks.v2beta2.AppEngineHttpTarget].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.AppEngineHttpTarget app_engine_http_target = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta2.AppEngineHttpTarget,
            com.google.cloud.tasks.v2beta2.AppEngineHttpTarget.Builder,
            com.google.cloud.tasks.v2beta2.AppEngineHttpTargetOrBuilder>
        getAppEngineHttpTargetFieldBuilder() {
      if (appEngineHttpTargetBuilder_ == null) {
        if (!(targetTypeCase_ == 3)) {
          targetType_ = com.google.cloud.tasks.v2beta2.AppEngineHttpTarget.getDefaultInstance();
        }
        appEngineHttpTargetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2beta2.AppEngineHttpTarget,
                com.google.cloud.tasks.v2beta2.AppEngineHttpTarget.Builder,
                com.google.cloud.tasks.v2beta2.AppEngineHttpTargetOrBuilder>(
                (com.google.cloud.tasks.v2beta2.AppEngineHttpTarget) targetType_,
                getParentForChildren(),
                isClean());
        targetType_ = null;
      }
      targetTypeCase_ = 3;
      onChanged();
      return appEngineHttpTargetBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta2.PullTarget,
            com.google.cloud.tasks.v2beta2.PullTarget.Builder,
            com.google.cloud.tasks.v2beta2.PullTargetOrBuilder>
        pullTargetBuilder_;
    /**
     *
     *
     * <pre>
     * Pull target.
     *
     * A pull queue is a queue that has a
     * [PullTarget][google.cloud.tasks.v2beta2.PullTarget].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.PullTarget pull_target = 4;</code>
     *
     * @return Whether the pullTarget field is set.
     */
    @java.lang.Override
    public boolean hasPullTarget() {
      return targetTypeCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * Pull target.
     *
     * A pull queue is a queue that has a
     * [PullTarget][google.cloud.tasks.v2beta2.PullTarget].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.PullTarget pull_target = 4;</code>
     *
     * @return The pullTarget.
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2beta2.PullTarget getPullTarget() {
      if (pullTargetBuilder_ == null) {
        if (targetTypeCase_ == 4) {
          return (com.google.cloud.tasks.v2beta2.PullTarget) targetType_;
        }
        return com.google.cloud.tasks.v2beta2.PullTarget.getDefaultInstance();
      } else {
        if (targetTypeCase_ == 4) {
          return pullTargetBuilder_.getMessage();
        }
        return com.google.cloud.tasks.v2beta2.PullTarget.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Pull target.
     *
     * A pull queue is a queue that has a
     * [PullTarget][google.cloud.tasks.v2beta2.PullTarget].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.PullTarget pull_target = 4;</code>
     */
    public Builder setPullTarget(com.google.cloud.tasks.v2beta2.PullTarget value) {
      if (pullTargetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        targetType_ = value;
        onChanged();
      } else {
        pullTargetBuilder_.setMessage(value);
      }
      targetTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pull target.
     *
     * A pull queue is a queue that has a
     * [PullTarget][google.cloud.tasks.v2beta2.PullTarget].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.PullTarget pull_target = 4;</code>
     */
    public Builder setPullTarget(
        com.google.cloud.tasks.v2beta2.PullTarget.Builder builderForValue) {
      if (pullTargetBuilder_ == null) {
        targetType_ = builderForValue.build();
        onChanged();
      } else {
        pullTargetBuilder_.setMessage(builderForValue.build());
      }
      targetTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pull target.
     *
     * A pull queue is a queue that has a
     * [PullTarget][google.cloud.tasks.v2beta2.PullTarget].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.PullTarget pull_target = 4;</code>
     */
    public Builder mergePullTarget(com.google.cloud.tasks.v2beta2.PullTarget value) {
      if (pullTargetBuilder_ == null) {
        if (targetTypeCase_ == 4
            && targetType_ != com.google.cloud.tasks.v2beta2.PullTarget.getDefaultInstance()) {
          targetType_ =
              com.google.cloud.tasks.v2beta2.PullTarget.newBuilder(
                      (com.google.cloud.tasks.v2beta2.PullTarget) targetType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          targetType_ = value;
        }
        onChanged();
      } else {
        if (targetTypeCase_ == 4) {
          pullTargetBuilder_.mergeFrom(value);
        } else {
          pullTargetBuilder_.setMessage(value);
        }
      }
      targetTypeCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pull target.
     *
     * A pull queue is a queue that has a
     * [PullTarget][google.cloud.tasks.v2beta2.PullTarget].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.PullTarget pull_target = 4;</code>
     */
    public Builder clearPullTarget() {
      if (pullTargetBuilder_ == null) {
        if (targetTypeCase_ == 4) {
          targetTypeCase_ = 0;
          targetType_ = null;
          onChanged();
        }
      } else {
        if (targetTypeCase_ == 4) {
          targetTypeCase_ = 0;
          targetType_ = null;
        }
        pullTargetBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pull target.
     *
     * A pull queue is a queue that has a
     * [PullTarget][google.cloud.tasks.v2beta2.PullTarget].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.PullTarget pull_target = 4;</code>
     */
    public com.google.cloud.tasks.v2beta2.PullTarget.Builder getPullTargetBuilder() {
      return getPullTargetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Pull target.
     *
     * A pull queue is a queue that has a
     * [PullTarget][google.cloud.tasks.v2beta2.PullTarget].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.PullTarget pull_target = 4;</code>
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2beta2.PullTargetOrBuilder getPullTargetOrBuilder() {
      if ((targetTypeCase_ == 4) && (pullTargetBuilder_ != null)) {
        return pullTargetBuilder_.getMessageOrBuilder();
      } else {
        if (targetTypeCase_ == 4) {
          return (com.google.cloud.tasks.v2beta2.PullTarget) targetType_;
        }
        return com.google.cloud.tasks.v2beta2.PullTarget.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Pull target.
     *
     * A pull queue is a queue that has a
     * [PullTarget][google.cloud.tasks.v2beta2.PullTarget].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.PullTarget pull_target = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta2.PullTarget,
            com.google.cloud.tasks.v2beta2.PullTarget.Builder,
            com.google.cloud.tasks.v2beta2.PullTargetOrBuilder>
        getPullTargetFieldBuilder() {
      if (pullTargetBuilder_ == null) {
        if (!(targetTypeCase_ == 4)) {
          targetType_ = com.google.cloud.tasks.v2beta2.PullTarget.getDefaultInstance();
        }
        pullTargetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2beta2.PullTarget,
                com.google.cloud.tasks.v2beta2.PullTarget.Builder,
                com.google.cloud.tasks.v2beta2.PullTargetOrBuilder>(
                (com.google.cloud.tasks.v2beta2.PullTarget) targetType_,
                getParentForChildren(),
                isClean());
        targetType_ = null;
      }
      targetTypeCase_ = 4;
      onChanged();
      return pullTargetBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta2.HttpTarget,
            com.google.cloud.tasks.v2beta2.HttpTarget.Builder,
            com.google.cloud.tasks.v2beta2.HttpTargetOrBuilder>
        httpTargetBuilder_;
    /**
     *
     *
     * <pre>
     * An http_target is used to override the target values for HTTP tasks.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.HttpTarget http_target = 17;</code>
     *
     * @return Whether the httpTarget field is set.
     */
    @java.lang.Override
    public boolean hasHttpTarget() {
      return targetTypeCase_ == 17;
    }
    /**
     *
     *
     * <pre>
     * An http_target is used to override the target values for HTTP tasks.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.HttpTarget http_target = 17;</code>
     *
     * @return The httpTarget.
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2beta2.HttpTarget getHttpTarget() {
      if (httpTargetBuilder_ == null) {
        if (targetTypeCase_ == 17) {
          return (com.google.cloud.tasks.v2beta2.HttpTarget) targetType_;
        }
        return com.google.cloud.tasks.v2beta2.HttpTarget.getDefaultInstance();
      } else {
        if (targetTypeCase_ == 17) {
          return httpTargetBuilder_.getMessage();
        }
        return com.google.cloud.tasks.v2beta2.HttpTarget.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An http_target is used to override the target values for HTTP tasks.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.HttpTarget http_target = 17;</code>
     */
    public Builder setHttpTarget(com.google.cloud.tasks.v2beta2.HttpTarget value) {
      if (httpTargetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        targetType_ = value;
        onChanged();
      } else {
        httpTargetBuilder_.setMessage(value);
      }
      targetTypeCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An http_target is used to override the target values for HTTP tasks.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.HttpTarget http_target = 17;</code>
     */
    public Builder setHttpTarget(
        com.google.cloud.tasks.v2beta2.HttpTarget.Builder builderForValue) {
      if (httpTargetBuilder_ == null) {
        targetType_ = builderForValue.build();
        onChanged();
      } else {
        httpTargetBuilder_.setMessage(builderForValue.build());
      }
      targetTypeCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An http_target is used to override the target values for HTTP tasks.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.HttpTarget http_target = 17;</code>
     */
    public Builder mergeHttpTarget(com.google.cloud.tasks.v2beta2.HttpTarget value) {
      if (httpTargetBuilder_ == null) {
        if (targetTypeCase_ == 17
            && targetType_ != com.google.cloud.tasks.v2beta2.HttpTarget.getDefaultInstance()) {
          targetType_ =
              com.google.cloud.tasks.v2beta2.HttpTarget.newBuilder(
                      (com.google.cloud.tasks.v2beta2.HttpTarget) targetType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          targetType_ = value;
        }
        onChanged();
      } else {
        if (targetTypeCase_ == 17) {
          httpTargetBuilder_.mergeFrom(value);
        } else {
          httpTargetBuilder_.setMessage(value);
        }
      }
      targetTypeCase_ = 17;
      return this;
    }
    /**
     *
     *
     * <pre>
     * An http_target is used to override the target values for HTTP tasks.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.HttpTarget http_target = 17;</code>
     */
    public Builder clearHttpTarget() {
      if (httpTargetBuilder_ == null) {
        if (targetTypeCase_ == 17) {
          targetTypeCase_ = 0;
          targetType_ = null;
          onChanged();
        }
      } else {
        if (targetTypeCase_ == 17) {
          targetTypeCase_ = 0;
          targetType_ = null;
        }
        httpTargetBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * An http_target is used to override the target values for HTTP tasks.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.HttpTarget http_target = 17;</code>
     */
    public com.google.cloud.tasks.v2beta2.HttpTarget.Builder getHttpTargetBuilder() {
      return getHttpTargetFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * An http_target is used to override the target values for HTTP tasks.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.HttpTarget http_target = 17;</code>
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2beta2.HttpTargetOrBuilder getHttpTargetOrBuilder() {
      if ((targetTypeCase_ == 17) && (httpTargetBuilder_ != null)) {
        return httpTargetBuilder_.getMessageOrBuilder();
      } else {
        if (targetTypeCase_ == 17) {
          return (com.google.cloud.tasks.v2beta2.HttpTarget) targetType_;
        }
        return com.google.cloud.tasks.v2beta2.HttpTarget.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * An http_target is used to override the target values for HTTP tasks.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.HttpTarget http_target = 17;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta2.HttpTarget,
            com.google.cloud.tasks.v2beta2.HttpTarget.Builder,
            com.google.cloud.tasks.v2beta2.HttpTargetOrBuilder>
        getHttpTargetFieldBuilder() {
      if (httpTargetBuilder_ == null) {
        if (!(targetTypeCase_ == 17)) {
          targetType_ = com.google.cloud.tasks.v2beta2.HttpTarget.getDefaultInstance();
        }
        httpTargetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2beta2.HttpTarget,
                com.google.cloud.tasks.v2beta2.HttpTarget.Builder,
                com.google.cloud.tasks.v2beta2.HttpTargetOrBuilder>(
                (com.google.cloud.tasks.v2beta2.HttpTarget) targetType_,
                getParentForChildren(),
                isClean());
        targetType_ = null;
      }
      targetTypeCase_ = 17;
      onChanged();
      return httpTargetBuilder_;
    }

    private com.google.cloud.tasks.v2beta2.RateLimits rateLimits_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta2.RateLimits,
            com.google.cloud.tasks.v2beta2.RateLimits.Builder,
            com.google.cloud.tasks.v2beta2.RateLimitsOrBuilder>
        rateLimitsBuilder_;
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     *
     * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] and
     * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] are related
     * because they both control task attempts however they control how tasks are
     * attempted in different ways:
     *
     * * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] controls the
     * total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     * what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     *   task retries (the second attempt, third attempt, etc).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.RateLimits rate_limits = 5;</code>
     *
     * @return Whether the rateLimits field is set.
     */
    public boolean hasRateLimits() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     *
     * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] and
     * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] are related
     * because they both control task attempts however they control how tasks are
     * attempted in different ways:
     *
     * * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] controls the
     * total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     * what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     *   task retries (the second attempt, third attempt, etc).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.RateLimits rate_limits = 5;</code>
     *
     * @return The rateLimits.
     */
    public com.google.cloud.tasks.v2beta2.RateLimits getRateLimits() {
      if (rateLimitsBuilder_ == null) {
        return rateLimits_ == null
            ? com.google.cloud.tasks.v2beta2.RateLimits.getDefaultInstance()
            : rateLimits_;
      } else {
        return rateLimitsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     *
     * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] and
     * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] are related
     * because they both control task attempts however they control how tasks are
     * attempted in different ways:
     *
     * * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] controls the
     * total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     * what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     *   task retries (the second attempt, third attempt, etc).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.RateLimits rate_limits = 5;</code>
     */
    public Builder setRateLimits(com.google.cloud.tasks.v2beta2.RateLimits value) {
      if (rateLimitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rateLimits_ = value;
      } else {
        rateLimitsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     *
     * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] and
     * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] are related
     * because they both control task attempts however they control how tasks are
     * attempted in different ways:
     *
     * * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] controls the
     * total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     * what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     *   task retries (the second attempt, third attempt, etc).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.RateLimits rate_limits = 5;</code>
     */
    public Builder setRateLimits(
        com.google.cloud.tasks.v2beta2.RateLimits.Builder builderForValue) {
      if (rateLimitsBuilder_ == null) {
        rateLimits_ = builderForValue.build();
      } else {
        rateLimitsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     *
     * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] and
     * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] are related
     * because they both control task attempts however they control how tasks are
     * attempted in different ways:
     *
     * * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] controls the
     * total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     * what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     *   task retries (the second attempt, third attempt, etc).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.RateLimits rate_limits = 5;</code>
     */
    public Builder mergeRateLimits(com.google.cloud.tasks.v2beta2.RateLimits value) {
      if (rateLimitsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && rateLimits_ != null
            && rateLimits_ != com.google.cloud.tasks.v2beta2.RateLimits.getDefaultInstance()) {
          getRateLimitsBuilder().mergeFrom(value);
        } else {
          rateLimits_ = value;
        }
      } else {
        rateLimitsBuilder_.mergeFrom(value);
      }
      if (rateLimits_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     *
     * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] and
     * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] are related
     * because they both control task attempts however they control how tasks are
     * attempted in different ways:
     *
     * * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] controls the
     * total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     * what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     *   task retries (the second attempt, third attempt, etc).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.RateLimits rate_limits = 5;</code>
     */
    public Builder clearRateLimits() {
      bitField0_ = (bitField0_ & ~0x00000010);
      rateLimits_ = null;
      if (rateLimitsBuilder_ != null) {
        rateLimitsBuilder_.dispose();
        rateLimitsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     *
     * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] and
     * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] are related
     * because they both control task attempts however they control how tasks are
     * attempted in different ways:
     *
     * * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] controls the
     * total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     * what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     *   task retries (the second attempt, third attempt, etc).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.RateLimits rate_limits = 5;</code>
     */
    public com.google.cloud.tasks.v2beta2.RateLimits.Builder getRateLimitsBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getRateLimitsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     *
     * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] and
     * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] are related
     * because they both control task attempts however they control how tasks are
     * attempted in different ways:
     *
     * * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] controls the
     * total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     * what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     *   task retries (the second attempt, third attempt, etc).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.RateLimits rate_limits = 5;</code>
     */
    public com.google.cloud.tasks.v2beta2.RateLimitsOrBuilder getRateLimitsOrBuilder() {
      if (rateLimitsBuilder_ != null) {
        return rateLimitsBuilder_.getMessageOrBuilder();
      } else {
        return rateLimits_ == null
            ? com.google.cloud.tasks.v2beta2.RateLimits.getDefaultInstance()
            : rateLimits_;
      }
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     *
     * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] and
     * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] are related
     * because they both control task attempts however they control how tasks are
     * attempted in different ways:
     *
     * * [rate_limits][google.cloud.tasks.v2beta2.Queue.rate_limits] controls the
     * total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     * what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta2.Queue.retry_config] controls
     *   task retries (the second attempt, third attempt, etc).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.RateLimits rate_limits = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta2.RateLimits,
            com.google.cloud.tasks.v2beta2.RateLimits.Builder,
            com.google.cloud.tasks.v2beta2.RateLimitsOrBuilder>
        getRateLimitsFieldBuilder() {
      if (rateLimitsBuilder_ == null) {
        rateLimitsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2beta2.RateLimits,
                com.google.cloud.tasks.v2beta2.RateLimits.Builder,
                com.google.cloud.tasks.v2beta2.RateLimitsOrBuilder>(
                getRateLimits(), getParentForChildren(), isClean());
        rateLimits_ = null;
      }
      return rateLimitsBuilder_;
    }

    private com.google.cloud.tasks.v2beta2.RetryConfig retryConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta2.RetryConfig,
            com.google.cloud.tasks.v2beta2.RetryConfig.Builder,
            com.google.cloud.tasks.v2beta2.RetryConfigOrBuilder>
        retryConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     *
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.RetryConfig retry_config = 6;</code>
     *
     * @return Whether the retryConfig field is set.
     */
    public boolean hasRetryConfig() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     *
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.RetryConfig retry_config = 6;</code>
     *
     * @return The retryConfig.
     */
    public com.google.cloud.tasks.v2beta2.RetryConfig getRetryConfig() {
      if (retryConfigBuilder_ == null) {
        return retryConfig_ == null
            ? com.google.cloud.tasks.v2beta2.RetryConfig.getDefaultInstance()
            : retryConfig_;
      } else {
        return retryConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     *
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.RetryConfig retry_config = 6;</code>
     */
    public Builder setRetryConfig(com.google.cloud.tasks.v2beta2.RetryConfig value) {
      if (retryConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retryConfig_ = value;
      } else {
        retryConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     *
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.RetryConfig retry_config = 6;</code>
     */
    public Builder setRetryConfig(
        com.google.cloud.tasks.v2beta2.RetryConfig.Builder builderForValue) {
      if (retryConfigBuilder_ == null) {
        retryConfig_ = builderForValue.build();
      } else {
        retryConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     *
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.RetryConfig retry_config = 6;</code>
     */
    public Builder mergeRetryConfig(com.google.cloud.tasks.v2beta2.RetryConfig value) {
      if (retryConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && retryConfig_ != null
            && retryConfig_ != com.google.cloud.tasks.v2beta2.RetryConfig.getDefaultInstance()) {
          getRetryConfigBuilder().mergeFrom(value);
        } else {
          retryConfig_ = value;
        }
      } else {
        retryConfigBuilder_.mergeFrom(value);
      }
      if (retryConfig_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     *
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.RetryConfig retry_config = 6;</code>
     */
    public Builder clearRetryConfig() {
      bitField0_ = (bitField0_ & ~0x00000020);
      retryConfig_ = null;
      if (retryConfigBuilder_ != null) {
        retryConfigBuilder_.dispose();
        retryConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     *
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.RetryConfig retry_config = 6;</code>
     */
    public com.google.cloud.tasks.v2beta2.RetryConfig.Builder getRetryConfigBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getRetryConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     *
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.RetryConfig retry_config = 6;</code>
     */
    public com.google.cloud.tasks.v2beta2.RetryConfigOrBuilder getRetryConfigOrBuilder() {
      if (retryConfigBuilder_ != null) {
        return retryConfigBuilder_.getMessageOrBuilder();
      } else {
        return retryConfig_ == null
            ? com.google.cloud.tasks.v2beta2.RetryConfig.getDefaultInstance()
            : retryConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     *
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.RetryConfig retry_config = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta2.RetryConfig,
            com.google.cloud.tasks.v2beta2.RetryConfig.Builder,
            com.google.cloud.tasks.v2beta2.RetryConfigOrBuilder>
        getRetryConfigFieldBuilder() {
      if (retryConfigBuilder_ == null) {
        retryConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2beta2.RetryConfig,
                com.google.cloud.tasks.v2beta2.RetryConfig.Builder,
                com.google.cloud.tasks.v2beta2.RetryConfigOrBuilder>(
                getRetryConfig(), getParentForChildren(), isClean());
        retryConfig_ = null;
      }
      return retryConfigBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of the queue.
     *
     * `state` can only be changed by called
     * [PauseQueue][google.cloud.tasks.v2beta2.CloudTasks.PauseQueue],
     * [ResumeQueue][google.cloud.tasks.v2beta2.CloudTasks.ResumeQueue], or
     * uploading
     * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     * [UpdateQueue][google.cloud.tasks.v2beta2.CloudTasks.UpdateQueue] cannot be
     * used to change `state`.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.Queue.State state = 7;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the queue.
     *
     * `state` can only be changed by called
     * [PauseQueue][google.cloud.tasks.v2beta2.CloudTasks.PauseQueue],
     * [ResumeQueue][google.cloud.tasks.v2beta2.CloudTasks.ResumeQueue], or
     * uploading
     * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     * [UpdateQueue][google.cloud.tasks.v2beta2.CloudTasks.UpdateQueue] cannot be
     * used to change `state`.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.Queue.State state = 7;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the queue.
     *
     * `state` can only be changed by called
     * [PauseQueue][google.cloud.tasks.v2beta2.CloudTasks.PauseQueue],
     * [ResumeQueue][google.cloud.tasks.v2beta2.CloudTasks.ResumeQueue], or
     * uploading
     * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     * [UpdateQueue][google.cloud.tasks.v2beta2.CloudTasks.UpdateQueue] cannot be
     * used to change `state`.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.Queue.State state = 7;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2beta2.Queue.State getState() {
      com.google.cloud.tasks.v2beta2.Queue.State result =
          com.google.cloud.tasks.v2beta2.Queue.State.forNumber(state_);
      return result == null ? com.google.cloud.tasks.v2beta2.Queue.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the queue.
     *
     * `state` can only be changed by called
     * [PauseQueue][google.cloud.tasks.v2beta2.CloudTasks.PauseQueue],
     * [ResumeQueue][google.cloud.tasks.v2beta2.CloudTasks.ResumeQueue], or
     * uploading
     * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     * [UpdateQueue][google.cloud.tasks.v2beta2.CloudTasks.UpdateQueue] cannot be
     * used to change `state`.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.Queue.State state = 7;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.tasks.v2beta2.Queue.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the queue.
     *
     * `state` can only be changed by called
     * [PauseQueue][google.cloud.tasks.v2beta2.CloudTasks.PauseQueue],
     * [ResumeQueue][google.cloud.tasks.v2beta2.CloudTasks.ResumeQueue], or
     * uploading
     * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     * [UpdateQueue][google.cloud.tasks.v2beta2.CloudTasks.UpdateQueue] cannot be
     * used to change `state`.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta2.Queue.State state = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000040);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp purgeTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        purgeTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     *
     * All tasks that were [created][google.cloud.tasks.v2beta2.Task.create_time]
     * before this time were purged.
     *
     * A queue can be purged using
     * [PurgeQueue][google.cloud.tasks.v2beta2.CloudTasks.PurgeQueue], the [App
     * Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     *
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 8;</code>
     *
     * @return Whether the purgeTime field is set.
     */
    public boolean hasPurgeTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     *
     * All tasks that were [created][google.cloud.tasks.v2beta2.Task.create_time]
     * before this time were purged.
     *
     * A queue can be purged using
     * [PurgeQueue][google.cloud.tasks.v2beta2.CloudTasks.PurgeQueue], the [App
     * Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     *
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 8;</code>
     *
     * @return The purgeTime.
     */
    public com.google.protobuf.Timestamp getPurgeTime() {
      if (purgeTimeBuilder_ == null) {
        return purgeTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : purgeTime_;
      } else {
        return purgeTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     *
     * All tasks that were [created][google.cloud.tasks.v2beta2.Task.create_time]
     * before this time were purged.
     *
     * A queue can be purged using
     * [PurgeQueue][google.cloud.tasks.v2beta2.CloudTasks.PurgeQueue], the [App
     * Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     *
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 8;</code>
     */
    public Builder setPurgeTime(com.google.protobuf.Timestamp value) {
      if (purgeTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        purgeTime_ = value;
      } else {
        purgeTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     *
     * All tasks that were [created][google.cloud.tasks.v2beta2.Task.create_time]
     * before this time were purged.
     *
     * A queue can be purged using
     * [PurgeQueue][google.cloud.tasks.v2beta2.CloudTasks.PurgeQueue], the [App
     * Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     *
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 8;</code>
     */
    public Builder setPurgeTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (purgeTimeBuilder_ == null) {
        purgeTime_ = builderForValue.build();
      } else {
        purgeTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     *
     * All tasks that were [created][google.cloud.tasks.v2beta2.Task.create_time]
     * before this time were purged.
     *
     * A queue can be purged using
     * [PurgeQueue][google.cloud.tasks.v2beta2.CloudTasks.PurgeQueue], the [App
     * Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     *
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 8;</code>
     */
    public Builder mergePurgeTime(com.google.protobuf.Timestamp value) {
      if (purgeTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && purgeTime_ != null
            && purgeTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getPurgeTimeBuilder().mergeFrom(value);
        } else {
          purgeTime_ = value;
        }
      } else {
        purgeTimeBuilder_.mergeFrom(value);
      }
      if (purgeTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     *
     * All tasks that were [created][google.cloud.tasks.v2beta2.Task.create_time]
     * before this time were purged.
     *
     * A queue can be purged using
     * [PurgeQueue][google.cloud.tasks.v2beta2.CloudTasks.PurgeQueue], the [App
     * Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     *
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 8;</code>
     */
    public Builder clearPurgeTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      purgeTime_ = null;
      if (purgeTimeBuilder_ != null) {
        purgeTimeBuilder_.dispose();
        purgeTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     *
     * All tasks that were [created][google.cloud.tasks.v2beta2.Task.create_time]
     * before this time were purged.
     *
     * A queue can be purged using
     * [PurgeQueue][google.cloud.tasks.v2beta2.CloudTasks.PurgeQueue], the [App
     * Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     *
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 8;</code>
     */
    public com.google.protobuf.Timestamp.Builder getPurgeTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getPurgeTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     *
     * All tasks that were [created][google.cloud.tasks.v2beta2.Task.create_time]
     * before this time were purged.
     *
     * A queue can be purged using
     * [PurgeQueue][google.cloud.tasks.v2beta2.CloudTasks.PurgeQueue], the [App
     * Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     *
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 8;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getPurgeTimeOrBuilder() {
      if (purgeTimeBuilder_ != null) {
        return purgeTimeBuilder_.getMessageOrBuilder();
      } else {
        return purgeTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : purgeTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     *
     * All tasks that were [created][google.cloud.tasks.v2beta2.Task.create_time]
     * before this time were purged.
     *
     * A queue can be purged using
     * [PurgeQueue][google.cloud.tasks.v2beta2.CloudTasks.PurgeQueue], the [App
     * Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     *
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getPurgeTimeFieldBuilder() {
      if (purgeTimeBuilder_ == null) {
        purgeTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getPurgeTime(), getParentForChildren(), isClean());
        purgeTime_ = null;
      }
      return purgeTimeBuilder_;
    }

    private com.google.protobuf.Duration taskTtl_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        taskTtlBuilder_;
    /**
     *
     *
     * <pre>
     * The maximum amount of time that a task will be retained in
     * this queue.
     *
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     *
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     * </pre>
     *
     * <code>.google.protobuf.Duration task_ttl = 9;</code>
     *
     * @return Whether the taskTtl field is set.
     */
    public boolean hasTaskTtl() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time that a task will be retained in
     * this queue.
     *
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     *
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     * </pre>
     *
     * <code>.google.protobuf.Duration task_ttl = 9;</code>
     *
     * @return The taskTtl.
     */
    public com.google.protobuf.Duration getTaskTtl() {
      if (taskTtlBuilder_ == null) {
        return taskTtl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : taskTtl_;
      } else {
        return taskTtlBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time that a task will be retained in
     * this queue.
     *
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     *
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     * </pre>
     *
     * <code>.google.protobuf.Duration task_ttl = 9;</code>
     */
    public Builder setTaskTtl(com.google.protobuf.Duration value) {
      if (taskTtlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        taskTtl_ = value;
      } else {
        taskTtlBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time that a task will be retained in
     * this queue.
     *
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     *
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     * </pre>
     *
     * <code>.google.protobuf.Duration task_ttl = 9;</code>
     */
    public Builder setTaskTtl(com.google.protobuf.Duration.Builder builderForValue) {
      if (taskTtlBuilder_ == null) {
        taskTtl_ = builderForValue.build();
      } else {
        taskTtlBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time that a task will be retained in
     * this queue.
     *
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     *
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     * </pre>
     *
     * <code>.google.protobuf.Duration task_ttl = 9;</code>
     */
    public Builder mergeTaskTtl(com.google.protobuf.Duration value) {
      if (taskTtlBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && taskTtl_ != null
            && taskTtl_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTaskTtlBuilder().mergeFrom(value);
        } else {
          taskTtl_ = value;
        }
      } else {
        taskTtlBuilder_.mergeFrom(value);
      }
      if (taskTtl_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time that a task will be retained in
     * this queue.
     *
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     *
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     * </pre>
     *
     * <code>.google.protobuf.Duration task_ttl = 9;</code>
     */
    public Builder clearTaskTtl() {
      bitField0_ = (bitField0_ & ~0x00000100);
      taskTtl_ = null;
      if (taskTtlBuilder_ != null) {
        taskTtlBuilder_.dispose();
        taskTtlBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time that a task will be retained in
     * this queue.
     *
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     *
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     * </pre>
     *
     * <code>.google.protobuf.Duration task_ttl = 9;</code>
     */
    public com.google.protobuf.Duration.Builder getTaskTtlBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getTaskTtlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time that a task will be retained in
     * this queue.
     *
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     *
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     * </pre>
     *
     * <code>.google.protobuf.Duration task_ttl = 9;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTaskTtlOrBuilder() {
      if (taskTtlBuilder_ != null) {
        return taskTtlBuilder_.getMessageOrBuilder();
      } else {
        return taskTtl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : taskTtl_;
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time that a task will be retained in
     * this queue.
     *
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     *
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     * </pre>
     *
     * <code>.google.protobuf.Duration task_ttl = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTaskTtlFieldBuilder() {
      if (taskTtlBuilder_ == null) {
        taskTtlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTaskTtl(), getParentForChildren(), isClean());
        taskTtl_ = null;
      }
      return taskTtlBuilder_;
    }

    private com.google.protobuf.Duration tombstoneTtl_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        tombstoneTtlBuilder_;
    /**
     *
     *
     * <pre>
     * The task tombstone time to live (TTL).
     *
     * After a task is deleted or completed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta2.CreateTaskRequest.task].
     *
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration tombstone_ttl = 10;</code>
     *
     * @return Whether the tombstoneTtl field is set.
     */
    public boolean hasTombstoneTtl() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * The task tombstone time to live (TTL).
     *
     * After a task is deleted or completed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta2.CreateTaskRequest.task].
     *
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration tombstone_ttl = 10;</code>
     *
     * @return The tombstoneTtl.
     */
    public com.google.protobuf.Duration getTombstoneTtl() {
      if (tombstoneTtlBuilder_ == null) {
        return tombstoneTtl_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : tombstoneTtl_;
      } else {
        return tombstoneTtlBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The task tombstone time to live (TTL).
     *
     * After a task is deleted or completed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta2.CreateTaskRequest.task].
     *
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration tombstone_ttl = 10;</code>
     */
    public Builder setTombstoneTtl(com.google.protobuf.Duration value) {
      if (tombstoneTtlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tombstoneTtl_ = value;
      } else {
        tombstoneTtlBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The task tombstone time to live (TTL).
     *
     * After a task is deleted or completed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta2.CreateTaskRequest.task].
     *
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration tombstone_ttl = 10;</code>
     */
    public Builder setTombstoneTtl(com.google.protobuf.Duration.Builder builderForValue) {
      if (tombstoneTtlBuilder_ == null) {
        tombstoneTtl_ = builderForValue.build();
      } else {
        tombstoneTtlBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The task tombstone time to live (TTL).
     *
     * After a task is deleted or completed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta2.CreateTaskRequest.task].
     *
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration tombstone_ttl = 10;</code>
     */
    public Builder mergeTombstoneTtl(com.google.protobuf.Duration value) {
      if (tombstoneTtlBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && tombstoneTtl_ != null
            && tombstoneTtl_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTombstoneTtlBuilder().mergeFrom(value);
        } else {
          tombstoneTtl_ = value;
        }
      } else {
        tombstoneTtlBuilder_.mergeFrom(value);
      }
      if (tombstoneTtl_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The task tombstone time to live (TTL).
     *
     * After a task is deleted or completed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta2.CreateTaskRequest.task].
     *
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration tombstone_ttl = 10;</code>
     */
    public Builder clearTombstoneTtl() {
      bitField0_ = (bitField0_ & ~0x00000200);
      tombstoneTtl_ = null;
      if (tombstoneTtlBuilder_ != null) {
        tombstoneTtlBuilder_.dispose();
        tombstoneTtlBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The task tombstone time to live (TTL).
     *
     * After a task is deleted or completed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta2.CreateTaskRequest.task].
     *
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration tombstone_ttl = 10;</code>
     */
    public com.google.protobuf.Duration.Builder getTombstoneTtlBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getTombstoneTtlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The task tombstone time to live (TTL).
     *
     * After a task is deleted or completed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta2.CreateTaskRequest.task].
     *
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration tombstone_ttl = 10;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTombstoneTtlOrBuilder() {
      if (tombstoneTtlBuilder_ != null) {
        return tombstoneTtlBuilder_.getMessageOrBuilder();
      } else {
        return tombstoneTtl_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : tombstoneTtl_;
      }
    }
    /**
     *
     *
     * <pre>
     * The task tombstone time to live (TTL).
     *
     * After a task is deleted or completed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta2.CreateTaskRequest.task].
     *
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration tombstone_ttl = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTombstoneTtlFieldBuilder() {
      if (tombstoneTtlBuilder_ == null) {
        tombstoneTtlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTombstoneTtl(), getParentForChildren(), isClean());
        tombstoneTtl_ = null;
      }
      return tombstoneTtlBuilder_;
    }

    private com.google.cloud.tasks.v2beta2.QueueStats stats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta2.QueueStats,
            com.google.cloud.tasks.v2beta2.QueueStats.Builder,
            com.google.cloud.tasks.v2beta2.QueueStatsOrBuilder>
        statsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta2.QueueStats stats = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the stats field is set.
     */
    public boolean hasStats() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta2.QueueStats stats = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The stats.
     */
    public com.google.cloud.tasks.v2beta2.QueueStats getStats() {
      if (statsBuilder_ == null) {
        return stats_ == null
            ? com.google.cloud.tasks.v2beta2.QueueStats.getDefaultInstance()
            : stats_;
      } else {
        return statsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta2.QueueStats stats = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStats(com.google.cloud.tasks.v2beta2.QueueStats value) {
      if (statsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stats_ = value;
      } else {
        statsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta2.QueueStats stats = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStats(com.google.cloud.tasks.v2beta2.QueueStats.Builder builderForValue) {
      if (statsBuilder_ == null) {
        stats_ = builderForValue.build();
      } else {
        statsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta2.QueueStats stats = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStats(com.google.cloud.tasks.v2beta2.QueueStats value) {
      if (statsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && stats_ != null
            && stats_ != com.google.cloud.tasks.v2beta2.QueueStats.getDefaultInstance()) {
          getStatsBuilder().mergeFrom(value);
        } else {
          stats_ = value;
        }
      } else {
        statsBuilder_.mergeFrom(value);
      }
      if (stats_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta2.QueueStats stats = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStats() {
      bitField0_ = (bitField0_ & ~0x00000400);
      stats_ = null;
      if (statsBuilder_ != null) {
        statsBuilder_.dispose();
        statsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta2.QueueStats stats = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.tasks.v2beta2.QueueStats.Builder getStatsBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getStatsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta2.QueueStats stats = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.tasks.v2beta2.QueueStatsOrBuilder getStatsOrBuilder() {
      if (statsBuilder_ != null) {
        return statsBuilder_.getMessageOrBuilder();
      } else {
        return stats_ == null
            ? com.google.cloud.tasks.v2beta2.QueueStats.getDefaultInstance()
            : stats_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta2.QueueStats stats = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta2.QueueStats,
            com.google.cloud.tasks.v2beta2.QueueStats.Builder,
            com.google.cloud.tasks.v2beta2.QueueStatsOrBuilder>
        getStatsFieldBuilder() {
      if (statsBuilder_ == null) {
        statsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2beta2.QueueStats,
                com.google.cloud.tasks.v2beta2.QueueStats.Builder,
                com.google.cloud.tasks.v2beta2.QueueStatsOrBuilder>(
                getStats(), getParentForChildren(), isClean());
        stats_ = null;
      }
      return statsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.tasks.v2beta2.Queue)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.tasks.v2beta2.Queue)
  private static final com.google.cloud.tasks.v2beta2.Queue DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.tasks.v2beta2.Queue();
  }

  public static com.google.cloud.tasks.v2beta2.Queue getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Queue> PARSER =
      new com.google.protobuf.AbstractParser<Queue>() {
        @java.lang.Override
        public Queue parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Queue> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Queue> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.tasks.v2beta2.Queue getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
