/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/tasks/v2beta2/queue.proto

// Protobuf Java Version: 3.25.3
package com.google.cloud.tasks.v2beta2;

/**
 *
 *
 * <pre>
 * Retry config.
 *
 * These settings determine how a failed task attempt is retried.
 * </pre>
 *
 * Protobuf type {@code google.cloud.tasks.v2beta2.RetryConfig}
 */
public final class RetryConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.tasks.v2beta2.RetryConfig)
    RetryConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RetryConfig.newBuilder() to construct.
  private RetryConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RetryConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RetryConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.tasks.v2beta2.QueueProto
        .internal_static_google_cloud_tasks_v2beta2_RetryConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.tasks.v2beta2.QueueProto
        .internal_static_google_cloud_tasks_v2beta2_RetryConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.tasks.v2beta2.RetryConfig.class,
            com.google.cloud.tasks.v2beta2.RetryConfig.Builder.class);
  }

  private int bitField0_;
  private int numAttemptsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object numAttempts_;

  public enum NumAttemptsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    MAX_ATTEMPTS(1),
    UNLIMITED_ATTEMPTS(2),
    NUMATTEMPTS_NOT_SET(0);
    private final int value;

    private NumAttemptsCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static NumAttemptsCase valueOf(int value) {
      return forNumber(value);
    }

    public static NumAttemptsCase forNumber(int value) {
      switch (value) {
        case 1:
          return MAX_ATTEMPTS;
        case 2:
          return UNLIMITED_ATTEMPTS;
        case 0:
          return NUMATTEMPTS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public NumAttemptsCase getNumAttemptsCase() {
    return NumAttemptsCase.forNumber(numAttemptsCase_);
  }

  public static final int MAX_ATTEMPTS_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * The maximum number of attempts for a task.
   *
   * Cloud Tasks will attempt the task `max_attempts` times (that
   * is, if the first attempt fails, then there will be
   * `max_attempts - 1` retries).  Must be &gt; 0.
   * </pre>
   *
   * <code>int32 max_attempts = 1;</code>
   *
   * @return Whether the maxAttempts field is set.
   */
  @java.lang.Override
  public boolean hasMaxAttempts() {
    return numAttemptsCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * The maximum number of attempts for a task.
   *
   * Cloud Tasks will attempt the task `max_attempts` times (that
   * is, if the first attempt fails, then there will be
   * `max_attempts - 1` retries).  Must be &gt; 0.
   * </pre>
   *
   * <code>int32 max_attempts = 1;</code>
   *
   * @return The maxAttempts.
   */
  @java.lang.Override
  public int getMaxAttempts() {
    if (numAttemptsCase_ == 1) {
      return (java.lang.Integer) numAttempts_;
    }
    return 0;
  }

  public static final int UNLIMITED_ATTEMPTS_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * If true, then the number of attempts is unlimited.
   * </pre>
   *
   * <code>bool unlimited_attempts = 2;</code>
   *
   * @return Whether the unlimitedAttempts field is set.
   */
  @java.lang.Override
  public boolean hasUnlimitedAttempts() {
    return numAttemptsCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * If true, then the number of attempts is unlimited.
   * </pre>
   *
   * <code>bool unlimited_attempts = 2;</code>
   *
   * @return The unlimitedAttempts.
   */
  @java.lang.Override
  public boolean getUnlimitedAttempts() {
    if (numAttemptsCase_ == 2) {
      return (java.lang.Boolean) numAttempts_;
    }
    return false;
  }

  public static final int MAX_RETRY_DURATION_FIELD_NUMBER = 3;
  private com.google.protobuf.Duration maxRetryDuration_;
  /**
   *
   *
   * <pre>
   * If positive, `max_retry_duration` specifies the time limit for
   * retrying a failed task, measured from when the task was first
   * attempted. Once `max_retry_duration` time has passed *and* the
   * task has been attempted
   * [max_attempts][google.cloud.tasks.v2beta2.RetryConfig.max_attempts] times,
   * no further attempts will be made and the task will be deleted.
   *
   * If zero, then the task age is unlimited.
   *
   * If unspecified when the queue is created, Cloud Tasks will pick the
   * default.
   *
   * This field is output only for [pull
   * queues][google.cloud.tasks.v2beta2.PullTarget].
   *
   *
   * `max_retry_duration` will be truncated to the nearest second.
   *
   * This field has the same meaning as
   * [task_age_limit in
   * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
   * </pre>
   *
   * <code>.google.protobuf.Duration max_retry_duration = 3;</code>
   *
   * @return Whether the maxRetryDuration field is set.
   */
  @java.lang.Override
  public boolean hasMaxRetryDuration() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * If positive, `max_retry_duration` specifies the time limit for
   * retrying a failed task, measured from when the task was first
   * attempted. Once `max_retry_duration` time has passed *and* the
   * task has been attempted
   * [max_attempts][google.cloud.tasks.v2beta2.RetryConfig.max_attempts] times,
   * no further attempts will be made and the task will be deleted.
   *
   * If zero, then the task age is unlimited.
   *
   * If unspecified when the queue is created, Cloud Tasks will pick the
   * default.
   *
   * This field is output only for [pull
   * queues][google.cloud.tasks.v2beta2.PullTarget].
   *
   *
   * `max_retry_duration` will be truncated to the nearest second.
   *
   * This field has the same meaning as
   * [task_age_limit in
   * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
   * </pre>
   *
   * <code>.google.protobuf.Duration max_retry_duration = 3;</code>
   *
   * @return The maxRetryDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getMaxRetryDuration() {
    return maxRetryDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : maxRetryDuration_;
  }
  /**
   *
   *
   * <pre>
   * If positive, `max_retry_duration` specifies the time limit for
   * retrying a failed task, measured from when the task was first
   * attempted. Once `max_retry_duration` time has passed *and* the
   * task has been attempted
   * [max_attempts][google.cloud.tasks.v2beta2.RetryConfig.max_attempts] times,
   * no further attempts will be made and the task will be deleted.
   *
   * If zero, then the task age is unlimited.
   *
   * If unspecified when the queue is created, Cloud Tasks will pick the
   * default.
   *
   * This field is output only for [pull
   * queues][google.cloud.tasks.v2beta2.PullTarget].
   *
   *
   * `max_retry_duration` will be truncated to the nearest second.
   *
   * This field has the same meaning as
   * [task_age_limit in
   * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
   * </pre>
   *
   * <code>.google.protobuf.Duration max_retry_duration = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getMaxRetryDurationOrBuilder() {
    return maxRetryDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : maxRetryDuration_;
  }

  public static final int MIN_BACKOFF_FIELD_NUMBER = 4;
  private com.google.protobuf.Duration minBackoff_;
  /**
   *
   *
   * <pre>
   * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
   * for retry between
   * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
   * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
   * after it fails, if the queue's
   * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
   * task should be retried.
   *
   * If unspecified when the queue is created, Cloud Tasks will pick the
   * default.
   *
   * This field is output only for [pull
   * queues][google.cloud.tasks.v2beta2.PullTarget].
   *
   *
   * `min_backoff` will be truncated to the nearest second.
   *
   * This field has the same meaning as
   * [min_backoff_seconds in
   * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
   * </pre>
   *
   * <code>.google.protobuf.Duration min_backoff = 4;</code>
   *
   * @return Whether the minBackoff field is set.
   */
  @java.lang.Override
  public boolean hasMinBackoff() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
   * for retry between
   * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
   * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
   * after it fails, if the queue's
   * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
   * task should be retried.
   *
   * If unspecified when the queue is created, Cloud Tasks will pick the
   * default.
   *
   * This field is output only for [pull
   * queues][google.cloud.tasks.v2beta2.PullTarget].
   *
   *
   * `min_backoff` will be truncated to the nearest second.
   *
   * This field has the same meaning as
   * [min_backoff_seconds in
   * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
   * </pre>
   *
   * <code>.google.protobuf.Duration min_backoff = 4;</code>
   *
   * @return The minBackoff.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getMinBackoff() {
    return minBackoff_ == null ? com.google.protobuf.Duration.getDefaultInstance() : minBackoff_;
  }
  /**
   *
   *
   * <pre>
   * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
   * for retry between
   * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
   * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
   * after it fails, if the queue's
   * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
   * task should be retried.
   *
   * If unspecified when the queue is created, Cloud Tasks will pick the
   * default.
   *
   * This field is output only for [pull
   * queues][google.cloud.tasks.v2beta2.PullTarget].
   *
   *
   * `min_backoff` will be truncated to the nearest second.
   *
   * This field has the same meaning as
   * [min_backoff_seconds in
   * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
   * </pre>
   *
   * <code>.google.protobuf.Duration min_backoff = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getMinBackoffOrBuilder() {
    return minBackoff_ == null ? com.google.protobuf.Duration.getDefaultInstance() : minBackoff_;
  }

  public static final int MAX_BACKOFF_FIELD_NUMBER = 5;
  private com.google.protobuf.Duration maxBackoff_;
  /**
   *
   *
   * <pre>
   * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
   * for retry between
   * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
   * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
   * after it fails, if the queue's
   * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
   * task should be retried.
   *
   * If unspecified when the queue is created, Cloud Tasks will pick the
   * default.
   *
   * This field is output only for [pull
   * queues][google.cloud.tasks.v2beta2.PullTarget].
   *
   *
   * `max_backoff` will be truncated to the nearest second.
   *
   * This field has the same meaning as
   * [max_backoff_seconds in
   * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
   * </pre>
   *
   * <code>.google.protobuf.Duration max_backoff = 5;</code>
   *
   * @return Whether the maxBackoff field is set.
   */
  @java.lang.Override
  public boolean hasMaxBackoff() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
   * for retry between
   * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
   * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
   * after it fails, if the queue's
   * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
   * task should be retried.
   *
   * If unspecified when the queue is created, Cloud Tasks will pick the
   * default.
   *
   * This field is output only for [pull
   * queues][google.cloud.tasks.v2beta2.PullTarget].
   *
   *
   * `max_backoff` will be truncated to the nearest second.
   *
   * This field has the same meaning as
   * [max_backoff_seconds in
   * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
   * </pre>
   *
   * <code>.google.protobuf.Duration max_backoff = 5;</code>
   *
   * @return The maxBackoff.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getMaxBackoff() {
    return maxBackoff_ == null ? com.google.protobuf.Duration.getDefaultInstance() : maxBackoff_;
  }
  /**
   *
   *
   * <pre>
   * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
   * for retry between
   * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
   * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
   * after it fails, if the queue's
   * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
   * task should be retried.
   *
   * If unspecified when the queue is created, Cloud Tasks will pick the
   * default.
   *
   * This field is output only for [pull
   * queues][google.cloud.tasks.v2beta2.PullTarget].
   *
   *
   * `max_backoff` will be truncated to the nearest second.
   *
   * This field has the same meaning as
   * [max_backoff_seconds in
   * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
   * </pre>
   *
   * <code>.google.protobuf.Duration max_backoff = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getMaxBackoffOrBuilder() {
    return maxBackoff_ == null ? com.google.protobuf.Duration.getDefaultInstance() : maxBackoff_;
  }

  public static final int MAX_DOUBLINGS_FIELD_NUMBER = 6;
  private int maxDoublings_ = 0;
  /**
   *
   *
   * <pre>
   * The time between retries will double `max_doublings` times.
   *
   * A task's retry interval starts at
   * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff], then
   * doubles `max_doublings` times, then increases linearly, and finally retries
   * at intervals of
   * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] up to
   * [max_attempts][google.cloud.tasks.v2beta2.RetryConfig.max_attempts] times.
   *
   * For example, if
   * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] is 10s,
   * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] is 300s,
   * and `max_doublings` is 3, then the a task will first be retried in 10s. The
   * retry interval will double three times, and then increase linearly by 2^3 *
   * 10s.  Finally, the task will retry at intervals of
   * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] until the
   * task has been attempted
   * [max_attempts][google.cloud.tasks.v2beta2.RetryConfig.max_attempts] times.
   * Thus, the requests will retry at 10s, 20s, 40s, 80s, 160s, 240s, 300s,
   * 300s, ....
   *
   * If unspecified when the queue is created, Cloud Tasks will pick the
   * default.
   *
   * This field is output only for [pull
   * queues][google.cloud.tasks.v2beta2.PullTarget].
   *
   *
   * This field has the same meaning as
   * [max_doublings in
   * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
   * </pre>
   *
   * <code>int32 max_doublings = 6;</code>
   *
   * @return The maxDoublings.
   */
  @java.lang.Override
  public int getMaxDoublings() {
    return maxDoublings_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (numAttemptsCase_ == 1) {
      output.writeInt32(1, (int) ((java.lang.Integer) numAttempts_));
    }
    if (numAttemptsCase_ == 2) {
      output.writeBool(2, (boolean) ((java.lang.Boolean) numAttempts_));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getMaxRetryDuration());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(4, getMinBackoff());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getMaxBackoff());
    }
    if (maxDoublings_ != 0) {
      output.writeInt32(6, maxDoublings_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (numAttemptsCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              1, (int) ((java.lang.Integer) numAttempts_));
    }
    if (numAttemptsCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeBoolSize(
              2, (boolean) ((java.lang.Boolean) numAttempts_));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getMaxRetryDuration());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getMinBackoff());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getMaxBackoff());
    }
    if (maxDoublings_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, maxDoublings_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.tasks.v2beta2.RetryConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.tasks.v2beta2.RetryConfig other =
        (com.google.cloud.tasks.v2beta2.RetryConfig) obj;

    if (hasMaxRetryDuration() != other.hasMaxRetryDuration()) return false;
    if (hasMaxRetryDuration()) {
      if (!getMaxRetryDuration().equals(other.getMaxRetryDuration())) return false;
    }
    if (hasMinBackoff() != other.hasMinBackoff()) return false;
    if (hasMinBackoff()) {
      if (!getMinBackoff().equals(other.getMinBackoff())) return false;
    }
    if (hasMaxBackoff() != other.hasMaxBackoff()) return false;
    if (hasMaxBackoff()) {
      if (!getMaxBackoff().equals(other.getMaxBackoff())) return false;
    }
    if (getMaxDoublings() != other.getMaxDoublings()) return false;
    if (!getNumAttemptsCase().equals(other.getNumAttemptsCase())) return false;
    switch (numAttemptsCase_) {
      case 1:
        if (getMaxAttempts() != other.getMaxAttempts()) return false;
        break;
      case 2:
        if (getUnlimitedAttempts() != other.getUnlimitedAttempts()) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasMaxRetryDuration()) {
      hash = (37 * hash) + MAX_RETRY_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getMaxRetryDuration().hashCode();
    }
    if (hasMinBackoff()) {
      hash = (37 * hash) + MIN_BACKOFF_FIELD_NUMBER;
      hash = (53 * hash) + getMinBackoff().hashCode();
    }
    if (hasMaxBackoff()) {
      hash = (37 * hash) + MAX_BACKOFF_FIELD_NUMBER;
      hash = (53 * hash) + getMaxBackoff().hashCode();
    }
    hash = (37 * hash) + MAX_DOUBLINGS_FIELD_NUMBER;
    hash = (53 * hash) + getMaxDoublings();
    switch (numAttemptsCase_) {
      case 1:
        hash = (37 * hash) + MAX_ATTEMPTS_FIELD_NUMBER;
        hash = (53 * hash) + getMaxAttempts();
        break;
      case 2:
        hash = (37 * hash) + UNLIMITED_ATTEMPTS_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUnlimitedAttempts());
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.tasks.v2beta2.RetryConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta2.RetryConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta2.RetryConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta2.RetryConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta2.RetryConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta2.RetryConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta2.RetryConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta2.RetryConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta2.RetryConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta2.RetryConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta2.RetryConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta2.RetryConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.tasks.v2beta2.RetryConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Retry config.
   *
   * These settings determine how a failed task attempt is retried.
   * </pre>
   *
   * Protobuf type {@code google.cloud.tasks.v2beta2.RetryConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.tasks.v2beta2.RetryConfig)
      com.google.cloud.tasks.v2beta2.RetryConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.tasks.v2beta2.QueueProto
          .internal_static_google_cloud_tasks_v2beta2_RetryConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.tasks.v2beta2.QueueProto
          .internal_static_google_cloud_tasks_v2beta2_RetryConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.tasks.v2beta2.RetryConfig.class,
              com.google.cloud.tasks.v2beta2.RetryConfig.Builder.class);
    }

    // Construct using com.google.cloud.tasks.v2beta2.RetryConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMaxRetryDurationFieldBuilder();
        getMinBackoffFieldBuilder();
        getMaxBackoffFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      maxRetryDuration_ = null;
      if (maxRetryDurationBuilder_ != null) {
        maxRetryDurationBuilder_.dispose();
        maxRetryDurationBuilder_ = null;
      }
      minBackoff_ = null;
      if (minBackoffBuilder_ != null) {
        minBackoffBuilder_.dispose();
        minBackoffBuilder_ = null;
      }
      maxBackoff_ = null;
      if (maxBackoffBuilder_ != null) {
        maxBackoffBuilder_.dispose();
        maxBackoffBuilder_ = null;
      }
      maxDoublings_ = 0;
      numAttemptsCase_ = 0;
      numAttempts_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.tasks.v2beta2.QueueProto
          .internal_static_google_cloud_tasks_v2beta2_RetryConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta2.RetryConfig getDefaultInstanceForType() {
      return com.google.cloud.tasks.v2beta2.RetryConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta2.RetryConfig build() {
      com.google.cloud.tasks.v2beta2.RetryConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta2.RetryConfig buildPartial() {
      com.google.cloud.tasks.v2beta2.RetryConfig result =
          new com.google.cloud.tasks.v2beta2.RetryConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.tasks.v2beta2.RetryConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.maxRetryDuration_ =
            maxRetryDurationBuilder_ == null ? maxRetryDuration_ : maxRetryDurationBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.minBackoff_ = minBackoffBuilder_ == null ? minBackoff_ : minBackoffBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.maxBackoff_ = maxBackoffBuilder_ == null ? maxBackoff_ : maxBackoffBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.maxDoublings_ = maxDoublings_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.tasks.v2beta2.RetryConfig result) {
      result.numAttemptsCase_ = numAttemptsCase_;
      result.numAttempts_ = this.numAttempts_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.tasks.v2beta2.RetryConfig) {
        return mergeFrom((com.google.cloud.tasks.v2beta2.RetryConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.tasks.v2beta2.RetryConfig other) {
      if (other == com.google.cloud.tasks.v2beta2.RetryConfig.getDefaultInstance()) return this;
      if (other.hasMaxRetryDuration()) {
        mergeMaxRetryDuration(other.getMaxRetryDuration());
      }
      if (other.hasMinBackoff()) {
        mergeMinBackoff(other.getMinBackoff());
      }
      if (other.hasMaxBackoff()) {
        mergeMaxBackoff(other.getMaxBackoff());
      }
      if (other.getMaxDoublings() != 0) {
        setMaxDoublings(other.getMaxDoublings());
      }
      switch (other.getNumAttemptsCase()) {
        case MAX_ATTEMPTS:
          {
            setMaxAttempts(other.getMaxAttempts());
            break;
          }
        case UNLIMITED_ATTEMPTS:
          {
            setUnlimitedAttempts(other.getUnlimitedAttempts());
            break;
          }
        case NUMATTEMPTS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                numAttempts_ = input.readInt32();
                numAttemptsCase_ = 1;
                break;
              } // case 8
            case 16:
              {
                numAttempts_ = input.readBool();
                numAttemptsCase_ = 2;
                break;
              } // case 16
            case 26:
              {
                input.readMessage(
                    getMaxRetryDurationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getMinBackoffFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getMaxBackoffFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                maxDoublings_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int numAttemptsCase_ = 0;
    private java.lang.Object numAttempts_;

    public NumAttemptsCase getNumAttemptsCase() {
      return NumAttemptsCase.forNumber(numAttemptsCase_);
    }

    public Builder clearNumAttempts() {
      numAttemptsCase_ = 0;
      numAttempts_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * The maximum number of attempts for a task.
     *
     * Cloud Tasks will attempt the task `max_attempts` times (that
     * is, if the first attempt fails, then there will be
     * `max_attempts - 1` retries).  Must be &gt; 0.
     * </pre>
     *
     * <code>int32 max_attempts = 1;</code>
     *
     * @return Whether the maxAttempts field is set.
     */
    public boolean hasMaxAttempts() {
      return numAttemptsCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of attempts for a task.
     *
     * Cloud Tasks will attempt the task `max_attempts` times (that
     * is, if the first attempt fails, then there will be
     * `max_attempts - 1` retries).  Must be &gt; 0.
     * </pre>
     *
     * <code>int32 max_attempts = 1;</code>
     *
     * @return The maxAttempts.
     */
    public int getMaxAttempts() {
      if (numAttemptsCase_ == 1) {
        return (java.lang.Integer) numAttempts_;
      }
      return 0;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of attempts for a task.
     *
     * Cloud Tasks will attempt the task `max_attempts` times (that
     * is, if the first attempt fails, then there will be
     * `max_attempts - 1` retries).  Must be &gt; 0.
     * </pre>
     *
     * <code>int32 max_attempts = 1;</code>
     *
     * @param value The maxAttempts to set.
     * @return This builder for chaining.
     */
    public Builder setMaxAttempts(int value) {

      numAttemptsCase_ = 1;
      numAttempts_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of attempts for a task.
     *
     * Cloud Tasks will attempt the task `max_attempts` times (that
     * is, if the first attempt fails, then there will be
     * `max_attempts - 1` retries).  Must be &gt; 0.
     * </pre>
     *
     * <code>int32 max_attempts = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxAttempts() {
      if (numAttemptsCase_ == 1) {
        numAttemptsCase_ = 0;
        numAttempts_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If true, then the number of attempts is unlimited.
     * </pre>
     *
     * <code>bool unlimited_attempts = 2;</code>
     *
     * @return Whether the unlimitedAttempts field is set.
     */
    public boolean hasUnlimitedAttempts() {
      return numAttemptsCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * If true, then the number of attempts is unlimited.
     * </pre>
     *
     * <code>bool unlimited_attempts = 2;</code>
     *
     * @return The unlimitedAttempts.
     */
    public boolean getUnlimitedAttempts() {
      if (numAttemptsCase_ == 2) {
        return (java.lang.Boolean) numAttempts_;
      }
      return false;
    }
    /**
     *
     *
     * <pre>
     * If true, then the number of attempts is unlimited.
     * </pre>
     *
     * <code>bool unlimited_attempts = 2;</code>
     *
     * @param value The unlimitedAttempts to set.
     * @return This builder for chaining.
     */
    public Builder setUnlimitedAttempts(boolean value) {

      numAttemptsCase_ = 2;
      numAttempts_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, then the number of attempts is unlimited.
     * </pre>
     *
     * <code>bool unlimited_attempts = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUnlimitedAttempts() {
      if (numAttemptsCase_ == 2) {
        numAttemptsCase_ = 0;
        numAttempts_ = null;
        onChanged();
      }
      return this;
    }

    private com.google.protobuf.Duration maxRetryDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        maxRetryDurationBuilder_;
    /**
     *
     *
     * <pre>
     * If positive, `max_retry_duration` specifies the time limit for
     * retrying a failed task, measured from when the task was first
     * attempted. Once `max_retry_duration` time has passed *and* the
     * task has been attempted
     * [max_attempts][google.cloud.tasks.v2beta2.RetryConfig.max_attempts] times,
     * no further attempts will be made and the task will be deleted.
     *
     * If zero, then the task age is unlimited.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `max_retry_duration` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [task_age_limit in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 3;</code>
     *
     * @return Whether the maxRetryDuration field is set.
     */
    public boolean hasMaxRetryDuration() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * If positive, `max_retry_duration` specifies the time limit for
     * retrying a failed task, measured from when the task was first
     * attempted. Once `max_retry_duration` time has passed *and* the
     * task has been attempted
     * [max_attempts][google.cloud.tasks.v2beta2.RetryConfig.max_attempts] times,
     * no further attempts will be made and the task will be deleted.
     *
     * If zero, then the task age is unlimited.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `max_retry_duration` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [task_age_limit in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 3;</code>
     *
     * @return The maxRetryDuration.
     */
    public com.google.protobuf.Duration getMaxRetryDuration() {
      if (maxRetryDurationBuilder_ == null) {
        return maxRetryDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maxRetryDuration_;
      } else {
        return maxRetryDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If positive, `max_retry_duration` specifies the time limit for
     * retrying a failed task, measured from when the task was first
     * attempted. Once `max_retry_duration` time has passed *and* the
     * task has been attempted
     * [max_attempts][google.cloud.tasks.v2beta2.RetryConfig.max_attempts] times,
     * no further attempts will be made and the task will be deleted.
     *
     * If zero, then the task age is unlimited.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `max_retry_duration` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [task_age_limit in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 3;</code>
     */
    public Builder setMaxRetryDuration(com.google.protobuf.Duration value) {
      if (maxRetryDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maxRetryDuration_ = value;
      } else {
        maxRetryDurationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If positive, `max_retry_duration` specifies the time limit for
     * retrying a failed task, measured from when the task was first
     * attempted. Once `max_retry_duration` time has passed *and* the
     * task has been attempted
     * [max_attempts][google.cloud.tasks.v2beta2.RetryConfig.max_attempts] times,
     * no further attempts will be made and the task will be deleted.
     *
     * If zero, then the task age is unlimited.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `max_retry_duration` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [task_age_limit in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 3;</code>
     */
    public Builder setMaxRetryDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (maxRetryDurationBuilder_ == null) {
        maxRetryDuration_ = builderForValue.build();
      } else {
        maxRetryDurationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If positive, `max_retry_duration` specifies the time limit for
     * retrying a failed task, measured from when the task was first
     * attempted. Once `max_retry_duration` time has passed *and* the
     * task has been attempted
     * [max_attempts][google.cloud.tasks.v2beta2.RetryConfig.max_attempts] times,
     * no further attempts will be made and the task will be deleted.
     *
     * If zero, then the task age is unlimited.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `max_retry_duration` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [task_age_limit in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 3;</code>
     */
    public Builder mergeMaxRetryDuration(com.google.protobuf.Duration value) {
      if (maxRetryDurationBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && maxRetryDuration_ != null
            && maxRetryDuration_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getMaxRetryDurationBuilder().mergeFrom(value);
        } else {
          maxRetryDuration_ = value;
        }
      } else {
        maxRetryDurationBuilder_.mergeFrom(value);
      }
      if (maxRetryDuration_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If positive, `max_retry_duration` specifies the time limit for
     * retrying a failed task, measured from when the task was first
     * attempted. Once `max_retry_duration` time has passed *and* the
     * task has been attempted
     * [max_attempts][google.cloud.tasks.v2beta2.RetryConfig.max_attempts] times,
     * no further attempts will be made and the task will be deleted.
     *
     * If zero, then the task age is unlimited.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `max_retry_duration` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [task_age_limit in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 3;</code>
     */
    public Builder clearMaxRetryDuration() {
      bitField0_ = (bitField0_ & ~0x00000004);
      maxRetryDuration_ = null;
      if (maxRetryDurationBuilder_ != null) {
        maxRetryDurationBuilder_.dispose();
        maxRetryDurationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If positive, `max_retry_duration` specifies the time limit for
     * retrying a failed task, measured from when the task was first
     * attempted. Once `max_retry_duration` time has passed *and* the
     * task has been attempted
     * [max_attempts][google.cloud.tasks.v2beta2.RetryConfig.max_attempts] times,
     * no further attempts will be made and the task will be deleted.
     *
     * If zero, then the task age is unlimited.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `max_retry_duration` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [task_age_limit in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 3;</code>
     */
    public com.google.protobuf.Duration.Builder getMaxRetryDurationBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getMaxRetryDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If positive, `max_retry_duration` specifies the time limit for
     * retrying a failed task, measured from when the task was first
     * attempted. Once `max_retry_duration` time has passed *and* the
     * task has been attempted
     * [max_attempts][google.cloud.tasks.v2beta2.RetryConfig.max_attempts] times,
     * no further attempts will be made and the task will be deleted.
     *
     * If zero, then the task age is unlimited.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `max_retry_duration` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [task_age_limit in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 3;</code>
     */
    public com.google.protobuf.DurationOrBuilder getMaxRetryDurationOrBuilder() {
      if (maxRetryDurationBuilder_ != null) {
        return maxRetryDurationBuilder_.getMessageOrBuilder();
      } else {
        return maxRetryDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maxRetryDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * If positive, `max_retry_duration` specifies the time limit for
     * retrying a failed task, measured from when the task was first
     * attempted. Once `max_retry_duration` time has passed *and* the
     * task has been attempted
     * [max_attempts][google.cloud.tasks.v2beta2.RetryConfig.max_attempts] times,
     * no further attempts will be made and the task will be deleted.
     *
     * If zero, then the task age is unlimited.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `max_retry_duration` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [task_age_limit in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getMaxRetryDurationFieldBuilder() {
      if (maxRetryDurationBuilder_ == null) {
        maxRetryDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getMaxRetryDuration(), getParentForChildren(), isClean());
        maxRetryDuration_ = null;
      }
      return maxRetryDurationBuilder_;
    }

    private com.google.protobuf.Duration minBackoff_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        minBackoffBuilder_;
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
     * for retry between
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
     * after it fails, if the queue's
     * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
     * task should be retried.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `min_backoff` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [min_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff = 4;</code>
     *
     * @return Whether the minBackoff field is set.
     */
    public boolean hasMinBackoff() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
     * for retry between
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
     * after it fails, if the queue's
     * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
     * task should be retried.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `min_backoff` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [min_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff = 4;</code>
     *
     * @return The minBackoff.
     */
    public com.google.protobuf.Duration getMinBackoff() {
      if (minBackoffBuilder_ == null) {
        return minBackoff_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : minBackoff_;
      } else {
        return minBackoffBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
     * for retry between
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
     * after it fails, if the queue's
     * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
     * task should be retried.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `min_backoff` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [min_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff = 4;</code>
     */
    public Builder setMinBackoff(com.google.protobuf.Duration value) {
      if (minBackoffBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        minBackoff_ = value;
      } else {
        minBackoffBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
     * for retry between
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
     * after it fails, if the queue's
     * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
     * task should be retried.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `min_backoff` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [min_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff = 4;</code>
     */
    public Builder setMinBackoff(com.google.protobuf.Duration.Builder builderForValue) {
      if (minBackoffBuilder_ == null) {
        minBackoff_ = builderForValue.build();
      } else {
        minBackoffBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
     * for retry between
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
     * after it fails, if the queue's
     * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
     * task should be retried.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `min_backoff` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [min_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff = 4;</code>
     */
    public Builder mergeMinBackoff(com.google.protobuf.Duration value) {
      if (minBackoffBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && minBackoff_ != null
            && minBackoff_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getMinBackoffBuilder().mergeFrom(value);
        } else {
          minBackoff_ = value;
        }
      } else {
        minBackoffBuilder_.mergeFrom(value);
      }
      if (minBackoff_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
     * for retry between
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
     * after it fails, if the queue's
     * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
     * task should be retried.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `min_backoff` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [min_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff = 4;</code>
     */
    public Builder clearMinBackoff() {
      bitField0_ = (bitField0_ & ~0x00000008);
      minBackoff_ = null;
      if (minBackoffBuilder_ != null) {
        minBackoffBuilder_.dispose();
        minBackoffBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
     * for retry between
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
     * after it fails, if the queue's
     * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
     * task should be retried.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `min_backoff` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [min_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff = 4;</code>
     */
    public com.google.protobuf.Duration.Builder getMinBackoffBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getMinBackoffFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
     * for retry between
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
     * after it fails, if the queue's
     * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
     * task should be retried.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `min_backoff` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [min_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff = 4;</code>
     */
    public com.google.protobuf.DurationOrBuilder getMinBackoffOrBuilder() {
      if (minBackoffBuilder_ != null) {
        return minBackoffBuilder_.getMessageOrBuilder();
      } else {
        return minBackoff_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : minBackoff_;
      }
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
     * for retry between
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
     * after it fails, if the queue's
     * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
     * task should be retried.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `min_backoff` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [min_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getMinBackoffFieldBuilder() {
      if (minBackoffBuilder_ == null) {
        minBackoffBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getMinBackoff(), getParentForChildren(), isClean());
        minBackoff_ = null;
      }
      return minBackoffBuilder_;
    }

    private com.google.protobuf.Duration maxBackoff_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        maxBackoffBuilder_;
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
     * for retry between
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
     * after it fails, if the queue's
     * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
     * task should be retried.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `max_backoff` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [max_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff = 5;</code>
     *
     * @return Whether the maxBackoff field is set.
     */
    public boolean hasMaxBackoff() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
     * for retry between
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
     * after it fails, if the queue's
     * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
     * task should be retried.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `max_backoff` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [max_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff = 5;</code>
     *
     * @return The maxBackoff.
     */
    public com.google.protobuf.Duration getMaxBackoff() {
      if (maxBackoffBuilder_ == null) {
        return maxBackoff_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maxBackoff_;
      } else {
        return maxBackoffBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
     * for retry between
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
     * after it fails, if the queue's
     * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
     * task should be retried.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `max_backoff` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [max_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff = 5;</code>
     */
    public Builder setMaxBackoff(com.google.protobuf.Duration value) {
      if (maxBackoffBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maxBackoff_ = value;
      } else {
        maxBackoffBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
     * for retry between
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
     * after it fails, if the queue's
     * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
     * task should be retried.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `max_backoff` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [max_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff = 5;</code>
     */
    public Builder setMaxBackoff(com.google.protobuf.Duration.Builder builderForValue) {
      if (maxBackoffBuilder_ == null) {
        maxBackoff_ = builderForValue.build();
      } else {
        maxBackoffBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
     * for retry between
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
     * after it fails, if the queue's
     * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
     * task should be retried.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `max_backoff` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [max_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff = 5;</code>
     */
    public Builder mergeMaxBackoff(com.google.protobuf.Duration value) {
      if (maxBackoffBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && maxBackoff_ != null
            && maxBackoff_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getMaxBackoffBuilder().mergeFrom(value);
        } else {
          maxBackoff_ = value;
        }
      } else {
        maxBackoffBuilder_.mergeFrom(value);
      }
      if (maxBackoff_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
     * for retry between
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
     * after it fails, if the queue's
     * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
     * task should be retried.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `max_backoff` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [max_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff = 5;</code>
     */
    public Builder clearMaxBackoff() {
      bitField0_ = (bitField0_ & ~0x00000010);
      maxBackoff_ = null;
      if (maxBackoffBuilder_ != null) {
        maxBackoffBuilder_.dispose();
        maxBackoffBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
     * for retry between
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
     * after it fails, if the queue's
     * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
     * task should be retried.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `max_backoff` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [max_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff = 5;</code>
     */
    public com.google.protobuf.Duration.Builder getMaxBackoffBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getMaxBackoffFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
     * for retry between
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
     * after it fails, if the queue's
     * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
     * task should be retried.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `max_backoff` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [max_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff = 5;</code>
     */
    public com.google.protobuf.DurationOrBuilder getMaxBackoffOrBuilder() {
      if (maxBackoffBuilder_ != null) {
        return maxBackoffBuilder_.getMessageOrBuilder();
      } else {
        return maxBackoff_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maxBackoff_;
      }
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta2.Task.schedule_time]
     * for retry between
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] duration
     * after it fails, if the queue's
     * [RetryConfig][google.cloud.tasks.v2beta2.RetryConfig] specifies that the
     * task should be retried.
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * `max_backoff` will be truncated to the nearest second.
     *
     * This field has the same meaning as
     * [max_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getMaxBackoffFieldBuilder() {
      if (maxBackoffBuilder_ == null) {
        maxBackoffBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getMaxBackoff(), getParentForChildren(), isClean());
        maxBackoff_ = null;
      }
      return maxBackoffBuilder_;
    }

    private int maxDoublings_;
    /**
     *
     *
     * <pre>
     * The time between retries will double `max_doublings` times.
     *
     * A task's retry interval starts at
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff], then
     * doubles `max_doublings` times, then increases linearly, and finally retries
     * at intervals of
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] up to
     * [max_attempts][google.cloud.tasks.v2beta2.RetryConfig.max_attempts] times.
     *
     * For example, if
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] is 10s,
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] is 300s,
     * and `max_doublings` is 3, then the a task will first be retried in 10s. The
     * retry interval will double three times, and then increase linearly by 2^3 *
     * 10s.  Finally, the task will retry at intervals of
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] until the
     * task has been attempted
     * [max_attempts][google.cloud.tasks.v2beta2.RetryConfig.max_attempts] times.
     * Thus, the requests will retry at 10s, 20s, 40s, 80s, 160s, 240s, 300s,
     * 300s, ....
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * This field has the same meaning as
     * [max_doublings in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>int32 max_doublings = 6;</code>
     *
     * @return The maxDoublings.
     */
    @java.lang.Override
    public int getMaxDoublings() {
      return maxDoublings_;
    }
    /**
     *
     *
     * <pre>
     * The time between retries will double `max_doublings` times.
     *
     * A task's retry interval starts at
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff], then
     * doubles `max_doublings` times, then increases linearly, and finally retries
     * at intervals of
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] up to
     * [max_attempts][google.cloud.tasks.v2beta2.RetryConfig.max_attempts] times.
     *
     * For example, if
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] is 10s,
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] is 300s,
     * and `max_doublings` is 3, then the a task will first be retried in 10s. The
     * retry interval will double three times, and then increase linearly by 2^3 *
     * 10s.  Finally, the task will retry at intervals of
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] until the
     * task has been attempted
     * [max_attempts][google.cloud.tasks.v2beta2.RetryConfig.max_attempts] times.
     * Thus, the requests will retry at 10s, 20s, 40s, 80s, 160s, 240s, 300s,
     * 300s, ....
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * This field has the same meaning as
     * [max_doublings in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>int32 max_doublings = 6;</code>
     *
     * @param value The maxDoublings to set.
     * @return This builder for chaining.
     */
    public Builder setMaxDoublings(int value) {

      maxDoublings_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time between retries will double `max_doublings` times.
     *
     * A task's retry interval starts at
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff], then
     * doubles `max_doublings` times, then increases linearly, and finally retries
     * at intervals of
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] up to
     * [max_attempts][google.cloud.tasks.v2beta2.RetryConfig.max_attempts] times.
     *
     * For example, if
     * [min_backoff][google.cloud.tasks.v2beta2.RetryConfig.min_backoff] is 10s,
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] is 300s,
     * and `max_doublings` is 3, then the a task will first be retried in 10s. The
     * retry interval will double three times, and then increase linearly by 2^3 *
     * 10s.  Finally, the task will retry at intervals of
     * [max_backoff][google.cloud.tasks.v2beta2.RetryConfig.max_backoff] until the
     * task has been attempted
     * [max_attempts][google.cloud.tasks.v2beta2.RetryConfig.max_attempts] times.
     * Thus, the requests will retry at 10s, 20s, 40s, 80s, 160s, 240s, 300s,
     * 300s, ....
     *
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     *
     * This field is output only for [pull
     * queues][google.cloud.tasks.v2beta2.PullTarget].
     *
     *
     * This field has the same meaning as
     * [max_doublings in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>int32 max_doublings = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxDoublings() {
      bitField0_ = (bitField0_ & ~0x00000020);
      maxDoublings_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.tasks.v2beta2.RetryConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.tasks.v2beta2.RetryConfig)
  private static final com.google.cloud.tasks.v2beta2.RetryConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.tasks.v2beta2.RetryConfig();
  }

  public static com.google.cloud.tasks.v2beta2.RetryConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RetryConfig> PARSER =
      new com.google.protobuf.AbstractParser<RetryConfig>() {
        @java.lang.Override
        public RetryConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RetryConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RetryConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.tasks.v2beta2.RetryConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
