/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/tasks/v2beta3/queue.proto

package com.google.cloud.tasks.v2beta3;

/**
 *
 *
 * <pre>
 * A queue is a container of related tasks. Queues are configured to manage
 * how those tasks are dispatched. Configurable properties include rate limits,
 * retry options, queue types, and others.
 * </pre>
 *
 * Protobuf type {@code google.cloud.tasks.v2beta3.Queue}
 */
public final class Queue extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.tasks.v2beta3.Queue)
    QueueOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Queue.newBuilder() to construct.
  private Queue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Queue() {
    name_ = "";
    state_ = 0;
    type_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Queue();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.tasks.v2beta3.QueueProto
        .internal_static_google_cloud_tasks_v2beta3_Queue_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.tasks.v2beta3.QueueProto
        .internal_static_google_cloud_tasks_v2beta3_Queue_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.tasks.v2beta3.Queue.class,
            com.google.cloud.tasks.v2beta3.Queue.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * State of the queue.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.tasks.v2beta3.Queue.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The queue is running. Tasks can be dispatched.
     * If the queue was created using Cloud Tasks and the queue has
     * had no activity (method calls or task dispatches) for 30 days,
     * the queue may take a few minutes to re-activate. Some method
     * calls may return [NOT_FOUND][google.rpc.Code.NOT_FOUND] and
     * tasks may not be dispatched for a few minutes until the queue
     * has been re-activated.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    RUNNING(1),
    /**
     *
     *
     * <pre>
     * Tasks are paused by the user. If the queue is paused then Cloud
     * Tasks will stop delivering tasks from it, but more tasks can
     * still be added to it by the user.
     * </pre>
     *
     * <code>PAUSED = 2;</code>
     */
    PAUSED(2),
    /**
     *
     *
     * <pre>
     * The queue is disabled.
     * A queue becomes `DISABLED` when
     * [queue.yaml](https://cloud.google.com/appengine/docs/python/config/queueref)
     * or
     * [queue.xml](https://cloud.google.com/appengine/docs/standard/java/config/queueref)
     * is uploaded which does not contain the queue. You cannot directly disable
     * a queue.
     * When a queue is disabled, tasks can still be added to a queue
     * but the tasks are not dispatched.
     * To permanently delete this queue and all of its tasks, call
     * [DeleteQueue][google.cloud.tasks.v2beta3.CloudTasks.DeleteQueue].
     * </pre>
     *
     * <code>DISABLED = 3;</code>
     */
    DISABLED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified state.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The queue is running. Tasks can be dispatched.
     * If the queue was created using Cloud Tasks and the queue has
     * had no activity (method calls or task dispatches) for 30 days,
     * the queue may take a few minutes to re-activate. Some method
     * calls may return [NOT_FOUND][google.rpc.Code.NOT_FOUND] and
     * tasks may not be dispatched for a few minutes until the queue
     * has been re-activated.
     * </pre>
     *
     * <code>RUNNING = 1;</code>
     */
    public static final int RUNNING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Tasks are paused by the user. If the queue is paused then Cloud
     * Tasks will stop delivering tasks from it, but more tasks can
     * still be added to it by the user.
     * </pre>
     *
     * <code>PAUSED = 2;</code>
     */
    public static final int PAUSED_VALUE = 2;
    /**
     *
     *
     * <pre>
     * The queue is disabled.
     * A queue becomes `DISABLED` when
     * [queue.yaml](https://cloud.google.com/appengine/docs/python/config/queueref)
     * or
     * [queue.xml](https://cloud.google.com/appengine/docs/standard/java/config/queueref)
     * is uploaded which does not contain the queue. You cannot directly disable
     * a queue.
     * When a queue is disabled, tasks can still be added to a queue
     * but the tasks are not dispatched.
     * To permanently delete this queue and all of its tasks, call
     * [DeleteQueue][google.cloud.tasks.v2beta3.CloudTasks.DeleteQueue].
     * </pre>
     *
     * <code>DISABLED = 3;</code>
     */
    public static final int DISABLED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return RUNNING;
        case 2:
          return PAUSED;
        case 3:
          return DISABLED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.tasks.v2beta3.Queue.getDescriptor().getEnumTypes().get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.tasks.v2beta3.Queue.State)
  }

  /**
   *
   *
   * <pre>
   * The type of the queue.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.tasks.v2beta3.Queue.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * A pull queue.
     * </pre>
     *
     * <code>PULL = 1;</code>
     */
    PULL(1),
    /**
     *
     *
     * <pre>
     * A push queue.
     * </pre>
     *
     * <code>PUSH = 2;</code>
     */
    PUSH(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Default value.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * A pull queue.
     * </pre>
     *
     * <code>PULL = 1;</code>
     */
    public static final int PULL_VALUE = 1;
    /**
     *
     *
     * <pre>
     * A push queue.
     * </pre>
     *
     * <code>PUSH = 2;</code>
     */
    public static final int PUSH_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return PULL;
        case 2:
          return PUSH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.tasks.v2beta3.Queue.getDescriptor().getEnumTypes().get(1);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.tasks.v2beta3.Queue.Type)
  }

  private int queueTypeCase_ = 0;
  private java.lang.Object queueType_;

  public enum QueueTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    APP_ENGINE_HTTP_QUEUE(3),
    QUEUETYPE_NOT_SET(0);
    private final int value;

    private QueueTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static QueueTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static QueueTypeCase forNumber(int value) {
      switch (value) {
        case 3:
          return APP_ENGINE_HTTP_QUEUE;
        case 0:
          return QUEUETYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public QueueTypeCase getQueueTypeCase() {
    return QueueTypeCase.forNumber(queueTypeCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Caller-specified and required in [CreateQueue][google.cloud.tasks.v2beta3.CloudTasks.CreateQueue],
   * after which it becomes output only.
   * The queue name.
   * The queue name must have the following format:
   * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
   * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
   *    hyphens (-), colons (:), or periods (.).
   *    For more information, see
   *    [Identifying
   *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
   * * `LOCATION_ID` is the canonical ID for the queue's location.
   *    The list of available locations can be obtained by calling
   *    [ListLocations][google.cloud.location.Locations.ListLocations].
   *    For more information, see https://cloud.google.com/about/locations/.
   * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
   *   hyphens (-). The maximum length is 100 characters.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Caller-specified and required in [CreateQueue][google.cloud.tasks.v2beta3.CloudTasks.CreateQueue],
   * after which it becomes output only.
   * The queue name.
   * The queue name must have the following format:
   * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
   * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
   *    hyphens (-), colons (:), or periods (.).
   *    For more information, see
   *    [Identifying
   *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
   * * `LOCATION_ID` is the canonical ID for the queue's location.
   *    The list of available locations can be obtained by calling
   *    [ListLocations][google.cloud.location.Locations.ListLocations].
   *    For more information, see https://cloud.google.com/about/locations/.
   * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
   *   hyphens (-). The maximum length is 100 characters.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APP_ENGINE_HTTP_QUEUE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * [AppEngineHttpQueue][google.cloud.tasks.v2beta3.AppEngineHttpQueue] settings apply only to
   * [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest] in this queue.
   * [Http tasks][google.cloud.tasks.v2beta3.HttpRequest] are not affected by this proto.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.AppEngineHttpQueue app_engine_http_queue = 3;</code>
   *
   * @return Whether the appEngineHttpQueue field is set.
   */
  @java.lang.Override
  public boolean hasAppEngineHttpQueue() {
    return queueTypeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * [AppEngineHttpQueue][google.cloud.tasks.v2beta3.AppEngineHttpQueue] settings apply only to
   * [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest] in this queue.
   * [Http tasks][google.cloud.tasks.v2beta3.HttpRequest] are not affected by this proto.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.AppEngineHttpQueue app_engine_http_queue = 3;</code>
   *
   * @return The appEngineHttpQueue.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.AppEngineHttpQueue getAppEngineHttpQueue() {
    if (queueTypeCase_ == 3) {
      return (com.google.cloud.tasks.v2beta3.AppEngineHttpQueue) queueType_;
    }
    return com.google.cloud.tasks.v2beta3.AppEngineHttpQueue.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * [AppEngineHttpQueue][google.cloud.tasks.v2beta3.AppEngineHttpQueue] settings apply only to
   * [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest] in this queue.
   * [Http tasks][google.cloud.tasks.v2beta3.HttpRequest] are not affected by this proto.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.AppEngineHttpQueue app_engine_http_queue = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.AppEngineHttpQueueOrBuilder
      getAppEngineHttpQueueOrBuilder() {
    if (queueTypeCase_ == 3) {
      return (com.google.cloud.tasks.v2beta3.AppEngineHttpQueue) queueType_;
    }
    return com.google.cloud.tasks.v2beta3.AppEngineHttpQueue.getDefaultInstance();
  }

  public static final int RATE_LIMITS_FIELD_NUMBER = 4;
  private com.google.cloud.tasks.v2beta3.RateLimits rateLimits_;
  /**
   *
   *
   * <pre>
   * Rate limits for task dispatches.
   * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] are
   * related because they both control task attempts. However they control task
   * attempts in different ways:
   * * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] controls the total rate of
   *   dispatches from a queue (i.e. all traffic dispatched from the
   *   queue, regardless of whether the dispatch is from a first
   *   attempt or a retry).
   * * [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls what happens to
   *   particular a task after its first attempt fails. That is,
   *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls task retries (the
   *   second attempt, third attempt, etc).
   * The queue's actual dispatch rate is the result of:
   * * Number of tasks in the queue
   * * User-specified throttling: [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits],
   *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config], and the
   *   [queue's state][google.cloud.tasks.v2beta3.Queue.state].
   * * System throttling due to `429` (Too Many Requests) or `503` (Service
   *   Unavailable) responses from the worker, high error rates, or to smooth
   *   sudden large traffic spikes.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.RateLimits rate_limits = 4;</code>
   *
   * @return Whether the rateLimits field is set.
   */
  @java.lang.Override
  public boolean hasRateLimits() {
    return rateLimits_ != null;
  }
  /**
   *
   *
   * <pre>
   * Rate limits for task dispatches.
   * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] are
   * related because they both control task attempts. However they control task
   * attempts in different ways:
   * * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] controls the total rate of
   *   dispatches from a queue (i.e. all traffic dispatched from the
   *   queue, regardless of whether the dispatch is from a first
   *   attempt or a retry).
   * * [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls what happens to
   *   particular a task after its first attempt fails. That is,
   *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls task retries (the
   *   second attempt, third attempt, etc).
   * The queue's actual dispatch rate is the result of:
   * * Number of tasks in the queue
   * * User-specified throttling: [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits],
   *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config], and the
   *   [queue's state][google.cloud.tasks.v2beta3.Queue.state].
   * * System throttling due to `429` (Too Many Requests) or `503` (Service
   *   Unavailable) responses from the worker, high error rates, or to smooth
   *   sudden large traffic spikes.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.RateLimits rate_limits = 4;</code>
   *
   * @return The rateLimits.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.RateLimits getRateLimits() {
    return rateLimits_ == null
        ? com.google.cloud.tasks.v2beta3.RateLimits.getDefaultInstance()
        : rateLimits_;
  }
  /**
   *
   *
   * <pre>
   * Rate limits for task dispatches.
   * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] are
   * related because they both control task attempts. However they control task
   * attempts in different ways:
   * * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] controls the total rate of
   *   dispatches from a queue (i.e. all traffic dispatched from the
   *   queue, regardless of whether the dispatch is from a first
   *   attempt or a retry).
   * * [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls what happens to
   *   particular a task after its first attempt fails. That is,
   *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls task retries (the
   *   second attempt, third attempt, etc).
   * The queue's actual dispatch rate is the result of:
   * * Number of tasks in the queue
   * * User-specified throttling: [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits],
   *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config], and the
   *   [queue's state][google.cloud.tasks.v2beta3.Queue.state].
   * * System throttling due to `429` (Too Many Requests) or `503` (Service
   *   Unavailable) responses from the worker, high error rates, or to smooth
   *   sudden large traffic spikes.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.RateLimits rate_limits = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.RateLimitsOrBuilder getRateLimitsOrBuilder() {
    return rateLimits_ == null
        ? com.google.cloud.tasks.v2beta3.RateLimits.getDefaultInstance()
        : rateLimits_;
  }

  public static final int RETRY_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.tasks.v2beta3.RetryConfig retryConfig_;
  /**
   *
   *
   * <pre>
   * Settings that determine the retry behavior.
   * * For tasks created using Cloud Tasks: the queue-level retry settings
   *   apply to all tasks in the queue that were created using Cloud Tasks.
   *   Retry settings cannot be set on individual tasks.
   * * For tasks created using the App Engine SDK: the queue-level retry
   *   settings apply to all tasks in the queue which do not have retry settings
   *   explicitly set on the task and were created by the App Engine SDK. See
   *   [App Engine
   *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.RetryConfig retry_config = 5;</code>
   *
   * @return Whether the retryConfig field is set.
   */
  @java.lang.Override
  public boolean hasRetryConfig() {
    return retryConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Settings that determine the retry behavior.
   * * For tasks created using Cloud Tasks: the queue-level retry settings
   *   apply to all tasks in the queue that were created using Cloud Tasks.
   *   Retry settings cannot be set on individual tasks.
   * * For tasks created using the App Engine SDK: the queue-level retry
   *   settings apply to all tasks in the queue which do not have retry settings
   *   explicitly set on the task and were created by the App Engine SDK. See
   *   [App Engine
   *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.RetryConfig retry_config = 5;</code>
   *
   * @return The retryConfig.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.RetryConfig getRetryConfig() {
    return retryConfig_ == null
        ? com.google.cloud.tasks.v2beta3.RetryConfig.getDefaultInstance()
        : retryConfig_;
  }
  /**
   *
   *
   * <pre>
   * Settings that determine the retry behavior.
   * * For tasks created using Cloud Tasks: the queue-level retry settings
   *   apply to all tasks in the queue that were created using Cloud Tasks.
   *   Retry settings cannot be set on individual tasks.
   * * For tasks created using the App Engine SDK: the queue-level retry
   *   settings apply to all tasks in the queue which do not have retry settings
   *   explicitly set on the task and were created by the App Engine SDK. See
   *   [App Engine
   *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.RetryConfig retry_config = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.RetryConfigOrBuilder getRetryConfigOrBuilder() {
    return retryConfig_ == null
        ? com.google.cloud.tasks.v2beta3.RetryConfig.getDefaultInstance()
        : retryConfig_;
  }

  public static final int STATE_FIELD_NUMBER = 6;
  private int state_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The state of the queue.
   * `state` can only be changed by calling
   * [PauseQueue][google.cloud.tasks.v2beta3.CloudTasks.PauseQueue],
   * [ResumeQueue][google.cloud.tasks.v2beta3.CloudTasks.ResumeQueue], or uploading
   * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
   * [UpdateQueue][google.cloud.tasks.v2beta3.CloudTasks.UpdateQueue] cannot be used to change `state`.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.Queue.State state = 6;</code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The state of the queue.
   * `state` can only be changed by calling
   * [PauseQueue][google.cloud.tasks.v2beta3.CloudTasks.PauseQueue],
   * [ResumeQueue][google.cloud.tasks.v2beta3.CloudTasks.ResumeQueue], or uploading
   * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
   * [UpdateQueue][google.cloud.tasks.v2beta3.CloudTasks.UpdateQueue] cannot be used to change `state`.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.Queue.State state = 6;</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.Queue.State getState() {
    com.google.cloud.tasks.v2beta3.Queue.State result =
        com.google.cloud.tasks.v2beta3.Queue.State.forNumber(state_);
    return result == null ? com.google.cloud.tasks.v2beta3.Queue.State.UNRECOGNIZED : result;
  }

  public static final int PURGE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp purgeTime_;
  /**
   *
   *
   * <pre>
   * Output only. The last time this queue was purged.
   * All tasks that were [created][google.cloud.tasks.v2beta3.Task.create_time] before this time
   * were purged.
   * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2beta3.CloudTasks.PurgeQueue], the
   * [App Engine Task Queue SDK, or the Cloud
   * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
   * Purge time will be truncated to the nearest microsecond. Purge
   * time will be unset if the queue has never been purged.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp purge_time = 7;</code>
   *
   * @return Whether the purgeTime field is set.
   */
  @java.lang.Override
  public boolean hasPurgeTime() {
    return purgeTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last time this queue was purged.
   * All tasks that were [created][google.cloud.tasks.v2beta3.Task.create_time] before this time
   * were purged.
   * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2beta3.CloudTasks.PurgeQueue], the
   * [App Engine Task Queue SDK, or the Cloud
   * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
   * Purge time will be truncated to the nearest microsecond. Purge
   * time will be unset if the queue has never been purged.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp purge_time = 7;</code>
   *
   * @return The purgeTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getPurgeTime() {
    return purgeTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : purgeTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The last time this queue was purged.
   * All tasks that were [created][google.cloud.tasks.v2beta3.Task.create_time] before this time
   * were purged.
   * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2beta3.CloudTasks.PurgeQueue], the
   * [App Engine Task Queue SDK, or the Cloud
   * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
   * Purge time will be truncated to the nearest microsecond. Purge
   * time will be unset if the queue has never been purged.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp purge_time = 7;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getPurgeTimeOrBuilder() {
    return purgeTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : purgeTime_;
  }

  public static final int TASK_TTL_FIELD_NUMBER = 8;
  private com.google.protobuf.Duration taskTtl_;
  /**
   *
   *
   * <pre>
   * The maximum amount of time that a task will be retained in
   * this queue.
   * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
   * After a task has lived for `task_ttl`, the task will be deleted
   * regardless of whether it was dispatched or not.
   * The `task_ttl` for queues created via queue.yaml/xml is equal to the
   * maximum duration because there is a
   * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
   * these queues. To view the maximum valid duration, see the documentation for
   * [Duration][google.protobuf.Duration].
   * </pre>
   *
   * <code>.google.protobuf.Duration task_ttl = 8;</code>
   *
   * @return Whether the taskTtl field is set.
   */
  @java.lang.Override
  public boolean hasTaskTtl() {
    return taskTtl_ != null;
  }
  /**
   *
   *
   * <pre>
   * The maximum amount of time that a task will be retained in
   * this queue.
   * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
   * After a task has lived for `task_ttl`, the task will be deleted
   * regardless of whether it was dispatched or not.
   * The `task_ttl` for queues created via queue.yaml/xml is equal to the
   * maximum duration because there is a
   * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
   * these queues. To view the maximum valid duration, see the documentation for
   * [Duration][google.protobuf.Duration].
   * </pre>
   *
   * <code>.google.protobuf.Duration task_ttl = 8;</code>
   *
   * @return The taskTtl.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTaskTtl() {
    return taskTtl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : taskTtl_;
  }
  /**
   *
   *
   * <pre>
   * The maximum amount of time that a task will be retained in
   * this queue.
   * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
   * After a task has lived for `task_ttl`, the task will be deleted
   * regardless of whether it was dispatched or not.
   * The `task_ttl` for queues created via queue.yaml/xml is equal to the
   * maximum duration because there is a
   * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
   * these queues. To view the maximum valid duration, see the documentation for
   * [Duration][google.protobuf.Duration].
   * </pre>
   *
   * <code>.google.protobuf.Duration task_ttl = 8;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTaskTtlOrBuilder() {
    return taskTtl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : taskTtl_;
  }

  public static final int TOMBSTONE_TTL_FIELD_NUMBER = 9;
  private com.google.protobuf.Duration tombstoneTtl_;
  /**
   *
   *
   * <pre>
   * The task tombstone time to live (TTL).
   * After a task is deleted or executed, the task's tombstone is
   * retained for the length of time specified by `tombstone_ttl`.
   * The tombstone is used by task de-duplication; another task with the same
   * name can't be created until the tombstone has expired. For more information
   * about task de-duplication, see the documentation for
   * [CreateTaskRequest][google.cloud.tasks.v2beta3.CreateTaskRequest.task].
   * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
   * </pre>
   *
   * <code>.google.protobuf.Duration tombstone_ttl = 9;</code>
   *
   * @return Whether the tombstoneTtl field is set.
   */
  @java.lang.Override
  public boolean hasTombstoneTtl() {
    return tombstoneTtl_ != null;
  }
  /**
   *
   *
   * <pre>
   * The task tombstone time to live (TTL).
   * After a task is deleted or executed, the task's tombstone is
   * retained for the length of time specified by `tombstone_ttl`.
   * The tombstone is used by task de-duplication; another task with the same
   * name can't be created until the tombstone has expired. For more information
   * about task de-duplication, see the documentation for
   * [CreateTaskRequest][google.cloud.tasks.v2beta3.CreateTaskRequest.task].
   * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
   * </pre>
   *
   * <code>.google.protobuf.Duration tombstone_ttl = 9;</code>
   *
   * @return The tombstoneTtl.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTombstoneTtl() {
    return tombstoneTtl_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : tombstoneTtl_;
  }
  /**
   *
   *
   * <pre>
   * The task tombstone time to live (TTL).
   * After a task is deleted or executed, the task's tombstone is
   * retained for the length of time specified by `tombstone_ttl`.
   * The tombstone is used by task de-duplication; another task with the same
   * name can't be created until the tombstone has expired. For more information
   * about task de-duplication, see the documentation for
   * [CreateTaskRequest][google.cloud.tasks.v2beta3.CreateTaskRequest.task].
   * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
   * </pre>
   *
   * <code>.google.protobuf.Duration tombstone_ttl = 9;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTombstoneTtlOrBuilder() {
    return tombstoneTtl_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : tombstoneTtl_;
  }

  public static final int STACKDRIVER_LOGGING_CONFIG_FIELD_NUMBER = 10;
  private com.google.cloud.tasks.v2beta3.StackdriverLoggingConfig stackdriverLoggingConfig_;
  /**
   *
   *
   * <pre>
   * Configuration options for writing logs to
   * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
   * field is unset, then no logs are written.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.StackdriverLoggingConfig stackdriver_logging_config = 10;
   * </code>
   *
   * @return Whether the stackdriverLoggingConfig field is set.
   */
  @java.lang.Override
  public boolean hasStackdriverLoggingConfig() {
    return stackdriverLoggingConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Configuration options for writing logs to
   * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
   * field is unset, then no logs are written.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.StackdriverLoggingConfig stackdriver_logging_config = 10;
   * </code>
   *
   * @return The stackdriverLoggingConfig.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.StackdriverLoggingConfig getStackdriverLoggingConfig() {
    return stackdriverLoggingConfig_ == null
        ? com.google.cloud.tasks.v2beta3.StackdriverLoggingConfig.getDefaultInstance()
        : stackdriverLoggingConfig_;
  }
  /**
   *
   *
   * <pre>
   * Configuration options for writing logs to
   * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
   * field is unset, then no logs are written.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.StackdriverLoggingConfig stackdriver_logging_config = 10;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.StackdriverLoggingConfigOrBuilder
      getStackdriverLoggingConfigOrBuilder() {
    return stackdriverLoggingConfig_ == null
        ? com.google.cloud.tasks.v2beta3.StackdriverLoggingConfig.getDefaultInstance()
        : stackdriverLoggingConfig_;
  }

  public static final int TYPE_FIELD_NUMBER = 11;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Immutable. The type of a queue (push or pull).
   * `Queue.type` is an immutable property of the queue that is set at the queue
   * creation time. When left unspecified, the default value of `PUSH` is
   * selected.
   * </pre>
   *
   * <code>
   * .google.cloud.tasks.v2beta3.Queue.Type type = 11 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Immutable. The type of a queue (push or pull).
   * `Queue.type` is an immutable property of the queue that is set at the queue
   * creation time. When left unspecified, the default value of `PUSH` is
   * selected.
   * </pre>
   *
   * <code>
   * .google.cloud.tasks.v2beta3.Queue.Type type = 11 [(.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.Queue.Type getType() {
    com.google.cloud.tasks.v2beta3.Queue.Type result =
        com.google.cloud.tasks.v2beta3.Queue.Type.forNumber(type_);
    return result == null ? com.google.cloud.tasks.v2beta3.Queue.Type.UNRECOGNIZED : result;
  }

  public static final int STATS_FIELD_NUMBER = 12;
  private com.google.cloud.tasks.v2beta3.QueueStats stats_;
  /**
   *
   *
   * <pre>
   * Output only. The realtime, informational statistics for a queue. In order
   * to receive the statistics the caller should include this field in the
   * FieldMask.
   * </pre>
   *
   * <code>
   * .google.cloud.tasks.v2beta3.QueueStats stats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the stats field is set.
   */
  @java.lang.Override
  public boolean hasStats() {
    return stats_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The realtime, informational statistics for a queue. In order
   * to receive the statistics the caller should include this field in the
   * FieldMask.
   * </pre>
   *
   * <code>
   * .google.cloud.tasks.v2beta3.QueueStats stats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The stats.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.QueueStats getStats() {
    return stats_ == null ? com.google.cloud.tasks.v2beta3.QueueStats.getDefaultInstance() : stats_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The realtime, informational statistics for a queue. In order
   * to receive the statistics the caller should include this field in the
   * FieldMask.
   * </pre>
   *
   * <code>
   * .google.cloud.tasks.v2beta3.QueueStats stats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.QueueStatsOrBuilder getStatsOrBuilder() {
    return stats_ == null ? com.google.cloud.tasks.v2beta3.QueueStats.getDefaultInstance() : stats_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (queueTypeCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.tasks.v2beta3.AppEngineHttpQueue) queueType_);
    }
    if (rateLimits_ != null) {
      output.writeMessage(4, getRateLimits());
    }
    if (retryConfig_ != null) {
      output.writeMessage(5, getRetryConfig());
    }
    if (state_ != com.google.cloud.tasks.v2beta3.Queue.State.STATE_UNSPECIFIED.getNumber()) {
      output.writeEnum(6, state_);
    }
    if (purgeTime_ != null) {
      output.writeMessage(7, getPurgeTime());
    }
    if (taskTtl_ != null) {
      output.writeMessage(8, getTaskTtl());
    }
    if (tombstoneTtl_ != null) {
      output.writeMessage(9, getTombstoneTtl());
    }
    if (stackdriverLoggingConfig_ != null) {
      output.writeMessage(10, getStackdriverLoggingConfig());
    }
    if (type_ != com.google.cloud.tasks.v2beta3.Queue.Type.TYPE_UNSPECIFIED.getNumber()) {
      output.writeEnum(11, type_);
    }
    if (stats_ != null) {
      output.writeMessage(12, getStats());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (queueTypeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.tasks.v2beta3.AppEngineHttpQueue) queueType_);
    }
    if (rateLimits_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getRateLimits());
    }
    if (retryConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getRetryConfig());
    }
    if (state_ != com.google.cloud.tasks.v2beta3.Queue.State.STATE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, state_);
    }
    if (purgeTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getPurgeTime());
    }
    if (taskTtl_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getTaskTtl());
    }
    if (tombstoneTtl_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getTombstoneTtl());
    }
    if (stackdriverLoggingConfig_ != null) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, getStackdriverLoggingConfig());
    }
    if (type_ != com.google.cloud.tasks.v2beta3.Queue.Type.TYPE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(11, type_);
    }
    if (stats_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getStats());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.tasks.v2beta3.Queue)) {
      return super.equals(obj);
    }
    com.google.cloud.tasks.v2beta3.Queue other = (com.google.cloud.tasks.v2beta3.Queue) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasRateLimits() != other.hasRateLimits()) return false;
    if (hasRateLimits()) {
      if (!getRateLimits().equals(other.getRateLimits())) return false;
    }
    if (hasRetryConfig() != other.hasRetryConfig()) return false;
    if (hasRetryConfig()) {
      if (!getRetryConfig().equals(other.getRetryConfig())) return false;
    }
    if (state_ != other.state_) return false;
    if (hasPurgeTime() != other.hasPurgeTime()) return false;
    if (hasPurgeTime()) {
      if (!getPurgeTime().equals(other.getPurgeTime())) return false;
    }
    if (hasTaskTtl() != other.hasTaskTtl()) return false;
    if (hasTaskTtl()) {
      if (!getTaskTtl().equals(other.getTaskTtl())) return false;
    }
    if (hasTombstoneTtl() != other.hasTombstoneTtl()) return false;
    if (hasTombstoneTtl()) {
      if (!getTombstoneTtl().equals(other.getTombstoneTtl())) return false;
    }
    if (hasStackdriverLoggingConfig() != other.hasStackdriverLoggingConfig()) return false;
    if (hasStackdriverLoggingConfig()) {
      if (!getStackdriverLoggingConfig().equals(other.getStackdriverLoggingConfig())) return false;
    }
    if (type_ != other.type_) return false;
    if (hasStats() != other.hasStats()) return false;
    if (hasStats()) {
      if (!getStats().equals(other.getStats())) return false;
    }
    if (!getQueueTypeCase().equals(other.getQueueTypeCase())) return false;
    switch (queueTypeCase_) {
      case 3:
        if (!getAppEngineHttpQueue().equals(other.getAppEngineHttpQueue())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasRateLimits()) {
      hash = (37 * hash) + RATE_LIMITS_FIELD_NUMBER;
      hash = (53 * hash) + getRateLimits().hashCode();
    }
    if (hasRetryConfig()) {
      hash = (37 * hash) + RETRY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getRetryConfig().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasPurgeTime()) {
      hash = (37 * hash) + PURGE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getPurgeTime().hashCode();
    }
    if (hasTaskTtl()) {
      hash = (37 * hash) + TASK_TTL_FIELD_NUMBER;
      hash = (53 * hash) + getTaskTtl().hashCode();
    }
    if (hasTombstoneTtl()) {
      hash = (37 * hash) + TOMBSTONE_TTL_FIELD_NUMBER;
      hash = (53 * hash) + getTombstoneTtl().hashCode();
    }
    if (hasStackdriverLoggingConfig()) {
      hash = (37 * hash) + STACKDRIVER_LOGGING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getStackdriverLoggingConfig().hashCode();
    }
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    if (hasStats()) {
      hash = (37 * hash) + STATS_FIELD_NUMBER;
      hash = (53 * hash) + getStats().hashCode();
    }
    switch (queueTypeCase_) {
      case 3:
        hash = (37 * hash) + APP_ENGINE_HTTP_QUEUE_FIELD_NUMBER;
        hash = (53 * hash) + getAppEngineHttpQueue().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.tasks.v2beta3.Queue parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.Queue parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.Queue parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.Queue parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.Queue parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.Queue parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.Queue parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.Queue parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.Queue parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.Queue parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.Queue parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.Queue parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.tasks.v2beta3.Queue prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A queue is a container of related tasks. Queues are configured to manage
   * how those tasks are dispatched. Configurable properties include rate limits,
   * retry options, queue types, and others.
   * </pre>
   *
   * Protobuf type {@code google.cloud.tasks.v2beta3.Queue}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.tasks.v2beta3.Queue)
      com.google.cloud.tasks.v2beta3.QueueOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.tasks.v2beta3.QueueProto
          .internal_static_google_cloud_tasks_v2beta3_Queue_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.tasks.v2beta3.QueueProto
          .internal_static_google_cloud_tasks_v2beta3_Queue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.tasks.v2beta3.Queue.class,
              com.google.cloud.tasks.v2beta3.Queue.Builder.class);
    }

    // Construct using com.google.cloud.tasks.v2beta3.Queue.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      if (appEngineHttpQueueBuilder_ != null) {
        appEngineHttpQueueBuilder_.clear();
      }
      rateLimits_ = null;
      if (rateLimitsBuilder_ != null) {
        rateLimitsBuilder_.dispose();
        rateLimitsBuilder_ = null;
      }
      retryConfig_ = null;
      if (retryConfigBuilder_ != null) {
        retryConfigBuilder_.dispose();
        retryConfigBuilder_ = null;
      }
      state_ = 0;
      purgeTime_ = null;
      if (purgeTimeBuilder_ != null) {
        purgeTimeBuilder_.dispose();
        purgeTimeBuilder_ = null;
      }
      taskTtl_ = null;
      if (taskTtlBuilder_ != null) {
        taskTtlBuilder_.dispose();
        taskTtlBuilder_ = null;
      }
      tombstoneTtl_ = null;
      if (tombstoneTtlBuilder_ != null) {
        tombstoneTtlBuilder_.dispose();
        tombstoneTtlBuilder_ = null;
      }
      stackdriverLoggingConfig_ = null;
      if (stackdriverLoggingConfigBuilder_ != null) {
        stackdriverLoggingConfigBuilder_.dispose();
        stackdriverLoggingConfigBuilder_ = null;
      }
      type_ = 0;
      stats_ = null;
      if (statsBuilder_ != null) {
        statsBuilder_.dispose();
        statsBuilder_ = null;
      }
      queueTypeCase_ = 0;
      queueType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.tasks.v2beta3.QueueProto
          .internal_static_google_cloud_tasks_v2beta3_Queue_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.Queue getDefaultInstanceForType() {
      return com.google.cloud.tasks.v2beta3.Queue.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.Queue build() {
      com.google.cloud.tasks.v2beta3.Queue result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.Queue buildPartial() {
      com.google.cloud.tasks.v2beta3.Queue result = new com.google.cloud.tasks.v2beta3.Queue(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.tasks.v2beta3.Queue result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.rateLimits_ = rateLimitsBuilder_ == null ? rateLimits_ : rateLimitsBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.retryConfig_ =
            retryConfigBuilder_ == null ? retryConfig_ : retryConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.purgeTime_ = purgeTimeBuilder_ == null ? purgeTime_ : purgeTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.taskTtl_ = taskTtlBuilder_ == null ? taskTtl_ : taskTtlBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.tombstoneTtl_ =
            tombstoneTtlBuilder_ == null ? tombstoneTtl_ : tombstoneTtlBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.stackdriverLoggingConfig_ =
            stackdriverLoggingConfigBuilder_ == null
                ? stackdriverLoggingConfig_
                : stackdriverLoggingConfigBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.stats_ = statsBuilder_ == null ? stats_ : statsBuilder_.build();
      }
    }

    private void buildPartialOneofs(com.google.cloud.tasks.v2beta3.Queue result) {
      result.queueTypeCase_ = queueTypeCase_;
      result.queueType_ = this.queueType_;
      if (queueTypeCase_ == 3 && appEngineHttpQueueBuilder_ != null) {
        result.queueType_ = appEngineHttpQueueBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.tasks.v2beta3.Queue) {
        return mergeFrom((com.google.cloud.tasks.v2beta3.Queue) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.tasks.v2beta3.Queue other) {
      if (other == com.google.cloud.tasks.v2beta3.Queue.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasRateLimits()) {
        mergeRateLimits(other.getRateLimits());
      }
      if (other.hasRetryConfig()) {
        mergeRetryConfig(other.getRetryConfig());
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasPurgeTime()) {
        mergePurgeTime(other.getPurgeTime());
      }
      if (other.hasTaskTtl()) {
        mergeTaskTtl(other.getTaskTtl());
      }
      if (other.hasTombstoneTtl()) {
        mergeTombstoneTtl(other.getTombstoneTtl());
      }
      if (other.hasStackdriverLoggingConfig()) {
        mergeStackdriverLoggingConfig(other.getStackdriverLoggingConfig());
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.hasStats()) {
        mergeStats(other.getStats());
      }
      switch (other.getQueueTypeCase()) {
        case APP_ENGINE_HTTP_QUEUE:
          {
            mergeAppEngineHttpQueue(other.getAppEngineHttpQueue());
            break;
          }
        case QUEUETYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(
                    getAppEngineHttpQueueFieldBuilder().getBuilder(), extensionRegistry);
                queueTypeCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getRateLimitsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getRetryConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            case 48:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000010;
                break;
              } // case 48
            case 58:
              {
                input.readMessage(getPurgeTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getTaskTtlFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getTombstoneTtlFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(
                    getStackdriverLoggingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            case 88:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000200;
                break;
              } // case 88
            case 98:
              {
                input.readMessage(getStatsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int queueTypeCase_ = 0;
    private java.lang.Object queueType_;

    public QueueTypeCase getQueueTypeCase() {
      return QueueTypeCase.forNumber(queueTypeCase_);
    }

    public Builder clearQueueType() {
      queueTypeCase_ = 0;
      queueType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Caller-specified and required in [CreateQueue][google.cloud.tasks.v2beta3.CloudTasks.CreateQueue],
     * after which it becomes output only.
     * The queue name.
     * The queue name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the queue's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Caller-specified and required in [CreateQueue][google.cloud.tasks.v2beta3.CloudTasks.CreateQueue],
     * after which it becomes output only.
     * The queue name.
     * The queue name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the queue's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Caller-specified and required in [CreateQueue][google.cloud.tasks.v2beta3.CloudTasks.CreateQueue],
     * after which it becomes output only.
     * The queue name.
     * The queue name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the queue's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Caller-specified and required in [CreateQueue][google.cloud.tasks.v2beta3.CloudTasks.CreateQueue],
     * after which it becomes output only.
     * The queue name.
     * The queue name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the queue's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Caller-specified and required in [CreateQueue][google.cloud.tasks.v2beta3.CloudTasks.CreateQueue],
     * after which it becomes output only.
     * The queue name.
     * The queue name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID`
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the queue's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.AppEngineHttpQueue,
            com.google.cloud.tasks.v2beta3.AppEngineHttpQueue.Builder,
            com.google.cloud.tasks.v2beta3.AppEngineHttpQueueOrBuilder>
        appEngineHttpQueueBuilder_;
    /**
     *
     *
     * <pre>
     * [AppEngineHttpQueue][google.cloud.tasks.v2beta3.AppEngineHttpQueue] settings apply only to
     * [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest] in this queue.
     * [Http tasks][google.cloud.tasks.v2beta3.HttpRequest] are not affected by this proto.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineHttpQueue app_engine_http_queue = 3;</code>
     *
     * @return Whether the appEngineHttpQueue field is set.
     */
    @java.lang.Override
    public boolean hasAppEngineHttpQueue() {
      return queueTypeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * [AppEngineHttpQueue][google.cloud.tasks.v2beta3.AppEngineHttpQueue] settings apply only to
     * [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest] in this queue.
     * [Http tasks][google.cloud.tasks.v2beta3.HttpRequest] are not affected by this proto.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineHttpQueue app_engine_http_queue = 3;</code>
     *
     * @return The appEngineHttpQueue.
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.AppEngineHttpQueue getAppEngineHttpQueue() {
      if (appEngineHttpQueueBuilder_ == null) {
        if (queueTypeCase_ == 3) {
          return (com.google.cloud.tasks.v2beta3.AppEngineHttpQueue) queueType_;
        }
        return com.google.cloud.tasks.v2beta3.AppEngineHttpQueue.getDefaultInstance();
      } else {
        if (queueTypeCase_ == 3) {
          return appEngineHttpQueueBuilder_.getMessage();
        }
        return com.google.cloud.tasks.v2beta3.AppEngineHttpQueue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * [AppEngineHttpQueue][google.cloud.tasks.v2beta3.AppEngineHttpQueue] settings apply only to
     * [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest] in this queue.
     * [Http tasks][google.cloud.tasks.v2beta3.HttpRequest] are not affected by this proto.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineHttpQueue app_engine_http_queue = 3;</code>
     */
    public Builder setAppEngineHttpQueue(com.google.cloud.tasks.v2beta3.AppEngineHttpQueue value) {
      if (appEngineHttpQueueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queueType_ = value;
        onChanged();
      } else {
        appEngineHttpQueueBuilder_.setMessage(value);
      }
      queueTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * [AppEngineHttpQueue][google.cloud.tasks.v2beta3.AppEngineHttpQueue] settings apply only to
     * [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest] in this queue.
     * [Http tasks][google.cloud.tasks.v2beta3.HttpRequest] are not affected by this proto.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineHttpQueue app_engine_http_queue = 3;</code>
     */
    public Builder setAppEngineHttpQueue(
        com.google.cloud.tasks.v2beta3.AppEngineHttpQueue.Builder builderForValue) {
      if (appEngineHttpQueueBuilder_ == null) {
        queueType_ = builderForValue.build();
        onChanged();
      } else {
        appEngineHttpQueueBuilder_.setMessage(builderForValue.build());
      }
      queueTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * [AppEngineHttpQueue][google.cloud.tasks.v2beta3.AppEngineHttpQueue] settings apply only to
     * [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest] in this queue.
     * [Http tasks][google.cloud.tasks.v2beta3.HttpRequest] are not affected by this proto.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineHttpQueue app_engine_http_queue = 3;</code>
     */
    public Builder mergeAppEngineHttpQueue(
        com.google.cloud.tasks.v2beta3.AppEngineHttpQueue value) {
      if (appEngineHttpQueueBuilder_ == null) {
        if (queueTypeCase_ == 3
            && queueType_
                != com.google.cloud.tasks.v2beta3.AppEngineHttpQueue.getDefaultInstance()) {
          queueType_ =
              com.google.cloud.tasks.v2beta3.AppEngineHttpQueue.newBuilder(
                      (com.google.cloud.tasks.v2beta3.AppEngineHttpQueue) queueType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          queueType_ = value;
        }
        onChanged();
      } else {
        if (queueTypeCase_ == 3) {
          appEngineHttpQueueBuilder_.mergeFrom(value);
        } else {
          appEngineHttpQueueBuilder_.setMessage(value);
        }
      }
      queueTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * [AppEngineHttpQueue][google.cloud.tasks.v2beta3.AppEngineHttpQueue] settings apply only to
     * [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest] in this queue.
     * [Http tasks][google.cloud.tasks.v2beta3.HttpRequest] are not affected by this proto.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineHttpQueue app_engine_http_queue = 3;</code>
     */
    public Builder clearAppEngineHttpQueue() {
      if (appEngineHttpQueueBuilder_ == null) {
        if (queueTypeCase_ == 3) {
          queueTypeCase_ = 0;
          queueType_ = null;
          onChanged();
        }
      } else {
        if (queueTypeCase_ == 3) {
          queueTypeCase_ = 0;
          queueType_ = null;
        }
        appEngineHttpQueueBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * [AppEngineHttpQueue][google.cloud.tasks.v2beta3.AppEngineHttpQueue] settings apply only to
     * [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest] in this queue.
     * [Http tasks][google.cloud.tasks.v2beta3.HttpRequest] are not affected by this proto.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineHttpQueue app_engine_http_queue = 3;</code>
     */
    public com.google.cloud.tasks.v2beta3.AppEngineHttpQueue.Builder
        getAppEngineHttpQueueBuilder() {
      return getAppEngineHttpQueueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * [AppEngineHttpQueue][google.cloud.tasks.v2beta3.AppEngineHttpQueue] settings apply only to
     * [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest] in this queue.
     * [Http tasks][google.cloud.tasks.v2beta3.HttpRequest] are not affected by this proto.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineHttpQueue app_engine_http_queue = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.AppEngineHttpQueueOrBuilder
        getAppEngineHttpQueueOrBuilder() {
      if ((queueTypeCase_ == 3) && (appEngineHttpQueueBuilder_ != null)) {
        return appEngineHttpQueueBuilder_.getMessageOrBuilder();
      } else {
        if (queueTypeCase_ == 3) {
          return (com.google.cloud.tasks.v2beta3.AppEngineHttpQueue) queueType_;
        }
        return com.google.cloud.tasks.v2beta3.AppEngineHttpQueue.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * [AppEngineHttpQueue][google.cloud.tasks.v2beta3.AppEngineHttpQueue] settings apply only to
     * [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest] in this queue.
     * [Http tasks][google.cloud.tasks.v2beta3.HttpRequest] are not affected by this proto.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineHttpQueue app_engine_http_queue = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.AppEngineHttpQueue,
            com.google.cloud.tasks.v2beta3.AppEngineHttpQueue.Builder,
            com.google.cloud.tasks.v2beta3.AppEngineHttpQueueOrBuilder>
        getAppEngineHttpQueueFieldBuilder() {
      if (appEngineHttpQueueBuilder_ == null) {
        if (!(queueTypeCase_ == 3)) {
          queueType_ = com.google.cloud.tasks.v2beta3.AppEngineHttpQueue.getDefaultInstance();
        }
        appEngineHttpQueueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2beta3.AppEngineHttpQueue,
                com.google.cloud.tasks.v2beta3.AppEngineHttpQueue.Builder,
                com.google.cloud.tasks.v2beta3.AppEngineHttpQueueOrBuilder>(
                (com.google.cloud.tasks.v2beta3.AppEngineHttpQueue) queueType_,
                getParentForChildren(),
                isClean());
        queueType_ = null;
      }
      queueTypeCase_ = 3;
      onChanged();
      return appEngineHttpQueueBuilder_;
    }

    private com.google.cloud.tasks.v2beta3.RateLimits rateLimits_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.RateLimits,
            com.google.cloud.tasks.v2beta3.RateLimits.Builder,
            com.google.cloud.tasks.v2beta3.RateLimitsOrBuilder>
        rateLimitsBuilder_;
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] are
     * related because they both control task attempts. However they control task
     * attempts in different ways:
     * * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] controls the total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls task retries (the
     *   second attempt, third attempt, etc).
     * The queue's actual dispatch rate is the result of:
     * * Number of tasks in the queue
     * * User-specified throttling: [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits],
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config], and the
     *   [queue's state][google.cloud.tasks.v2beta3.Queue.state].
     * * System throttling due to `429` (Too Many Requests) or `503` (Service
     *   Unavailable) responses from the worker, high error rates, or to smooth
     *   sudden large traffic spikes.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.RateLimits rate_limits = 4;</code>
     *
     * @return Whether the rateLimits field is set.
     */
    public boolean hasRateLimits() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] are
     * related because they both control task attempts. However they control task
     * attempts in different ways:
     * * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] controls the total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls task retries (the
     *   second attempt, third attempt, etc).
     * The queue's actual dispatch rate is the result of:
     * * Number of tasks in the queue
     * * User-specified throttling: [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits],
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config], and the
     *   [queue's state][google.cloud.tasks.v2beta3.Queue.state].
     * * System throttling due to `429` (Too Many Requests) or `503` (Service
     *   Unavailable) responses from the worker, high error rates, or to smooth
     *   sudden large traffic spikes.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.RateLimits rate_limits = 4;</code>
     *
     * @return The rateLimits.
     */
    public com.google.cloud.tasks.v2beta3.RateLimits getRateLimits() {
      if (rateLimitsBuilder_ == null) {
        return rateLimits_ == null
            ? com.google.cloud.tasks.v2beta3.RateLimits.getDefaultInstance()
            : rateLimits_;
      } else {
        return rateLimitsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] are
     * related because they both control task attempts. However they control task
     * attempts in different ways:
     * * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] controls the total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls task retries (the
     *   second attempt, third attempt, etc).
     * The queue's actual dispatch rate is the result of:
     * * Number of tasks in the queue
     * * User-specified throttling: [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits],
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config], and the
     *   [queue's state][google.cloud.tasks.v2beta3.Queue.state].
     * * System throttling due to `429` (Too Many Requests) or `503` (Service
     *   Unavailable) responses from the worker, high error rates, or to smooth
     *   sudden large traffic spikes.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.RateLimits rate_limits = 4;</code>
     */
    public Builder setRateLimits(com.google.cloud.tasks.v2beta3.RateLimits value) {
      if (rateLimitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rateLimits_ = value;
      } else {
        rateLimitsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] are
     * related because they both control task attempts. However they control task
     * attempts in different ways:
     * * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] controls the total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls task retries (the
     *   second attempt, third attempt, etc).
     * The queue's actual dispatch rate is the result of:
     * * Number of tasks in the queue
     * * User-specified throttling: [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits],
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config], and the
     *   [queue's state][google.cloud.tasks.v2beta3.Queue.state].
     * * System throttling due to `429` (Too Many Requests) or `503` (Service
     *   Unavailable) responses from the worker, high error rates, or to smooth
     *   sudden large traffic spikes.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.RateLimits rate_limits = 4;</code>
     */
    public Builder setRateLimits(
        com.google.cloud.tasks.v2beta3.RateLimits.Builder builderForValue) {
      if (rateLimitsBuilder_ == null) {
        rateLimits_ = builderForValue.build();
      } else {
        rateLimitsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] are
     * related because they both control task attempts. However they control task
     * attempts in different ways:
     * * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] controls the total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls task retries (the
     *   second attempt, third attempt, etc).
     * The queue's actual dispatch rate is the result of:
     * * Number of tasks in the queue
     * * User-specified throttling: [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits],
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config], and the
     *   [queue's state][google.cloud.tasks.v2beta3.Queue.state].
     * * System throttling due to `429` (Too Many Requests) or `503` (Service
     *   Unavailable) responses from the worker, high error rates, or to smooth
     *   sudden large traffic spikes.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.RateLimits rate_limits = 4;</code>
     */
    public Builder mergeRateLimits(com.google.cloud.tasks.v2beta3.RateLimits value) {
      if (rateLimitsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && rateLimits_ != null
            && rateLimits_ != com.google.cloud.tasks.v2beta3.RateLimits.getDefaultInstance()) {
          getRateLimitsBuilder().mergeFrom(value);
        } else {
          rateLimits_ = value;
        }
      } else {
        rateLimitsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] are
     * related because they both control task attempts. However they control task
     * attempts in different ways:
     * * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] controls the total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls task retries (the
     *   second attempt, third attempt, etc).
     * The queue's actual dispatch rate is the result of:
     * * Number of tasks in the queue
     * * User-specified throttling: [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits],
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config], and the
     *   [queue's state][google.cloud.tasks.v2beta3.Queue.state].
     * * System throttling due to `429` (Too Many Requests) or `503` (Service
     *   Unavailable) responses from the worker, high error rates, or to smooth
     *   sudden large traffic spikes.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.RateLimits rate_limits = 4;</code>
     */
    public Builder clearRateLimits() {
      bitField0_ = (bitField0_ & ~0x00000004);
      rateLimits_ = null;
      if (rateLimitsBuilder_ != null) {
        rateLimitsBuilder_.dispose();
        rateLimitsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] are
     * related because they both control task attempts. However they control task
     * attempts in different ways:
     * * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] controls the total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls task retries (the
     *   second attempt, third attempt, etc).
     * The queue's actual dispatch rate is the result of:
     * * Number of tasks in the queue
     * * User-specified throttling: [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits],
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config], and the
     *   [queue's state][google.cloud.tasks.v2beta3.Queue.state].
     * * System throttling due to `429` (Too Many Requests) or `503` (Service
     *   Unavailable) responses from the worker, high error rates, or to smooth
     *   sudden large traffic spikes.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.RateLimits rate_limits = 4;</code>
     */
    public com.google.cloud.tasks.v2beta3.RateLimits.Builder getRateLimitsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getRateLimitsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] are
     * related because they both control task attempts. However they control task
     * attempts in different ways:
     * * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] controls the total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls task retries (the
     *   second attempt, third attempt, etc).
     * The queue's actual dispatch rate is the result of:
     * * Number of tasks in the queue
     * * User-specified throttling: [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits],
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config], and the
     *   [queue's state][google.cloud.tasks.v2beta3.Queue.state].
     * * System throttling due to `429` (Too Many Requests) or `503` (Service
     *   Unavailable) responses from the worker, high error rates, or to smooth
     *   sudden large traffic spikes.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.RateLimits rate_limits = 4;</code>
     */
    public com.google.cloud.tasks.v2beta3.RateLimitsOrBuilder getRateLimitsOrBuilder() {
      if (rateLimitsBuilder_ != null) {
        return rateLimitsBuilder_.getMessageOrBuilder();
      } else {
        return rateLimits_ == null
            ? com.google.cloud.tasks.v2beta3.RateLimits.getDefaultInstance()
            : rateLimits_;
      }
    }
    /**
     *
     *
     * <pre>
     * Rate limits for task dispatches.
     * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] and [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] are
     * related because they both control task attempts. However they control task
     * attempts in different ways:
     * * [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits] controls the total rate of
     *   dispatches from a queue (i.e. all traffic dispatched from the
     *   queue, regardless of whether the dispatch is from a first
     *   attempt or a retry).
     * * [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls what happens to
     *   particular a task after its first attempt fails. That is,
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config] controls task retries (the
     *   second attempt, third attempt, etc).
     * The queue's actual dispatch rate is the result of:
     * * Number of tasks in the queue
     * * User-specified throttling: [rate_limits][google.cloud.tasks.v2beta3.Queue.rate_limits],
     *   [retry_config][google.cloud.tasks.v2beta3.Queue.retry_config], and the
     *   [queue's state][google.cloud.tasks.v2beta3.Queue.state].
     * * System throttling due to `429` (Too Many Requests) or `503` (Service
     *   Unavailable) responses from the worker, high error rates, or to smooth
     *   sudden large traffic spikes.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.RateLimits rate_limits = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.RateLimits,
            com.google.cloud.tasks.v2beta3.RateLimits.Builder,
            com.google.cloud.tasks.v2beta3.RateLimitsOrBuilder>
        getRateLimitsFieldBuilder() {
      if (rateLimitsBuilder_ == null) {
        rateLimitsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2beta3.RateLimits,
                com.google.cloud.tasks.v2beta3.RateLimits.Builder,
                com.google.cloud.tasks.v2beta3.RateLimitsOrBuilder>(
                getRateLimits(), getParentForChildren(), isClean());
        rateLimits_ = null;
      }
      return rateLimitsBuilder_;
    }

    private com.google.cloud.tasks.v2beta3.RetryConfig retryConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.RetryConfig,
            com.google.cloud.tasks.v2beta3.RetryConfig.Builder,
            com.google.cloud.tasks.v2beta3.RetryConfigOrBuilder>
        retryConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.RetryConfig retry_config = 5;</code>
     *
     * @return Whether the retryConfig field is set.
     */
    public boolean hasRetryConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.RetryConfig retry_config = 5;</code>
     *
     * @return The retryConfig.
     */
    public com.google.cloud.tasks.v2beta3.RetryConfig getRetryConfig() {
      if (retryConfigBuilder_ == null) {
        return retryConfig_ == null
            ? com.google.cloud.tasks.v2beta3.RetryConfig.getDefaultInstance()
            : retryConfig_;
      } else {
        return retryConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.RetryConfig retry_config = 5;</code>
     */
    public Builder setRetryConfig(com.google.cloud.tasks.v2beta3.RetryConfig value) {
      if (retryConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retryConfig_ = value;
      } else {
        retryConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.RetryConfig retry_config = 5;</code>
     */
    public Builder setRetryConfig(
        com.google.cloud.tasks.v2beta3.RetryConfig.Builder builderForValue) {
      if (retryConfigBuilder_ == null) {
        retryConfig_ = builderForValue.build();
      } else {
        retryConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.RetryConfig retry_config = 5;</code>
     */
    public Builder mergeRetryConfig(com.google.cloud.tasks.v2beta3.RetryConfig value) {
      if (retryConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && retryConfig_ != null
            && retryConfig_ != com.google.cloud.tasks.v2beta3.RetryConfig.getDefaultInstance()) {
          getRetryConfigBuilder().mergeFrom(value);
        } else {
          retryConfig_ = value;
        }
      } else {
        retryConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.RetryConfig retry_config = 5;</code>
     */
    public Builder clearRetryConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      retryConfig_ = null;
      if (retryConfigBuilder_ != null) {
        retryConfigBuilder_.dispose();
        retryConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.RetryConfig retry_config = 5;</code>
     */
    public com.google.cloud.tasks.v2beta3.RetryConfig.Builder getRetryConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getRetryConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.RetryConfig retry_config = 5;</code>
     */
    public com.google.cloud.tasks.v2beta3.RetryConfigOrBuilder getRetryConfigOrBuilder() {
      if (retryConfigBuilder_ != null) {
        return retryConfigBuilder_.getMessageOrBuilder();
      } else {
        return retryConfig_ == null
            ? com.google.cloud.tasks.v2beta3.RetryConfig.getDefaultInstance()
            : retryConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Settings that determine the retry behavior.
     * * For tasks created using Cloud Tasks: the queue-level retry settings
     *   apply to all tasks in the queue that were created using Cloud Tasks.
     *   Retry settings cannot be set on individual tasks.
     * * For tasks created using the App Engine SDK: the queue-level retry
     *   settings apply to all tasks in the queue which do not have retry settings
     *   explicitly set on the task and were created by the App Engine SDK. See
     *   [App Engine
     *   documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.RetryConfig retry_config = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.RetryConfig,
            com.google.cloud.tasks.v2beta3.RetryConfig.Builder,
            com.google.cloud.tasks.v2beta3.RetryConfigOrBuilder>
        getRetryConfigFieldBuilder() {
      if (retryConfigBuilder_ == null) {
        retryConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2beta3.RetryConfig,
                com.google.cloud.tasks.v2beta3.RetryConfig.Builder,
                com.google.cloud.tasks.v2beta3.RetryConfigOrBuilder>(
                getRetryConfig(), getParentForChildren(), isClean());
        retryConfig_ = null;
      }
      return retryConfigBuilder_;
    }

    private int state_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The state of the queue.
     * `state` can only be changed by calling
     * [PauseQueue][google.cloud.tasks.v2beta3.CloudTasks.PauseQueue],
     * [ResumeQueue][google.cloud.tasks.v2beta3.CloudTasks.ResumeQueue], or uploading
     * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     * [UpdateQueue][google.cloud.tasks.v2beta3.CloudTasks.UpdateQueue] cannot be used to change `state`.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Queue.State state = 6;</code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the queue.
     * `state` can only be changed by calling
     * [PauseQueue][google.cloud.tasks.v2beta3.CloudTasks.PauseQueue],
     * [ResumeQueue][google.cloud.tasks.v2beta3.CloudTasks.ResumeQueue], or uploading
     * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     * [UpdateQueue][google.cloud.tasks.v2beta3.CloudTasks.UpdateQueue] cannot be used to change `state`.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Queue.State state = 6;</code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the queue.
     * `state` can only be changed by calling
     * [PauseQueue][google.cloud.tasks.v2beta3.CloudTasks.PauseQueue],
     * [ResumeQueue][google.cloud.tasks.v2beta3.CloudTasks.ResumeQueue], or uploading
     * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     * [UpdateQueue][google.cloud.tasks.v2beta3.CloudTasks.UpdateQueue] cannot be used to change `state`.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Queue.State state = 6;</code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.Queue.State getState() {
      com.google.cloud.tasks.v2beta3.Queue.State result =
          com.google.cloud.tasks.v2beta3.Queue.State.forNumber(state_);
      return result == null ? com.google.cloud.tasks.v2beta3.Queue.State.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the queue.
     * `state` can only be changed by calling
     * [PauseQueue][google.cloud.tasks.v2beta3.CloudTasks.PauseQueue],
     * [ResumeQueue][google.cloud.tasks.v2beta3.CloudTasks.ResumeQueue], or uploading
     * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     * [UpdateQueue][google.cloud.tasks.v2beta3.CloudTasks.UpdateQueue] cannot be used to change `state`.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Queue.State state = 6;</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.tasks.v2beta3.Queue.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000010;
      state_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The state of the queue.
     * `state` can only be changed by calling
     * [PauseQueue][google.cloud.tasks.v2beta3.CloudTasks.PauseQueue],
     * [ResumeQueue][google.cloud.tasks.v2beta3.CloudTasks.ResumeQueue], or uploading
     * [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref).
     * [UpdateQueue][google.cloud.tasks.v2beta3.CloudTasks.UpdateQueue] cannot be used to change `state`.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Queue.State state = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000010);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp purgeTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        purgeTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2beta3.Task.create_time] before this time
     * were purged.
     * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2beta3.CloudTasks.PurgeQueue], the
     * [App Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 7;</code>
     *
     * @return Whether the purgeTime field is set.
     */
    public boolean hasPurgeTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2beta3.Task.create_time] before this time
     * were purged.
     * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2beta3.CloudTasks.PurgeQueue], the
     * [App Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 7;</code>
     *
     * @return The purgeTime.
     */
    public com.google.protobuf.Timestamp getPurgeTime() {
      if (purgeTimeBuilder_ == null) {
        return purgeTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : purgeTime_;
      } else {
        return purgeTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2beta3.Task.create_time] before this time
     * were purged.
     * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2beta3.CloudTasks.PurgeQueue], the
     * [App Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 7;</code>
     */
    public Builder setPurgeTime(com.google.protobuf.Timestamp value) {
      if (purgeTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        purgeTime_ = value;
      } else {
        purgeTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2beta3.Task.create_time] before this time
     * were purged.
     * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2beta3.CloudTasks.PurgeQueue], the
     * [App Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 7;</code>
     */
    public Builder setPurgeTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (purgeTimeBuilder_ == null) {
        purgeTime_ = builderForValue.build();
      } else {
        purgeTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2beta3.Task.create_time] before this time
     * were purged.
     * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2beta3.CloudTasks.PurgeQueue], the
     * [App Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 7;</code>
     */
    public Builder mergePurgeTime(com.google.protobuf.Timestamp value) {
      if (purgeTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && purgeTime_ != null
            && purgeTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getPurgeTimeBuilder().mergeFrom(value);
        } else {
          purgeTime_ = value;
        }
      } else {
        purgeTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2beta3.Task.create_time] before this time
     * were purged.
     * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2beta3.CloudTasks.PurgeQueue], the
     * [App Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 7;</code>
     */
    public Builder clearPurgeTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      purgeTime_ = null;
      if (purgeTimeBuilder_ != null) {
        purgeTimeBuilder_.dispose();
        purgeTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2beta3.Task.create_time] before this time
     * were purged.
     * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2beta3.CloudTasks.PurgeQueue], the
     * [App Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 7;</code>
     */
    public com.google.protobuf.Timestamp.Builder getPurgeTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getPurgeTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2beta3.Task.create_time] before this time
     * were purged.
     * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2beta3.CloudTasks.PurgeQueue], the
     * [App Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 7;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getPurgeTimeOrBuilder() {
      if (purgeTimeBuilder_ != null) {
        return purgeTimeBuilder_.getMessageOrBuilder();
      } else {
        return purgeTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : purgeTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The last time this queue was purged.
     * All tasks that were [created][google.cloud.tasks.v2beta3.Task.create_time] before this time
     * were purged.
     * A queue can be purged using [PurgeQueue][google.cloud.tasks.v2beta3.CloudTasks.PurgeQueue], the
     * [App Engine Task Queue SDK, or the Cloud
     * Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue).
     * Purge time will be truncated to the nearest microsecond. Purge
     * time will be unset if the queue has never been purged.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp purge_time = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getPurgeTimeFieldBuilder() {
      if (purgeTimeBuilder_ == null) {
        purgeTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getPurgeTime(), getParentForChildren(), isClean());
        purgeTime_ = null;
      }
      return purgeTimeBuilder_;
    }

    private com.google.protobuf.Duration taskTtl_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        taskTtlBuilder_;
    /**
     *
     *
     * <pre>
     * The maximum amount of time that a task will be retained in
     * this queue.
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     * </pre>
     *
     * <code>.google.protobuf.Duration task_ttl = 8;</code>
     *
     * @return Whether the taskTtl field is set.
     */
    public boolean hasTaskTtl() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time that a task will be retained in
     * this queue.
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     * </pre>
     *
     * <code>.google.protobuf.Duration task_ttl = 8;</code>
     *
     * @return The taskTtl.
     */
    public com.google.protobuf.Duration getTaskTtl() {
      if (taskTtlBuilder_ == null) {
        return taskTtl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : taskTtl_;
      } else {
        return taskTtlBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time that a task will be retained in
     * this queue.
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     * </pre>
     *
     * <code>.google.protobuf.Duration task_ttl = 8;</code>
     */
    public Builder setTaskTtl(com.google.protobuf.Duration value) {
      if (taskTtlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        taskTtl_ = value;
      } else {
        taskTtlBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time that a task will be retained in
     * this queue.
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     * </pre>
     *
     * <code>.google.protobuf.Duration task_ttl = 8;</code>
     */
    public Builder setTaskTtl(com.google.protobuf.Duration.Builder builderForValue) {
      if (taskTtlBuilder_ == null) {
        taskTtl_ = builderForValue.build();
      } else {
        taskTtlBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time that a task will be retained in
     * this queue.
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     * </pre>
     *
     * <code>.google.protobuf.Duration task_ttl = 8;</code>
     */
    public Builder mergeTaskTtl(com.google.protobuf.Duration value) {
      if (taskTtlBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && taskTtl_ != null
            && taskTtl_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTaskTtlBuilder().mergeFrom(value);
        } else {
          taskTtl_ = value;
        }
      } else {
        taskTtlBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time that a task will be retained in
     * this queue.
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     * </pre>
     *
     * <code>.google.protobuf.Duration task_ttl = 8;</code>
     */
    public Builder clearTaskTtl() {
      bitField0_ = (bitField0_ & ~0x00000040);
      taskTtl_ = null;
      if (taskTtlBuilder_ != null) {
        taskTtlBuilder_.dispose();
        taskTtlBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time that a task will be retained in
     * this queue.
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     * </pre>
     *
     * <code>.google.protobuf.Duration task_ttl = 8;</code>
     */
    public com.google.protobuf.Duration.Builder getTaskTtlBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getTaskTtlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time that a task will be retained in
     * this queue.
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     * </pre>
     *
     * <code>.google.protobuf.Duration task_ttl = 8;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTaskTtlOrBuilder() {
      if (taskTtlBuilder_ != null) {
        return taskTtlBuilder_.getMessageOrBuilder();
      } else {
        return taskTtl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : taskTtl_;
      }
    }
    /**
     *
     *
     * <pre>
     * The maximum amount of time that a task will be retained in
     * this queue.
     * Queues created by Cloud Tasks have a default `task_ttl` of 31 days.
     * After a task has lived for `task_ttl`, the task will be deleted
     * regardless of whether it was dispatched or not.
     * The `task_ttl` for queues created via queue.yaml/xml is equal to the
     * maximum duration because there is a
     * [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for
     * these queues. To view the maximum valid duration, see the documentation for
     * [Duration][google.protobuf.Duration].
     * </pre>
     *
     * <code>.google.protobuf.Duration task_ttl = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTaskTtlFieldBuilder() {
      if (taskTtlBuilder_ == null) {
        taskTtlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTaskTtl(), getParentForChildren(), isClean());
        taskTtl_ = null;
      }
      return taskTtlBuilder_;
    }

    private com.google.protobuf.Duration tombstoneTtl_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        tombstoneTtlBuilder_;
    /**
     *
     *
     * <pre>
     * The task tombstone time to live (TTL).
     * After a task is deleted or executed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta3.CreateTaskRequest.task].
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration tombstone_ttl = 9;</code>
     *
     * @return Whether the tombstoneTtl field is set.
     */
    public boolean hasTombstoneTtl() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     *
     *
     * <pre>
     * The task tombstone time to live (TTL).
     * After a task is deleted or executed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta3.CreateTaskRequest.task].
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration tombstone_ttl = 9;</code>
     *
     * @return The tombstoneTtl.
     */
    public com.google.protobuf.Duration getTombstoneTtl() {
      if (tombstoneTtlBuilder_ == null) {
        return tombstoneTtl_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : tombstoneTtl_;
      } else {
        return tombstoneTtlBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The task tombstone time to live (TTL).
     * After a task is deleted or executed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta3.CreateTaskRequest.task].
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration tombstone_ttl = 9;</code>
     */
    public Builder setTombstoneTtl(com.google.protobuf.Duration value) {
      if (tombstoneTtlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        tombstoneTtl_ = value;
      } else {
        tombstoneTtlBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The task tombstone time to live (TTL).
     * After a task is deleted or executed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta3.CreateTaskRequest.task].
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration tombstone_ttl = 9;</code>
     */
    public Builder setTombstoneTtl(com.google.protobuf.Duration.Builder builderForValue) {
      if (tombstoneTtlBuilder_ == null) {
        tombstoneTtl_ = builderForValue.build();
      } else {
        tombstoneTtlBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The task tombstone time to live (TTL).
     * After a task is deleted or executed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta3.CreateTaskRequest.task].
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration tombstone_ttl = 9;</code>
     */
    public Builder mergeTombstoneTtl(com.google.protobuf.Duration value) {
      if (tombstoneTtlBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && tombstoneTtl_ != null
            && tombstoneTtl_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTombstoneTtlBuilder().mergeFrom(value);
        } else {
          tombstoneTtl_ = value;
        }
      } else {
        tombstoneTtlBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The task tombstone time to live (TTL).
     * After a task is deleted or executed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta3.CreateTaskRequest.task].
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration tombstone_ttl = 9;</code>
     */
    public Builder clearTombstoneTtl() {
      bitField0_ = (bitField0_ & ~0x00000080);
      tombstoneTtl_ = null;
      if (tombstoneTtlBuilder_ != null) {
        tombstoneTtlBuilder_.dispose();
        tombstoneTtlBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The task tombstone time to live (TTL).
     * After a task is deleted or executed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta3.CreateTaskRequest.task].
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration tombstone_ttl = 9;</code>
     */
    public com.google.protobuf.Duration.Builder getTombstoneTtlBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getTombstoneTtlFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The task tombstone time to live (TTL).
     * After a task is deleted or executed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta3.CreateTaskRequest.task].
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration tombstone_ttl = 9;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTombstoneTtlOrBuilder() {
      if (tombstoneTtlBuilder_ != null) {
        return tombstoneTtlBuilder_.getMessageOrBuilder();
      } else {
        return tombstoneTtl_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : tombstoneTtl_;
      }
    }
    /**
     *
     *
     * <pre>
     * The task tombstone time to live (TTL).
     * After a task is deleted or executed, the task's tombstone is
     * retained for the length of time specified by `tombstone_ttl`.
     * The tombstone is used by task de-duplication; another task with the same
     * name can't be created until the tombstone has expired. For more information
     * about task de-duplication, see the documentation for
     * [CreateTaskRequest][google.cloud.tasks.v2beta3.CreateTaskRequest.task].
     * Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
     * </pre>
     *
     * <code>.google.protobuf.Duration tombstone_ttl = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTombstoneTtlFieldBuilder() {
      if (tombstoneTtlBuilder_ == null) {
        tombstoneTtlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getTombstoneTtl(), getParentForChildren(), isClean());
        tombstoneTtl_ = null;
      }
      return tombstoneTtlBuilder_;
    }

    private com.google.cloud.tasks.v2beta3.StackdriverLoggingConfig stackdriverLoggingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.StackdriverLoggingConfig,
            com.google.cloud.tasks.v2beta3.StackdriverLoggingConfig.Builder,
            com.google.cloud.tasks.v2beta3.StackdriverLoggingConfigOrBuilder>
        stackdriverLoggingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Configuration options for writing logs to
     * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
     * field is unset, then no logs are written.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.StackdriverLoggingConfig stackdriver_logging_config = 10;
     * </code>
     *
     * @return Whether the stackdriverLoggingConfig field is set.
     */
    public boolean hasStackdriverLoggingConfig() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Configuration options for writing logs to
     * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
     * field is unset, then no logs are written.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.StackdriverLoggingConfig stackdriver_logging_config = 10;
     * </code>
     *
     * @return The stackdriverLoggingConfig.
     */
    public com.google.cloud.tasks.v2beta3.StackdriverLoggingConfig getStackdriverLoggingConfig() {
      if (stackdriverLoggingConfigBuilder_ == null) {
        return stackdriverLoggingConfig_ == null
            ? com.google.cloud.tasks.v2beta3.StackdriverLoggingConfig.getDefaultInstance()
            : stackdriverLoggingConfig_;
      } else {
        return stackdriverLoggingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration options for writing logs to
     * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
     * field is unset, then no logs are written.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.StackdriverLoggingConfig stackdriver_logging_config = 10;
     * </code>
     */
    public Builder setStackdriverLoggingConfig(
        com.google.cloud.tasks.v2beta3.StackdriverLoggingConfig value) {
      if (stackdriverLoggingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stackdriverLoggingConfig_ = value;
      } else {
        stackdriverLoggingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for writing logs to
     * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
     * field is unset, then no logs are written.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.StackdriverLoggingConfig stackdriver_logging_config = 10;
     * </code>
     */
    public Builder setStackdriverLoggingConfig(
        com.google.cloud.tasks.v2beta3.StackdriverLoggingConfig.Builder builderForValue) {
      if (stackdriverLoggingConfigBuilder_ == null) {
        stackdriverLoggingConfig_ = builderForValue.build();
      } else {
        stackdriverLoggingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for writing logs to
     * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
     * field is unset, then no logs are written.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.StackdriverLoggingConfig stackdriver_logging_config = 10;
     * </code>
     */
    public Builder mergeStackdriverLoggingConfig(
        com.google.cloud.tasks.v2beta3.StackdriverLoggingConfig value) {
      if (stackdriverLoggingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && stackdriverLoggingConfig_ != null
            && stackdriverLoggingConfig_
                != com.google.cloud.tasks.v2beta3.StackdriverLoggingConfig.getDefaultInstance()) {
          getStackdriverLoggingConfigBuilder().mergeFrom(value);
        } else {
          stackdriverLoggingConfig_ = value;
        }
      } else {
        stackdriverLoggingConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for writing logs to
     * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
     * field is unset, then no logs are written.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.StackdriverLoggingConfig stackdriver_logging_config = 10;
     * </code>
     */
    public Builder clearStackdriverLoggingConfig() {
      bitField0_ = (bitField0_ & ~0x00000100);
      stackdriverLoggingConfig_ = null;
      if (stackdriverLoggingConfigBuilder_ != null) {
        stackdriverLoggingConfigBuilder_.dispose();
        stackdriverLoggingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Configuration options for writing logs to
     * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
     * field is unset, then no logs are written.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.StackdriverLoggingConfig stackdriver_logging_config = 10;
     * </code>
     */
    public com.google.cloud.tasks.v2beta3.StackdriverLoggingConfig.Builder
        getStackdriverLoggingConfigBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getStackdriverLoggingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Configuration options for writing logs to
     * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
     * field is unset, then no logs are written.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.StackdriverLoggingConfig stackdriver_logging_config = 10;
     * </code>
     */
    public com.google.cloud.tasks.v2beta3.StackdriverLoggingConfigOrBuilder
        getStackdriverLoggingConfigOrBuilder() {
      if (stackdriverLoggingConfigBuilder_ != null) {
        return stackdriverLoggingConfigBuilder_.getMessageOrBuilder();
      } else {
        return stackdriverLoggingConfig_ == null
            ? com.google.cloud.tasks.v2beta3.StackdriverLoggingConfig.getDefaultInstance()
            : stackdriverLoggingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Configuration options for writing logs to
     * [Stackdriver Logging](https://cloud.google.com/logging/docs/). If this
     * field is unset, then no logs are written.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.StackdriverLoggingConfig stackdriver_logging_config = 10;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.StackdriverLoggingConfig,
            com.google.cloud.tasks.v2beta3.StackdriverLoggingConfig.Builder,
            com.google.cloud.tasks.v2beta3.StackdriverLoggingConfigOrBuilder>
        getStackdriverLoggingConfigFieldBuilder() {
      if (stackdriverLoggingConfigBuilder_ == null) {
        stackdriverLoggingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2beta3.StackdriverLoggingConfig,
                com.google.cloud.tasks.v2beta3.StackdriverLoggingConfig.Builder,
                com.google.cloud.tasks.v2beta3.StackdriverLoggingConfigOrBuilder>(
                getStackdriverLoggingConfig(), getParentForChildren(), isClean());
        stackdriverLoggingConfig_ = null;
      }
      return stackdriverLoggingConfigBuilder_;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Immutable. The type of a queue (push or pull).
     * `Queue.type` is an immutable property of the queue that is set at the queue
     * creation time. When left unspecified, the default value of `PUSH` is
     * selected.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta3.Queue.Type type = 11 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The type of a queue (push or pull).
     * `Queue.type` is an immutable property of the queue that is set at the queue
     * creation time. When left unspecified, the default value of `PUSH` is
     * selected.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta3.Queue.Type type = 11 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The type of a queue (push or pull).
     * `Queue.type` is an immutable property of the queue that is set at the queue
     * creation time. When left unspecified, the default value of `PUSH` is
     * selected.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta3.Queue.Type type = 11 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.Queue.Type getType() {
      com.google.cloud.tasks.v2beta3.Queue.Type result =
          com.google.cloud.tasks.v2beta3.Queue.Type.forNumber(type_);
      return result == null ? com.google.cloud.tasks.v2beta3.Queue.Type.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The type of a queue (push or pull).
     * `Queue.type` is an immutable property of the queue that is set at the queue
     * creation time. When left unspecified, the default value of `PUSH` is
     * selected.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta3.Queue.Type type = 11 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.tasks.v2beta3.Queue.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000200;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Immutable. The type of a queue (push or pull).
     * `Queue.type` is an immutable property of the queue that is set at the queue
     * creation time. When left unspecified, the default value of `PUSH` is
     * selected.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta3.Queue.Type type = 11 [(.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000200);
      type_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.tasks.v2beta3.QueueStats stats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.QueueStats,
            com.google.cloud.tasks.v2beta3.QueueStats.Builder,
            com.google.cloud.tasks.v2beta3.QueueStatsOrBuilder>
        statsBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta3.QueueStats stats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the stats field is set.
     */
    public boolean hasStats() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta3.QueueStats stats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The stats.
     */
    public com.google.cloud.tasks.v2beta3.QueueStats getStats() {
      if (statsBuilder_ == null) {
        return stats_ == null
            ? com.google.cloud.tasks.v2beta3.QueueStats.getDefaultInstance()
            : stats_;
      } else {
        return statsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta3.QueueStats stats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStats(com.google.cloud.tasks.v2beta3.QueueStats value) {
      if (statsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stats_ = value;
      } else {
        statsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta3.QueueStats stats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStats(com.google.cloud.tasks.v2beta3.QueueStats.Builder builderForValue) {
      if (statsBuilder_ == null) {
        stats_ = builderForValue.build();
      } else {
        statsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta3.QueueStats stats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStats(com.google.cloud.tasks.v2beta3.QueueStats value) {
      if (statsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && stats_ != null
            && stats_ != com.google.cloud.tasks.v2beta3.QueueStats.getDefaultInstance()) {
          getStatsBuilder().mergeFrom(value);
        } else {
          stats_ = value;
        }
      } else {
        statsBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta3.QueueStats stats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStats() {
      bitField0_ = (bitField0_ & ~0x00000400);
      stats_ = null;
      if (statsBuilder_ != null) {
        statsBuilder_.dispose();
        statsBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta3.QueueStats stats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.tasks.v2beta3.QueueStats.Builder getStatsBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getStatsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta3.QueueStats stats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.tasks.v2beta3.QueueStatsOrBuilder getStatsOrBuilder() {
      if (statsBuilder_ != null) {
        return statsBuilder_.getMessageOrBuilder();
      } else {
        return stats_ == null
            ? com.google.cloud.tasks.v2beta3.QueueStats.getDefaultInstance()
            : stats_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The realtime, informational statistics for a queue. In order
     * to receive the statistics the caller should include this field in the
     * FieldMask.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta3.QueueStats stats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.QueueStats,
            com.google.cloud.tasks.v2beta3.QueueStats.Builder,
            com.google.cloud.tasks.v2beta3.QueueStatsOrBuilder>
        getStatsFieldBuilder() {
      if (statsBuilder_ == null) {
        statsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2beta3.QueueStats,
                com.google.cloud.tasks.v2beta3.QueueStats.Builder,
                com.google.cloud.tasks.v2beta3.QueueStatsOrBuilder>(
                getStats(), getParentForChildren(), isClean());
        stats_ = null;
      }
      return statsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.tasks.v2beta3.Queue)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.tasks.v2beta3.Queue)
  private static final com.google.cloud.tasks.v2beta3.Queue DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.tasks.v2beta3.Queue();
  }

  public static com.google.cloud.tasks.v2beta3.Queue getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Queue> PARSER =
      new com.google.protobuf.AbstractParser<Queue>() {
        @java.lang.Override
        public Queue parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Queue> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Queue> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.Queue getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
