/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/tasks/v2beta3/task.proto

package com.google.cloud.tasks.v2beta3;

/**
 *
 *
 * <pre>
 * A unit of scheduled work.
 * </pre>
 *
 * Protobuf type {@code google.cloud.tasks.v2beta3.Task}
 */
public final class Task extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.tasks.v2beta3.Task)
    TaskOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Task.newBuilder() to construct.
  private Task(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Task() {
    name_ = "";
    view_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Task();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.tasks.v2beta3.TaskProto
        .internal_static_google_cloud_tasks_v2beta3_Task_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.tasks.v2beta3.TaskProto
        .internal_static_google_cloud_tasks_v2beta3_Task_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.tasks.v2beta3.Task.class,
            com.google.cloud.tasks.v2beta3.Task.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The view specifies a subset of [Task][google.cloud.tasks.v2beta3.Task]
   * data.
   * When a task is returned in a response, not all
   * information is retrieved by default because some data, such as
   * payloads, might be desirable to return only when needed because
   * of its large size or because of the sensitivity of data that it
   * contains.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.tasks.v2beta3.Task.View}
   */
  public enum View implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Unspecified. Defaults to BASIC.
     * </pre>
     *
     * <code>VIEW_UNSPECIFIED = 0;</code>
     */
    VIEW_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The basic view omits fields which can be large or can contain
     * sensitive data.
     * This view does not include the
     * [body in
     * AppEngineHttpRequest][google.cloud.tasks.v2beta3.AppEngineHttpRequest.body].
     * Bodies are desirable to return only when needed, because they
     * can be large and because of the sensitivity of the data that you
     * choose to store in it.
     * </pre>
     *
     * <code>BASIC = 1;</code>
     */
    BASIC(1),
    /**
     *
     *
     * <pre>
     * All information is returned.
     * Authorization for [FULL][google.cloud.tasks.v2beta3.Task.View.FULL]
     * requires `cloudtasks.tasks.fullView` [Google
     * IAM](https://cloud.google.com/iam/) permission on the
     * [Queue][google.cloud.tasks.v2beta3.Queue] resource.
     * </pre>
     *
     * <code>FULL = 2;</code>
     */
    FULL(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Unspecified. Defaults to BASIC.
     * </pre>
     *
     * <code>VIEW_UNSPECIFIED = 0;</code>
     */
    public static final int VIEW_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * The basic view omits fields which can be large or can contain
     * sensitive data.
     * This view does not include the
     * [body in
     * AppEngineHttpRequest][google.cloud.tasks.v2beta3.AppEngineHttpRequest.body].
     * Bodies are desirable to return only when needed, because they
     * can be large and because of the sensitivity of the data that you
     * choose to store in it.
     * </pre>
     *
     * <code>BASIC = 1;</code>
     */
    public static final int BASIC_VALUE = 1;
    /**
     *
     *
     * <pre>
     * All information is returned.
     * Authorization for [FULL][google.cloud.tasks.v2beta3.Task.View.FULL]
     * requires `cloudtasks.tasks.fullView` [Google
     * IAM](https://cloud.google.com/iam/) permission on the
     * [Queue][google.cloud.tasks.v2beta3.Queue] resource.
     * </pre>
     *
     * <code>FULL = 2;</code>
     */
    public static final int FULL_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static View valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static View forNumber(int value) {
      switch (value) {
        case 0:
          return VIEW_UNSPECIFIED;
        case 1:
          return BASIC;
        case 2:
          return FULL;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<View> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<View> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<View>() {
          public View findValueByNumber(int number) {
            return View.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.tasks.v2beta3.Task.getDescriptor().getEnumTypes().get(0);
    }

    private static final View[] VALUES = values();

    public static View valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private View(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.tasks.v2beta3.Task.View)
  }

  private int payloadTypeCase_ = 0;
  private java.lang.Object payloadType_;

  public enum PayloadTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    APP_ENGINE_HTTP_REQUEST(3),
    HTTP_REQUEST(11),
    PULL_MESSAGE(13),
    PAYLOADTYPE_NOT_SET(0);
    private final int value;

    private PayloadTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PayloadTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static PayloadTypeCase forNumber(int value) {
      switch (value) {
        case 3:
          return APP_ENGINE_HTTP_REQUEST;
        case 11:
          return HTTP_REQUEST;
        case 13:
          return PULL_MESSAGE;
        case 0:
          return PAYLOADTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public PayloadTypeCase getPayloadTypeCase() {
    return PayloadTypeCase.forNumber(payloadTypeCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Optionally caller-specified in
   * [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
   * The task name.
   * The task name must have the following format:
   * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`
   * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
   *    hyphens (-), colons (:), or periods (.).
   *    For more information, see
   *    [Identifying
   *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
   * * `LOCATION_ID` is the canonical ID for the task's location.
   *    The list of available locations can be obtained by calling
   *    [ListLocations][google.cloud.location.Locations.ListLocations].
   *    For more information, see https://cloud.google.com/about/locations/.
   * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
   *   hyphens (-). The maximum length is 100 characters.
   * * `TASK_ID` can contain only letters ([A-Za-z]), numbers ([0-9]),
   *   hyphens (-), or underscores (_). The maximum length is 500 characters.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optionally caller-specified in
   * [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
   * The task name.
   * The task name must have the following format:
   * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`
   * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
   *    hyphens (-), colons (:), or periods (.).
   *    For more information, see
   *    [Identifying
   *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
   * * `LOCATION_ID` is the canonical ID for the task's location.
   *    The list of available locations can be obtained by calling
   *    [ListLocations][google.cloud.location.Locations.ListLocations].
   *    For more information, see https://cloud.google.com/about/locations/.
   * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
   *   hyphens (-). The maximum length is 100 characters.
   * * `TASK_ID` can contain only letters ([A-Za-z]), numbers ([0-9]),
   *   hyphens (-), or underscores (_). The maximum length is 500 characters.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int APP_ENGINE_HTTP_REQUEST_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * HTTP request that is sent to the App Engine app handler.
   * An App Engine task is a task that has
   * [AppEngineHttpRequest][google.cloud.tasks.v2beta3.AppEngineHttpRequest]
   * set.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.AppEngineHttpRequest app_engine_http_request = 3;</code>
   *
   * @return Whether the appEngineHttpRequest field is set.
   */
  @java.lang.Override
  public boolean hasAppEngineHttpRequest() {
    return payloadTypeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * HTTP request that is sent to the App Engine app handler.
   * An App Engine task is a task that has
   * [AppEngineHttpRequest][google.cloud.tasks.v2beta3.AppEngineHttpRequest]
   * set.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.AppEngineHttpRequest app_engine_http_request = 3;</code>
   *
   * @return The appEngineHttpRequest.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.AppEngineHttpRequest getAppEngineHttpRequest() {
    if (payloadTypeCase_ == 3) {
      return (com.google.cloud.tasks.v2beta3.AppEngineHttpRequest) payloadType_;
    }
    return com.google.cloud.tasks.v2beta3.AppEngineHttpRequest.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * HTTP request that is sent to the App Engine app handler.
   * An App Engine task is a task that has
   * [AppEngineHttpRequest][google.cloud.tasks.v2beta3.AppEngineHttpRequest]
   * set.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.AppEngineHttpRequest app_engine_http_request = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.AppEngineHttpRequestOrBuilder
      getAppEngineHttpRequestOrBuilder() {
    if (payloadTypeCase_ == 3) {
      return (com.google.cloud.tasks.v2beta3.AppEngineHttpRequest) payloadType_;
    }
    return com.google.cloud.tasks.v2beta3.AppEngineHttpRequest.getDefaultInstance();
  }

  public static final int HTTP_REQUEST_FIELD_NUMBER = 11;
  /**
   *
   *
   * <pre>
   * HTTP request that is sent to the task's target.
   * An HTTP task is a task that has
   * [HttpRequest][google.cloud.tasks.v2beta3.HttpRequest] set.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.HttpRequest http_request = 11;</code>
   *
   * @return Whether the httpRequest field is set.
   */
  @java.lang.Override
  public boolean hasHttpRequest() {
    return payloadTypeCase_ == 11;
  }
  /**
   *
   *
   * <pre>
   * HTTP request that is sent to the task's target.
   * An HTTP task is a task that has
   * [HttpRequest][google.cloud.tasks.v2beta3.HttpRequest] set.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.HttpRequest http_request = 11;</code>
   *
   * @return The httpRequest.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.HttpRequest getHttpRequest() {
    if (payloadTypeCase_ == 11) {
      return (com.google.cloud.tasks.v2beta3.HttpRequest) payloadType_;
    }
    return com.google.cloud.tasks.v2beta3.HttpRequest.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * HTTP request that is sent to the task's target.
   * An HTTP task is a task that has
   * [HttpRequest][google.cloud.tasks.v2beta3.HttpRequest] set.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.HttpRequest http_request = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.HttpRequestOrBuilder getHttpRequestOrBuilder() {
    if (payloadTypeCase_ == 11) {
      return (com.google.cloud.tasks.v2beta3.HttpRequest) payloadType_;
    }
    return com.google.cloud.tasks.v2beta3.HttpRequest.getDefaultInstance();
  }

  public static final int PULL_MESSAGE_FIELD_NUMBER = 13;
  /**
   *
   *
   * <pre>
   * Pull Message contained in a task in a
   * [PULL][google.cloud.tasks.v2beta3.Queue.type] queue type. This payload
   * type cannot be explicitly set through Cloud Tasks API. Its purpose,
   * currently is to provide backward compatibility with App Engine Task Queue
   * [pull](https://cloud.google.com/appengine/docs/standard/java/taskqueue/pull/)
   * queues to provide a way to inspect contents of pull tasks through the
   * [CloudTasks.GetTask][google.cloud.tasks.v2beta3.CloudTasks.GetTask].
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.PullMessage pull_message = 13;</code>
   *
   * @return Whether the pullMessage field is set.
   */
  @java.lang.Override
  public boolean hasPullMessage() {
    return payloadTypeCase_ == 13;
  }
  /**
   *
   *
   * <pre>
   * Pull Message contained in a task in a
   * [PULL][google.cloud.tasks.v2beta3.Queue.type] queue type. This payload
   * type cannot be explicitly set through Cloud Tasks API. Its purpose,
   * currently is to provide backward compatibility with App Engine Task Queue
   * [pull](https://cloud.google.com/appengine/docs/standard/java/taskqueue/pull/)
   * queues to provide a way to inspect contents of pull tasks through the
   * [CloudTasks.GetTask][google.cloud.tasks.v2beta3.CloudTasks.GetTask].
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.PullMessage pull_message = 13;</code>
   *
   * @return The pullMessage.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.PullMessage getPullMessage() {
    if (payloadTypeCase_ == 13) {
      return (com.google.cloud.tasks.v2beta3.PullMessage) payloadType_;
    }
    return com.google.cloud.tasks.v2beta3.PullMessage.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Pull Message contained in a task in a
   * [PULL][google.cloud.tasks.v2beta3.Queue.type] queue type. This payload
   * type cannot be explicitly set through Cloud Tasks API. Its purpose,
   * currently is to provide backward compatibility with App Engine Task Queue
   * [pull](https://cloud.google.com/appengine/docs/standard/java/taskqueue/pull/)
   * queues to provide a way to inspect contents of pull tasks through the
   * [CloudTasks.GetTask][google.cloud.tasks.v2beta3.CloudTasks.GetTask].
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.PullMessage pull_message = 13;</code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.PullMessageOrBuilder getPullMessageOrBuilder() {
    if (payloadTypeCase_ == 13) {
      return (com.google.cloud.tasks.v2beta3.PullMessage) payloadType_;
    }
    return com.google.cloud.tasks.v2beta3.PullMessage.getDefaultInstance();
  }

  public static final int SCHEDULE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp scheduleTime_;
  /**
   *
   *
   * <pre>
   * The time when the task is scheduled to be attempted.
   * For App Engine queues, this is when the task will be attempted or retried.
   * `schedule_time` will be truncated to the nearest microsecond.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp schedule_time = 4;</code>
   *
   * @return Whether the scheduleTime field is set.
   */
  @java.lang.Override
  public boolean hasScheduleTime() {
    return scheduleTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * The time when the task is scheduled to be attempted.
   * For App Engine queues, this is when the task will be attempted or retried.
   * `schedule_time` will be truncated to the nearest microsecond.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp schedule_time = 4;</code>
   *
   * @return The scheduleTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getScheduleTime() {
    return scheduleTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : scheduleTime_;
  }
  /**
   *
   *
   * <pre>
   * The time when the task is scheduled to be attempted.
   * For App Engine queues, this is when the task will be attempted or retried.
   * `schedule_time` will be truncated to the nearest microsecond.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp schedule_time = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getScheduleTimeOrBuilder() {
    return scheduleTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : scheduleTime_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp createTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time that the task was created.
   * `create_time` will be truncated to the nearest second.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5;</code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return createTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time that the task was created.
   * `create_time` will be truncated to the nearest second.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5;</code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time that the task was created.
   * `create_time` will be truncated to the nearest second.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 5;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int DISPATCH_DEADLINE_FIELD_NUMBER = 12;
  private com.google.protobuf.Duration dispatchDeadline_;
  /**
   *
   *
   * <pre>
   * The deadline for requests sent to the worker. If the worker does not
   * respond by this deadline then the request is cancelled and the attempt
   * is marked as a `DEADLINE_EXCEEDED` failure. Cloud Tasks will retry the
   * task according to the
   * [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig].
   * Note that when the request is cancelled, Cloud Tasks will stop listening
   * for the response, but whether the worker stops processing depends on the
   * worker. For example, if the worker is stuck, it may not react to cancelled
   * requests.
   * The default and maximum values depend on the type of request:
   * * For [HTTP tasks][google.cloud.tasks.v2beta3.HttpRequest], the default is
   * 10 minutes. The deadline
   *   must be in the interval [15 seconds, 30 minutes].
   * * For [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest],
   * 0 indicates that the
   *   request has the default deadline. The default deadline depends on the
   *   [scaling
   *   type](https://cloud.google.com/appengine/docs/standard/go/how-instances-are-managed#instance_scaling)
   *   of the service: 10 minutes for standard apps with automatic scaling, 24
   *   hours for standard apps with manual and basic scaling, and 60 minutes for
   *   flex apps. If the request deadline is set, it must be in the interval [15
   *   seconds, 24 hours 15 seconds]. Regardless of the task's
   *   `dispatch_deadline`, the app handler will not run for longer than than
   *   the service's timeout. We recommend setting the `dispatch_deadline` to
   *   at most a few seconds more than the app handler's timeout. For more
   *   information see
   *   [Timeouts](https://cloud.google.com/tasks/docs/creating-appengine-handlers#timeouts).
   * `dispatch_deadline` will be truncated to the nearest millisecond. The
   * deadline is an approximate deadline.
   * </pre>
   *
   * <code>.google.protobuf.Duration dispatch_deadline = 12;</code>
   *
   * @return Whether the dispatchDeadline field is set.
   */
  @java.lang.Override
  public boolean hasDispatchDeadline() {
    return dispatchDeadline_ != null;
  }
  /**
   *
   *
   * <pre>
   * The deadline for requests sent to the worker. If the worker does not
   * respond by this deadline then the request is cancelled and the attempt
   * is marked as a `DEADLINE_EXCEEDED` failure. Cloud Tasks will retry the
   * task according to the
   * [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig].
   * Note that when the request is cancelled, Cloud Tasks will stop listening
   * for the response, but whether the worker stops processing depends on the
   * worker. For example, if the worker is stuck, it may not react to cancelled
   * requests.
   * The default and maximum values depend on the type of request:
   * * For [HTTP tasks][google.cloud.tasks.v2beta3.HttpRequest], the default is
   * 10 minutes. The deadline
   *   must be in the interval [15 seconds, 30 minutes].
   * * For [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest],
   * 0 indicates that the
   *   request has the default deadline. The default deadline depends on the
   *   [scaling
   *   type](https://cloud.google.com/appengine/docs/standard/go/how-instances-are-managed#instance_scaling)
   *   of the service: 10 minutes for standard apps with automatic scaling, 24
   *   hours for standard apps with manual and basic scaling, and 60 minutes for
   *   flex apps. If the request deadline is set, it must be in the interval [15
   *   seconds, 24 hours 15 seconds]. Regardless of the task's
   *   `dispatch_deadline`, the app handler will not run for longer than than
   *   the service's timeout. We recommend setting the `dispatch_deadline` to
   *   at most a few seconds more than the app handler's timeout. For more
   *   information see
   *   [Timeouts](https://cloud.google.com/tasks/docs/creating-appengine-handlers#timeouts).
   * `dispatch_deadline` will be truncated to the nearest millisecond. The
   * deadline is an approximate deadline.
   * </pre>
   *
   * <code>.google.protobuf.Duration dispatch_deadline = 12;</code>
   *
   * @return The dispatchDeadline.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getDispatchDeadline() {
    return dispatchDeadline_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : dispatchDeadline_;
  }
  /**
   *
   *
   * <pre>
   * The deadline for requests sent to the worker. If the worker does not
   * respond by this deadline then the request is cancelled and the attempt
   * is marked as a `DEADLINE_EXCEEDED` failure. Cloud Tasks will retry the
   * task according to the
   * [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig].
   * Note that when the request is cancelled, Cloud Tasks will stop listening
   * for the response, but whether the worker stops processing depends on the
   * worker. For example, if the worker is stuck, it may not react to cancelled
   * requests.
   * The default and maximum values depend on the type of request:
   * * For [HTTP tasks][google.cloud.tasks.v2beta3.HttpRequest], the default is
   * 10 minutes. The deadline
   *   must be in the interval [15 seconds, 30 minutes].
   * * For [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest],
   * 0 indicates that the
   *   request has the default deadline. The default deadline depends on the
   *   [scaling
   *   type](https://cloud.google.com/appengine/docs/standard/go/how-instances-are-managed#instance_scaling)
   *   of the service: 10 minutes for standard apps with automatic scaling, 24
   *   hours for standard apps with manual and basic scaling, and 60 minutes for
   *   flex apps. If the request deadline is set, it must be in the interval [15
   *   seconds, 24 hours 15 seconds]. Regardless of the task's
   *   `dispatch_deadline`, the app handler will not run for longer than than
   *   the service's timeout. We recommend setting the `dispatch_deadline` to
   *   at most a few seconds more than the app handler's timeout. For more
   *   information see
   *   [Timeouts](https://cloud.google.com/tasks/docs/creating-appengine-handlers#timeouts).
   * `dispatch_deadline` will be truncated to the nearest millisecond. The
   * deadline is an approximate deadline.
   * </pre>
   *
   * <code>.google.protobuf.Duration dispatch_deadline = 12;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getDispatchDeadlineOrBuilder() {
    return dispatchDeadline_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : dispatchDeadline_;
  }

  public static final int DISPATCH_COUNT_FIELD_NUMBER = 6;
  private int dispatchCount_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The number of attempts dispatched.
   * This count includes attempts which have been dispatched but haven't
   * received a response.
   * </pre>
   *
   * <code>int32 dispatch_count = 6;</code>
   *
   * @return The dispatchCount.
   */
  @java.lang.Override
  public int getDispatchCount() {
    return dispatchCount_;
  }

  public static final int RESPONSE_COUNT_FIELD_NUMBER = 7;
  private int responseCount_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The number of attempts which have received a response.
   * </pre>
   *
   * <code>int32 response_count = 7;</code>
   *
   * @return The responseCount.
   */
  @java.lang.Override
  public int getResponseCount() {
    return responseCount_;
  }

  public static final int FIRST_ATTEMPT_FIELD_NUMBER = 8;
  private com.google.cloud.tasks.v2beta3.Attempt firstAttempt_;
  /**
   *
   *
   * <pre>
   * Output only. The status of the task's first attempt.
   * Only [dispatch_time][google.cloud.tasks.v2beta3.Attempt.dispatch_time] will
   * be set. The other [Attempt][google.cloud.tasks.v2beta3.Attempt] information
   * is not retained by Cloud Tasks.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.Attempt first_attempt = 8;</code>
   *
   * @return Whether the firstAttempt field is set.
   */
  @java.lang.Override
  public boolean hasFirstAttempt() {
    return firstAttempt_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The status of the task's first attempt.
   * Only [dispatch_time][google.cloud.tasks.v2beta3.Attempt.dispatch_time] will
   * be set. The other [Attempt][google.cloud.tasks.v2beta3.Attempt] information
   * is not retained by Cloud Tasks.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.Attempt first_attempt = 8;</code>
   *
   * @return The firstAttempt.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.Attempt getFirstAttempt() {
    return firstAttempt_ == null
        ? com.google.cloud.tasks.v2beta3.Attempt.getDefaultInstance()
        : firstAttempt_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The status of the task's first attempt.
   * Only [dispatch_time][google.cloud.tasks.v2beta3.Attempt.dispatch_time] will
   * be set. The other [Attempt][google.cloud.tasks.v2beta3.Attempt] information
   * is not retained by Cloud Tasks.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.Attempt first_attempt = 8;</code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.AttemptOrBuilder getFirstAttemptOrBuilder() {
    return firstAttempt_ == null
        ? com.google.cloud.tasks.v2beta3.Attempt.getDefaultInstance()
        : firstAttempt_;
  }

  public static final int LAST_ATTEMPT_FIELD_NUMBER = 9;
  private com.google.cloud.tasks.v2beta3.Attempt lastAttempt_;
  /**
   *
   *
   * <pre>
   * Output only. The status of the task's last attempt.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.Attempt last_attempt = 9;</code>
   *
   * @return Whether the lastAttempt field is set.
   */
  @java.lang.Override
  public boolean hasLastAttempt() {
    return lastAttempt_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The status of the task's last attempt.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.Attempt last_attempt = 9;</code>
   *
   * @return The lastAttempt.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.Attempt getLastAttempt() {
    return lastAttempt_ == null
        ? com.google.cloud.tasks.v2beta3.Attempt.getDefaultInstance()
        : lastAttempt_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The status of the task's last attempt.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.Attempt last_attempt = 9;</code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.AttemptOrBuilder getLastAttemptOrBuilder() {
    return lastAttempt_ == null
        ? com.google.cloud.tasks.v2beta3.Attempt.getDefaultInstance()
        : lastAttempt_;
  }

  public static final int VIEW_FIELD_NUMBER = 10;
  private int view_ = 0;
  /**
   *
   *
   * <pre>
   * Output only. The view specifies which subset of the
   * [Task][google.cloud.tasks.v2beta3.Task] has been returned.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.Task.View view = 10;</code>
   *
   * @return The enum numeric value on the wire for view.
   */
  @java.lang.Override
  public int getViewValue() {
    return view_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The view specifies which subset of the
   * [Task][google.cloud.tasks.v2beta3.Task] has been returned.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.Task.View view = 10;</code>
   *
   * @return The view.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.Task.View getView() {
    com.google.cloud.tasks.v2beta3.Task.View result =
        com.google.cloud.tasks.v2beta3.Task.View.forNumber(view_);
    return result == null ? com.google.cloud.tasks.v2beta3.Task.View.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (payloadTypeCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.tasks.v2beta3.AppEngineHttpRequest) payloadType_);
    }
    if (scheduleTime_ != null) {
      output.writeMessage(4, getScheduleTime());
    }
    if (createTime_ != null) {
      output.writeMessage(5, getCreateTime());
    }
    if (dispatchCount_ != 0) {
      output.writeInt32(6, dispatchCount_);
    }
    if (responseCount_ != 0) {
      output.writeInt32(7, responseCount_);
    }
    if (firstAttempt_ != null) {
      output.writeMessage(8, getFirstAttempt());
    }
    if (lastAttempt_ != null) {
      output.writeMessage(9, getLastAttempt());
    }
    if (view_ != com.google.cloud.tasks.v2beta3.Task.View.VIEW_UNSPECIFIED.getNumber()) {
      output.writeEnum(10, view_);
    }
    if (payloadTypeCase_ == 11) {
      output.writeMessage(11, (com.google.cloud.tasks.v2beta3.HttpRequest) payloadType_);
    }
    if (dispatchDeadline_ != null) {
      output.writeMessage(12, getDispatchDeadline());
    }
    if (payloadTypeCase_ == 13) {
      output.writeMessage(13, (com.google.cloud.tasks.v2beta3.PullMessage) payloadType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (payloadTypeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.tasks.v2beta3.AppEngineHttpRequest) payloadType_);
    }
    if (scheduleTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getScheduleTime());
    }
    if (createTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getCreateTime());
    }
    if (dispatchCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, dispatchCount_);
    }
    if (responseCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, responseCount_);
    }
    if (firstAttempt_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getFirstAttempt());
    }
    if (lastAttempt_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getLastAttempt());
    }
    if (view_ != com.google.cloud.tasks.v2beta3.Task.View.VIEW_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(10, view_);
    }
    if (payloadTypeCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, (com.google.cloud.tasks.v2beta3.HttpRequest) payloadType_);
    }
    if (dispatchDeadline_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getDispatchDeadline());
    }
    if (payloadTypeCase_ == 13) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, (com.google.cloud.tasks.v2beta3.PullMessage) payloadType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.tasks.v2beta3.Task)) {
      return super.equals(obj);
    }
    com.google.cloud.tasks.v2beta3.Task other = (com.google.cloud.tasks.v2beta3.Task) obj;

    if (!getName().equals(other.getName())) return false;
    if (hasScheduleTime() != other.hasScheduleTime()) return false;
    if (hasScheduleTime()) {
      if (!getScheduleTime().equals(other.getScheduleTime())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasDispatchDeadline() != other.hasDispatchDeadline()) return false;
    if (hasDispatchDeadline()) {
      if (!getDispatchDeadline().equals(other.getDispatchDeadline())) return false;
    }
    if (getDispatchCount() != other.getDispatchCount()) return false;
    if (getResponseCount() != other.getResponseCount()) return false;
    if (hasFirstAttempt() != other.hasFirstAttempt()) return false;
    if (hasFirstAttempt()) {
      if (!getFirstAttempt().equals(other.getFirstAttempt())) return false;
    }
    if (hasLastAttempt() != other.hasLastAttempt()) return false;
    if (hasLastAttempt()) {
      if (!getLastAttempt().equals(other.getLastAttempt())) return false;
    }
    if (view_ != other.view_) return false;
    if (!getPayloadTypeCase().equals(other.getPayloadTypeCase())) return false;
    switch (payloadTypeCase_) {
      case 3:
        if (!getAppEngineHttpRequest().equals(other.getAppEngineHttpRequest())) return false;
        break;
      case 11:
        if (!getHttpRequest().equals(other.getHttpRequest())) return false;
        break;
      case 13:
        if (!getPullMessage().equals(other.getPullMessage())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    if (hasScheduleTime()) {
      hash = (37 * hash) + SCHEDULE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getScheduleTime().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasDispatchDeadline()) {
      hash = (37 * hash) + DISPATCH_DEADLINE_FIELD_NUMBER;
      hash = (53 * hash) + getDispatchDeadline().hashCode();
    }
    hash = (37 * hash) + DISPATCH_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getDispatchCount();
    hash = (37 * hash) + RESPONSE_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getResponseCount();
    if (hasFirstAttempt()) {
      hash = (37 * hash) + FIRST_ATTEMPT_FIELD_NUMBER;
      hash = (53 * hash) + getFirstAttempt().hashCode();
    }
    if (hasLastAttempt()) {
      hash = (37 * hash) + LAST_ATTEMPT_FIELD_NUMBER;
      hash = (53 * hash) + getLastAttempt().hashCode();
    }
    hash = (37 * hash) + VIEW_FIELD_NUMBER;
    hash = (53 * hash) + view_;
    switch (payloadTypeCase_) {
      case 3:
        hash = (37 * hash) + APP_ENGINE_HTTP_REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getAppEngineHttpRequest().hashCode();
        break;
      case 11:
        hash = (37 * hash) + HTTP_REQUEST_FIELD_NUMBER;
        hash = (53 * hash) + getHttpRequest().hashCode();
        break;
      case 13:
        hash = (37 * hash) + PULL_MESSAGE_FIELD_NUMBER;
        hash = (53 * hash) + getPullMessage().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.tasks.v2beta3.Task parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.Task parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.Task parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.Task parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.Task parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.Task parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.Task parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.Task parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.Task parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.Task parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.Task parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.Task parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.tasks.v2beta3.Task prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A unit of scheduled work.
   * </pre>
   *
   * Protobuf type {@code google.cloud.tasks.v2beta3.Task}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.tasks.v2beta3.Task)
      com.google.cloud.tasks.v2beta3.TaskOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.tasks.v2beta3.TaskProto
          .internal_static_google_cloud_tasks_v2beta3_Task_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.tasks.v2beta3.TaskProto
          .internal_static_google_cloud_tasks_v2beta3_Task_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.tasks.v2beta3.Task.class,
              com.google.cloud.tasks.v2beta3.Task.Builder.class);
    }

    // Construct using com.google.cloud.tasks.v2beta3.Task.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      if (appEngineHttpRequestBuilder_ != null) {
        appEngineHttpRequestBuilder_.clear();
      }
      if (httpRequestBuilder_ != null) {
        httpRequestBuilder_.clear();
      }
      if (pullMessageBuilder_ != null) {
        pullMessageBuilder_.clear();
      }
      scheduleTime_ = null;
      if (scheduleTimeBuilder_ != null) {
        scheduleTimeBuilder_.dispose();
        scheduleTimeBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      dispatchDeadline_ = null;
      if (dispatchDeadlineBuilder_ != null) {
        dispatchDeadlineBuilder_.dispose();
        dispatchDeadlineBuilder_ = null;
      }
      dispatchCount_ = 0;
      responseCount_ = 0;
      firstAttempt_ = null;
      if (firstAttemptBuilder_ != null) {
        firstAttemptBuilder_.dispose();
        firstAttemptBuilder_ = null;
      }
      lastAttempt_ = null;
      if (lastAttemptBuilder_ != null) {
        lastAttemptBuilder_.dispose();
        lastAttemptBuilder_ = null;
      }
      view_ = 0;
      payloadTypeCase_ = 0;
      payloadType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.tasks.v2beta3.TaskProto
          .internal_static_google_cloud_tasks_v2beta3_Task_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.Task getDefaultInstanceForType() {
      return com.google.cloud.tasks.v2beta3.Task.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.Task build() {
      com.google.cloud.tasks.v2beta3.Task result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.Task buildPartial() {
      com.google.cloud.tasks.v2beta3.Task result = new com.google.cloud.tasks.v2beta3.Task(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.tasks.v2beta3.Task result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.scheduleTime_ =
            scheduleTimeBuilder_ == null ? scheduleTime_ : scheduleTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.dispatchDeadline_ =
            dispatchDeadlineBuilder_ == null ? dispatchDeadline_ : dispatchDeadlineBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.dispatchCount_ = dispatchCount_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.responseCount_ = responseCount_;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.firstAttempt_ =
            firstAttemptBuilder_ == null ? firstAttempt_ : firstAttemptBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.lastAttempt_ =
            lastAttemptBuilder_ == null ? lastAttempt_ : lastAttemptBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.view_ = view_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.tasks.v2beta3.Task result) {
      result.payloadTypeCase_ = payloadTypeCase_;
      result.payloadType_ = this.payloadType_;
      if (payloadTypeCase_ == 3 && appEngineHttpRequestBuilder_ != null) {
        result.payloadType_ = appEngineHttpRequestBuilder_.build();
      }
      if (payloadTypeCase_ == 11 && httpRequestBuilder_ != null) {
        result.payloadType_ = httpRequestBuilder_.build();
      }
      if (payloadTypeCase_ == 13 && pullMessageBuilder_ != null) {
        result.payloadType_ = pullMessageBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.tasks.v2beta3.Task) {
        return mergeFrom((com.google.cloud.tasks.v2beta3.Task) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.tasks.v2beta3.Task other) {
      if (other == com.google.cloud.tasks.v2beta3.Task.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasScheduleTime()) {
        mergeScheduleTime(other.getScheduleTime());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasDispatchDeadline()) {
        mergeDispatchDeadline(other.getDispatchDeadline());
      }
      if (other.getDispatchCount() != 0) {
        setDispatchCount(other.getDispatchCount());
      }
      if (other.getResponseCount() != 0) {
        setResponseCount(other.getResponseCount());
      }
      if (other.hasFirstAttempt()) {
        mergeFirstAttempt(other.getFirstAttempt());
      }
      if (other.hasLastAttempt()) {
        mergeLastAttempt(other.getLastAttempt());
      }
      if (other.view_ != 0) {
        setViewValue(other.getViewValue());
      }
      switch (other.getPayloadTypeCase()) {
        case APP_ENGINE_HTTP_REQUEST:
          {
            mergeAppEngineHttpRequest(other.getAppEngineHttpRequest());
            break;
          }
        case HTTP_REQUEST:
          {
            mergeHttpRequest(other.getHttpRequest());
            break;
          }
        case PULL_MESSAGE:
          {
            mergePullMessage(other.getPullMessage());
            break;
          }
        case PAYLOADTYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(
                    getAppEngineHttpRequestFieldBuilder().getBuilder(), extensionRegistry);
                payloadTypeCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getScheduleTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 48:
              {
                dispatchCount_ = input.readInt32();
                bitField0_ |= 0x00000080;
                break;
              } // case 48
            case 56:
              {
                responseCount_ = input.readInt32();
                bitField0_ |= 0x00000100;
                break;
              } // case 56
            case 66:
              {
                input.readMessage(getFirstAttemptFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getLastAttemptFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 74
            case 80:
              {
                view_ = input.readEnum();
                bitField0_ |= 0x00000800;
                break;
              } // case 80
            case 90:
              {
                input.readMessage(getHttpRequestFieldBuilder().getBuilder(), extensionRegistry);
                payloadTypeCase_ = 11;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getDispatchDeadlineFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getPullMessageFieldBuilder().getBuilder(), extensionRegistry);
                payloadTypeCase_ = 13;
                break;
              } // case 106
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int payloadTypeCase_ = 0;
    private java.lang.Object payloadType_;

    public PayloadTypeCase getPayloadTypeCase() {
      return PayloadTypeCase.forNumber(payloadTypeCase_);
    }

    public Builder clearPayloadType() {
      payloadTypeCase_ = 0;
      payloadType_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Optionally caller-specified in
     * [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     * The task name.
     * The task name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the task's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     * * `TASK_ID` can contain only letters ([A-Za-z]), numbers ([0-9]),
     *   hyphens (-), or underscores (_). The maximum length is 500 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optionally caller-specified in
     * [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     * The task name.
     * The task name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the task's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     * * `TASK_ID` can contain only letters ([A-Za-z]), numbers ([0-9]),
     *   hyphens (-), or underscores (_). The maximum length is 500 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optionally caller-specified in
     * [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     * The task name.
     * The task name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the task's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     * * `TASK_ID` can contain only letters ([A-Za-z]), numbers ([0-9]),
     *   hyphens (-), or underscores (_). The maximum length is 500 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optionally caller-specified in
     * [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     * The task name.
     * The task name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the task's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     * * `TASK_ID` can contain only letters ([A-Za-z]), numbers ([0-9]),
     *   hyphens (-), or underscores (_). The maximum length is 500 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optionally caller-specified in
     * [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     * The task name.
     * The task name must have the following format:
     * `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID/tasks/TASK_ID`
     * * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]),
     *    hyphens (-), colons (:), or periods (.).
     *    For more information, see
     *    [Identifying
     *    projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects)
     * * `LOCATION_ID` is the canonical ID for the task's location.
     *    The list of available locations can be obtained by calling
     *    [ListLocations][google.cloud.location.Locations.ListLocations].
     *    For more information, see https://cloud.google.com/about/locations/.
     * * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or
     *   hyphens (-). The maximum length is 100 characters.
     * * `TASK_ID` can contain only letters ([A-Za-z]), numbers ([0-9]),
     *   hyphens (-), or underscores (_). The maximum length is 500 characters.
     * </pre>
     *
     * <code>string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.AppEngineHttpRequest,
            com.google.cloud.tasks.v2beta3.AppEngineHttpRequest.Builder,
            com.google.cloud.tasks.v2beta3.AppEngineHttpRequestOrBuilder>
        appEngineHttpRequestBuilder_;
    /**
     *
     *
     * <pre>
     * HTTP request that is sent to the App Engine app handler.
     * An App Engine task is a task that has
     * [AppEngineHttpRequest][google.cloud.tasks.v2beta3.AppEngineHttpRequest]
     * set.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineHttpRequest app_engine_http_request = 3;</code>
     *
     * @return Whether the appEngineHttpRequest field is set.
     */
    @java.lang.Override
    public boolean hasAppEngineHttpRequest() {
      return payloadTypeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * HTTP request that is sent to the App Engine app handler.
     * An App Engine task is a task that has
     * [AppEngineHttpRequest][google.cloud.tasks.v2beta3.AppEngineHttpRequest]
     * set.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineHttpRequest app_engine_http_request = 3;</code>
     *
     * @return The appEngineHttpRequest.
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.AppEngineHttpRequest getAppEngineHttpRequest() {
      if (appEngineHttpRequestBuilder_ == null) {
        if (payloadTypeCase_ == 3) {
          return (com.google.cloud.tasks.v2beta3.AppEngineHttpRequest) payloadType_;
        }
        return com.google.cloud.tasks.v2beta3.AppEngineHttpRequest.getDefaultInstance();
      } else {
        if (payloadTypeCase_ == 3) {
          return appEngineHttpRequestBuilder_.getMessage();
        }
        return com.google.cloud.tasks.v2beta3.AppEngineHttpRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * HTTP request that is sent to the App Engine app handler.
     * An App Engine task is a task that has
     * [AppEngineHttpRequest][google.cloud.tasks.v2beta3.AppEngineHttpRequest]
     * set.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineHttpRequest app_engine_http_request = 3;</code>
     */
    public Builder setAppEngineHttpRequest(
        com.google.cloud.tasks.v2beta3.AppEngineHttpRequest value) {
      if (appEngineHttpRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payloadType_ = value;
        onChanged();
      } else {
        appEngineHttpRequestBuilder_.setMessage(value);
      }
      payloadTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP request that is sent to the App Engine app handler.
     * An App Engine task is a task that has
     * [AppEngineHttpRequest][google.cloud.tasks.v2beta3.AppEngineHttpRequest]
     * set.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineHttpRequest app_engine_http_request = 3;</code>
     */
    public Builder setAppEngineHttpRequest(
        com.google.cloud.tasks.v2beta3.AppEngineHttpRequest.Builder builderForValue) {
      if (appEngineHttpRequestBuilder_ == null) {
        payloadType_ = builderForValue.build();
        onChanged();
      } else {
        appEngineHttpRequestBuilder_.setMessage(builderForValue.build());
      }
      payloadTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP request that is sent to the App Engine app handler.
     * An App Engine task is a task that has
     * [AppEngineHttpRequest][google.cloud.tasks.v2beta3.AppEngineHttpRequest]
     * set.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineHttpRequest app_engine_http_request = 3;</code>
     */
    public Builder mergeAppEngineHttpRequest(
        com.google.cloud.tasks.v2beta3.AppEngineHttpRequest value) {
      if (appEngineHttpRequestBuilder_ == null) {
        if (payloadTypeCase_ == 3
            && payloadType_
                != com.google.cloud.tasks.v2beta3.AppEngineHttpRequest.getDefaultInstance()) {
          payloadType_ =
              com.google.cloud.tasks.v2beta3.AppEngineHttpRequest.newBuilder(
                      (com.google.cloud.tasks.v2beta3.AppEngineHttpRequest) payloadType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payloadType_ = value;
        }
        onChanged();
      } else {
        if (payloadTypeCase_ == 3) {
          appEngineHttpRequestBuilder_.mergeFrom(value);
        } else {
          appEngineHttpRequestBuilder_.setMessage(value);
        }
      }
      payloadTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP request that is sent to the App Engine app handler.
     * An App Engine task is a task that has
     * [AppEngineHttpRequest][google.cloud.tasks.v2beta3.AppEngineHttpRequest]
     * set.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineHttpRequest app_engine_http_request = 3;</code>
     */
    public Builder clearAppEngineHttpRequest() {
      if (appEngineHttpRequestBuilder_ == null) {
        if (payloadTypeCase_ == 3) {
          payloadTypeCase_ = 0;
          payloadType_ = null;
          onChanged();
        }
      } else {
        if (payloadTypeCase_ == 3) {
          payloadTypeCase_ = 0;
          payloadType_ = null;
        }
        appEngineHttpRequestBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP request that is sent to the App Engine app handler.
     * An App Engine task is a task that has
     * [AppEngineHttpRequest][google.cloud.tasks.v2beta3.AppEngineHttpRequest]
     * set.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineHttpRequest app_engine_http_request = 3;</code>
     */
    public com.google.cloud.tasks.v2beta3.AppEngineHttpRequest.Builder
        getAppEngineHttpRequestBuilder() {
      return getAppEngineHttpRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * HTTP request that is sent to the App Engine app handler.
     * An App Engine task is a task that has
     * [AppEngineHttpRequest][google.cloud.tasks.v2beta3.AppEngineHttpRequest]
     * set.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineHttpRequest app_engine_http_request = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.AppEngineHttpRequestOrBuilder
        getAppEngineHttpRequestOrBuilder() {
      if ((payloadTypeCase_ == 3) && (appEngineHttpRequestBuilder_ != null)) {
        return appEngineHttpRequestBuilder_.getMessageOrBuilder();
      } else {
        if (payloadTypeCase_ == 3) {
          return (com.google.cloud.tasks.v2beta3.AppEngineHttpRequest) payloadType_;
        }
        return com.google.cloud.tasks.v2beta3.AppEngineHttpRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * HTTP request that is sent to the App Engine app handler.
     * An App Engine task is a task that has
     * [AppEngineHttpRequest][google.cloud.tasks.v2beta3.AppEngineHttpRequest]
     * set.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineHttpRequest app_engine_http_request = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.AppEngineHttpRequest,
            com.google.cloud.tasks.v2beta3.AppEngineHttpRequest.Builder,
            com.google.cloud.tasks.v2beta3.AppEngineHttpRequestOrBuilder>
        getAppEngineHttpRequestFieldBuilder() {
      if (appEngineHttpRequestBuilder_ == null) {
        if (!(payloadTypeCase_ == 3)) {
          payloadType_ = com.google.cloud.tasks.v2beta3.AppEngineHttpRequest.getDefaultInstance();
        }
        appEngineHttpRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2beta3.AppEngineHttpRequest,
                com.google.cloud.tasks.v2beta3.AppEngineHttpRequest.Builder,
                com.google.cloud.tasks.v2beta3.AppEngineHttpRequestOrBuilder>(
                (com.google.cloud.tasks.v2beta3.AppEngineHttpRequest) payloadType_,
                getParentForChildren(),
                isClean());
        payloadType_ = null;
      }
      payloadTypeCase_ = 3;
      onChanged();
      return appEngineHttpRequestBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.HttpRequest,
            com.google.cloud.tasks.v2beta3.HttpRequest.Builder,
            com.google.cloud.tasks.v2beta3.HttpRequestOrBuilder>
        httpRequestBuilder_;
    /**
     *
     *
     * <pre>
     * HTTP request that is sent to the task's target.
     * An HTTP task is a task that has
     * [HttpRequest][google.cloud.tasks.v2beta3.HttpRequest] set.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.HttpRequest http_request = 11;</code>
     *
     * @return Whether the httpRequest field is set.
     */
    @java.lang.Override
    public boolean hasHttpRequest() {
      return payloadTypeCase_ == 11;
    }
    /**
     *
     *
     * <pre>
     * HTTP request that is sent to the task's target.
     * An HTTP task is a task that has
     * [HttpRequest][google.cloud.tasks.v2beta3.HttpRequest] set.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.HttpRequest http_request = 11;</code>
     *
     * @return The httpRequest.
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.HttpRequest getHttpRequest() {
      if (httpRequestBuilder_ == null) {
        if (payloadTypeCase_ == 11) {
          return (com.google.cloud.tasks.v2beta3.HttpRequest) payloadType_;
        }
        return com.google.cloud.tasks.v2beta3.HttpRequest.getDefaultInstance();
      } else {
        if (payloadTypeCase_ == 11) {
          return httpRequestBuilder_.getMessage();
        }
        return com.google.cloud.tasks.v2beta3.HttpRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * HTTP request that is sent to the task's target.
     * An HTTP task is a task that has
     * [HttpRequest][google.cloud.tasks.v2beta3.HttpRequest] set.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.HttpRequest http_request = 11;</code>
     */
    public Builder setHttpRequest(com.google.cloud.tasks.v2beta3.HttpRequest value) {
      if (httpRequestBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payloadType_ = value;
        onChanged();
      } else {
        httpRequestBuilder_.setMessage(value);
      }
      payloadTypeCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP request that is sent to the task's target.
     * An HTTP task is a task that has
     * [HttpRequest][google.cloud.tasks.v2beta3.HttpRequest] set.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.HttpRequest http_request = 11;</code>
     */
    public Builder setHttpRequest(
        com.google.cloud.tasks.v2beta3.HttpRequest.Builder builderForValue) {
      if (httpRequestBuilder_ == null) {
        payloadType_ = builderForValue.build();
        onChanged();
      } else {
        httpRequestBuilder_.setMessage(builderForValue.build());
      }
      payloadTypeCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP request that is sent to the task's target.
     * An HTTP task is a task that has
     * [HttpRequest][google.cloud.tasks.v2beta3.HttpRequest] set.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.HttpRequest http_request = 11;</code>
     */
    public Builder mergeHttpRequest(com.google.cloud.tasks.v2beta3.HttpRequest value) {
      if (httpRequestBuilder_ == null) {
        if (payloadTypeCase_ == 11
            && payloadType_ != com.google.cloud.tasks.v2beta3.HttpRequest.getDefaultInstance()) {
          payloadType_ =
              com.google.cloud.tasks.v2beta3.HttpRequest.newBuilder(
                      (com.google.cloud.tasks.v2beta3.HttpRequest) payloadType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payloadType_ = value;
        }
        onChanged();
      } else {
        if (payloadTypeCase_ == 11) {
          httpRequestBuilder_.mergeFrom(value);
        } else {
          httpRequestBuilder_.setMessage(value);
        }
      }
      payloadTypeCase_ = 11;
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP request that is sent to the task's target.
     * An HTTP task is a task that has
     * [HttpRequest][google.cloud.tasks.v2beta3.HttpRequest] set.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.HttpRequest http_request = 11;</code>
     */
    public Builder clearHttpRequest() {
      if (httpRequestBuilder_ == null) {
        if (payloadTypeCase_ == 11) {
          payloadTypeCase_ = 0;
          payloadType_ = null;
          onChanged();
        }
      } else {
        if (payloadTypeCase_ == 11) {
          payloadTypeCase_ = 0;
          payloadType_ = null;
        }
        httpRequestBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP request that is sent to the task's target.
     * An HTTP task is a task that has
     * [HttpRequest][google.cloud.tasks.v2beta3.HttpRequest] set.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.HttpRequest http_request = 11;</code>
     */
    public com.google.cloud.tasks.v2beta3.HttpRequest.Builder getHttpRequestBuilder() {
      return getHttpRequestFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * HTTP request that is sent to the task's target.
     * An HTTP task is a task that has
     * [HttpRequest][google.cloud.tasks.v2beta3.HttpRequest] set.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.HttpRequest http_request = 11;</code>
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.HttpRequestOrBuilder getHttpRequestOrBuilder() {
      if ((payloadTypeCase_ == 11) && (httpRequestBuilder_ != null)) {
        return httpRequestBuilder_.getMessageOrBuilder();
      } else {
        if (payloadTypeCase_ == 11) {
          return (com.google.cloud.tasks.v2beta3.HttpRequest) payloadType_;
        }
        return com.google.cloud.tasks.v2beta3.HttpRequest.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * HTTP request that is sent to the task's target.
     * An HTTP task is a task that has
     * [HttpRequest][google.cloud.tasks.v2beta3.HttpRequest] set.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.HttpRequest http_request = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.HttpRequest,
            com.google.cloud.tasks.v2beta3.HttpRequest.Builder,
            com.google.cloud.tasks.v2beta3.HttpRequestOrBuilder>
        getHttpRequestFieldBuilder() {
      if (httpRequestBuilder_ == null) {
        if (!(payloadTypeCase_ == 11)) {
          payloadType_ = com.google.cloud.tasks.v2beta3.HttpRequest.getDefaultInstance();
        }
        httpRequestBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2beta3.HttpRequest,
                com.google.cloud.tasks.v2beta3.HttpRequest.Builder,
                com.google.cloud.tasks.v2beta3.HttpRequestOrBuilder>(
                (com.google.cloud.tasks.v2beta3.HttpRequest) payloadType_,
                getParentForChildren(),
                isClean());
        payloadType_ = null;
      }
      payloadTypeCase_ = 11;
      onChanged();
      return httpRequestBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.PullMessage,
            com.google.cloud.tasks.v2beta3.PullMessage.Builder,
            com.google.cloud.tasks.v2beta3.PullMessageOrBuilder>
        pullMessageBuilder_;
    /**
     *
     *
     * <pre>
     * Pull Message contained in a task in a
     * [PULL][google.cloud.tasks.v2beta3.Queue.type] queue type. This payload
     * type cannot be explicitly set through Cloud Tasks API. Its purpose,
     * currently is to provide backward compatibility with App Engine Task Queue
     * [pull](https://cloud.google.com/appengine/docs/standard/java/taskqueue/pull/)
     * queues to provide a way to inspect contents of pull tasks through the
     * [CloudTasks.GetTask][google.cloud.tasks.v2beta3.CloudTasks.GetTask].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.PullMessage pull_message = 13;</code>
     *
     * @return Whether the pullMessage field is set.
     */
    @java.lang.Override
    public boolean hasPullMessage() {
      return payloadTypeCase_ == 13;
    }
    /**
     *
     *
     * <pre>
     * Pull Message contained in a task in a
     * [PULL][google.cloud.tasks.v2beta3.Queue.type] queue type. This payload
     * type cannot be explicitly set through Cloud Tasks API. Its purpose,
     * currently is to provide backward compatibility with App Engine Task Queue
     * [pull](https://cloud.google.com/appengine/docs/standard/java/taskqueue/pull/)
     * queues to provide a way to inspect contents of pull tasks through the
     * [CloudTasks.GetTask][google.cloud.tasks.v2beta3.CloudTasks.GetTask].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.PullMessage pull_message = 13;</code>
     *
     * @return The pullMessage.
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.PullMessage getPullMessage() {
      if (pullMessageBuilder_ == null) {
        if (payloadTypeCase_ == 13) {
          return (com.google.cloud.tasks.v2beta3.PullMessage) payloadType_;
        }
        return com.google.cloud.tasks.v2beta3.PullMessage.getDefaultInstance();
      } else {
        if (payloadTypeCase_ == 13) {
          return pullMessageBuilder_.getMessage();
        }
        return com.google.cloud.tasks.v2beta3.PullMessage.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Pull Message contained in a task in a
     * [PULL][google.cloud.tasks.v2beta3.Queue.type] queue type. This payload
     * type cannot be explicitly set through Cloud Tasks API. Its purpose,
     * currently is to provide backward compatibility with App Engine Task Queue
     * [pull](https://cloud.google.com/appengine/docs/standard/java/taskqueue/pull/)
     * queues to provide a way to inspect contents of pull tasks through the
     * [CloudTasks.GetTask][google.cloud.tasks.v2beta3.CloudTasks.GetTask].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.PullMessage pull_message = 13;</code>
     */
    public Builder setPullMessage(com.google.cloud.tasks.v2beta3.PullMessage value) {
      if (pullMessageBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        payloadType_ = value;
        onChanged();
      } else {
        pullMessageBuilder_.setMessage(value);
      }
      payloadTypeCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pull Message contained in a task in a
     * [PULL][google.cloud.tasks.v2beta3.Queue.type] queue type. This payload
     * type cannot be explicitly set through Cloud Tasks API. Its purpose,
     * currently is to provide backward compatibility with App Engine Task Queue
     * [pull](https://cloud.google.com/appengine/docs/standard/java/taskqueue/pull/)
     * queues to provide a way to inspect contents of pull tasks through the
     * [CloudTasks.GetTask][google.cloud.tasks.v2beta3.CloudTasks.GetTask].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.PullMessage pull_message = 13;</code>
     */
    public Builder setPullMessage(
        com.google.cloud.tasks.v2beta3.PullMessage.Builder builderForValue) {
      if (pullMessageBuilder_ == null) {
        payloadType_ = builderForValue.build();
        onChanged();
      } else {
        pullMessageBuilder_.setMessage(builderForValue.build());
      }
      payloadTypeCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pull Message contained in a task in a
     * [PULL][google.cloud.tasks.v2beta3.Queue.type] queue type. This payload
     * type cannot be explicitly set through Cloud Tasks API. Its purpose,
     * currently is to provide backward compatibility with App Engine Task Queue
     * [pull](https://cloud.google.com/appengine/docs/standard/java/taskqueue/pull/)
     * queues to provide a way to inspect contents of pull tasks through the
     * [CloudTasks.GetTask][google.cloud.tasks.v2beta3.CloudTasks.GetTask].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.PullMessage pull_message = 13;</code>
     */
    public Builder mergePullMessage(com.google.cloud.tasks.v2beta3.PullMessage value) {
      if (pullMessageBuilder_ == null) {
        if (payloadTypeCase_ == 13
            && payloadType_ != com.google.cloud.tasks.v2beta3.PullMessage.getDefaultInstance()) {
          payloadType_ =
              com.google.cloud.tasks.v2beta3.PullMessage.newBuilder(
                      (com.google.cloud.tasks.v2beta3.PullMessage) payloadType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          payloadType_ = value;
        }
        onChanged();
      } else {
        if (payloadTypeCase_ == 13) {
          pullMessageBuilder_.mergeFrom(value);
        } else {
          pullMessageBuilder_.setMessage(value);
        }
      }
      payloadTypeCase_ = 13;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pull Message contained in a task in a
     * [PULL][google.cloud.tasks.v2beta3.Queue.type] queue type. This payload
     * type cannot be explicitly set through Cloud Tasks API. Its purpose,
     * currently is to provide backward compatibility with App Engine Task Queue
     * [pull](https://cloud.google.com/appengine/docs/standard/java/taskqueue/pull/)
     * queues to provide a way to inspect contents of pull tasks through the
     * [CloudTasks.GetTask][google.cloud.tasks.v2beta3.CloudTasks.GetTask].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.PullMessage pull_message = 13;</code>
     */
    public Builder clearPullMessage() {
      if (pullMessageBuilder_ == null) {
        if (payloadTypeCase_ == 13) {
          payloadTypeCase_ = 0;
          payloadType_ = null;
          onChanged();
        }
      } else {
        if (payloadTypeCase_ == 13) {
          payloadTypeCase_ = 0;
          payloadType_ = null;
        }
        pullMessageBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Pull Message contained in a task in a
     * [PULL][google.cloud.tasks.v2beta3.Queue.type] queue type. This payload
     * type cannot be explicitly set through Cloud Tasks API. Its purpose,
     * currently is to provide backward compatibility with App Engine Task Queue
     * [pull](https://cloud.google.com/appengine/docs/standard/java/taskqueue/pull/)
     * queues to provide a way to inspect contents of pull tasks through the
     * [CloudTasks.GetTask][google.cloud.tasks.v2beta3.CloudTasks.GetTask].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.PullMessage pull_message = 13;</code>
     */
    public com.google.cloud.tasks.v2beta3.PullMessage.Builder getPullMessageBuilder() {
      return getPullMessageFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Pull Message contained in a task in a
     * [PULL][google.cloud.tasks.v2beta3.Queue.type] queue type. This payload
     * type cannot be explicitly set through Cloud Tasks API. Its purpose,
     * currently is to provide backward compatibility with App Engine Task Queue
     * [pull](https://cloud.google.com/appengine/docs/standard/java/taskqueue/pull/)
     * queues to provide a way to inspect contents of pull tasks through the
     * [CloudTasks.GetTask][google.cloud.tasks.v2beta3.CloudTasks.GetTask].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.PullMessage pull_message = 13;</code>
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.PullMessageOrBuilder getPullMessageOrBuilder() {
      if ((payloadTypeCase_ == 13) && (pullMessageBuilder_ != null)) {
        return pullMessageBuilder_.getMessageOrBuilder();
      } else {
        if (payloadTypeCase_ == 13) {
          return (com.google.cloud.tasks.v2beta3.PullMessage) payloadType_;
        }
        return com.google.cloud.tasks.v2beta3.PullMessage.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Pull Message contained in a task in a
     * [PULL][google.cloud.tasks.v2beta3.Queue.type] queue type. This payload
     * type cannot be explicitly set through Cloud Tasks API. Its purpose,
     * currently is to provide backward compatibility with App Engine Task Queue
     * [pull](https://cloud.google.com/appengine/docs/standard/java/taskqueue/pull/)
     * queues to provide a way to inspect contents of pull tasks through the
     * [CloudTasks.GetTask][google.cloud.tasks.v2beta3.CloudTasks.GetTask].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.PullMessage pull_message = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.PullMessage,
            com.google.cloud.tasks.v2beta3.PullMessage.Builder,
            com.google.cloud.tasks.v2beta3.PullMessageOrBuilder>
        getPullMessageFieldBuilder() {
      if (pullMessageBuilder_ == null) {
        if (!(payloadTypeCase_ == 13)) {
          payloadType_ = com.google.cloud.tasks.v2beta3.PullMessage.getDefaultInstance();
        }
        pullMessageBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2beta3.PullMessage,
                com.google.cloud.tasks.v2beta3.PullMessage.Builder,
                com.google.cloud.tasks.v2beta3.PullMessageOrBuilder>(
                (com.google.cloud.tasks.v2beta3.PullMessage) payloadType_,
                getParentForChildren(),
                isClean());
        payloadType_ = null;
      }
      payloadTypeCase_ = 13;
      onChanged();
      return pullMessageBuilder_;
    }

    private com.google.protobuf.Timestamp scheduleTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        scheduleTimeBuilder_;
    /**
     *
     *
     * <pre>
     * The time when the task is scheduled to be attempted.
     * For App Engine queues, this is when the task will be attempted or retried.
     * `schedule_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 4;</code>
     *
     * @return Whether the scheduleTime field is set.
     */
    public boolean hasScheduleTime() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * The time when the task is scheduled to be attempted.
     * For App Engine queues, this is when the task will be attempted or retried.
     * `schedule_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 4;</code>
     *
     * @return The scheduleTime.
     */
    public com.google.protobuf.Timestamp getScheduleTime() {
      if (scheduleTimeBuilder_ == null) {
        return scheduleTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : scheduleTime_;
      } else {
        return scheduleTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the task is scheduled to be attempted.
     * For App Engine queues, this is when the task will be attempted or retried.
     * `schedule_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 4;</code>
     */
    public Builder setScheduleTime(com.google.protobuf.Timestamp value) {
      if (scheduleTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        scheduleTime_ = value;
      } else {
        scheduleTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the task is scheduled to be attempted.
     * For App Engine queues, this is when the task will be attempted or retried.
     * `schedule_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 4;</code>
     */
    public Builder setScheduleTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (scheduleTimeBuilder_ == null) {
        scheduleTime_ = builderForValue.build();
      } else {
        scheduleTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the task is scheduled to be attempted.
     * For App Engine queues, this is when the task will be attempted or retried.
     * `schedule_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 4;</code>
     */
    public Builder mergeScheduleTime(com.google.protobuf.Timestamp value) {
      if (scheduleTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && scheduleTime_ != null
            && scheduleTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getScheduleTimeBuilder().mergeFrom(value);
        } else {
          scheduleTime_ = value;
        }
      } else {
        scheduleTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the task is scheduled to be attempted.
     * For App Engine queues, this is when the task will be attempted or retried.
     * `schedule_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 4;</code>
     */
    public Builder clearScheduleTime() {
      bitField0_ = (bitField0_ & ~0x00000010);
      scheduleTime_ = null;
      if (scheduleTimeBuilder_ != null) {
        scheduleTimeBuilder_.dispose();
        scheduleTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time when the task is scheduled to be attempted.
     * For App Engine queues, this is when the task will be attempted or retried.
     * `schedule_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 4;</code>
     */
    public com.google.protobuf.Timestamp.Builder getScheduleTimeBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getScheduleTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The time when the task is scheduled to be attempted.
     * For App Engine queues, this is when the task will be attempted or retried.
     * `schedule_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 4;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getScheduleTimeOrBuilder() {
      if (scheduleTimeBuilder_ != null) {
        return scheduleTimeBuilder_.getMessageOrBuilder();
      } else {
        return scheduleTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : scheduleTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * The time when the task is scheduled to be attempted.
     * For App Engine queues, this is when the task will be attempted or retried.
     * `schedule_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getScheduleTimeFieldBuilder() {
      if (scheduleTimeBuilder_ == null) {
        scheduleTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getScheduleTime(), getParentForChildren(), isClean());
        scheduleTime_ = null;
      }
      return scheduleTimeBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time that the task was created.
     * `create_time` will be truncated to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that the task was created.
     * `create_time` will be truncated to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that the task was created.
     * `create_time` will be truncated to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that the task was created.
     * `create_time` will be truncated to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that the task was created.
     * `create_time` will be truncated to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that the task was created.
     * `create_time` will be truncated to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that the task was created.
     * `create_time` will be truncated to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that the task was created.
     * `create_time` will be truncated to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that the task was created.
     * `create_time` will be truncated to the nearest second.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp create_time = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Duration dispatchDeadline_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        dispatchDeadlineBuilder_;
    /**
     *
     *
     * <pre>
     * The deadline for requests sent to the worker. If the worker does not
     * respond by this deadline then the request is cancelled and the attempt
     * is marked as a `DEADLINE_EXCEEDED` failure. Cloud Tasks will retry the
     * task according to the
     * [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig].
     * Note that when the request is cancelled, Cloud Tasks will stop listening
     * for the response, but whether the worker stops processing depends on the
     * worker. For example, if the worker is stuck, it may not react to cancelled
     * requests.
     * The default and maximum values depend on the type of request:
     * * For [HTTP tasks][google.cloud.tasks.v2beta3.HttpRequest], the default is
     * 10 minutes. The deadline
     *   must be in the interval [15 seconds, 30 minutes].
     * * For [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest],
     * 0 indicates that the
     *   request has the default deadline. The default deadline depends on the
     *   [scaling
     *   type](https://cloud.google.com/appengine/docs/standard/go/how-instances-are-managed#instance_scaling)
     *   of the service: 10 minutes for standard apps with automatic scaling, 24
     *   hours for standard apps with manual and basic scaling, and 60 minutes for
     *   flex apps. If the request deadline is set, it must be in the interval [15
     *   seconds, 24 hours 15 seconds]. Regardless of the task's
     *   `dispatch_deadline`, the app handler will not run for longer than than
     *   the service's timeout. We recommend setting the `dispatch_deadline` to
     *   at most a few seconds more than the app handler's timeout. For more
     *   information see
     *   [Timeouts](https://cloud.google.com/tasks/docs/creating-appengine-handlers#timeouts).
     * `dispatch_deadline` will be truncated to the nearest millisecond. The
     * deadline is an approximate deadline.
     * </pre>
     *
     * <code>.google.protobuf.Duration dispatch_deadline = 12;</code>
     *
     * @return Whether the dispatchDeadline field is set.
     */
    public boolean hasDispatchDeadline() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     *
     *
     * <pre>
     * The deadline for requests sent to the worker. If the worker does not
     * respond by this deadline then the request is cancelled and the attempt
     * is marked as a `DEADLINE_EXCEEDED` failure. Cloud Tasks will retry the
     * task according to the
     * [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig].
     * Note that when the request is cancelled, Cloud Tasks will stop listening
     * for the response, but whether the worker stops processing depends on the
     * worker. For example, if the worker is stuck, it may not react to cancelled
     * requests.
     * The default and maximum values depend on the type of request:
     * * For [HTTP tasks][google.cloud.tasks.v2beta3.HttpRequest], the default is
     * 10 minutes. The deadline
     *   must be in the interval [15 seconds, 30 minutes].
     * * For [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest],
     * 0 indicates that the
     *   request has the default deadline. The default deadline depends on the
     *   [scaling
     *   type](https://cloud.google.com/appengine/docs/standard/go/how-instances-are-managed#instance_scaling)
     *   of the service: 10 minutes for standard apps with automatic scaling, 24
     *   hours for standard apps with manual and basic scaling, and 60 minutes for
     *   flex apps. If the request deadline is set, it must be in the interval [15
     *   seconds, 24 hours 15 seconds]. Regardless of the task's
     *   `dispatch_deadline`, the app handler will not run for longer than than
     *   the service's timeout. We recommend setting the `dispatch_deadline` to
     *   at most a few seconds more than the app handler's timeout. For more
     *   information see
     *   [Timeouts](https://cloud.google.com/tasks/docs/creating-appengine-handlers#timeouts).
     * `dispatch_deadline` will be truncated to the nearest millisecond. The
     * deadline is an approximate deadline.
     * </pre>
     *
     * <code>.google.protobuf.Duration dispatch_deadline = 12;</code>
     *
     * @return The dispatchDeadline.
     */
    public com.google.protobuf.Duration getDispatchDeadline() {
      if (dispatchDeadlineBuilder_ == null) {
        return dispatchDeadline_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : dispatchDeadline_;
      } else {
        return dispatchDeadlineBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The deadline for requests sent to the worker. If the worker does not
     * respond by this deadline then the request is cancelled and the attempt
     * is marked as a `DEADLINE_EXCEEDED` failure. Cloud Tasks will retry the
     * task according to the
     * [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig].
     * Note that when the request is cancelled, Cloud Tasks will stop listening
     * for the response, but whether the worker stops processing depends on the
     * worker. For example, if the worker is stuck, it may not react to cancelled
     * requests.
     * The default and maximum values depend on the type of request:
     * * For [HTTP tasks][google.cloud.tasks.v2beta3.HttpRequest], the default is
     * 10 minutes. The deadline
     *   must be in the interval [15 seconds, 30 minutes].
     * * For [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest],
     * 0 indicates that the
     *   request has the default deadline. The default deadline depends on the
     *   [scaling
     *   type](https://cloud.google.com/appengine/docs/standard/go/how-instances-are-managed#instance_scaling)
     *   of the service: 10 minutes for standard apps with automatic scaling, 24
     *   hours for standard apps with manual and basic scaling, and 60 minutes for
     *   flex apps. If the request deadline is set, it must be in the interval [15
     *   seconds, 24 hours 15 seconds]. Regardless of the task's
     *   `dispatch_deadline`, the app handler will not run for longer than than
     *   the service's timeout. We recommend setting the `dispatch_deadline` to
     *   at most a few seconds more than the app handler's timeout. For more
     *   information see
     *   [Timeouts](https://cloud.google.com/tasks/docs/creating-appengine-handlers#timeouts).
     * `dispatch_deadline` will be truncated to the nearest millisecond. The
     * deadline is an approximate deadline.
     * </pre>
     *
     * <code>.google.protobuf.Duration dispatch_deadline = 12;</code>
     */
    public Builder setDispatchDeadline(com.google.protobuf.Duration value) {
      if (dispatchDeadlineBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dispatchDeadline_ = value;
      } else {
        dispatchDeadlineBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The deadline for requests sent to the worker. If the worker does not
     * respond by this deadline then the request is cancelled and the attempt
     * is marked as a `DEADLINE_EXCEEDED` failure. Cloud Tasks will retry the
     * task according to the
     * [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig].
     * Note that when the request is cancelled, Cloud Tasks will stop listening
     * for the response, but whether the worker stops processing depends on the
     * worker. For example, if the worker is stuck, it may not react to cancelled
     * requests.
     * The default and maximum values depend on the type of request:
     * * For [HTTP tasks][google.cloud.tasks.v2beta3.HttpRequest], the default is
     * 10 minutes. The deadline
     *   must be in the interval [15 seconds, 30 minutes].
     * * For [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest],
     * 0 indicates that the
     *   request has the default deadline. The default deadline depends on the
     *   [scaling
     *   type](https://cloud.google.com/appengine/docs/standard/go/how-instances-are-managed#instance_scaling)
     *   of the service: 10 minutes for standard apps with automatic scaling, 24
     *   hours for standard apps with manual and basic scaling, and 60 minutes for
     *   flex apps. If the request deadline is set, it must be in the interval [15
     *   seconds, 24 hours 15 seconds]. Regardless of the task's
     *   `dispatch_deadline`, the app handler will not run for longer than than
     *   the service's timeout. We recommend setting the `dispatch_deadline` to
     *   at most a few seconds more than the app handler's timeout. For more
     *   information see
     *   [Timeouts](https://cloud.google.com/tasks/docs/creating-appengine-handlers#timeouts).
     * `dispatch_deadline` will be truncated to the nearest millisecond. The
     * deadline is an approximate deadline.
     * </pre>
     *
     * <code>.google.protobuf.Duration dispatch_deadline = 12;</code>
     */
    public Builder setDispatchDeadline(com.google.protobuf.Duration.Builder builderForValue) {
      if (dispatchDeadlineBuilder_ == null) {
        dispatchDeadline_ = builderForValue.build();
      } else {
        dispatchDeadlineBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The deadline for requests sent to the worker. If the worker does not
     * respond by this deadline then the request is cancelled and the attempt
     * is marked as a `DEADLINE_EXCEEDED` failure. Cloud Tasks will retry the
     * task according to the
     * [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig].
     * Note that when the request is cancelled, Cloud Tasks will stop listening
     * for the response, but whether the worker stops processing depends on the
     * worker. For example, if the worker is stuck, it may not react to cancelled
     * requests.
     * The default and maximum values depend on the type of request:
     * * For [HTTP tasks][google.cloud.tasks.v2beta3.HttpRequest], the default is
     * 10 minutes. The deadline
     *   must be in the interval [15 seconds, 30 minutes].
     * * For [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest],
     * 0 indicates that the
     *   request has the default deadline. The default deadline depends on the
     *   [scaling
     *   type](https://cloud.google.com/appengine/docs/standard/go/how-instances-are-managed#instance_scaling)
     *   of the service: 10 minutes for standard apps with automatic scaling, 24
     *   hours for standard apps with manual and basic scaling, and 60 minutes for
     *   flex apps. If the request deadline is set, it must be in the interval [15
     *   seconds, 24 hours 15 seconds]. Regardless of the task's
     *   `dispatch_deadline`, the app handler will not run for longer than than
     *   the service's timeout. We recommend setting the `dispatch_deadline` to
     *   at most a few seconds more than the app handler's timeout. For more
     *   information see
     *   [Timeouts](https://cloud.google.com/tasks/docs/creating-appengine-handlers#timeouts).
     * `dispatch_deadline` will be truncated to the nearest millisecond. The
     * deadline is an approximate deadline.
     * </pre>
     *
     * <code>.google.protobuf.Duration dispatch_deadline = 12;</code>
     */
    public Builder mergeDispatchDeadline(com.google.protobuf.Duration value) {
      if (dispatchDeadlineBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && dispatchDeadline_ != null
            && dispatchDeadline_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getDispatchDeadlineBuilder().mergeFrom(value);
        } else {
          dispatchDeadline_ = value;
        }
      } else {
        dispatchDeadlineBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The deadline for requests sent to the worker. If the worker does not
     * respond by this deadline then the request is cancelled and the attempt
     * is marked as a `DEADLINE_EXCEEDED` failure. Cloud Tasks will retry the
     * task according to the
     * [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig].
     * Note that when the request is cancelled, Cloud Tasks will stop listening
     * for the response, but whether the worker stops processing depends on the
     * worker. For example, if the worker is stuck, it may not react to cancelled
     * requests.
     * The default and maximum values depend on the type of request:
     * * For [HTTP tasks][google.cloud.tasks.v2beta3.HttpRequest], the default is
     * 10 minutes. The deadline
     *   must be in the interval [15 seconds, 30 minutes].
     * * For [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest],
     * 0 indicates that the
     *   request has the default deadline. The default deadline depends on the
     *   [scaling
     *   type](https://cloud.google.com/appengine/docs/standard/go/how-instances-are-managed#instance_scaling)
     *   of the service: 10 minutes for standard apps with automatic scaling, 24
     *   hours for standard apps with manual and basic scaling, and 60 minutes for
     *   flex apps. If the request deadline is set, it must be in the interval [15
     *   seconds, 24 hours 15 seconds]. Regardless of the task's
     *   `dispatch_deadline`, the app handler will not run for longer than than
     *   the service's timeout. We recommend setting the `dispatch_deadline` to
     *   at most a few seconds more than the app handler's timeout. For more
     *   information see
     *   [Timeouts](https://cloud.google.com/tasks/docs/creating-appengine-handlers#timeouts).
     * `dispatch_deadline` will be truncated to the nearest millisecond. The
     * deadline is an approximate deadline.
     * </pre>
     *
     * <code>.google.protobuf.Duration dispatch_deadline = 12;</code>
     */
    public Builder clearDispatchDeadline() {
      bitField0_ = (bitField0_ & ~0x00000040);
      dispatchDeadline_ = null;
      if (dispatchDeadlineBuilder_ != null) {
        dispatchDeadlineBuilder_.dispose();
        dispatchDeadlineBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The deadline for requests sent to the worker. If the worker does not
     * respond by this deadline then the request is cancelled and the attempt
     * is marked as a `DEADLINE_EXCEEDED` failure. Cloud Tasks will retry the
     * task according to the
     * [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig].
     * Note that when the request is cancelled, Cloud Tasks will stop listening
     * for the response, but whether the worker stops processing depends on the
     * worker. For example, if the worker is stuck, it may not react to cancelled
     * requests.
     * The default and maximum values depend on the type of request:
     * * For [HTTP tasks][google.cloud.tasks.v2beta3.HttpRequest], the default is
     * 10 minutes. The deadline
     *   must be in the interval [15 seconds, 30 minutes].
     * * For [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest],
     * 0 indicates that the
     *   request has the default deadline. The default deadline depends on the
     *   [scaling
     *   type](https://cloud.google.com/appengine/docs/standard/go/how-instances-are-managed#instance_scaling)
     *   of the service: 10 minutes for standard apps with automatic scaling, 24
     *   hours for standard apps with manual and basic scaling, and 60 minutes for
     *   flex apps. If the request deadline is set, it must be in the interval [15
     *   seconds, 24 hours 15 seconds]. Regardless of the task's
     *   `dispatch_deadline`, the app handler will not run for longer than than
     *   the service's timeout. We recommend setting the `dispatch_deadline` to
     *   at most a few seconds more than the app handler's timeout. For more
     *   information see
     *   [Timeouts](https://cloud.google.com/tasks/docs/creating-appengine-handlers#timeouts).
     * `dispatch_deadline` will be truncated to the nearest millisecond. The
     * deadline is an approximate deadline.
     * </pre>
     *
     * <code>.google.protobuf.Duration dispatch_deadline = 12;</code>
     */
    public com.google.protobuf.Duration.Builder getDispatchDeadlineBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getDispatchDeadlineFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The deadline for requests sent to the worker. If the worker does not
     * respond by this deadline then the request is cancelled and the attempt
     * is marked as a `DEADLINE_EXCEEDED` failure. Cloud Tasks will retry the
     * task according to the
     * [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig].
     * Note that when the request is cancelled, Cloud Tasks will stop listening
     * for the response, but whether the worker stops processing depends on the
     * worker. For example, if the worker is stuck, it may not react to cancelled
     * requests.
     * The default and maximum values depend on the type of request:
     * * For [HTTP tasks][google.cloud.tasks.v2beta3.HttpRequest], the default is
     * 10 minutes. The deadline
     *   must be in the interval [15 seconds, 30 minutes].
     * * For [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest],
     * 0 indicates that the
     *   request has the default deadline. The default deadline depends on the
     *   [scaling
     *   type](https://cloud.google.com/appengine/docs/standard/go/how-instances-are-managed#instance_scaling)
     *   of the service: 10 minutes for standard apps with automatic scaling, 24
     *   hours for standard apps with manual and basic scaling, and 60 minutes for
     *   flex apps. If the request deadline is set, it must be in the interval [15
     *   seconds, 24 hours 15 seconds]. Regardless of the task's
     *   `dispatch_deadline`, the app handler will not run for longer than than
     *   the service's timeout. We recommend setting the `dispatch_deadline` to
     *   at most a few seconds more than the app handler's timeout. For more
     *   information see
     *   [Timeouts](https://cloud.google.com/tasks/docs/creating-appengine-handlers#timeouts).
     * `dispatch_deadline` will be truncated to the nearest millisecond. The
     * deadline is an approximate deadline.
     * </pre>
     *
     * <code>.google.protobuf.Duration dispatch_deadline = 12;</code>
     */
    public com.google.protobuf.DurationOrBuilder getDispatchDeadlineOrBuilder() {
      if (dispatchDeadlineBuilder_ != null) {
        return dispatchDeadlineBuilder_.getMessageOrBuilder();
      } else {
        return dispatchDeadline_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : dispatchDeadline_;
      }
    }
    /**
     *
     *
     * <pre>
     * The deadline for requests sent to the worker. If the worker does not
     * respond by this deadline then the request is cancelled and the attempt
     * is marked as a `DEADLINE_EXCEEDED` failure. Cloud Tasks will retry the
     * task according to the
     * [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig].
     * Note that when the request is cancelled, Cloud Tasks will stop listening
     * for the response, but whether the worker stops processing depends on the
     * worker. For example, if the worker is stuck, it may not react to cancelled
     * requests.
     * The default and maximum values depend on the type of request:
     * * For [HTTP tasks][google.cloud.tasks.v2beta3.HttpRequest], the default is
     * 10 minutes. The deadline
     *   must be in the interval [15 seconds, 30 minutes].
     * * For [App Engine tasks][google.cloud.tasks.v2beta3.AppEngineHttpRequest],
     * 0 indicates that the
     *   request has the default deadline. The default deadline depends on the
     *   [scaling
     *   type](https://cloud.google.com/appengine/docs/standard/go/how-instances-are-managed#instance_scaling)
     *   of the service: 10 minutes for standard apps with automatic scaling, 24
     *   hours for standard apps with manual and basic scaling, and 60 minutes for
     *   flex apps. If the request deadline is set, it must be in the interval [15
     *   seconds, 24 hours 15 seconds]. Regardless of the task's
     *   `dispatch_deadline`, the app handler will not run for longer than than
     *   the service's timeout. We recommend setting the `dispatch_deadline` to
     *   at most a few seconds more than the app handler's timeout. For more
     *   information see
     *   [Timeouts](https://cloud.google.com/tasks/docs/creating-appengine-handlers#timeouts).
     * `dispatch_deadline` will be truncated to the nearest millisecond. The
     * deadline is an approximate deadline.
     * </pre>
     *
     * <code>.google.protobuf.Duration dispatch_deadline = 12;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getDispatchDeadlineFieldBuilder() {
      if (dispatchDeadlineBuilder_ == null) {
        dispatchDeadlineBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getDispatchDeadline(), getParentForChildren(), isClean());
        dispatchDeadline_ = null;
      }
      return dispatchDeadlineBuilder_;
    }

    private int dispatchCount_;
    /**
     *
     *
     * <pre>
     * Output only. The number of attempts dispatched.
     * This count includes attempts which have been dispatched but haven't
     * received a response.
     * </pre>
     *
     * <code>int32 dispatch_count = 6;</code>
     *
     * @return The dispatchCount.
     */
    @java.lang.Override
    public int getDispatchCount() {
      return dispatchCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of attempts dispatched.
     * This count includes attempts which have been dispatched but haven't
     * received a response.
     * </pre>
     *
     * <code>int32 dispatch_count = 6;</code>
     *
     * @param value The dispatchCount to set.
     * @return This builder for chaining.
     */
    public Builder setDispatchCount(int value) {

      dispatchCount_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of attempts dispatched.
     * This count includes attempts which have been dispatched but haven't
     * received a response.
     * </pre>
     *
     * <code>int32 dispatch_count = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDispatchCount() {
      bitField0_ = (bitField0_ & ~0x00000080);
      dispatchCount_ = 0;
      onChanged();
      return this;
    }

    private int responseCount_;
    /**
     *
     *
     * <pre>
     * Output only. The number of attempts which have received a response.
     * </pre>
     *
     * <code>int32 response_count = 7;</code>
     *
     * @return The responseCount.
     */
    @java.lang.Override
    public int getResponseCount() {
      return responseCount_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of attempts which have received a response.
     * </pre>
     *
     * <code>int32 response_count = 7;</code>
     *
     * @param value The responseCount to set.
     * @return This builder for chaining.
     */
    public Builder setResponseCount(int value) {

      responseCount_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The number of attempts which have received a response.
     * </pre>
     *
     * <code>int32 response_count = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearResponseCount() {
      bitField0_ = (bitField0_ & ~0x00000100);
      responseCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.tasks.v2beta3.Attempt firstAttempt_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.Attempt,
            com.google.cloud.tasks.v2beta3.Attempt.Builder,
            com.google.cloud.tasks.v2beta3.AttemptOrBuilder>
        firstAttemptBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The status of the task's first attempt.
     * Only [dispatch_time][google.cloud.tasks.v2beta3.Attempt.dispatch_time] will
     * be set. The other [Attempt][google.cloud.tasks.v2beta3.Attempt] information
     * is not retained by Cloud Tasks.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Attempt first_attempt = 8;</code>
     *
     * @return Whether the firstAttempt field is set.
     */
    public boolean hasFirstAttempt() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of the task's first attempt.
     * Only [dispatch_time][google.cloud.tasks.v2beta3.Attempt.dispatch_time] will
     * be set. The other [Attempt][google.cloud.tasks.v2beta3.Attempt] information
     * is not retained by Cloud Tasks.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Attempt first_attempt = 8;</code>
     *
     * @return The firstAttempt.
     */
    public com.google.cloud.tasks.v2beta3.Attempt getFirstAttempt() {
      if (firstAttemptBuilder_ == null) {
        return firstAttempt_ == null
            ? com.google.cloud.tasks.v2beta3.Attempt.getDefaultInstance()
            : firstAttempt_;
      } else {
        return firstAttemptBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of the task's first attempt.
     * Only [dispatch_time][google.cloud.tasks.v2beta3.Attempt.dispatch_time] will
     * be set. The other [Attempt][google.cloud.tasks.v2beta3.Attempt] information
     * is not retained by Cloud Tasks.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Attempt first_attempt = 8;</code>
     */
    public Builder setFirstAttempt(com.google.cloud.tasks.v2beta3.Attempt value) {
      if (firstAttemptBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        firstAttempt_ = value;
      } else {
        firstAttemptBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of the task's first attempt.
     * Only [dispatch_time][google.cloud.tasks.v2beta3.Attempt.dispatch_time] will
     * be set. The other [Attempt][google.cloud.tasks.v2beta3.Attempt] information
     * is not retained by Cloud Tasks.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Attempt first_attempt = 8;</code>
     */
    public Builder setFirstAttempt(com.google.cloud.tasks.v2beta3.Attempt.Builder builderForValue) {
      if (firstAttemptBuilder_ == null) {
        firstAttempt_ = builderForValue.build();
      } else {
        firstAttemptBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of the task's first attempt.
     * Only [dispatch_time][google.cloud.tasks.v2beta3.Attempt.dispatch_time] will
     * be set. The other [Attempt][google.cloud.tasks.v2beta3.Attempt] information
     * is not retained by Cloud Tasks.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Attempt first_attempt = 8;</code>
     */
    public Builder mergeFirstAttempt(com.google.cloud.tasks.v2beta3.Attempt value) {
      if (firstAttemptBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && firstAttempt_ != null
            && firstAttempt_ != com.google.cloud.tasks.v2beta3.Attempt.getDefaultInstance()) {
          getFirstAttemptBuilder().mergeFrom(value);
        } else {
          firstAttempt_ = value;
        }
      } else {
        firstAttemptBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of the task's first attempt.
     * Only [dispatch_time][google.cloud.tasks.v2beta3.Attempt.dispatch_time] will
     * be set. The other [Attempt][google.cloud.tasks.v2beta3.Attempt] information
     * is not retained by Cloud Tasks.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Attempt first_attempt = 8;</code>
     */
    public Builder clearFirstAttempt() {
      bitField0_ = (bitField0_ & ~0x00000200);
      firstAttempt_ = null;
      if (firstAttemptBuilder_ != null) {
        firstAttemptBuilder_.dispose();
        firstAttemptBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of the task's first attempt.
     * Only [dispatch_time][google.cloud.tasks.v2beta3.Attempt.dispatch_time] will
     * be set. The other [Attempt][google.cloud.tasks.v2beta3.Attempt] information
     * is not retained by Cloud Tasks.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Attempt first_attempt = 8;</code>
     */
    public com.google.cloud.tasks.v2beta3.Attempt.Builder getFirstAttemptBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getFirstAttemptFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of the task's first attempt.
     * Only [dispatch_time][google.cloud.tasks.v2beta3.Attempt.dispatch_time] will
     * be set. The other [Attempt][google.cloud.tasks.v2beta3.Attempt] information
     * is not retained by Cloud Tasks.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Attempt first_attempt = 8;</code>
     */
    public com.google.cloud.tasks.v2beta3.AttemptOrBuilder getFirstAttemptOrBuilder() {
      if (firstAttemptBuilder_ != null) {
        return firstAttemptBuilder_.getMessageOrBuilder();
      } else {
        return firstAttempt_ == null
            ? com.google.cloud.tasks.v2beta3.Attempt.getDefaultInstance()
            : firstAttempt_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of the task's first attempt.
     * Only [dispatch_time][google.cloud.tasks.v2beta3.Attempt.dispatch_time] will
     * be set. The other [Attempt][google.cloud.tasks.v2beta3.Attempt] information
     * is not retained by Cloud Tasks.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Attempt first_attempt = 8;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.Attempt,
            com.google.cloud.tasks.v2beta3.Attempt.Builder,
            com.google.cloud.tasks.v2beta3.AttemptOrBuilder>
        getFirstAttemptFieldBuilder() {
      if (firstAttemptBuilder_ == null) {
        firstAttemptBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2beta3.Attempt,
                com.google.cloud.tasks.v2beta3.Attempt.Builder,
                com.google.cloud.tasks.v2beta3.AttemptOrBuilder>(
                getFirstAttempt(), getParentForChildren(), isClean());
        firstAttempt_ = null;
      }
      return firstAttemptBuilder_;
    }

    private com.google.cloud.tasks.v2beta3.Attempt lastAttempt_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.Attempt,
            com.google.cloud.tasks.v2beta3.Attempt.Builder,
            com.google.cloud.tasks.v2beta3.AttemptOrBuilder>
        lastAttemptBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The status of the task's last attempt.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Attempt last_attempt = 9;</code>
     *
     * @return Whether the lastAttempt field is set.
     */
    public boolean hasLastAttempt() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of the task's last attempt.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Attempt last_attempt = 9;</code>
     *
     * @return The lastAttempt.
     */
    public com.google.cloud.tasks.v2beta3.Attempt getLastAttempt() {
      if (lastAttemptBuilder_ == null) {
        return lastAttempt_ == null
            ? com.google.cloud.tasks.v2beta3.Attempt.getDefaultInstance()
            : lastAttempt_;
      } else {
        return lastAttemptBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of the task's last attempt.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Attempt last_attempt = 9;</code>
     */
    public Builder setLastAttempt(com.google.cloud.tasks.v2beta3.Attempt value) {
      if (lastAttemptBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        lastAttempt_ = value;
      } else {
        lastAttemptBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of the task's last attempt.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Attempt last_attempt = 9;</code>
     */
    public Builder setLastAttempt(com.google.cloud.tasks.v2beta3.Attempt.Builder builderForValue) {
      if (lastAttemptBuilder_ == null) {
        lastAttempt_ = builderForValue.build();
      } else {
        lastAttemptBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of the task's last attempt.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Attempt last_attempt = 9;</code>
     */
    public Builder mergeLastAttempt(com.google.cloud.tasks.v2beta3.Attempt value) {
      if (lastAttemptBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && lastAttempt_ != null
            && lastAttempt_ != com.google.cloud.tasks.v2beta3.Attempt.getDefaultInstance()) {
          getLastAttemptBuilder().mergeFrom(value);
        } else {
          lastAttempt_ = value;
        }
      } else {
        lastAttemptBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of the task's last attempt.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Attempt last_attempt = 9;</code>
     */
    public Builder clearLastAttempt() {
      bitField0_ = (bitField0_ & ~0x00000400);
      lastAttempt_ = null;
      if (lastAttemptBuilder_ != null) {
        lastAttemptBuilder_.dispose();
        lastAttemptBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of the task's last attempt.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Attempt last_attempt = 9;</code>
     */
    public com.google.cloud.tasks.v2beta3.Attempt.Builder getLastAttemptBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getLastAttemptFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of the task's last attempt.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Attempt last_attempt = 9;</code>
     */
    public com.google.cloud.tasks.v2beta3.AttemptOrBuilder getLastAttemptOrBuilder() {
      if (lastAttemptBuilder_ != null) {
        return lastAttemptBuilder_.getMessageOrBuilder();
      } else {
        return lastAttempt_ == null
            ? com.google.cloud.tasks.v2beta3.Attempt.getDefaultInstance()
            : lastAttempt_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The status of the task's last attempt.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Attempt last_attempt = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.Attempt,
            com.google.cloud.tasks.v2beta3.Attempt.Builder,
            com.google.cloud.tasks.v2beta3.AttemptOrBuilder>
        getLastAttemptFieldBuilder() {
      if (lastAttemptBuilder_ == null) {
        lastAttemptBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2beta3.Attempt,
                com.google.cloud.tasks.v2beta3.Attempt.Builder,
                com.google.cloud.tasks.v2beta3.AttemptOrBuilder>(
                getLastAttempt(), getParentForChildren(), isClean());
        lastAttempt_ = null;
      }
      return lastAttemptBuilder_;
    }

    private int view_ = 0;
    /**
     *
     *
     * <pre>
     * Output only. The view specifies which subset of the
     * [Task][google.cloud.tasks.v2beta3.Task] has been returned.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Task.View view = 10;</code>
     *
     * @return The enum numeric value on the wire for view.
     */
    @java.lang.Override
    public int getViewValue() {
      return view_;
    }
    /**
     *
     *
     * <pre>
     * Output only. The view specifies which subset of the
     * [Task][google.cloud.tasks.v2beta3.Task] has been returned.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Task.View view = 10;</code>
     *
     * @param value The enum numeric value on the wire for view to set.
     * @return This builder for chaining.
     */
    public Builder setViewValue(int value) {
      view_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The view specifies which subset of the
     * [Task][google.cloud.tasks.v2beta3.Task] has been returned.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Task.View view = 10;</code>
     *
     * @return The view.
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.Task.View getView() {
      com.google.cloud.tasks.v2beta3.Task.View result =
          com.google.cloud.tasks.v2beta3.Task.View.forNumber(view_);
      return result == null ? com.google.cloud.tasks.v2beta3.Task.View.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Output only. The view specifies which subset of the
     * [Task][google.cloud.tasks.v2beta3.Task] has been returned.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Task.View view = 10;</code>
     *
     * @param value The view to set.
     * @return This builder for chaining.
     */
    public Builder setView(com.google.cloud.tasks.v2beta3.Task.View value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      view_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The view specifies which subset of the
     * [Task][google.cloud.tasks.v2beta3.Task] has been returned.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.Task.View view = 10;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearView() {
      bitField0_ = (bitField0_ & ~0x00000800);
      view_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.tasks.v2beta3.Task)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.tasks.v2beta3.Task)
  private static final com.google.cloud.tasks.v2beta3.Task DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.tasks.v2beta3.Task();
  }

  public static com.google.cloud.tasks.v2beta3.Task getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Task> PARSER =
      new com.google.protobuf.AbstractParser<Task>() {
        @java.lang.Override
        public Task parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Task> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Task> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.Task getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
