/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/tasks/v2beta3/task.proto

package com.google.cloud.tasks.v2beta3;

/**
 *
 *
 * <pre>
 * The status of a task attempt.
 * </pre>
 *
 * Protobuf type {@code google.cloud.tasks.v2beta3.Attempt}
 */
public final class Attempt extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.tasks.v2beta3.Attempt)
    AttemptOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use Attempt.newBuilder() to construct.
  private Attempt(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Attempt() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Attempt();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.tasks.v2beta3.TaskProto
        .internal_static_google_cloud_tasks_v2beta3_Attempt_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.tasks.v2beta3.TaskProto
        .internal_static_google_cloud_tasks_v2beta3_Attempt_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.tasks.v2beta3.Attempt.class,
            com.google.cloud.tasks.v2beta3.Attempt.Builder.class);
  }

  public static final int SCHEDULE_TIME_FIELD_NUMBER = 1;
  private com.google.protobuf.Timestamp scheduleTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time that this attempt was scheduled.
   *
   * `schedule_time` will be truncated to the nearest microsecond.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
   *
   * @return Whether the scheduleTime field is set.
   */
  @java.lang.Override
  public boolean hasScheduleTime() {
    return scheduleTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time that this attempt was scheduled.
   *
   * `schedule_time` will be truncated to the nearest microsecond.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
   *
   * @return The scheduleTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getScheduleTime() {
    return scheduleTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : scheduleTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time that this attempt was scheduled.
   *
   * `schedule_time` will be truncated to the nearest microsecond.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getScheduleTimeOrBuilder() {
    return scheduleTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : scheduleTime_;
  }

  public static final int DISPATCH_TIME_FIELD_NUMBER = 2;
  private com.google.protobuf.Timestamp dispatchTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time that this attempt was dispatched.
   *
   * `dispatch_time` will be truncated to the nearest microsecond.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp dispatch_time = 2;</code>
   *
   * @return Whether the dispatchTime field is set.
   */
  @java.lang.Override
  public boolean hasDispatchTime() {
    return dispatchTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time that this attempt was dispatched.
   *
   * `dispatch_time` will be truncated to the nearest microsecond.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp dispatch_time = 2;</code>
   *
   * @return The dispatchTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getDispatchTime() {
    return dispatchTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : dispatchTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time that this attempt was dispatched.
   *
   * `dispatch_time` will be truncated to the nearest microsecond.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp dispatch_time = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getDispatchTimeOrBuilder() {
    return dispatchTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : dispatchTime_;
  }

  public static final int RESPONSE_TIME_FIELD_NUMBER = 3;
  private com.google.protobuf.Timestamp responseTime_;
  /**
   *
   *
   * <pre>
   * Output only. The time that this attempt response was received.
   *
   * `response_time` will be truncated to the nearest microsecond.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp response_time = 3;</code>
   *
   * @return Whether the responseTime field is set.
   */
  @java.lang.Override
  public boolean hasResponseTime() {
    return responseTime_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time that this attempt response was received.
   *
   * `response_time` will be truncated to the nearest microsecond.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp response_time = 3;</code>
   *
   * @return The responseTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getResponseTime() {
    return responseTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : responseTime_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The time that this attempt response was received.
   *
   * `response_time` will be truncated to the nearest microsecond.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp response_time = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getResponseTimeOrBuilder() {
    return responseTime_ == null
        ? com.google.protobuf.Timestamp.getDefaultInstance()
        : responseTime_;
  }

  public static final int RESPONSE_STATUS_FIELD_NUMBER = 4;
  private com.google.rpc.Status responseStatus_;
  /**
   *
   *
   * <pre>
   * Output only. The response from the worker for this attempt.
   *
   * If `response_time` is unset, then the task has not been attempted or is
   * currently running and the `response_status` field is meaningless.
   * </pre>
   *
   * <code>.google.rpc.Status response_status = 4;</code>
   *
   * @return Whether the responseStatus field is set.
   */
  @java.lang.Override
  public boolean hasResponseStatus() {
    return responseStatus_ != null;
  }
  /**
   *
   *
   * <pre>
   * Output only. The response from the worker for this attempt.
   *
   * If `response_time` is unset, then the task has not been attempted or is
   * currently running and the `response_status` field is meaningless.
   * </pre>
   *
   * <code>.google.rpc.Status response_status = 4;</code>
   *
   * @return The responseStatus.
   */
  @java.lang.Override
  public com.google.rpc.Status getResponseStatus() {
    return responseStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : responseStatus_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The response from the worker for this attempt.
   *
   * If `response_time` is unset, then the task has not been attempted or is
   * currently running and the `response_status` field is meaningless.
   * </pre>
   *
   * <code>.google.rpc.Status response_status = 4;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getResponseStatusOrBuilder() {
    return responseStatus_ == null ? com.google.rpc.Status.getDefaultInstance() : responseStatus_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (scheduleTime_ != null) {
      output.writeMessage(1, getScheduleTime());
    }
    if (dispatchTime_ != null) {
      output.writeMessage(2, getDispatchTime());
    }
    if (responseTime_ != null) {
      output.writeMessage(3, getResponseTime());
    }
    if (responseStatus_ != null) {
      output.writeMessage(4, getResponseStatus());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (scheduleTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getScheduleTime());
    }
    if (dispatchTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getDispatchTime());
    }
    if (responseTime_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getResponseTime());
    }
    if (responseStatus_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getResponseStatus());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.tasks.v2beta3.Attempt)) {
      return super.equals(obj);
    }
    com.google.cloud.tasks.v2beta3.Attempt other = (com.google.cloud.tasks.v2beta3.Attempt) obj;

    if (hasScheduleTime() != other.hasScheduleTime()) return false;
    if (hasScheduleTime()) {
      if (!getScheduleTime().equals(other.getScheduleTime())) return false;
    }
    if (hasDispatchTime() != other.hasDispatchTime()) return false;
    if (hasDispatchTime()) {
      if (!getDispatchTime().equals(other.getDispatchTime())) return false;
    }
    if (hasResponseTime() != other.hasResponseTime()) return false;
    if (hasResponseTime()) {
      if (!getResponseTime().equals(other.getResponseTime())) return false;
    }
    if (hasResponseStatus() != other.hasResponseStatus()) return false;
    if (hasResponseStatus()) {
      if (!getResponseStatus().equals(other.getResponseStatus())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasScheduleTime()) {
      hash = (37 * hash) + SCHEDULE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getScheduleTime().hashCode();
    }
    if (hasDispatchTime()) {
      hash = (37 * hash) + DISPATCH_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getDispatchTime().hashCode();
    }
    if (hasResponseTime()) {
      hash = (37 * hash) + RESPONSE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getResponseTime().hashCode();
    }
    if (hasResponseStatus()) {
      hash = (37 * hash) + RESPONSE_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getResponseStatus().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.tasks.v2beta3.Attempt parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.Attempt parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.Attempt parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.Attempt parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.Attempt parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.Attempt parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.Attempt parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.Attempt parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.Attempt parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.Attempt parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.Attempt parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.Attempt parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.tasks.v2beta3.Attempt prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The status of a task attempt.
   * </pre>
   *
   * Protobuf type {@code google.cloud.tasks.v2beta3.Attempt}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.tasks.v2beta3.Attempt)
      com.google.cloud.tasks.v2beta3.AttemptOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.tasks.v2beta3.TaskProto
          .internal_static_google_cloud_tasks_v2beta3_Attempt_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.tasks.v2beta3.TaskProto
          .internal_static_google_cloud_tasks_v2beta3_Attempt_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.tasks.v2beta3.Attempt.class,
              com.google.cloud.tasks.v2beta3.Attempt.Builder.class);
    }

    // Construct using com.google.cloud.tasks.v2beta3.Attempt.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      scheduleTime_ = null;
      if (scheduleTimeBuilder_ != null) {
        scheduleTimeBuilder_.dispose();
        scheduleTimeBuilder_ = null;
      }
      dispatchTime_ = null;
      if (dispatchTimeBuilder_ != null) {
        dispatchTimeBuilder_.dispose();
        dispatchTimeBuilder_ = null;
      }
      responseTime_ = null;
      if (responseTimeBuilder_ != null) {
        responseTimeBuilder_.dispose();
        responseTimeBuilder_ = null;
      }
      responseStatus_ = null;
      if (responseStatusBuilder_ != null) {
        responseStatusBuilder_.dispose();
        responseStatusBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.tasks.v2beta3.TaskProto
          .internal_static_google_cloud_tasks_v2beta3_Attempt_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.Attempt getDefaultInstanceForType() {
      return com.google.cloud.tasks.v2beta3.Attempt.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.Attempt build() {
      com.google.cloud.tasks.v2beta3.Attempt result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.Attempt buildPartial() {
      com.google.cloud.tasks.v2beta3.Attempt result =
          new com.google.cloud.tasks.v2beta3.Attempt(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.tasks.v2beta3.Attempt result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.scheduleTime_ =
            scheduleTimeBuilder_ == null ? scheduleTime_ : scheduleTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.dispatchTime_ =
            dispatchTimeBuilder_ == null ? dispatchTime_ : dispatchTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.responseTime_ =
            responseTimeBuilder_ == null ? responseTime_ : responseTimeBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.responseStatus_ =
            responseStatusBuilder_ == null ? responseStatus_ : responseStatusBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.tasks.v2beta3.Attempt) {
        return mergeFrom((com.google.cloud.tasks.v2beta3.Attempt) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.tasks.v2beta3.Attempt other) {
      if (other == com.google.cloud.tasks.v2beta3.Attempt.getDefaultInstance()) return this;
      if (other.hasScheduleTime()) {
        mergeScheduleTime(other.getScheduleTime());
      }
      if (other.hasDispatchTime()) {
        mergeDispatchTime(other.getDispatchTime());
      }
      if (other.hasResponseTime()) {
        mergeResponseTime(other.getResponseTime());
      }
      if (other.hasResponseStatus()) {
        mergeResponseStatus(other.getResponseStatus());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getScheduleTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getDispatchTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getResponseTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getResponseStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.Timestamp scheduleTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        scheduleTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt was scheduled.
     *
     * `schedule_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
     *
     * @return Whether the scheduleTime field is set.
     */
    public boolean hasScheduleTime() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt was scheduled.
     *
     * `schedule_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
     *
     * @return The scheduleTime.
     */
    public com.google.protobuf.Timestamp getScheduleTime() {
      if (scheduleTimeBuilder_ == null) {
        return scheduleTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : scheduleTime_;
      } else {
        return scheduleTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt was scheduled.
     *
     * `schedule_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
     */
    public Builder setScheduleTime(com.google.protobuf.Timestamp value) {
      if (scheduleTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        scheduleTime_ = value;
      } else {
        scheduleTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt was scheduled.
     *
     * `schedule_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
     */
    public Builder setScheduleTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (scheduleTimeBuilder_ == null) {
        scheduleTime_ = builderForValue.build();
      } else {
        scheduleTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt was scheduled.
     *
     * `schedule_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
     */
    public Builder mergeScheduleTime(com.google.protobuf.Timestamp value) {
      if (scheduleTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && scheduleTime_ != null
            && scheduleTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getScheduleTimeBuilder().mergeFrom(value);
        } else {
          scheduleTime_ = value;
        }
      } else {
        scheduleTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt was scheduled.
     *
     * `schedule_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
     */
    public Builder clearScheduleTime() {
      bitField0_ = (bitField0_ & ~0x00000001);
      scheduleTime_ = null;
      if (scheduleTimeBuilder_ != null) {
        scheduleTimeBuilder_.dispose();
        scheduleTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt was scheduled.
     *
     * `schedule_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
     */
    public com.google.protobuf.Timestamp.Builder getScheduleTimeBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getScheduleTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt was scheduled.
     *
     * `schedule_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getScheduleTimeOrBuilder() {
      if (scheduleTimeBuilder_ != null) {
        return scheduleTimeBuilder_.getMessageOrBuilder();
      } else {
        return scheduleTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : scheduleTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt was scheduled.
     *
     * `schedule_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp schedule_time = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getScheduleTimeFieldBuilder() {
      if (scheduleTimeBuilder_ == null) {
        scheduleTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getScheduleTime(), getParentForChildren(), isClean());
        scheduleTime_ = null;
      }
      return scheduleTimeBuilder_;
    }

    private com.google.protobuf.Timestamp dispatchTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        dispatchTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt was dispatched.
     *
     * `dispatch_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp dispatch_time = 2;</code>
     *
     * @return Whether the dispatchTime field is set.
     */
    public boolean hasDispatchTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt was dispatched.
     *
     * `dispatch_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp dispatch_time = 2;</code>
     *
     * @return The dispatchTime.
     */
    public com.google.protobuf.Timestamp getDispatchTime() {
      if (dispatchTimeBuilder_ == null) {
        return dispatchTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : dispatchTime_;
      } else {
        return dispatchTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt was dispatched.
     *
     * `dispatch_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp dispatch_time = 2;</code>
     */
    public Builder setDispatchTime(com.google.protobuf.Timestamp value) {
      if (dispatchTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        dispatchTime_ = value;
      } else {
        dispatchTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt was dispatched.
     *
     * `dispatch_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp dispatch_time = 2;</code>
     */
    public Builder setDispatchTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (dispatchTimeBuilder_ == null) {
        dispatchTime_ = builderForValue.build();
      } else {
        dispatchTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt was dispatched.
     *
     * `dispatch_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp dispatch_time = 2;</code>
     */
    public Builder mergeDispatchTime(com.google.protobuf.Timestamp value) {
      if (dispatchTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && dispatchTime_ != null
            && dispatchTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getDispatchTimeBuilder().mergeFrom(value);
        } else {
          dispatchTime_ = value;
        }
      } else {
        dispatchTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt was dispatched.
     *
     * `dispatch_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp dispatch_time = 2;</code>
     */
    public Builder clearDispatchTime() {
      bitField0_ = (bitField0_ & ~0x00000002);
      dispatchTime_ = null;
      if (dispatchTimeBuilder_ != null) {
        dispatchTimeBuilder_.dispose();
        dispatchTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt was dispatched.
     *
     * `dispatch_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp dispatch_time = 2;</code>
     */
    public com.google.protobuf.Timestamp.Builder getDispatchTimeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getDispatchTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt was dispatched.
     *
     * `dispatch_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp dispatch_time = 2;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getDispatchTimeOrBuilder() {
      if (dispatchTimeBuilder_ != null) {
        return dispatchTimeBuilder_.getMessageOrBuilder();
      } else {
        return dispatchTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : dispatchTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt was dispatched.
     *
     * `dispatch_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp dispatch_time = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getDispatchTimeFieldBuilder() {
      if (dispatchTimeBuilder_ == null) {
        dispatchTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getDispatchTime(), getParentForChildren(), isClean());
        dispatchTime_ = null;
      }
      return dispatchTimeBuilder_;
    }

    private com.google.protobuf.Timestamp responseTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        responseTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt response was received.
     *
     * `response_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp response_time = 3;</code>
     *
     * @return Whether the responseTime field is set.
     */
    public boolean hasResponseTime() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt response was received.
     *
     * `response_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp response_time = 3;</code>
     *
     * @return The responseTime.
     */
    public com.google.protobuf.Timestamp getResponseTime() {
      if (responseTimeBuilder_ == null) {
        return responseTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : responseTime_;
      } else {
        return responseTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt response was received.
     *
     * `response_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp response_time = 3;</code>
     */
    public Builder setResponseTime(com.google.protobuf.Timestamp value) {
      if (responseTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        responseTime_ = value;
      } else {
        responseTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt response was received.
     *
     * `response_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp response_time = 3;</code>
     */
    public Builder setResponseTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (responseTimeBuilder_ == null) {
        responseTime_ = builderForValue.build();
      } else {
        responseTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt response was received.
     *
     * `response_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp response_time = 3;</code>
     */
    public Builder mergeResponseTime(com.google.protobuf.Timestamp value) {
      if (responseTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && responseTime_ != null
            && responseTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getResponseTimeBuilder().mergeFrom(value);
        } else {
          responseTime_ = value;
        }
      } else {
        responseTimeBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt response was received.
     *
     * `response_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp response_time = 3;</code>
     */
    public Builder clearResponseTime() {
      bitField0_ = (bitField0_ & ~0x00000004);
      responseTime_ = null;
      if (responseTimeBuilder_ != null) {
        responseTimeBuilder_.dispose();
        responseTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt response was received.
     *
     * `response_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp response_time = 3;</code>
     */
    public com.google.protobuf.Timestamp.Builder getResponseTimeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getResponseTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt response was received.
     *
     * `response_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp response_time = 3;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getResponseTimeOrBuilder() {
      if (responseTimeBuilder_ != null) {
        return responseTimeBuilder_.getMessageOrBuilder();
      } else {
        return responseTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : responseTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The time that this attempt response was received.
     *
     * `response_time` will be truncated to the nearest microsecond.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp response_time = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getResponseTimeFieldBuilder() {
      if (responseTimeBuilder_ == null) {
        responseTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getResponseTime(), getParentForChildren(), isClean());
        responseTime_ = null;
      }
      return responseTimeBuilder_;
    }

    private com.google.rpc.Status responseStatus_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        responseStatusBuilder_;
    /**
     *
     *
     * <pre>
     * Output only. The response from the worker for this attempt.
     *
     * If `response_time` is unset, then the task has not been attempted or is
     * currently running and the `response_status` field is meaningless.
     * </pre>
     *
     * <code>.google.rpc.Status response_status = 4;</code>
     *
     * @return Whether the responseStatus field is set.
     */
    public boolean hasResponseStatus() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Output only. The response from the worker for this attempt.
     *
     * If `response_time` is unset, then the task has not been attempted or is
     * currently running and the `response_status` field is meaningless.
     * </pre>
     *
     * <code>.google.rpc.Status response_status = 4;</code>
     *
     * @return The responseStatus.
     */
    public com.google.rpc.Status getResponseStatus() {
      if (responseStatusBuilder_ == null) {
        return responseStatus_ == null
            ? com.google.rpc.Status.getDefaultInstance()
            : responseStatus_;
      } else {
        return responseStatusBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The response from the worker for this attempt.
     *
     * If `response_time` is unset, then the task has not been attempted or is
     * currently running and the `response_status` field is meaningless.
     * </pre>
     *
     * <code>.google.rpc.Status response_status = 4;</code>
     */
    public Builder setResponseStatus(com.google.rpc.Status value) {
      if (responseStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        responseStatus_ = value;
      } else {
        responseStatusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The response from the worker for this attempt.
     *
     * If `response_time` is unset, then the task has not been attempted or is
     * currently running and the `response_status` field is meaningless.
     * </pre>
     *
     * <code>.google.rpc.Status response_status = 4;</code>
     */
    public Builder setResponseStatus(com.google.rpc.Status.Builder builderForValue) {
      if (responseStatusBuilder_ == null) {
        responseStatus_ = builderForValue.build();
      } else {
        responseStatusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The response from the worker for this attempt.
     *
     * If `response_time` is unset, then the task has not been attempted or is
     * currently running and the `response_status` field is meaningless.
     * </pre>
     *
     * <code>.google.rpc.Status response_status = 4;</code>
     */
    public Builder mergeResponseStatus(com.google.rpc.Status value) {
      if (responseStatusBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && responseStatus_ != null
            && responseStatus_ != com.google.rpc.Status.getDefaultInstance()) {
          getResponseStatusBuilder().mergeFrom(value);
        } else {
          responseStatus_ = value;
        }
      } else {
        responseStatusBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The response from the worker for this attempt.
     *
     * If `response_time` is unset, then the task has not been attempted or is
     * currently running and the `response_status` field is meaningless.
     * </pre>
     *
     * <code>.google.rpc.Status response_status = 4;</code>
     */
    public Builder clearResponseStatus() {
      bitField0_ = (bitField0_ & ~0x00000008);
      responseStatus_ = null;
      if (responseStatusBuilder_ != null) {
        responseStatusBuilder_.dispose();
        responseStatusBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The response from the worker for this attempt.
     *
     * If `response_time` is unset, then the task has not been attempted or is
     * currently running and the `response_status` field is meaningless.
     * </pre>
     *
     * <code>.google.rpc.Status response_status = 4;</code>
     */
    public com.google.rpc.Status.Builder getResponseStatusBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getResponseStatusFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Output only. The response from the worker for this attempt.
     *
     * If `response_time` is unset, then the task has not been attempted or is
     * currently running and the `response_status` field is meaningless.
     * </pre>
     *
     * <code>.google.rpc.Status response_status = 4;</code>
     */
    public com.google.rpc.StatusOrBuilder getResponseStatusOrBuilder() {
      if (responseStatusBuilder_ != null) {
        return responseStatusBuilder_.getMessageOrBuilder();
      } else {
        return responseStatus_ == null
            ? com.google.rpc.Status.getDefaultInstance()
            : responseStatus_;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The response from the worker for this attempt.
     *
     * If `response_time` is unset, then the task has not been attempted or is
     * currently running and the `response_status` field is meaningless.
     * </pre>
     *
     * <code>.google.rpc.Status response_status = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getResponseStatusFieldBuilder() {
      if (responseStatusBuilder_ == null) {
        responseStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                getResponseStatus(), getParentForChildren(), isClean());
        responseStatus_ = null;
      }
      return responseStatusBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.tasks.v2beta3.Attempt)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.tasks.v2beta3.Attempt)
  private static final com.google.cloud.tasks.v2beta3.Attempt DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.tasks.v2beta3.Attempt();
  }

  public static com.google.cloud.tasks.v2beta3.Attempt getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Attempt> PARSER =
      new com.google.protobuf.AbstractParser<Attempt>() {
        @java.lang.Override
        public Attempt parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Attempt> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Attempt> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.Attempt getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
