/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/tasks/v2beta3/target.proto

package com.google.cloud.tasks.v2beta3;

/**
 *
 *
 * <pre>
 * App Engine HTTP request.
 *
 * The message defines the HTTP request that is sent to an App Engine app when
 * the task is dispatched.
 *
 * Using [AppEngineHttpRequest][google.cloud.tasks.v2beta3.AppEngineHttpRequest]
 * requires
 * [`appengine.applications.get`](https://cloud.google.com/appengine/docs/admin-api/access-control)
 * Google IAM permission for the project
 * and the following scope:
 *
 * `https://www.googleapis.com/auth/cloud-platform`
 *
 * The task will be delivered to the App Engine app which belongs to the same
 * project as the queue. For more information, see
 * [How Requests are
 * Routed](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed)
 * and how routing is affected by
 * [dispatch
 * files](https://cloud.google.com/appengine/docs/python/config/dispatchref).
 * Traffic is encrypted during transport and never leaves Google datacenters.
 * Because this traffic is carried over a communication mechanism internal to
 * Google, you cannot explicitly set the protocol (for example, HTTP or HTTPS).
 * The request to the handler, however, will appear to have used the HTTP
 * protocol.
 *
 * The [AppEngineRouting][google.cloud.tasks.v2beta3.AppEngineRouting] used to
 * construct the URL that the task is delivered to can be set at the queue-level
 * or task-level:
 *
 * * If set,
 *   [app_engine_routing_override][google.cloud.tasks.v2beta3.AppEngineHttpQueue.app_engine_routing_override]
 *   is used for all tasks in the queue, no matter what the setting
 *   is for the
 *   [task-level
 *   app_engine_routing][google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing].
 *
 *
 * The `url` that the task will be sent to is:
 *
 * * `url =` [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] `+`
 *   [relative_uri][google.cloud.tasks.v2beta3.AppEngineHttpRequest.relative_uri]
 *
 * Tasks can be dispatched to secure app handlers, unsecure app handlers, and
 * URIs restricted with
 * [`login:
 * admin`](https://cloud.google.com/appengine/docs/standard/python/config/appref).
 * Because tasks are not run as any user, they cannot be dispatched to URIs
 * restricted with
 * [`login:
 * required`](https://cloud.google.com/appengine/docs/standard/python/config/appref)
 * Task dispatches also do not follow redirects.
 *
 * The task attempt has succeeded if the app's request handler returns an HTTP
 * response code in the range [`200` - `299`]. The task attempt has failed if
 * the app's handler returns a non-2xx response code or Cloud Tasks does
 * not receive response before the
 * [deadline][google.cloud.tasks.v2beta3.Task.dispatch_deadline]. Failed tasks
 * will be retried according to the [retry
 * configuration][google.cloud.tasks.v2beta3.Queue.retry_config]. `503` (Service
 * Unavailable) is considered an App Engine system error instead of an
 * application error and will cause Cloud Tasks' traffic congestion control to
 * temporarily throttle the queue's dispatches. Unlike other types of task
 * targets, a `429` (Too Many Requests) response from an app handler does not
 * cause traffic congestion control to throttle the queue.
 * </pre>
 *
 * Protobuf type {@code google.cloud.tasks.v2beta3.AppEngineHttpRequest}
 */
public final class AppEngineHttpRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.tasks.v2beta3.AppEngineHttpRequest)
    AppEngineHttpRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AppEngineHttpRequest.newBuilder() to construct.
  private AppEngineHttpRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AppEngineHttpRequest() {
    httpMethod_ = 0;
    relativeUri_ = "";
    body_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AppEngineHttpRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.tasks.v2beta3.TargetProto
        .internal_static_google_cloud_tasks_v2beta3_AppEngineHttpRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 4:
        return internalGetHeaders();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.tasks.v2beta3.TargetProto
        .internal_static_google_cloud_tasks_v2beta3_AppEngineHttpRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.tasks.v2beta3.AppEngineHttpRequest.class,
            com.google.cloud.tasks.v2beta3.AppEngineHttpRequest.Builder.class);
  }

  public static final int HTTP_METHOD_FIELD_NUMBER = 1;
  private int httpMethod_ = 0;
  /**
   *
   *
   * <pre>
   * The HTTP method to use for the request. The default is POST.
   *
   * The app's request handler for the task's target URL must be able to handle
   * HTTP requests with this http_method, otherwise the task attempt fails with
   * error code 405 (Method Not Allowed). See [Writing a push task request
   * handler](https://cloud.google.com/appengine/docs/java/taskqueue/push/creating-handlers#writing_a_push_task_request_handler)
   * and the App Engine documentation for your runtime on [How Requests are
   * Handled](https://cloud.google.com/appengine/docs/standard/python3/how-requests-are-handled).
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.HttpMethod http_method = 1;</code>
   *
   * @return The enum numeric value on the wire for httpMethod.
   */
  @java.lang.Override
  public int getHttpMethodValue() {
    return httpMethod_;
  }
  /**
   *
   *
   * <pre>
   * The HTTP method to use for the request. The default is POST.
   *
   * The app's request handler for the task's target URL must be able to handle
   * HTTP requests with this http_method, otherwise the task attempt fails with
   * error code 405 (Method Not Allowed). See [Writing a push task request
   * handler](https://cloud.google.com/appengine/docs/java/taskqueue/push/creating-handlers#writing_a_push_task_request_handler)
   * and the App Engine documentation for your runtime on [How Requests are
   * Handled](https://cloud.google.com/appengine/docs/standard/python3/how-requests-are-handled).
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.HttpMethod http_method = 1;</code>
   *
   * @return The httpMethod.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.HttpMethod getHttpMethod() {
    com.google.cloud.tasks.v2beta3.HttpMethod result =
        com.google.cloud.tasks.v2beta3.HttpMethod.forNumber(httpMethod_);
    return result == null ? com.google.cloud.tasks.v2beta3.HttpMethod.UNRECOGNIZED : result;
  }

  public static final int APP_ENGINE_ROUTING_FIELD_NUMBER = 2;
  private com.google.cloud.tasks.v2beta3.AppEngineRouting appEngineRouting_;
  /**
   *
   *
   * <pre>
   * Task-level setting for App Engine routing.
   *
   * If set,
   * [app_engine_routing_override][google.cloud.tasks.v2beta3.AppEngineHttpQueue.app_engine_routing_override]
   * is used for all tasks in the queue, no matter what the setting is for the
   * [task-level
   * app_engine_routing][google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing].
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.AppEngineRouting app_engine_routing = 2;</code>
   *
   * @return Whether the appEngineRouting field is set.
   */
  @java.lang.Override
  public boolean hasAppEngineRouting() {
    return appEngineRouting_ != null;
  }
  /**
   *
   *
   * <pre>
   * Task-level setting for App Engine routing.
   *
   * If set,
   * [app_engine_routing_override][google.cloud.tasks.v2beta3.AppEngineHttpQueue.app_engine_routing_override]
   * is used for all tasks in the queue, no matter what the setting is for the
   * [task-level
   * app_engine_routing][google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing].
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.AppEngineRouting app_engine_routing = 2;</code>
   *
   * @return The appEngineRouting.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.AppEngineRouting getAppEngineRouting() {
    return appEngineRouting_ == null
        ? com.google.cloud.tasks.v2beta3.AppEngineRouting.getDefaultInstance()
        : appEngineRouting_;
  }
  /**
   *
   *
   * <pre>
   * Task-level setting for App Engine routing.
   *
   * If set,
   * [app_engine_routing_override][google.cloud.tasks.v2beta3.AppEngineHttpQueue.app_engine_routing_override]
   * is used for all tasks in the queue, no matter what the setting is for the
   * [task-level
   * app_engine_routing][google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing].
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.AppEngineRouting app_engine_routing = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.AppEngineRoutingOrBuilder getAppEngineRoutingOrBuilder() {
    return appEngineRouting_ == null
        ? com.google.cloud.tasks.v2beta3.AppEngineRouting.getDefaultInstance()
        : appEngineRouting_;
  }

  public static final int RELATIVE_URI_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object relativeUri_ = "";
  /**
   *
   *
   * <pre>
   * The relative URI.
   *
   * The relative URI must begin with "/" and must be a valid HTTP relative URI.
   * It can contain a path and query string arguments.
   * If the relative URI is empty, then the root path "/" will be used.
   * No spaces are allowed, and the maximum length allowed is 2083 characters.
   * </pre>
   *
   * <code>string relative_uri = 3;</code>
   *
   * @return The relativeUri.
   */
  @java.lang.Override
  public java.lang.String getRelativeUri() {
    java.lang.Object ref = relativeUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      relativeUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The relative URI.
   *
   * The relative URI must begin with "/" and must be a valid HTTP relative URI.
   * It can contain a path and query string arguments.
   * If the relative URI is empty, then the root path "/" will be used.
   * No spaces are allowed, and the maximum length allowed is 2083 characters.
   * </pre>
   *
   * <code>string relative_uri = 3;</code>
   *
   * @return The bytes for relativeUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getRelativeUriBytes() {
    java.lang.Object ref = relativeUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      relativeUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HEADERS_FIELD_NUMBER = 4;

  private static final class HeadersDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.tasks.v2beta3.TargetProto
                .internal_static_google_cloud_tasks_v2beta3_AppEngineHttpRequest_HeadersEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> headers_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetHeaders() {
    if (headers_ == null) {
      return com.google.protobuf.MapField.emptyMapField(HeadersDefaultEntryHolder.defaultEntry);
    }
    return headers_;
  }

  public int getHeadersCount() {
    return internalGetHeaders().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * HTTP request headers.
   *
   * This map contains the header field names and values.
   * Headers can be set when the
   * [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
   * Repeated headers are not supported but a header value can contain commas.
   *
   * Cloud Tasks sets some headers to default values:
   *
   * * `User-Agent`: By default, this header is
   *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
   *   This header can be modified, but Cloud Tasks will append
   *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
   *   modified `User-Agent`.
   *
   * If the task has a
   * [body][google.cloud.tasks.v2beta3.AppEngineHttpRequest.body], Cloud Tasks
   * sets the following headers:
   *
   * * `Content-Type`: By default, the `Content-Type` header is set to
   *   `"application/octet-stream"`. The default can be overridden by explicitly
   *   setting `Content-Type` to a particular media type when the
   *   [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
   *   For example, `Content-Type` can be set to `"application/json"`.
   * * `Content-Length`: This is computed by Cloud Tasks. This value is
   *   output only.   It cannot be changed.
   *
   * The headers below cannot be set or overridden:
   *
   * * `Host`
   * * `X-Google-*`
   * * `X-AppEngine-*`
   *
   * In addition, Cloud Tasks sets some headers when the task is dispatched,
   * such as headers containing information about the task; see
   * [request
   * headers](https://cloud.google.com/tasks/docs/creating-appengine-handlers#reading_request_headers).
   * These headers are set only when the task is dispatched, so they are not
   * visible when the task is returned in a Cloud Tasks response.
   *
   * Although there is no specific limit for the maximum number of headers or
   * the size, there is a limit on the maximum size of the
   * [Task][google.cloud.tasks.v2beta3.Task]. For more information, see the
   * [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask]
   * documentation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; headers = 4;</code>
   */
  @java.lang.Override
  public boolean containsHeaders(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetHeaders().getMap().containsKey(key);
  }
  /** Use {@link #getHeadersMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getHeaders() {
    return getHeadersMap();
  }
  /**
   *
   *
   * <pre>
   * HTTP request headers.
   *
   * This map contains the header field names and values.
   * Headers can be set when the
   * [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
   * Repeated headers are not supported but a header value can contain commas.
   *
   * Cloud Tasks sets some headers to default values:
   *
   * * `User-Agent`: By default, this header is
   *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
   *   This header can be modified, but Cloud Tasks will append
   *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
   *   modified `User-Agent`.
   *
   * If the task has a
   * [body][google.cloud.tasks.v2beta3.AppEngineHttpRequest.body], Cloud Tasks
   * sets the following headers:
   *
   * * `Content-Type`: By default, the `Content-Type` header is set to
   *   `"application/octet-stream"`. The default can be overridden by explicitly
   *   setting `Content-Type` to a particular media type when the
   *   [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
   *   For example, `Content-Type` can be set to `"application/json"`.
   * * `Content-Length`: This is computed by Cloud Tasks. This value is
   *   output only.   It cannot be changed.
   *
   * The headers below cannot be set or overridden:
   *
   * * `Host`
   * * `X-Google-*`
   * * `X-AppEngine-*`
   *
   * In addition, Cloud Tasks sets some headers when the task is dispatched,
   * such as headers containing information about the task; see
   * [request
   * headers](https://cloud.google.com/tasks/docs/creating-appengine-handlers#reading_request_headers).
   * These headers are set only when the task is dispatched, so they are not
   * visible when the task is returned in a Cloud Tasks response.
   *
   * Although there is no specific limit for the maximum number of headers or
   * the size, there is a limit on the maximum size of the
   * [Task][google.cloud.tasks.v2beta3.Task]. For more information, see the
   * [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask]
   * documentation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; headers = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getHeadersMap() {
    return internalGetHeaders().getMap();
  }
  /**
   *
   *
   * <pre>
   * HTTP request headers.
   *
   * This map contains the header field names and values.
   * Headers can be set when the
   * [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
   * Repeated headers are not supported but a header value can contain commas.
   *
   * Cloud Tasks sets some headers to default values:
   *
   * * `User-Agent`: By default, this header is
   *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
   *   This header can be modified, but Cloud Tasks will append
   *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
   *   modified `User-Agent`.
   *
   * If the task has a
   * [body][google.cloud.tasks.v2beta3.AppEngineHttpRequest.body], Cloud Tasks
   * sets the following headers:
   *
   * * `Content-Type`: By default, the `Content-Type` header is set to
   *   `"application/octet-stream"`. The default can be overridden by explicitly
   *   setting `Content-Type` to a particular media type when the
   *   [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
   *   For example, `Content-Type` can be set to `"application/json"`.
   * * `Content-Length`: This is computed by Cloud Tasks. This value is
   *   output only.   It cannot be changed.
   *
   * The headers below cannot be set or overridden:
   *
   * * `Host`
   * * `X-Google-*`
   * * `X-AppEngine-*`
   *
   * In addition, Cloud Tasks sets some headers when the task is dispatched,
   * such as headers containing information about the task; see
   * [request
   * headers](https://cloud.google.com/tasks/docs/creating-appengine-handlers#reading_request_headers).
   * These headers are set only when the task is dispatched, so they are not
   * visible when the task is returned in a Cloud Tasks response.
   *
   * Although there is no specific limit for the maximum number of headers or
   * the size, there is a limit on the maximum size of the
   * [Task][google.cloud.tasks.v2beta3.Task]. For more information, see the
   * [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask]
   * documentation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; headers = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getHeadersOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * HTTP request headers.
   *
   * This map contains the header field names and values.
   * Headers can be set when the
   * [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
   * Repeated headers are not supported but a header value can contain commas.
   *
   * Cloud Tasks sets some headers to default values:
   *
   * * `User-Agent`: By default, this header is
   *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
   *   This header can be modified, but Cloud Tasks will append
   *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
   *   modified `User-Agent`.
   *
   * If the task has a
   * [body][google.cloud.tasks.v2beta3.AppEngineHttpRequest.body], Cloud Tasks
   * sets the following headers:
   *
   * * `Content-Type`: By default, the `Content-Type` header is set to
   *   `"application/octet-stream"`. The default can be overridden by explicitly
   *   setting `Content-Type` to a particular media type when the
   *   [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
   *   For example, `Content-Type` can be set to `"application/json"`.
   * * `Content-Length`: This is computed by Cloud Tasks. This value is
   *   output only.   It cannot be changed.
   *
   * The headers below cannot be set or overridden:
   *
   * * `Host`
   * * `X-Google-*`
   * * `X-AppEngine-*`
   *
   * In addition, Cloud Tasks sets some headers when the task is dispatched,
   * such as headers containing information about the task; see
   * [request
   * headers](https://cloud.google.com/tasks/docs/creating-appengine-handlers#reading_request_headers).
   * These headers are set only when the task is dispatched, so they are not
   * visible when the task is returned in a Cloud Tasks response.
   *
   * Although there is no specific limit for the maximum number of headers or
   * the size, there is a limit on the maximum size of the
   * [Task][google.cloud.tasks.v2beta3.Task]. For more information, see the
   * [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask]
   * documentation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; headers = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getHeadersOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int BODY_FIELD_NUMBER = 5;
  private com.google.protobuf.ByteString body_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * HTTP request body.
   *
   * A request body is allowed only if the HTTP method is POST or PUT. It is
   * an error to set a body on a task with an incompatible
   * [HttpMethod][google.cloud.tasks.v2beta3.HttpMethod].
   * </pre>
   *
   * <code>bytes body = 5;</code>
   *
   * @return The body.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBody() {
    return body_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (httpMethod_
        != com.google.cloud.tasks.v2beta3.HttpMethod.HTTP_METHOD_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, httpMethod_);
    }
    if (appEngineRouting_ != null) {
      output.writeMessage(2, getAppEngineRouting());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(relativeUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, relativeUri_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetHeaders(), HeadersDefaultEntryHolder.defaultEntry, 4);
    if (!body_.isEmpty()) {
      output.writeBytes(5, body_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (httpMethod_
        != com.google.cloud.tasks.v2beta3.HttpMethod.HTTP_METHOD_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, httpMethod_);
    }
    if (appEngineRouting_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getAppEngineRouting());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(relativeUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, relativeUri_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetHeaders().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> headers__ =
          HeadersDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, headers__);
    }
    if (!body_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(5, body_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.tasks.v2beta3.AppEngineHttpRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.tasks.v2beta3.AppEngineHttpRequest other =
        (com.google.cloud.tasks.v2beta3.AppEngineHttpRequest) obj;

    if (httpMethod_ != other.httpMethod_) return false;
    if (hasAppEngineRouting() != other.hasAppEngineRouting()) return false;
    if (hasAppEngineRouting()) {
      if (!getAppEngineRouting().equals(other.getAppEngineRouting())) return false;
    }
    if (!getRelativeUri().equals(other.getRelativeUri())) return false;
    if (!internalGetHeaders().equals(other.internalGetHeaders())) return false;
    if (!getBody().equals(other.getBody())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + HTTP_METHOD_FIELD_NUMBER;
    hash = (53 * hash) + httpMethod_;
    if (hasAppEngineRouting()) {
      hash = (37 * hash) + APP_ENGINE_ROUTING_FIELD_NUMBER;
      hash = (53 * hash) + getAppEngineRouting().hashCode();
    }
    hash = (37 * hash) + RELATIVE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getRelativeUri().hashCode();
    if (!internalGetHeaders().getMap().isEmpty()) {
      hash = (37 * hash) + HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetHeaders().hashCode();
    }
    hash = (37 * hash) + BODY_FIELD_NUMBER;
    hash = (53 * hash) + getBody().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineHttpRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineHttpRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineHttpRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineHttpRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineHttpRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineHttpRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineHttpRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineHttpRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineHttpRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineHttpRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineHttpRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineHttpRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.tasks.v2beta3.AppEngineHttpRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * App Engine HTTP request.
   *
   * The message defines the HTTP request that is sent to an App Engine app when
   * the task is dispatched.
   *
   * Using [AppEngineHttpRequest][google.cloud.tasks.v2beta3.AppEngineHttpRequest]
   * requires
   * [`appengine.applications.get`](https://cloud.google.com/appengine/docs/admin-api/access-control)
   * Google IAM permission for the project
   * and the following scope:
   *
   * `https://www.googleapis.com/auth/cloud-platform`
   *
   * The task will be delivered to the App Engine app which belongs to the same
   * project as the queue. For more information, see
   * [How Requests are
   * Routed](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed)
   * and how routing is affected by
   * [dispatch
   * files](https://cloud.google.com/appengine/docs/python/config/dispatchref).
   * Traffic is encrypted during transport and never leaves Google datacenters.
   * Because this traffic is carried over a communication mechanism internal to
   * Google, you cannot explicitly set the protocol (for example, HTTP or HTTPS).
   * The request to the handler, however, will appear to have used the HTTP
   * protocol.
   *
   * The [AppEngineRouting][google.cloud.tasks.v2beta3.AppEngineRouting] used to
   * construct the URL that the task is delivered to can be set at the queue-level
   * or task-level:
   *
   * * If set,
   *   [app_engine_routing_override][google.cloud.tasks.v2beta3.AppEngineHttpQueue.app_engine_routing_override]
   *   is used for all tasks in the queue, no matter what the setting
   *   is for the
   *   [task-level
   *   app_engine_routing][google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing].
   *
   *
   * The `url` that the task will be sent to is:
   *
   * * `url =` [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] `+`
   *   [relative_uri][google.cloud.tasks.v2beta3.AppEngineHttpRequest.relative_uri]
   *
   * Tasks can be dispatched to secure app handlers, unsecure app handlers, and
   * URIs restricted with
   * [`login:
   * admin`](https://cloud.google.com/appengine/docs/standard/python/config/appref).
   * Because tasks are not run as any user, they cannot be dispatched to URIs
   * restricted with
   * [`login:
   * required`](https://cloud.google.com/appengine/docs/standard/python/config/appref)
   * Task dispatches also do not follow redirects.
   *
   * The task attempt has succeeded if the app's request handler returns an HTTP
   * response code in the range [`200` - `299`]. The task attempt has failed if
   * the app's handler returns a non-2xx response code or Cloud Tasks does
   * not receive response before the
   * [deadline][google.cloud.tasks.v2beta3.Task.dispatch_deadline]. Failed tasks
   * will be retried according to the [retry
   * configuration][google.cloud.tasks.v2beta3.Queue.retry_config]. `503` (Service
   * Unavailable) is considered an App Engine system error instead of an
   * application error and will cause Cloud Tasks' traffic congestion control to
   * temporarily throttle the queue's dispatches. Unlike other types of task
   * targets, a `429` (Too Many Requests) response from an app handler does not
   * cause traffic congestion control to throttle the queue.
   * </pre>
   *
   * Protobuf type {@code google.cloud.tasks.v2beta3.AppEngineHttpRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.tasks.v2beta3.AppEngineHttpRequest)
      com.google.cloud.tasks.v2beta3.AppEngineHttpRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.tasks.v2beta3.TargetProto
          .internal_static_google_cloud_tasks_v2beta3_AppEngineHttpRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 4:
          return internalGetHeaders();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 4:
          return internalGetMutableHeaders();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.tasks.v2beta3.TargetProto
          .internal_static_google_cloud_tasks_v2beta3_AppEngineHttpRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.tasks.v2beta3.AppEngineHttpRequest.class,
              com.google.cloud.tasks.v2beta3.AppEngineHttpRequest.Builder.class);
    }

    // Construct using com.google.cloud.tasks.v2beta3.AppEngineHttpRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      httpMethod_ = 0;
      appEngineRouting_ = null;
      if (appEngineRoutingBuilder_ != null) {
        appEngineRoutingBuilder_.dispose();
        appEngineRoutingBuilder_ = null;
      }
      relativeUri_ = "";
      internalGetMutableHeaders().clear();
      body_ = com.google.protobuf.ByteString.EMPTY;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.tasks.v2beta3.TargetProto
          .internal_static_google_cloud_tasks_v2beta3_AppEngineHttpRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.AppEngineHttpRequest getDefaultInstanceForType() {
      return com.google.cloud.tasks.v2beta3.AppEngineHttpRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.AppEngineHttpRequest build() {
      com.google.cloud.tasks.v2beta3.AppEngineHttpRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.AppEngineHttpRequest buildPartial() {
      com.google.cloud.tasks.v2beta3.AppEngineHttpRequest result =
          new com.google.cloud.tasks.v2beta3.AppEngineHttpRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.tasks.v2beta3.AppEngineHttpRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.httpMethod_ = httpMethod_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.appEngineRouting_ =
            appEngineRoutingBuilder_ == null ? appEngineRouting_ : appEngineRoutingBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.relativeUri_ = relativeUri_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.headers_ = internalGetHeaders();
        result.headers_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.body_ = body_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.tasks.v2beta3.AppEngineHttpRequest) {
        return mergeFrom((com.google.cloud.tasks.v2beta3.AppEngineHttpRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.tasks.v2beta3.AppEngineHttpRequest other) {
      if (other == com.google.cloud.tasks.v2beta3.AppEngineHttpRequest.getDefaultInstance())
        return this;
      if (other.httpMethod_ != 0) {
        setHttpMethodValue(other.getHttpMethodValue());
      }
      if (other.hasAppEngineRouting()) {
        mergeAppEngineRouting(other.getAppEngineRouting());
      }
      if (!other.getRelativeUri().isEmpty()) {
        relativeUri_ = other.relativeUri_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      internalGetMutableHeaders().mergeFrom(other.internalGetHeaders());
      bitField0_ |= 0x00000008;
      if (other.getBody() != com.google.protobuf.ByteString.EMPTY) {
        setBody(other.getBody());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                httpMethod_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(
                    getAppEngineRoutingFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                relativeUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> headers__ =
                    input.readMessage(
                        HeadersDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableHeaders()
                    .getMutableMap()
                    .put(headers__.getKey(), headers__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                body_ = input.readBytes();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int httpMethod_ = 0;
    /**
     *
     *
     * <pre>
     * The HTTP method to use for the request. The default is POST.
     *
     * The app's request handler for the task's target URL must be able to handle
     * HTTP requests with this http_method, otherwise the task attempt fails with
     * error code 405 (Method Not Allowed). See [Writing a push task request
     * handler](https://cloud.google.com/appengine/docs/java/taskqueue/push/creating-handlers#writing_a_push_task_request_handler)
     * and the App Engine documentation for your runtime on [How Requests are
     * Handled](https://cloud.google.com/appengine/docs/standard/python3/how-requests-are-handled).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.HttpMethod http_method = 1;</code>
     *
     * @return The enum numeric value on the wire for httpMethod.
     */
    @java.lang.Override
    public int getHttpMethodValue() {
      return httpMethod_;
    }
    /**
     *
     *
     * <pre>
     * The HTTP method to use for the request. The default is POST.
     *
     * The app's request handler for the task's target URL must be able to handle
     * HTTP requests with this http_method, otherwise the task attempt fails with
     * error code 405 (Method Not Allowed). See [Writing a push task request
     * handler](https://cloud.google.com/appengine/docs/java/taskqueue/push/creating-handlers#writing_a_push_task_request_handler)
     * and the App Engine documentation for your runtime on [How Requests are
     * Handled](https://cloud.google.com/appengine/docs/standard/python3/how-requests-are-handled).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.HttpMethod http_method = 1;</code>
     *
     * @param value The enum numeric value on the wire for httpMethod to set.
     * @return This builder for chaining.
     */
    public Builder setHttpMethodValue(int value) {
      httpMethod_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The HTTP method to use for the request. The default is POST.
     *
     * The app's request handler for the task's target URL must be able to handle
     * HTTP requests with this http_method, otherwise the task attempt fails with
     * error code 405 (Method Not Allowed). See [Writing a push task request
     * handler](https://cloud.google.com/appengine/docs/java/taskqueue/push/creating-handlers#writing_a_push_task_request_handler)
     * and the App Engine documentation for your runtime on [How Requests are
     * Handled](https://cloud.google.com/appengine/docs/standard/python3/how-requests-are-handled).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.HttpMethod http_method = 1;</code>
     *
     * @return The httpMethod.
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.HttpMethod getHttpMethod() {
      com.google.cloud.tasks.v2beta3.HttpMethod result =
          com.google.cloud.tasks.v2beta3.HttpMethod.forNumber(httpMethod_);
      return result == null ? com.google.cloud.tasks.v2beta3.HttpMethod.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The HTTP method to use for the request. The default is POST.
     *
     * The app's request handler for the task's target URL must be able to handle
     * HTTP requests with this http_method, otherwise the task attempt fails with
     * error code 405 (Method Not Allowed). See [Writing a push task request
     * handler](https://cloud.google.com/appengine/docs/java/taskqueue/push/creating-handlers#writing_a_push_task_request_handler)
     * and the App Engine documentation for your runtime on [How Requests are
     * Handled](https://cloud.google.com/appengine/docs/standard/python3/how-requests-are-handled).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.HttpMethod http_method = 1;</code>
     *
     * @param value The httpMethod to set.
     * @return This builder for chaining.
     */
    public Builder setHttpMethod(com.google.cloud.tasks.v2beta3.HttpMethod value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      httpMethod_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The HTTP method to use for the request. The default is POST.
     *
     * The app's request handler for the task's target URL must be able to handle
     * HTTP requests with this http_method, otherwise the task attempt fails with
     * error code 405 (Method Not Allowed). See [Writing a push task request
     * handler](https://cloud.google.com/appengine/docs/java/taskqueue/push/creating-handlers#writing_a_push_task_request_handler)
     * and the App Engine documentation for your runtime on [How Requests are
     * Handled](https://cloud.google.com/appengine/docs/standard/python3/how-requests-are-handled).
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.HttpMethod http_method = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHttpMethod() {
      bitField0_ = (bitField0_ & ~0x00000001);
      httpMethod_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.tasks.v2beta3.AppEngineRouting appEngineRouting_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.AppEngineRouting,
            com.google.cloud.tasks.v2beta3.AppEngineRouting.Builder,
            com.google.cloud.tasks.v2beta3.AppEngineRoutingOrBuilder>
        appEngineRoutingBuilder_;
    /**
     *
     *
     * <pre>
     * Task-level setting for App Engine routing.
     *
     * If set,
     * [app_engine_routing_override][google.cloud.tasks.v2beta3.AppEngineHttpQueue.app_engine_routing_override]
     * is used for all tasks in the queue, no matter what the setting is for the
     * [task-level
     * app_engine_routing][google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineRouting app_engine_routing = 2;</code>
     *
     * @return Whether the appEngineRouting field is set.
     */
    public boolean hasAppEngineRouting() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Task-level setting for App Engine routing.
     *
     * If set,
     * [app_engine_routing_override][google.cloud.tasks.v2beta3.AppEngineHttpQueue.app_engine_routing_override]
     * is used for all tasks in the queue, no matter what the setting is for the
     * [task-level
     * app_engine_routing][google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineRouting app_engine_routing = 2;</code>
     *
     * @return The appEngineRouting.
     */
    public com.google.cloud.tasks.v2beta3.AppEngineRouting getAppEngineRouting() {
      if (appEngineRoutingBuilder_ == null) {
        return appEngineRouting_ == null
            ? com.google.cloud.tasks.v2beta3.AppEngineRouting.getDefaultInstance()
            : appEngineRouting_;
      } else {
        return appEngineRoutingBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Task-level setting for App Engine routing.
     *
     * If set,
     * [app_engine_routing_override][google.cloud.tasks.v2beta3.AppEngineHttpQueue.app_engine_routing_override]
     * is used for all tasks in the queue, no matter what the setting is for the
     * [task-level
     * app_engine_routing][google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineRouting app_engine_routing = 2;</code>
     */
    public Builder setAppEngineRouting(com.google.cloud.tasks.v2beta3.AppEngineRouting value) {
      if (appEngineRoutingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        appEngineRouting_ = value;
      } else {
        appEngineRoutingBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Task-level setting for App Engine routing.
     *
     * If set,
     * [app_engine_routing_override][google.cloud.tasks.v2beta3.AppEngineHttpQueue.app_engine_routing_override]
     * is used for all tasks in the queue, no matter what the setting is for the
     * [task-level
     * app_engine_routing][google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineRouting app_engine_routing = 2;</code>
     */
    public Builder setAppEngineRouting(
        com.google.cloud.tasks.v2beta3.AppEngineRouting.Builder builderForValue) {
      if (appEngineRoutingBuilder_ == null) {
        appEngineRouting_ = builderForValue.build();
      } else {
        appEngineRoutingBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Task-level setting for App Engine routing.
     *
     * If set,
     * [app_engine_routing_override][google.cloud.tasks.v2beta3.AppEngineHttpQueue.app_engine_routing_override]
     * is used for all tasks in the queue, no matter what the setting is for the
     * [task-level
     * app_engine_routing][google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineRouting app_engine_routing = 2;</code>
     */
    public Builder mergeAppEngineRouting(com.google.cloud.tasks.v2beta3.AppEngineRouting value) {
      if (appEngineRoutingBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && appEngineRouting_ != null
            && appEngineRouting_
                != com.google.cloud.tasks.v2beta3.AppEngineRouting.getDefaultInstance()) {
          getAppEngineRoutingBuilder().mergeFrom(value);
        } else {
          appEngineRouting_ = value;
        }
      } else {
        appEngineRoutingBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Task-level setting for App Engine routing.
     *
     * If set,
     * [app_engine_routing_override][google.cloud.tasks.v2beta3.AppEngineHttpQueue.app_engine_routing_override]
     * is used for all tasks in the queue, no matter what the setting is for the
     * [task-level
     * app_engine_routing][google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineRouting app_engine_routing = 2;</code>
     */
    public Builder clearAppEngineRouting() {
      bitField0_ = (bitField0_ & ~0x00000002);
      appEngineRouting_ = null;
      if (appEngineRoutingBuilder_ != null) {
        appEngineRoutingBuilder_.dispose();
        appEngineRoutingBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Task-level setting for App Engine routing.
     *
     * If set,
     * [app_engine_routing_override][google.cloud.tasks.v2beta3.AppEngineHttpQueue.app_engine_routing_override]
     * is used for all tasks in the queue, no matter what the setting is for the
     * [task-level
     * app_engine_routing][google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineRouting app_engine_routing = 2;</code>
     */
    public com.google.cloud.tasks.v2beta3.AppEngineRouting.Builder getAppEngineRoutingBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getAppEngineRoutingFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Task-level setting for App Engine routing.
     *
     * If set,
     * [app_engine_routing_override][google.cloud.tasks.v2beta3.AppEngineHttpQueue.app_engine_routing_override]
     * is used for all tasks in the queue, no matter what the setting is for the
     * [task-level
     * app_engine_routing][google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineRouting app_engine_routing = 2;</code>
     */
    public com.google.cloud.tasks.v2beta3.AppEngineRoutingOrBuilder getAppEngineRoutingOrBuilder() {
      if (appEngineRoutingBuilder_ != null) {
        return appEngineRoutingBuilder_.getMessageOrBuilder();
      } else {
        return appEngineRouting_ == null
            ? com.google.cloud.tasks.v2beta3.AppEngineRouting.getDefaultInstance()
            : appEngineRouting_;
      }
    }
    /**
     *
     *
     * <pre>
     * Task-level setting for App Engine routing.
     *
     * If set,
     * [app_engine_routing_override][google.cloud.tasks.v2beta3.AppEngineHttpQueue.app_engine_routing_override]
     * is used for all tasks in the queue, no matter what the setting is for the
     * [task-level
     * app_engine_routing][google.cloud.tasks.v2beta3.AppEngineHttpRequest.app_engine_routing].
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.AppEngineRouting app_engine_routing = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.AppEngineRouting,
            com.google.cloud.tasks.v2beta3.AppEngineRouting.Builder,
            com.google.cloud.tasks.v2beta3.AppEngineRoutingOrBuilder>
        getAppEngineRoutingFieldBuilder() {
      if (appEngineRoutingBuilder_ == null) {
        appEngineRoutingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2beta3.AppEngineRouting,
                com.google.cloud.tasks.v2beta3.AppEngineRouting.Builder,
                com.google.cloud.tasks.v2beta3.AppEngineRoutingOrBuilder>(
                getAppEngineRouting(), getParentForChildren(), isClean());
        appEngineRouting_ = null;
      }
      return appEngineRoutingBuilder_;
    }

    private java.lang.Object relativeUri_ = "";
    /**
     *
     *
     * <pre>
     * The relative URI.
     *
     * The relative URI must begin with "/" and must be a valid HTTP relative URI.
     * It can contain a path and query string arguments.
     * If the relative URI is empty, then the root path "/" will be used.
     * No spaces are allowed, and the maximum length allowed is 2083 characters.
     * </pre>
     *
     * <code>string relative_uri = 3;</code>
     *
     * @return The relativeUri.
     */
    public java.lang.String getRelativeUri() {
      java.lang.Object ref = relativeUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        relativeUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative URI.
     *
     * The relative URI must begin with "/" and must be a valid HTTP relative URI.
     * It can contain a path and query string arguments.
     * If the relative URI is empty, then the root path "/" will be used.
     * No spaces are allowed, and the maximum length allowed is 2083 characters.
     * </pre>
     *
     * <code>string relative_uri = 3;</code>
     *
     * @return The bytes for relativeUri.
     */
    public com.google.protobuf.ByteString getRelativeUriBytes() {
      java.lang.Object ref = relativeUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        relativeUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The relative URI.
     *
     * The relative URI must begin with "/" and must be a valid HTTP relative URI.
     * It can contain a path and query string arguments.
     * If the relative URI is empty, then the root path "/" will be used.
     * No spaces are allowed, and the maximum length allowed is 2083 characters.
     * </pre>
     *
     * <code>string relative_uri = 3;</code>
     *
     * @param value The relativeUri to set.
     * @return This builder for chaining.
     */
    public Builder setRelativeUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      relativeUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative URI.
     *
     * The relative URI must begin with "/" and must be a valid HTTP relative URI.
     * It can contain a path and query string arguments.
     * If the relative URI is empty, then the root path "/" will be used.
     * No spaces are allowed, and the maximum length allowed is 2083 characters.
     * </pre>
     *
     * <code>string relative_uri = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRelativeUri() {
      relativeUri_ = getDefaultInstance().getRelativeUri();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The relative URI.
     *
     * The relative URI must begin with "/" and must be a valid HTTP relative URI.
     * It can contain a path and query string arguments.
     * If the relative URI is empty, then the root path "/" will be used.
     * No spaces are allowed, and the maximum length allowed is 2083 characters.
     * </pre>
     *
     * <code>string relative_uri = 3;</code>
     *
     * @param value The bytes for relativeUri to set.
     * @return This builder for chaining.
     */
    public Builder setRelativeUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      relativeUri_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> headers_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetHeaders() {
      if (headers_ == null) {
        return com.google.protobuf.MapField.emptyMapField(HeadersDefaultEntryHolder.defaultEntry);
      }
      return headers_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableHeaders() {
      if (headers_ == null) {
        headers_ = com.google.protobuf.MapField.newMapField(HeadersDefaultEntryHolder.defaultEntry);
      }
      if (!headers_.isMutable()) {
        headers_ = headers_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return headers_;
    }

    public int getHeadersCount() {
      return internalGetHeaders().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     *
     * This map contains the header field names and values.
     * Headers can be set when the
     * [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     * Repeated headers are not supported but a header value can contain commas.
     *
     * Cloud Tasks sets some headers to default values:
     *
     * * `User-Agent`: By default, this header is
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
     *   This header can be modified, but Cloud Tasks will append
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
     *   modified `User-Agent`.
     *
     * If the task has a
     * [body][google.cloud.tasks.v2beta3.AppEngineHttpRequest.body], Cloud Tasks
     * sets the following headers:
     *
     * * `Content-Type`: By default, the `Content-Type` header is set to
     *   `"application/octet-stream"`. The default can be overridden by explicitly
     *   setting `Content-Type` to a particular media type when the
     *   [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     *   For example, `Content-Type` can be set to `"application/json"`.
     * * `Content-Length`: This is computed by Cloud Tasks. This value is
     *   output only.   It cannot be changed.
     *
     * The headers below cannot be set or overridden:
     *
     * * `Host`
     * * `X-Google-*`
     * * `X-AppEngine-*`
     *
     * In addition, Cloud Tasks sets some headers when the task is dispatched,
     * such as headers containing information about the task; see
     * [request
     * headers](https://cloud.google.com/tasks/docs/creating-appengine-handlers#reading_request_headers).
     * These headers are set only when the task is dispatched, so they are not
     * visible when the task is returned in a Cloud Tasks response.
     *
     * Although there is no specific limit for the maximum number of headers or
     * the size, there is a limit on the maximum size of the
     * [Task][google.cloud.tasks.v2beta3.Task]. For more information, see the
     * [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask]
     * documentation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 4;</code>
     */
    @java.lang.Override
    public boolean containsHeaders(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetHeaders().getMap().containsKey(key);
    }
    /** Use {@link #getHeadersMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getHeaders() {
      return getHeadersMap();
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     *
     * This map contains the header field names and values.
     * Headers can be set when the
     * [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     * Repeated headers are not supported but a header value can contain commas.
     *
     * Cloud Tasks sets some headers to default values:
     *
     * * `User-Agent`: By default, this header is
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
     *   This header can be modified, but Cloud Tasks will append
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
     *   modified `User-Agent`.
     *
     * If the task has a
     * [body][google.cloud.tasks.v2beta3.AppEngineHttpRequest.body], Cloud Tasks
     * sets the following headers:
     *
     * * `Content-Type`: By default, the `Content-Type` header is set to
     *   `"application/octet-stream"`. The default can be overridden by explicitly
     *   setting `Content-Type` to a particular media type when the
     *   [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     *   For example, `Content-Type` can be set to `"application/json"`.
     * * `Content-Length`: This is computed by Cloud Tasks. This value is
     *   output only.   It cannot be changed.
     *
     * The headers below cannot be set or overridden:
     *
     * * `Host`
     * * `X-Google-*`
     * * `X-AppEngine-*`
     *
     * In addition, Cloud Tasks sets some headers when the task is dispatched,
     * such as headers containing information about the task; see
     * [request
     * headers](https://cloud.google.com/tasks/docs/creating-appengine-handlers#reading_request_headers).
     * These headers are set only when the task is dispatched, so they are not
     * visible when the task is returned in a Cloud Tasks response.
     *
     * Although there is no specific limit for the maximum number of headers or
     * the size, there is a limit on the maximum size of the
     * [Task][google.cloud.tasks.v2beta3.Task]. For more information, see the
     * [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask]
     * documentation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getHeadersMap() {
      return internalGetHeaders().getMap();
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     *
     * This map contains the header field names and values.
     * Headers can be set when the
     * [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     * Repeated headers are not supported but a header value can contain commas.
     *
     * Cloud Tasks sets some headers to default values:
     *
     * * `User-Agent`: By default, this header is
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
     *   This header can be modified, but Cloud Tasks will append
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
     *   modified `User-Agent`.
     *
     * If the task has a
     * [body][google.cloud.tasks.v2beta3.AppEngineHttpRequest.body], Cloud Tasks
     * sets the following headers:
     *
     * * `Content-Type`: By default, the `Content-Type` header is set to
     *   `"application/octet-stream"`. The default can be overridden by explicitly
     *   setting `Content-Type` to a particular media type when the
     *   [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     *   For example, `Content-Type` can be set to `"application/json"`.
     * * `Content-Length`: This is computed by Cloud Tasks. This value is
     *   output only.   It cannot be changed.
     *
     * The headers below cannot be set or overridden:
     *
     * * `Host`
     * * `X-Google-*`
     * * `X-AppEngine-*`
     *
     * In addition, Cloud Tasks sets some headers when the task is dispatched,
     * such as headers containing information about the task; see
     * [request
     * headers](https://cloud.google.com/tasks/docs/creating-appengine-handlers#reading_request_headers).
     * These headers are set only when the task is dispatched, so they are not
     * visible when the task is returned in a Cloud Tasks response.
     *
     * Although there is no specific limit for the maximum number of headers or
     * the size, there is a limit on the maximum size of the
     * [Task][google.cloud.tasks.v2beta3.Task]. For more information, see the
     * [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask]
     * documentation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getHeadersOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     *
     * This map contains the header field names and values.
     * Headers can be set when the
     * [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     * Repeated headers are not supported but a header value can contain commas.
     *
     * Cloud Tasks sets some headers to default values:
     *
     * * `User-Agent`: By default, this header is
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
     *   This header can be modified, but Cloud Tasks will append
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
     *   modified `User-Agent`.
     *
     * If the task has a
     * [body][google.cloud.tasks.v2beta3.AppEngineHttpRequest.body], Cloud Tasks
     * sets the following headers:
     *
     * * `Content-Type`: By default, the `Content-Type` header is set to
     *   `"application/octet-stream"`. The default can be overridden by explicitly
     *   setting `Content-Type` to a particular media type when the
     *   [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     *   For example, `Content-Type` can be set to `"application/json"`.
     * * `Content-Length`: This is computed by Cloud Tasks. This value is
     *   output only.   It cannot be changed.
     *
     * The headers below cannot be set or overridden:
     *
     * * `Host`
     * * `X-Google-*`
     * * `X-AppEngine-*`
     *
     * In addition, Cloud Tasks sets some headers when the task is dispatched,
     * such as headers containing information about the task; see
     * [request
     * headers](https://cloud.google.com/tasks/docs/creating-appengine-handlers#reading_request_headers).
     * These headers are set only when the task is dispatched, so they are not
     * visible when the task is returned in a Cloud Tasks response.
     *
     * Although there is no specific limit for the maximum number of headers or
     * the size, there is a limit on the maximum size of the
     * [Task][google.cloud.tasks.v2beta3.Task]. For more information, see the
     * [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask]
     * documentation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getHeadersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearHeaders() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableHeaders().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     *
     * This map contains the header field names and values.
     * Headers can be set when the
     * [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     * Repeated headers are not supported but a header value can contain commas.
     *
     * Cloud Tasks sets some headers to default values:
     *
     * * `User-Agent`: By default, this header is
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
     *   This header can be modified, but Cloud Tasks will append
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
     *   modified `User-Agent`.
     *
     * If the task has a
     * [body][google.cloud.tasks.v2beta3.AppEngineHttpRequest.body], Cloud Tasks
     * sets the following headers:
     *
     * * `Content-Type`: By default, the `Content-Type` header is set to
     *   `"application/octet-stream"`. The default can be overridden by explicitly
     *   setting `Content-Type` to a particular media type when the
     *   [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     *   For example, `Content-Type` can be set to `"application/json"`.
     * * `Content-Length`: This is computed by Cloud Tasks. This value is
     *   output only.   It cannot be changed.
     *
     * The headers below cannot be set or overridden:
     *
     * * `Host`
     * * `X-Google-*`
     * * `X-AppEngine-*`
     *
     * In addition, Cloud Tasks sets some headers when the task is dispatched,
     * such as headers containing information about the task; see
     * [request
     * headers](https://cloud.google.com/tasks/docs/creating-appengine-handlers#reading_request_headers).
     * These headers are set only when the task is dispatched, so they are not
     * visible when the task is returned in a Cloud Tasks response.
     *
     * Although there is no specific limit for the maximum number of headers or
     * the size, there is a limit on the maximum size of the
     * [Task][google.cloud.tasks.v2beta3.Task]. For more information, see the
     * [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask]
     * documentation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 4;</code>
     */
    public Builder removeHeaders(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableHeaders().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableHeaders() {
      bitField0_ |= 0x00000008;
      return internalGetMutableHeaders().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     *
     * This map contains the header field names and values.
     * Headers can be set when the
     * [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     * Repeated headers are not supported but a header value can contain commas.
     *
     * Cloud Tasks sets some headers to default values:
     *
     * * `User-Agent`: By default, this header is
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
     *   This header can be modified, but Cloud Tasks will append
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
     *   modified `User-Agent`.
     *
     * If the task has a
     * [body][google.cloud.tasks.v2beta3.AppEngineHttpRequest.body], Cloud Tasks
     * sets the following headers:
     *
     * * `Content-Type`: By default, the `Content-Type` header is set to
     *   `"application/octet-stream"`. The default can be overridden by explicitly
     *   setting `Content-Type` to a particular media type when the
     *   [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     *   For example, `Content-Type` can be set to `"application/json"`.
     * * `Content-Length`: This is computed by Cloud Tasks. This value is
     *   output only.   It cannot be changed.
     *
     * The headers below cannot be set or overridden:
     *
     * * `Host`
     * * `X-Google-*`
     * * `X-AppEngine-*`
     *
     * In addition, Cloud Tasks sets some headers when the task is dispatched,
     * such as headers containing information about the task; see
     * [request
     * headers](https://cloud.google.com/tasks/docs/creating-appengine-handlers#reading_request_headers).
     * These headers are set only when the task is dispatched, so they are not
     * visible when the task is returned in a Cloud Tasks response.
     *
     * Although there is no specific limit for the maximum number of headers or
     * the size, there is a limit on the maximum size of the
     * [Task][google.cloud.tasks.v2beta3.Task]. For more information, see the
     * [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask]
     * documentation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 4;</code>
     */
    public Builder putHeaders(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableHeaders().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     *
     * This map contains the header field names and values.
     * Headers can be set when the
     * [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     * Repeated headers are not supported but a header value can contain commas.
     *
     * Cloud Tasks sets some headers to default values:
     *
     * * `User-Agent`: By default, this header is
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"`.
     *   This header can be modified, but Cloud Tasks will append
     *   `"AppEngine-Google; (+http://code.google.com/appengine)"` to the
     *   modified `User-Agent`.
     *
     * If the task has a
     * [body][google.cloud.tasks.v2beta3.AppEngineHttpRequest.body], Cloud Tasks
     * sets the following headers:
     *
     * * `Content-Type`: By default, the `Content-Type` header is set to
     *   `"application/octet-stream"`. The default can be overridden by explicitly
     *   setting `Content-Type` to a particular media type when the
     *   [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     *   For example, `Content-Type` can be set to `"application/json"`.
     * * `Content-Length`: This is computed by Cloud Tasks. This value is
     *   output only.   It cannot be changed.
     *
     * The headers below cannot be set or overridden:
     *
     * * `Host`
     * * `X-Google-*`
     * * `X-AppEngine-*`
     *
     * In addition, Cloud Tasks sets some headers when the task is dispatched,
     * such as headers containing information about the task; see
     * [request
     * headers](https://cloud.google.com/tasks/docs/creating-appengine-handlers#reading_request_headers).
     * These headers are set only when the task is dispatched, so they are not
     * visible when the task is returned in a Cloud Tasks response.
     *
     * Although there is no specific limit for the maximum number of headers or
     * the size, there is a limit on the maximum size of the
     * [Task][google.cloud.tasks.v2beta3.Task]. For more information, see the
     * [CreateTask][google.cloud.tasks.v2beta3.CloudTasks.CreateTask]
     * documentation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 4;</code>
     */
    public Builder putAllHeaders(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableHeaders().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    private com.google.protobuf.ByteString body_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * HTTP request body.
     *
     * A request body is allowed only if the HTTP method is POST or PUT. It is
     * an error to set a body on a task with an incompatible
     * [HttpMethod][google.cloud.tasks.v2beta3.HttpMethod].
     * </pre>
     *
     * <code>bytes body = 5;</code>
     *
     * @return The body.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getBody() {
      return body_;
    }
    /**
     *
     *
     * <pre>
     * HTTP request body.
     *
     * A request body is allowed only if the HTTP method is POST or PUT. It is
     * an error to set a body on a task with an incompatible
     * [HttpMethod][google.cloud.tasks.v2beta3.HttpMethod].
     * </pre>
     *
     * <code>bytes body = 5;</code>
     *
     * @param value The body to set.
     * @return This builder for chaining.
     */
    public Builder setBody(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      body_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP request body.
     *
     * A request body is allowed only if the HTTP method is POST or PUT. It is
     * an error to set a body on a task with an incompatible
     * [HttpMethod][google.cloud.tasks.v2beta3.HttpMethod].
     * </pre>
     *
     * <code>bytes body = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBody() {
      bitField0_ = (bitField0_ & ~0x00000010);
      body_ = getDefaultInstance().getBody();
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.tasks.v2beta3.AppEngineHttpRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.tasks.v2beta3.AppEngineHttpRequest)
  private static final com.google.cloud.tasks.v2beta3.AppEngineHttpRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.tasks.v2beta3.AppEngineHttpRequest();
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineHttpRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AppEngineHttpRequest> PARSER =
      new com.google.protobuf.AbstractParser<AppEngineHttpRequest>() {
        @java.lang.Override
        public AppEngineHttpRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AppEngineHttpRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AppEngineHttpRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.AppEngineHttpRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
