/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/tasks/v2beta3/target.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.tasks.v2beta3;

/**
 *
 *
 * <pre>
 * URI Override.
 *
 * When specified, all the HTTP tasks inside the queue will be partially or
 * fully overridden depending on the configured values.
 * </pre>
 *
 * Protobuf type {@code google.cloud.tasks.v2beta3.UriOverride}
 */
public final class UriOverride extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.tasks.v2beta3.UriOverride)
    UriOverrideOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UriOverride.newBuilder() to construct.
  private UriOverride(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UriOverride() {
    scheme_ = 0;
    host_ = "";
    uriOverrideEnforceMode_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UriOverride();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.tasks.v2beta3.TargetProto
        .internal_static_google_cloud_tasks_v2beta3_UriOverride_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.tasks.v2beta3.TargetProto
        .internal_static_google_cloud_tasks_v2beta3_UriOverride_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.tasks.v2beta3.UriOverride.class,
            com.google.cloud.tasks.v2beta3.UriOverride.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The Scheme for an HTTP request. By default, it is HTTPS.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.tasks.v2beta3.UriOverride.Scheme}
   */
  public enum Scheme implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Scheme unspecified. Defaults to HTTPS.
     * </pre>
     *
     * <code>SCHEME_UNSPECIFIED = 0;</code>
     */
    SCHEME_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Convert the scheme to HTTP, e.g., https://www.google.ca will change to
     * http://www.google.ca.
     * </pre>
     *
     * <code>HTTP = 1;</code>
     */
    HTTP(1),
    /**
     *
     *
     * <pre>
     * Convert the scheme to HTTPS, e.g., http://www.google.ca will change to
     * https://www.google.ca.
     * </pre>
     *
     * <code>HTTPS = 2;</code>
     */
    HTTPS(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Scheme unspecified. Defaults to HTTPS.
     * </pre>
     *
     * <code>SCHEME_UNSPECIFIED = 0;</code>
     */
    public static final int SCHEME_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Convert the scheme to HTTP, e.g., https://www.google.ca will change to
     * http://www.google.ca.
     * </pre>
     *
     * <code>HTTP = 1;</code>
     */
    public static final int HTTP_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Convert the scheme to HTTPS, e.g., http://www.google.ca will change to
     * https://www.google.ca.
     * </pre>
     *
     * <code>HTTPS = 2;</code>
     */
    public static final int HTTPS_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Scheme valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Scheme forNumber(int value) {
      switch (value) {
        case 0:
          return SCHEME_UNSPECIFIED;
        case 1:
          return HTTP;
        case 2:
          return HTTPS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Scheme> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Scheme> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Scheme>() {
          public Scheme findValueByNumber(int number) {
            return Scheme.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.tasks.v2beta3.UriOverride.getDescriptor().getEnumTypes().get(0);
    }

    private static final Scheme[] VALUES = values();

    public static Scheme valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Scheme(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.tasks.v2beta3.UriOverride.Scheme)
  }

  /**
   *
   *
   * <pre>
   * UriOverrideEnforceMode mode is to define enforcing mode for the override
   * modes.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.tasks.v2beta3.UriOverride.UriOverrideEnforceMode}
   */
  public enum UriOverrideEnforceMode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * OverrideMode Unspecified. Defaults to ALWAYS.
     * </pre>
     *
     * <code>URI_OVERRIDE_ENFORCE_MODE_UNSPECIFIED = 0;</code>
     */
    URI_OVERRIDE_ENFORCE_MODE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * In the IF_NOT_EXISTS mode, queue-level configuration is only
     * applied where task-level configuration does not exist.
     * </pre>
     *
     * <code>IF_NOT_EXISTS = 1;</code>
     */
    IF_NOT_EXISTS(1),
    /**
     *
     *
     * <pre>
     * In the ALWAYS mode, queue-level configuration overrides all
     * task-level configuration
     * </pre>
     *
     * <code>ALWAYS = 2;</code>
     */
    ALWAYS(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * OverrideMode Unspecified. Defaults to ALWAYS.
     * </pre>
     *
     * <code>URI_OVERRIDE_ENFORCE_MODE_UNSPECIFIED = 0;</code>
     */
    public static final int URI_OVERRIDE_ENFORCE_MODE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * In the IF_NOT_EXISTS mode, queue-level configuration is only
     * applied where task-level configuration does not exist.
     * </pre>
     *
     * <code>IF_NOT_EXISTS = 1;</code>
     */
    public static final int IF_NOT_EXISTS_VALUE = 1;
    /**
     *
     *
     * <pre>
     * In the ALWAYS mode, queue-level configuration overrides all
     * task-level configuration
     * </pre>
     *
     * <code>ALWAYS = 2;</code>
     */
    public static final int ALWAYS_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static UriOverrideEnforceMode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static UriOverrideEnforceMode forNumber(int value) {
      switch (value) {
        case 0:
          return URI_OVERRIDE_ENFORCE_MODE_UNSPECIFIED;
        case 1:
          return IF_NOT_EXISTS;
        case 2:
          return ALWAYS;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<UriOverrideEnforceMode>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<UriOverrideEnforceMode>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<UriOverrideEnforceMode>() {
              public UriOverrideEnforceMode findValueByNumber(int number) {
                return UriOverrideEnforceMode.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.tasks.v2beta3.UriOverride.getDescriptor().getEnumTypes().get(1);
    }

    private static final UriOverrideEnforceMode[] VALUES = values();

    public static UriOverrideEnforceMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private UriOverrideEnforceMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.tasks.v2beta3.UriOverride.UriOverrideEnforceMode)
  }

  private int bitField0_;
  public static final int SCHEME_FIELD_NUMBER = 1;
  private int scheme_ = 0;
  /**
   *
   *
   * <pre>
   * Scheme override.
   *
   * When specified, the task URI scheme is replaced by the provided value (HTTP
   * or HTTPS).
   * </pre>
   *
   * <code>optional .google.cloud.tasks.v2beta3.UriOverride.Scheme scheme = 1;</code>
   *
   * @return Whether the scheme field is set.
   */
  @java.lang.Override
  public boolean hasScheme() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Scheme override.
   *
   * When specified, the task URI scheme is replaced by the provided value (HTTP
   * or HTTPS).
   * </pre>
   *
   * <code>optional .google.cloud.tasks.v2beta3.UriOverride.Scheme scheme = 1;</code>
   *
   * @return The enum numeric value on the wire for scheme.
   */
  @java.lang.Override
  public int getSchemeValue() {
    return scheme_;
  }
  /**
   *
   *
   * <pre>
   * Scheme override.
   *
   * When specified, the task URI scheme is replaced by the provided value (HTTP
   * or HTTPS).
   * </pre>
   *
   * <code>optional .google.cloud.tasks.v2beta3.UriOverride.Scheme scheme = 1;</code>
   *
   * @return The scheme.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.UriOverride.Scheme getScheme() {
    com.google.cloud.tasks.v2beta3.UriOverride.Scheme result =
        com.google.cloud.tasks.v2beta3.UriOverride.Scheme.forNumber(scheme_);
    return result == null ? com.google.cloud.tasks.v2beta3.UriOverride.Scheme.UNRECOGNIZED : result;
  }

  public static final int HOST_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object host_ = "";
  /**
   *
   *
   * <pre>
   * Host override.
   *
   * When specified, replaces the host part of the task URL. For example,
   * if the task URL is "https://www.google.com," and host value is set to
   * "example.net", the overridden URI will be changed to "https://example.net."
   * Host value cannot be an empty string (INVALID_ARGUMENT).
   * </pre>
   *
   * <code>optional string host = 2;</code>
   *
   * @return Whether the host field is set.
   */
  @java.lang.Override
  public boolean hasHost() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Host override.
   *
   * When specified, replaces the host part of the task URL. For example,
   * if the task URL is "https://www.google.com," and host value is set to
   * "example.net", the overridden URI will be changed to "https://example.net."
   * Host value cannot be an empty string (INVALID_ARGUMENT).
   * </pre>
   *
   * <code>optional string host = 2;</code>
   *
   * @return The host.
   */
  @java.lang.Override
  public java.lang.String getHost() {
    java.lang.Object ref = host_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      host_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Host override.
   *
   * When specified, replaces the host part of the task URL. For example,
   * if the task URL is "https://www.google.com," and host value is set to
   * "example.net", the overridden URI will be changed to "https://example.net."
   * Host value cannot be an empty string (INVALID_ARGUMENT).
   * </pre>
   *
   * <code>optional string host = 2;</code>
   *
   * @return The bytes for host.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getHostBytes() {
    java.lang.Object ref = host_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      host_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PORT_FIELD_NUMBER = 3;
  private long port_ = 0L;
  /**
   *
   *
   * <pre>
   * Port override.
   *
   * When specified, replaces the port part of the task URI. For instance,
   * for a URI http://www.google.com/foo and port=123, the overridden URI
   * becomes http://www.google.com:123/foo. Note that the port value must be a
   * positive integer. Setting the port to 0 (Zero) clears the URI port.
   * </pre>
   *
   * <code>optional int64 port = 3;</code>
   *
   * @return Whether the port field is set.
   */
  @java.lang.Override
  public boolean hasPort() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Port override.
   *
   * When specified, replaces the port part of the task URI. For instance,
   * for a URI http://www.google.com/foo and port=123, the overridden URI
   * becomes http://www.google.com:123/foo. Note that the port value must be a
   * positive integer. Setting the port to 0 (Zero) clears the URI port.
   * </pre>
   *
   * <code>optional int64 port = 3;</code>
   *
   * @return The port.
   */
  @java.lang.Override
  public long getPort() {
    return port_;
  }

  public static final int PATH_OVERRIDE_FIELD_NUMBER = 4;
  private com.google.cloud.tasks.v2beta3.PathOverride pathOverride_;
  /**
   *
   *
   * <pre>
   * URI path.
   *
   * When specified, replaces the existing path of the task URL. Setting the
   * path value to an empty string clears the URI path segment.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.PathOverride path_override = 4;</code>
   *
   * @return Whether the pathOverride field is set.
   */
  @java.lang.Override
  public boolean hasPathOverride() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * URI path.
   *
   * When specified, replaces the existing path of the task URL. Setting the
   * path value to an empty string clears the URI path segment.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.PathOverride path_override = 4;</code>
   *
   * @return The pathOverride.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.PathOverride getPathOverride() {
    return pathOverride_ == null
        ? com.google.cloud.tasks.v2beta3.PathOverride.getDefaultInstance()
        : pathOverride_;
  }
  /**
   *
   *
   * <pre>
   * URI path.
   *
   * When specified, replaces the existing path of the task URL. Setting the
   * path value to an empty string clears the URI path segment.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.PathOverride path_override = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.PathOverrideOrBuilder getPathOverrideOrBuilder() {
    return pathOverride_ == null
        ? com.google.cloud.tasks.v2beta3.PathOverride.getDefaultInstance()
        : pathOverride_;
  }

  public static final int QUERY_OVERRIDE_FIELD_NUMBER = 5;
  private com.google.cloud.tasks.v2beta3.QueryOverride queryOverride_;
  /**
   *
   *
   * <pre>
   * URI Query.
   *
   * When specified, replaces the query part of the task URI. Setting the
   * query value to an empty string clears the URI query segment.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.QueryOverride query_override = 5;</code>
   *
   * @return Whether the queryOverride field is set.
   */
  @java.lang.Override
  public boolean hasQueryOverride() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   *
   *
   * <pre>
   * URI Query.
   *
   * When specified, replaces the query part of the task URI. Setting the
   * query value to an empty string clears the URI query segment.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.QueryOverride query_override = 5;</code>
   *
   * @return The queryOverride.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.QueryOverride getQueryOverride() {
    return queryOverride_ == null
        ? com.google.cloud.tasks.v2beta3.QueryOverride.getDefaultInstance()
        : queryOverride_;
  }
  /**
   *
   *
   * <pre>
   * URI Query.
   *
   * When specified, replaces the query part of the task URI. Setting the
   * query value to an empty string clears the URI query segment.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.QueryOverride query_override = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.QueryOverrideOrBuilder getQueryOverrideOrBuilder() {
    return queryOverride_ == null
        ? com.google.cloud.tasks.v2beta3.QueryOverride.getDefaultInstance()
        : queryOverride_;
  }

  public static final int URI_OVERRIDE_ENFORCE_MODE_FIELD_NUMBER = 6;
  private int uriOverrideEnforceMode_ = 0;
  /**
   *
   *
   * <pre>
   * URI Override Enforce Mode
   *
   * When specified, determines the Target UriOverride mode. If not specified,
   * it defaults to ALWAYS.
   * </pre>
   *
   * <code>
   * .google.cloud.tasks.v2beta3.UriOverride.UriOverrideEnforceMode uri_override_enforce_mode = 6;
   * </code>
   *
   * @return The enum numeric value on the wire for uriOverrideEnforceMode.
   */
  @java.lang.Override
  public int getUriOverrideEnforceModeValue() {
    return uriOverrideEnforceMode_;
  }
  /**
   *
   *
   * <pre>
   * URI Override Enforce Mode
   *
   * When specified, determines the Target UriOverride mode. If not specified,
   * it defaults to ALWAYS.
   * </pre>
   *
   * <code>
   * .google.cloud.tasks.v2beta3.UriOverride.UriOverrideEnforceMode uri_override_enforce_mode = 6;
   * </code>
   *
   * @return The uriOverrideEnforceMode.
   */
  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.UriOverride.UriOverrideEnforceMode
      getUriOverrideEnforceMode() {
    com.google.cloud.tasks.v2beta3.UriOverride.UriOverrideEnforceMode result =
        com.google.cloud.tasks.v2beta3.UriOverride.UriOverrideEnforceMode.forNumber(
            uriOverrideEnforceMode_);
    return result == null
        ? com.google.cloud.tasks.v2beta3.UriOverride.UriOverrideEnforceMode.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeEnum(1, scheme_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, host_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt64(3, port_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(4, getPathOverride());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(5, getQueryOverride());
    }
    if (uriOverrideEnforceMode_
        != com.google.cloud.tasks.v2beta3.UriOverride.UriOverrideEnforceMode
            .URI_OVERRIDE_ENFORCE_MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, uriOverrideEnforceMode_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, scheme_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, host_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, port_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPathOverride());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getQueryOverride());
    }
    if (uriOverrideEnforceMode_
        != com.google.cloud.tasks.v2beta3.UriOverride.UriOverrideEnforceMode
            .URI_OVERRIDE_ENFORCE_MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, uriOverrideEnforceMode_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.tasks.v2beta3.UriOverride)) {
      return super.equals(obj);
    }
    com.google.cloud.tasks.v2beta3.UriOverride other =
        (com.google.cloud.tasks.v2beta3.UriOverride) obj;

    if (hasScheme() != other.hasScheme()) return false;
    if (hasScheme()) {
      if (scheme_ != other.scheme_) return false;
    }
    if (hasHost() != other.hasHost()) return false;
    if (hasHost()) {
      if (!getHost().equals(other.getHost())) return false;
    }
    if (hasPort() != other.hasPort()) return false;
    if (hasPort()) {
      if (getPort() != other.getPort()) return false;
    }
    if (hasPathOverride() != other.hasPathOverride()) return false;
    if (hasPathOverride()) {
      if (!getPathOverride().equals(other.getPathOverride())) return false;
    }
    if (hasQueryOverride() != other.hasQueryOverride()) return false;
    if (hasQueryOverride()) {
      if (!getQueryOverride().equals(other.getQueryOverride())) return false;
    }
    if (uriOverrideEnforceMode_ != other.uriOverrideEnforceMode_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasScheme()) {
      hash = (37 * hash) + SCHEME_FIELD_NUMBER;
      hash = (53 * hash) + scheme_;
    }
    if (hasHost()) {
      hash = (37 * hash) + HOST_FIELD_NUMBER;
      hash = (53 * hash) + getHost().hashCode();
    }
    if (hasPort()) {
      hash = (37 * hash) + PORT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPort());
    }
    if (hasPathOverride()) {
      hash = (37 * hash) + PATH_OVERRIDE_FIELD_NUMBER;
      hash = (53 * hash) + getPathOverride().hashCode();
    }
    if (hasQueryOverride()) {
      hash = (37 * hash) + QUERY_OVERRIDE_FIELD_NUMBER;
      hash = (53 * hash) + getQueryOverride().hashCode();
    }
    hash = (37 * hash) + URI_OVERRIDE_ENFORCE_MODE_FIELD_NUMBER;
    hash = (53 * hash) + uriOverrideEnforceMode_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.tasks.v2beta3.UriOverride parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.UriOverride parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.UriOverride parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.UriOverride parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.UriOverride parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.UriOverride parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.UriOverride parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.UriOverride parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.UriOverride parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.UriOverride parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.UriOverride parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.UriOverride parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.tasks.v2beta3.UriOverride prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * URI Override.
   *
   * When specified, all the HTTP tasks inside the queue will be partially or
   * fully overridden depending on the configured values.
   * </pre>
   *
   * Protobuf type {@code google.cloud.tasks.v2beta3.UriOverride}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.tasks.v2beta3.UriOverride)
      com.google.cloud.tasks.v2beta3.UriOverrideOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.tasks.v2beta3.TargetProto
          .internal_static_google_cloud_tasks_v2beta3_UriOverride_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.tasks.v2beta3.TargetProto
          .internal_static_google_cloud_tasks_v2beta3_UriOverride_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.tasks.v2beta3.UriOverride.class,
              com.google.cloud.tasks.v2beta3.UriOverride.Builder.class);
    }

    // Construct using com.google.cloud.tasks.v2beta3.UriOverride.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPathOverrideFieldBuilder();
        getQueryOverrideFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      scheme_ = 0;
      host_ = "";
      port_ = 0L;
      pathOverride_ = null;
      if (pathOverrideBuilder_ != null) {
        pathOverrideBuilder_.dispose();
        pathOverrideBuilder_ = null;
      }
      queryOverride_ = null;
      if (queryOverrideBuilder_ != null) {
        queryOverrideBuilder_.dispose();
        queryOverrideBuilder_ = null;
      }
      uriOverrideEnforceMode_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.tasks.v2beta3.TargetProto
          .internal_static_google_cloud_tasks_v2beta3_UriOverride_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.UriOverride getDefaultInstanceForType() {
      return com.google.cloud.tasks.v2beta3.UriOverride.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.UriOverride build() {
      com.google.cloud.tasks.v2beta3.UriOverride result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.UriOverride buildPartial() {
      com.google.cloud.tasks.v2beta3.UriOverride result =
          new com.google.cloud.tasks.v2beta3.UriOverride(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.tasks.v2beta3.UriOverride result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.scheme_ = scheme_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.host_ = host_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.port_ = port_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.pathOverride_ =
            pathOverrideBuilder_ == null ? pathOverride_ : pathOverrideBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.queryOverride_ =
            queryOverrideBuilder_ == null ? queryOverride_ : queryOverrideBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.uriOverrideEnforceMode_ = uriOverrideEnforceMode_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.tasks.v2beta3.UriOverride) {
        return mergeFrom((com.google.cloud.tasks.v2beta3.UriOverride) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.tasks.v2beta3.UriOverride other) {
      if (other == com.google.cloud.tasks.v2beta3.UriOverride.getDefaultInstance()) return this;
      if (other.hasScheme()) {
        setScheme(other.getScheme());
      }
      if (other.hasHost()) {
        host_ = other.host_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasPort()) {
        setPort(other.getPort());
      }
      if (other.hasPathOverride()) {
        mergePathOverride(other.getPathOverride());
      }
      if (other.hasQueryOverride()) {
        mergeQueryOverride(other.getQueryOverride());
      }
      if (other.uriOverrideEnforceMode_ != 0) {
        setUriOverrideEnforceModeValue(other.getUriOverrideEnforceModeValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                scheme_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                host_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                port_ = input.readInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getPathOverrideFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getQueryOverrideFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 48:
              {
                uriOverrideEnforceMode_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int scheme_ = 0;
    /**
     *
     *
     * <pre>
     * Scheme override.
     *
     * When specified, the task URI scheme is replaced by the provided value (HTTP
     * or HTTPS).
     * </pre>
     *
     * <code>optional .google.cloud.tasks.v2beta3.UriOverride.Scheme scheme = 1;</code>
     *
     * @return Whether the scheme field is set.
     */
    @java.lang.Override
    public boolean hasScheme() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Scheme override.
     *
     * When specified, the task URI scheme is replaced by the provided value (HTTP
     * or HTTPS).
     * </pre>
     *
     * <code>optional .google.cloud.tasks.v2beta3.UriOverride.Scheme scheme = 1;</code>
     *
     * @return The enum numeric value on the wire for scheme.
     */
    @java.lang.Override
    public int getSchemeValue() {
      return scheme_;
    }
    /**
     *
     *
     * <pre>
     * Scheme override.
     *
     * When specified, the task URI scheme is replaced by the provided value (HTTP
     * or HTTPS).
     * </pre>
     *
     * <code>optional .google.cloud.tasks.v2beta3.UriOverride.Scheme scheme = 1;</code>
     *
     * @param value The enum numeric value on the wire for scheme to set.
     * @return This builder for chaining.
     */
    public Builder setSchemeValue(int value) {
      scheme_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Scheme override.
     *
     * When specified, the task URI scheme is replaced by the provided value (HTTP
     * or HTTPS).
     * </pre>
     *
     * <code>optional .google.cloud.tasks.v2beta3.UriOverride.Scheme scheme = 1;</code>
     *
     * @return The scheme.
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.UriOverride.Scheme getScheme() {
      com.google.cloud.tasks.v2beta3.UriOverride.Scheme result =
          com.google.cloud.tasks.v2beta3.UriOverride.Scheme.forNumber(scheme_);
      return result == null
          ? com.google.cloud.tasks.v2beta3.UriOverride.Scheme.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Scheme override.
     *
     * When specified, the task URI scheme is replaced by the provided value (HTTP
     * or HTTPS).
     * </pre>
     *
     * <code>optional .google.cloud.tasks.v2beta3.UriOverride.Scheme scheme = 1;</code>
     *
     * @param value The scheme to set.
     * @return This builder for chaining.
     */
    public Builder setScheme(com.google.cloud.tasks.v2beta3.UriOverride.Scheme value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      scheme_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Scheme override.
     *
     * When specified, the task URI scheme is replaced by the provided value (HTTP
     * or HTTPS).
     * </pre>
     *
     * <code>optional .google.cloud.tasks.v2beta3.UriOverride.Scheme scheme = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScheme() {
      bitField0_ = (bitField0_ & ~0x00000001);
      scheme_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object host_ = "";
    /**
     *
     *
     * <pre>
     * Host override.
     *
     * When specified, replaces the host part of the task URL. For example,
     * if the task URL is "https://www.google.com," and host value is set to
     * "example.net", the overridden URI will be changed to "https://example.net."
     * Host value cannot be an empty string (INVALID_ARGUMENT).
     * </pre>
     *
     * <code>optional string host = 2;</code>
     *
     * @return Whether the host field is set.
     */
    public boolean hasHost() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Host override.
     *
     * When specified, replaces the host part of the task URL. For example,
     * if the task URL is "https://www.google.com," and host value is set to
     * "example.net", the overridden URI will be changed to "https://example.net."
     * Host value cannot be an empty string (INVALID_ARGUMENT).
     * </pre>
     *
     * <code>optional string host = 2;</code>
     *
     * @return The host.
     */
    public java.lang.String getHost() {
      java.lang.Object ref = host_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        host_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Host override.
     *
     * When specified, replaces the host part of the task URL. For example,
     * if the task URL is "https://www.google.com," and host value is set to
     * "example.net", the overridden URI will be changed to "https://example.net."
     * Host value cannot be an empty string (INVALID_ARGUMENT).
     * </pre>
     *
     * <code>optional string host = 2;</code>
     *
     * @return The bytes for host.
     */
    public com.google.protobuf.ByteString getHostBytes() {
      java.lang.Object ref = host_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        host_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Host override.
     *
     * When specified, replaces the host part of the task URL. For example,
     * if the task URL is "https://www.google.com," and host value is set to
     * "example.net", the overridden URI will be changed to "https://example.net."
     * Host value cannot be an empty string (INVALID_ARGUMENT).
     * </pre>
     *
     * <code>optional string host = 2;</code>
     *
     * @param value The host to set.
     * @return This builder for chaining.
     */
    public Builder setHost(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      host_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Host override.
     *
     * When specified, replaces the host part of the task URL. For example,
     * if the task URL is "https://www.google.com," and host value is set to
     * "example.net", the overridden URI will be changed to "https://example.net."
     * Host value cannot be an empty string (INVALID_ARGUMENT).
     * </pre>
     *
     * <code>optional string host = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHost() {
      host_ = getDefaultInstance().getHost();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Host override.
     *
     * When specified, replaces the host part of the task URL. For example,
     * if the task URL is "https://www.google.com," and host value is set to
     * "example.net", the overridden URI will be changed to "https://example.net."
     * Host value cannot be an empty string (INVALID_ARGUMENT).
     * </pre>
     *
     * <code>optional string host = 2;</code>
     *
     * @param value The bytes for host to set.
     * @return This builder for chaining.
     */
    public Builder setHostBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      host_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private long port_;
    /**
     *
     *
     * <pre>
     * Port override.
     *
     * When specified, replaces the port part of the task URI. For instance,
     * for a URI http://www.google.com/foo and port=123, the overridden URI
     * becomes http://www.google.com:123/foo. Note that the port value must be a
     * positive integer. Setting the port to 0 (Zero) clears the URI port.
     * </pre>
     *
     * <code>optional int64 port = 3;</code>
     *
     * @return Whether the port field is set.
     */
    @java.lang.Override
    public boolean hasPort() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Port override.
     *
     * When specified, replaces the port part of the task URI. For instance,
     * for a URI http://www.google.com/foo and port=123, the overridden URI
     * becomes http://www.google.com:123/foo. Note that the port value must be a
     * positive integer. Setting the port to 0 (Zero) clears the URI port.
     * </pre>
     *
     * <code>optional int64 port = 3;</code>
     *
     * @return The port.
     */
    @java.lang.Override
    public long getPort() {
      return port_;
    }
    /**
     *
     *
     * <pre>
     * Port override.
     *
     * When specified, replaces the port part of the task URI. For instance,
     * for a URI http://www.google.com/foo and port=123, the overridden URI
     * becomes http://www.google.com:123/foo. Note that the port value must be a
     * positive integer. Setting the port to 0 (Zero) clears the URI port.
     * </pre>
     *
     * <code>optional int64 port = 3;</code>
     *
     * @param value The port to set.
     * @return This builder for chaining.
     */
    public Builder setPort(long value) {

      port_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Port override.
     *
     * When specified, replaces the port part of the task URI. For instance,
     * for a URI http://www.google.com/foo and port=123, the overridden URI
     * becomes http://www.google.com:123/foo. Note that the port value must be a
     * positive integer. Setting the port to 0 (Zero) clears the URI port.
     * </pre>
     *
     * <code>optional int64 port = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPort() {
      bitField0_ = (bitField0_ & ~0x00000004);
      port_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloud.tasks.v2beta3.PathOverride pathOverride_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.PathOverride,
            com.google.cloud.tasks.v2beta3.PathOverride.Builder,
            com.google.cloud.tasks.v2beta3.PathOverrideOrBuilder>
        pathOverrideBuilder_;
    /**
     *
     *
     * <pre>
     * URI path.
     *
     * When specified, replaces the existing path of the task URL. Setting the
     * path value to an empty string clears the URI path segment.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.PathOverride path_override = 4;</code>
     *
     * @return Whether the pathOverride field is set.
     */
    public boolean hasPathOverride() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * URI path.
     *
     * When specified, replaces the existing path of the task URL. Setting the
     * path value to an empty string clears the URI path segment.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.PathOverride path_override = 4;</code>
     *
     * @return The pathOverride.
     */
    public com.google.cloud.tasks.v2beta3.PathOverride getPathOverride() {
      if (pathOverrideBuilder_ == null) {
        return pathOverride_ == null
            ? com.google.cloud.tasks.v2beta3.PathOverride.getDefaultInstance()
            : pathOverride_;
      } else {
        return pathOverrideBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * URI path.
     *
     * When specified, replaces the existing path of the task URL. Setting the
     * path value to an empty string clears the URI path segment.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.PathOverride path_override = 4;</code>
     */
    public Builder setPathOverride(com.google.cloud.tasks.v2beta3.PathOverride value) {
      if (pathOverrideBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pathOverride_ = value;
      } else {
        pathOverrideBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI path.
     *
     * When specified, replaces the existing path of the task URL. Setting the
     * path value to an empty string clears the URI path segment.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.PathOverride path_override = 4;</code>
     */
    public Builder setPathOverride(
        com.google.cloud.tasks.v2beta3.PathOverride.Builder builderForValue) {
      if (pathOverrideBuilder_ == null) {
        pathOverride_ = builderForValue.build();
      } else {
        pathOverrideBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI path.
     *
     * When specified, replaces the existing path of the task URL. Setting the
     * path value to an empty string clears the URI path segment.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.PathOverride path_override = 4;</code>
     */
    public Builder mergePathOverride(com.google.cloud.tasks.v2beta3.PathOverride value) {
      if (pathOverrideBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && pathOverride_ != null
            && pathOverride_ != com.google.cloud.tasks.v2beta3.PathOverride.getDefaultInstance()) {
          getPathOverrideBuilder().mergeFrom(value);
        } else {
          pathOverride_ = value;
        }
      } else {
        pathOverrideBuilder_.mergeFrom(value);
      }
      if (pathOverride_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI path.
     *
     * When specified, replaces the existing path of the task URL. Setting the
     * path value to an empty string clears the URI path segment.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.PathOverride path_override = 4;</code>
     */
    public Builder clearPathOverride() {
      bitField0_ = (bitField0_ & ~0x00000008);
      pathOverride_ = null;
      if (pathOverrideBuilder_ != null) {
        pathOverrideBuilder_.dispose();
        pathOverrideBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI path.
     *
     * When specified, replaces the existing path of the task URL. Setting the
     * path value to an empty string clears the URI path segment.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.PathOverride path_override = 4;</code>
     */
    public com.google.cloud.tasks.v2beta3.PathOverride.Builder getPathOverrideBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getPathOverrideFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * URI path.
     *
     * When specified, replaces the existing path of the task URL. Setting the
     * path value to an empty string clears the URI path segment.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.PathOverride path_override = 4;</code>
     */
    public com.google.cloud.tasks.v2beta3.PathOverrideOrBuilder getPathOverrideOrBuilder() {
      if (pathOverrideBuilder_ != null) {
        return pathOverrideBuilder_.getMessageOrBuilder();
      } else {
        return pathOverride_ == null
            ? com.google.cloud.tasks.v2beta3.PathOverride.getDefaultInstance()
            : pathOverride_;
      }
    }
    /**
     *
     *
     * <pre>
     * URI path.
     *
     * When specified, replaces the existing path of the task URL. Setting the
     * path value to an empty string clears the URI path segment.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.PathOverride path_override = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.PathOverride,
            com.google.cloud.tasks.v2beta3.PathOverride.Builder,
            com.google.cloud.tasks.v2beta3.PathOverrideOrBuilder>
        getPathOverrideFieldBuilder() {
      if (pathOverrideBuilder_ == null) {
        pathOverrideBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2beta3.PathOverride,
                com.google.cloud.tasks.v2beta3.PathOverride.Builder,
                com.google.cloud.tasks.v2beta3.PathOverrideOrBuilder>(
                getPathOverride(), getParentForChildren(), isClean());
        pathOverride_ = null;
      }
      return pathOverrideBuilder_;
    }

    private com.google.cloud.tasks.v2beta3.QueryOverride queryOverride_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.QueryOverride,
            com.google.cloud.tasks.v2beta3.QueryOverride.Builder,
            com.google.cloud.tasks.v2beta3.QueryOverrideOrBuilder>
        queryOverrideBuilder_;
    /**
     *
     *
     * <pre>
     * URI Query.
     *
     * When specified, replaces the query part of the task URI. Setting the
     * query value to an empty string clears the URI query segment.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.QueryOverride query_override = 5;</code>
     *
     * @return Whether the queryOverride field is set.
     */
    public boolean hasQueryOverride() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * URI Query.
     *
     * When specified, replaces the query part of the task URI. Setting the
     * query value to an empty string clears the URI query segment.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.QueryOverride query_override = 5;</code>
     *
     * @return The queryOverride.
     */
    public com.google.cloud.tasks.v2beta3.QueryOverride getQueryOverride() {
      if (queryOverrideBuilder_ == null) {
        return queryOverride_ == null
            ? com.google.cloud.tasks.v2beta3.QueryOverride.getDefaultInstance()
            : queryOverride_;
      } else {
        return queryOverrideBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * URI Query.
     *
     * When specified, replaces the query part of the task URI. Setting the
     * query value to an empty string clears the URI query segment.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.QueryOverride query_override = 5;</code>
     */
    public Builder setQueryOverride(com.google.cloud.tasks.v2beta3.QueryOverride value) {
      if (queryOverrideBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryOverride_ = value;
      } else {
        queryOverrideBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI Query.
     *
     * When specified, replaces the query part of the task URI. Setting the
     * query value to an empty string clears the URI query segment.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.QueryOverride query_override = 5;</code>
     */
    public Builder setQueryOverride(
        com.google.cloud.tasks.v2beta3.QueryOverride.Builder builderForValue) {
      if (queryOverrideBuilder_ == null) {
        queryOverride_ = builderForValue.build();
      } else {
        queryOverrideBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI Query.
     *
     * When specified, replaces the query part of the task URI. Setting the
     * query value to an empty string clears the URI query segment.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.QueryOverride query_override = 5;</code>
     */
    public Builder mergeQueryOverride(com.google.cloud.tasks.v2beta3.QueryOverride value) {
      if (queryOverrideBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && queryOverride_ != null
            && queryOverride_
                != com.google.cloud.tasks.v2beta3.QueryOverride.getDefaultInstance()) {
          getQueryOverrideBuilder().mergeFrom(value);
        } else {
          queryOverride_ = value;
        }
      } else {
        queryOverrideBuilder_.mergeFrom(value);
      }
      if (queryOverride_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI Query.
     *
     * When specified, replaces the query part of the task URI. Setting the
     * query value to an empty string clears the URI query segment.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.QueryOverride query_override = 5;</code>
     */
    public Builder clearQueryOverride() {
      bitField0_ = (bitField0_ & ~0x00000010);
      queryOverride_ = null;
      if (queryOverrideBuilder_ != null) {
        queryOverrideBuilder_.dispose();
        queryOverrideBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI Query.
     *
     * When specified, replaces the query part of the task URI. Setting the
     * query value to an empty string clears the URI query segment.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.QueryOverride query_override = 5;</code>
     */
    public com.google.cloud.tasks.v2beta3.QueryOverride.Builder getQueryOverrideBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getQueryOverrideFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * URI Query.
     *
     * When specified, replaces the query part of the task URI. Setting the
     * query value to an empty string clears the URI query segment.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.QueryOverride query_override = 5;</code>
     */
    public com.google.cloud.tasks.v2beta3.QueryOverrideOrBuilder getQueryOverrideOrBuilder() {
      if (queryOverrideBuilder_ != null) {
        return queryOverrideBuilder_.getMessageOrBuilder();
      } else {
        return queryOverride_ == null
            ? com.google.cloud.tasks.v2beta3.QueryOverride.getDefaultInstance()
            : queryOverride_;
      }
    }
    /**
     *
     *
     * <pre>
     * URI Query.
     *
     * When specified, replaces the query part of the task URI. Setting the
     * query value to an empty string clears the URI query segment.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.QueryOverride query_override = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.QueryOverride,
            com.google.cloud.tasks.v2beta3.QueryOverride.Builder,
            com.google.cloud.tasks.v2beta3.QueryOverrideOrBuilder>
        getQueryOverrideFieldBuilder() {
      if (queryOverrideBuilder_ == null) {
        queryOverrideBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2beta3.QueryOverride,
                com.google.cloud.tasks.v2beta3.QueryOverride.Builder,
                com.google.cloud.tasks.v2beta3.QueryOverrideOrBuilder>(
                getQueryOverride(), getParentForChildren(), isClean());
        queryOverride_ = null;
      }
      return queryOverrideBuilder_;
    }

    private int uriOverrideEnforceMode_ = 0;
    /**
     *
     *
     * <pre>
     * URI Override Enforce Mode
     *
     * When specified, determines the Target UriOverride mode. If not specified,
     * it defaults to ALWAYS.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta3.UriOverride.UriOverrideEnforceMode uri_override_enforce_mode = 6;
     * </code>
     *
     * @return The enum numeric value on the wire for uriOverrideEnforceMode.
     */
    @java.lang.Override
    public int getUriOverrideEnforceModeValue() {
      return uriOverrideEnforceMode_;
    }
    /**
     *
     *
     * <pre>
     * URI Override Enforce Mode
     *
     * When specified, determines the Target UriOverride mode. If not specified,
     * it defaults to ALWAYS.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta3.UriOverride.UriOverrideEnforceMode uri_override_enforce_mode = 6;
     * </code>
     *
     * @param value The enum numeric value on the wire for uriOverrideEnforceMode to set.
     * @return This builder for chaining.
     */
    public Builder setUriOverrideEnforceModeValue(int value) {
      uriOverrideEnforceMode_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI Override Enforce Mode
     *
     * When specified, determines the Target UriOverride mode. If not specified,
     * it defaults to ALWAYS.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta3.UriOverride.UriOverrideEnforceMode uri_override_enforce_mode = 6;
     * </code>
     *
     * @return The uriOverrideEnforceMode.
     */
    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.UriOverride.UriOverrideEnforceMode
        getUriOverrideEnforceMode() {
      com.google.cloud.tasks.v2beta3.UriOverride.UriOverrideEnforceMode result =
          com.google.cloud.tasks.v2beta3.UriOverride.UriOverrideEnforceMode.forNumber(
              uriOverrideEnforceMode_);
      return result == null
          ? com.google.cloud.tasks.v2beta3.UriOverride.UriOverrideEnforceMode.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * URI Override Enforce Mode
     *
     * When specified, determines the Target UriOverride mode. If not specified,
     * it defaults to ALWAYS.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta3.UriOverride.UriOverrideEnforceMode uri_override_enforce_mode = 6;
     * </code>
     *
     * @param value The uriOverrideEnforceMode to set.
     * @return This builder for chaining.
     */
    public Builder setUriOverrideEnforceMode(
        com.google.cloud.tasks.v2beta3.UriOverride.UriOverrideEnforceMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      uriOverrideEnforceMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URI Override Enforce Mode
     *
     * When specified, determines the Target UriOverride mode. If not specified,
     * it defaults to ALWAYS.
     * </pre>
     *
     * <code>
     * .google.cloud.tasks.v2beta3.UriOverride.UriOverrideEnforceMode uri_override_enforce_mode = 6;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUriOverrideEnforceMode() {
      bitField0_ = (bitField0_ & ~0x00000020);
      uriOverrideEnforceMode_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.tasks.v2beta3.UriOverride)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.tasks.v2beta3.UriOverride)
  private static final com.google.cloud.tasks.v2beta3.UriOverride DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.tasks.v2beta3.UriOverride();
  }

  public static com.google.cloud.tasks.v2beta3.UriOverride getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UriOverride> PARSER =
      new com.google.protobuf.AbstractParser<UriOverride>() {
        @java.lang.Override
        public UriOverride parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UriOverride> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UriOverride> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.UriOverride getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
