/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/tasks/v2beta3/target.proto

package com.google.cloud.tasks.v2beta3;

/**
 *
 *
 * <pre>
 * HTTP request.
 * The task will be pushed to the worker as an HTTP request. If the worker
 * or the redirected worker acknowledges the task by returning a successful HTTP
 * response code ([`200` - `299`]), the task will be removed from the queue. If
 * any other HTTP response code is returned or no response is received, the
 * task will be retried according to the following:
 * * User-specified throttling: [retry configuration][google.cloud.tasks.v2beta3.Queue.retry_config],
 *   [rate limits][google.cloud.tasks.v2beta3.Queue.rate_limits], and the [queue's state][google.cloud.tasks.v2beta3.Queue.state].
 * * System throttling: To prevent the worker from overloading, Cloud Tasks may
 *   temporarily reduce the queue's effective rate. User-specified settings
 *   will not be changed.
 *  System throttling happens because:
 *   * Cloud Tasks backs off on all errors. Normally the backoff specified in
 *     [rate limits][google.cloud.tasks.v2beta3.Queue.rate_limits] will be used. But if the worker returns
 *     `429` (Too Many Requests), `503` (Service Unavailable), or the rate of
 *     errors is high, Cloud Tasks will use a higher backoff rate. The retry
 *     specified in the `Retry-After` HTTP response header is considered.
 *   * To prevent traffic spikes and to smooth sudden increases in traffic,
 *     dispatches ramp up slowly when the queue is newly created or idle and
 *     if large numbers of tasks suddenly become available to dispatch (due to
 *     spikes in create task rates, the queue being unpaused, or many tasks
 *     that are scheduled at the same time).
 * </pre>
 *
 * Protobuf type {@code google.cloud.tasks.v2beta3.HttpRequest}
 */
public final class HttpRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.tasks.v2beta3.HttpRequest)
    HttpRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use HttpRequest.newBuilder() to construct.
  private HttpRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private HttpRequest() {
    url_ = "";
    httpMethod_ = 0;
    body_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new HttpRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private HttpRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              url_ = s;
              break;
            }
          case 16:
            {
              int rawValue = input.readEnum();

              httpMethod_ = rawValue;
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                headers_ =
                    com.google.protobuf.MapField.newMapField(
                        HeadersDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000001;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> headers__ =
                  input.readMessage(
                      HeadersDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              headers_.getMutableMap().put(headers__.getKey(), headers__.getValue());
              break;
            }
          case 34:
            {
              body_ = input.readBytes();
              break;
            }
          case 42:
            {
              com.google.cloud.tasks.v2beta3.OAuthToken.Builder subBuilder = null;
              if (authorizationHeaderCase_ == 5) {
                subBuilder =
                    ((com.google.cloud.tasks.v2beta3.OAuthToken) authorizationHeader_).toBuilder();
              }
              authorizationHeader_ =
                  input.readMessage(
                      com.google.cloud.tasks.v2beta3.OAuthToken.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.tasks.v2beta3.OAuthToken) authorizationHeader_);
                authorizationHeader_ = subBuilder.buildPartial();
              }
              authorizationHeaderCase_ = 5;
              break;
            }
          case 50:
            {
              com.google.cloud.tasks.v2beta3.OidcToken.Builder subBuilder = null;
              if (authorizationHeaderCase_ == 6) {
                subBuilder =
                    ((com.google.cloud.tasks.v2beta3.OidcToken) authorizationHeader_).toBuilder();
              }
              authorizationHeader_ =
                  input.readMessage(
                      com.google.cloud.tasks.v2beta3.OidcToken.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(
                    (com.google.cloud.tasks.v2beta3.OidcToken) authorizationHeader_);
                authorizationHeader_ = subBuilder.buildPartial();
              }
              authorizationHeaderCase_ = 6;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.tasks.v2beta3.TargetProto
        .internal_static_google_cloud_tasks_v2beta3_HttpRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 3:
        return internalGetHeaders();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.tasks.v2beta3.TargetProto
        .internal_static_google_cloud_tasks_v2beta3_HttpRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.tasks.v2beta3.HttpRequest.class,
            com.google.cloud.tasks.v2beta3.HttpRequest.Builder.class);
  }

  private int authorizationHeaderCase_ = 0;
  private java.lang.Object authorizationHeader_;

  public enum AuthorizationHeaderCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    OAUTH_TOKEN(5),
    OIDC_TOKEN(6),
    AUTHORIZATIONHEADER_NOT_SET(0);
    private final int value;

    private AuthorizationHeaderCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AuthorizationHeaderCase valueOf(int value) {
      return forNumber(value);
    }

    public static AuthorizationHeaderCase forNumber(int value) {
      switch (value) {
        case 5:
          return OAUTH_TOKEN;
        case 6:
          return OIDC_TOKEN;
        case 0:
          return AUTHORIZATIONHEADER_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AuthorizationHeaderCase getAuthorizationHeaderCase() {
    return AuthorizationHeaderCase.forNumber(authorizationHeaderCase_);
  }

  public static final int URL_FIELD_NUMBER = 1;
  private volatile java.lang.Object url_;
  /**
   *
   *
   * <pre>
   * Required. The full url path that the request will be sent to.
   * This string must begin with either "http://" or "https://". Some examples
   * are: `http://acme.com` and `https://acme.com/sales:8080`. Cloud Tasks will
   * encode some characters for safety and compatibility. The maximum allowed
   * URL length is 2083 characters after encoding.
   * The `Location` header response from a redirect response [`300` - `399`]
   * may be followed. The redirect is not counted as a separate attempt.
   * </pre>
   *
   * <code>string url = 1;</code>
   *
   * @return The url.
   */
  public java.lang.String getUrl() {
    java.lang.Object ref = url_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      url_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The full url path that the request will be sent to.
   * This string must begin with either "http://" or "https://". Some examples
   * are: `http://acme.com` and `https://acme.com/sales:8080`. Cloud Tasks will
   * encode some characters for safety and compatibility. The maximum allowed
   * URL length is 2083 characters after encoding.
   * The `Location` header response from a redirect response [`300` - `399`]
   * may be followed. The redirect is not counted as a separate attempt.
   * </pre>
   *
   * <code>string url = 1;</code>
   *
   * @return The bytes for url.
   */
  public com.google.protobuf.ByteString getUrlBytes() {
    java.lang.Object ref = url_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      url_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HTTP_METHOD_FIELD_NUMBER = 2;
  private int httpMethod_;
  /**
   *
   *
   * <pre>
   * The HTTP method to use for the request. The default is POST.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.HttpMethod http_method = 2;</code>
   *
   * @return The enum numeric value on the wire for httpMethod.
   */
  public int getHttpMethodValue() {
    return httpMethod_;
  }
  /**
   *
   *
   * <pre>
   * The HTTP method to use for the request. The default is POST.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.HttpMethod http_method = 2;</code>
   *
   * @return The httpMethod.
   */
  public com.google.cloud.tasks.v2beta3.HttpMethod getHttpMethod() {
    @SuppressWarnings("deprecation")
    com.google.cloud.tasks.v2beta3.HttpMethod result =
        com.google.cloud.tasks.v2beta3.HttpMethod.valueOf(httpMethod_);
    return result == null ? com.google.cloud.tasks.v2beta3.HttpMethod.UNRECOGNIZED : result;
  }

  public static final int HEADERS_FIELD_NUMBER = 3;

  private static final class HeadersDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.tasks.v2beta3.TargetProto
                .internal_static_google_cloud_tasks_v2beta3_HttpRequest_HeadersEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> headers_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetHeaders() {
    if (headers_ == null) {
      return com.google.protobuf.MapField.emptyMapField(HeadersDefaultEntryHolder.defaultEntry);
    }
    return headers_;
  }

  public int getHeadersCount() {
    return internalGetHeaders().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * HTTP request headers.
   * This map contains the header field names and values.
   * Headers can be set when the
   * [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
   * These headers represent a subset of the headers that will accompany the
   * task's HTTP request. Some HTTP request headers will be ignored or replaced.
   * A partial list of headers that will be ignored or replaced is:
   * * Host: This will be computed by Cloud Tasks and derived from
   *   [HttpRequest.url][google.cloud.tasks.v2beta3.HttpRequest.url].
   * * Content-Length: This will be computed by Cloud Tasks.
   * * User-Agent: This will be set to `"Google-Cloud-Tasks"`.
   * * X-Google-*: Google use only.
   * * X-AppEngine-*: Google use only.
   * `Content-Type` won't be set by Cloud Tasks. You can explicitly set
   * `Content-Type` to a media type when the
   *  [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
   *  For example, `Content-Type` can be set to `"application/octet-stream"` or
   *  `"application/json"`.
   * Headers which can have multiple values (according to RFC2616) can be
   * specified using comma-separated values.
   * The size of the headers must be less than 80KB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; headers = 3;</code>
   */
  public boolean containsHeaders(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    return internalGetHeaders().getMap().containsKey(key);
  }
  /** Use {@link #getHeadersMap()} instead. */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getHeaders() {
    return getHeadersMap();
  }
  /**
   *
   *
   * <pre>
   * HTTP request headers.
   * This map contains the header field names and values.
   * Headers can be set when the
   * [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
   * These headers represent a subset of the headers that will accompany the
   * task's HTTP request. Some HTTP request headers will be ignored or replaced.
   * A partial list of headers that will be ignored or replaced is:
   * * Host: This will be computed by Cloud Tasks and derived from
   *   [HttpRequest.url][google.cloud.tasks.v2beta3.HttpRequest.url].
   * * Content-Length: This will be computed by Cloud Tasks.
   * * User-Agent: This will be set to `"Google-Cloud-Tasks"`.
   * * X-Google-*: Google use only.
   * * X-AppEngine-*: Google use only.
   * `Content-Type` won't be set by Cloud Tasks. You can explicitly set
   * `Content-Type` to a media type when the
   *  [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
   *  For example, `Content-Type` can be set to `"application/octet-stream"` or
   *  `"application/json"`.
   * Headers which can have multiple values (according to RFC2616) can be
   * specified using comma-separated values.
   * The size of the headers must be less than 80KB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; headers = 3;</code>
   */
  public java.util.Map<java.lang.String, java.lang.String> getHeadersMap() {
    return internalGetHeaders().getMap();
  }
  /**
   *
   *
   * <pre>
   * HTTP request headers.
   * This map contains the header field names and values.
   * Headers can be set when the
   * [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
   * These headers represent a subset of the headers that will accompany the
   * task's HTTP request. Some HTTP request headers will be ignored or replaced.
   * A partial list of headers that will be ignored or replaced is:
   * * Host: This will be computed by Cloud Tasks and derived from
   *   [HttpRequest.url][google.cloud.tasks.v2beta3.HttpRequest.url].
   * * Content-Length: This will be computed by Cloud Tasks.
   * * User-Agent: This will be set to `"Google-Cloud-Tasks"`.
   * * X-Google-*: Google use only.
   * * X-AppEngine-*: Google use only.
   * `Content-Type` won't be set by Cloud Tasks. You can explicitly set
   * `Content-Type` to a media type when the
   *  [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
   *  For example, `Content-Type` can be set to `"application/octet-stream"` or
   *  `"application/json"`.
   * Headers which can have multiple values (according to RFC2616) can be
   * specified using comma-separated values.
   * The size of the headers must be less than 80KB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; headers = 3;</code>
   */
  public java.lang.String getHeadersOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * HTTP request headers.
   * This map contains the header field names and values.
   * Headers can be set when the
   * [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
   * These headers represent a subset of the headers that will accompany the
   * task's HTTP request. Some HTTP request headers will be ignored or replaced.
   * A partial list of headers that will be ignored or replaced is:
   * * Host: This will be computed by Cloud Tasks and derived from
   *   [HttpRequest.url][google.cloud.tasks.v2beta3.HttpRequest.url].
   * * Content-Length: This will be computed by Cloud Tasks.
   * * User-Agent: This will be set to `"Google-Cloud-Tasks"`.
   * * X-Google-*: Google use only.
   * * X-AppEngine-*: Google use only.
   * `Content-Type` won't be set by Cloud Tasks. You can explicitly set
   * `Content-Type` to a media type when the
   *  [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
   *  For example, `Content-Type` can be set to `"application/octet-stream"` or
   *  `"application/json"`.
   * Headers which can have multiple values (according to RFC2616) can be
   * specified using comma-separated values.
   * The size of the headers must be less than 80KB.
   * </pre>
   *
   * <code>map&lt;string, string&gt; headers = 3;</code>
   */
  public java.lang.String getHeadersOrThrow(java.lang.String key) {
    if (key == null) {
      throw new java.lang.NullPointerException();
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int BODY_FIELD_NUMBER = 4;
  private com.google.protobuf.ByteString body_;
  /**
   *
   *
   * <pre>
   * HTTP request body.
   * A request body is allowed only if the
   * [HTTP method][google.cloud.tasks.v2beta3.HttpRequest.http_method] is POST, PUT, or PATCH. It is an
   * error to set body on a task with an incompatible [HttpMethod][google.cloud.tasks.v2beta3.HttpMethod].
   * </pre>
   *
   * <code>bytes body = 4;</code>
   *
   * @return The body.
   */
  public com.google.protobuf.ByteString getBody() {
    return body_;
  }

  public static final int OAUTH_TOKEN_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * If specified, an
   * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
   * will be generated and attached as an `Authorization` header in the HTTP
   * request.
   * This type of authorization should generally only be used when calling
   * Google APIs hosted on *.googleapis.com.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.OAuthToken oauth_token = 5;</code>
   *
   * @return Whether the oauthToken field is set.
   */
  public boolean hasOauthToken() {
    return authorizationHeaderCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * If specified, an
   * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
   * will be generated and attached as an `Authorization` header in the HTTP
   * request.
   * This type of authorization should generally only be used when calling
   * Google APIs hosted on *.googleapis.com.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.OAuthToken oauth_token = 5;</code>
   *
   * @return The oauthToken.
   */
  public com.google.cloud.tasks.v2beta3.OAuthToken getOauthToken() {
    if (authorizationHeaderCase_ == 5) {
      return (com.google.cloud.tasks.v2beta3.OAuthToken) authorizationHeader_;
    }
    return com.google.cloud.tasks.v2beta3.OAuthToken.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * If specified, an
   * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
   * will be generated and attached as an `Authorization` header in the HTTP
   * request.
   * This type of authorization should generally only be used when calling
   * Google APIs hosted on *.googleapis.com.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.OAuthToken oauth_token = 5;</code>
   */
  public com.google.cloud.tasks.v2beta3.OAuthTokenOrBuilder getOauthTokenOrBuilder() {
    if (authorizationHeaderCase_ == 5) {
      return (com.google.cloud.tasks.v2beta3.OAuthToken) authorizationHeader_;
    }
    return com.google.cloud.tasks.v2beta3.OAuthToken.getDefaultInstance();
  }

  public static final int OIDC_TOKEN_FIELD_NUMBER = 6;
  /**
   *
   *
   * <pre>
   * If specified, an
   * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
   * token will be generated and attached as an `Authorization` header in the
   * HTTP request.
   * This type of authorization can be used for many scenarios, including
   * calling Cloud Run, or endpoints where you intend to validate the token
   * yourself.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.OidcToken oidc_token = 6;</code>
   *
   * @return Whether the oidcToken field is set.
   */
  public boolean hasOidcToken() {
    return authorizationHeaderCase_ == 6;
  }
  /**
   *
   *
   * <pre>
   * If specified, an
   * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
   * token will be generated and attached as an `Authorization` header in the
   * HTTP request.
   * This type of authorization can be used for many scenarios, including
   * calling Cloud Run, or endpoints where you intend to validate the token
   * yourself.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.OidcToken oidc_token = 6;</code>
   *
   * @return The oidcToken.
   */
  public com.google.cloud.tasks.v2beta3.OidcToken getOidcToken() {
    if (authorizationHeaderCase_ == 6) {
      return (com.google.cloud.tasks.v2beta3.OidcToken) authorizationHeader_;
    }
    return com.google.cloud.tasks.v2beta3.OidcToken.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * If specified, an
   * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
   * token will be generated and attached as an `Authorization` header in the
   * HTTP request.
   * This type of authorization can be used for many scenarios, including
   * calling Cloud Run, or endpoints where you intend to validate the token
   * yourself.
   * </pre>
   *
   * <code>.google.cloud.tasks.v2beta3.OidcToken oidc_token = 6;</code>
   */
  public com.google.cloud.tasks.v2beta3.OidcTokenOrBuilder getOidcTokenOrBuilder() {
    if (authorizationHeaderCase_ == 6) {
      return (com.google.cloud.tasks.v2beta3.OidcToken) authorizationHeader_;
    }
    return com.google.cloud.tasks.v2beta3.OidcToken.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getUrlBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, url_);
    }
    if (httpMethod_
        != com.google.cloud.tasks.v2beta3.HttpMethod.HTTP_METHOD_UNSPECIFIED.getNumber()) {
      output.writeEnum(2, httpMethod_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetHeaders(), HeadersDefaultEntryHolder.defaultEntry, 3);
    if (!body_.isEmpty()) {
      output.writeBytes(4, body_);
    }
    if (authorizationHeaderCase_ == 5) {
      output.writeMessage(5, (com.google.cloud.tasks.v2beta3.OAuthToken) authorizationHeader_);
    }
    if (authorizationHeaderCase_ == 6) {
      output.writeMessage(6, (com.google.cloud.tasks.v2beta3.OidcToken) authorizationHeader_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getUrlBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, url_);
    }
    if (httpMethod_
        != com.google.cloud.tasks.v2beta3.HttpMethod.HTTP_METHOD_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, httpMethod_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetHeaders().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> headers__ =
          HeadersDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, headers__);
    }
    if (!body_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(4, body_);
    }
    if (authorizationHeaderCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.cloud.tasks.v2beta3.OAuthToken) authorizationHeader_);
    }
    if (authorizationHeaderCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6, (com.google.cloud.tasks.v2beta3.OidcToken) authorizationHeader_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.tasks.v2beta3.HttpRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.tasks.v2beta3.HttpRequest other =
        (com.google.cloud.tasks.v2beta3.HttpRequest) obj;

    if (!getUrl().equals(other.getUrl())) return false;
    if (httpMethod_ != other.httpMethod_) return false;
    if (!internalGetHeaders().equals(other.internalGetHeaders())) return false;
    if (!getBody().equals(other.getBody())) return false;
    if (!getAuthorizationHeaderCase().equals(other.getAuthorizationHeaderCase())) return false;
    switch (authorizationHeaderCase_) {
      case 5:
        if (!getOauthToken().equals(other.getOauthToken())) return false;
        break;
      case 6:
        if (!getOidcToken().equals(other.getOidcToken())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + URL_FIELD_NUMBER;
    hash = (53 * hash) + getUrl().hashCode();
    hash = (37 * hash) + HTTP_METHOD_FIELD_NUMBER;
    hash = (53 * hash) + httpMethod_;
    if (!internalGetHeaders().getMap().isEmpty()) {
      hash = (37 * hash) + HEADERS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetHeaders().hashCode();
    }
    hash = (37 * hash) + BODY_FIELD_NUMBER;
    hash = (53 * hash) + getBody().hashCode();
    switch (authorizationHeaderCase_) {
      case 5:
        hash = (37 * hash) + OAUTH_TOKEN_FIELD_NUMBER;
        hash = (53 * hash) + getOauthToken().hashCode();
        break;
      case 6:
        hash = (37 * hash) + OIDC_TOKEN_FIELD_NUMBER;
        hash = (53 * hash) + getOidcToken().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.tasks.v2beta3.HttpRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.HttpRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.HttpRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.HttpRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.HttpRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.HttpRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.HttpRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.HttpRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.HttpRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.HttpRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.HttpRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.HttpRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.tasks.v2beta3.HttpRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * HTTP request.
   * The task will be pushed to the worker as an HTTP request. If the worker
   * or the redirected worker acknowledges the task by returning a successful HTTP
   * response code ([`200` - `299`]), the task will be removed from the queue. If
   * any other HTTP response code is returned or no response is received, the
   * task will be retried according to the following:
   * * User-specified throttling: [retry configuration][google.cloud.tasks.v2beta3.Queue.retry_config],
   *   [rate limits][google.cloud.tasks.v2beta3.Queue.rate_limits], and the [queue's state][google.cloud.tasks.v2beta3.Queue.state].
   * * System throttling: To prevent the worker from overloading, Cloud Tasks may
   *   temporarily reduce the queue's effective rate. User-specified settings
   *   will not be changed.
   *  System throttling happens because:
   *   * Cloud Tasks backs off on all errors. Normally the backoff specified in
   *     [rate limits][google.cloud.tasks.v2beta3.Queue.rate_limits] will be used. But if the worker returns
   *     `429` (Too Many Requests), `503` (Service Unavailable), or the rate of
   *     errors is high, Cloud Tasks will use a higher backoff rate. The retry
   *     specified in the `Retry-After` HTTP response header is considered.
   *   * To prevent traffic spikes and to smooth sudden increases in traffic,
   *     dispatches ramp up slowly when the queue is newly created or idle and
   *     if large numbers of tasks suddenly become available to dispatch (due to
   *     spikes in create task rates, the queue being unpaused, or many tasks
   *     that are scheduled at the same time).
   * </pre>
   *
   * Protobuf type {@code google.cloud.tasks.v2beta3.HttpRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.tasks.v2beta3.HttpRequest)
      com.google.cloud.tasks.v2beta3.HttpRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.tasks.v2beta3.TargetProto
          .internal_static_google_cloud_tasks_v2beta3_HttpRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetHeaders();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 3:
          return internalGetMutableHeaders();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.tasks.v2beta3.TargetProto
          .internal_static_google_cloud_tasks_v2beta3_HttpRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.tasks.v2beta3.HttpRequest.class,
              com.google.cloud.tasks.v2beta3.HttpRequest.Builder.class);
    }

    // Construct using com.google.cloud.tasks.v2beta3.HttpRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      url_ = "";

      httpMethod_ = 0;

      internalGetMutableHeaders().clear();
      body_ = com.google.protobuf.ByteString.EMPTY;

      authorizationHeaderCase_ = 0;
      authorizationHeader_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.tasks.v2beta3.TargetProto
          .internal_static_google_cloud_tasks_v2beta3_HttpRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.HttpRequest getDefaultInstanceForType() {
      return com.google.cloud.tasks.v2beta3.HttpRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.HttpRequest build() {
      com.google.cloud.tasks.v2beta3.HttpRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.HttpRequest buildPartial() {
      com.google.cloud.tasks.v2beta3.HttpRequest result =
          new com.google.cloud.tasks.v2beta3.HttpRequest(this);
      int from_bitField0_ = bitField0_;
      result.url_ = url_;
      result.httpMethod_ = httpMethod_;
      result.headers_ = internalGetHeaders();
      result.headers_.makeImmutable();
      result.body_ = body_;
      if (authorizationHeaderCase_ == 5) {
        if (oauthTokenBuilder_ == null) {
          result.authorizationHeader_ = authorizationHeader_;
        } else {
          result.authorizationHeader_ = oauthTokenBuilder_.build();
        }
      }
      if (authorizationHeaderCase_ == 6) {
        if (oidcTokenBuilder_ == null) {
          result.authorizationHeader_ = authorizationHeader_;
        } else {
          result.authorizationHeader_ = oidcTokenBuilder_.build();
        }
      }
      result.authorizationHeaderCase_ = authorizationHeaderCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.tasks.v2beta3.HttpRequest) {
        return mergeFrom((com.google.cloud.tasks.v2beta3.HttpRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.tasks.v2beta3.HttpRequest other) {
      if (other == com.google.cloud.tasks.v2beta3.HttpRequest.getDefaultInstance()) return this;
      if (!other.getUrl().isEmpty()) {
        url_ = other.url_;
        onChanged();
      }
      if (other.httpMethod_ != 0) {
        setHttpMethodValue(other.getHttpMethodValue());
      }
      internalGetMutableHeaders().mergeFrom(other.internalGetHeaders());
      if (other.getBody() != com.google.protobuf.ByteString.EMPTY) {
        setBody(other.getBody());
      }
      switch (other.getAuthorizationHeaderCase()) {
        case OAUTH_TOKEN:
          {
            mergeOauthToken(other.getOauthToken());
            break;
          }
        case OIDC_TOKEN:
          {
            mergeOidcToken(other.getOidcToken());
            break;
          }
        case AUTHORIZATIONHEADER_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.tasks.v2beta3.HttpRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.tasks.v2beta3.HttpRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int authorizationHeaderCase_ = 0;
    private java.lang.Object authorizationHeader_;

    public AuthorizationHeaderCase getAuthorizationHeaderCase() {
      return AuthorizationHeaderCase.forNumber(authorizationHeaderCase_);
    }

    public Builder clearAuthorizationHeader() {
      authorizationHeaderCase_ = 0;
      authorizationHeader_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object url_ = "";
    /**
     *
     *
     * <pre>
     * Required. The full url path that the request will be sent to.
     * This string must begin with either "http://" or "https://". Some examples
     * are: `http://acme.com` and `https://acme.com/sales:8080`. Cloud Tasks will
     * encode some characters for safety and compatibility. The maximum allowed
     * URL length is 2083 characters after encoding.
     * The `Location` header response from a redirect response [`300` - `399`]
     * may be followed. The redirect is not counted as a separate attempt.
     * </pre>
     *
     * <code>string url = 1;</code>
     *
     * @return The url.
     */
    public java.lang.String getUrl() {
      java.lang.Object ref = url_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        url_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The full url path that the request will be sent to.
     * This string must begin with either "http://" or "https://". Some examples
     * are: `http://acme.com` and `https://acme.com/sales:8080`. Cloud Tasks will
     * encode some characters for safety and compatibility. The maximum allowed
     * URL length is 2083 characters after encoding.
     * The `Location` header response from a redirect response [`300` - `399`]
     * may be followed. The redirect is not counted as a separate attempt.
     * </pre>
     *
     * <code>string url = 1;</code>
     *
     * @return The bytes for url.
     */
    public com.google.protobuf.ByteString getUrlBytes() {
      java.lang.Object ref = url_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        url_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The full url path that the request will be sent to.
     * This string must begin with either "http://" or "https://". Some examples
     * are: `http://acme.com` and `https://acme.com/sales:8080`. Cloud Tasks will
     * encode some characters for safety and compatibility. The maximum allowed
     * URL length is 2083 characters after encoding.
     * The `Location` header response from a redirect response [`300` - `399`]
     * may be followed. The redirect is not counted as a separate attempt.
     * </pre>
     *
     * <code>string url = 1;</code>
     *
     * @param value The url to set.
     * @return This builder for chaining.
     */
    public Builder setUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      url_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The full url path that the request will be sent to.
     * This string must begin with either "http://" or "https://". Some examples
     * are: `http://acme.com` and `https://acme.com/sales:8080`. Cloud Tasks will
     * encode some characters for safety and compatibility. The maximum allowed
     * URL length is 2083 characters after encoding.
     * The `Location` header response from a redirect response [`300` - `399`]
     * may be followed. The redirect is not counted as a separate attempt.
     * </pre>
     *
     * <code>string url = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearUrl() {

      url_ = getDefaultInstance().getUrl();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The full url path that the request will be sent to.
     * This string must begin with either "http://" or "https://". Some examples
     * are: `http://acme.com` and `https://acme.com/sales:8080`. Cloud Tasks will
     * encode some characters for safety and compatibility. The maximum allowed
     * URL length is 2083 characters after encoding.
     * The `Location` header response from a redirect response [`300` - `399`]
     * may be followed. The redirect is not counted as a separate attempt.
     * </pre>
     *
     * <code>string url = 1;</code>
     *
     * @param value The bytes for url to set.
     * @return This builder for chaining.
     */
    public Builder setUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      url_ = value;
      onChanged();
      return this;
    }

    private int httpMethod_ = 0;
    /**
     *
     *
     * <pre>
     * The HTTP method to use for the request. The default is POST.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.HttpMethod http_method = 2;</code>
     *
     * @return The enum numeric value on the wire for httpMethod.
     */
    public int getHttpMethodValue() {
      return httpMethod_;
    }
    /**
     *
     *
     * <pre>
     * The HTTP method to use for the request. The default is POST.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.HttpMethod http_method = 2;</code>
     *
     * @param value The enum numeric value on the wire for httpMethod to set.
     * @return This builder for chaining.
     */
    public Builder setHttpMethodValue(int value) {
      httpMethod_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The HTTP method to use for the request. The default is POST.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.HttpMethod http_method = 2;</code>
     *
     * @return The httpMethod.
     */
    public com.google.cloud.tasks.v2beta3.HttpMethod getHttpMethod() {
      @SuppressWarnings("deprecation")
      com.google.cloud.tasks.v2beta3.HttpMethod result =
          com.google.cloud.tasks.v2beta3.HttpMethod.valueOf(httpMethod_);
      return result == null ? com.google.cloud.tasks.v2beta3.HttpMethod.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * The HTTP method to use for the request. The default is POST.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.HttpMethod http_method = 2;</code>
     *
     * @param value The httpMethod to set.
     * @return This builder for chaining.
     */
    public Builder setHttpMethod(com.google.cloud.tasks.v2beta3.HttpMethod value) {
      if (value == null) {
        throw new NullPointerException();
      }

      httpMethod_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The HTTP method to use for the request. The default is POST.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.HttpMethod http_method = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHttpMethod() {

      httpMethod_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> headers_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetHeaders() {
      if (headers_ == null) {
        return com.google.protobuf.MapField.emptyMapField(HeadersDefaultEntryHolder.defaultEntry);
      }
      return headers_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableHeaders() {
      onChanged();
      ;
      if (headers_ == null) {
        headers_ = com.google.protobuf.MapField.newMapField(HeadersDefaultEntryHolder.defaultEntry);
      }
      if (!headers_.isMutable()) {
        headers_ = headers_.copy();
      }
      return headers_;
    }

    public int getHeadersCount() {
      return internalGetHeaders().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     * This map contains the header field names and values.
     * Headers can be set when the
     * [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     * These headers represent a subset of the headers that will accompany the
     * task's HTTP request. Some HTTP request headers will be ignored or replaced.
     * A partial list of headers that will be ignored or replaced is:
     * * Host: This will be computed by Cloud Tasks and derived from
     *   [HttpRequest.url][google.cloud.tasks.v2beta3.HttpRequest.url].
     * * Content-Length: This will be computed by Cloud Tasks.
     * * User-Agent: This will be set to `"Google-Cloud-Tasks"`.
     * * X-Google-*: Google use only.
     * * X-AppEngine-*: Google use only.
     * `Content-Type` won't be set by Cloud Tasks. You can explicitly set
     * `Content-Type` to a media type when the
     *  [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     *  For example, `Content-Type` can be set to `"application/octet-stream"` or
     *  `"application/json"`.
     * Headers which can have multiple values (according to RFC2616) can be
     * specified using comma-separated values.
     * The size of the headers must be less than 80KB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    public boolean containsHeaders(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetHeaders().getMap().containsKey(key);
    }
    /** Use {@link #getHeadersMap()} instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getHeaders() {
      return getHeadersMap();
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     * This map contains the header field names and values.
     * Headers can be set when the
     * [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     * These headers represent a subset of the headers that will accompany the
     * task's HTTP request. Some HTTP request headers will be ignored or replaced.
     * A partial list of headers that will be ignored or replaced is:
     * * Host: This will be computed by Cloud Tasks and derived from
     *   [HttpRequest.url][google.cloud.tasks.v2beta3.HttpRequest.url].
     * * Content-Length: This will be computed by Cloud Tasks.
     * * User-Agent: This will be set to `"Google-Cloud-Tasks"`.
     * * X-Google-*: Google use only.
     * * X-AppEngine-*: Google use only.
     * `Content-Type` won't be set by Cloud Tasks. You can explicitly set
     * `Content-Type` to a media type when the
     *  [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     *  For example, `Content-Type` can be set to `"application/octet-stream"` or
     *  `"application/json"`.
     * Headers which can have multiple values (according to RFC2616) can be
     * specified using comma-separated values.
     * The size of the headers must be less than 80KB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    public java.util.Map<java.lang.String, java.lang.String> getHeadersMap() {
      return internalGetHeaders().getMap();
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     * This map contains the header field names and values.
     * Headers can be set when the
     * [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     * These headers represent a subset of the headers that will accompany the
     * task's HTTP request. Some HTTP request headers will be ignored or replaced.
     * A partial list of headers that will be ignored or replaced is:
     * * Host: This will be computed by Cloud Tasks and derived from
     *   [HttpRequest.url][google.cloud.tasks.v2beta3.HttpRequest.url].
     * * Content-Length: This will be computed by Cloud Tasks.
     * * User-Agent: This will be set to `"Google-Cloud-Tasks"`.
     * * X-Google-*: Google use only.
     * * X-AppEngine-*: Google use only.
     * `Content-Type` won't be set by Cloud Tasks. You can explicitly set
     * `Content-Type` to a media type when the
     *  [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     *  For example, `Content-Type` can be set to `"application/octet-stream"` or
     *  `"application/json"`.
     * Headers which can have multiple values (according to RFC2616) can be
     * specified using comma-separated values.
     * The size of the headers must be less than 80KB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    public java.lang.String getHeadersOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     * This map contains the header field names and values.
     * Headers can be set when the
     * [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     * These headers represent a subset of the headers that will accompany the
     * task's HTTP request. Some HTTP request headers will be ignored or replaced.
     * A partial list of headers that will be ignored or replaced is:
     * * Host: This will be computed by Cloud Tasks and derived from
     *   [HttpRequest.url][google.cloud.tasks.v2beta3.HttpRequest.url].
     * * Content-Length: This will be computed by Cloud Tasks.
     * * User-Agent: This will be set to `"Google-Cloud-Tasks"`.
     * * X-Google-*: Google use only.
     * * X-AppEngine-*: Google use only.
     * `Content-Type` won't be set by Cloud Tasks. You can explicitly set
     * `Content-Type` to a media type when the
     *  [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     *  For example, `Content-Type` can be set to `"application/octet-stream"` or
     *  `"application/json"`.
     * Headers which can have multiple values (according to RFC2616) can be
     * specified using comma-separated values.
     * The size of the headers must be less than 80KB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    public java.lang.String getHeadersOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetHeaders().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearHeaders() {
      internalGetMutableHeaders().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     * This map contains the header field names and values.
     * Headers can be set when the
     * [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     * These headers represent a subset of the headers that will accompany the
     * task's HTTP request. Some HTTP request headers will be ignored or replaced.
     * A partial list of headers that will be ignored or replaced is:
     * * Host: This will be computed by Cloud Tasks and derived from
     *   [HttpRequest.url][google.cloud.tasks.v2beta3.HttpRequest.url].
     * * Content-Length: This will be computed by Cloud Tasks.
     * * User-Agent: This will be set to `"Google-Cloud-Tasks"`.
     * * X-Google-*: Google use only.
     * * X-AppEngine-*: Google use only.
     * `Content-Type` won't be set by Cloud Tasks. You can explicitly set
     * `Content-Type` to a media type when the
     *  [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     *  For example, `Content-Type` can be set to `"application/octet-stream"` or
     *  `"application/json"`.
     * Headers which can have multiple values (according to RFC2616) can be
     * specified using comma-separated values.
     * The size of the headers must be less than 80KB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    public Builder removeHeaders(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableHeaders().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableHeaders() {
      return internalGetMutableHeaders().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     * This map contains the header field names and values.
     * Headers can be set when the
     * [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     * These headers represent a subset of the headers that will accompany the
     * task's HTTP request. Some HTTP request headers will be ignored or replaced.
     * A partial list of headers that will be ignored or replaced is:
     * * Host: This will be computed by Cloud Tasks and derived from
     *   [HttpRequest.url][google.cloud.tasks.v2beta3.HttpRequest.url].
     * * Content-Length: This will be computed by Cloud Tasks.
     * * User-Agent: This will be set to `"Google-Cloud-Tasks"`.
     * * X-Google-*: Google use only.
     * * X-AppEngine-*: Google use only.
     * `Content-Type` won't be set by Cloud Tasks. You can explicitly set
     * `Content-Type` to a media type when the
     *  [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     *  For example, `Content-Type` can be set to `"application/octet-stream"` or
     *  `"application/json"`.
     * Headers which can have multiple values (according to RFC2616) can be
     * specified using comma-separated values.
     * The size of the headers must be less than 80KB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    public Builder putHeaders(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      if (value == null) {
        throw new java.lang.NullPointerException();
      }
      internalGetMutableHeaders().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP request headers.
     * This map contains the header field names and values.
     * Headers can be set when the
     * [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     * These headers represent a subset of the headers that will accompany the
     * task's HTTP request. Some HTTP request headers will be ignored or replaced.
     * A partial list of headers that will be ignored or replaced is:
     * * Host: This will be computed by Cloud Tasks and derived from
     *   [HttpRequest.url][google.cloud.tasks.v2beta3.HttpRequest.url].
     * * Content-Length: This will be computed by Cloud Tasks.
     * * User-Agent: This will be set to `"Google-Cloud-Tasks"`.
     * * X-Google-*: Google use only.
     * * X-AppEngine-*: Google use only.
     * `Content-Type` won't be set by Cloud Tasks. You can explicitly set
     * `Content-Type` to a media type when the
     *  [task is created][google.cloud.tasks.v2beta3.CloudTasks.CreateTask].
     *  For example, `Content-Type` can be set to `"application/octet-stream"` or
     *  `"application/json"`.
     * Headers which can have multiple values (according to RFC2616) can be
     * specified using comma-separated values.
     * The size of the headers must be less than 80KB.
     * </pre>
     *
     * <code>map&lt;string, string&gt; headers = 3;</code>
     */
    public Builder putAllHeaders(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableHeaders().getMutableMap().putAll(values);
      return this;
    }

    private com.google.protobuf.ByteString body_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * HTTP request body.
     * A request body is allowed only if the
     * [HTTP method][google.cloud.tasks.v2beta3.HttpRequest.http_method] is POST, PUT, or PATCH. It is an
     * error to set body on a task with an incompatible [HttpMethod][google.cloud.tasks.v2beta3.HttpMethod].
     * </pre>
     *
     * <code>bytes body = 4;</code>
     *
     * @return The body.
     */
    public com.google.protobuf.ByteString getBody() {
      return body_;
    }
    /**
     *
     *
     * <pre>
     * HTTP request body.
     * A request body is allowed only if the
     * [HTTP method][google.cloud.tasks.v2beta3.HttpRequest.http_method] is POST, PUT, or PATCH. It is an
     * error to set body on a task with an incompatible [HttpMethod][google.cloud.tasks.v2beta3.HttpMethod].
     * </pre>
     *
     * <code>bytes body = 4;</code>
     *
     * @param value The body to set.
     * @return This builder for chaining.
     */
    public Builder setBody(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      body_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * HTTP request body.
     * A request body is allowed only if the
     * [HTTP method][google.cloud.tasks.v2beta3.HttpRequest.http_method] is POST, PUT, or PATCH. It is an
     * error to set body on a task with an incompatible [HttpMethod][google.cloud.tasks.v2beta3.HttpMethod].
     * </pre>
     *
     * <code>bytes body = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBody() {

      body_ = getDefaultInstance().getBody();
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.OAuthToken,
            com.google.cloud.tasks.v2beta3.OAuthToken.Builder,
            com.google.cloud.tasks.v2beta3.OAuthTokenOrBuilder>
        oauthTokenBuilder_;
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
     * will be generated and attached as an `Authorization` header in the HTTP
     * request.
     * This type of authorization should generally only be used when calling
     * Google APIs hosted on *.googleapis.com.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.OAuthToken oauth_token = 5;</code>
     *
     * @return Whether the oauthToken field is set.
     */
    public boolean hasOauthToken() {
      return authorizationHeaderCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
     * will be generated and attached as an `Authorization` header in the HTTP
     * request.
     * This type of authorization should generally only be used when calling
     * Google APIs hosted on *.googleapis.com.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.OAuthToken oauth_token = 5;</code>
     *
     * @return The oauthToken.
     */
    public com.google.cloud.tasks.v2beta3.OAuthToken getOauthToken() {
      if (oauthTokenBuilder_ == null) {
        if (authorizationHeaderCase_ == 5) {
          return (com.google.cloud.tasks.v2beta3.OAuthToken) authorizationHeader_;
        }
        return com.google.cloud.tasks.v2beta3.OAuthToken.getDefaultInstance();
      } else {
        if (authorizationHeaderCase_ == 5) {
          return oauthTokenBuilder_.getMessage();
        }
        return com.google.cloud.tasks.v2beta3.OAuthToken.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
     * will be generated and attached as an `Authorization` header in the HTTP
     * request.
     * This type of authorization should generally only be used when calling
     * Google APIs hosted on *.googleapis.com.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.OAuthToken oauth_token = 5;</code>
     */
    public Builder setOauthToken(com.google.cloud.tasks.v2beta3.OAuthToken value) {
      if (oauthTokenBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        authorizationHeader_ = value;
        onChanged();
      } else {
        oauthTokenBuilder_.setMessage(value);
      }
      authorizationHeaderCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
     * will be generated and attached as an `Authorization` header in the HTTP
     * request.
     * This type of authorization should generally only be used when calling
     * Google APIs hosted on *.googleapis.com.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.OAuthToken oauth_token = 5;</code>
     */
    public Builder setOauthToken(
        com.google.cloud.tasks.v2beta3.OAuthToken.Builder builderForValue) {
      if (oauthTokenBuilder_ == null) {
        authorizationHeader_ = builderForValue.build();
        onChanged();
      } else {
        oauthTokenBuilder_.setMessage(builderForValue.build());
      }
      authorizationHeaderCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
     * will be generated and attached as an `Authorization` header in the HTTP
     * request.
     * This type of authorization should generally only be used when calling
     * Google APIs hosted on *.googleapis.com.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.OAuthToken oauth_token = 5;</code>
     */
    public Builder mergeOauthToken(com.google.cloud.tasks.v2beta3.OAuthToken value) {
      if (oauthTokenBuilder_ == null) {
        if (authorizationHeaderCase_ == 5
            && authorizationHeader_
                != com.google.cloud.tasks.v2beta3.OAuthToken.getDefaultInstance()) {
          authorizationHeader_ =
              com.google.cloud.tasks.v2beta3.OAuthToken.newBuilder(
                      (com.google.cloud.tasks.v2beta3.OAuthToken) authorizationHeader_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          authorizationHeader_ = value;
        }
        onChanged();
      } else {
        if (authorizationHeaderCase_ == 5) {
          oauthTokenBuilder_.mergeFrom(value);
        }
        oauthTokenBuilder_.setMessage(value);
      }
      authorizationHeaderCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
     * will be generated and attached as an `Authorization` header in the HTTP
     * request.
     * This type of authorization should generally only be used when calling
     * Google APIs hosted on *.googleapis.com.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.OAuthToken oauth_token = 5;</code>
     */
    public Builder clearOauthToken() {
      if (oauthTokenBuilder_ == null) {
        if (authorizationHeaderCase_ == 5) {
          authorizationHeaderCase_ = 0;
          authorizationHeader_ = null;
          onChanged();
        }
      } else {
        if (authorizationHeaderCase_ == 5) {
          authorizationHeaderCase_ = 0;
          authorizationHeader_ = null;
        }
        oauthTokenBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
     * will be generated and attached as an `Authorization` header in the HTTP
     * request.
     * This type of authorization should generally only be used when calling
     * Google APIs hosted on *.googleapis.com.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.OAuthToken oauth_token = 5;</code>
     */
    public com.google.cloud.tasks.v2beta3.OAuthToken.Builder getOauthTokenBuilder() {
      return getOauthTokenFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
     * will be generated and attached as an `Authorization` header in the HTTP
     * request.
     * This type of authorization should generally only be used when calling
     * Google APIs hosted on *.googleapis.com.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.OAuthToken oauth_token = 5;</code>
     */
    public com.google.cloud.tasks.v2beta3.OAuthTokenOrBuilder getOauthTokenOrBuilder() {
      if ((authorizationHeaderCase_ == 5) && (oauthTokenBuilder_ != null)) {
        return oauthTokenBuilder_.getMessageOrBuilder();
      } else {
        if (authorizationHeaderCase_ == 5) {
          return (com.google.cloud.tasks.v2beta3.OAuthToken) authorizationHeader_;
        }
        return com.google.cloud.tasks.v2beta3.OAuthToken.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OAuth token](https://developers.google.com/identity/protocols/OAuth2)
     * will be generated and attached as an `Authorization` header in the HTTP
     * request.
     * This type of authorization should generally only be used when calling
     * Google APIs hosted on *.googleapis.com.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.OAuthToken oauth_token = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.OAuthToken,
            com.google.cloud.tasks.v2beta3.OAuthToken.Builder,
            com.google.cloud.tasks.v2beta3.OAuthTokenOrBuilder>
        getOauthTokenFieldBuilder() {
      if (oauthTokenBuilder_ == null) {
        if (!(authorizationHeaderCase_ == 5)) {
          authorizationHeader_ = com.google.cloud.tasks.v2beta3.OAuthToken.getDefaultInstance();
        }
        oauthTokenBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2beta3.OAuthToken,
                com.google.cloud.tasks.v2beta3.OAuthToken.Builder,
                com.google.cloud.tasks.v2beta3.OAuthTokenOrBuilder>(
                (com.google.cloud.tasks.v2beta3.OAuthToken) authorizationHeader_,
                getParentForChildren(),
                isClean());
        authorizationHeader_ = null;
      }
      authorizationHeaderCase_ = 5;
      onChanged();
      ;
      return oauthTokenBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.OidcToken,
            com.google.cloud.tasks.v2beta3.OidcToken.Builder,
            com.google.cloud.tasks.v2beta3.OidcTokenOrBuilder>
        oidcTokenBuilder_;
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
     * token will be generated and attached as an `Authorization` header in the
     * HTTP request.
     * This type of authorization can be used for many scenarios, including
     * calling Cloud Run, or endpoints where you intend to validate the token
     * yourself.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.OidcToken oidc_token = 6;</code>
     *
     * @return Whether the oidcToken field is set.
     */
    public boolean hasOidcToken() {
      return authorizationHeaderCase_ == 6;
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
     * token will be generated and attached as an `Authorization` header in the
     * HTTP request.
     * This type of authorization can be used for many scenarios, including
     * calling Cloud Run, or endpoints where you intend to validate the token
     * yourself.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.OidcToken oidc_token = 6;</code>
     *
     * @return The oidcToken.
     */
    public com.google.cloud.tasks.v2beta3.OidcToken getOidcToken() {
      if (oidcTokenBuilder_ == null) {
        if (authorizationHeaderCase_ == 6) {
          return (com.google.cloud.tasks.v2beta3.OidcToken) authorizationHeader_;
        }
        return com.google.cloud.tasks.v2beta3.OidcToken.getDefaultInstance();
      } else {
        if (authorizationHeaderCase_ == 6) {
          return oidcTokenBuilder_.getMessage();
        }
        return com.google.cloud.tasks.v2beta3.OidcToken.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
     * token will be generated and attached as an `Authorization` header in the
     * HTTP request.
     * This type of authorization can be used for many scenarios, including
     * calling Cloud Run, or endpoints where you intend to validate the token
     * yourself.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.OidcToken oidc_token = 6;</code>
     */
    public Builder setOidcToken(com.google.cloud.tasks.v2beta3.OidcToken value) {
      if (oidcTokenBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        authorizationHeader_ = value;
        onChanged();
      } else {
        oidcTokenBuilder_.setMessage(value);
      }
      authorizationHeaderCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
     * token will be generated and attached as an `Authorization` header in the
     * HTTP request.
     * This type of authorization can be used for many scenarios, including
     * calling Cloud Run, or endpoints where you intend to validate the token
     * yourself.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.OidcToken oidc_token = 6;</code>
     */
    public Builder setOidcToken(com.google.cloud.tasks.v2beta3.OidcToken.Builder builderForValue) {
      if (oidcTokenBuilder_ == null) {
        authorizationHeader_ = builderForValue.build();
        onChanged();
      } else {
        oidcTokenBuilder_.setMessage(builderForValue.build());
      }
      authorizationHeaderCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
     * token will be generated and attached as an `Authorization` header in the
     * HTTP request.
     * This type of authorization can be used for many scenarios, including
     * calling Cloud Run, or endpoints where you intend to validate the token
     * yourself.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.OidcToken oidc_token = 6;</code>
     */
    public Builder mergeOidcToken(com.google.cloud.tasks.v2beta3.OidcToken value) {
      if (oidcTokenBuilder_ == null) {
        if (authorizationHeaderCase_ == 6
            && authorizationHeader_
                != com.google.cloud.tasks.v2beta3.OidcToken.getDefaultInstance()) {
          authorizationHeader_ =
              com.google.cloud.tasks.v2beta3.OidcToken.newBuilder(
                      (com.google.cloud.tasks.v2beta3.OidcToken) authorizationHeader_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          authorizationHeader_ = value;
        }
        onChanged();
      } else {
        if (authorizationHeaderCase_ == 6) {
          oidcTokenBuilder_.mergeFrom(value);
        }
        oidcTokenBuilder_.setMessage(value);
      }
      authorizationHeaderCase_ = 6;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
     * token will be generated and attached as an `Authorization` header in the
     * HTTP request.
     * This type of authorization can be used for many scenarios, including
     * calling Cloud Run, or endpoints where you intend to validate the token
     * yourself.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.OidcToken oidc_token = 6;</code>
     */
    public Builder clearOidcToken() {
      if (oidcTokenBuilder_ == null) {
        if (authorizationHeaderCase_ == 6) {
          authorizationHeaderCase_ = 0;
          authorizationHeader_ = null;
          onChanged();
        }
      } else {
        if (authorizationHeaderCase_ == 6) {
          authorizationHeaderCase_ = 0;
          authorizationHeader_ = null;
        }
        oidcTokenBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
     * token will be generated and attached as an `Authorization` header in the
     * HTTP request.
     * This type of authorization can be used for many scenarios, including
     * calling Cloud Run, or endpoints where you intend to validate the token
     * yourself.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.OidcToken oidc_token = 6;</code>
     */
    public com.google.cloud.tasks.v2beta3.OidcToken.Builder getOidcTokenBuilder() {
      return getOidcTokenFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
     * token will be generated and attached as an `Authorization` header in the
     * HTTP request.
     * This type of authorization can be used for many scenarios, including
     * calling Cloud Run, or endpoints where you intend to validate the token
     * yourself.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.OidcToken oidc_token = 6;</code>
     */
    public com.google.cloud.tasks.v2beta3.OidcTokenOrBuilder getOidcTokenOrBuilder() {
      if ((authorizationHeaderCase_ == 6) && (oidcTokenBuilder_ != null)) {
        return oidcTokenBuilder_.getMessageOrBuilder();
      } else {
        if (authorizationHeaderCase_ == 6) {
          return (com.google.cloud.tasks.v2beta3.OidcToken) authorizationHeader_;
        }
        return com.google.cloud.tasks.v2beta3.OidcToken.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * If specified, an
     * [OIDC](https://developers.google.com/identity/protocols/OpenIDConnect)
     * token will be generated and attached as an `Authorization` header in the
     * HTTP request.
     * This type of authorization can be used for many scenarios, including
     * calling Cloud Run, or endpoints where you intend to validate the token
     * yourself.
     * </pre>
     *
     * <code>.google.cloud.tasks.v2beta3.OidcToken oidc_token = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.tasks.v2beta3.OidcToken,
            com.google.cloud.tasks.v2beta3.OidcToken.Builder,
            com.google.cloud.tasks.v2beta3.OidcTokenOrBuilder>
        getOidcTokenFieldBuilder() {
      if (oidcTokenBuilder_ == null) {
        if (!(authorizationHeaderCase_ == 6)) {
          authorizationHeader_ = com.google.cloud.tasks.v2beta3.OidcToken.getDefaultInstance();
        }
        oidcTokenBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.tasks.v2beta3.OidcToken,
                com.google.cloud.tasks.v2beta3.OidcToken.Builder,
                com.google.cloud.tasks.v2beta3.OidcTokenOrBuilder>(
                (com.google.cloud.tasks.v2beta3.OidcToken) authorizationHeader_,
                getParentForChildren(),
                isClean());
        authorizationHeader_ = null;
      }
      authorizationHeaderCase_ = 6;
      onChanged();
      ;
      return oidcTokenBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.tasks.v2beta3.HttpRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.tasks.v2beta3.HttpRequest)
  private static final com.google.cloud.tasks.v2beta3.HttpRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.tasks.v2beta3.HttpRequest();
  }

  public static com.google.cloud.tasks.v2beta3.HttpRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<HttpRequest> PARSER =
      new com.google.protobuf.AbstractParser<HttpRequest>() {
        @java.lang.Override
        public HttpRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new HttpRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<HttpRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<HttpRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.HttpRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
