/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/tasks/v2beta3/target.proto

package com.google.cloud.tasks.v2beta3;

/**
 *
 *
 * <pre>
 * App Engine Routing.
 * Defines routing characteristics specific to App Engine - service, version,
 * and instance.
 * For more information about services, versions, and instances see
 * [An Overview of App
 * Engine](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine),
 * [Microservices Architecture on Google App
 * Engine](https://cloud.google.com/appengine/docs/python/microservices-on-app-engine),
 * [App Engine Standard request
 * routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed),
 * and [App Engine Flex request
 * routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
 * </pre>
 *
 * Protobuf type {@code google.cloud.tasks.v2beta3.AppEngineRouting}
 */
public final class AppEngineRouting extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.tasks.v2beta3.AppEngineRouting)
    AppEngineRoutingOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AppEngineRouting.newBuilder() to construct.
  private AppEngineRouting(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AppEngineRouting() {
    service_ = "";
    version_ = "";
    instance_ = "";
    host_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AppEngineRouting();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private AppEngineRouting(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              service_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              version_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();

              instance_ = s;
              break;
            }
          case 34:
            {
              java.lang.String s = input.readStringRequireUtf8();

              host_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.tasks.v2beta3.TargetProto
        .internal_static_google_cloud_tasks_v2beta3_AppEngineRouting_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.tasks.v2beta3.TargetProto
        .internal_static_google_cloud_tasks_v2beta3_AppEngineRouting_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.tasks.v2beta3.AppEngineRouting.class,
            com.google.cloud.tasks.v2beta3.AppEngineRouting.Builder.class);
  }

  public static final int SERVICE_FIELD_NUMBER = 1;
  private volatile java.lang.Object service_;
  /**
   *
   *
   * <pre>
   * App service.
   * By default, the task is sent to the service which is the default
   * service when the task is attempted.
   * For some queues or tasks which were created using the App Engine
   * Task Queue API, [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable
   * into [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
   * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
   * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. For example, some tasks
   * which were created using the App Engine SDK use a custom domain
   * name; custom domains are not parsed by Cloud Tasks. If
   * [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable, then
   * [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
   * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
   * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance] are the empty string.
   * </pre>
   *
   * <code>string service = 1;</code>
   *
   * @return The service.
   */
  public java.lang.String getService() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      service_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * App service.
   * By default, the task is sent to the service which is the default
   * service when the task is attempted.
   * For some queues or tasks which were created using the App Engine
   * Task Queue API, [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable
   * into [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
   * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
   * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. For example, some tasks
   * which were created using the App Engine SDK use a custom domain
   * name; custom domains are not parsed by Cloud Tasks. If
   * [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable, then
   * [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
   * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
   * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance] are the empty string.
   * </pre>
   *
   * <code>string service = 1;</code>
   *
   * @return The bytes for service.
   */
  public com.google.protobuf.ByteString getServiceBytes() {
    java.lang.Object ref = service_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      service_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VERSION_FIELD_NUMBER = 2;
  private volatile java.lang.Object version_;
  /**
   *
   *
   * <pre>
   * App version.
   * By default, the task is sent to the version which is the default
   * version when the task is attempted.
   * For some queues or tasks which were created using the App Engine
   * Task Queue API, [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable
   * into [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
   * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
   * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. For example, some tasks
   * which were created using the App Engine SDK use a custom domain
   * name; custom domains are not parsed by Cloud Tasks. If
   * [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable, then
   * [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
   * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
   * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance] are the empty string.
   * </pre>
   *
   * <code>string version = 2;</code>
   *
   * @return The version.
   */
  public java.lang.String getVersion() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      version_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * App version.
   * By default, the task is sent to the version which is the default
   * version when the task is attempted.
   * For some queues or tasks which were created using the App Engine
   * Task Queue API, [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable
   * into [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
   * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
   * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. For example, some tasks
   * which were created using the App Engine SDK use a custom domain
   * name; custom domains are not parsed by Cloud Tasks. If
   * [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable, then
   * [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
   * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
   * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance] are the empty string.
   * </pre>
   *
   * <code>string version = 2;</code>
   *
   * @return The bytes for version.
   */
  public com.google.protobuf.ByteString getVersionBytes() {
    java.lang.Object ref = version_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      version_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANCE_FIELD_NUMBER = 3;
  private volatile java.lang.Object instance_;
  /**
   *
   *
   * <pre>
   * App instance.
   * By default, the task is sent to an instance which is available when
   * the task is attempted.
   * Requests can only be sent to a specific instance if
   * [manual scaling is used in App Engine
   * Standard](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine?hl=en_US#scaling_types_and_instance_classes).
   * App Engine Flex does not support instances. For more information, see
   * [App Engine Standard request
   * routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed)
   * and [App Engine Flex request
   * routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
   * </pre>
   *
   * <code>string instance = 3;</code>
   *
   * @return The instance.
   */
  public java.lang.String getInstance() {
    java.lang.Object ref = instance_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instance_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * App instance.
   * By default, the task is sent to an instance which is available when
   * the task is attempted.
   * Requests can only be sent to a specific instance if
   * [manual scaling is used in App Engine
   * Standard](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine?hl=en_US#scaling_types_and_instance_classes).
   * App Engine Flex does not support instances. For more information, see
   * [App Engine Standard request
   * routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed)
   * and [App Engine Flex request
   * routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
   * </pre>
   *
   * <code>string instance = 3;</code>
   *
   * @return The bytes for instance.
   */
  public com.google.protobuf.ByteString getInstanceBytes() {
    java.lang.Object ref = instance_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instance_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HOST_FIELD_NUMBER = 4;
  private volatile java.lang.Object host_;
  /**
   *
   *
   * <pre>
   * Output only. The host that the task is sent to.
   * The host is constructed from the domain name of the app associated with
   * the queue's project ID (for example &lt;app-id&gt;.appspot.com), and the
   * [service][google.cloud.tasks.v2beta3.AppEngineRouting.service], [version][google.cloud.tasks.v2beta3.AppEngineRouting.version],
   * and [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. Tasks which were created using
   * the App Engine SDK might have a custom domain name.
   * For more information, see
   * [How Requests are
   * Routed](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed).
   * </pre>
   *
   * <code>string host = 4;</code>
   *
   * @return The host.
   */
  public java.lang.String getHost() {
    java.lang.Object ref = host_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      host_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Output only. The host that the task is sent to.
   * The host is constructed from the domain name of the app associated with
   * the queue's project ID (for example &lt;app-id&gt;.appspot.com), and the
   * [service][google.cloud.tasks.v2beta3.AppEngineRouting.service], [version][google.cloud.tasks.v2beta3.AppEngineRouting.version],
   * and [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. Tasks which were created using
   * the App Engine SDK might have a custom domain name.
   * For more information, see
   * [How Requests are
   * Routed](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed).
   * </pre>
   *
   * <code>string host = 4;</code>
   *
   * @return The bytes for host.
   */
  public com.google.protobuf.ByteString getHostBytes() {
    java.lang.Object ref = host_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      host_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!getServiceBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, service_);
    }
    if (!getVersionBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, version_);
    }
    if (!getInstanceBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, instance_);
    }
    if (!getHostBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, host_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getServiceBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, service_);
    }
    if (!getVersionBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, version_);
    }
    if (!getInstanceBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, instance_);
    }
    if (!getHostBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, host_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.tasks.v2beta3.AppEngineRouting)) {
      return super.equals(obj);
    }
    com.google.cloud.tasks.v2beta3.AppEngineRouting other =
        (com.google.cloud.tasks.v2beta3.AppEngineRouting) obj;

    if (!getService().equals(other.getService())) return false;
    if (!getVersion().equals(other.getVersion())) return false;
    if (!getInstance().equals(other.getInstance())) return false;
    if (!getHost().equals(other.getHost())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SERVICE_FIELD_NUMBER;
    hash = (53 * hash) + getService().hashCode();
    hash = (37 * hash) + VERSION_FIELD_NUMBER;
    hash = (53 * hash) + getVersion().hashCode();
    hash = (37 * hash) + INSTANCE_FIELD_NUMBER;
    hash = (53 * hash) + getInstance().hashCode();
    hash = (37 * hash) + HOST_FIELD_NUMBER;
    hash = (53 * hash) + getHost().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineRouting parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineRouting parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineRouting parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineRouting parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineRouting parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineRouting parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineRouting parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineRouting parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineRouting parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineRouting parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineRouting parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineRouting parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.tasks.v2beta3.AppEngineRouting prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * App Engine Routing.
   * Defines routing characteristics specific to App Engine - service, version,
   * and instance.
   * For more information about services, versions, and instances see
   * [An Overview of App
   * Engine](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine),
   * [Microservices Architecture on Google App
   * Engine](https://cloud.google.com/appengine/docs/python/microservices-on-app-engine),
   * [App Engine Standard request
   * routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed),
   * and [App Engine Flex request
   * routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
   * </pre>
   *
   * Protobuf type {@code google.cloud.tasks.v2beta3.AppEngineRouting}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.tasks.v2beta3.AppEngineRouting)
      com.google.cloud.tasks.v2beta3.AppEngineRoutingOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.tasks.v2beta3.TargetProto
          .internal_static_google_cloud_tasks_v2beta3_AppEngineRouting_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.tasks.v2beta3.TargetProto
          .internal_static_google_cloud_tasks_v2beta3_AppEngineRouting_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.tasks.v2beta3.AppEngineRouting.class,
              com.google.cloud.tasks.v2beta3.AppEngineRouting.Builder.class);
    }

    // Construct using com.google.cloud.tasks.v2beta3.AppEngineRouting.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      service_ = "";

      version_ = "";

      instance_ = "";

      host_ = "";

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.tasks.v2beta3.TargetProto
          .internal_static_google_cloud_tasks_v2beta3_AppEngineRouting_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.AppEngineRouting getDefaultInstanceForType() {
      return com.google.cloud.tasks.v2beta3.AppEngineRouting.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.AppEngineRouting build() {
      com.google.cloud.tasks.v2beta3.AppEngineRouting result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.AppEngineRouting buildPartial() {
      com.google.cloud.tasks.v2beta3.AppEngineRouting result =
          new com.google.cloud.tasks.v2beta3.AppEngineRouting(this);
      result.service_ = service_;
      result.version_ = version_;
      result.instance_ = instance_;
      result.host_ = host_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.tasks.v2beta3.AppEngineRouting) {
        return mergeFrom((com.google.cloud.tasks.v2beta3.AppEngineRouting) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.tasks.v2beta3.AppEngineRouting other) {
      if (other == com.google.cloud.tasks.v2beta3.AppEngineRouting.getDefaultInstance())
        return this;
      if (!other.getService().isEmpty()) {
        service_ = other.service_;
        onChanged();
      }
      if (!other.getVersion().isEmpty()) {
        version_ = other.version_;
        onChanged();
      }
      if (!other.getInstance().isEmpty()) {
        instance_ = other.instance_;
        onChanged();
      }
      if (!other.getHost().isEmpty()) {
        host_ = other.host_;
        onChanged();
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.tasks.v2beta3.AppEngineRouting parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.tasks.v2beta3.AppEngineRouting) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private java.lang.Object service_ = "";
    /**
     *
     *
     * <pre>
     * App service.
     * By default, the task is sent to the service which is the default
     * service when the task is attempted.
     * For some queues or tasks which were created using the App Engine
     * Task Queue API, [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable
     * into [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
     * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
     * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. For example, some tasks
     * which were created using the App Engine SDK use a custom domain
     * name; custom domains are not parsed by Cloud Tasks. If
     * [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable, then
     * [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
     * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
     * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance] are the empty string.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return The service.
     */
    public java.lang.String getService() {
      java.lang.Object ref = service_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        service_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * App service.
     * By default, the task is sent to the service which is the default
     * service when the task is attempted.
     * For some queues or tasks which were created using the App Engine
     * Task Queue API, [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable
     * into [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
     * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
     * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. For example, some tasks
     * which were created using the App Engine SDK use a custom domain
     * name; custom domains are not parsed by Cloud Tasks. If
     * [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable, then
     * [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
     * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
     * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance] are the empty string.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return The bytes for service.
     */
    public com.google.protobuf.ByteString getServiceBytes() {
      java.lang.Object ref = service_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        service_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * App service.
     * By default, the task is sent to the service which is the default
     * service when the task is attempted.
     * For some queues or tasks which were created using the App Engine
     * Task Queue API, [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable
     * into [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
     * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
     * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. For example, some tasks
     * which were created using the App Engine SDK use a custom domain
     * name; custom domains are not parsed by Cloud Tasks. If
     * [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable, then
     * [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
     * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
     * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance] are the empty string.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @param value The service to set.
     * @return This builder for chaining.
     */
    public Builder setService(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      service_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * App service.
     * By default, the task is sent to the service which is the default
     * service when the task is attempted.
     * For some queues or tasks which were created using the App Engine
     * Task Queue API, [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable
     * into [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
     * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
     * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. For example, some tasks
     * which were created using the App Engine SDK use a custom domain
     * name; custom domains are not parsed by Cloud Tasks. If
     * [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable, then
     * [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
     * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
     * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance] are the empty string.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearService() {

      service_ = getDefaultInstance().getService();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * App service.
     * By default, the task is sent to the service which is the default
     * service when the task is attempted.
     * For some queues or tasks which were created using the App Engine
     * Task Queue API, [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable
     * into [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
     * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
     * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. For example, some tasks
     * which were created using the App Engine SDK use a custom domain
     * name; custom domains are not parsed by Cloud Tasks. If
     * [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable, then
     * [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
     * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
     * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance] are the empty string.
     * </pre>
     *
     * <code>string service = 1;</code>
     *
     * @param value The bytes for service to set.
     * @return This builder for chaining.
     */
    public Builder setServiceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      service_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object version_ = "";
    /**
     *
     *
     * <pre>
     * App version.
     * By default, the task is sent to the version which is the default
     * version when the task is attempted.
     * For some queues or tasks which were created using the App Engine
     * Task Queue API, [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable
     * into [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
     * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
     * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. For example, some tasks
     * which were created using the App Engine SDK use a custom domain
     * name; custom domains are not parsed by Cloud Tasks. If
     * [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable, then
     * [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
     * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
     * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance] are the empty string.
     * </pre>
     *
     * <code>string version = 2;</code>
     *
     * @return The version.
     */
    public java.lang.String getVersion() {
      java.lang.Object ref = version_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        version_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * App version.
     * By default, the task is sent to the version which is the default
     * version when the task is attempted.
     * For some queues or tasks which were created using the App Engine
     * Task Queue API, [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable
     * into [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
     * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
     * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. For example, some tasks
     * which were created using the App Engine SDK use a custom domain
     * name; custom domains are not parsed by Cloud Tasks. If
     * [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable, then
     * [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
     * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
     * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance] are the empty string.
     * </pre>
     *
     * <code>string version = 2;</code>
     *
     * @return The bytes for version.
     */
    public com.google.protobuf.ByteString getVersionBytes() {
      java.lang.Object ref = version_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        version_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * App version.
     * By default, the task is sent to the version which is the default
     * version when the task is attempted.
     * For some queues or tasks which were created using the App Engine
     * Task Queue API, [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable
     * into [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
     * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
     * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. For example, some tasks
     * which were created using the App Engine SDK use a custom domain
     * name; custom domains are not parsed by Cloud Tasks. If
     * [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable, then
     * [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
     * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
     * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance] are the empty string.
     * </pre>
     *
     * <code>string version = 2;</code>
     *
     * @param value The version to set.
     * @return This builder for chaining.
     */
    public Builder setVersion(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      version_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * App version.
     * By default, the task is sent to the version which is the default
     * version when the task is attempted.
     * For some queues or tasks which were created using the App Engine
     * Task Queue API, [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable
     * into [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
     * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
     * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. For example, some tasks
     * which were created using the App Engine SDK use a custom domain
     * name; custom domains are not parsed by Cloud Tasks. If
     * [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable, then
     * [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
     * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
     * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance] are the empty string.
     * </pre>
     *
     * <code>string version = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearVersion() {

      version_ = getDefaultInstance().getVersion();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * App version.
     * By default, the task is sent to the version which is the default
     * version when the task is attempted.
     * For some queues or tasks which were created using the App Engine
     * Task Queue API, [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable
     * into [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
     * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
     * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. For example, some tasks
     * which were created using the App Engine SDK use a custom domain
     * name; custom domains are not parsed by Cloud Tasks. If
     * [host][google.cloud.tasks.v2beta3.AppEngineRouting.host] is not parsable, then
     * [service][google.cloud.tasks.v2beta3.AppEngineRouting.service],
     * [version][google.cloud.tasks.v2beta3.AppEngineRouting.version], and
     * [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance] are the empty string.
     * </pre>
     *
     * <code>string version = 2;</code>
     *
     * @param value The bytes for version to set.
     * @return This builder for chaining.
     */
    public Builder setVersionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      version_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object instance_ = "";
    /**
     *
     *
     * <pre>
     * App instance.
     * By default, the task is sent to an instance which is available when
     * the task is attempted.
     * Requests can only be sent to a specific instance if
     * [manual scaling is used in App Engine
     * Standard](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine?hl=en_US#scaling_types_and_instance_classes).
     * App Engine Flex does not support instances. For more information, see
     * [App Engine Standard request
     * routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed)
     * and [App Engine Flex request
     * routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
     * </pre>
     *
     * <code>string instance = 3;</code>
     *
     * @return The instance.
     */
    public java.lang.String getInstance() {
      java.lang.Object ref = instance_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instance_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * App instance.
     * By default, the task is sent to an instance which is available when
     * the task is attempted.
     * Requests can only be sent to a specific instance if
     * [manual scaling is used in App Engine
     * Standard](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine?hl=en_US#scaling_types_and_instance_classes).
     * App Engine Flex does not support instances. For more information, see
     * [App Engine Standard request
     * routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed)
     * and [App Engine Flex request
     * routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
     * </pre>
     *
     * <code>string instance = 3;</code>
     *
     * @return The bytes for instance.
     */
    public com.google.protobuf.ByteString getInstanceBytes() {
      java.lang.Object ref = instance_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instance_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * App instance.
     * By default, the task is sent to an instance which is available when
     * the task is attempted.
     * Requests can only be sent to a specific instance if
     * [manual scaling is used in App Engine
     * Standard](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine?hl=en_US#scaling_types_and_instance_classes).
     * App Engine Flex does not support instances. For more information, see
     * [App Engine Standard request
     * routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed)
     * and [App Engine Flex request
     * routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
     * </pre>
     *
     * <code>string instance = 3;</code>
     *
     * @param value The instance to set.
     * @return This builder for chaining.
     */
    public Builder setInstance(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      instance_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * App instance.
     * By default, the task is sent to an instance which is available when
     * the task is attempted.
     * Requests can only be sent to a specific instance if
     * [manual scaling is used in App Engine
     * Standard](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine?hl=en_US#scaling_types_and_instance_classes).
     * App Engine Flex does not support instances. For more information, see
     * [App Engine Standard request
     * routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed)
     * and [App Engine Flex request
     * routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
     * </pre>
     *
     * <code>string instance = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstance() {

      instance_ = getDefaultInstance().getInstance();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * App instance.
     * By default, the task is sent to an instance which is available when
     * the task is attempted.
     * Requests can only be sent to a specific instance if
     * [manual scaling is used in App Engine
     * Standard](https://cloud.google.com/appengine/docs/python/an-overview-of-app-engine?hl=en_US#scaling_types_and_instance_classes).
     * App Engine Flex does not support instances. For more information, see
     * [App Engine Standard request
     * routing](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed)
     * and [App Engine Flex request
     * routing](https://cloud.google.com/appengine/docs/flexible/python/how-requests-are-routed).
     * </pre>
     *
     * <code>string instance = 3;</code>
     *
     * @param value The bytes for instance to set.
     * @return This builder for chaining.
     */
    public Builder setInstanceBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      instance_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object host_ = "";
    /**
     *
     *
     * <pre>
     * Output only. The host that the task is sent to.
     * The host is constructed from the domain name of the app associated with
     * the queue's project ID (for example &lt;app-id&gt;.appspot.com), and the
     * [service][google.cloud.tasks.v2beta3.AppEngineRouting.service], [version][google.cloud.tasks.v2beta3.AppEngineRouting.version],
     * and [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. Tasks which were created using
     * the App Engine SDK might have a custom domain name.
     * For more information, see
     * [How Requests are
     * Routed](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed).
     * </pre>
     *
     * <code>string host = 4;</code>
     *
     * @return The host.
     */
    public java.lang.String getHost() {
      java.lang.Object ref = host_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        host_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The host that the task is sent to.
     * The host is constructed from the domain name of the app associated with
     * the queue's project ID (for example &lt;app-id&gt;.appspot.com), and the
     * [service][google.cloud.tasks.v2beta3.AppEngineRouting.service], [version][google.cloud.tasks.v2beta3.AppEngineRouting.version],
     * and [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. Tasks which were created using
     * the App Engine SDK might have a custom domain name.
     * For more information, see
     * [How Requests are
     * Routed](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed).
     * </pre>
     *
     * <code>string host = 4;</code>
     *
     * @return The bytes for host.
     */
    public com.google.protobuf.ByteString getHostBytes() {
      java.lang.Object ref = host_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        host_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The host that the task is sent to.
     * The host is constructed from the domain name of the app associated with
     * the queue's project ID (for example &lt;app-id&gt;.appspot.com), and the
     * [service][google.cloud.tasks.v2beta3.AppEngineRouting.service], [version][google.cloud.tasks.v2beta3.AppEngineRouting.version],
     * and [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. Tasks which were created using
     * the App Engine SDK might have a custom domain name.
     * For more information, see
     * [How Requests are
     * Routed](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed).
     * </pre>
     *
     * <code>string host = 4;</code>
     *
     * @param value The host to set.
     * @return This builder for chaining.
     */
    public Builder setHost(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      host_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The host that the task is sent to.
     * The host is constructed from the domain name of the app associated with
     * the queue's project ID (for example &lt;app-id&gt;.appspot.com), and the
     * [service][google.cloud.tasks.v2beta3.AppEngineRouting.service], [version][google.cloud.tasks.v2beta3.AppEngineRouting.version],
     * and [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. Tasks which were created using
     * the App Engine SDK might have a custom domain name.
     * For more information, see
     * [How Requests are
     * Routed](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed).
     * </pre>
     *
     * <code>string host = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearHost() {

      host_ = getDefaultInstance().getHost();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The host that the task is sent to.
     * The host is constructed from the domain name of the app associated with
     * the queue's project ID (for example &lt;app-id&gt;.appspot.com), and the
     * [service][google.cloud.tasks.v2beta3.AppEngineRouting.service], [version][google.cloud.tasks.v2beta3.AppEngineRouting.version],
     * and [instance][google.cloud.tasks.v2beta3.AppEngineRouting.instance]. Tasks which were created using
     * the App Engine SDK might have a custom domain name.
     * For more information, see
     * [How Requests are
     * Routed](https://cloud.google.com/appengine/docs/standard/python/how-requests-are-routed).
     * </pre>
     *
     * <code>string host = 4;</code>
     *
     * @param value The bytes for host to set.
     * @return This builder for chaining.
     */
    public Builder setHostBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      host_ = value;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.tasks.v2beta3.AppEngineRouting)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.tasks.v2beta3.AppEngineRouting)
  private static final com.google.cloud.tasks.v2beta3.AppEngineRouting DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.tasks.v2beta3.AppEngineRouting();
  }

  public static com.google.cloud.tasks.v2beta3.AppEngineRouting getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AppEngineRouting> PARSER =
      new com.google.protobuf.AbstractParser<AppEngineRouting>() {
        @java.lang.Override
        public AppEngineRouting parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new AppEngineRouting(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<AppEngineRouting> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AppEngineRouting> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.AppEngineRouting getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
