/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/tasks/v2beta3/queue.proto

package com.google.cloud.tasks.v2beta3;

/**
 *
 *
 * <pre>
 * Retry config.
 * These settings determine when a failed task attempt is retried.
 * </pre>
 *
 * Protobuf type {@code google.cloud.tasks.v2beta3.RetryConfig}
 */
public final class RetryConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.tasks.v2beta3.RetryConfig)
    RetryConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RetryConfig.newBuilder() to construct.
  private RetryConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RetryConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RetryConfig();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private RetryConfig(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 8:
            {
              maxAttempts_ = input.readInt32();
              break;
            }
          case 18:
            {
              com.google.protobuf.Duration.Builder subBuilder = null;
              if (maxRetryDuration_ != null) {
                subBuilder = maxRetryDuration_.toBuilder();
              }
              maxRetryDuration_ =
                  input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(maxRetryDuration_);
                maxRetryDuration_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              com.google.protobuf.Duration.Builder subBuilder = null;
              if (minBackoff_ != null) {
                subBuilder = minBackoff_.toBuilder();
              }
              minBackoff_ =
                  input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(minBackoff_);
                minBackoff_ = subBuilder.buildPartial();
              }

              break;
            }
          case 34:
            {
              com.google.protobuf.Duration.Builder subBuilder = null;
              if (maxBackoff_ != null) {
                subBuilder = maxBackoff_.toBuilder();
              }
              maxBackoff_ =
                  input.readMessage(com.google.protobuf.Duration.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(maxBackoff_);
                maxBackoff_ = subBuilder.buildPartial();
              }

              break;
            }
          case 40:
            {
              maxDoublings_ = input.readInt32();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.tasks.v2beta3.QueueProto
        .internal_static_google_cloud_tasks_v2beta3_RetryConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.tasks.v2beta3.QueueProto
        .internal_static_google_cloud_tasks_v2beta3_RetryConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.tasks.v2beta3.RetryConfig.class,
            com.google.cloud.tasks.v2beta3.RetryConfig.Builder.class);
  }

  public static final int MAX_ATTEMPTS_FIELD_NUMBER = 1;
  private int maxAttempts_;
  /**
   *
   *
   * <pre>
   * Number of attempts per task.
   * Cloud Tasks will attempt the task `max_attempts` times (that is, if the
   * first attempt fails, then there will be `max_attempts - 1` retries). Must
   * be &gt;= -1.
   * If unspecified when the queue is created, Cloud Tasks will pick the
   * default.
   * -1 indicates unlimited attempts.
   * This field has the same meaning as
   * [task_retry_limit in
   * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
   * </pre>
   *
   * <code>int32 max_attempts = 1;</code>
   *
   * @return The maxAttempts.
   */
  @java.lang.Override
  public int getMaxAttempts() {
    return maxAttempts_;
  }

  public static final int MAX_RETRY_DURATION_FIELD_NUMBER = 2;
  private com.google.protobuf.Duration maxRetryDuration_;
  /**
   *
   *
   * <pre>
   * If positive, `max_retry_duration` specifies the time limit for
   * retrying a failed task, measured from when the task was first
   * attempted. Once `max_retry_duration` time has passed *and* the
   * task has been attempted [max_attempts][google.cloud.tasks.v2beta3.RetryConfig.max_attempts]
   * times, no further attempts will be made and the task will be
   * deleted.
   * If zero, then the task age is unlimited.
   * If unspecified when the queue is created, Cloud Tasks will pick the
   * default.
   * `max_retry_duration` will be truncated to the nearest second.
   * This field has the same meaning as
   * [task_age_limit in
   * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
   * </pre>
   *
   * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
   *
   * @return Whether the maxRetryDuration field is set.
   */
  @java.lang.Override
  public boolean hasMaxRetryDuration() {
    return maxRetryDuration_ != null;
  }
  /**
   *
   *
   * <pre>
   * If positive, `max_retry_duration` specifies the time limit for
   * retrying a failed task, measured from when the task was first
   * attempted. Once `max_retry_duration` time has passed *and* the
   * task has been attempted [max_attempts][google.cloud.tasks.v2beta3.RetryConfig.max_attempts]
   * times, no further attempts will be made and the task will be
   * deleted.
   * If zero, then the task age is unlimited.
   * If unspecified when the queue is created, Cloud Tasks will pick the
   * default.
   * `max_retry_duration` will be truncated to the nearest second.
   * This field has the same meaning as
   * [task_age_limit in
   * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
   * </pre>
   *
   * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
   *
   * @return The maxRetryDuration.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getMaxRetryDuration() {
    return maxRetryDuration_ == null
        ? com.google.protobuf.Duration.getDefaultInstance()
        : maxRetryDuration_;
  }
  /**
   *
   *
   * <pre>
   * If positive, `max_retry_duration` specifies the time limit for
   * retrying a failed task, measured from when the task was first
   * attempted. Once `max_retry_duration` time has passed *and* the
   * task has been attempted [max_attempts][google.cloud.tasks.v2beta3.RetryConfig.max_attempts]
   * times, no further attempts will be made and the task will be
   * deleted.
   * If zero, then the task age is unlimited.
   * If unspecified when the queue is created, Cloud Tasks will pick the
   * default.
   * `max_retry_duration` will be truncated to the nearest second.
   * This field has the same meaning as
   * [task_age_limit in
   * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
   * </pre>
   *
   * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getMaxRetryDurationOrBuilder() {
    return getMaxRetryDuration();
  }

  public static final int MIN_BACKOFF_FIELD_NUMBER = 3;
  private com.google.protobuf.Duration minBackoff_;
  /**
   *
   *
   * <pre>
   * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
   * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
   * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
   * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
   * retried.
   * If unspecified when the queue is created, Cloud Tasks will pick the
   * default.
   * `min_backoff` will be truncated to the nearest second.
   * This field has the same meaning as
   * [min_backoff_seconds in
   * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
   * </pre>
   *
   * <code>.google.protobuf.Duration min_backoff = 3;</code>
   *
   * @return Whether the minBackoff field is set.
   */
  @java.lang.Override
  public boolean hasMinBackoff() {
    return minBackoff_ != null;
  }
  /**
   *
   *
   * <pre>
   * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
   * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
   * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
   * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
   * retried.
   * If unspecified when the queue is created, Cloud Tasks will pick the
   * default.
   * `min_backoff` will be truncated to the nearest second.
   * This field has the same meaning as
   * [min_backoff_seconds in
   * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
   * </pre>
   *
   * <code>.google.protobuf.Duration min_backoff = 3;</code>
   *
   * @return The minBackoff.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getMinBackoff() {
    return minBackoff_ == null ? com.google.protobuf.Duration.getDefaultInstance() : minBackoff_;
  }
  /**
   *
   *
   * <pre>
   * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
   * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
   * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
   * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
   * retried.
   * If unspecified when the queue is created, Cloud Tasks will pick the
   * default.
   * `min_backoff` will be truncated to the nearest second.
   * This field has the same meaning as
   * [min_backoff_seconds in
   * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
   * </pre>
   *
   * <code>.google.protobuf.Duration min_backoff = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getMinBackoffOrBuilder() {
    return getMinBackoff();
  }

  public static final int MAX_BACKOFF_FIELD_NUMBER = 4;
  private com.google.protobuf.Duration maxBackoff_;
  /**
   *
   *
   * <pre>
   * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
   * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
   * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
   * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
   * retried.
   * If unspecified when the queue is created, Cloud Tasks will pick the
   * default.
   * `max_backoff` will be truncated to the nearest second.
   * This field has the same meaning as
   * [max_backoff_seconds in
   * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
   * </pre>
   *
   * <code>.google.protobuf.Duration max_backoff = 4;</code>
   *
   * @return Whether the maxBackoff field is set.
   */
  @java.lang.Override
  public boolean hasMaxBackoff() {
    return maxBackoff_ != null;
  }
  /**
   *
   *
   * <pre>
   * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
   * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
   * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
   * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
   * retried.
   * If unspecified when the queue is created, Cloud Tasks will pick the
   * default.
   * `max_backoff` will be truncated to the nearest second.
   * This field has the same meaning as
   * [max_backoff_seconds in
   * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
   * </pre>
   *
   * <code>.google.protobuf.Duration max_backoff = 4;</code>
   *
   * @return The maxBackoff.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getMaxBackoff() {
    return maxBackoff_ == null ? com.google.protobuf.Duration.getDefaultInstance() : maxBackoff_;
  }
  /**
   *
   *
   * <pre>
   * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
   * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
   * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
   * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
   * retried.
   * If unspecified when the queue is created, Cloud Tasks will pick the
   * default.
   * `max_backoff` will be truncated to the nearest second.
   * This field has the same meaning as
   * [max_backoff_seconds in
   * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
   * </pre>
   *
   * <code>.google.protobuf.Duration max_backoff = 4;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getMaxBackoffOrBuilder() {
    return getMaxBackoff();
  }

  public static final int MAX_DOUBLINGS_FIELD_NUMBER = 5;
  private int maxDoublings_;
  /**
   *
   *
   * <pre>
   * The time between retries will double `max_doublings` times.
   * A task's retry interval starts at
   * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff], then doubles
   * `max_doublings` times, then increases linearly, and finally
   * retries at intervals of
   * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] up to
   * [max_attempts][google.cloud.tasks.v2beta3.RetryConfig.max_attempts] times.
   * For example, if [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] is 10s,
   * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] is 300s, and
   * `max_doublings` is 3, then the a task will first be retried in
   * 10s. The retry interval will double three times, and then
   * increase linearly by 2^3 * 10s.  Finally, the task will retry at
   * intervals of [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] until the
   * task has been attempted [max_attempts][google.cloud.tasks.v2beta3.RetryConfig.max_attempts]
   * times. Thus, the requests will retry at 10s, 20s, 40s, 80s, 160s,
   * 240s, 300s, 300s, ....
   * If unspecified when the queue is created, Cloud Tasks will pick the
   * default.
   * This field has the same meaning as
   * [max_doublings in
   * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
   * </pre>
   *
   * <code>int32 max_doublings = 5;</code>
   *
   * @return The maxDoublings.
   */
  @java.lang.Override
  public int getMaxDoublings() {
    return maxDoublings_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (maxAttempts_ != 0) {
      output.writeInt32(1, maxAttempts_);
    }
    if (maxRetryDuration_ != null) {
      output.writeMessage(2, getMaxRetryDuration());
    }
    if (minBackoff_ != null) {
      output.writeMessage(3, getMinBackoff());
    }
    if (maxBackoff_ != null) {
      output.writeMessage(4, getMaxBackoff());
    }
    if (maxDoublings_ != 0) {
      output.writeInt32(5, maxDoublings_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (maxAttempts_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, maxAttempts_);
    }
    if (maxRetryDuration_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMaxRetryDuration());
    }
    if (minBackoff_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getMinBackoff());
    }
    if (maxBackoff_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getMaxBackoff());
    }
    if (maxDoublings_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, maxDoublings_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.tasks.v2beta3.RetryConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.tasks.v2beta3.RetryConfig other =
        (com.google.cloud.tasks.v2beta3.RetryConfig) obj;

    if (getMaxAttempts() != other.getMaxAttempts()) return false;
    if (hasMaxRetryDuration() != other.hasMaxRetryDuration()) return false;
    if (hasMaxRetryDuration()) {
      if (!getMaxRetryDuration().equals(other.getMaxRetryDuration())) return false;
    }
    if (hasMinBackoff() != other.hasMinBackoff()) return false;
    if (hasMinBackoff()) {
      if (!getMinBackoff().equals(other.getMinBackoff())) return false;
    }
    if (hasMaxBackoff() != other.hasMaxBackoff()) return false;
    if (hasMaxBackoff()) {
      if (!getMaxBackoff().equals(other.getMaxBackoff())) return false;
    }
    if (getMaxDoublings() != other.getMaxDoublings()) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MAX_ATTEMPTS_FIELD_NUMBER;
    hash = (53 * hash) + getMaxAttempts();
    if (hasMaxRetryDuration()) {
      hash = (37 * hash) + MAX_RETRY_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + getMaxRetryDuration().hashCode();
    }
    if (hasMinBackoff()) {
      hash = (37 * hash) + MIN_BACKOFF_FIELD_NUMBER;
      hash = (53 * hash) + getMinBackoff().hashCode();
    }
    if (hasMaxBackoff()) {
      hash = (37 * hash) + MAX_BACKOFF_FIELD_NUMBER;
      hash = (53 * hash) + getMaxBackoff().hashCode();
    }
    hash = (37 * hash) + MAX_DOUBLINGS_FIELD_NUMBER;
    hash = (53 * hash) + getMaxDoublings();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.tasks.v2beta3.RetryConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.RetryConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.RetryConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.RetryConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.RetryConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.tasks.v2beta3.RetryConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.RetryConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.RetryConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.RetryConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.RetryConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.tasks.v2beta3.RetryConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.tasks.v2beta3.RetryConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.tasks.v2beta3.RetryConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Retry config.
   * These settings determine when a failed task attempt is retried.
   * </pre>
   *
   * Protobuf type {@code google.cloud.tasks.v2beta3.RetryConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.tasks.v2beta3.RetryConfig)
      com.google.cloud.tasks.v2beta3.RetryConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.tasks.v2beta3.QueueProto
          .internal_static_google_cloud_tasks_v2beta3_RetryConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.tasks.v2beta3.QueueProto
          .internal_static_google_cloud_tasks_v2beta3_RetryConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.tasks.v2beta3.RetryConfig.class,
              com.google.cloud.tasks.v2beta3.RetryConfig.Builder.class);
    }

    // Construct using com.google.cloud.tasks.v2beta3.RetryConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      maxAttempts_ = 0;

      if (maxRetryDurationBuilder_ == null) {
        maxRetryDuration_ = null;
      } else {
        maxRetryDuration_ = null;
        maxRetryDurationBuilder_ = null;
      }
      if (minBackoffBuilder_ == null) {
        minBackoff_ = null;
      } else {
        minBackoff_ = null;
        minBackoffBuilder_ = null;
      }
      if (maxBackoffBuilder_ == null) {
        maxBackoff_ = null;
      } else {
        maxBackoff_ = null;
        maxBackoffBuilder_ = null;
      }
      maxDoublings_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.tasks.v2beta3.QueueProto
          .internal_static_google_cloud_tasks_v2beta3_RetryConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.RetryConfig getDefaultInstanceForType() {
      return com.google.cloud.tasks.v2beta3.RetryConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.RetryConfig build() {
      com.google.cloud.tasks.v2beta3.RetryConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.tasks.v2beta3.RetryConfig buildPartial() {
      com.google.cloud.tasks.v2beta3.RetryConfig result =
          new com.google.cloud.tasks.v2beta3.RetryConfig(this);
      result.maxAttempts_ = maxAttempts_;
      if (maxRetryDurationBuilder_ == null) {
        result.maxRetryDuration_ = maxRetryDuration_;
      } else {
        result.maxRetryDuration_ = maxRetryDurationBuilder_.build();
      }
      if (minBackoffBuilder_ == null) {
        result.minBackoff_ = minBackoff_;
      } else {
        result.minBackoff_ = minBackoffBuilder_.build();
      }
      if (maxBackoffBuilder_ == null) {
        result.maxBackoff_ = maxBackoff_;
      } else {
        result.maxBackoff_ = maxBackoffBuilder_.build();
      }
      result.maxDoublings_ = maxDoublings_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.tasks.v2beta3.RetryConfig) {
        return mergeFrom((com.google.cloud.tasks.v2beta3.RetryConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.tasks.v2beta3.RetryConfig other) {
      if (other == com.google.cloud.tasks.v2beta3.RetryConfig.getDefaultInstance()) return this;
      if (other.getMaxAttempts() != 0) {
        setMaxAttempts(other.getMaxAttempts());
      }
      if (other.hasMaxRetryDuration()) {
        mergeMaxRetryDuration(other.getMaxRetryDuration());
      }
      if (other.hasMinBackoff()) {
        mergeMinBackoff(other.getMinBackoff());
      }
      if (other.hasMaxBackoff()) {
        mergeMaxBackoff(other.getMaxBackoff());
      }
      if (other.getMaxDoublings() != 0) {
        setMaxDoublings(other.getMaxDoublings());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.tasks.v2beta3.RetryConfig parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.cloud.tasks.v2beta3.RetryConfig) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int maxAttempts_;
    /**
     *
     *
     * <pre>
     * Number of attempts per task.
     * Cloud Tasks will attempt the task `max_attempts` times (that is, if the
     * first attempt fails, then there will be `max_attempts - 1` retries). Must
     * be &gt;= -1.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * -1 indicates unlimited attempts.
     * This field has the same meaning as
     * [task_retry_limit in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>int32 max_attempts = 1;</code>
     *
     * @return The maxAttempts.
     */
    @java.lang.Override
    public int getMaxAttempts() {
      return maxAttempts_;
    }
    /**
     *
     *
     * <pre>
     * Number of attempts per task.
     * Cloud Tasks will attempt the task `max_attempts` times (that is, if the
     * first attempt fails, then there will be `max_attempts - 1` retries). Must
     * be &gt;= -1.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * -1 indicates unlimited attempts.
     * This field has the same meaning as
     * [task_retry_limit in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>int32 max_attempts = 1;</code>
     *
     * @param value The maxAttempts to set.
     * @return This builder for chaining.
     */
    public Builder setMaxAttempts(int value) {

      maxAttempts_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Number of attempts per task.
     * Cloud Tasks will attempt the task `max_attempts` times (that is, if the
     * first attempt fails, then there will be `max_attempts - 1` retries). Must
     * be &gt;= -1.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * -1 indicates unlimited attempts.
     * This field has the same meaning as
     * [task_retry_limit in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>int32 max_attempts = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxAttempts() {

      maxAttempts_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration maxRetryDuration_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        maxRetryDurationBuilder_;
    /**
     *
     *
     * <pre>
     * If positive, `max_retry_duration` specifies the time limit for
     * retrying a failed task, measured from when the task was first
     * attempted. Once `max_retry_duration` time has passed *and* the
     * task has been attempted [max_attempts][google.cloud.tasks.v2beta3.RetryConfig.max_attempts]
     * times, no further attempts will be made and the task will be
     * deleted.
     * If zero, then the task age is unlimited.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `max_retry_duration` will be truncated to the nearest second.
     * This field has the same meaning as
     * [task_age_limit in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
     *
     * @return Whether the maxRetryDuration field is set.
     */
    public boolean hasMaxRetryDuration() {
      return maxRetryDurationBuilder_ != null || maxRetryDuration_ != null;
    }
    /**
     *
     *
     * <pre>
     * If positive, `max_retry_duration` specifies the time limit for
     * retrying a failed task, measured from when the task was first
     * attempted. Once `max_retry_duration` time has passed *and* the
     * task has been attempted [max_attempts][google.cloud.tasks.v2beta3.RetryConfig.max_attempts]
     * times, no further attempts will be made and the task will be
     * deleted.
     * If zero, then the task age is unlimited.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `max_retry_duration` will be truncated to the nearest second.
     * This field has the same meaning as
     * [task_age_limit in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
     *
     * @return The maxRetryDuration.
     */
    public com.google.protobuf.Duration getMaxRetryDuration() {
      if (maxRetryDurationBuilder_ == null) {
        return maxRetryDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maxRetryDuration_;
      } else {
        return maxRetryDurationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If positive, `max_retry_duration` specifies the time limit for
     * retrying a failed task, measured from when the task was first
     * attempted. Once `max_retry_duration` time has passed *and* the
     * task has been attempted [max_attempts][google.cloud.tasks.v2beta3.RetryConfig.max_attempts]
     * times, no further attempts will be made and the task will be
     * deleted.
     * If zero, then the task age is unlimited.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `max_retry_duration` will be truncated to the nearest second.
     * This field has the same meaning as
     * [task_age_limit in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
     */
    public Builder setMaxRetryDuration(com.google.protobuf.Duration value) {
      if (maxRetryDurationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maxRetryDuration_ = value;
        onChanged();
      } else {
        maxRetryDurationBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If positive, `max_retry_duration` specifies the time limit for
     * retrying a failed task, measured from when the task was first
     * attempted. Once `max_retry_duration` time has passed *and* the
     * task has been attempted [max_attempts][google.cloud.tasks.v2beta3.RetryConfig.max_attempts]
     * times, no further attempts will be made and the task will be
     * deleted.
     * If zero, then the task age is unlimited.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `max_retry_duration` will be truncated to the nearest second.
     * This field has the same meaning as
     * [task_age_limit in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
     */
    public Builder setMaxRetryDuration(com.google.protobuf.Duration.Builder builderForValue) {
      if (maxRetryDurationBuilder_ == null) {
        maxRetryDuration_ = builderForValue.build();
        onChanged();
      } else {
        maxRetryDurationBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If positive, `max_retry_duration` specifies the time limit for
     * retrying a failed task, measured from when the task was first
     * attempted. Once `max_retry_duration` time has passed *and* the
     * task has been attempted [max_attempts][google.cloud.tasks.v2beta3.RetryConfig.max_attempts]
     * times, no further attempts will be made and the task will be
     * deleted.
     * If zero, then the task age is unlimited.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `max_retry_duration` will be truncated to the nearest second.
     * This field has the same meaning as
     * [task_age_limit in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
     */
    public Builder mergeMaxRetryDuration(com.google.protobuf.Duration value) {
      if (maxRetryDurationBuilder_ == null) {
        if (maxRetryDuration_ != null) {
          maxRetryDuration_ =
              com.google.protobuf.Duration.newBuilder(maxRetryDuration_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          maxRetryDuration_ = value;
        }
        onChanged();
      } else {
        maxRetryDurationBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If positive, `max_retry_duration` specifies the time limit for
     * retrying a failed task, measured from when the task was first
     * attempted. Once `max_retry_duration` time has passed *and* the
     * task has been attempted [max_attempts][google.cloud.tasks.v2beta3.RetryConfig.max_attempts]
     * times, no further attempts will be made and the task will be
     * deleted.
     * If zero, then the task age is unlimited.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `max_retry_duration` will be truncated to the nearest second.
     * This field has the same meaning as
     * [task_age_limit in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
     */
    public Builder clearMaxRetryDuration() {
      if (maxRetryDurationBuilder_ == null) {
        maxRetryDuration_ = null;
        onChanged();
      } else {
        maxRetryDuration_ = null;
        maxRetryDurationBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * If positive, `max_retry_duration` specifies the time limit for
     * retrying a failed task, measured from when the task was first
     * attempted. Once `max_retry_duration` time has passed *and* the
     * task has been attempted [max_attempts][google.cloud.tasks.v2beta3.RetryConfig.max_attempts]
     * times, no further attempts will be made and the task will be
     * deleted.
     * If zero, then the task age is unlimited.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `max_retry_duration` will be truncated to the nearest second.
     * This field has the same meaning as
     * [task_age_limit in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
     */
    public com.google.protobuf.Duration.Builder getMaxRetryDurationBuilder() {

      onChanged();
      return getMaxRetryDurationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If positive, `max_retry_duration` specifies the time limit for
     * retrying a failed task, measured from when the task was first
     * attempted. Once `max_retry_duration` time has passed *and* the
     * task has been attempted [max_attempts][google.cloud.tasks.v2beta3.RetryConfig.max_attempts]
     * times, no further attempts will be made and the task will be
     * deleted.
     * If zero, then the task age is unlimited.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `max_retry_duration` will be truncated to the nearest second.
     * This field has the same meaning as
     * [task_age_limit in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
     */
    public com.google.protobuf.DurationOrBuilder getMaxRetryDurationOrBuilder() {
      if (maxRetryDurationBuilder_ != null) {
        return maxRetryDurationBuilder_.getMessageOrBuilder();
      } else {
        return maxRetryDuration_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maxRetryDuration_;
      }
    }
    /**
     *
     *
     * <pre>
     * If positive, `max_retry_duration` specifies the time limit for
     * retrying a failed task, measured from when the task was first
     * attempted. Once `max_retry_duration` time has passed *and* the
     * task has been attempted [max_attempts][google.cloud.tasks.v2beta3.RetryConfig.max_attempts]
     * times, no further attempts will be made and the task will be
     * deleted.
     * If zero, then the task age is unlimited.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `max_retry_duration` will be truncated to the nearest second.
     * This field has the same meaning as
     * [task_age_limit in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_retry_duration = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getMaxRetryDurationFieldBuilder() {
      if (maxRetryDurationBuilder_ == null) {
        maxRetryDurationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getMaxRetryDuration(), getParentForChildren(), isClean());
        maxRetryDuration_ = null;
      }
      return maxRetryDurationBuilder_;
    }

    private com.google.protobuf.Duration minBackoff_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        minBackoffBuilder_;
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
     * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
     * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
     * retried.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `min_backoff` will be truncated to the nearest second.
     * This field has the same meaning as
     * [min_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff = 3;</code>
     *
     * @return Whether the minBackoff field is set.
     */
    public boolean hasMinBackoff() {
      return minBackoffBuilder_ != null || minBackoff_ != null;
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
     * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
     * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
     * retried.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `min_backoff` will be truncated to the nearest second.
     * This field has the same meaning as
     * [min_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff = 3;</code>
     *
     * @return The minBackoff.
     */
    public com.google.protobuf.Duration getMinBackoff() {
      if (minBackoffBuilder_ == null) {
        return minBackoff_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : minBackoff_;
      } else {
        return minBackoffBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
     * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
     * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
     * retried.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `min_backoff` will be truncated to the nearest second.
     * This field has the same meaning as
     * [min_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff = 3;</code>
     */
    public Builder setMinBackoff(com.google.protobuf.Duration value) {
      if (minBackoffBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        minBackoff_ = value;
        onChanged();
      } else {
        minBackoffBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
     * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
     * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
     * retried.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `min_backoff` will be truncated to the nearest second.
     * This field has the same meaning as
     * [min_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff = 3;</code>
     */
    public Builder setMinBackoff(com.google.protobuf.Duration.Builder builderForValue) {
      if (minBackoffBuilder_ == null) {
        minBackoff_ = builderForValue.build();
        onChanged();
      } else {
        minBackoffBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
     * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
     * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
     * retried.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `min_backoff` will be truncated to the nearest second.
     * This field has the same meaning as
     * [min_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff = 3;</code>
     */
    public Builder mergeMinBackoff(com.google.protobuf.Duration value) {
      if (minBackoffBuilder_ == null) {
        if (minBackoff_ != null) {
          minBackoff_ =
              com.google.protobuf.Duration.newBuilder(minBackoff_).mergeFrom(value).buildPartial();
        } else {
          minBackoff_ = value;
        }
        onChanged();
      } else {
        minBackoffBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
     * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
     * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
     * retried.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `min_backoff` will be truncated to the nearest second.
     * This field has the same meaning as
     * [min_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff = 3;</code>
     */
    public Builder clearMinBackoff() {
      if (minBackoffBuilder_ == null) {
        minBackoff_ = null;
        onChanged();
      } else {
        minBackoff_ = null;
        minBackoffBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
     * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
     * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
     * retried.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `min_backoff` will be truncated to the nearest second.
     * This field has the same meaning as
     * [min_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff = 3;</code>
     */
    public com.google.protobuf.Duration.Builder getMinBackoffBuilder() {

      onChanged();
      return getMinBackoffFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
     * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
     * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
     * retried.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `min_backoff` will be truncated to the nearest second.
     * This field has the same meaning as
     * [min_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff = 3;</code>
     */
    public com.google.protobuf.DurationOrBuilder getMinBackoffOrBuilder() {
      if (minBackoffBuilder_ != null) {
        return minBackoffBuilder_.getMessageOrBuilder();
      } else {
        return minBackoff_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : minBackoff_;
      }
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
     * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
     * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
     * retried.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `min_backoff` will be truncated to the nearest second.
     * This field has the same meaning as
     * [min_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration min_backoff = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getMinBackoffFieldBuilder() {
      if (minBackoffBuilder_ == null) {
        minBackoffBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getMinBackoff(), getParentForChildren(), isClean());
        minBackoff_ = null;
      }
      return minBackoffBuilder_;
    }

    private com.google.protobuf.Duration maxBackoff_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        maxBackoffBuilder_;
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
     * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
     * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
     * retried.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `max_backoff` will be truncated to the nearest second.
     * This field has the same meaning as
     * [max_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff = 4;</code>
     *
     * @return Whether the maxBackoff field is set.
     */
    public boolean hasMaxBackoff() {
      return maxBackoffBuilder_ != null || maxBackoff_ != null;
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
     * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
     * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
     * retried.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `max_backoff` will be truncated to the nearest second.
     * This field has the same meaning as
     * [max_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff = 4;</code>
     *
     * @return The maxBackoff.
     */
    public com.google.protobuf.Duration getMaxBackoff() {
      if (maxBackoffBuilder_ == null) {
        return maxBackoff_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maxBackoff_;
      } else {
        return maxBackoffBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
     * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
     * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
     * retried.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `max_backoff` will be truncated to the nearest second.
     * This field has the same meaning as
     * [max_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff = 4;</code>
     */
    public Builder setMaxBackoff(com.google.protobuf.Duration value) {
      if (maxBackoffBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maxBackoff_ = value;
        onChanged();
      } else {
        maxBackoffBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
     * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
     * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
     * retried.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `max_backoff` will be truncated to the nearest second.
     * This field has the same meaning as
     * [max_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff = 4;</code>
     */
    public Builder setMaxBackoff(com.google.protobuf.Duration.Builder builderForValue) {
      if (maxBackoffBuilder_ == null) {
        maxBackoff_ = builderForValue.build();
        onChanged();
      } else {
        maxBackoffBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
     * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
     * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
     * retried.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `max_backoff` will be truncated to the nearest second.
     * This field has the same meaning as
     * [max_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff = 4;</code>
     */
    public Builder mergeMaxBackoff(com.google.protobuf.Duration value) {
      if (maxBackoffBuilder_ == null) {
        if (maxBackoff_ != null) {
          maxBackoff_ =
              com.google.protobuf.Duration.newBuilder(maxBackoff_).mergeFrom(value).buildPartial();
        } else {
          maxBackoff_ = value;
        }
        onChanged();
      } else {
        maxBackoffBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
     * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
     * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
     * retried.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `max_backoff` will be truncated to the nearest second.
     * This field has the same meaning as
     * [max_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff = 4;</code>
     */
    public Builder clearMaxBackoff() {
      if (maxBackoffBuilder_ == null) {
        maxBackoff_ = null;
        onChanged();
      } else {
        maxBackoff_ = null;
        maxBackoffBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
     * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
     * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
     * retried.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `max_backoff` will be truncated to the nearest second.
     * This field has the same meaning as
     * [max_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff = 4;</code>
     */
    public com.google.protobuf.Duration.Builder getMaxBackoffBuilder() {

      onChanged();
      return getMaxBackoffFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
     * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
     * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
     * retried.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `max_backoff` will be truncated to the nearest second.
     * This field has the same meaning as
     * [max_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff = 4;</code>
     */
    public com.google.protobuf.DurationOrBuilder getMaxBackoffOrBuilder() {
      if (maxBackoffBuilder_ != null) {
        return maxBackoffBuilder_.getMessageOrBuilder();
      } else {
        return maxBackoff_ == null
            ? com.google.protobuf.Duration.getDefaultInstance()
            : maxBackoff_;
      }
    }
    /**
     *
     *
     * <pre>
     * A task will be [scheduled][google.cloud.tasks.v2beta3.Task.schedule_time] for retry between
     * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] and
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] duration after it fails,
     * if the queue's [RetryConfig][google.cloud.tasks.v2beta3.RetryConfig] specifies that the task should be
     * retried.
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * `max_backoff` will be truncated to the nearest second.
     * This field has the same meaning as
     * [max_backoff_seconds in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>.google.protobuf.Duration max_backoff = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getMaxBackoffFieldBuilder() {
      if (maxBackoffBuilder_ == null) {
        maxBackoffBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(
                getMaxBackoff(), getParentForChildren(), isClean());
        maxBackoff_ = null;
      }
      return maxBackoffBuilder_;
    }

    private int maxDoublings_;
    /**
     *
     *
     * <pre>
     * The time between retries will double `max_doublings` times.
     * A task's retry interval starts at
     * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff], then doubles
     * `max_doublings` times, then increases linearly, and finally
     * retries at intervals of
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] up to
     * [max_attempts][google.cloud.tasks.v2beta3.RetryConfig.max_attempts] times.
     * For example, if [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] is 10s,
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] is 300s, and
     * `max_doublings` is 3, then the a task will first be retried in
     * 10s. The retry interval will double three times, and then
     * increase linearly by 2^3 * 10s.  Finally, the task will retry at
     * intervals of [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] until the
     * task has been attempted [max_attempts][google.cloud.tasks.v2beta3.RetryConfig.max_attempts]
     * times. Thus, the requests will retry at 10s, 20s, 40s, 80s, 160s,
     * 240s, 300s, 300s, ....
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * This field has the same meaning as
     * [max_doublings in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>int32 max_doublings = 5;</code>
     *
     * @return The maxDoublings.
     */
    @java.lang.Override
    public int getMaxDoublings() {
      return maxDoublings_;
    }
    /**
     *
     *
     * <pre>
     * The time between retries will double `max_doublings` times.
     * A task's retry interval starts at
     * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff], then doubles
     * `max_doublings` times, then increases linearly, and finally
     * retries at intervals of
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] up to
     * [max_attempts][google.cloud.tasks.v2beta3.RetryConfig.max_attempts] times.
     * For example, if [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] is 10s,
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] is 300s, and
     * `max_doublings` is 3, then the a task will first be retried in
     * 10s. The retry interval will double three times, and then
     * increase linearly by 2^3 * 10s.  Finally, the task will retry at
     * intervals of [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] until the
     * task has been attempted [max_attempts][google.cloud.tasks.v2beta3.RetryConfig.max_attempts]
     * times. Thus, the requests will retry at 10s, 20s, 40s, 80s, 160s,
     * 240s, 300s, 300s, ....
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * This field has the same meaning as
     * [max_doublings in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>int32 max_doublings = 5;</code>
     *
     * @param value The maxDoublings to set.
     * @return This builder for chaining.
     */
    public Builder setMaxDoublings(int value) {

      maxDoublings_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The time between retries will double `max_doublings` times.
     * A task's retry interval starts at
     * [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff], then doubles
     * `max_doublings` times, then increases linearly, and finally
     * retries at intervals of
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] up to
     * [max_attempts][google.cloud.tasks.v2beta3.RetryConfig.max_attempts] times.
     * For example, if [min_backoff][google.cloud.tasks.v2beta3.RetryConfig.min_backoff] is 10s,
     * [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] is 300s, and
     * `max_doublings` is 3, then the a task will first be retried in
     * 10s. The retry interval will double three times, and then
     * increase linearly by 2^3 * 10s.  Finally, the task will retry at
     * intervals of [max_backoff][google.cloud.tasks.v2beta3.RetryConfig.max_backoff] until the
     * task has been attempted [max_attempts][google.cloud.tasks.v2beta3.RetryConfig.max_attempts]
     * times. Thus, the requests will retry at 10s, 20s, 40s, 80s, 160s,
     * 240s, 300s, 300s, ....
     * If unspecified when the queue is created, Cloud Tasks will pick the
     * default.
     * This field has the same meaning as
     * [max_doublings in
     * queue.yaml/xml](https://cloud.google.com/appengine/docs/standard/python/config/queueref#retry_parameters).
     * </pre>
     *
     * <code>int32 max_doublings = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxDoublings() {

      maxDoublings_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.tasks.v2beta3.RetryConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.tasks.v2beta3.RetryConfig)
  private static final com.google.cloud.tasks.v2beta3.RetryConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.tasks.v2beta3.RetryConfig();
  }

  public static com.google.cloud.tasks.v2beta3.RetryConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RetryConfig> PARSER =
      new com.google.protobuf.AbstractParser<RetryConfig>() {
        @java.lang.Override
        public RetryConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new RetryConfig(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<RetryConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RetryConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.tasks.v2beta3.RetryConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
