/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.telcoautomation.v1alpha1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BlueprintName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ORCHESTRATION_CLUSTER_BLUEPRINT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/orchestrationClusters/{orchestration_cluster}/blueprints/{blueprint}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String orchestrationCluster;
    private final String blueprint;

    @Deprecated
    protected BlueprintName() {
        this.project = null;
        this.location = null;
        this.orchestrationCluster = null;
        this.blueprint = null;
    }

    private BlueprintName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.orchestrationCluster = (String)Preconditions.checkNotNull((Object)builder.getOrchestrationCluster());
        this.blueprint = (String)Preconditions.checkNotNull((Object)builder.getBlueprint());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getOrchestrationCluster() {
        return this.orchestrationCluster;
    }

    public String getBlueprint() {
        return this.blueprint;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BlueprintName of(String project, String location, String orchestrationCluster, String blueprint) {
        return BlueprintName.newBuilder().setProject(project).setLocation(location).setOrchestrationCluster(orchestrationCluster).setBlueprint(blueprint).build();
    }

    public static String format(String project, String location, String orchestrationCluster, String blueprint) {
        return BlueprintName.newBuilder().setProject(project).setLocation(location).setOrchestrationCluster(orchestrationCluster).setBlueprint(blueprint).build().toString();
    }

    public static BlueprintName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ORCHESTRATION_CLUSTER_BLUEPRINT.validatedMatch(formattedString, "BlueprintName.parse: formattedString not in valid format");
        return BlueprintName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("orchestration_cluster"), (String)matchMap.get("blueprint"));
    }

    public static List<BlueprintName> parseList(List<String> formattedStrings) {
        ArrayList<BlueprintName> list = new ArrayList<BlueprintName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BlueprintName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BlueprintName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BlueprintName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ORCHESTRATION_CLUSTER_BLUEPRINT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BlueprintName blueprintName = this;
            synchronized (blueprintName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.orchestrationCluster != null) {
                        fieldMapBuilder.put((Object)"orchestration_cluster", (Object)this.orchestrationCluster);
                    }
                    if (this.blueprint != null) {
                        fieldMapBuilder.put((Object)"blueprint", (Object)this.blueprint);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ORCHESTRATION_CLUSTER_BLUEPRINT.instantiate(new String[]{"project", this.project, "location", this.location, "orchestration_cluster", this.orchestrationCluster, "blueprint", this.blueprint});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BlueprintName that = (BlueprintName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.orchestrationCluster, that.orchestrationCluster) && Objects.equals(this.blueprint, that.blueprint);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.orchestrationCluster);
        h *= 1000003;
        return h ^= Objects.hashCode(this.blueprint);
    }

    public static class Builder {
        private String project;
        private String location;
        private String orchestrationCluster;
        private String blueprint;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getOrchestrationCluster() {
            return this.orchestrationCluster;
        }

        public String getBlueprint() {
            return this.blueprint;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setOrchestrationCluster(String orchestrationCluster) {
            this.orchestrationCluster = orchestrationCluster;
            return this;
        }

        public Builder setBlueprint(String blueprint) {
            this.blueprint = blueprint;
            return this;
        }

        private Builder(BlueprintName blueprintName) {
            this.project = blueprintName.project;
            this.location = blueprintName.location;
            this.orchestrationCluster = blueprintName.orchestrationCluster;
            this.blueprint = blueprintName.blueprint;
        }

        public BlueprintName build() {
            return new BlueprintName(this);
        }
    }
}

