/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.telcoautomation.v1alpha1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HydratedDeploymentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ORCHESTRATION_CLUSTER_DEPLOYMENT_HYDRATED_DEPLOYMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/orchestrationClusters/{orchestration_cluster}/deployments/{deployment}/hydratedDeployments/{hydrated_deployment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String orchestrationCluster;
    private final String deployment;
    private final String hydratedDeployment;

    @Deprecated
    protected HydratedDeploymentName() {
        this.project = null;
        this.location = null;
        this.orchestrationCluster = null;
        this.deployment = null;
        this.hydratedDeployment = null;
    }

    private HydratedDeploymentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.orchestrationCluster = (String)Preconditions.checkNotNull((Object)builder.getOrchestrationCluster());
        this.deployment = (String)Preconditions.checkNotNull((Object)builder.getDeployment());
        this.hydratedDeployment = (String)Preconditions.checkNotNull((Object)builder.getHydratedDeployment());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getOrchestrationCluster() {
        return this.orchestrationCluster;
    }

    public String getDeployment() {
        return this.deployment;
    }

    public String getHydratedDeployment() {
        return this.hydratedDeployment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static HydratedDeploymentName of(String project, String location, String orchestrationCluster, String deployment, String hydratedDeployment) {
        return HydratedDeploymentName.newBuilder().setProject(project).setLocation(location).setOrchestrationCluster(orchestrationCluster).setDeployment(deployment).setHydratedDeployment(hydratedDeployment).build();
    }

    public static String format(String project, String location, String orchestrationCluster, String deployment, String hydratedDeployment) {
        return HydratedDeploymentName.newBuilder().setProject(project).setLocation(location).setOrchestrationCluster(orchestrationCluster).setDeployment(deployment).setHydratedDeployment(hydratedDeployment).build().toString();
    }

    public static HydratedDeploymentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ORCHESTRATION_CLUSTER_DEPLOYMENT_HYDRATED_DEPLOYMENT.validatedMatch(formattedString, "HydratedDeploymentName.parse: formattedString not in valid format");
        return HydratedDeploymentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("orchestration_cluster"), (String)matchMap.get("deployment"), (String)matchMap.get("hydrated_deployment"));
    }

    public static List<HydratedDeploymentName> parseList(List<String> formattedStrings) {
        ArrayList<HydratedDeploymentName> list = new ArrayList<HydratedDeploymentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(HydratedDeploymentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<HydratedDeploymentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (HydratedDeploymentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ORCHESTRATION_CLUSTER_DEPLOYMENT_HYDRATED_DEPLOYMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            HydratedDeploymentName hydratedDeploymentName = this;
            synchronized (hydratedDeploymentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.orchestrationCluster != null) {
                        fieldMapBuilder.put((Object)"orchestration_cluster", (Object)this.orchestrationCluster);
                    }
                    if (this.deployment != null) {
                        fieldMapBuilder.put((Object)"deployment", (Object)this.deployment);
                    }
                    if (this.hydratedDeployment != null) {
                        fieldMapBuilder.put((Object)"hydrated_deployment", (Object)this.hydratedDeployment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ORCHESTRATION_CLUSTER_DEPLOYMENT_HYDRATED_DEPLOYMENT.instantiate(new String[]{"project", this.project, "location", this.location, "orchestration_cluster", this.orchestrationCluster, "deployment", this.deployment, "hydrated_deployment", this.hydratedDeployment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            HydratedDeploymentName that = (HydratedDeploymentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.orchestrationCluster, that.orchestrationCluster) && Objects.equals(this.deployment, that.deployment) && Objects.equals(this.hydratedDeployment, that.hydratedDeployment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.orchestrationCluster);
        h *= 1000003;
        h ^= Objects.hashCode(this.deployment);
        h *= 1000003;
        return h ^= Objects.hashCode(this.hydratedDeployment);
    }

    public static class Builder {
        private String project;
        private String location;
        private String orchestrationCluster;
        private String deployment;
        private String hydratedDeployment;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getOrchestrationCluster() {
            return this.orchestrationCluster;
        }

        public String getDeployment() {
            return this.deployment;
        }

        public String getHydratedDeployment() {
            return this.hydratedDeployment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setOrchestrationCluster(String orchestrationCluster) {
            this.orchestrationCluster = orchestrationCluster;
            return this;
        }

        public Builder setDeployment(String deployment) {
            this.deployment = deployment;
            return this;
        }

        public Builder setHydratedDeployment(String hydratedDeployment) {
            this.hydratedDeployment = hydratedDeployment;
            return this;
        }

        private Builder(HydratedDeploymentName hydratedDeploymentName) {
            this.project = hydratedDeploymentName.project;
            this.location = hydratedDeploymentName.location;
            this.orchestrationCluster = hydratedDeploymentName.orchestrationCluster;
            this.deployment = hydratedDeploymentName.deployment;
            this.hydratedDeployment = hydratedDeploymentName.hydratedDeployment;
        }

        public HydratedDeploymentName build() {
            return new HydratedDeploymentName(this);
        }
    }
}

