/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/texttospeech/v1/cloud_tts.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.texttospeech.v1;

/**
 *
 *
 * <pre>
 * Request message for the `StreamingSynthesize` method. Multiple
 * `StreamingSynthesizeRequest` messages are sent in one call.
 * The first message must contain a `streaming_config` that
 * fully specifies the request configuration and must not contain `input`. All
 * subsequent messages must only have `input` set.
 * </pre>
 *
 * Protobuf type {@code google.cloud.texttospeech.v1.StreamingSynthesizeRequest}
 */
public final class StreamingSynthesizeRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.texttospeech.v1.StreamingSynthesizeRequest)
    StreamingSynthesizeRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StreamingSynthesizeRequest.newBuilder() to construct.
  private StreamingSynthesizeRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StreamingSynthesizeRequest() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StreamingSynthesizeRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.texttospeech.v1.TextToSpeechProto
        .internal_static_google_cloud_texttospeech_v1_StreamingSynthesizeRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.texttospeech.v1.TextToSpeechProto
        .internal_static_google_cloud_texttospeech_v1_StreamingSynthesizeRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest.class,
            com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest.Builder.class);
  }

  private int streamingRequestCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object streamingRequest_;

  public enum StreamingRequestCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    STREAMING_CONFIG(1),
    INPUT(2),
    STREAMINGREQUEST_NOT_SET(0);
    private final int value;

    private StreamingRequestCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static StreamingRequestCase valueOf(int value) {
      return forNumber(value);
    }

    public static StreamingRequestCase forNumber(int value) {
      switch (value) {
        case 1:
          return STREAMING_CONFIG;
        case 2:
          return INPUT;
        case 0:
          return STREAMINGREQUEST_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public StreamingRequestCase getStreamingRequestCase() {
    return StreamingRequestCase.forNumber(streamingRequestCase_);
  }

  public static final int STREAMING_CONFIG_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * StreamingSynthesizeConfig to be used in this streaming attempt. Only
   * specified in the first message sent in a `StreamingSynthesize` call.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1.StreamingSynthesizeConfig streaming_config = 1;</code>
   *
   * @return Whether the streamingConfig field is set.
   */
  @java.lang.Override
  public boolean hasStreamingConfig() {
    return streamingRequestCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * StreamingSynthesizeConfig to be used in this streaming attempt. Only
   * specified in the first message sent in a `StreamingSynthesize` call.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1.StreamingSynthesizeConfig streaming_config = 1;</code>
   *
   * @return The streamingConfig.
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig getStreamingConfig() {
    if (streamingRequestCase_ == 1) {
      return (com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig) streamingRequest_;
    }
    return com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * StreamingSynthesizeConfig to be used in this streaming attempt. Only
   * specified in the first message sent in a `StreamingSynthesize` call.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1.StreamingSynthesizeConfig streaming_config = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1.StreamingSynthesizeConfigOrBuilder
      getStreamingConfigOrBuilder() {
    if (streamingRequestCase_ == 1) {
      return (com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig) streamingRequest_;
    }
    return com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig.getDefaultInstance();
  }

  public static final int INPUT_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Input to synthesize. Specified in all messages but the first in a
   * `StreamingSynthesize` call.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1.StreamingSynthesisInput input = 2;</code>
   *
   * @return Whether the input field is set.
   */
  @java.lang.Override
  public boolean hasInput() {
    return streamingRequestCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Input to synthesize. Specified in all messages but the first in a
   * `StreamingSynthesize` call.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1.StreamingSynthesisInput input = 2;</code>
   *
   * @return The input.
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1.StreamingSynthesisInput getInput() {
    if (streamingRequestCase_ == 2) {
      return (com.google.cloud.texttospeech.v1.StreamingSynthesisInput) streamingRequest_;
    }
    return com.google.cloud.texttospeech.v1.StreamingSynthesisInput.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Input to synthesize. Specified in all messages but the first in a
   * `StreamingSynthesize` call.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1.StreamingSynthesisInput input = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1.StreamingSynthesisInputOrBuilder getInputOrBuilder() {
    if (streamingRequestCase_ == 2) {
      return (com.google.cloud.texttospeech.v1.StreamingSynthesisInput) streamingRequest_;
    }
    return com.google.cloud.texttospeech.v1.StreamingSynthesisInput.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (streamingRequestCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig) streamingRequest_);
    }
    if (streamingRequestCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.texttospeech.v1.StreamingSynthesisInput) streamingRequest_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (streamingRequestCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig) streamingRequest_);
    }
    if (streamingRequestCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.texttospeech.v1.StreamingSynthesisInput) streamingRequest_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest other =
        (com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest) obj;

    if (!getStreamingRequestCase().equals(other.getStreamingRequestCase())) return false;
    switch (streamingRequestCase_) {
      case 1:
        if (!getStreamingConfig().equals(other.getStreamingConfig())) return false;
        break;
      case 2:
        if (!getInput().equals(other.getInput())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (streamingRequestCase_) {
      case 1:
        hash = (37 * hash) + STREAMING_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getStreamingConfig().hashCode();
        break;
      case 2:
        hash = (37 * hash) + INPUT_FIELD_NUMBER;
        hash = (53 * hash) + getInput().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for the `StreamingSynthesize` method. Multiple
   * `StreamingSynthesizeRequest` messages are sent in one call.
   * The first message must contain a `streaming_config` that
   * fully specifies the request configuration and must not contain `input`. All
   * subsequent messages must only have `input` set.
   * </pre>
   *
   * Protobuf type {@code google.cloud.texttospeech.v1.StreamingSynthesizeRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.texttospeech.v1.StreamingSynthesizeRequest)
      com.google.cloud.texttospeech.v1.StreamingSynthesizeRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.texttospeech.v1.TextToSpeechProto
          .internal_static_google_cloud_texttospeech_v1_StreamingSynthesizeRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.texttospeech.v1.TextToSpeechProto
          .internal_static_google_cloud_texttospeech_v1_StreamingSynthesizeRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest.class,
              com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest.Builder.class);
    }

    // Construct using com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (streamingConfigBuilder_ != null) {
        streamingConfigBuilder_.clear();
      }
      if (inputBuilder_ != null) {
        inputBuilder_.clear();
      }
      streamingRequestCase_ = 0;
      streamingRequest_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.texttospeech.v1.TextToSpeechProto
          .internal_static_google_cloud_texttospeech_v1_StreamingSynthesizeRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest getDefaultInstanceForType() {
      return com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest build() {
      com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest buildPartial() {
      com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest result =
          new com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest result) {
      result.streamingRequestCase_ = streamingRequestCase_;
      result.streamingRequest_ = this.streamingRequest_;
      if (streamingRequestCase_ == 1 && streamingConfigBuilder_ != null) {
        result.streamingRequest_ = streamingConfigBuilder_.build();
      }
      if (streamingRequestCase_ == 2 && inputBuilder_ != null) {
        result.streamingRequest_ = inputBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest) {
        return mergeFrom((com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest other) {
      if (other == com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest.getDefaultInstance())
        return this;
      switch (other.getStreamingRequestCase()) {
        case STREAMING_CONFIG:
          {
            mergeStreamingConfig(other.getStreamingConfig());
            break;
          }
        case INPUT:
          {
            mergeInput(other.getInput());
            break;
          }
        case STREAMINGREQUEST_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getStreamingConfigFieldBuilder().getBuilder(), extensionRegistry);
                streamingRequestCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getInputFieldBuilder().getBuilder(), extensionRegistry);
                streamingRequestCase_ = 2;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int streamingRequestCase_ = 0;
    private java.lang.Object streamingRequest_;

    public StreamingRequestCase getStreamingRequestCase() {
      return StreamingRequestCase.forNumber(streamingRequestCase_);
    }

    public Builder clearStreamingRequest() {
      streamingRequestCase_ = 0;
      streamingRequest_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig,
            com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig.Builder,
            com.google.cloud.texttospeech.v1.StreamingSynthesizeConfigOrBuilder>
        streamingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * StreamingSynthesizeConfig to be used in this streaming attempt. Only
     * specified in the first message sent in a `StreamingSynthesize` call.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.StreamingSynthesizeConfig streaming_config = 1;</code>
     *
     * @return Whether the streamingConfig field is set.
     */
    @java.lang.Override
    public boolean hasStreamingConfig() {
      return streamingRequestCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * StreamingSynthesizeConfig to be used in this streaming attempt. Only
     * specified in the first message sent in a `StreamingSynthesize` call.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.StreamingSynthesizeConfig streaming_config = 1;</code>
     *
     * @return The streamingConfig.
     */
    @java.lang.Override
    public com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig getStreamingConfig() {
      if (streamingConfigBuilder_ == null) {
        if (streamingRequestCase_ == 1) {
          return (com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig) streamingRequest_;
        }
        return com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig.getDefaultInstance();
      } else {
        if (streamingRequestCase_ == 1) {
          return streamingConfigBuilder_.getMessage();
        }
        return com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * StreamingSynthesizeConfig to be used in this streaming attempt. Only
     * specified in the first message sent in a `StreamingSynthesize` call.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.StreamingSynthesizeConfig streaming_config = 1;</code>
     */
    public Builder setStreamingConfig(
        com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig value) {
      if (streamingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        streamingRequest_ = value;
        onChanged();
      } else {
        streamingConfigBuilder_.setMessage(value);
      }
      streamingRequestCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * StreamingSynthesizeConfig to be used in this streaming attempt. Only
     * specified in the first message sent in a `StreamingSynthesize` call.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.StreamingSynthesizeConfig streaming_config = 1;</code>
     */
    public Builder setStreamingConfig(
        com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig.Builder builderForValue) {
      if (streamingConfigBuilder_ == null) {
        streamingRequest_ = builderForValue.build();
        onChanged();
      } else {
        streamingConfigBuilder_.setMessage(builderForValue.build());
      }
      streamingRequestCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * StreamingSynthesizeConfig to be used in this streaming attempt. Only
     * specified in the first message sent in a `StreamingSynthesize` call.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.StreamingSynthesizeConfig streaming_config = 1;</code>
     */
    public Builder mergeStreamingConfig(
        com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig value) {
      if (streamingConfigBuilder_ == null) {
        if (streamingRequestCase_ == 1
            && streamingRequest_
                != com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig
                    .getDefaultInstance()) {
          streamingRequest_ =
              com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig.newBuilder(
                      (com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig)
                          streamingRequest_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          streamingRequest_ = value;
        }
        onChanged();
      } else {
        if (streamingRequestCase_ == 1) {
          streamingConfigBuilder_.mergeFrom(value);
        } else {
          streamingConfigBuilder_.setMessage(value);
        }
      }
      streamingRequestCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * StreamingSynthesizeConfig to be used in this streaming attempt. Only
     * specified in the first message sent in a `StreamingSynthesize` call.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.StreamingSynthesizeConfig streaming_config = 1;</code>
     */
    public Builder clearStreamingConfig() {
      if (streamingConfigBuilder_ == null) {
        if (streamingRequestCase_ == 1) {
          streamingRequestCase_ = 0;
          streamingRequest_ = null;
          onChanged();
        }
      } else {
        if (streamingRequestCase_ == 1) {
          streamingRequestCase_ = 0;
          streamingRequest_ = null;
        }
        streamingConfigBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * StreamingSynthesizeConfig to be used in this streaming attempt. Only
     * specified in the first message sent in a `StreamingSynthesize` call.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.StreamingSynthesizeConfig streaming_config = 1;</code>
     */
    public com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig.Builder
        getStreamingConfigBuilder() {
      return getStreamingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * StreamingSynthesizeConfig to be used in this streaming attempt. Only
     * specified in the first message sent in a `StreamingSynthesize` call.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.StreamingSynthesizeConfig streaming_config = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.texttospeech.v1.StreamingSynthesizeConfigOrBuilder
        getStreamingConfigOrBuilder() {
      if ((streamingRequestCase_ == 1) && (streamingConfigBuilder_ != null)) {
        return streamingConfigBuilder_.getMessageOrBuilder();
      } else {
        if (streamingRequestCase_ == 1) {
          return (com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig) streamingRequest_;
        }
        return com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * StreamingSynthesizeConfig to be used in this streaming attempt. Only
     * specified in the first message sent in a `StreamingSynthesize` call.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.StreamingSynthesizeConfig streaming_config = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig,
            com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig.Builder,
            com.google.cloud.texttospeech.v1.StreamingSynthesizeConfigOrBuilder>
        getStreamingConfigFieldBuilder() {
      if (streamingConfigBuilder_ == null) {
        if (!(streamingRequestCase_ == 1)) {
          streamingRequest_ =
              com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig.getDefaultInstance();
        }
        streamingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig,
                com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig.Builder,
                com.google.cloud.texttospeech.v1.StreamingSynthesizeConfigOrBuilder>(
                (com.google.cloud.texttospeech.v1.StreamingSynthesizeConfig) streamingRequest_,
                getParentForChildren(),
                isClean());
        streamingRequest_ = null;
      }
      streamingRequestCase_ = 1;
      onChanged();
      return streamingConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.texttospeech.v1.StreamingSynthesisInput,
            com.google.cloud.texttospeech.v1.StreamingSynthesisInput.Builder,
            com.google.cloud.texttospeech.v1.StreamingSynthesisInputOrBuilder>
        inputBuilder_;
    /**
     *
     *
     * <pre>
     * Input to synthesize. Specified in all messages but the first in a
     * `StreamingSynthesize` call.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.StreamingSynthesisInput input = 2;</code>
     *
     * @return Whether the input field is set.
     */
    @java.lang.Override
    public boolean hasInput() {
      return streamingRequestCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Input to synthesize. Specified in all messages but the first in a
     * `StreamingSynthesize` call.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.StreamingSynthesisInput input = 2;</code>
     *
     * @return The input.
     */
    @java.lang.Override
    public com.google.cloud.texttospeech.v1.StreamingSynthesisInput getInput() {
      if (inputBuilder_ == null) {
        if (streamingRequestCase_ == 2) {
          return (com.google.cloud.texttospeech.v1.StreamingSynthesisInput) streamingRequest_;
        }
        return com.google.cloud.texttospeech.v1.StreamingSynthesisInput.getDefaultInstance();
      } else {
        if (streamingRequestCase_ == 2) {
          return inputBuilder_.getMessage();
        }
        return com.google.cloud.texttospeech.v1.StreamingSynthesisInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input to synthesize. Specified in all messages but the first in a
     * `StreamingSynthesize` call.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.StreamingSynthesisInput input = 2;</code>
     */
    public Builder setInput(com.google.cloud.texttospeech.v1.StreamingSynthesisInput value) {
      if (inputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        streamingRequest_ = value;
        onChanged();
      } else {
        inputBuilder_.setMessage(value);
      }
      streamingRequestCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input to synthesize. Specified in all messages but the first in a
     * `StreamingSynthesize` call.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.StreamingSynthesisInput input = 2;</code>
     */
    public Builder setInput(
        com.google.cloud.texttospeech.v1.StreamingSynthesisInput.Builder builderForValue) {
      if (inputBuilder_ == null) {
        streamingRequest_ = builderForValue.build();
        onChanged();
      } else {
        inputBuilder_.setMessage(builderForValue.build());
      }
      streamingRequestCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input to synthesize. Specified in all messages but the first in a
     * `StreamingSynthesize` call.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.StreamingSynthesisInput input = 2;</code>
     */
    public Builder mergeInput(com.google.cloud.texttospeech.v1.StreamingSynthesisInput value) {
      if (inputBuilder_ == null) {
        if (streamingRequestCase_ == 2
            && streamingRequest_
                != com.google.cloud.texttospeech.v1.StreamingSynthesisInput.getDefaultInstance()) {
          streamingRequest_ =
              com.google.cloud.texttospeech.v1.StreamingSynthesisInput.newBuilder(
                      (com.google.cloud.texttospeech.v1.StreamingSynthesisInput) streamingRequest_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          streamingRequest_ = value;
        }
        onChanged();
      } else {
        if (streamingRequestCase_ == 2) {
          inputBuilder_.mergeFrom(value);
        } else {
          inputBuilder_.setMessage(value);
        }
      }
      streamingRequestCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input to synthesize. Specified in all messages but the first in a
     * `StreamingSynthesize` call.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.StreamingSynthesisInput input = 2;</code>
     */
    public Builder clearInput() {
      if (inputBuilder_ == null) {
        if (streamingRequestCase_ == 2) {
          streamingRequestCase_ = 0;
          streamingRequest_ = null;
          onChanged();
        }
      } else {
        if (streamingRequestCase_ == 2) {
          streamingRequestCase_ = 0;
          streamingRequest_ = null;
        }
        inputBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Input to synthesize. Specified in all messages but the first in a
     * `StreamingSynthesize` call.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.StreamingSynthesisInput input = 2;</code>
     */
    public com.google.cloud.texttospeech.v1.StreamingSynthesisInput.Builder getInputBuilder() {
      return getInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Input to synthesize. Specified in all messages but the first in a
     * `StreamingSynthesize` call.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.StreamingSynthesisInput input = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.texttospeech.v1.StreamingSynthesisInputOrBuilder getInputOrBuilder() {
      if ((streamingRequestCase_ == 2) && (inputBuilder_ != null)) {
        return inputBuilder_.getMessageOrBuilder();
      } else {
        if (streamingRequestCase_ == 2) {
          return (com.google.cloud.texttospeech.v1.StreamingSynthesisInput) streamingRequest_;
        }
        return com.google.cloud.texttospeech.v1.StreamingSynthesisInput.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Input to synthesize. Specified in all messages but the first in a
     * `StreamingSynthesize` call.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.StreamingSynthesisInput input = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.texttospeech.v1.StreamingSynthesisInput,
            com.google.cloud.texttospeech.v1.StreamingSynthesisInput.Builder,
            com.google.cloud.texttospeech.v1.StreamingSynthesisInputOrBuilder>
        getInputFieldBuilder() {
      if (inputBuilder_ == null) {
        if (!(streamingRequestCase_ == 2)) {
          streamingRequest_ =
              com.google.cloud.texttospeech.v1.StreamingSynthesisInput.getDefaultInstance();
        }
        inputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.texttospeech.v1.StreamingSynthesisInput,
                com.google.cloud.texttospeech.v1.StreamingSynthesisInput.Builder,
                com.google.cloud.texttospeech.v1.StreamingSynthesisInputOrBuilder>(
                (com.google.cloud.texttospeech.v1.StreamingSynthesisInput) streamingRequest_,
                getParentForChildren(),
                isClean());
        streamingRequest_ = null;
      }
      streamingRequestCase_ = 2;
      onChanged();
      return inputBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.texttospeech.v1.StreamingSynthesizeRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.texttospeech.v1.StreamingSynthesizeRequest)
  private static final com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest();
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StreamingSynthesizeRequest> PARSER =
      new com.google.protobuf.AbstractParser<StreamingSynthesizeRequest>() {
        @java.lang.Override
        public StreamingSynthesizeRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StreamingSynthesizeRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StreamingSynthesizeRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.texttospeech.v1.StreamingSynthesizeRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
