/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/texttospeech/v1/cloud_tts.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.texttospeech.v1;

/**
 *
 *
 * <pre>
 * Pronunciation customization for a phrase.
 * </pre>
 *
 * Protobuf type {@code google.cloud.texttospeech.v1.CustomPronunciationParams}
 */
public final class CustomPronunciationParams extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.texttospeech.v1.CustomPronunciationParams)
    CustomPronunciationParamsOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CustomPronunciationParams.newBuilder() to construct.
  private CustomPronunciationParams(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CustomPronunciationParams() {
    phrase_ = "";
    phoneticEncoding_ = 0;
    pronunciation_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CustomPronunciationParams();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.texttospeech.v1.TextToSpeechProto
        .internal_static_google_cloud_texttospeech_v1_CustomPronunciationParams_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.texttospeech.v1.TextToSpeechProto
        .internal_static_google_cloud_texttospeech_v1_CustomPronunciationParams_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.texttospeech.v1.CustomPronunciationParams.class,
            com.google.cloud.texttospeech.v1.CustomPronunciationParams.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The phonetic encoding of the phrase.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.texttospeech.v1.CustomPronunciationParams.PhoneticEncoding}
   */
  public enum PhoneticEncoding implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>PHONETIC_ENCODING_UNSPECIFIED = 0;</code>
     */
    PHONETIC_ENCODING_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * IPA, such as apple -&gt; ˈæpəl.
     * https://en.wikipedia.org/wiki/International_Phonetic_Alphabet
     * </pre>
     *
     * <code>PHONETIC_ENCODING_IPA = 1;</code>
     */
    PHONETIC_ENCODING_IPA(1),
    /**
     *
     *
     * <pre>
     * X-SAMPA, such as apple -&gt; "{p&#64;l".
     * https://en.wikipedia.org/wiki/X-SAMPA
     * </pre>
     *
     * <code>PHONETIC_ENCODING_X_SAMPA = 2;</code>
     */
    PHONETIC_ENCODING_X_SAMPA(2),
    /**
     *
     *
     * <pre>
     * For reading-to-pron conversion to work well, the `pronunciation` field
     *  should only contain Kanji, Hiragana, and Katakana.
     *
     * The pronunciation can also contain pitch accents.
     * The start of a pitch phrase is specified with `^` and the down-pitch
     * position is specified with `!`, for example:
     *
     *     phrase:端  pronunciation:^はし
     *     phrase:箸  pronunciation:^は!し
     *     phrase:橋  pronunciation:^はし!
     *
     * We currently only support the Tokyo dialect, which allows at most one
     * down-pitch per phrase (i.e. at most one `!` between `^`).
     * </pre>
     *
     * <code>PHONETIC_ENCODING_JAPANESE_YOMIGANA = 3;</code>
     */
    PHONETIC_ENCODING_JAPANESE_YOMIGANA(3),
    /**
     *
     *
     * <pre>
     * Used to specify pronunciations for Mandarin words. See
     * https://en.wikipedia.org/wiki/Pinyin.
     *
     * For example: 朝阳, the pronunciation is "chao2 yang2". The number
     * represents the tone, and there is a space between syllables. Neutral
     * tones are represented by 5, for example 孩子 "hai2 zi5".
     * </pre>
     *
     * <code>PHONETIC_ENCODING_PINYIN = 4;</code>
     */
    PHONETIC_ENCODING_PINYIN(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified.
     * </pre>
     *
     * <code>PHONETIC_ENCODING_UNSPECIFIED = 0;</code>
     */
    public static final int PHONETIC_ENCODING_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * IPA, such as apple -&gt; ˈæpəl.
     * https://en.wikipedia.org/wiki/International_Phonetic_Alphabet
     * </pre>
     *
     * <code>PHONETIC_ENCODING_IPA = 1;</code>
     */
    public static final int PHONETIC_ENCODING_IPA_VALUE = 1;

    /**
     *
     *
     * <pre>
     * X-SAMPA, such as apple -&gt; "{p&#64;l".
     * https://en.wikipedia.org/wiki/X-SAMPA
     * </pre>
     *
     * <code>PHONETIC_ENCODING_X_SAMPA = 2;</code>
     */
    public static final int PHONETIC_ENCODING_X_SAMPA_VALUE = 2;

    /**
     *
     *
     * <pre>
     * For reading-to-pron conversion to work well, the `pronunciation` field
     *  should only contain Kanji, Hiragana, and Katakana.
     *
     * The pronunciation can also contain pitch accents.
     * The start of a pitch phrase is specified with `^` and the down-pitch
     * position is specified with `!`, for example:
     *
     *     phrase:端  pronunciation:^はし
     *     phrase:箸  pronunciation:^は!し
     *     phrase:橋  pronunciation:^はし!
     *
     * We currently only support the Tokyo dialect, which allows at most one
     * down-pitch per phrase (i.e. at most one `!` between `^`).
     * </pre>
     *
     * <code>PHONETIC_ENCODING_JAPANESE_YOMIGANA = 3;</code>
     */
    public static final int PHONETIC_ENCODING_JAPANESE_YOMIGANA_VALUE = 3;

    /**
     *
     *
     * <pre>
     * Used to specify pronunciations for Mandarin words. See
     * https://en.wikipedia.org/wiki/Pinyin.
     *
     * For example: 朝阳, the pronunciation is "chao2 yang2". The number
     * represents the tone, and there is a space between syllables. Neutral
     * tones are represented by 5, for example 孩子 "hai2 zi5".
     * </pre>
     *
     * <code>PHONETIC_ENCODING_PINYIN = 4;</code>
     */
    public static final int PHONETIC_ENCODING_PINYIN_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static PhoneticEncoding valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static PhoneticEncoding forNumber(int value) {
      switch (value) {
        case 0:
          return PHONETIC_ENCODING_UNSPECIFIED;
        case 1:
          return PHONETIC_ENCODING_IPA;
        case 2:
          return PHONETIC_ENCODING_X_SAMPA;
        case 3:
          return PHONETIC_ENCODING_JAPANESE_YOMIGANA;
        case 4:
          return PHONETIC_ENCODING_PINYIN;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<PhoneticEncoding> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<PhoneticEncoding>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<PhoneticEncoding>() {
              public PhoneticEncoding findValueByNumber(int number) {
                return PhoneticEncoding.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.texttospeech.v1.CustomPronunciationParams.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final PhoneticEncoding[] VALUES = values();

    public static PhoneticEncoding valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private PhoneticEncoding(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.texttospeech.v1.CustomPronunciationParams.PhoneticEncoding)
  }

  private int bitField0_;
  public static final int PHRASE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object phrase_ = "";

  /**
   *
   *
   * <pre>
   * The phrase to which the customization is applied.
   * The phrase can be multiple words, such as proper nouns, but shouldn't span
   * the length of the sentence.
   * </pre>
   *
   * <code>optional string phrase = 1;</code>
   *
   * @return Whether the phrase field is set.
   */
  @java.lang.Override
  public boolean hasPhrase() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The phrase to which the customization is applied.
   * The phrase can be multiple words, such as proper nouns, but shouldn't span
   * the length of the sentence.
   * </pre>
   *
   * <code>optional string phrase = 1;</code>
   *
   * @return The phrase.
   */
  @java.lang.Override
  public java.lang.String getPhrase() {
    java.lang.Object ref = phrase_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      phrase_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The phrase to which the customization is applied.
   * The phrase can be multiple words, such as proper nouns, but shouldn't span
   * the length of the sentence.
   * </pre>
   *
   * <code>optional string phrase = 1;</code>
   *
   * @return The bytes for phrase.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPhraseBytes() {
    java.lang.Object ref = phrase_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      phrase_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PHONETIC_ENCODING_FIELD_NUMBER = 2;
  private int phoneticEncoding_ = 0;

  /**
   *
   *
   * <pre>
   * The phonetic encoding of the phrase.
   * </pre>
   *
   * <code>
   * optional .google.cloud.texttospeech.v1.CustomPronunciationParams.PhoneticEncoding phonetic_encoding = 2;
   * </code>
   *
   * @return Whether the phoneticEncoding field is set.
   */
  @java.lang.Override
  public boolean hasPhoneticEncoding() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The phonetic encoding of the phrase.
   * </pre>
   *
   * <code>
   * optional .google.cloud.texttospeech.v1.CustomPronunciationParams.PhoneticEncoding phonetic_encoding = 2;
   * </code>
   *
   * @return The enum numeric value on the wire for phoneticEncoding.
   */
  @java.lang.Override
  public int getPhoneticEncodingValue() {
    return phoneticEncoding_;
  }

  /**
   *
   *
   * <pre>
   * The phonetic encoding of the phrase.
   * </pre>
   *
   * <code>
   * optional .google.cloud.texttospeech.v1.CustomPronunciationParams.PhoneticEncoding phonetic_encoding = 2;
   * </code>
   *
   * @return The phoneticEncoding.
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1.CustomPronunciationParams.PhoneticEncoding
      getPhoneticEncoding() {
    com.google.cloud.texttospeech.v1.CustomPronunciationParams.PhoneticEncoding result =
        com.google.cloud.texttospeech.v1.CustomPronunciationParams.PhoneticEncoding.forNumber(
            phoneticEncoding_);
    return result == null
        ? com.google.cloud.texttospeech.v1.CustomPronunciationParams.PhoneticEncoding.UNRECOGNIZED
        : result;
  }

  public static final int PRONUNCIATION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object pronunciation_ = "";

  /**
   *
   *
   * <pre>
   * The pronunciation of the phrase. This must be in the phonetic encoding
   * specified above.
   * </pre>
   *
   * <code>optional string pronunciation = 3;</code>
   *
   * @return Whether the pronunciation field is set.
   */
  @java.lang.Override
  public boolean hasPronunciation() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * The pronunciation of the phrase. This must be in the phonetic encoding
   * specified above.
   * </pre>
   *
   * <code>optional string pronunciation = 3;</code>
   *
   * @return The pronunciation.
   */
  @java.lang.Override
  public java.lang.String getPronunciation() {
    java.lang.Object ref = pronunciation_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      pronunciation_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The pronunciation of the phrase. This must be in the phonetic encoding
   * specified above.
   * </pre>
   *
   * <code>optional string pronunciation = 3;</code>
   *
   * @return The bytes for pronunciation.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPronunciationBytes() {
    java.lang.Object ref = pronunciation_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      pronunciation_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, phrase_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeEnum(2, phoneticEncoding_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pronunciation_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, phrase_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, phoneticEncoding_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pronunciation_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.texttospeech.v1.CustomPronunciationParams)) {
      return super.equals(obj);
    }
    com.google.cloud.texttospeech.v1.CustomPronunciationParams other =
        (com.google.cloud.texttospeech.v1.CustomPronunciationParams) obj;

    if (hasPhrase() != other.hasPhrase()) return false;
    if (hasPhrase()) {
      if (!getPhrase().equals(other.getPhrase())) return false;
    }
    if (hasPhoneticEncoding() != other.hasPhoneticEncoding()) return false;
    if (hasPhoneticEncoding()) {
      if (phoneticEncoding_ != other.phoneticEncoding_) return false;
    }
    if (hasPronunciation() != other.hasPronunciation()) return false;
    if (hasPronunciation()) {
      if (!getPronunciation().equals(other.getPronunciation())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasPhrase()) {
      hash = (37 * hash) + PHRASE_FIELD_NUMBER;
      hash = (53 * hash) + getPhrase().hashCode();
    }
    if (hasPhoneticEncoding()) {
      hash = (37 * hash) + PHONETIC_ENCODING_FIELD_NUMBER;
      hash = (53 * hash) + phoneticEncoding_;
    }
    if (hasPronunciation()) {
      hash = (37 * hash) + PRONUNCIATION_FIELD_NUMBER;
      hash = (53 * hash) + getPronunciation().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.texttospeech.v1.CustomPronunciationParams parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1.CustomPronunciationParams parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1.CustomPronunciationParams parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1.CustomPronunciationParams parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1.CustomPronunciationParams parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1.CustomPronunciationParams parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1.CustomPronunciationParams parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1.CustomPronunciationParams parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1.CustomPronunciationParams parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1.CustomPronunciationParams parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1.CustomPronunciationParams parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1.CustomPronunciationParams parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.texttospeech.v1.CustomPronunciationParams prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Pronunciation customization for a phrase.
   * </pre>
   *
   * Protobuf type {@code google.cloud.texttospeech.v1.CustomPronunciationParams}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.texttospeech.v1.CustomPronunciationParams)
      com.google.cloud.texttospeech.v1.CustomPronunciationParamsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.texttospeech.v1.TextToSpeechProto
          .internal_static_google_cloud_texttospeech_v1_CustomPronunciationParams_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.texttospeech.v1.TextToSpeechProto
          .internal_static_google_cloud_texttospeech_v1_CustomPronunciationParams_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.texttospeech.v1.CustomPronunciationParams.class,
              com.google.cloud.texttospeech.v1.CustomPronunciationParams.Builder.class);
    }

    // Construct using com.google.cloud.texttospeech.v1.CustomPronunciationParams.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      phrase_ = "";
      phoneticEncoding_ = 0;
      pronunciation_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.texttospeech.v1.TextToSpeechProto
          .internal_static_google_cloud_texttospeech_v1_CustomPronunciationParams_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1.CustomPronunciationParams getDefaultInstanceForType() {
      return com.google.cloud.texttospeech.v1.CustomPronunciationParams.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1.CustomPronunciationParams build() {
      com.google.cloud.texttospeech.v1.CustomPronunciationParams result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1.CustomPronunciationParams buildPartial() {
      com.google.cloud.texttospeech.v1.CustomPronunciationParams result =
          new com.google.cloud.texttospeech.v1.CustomPronunciationParams(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.texttospeech.v1.CustomPronunciationParams result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.phrase_ = phrase_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.phoneticEncoding_ = phoneticEncoding_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.pronunciation_ = pronunciation_;
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.texttospeech.v1.CustomPronunciationParams) {
        return mergeFrom((com.google.cloud.texttospeech.v1.CustomPronunciationParams) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.texttospeech.v1.CustomPronunciationParams other) {
      if (other == com.google.cloud.texttospeech.v1.CustomPronunciationParams.getDefaultInstance())
        return this;
      if (other.hasPhrase()) {
        phrase_ = other.phrase_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasPhoneticEncoding()) {
        setPhoneticEncoding(other.getPhoneticEncoding());
      }
      if (other.hasPronunciation()) {
        pronunciation_ = other.pronunciation_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                phrase_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                phoneticEncoding_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                pronunciation_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object phrase_ = "";

    /**
     *
     *
     * <pre>
     * The phrase to which the customization is applied.
     * The phrase can be multiple words, such as proper nouns, but shouldn't span
     * the length of the sentence.
     * </pre>
     *
     * <code>optional string phrase = 1;</code>
     *
     * @return Whether the phrase field is set.
     */
    public boolean hasPhrase() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The phrase to which the customization is applied.
     * The phrase can be multiple words, such as proper nouns, but shouldn't span
     * the length of the sentence.
     * </pre>
     *
     * <code>optional string phrase = 1;</code>
     *
     * @return The phrase.
     */
    public java.lang.String getPhrase() {
      java.lang.Object ref = phrase_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        phrase_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The phrase to which the customization is applied.
     * The phrase can be multiple words, such as proper nouns, but shouldn't span
     * the length of the sentence.
     * </pre>
     *
     * <code>optional string phrase = 1;</code>
     *
     * @return The bytes for phrase.
     */
    public com.google.protobuf.ByteString getPhraseBytes() {
      java.lang.Object ref = phrase_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        phrase_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The phrase to which the customization is applied.
     * The phrase can be multiple words, such as proper nouns, but shouldn't span
     * the length of the sentence.
     * </pre>
     *
     * <code>optional string phrase = 1;</code>
     *
     * @param value The phrase to set.
     * @return This builder for chaining.
     */
    public Builder setPhrase(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      phrase_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The phrase to which the customization is applied.
     * The phrase can be multiple words, such as proper nouns, but shouldn't span
     * the length of the sentence.
     * </pre>
     *
     * <code>optional string phrase = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPhrase() {
      phrase_ = getDefaultInstance().getPhrase();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The phrase to which the customization is applied.
     * The phrase can be multiple words, such as proper nouns, but shouldn't span
     * the length of the sentence.
     * </pre>
     *
     * <code>optional string phrase = 1;</code>
     *
     * @param value The bytes for phrase to set.
     * @return This builder for chaining.
     */
    public Builder setPhraseBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      phrase_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int phoneticEncoding_ = 0;

    /**
     *
     *
     * <pre>
     * The phonetic encoding of the phrase.
     * </pre>
     *
     * <code>
     * optional .google.cloud.texttospeech.v1.CustomPronunciationParams.PhoneticEncoding phonetic_encoding = 2;
     * </code>
     *
     * @return Whether the phoneticEncoding field is set.
     */
    @java.lang.Override
    public boolean hasPhoneticEncoding() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The phonetic encoding of the phrase.
     * </pre>
     *
     * <code>
     * optional .google.cloud.texttospeech.v1.CustomPronunciationParams.PhoneticEncoding phonetic_encoding = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for phoneticEncoding.
     */
    @java.lang.Override
    public int getPhoneticEncodingValue() {
      return phoneticEncoding_;
    }

    /**
     *
     *
     * <pre>
     * The phonetic encoding of the phrase.
     * </pre>
     *
     * <code>
     * optional .google.cloud.texttospeech.v1.CustomPronunciationParams.PhoneticEncoding phonetic_encoding = 2;
     * </code>
     *
     * @param value The enum numeric value on the wire for phoneticEncoding to set.
     * @return This builder for chaining.
     */
    public Builder setPhoneticEncodingValue(int value) {
      phoneticEncoding_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The phonetic encoding of the phrase.
     * </pre>
     *
     * <code>
     * optional .google.cloud.texttospeech.v1.CustomPronunciationParams.PhoneticEncoding phonetic_encoding = 2;
     * </code>
     *
     * @return The phoneticEncoding.
     */
    @java.lang.Override
    public com.google.cloud.texttospeech.v1.CustomPronunciationParams.PhoneticEncoding
        getPhoneticEncoding() {
      com.google.cloud.texttospeech.v1.CustomPronunciationParams.PhoneticEncoding result =
          com.google.cloud.texttospeech.v1.CustomPronunciationParams.PhoneticEncoding.forNumber(
              phoneticEncoding_);
      return result == null
          ? com.google.cloud.texttospeech.v1.CustomPronunciationParams.PhoneticEncoding.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * The phonetic encoding of the phrase.
     * </pre>
     *
     * <code>
     * optional .google.cloud.texttospeech.v1.CustomPronunciationParams.PhoneticEncoding phonetic_encoding = 2;
     * </code>
     *
     * @param value The phoneticEncoding to set.
     * @return This builder for chaining.
     */
    public Builder setPhoneticEncoding(
        com.google.cloud.texttospeech.v1.CustomPronunciationParams.PhoneticEncoding value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      phoneticEncoding_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The phonetic encoding of the phrase.
     * </pre>
     *
     * <code>
     * optional .google.cloud.texttospeech.v1.CustomPronunciationParams.PhoneticEncoding phonetic_encoding = 2;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPhoneticEncoding() {
      bitField0_ = (bitField0_ & ~0x00000002);
      phoneticEncoding_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object pronunciation_ = "";

    /**
     *
     *
     * <pre>
     * The pronunciation of the phrase. This must be in the phonetic encoding
     * specified above.
     * </pre>
     *
     * <code>optional string pronunciation = 3;</code>
     *
     * @return Whether the pronunciation field is set.
     */
    public boolean hasPronunciation() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * The pronunciation of the phrase. This must be in the phonetic encoding
     * specified above.
     * </pre>
     *
     * <code>optional string pronunciation = 3;</code>
     *
     * @return The pronunciation.
     */
    public java.lang.String getPronunciation() {
      java.lang.Object ref = pronunciation_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pronunciation_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The pronunciation of the phrase. This must be in the phonetic encoding
     * specified above.
     * </pre>
     *
     * <code>optional string pronunciation = 3;</code>
     *
     * @return The bytes for pronunciation.
     */
    public com.google.protobuf.ByteString getPronunciationBytes() {
      java.lang.Object ref = pronunciation_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pronunciation_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The pronunciation of the phrase. This must be in the phonetic encoding
     * specified above.
     * </pre>
     *
     * <code>optional string pronunciation = 3;</code>
     *
     * @param value The pronunciation to set.
     * @return This builder for chaining.
     */
    public Builder setPronunciation(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      pronunciation_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The pronunciation of the phrase. This must be in the phonetic encoding
     * specified above.
     * </pre>
     *
     * <code>optional string pronunciation = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPronunciation() {
      pronunciation_ = getDefaultInstance().getPronunciation();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The pronunciation of the phrase. This must be in the phonetic encoding
     * specified above.
     * </pre>
     *
     * <code>optional string pronunciation = 3;</code>
     *
     * @param value The bytes for pronunciation to set.
     * @return This builder for chaining.
     */
    public Builder setPronunciationBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      pronunciation_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.texttospeech.v1.CustomPronunciationParams)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.texttospeech.v1.CustomPronunciationParams)
  private static final com.google.cloud.texttospeech.v1.CustomPronunciationParams DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.texttospeech.v1.CustomPronunciationParams();
  }

  public static com.google.cloud.texttospeech.v1.CustomPronunciationParams getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CustomPronunciationParams> PARSER =
      new com.google.protobuf.AbstractParser<CustomPronunciationParams>() {
        @java.lang.Override
        public CustomPronunciationParams parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CustomPronunciationParams> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CustomPronunciationParams> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.texttospeech.v1.CustomPronunciationParams getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
