/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/texttospeech/v1/cloud_tts.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.texttospeech.v1;

/**
 *
 *
 * <pre>
 * Input to be synthesized.
 * </pre>
 *
 * Protobuf type {@code google.cloud.texttospeech.v1.StreamingSynthesisInput}
 */
public final class StreamingSynthesisInput extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.texttospeech.v1.StreamingSynthesisInput)
    StreamingSynthesisInputOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use StreamingSynthesisInput.newBuilder() to construct.
  private StreamingSynthesisInput(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StreamingSynthesisInput() {
    prompt_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StreamingSynthesisInput();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.texttospeech.v1.TextToSpeechProto
        .internal_static_google_cloud_texttospeech_v1_StreamingSynthesisInput_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.texttospeech.v1.TextToSpeechProto
        .internal_static_google_cloud_texttospeech_v1_StreamingSynthesisInput_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.texttospeech.v1.StreamingSynthesisInput.class,
            com.google.cloud.texttospeech.v1.StreamingSynthesisInput.Builder.class);
  }

  private int bitField0_;
  private int inputSourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object inputSource_;

  public enum InputSourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TEXT(1),
    MARKUP(5),
    MULTI_SPEAKER_MARKUP(7),
    INPUTSOURCE_NOT_SET(0);
    private final int value;

    private InputSourceCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static InputSourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static InputSourceCase forNumber(int value) {
      switch (value) {
        case 1:
          return TEXT;
        case 5:
          return MARKUP;
        case 7:
          return MULTI_SPEAKER_MARKUP;
        case 0:
          return INPUTSOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public InputSourceCase getInputSourceCase() {
    return InputSourceCase.forNumber(inputSourceCase_);
  }

  public static final int TEXT_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * The raw text to be synthesized. It is recommended that each input
   * contains complete, terminating sentences, which results in better prosody
   * in the output audio.
   * </pre>
   *
   * <code>string text = 1;</code>
   *
   * @return Whether the text field is set.
   */
  public boolean hasText() {
    return inputSourceCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * The raw text to be synthesized. It is recommended that each input
   * contains complete, terminating sentences, which results in better prosody
   * in the output audio.
   * </pre>
   *
   * <code>string text = 1;</code>
   *
   * @return The text.
   */
  public java.lang.String getText() {
    java.lang.Object ref = "";
    if (inputSourceCase_ == 1) {
      ref = inputSource_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (inputSourceCase_ == 1) {
        inputSource_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The raw text to be synthesized. It is recommended that each input
   * contains complete, terminating sentences, which results in better prosody
   * in the output audio.
   * </pre>
   *
   * <code>string text = 1;</code>
   *
   * @return The bytes for text.
   */
  public com.google.protobuf.ByteString getTextBytes() {
    java.lang.Object ref = "";
    if (inputSourceCase_ == 1) {
      ref = inputSource_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (inputSourceCase_ == 1) {
        inputSource_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MARKUP_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * Markup for HD voices specifically. This field may not be used with any
   * other voices.
   * </pre>
   *
   * <code>string markup = 5;</code>
   *
   * @return Whether the markup field is set.
   */
  public boolean hasMarkup() {
    return inputSourceCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * Markup for HD voices specifically. This field may not be used with any
   * other voices.
   * </pre>
   *
   * <code>string markup = 5;</code>
   *
   * @return The markup.
   */
  public java.lang.String getMarkup() {
    java.lang.Object ref = "";
    if (inputSourceCase_ == 5) {
      ref = inputSource_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (inputSourceCase_ == 5) {
        inputSource_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Markup for HD voices specifically. This field may not be used with any
   * other voices.
   * </pre>
   *
   * <code>string markup = 5;</code>
   *
   * @return The bytes for markup.
   */
  public com.google.protobuf.ByteString getMarkupBytes() {
    java.lang.Object ref = "";
    if (inputSourceCase_ == 5) {
      ref = inputSource_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (inputSourceCase_ == 5) {
        inputSource_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MULTI_SPEAKER_MARKUP_FIELD_NUMBER = 7;

  /**
   *
   *
   * <pre>
   * Multi-speaker markup for Gemini TTS. This field may not
   * be used with any other voices.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1.MultiSpeakerMarkup multi_speaker_markup = 7;</code>
   *
   * @return Whether the multiSpeakerMarkup field is set.
   */
  @java.lang.Override
  public boolean hasMultiSpeakerMarkup() {
    return inputSourceCase_ == 7;
  }

  /**
   *
   *
   * <pre>
   * Multi-speaker markup for Gemini TTS. This field may not
   * be used with any other voices.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1.MultiSpeakerMarkup multi_speaker_markup = 7;</code>
   *
   * @return The multiSpeakerMarkup.
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1.MultiSpeakerMarkup getMultiSpeakerMarkup() {
    if (inputSourceCase_ == 7) {
      return (com.google.cloud.texttospeech.v1.MultiSpeakerMarkup) inputSource_;
    }
    return com.google.cloud.texttospeech.v1.MultiSpeakerMarkup.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Multi-speaker markup for Gemini TTS. This field may not
   * be used with any other voices.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1.MultiSpeakerMarkup multi_speaker_markup = 7;</code>
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1.MultiSpeakerMarkupOrBuilder
      getMultiSpeakerMarkupOrBuilder() {
    if (inputSourceCase_ == 7) {
      return (com.google.cloud.texttospeech.v1.MultiSpeakerMarkup) inputSource_;
    }
    return com.google.cloud.texttospeech.v1.MultiSpeakerMarkup.getDefaultInstance();
  }

  public static final int PROMPT_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object prompt_ = "";

  /**
   *
   *
   * <pre>
   * This is system instruction supported only for controllable voice models.
   * </pre>
   *
   * <code>optional string prompt = 6;</code>
   *
   * @return Whether the prompt field is set.
   */
  @java.lang.Override
  public boolean hasPrompt() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * This is system instruction supported only for controllable voice models.
   * </pre>
   *
   * <code>optional string prompt = 6;</code>
   *
   * @return The prompt.
   */
  @java.lang.Override
  public java.lang.String getPrompt() {
    java.lang.Object ref = prompt_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      prompt_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * This is system instruction supported only for controllable voice models.
   * </pre>
   *
   * <code>optional string prompt = 6;</code>
   *
   * @return The bytes for prompt.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPromptBytes() {
    java.lang.Object ref = prompt_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      prompt_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (inputSourceCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, inputSource_);
    }
    if (inputSourceCase_ == 5) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, inputSource_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, prompt_);
    }
    if (inputSourceCase_ == 7) {
      output.writeMessage(7, (com.google.cloud.texttospeech.v1.MultiSpeakerMarkup) inputSource_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (inputSourceCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, inputSource_);
    }
    if (inputSourceCase_ == 5) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, inputSource_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, prompt_);
    }
    if (inputSourceCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.cloud.texttospeech.v1.MultiSpeakerMarkup) inputSource_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.texttospeech.v1.StreamingSynthesisInput)) {
      return super.equals(obj);
    }
    com.google.cloud.texttospeech.v1.StreamingSynthesisInput other =
        (com.google.cloud.texttospeech.v1.StreamingSynthesisInput) obj;

    if (hasPrompt() != other.hasPrompt()) return false;
    if (hasPrompt()) {
      if (!getPrompt().equals(other.getPrompt())) return false;
    }
    if (!getInputSourceCase().equals(other.getInputSourceCase())) return false;
    switch (inputSourceCase_) {
      case 1:
        if (!getText().equals(other.getText())) return false;
        break;
      case 5:
        if (!getMarkup().equals(other.getMarkup())) return false;
        break;
      case 7:
        if (!getMultiSpeakerMarkup().equals(other.getMultiSpeakerMarkup())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasPrompt()) {
      hash = (37 * hash) + PROMPT_FIELD_NUMBER;
      hash = (53 * hash) + getPrompt().hashCode();
    }
    switch (inputSourceCase_) {
      case 1:
        hash = (37 * hash) + TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getText().hashCode();
        break;
      case 5:
        hash = (37 * hash) + MARKUP_FIELD_NUMBER;
        hash = (53 * hash) + getMarkup().hashCode();
        break;
      case 7:
        hash = (37 * hash) + MULTI_SPEAKER_MARKUP_FIELD_NUMBER;
        hash = (53 * hash) + getMultiSpeakerMarkup().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesisInput parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesisInput parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesisInput parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesisInput parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesisInput parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesisInput parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesisInput parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesisInput parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesisInput parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesisInput parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesisInput parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesisInput parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.texttospeech.v1.StreamingSynthesisInput prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Input to be synthesized.
   * </pre>
   *
   * Protobuf type {@code google.cloud.texttospeech.v1.StreamingSynthesisInput}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.texttospeech.v1.StreamingSynthesisInput)
      com.google.cloud.texttospeech.v1.StreamingSynthesisInputOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.texttospeech.v1.TextToSpeechProto
          .internal_static_google_cloud_texttospeech_v1_StreamingSynthesisInput_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.texttospeech.v1.TextToSpeechProto
          .internal_static_google_cloud_texttospeech_v1_StreamingSynthesisInput_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.texttospeech.v1.StreamingSynthesisInput.class,
              com.google.cloud.texttospeech.v1.StreamingSynthesisInput.Builder.class);
    }

    // Construct using com.google.cloud.texttospeech.v1.StreamingSynthesisInput.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (multiSpeakerMarkupBuilder_ != null) {
        multiSpeakerMarkupBuilder_.clear();
      }
      prompt_ = "";
      inputSourceCase_ = 0;
      inputSource_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.texttospeech.v1.TextToSpeechProto
          .internal_static_google_cloud_texttospeech_v1_StreamingSynthesisInput_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1.StreamingSynthesisInput getDefaultInstanceForType() {
      return com.google.cloud.texttospeech.v1.StreamingSynthesisInput.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1.StreamingSynthesisInput build() {
      com.google.cloud.texttospeech.v1.StreamingSynthesisInput result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1.StreamingSynthesisInput buildPartial() {
      com.google.cloud.texttospeech.v1.StreamingSynthesisInput result =
          new com.google.cloud.texttospeech.v1.StreamingSynthesisInput(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.texttospeech.v1.StreamingSynthesisInput result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.prompt_ = prompt_;
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.texttospeech.v1.StreamingSynthesisInput result) {
      result.inputSourceCase_ = inputSourceCase_;
      result.inputSource_ = this.inputSource_;
      if (inputSourceCase_ == 7 && multiSpeakerMarkupBuilder_ != null) {
        result.inputSource_ = multiSpeakerMarkupBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.texttospeech.v1.StreamingSynthesisInput) {
        return mergeFrom((com.google.cloud.texttospeech.v1.StreamingSynthesisInput) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.texttospeech.v1.StreamingSynthesisInput other) {
      if (other == com.google.cloud.texttospeech.v1.StreamingSynthesisInput.getDefaultInstance())
        return this;
      if (other.hasPrompt()) {
        prompt_ = other.prompt_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      switch (other.getInputSourceCase()) {
        case TEXT:
          {
            inputSourceCase_ = 1;
            inputSource_ = other.inputSource_;
            onChanged();
            break;
          }
        case MARKUP:
          {
            inputSourceCase_ = 5;
            inputSource_ = other.inputSource_;
            onChanged();
            break;
          }
        case MULTI_SPEAKER_MARKUP:
          {
            mergeMultiSpeakerMarkup(other.getMultiSpeakerMarkup());
            break;
          }
        case INPUTSOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                inputSourceCase_ = 1;
                inputSource_ = s;
                break;
              } // case 10
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                inputSourceCase_ = 5;
                inputSource_ = s;
                break;
              } // case 42
            case 50:
              {
                prompt_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getMultiSpeakerMarkupFieldBuilder().getBuilder(), extensionRegistry);
                inputSourceCase_ = 7;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int inputSourceCase_ = 0;
    private java.lang.Object inputSource_;

    public InputSourceCase getInputSourceCase() {
      return InputSourceCase.forNumber(inputSourceCase_);
    }

    public Builder clearInputSource() {
      inputSourceCase_ = 0;
      inputSource_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * The raw text to be synthesized. It is recommended that each input
     * contains complete, terminating sentences, which results in better prosody
     * in the output audio.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return Whether the text field is set.
     */
    @java.lang.Override
    public boolean hasText() {
      return inputSourceCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * The raw text to be synthesized. It is recommended that each input
     * contains complete, terminating sentences, which results in better prosody
     * in the output audio.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The text.
     */
    @java.lang.Override
    public java.lang.String getText() {
      java.lang.Object ref = "";
      if (inputSourceCase_ == 1) {
        ref = inputSource_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (inputSourceCase_ == 1) {
          inputSource_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The raw text to be synthesized. It is recommended that each input
     * contains complete, terminating sentences, which results in better prosody
     * in the output audio.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return The bytes for text.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTextBytes() {
      java.lang.Object ref = "";
      if (inputSourceCase_ == 1) {
        ref = inputSource_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (inputSourceCase_ == 1) {
          inputSource_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The raw text to be synthesized. It is recommended that each input
     * contains complete, terminating sentences, which results in better prosody
     * in the output audio.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @param value The text to set.
     * @return This builder for chaining.
     */
    public Builder setText(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      inputSourceCase_ = 1;
      inputSource_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The raw text to be synthesized. It is recommended that each input
     * contains complete, terminating sentences, which results in better prosody
     * in the output audio.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearText() {
      if (inputSourceCase_ == 1) {
        inputSourceCase_ = 0;
        inputSource_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The raw text to be synthesized. It is recommended that each input
     * contains complete, terminating sentences, which results in better prosody
     * in the output audio.
     * </pre>
     *
     * <code>string text = 1;</code>
     *
     * @param value The bytes for text to set.
     * @return This builder for chaining.
     */
    public Builder setTextBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      inputSourceCase_ = 1;
      inputSource_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Markup for HD voices specifically. This field may not be used with any
     * other voices.
     * </pre>
     *
     * <code>string markup = 5;</code>
     *
     * @return Whether the markup field is set.
     */
    @java.lang.Override
    public boolean hasMarkup() {
      return inputSourceCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Markup for HD voices specifically. This field may not be used with any
     * other voices.
     * </pre>
     *
     * <code>string markup = 5;</code>
     *
     * @return The markup.
     */
    @java.lang.Override
    public java.lang.String getMarkup() {
      java.lang.Object ref = "";
      if (inputSourceCase_ == 5) {
        ref = inputSource_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (inputSourceCase_ == 5) {
          inputSource_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Markup for HD voices specifically. This field may not be used with any
     * other voices.
     * </pre>
     *
     * <code>string markup = 5;</code>
     *
     * @return The bytes for markup.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMarkupBytes() {
      java.lang.Object ref = "";
      if (inputSourceCase_ == 5) {
        ref = inputSource_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (inputSourceCase_ == 5) {
          inputSource_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Markup for HD voices specifically. This field may not be used with any
     * other voices.
     * </pre>
     *
     * <code>string markup = 5;</code>
     *
     * @param value The markup to set.
     * @return This builder for chaining.
     */
    public Builder setMarkup(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      inputSourceCase_ = 5;
      inputSource_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Markup for HD voices specifically. This field may not be used with any
     * other voices.
     * </pre>
     *
     * <code>string markup = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMarkup() {
      if (inputSourceCase_ == 5) {
        inputSourceCase_ = 0;
        inputSource_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Markup for HD voices specifically. This field may not be used with any
     * other voices.
     * </pre>
     *
     * <code>string markup = 5;</code>
     *
     * @param value The bytes for markup to set.
     * @return This builder for chaining.
     */
    public Builder setMarkupBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      inputSourceCase_ = 5;
      inputSource_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.texttospeech.v1.MultiSpeakerMarkup,
            com.google.cloud.texttospeech.v1.MultiSpeakerMarkup.Builder,
            com.google.cloud.texttospeech.v1.MultiSpeakerMarkupOrBuilder>
        multiSpeakerMarkupBuilder_;

    /**
     *
     *
     * <pre>
     * Multi-speaker markup for Gemini TTS. This field may not
     * be used with any other voices.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.MultiSpeakerMarkup multi_speaker_markup = 7;</code>
     *
     * @return Whether the multiSpeakerMarkup field is set.
     */
    @java.lang.Override
    public boolean hasMultiSpeakerMarkup() {
      return inputSourceCase_ == 7;
    }

    /**
     *
     *
     * <pre>
     * Multi-speaker markup for Gemini TTS. This field may not
     * be used with any other voices.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.MultiSpeakerMarkup multi_speaker_markup = 7;</code>
     *
     * @return The multiSpeakerMarkup.
     */
    @java.lang.Override
    public com.google.cloud.texttospeech.v1.MultiSpeakerMarkup getMultiSpeakerMarkup() {
      if (multiSpeakerMarkupBuilder_ == null) {
        if (inputSourceCase_ == 7) {
          return (com.google.cloud.texttospeech.v1.MultiSpeakerMarkup) inputSource_;
        }
        return com.google.cloud.texttospeech.v1.MultiSpeakerMarkup.getDefaultInstance();
      } else {
        if (inputSourceCase_ == 7) {
          return multiSpeakerMarkupBuilder_.getMessage();
        }
        return com.google.cloud.texttospeech.v1.MultiSpeakerMarkup.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Multi-speaker markup for Gemini TTS. This field may not
     * be used with any other voices.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.MultiSpeakerMarkup multi_speaker_markup = 7;</code>
     */
    public Builder setMultiSpeakerMarkup(
        com.google.cloud.texttospeech.v1.MultiSpeakerMarkup value) {
      if (multiSpeakerMarkupBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        inputSource_ = value;
        onChanged();
      } else {
        multiSpeakerMarkupBuilder_.setMessage(value);
      }
      inputSourceCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Multi-speaker markup for Gemini TTS. This field may not
     * be used with any other voices.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.MultiSpeakerMarkup multi_speaker_markup = 7;</code>
     */
    public Builder setMultiSpeakerMarkup(
        com.google.cloud.texttospeech.v1.MultiSpeakerMarkup.Builder builderForValue) {
      if (multiSpeakerMarkupBuilder_ == null) {
        inputSource_ = builderForValue.build();
        onChanged();
      } else {
        multiSpeakerMarkupBuilder_.setMessage(builderForValue.build());
      }
      inputSourceCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Multi-speaker markup for Gemini TTS. This field may not
     * be used with any other voices.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.MultiSpeakerMarkup multi_speaker_markup = 7;</code>
     */
    public Builder mergeMultiSpeakerMarkup(
        com.google.cloud.texttospeech.v1.MultiSpeakerMarkup value) {
      if (multiSpeakerMarkupBuilder_ == null) {
        if (inputSourceCase_ == 7
            && inputSource_
                != com.google.cloud.texttospeech.v1.MultiSpeakerMarkup.getDefaultInstance()) {
          inputSource_ =
              com.google.cloud.texttospeech.v1.MultiSpeakerMarkup.newBuilder(
                      (com.google.cloud.texttospeech.v1.MultiSpeakerMarkup) inputSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          inputSource_ = value;
        }
        onChanged();
      } else {
        if (inputSourceCase_ == 7) {
          multiSpeakerMarkupBuilder_.mergeFrom(value);
        } else {
          multiSpeakerMarkupBuilder_.setMessage(value);
        }
      }
      inputSourceCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Multi-speaker markup for Gemini TTS. This field may not
     * be used with any other voices.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.MultiSpeakerMarkup multi_speaker_markup = 7;</code>
     */
    public Builder clearMultiSpeakerMarkup() {
      if (multiSpeakerMarkupBuilder_ == null) {
        if (inputSourceCase_ == 7) {
          inputSourceCase_ = 0;
          inputSource_ = null;
          onChanged();
        }
      } else {
        if (inputSourceCase_ == 7) {
          inputSourceCase_ = 0;
          inputSource_ = null;
        }
        multiSpeakerMarkupBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Multi-speaker markup for Gemini TTS. This field may not
     * be used with any other voices.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.MultiSpeakerMarkup multi_speaker_markup = 7;</code>
     */
    public com.google.cloud.texttospeech.v1.MultiSpeakerMarkup.Builder
        getMultiSpeakerMarkupBuilder() {
      return getMultiSpeakerMarkupFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Multi-speaker markup for Gemini TTS. This field may not
     * be used with any other voices.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.MultiSpeakerMarkup multi_speaker_markup = 7;</code>
     */
    @java.lang.Override
    public com.google.cloud.texttospeech.v1.MultiSpeakerMarkupOrBuilder
        getMultiSpeakerMarkupOrBuilder() {
      if ((inputSourceCase_ == 7) && (multiSpeakerMarkupBuilder_ != null)) {
        return multiSpeakerMarkupBuilder_.getMessageOrBuilder();
      } else {
        if (inputSourceCase_ == 7) {
          return (com.google.cloud.texttospeech.v1.MultiSpeakerMarkup) inputSource_;
        }
        return com.google.cloud.texttospeech.v1.MultiSpeakerMarkup.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Multi-speaker markup for Gemini TTS. This field may not
     * be used with any other voices.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1.MultiSpeakerMarkup multi_speaker_markup = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.texttospeech.v1.MultiSpeakerMarkup,
            com.google.cloud.texttospeech.v1.MultiSpeakerMarkup.Builder,
            com.google.cloud.texttospeech.v1.MultiSpeakerMarkupOrBuilder>
        getMultiSpeakerMarkupFieldBuilder() {
      if (multiSpeakerMarkupBuilder_ == null) {
        if (!(inputSourceCase_ == 7)) {
          inputSource_ = com.google.cloud.texttospeech.v1.MultiSpeakerMarkup.getDefaultInstance();
        }
        multiSpeakerMarkupBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.texttospeech.v1.MultiSpeakerMarkup,
                com.google.cloud.texttospeech.v1.MultiSpeakerMarkup.Builder,
                com.google.cloud.texttospeech.v1.MultiSpeakerMarkupOrBuilder>(
                (com.google.cloud.texttospeech.v1.MultiSpeakerMarkup) inputSource_,
                getParentForChildren(),
                isClean());
        inputSource_ = null;
      }
      inputSourceCase_ = 7;
      onChanged();
      return multiSpeakerMarkupBuilder_;
    }

    private java.lang.Object prompt_ = "";

    /**
     *
     *
     * <pre>
     * This is system instruction supported only for controllable voice models.
     * </pre>
     *
     * <code>optional string prompt = 6;</code>
     *
     * @return Whether the prompt field is set.
     */
    public boolean hasPrompt() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * This is system instruction supported only for controllable voice models.
     * </pre>
     *
     * <code>optional string prompt = 6;</code>
     *
     * @return The prompt.
     */
    public java.lang.String getPrompt() {
      java.lang.Object ref = prompt_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        prompt_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * This is system instruction supported only for controllable voice models.
     * </pre>
     *
     * <code>optional string prompt = 6;</code>
     *
     * @return The bytes for prompt.
     */
    public com.google.protobuf.ByteString getPromptBytes() {
      java.lang.Object ref = prompt_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        prompt_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * This is system instruction supported only for controllable voice models.
     * </pre>
     *
     * <code>optional string prompt = 6;</code>
     *
     * @param value The prompt to set.
     * @return This builder for chaining.
     */
    public Builder setPrompt(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      prompt_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This is system instruction supported only for controllable voice models.
     * </pre>
     *
     * <code>optional string prompt = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrompt() {
      prompt_ = getDefaultInstance().getPrompt();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This is system instruction supported only for controllable voice models.
     * </pre>
     *
     * <code>optional string prompt = 6;</code>
     *
     * @param value The bytes for prompt to set.
     * @return This builder for chaining.
     */
    public Builder setPromptBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      prompt_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.texttospeech.v1.StreamingSynthesisInput)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.texttospeech.v1.StreamingSynthesisInput)
  private static final com.google.cloud.texttospeech.v1.StreamingSynthesisInput DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.texttospeech.v1.StreamingSynthesisInput();
  }

  public static com.google.cloud.texttospeech.v1.StreamingSynthesisInput getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StreamingSynthesisInput> PARSER =
      new com.google.protobuf.AbstractParser<StreamingSynthesisInput>() {
        @java.lang.Override
        public StreamingSynthesisInput parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StreamingSynthesisInput> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StreamingSynthesisInput> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.texttospeech.v1.StreamingSynthesisInput getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
