/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/texttospeech/v1/cloud_tts.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.texttospeech.v1;

public interface VoiceSelectionParamsOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.texttospeech.v1.VoiceSelectionParams)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The language (and potentially also the region) of the voice
   * expressed as a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
   * language tag, e.g. "en-US". This should not include a script tag (e.g. use
   * "cmn-cn" rather than "cmn-Hant-cn"), because the script will be inferred
   * from the input provided in the SynthesisInput.  The TTS service
   * will use this parameter to help choose an appropriate voice.  Note that
   * the TTS service may choose a voice with a slightly different language code
   * than the one selected; it may substitute a different region
   * (e.g. using en-US rather than en-CA if there isn't a Canadian voice
   * available), or even a different language, e.g. using "nb" (Norwegian
   * Bokmal) instead of "no" (Norwegian)".
   * </pre>
   *
   * <code>string language_code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The languageCode.
   */
  java.lang.String getLanguageCode();

  /**
   *
   *
   * <pre>
   * Required. The language (and potentially also the region) of the voice
   * expressed as a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt)
   * language tag, e.g. "en-US". This should not include a script tag (e.g. use
   * "cmn-cn" rather than "cmn-Hant-cn"), because the script will be inferred
   * from the input provided in the SynthesisInput.  The TTS service
   * will use this parameter to help choose an appropriate voice.  Note that
   * the TTS service may choose a voice with a slightly different language code
   * than the one selected; it may substitute a different region
   * (e.g. using en-US rather than en-CA if there isn't a Canadian voice
   * available), or even a different language, e.g. using "nb" (Norwegian
   * Bokmal) instead of "no" (Norwegian)".
   * </pre>
   *
   * <code>string language_code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for languageCode.
   */
  com.google.protobuf.ByteString getLanguageCodeBytes();

  /**
   *
   *
   * <pre>
   * The name of the voice. If both the name and the gender are not set,
   * the service will choose a voice based on the other parameters such as
   * language_code.
   * </pre>
   *
   * <code>string name = 2;</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * The name of the voice. If both the name and the gender are not set,
   * the service will choose a voice based on the other parameters such as
   * language_code.
   * </pre>
   *
   * <code>string name = 2;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The preferred gender of the voice. If not set, the service will
   * choose a voice based on the other parameters such as language_code and
   * name. Note that this is only a preference, not requirement; if a
   * voice of the appropriate gender is not available, the synthesizer should
   * substitute a voice with a different gender rather than failing the request.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1.SsmlVoiceGender ssml_gender = 3;</code>
   *
   * @return The enum numeric value on the wire for ssmlGender.
   */
  int getSsmlGenderValue();

  /**
   *
   *
   * <pre>
   * The preferred gender of the voice. If not set, the service will
   * choose a voice based on the other parameters such as language_code and
   * name. Note that this is only a preference, not requirement; if a
   * voice of the appropriate gender is not available, the synthesizer should
   * substitute a voice with a different gender rather than failing the request.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1.SsmlVoiceGender ssml_gender = 3;</code>
   *
   * @return The ssmlGender.
   */
  com.google.cloud.texttospeech.v1.SsmlVoiceGender getSsmlGender();

  /**
   *
   *
   * <pre>
   * The configuration for a custom voice. If [CustomVoiceParams.model] is set,
   * the service will choose the custom voice matching the specified
   * configuration.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1.CustomVoiceParams custom_voice = 4;</code>
   *
   * @return Whether the customVoice field is set.
   */
  boolean hasCustomVoice();

  /**
   *
   *
   * <pre>
   * The configuration for a custom voice. If [CustomVoiceParams.model] is set,
   * the service will choose the custom voice matching the specified
   * configuration.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1.CustomVoiceParams custom_voice = 4;</code>
   *
   * @return The customVoice.
   */
  com.google.cloud.texttospeech.v1.CustomVoiceParams getCustomVoice();

  /**
   *
   *
   * <pre>
   * The configuration for a custom voice. If [CustomVoiceParams.model] is set,
   * the service will choose the custom voice matching the specified
   * configuration.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1.CustomVoiceParams custom_voice = 4;</code>
   */
  com.google.cloud.texttospeech.v1.CustomVoiceParamsOrBuilder getCustomVoiceOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The configuration for a voice clone. If
   * [VoiceCloneParams.voice_clone_key] is set, the service chooses the voice
   * clone matching the specified configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.texttospeech.v1.VoiceCloneParams voice_clone = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the voiceClone field is set.
   */
  boolean hasVoiceClone();

  /**
   *
   *
   * <pre>
   * Optional. The configuration for a voice clone. If
   * [VoiceCloneParams.voice_clone_key] is set, the service chooses the voice
   * clone matching the specified configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.texttospeech.v1.VoiceCloneParams voice_clone = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The voiceClone.
   */
  com.google.cloud.texttospeech.v1.VoiceCloneParams getVoiceClone();

  /**
   *
   *
   * <pre>
   * Optional. The configuration for a voice clone. If
   * [VoiceCloneParams.voice_clone_key] is set, the service chooses the voice
   * clone matching the specified configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.texttospeech.v1.VoiceCloneParams voice_clone = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.texttospeech.v1.VoiceCloneParamsOrBuilder getVoiceCloneOrBuilder();

  /**
   *
   *
   * <pre>
   * Optional. The name of the model. If set, the service will choose the model
   * matching the specified configuration.
   * </pre>
   *
   * <code>string model_name = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The modelName.
   */
  java.lang.String getModelName();

  /**
   *
   *
   * <pre>
   * Optional. The name of the model. If set, the service will choose the model
   * matching the specified configuration.
   * </pre>
   *
   * <code>string model_name = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for modelName.
   */
  com.google.protobuf.ByteString getModelNameBytes();

  /**
   *
   *
   * <pre>
   * Optional. The configuration for a Gemini multi-speaker text-to-speech
   * setup. Enables the use of two distinct voices in a single synthesis
   * request.
   * </pre>
   *
   * <code>
   * .google.cloud.texttospeech.v1.MultiSpeakerVoiceConfig multi_speaker_voice_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the multiSpeakerVoiceConfig field is set.
   */
  boolean hasMultiSpeakerVoiceConfig();

  /**
   *
   *
   * <pre>
   * Optional. The configuration for a Gemini multi-speaker text-to-speech
   * setup. Enables the use of two distinct voices in a single synthesis
   * request.
   * </pre>
   *
   * <code>
   * .google.cloud.texttospeech.v1.MultiSpeakerVoiceConfig multi_speaker_voice_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The multiSpeakerVoiceConfig.
   */
  com.google.cloud.texttospeech.v1.MultiSpeakerVoiceConfig getMultiSpeakerVoiceConfig();

  /**
   *
   *
   * <pre>
   * Optional. The configuration for a Gemini multi-speaker text-to-speech
   * setup. Enables the use of two distinct voices in a single synthesis
   * request.
   * </pre>
   *
   * <code>
   * .google.cloud.texttospeech.v1.MultiSpeakerVoiceConfig multi_speaker_voice_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.texttospeech.v1.MultiSpeakerVoiceConfigOrBuilder
      getMultiSpeakerVoiceConfigOrBuilder();
}
