/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/texttospeech/v1/cloud_tts.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.texttospeech.v1;

/**
 *
 *
 * <pre>
 * Configuration for a single speaker in a Gemini TTS multi-speaker setup.
 * Enables dialogue between two speakers.
 * </pre>
 *
 * Protobuf type {@code google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice}
 */
public final class MultispeakerPrebuiltVoice extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice)
    MultispeakerPrebuiltVoiceOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use MultispeakerPrebuiltVoice.newBuilder() to construct.
  private MultispeakerPrebuiltVoice(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MultispeakerPrebuiltVoice() {
    speakerAlias_ = "";
    speakerId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MultispeakerPrebuiltVoice();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.texttospeech.v1.TextToSpeechProto
        .internal_static_google_cloud_texttospeech_v1_MultispeakerPrebuiltVoice_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.texttospeech.v1.TextToSpeechProto
        .internal_static_google_cloud_texttospeech_v1_MultispeakerPrebuiltVoice_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice.class,
            com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice.Builder.class);
  }

  public static final int SPEAKER_ALIAS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object speakerAlias_ = "";

  /**
   *
   *
   * <pre>
   * Required. The speaker alias of the voice. This is the user-chosen speaker
   * name that is used in the multispeaker text input, such as "Speaker1".
   * </pre>
   *
   * <code>string speaker_alias = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The speakerAlias.
   */
  @java.lang.Override
  public java.lang.String getSpeakerAlias() {
    java.lang.Object ref = speakerAlias_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      speakerAlias_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The speaker alias of the voice. This is the user-chosen speaker
   * name that is used in the multispeaker text input, such as "Speaker1".
   * </pre>
   *
   * <code>string speaker_alias = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for speakerAlias.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSpeakerAliasBytes() {
    java.lang.Object ref = speakerAlias_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      speakerAlias_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SPEAKER_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object speakerId_ = "";

  /**
   *
   *
   * <pre>
   * Required. The speaker ID of the voice. See
   * https://cloud.google.com/text-to-speech/docs/gemini-tts#voice_options
   * for available values.
   * </pre>
   *
   * <code>string speaker_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The speakerId.
   */
  @java.lang.Override
  public java.lang.String getSpeakerId() {
    java.lang.Object ref = speakerId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      speakerId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The speaker ID of the voice. See
   * https://cloud.google.com/text-to-speech/docs/gemini-tts#voice_options
   * for available values.
   * </pre>
   *
   * <code>string speaker_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for speakerId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSpeakerIdBytes() {
    java.lang.Object ref = speakerId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      speakerId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(speakerAlias_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, speakerAlias_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(speakerId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, speakerId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(speakerAlias_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, speakerAlias_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(speakerId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, speakerId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice)) {
      return super.equals(obj);
    }
    com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice other =
        (com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice) obj;

    if (!getSpeakerAlias().equals(other.getSpeakerAlias())) return false;
    if (!getSpeakerId().equals(other.getSpeakerId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + SPEAKER_ALIAS_FIELD_NUMBER;
    hash = (53 * hash) + getSpeakerAlias().hashCode();
    hash = (37 * hash) + SPEAKER_ID_FIELD_NUMBER;
    hash = (53 * hash) + getSpeakerId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Configuration for a single speaker in a Gemini TTS multi-speaker setup.
   * Enables dialogue between two speakers.
   * </pre>
   *
   * Protobuf type {@code google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice)
      com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoiceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.texttospeech.v1.TextToSpeechProto
          .internal_static_google_cloud_texttospeech_v1_MultispeakerPrebuiltVoice_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.texttospeech.v1.TextToSpeechProto
          .internal_static_google_cloud_texttospeech_v1_MultispeakerPrebuiltVoice_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice.class,
              com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice.Builder.class);
    }

    // Construct using com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      speakerAlias_ = "";
      speakerId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.texttospeech.v1.TextToSpeechProto
          .internal_static_google_cloud_texttospeech_v1_MultispeakerPrebuiltVoice_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice getDefaultInstanceForType() {
      return com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice build() {
      com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice buildPartial() {
      com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice result =
          new com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.speakerAlias_ = speakerAlias_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.speakerId_ = speakerId_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice) {
        return mergeFrom((com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice other) {
      if (other == com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice.getDefaultInstance())
        return this;
      if (!other.getSpeakerAlias().isEmpty()) {
        speakerAlias_ = other.speakerAlias_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getSpeakerId().isEmpty()) {
        speakerId_ = other.speakerId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                speakerAlias_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                speakerId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object speakerAlias_ = "";

    /**
     *
     *
     * <pre>
     * Required. The speaker alias of the voice. This is the user-chosen speaker
     * name that is used in the multispeaker text input, such as "Speaker1".
     * </pre>
     *
     * <code>string speaker_alias = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The speakerAlias.
     */
    public java.lang.String getSpeakerAlias() {
      java.lang.Object ref = speakerAlias_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        speakerAlias_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The speaker alias of the voice. This is the user-chosen speaker
     * name that is used in the multispeaker text input, such as "Speaker1".
     * </pre>
     *
     * <code>string speaker_alias = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for speakerAlias.
     */
    public com.google.protobuf.ByteString getSpeakerAliasBytes() {
      java.lang.Object ref = speakerAlias_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        speakerAlias_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The speaker alias of the voice. This is the user-chosen speaker
     * name that is used in the multispeaker text input, such as "Speaker1".
     * </pre>
     *
     * <code>string speaker_alias = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The speakerAlias to set.
     * @return This builder for chaining.
     */
    public Builder setSpeakerAlias(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      speakerAlias_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The speaker alias of the voice. This is the user-chosen speaker
     * name that is used in the multispeaker text input, such as "Speaker1".
     * </pre>
     *
     * <code>string speaker_alias = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpeakerAlias() {
      speakerAlias_ = getDefaultInstance().getSpeakerAlias();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The speaker alias of the voice. This is the user-chosen speaker
     * name that is used in the multispeaker text input, such as "Speaker1".
     * </pre>
     *
     * <code>string speaker_alias = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for speakerAlias to set.
     * @return This builder for chaining.
     */
    public Builder setSpeakerAliasBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      speakerAlias_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object speakerId_ = "";

    /**
     *
     *
     * <pre>
     * Required. The speaker ID of the voice. See
     * https://cloud.google.com/text-to-speech/docs/gemini-tts#voice_options
     * for available values.
     * </pre>
     *
     * <code>string speaker_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The speakerId.
     */
    public java.lang.String getSpeakerId() {
      java.lang.Object ref = speakerId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        speakerId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The speaker ID of the voice. See
     * https://cloud.google.com/text-to-speech/docs/gemini-tts#voice_options
     * for available values.
     * </pre>
     *
     * <code>string speaker_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for speakerId.
     */
    public com.google.protobuf.ByteString getSpeakerIdBytes() {
      java.lang.Object ref = speakerId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        speakerId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The speaker ID of the voice. See
     * https://cloud.google.com/text-to-speech/docs/gemini-tts#voice_options
     * for available values.
     * </pre>
     *
     * <code>string speaker_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The speakerId to set.
     * @return This builder for chaining.
     */
    public Builder setSpeakerId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      speakerId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The speaker ID of the voice. See
     * https://cloud.google.com/text-to-speech/docs/gemini-tts#voice_options
     * for available values.
     * </pre>
     *
     * <code>string speaker_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSpeakerId() {
      speakerId_ = getDefaultInstance().getSpeakerId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The speaker ID of the voice. See
     * https://cloud.google.com/text-to-speech/docs/gemini-tts#voice_options
     * for available values.
     * </pre>
     *
     * <code>string speaker_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for speakerId to set.
     * @return This builder for chaining.
     */
    public Builder setSpeakerIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      speakerId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice)
  private static final com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice();
  }

  public static com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MultispeakerPrebuiltVoice> PARSER =
      new com.google.protobuf.AbstractParser<MultispeakerPrebuiltVoice>() {
        @java.lang.Override
        public MultispeakerPrebuiltVoice parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MultispeakerPrebuiltVoice> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MultispeakerPrebuiltVoice> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.texttospeech.v1.MultispeakerPrebuiltVoice getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
