/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/texttospeech/v1beta1/cloud_tts.proto

package com.google.cloud.texttospeech.v1beta1;

/**
 *
 *
 * <pre>
 * Description of which voice to use for a synthesis request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.texttospeech.v1beta1.VoiceSelectionParams}
 */
public final class VoiceSelectionParams extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.texttospeech.v1beta1.VoiceSelectionParams)
    VoiceSelectionParamsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VoiceSelectionParams.newBuilder() to construct.
  private VoiceSelectionParams(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VoiceSelectionParams() {
    languageCode_ = "";
    name_ = "";
    ssmlGender_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VoiceSelectionParams();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.texttospeech.v1beta1.TextToSpeechProto
        .internal_static_google_cloud_texttospeech_v1beta1_VoiceSelectionParams_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.texttospeech.v1beta1.TextToSpeechProto
        .internal_static_google_cloud_texttospeech_v1beta1_VoiceSelectionParams_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.class,
            com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.Builder.class);
  }

  public static final int LANGUAGE_CODE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object languageCode_ = "";
  /**
   *
   *
   * <pre>
   * Required. The language (and potentially also the region) of the voice expressed as a
   * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag, e.g.
   * "en-US". This should not include a script tag (e.g. use
   * "cmn-cn" rather than "cmn-Hant-cn"), because the script will be inferred
   * from the input provided in the SynthesisInput.  The TTS service
   * will use this parameter to help choose an appropriate voice.  Note that
   * the TTS service may choose a voice with a slightly different language code
   * than the one selected; it may substitute a different region
   * (e.g. using en-US rather than en-CA if there isn't a Canadian voice
   * available), or even a different language, e.g. using "nb" (Norwegian
   * Bokmal) instead of "no" (Norwegian)".
   * </pre>
   *
   * <code>string language_code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The languageCode.
   */
  @java.lang.Override
  public java.lang.String getLanguageCode() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      languageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The language (and potentially also the region) of the voice expressed as a
   * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag, e.g.
   * "en-US". This should not include a script tag (e.g. use
   * "cmn-cn" rather than "cmn-Hant-cn"), because the script will be inferred
   * from the input provided in the SynthesisInput.  The TTS service
   * will use this parameter to help choose an appropriate voice.  Note that
   * the TTS service may choose a voice with a slightly different language code
   * than the one selected; it may substitute a different region
   * (e.g. using en-US rather than en-CA if there isn't a Canadian voice
   * available), or even a different language, e.g. using "nb" (Norwegian
   * Bokmal) instead of "no" (Norwegian)".
   * </pre>
   *
   * <code>string language_code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for languageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLanguageCodeBytes() {
    java.lang.Object ref = languageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      languageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * The name of the voice. If not set, the service will choose a
   * voice based on the other parameters such as language_code and gender.
   * </pre>
   *
   * <code>string name = 2;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The name of the voice. If not set, the service will choose a
   * voice based on the other parameters such as language_code and gender.
   * </pre>
   *
   * <code>string name = 2;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SSML_GENDER_FIELD_NUMBER = 3;
  private int ssmlGender_ = 0;
  /**
   *
   *
   * <pre>
   * The preferred gender of the voice. If not set, the service will
   * choose a voice based on the other parameters such as language_code and
   * name. Note that this is only a preference, not requirement; if a
   * voice of the appropriate gender is not available, the synthesizer should
   * substitute a voice with a different gender rather than failing the request.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1beta1.SsmlVoiceGender ssml_gender = 3;</code>
   *
   * @return The enum numeric value on the wire for ssmlGender.
   */
  @java.lang.Override
  public int getSsmlGenderValue() {
    return ssmlGender_;
  }
  /**
   *
   *
   * <pre>
   * The preferred gender of the voice. If not set, the service will
   * choose a voice based on the other parameters such as language_code and
   * name. Note that this is only a preference, not requirement; if a
   * voice of the appropriate gender is not available, the synthesizer should
   * substitute a voice with a different gender rather than failing the request.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1beta1.SsmlVoiceGender ssml_gender = 3;</code>
   *
   * @return The ssmlGender.
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.SsmlVoiceGender getSsmlGender() {
    com.google.cloud.texttospeech.v1beta1.SsmlVoiceGender result =
        com.google.cloud.texttospeech.v1beta1.SsmlVoiceGender.forNumber(ssmlGender_);
    return result == null
        ? com.google.cloud.texttospeech.v1beta1.SsmlVoiceGender.UNRECOGNIZED
        : result;
  }

  public static final int CUSTOM_VOICE_FIELD_NUMBER = 4;
  private com.google.cloud.texttospeech.v1beta1.CustomVoiceParams customVoice_;
  /**
   *
   *
   * <pre>
   * The configuration for a custom voice. If [CustomVoiceParams.model] is set,
   * the service will choose the custom voice matching the specified
   * configuration.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1beta1.CustomVoiceParams custom_voice = 4;</code>
   *
   * @return Whether the customVoice field is set.
   */
  @java.lang.Override
  public boolean hasCustomVoice() {
    return customVoice_ != null;
  }
  /**
   *
   *
   * <pre>
   * The configuration for a custom voice. If [CustomVoiceParams.model] is set,
   * the service will choose the custom voice matching the specified
   * configuration.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1beta1.CustomVoiceParams custom_voice = 4;</code>
   *
   * @return The customVoice.
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.CustomVoiceParams getCustomVoice() {
    return customVoice_ == null
        ? com.google.cloud.texttospeech.v1beta1.CustomVoiceParams.getDefaultInstance()
        : customVoice_;
  }
  /**
   *
   *
   * <pre>
   * The configuration for a custom voice. If [CustomVoiceParams.model] is set,
   * the service will choose the custom voice matching the specified
   * configuration.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1beta1.CustomVoiceParams custom_voice = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.CustomVoiceParamsOrBuilder
      getCustomVoiceOrBuilder() {
    return customVoice_ == null
        ? com.google.cloud.texttospeech.v1beta1.CustomVoiceParams.getDefaultInstance()
        : customVoice_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, languageCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, name_);
    }
    if (ssmlGender_
        != com.google.cloud.texttospeech.v1beta1.SsmlVoiceGender.SSML_VOICE_GENDER_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, ssmlGender_);
    }
    if (customVoice_ != null) {
      output.writeMessage(4, getCustomVoice());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(languageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, languageCode_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, name_);
    }
    if (ssmlGender_
        != com.google.cloud.texttospeech.v1beta1.SsmlVoiceGender.SSML_VOICE_GENDER_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, ssmlGender_);
    }
    if (customVoice_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCustomVoice());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams)) {
      return super.equals(obj);
    }
    com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams other =
        (com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams) obj;

    if (!getLanguageCode().equals(other.getLanguageCode())) return false;
    if (!getName().equals(other.getName())) return false;
    if (ssmlGender_ != other.ssmlGender_) return false;
    if (hasCustomVoice() != other.hasCustomVoice()) return false;
    if (hasCustomVoice()) {
      if (!getCustomVoice().equals(other.getCustomVoice())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getLanguageCode().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + SSML_GENDER_FIELD_NUMBER;
    hash = (53 * hash) + ssmlGender_;
    if (hasCustomVoice()) {
      hash = (37 * hash) + CUSTOM_VOICE_FIELD_NUMBER;
      hash = (53 * hash) + getCustomVoice().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Description of which voice to use for a synthesis request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.texttospeech.v1beta1.VoiceSelectionParams}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.texttospeech.v1beta1.VoiceSelectionParams)
      com.google.cloud.texttospeech.v1beta1.VoiceSelectionParamsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.texttospeech.v1beta1.TextToSpeechProto
          .internal_static_google_cloud_texttospeech_v1beta1_VoiceSelectionParams_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.texttospeech.v1beta1.TextToSpeechProto
          .internal_static_google_cloud_texttospeech_v1beta1_VoiceSelectionParams_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.class,
              com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.Builder.class);
    }

    // Construct using com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      languageCode_ = "";
      name_ = "";
      ssmlGender_ = 0;
      customVoice_ = null;
      if (customVoiceBuilder_ != null) {
        customVoiceBuilder_.dispose();
        customVoiceBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.texttospeech.v1beta1.TextToSpeechProto
          .internal_static_google_cloud_texttospeech_v1beta1_VoiceSelectionParams_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams getDefaultInstanceForType() {
      return com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams build() {
      com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams buildPartial() {
      com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams result =
          new com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.languageCode_ = languageCode_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.ssmlGender_ = ssmlGender_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.customVoice_ =
            customVoiceBuilder_ == null ? customVoice_ : customVoiceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams) {
        return mergeFrom((com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams other) {
      if (other == com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.getDefaultInstance())
        return this;
      if (!other.getLanguageCode().isEmpty()) {
        languageCode_ = other.languageCode_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.ssmlGender_ != 0) {
        setSsmlGenderValue(other.getSsmlGenderValue());
      }
      if (other.hasCustomVoice()) {
        mergeCustomVoice(other.getCustomVoice());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                languageCode_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                ssmlGender_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(getCustomVoiceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object languageCode_ = "";
    /**
     *
     *
     * <pre>
     * Required. The language (and potentially also the region) of the voice expressed as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag, e.g.
     * "en-US". This should not include a script tag (e.g. use
     * "cmn-cn" rather than "cmn-Hant-cn"), because the script will be inferred
     * from the input provided in the SynthesisInput.  The TTS service
     * will use this parameter to help choose an appropriate voice.  Note that
     * the TTS service may choose a voice with a slightly different language code
     * than the one selected; it may substitute a different region
     * (e.g. using en-US rather than en-CA if there isn't a Canadian voice
     * available), or even a different language, e.g. using "nb" (Norwegian
     * Bokmal) instead of "no" (Norwegian)".
     * </pre>
     *
     * <code>string language_code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The languageCode.
     */
    public java.lang.String getLanguageCode() {
      java.lang.Object ref = languageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        languageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The language (and potentially also the region) of the voice expressed as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag, e.g.
     * "en-US". This should not include a script tag (e.g. use
     * "cmn-cn" rather than "cmn-Hant-cn"), because the script will be inferred
     * from the input provided in the SynthesisInput.  The TTS service
     * will use this parameter to help choose an appropriate voice.  Note that
     * the TTS service may choose a voice with a slightly different language code
     * than the one selected; it may substitute a different region
     * (e.g. using en-US rather than en-CA if there isn't a Canadian voice
     * available), or even a different language, e.g. using "nb" (Norwegian
     * Bokmal) instead of "no" (Norwegian)".
     * </pre>
     *
     * <code>string language_code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for languageCode.
     */
    public com.google.protobuf.ByteString getLanguageCodeBytes() {
      java.lang.Object ref = languageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        languageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The language (and potentially also the region) of the voice expressed as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag, e.g.
     * "en-US". This should not include a script tag (e.g. use
     * "cmn-cn" rather than "cmn-Hant-cn"), because the script will be inferred
     * from the input provided in the SynthesisInput.  The TTS service
     * will use this parameter to help choose an appropriate voice.  Note that
     * the TTS service may choose a voice with a slightly different language code
     * than the one selected; it may substitute a different region
     * (e.g. using en-US rather than en-CA if there isn't a Canadian voice
     * available), or even a different language, e.g. using "nb" (Norwegian
     * Bokmal) instead of "no" (Norwegian)".
     * </pre>
     *
     * <code>string language_code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      languageCode_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The language (and potentially also the region) of the voice expressed as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag, e.g.
     * "en-US". This should not include a script tag (e.g. use
     * "cmn-cn" rather than "cmn-Hant-cn"), because the script will be inferred
     * from the input provided in the SynthesisInput.  The TTS service
     * will use this parameter to help choose an appropriate voice.  Note that
     * the TTS service may choose a voice with a slightly different language code
     * than the one selected; it may substitute a different region
     * (e.g. using en-US rather than en-CA if there isn't a Canadian voice
     * available), or even a different language, e.g. using "nb" (Norwegian
     * Bokmal) instead of "no" (Norwegian)".
     * </pre>
     *
     * <code>string language_code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLanguageCode() {
      languageCode_ = getDefaultInstance().getLanguageCode();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The language (and potentially also the region) of the voice expressed as a
     * [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag, e.g.
     * "en-US". This should not include a script tag (e.g. use
     * "cmn-cn" rather than "cmn-Hant-cn"), because the script will be inferred
     * from the input provided in the SynthesisInput.  The TTS service
     * will use this parameter to help choose an appropriate voice.  Note that
     * the TTS service may choose a voice with a slightly different language code
     * than the one selected; it may substitute a different region
     * (e.g. using en-US rather than en-CA if there isn't a Canadian voice
     * available), or even a different language, e.g. using "nb" (Norwegian
     * Bokmal) instead of "no" (Norwegian)".
     * </pre>
     *
     * <code>string language_code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for languageCode to set.
     * @return This builder for chaining.
     */
    public Builder setLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      languageCode_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * The name of the voice. If not set, the service will choose a
     * voice based on the other parameters such as language_code and gender.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the voice. If not set, the service will choose a
     * voice based on the other parameters such as language_code and gender.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The name of the voice. If not set, the service will choose a
     * voice based on the other parameters such as language_code and gender.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the voice. If not set, the service will choose a
     * voice based on the other parameters such as language_code and gender.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The name of the voice. If not set, the service will choose a
     * voice based on the other parameters such as language_code and gender.
     * </pre>
     *
     * <code>string name = 2;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int ssmlGender_ = 0;
    /**
     *
     *
     * <pre>
     * The preferred gender of the voice. If not set, the service will
     * choose a voice based on the other parameters such as language_code and
     * name. Note that this is only a preference, not requirement; if a
     * voice of the appropriate gender is not available, the synthesizer should
     * substitute a voice with a different gender rather than failing the request.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.SsmlVoiceGender ssml_gender = 3;</code>
     *
     * @return The enum numeric value on the wire for ssmlGender.
     */
    @java.lang.Override
    public int getSsmlGenderValue() {
      return ssmlGender_;
    }
    /**
     *
     *
     * <pre>
     * The preferred gender of the voice. If not set, the service will
     * choose a voice based on the other parameters such as language_code and
     * name. Note that this is only a preference, not requirement; if a
     * voice of the appropriate gender is not available, the synthesizer should
     * substitute a voice with a different gender rather than failing the request.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.SsmlVoiceGender ssml_gender = 3;</code>
     *
     * @param value The enum numeric value on the wire for ssmlGender to set.
     * @return This builder for chaining.
     */
    public Builder setSsmlGenderValue(int value) {
      ssmlGender_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The preferred gender of the voice. If not set, the service will
     * choose a voice based on the other parameters such as language_code and
     * name. Note that this is only a preference, not requirement; if a
     * voice of the appropriate gender is not available, the synthesizer should
     * substitute a voice with a different gender rather than failing the request.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.SsmlVoiceGender ssml_gender = 3;</code>
     *
     * @return The ssmlGender.
     */
    @java.lang.Override
    public com.google.cloud.texttospeech.v1beta1.SsmlVoiceGender getSsmlGender() {
      com.google.cloud.texttospeech.v1beta1.SsmlVoiceGender result =
          com.google.cloud.texttospeech.v1beta1.SsmlVoiceGender.forNumber(ssmlGender_);
      return result == null
          ? com.google.cloud.texttospeech.v1beta1.SsmlVoiceGender.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The preferred gender of the voice. If not set, the service will
     * choose a voice based on the other parameters such as language_code and
     * name. Note that this is only a preference, not requirement; if a
     * voice of the appropriate gender is not available, the synthesizer should
     * substitute a voice with a different gender rather than failing the request.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.SsmlVoiceGender ssml_gender = 3;</code>
     *
     * @param value The ssmlGender to set.
     * @return This builder for chaining.
     */
    public Builder setSsmlGender(com.google.cloud.texttospeech.v1beta1.SsmlVoiceGender value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      ssmlGender_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The preferred gender of the voice. If not set, the service will
     * choose a voice based on the other parameters such as language_code and
     * name. Note that this is only a preference, not requirement; if a
     * voice of the appropriate gender is not available, the synthesizer should
     * substitute a voice with a different gender rather than failing the request.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.SsmlVoiceGender ssml_gender = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSsmlGender() {
      bitField0_ = (bitField0_ & ~0x00000004);
      ssmlGender_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.texttospeech.v1beta1.CustomVoiceParams customVoice_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.texttospeech.v1beta1.CustomVoiceParams,
            com.google.cloud.texttospeech.v1beta1.CustomVoiceParams.Builder,
            com.google.cloud.texttospeech.v1beta1.CustomVoiceParamsOrBuilder>
        customVoiceBuilder_;
    /**
     *
     *
     * <pre>
     * The configuration for a custom voice. If [CustomVoiceParams.model] is set,
     * the service will choose the custom voice matching the specified
     * configuration.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.CustomVoiceParams custom_voice = 4;</code>
     *
     * @return Whether the customVoice field is set.
     */
    public boolean hasCustomVoice() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * The configuration for a custom voice. If [CustomVoiceParams.model] is set,
     * the service will choose the custom voice matching the specified
     * configuration.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.CustomVoiceParams custom_voice = 4;</code>
     *
     * @return The customVoice.
     */
    public com.google.cloud.texttospeech.v1beta1.CustomVoiceParams getCustomVoice() {
      if (customVoiceBuilder_ == null) {
        return customVoice_ == null
            ? com.google.cloud.texttospeech.v1beta1.CustomVoiceParams.getDefaultInstance()
            : customVoice_;
      } else {
        return customVoiceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for a custom voice. If [CustomVoiceParams.model] is set,
     * the service will choose the custom voice matching the specified
     * configuration.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.CustomVoiceParams custom_voice = 4;</code>
     */
    public Builder setCustomVoice(com.google.cloud.texttospeech.v1beta1.CustomVoiceParams value) {
      if (customVoiceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        customVoice_ = value;
      } else {
        customVoiceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for a custom voice. If [CustomVoiceParams.model] is set,
     * the service will choose the custom voice matching the specified
     * configuration.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.CustomVoiceParams custom_voice = 4;</code>
     */
    public Builder setCustomVoice(
        com.google.cloud.texttospeech.v1beta1.CustomVoiceParams.Builder builderForValue) {
      if (customVoiceBuilder_ == null) {
        customVoice_ = builderForValue.build();
      } else {
        customVoiceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for a custom voice. If [CustomVoiceParams.model] is set,
     * the service will choose the custom voice matching the specified
     * configuration.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.CustomVoiceParams custom_voice = 4;</code>
     */
    public Builder mergeCustomVoice(com.google.cloud.texttospeech.v1beta1.CustomVoiceParams value) {
      if (customVoiceBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && customVoice_ != null
            && customVoice_
                != com.google.cloud.texttospeech.v1beta1.CustomVoiceParams.getDefaultInstance()) {
          getCustomVoiceBuilder().mergeFrom(value);
        } else {
          customVoice_ = value;
        }
      } else {
        customVoiceBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for a custom voice. If [CustomVoiceParams.model] is set,
     * the service will choose the custom voice matching the specified
     * configuration.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.CustomVoiceParams custom_voice = 4;</code>
     */
    public Builder clearCustomVoice() {
      bitField0_ = (bitField0_ & ~0x00000008);
      customVoice_ = null;
      if (customVoiceBuilder_ != null) {
        customVoiceBuilder_.dispose();
        customVoiceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The configuration for a custom voice. If [CustomVoiceParams.model] is set,
     * the service will choose the custom voice matching the specified
     * configuration.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.CustomVoiceParams custom_voice = 4;</code>
     */
    public com.google.cloud.texttospeech.v1beta1.CustomVoiceParams.Builder getCustomVoiceBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getCustomVoiceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The configuration for a custom voice. If [CustomVoiceParams.model] is set,
     * the service will choose the custom voice matching the specified
     * configuration.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.CustomVoiceParams custom_voice = 4;</code>
     */
    public com.google.cloud.texttospeech.v1beta1.CustomVoiceParamsOrBuilder
        getCustomVoiceOrBuilder() {
      if (customVoiceBuilder_ != null) {
        return customVoiceBuilder_.getMessageOrBuilder();
      } else {
        return customVoice_ == null
            ? com.google.cloud.texttospeech.v1beta1.CustomVoiceParams.getDefaultInstance()
            : customVoice_;
      }
    }
    /**
     *
     *
     * <pre>
     * The configuration for a custom voice. If [CustomVoiceParams.model] is set,
     * the service will choose the custom voice matching the specified
     * configuration.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.CustomVoiceParams custom_voice = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.texttospeech.v1beta1.CustomVoiceParams,
            com.google.cloud.texttospeech.v1beta1.CustomVoiceParams.Builder,
            com.google.cloud.texttospeech.v1beta1.CustomVoiceParamsOrBuilder>
        getCustomVoiceFieldBuilder() {
      if (customVoiceBuilder_ == null) {
        customVoiceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.texttospeech.v1beta1.CustomVoiceParams,
                com.google.cloud.texttospeech.v1beta1.CustomVoiceParams.Builder,
                com.google.cloud.texttospeech.v1beta1.CustomVoiceParamsOrBuilder>(
                getCustomVoice(), getParentForChildren(), isClean());
        customVoice_ = null;
      }
      return customVoiceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.texttospeech.v1beta1.VoiceSelectionParams)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.texttospeech.v1beta1.VoiceSelectionParams)
  private static final com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams();
  }

  public static com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VoiceSelectionParams> PARSER =
      new com.google.protobuf.AbstractParser<VoiceSelectionParams>() {
        @java.lang.Override
        public VoiceSelectionParams parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VoiceSelectionParams> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VoiceSelectionParams> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
