/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/texttospeech/v1beta1/cloud_tts.proto

package com.google.cloud.texttospeech.v1beta1;

/**
 *
 *
 * <pre>
 * The message returned to the client by the `SynthesizeSpeech` method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse}
 */
public final class SynthesizeSpeechResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse)
    SynthesizeSpeechResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SynthesizeSpeechResponse.newBuilder() to construct.
  private SynthesizeSpeechResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SynthesizeSpeechResponse() {
    audioContent_ = com.google.protobuf.ByteString.EMPTY;
    timepoints_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SynthesizeSpeechResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.texttospeech.v1beta1.TextToSpeechProto
        .internal_static_google_cloud_texttospeech_v1beta1_SynthesizeSpeechResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.texttospeech.v1beta1.TextToSpeechProto
        .internal_static_google_cloud_texttospeech_v1beta1_SynthesizeSpeechResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse.class,
            com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse.Builder.class);
  }

  public static final int AUDIO_CONTENT_FIELD_NUMBER = 1;
  private com.google.protobuf.ByteString audioContent_ = com.google.protobuf.ByteString.EMPTY;
  /**
   *
   *
   * <pre>
   * The audio data bytes encoded as specified in the request, including the
   * header for encodings that are wrapped in containers (e.g. MP3, OGG_OPUS).
   * For LINEAR16 audio, we include the WAV header. Note: as
   * with all bytes fields, protobuffers use a pure binary representation,
   * whereas JSON representations use base64.
   * </pre>
   *
   * <code>bytes audio_content = 1;</code>
   *
   * @return The audioContent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAudioContent() {
    return audioContent_;
  }

  public static final int TIMEPOINTS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.texttospeech.v1beta1.Timepoint> timepoints_;
  /**
   *
   *
   * <pre>
   * A link between a position in the original request input and a corresponding
   * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
   * </pre>
   *
   * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.texttospeech.v1beta1.Timepoint> getTimepointsList() {
    return timepoints_;
  }
  /**
   *
   *
   * <pre>
   * A link between a position in the original request input and a corresponding
   * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
   * </pre>
   *
   * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.texttospeech.v1beta1.TimepointOrBuilder>
      getTimepointsOrBuilderList() {
    return timepoints_;
  }
  /**
   *
   *
   * <pre>
   * A link between a position in the original request input and a corresponding
   * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
   * </pre>
   *
   * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
   */
  @java.lang.Override
  public int getTimepointsCount() {
    return timepoints_.size();
  }
  /**
   *
   *
   * <pre>
   * A link between a position in the original request input and a corresponding
   * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
   * </pre>
   *
   * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.Timepoint getTimepoints(int index) {
    return timepoints_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A link between a position in the original request input and a corresponding
   * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
   * </pre>
   *
   * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.TimepointOrBuilder getTimepointsOrBuilder(
      int index) {
    return timepoints_.get(index);
  }

  public static final int AUDIO_CONFIG_FIELD_NUMBER = 4;
  private com.google.cloud.texttospeech.v1beta1.AudioConfig audioConfig_;
  /**
   *
   *
   * <pre>
   * The audio metadata of `audio_content`.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 4;</code>
   *
   * @return Whether the audioConfig field is set.
   */
  @java.lang.Override
  public boolean hasAudioConfig() {
    return audioConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * The audio metadata of `audio_content`.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 4;</code>
   *
   * @return The audioConfig.
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.AudioConfig getAudioConfig() {
    return audioConfig_ == null
        ? com.google.cloud.texttospeech.v1beta1.AudioConfig.getDefaultInstance()
        : audioConfig_;
  }
  /**
   *
   *
   * <pre>
   * The audio metadata of `audio_content`.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.AudioConfigOrBuilder getAudioConfigOrBuilder() {
    return audioConfig_ == null
        ? com.google.cloud.texttospeech.v1beta1.AudioConfig.getDefaultInstance()
        : audioConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!audioContent_.isEmpty()) {
      output.writeBytes(1, audioContent_);
    }
    for (int i = 0; i < timepoints_.size(); i++) {
      output.writeMessage(2, timepoints_.get(i));
    }
    if (audioConfig_ != null) {
      output.writeMessage(4, getAudioConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!audioContent_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(1, audioContent_);
    }
    for (int i = 0; i < timepoints_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, timepoints_.get(i));
    }
    if (audioConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getAudioConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse other =
        (com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse) obj;

    if (!getAudioContent().equals(other.getAudioContent())) return false;
    if (!getTimepointsList().equals(other.getTimepointsList())) return false;
    if (hasAudioConfig() != other.hasAudioConfig()) return false;
    if (hasAudioConfig()) {
      if (!getAudioConfig().equals(other.getAudioConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + AUDIO_CONTENT_FIELD_NUMBER;
    hash = (53 * hash) + getAudioContent().hashCode();
    if (getTimepointsCount() > 0) {
      hash = (37 * hash) + TIMEPOINTS_FIELD_NUMBER;
      hash = (53 * hash) + getTimepointsList().hashCode();
    }
    if (hasAudioConfig()) {
      hash = (37 * hash) + AUDIO_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAudioConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The message returned to the client by the `SynthesizeSpeech` method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse)
      com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.texttospeech.v1beta1.TextToSpeechProto
          .internal_static_google_cloud_texttospeech_v1beta1_SynthesizeSpeechResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.texttospeech.v1beta1.TextToSpeechProto
          .internal_static_google_cloud_texttospeech_v1beta1_SynthesizeSpeechResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse.class,
              com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse.Builder.class);
    }

    // Construct using com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      audioContent_ = com.google.protobuf.ByteString.EMPTY;
      if (timepointsBuilder_ == null) {
        timepoints_ = java.util.Collections.emptyList();
      } else {
        timepoints_ = null;
        timepointsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      audioConfig_ = null;
      if (audioConfigBuilder_ != null) {
        audioConfigBuilder_.dispose();
        audioConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.texttospeech.v1beta1.TextToSpeechProto
          .internal_static_google_cloud_texttospeech_v1beta1_SynthesizeSpeechResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse
        getDefaultInstanceForType() {
      return com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse build() {
      com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse buildPartial() {
      com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse result =
          new com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse result) {
      if (timepointsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          timepoints_ = java.util.Collections.unmodifiableList(timepoints_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.timepoints_ = timepoints_;
      } else {
        result.timepoints_ = timepointsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.audioContent_ = audioContent_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.audioConfig_ =
            audioConfigBuilder_ == null ? audioConfig_ : audioConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse) {
        return mergeFrom((com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse other) {
      if (other
          == com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse.getDefaultInstance())
        return this;
      if (other.getAudioContent() != com.google.protobuf.ByteString.EMPTY) {
        setAudioContent(other.getAudioContent());
      }
      if (timepointsBuilder_ == null) {
        if (!other.timepoints_.isEmpty()) {
          if (timepoints_.isEmpty()) {
            timepoints_ = other.timepoints_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureTimepointsIsMutable();
            timepoints_.addAll(other.timepoints_);
          }
          onChanged();
        }
      } else {
        if (!other.timepoints_.isEmpty()) {
          if (timepointsBuilder_.isEmpty()) {
            timepointsBuilder_.dispose();
            timepointsBuilder_ = null;
            timepoints_ = other.timepoints_;
            bitField0_ = (bitField0_ & ~0x00000002);
            timepointsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTimepointsFieldBuilder()
                    : null;
          } else {
            timepointsBuilder_.addAllMessages(other.timepoints_);
          }
        }
      }
      if (other.hasAudioConfig()) {
        mergeAudioConfig(other.getAudioConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                audioContent_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.texttospeech.v1beta1.Timepoint m =
                    input.readMessage(
                        com.google.cloud.texttospeech.v1beta1.Timepoint.parser(),
                        extensionRegistry);
                if (timepointsBuilder_ == null) {
                  ensureTimepointsIsMutable();
                  timepoints_.add(m);
                } else {
                  timepointsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 34:
              {
                input.readMessage(getAudioConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.ByteString audioContent_ = com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * The audio data bytes encoded as specified in the request, including the
     * header for encodings that are wrapped in containers (e.g. MP3, OGG_OPUS).
     * For LINEAR16 audio, we include the WAV header. Note: as
     * with all bytes fields, protobuffers use a pure binary representation,
     * whereas JSON representations use base64.
     * </pre>
     *
     * <code>bytes audio_content = 1;</code>
     *
     * @return The audioContent.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getAudioContent() {
      return audioContent_;
    }
    /**
     *
     *
     * <pre>
     * The audio data bytes encoded as specified in the request, including the
     * header for encodings that are wrapped in containers (e.g. MP3, OGG_OPUS).
     * For LINEAR16 audio, we include the WAV header. Note: as
     * with all bytes fields, protobuffers use a pure binary representation,
     * whereas JSON representations use base64.
     * </pre>
     *
     * <code>bytes audio_content = 1;</code>
     *
     * @param value The audioContent to set.
     * @return This builder for chaining.
     */
    public Builder setAudioContent(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      audioContent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The audio data bytes encoded as specified in the request, including the
     * header for encodings that are wrapped in containers (e.g. MP3, OGG_OPUS).
     * For LINEAR16 audio, we include the WAV header. Note: as
     * with all bytes fields, protobuffers use a pure binary representation,
     * whereas JSON representations use base64.
     * </pre>
     *
     * <code>bytes audio_content = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAudioContent() {
      bitField0_ = (bitField0_ & ~0x00000001);
      audioContent_ = getDefaultInstance().getAudioContent();
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.texttospeech.v1beta1.Timepoint> timepoints_ =
        java.util.Collections.emptyList();

    private void ensureTimepointsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        timepoints_ =
            new java.util.ArrayList<com.google.cloud.texttospeech.v1beta1.Timepoint>(timepoints_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.texttospeech.v1beta1.Timepoint,
            com.google.cloud.texttospeech.v1beta1.Timepoint.Builder,
            com.google.cloud.texttospeech.v1beta1.TimepointOrBuilder>
        timepointsBuilder_;

    /**
     *
     *
     * <pre>
     * A link between a position in the original request input and a corresponding
     * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
     * </pre>
     *
     * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
     */
    public java.util.List<com.google.cloud.texttospeech.v1beta1.Timepoint> getTimepointsList() {
      if (timepointsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(timepoints_);
      } else {
        return timepointsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A link between a position in the original request input and a corresponding
     * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
     * </pre>
     *
     * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
     */
    public int getTimepointsCount() {
      if (timepointsBuilder_ == null) {
        return timepoints_.size();
      } else {
        return timepointsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A link between a position in the original request input and a corresponding
     * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
     * </pre>
     *
     * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
     */
    public com.google.cloud.texttospeech.v1beta1.Timepoint getTimepoints(int index) {
      if (timepointsBuilder_ == null) {
        return timepoints_.get(index);
      } else {
        return timepointsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A link between a position in the original request input and a corresponding
     * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
     * </pre>
     *
     * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
     */
    public Builder setTimepoints(int index, com.google.cloud.texttospeech.v1beta1.Timepoint value) {
      if (timepointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTimepointsIsMutable();
        timepoints_.set(index, value);
        onChanged();
      } else {
        timepointsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A link between a position in the original request input and a corresponding
     * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
     * </pre>
     *
     * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
     */
    public Builder setTimepoints(
        int index, com.google.cloud.texttospeech.v1beta1.Timepoint.Builder builderForValue) {
      if (timepointsBuilder_ == null) {
        ensureTimepointsIsMutable();
        timepoints_.set(index, builderForValue.build());
        onChanged();
      } else {
        timepointsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A link between a position in the original request input and a corresponding
     * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
     * </pre>
     *
     * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
     */
    public Builder addTimepoints(com.google.cloud.texttospeech.v1beta1.Timepoint value) {
      if (timepointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTimepointsIsMutable();
        timepoints_.add(value);
        onChanged();
      } else {
        timepointsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A link between a position in the original request input and a corresponding
     * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
     * </pre>
     *
     * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
     */
    public Builder addTimepoints(int index, com.google.cloud.texttospeech.v1beta1.Timepoint value) {
      if (timepointsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTimepointsIsMutable();
        timepoints_.add(index, value);
        onChanged();
      } else {
        timepointsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A link between a position in the original request input and a corresponding
     * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
     * </pre>
     *
     * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
     */
    public Builder addTimepoints(
        com.google.cloud.texttospeech.v1beta1.Timepoint.Builder builderForValue) {
      if (timepointsBuilder_ == null) {
        ensureTimepointsIsMutable();
        timepoints_.add(builderForValue.build());
        onChanged();
      } else {
        timepointsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A link between a position in the original request input and a corresponding
     * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
     * </pre>
     *
     * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
     */
    public Builder addTimepoints(
        int index, com.google.cloud.texttospeech.v1beta1.Timepoint.Builder builderForValue) {
      if (timepointsBuilder_ == null) {
        ensureTimepointsIsMutable();
        timepoints_.add(index, builderForValue.build());
        onChanged();
      } else {
        timepointsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A link between a position in the original request input and a corresponding
     * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
     * </pre>
     *
     * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
     */
    public Builder addAllTimepoints(
        java.lang.Iterable<? extends com.google.cloud.texttospeech.v1beta1.Timepoint> values) {
      if (timepointsBuilder_ == null) {
        ensureTimepointsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, timepoints_);
        onChanged();
      } else {
        timepointsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A link between a position in the original request input and a corresponding
     * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
     * </pre>
     *
     * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
     */
    public Builder clearTimepoints() {
      if (timepointsBuilder_ == null) {
        timepoints_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        timepointsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A link between a position in the original request input and a corresponding
     * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
     * </pre>
     *
     * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
     */
    public Builder removeTimepoints(int index) {
      if (timepointsBuilder_ == null) {
        ensureTimepointsIsMutable();
        timepoints_.remove(index);
        onChanged();
      } else {
        timepointsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A link between a position in the original request input and a corresponding
     * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
     * </pre>
     *
     * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
     */
    public com.google.cloud.texttospeech.v1beta1.Timepoint.Builder getTimepointsBuilder(int index) {
      return getTimepointsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A link between a position in the original request input and a corresponding
     * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
     * </pre>
     *
     * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
     */
    public com.google.cloud.texttospeech.v1beta1.TimepointOrBuilder getTimepointsOrBuilder(
        int index) {
      if (timepointsBuilder_ == null) {
        return timepoints_.get(index);
      } else {
        return timepointsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A link between a position in the original request input and a corresponding
     * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
     * </pre>
     *
     * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
     */
    public java.util.List<? extends com.google.cloud.texttospeech.v1beta1.TimepointOrBuilder>
        getTimepointsOrBuilderList() {
      if (timepointsBuilder_ != null) {
        return timepointsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(timepoints_);
      }
    }
    /**
     *
     *
     * <pre>
     * A link between a position in the original request input and a corresponding
     * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
     * </pre>
     *
     * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
     */
    public com.google.cloud.texttospeech.v1beta1.Timepoint.Builder addTimepointsBuilder() {
      return getTimepointsFieldBuilder()
          .addBuilder(com.google.cloud.texttospeech.v1beta1.Timepoint.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A link between a position in the original request input and a corresponding
     * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
     * </pre>
     *
     * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
     */
    public com.google.cloud.texttospeech.v1beta1.Timepoint.Builder addTimepointsBuilder(int index) {
      return getTimepointsFieldBuilder()
          .addBuilder(index, com.google.cloud.texttospeech.v1beta1.Timepoint.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A link between a position in the original request input and a corresponding
     * time in the output audio. It's only supported via `&lt;mark&gt;` of SSML input.
     * </pre>
     *
     * <code>repeated .google.cloud.texttospeech.v1beta1.Timepoint timepoints = 2;</code>
     */
    public java.util.List<com.google.cloud.texttospeech.v1beta1.Timepoint.Builder>
        getTimepointsBuilderList() {
      return getTimepointsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.texttospeech.v1beta1.Timepoint,
            com.google.cloud.texttospeech.v1beta1.Timepoint.Builder,
            com.google.cloud.texttospeech.v1beta1.TimepointOrBuilder>
        getTimepointsFieldBuilder() {
      if (timepointsBuilder_ == null) {
        timepointsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.texttospeech.v1beta1.Timepoint,
                com.google.cloud.texttospeech.v1beta1.Timepoint.Builder,
                com.google.cloud.texttospeech.v1beta1.TimepointOrBuilder>(
                timepoints_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        timepoints_ = null;
      }
      return timepointsBuilder_;
    }

    private com.google.cloud.texttospeech.v1beta1.AudioConfig audioConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.texttospeech.v1beta1.AudioConfig,
            com.google.cloud.texttospeech.v1beta1.AudioConfig.Builder,
            com.google.cloud.texttospeech.v1beta1.AudioConfigOrBuilder>
        audioConfigBuilder_;
    /**
     *
     *
     * <pre>
     * The audio metadata of `audio_content`.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 4;</code>
     *
     * @return Whether the audioConfig field is set.
     */
    public boolean hasAudioConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * The audio metadata of `audio_content`.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 4;</code>
     *
     * @return The audioConfig.
     */
    public com.google.cloud.texttospeech.v1beta1.AudioConfig getAudioConfig() {
      if (audioConfigBuilder_ == null) {
        return audioConfig_ == null
            ? com.google.cloud.texttospeech.v1beta1.AudioConfig.getDefaultInstance()
            : audioConfig_;
      } else {
        return audioConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The audio metadata of `audio_content`.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 4;</code>
     */
    public Builder setAudioConfig(com.google.cloud.texttospeech.v1beta1.AudioConfig value) {
      if (audioConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        audioConfig_ = value;
      } else {
        audioConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The audio metadata of `audio_content`.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 4;</code>
     */
    public Builder setAudioConfig(
        com.google.cloud.texttospeech.v1beta1.AudioConfig.Builder builderForValue) {
      if (audioConfigBuilder_ == null) {
        audioConfig_ = builderForValue.build();
      } else {
        audioConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The audio metadata of `audio_content`.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 4;</code>
     */
    public Builder mergeAudioConfig(com.google.cloud.texttospeech.v1beta1.AudioConfig value) {
      if (audioConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && audioConfig_ != null
            && audioConfig_
                != com.google.cloud.texttospeech.v1beta1.AudioConfig.getDefaultInstance()) {
          getAudioConfigBuilder().mergeFrom(value);
        } else {
          audioConfig_ = value;
        }
      } else {
        audioConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The audio metadata of `audio_content`.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 4;</code>
     */
    public Builder clearAudioConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      audioConfig_ = null;
      if (audioConfigBuilder_ != null) {
        audioConfigBuilder_.dispose();
        audioConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The audio metadata of `audio_content`.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 4;</code>
     */
    public com.google.cloud.texttospeech.v1beta1.AudioConfig.Builder getAudioConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getAudioConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The audio metadata of `audio_content`.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 4;</code>
     */
    public com.google.cloud.texttospeech.v1beta1.AudioConfigOrBuilder getAudioConfigOrBuilder() {
      if (audioConfigBuilder_ != null) {
        return audioConfigBuilder_.getMessageOrBuilder();
      } else {
        return audioConfig_ == null
            ? com.google.cloud.texttospeech.v1beta1.AudioConfig.getDefaultInstance()
            : audioConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * The audio metadata of `audio_content`.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 4;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.texttospeech.v1beta1.AudioConfig,
            com.google.cloud.texttospeech.v1beta1.AudioConfig.Builder,
            com.google.cloud.texttospeech.v1beta1.AudioConfigOrBuilder>
        getAudioConfigFieldBuilder() {
      if (audioConfigBuilder_ == null) {
        audioConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.texttospeech.v1beta1.AudioConfig,
                com.google.cloud.texttospeech.v1beta1.AudioConfig.Builder,
                com.google.cloud.texttospeech.v1beta1.AudioConfigOrBuilder>(
                getAudioConfig(), getParentForChildren(), isClean());
        audioConfig_ = null;
      }
      return audioConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse)
  private static final com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse();
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SynthesizeSpeechResponse> PARSER =
      new com.google.protobuf.AbstractParser<SynthesizeSpeechResponse>() {
        @java.lang.Override
        public SynthesizeSpeechResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SynthesizeSpeechResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SynthesizeSpeechResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechResponse
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
