/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/texttospeech/v1beta1/cloud_tts.proto

package com.google.cloud.texttospeech.v1beta1;

/**
 *
 *
 * <pre>
 * The top-level message sent by the client for the `SynthesizeSpeech` method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest}
 */
public final class SynthesizeSpeechRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest)
    SynthesizeSpeechRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SynthesizeSpeechRequest.newBuilder() to construct.
  private SynthesizeSpeechRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SynthesizeSpeechRequest() {
    enableTimePointing_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SynthesizeSpeechRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.texttospeech.v1beta1.TextToSpeechProto
        .internal_static_google_cloud_texttospeech_v1beta1_SynthesizeSpeechRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.texttospeech.v1beta1.TextToSpeechProto
        .internal_static_google_cloud_texttospeech_v1beta1_SynthesizeSpeechRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.class,
            com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The type of timepoint information that is returned in the response.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType}
   */
  public enum TimepointType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not specified. No timepoint information will be returned.
     * </pre>
     *
     * <code>TIMEPOINT_TYPE_UNSPECIFIED = 0;</code>
     */
    TIMEPOINT_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Timepoint information of `&lt;mark&gt;` tags in SSML input will be returned.
     * </pre>
     *
     * <code>SSML_MARK = 1;</code>
     */
    SSML_MARK(1),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not specified. No timepoint information will be returned.
     * </pre>
     *
     * <code>TIMEPOINT_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TIMEPOINT_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Timepoint information of `&lt;mark&gt;` tags in SSML input will be returned.
     * </pre>
     *
     * <code>SSML_MARK = 1;</code>
     */
    public static final int SSML_MARK_VALUE = 1;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static TimepointType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static TimepointType forNumber(int value) {
      switch (value) {
        case 0:
          return TIMEPOINT_TYPE_UNSPECIFIED;
        case 1:
          return SSML_MARK;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<TimepointType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<TimepointType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<TimepointType>() {
          public TimepointType findValueByNumber(int number) {
            return TimepointType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final TimepointType[] VALUES = values();

    public static TimepointType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private TimepointType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType)
  }

  public static final int INPUT_FIELD_NUMBER = 1;
  private com.google.cloud.texttospeech.v1beta1.SynthesisInput input_;
  /**
   *
   *
   * <pre>
   * Required. The Synthesizer requires either plain text or SSML as input.
   * </pre>
   *
   * <code>
   * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the input field is set.
   */
  @java.lang.Override
  public boolean hasInput() {
    return input_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The Synthesizer requires either plain text or SSML as input.
   * </pre>
   *
   * <code>
   * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The input.
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.SynthesisInput getInput() {
    return input_ == null
        ? com.google.cloud.texttospeech.v1beta1.SynthesisInput.getDefaultInstance()
        : input_;
  }
  /**
   *
   *
   * <pre>
   * Required. The Synthesizer requires either plain text or SSML as input.
   * </pre>
   *
   * <code>
   * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.SynthesisInputOrBuilder getInputOrBuilder() {
    return input_ == null
        ? com.google.cloud.texttospeech.v1beta1.SynthesisInput.getDefaultInstance()
        : input_;
  }

  public static final int VOICE_FIELD_NUMBER = 2;
  private com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice_;
  /**
   *
   *
   * <pre>
   * Required. The desired voice of the synthesized audio.
   * </pre>
   *
   * <code>
   * .google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the voice field is set.
   */
  @java.lang.Override
  public boolean hasVoice() {
    return voice_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The desired voice of the synthesized audio.
   * </pre>
   *
   * <code>
   * .google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The voice.
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams getVoice() {
    return voice_ == null
        ? com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.getDefaultInstance()
        : voice_;
  }
  /**
   *
   *
   * <pre>
   * Required. The desired voice of the synthesized audio.
   * </pre>
   *
   * <code>
   * .google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.VoiceSelectionParamsOrBuilder getVoiceOrBuilder() {
    return voice_ == null
        ? com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.getDefaultInstance()
        : voice_;
  }

  public static final int AUDIO_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.texttospeech.v1beta1.AudioConfig audioConfig_;
  /**
   *
   *
   * <pre>
   * Required. The configuration of the synthesized audio.
   * </pre>
   *
   * <code>
   * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the audioConfig field is set.
   */
  @java.lang.Override
  public boolean hasAudioConfig() {
    return audioConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The configuration of the synthesized audio.
   * </pre>
   *
   * <code>
   * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The audioConfig.
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.AudioConfig getAudioConfig() {
    return audioConfig_ == null
        ? com.google.cloud.texttospeech.v1beta1.AudioConfig.getDefaultInstance()
        : audioConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. The configuration of the synthesized audio.
   * </pre>
   *
   * <code>
   * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.AudioConfigOrBuilder getAudioConfigOrBuilder() {
    return audioConfig_ == null
        ? com.google.cloud.texttospeech.v1beta1.AudioConfig.getDefaultInstance()
        : audioConfig_;
  }

  public static final int ENABLE_TIME_POINTING_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<java.lang.Integer> enableTimePointing_;

  private static final com.google.protobuf.Internal.ListAdapter.Converter<
          java.lang.Integer,
          com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType>
      enableTimePointing_converter_ =
          new com.google.protobuf.Internal.ListAdapter.Converter<
              java.lang.Integer,
              com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType>() {
            public com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType
                convert(java.lang.Integer from) {
              com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType result =
                  com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType
                      .forNumber(from);
              return result == null
                  ? com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType
                      .UNRECOGNIZED
                  : result;
            }
          };
  /**
   *
   *
   * <pre>
   * Whether and what timepoints are returned in the response.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType enable_time_pointing = 4;
   * </code>
   *
   * @return A list containing the enableTimePointing.
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType>
      getEnableTimePointingList() {
    return new com.google.protobuf.Internal.ListAdapter<
        java.lang.Integer,
        com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType>(
        enableTimePointing_, enableTimePointing_converter_);
  }
  /**
   *
   *
   * <pre>
   * Whether and what timepoints are returned in the response.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType enable_time_pointing = 4;
   * </code>
   *
   * @return The count of enableTimePointing.
   */
  @java.lang.Override
  public int getEnableTimePointingCount() {
    return enableTimePointing_.size();
  }
  /**
   *
   *
   * <pre>
   * Whether and what timepoints are returned in the response.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType enable_time_pointing = 4;
   * </code>
   *
   * @param index The index of the element to return.
   * @return The enableTimePointing at the given index.
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType
      getEnableTimePointing(int index) {
    return enableTimePointing_converter_.convert(enableTimePointing_.get(index));
  }
  /**
   *
   *
   * <pre>
   * Whether and what timepoints are returned in the response.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType enable_time_pointing = 4;
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for enableTimePointing.
   */
  @java.lang.Override
  public java.util.List<java.lang.Integer> getEnableTimePointingValueList() {
    return enableTimePointing_;
  }
  /**
   *
   *
   * <pre>
   * Whether and what timepoints are returned in the response.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType enable_time_pointing = 4;
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of enableTimePointing at the given index.
   */
  @java.lang.Override
  public int getEnableTimePointingValue(int index) {
    return enableTimePointing_.get(index);
  }

  private int enableTimePointingMemoizedSerializedSize;

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    getSerializedSize();
    if (input_ != null) {
      output.writeMessage(1, getInput());
    }
    if (voice_ != null) {
      output.writeMessage(2, getVoice());
    }
    if (audioConfig_ != null) {
      output.writeMessage(3, getAudioConfig());
    }
    if (getEnableTimePointingList().size() > 0) {
      output.writeUInt32NoTag(34);
      output.writeUInt32NoTag(enableTimePointingMemoizedSerializedSize);
    }
    for (int i = 0; i < enableTimePointing_.size(); i++) {
      output.writeEnumNoTag(enableTimePointing_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (input_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getInput());
    }
    if (voice_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getVoice());
    }
    if (audioConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAudioConfig());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < enableTimePointing_.size(); i++) {
        dataSize +=
            com.google.protobuf.CodedOutputStream.computeEnumSizeNoTag(enableTimePointing_.get(i));
      }
      size += dataSize;
      if (!getEnableTimePointingList().isEmpty()) {
        size += 1;
        size += com.google.protobuf.CodedOutputStream.computeUInt32SizeNoTag(dataSize);
      }
      enableTimePointingMemoizedSerializedSize = dataSize;
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest other =
        (com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest) obj;

    if (hasInput() != other.hasInput()) return false;
    if (hasInput()) {
      if (!getInput().equals(other.getInput())) return false;
    }
    if (hasVoice() != other.hasVoice()) return false;
    if (hasVoice()) {
      if (!getVoice().equals(other.getVoice())) return false;
    }
    if (hasAudioConfig() != other.hasAudioConfig()) return false;
    if (hasAudioConfig()) {
      if (!getAudioConfig().equals(other.getAudioConfig())) return false;
    }
    if (!enableTimePointing_.equals(other.enableTimePointing_)) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasInput()) {
      hash = (37 * hash) + INPUT_FIELD_NUMBER;
      hash = (53 * hash) + getInput().hashCode();
    }
    if (hasVoice()) {
      hash = (37 * hash) + VOICE_FIELD_NUMBER;
      hash = (53 * hash) + getVoice().hashCode();
    }
    if (hasAudioConfig()) {
      hash = (37 * hash) + AUDIO_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAudioConfig().hashCode();
    }
    if (getEnableTimePointingCount() > 0) {
      hash = (37 * hash) + ENABLE_TIME_POINTING_FIELD_NUMBER;
      hash = (53 * hash) + enableTimePointing_.hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The top-level message sent by the client for the `SynthesizeSpeech` method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest)
      com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.texttospeech.v1beta1.TextToSpeechProto
          .internal_static_google_cloud_texttospeech_v1beta1_SynthesizeSpeechRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.texttospeech.v1beta1.TextToSpeechProto
          .internal_static_google_cloud_texttospeech_v1beta1_SynthesizeSpeechRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.class,
              com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.Builder.class);
    }

    // Construct using com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      input_ = null;
      if (inputBuilder_ != null) {
        inputBuilder_.dispose();
        inputBuilder_ = null;
      }
      voice_ = null;
      if (voiceBuilder_ != null) {
        voiceBuilder_.dispose();
        voiceBuilder_ = null;
      }
      audioConfig_ = null;
      if (audioConfigBuilder_ != null) {
        audioConfigBuilder_.dispose();
        audioConfigBuilder_ = null;
      }
      enableTimePointing_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.texttospeech.v1beta1.TextToSpeechProto
          .internal_static_google_cloud_texttospeech_v1beta1_SynthesizeSpeechRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest
        getDefaultInstanceForType() {
      return com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest build() {
      com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest buildPartial() {
      com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest result =
          new com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest result) {
      if (((bitField0_ & 0x00000008) != 0)) {
        enableTimePointing_ = java.util.Collections.unmodifiableList(enableTimePointing_);
        bitField0_ = (bitField0_ & ~0x00000008);
      }
      result.enableTimePointing_ = enableTimePointing_;
    }

    private void buildPartial0(
        com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.input_ = inputBuilder_ == null ? input_ : inputBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.voice_ = voiceBuilder_ == null ? voice_ : voiceBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.audioConfig_ =
            audioConfigBuilder_ == null ? audioConfig_ : audioConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest) {
        return mergeFrom((com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest other) {
      if (other
          == com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.getDefaultInstance())
        return this;
      if (other.hasInput()) {
        mergeInput(other.getInput());
      }
      if (other.hasVoice()) {
        mergeVoice(other.getVoice());
      }
      if (other.hasAudioConfig()) {
        mergeAudioConfig(other.getAudioConfig());
      }
      if (!other.enableTimePointing_.isEmpty()) {
        if (enableTimePointing_.isEmpty()) {
          enableTimePointing_ = other.enableTimePointing_;
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          ensureEnableTimePointingIsMutable();
          enableTimePointing_.addAll(other.enableTimePointing_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getInputFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getVoiceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getAudioConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                int tmpRaw = input.readEnum();
                ensureEnableTimePointingIsMutable();
                enableTimePointing_.add(tmpRaw);
                break;
              } // case 32
            case 34:
              {
                int length = input.readRawVarint32();
                int oldLimit = input.pushLimit(length);
                while (input.getBytesUntilLimit() > 0) {
                  int tmpRaw = input.readEnum();
                  ensureEnableTimePointingIsMutable();
                  enableTimePointing_.add(tmpRaw);
                }
                input.popLimit(oldLimit);
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.texttospeech.v1beta1.SynthesisInput input_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.texttospeech.v1beta1.SynthesisInput,
            com.google.cloud.texttospeech.v1beta1.SynthesisInput.Builder,
            com.google.cloud.texttospeech.v1beta1.SynthesisInputOrBuilder>
        inputBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The Synthesizer requires either plain text or SSML as input.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the input field is set.
     */
    public boolean hasInput() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The Synthesizer requires either plain text or SSML as input.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The input.
     */
    public com.google.cloud.texttospeech.v1beta1.SynthesisInput getInput() {
      if (inputBuilder_ == null) {
        return input_ == null
            ? com.google.cloud.texttospeech.v1beta1.SynthesisInput.getDefaultInstance()
            : input_;
      } else {
        return inputBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Synthesizer requires either plain text or SSML as input.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInput(com.google.cloud.texttospeech.v1beta1.SynthesisInput value) {
      if (inputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        input_ = value;
      } else {
        inputBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Synthesizer requires either plain text or SSML as input.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInput(
        com.google.cloud.texttospeech.v1beta1.SynthesisInput.Builder builderForValue) {
      if (inputBuilder_ == null) {
        input_ = builderForValue.build();
      } else {
        inputBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Synthesizer requires either plain text or SSML as input.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeInput(com.google.cloud.texttospeech.v1beta1.SynthesisInput value) {
      if (inputBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && input_ != null
            && input_
                != com.google.cloud.texttospeech.v1beta1.SynthesisInput.getDefaultInstance()) {
          getInputBuilder().mergeFrom(value);
        } else {
          input_ = value;
        }
      } else {
        inputBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Synthesizer requires either plain text or SSML as input.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearInput() {
      bitField0_ = (bitField0_ & ~0x00000001);
      input_ = null;
      if (inputBuilder_ != null) {
        inputBuilder_.dispose();
        inputBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Synthesizer requires either plain text or SSML as input.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.texttospeech.v1beta1.SynthesisInput.Builder getInputBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The Synthesizer requires either plain text or SSML as input.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.texttospeech.v1beta1.SynthesisInputOrBuilder getInputOrBuilder() {
      if (inputBuilder_ != null) {
        return inputBuilder_.getMessageOrBuilder();
      } else {
        return input_ == null
            ? com.google.cloud.texttospeech.v1beta1.SynthesisInput.getDefaultInstance()
            : input_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Synthesizer requires either plain text or SSML as input.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.texttospeech.v1beta1.SynthesisInput,
            com.google.cloud.texttospeech.v1beta1.SynthesisInput.Builder,
            com.google.cloud.texttospeech.v1beta1.SynthesisInputOrBuilder>
        getInputFieldBuilder() {
      if (inputBuilder_ == null) {
        inputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.texttospeech.v1beta1.SynthesisInput,
                com.google.cloud.texttospeech.v1beta1.SynthesisInput.Builder,
                com.google.cloud.texttospeech.v1beta1.SynthesisInputOrBuilder>(
                getInput(), getParentForChildren(), isClean());
        input_ = null;
      }
      return inputBuilder_;
    }

    private com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams,
            com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.Builder,
            com.google.cloud.texttospeech.v1beta1.VoiceSelectionParamsOrBuilder>
        voiceBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the voice field is set.
     */
    public boolean hasVoice() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The voice.
     */
    public com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams getVoice() {
      if (voiceBuilder_ == null) {
        return voice_ == null
            ? com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.getDefaultInstance()
            : voice_;
      } else {
        return voiceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setVoice(com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams value) {
      if (voiceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        voice_ = value;
      } else {
        voiceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setVoice(
        com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.Builder builderForValue) {
      if (voiceBuilder_ == null) {
        voice_ = builderForValue.build();
      } else {
        voiceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeVoice(com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams value) {
      if (voiceBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && voice_ != null
            && voice_
                != com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams
                    .getDefaultInstance()) {
          getVoiceBuilder().mergeFrom(value);
        } else {
          voice_ = value;
        }
      } else {
        voiceBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearVoice() {
      bitField0_ = (bitField0_ & ~0x00000002);
      voice_ = null;
      if (voiceBuilder_ != null) {
        voiceBuilder_.dispose();
        voiceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.Builder getVoiceBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getVoiceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.texttospeech.v1beta1.VoiceSelectionParamsOrBuilder getVoiceOrBuilder() {
      if (voiceBuilder_ != null) {
        return voiceBuilder_.getMessageOrBuilder();
      } else {
        return voice_ == null
            ? com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.getDefaultInstance()
            : voice_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams,
            com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.Builder,
            com.google.cloud.texttospeech.v1beta1.VoiceSelectionParamsOrBuilder>
        getVoiceFieldBuilder() {
      if (voiceBuilder_ == null) {
        voiceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams,
                com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.Builder,
                com.google.cloud.texttospeech.v1beta1.VoiceSelectionParamsOrBuilder>(
                getVoice(), getParentForChildren(), isClean());
        voice_ = null;
      }
      return voiceBuilder_;
    }

    private com.google.cloud.texttospeech.v1beta1.AudioConfig audioConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.texttospeech.v1beta1.AudioConfig,
            com.google.cloud.texttospeech.v1beta1.AudioConfig.Builder,
            com.google.cloud.texttospeech.v1beta1.AudioConfigOrBuilder>
        audioConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The configuration of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the audioConfig field is set.
     */
    public boolean hasAudioConfig() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The audioConfig.
     */
    public com.google.cloud.texttospeech.v1beta1.AudioConfig getAudioConfig() {
      if (audioConfigBuilder_ == null) {
        return audioConfig_ == null
            ? com.google.cloud.texttospeech.v1beta1.AudioConfig.getDefaultInstance()
            : audioConfig_;
      } else {
        return audioConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAudioConfig(com.google.cloud.texttospeech.v1beta1.AudioConfig value) {
      if (audioConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        audioConfig_ = value;
      } else {
        audioConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAudioConfig(
        com.google.cloud.texttospeech.v1beta1.AudioConfig.Builder builderForValue) {
      if (audioConfigBuilder_ == null) {
        audioConfig_ = builderForValue.build();
      } else {
        audioConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeAudioConfig(com.google.cloud.texttospeech.v1beta1.AudioConfig value) {
      if (audioConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && audioConfig_ != null
            && audioConfig_
                != com.google.cloud.texttospeech.v1beta1.AudioConfig.getDefaultInstance()) {
          getAudioConfigBuilder().mergeFrom(value);
        } else {
          audioConfig_ = value;
        }
      } else {
        audioConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearAudioConfig() {
      bitField0_ = (bitField0_ & ~0x00000004);
      audioConfig_ = null;
      if (audioConfigBuilder_ != null) {
        audioConfigBuilder_.dispose();
        audioConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.texttospeech.v1beta1.AudioConfig.Builder getAudioConfigBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getAudioConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.texttospeech.v1beta1.AudioConfigOrBuilder getAudioConfigOrBuilder() {
      if (audioConfigBuilder_ != null) {
        return audioConfigBuilder_.getMessageOrBuilder();
      } else {
        return audioConfig_ == null
            ? com.google.cloud.texttospeech.v1beta1.AudioConfig.getDefaultInstance()
            : audioConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.texttospeech.v1beta1.AudioConfig,
            com.google.cloud.texttospeech.v1beta1.AudioConfig.Builder,
            com.google.cloud.texttospeech.v1beta1.AudioConfigOrBuilder>
        getAudioConfigFieldBuilder() {
      if (audioConfigBuilder_ == null) {
        audioConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.texttospeech.v1beta1.AudioConfig,
                com.google.cloud.texttospeech.v1beta1.AudioConfig.Builder,
                com.google.cloud.texttospeech.v1beta1.AudioConfigOrBuilder>(
                getAudioConfig(), getParentForChildren(), isClean());
        audioConfig_ = null;
      }
      return audioConfigBuilder_;
    }

    private java.util.List<java.lang.Integer> enableTimePointing_ =
        java.util.Collections.emptyList();

    private void ensureEnableTimePointingIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        enableTimePointing_ = new java.util.ArrayList<java.lang.Integer>(enableTimePointing_);
        bitField0_ |= 0x00000008;
      }
    }
    /**
     *
     *
     * <pre>
     * Whether and what timepoints are returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType enable_time_pointing = 4;
     * </code>
     *
     * @return A list containing the enableTimePointing.
     */
    public java.util.List<
            com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType>
        getEnableTimePointingList() {
      return new com.google.protobuf.Internal.ListAdapter<
          java.lang.Integer,
          com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType>(
          enableTimePointing_, enableTimePointing_converter_);
    }
    /**
     *
     *
     * <pre>
     * Whether and what timepoints are returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType enable_time_pointing = 4;
     * </code>
     *
     * @return The count of enableTimePointing.
     */
    public int getEnableTimePointingCount() {
      return enableTimePointing_.size();
    }
    /**
     *
     *
     * <pre>
     * Whether and what timepoints are returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType enable_time_pointing = 4;
     * </code>
     *
     * @param index The index of the element to return.
     * @return The enableTimePointing at the given index.
     */
    public com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType
        getEnableTimePointing(int index) {
      return enableTimePointing_converter_.convert(enableTimePointing_.get(index));
    }
    /**
     *
     *
     * <pre>
     * Whether and what timepoints are returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType enable_time_pointing = 4;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enableTimePointing to set.
     * @return This builder for chaining.
     */
    public Builder setEnableTimePointing(
        int index,
        com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEnableTimePointingIsMutable();
      enableTimePointing_.set(index, value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether and what timepoints are returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType enable_time_pointing = 4;
     * </code>
     *
     * @param value The enableTimePointing to add.
     * @return This builder for chaining.
     */
    public Builder addEnableTimePointing(
        com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEnableTimePointingIsMutable();
      enableTimePointing_.add(value.getNumber());
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether and what timepoints are returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType enable_time_pointing = 4;
     * </code>
     *
     * @param values The enableTimePointing to add.
     * @return This builder for chaining.
     */
    public Builder addAllEnableTimePointing(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType>
            values) {
      ensureEnableTimePointingIsMutable();
      for (com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType value :
          values) {
        enableTimePointing_.add(value.getNumber());
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether and what timepoints are returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType enable_time_pointing = 4;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEnableTimePointing() {
      enableTimePointing_ = java.util.Collections.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether and what timepoints are returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType enable_time_pointing = 4;
     * </code>
     *
     * @return A list containing the enum numeric values on the wire for enableTimePointing.
     */
    public java.util.List<java.lang.Integer> getEnableTimePointingValueList() {
      return java.util.Collections.unmodifiableList(enableTimePointing_);
    }
    /**
     *
     *
     * <pre>
     * Whether and what timepoints are returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType enable_time_pointing = 4;
     * </code>
     *
     * @param index The index of the value to return.
     * @return The enum numeric value on the wire of enableTimePointing at the given index.
     */
    public int getEnableTimePointingValue(int index) {
      return enableTimePointing_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Whether and what timepoints are returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType enable_time_pointing = 4;
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The enum numeric value on the wire for enableTimePointing to set.
     * @return This builder for chaining.
     */
    public Builder setEnableTimePointingValue(int index, int value) {
      ensureEnableTimePointingIsMutable();
      enableTimePointing_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether and what timepoints are returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType enable_time_pointing = 4;
     * </code>
     *
     * @param value The enum numeric value on the wire for enableTimePointing to add.
     * @return This builder for chaining.
     */
    public Builder addEnableTimePointingValue(int value) {
      ensureEnableTimePointingIsMutable();
      enableTimePointing_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Whether and what timepoints are returned in the response.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest.TimepointType enable_time_pointing = 4;
     * </code>
     *
     * @param values The enum numeric values on the wire for enableTimePointing to add.
     * @return This builder for chaining.
     */
    public Builder addAllEnableTimePointingValue(java.lang.Iterable<java.lang.Integer> values) {
      ensureEnableTimePointingIsMutable();
      for (int value : values) {
        enableTimePointing_.add(value);
      }
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest)
  private static final com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest();
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SynthesizeSpeechRequest> PARSER =
      new com.google.protobuf.AbstractParser<SynthesizeSpeechRequest>() {
        @java.lang.Override
        public SynthesizeSpeechRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SynthesizeSpeechRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SynthesizeSpeechRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.SynthesizeSpeechRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
