/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/texttospeech/v1beta1/cloud_tts_lrs.proto

package com.google.cloud.texttospeech.v1beta1;

/**
 *
 *
 * <pre>
 * The top-level message sent by the client for the
 * `SynthesizeLongAudio` method.
 * </pre>
 *
 * Protobuf type {@code google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest}
 */
public final class SynthesizeLongAudioRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest)
    SynthesizeLongAudioRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use SynthesizeLongAudioRequest.newBuilder() to construct.
  private SynthesizeLongAudioRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private SynthesizeLongAudioRequest() {
    parent_ = "";
    outputGcsUri_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new SynthesizeLongAudioRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.texttospeech.v1beta1.TextToSpeechLongAudioSynthesisProto
        .internal_static_google_cloud_texttospeech_v1beta1_SynthesizeLongAudioRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.texttospeech.v1beta1.TextToSpeechLongAudioSynthesisProto
        .internal_static_google_cloud_texttospeech_v1beta1_SynthesizeLongAudioRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest.class,
            com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * The resource states of the request in the form of
   * projects/&#42;&#47;locations/&#42;&#47;voices/&#42;.
   * </pre>
   *
   * <code>string parent = 1;</code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The resource states of the request in the form of
   * projects/&#42;&#47;locations/&#42;&#47;voices/&#42;.
   * </pre>
   *
   * <code>string parent = 1;</code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INPUT_FIELD_NUMBER = 2;
  private com.google.cloud.texttospeech.v1beta1.SynthesisInput input_;
  /**
   *
   *
   * <pre>
   * Required. The Synthesizer requires either plain text or SSML as input.
   * </pre>
   *
   * <code>
   * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the input field is set.
   */
  @java.lang.Override
  public boolean hasInput() {
    return input_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The Synthesizer requires either plain text or SSML as input.
   * </pre>
   *
   * <code>
   * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The input.
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.SynthesisInput getInput() {
    return input_ == null
        ? com.google.cloud.texttospeech.v1beta1.SynthesisInput.getDefaultInstance()
        : input_;
  }
  /**
   *
   *
   * <pre>
   * Required. The Synthesizer requires either plain text or SSML as input.
   * </pre>
   *
   * <code>
   * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.SynthesisInputOrBuilder getInputOrBuilder() {
    return getInput();
  }

  public static final int AUDIO_CONFIG_FIELD_NUMBER = 3;
  private com.google.cloud.texttospeech.v1beta1.AudioConfig audioConfig_;
  /**
   *
   *
   * <pre>
   * Required. The configuration of the synthesized audio.
   * </pre>
   *
   * <code>
   * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the audioConfig field is set.
   */
  @java.lang.Override
  public boolean hasAudioConfig() {
    return audioConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. The configuration of the synthesized audio.
   * </pre>
   *
   * <code>
   * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The audioConfig.
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.AudioConfig getAudioConfig() {
    return audioConfig_ == null
        ? com.google.cloud.texttospeech.v1beta1.AudioConfig.getDefaultInstance()
        : audioConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. The configuration of the synthesized audio.
   * </pre>
   *
   * <code>
   * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.AudioConfigOrBuilder getAudioConfigOrBuilder() {
    return getAudioConfig();
  }

  public static final int OUTPUT_GCS_URI_FIELD_NUMBER = 4;
  private volatile java.lang.Object outputGcsUri_;
  /**
   *
   *
   * <pre>
   * Specifies a Cloud Storage URI for the synthesis results. Must be
   * specified in the format: `gs://bucket_name/object_name`, and the bucket
   * must already exist.
   * </pre>
   *
   * <code>string output_gcs_uri = 4;</code>
   *
   * @return The outputGcsUri.
   */
  @java.lang.Override
  public java.lang.String getOutputGcsUri() {
    java.lang.Object ref = outputGcsUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      outputGcsUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Specifies a Cloud Storage URI for the synthesis results. Must be
   * specified in the format: `gs://bucket_name/object_name`, and the bucket
   * must already exist.
   * </pre>
   *
   * <code>string output_gcs_uri = 4;</code>
   *
   * @return The bytes for outputGcsUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getOutputGcsUriBytes() {
    java.lang.Object ref = outputGcsUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      outputGcsUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VOICE_FIELD_NUMBER = 5;
  private com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice_;
  /**
   *
   *
   * <pre>
   * The desired voice of the synthesized audio.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 5;</code>
   *
   * @return Whether the voice field is set.
   */
  @java.lang.Override
  public boolean hasVoice() {
    return voice_ != null;
  }
  /**
   *
   *
   * <pre>
   * The desired voice of the synthesized audio.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 5;</code>
   *
   * @return The voice.
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams getVoice() {
    return voice_ == null
        ? com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.getDefaultInstance()
        : voice_;
  }
  /**
   *
   *
   * <pre>
   * The desired voice of the synthesized audio.
   * </pre>
   *
   * <code>.google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.VoiceSelectionParamsOrBuilder getVoiceOrBuilder() {
    return getVoice();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (input_ != null) {
      output.writeMessage(2, getInput());
    }
    if (audioConfig_ != null) {
      output.writeMessage(3, getAudioConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputGcsUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, outputGcsUri_);
    }
    if (voice_ != null) {
      output.writeMessage(5, getVoice());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (input_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getInput());
    }
    if (audioConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getAudioConfig());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(outputGcsUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, outputGcsUri_);
    }
    if (voice_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getVoice());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest other =
        (com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (hasInput() != other.hasInput()) return false;
    if (hasInput()) {
      if (!getInput().equals(other.getInput())) return false;
    }
    if (hasAudioConfig() != other.hasAudioConfig()) return false;
    if (hasAudioConfig()) {
      if (!getAudioConfig().equals(other.getAudioConfig())) return false;
    }
    if (!getOutputGcsUri().equals(other.getOutputGcsUri())) return false;
    if (hasVoice() != other.hasVoice()) return false;
    if (hasVoice()) {
      if (!getVoice().equals(other.getVoice())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (hasInput()) {
      hash = (37 * hash) + INPUT_FIELD_NUMBER;
      hash = (53 * hash) + getInput().hashCode();
    }
    if (hasAudioConfig()) {
      hash = (37 * hash) + AUDIO_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getAudioConfig().hashCode();
    }
    hash = (37 * hash) + OUTPUT_GCS_URI_FIELD_NUMBER;
    hash = (53 * hash) + getOutputGcsUri().hashCode();
    if (hasVoice()) {
      hash = (37 * hash) + VOICE_FIELD_NUMBER;
      hash = (53 * hash) + getVoice().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest parseFrom(
      byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The top-level message sent by the client for the
   * `SynthesizeLongAudio` method.
   * </pre>
   *
   * Protobuf type {@code google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest)
      com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.texttospeech.v1beta1.TextToSpeechLongAudioSynthesisProto
          .internal_static_google_cloud_texttospeech_v1beta1_SynthesizeLongAudioRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.texttospeech.v1beta1.TextToSpeechLongAudioSynthesisProto
          .internal_static_google_cloud_texttospeech_v1beta1_SynthesizeLongAudioRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest.class,
              com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest.Builder.class);
    }

    // Construct using com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      if (inputBuilder_ == null) {
        input_ = null;
      } else {
        input_ = null;
        inputBuilder_ = null;
      }
      if (audioConfigBuilder_ == null) {
        audioConfig_ = null;
      } else {
        audioConfig_ = null;
        audioConfigBuilder_ = null;
      }
      outputGcsUri_ = "";

      if (voiceBuilder_ == null) {
        voice_ = null;
      } else {
        voice_ = null;
        voiceBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.texttospeech.v1beta1.TextToSpeechLongAudioSynthesisProto
          .internal_static_google_cloud_texttospeech_v1beta1_SynthesizeLongAudioRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest
        getDefaultInstanceForType() {
      return com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest build() {
      com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest buildPartial() {
      com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest result =
          new com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest(this);
      result.parent_ = parent_;
      if (inputBuilder_ == null) {
        result.input_ = input_;
      } else {
        result.input_ = inputBuilder_.build();
      }
      if (audioConfigBuilder_ == null) {
        result.audioConfig_ = audioConfig_;
      } else {
        result.audioConfig_ = audioConfigBuilder_.build();
      }
      result.outputGcsUri_ = outputGcsUri_;
      if (voiceBuilder_ == null) {
        result.voice_ = voice_;
      } else {
        result.voice_ = voiceBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest) {
        return mergeFrom((com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest other) {
      if (other
          == com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (other.hasInput()) {
        mergeInput(other.getInput());
      }
      if (other.hasAudioConfig()) {
        mergeAudioConfig(other.getAudioConfig());
      }
      if (!other.getOutputGcsUri().isEmpty()) {
        outputGcsUri_ = other.outputGcsUri_;
        onChanged();
      }
      if (other.hasVoice()) {
        mergeVoice(other.getVoice());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();

                break;
              } // case 10
            case 18:
              {
                input.readMessage(getInputFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 18
            case 26:
              {
                input.readMessage(getAudioConfigFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 26
            case 34:
              {
                outputGcsUri_ = input.readStringRequireUtf8();

                break;
              } // case 34
            case 42:
              {
                input.readMessage(getVoiceFieldBuilder().getBuilder(), extensionRegistry);

                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * The resource states of the request in the form of
     * projects/&#42;&#47;locations/&#42;&#47;voices/&#42;.
     * </pre>
     *
     * <code>string parent = 1;</code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource states of the request in the form of
     * projects/&#42;&#47;locations/&#42;&#47;voices/&#42;.
     * </pre>
     *
     * <code>string parent = 1;</code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The resource states of the request in the form of
     * projects/&#42;&#47;locations/&#42;&#47;voices/&#42;.
     * </pre>
     *
     * <code>string parent = 1;</code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource states of the request in the form of
     * projects/&#42;&#47;locations/&#42;&#47;voices/&#42;.
     * </pre>
     *
     * <code>string parent = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The resource states of the request in the form of
     * projects/&#42;&#47;locations/&#42;&#47;voices/&#42;.
     * </pre>
     *
     * <code>string parent = 1;</code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.texttospeech.v1beta1.SynthesisInput input_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.texttospeech.v1beta1.SynthesisInput,
            com.google.cloud.texttospeech.v1beta1.SynthesisInput.Builder,
            com.google.cloud.texttospeech.v1beta1.SynthesisInputOrBuilder>
        inputBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The Synthesizer requires either plain text or SSML as input.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the input field is set.
     */
    public boolean hasInput() {
      return inputBuilder_ != null || input_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The Synthesizer requires either plain text or SSML as input.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The input.
     */
    public com.google.cloud.texttospeech.v1beta1.SynthesisInput getInput() {
      if (inputBuilder_ == null) {
        return input_ == null
            ? com.google.cloud.texttospeech.v1beta1.SynthesisInput.getDefaultInstance()
            : input_;
      } else {
        return inputBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Synthesizer requires either plain text or SSML as input.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInput(com.google.cloud.texttospeech.v1beta1.SynthesisInput value) {
      if (inputBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        input_ = value;
        onChanged();
      } else {
        inputBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Synthesizer requires either plain text or SSML as input.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInput(
        com.google.cloud.texttospeech.v1beta1.SynthesisInput.Builder builderForValue) {
      if (inputBuilder_ == null) {
        input_ = builderForValue.build();
        onChanged();
      } else {
        inputBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Synthesizer requires either plain text or SSML as input.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeInput(com.google.cloud.texttospeech.v1beta1.SynthesisInput value) {
      if (inputBuilder_ == null) {
        if (input_ != null) {
          input_ =
              com.google.cloud.texttospeech.v1beta1.SynthesisInput.newBuilder(input_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          input_ = value;
        }
        onChanged();
      } else {
        inputBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Synthesizer requires either plain text or SSML as input.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearInput() {
      if (inputBuilder_ == null) {
        input_ = null;
        onChanged();
      } else {
        input_ = null;
        inputBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Synthesizer requires either plain text or SSML as input.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.texttospeech.v1beta1.SynthesisInput.Builder getInputBuilder() {

      onChanged();
      return getInputFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The Synthesizer requires either plain text or SSML as input.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.texttospeech.v1beta1.SynthesisInputOrBuilder getInputOrBuilder() {
      if (inputBuilder_ != null) {
        return inputBuilder_.getMessageOrBuilder();
      } else {
        return input_ == null
            ? com.google.cloud.texttospeech.v1beta1.SynthesisInput.getDefaultInstance()
            : input_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Synthesizer requires either plain text or SSML as input.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.SynthesisInput input = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.texttospeech.v1beta1.SynthesisInput,
            com.google.cloud.texttospeech.v1beta1.SynthesisInput.Builder,
            com.google.cloud.texttospeech.v1beta1.SynthesisInputOrBuilder>
        getInputFieldBuilder() {
      if (inputBuilder_ == null) {
        inputBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.texttospeech.v1beta1.SynthesisInput,
                com.google.cloud.texttospeech.v1beta1.SynthesisInput.Builder,
                com.google.cloud.texttospeech.v1beta1.SynthesisInputOrBuilder>(
                getInput(), getParentForChildren(), isClean());
        input_ = null;
      }
      return inputBuilder_;
    }

    private com.google.cloud.texttospeech.v1beta1.AudioConfig audioConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.texttospeech.v1beta1.AudioConfig,
            com.google.cloud.texttospeech.v1beta1.AudioConfig.Builder,
            com.google.cloud.texttospeech.v1beta1.AudioConfigOrBuilder>
        audioConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The configuration of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the audioConfig field is set.
     */
    public boolean hasAudioConfig() {
      return audioConfigBuilder_ != null || audioConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The audioConfig.
     */
    public com.google.cloud.texttospeech.v1beta1.AudioConfig getAudioConfig() {
      if (audioConfigBuilder_ == null) {
        return audioConfig_ == null
            ? com.google.cloud.texttospeech.v1beta1.AudioConfig.getDefaultInstance()
            : audioConfig_;
      } else {
        return audioConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAudioConfig(com.google.cloud.texttospeech.v1beta1.AudioConfig value) {
      if (audioConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        audioConfig_ = value;
        onChanged();
      } else {
        audioConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAudioConfig(
        com.google.cloud.texttospeech.v1beta1.AudioConfig.Builder builderForValue) {
      if (audioConfigBuilder_ == null) {
        audioConfig_ = builderForValue.build();
        onChanged();
      } else {
        audioConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeAudioConfig(com.google.cloud.texttospeech.v1beta1.AudioConfig value) {
      if (audioConfigBuilder_ == null) {
        if (audioConfig_ != null) {
          audioConfig_ =
              com.google.cloud.texttospeech.v1beta1.AudioConfig.newBuilder(audioConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          audioConfig_ = value;
        }
        onChanged();
      } else {
        audioConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearAudioConfig() {
      if (audioConfigBuilder_ == null) {
        audioConfig_ = null;
        onChanged();
      } else {
        audioConfig_ = null;
        audioConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.texttospeech.v1beta1.AudioConfig.Builder getAudioConfigBuilder() {

      onChanged();
      return getAudioConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.texttospeech.v1beta1.AudioConfigOrBuilder getAudioConfigOrBuilder() {
      if (audioConfigBuilder_ != null) {
        return audioConfigBuilder_.getMessageOrBuilder();
      } else {
        return audioConfig_ == null
            ? com.google.cloud.texttospeech.v1beta1.AudioConfig.getDefaultInstance()
            : audioConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The configuration of the synthesized audio.
     * </pre>
     *
     * <code>
     * .google.cloud.texttospeech.v1beta1.AudioConfig audio_config = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.texttospeech.v1beta1.AudioConfig,
            com.google.cloud.texttospeech.v1beta1.AudioConfig.Builder,
            com.google.cloud.texttospeech.v1beta1.AudioConfigOrBuilder>
        getAudioConfigFieldBuilder() {
      if (audioConfigBuilder_ == null) {
        audioConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.texttospeech.v1beta1.AudioConfig,
                com.google.cloud.texttospeech.v1beta1.AudioConfig.Builder,
                com.google.cloud.texttospeech.v1beta1.AudioConfigOrBuilder>(
                getAudioConfig(), getParentForChildren(), isClean());
        audioConfig_ = null;
      }
      return audioConfigBuilder_;
    }

    private java.lang.Object outputGcsUri_ = "";
    /**
     *
     *
     * <pre>
     * Specifies a Cloud Storage URI for the synthesis results. Must be
     * specified in the format: `gs://bucket_name/object_name`, and the bucket
     * must already exist.
     * </pre>
     *
     * <code>string output_gcs_uri = 4;</code>
     *
     * @return The outputGcsUri.
     */
    public java.lang.String getOutputGcsUri() {
      java.lang.Object ref = outputGcsUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        outputGcsUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a Cloud Storage URI for the synthesis results. Must be
     * specified in the format: `gs://bucket_name/object_name`, and the bucket
     * must already exist.
     * </pre>
     *
     * <code>string output_gcs_uri = 4;</code>
     *
     * @return The bytes for outputGcsUri.
     */
    public com.google.protobuf.ByteString getOutputGcsUriBytes() {
      java.lang.Object ref = outputGcsUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        outputGcsUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Specifies a Cloud Storage URI for the synthesis results. Must be
     * specified in the format: `gs://bucket_name/object_name`, and the bucket
     * must already exist.
     * </pre>
     *
     * <code>string output_gcs_uri = 4;</code>
     *
     * @param value The outputGcsUri to set.
     * @return This builder for chaining.
     */
    public Builder setOutputGcsUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      outputGcsUri_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a Cloud Storage URI for the synthesis results. Must be
     * specified in the format: `gs://bucket_name/object_name`, and the bucket
     * must already exist.
     * </pre>
     *
     * <code>string output_gcs_uri = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearOutputGcsUri() {

      outputGcsUri_ = getDefaultInstance().getOutputGcsUri();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Specifies a Cloud Storage URI for the synthesis results. Must be
     * specified in the format: `gs://bucket_name/object_name`, and the bucket
     * must already exist.
     * </pre>
     *
     * <code>string output_gcs_uri = 4;</code>
     *
     * @param value The bytes for outputGcsUri to set.
     * @return This builder for chaining.
     */
    public Builder setOutputGcsUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      outputGcsUri_ = value;
      onChanged();
      return this;
    }

    private com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams,
            com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.Builder,
            com.google.cloud.texttospeech.v1beta1.VoiceSelectionParamsOrBuilder>
        voiceBuilder_;
    /**
     *
     *
     * <pre>
     * The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 5;</code>
     *
     * @return Whether the voice field is set.
     */
    public boolean hasVoice() {
      return voiceBuilder_ != null || voice_ != null;
    }
    /**
     *
     *
     * <pre>
     * The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 5;</code>
     *
     * @return The voice.
     */
    public com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams getVoice() {
      if (voiceBuilder_ == null) {
        return voice_ == null
            ? com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.getDefaultInstance()
            : voice_;
      } else {
        return voiceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 5;</code>
     */
    public Builder setVoice(com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams value) {
      if (voiceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        voice_ = value;
        onChanged();
      } else {
        voiceBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 5;</code>
     */
    public Builder setVoice(
        com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.Builder builderForValue) {
      if (voiceBuilder_ == null) {
        voice_ = builderForValue.build();
        onChanged();
      } else {
        voiceBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 5;</code>
     */
    public Builder mergeVoice(com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams value) {
      if (voiceBuilder_ == null) {
        if (voice_ != null) {
          voice_ =
              com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.newBuilder(voice_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          voice_ = value;
        }
        onChanged();
      } else {
        voiceBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 5;</code>
     */
    public Builder clearVoice() {
      if (voiceBuilder_ == null) {
        voice_ = null;
        onChanged();
      } else {
        voice_ = null;
        voiceBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 5;</code>
     */
    public com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.Builder getVoiceBuilder() {

      onChanged();
      return getVoiceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 5;</code>
     */
    public com.google.cloud.texttospeech.v1beta1.VoiceSelectionParamsOrBuilder getVoiceOrBuilder() {
      if (voiceBuilder_ != null) {
        return voiceBuilder_.getMessageOrBuilder();
      } else {
        return voice_ == null
            ? com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.getDefaultInstance()
            : voice_;
      }
    }
    /**
     *
     *
     * <pre>
     * The desired voice of the synthesized audio.
     * </pre>
     *
     * <code>.google.cloud.texttospeech.v1beta1.VoiceSelectionParams voice = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams,
            com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.Builder,
            com.google.cloud.texttospeech.v1beta1.VoiceSelectionParamsOrBuilder>
        getVoiceFieldBuilder() {
      if (voiceBuilder_ == null) {
        voiceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams,
                com.google.cloud.texttospeech.v1beta1.VoiceSelectionParams.Builder,
                com.google.cloud.texttospeech.v1beta1.VoiceSelectionParamsOrBuilder>(
                getVoice(), getParentForChildren(), isClean());
        voice_ = null;
      }
      return voiceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest)
  private static final com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest();
  }

  public static com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<SynthesizeLongAudioRequest> PARSER =
      new com.google.protobuf.AbstractParser<SynthesizeLongAudioRequest>() {
        @java.lang.Override
        public SynthesizeLongAudioRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<SynthesizeLongAudioRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<SynthesizeLongAudioRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.texttospeech.v1beta1.SynthesizeLongAudioRequest
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
