/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tpu.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AcceleratorTypeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_ACCELERATOR_TYPE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/acceleratorTypes/{accelerator_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String acceleratorType;

    @Deprecated
    protected AcceleratorTypeName() {
        this.project = null;
        this.location = null;
        this.acceleratorType = null;
    }

    private AcceleratorTypeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.acceleratorType = (String)Preconditions.checkNotNull((Object)builder.getAcceleratorType());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getAcceleratorType() {
        return this.acceleratorType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AcceleratorTypeName of(String project, String location, String acceleratorType) {
        return AcceleratorTypeName.newBuilder().setProject(project).setLocation(location).setAcceleratorType(acceleratorType).build();
    }

    public static String format(String project, String location, String acceleratorType) {
        return AcceleratorTypeName.newBuilder().setProject(project).setLocation(location).setAcceleratorType(acceleratorType).build().toString();
    }

    public static AcceleratorTypeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_ACCELERATOR_TYPE.validatedMatch(formattedString, "AcceleratorTypeName.parse: formattedString not in valid format");
        return AcceleratorTypeName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("accelerator_type"));
    }

    public static List<AcceleratorTypeName> parseList(List<String> formattedStrings) {
        ArrayList<AcceleratorTypeName> list = new ArrayList<AcceleratorTypeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AcceleratorTypeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AcceleratorTypeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AcceleratorTypeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_ACCELERATOR_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AcceleratorTypeName acceleratorTypeName = this;
            synchronized (acceleratorTypeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.acceleratorType != null) {
                        fieldMapBuilder.put((Object)"accelerator_type", (Object)this.acceleratorType);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_ACCELERATOR_TYPE.instantiate(new String[]{"project", this.project, "location", this.location, "accelerator_type", this.acceleratorType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            AcceleratorTypeName that = (AcceleratorTypeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.acceleratorType, that.acceleratorType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.acceleratorType);
    }

    public static class Builder {
        private String project;
        private String location;
        private String acceleratorType;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getAcceleratorType() {
            return this.acceleratorType;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAcceleratorType(String acceleratorType) {
            this.acceleratorType = acceleratorType;
            return this;
        }

        private Builder(AcceleratorTypeName acceleratorTypeName) {
            this.project = acceleratorTypeName.project;
            this.location = acceleratorTypeName.location;
            this.acceleratorType = acceleratorTypeName.acceleratorType;
        }

        public AcceleratorTypeName build() {
            return new AcceleratorTypeName(this);
        }
    }
}

