/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tpu.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TensorFlowVersionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_TENSOR_FLOW_VERSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/tensorFlowVersions/{tensor_flow_version}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String tensorFlowVersion;

    @Deprecated
    protected TensorFlowVersionName() {
        this.project = null;
        this.location = null;
        this.tensorFlowVersion = null;
    }

    private TensorFlowVersionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.tensorFlowVersion = (String)Preconditions.checkNotNull((Object)builder.getTensorFlowVersion());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTensorFlowVersion() {
        return this.tensorFlowVersion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TensorFlowVersionName of(String project, String location, String tensorFlowVersion) {
        return TensorFlowVersionName.newBuilder().setProject(project).setLocation(location).setTensorFlowVersion(tensorFlowVersion).build();
    }

    public static String format(String project, String location, String tensorFlowVersion) {
        return TensorFlowVersionName.newBuilder().setProject(project).setLocation(location).setTensorFlowVersion(tensorFlowVersion).build().toString();
    }

    public static TensorFlowVersionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_TENSOR_FLOW_VERSION.validatedMatch(formattedString, "TensorFlowVersionName.parse: formattedString not in valid format");
        return TensorFlowVersionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("tensor_flow_version"));
    }

    public static List<TensorFlowVersionName> parseList(List<String> formattedStrings) {
        ArrayList<TensorFlowVersionName> list = new ArrayList<TensorFlowVersionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TensorFlowVersionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TensorFlowVersionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TensorFlowVersionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_TENSOR_FLOW_VERSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TensorFlowVersionName tensorFlowVersionName = this;
            synchronized (tensorFlowVersionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.tensorFlowVersion != null) {
                        fieldMapBuilder.put((Object)"tensor_flow_version", (Object)this.tensorFlowVersion);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_TENSOR_FLOW_VERSION.instantiate(new String[]{"project", this.project, "location", this.location, "tensor_flow_version", this.tensorFlowVersion});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            TensorFlowVersionName that = (TensorFlowVersionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.tensorFlowVersion, that.tensorFlowVersion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.tensorFlowVersion);
    }

    public static class Builder {
        private String project;
        private String location;
        private String tensorFlowVersion;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTensorFlowVersion() {
            return this.tensorFlowVersion;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTensorFlowVersion(String tensorFlowVersion) {
            this.tensorFlowVersion = tensorFlowVersion;
            return this;
        }

        private Builder(TensorFlowVersionName tensorFlowVersionName) {
            this.project = tensorFlowVersionName.project;
            this.location = tensorFlowVersionName.location;
            this.tensorFlowVersion = tensorFlowVersionName.tensorFlowVersion;
        }

        public TensorFlowVersionName build() {
            return new TensorFlowVersionName(this);
        }
    }
}

