/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tpu.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NodeName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_NODE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/nodes/{node}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String node;

    @Deprecated
    protected NodeName() {
        this.project = null;
        this.location = null;
        this.node = null;
    }

    private NodeName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.node = (String)Preconditions.checkNotNull((Object)builder.getNode());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNode() {
        return this.node;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NodeName of(String project, String location, String node) {
        return NodeName.newBuilder().setProject(project).setLocation(location).setNode(node).build();
    }

    public static String format(String project, String location, String node) {
        return NodeName.newBuilder().setProject(project).setLocation(location).setNode(node).build().toString();
    }

    public static NodeName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_NODE.validatedMatch(formattedString, "NodeName.parse: formattedString not in valid format");
        return NodeName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("node"));
    }

    public static List<NodeName> parseList(List<String> formattedStrings) {
        ArrayList<NodeName> list = new ArrayList<NodeName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NodeName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NodeName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NodeName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_NODE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NodeName nodeName = this;
            synchronized (nodeName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.node != null) {
                        fieldMapBuilder.put((Object)"node", (Object)this.node);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_NODE.instantiate(new String[]{"project", this.project, "location", this.location, "node", this.node});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            NodeName that = (NodeName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.node, that.node);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.node);
    }

    public static class Builder {
        private String project;
        private String location;
        private String node;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getNode() {
            return this.node;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setNode(String node) {
            this.node = node;
            return this;
        }

        private Builder(NodeName nodeName) {
            this.project = nodeName.project;
            this.location = nodeName.location;
            this.node = nodeName.node;
        }

        public NodeName build() {
            return new NodeName(this);
        }
    }
}

