/*
 * Copyright 2019 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/translate/v3/translation_service.proto

package com.google.cloud.translate.v3;

/** Protobuf type {@code google.cloud.translation.v3.TranslateTextResponse} */
public final class TranslateTextResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.translation.v3.TranslateTextResponse)
    TranslateTextResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use TranslateTextResponse.newBuilder() to construct.
  private TranslateTextResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TranslateTextResponse() {
    translations_ = java.util.Collections.emptyList();
    glossaryTranslations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TranslateTextResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private TranslateTextResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                translations_ =
                    new java.util.ArrayList<com.google.cloud.translate.v3.Translation>();
                mutable_bitField0_ |= 0x00000001;
              }
              translations_.add(
                  input.readMessage(
                      com.google.cloud.translate.v3.Translation.parser(), extensionRegistry));
              break;
            }
          case 26:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                glossaryTranslations_ =
                    new java.util.ArrayList<com.google.cloud.translate.v3.Translation>();
                mutable_bitField0_ |= 0x00000002;
              }
              glossaryTranslations_.add(
                  input.readMessage(
                      com.google.cloud.translate.v3.Translation.parser(), extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        translations_ = java.util.Collections.unmodifiableList(translations_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        glossaryTranslations_ = java.util.Collections.unmodifiableList(glossaryTranslations_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.translate.v3.TranslationServiceProto
        .internal_static_google_cloud_translation_v3_TranslateTextResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.translate.v3.TranslationServiceProto
        .internal_static_google_cloud_translation_v3_TranslateTextResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.translate.v3.TranslateTextResponse.class,
            com.google.cloud.translate.v3.TranslateTextResponse.Builder.class);
  }

  public static final int TRANSLATIONS_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.translate.v3.Translation> translations_;
  /**
   *
   *
   * <pre>
   * Text translation responses with no glossary applied.
   * This field has the same length as
   * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
   * </pre>
   *
   * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
   */
  public java.util.List<com.google.cloud.translate.v3.Translation> getTranslationsList() {
    return translations_;
  }
  /**
   *
   *
   * <pre>
   * Text translation responses with no glossary applied.
   * This field has the same length as
   * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
   * </pre>
   *
   * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
   */
  public java.util.List<? extends com.google.cloud.translate.v3.TranslationOrBuilder>
      getTranslationsOrBuilderList() {
    return translations_;
  }
  /**
   *
   *
   * <pre>
   * Text translation responses with no glossary applied.
   * This field has the same length as
   * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
   * </pre>
   *
   * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
   */
  public int getTranslationsCount() {
    return translations_.size();
  }
  /**
   *
   *
   * <pre>
   * Text translation responses with no glossary applied.
   * This field has the same length as
   * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
   * </pre>
   *
   * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
   */
  public com.google.cloud.translate.v3.Translation getTranslations(int index) {
    return translations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Text translation responses with no glossary applied.
   * This field has the same length as
   * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
   * </pre>
   *
   * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
   */
  public com.google.cloud.translate.v3.TranslationOrBuilder getTranslationsOrBuilder(int index) {
    return translations_.get(index);
  }

  public static final int GLOSSARY_TRANSLATIONS_FIELD_NUMBER = 3;
  private java.util.List<com.google.cloud.translate.v3.Translation> glossaryTranslations_;
  /**
   *
   *
   * <pre>
   * Text translation responses if a glossary is provided in the request.
   * This can be the same as
   * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
   * if no terms apply. This field has the same length as
   * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
   * </pre>
   *
   * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
   */
  public java.util.List<com.google.cloud.translate.v3.Translation> getGlossaryTranslationsList() {
    return glossaryTranslations_;
  }
  /**
   *
   *
   * <pre>
   * Text translation responses if a glossary is provided in the request.
   * This can be the same as
   * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
   * if no terms apply. This field has the same length as
   * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
   * </pre>
   *
   * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
   */
  public java.util.List<? extends com.google.cloud.translate.v3.TranslationOrBuilder>
      getGlossaryTranslationsOrBuilderList() {
    return glossaryTranslations_;
  }
  /**
   *
   *
   * <pre>
   * Text translation responses if a glossary is provided in the request.
   * This can be the same as
   * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
   * if no terms apply. This field has the same length as
   * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
   * </pre>
   *
   * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
   */
  public int getGlossaryTranslationsCount() {
    return glossaryTranslations_.size();
  }
  /**
   *
   *
   * <pre>
   * Text translation responses if a glossary is provided in the request.
   * This can be the same as
   * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
   * if no terms apply. This field has the same length as
   * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
   * </pre>
   *
   * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
   */
  public com.google.cloud.translate.v3.Translation getGlossaryTranslations(int index) {
    return glossaryTranslations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Text translation responses if a glossary is provided in the request.
   * This can be the same as
   * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
   * if no terms apply. This field has the same length as
   * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
   * </pre>
   *
   * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
   */
  public com.google.cloud.translate.v3.TranslationOrBuilder getGlossaryTranslationsOrBuilder(
      int index) {
    return glossaryTranslations_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < translations_.size(); i++) {
      output.writeMessage(1, translations_.get(i));
    }
    for (int i = 0; i < glossaryTranslations_.size(); i++) {
      output.writeMessage(3, glossaryTranslations_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < translations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, translations_.get(i));
    }
    for (int i = 0; i < glossaryTranslations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, glossaryTranslations_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.translate.v3.TranslateTextResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.translate.v3.TranslateTextResponse other =
        (com.google.cloud.translate.v3.TranslateTextResponse) obj;

    if (!getTranslationsList().equals(other.getTranslationsList())) return false;
    if (!getGlossaryTranslationsList().equals(other.getGlossaryTranslationsList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getTranslationsCount() > 0) {
      hash = (37 * hash) + TRANSLATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getTranslationsList().hashCode();
    }
    if (getGlossaryTranslationsCount() > 0) {
      hash = (37 * hash) + GLOSSARY_TRANSLATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getGlossaryTranslationsList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.translate.v3.TranslateTextResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.TranslateTextResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.TranslateTextResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.TranslateTextResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.TranslateTextResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.TranslateTextResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.TranslateTextResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.TranslateTextResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.TranslateTextResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.TranslateTextResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.TranslateTextResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.TranslateTextResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.translate.v3.TranslateTextResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /** Protobuf type {@code google.cloud.translation.v3.TranslateTextResponse} */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.translation.v3.TranslateTextResponse)
      com.google.cloud.translate.v3.TranslateTextResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.translate.v3.TranslationServiceProto
          .internal_static_google_cloud_translation_v3_TranslateTextResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.translate.v3.TranslationServiceProto
          .internal_static_google_cloud_translation_v3_TranslateTextResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.translate.v3.TranslateTextResponse.class,
              com.google.cloud.translate.v3.TranslateTextResponse.Builder.class);
    }

    // Construct using com.google.cloud.translate.v3.TranslateTextResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTranslationsFieldBuilder();
        getGlossaryTranslationsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (translationsBuilder_ == null) {
        translations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        translationsBuilder_.clear();
      }
      if (glossaryTranslationsBuilder_ == null) {
        glossaryTranslations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        glossaryTranslationsBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.translate.v3.TranslationServiceProto
          .internal_static_google_cloud_translation_v3_TranslateTextResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.TranslateTextResponse getDefaultInstanceForType() {
      return com.google.cloud.translate.v3.TranslateTextResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.TranslateTextResponse build() {
      com.google.cloud.translate.v3.TranslateTextResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.TranslateTextResponse buildPartial() {
      com.google.cloud.translate.v3.TranslateTextResponse result =
          new com.google.cloud.translate.v3.TranslateTextResponse(this);
      int from_bitField0_ = bitField0_;
      if (translationsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          translations_ = java.util.Collections.unmodifiableList(translations_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.translations_ = translations_;
      } else {
        result.translations_ = translationsBuilder_.build();
      }
      if (glossaryTranslationsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          glossaryTranslations_ = java.util.Collections.unmodifiableList(glossaryTranslations_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.glossaryTranslations_ = glossaryTranslations_;
      } else {
        result.glossaryTranslations_ = glossaryTranslationsBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.translate.v3.TranslateTextResponse) {
        return mergeFrom((com.google.cloud.translate.v3.TranslateTextResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.translate.v3.TranslateTextResponse other) {
      if (other == com.google.cloud.translate.v3.TranslateTextResponse.getDefaultInstance())
        return this;
      if (translationsBuilder_ == null) {
        if (!other.translations_.isEmpty()) {
          if (translations_.isEmpty()) {
            translations_ = other.translations_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureTranslationsIsMutable();
            translations_.addAll(other.translations_);
          }
          onChanged();
        }
      } else {
        if (!other.translations_.isEmpty()) {
          if (translationsBuilder_.isEmpty()) {
            translationsBuilder_.dispose();
            translationsBuilder_ = null;
            translations_ = other.translations_;
            bitField0_ = (bitField0_ & ~0x00000001);
            translationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTranslationsFieldBuilder()
                    : null;
          } else {
            translationsBuilder_.addAllMessages(other.translations_);
          }
        }
      }
      if (glossaryTranslationsBuilder_ == null) {
        if (!other.glossaryTranslations_.isEmpty()) {
          if (glossaryTranslations_.isEmpty()) {
            glossaryTranslations_ = other.glossaryTranslations_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureGlossaryTranslationsIsMutable();
            glossaryTranslations_.addAll(other.glossaryTranslations_);
          }
          onChanged();
        }
      } else {
        if (!other.glossaryTranslations_.isEmpty()) {
          if (glossaryTranslationsBuilder_.isEmpty()) {
            glossaryTranslationsBuilder_.dispose();
            glossaryTranslationsBuilder_ = null;
            glossaryTranslations_ = other.glossaryTranslations_;
            bitField0_ = (bitField0_ & ~0x00000002);
            glossaryTranslationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGlossaryTranslationsFieldBuilder()
                    : null;
          } else {
            glossaryTranslationsBuilder_.addAllMessages(other.glossaryTranslations_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.translate.v3.TranslateTextResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.translate.v3.TranslateTextResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.translate.v3.Translation> translations_ =
        java.util.Collections.emptyList();

    private void ensureTranslationsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        translations_ =
            new java.util.ArrayList<com.google.cloud.translate.v3.Translation>(translations_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.translate.v3.Translation,
            com.google.cloud.translate.v3.Translation.Builder,
            com.google.cloud.translate.v3.TranslationOrBuilder>
        translationsBuilder_;

    /**
     *
     *
     * <pre>
     * Text translation responses with no glossary applied.
     * This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
     */
    public java.util.List<com.google.cloud.translate.v3.Translation> getTranslationsList() {
      if (translationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(translations_);
      } else {
        return translationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Text translation responses with no glossary applied.
     * This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
     */
    public int getTranslationsCount() {
      if (translationsBuilder_ == null) {
        return translations_.size();
      } else {
        return translationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Text translation responses with no glossary applied.
     * This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
     */
    public com.google.cloud.translate.v3.Translation getTranslations(int index) {
      if (translationsBuilder_ == null) {
        return translations_.get(index);
      } else {
        return translationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Text translation responses with no glossary applied.
     * This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
     */
    public Builder setTranslations(int index, com.google.cloud.translate.v3.Translation value) {
      if (translationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTranslationsIsMutable();
        translations_.set(index, value);
        onChanged();
      } else {
        translationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text translation responses with no glossary applied.
     * This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
     */
    public Builder setTranslations(
        int index, com.google.cloud.translate.v3.Translation.Builder builderForValue) {
      if (translationsBuilder_ == null) {
        ensureTranslationsIsMutable();
        translations_.set(index, builderForValue.build());
        onChanged();
      } else {
        translationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text translation responses with no glossary applied.
     * This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
     */
    public Builder addTranslations(com.google.cloud.translate.v3.Translation value) {
      if (translationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTranslationsIsMutable();
        translations_.add(value);
        onChanged();
      } else {
        translationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text translation responses with no glossary applied.
     * This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
     */
    public Builder addTranslations(int index, com.google.cloud.translate.v3.Translation value) {
      if (translationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTranslationsIsMutable();
        translations_.add(index, value);
        onChanged();
      } else {
        translationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text translation responses with no glossary applied.
     * This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
     */
    public Builder addTranslations(
        com.google.cloud.translate.v3.Translation.Builder builderForValue) {
      if (translationsBuilder_ == null) {
        ensureTranslationsIsMutable();
        translations_.add(builderForValue.build());
        onChanged();
      } else {
        translationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text translation responses with no glossary applied.
     * This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
     */
    public Builder addTranslations(
        int index, com.google.cloud.translate.v3.Translation.Builder builderForValue) {
      if (translationsBuilder_ == null) {
        ensureTranslationsIsMutable();
        translations_.add(index, builderForValue.build());
        onChanged();
      } else {
        translationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text translation responses with no glossary applied.
     * This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
     */
    public Builder addAllTranslations(
        java.lang.Iterable<? extends com.google.cloud.translate.v3.Translation> values) {
      if (translationsBuilder_ == null) {
        ensureTranslationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, translations_);
        onChanged();
      } else {
        translationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text translation responses with no glossary applied.
     * This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
     */
    public Builder clearTranslations() {
      if (translationsBuilder_ == null) {
        translations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        translationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text translation responses with no glossary applied.
     * This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
     */
    public Builder removeTranslations(int index) {
      if (translationsBuilder_ == null) {
        ensureTranslationsIsMutable();
        translations_.remove(index);
        onChanged();
      } else {
        translationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text translation responses with no glossary applied.
     * This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
     */
    public com.google.cloud.translate.v3.Translation.Builder getTranslationsBuilder(int index) {
      return getTranslationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Text translation responses with no glossary applied.
     * This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
     */
    public com.google.cloud.translate.v3.TranslationOrBuilder getTranslationsOrBuilder(int index) {
      if (translationsBuilder_ == null) {
        return translations_.get(index);
      } else {
        return translationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Text translation responses with no glossary applied.
     * This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.translate.v3.TranslationOrBuilder>
        getTranslationsOrBuilderList() {
      if (translationsBuilder_ != null) {
        return translationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(translations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Text translation responses with no glossary applied.
     * This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
     */
    public com.google.cloud.translate.v3.Translation.Builder addTranslationsBuilder() {
      return getTranslationsFieldBuilder()
          .addBuilder(com.google.cloud.translate.v3.Translation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Text translation responses with no glossary applied.
     * This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
     */
    public com.google.cloud.translate.v3.Translation.Builder addTranslationsBuilder(int index) {
      return getTranslationsFieldBuilder()
          .addBuilder(index, com.google.cloud.translate.v3.Translation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Text translation responses with no glossary applied.
     * This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation translations = 1;</code>
     */
    public java.util.List<com.google.cloud.translate.v3.Translation.Builder>
        getTranslationsBuilderList() {
      return getTranslationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.translate.v3.Translation,
            com.google.cloud.translate.v3.Translation.Builder,
            com.google.cloud.translate.v3.TranslationOrBuilder>
        getTranslationsFieldBuilder() {
      if (translationsBuilder_ == null) {
        translationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.translate.v3.Translation,
                com.google.cloud.translate.v3.Translation.Builder,
                com.google.cloud.translate.v3.TranslationOrBuilder>(
                translations_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        translations_ = null;
      }
      return translationsBuilder_;
    }

    private java.util.List<com.google.cloud.translate.v3.Translation> glossaryTranslations_ =
        java.util.Collections.emptyList();

    private void ensureGlossaryTranslationsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        glossaryTranslations_ =
            new java.util.ArrayList<com.google.cloud.translate.v3.Translation>(
                glossaryTranslations_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.translate.v3.Translation,
            com.google.cloud.translate.v3.Translation.Builder,
            com.google.cloud.translate.v3.TranslationOrBuilder>
        glossaryTranslationsBuilder_;

    /**
     *
     *
     * <pre>
     * Text translation responses if a glossary is provided in the request.
     * This can be the same as
     * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
     * if no terms apply. This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
     */
    public java.util.List<com.google.cloud.translate.v3.Translation> getGlossaryTranslationsList() {
      if (glossaryTranslationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(glossaryTranslations_);
      } else {
        return glossaryTranslationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Text translation responses if a glossary is provided in the request.
     * This can be the same as
     * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
     * if no terms apply. This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
     */
    public int getGlossaryTranslationsCount() {
      if (glossaryTranslationsBuilder_ == null) {
        return glossaryTranslations_.size();
      } else {
        return glossaryTranslationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Text translation responses if a glossary is provided in the request.
     * This can be the same as
     * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
     * if no terms apply. This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
     */
    public com.google.cloud.translate.v3.Translation getGlossaryTranslations(int index) {
      if (glossaryTranslationsBuilder_ == null) {
        return glossaryTranslations_.get(index);
      } else {
        return glossaryTranslationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Text translation responses if a glossary is provided in the request.
     * This can be the same as
     * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
     * if no terms apply. This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
     */
    public Builder setGlossaryTranslations(
        int index, com.google.cloud.translate.v3.Translation value) {
      if (glossaryTranslationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGlossaryTranslationsIsMutable();
        glossaryTranslations_.set(index, value);
        onChanged();
      } else {
        glossaryTranslationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text translation responses if a glossary is provided in the request.
     * This can be the same as
     * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
     * if no terms apply. This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
     */
    public Builder setGlossaryTranslations(
        int index, com.google.cloud.translate.v3.Translation.Builder builderForValue) {
      if (glossaryTranslationsBuilder_ == null) {
        ensureGlossaryTranslationsIsMutable();
        glossaryTranslations_.set(index, builderForValue.build());
        onChanged();
      } else {
        glossaryTranslationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text translation responses if a glossary is provided in the request.
     * This can be the same as
     * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
     * if no terms apply. This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
     */
    public Builder addGlossaryTranslations(com.google.cloud.translate.v3.Translation value) {
      if (glossaryTranslationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGlossaryTranslationsIsMutable();
        glossaryTranslations_.add(value);
        onChanged();
      } else {
        glossaryTranslationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text translation responses if a glossary is provided in the request.
     * This can be the same as
     * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
     * if no terms apply. This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
     */
    public Builder addGlossaryTranslations(
        int index, com.google.cloud.translate.v3.Translation value) {
      if (glossaryTranslationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGlossaryTranslationsIsMutable();
        glossaryTranslations_.add(index, value);
        onChanged();
      } else {
        glossaryTranslationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text translation responses if a glossary is provided in the request.
     * This can be the same as
     * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
     * if no terms apply. This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
     */
    public Builder addGlossaryTranslations(
        com.google.cloud.translate.v3.Translation.Builder builderForValue) {
      if (glossaryTranslationsBuilder_ == null) {
        ensureGlossaryTranslationsIsMutable();
        glossaryTranslations_.add(builderForValue.build());
        onChanged();
      } else {
        glossaryTranslationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text translation responses if a glossary is provided in the request.
     * This can be the same as
     * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
     * if no terms apply. This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
     */
    public Builder addGlossaryTranslations(
        int index, com.google.cloud.translate.v3.Translation.Builder builderForValue) {
      if (glossaryTranslationsBuilder_ == null) {
        ensureGlossaryTranslationsIsMutable();
        glossaryTranslations_.add(index, builderForValue.build());
        onChanged();
      } else {
        glossaryTranslationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text translation responses if a glossary is provided in the request.
     * This can be the same as
     * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
     * if no terms apply. This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
     */
    public Builder addAllGlossaryTranslations(
        java.lang.Iterable<? extends com.google.cloud.translate.v3.Translation> values) {
      if (glossaryTranslationsBuilder_ == null) {
        ensureGlossaryTranslationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, glossaryTranslations_);
        onChanged();
      } else {
        glossaryTranslationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text translation responses if a glossary is provided in the request.
     * This can be the same as
     * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
     * if no terms apply. This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
     */
    public Builder clearGlossaryTranslations() {
      if (glossaryTranslationsBuilder_ == null) {
        glossaryTranslations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        glossaryTranslationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text translation responses if a glossary is provided in the request.
     * This can be the same as
     * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
     * if no terms apply. This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
     */
    public Builder removeGlossaryTranslations(int index) {
      if (glossaryTranslationsBuilder_ == null) {
        ensureGlossaryTranslationsIsMutable();
        glossaryTranslations_.remove(index);
        onChanged();
      } else {
        glossaryTranslationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Text translation responses if a glossary is provided in the request.
     * This can be the same as
     * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
     * if no terms apply. This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
     */
    public com.google.cloud.translate.v3.Translation.Builder getGlossaryTranslationsBuilder(
        int index) {
      return getGlossaryTranslationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Text translation responses if a glossary is provided in the request.
     * This can be the same as
     * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
     * if no terms apply. This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
     */
    public com.google.cloud.translate.v3.TranslationOrBuilder getGlossaryTranslationsOrBuilder(
        int index) {
      if (glossaryTranslationsBuilder_ == null) {
        return glossaryTranslations_.get(index);
      } else {
        return glossaryTranslationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Text translation responses if a glossary is provided in the request.
     * This can be the same as
     * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
     * if no terms apply. This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
     */
    public java.util.List<? extends com.google.cloud.translate.v3.TranslationOrBuilder>
        getGlossaryTranslationsOrBuilderList() {
      if (glossaryTranslationsBuilder_ != null) {
        return glossaryTranslationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(glossaryTranslations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Text translation responses if a glossary is provided in the request.
     * This can be the same as
     * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
     * if no terms apply. This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
     */
    public com.google.cloud.translate.v3.Translation.Builder addGlossaryTranslationsBuilder() {
      return getGlossaryTranslationsFieldBuilder()
          .addBuilder(com.google.cloud.translate.v3.Translation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Text translation responses if a glossary is provided in the request.
     * This can be the same as
     * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
     * if no terms apply. This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
     */
    public com.google.cloud.translate.v3.Translation.Builder addGlossaryTranslationsBuilder(
        int index) {
      return getGlossaryTranslationsFieldBuilder()
          .addBuilder(index, com.google.cloud.translate.v3.Translation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Text translation responses if a glossary is provided in the request.
     * This can be the same as
     * [`translations`][google.cloud.translation.v3.TranslateTextResponse.translations]
     * if no terms apply. This field has the same length as
     * [`contents`][google.cloud.translation.v3.TranslateTextRequest.contents].
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.Translation glossary_translations = 3;</code>
     */
    public java.util.List<com.google.cloud.translate.v3.Translation.Builder>
        getGlossaryTranslationsBuilderList() {
      return getGlossaryTranslationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.translate.v3.Translation,
            com.google.cloud.translate.v3.Translation.Builder,
            com.google.cloud.translate.v3.TranslationOrBuilder>
        getGlossaryTranslationsFieldBuilder() {
      if (glossaryTranslationsBuilder_ == null) {
        glossaryTranslationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.translate.v3.Translation,
                com.google.cloud.translate.v3.Translation.Builder,
                com.google.cloud.translate.v3.TranslationOrBuilder>(
                glossaryTranslations_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        glossaryTranslations_ = null;
      }
      return glossaryTranslationsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.translation.v3.TranslateTextResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.translation.v3.TranslateTextResponse)
  private static final com.google.cloud.translate.v3.TranslateTextResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.translate.v3.TranslateTextResponse();
  }

  public static com.google.cloud.translate.v3.TranslateTextResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TranslateTextResponse> PARSER =
      new com.google.protobuf.AbstractParser<TranslateTextResponse>() {
        @java.lang.Override
        public TranslateTextResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new TranslateTextResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<TranslateTextResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TranslateTextResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.translate.v3.TranslateTextResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
