/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/translate/v3/translation_service.proto

package com.google.cloud.translate.v3;

/**
 *
 *
 * <pre>
 * The BatchTranslateDocument request.
 * </pre>
 *
 * Protobuf type {@code google.cloud.translation.v3.BatchTranslateDocumentRequest}
 */
public final class BatchTranslateDocumentRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.translation.v3.BatchTranslateDocumentRequest)
    BatchTranslateDocumentRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchTranslateDocumentRequest.newBuilder() to construct.
  private BatchTranslateDocumentRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchTranslateDocumentRequest() {
    parent_ = "";
    sourceLanguageCode_ = "";
    targetLanguageCodes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    inputConfigs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchTranslateDocumentRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private BatchTranslateDocumentRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              java.lang.String s = input.readStringRequireUtf8();

              parent_ = s;
              break;
            }
          case 18:
            {
              java.lang.String s = input.readStringRequireUtf8();

              sourceLanguageCode_ = s;
              break;
            }
          case 26:
            {
              java.lang.String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                targetLanguageCodes_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              targetLanguageCodes_.add(s);
              break;
            }
          case 34:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                inputConfigs_ =
                    new java.util.ArrayList<
                        com.google.cloud.translate.v3.BatchDocumentInputConfig>();
                mutable_bitField0_ |= 0x00000002;
              }
              inputConfigs_.add(
                  input.readMessage(
                      com.google.cloud.translate.v3.BatchDocumentInputConfig.parser(),
                      extensionRegistry));
              break;
            }
          case 42:
            {
              com.google.cloud.translate.v3.BatchDocumentOutputConfig.Builder subBuilder = null;
              if (outputConfig_ != null) {
                subBuilder = outputConfig_.toBuilder();
              }
              outputConfig_ =
                  input.readMessage(
                      com.google.cloud.translate.v3.BatchDocumentOutputConfig.parser(),
                      extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(outputConfig_);
                outputConfig_ = subBuilder.buildPartial();
              }

              break;
            }
          case 50:
            {
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                models_ =
                    com.google.protobuf.MapField.newMapField(ModelsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000004;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> models__ =
                  input.readMessage(
                      ModelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
              models_.getMutableMap().put(models__.getKey(), models__.getValue());
              break;
            }
          case 58:
            {
              if (!((mutable_bitField0_ & 0x00000008) != 0)) {
                glossaries_ =
                    com.google.protobuf.MapField.newMapField(
                        GlossariesDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000008;
              }
              com.google.protobuf.MapEntry<
                      java.lang.String, com.google.cloud.translate.v3.TranslateTextGlossaryConfig>
                  glossaries__ =
                      input.readMessage(
                          GlossariesDefaultEntryHolder.defaultEntry.getParserForType(),
                          extensionRegistry);
              glossaries_.getMutableMap().put(glossaries__.getKey(), glossaries__.getValue());
              break;
            }
          case 66:
            {
              if (!((mutable_bitField0_ & 0x00000010) != 0)) {
                formatConversions_ =
                    com.google.protobuf.MapField.newMapField(
                        FormatConversionsDefaultEntryHolder.defaultEntry);
                mutable_bitField0_ |= 0x00000010;
              }
              com.google.protobuf.MapEntry<java.lang.String, java.lang.String> formatConversions__ =
                  input.readMessage(
                      FormatConversionsDefaultEntryHolder.defaultEntry.getParserForType(),
                      extensionRegistry);
              formatConversions_
                  .getMutableMap()
                  .put(formatConversions__.getKey(), formatConversions__.getValue());
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        targetLanguageCodes_ = targetLanguageCodes_.getUnmodifiableView();
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        inputConfigs_ = java.util.Collections.unmodifiableList(inputConfigs_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.translate.v3.TranslationServiceProto
        .internal_static_google_cloud_translation_v3_BatchTranslateDocumentRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 6:
        return internalGetModels();
      case 7:
        return internalGetGlossaries();
      case 8:
        return internalGetFormatConversions();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.translate.v3.TranslationServiceProto
        .internal_static_google_cloud_translation_v3_BatchTranslateDocumentRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.translate.v3.BatchTranslateDocumentRequest.class,
            com.google.cloud.translate.v3.BatchTranslateDocumentRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;
  private volatile java.lang.Object parent_;
  /**
   *
   *
   * <pre>
   * Required. Location to make a regional call.
   * Format: `projects/{project-number-or-id}/locations/{location-id}`.
   * The `global` location is not supported for batch translation.
   * Only AutoML Translation models or glossaries within the same region (have
   * the same location-id) can be used, otherwise an INVALID_ARGUMENT (400)
   * error is returned.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Location to make a regional call.
   * Format: `projects/{project-number-or-id}/locations/{location-id}`.
   * The `global` location is not supported for batch translation.
   * Only AutoML Translation models or glossaries within the same region (have
   * the same location-id) can be used, otherwise an INVALID_ARGUMENT (400)
   * error is returned.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_LANGUAGE_CODE_FIELD_NUMBER = 2;
  private volatile java.lang.Object sourceLanguageCode_;
  /**
   *
   *
   * <pre>
   * Required. The BCP-47 language code of the input document if known, for
   * example, "en-US" or "sr-Latn". Supported language codes are listed in
   * Language Support (https://cloud.google.com/translate/docs/languages).
   * </pre>
   *
   * <code>string source_language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The sourceLanguageCode.
   */
  @java.lang.Override
  public java.lang.String getSourceLanguageCode() {
    java.lang.Object ref = sourceLanguageCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceLanguageCode_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The BCP-47 language code of the input document if known, for
   * example, "en-US" or "sr-Latn". Supported language codes are listed in
   * Language Support (https://cloud.google.com/translate/docs/languages).
   * </pre>
   *
   * <code>string source_language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for sourceLanguageCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceLanguageCodeBytes() {
    java.lang.Object ref = sourceLanguageCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceLanguageCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_LANGUAGE_CODES_FIELD_NUMBER = 3;
  private com.google.protobuf.LazyStringList targetLanguageCodes_;
  /**
   *
   *
   * <pre>
   * Required. The BCP-47 language code to use for translation of the input
   * document. Specify up to 10 language codes here.
   * </pre>
   *
   * <code>repeated string target_language_codes = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return A list containing the targetLanguageCodes.
   */
  public com.google.protobuf.ProtocolStringList getTargetLanguageCodesList() {
    return targetLanguageCodes_;
  }
  /**
   *
   *
   * <pre>
   * Required. The BCP-47 language code to use for translation of the input
   * document. Specify up to 10 language codes here.
   * </pre>
   *
   * <code>repeated string target_language_codes = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The count of targetLanguageCodes.
   */
  public int getTargetLanguageCodesCount() {
    return targetLanguageCodes_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The BCP-47 language code to use for translation of the input
   * document. Specify up to 10 language codes here.
   * </pre>
   *
   * <code>repeated string target_language_codes = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The targetLanguageCodes at the given index.
   */
  public java.lang.String getTargetLanguageCodes(int index) {
    return targetLanguageCodes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The BCP-47 language code to use for translation of the input
   * document. Specify up to 10 language codes here.
   * </pre>
   *
   * <code>repeated string target_language_codes = 3 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the targetLanguageCodes at the given index.
   */
  public com.google.protobuf.ByteString getTargetLanguageCodesBytes(int index) {
    return targetLanguageCodes_.getByteString(index);
  }

  public static final int INPUT_CONFIGS_FIELD_NUMBER = 4;
  private java.util.List<com.google.cloud.translate.v3.BatchDocumentInputConfig> inputConfigs_;
  /**
   *
   *
   * <pre>
   * Required. Input configurations.
   * The total number of files matched should be &lt;= 100.
   * The total content size to translate should be &lt;= 100M Unicode codepoints.
   * The files must use UTF-8 encoding.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.translate.v3.BatchDocumentInputConfig>
      getInputConfigsList() {
    return inputConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Required. Input configurations.
   * The total number of files matched should be &lt;= 100.
   * The total content size to translate should be &lt;= 100M Unicode codepoints.
   * The files must use UTF-8 encoding.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.translate.v3.BatchDocumentInputConfigOrBuilder>
      getInputConfigsOrBuilderList() {
    return inputConfigs_;
  }
  /**
   *
   *
   * <pre>
   * Required. Input configurations.
   * The total number of files matched should be &lt;= 100.
   * The total content size to translate should be &lt;= 100M Unicode codepoints.
   * The files must use UTF-8 encoding.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getInputConfigsCount() {
    return inputConfigs_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Input configurations.
   * The total number of files matched should be &lt;= 100.
   * The total content size to translate should be &lt;= 100M Unicode codepoints.
   * The files must use UTF-8 encoding.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3.BatchDocumentInputConfig getInputConfigs(int index) {
    return inputConfigs_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Input configurations.
   * The total number of files matched should be &lt;= 100.
   * The total content size to translate should be &lt;= 100M Unicode codepoints.
   * The files must use UTF-8 encoding.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3.BatchDocumentInputConfigOrBuilder getInputConfigsOrBuilder(
      int index) {
    return inputConfigs_.get(index);
  }

  public static final int OUTPUT_CONFIG_FIELD_NUMBER = 5;
  private com.google.cloud.translate.v3.BatchDocumentOutputConfig outputConfig_;
  /**
   *
   *
   * <pre>
   * Required. Output configuration.
   * If 2 input configs match to the same file (that is, same input path),
   * we don't generate output for duplicate inputs.
   * </pre>
   *
   * <code>
   * .google.cloud.translation.v3.BatchDocumentOutputConfig output_config = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the outputConfig field is set.
   */
  @java.lang.Override
  public boolean hasOutputConfig() {
    return outputConfig_ != null;
  }
  /**
   *
   *
   * <pre>
   * Required. Output configuration.
   * If 2 input configs match to the same file (that is, same input path),
   * we don't generate output for duplicate inputs.
   * </pre>
   *
   * <code>
   * .google.cloud.translation.v3.BatchDocumentOutputConfig output_config = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The outputConfig.
   */
  @java.lang.Override
  public com.google.cloud.translate.v3.BatchDocumentOutputConfig getOutputConfig() {
    return outputConfig_ == null
        ? com.google.cloud.translate.v3.BatchDocumentOutputConfig.getDefaultInstance()
        : outputConfig_;
  }
  /**
   *
   *
   * <pre>
   * Required. Output configuration.
   * If 2 input configs match to the same file (that is, same input path),
   * we don't generate output for duplicate inputs.
   * </pre>
   *
   * <code>
   * .google.cloud.translation.v3.BatchDocumentOutputConfig output_config = 5 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3.BatchDocumentOutputConfigOrBuilder
      getOutputConfigOrBuilder() {
    return getOutputConfig();
  }

  public static final int MODELS_FIELD_NUMBER = 6;

  private static final class ModelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.translate.v3.TranslationServiceProto
                .internal_static_google_cloud_translation_v3_BatchTranslateDocumentRequest_ModelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> models_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetModels() {
    if (models_ == null) {
      return com.google.protobuf.MapField.emptyMapField(ModelsDefaultEntryHolder.defaultEntry);
    }
    return models_;
  }

  public int getModelsCount() {
    return internalGetModels().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. The models to use for translation. Map's key is target language
   * code. Map's value is the model name. Value can be a built-in general model,
   * or an AutoML Translation model.
   * The value format depends on model type:
   * - AutoML Translation models:
   *   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
   * - General (built-in) models:
   *   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
   * If the map is empty or a specific model is
   * not requested for a language pair, then default google model (nmt) is used.
   * </pre>
   *
   * <code>map&lt;string, string&gt; models = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsModels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetModels().getMap().containsKey(key);
  }
  /** Use {@link #getModelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getModels() {
    return getModelsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The models to use for translation. Map's key is target language
   * code. Map's value is the model name. Value can be a built-in general model,
   * or an AutoML Translation model.
   * The value format depends on model type:
   * - AutoML Translation models:
   *   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
   * - General (built-in) models:
   *   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
   * If the map is empty or a specific model is
   * not requested for a language pair, then default google model (nmt) is used.
   * </pre>
   *
   * <code>map&lt;string, string&gt; models = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getModelsMap() {
    return internalGetModels().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. The models to use for translation. Map's key is target language
   * code. Map's value is the model name. Value can be a built-in general model,
   * or an AutoML Translation model.
   * The value format depends on model type:
   * - AutoML Translation models:
   *   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
   * - General (built-in) models:
   *   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
   * If the map is empty or a specific model is
   * not requested for a language pair, then default google model (nmt) is used.
   * </pre>
   *
   * <code>map&lt;string, string&gt; models = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getModelsOrDefault(java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetModels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. The models to use for translation. Map's key is target language
   * code. Map's value is the model name. Value can be a built-in general model,
   * or an AutoML Translation model.
   * The value format depends on model type:
   * - AutoML Translation models:
   *   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
   * - General (built-in) models:
   *   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
   * If the map is empty or a specific model is
   * not requested for a language pair, then default google model (nmt) is used.
   * </pre>
   *
   * <code>map&lt;string, string&gt; models = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getModelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetModels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int GLOSSARIES_FIELD_NUMBER = 7;

  private static final class GlossariesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.translate.v3.TranslateTextGlossaryConfig>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.translate.v3.TranslateTextGlossaryConfig>
                    newDefaultInstance(
                        com.google.cloud.translate.v3.TranslationServiceProto
                            .internal_static_google_cloud_translation_v3_BatchTranslateDocumentRequest_GlossariesEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.translate.v3.TranslateTextGlossaryConfig
                            .getDefaultInstance());
  }

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.translate.v3.TranslateTextGlossaryConfig>
      glossaries_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.translate.v3.TranslateTextGlossaryConfig>
      internalGetGlossaries() {
    if (glossaries_ == null) {
      return com.google.protobuf.MapField.emptyMapField(GlossariesDefaultEntryHolder.defaultEntry);
    }
    return glossaries_;
  }

  public int getGlossariesCount() {
    return internalGetGlossaries().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. Glossaries to be applied. It's keyed by target language code.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.translation.v3.TranslateTextGlossaryConfig&gt; glossaries = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsGlossaries(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetGlossaries().getMap().containsKey(key);
  }
  /** Use {@link #getGlossariesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.translate.v3.TranslateTextGlossaryConfig>
      getGlossaries() {
    return getGlossariesMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Glossaries to be applied. It's keyed by target language code.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.translation.v3.TranslateTextGlossaryConfig&gt; glossaries = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.translate.v3.TranslateTextGlossaryConfig>
      getGlossariesMap() {
    return internalGetGlossaries().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. Glossaries to be applied. It's keyed by target language code.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.translation.v3.TranslateTextGlossaryConfig&gt; glossaries = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3.TranslateTextGlossaryConfig getGlossariesOrDefault(
      java.lang.String key,
      com.google.cloud.translate.v3.TranslateTextGlossaryConfig defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.translate.v3.TranslateTextGlossaryConfig> map =
        internalGetGlossaries().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. Glossaries to be applied. It's keyed by target language code.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.translation.v3.TranslateTextGlossaryConfig&gt; glossaries = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3.TranslateTextGlossaryConfig getGlossariesOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.translate.v3.TranslateTextGlossaryConfig> map =
        internalGetGlossaries().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int FORMAT_CONVERSIONS_FIELD_NUMBER = 8;

  private static final class FormatConversionsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.translate.v3.TranslationServiceProto
                .internal_static_google_cloud_translation_v3_BatchTranslateDocumentRequest_FormatConversionsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> formatConversions_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetFormatConversions() {
    if (formatConversions_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          FormatConversionsDefaultEntryHolder.defaultEntry);
    }
    return formatConversions_;
  }

  public int getFormatConversionsCount() {
    return internalGetFormatConversions().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * Optional. File format conversion map to be applied to all input files.
   * Map's key is the original mime_type. Map's value is the target mime_type of
   * translated documents.
   * Supported file format conversion includes:
   * - `application/pdf` to
   *   `application/vnd.openxmlformats-officedocument.wordprocessingml.document`
   * If nothing specified, output files will be in the same format as the
   * original file.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; format_conversions = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsFormatConversions(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetFormatConversions().getMap().containsKey(key);
  }
  /** Use {@link #getFormatConversionsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getFormatConversions() {
    return getFormatConversionsMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. File format conversion map to be applied to all input files.
   * Map's key is the original mime_type. Map's value is the target mime_type of
   * translated documents.
   * Supported file format conversion includes:
   * - `application/pdf` to
   *   `application/vnd.openxmlformats-officedocument.wordprocessingml.document`
   * If nothing specified, output files will be in the same format as the
   * original file.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; format_conversions = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getFormatConversionsMap() {
    return internalGetFormatConversions().getMap();
  }
  /**
   *
   *
   * <pre>
   * Optional. File format conversion map to be applied to all input files.
   * Map's key is the original mime_type. Map's value is the target mime_type of
   * translated documents.
   * Supported file format conversion includes:
   * - `application/pdf` to
   *   `application/vnd.openxmlformats-officedocument.wordprocessingml.document`
   * If nothing specified, output files will be in the same format as the
   * original file.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; format_conversions = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getFormatConversionsOrDefault(
      java.lang.String key, java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetFormatConversions().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * Optional. File format conversion map to be applied to all input files.
   * Map's key is the original mime_type. Map's value is the target mime_type of
   * translated documents.
   * Supported file format conversion includes:
   * - `application/pdf` to
   *   `application/vnd.openxmlformats-officedocument.wordprocessingml.document`
   * If nothing specified, output files will be in the same format as the
   * original file.
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; format_conversions = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getFormatConversionsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetFormatConversions().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceLanguageCode_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, sourceLanguageCode_);
    }
    for (int i = 0; i < targetLanguageCodes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, targetLanguageCodes_.getRaw(i));
    }
    for (int i = 0; i < inputConfigs_.size(); i++) {
      output.writeMessage(4, inputConfigs_.get(i));
    }
    if (outputConfig_ != null) {
      output.writeMessage(5, getOutputConfig());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetModels(), ModelsDefaultEntryHolder.defaultEntry, 6);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetGlossaries(), GlossariesDefaultEntryHolder.defaultEntry, 7);
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetFormatConversions(),
        FormatConversionsDefaultEntryHolder.defaultEntry,
        8);
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceLanguageCode_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, sourceLanguageCode_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < targetLanguageCodes_.size(); i++) {
        dataSize += computeStringSizeNoTag(targetLanguageCodes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getTargetLanguageCodesList().size();
    }
    for (int i = 0; i < inputConfigs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, inputConfigs_.get(i));
    }
    if (outputConfig_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getOutputConfig());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetModels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> models__ =
          ModelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, models__);
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.translate.v3.TranslateTextGlossaryConfig>
        entry : internalGetGlossaries().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.translate.v3.TranslateTextGlossaryConfig>
          glossaries__ =
              GlossariesDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, glossaries__);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetFormatConversions().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> formatConversions__ =
          FormatConversionsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, formatConversions__);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.translate.v3.BatchTranslateDocumentRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.translate.v3.BatchTranslateDocumentRequest other =
        (com.google.cloud.translate.v3.BatchTranslateDocumentRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getSourceLanguageCode().equals(other.getSourceLanguageCode())) return false;
    if (!getTargetLanguageCodesList().equals(other.getTargetLanguageCodesList())) return false;
    if (!getInputConfigsList().equals(other.getInputConfigsList())) return false;
    if (hasOutputConfig() != other.hasOutputConfig()) return false;
    if (hasOutputConfig()) {
      if (!getOutputConfig().equals(other.getOutputConfig())) return false;
    }
    if (!internalGetModels().equals(other.internalGetModels())) return false;
    if (!internalGetGlossaries().equals(other.internalGetGlossaries())) return false;
    if (!internalGetFormatConversions().equals(other.internalGetFormatConversions())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + SOURCE_LANGUAGE_CODE_FIELD_NUMBER;
    hash = (53 * hash) + getSourceLanguageCode().hashCode();
    if (getTargetLanguageCodesCount() > 0) {
      hash = (37 * hash) + TARGET_LANGUAGE_CODES_FIELD_NUMBER;
      hash = (53 * hash) + getTargetLanguageCodesList().hashCode();
    }
    if (getInputConfigsCount() > 0) {
      hash = (37 * hash) + INPUT_CONFIGS_FIELD_NUMBER;
      hash = (53 * hash) + getInputConfigsList().hashCode();
    }
    if (hasOutputConfig()) {
      hash = (37 * hash) + OUTPUT_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getOutputConfig().hashCode();
    }
    if (!internalGetModels().getMap().isEmpty()) {
      hash = (37 * hash) + MODELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetModels().hashCode();
    }
    if (!internalGetGlossaries().getMap().isEmpty()) {
      hash = (37 * hash) + GLOSSARIES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetGlossaries().hashCode();
    }
    if (!internalGetFormatConversions().getMap().isEmpty()) {
      hash = (37 * hash) + FORMAT_CONVERSIONS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetFormatConversions().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.translate.v3.BatchTranslateDocumentRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.BatchTranslateDocumentRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.BatchTranslateDocumentRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.BatchTranslateDocumentRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.BatchTranslateDocumentRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.BatchTranslateDocumentRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.BatchTranslateDocumentRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.BatchTranslateDocumentRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.BatchTranslateDocumentRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.BatchTranslateDocumentRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.BatchTranslateDocumentRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.BatchTranslateDocumentRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.translate.v3.BatchTranslateDocumentRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The BatchTranslateDocument request.
   * </pre>
   *
   * Protobuf type {@code google.cloud.translation.v3.BatchTranslateDocumentRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.translation.v3.BatchTranslateDocumentRequest)
      com.google.cloud.translate.v3.BatchTranslateDocumentRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.translate.v3.TranslationServiceProto
          .internal_static_google_cloud_translation_v3_BatchTranslateDocumentRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 6:
          return internalGetModels();
        case 7:
          return internalGetGlossaries();
        case 8:
          return internalGetFormatConversions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 6:
          return internalGetMutableModels();
        case 7:
          return internalGetMutableGlossaries();
        case 8:
          return internalGetMutableFormatConversions();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.translate.v3.TranslationServiceProto
          .internal_static_google_cloud_translation_v3_BatchTranslateDocumentRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.translate.v3.BatchTranslateDocumentRequest.class,
              com.google.cloud.translate.v3.BatchTranslateDocumentRequest.Builder.class);
    }

    // Construct using com.google.cloud.translate.v3.BatchTranslateDocumentRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getInputConfigsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      parent_ = "";

      sourceLanguageCode_ = "";

      targetLanguageCodes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      if (inputConfigsBuilder_ == null) {
        inputConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        inputConfigsBuilder_.clear();
      }
      if (outputConfigBuilder_ == null) {
        outputConfig_ = null;
      } else {
        outputConfig_ = null;
        outputConfigBuilder_ = null;
      }
      internalGetMutableModels().clear();
      internalGetMutableGlossaries().clear();
      internalGetMutableFormatConversions().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.translate.v3.TranslationServiceProto
          .internal_static_google_cloud_translation_v3_BatchTranslateDocumentRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.BatchTranslateDocumentRequest getDefaultInstanceForType() {
      return com.google.cloud.translate.v3.BatchTranslateDocumentRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.BatchTranslateDocumentRequest build() {
      com.google.cloud.translate.v3.BatchTranslateDocumentRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.BatchTranslateDocumentRequest buildPartial() {
      com.google.cloud.translate.v3.BatchTranslateDocumentRequest result =
          new com.google.cloud.translate.v3.BatchTranslateDocumentRequest(this);
      int from_bitField0_ = bitField0_;
      result.parent_ = parent_;
      result.sourceLanguageCode_ = sourceLanguageCode_;
      if (((bitField0_ & 0x00000001) != 0)) {
        targetLanguageCodes_ = targetLanguageCodes_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000001);
      }
      result.targetLanguageCodes_ = targetLanguageCodes_;
      if (inputConfigsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          inputConfigs_ = java.util.Collections.unmodifiableList(inputConfigs_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.inputConfigs_ = inputConfigs_;
      } else {
        result.inputConfigs_ = inputConfigsBuilder_.build();
      }
      if (outputConfigBuilder_ == null) {
        result.outputConfig_ = outputConfig_;
      } else {
        result.outputConfig_ = outputConfigBuilder_.build();
      }
      result.models_ = internalGetModels();
      result.models_.makeImmutable();
      result.glossaries_ = internalGetGlossaries();
      result.glossaries_.makeImmutable();
      result.formatConversions_ = internalGetFormatConversions();
      result.formatConversions_.makeImmutable();
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.translate.v3.BatchTranslateDocumentRequest) {
        return mergeFrom((com.google.cloud.translate.v3.BatchTranslateDocumentRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.translate.v3.BatchTranslateDocumentRequest other) {
      if (other == com.google.cloud.translate.v3.BatchTranslateDocumentRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        onChanged();
      }
      if (!other.getSourceLanguageCode().isEmpty()) {
        sourceLanguageCode_ = other.sourceLanguageCode_;
        onChanged();
      }
      if (!other.targetLanguageCodes_.isEmpty()) {
        if (targetLanguageCodes_.isEmpty()) {
          targetLanguageCodes_ = other.targetLanguageCodes_;
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          ensureTargetLanguageCodesIsMutable();
          targetLanguageCodes_.addAll(other.targetLanguageCodes_);
        }
        onChanged();
      }
      if (inputConfigsBuilder_ == null) {
        if (!other.inputConfigs_.isEmpty()) {
          if (inputConfigs_.isEmpty()) {
            inputConfigs_ = other.inputConfigs_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureInputConfigsIsMutable();
            inputConfigs_.addAll(other.inputConfigs_);
          }
          onChanged();
        }
      } else {
        if (!other.inputConfigs_.isEmpty()) {
          if (inputConfigsBuilder_.isEmpty()) {
            inputConfigsBuilder_.dispose();
            inputConfigsBuilder_ = null;
            inputConfigs_ = other.inputConfigs_;
            bitField0_ = (bitField0_ & ~0x00000002);
            inputConfigsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInputConfigsFieldBuilder()
                    : null;
          } else {
            inputConfigsBuilder_.addAllMessages(other.inputConfigs_);
          }
        }
      }
      if (other.hasOutputConfig()) {
        mergeOutputConfig(other.getOutputConfig());
      }
      internalGetMutableModels().mergeFrom(other.internalGetModels());
      internalGetMutableGlossaries().mergeFrom(other.internalGetGlossaries());
      internalGetMutableFormatConversions().mergeFrom(other.internalGetFormatConversions());
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.translate.v3.BatchTranslateDocumentRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.translate.v3.BatchTranslateDocumentRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. Location to make a regional call.
     * Format: `projects/{project-number-or-id}/locations/{location-id}`.
     * The `global` location is not supported for batch translation.
     * Only AutoML Translation models or glossaries within the same region (have
     * the same location-id) can be used, otherwise an INVALID_ARGUMENT (400)
     * error is returned.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Location to make a regional call.
     * Format: `projects/{project-number-or-id}/locations/{location-id}`.
     * The `global` location is not supported for batch translation.
     * Only AutoML Translation models or glossaries within the same region (have
     * the same location-id) can be used, otherwise an INVALID_ARGUMENT (400)
     * error is returned.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Location to make a regional call.
     * Format: `projects/{project-number-or-id}/locations/{location-id}`.
     * The `global` location is not supported for batch translation.
     * Only AutoML Translation models or glossaries within the same region (have
     * the same location-id) can be used, otherwise an INVALID_ARGUMENT (400)
     * error is returned.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      parent_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Location to make a regional call.
     * Format: `projects/{project-number-or-id}/locations/{location-id}`.
     * The `global` location is not supported for batch translation.
     * Only AutoML Translation models or glossaries within the same region (have
     * the same location-id) can be used, otherwise an INVALID_ARGUMENT (400)
     * error is returned.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {

      parent_ = getDefaultInstance().getParent();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Location to make a regional call.
     * Format: `projects/{project-number-or-id}/locations/{location-id}`.
     * The `global` location is not supported for batch translation.
     * Only AutoML Translation models or glossaries within the same region (have
     * the same location-id) can be used, otherwise an INVALID_ARGUMENT (400)
     * error is returned.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      parent_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object sourceLanguageCode_ = "";
    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code of the input document if known, for
     * example, "en-US" or "sr-Latn". Supported language codes are listed in
     * Language Support (https://cloud.google.com/translate/docs/languages).
     * </pre>
     *
     * <code>string source_language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The sourceLanguageCode.
     */
    public java.lang.String getSourceLanguageCode() {
      java.lang.Object ref = sourceLanguageCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceLanguageCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code of the input document if known, for
     * example, "en-US" or "sr-Latn". Supported language codes are listed in
     * Language Support (https://cloud.google.com/translate/docs/languages).
     * </pre>
     *
     * <code>string source_language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for sourceLanguageCode.
     */
    public com.google.protobuf.ByteString getSourceLanguageCodeBytes() {
      java.lang.Object ref = sourceLanguageCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceLanguageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code of the input document if known, for
     * example, "en-US" or "sr-Latn". Supported language codes are listed in
     * Language Support (https://cloud.google.com/translate/docs/languages).
     * </pre>
     *
     * <code>string source_language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The sourceLanguageCode to set.
     * @return This builder for chaining.
     */
    public Builder setSourceLanguageCode(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      sourceLanguageCode_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code of the input document if known, for
     * example, "en-US" or "sr-Latn". Supported language codes are listed in
     * Language Support (https://cloud.google.com/translate/docs/languages).
     * </pre>
     *
     * <code>string source_language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceLanguageCode() {

      sourceLanguageCode_ = getDefaultInstance().getSourceLanguageCode();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code of the input document if known, for
     * example, "en-US" or "sr-Latn". Supported language codes are listed in
     * Language Support (https://cloud.google.com/translate/docs/languages).
     * </pre>
     *
     * <code>string source_language_code = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for sourceLanguageCode to set.
     * @return This builder for chaining.
     */
    public Builder setSourceLanguageCodeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      sourceLanguageCode_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList targetLanguageCodes_ =
        com.google.protobuf.LazyStringArrayList.EMPTY;

    private void ensureTargetLanguageCodesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        targetLanguageCodes_ = new com.google.protobuf.LazyStringArrayList(targetLanguageCodes_);
        bitField0_ |= 0x00000001;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code to use for translation of the input
     * document. Specify up to 10 language codes here.
     * </pre>
     *
     * <code>repeated string target_language_codes = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return A list containing the targetLanguageCodes.
     */
    public com.google.protobuf.ProtocolStringList getTargetLanguageCodesList() {
      return targetLanguageCodes_.getUnmodifiableView();
    }
    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code to use for translation of the input
     * document. Specify up to 10 language codes here.
     * </pre>
     *
     * <code>repeated string target_language_codes = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The count of targetLanguageCodes.
     */
    public int getTargetLanguageCodesCount() {
      return targetLanguageCodes_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code to use for translation of the input
     * document. Specify up to 10 language codes here.
     * </pre>
     *
     * <code>repeated string target_language_codes = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The targetLanguageCodes at the given index.
     */
    public java.lang.String getTargetLanguageCodes(int index) {
      return targetLanguageCodes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code to use for translation of the input
     * document. Specify up to 10 language codes here.
     * </pre>
     *
     * <code>repeated string target_language_codes = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the targetLanguageCodes at the given index.
     */
    public com.google.protobuf.ByteString getTargetLanguageCodesBytes(int index) {
      return targetLanguageCodes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code to use for translation of the input
     * document. Specify up to 10 language codes here.
     * </pre>
     *
     * <code>repeated string target_language_codes = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The targetLanguageCodes to set.
     * @return This builder for chaining.
     */
    public Builder setTargetLanguageCodes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTargetLanguageCodesIsMutable();
      targetLanguageCodes_.set(index, value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code to use for translation of the input
     * document. Specify up to 10 language codes here.
     * </pre>
     *
     * <code>repeated string target_language_codes = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The targetLanguageCodes to add.
     * @return This builder for chaining.
     */
    public Builder addTargetLanguageCodes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureTargetLanguageCodesIsMutable();
      targetLanguageCodes_.add(value);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code to use for translation of the input
     * document. Specify up to 10 language codes here.
     * </pre>
     *
     * <code>repeated string target_language_codes = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param values The targetLanguageCodes to add.
     * @return This builder for chaining.
     */
    public Builder addAllTargetLanguageCodes(java.lang.Iterable<java.lang.String> values) {
      ensureTargetLanguageCodesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, targetLanguageCodes_);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code to use for translation of the input
     * document. Specify up to 10 language codes here.
     * </pre>
     *
     * <code>repeated string target_language_codes = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTargetLanguageCodes() {
      targetLanguageCodes_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The BCP-47 language code to use for translation of the input
     * document. Specify up to 10 language codes here.
     * </pre>
     *
     * <code>repeated string target_language_codes = 3 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The bytes of the targetLanguageCodes to add.
     * @return This builder for chaining.
     */
    public Builder addTargetLanguageCodesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureTargetLanguageCodesIsMutable();
      targetLanguageCodes_.add(value);
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.translate.v3.BatchDocumentInputConfig> inputConfigs_ =
        java.util.Collections.emptyList();

    private void ensureInputConfigsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        inputConfigs_ =
            new java.util.ArrayList<com.google.cloud.translate.v3.BatchDocumentInputConfig>(
                inputConfigs_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.translate.v3.BatchDocumentInputConfig,
            com.google.cloud.translate.v3.BatchDocumentInputConfig.Builder,
            com.google.cloud.translate.v3.BatchDocumentInputConfigOrBuilder>
        inputConfigsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * The total number of files matched should be &lt;= 100.
     * The total content size to translate should be &lt;= 100M Unicode codepoints.
     * The files must use UTF-8 encoding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.translate.v3.BatchDocumentInputConfig>
        getInputConfigsList() {
      if (inputConfigsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(inputConfigs_);
      } else {
        return inputConfigsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * The total number of files matched should be &lt;= 100.
     * The total content size to translate should be &lt;= 100M Unicode codepoints.
     * The files must use UTF-8 encoding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getInputConfigsCount() {
      if (inputConfigsBuilder_ == null) {
        return inputConfigs_.size();
      } else {
        return inputConfigsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * The total number of files matched should be &lt;= 100.
     * The total content size to translate should be &lt;= 100M Unicode codepoints.
     * The files must use UTF-8 encoding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.translate.v3.BatchDocumentInputConfig getInputConfigs(int index) {
      if (inputConfigsBuilder_ == null) {
        return inputConfigs_.get(index);
      } else {
        return inputConfigsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * The total number of files matched should be &lt;= 100.
     * The total content size to translate should be &lt;= 100M Unicode codepoints.
     * The files must use UTF-8 encoding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInputConfigs(
        int index, com.google.cloud.translate.v3.BatchDocumentInputConfig value) {
      if (inputConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputConfigsIsMutable();
        inputConfigs_.set(index, value);
        onChanged();
      } else {
        inputConfigsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * The total number of files matched should be &lt;= 100.
     * The total content size to translate should be &lt;= 100M Unicode codepoints.
     * The files must use UTF-8 encoding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setInputConfigs(
        int index, com.google.cloud.translate.v3.BatchDocumentInputConfig.Builder builderForValue) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        inputConfigs_.set(index, builderForValue.build());
        onChanged();
      } else {
        inputConfigsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * The total number of files matched should be &lt;= 100.
     * The total content size to translate should be &lt;= 100M Unicode codepoints.
     * The files must use UTF-8 encoding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addInputConfigs(com.google.cloud.translate.v3.BatchDocumentInputConfig value) {
      if (inputConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputConfigsIsMutable();
        inputConfigs_.add(value);
        onChanged();
      } else {
        inputConfigsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * The total number of files matched should be &lt;= 100.
     * The total content size to translate should be &lt;= 100M Unicode codepoints.
     * The files must use UTF-8 encoding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addInputConfigs(
        int index, com.google.cloud.translate.v3.BatchDocumentInputConfig value) {
      if (inputConfigsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputConfigsIsMutable();
        inputConfigs_.add(index, value);
        onChanged();
      } else {
        inputConfigsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * The total number of files matched should be &lt;= 100.
     * The total content size to translate should be &lt;= 100M Unicode codepoints.
     * The files must use UTF-8 encoding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addInputConfigs(
        com.google.cloud.translate.v3.BatchDocumentInputConfig.Builder builderForValue) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        inputConfigs_.add(builderForValue.build());
        onChanged();
      } else {
        inputConfigsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * The total number of files matched should be &lt;= 100.
     * The total content size to translate should be &lt;= 100M Unicode codepoints.
     * The files must use UTF-8 encoding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addInputConfigs(
        int index, com.google.cloud.translate.v3.BatchDocumentInputConfig.Builder builderForValue) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        inputConfigs_.add(index, builderForValue.build());
        onChanged();
      } else {
        inputConfigsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * The total number of files matched should be &lt;= 100.
     * The total content size to translate should be &lt;= 100M Unicode codepoints.
     * The files must use UTF-8 encoding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllInputConfigs(
        java.lang.Iterable<? extends com.google.cloud.translate.v3.BatchDocumentInputConfig>
            values) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, inputConfigs_);
        onChanged();
      } else {
        inputConfigsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * The total number of files matched should be &lt;= 100.
     * The total content size to translate should be &lt;= 100M Unicode codepoints.
     * The files must use UTF-8 encoding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearInputConfigs() {
      if (inputConfigsBuilder_ == null) {
        inputConfigs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        inputConfigsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * The total number of files matched should be &lt;= 100.
     * The total content size to translate should be &lt;= 100M Unicode codepoints.
     * The files must use UTF-8 encoding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeInputConfigs(int index) {
      if (inputConfigsBuilder_ == null) {
        ensureInputConfigsIsMutable();
        inputConfigs_.remove(index);
        onChanged();
      } else {
        inputConfigsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * The total number of files matched should be &lt;= 100.
     * The total content size to translate should be &lt;= 100M Unicode codepoints.
     * The files must use UTF-8 encoding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.translate.v3.BatchDocumentInputConfig.Builder getInputConfigsBuilder(
        int index) {
      return getInputConfigsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * The total number of files matched should be &lt;= 100.
     * The total content size to translate should be &lt;= 100M Unicode codepoints.
     * The files must use UTF-8 encoding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.translate.v3.BatchDocumentInputConfigOrBuilder getInputConfigsOrBuilder(
        int index) {
      if (inputConfigsBuilder_ == null) {
        return inputConfigs_.get(index);
      } else {
        return inputConfigsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * The total number of files matched should be &lt;= 100.
     * The total content size to translate should be &lt;= 100M Unicode codepoints.
     * The files must use UTF-8 encoding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.translate.v3.BatchDocumentInputConfigOrBuilder>
        getInputConfigsOrBuilderList() {
      if (inputConfigsBuilder_ != null) {
        return inputConfigsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(inputConfigs_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * The total number of files matched should be &lt;= 100.
     * The total content size to translate should be &lt;= 100M Unicode codepoints.
     * The files must use UTF-8 encoding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.translate.v3.BatchDocumentInputConfig.Builder addInputConfigsBuilder() {
      return getInputConfigsFieldBuilder()
          .addBuilder(com.google.cloud.translate.v3.BatchDocumentInputConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * The total number of files matched should be &lt;= 100.
     * The total content size to translate should be &lt;= 100M Unicode codepoints.
     * The files must use UTF-8 encoding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.translate.v3.BatchDocumentInputConfig.Builder addInputConfigsBuilder(
        int index) {
      return getInputConfigsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.translate.v3.BatchDocumentInputConfig.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Input configurations.
     * The total number of files matched should be &lt;= 100.
     * The total content size to translate should be &lt;= 100M Unicode codepoints.
     * The files must use UTF-8 encoding.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchDocumentInputConfig input_configs = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.translate.v3.BatchDocumentInputConfig.Builder>
        getInputConfigsBuilderList() {
      return getInputConfigsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.translate.v3.BatchDocumentInputConfig,
            com.google.cloud.translate.v3.BatchDocumentInputConfig.Builder,
            com.google.cloud.translate.v3.BatchDocumentInputConfigOrBuilder>
        getInputConfigsFieldBuilder() {
      if (inputConfigsBuilder_ == null) {
        inputConfigsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.translate.v3.BatchDocumentInputConfig,
                com.google.cloud.translate.v3.BatchDocumentInputConfig.Builder,
                com.google.cloud.translate.v3.BatchDocumentInputConfigOrBuilder>(
                inputConfigs_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        inputConfigs_ = null;
      }
      return inputConfigsBuilder_;
    }

    private com.google.cloud.translate.v3.BatchDocumentOutputConfig outputConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3.BatchDocumentOutputConfig,
            com.google.cloud.translate.v3.BatchDocumentOutputConfig.Builder,
            com.google.cloud.translate.v3.BatchDocumentOutputConfigOrBuilder>
        outputConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Output configuration.
     * If 2 input configs match to the same file (that is, same input path),
     * we don't generate output for duplicate inputs.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3.BatchDocumentOutputConfig output_config = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the outputConfig field is set.
     */
    public boolean hasOutputConfig() {
      return outputConfigBuilder_ != null || outputConfig_ != null;
    }
    /**
     *
     *
     * <pre>
     * Required. Output configuration.
     * If 2 input configs match to the same file (that is, same input path),
     * we don't generate output for duplicate inputs.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3.BatchDocumentOutputConfig output_config = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The outputConfig.
     */
    public com.google.cloud.translate.v3.BatchDocumentOutputConfig getOutputConfig() {
      if (outputConfigBuilder_ == null) {
        return outputConfig_ == null
            ? com.google.cloud.translate.v3.BatchDocumentOutputConfig.getDefaultInstance()
            : outputConfig_;
      } else {
        return outputConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Output configuration.
     * If 2 input configs match to the same file (that is, same input path),
     * we don't generate output for duplicate inputs.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3.BatchDocumentOutputConfig output_config = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOutputConfig(com.google.cloud.translate.v3.BatchDocumentOutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputConfig_ = value;
        onChanged();
      } else {
        outputConfigBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Output configuration.
     * If 2 input configs match to the same file (that is, same input path),
     * we don't generate output for duplicate inputs.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3.BatchDocumentOutputConfig output_config = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setOutputConfig(
        com.google.cloud.translate.v3.BatchDocumentOutputConfig.Builder builderForValue) {
      if (outputConfigBuilder_ == null) {
        outputConfig_ = builderForValue.build();
        onChanged();
      } else {
        outputConfigBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Output configuration.
     * If 2 input configs match to the same file (that is, same input path),
     * we don't generate output for duplicate inputs.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3.BatchDocumentOutputConfig output_config = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeOutputConfig(
        com.google.cloud.translate.v3.BatchDocumentOutputConfig value) {
      if (outputConfigBuilder_ == null) {
        if (outputConfig_ != null) {
          outputConfig_ =
              com.google.cloud.translate.v3.BatchDocumentOutputConfig.newBuilder(outputConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          outputConfig_ = value;
        }
        onChanged();
      } else {
        outputConfigBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Output configuration.
     * If 2 input configs match to the same file (that is, same input path),
     * we don't generate output for duplicate inputs.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3.BatchDocumentOutputConfig output_config = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearOutputConfig() {
      if (outputConfigBuilder_ == null) {
        outputConfig_ = null;
        onChanged();
      } else {
        outputConfig_ = null;
        outputConfigBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Output configuration.
     * If 2 input configs match to the same file (that is, same input path),
     * we don't generate output for duplicate inputs.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3.BatchDocumentOutputConfig output_config = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.translate.v3.BatchDocumentOutputConfig.Builder
        getOutputConfigBuilder() {

      onChanged();
      return getOutputConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Output configuration.
     * If 2 input configs match to the same file (that is, same input path),
     * we don't generate output for duplicate inputs.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3.BatchDocumentOutputConfig output_config = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.translate.v3.BatchDocumentOutputConfigOrBuilder
        getOutputConfigOrBuilder() {
      if (outputConfigBuilder_ != null) {
        return outputConfigBuilder_.getMessageOrBuilder();
      } else {
        return outputConfig_ == null
            ? com.google.cloud.translate.v3.BatchDocumentOutputConfig.getDefaultInstance()
            : outputConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Output configuration.
     * If 2 input configs match to the same file (that is, same input path),
     * we don't generate output for duplicate inputs.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3.BatchDocumentOutputConfig output_config = 5 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3.BatchDocumentOutputConfig,
            com.google.cloud.translate.v3.BatchDocumentOutputConfig.Builder,
            com.google.cloud.translate.v3.BatchDocumentOutputConfigOrBuilder>
        getOutputConfigFieldBuilder() {
      if (outputConfigBuilder_ == null) {
        outputConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.translate.v3.BatchDocumentOutputConfig,
                com.google.cloud.translate.v3.BatchDocumentOutputConfig.Builder,
                com.google.cloud.translate.v3.BatchDocumentOutputConfigOrBuilder>(
                getOutputConfig(), getParentForChildren(), isClean());
        outputConfig_ = null;
      }
      return outputConfigBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> models_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetModels() {
      if (models_ == null) {
        return com.google.protobuf.MapField.emptyMapField(ModelsDefaultEntryHolder.defaultEntry);
      }
      return models_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableModels() {
      onChanged();
      ;
      if (models_ == null) {
        models_ = com.google.protobuf.MapField.newMapField(ModelsDefaultEntryHolder.defaultEntry);
      }
      if (!models_.isMutable()) {
        models_ = models_.copy();
      }
      return models_;
    }

    public int getModelsCount() {
      return internalGetModels().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. The models to use for translation. Map's key is target language
     * code. Map's value is the model name. Value can be a built-in general model,
     * or an AutoML Translation model.
     * The value format depends on model type:
     * - AutoML Translation models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
     * - General (built-in) models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
     * If the map is empty or a specific model is
     * not requested for a language pair, then default google model (nmt) is used.
     * </pre>
     *
     * <code>map&lt;string, string&gt; models = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsModels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetModels().getMap().containsKey(key);
    }
    /** Use {@link #getModelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getModels() {
      return getModelsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The models to use for translation. Map's key is target language
     * code. Map's value is the model name. Value can be a built-in general model,
     * or an AutoML Translation model.
     * The value format depends on model type:
     * - AutoML Translation models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
     * - General (built-in) models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
     * If the map is empty or a specific model is
     * not requested for a language pair, then default google model (nmt) is used.
     * </pre>
     *
     * <code>map&lt;string, string&gt; models = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getModelsMap() {
      return internalGetModels().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The models to use for translation. Map's key is target language
     * code. Map's value is the model name. Value can be a built-in general model,
     * or an AutoML Translation model.
     * The value format depends on model type:
     * - AutoML Translation models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
     * - General (built-in) models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
     * If the map is empty or a specific model is
     * not requested for a language pair, then default google model (nmt) is used.
     * </pre>
     *
     * <code>map&lt;string, string&gt; models = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getModelsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetModels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. The models to use for translation. Map's key is target language
     * code. Map's value is the model name. Value can be a built-in general model,
     * or an AutoML Translation model.
     * The value format depends on model type:
     * - AutoML Translation models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
     * - General (built-in) models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
     * If the map is empty or a specific model is
     * not requested for a language pair, then default google model (nmt) is used.
     * </pre>
     *
     * <code>map&lt;string, string&gt; models = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getModelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetModels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearModels() {
      internalGetMutableModels().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The models to use for translation. Map's key is target language
     * code. Map's value is the model name. Value can be a built-in general model,
     * or an AutoML Translation model.
     * The value format depends on model type:
     * - AutoML Translation models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
     * - General (built-in) models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
     * If the map is empty or a specific model is
     * not requested for a language pair, then default google model (nmt) is used.
     * </pre>
     *
     * <code>map&lt;string, string&gt; models = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeModels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableModels().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableModels() {
      return internalGetMutableModels().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. The models to use for translation. Map's key is target language
     * code. Map's value is the model name. Value can be a built-in general model,
     * or an AutoML Translation model.
     * The value format depends on model type:
     * - AutoML Translation models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
     * - General (built-in) models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
     * If the map is empty or a specific model is
     * not requested for a language pair, then default google model (nmt) is used.
     * </pre>
     *
     * <code>map&lt;string, string&gt; models = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putModels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableModels().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The models to use for translation. Map's key is target language
     * code. Map's value is the model name. Value can be a built-in general model,
     * or an AutoML Translation model.
     * The value format depends on model type:
     * - AutoML Translation models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/{model-id}`
     * - General (built-in) models:
     *   `projects/{project-number-or-id}/locations/{location-id}/models/general/nmt`,
     * If the map is empty or a specific model is
     * not requested for a language pair, then default google model (nmt) is used.
     * </pre>
     *
     * <code>map&lt;string, string&gt; models = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllModels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableModels().getMutableMap().putAll(values);
      return this;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.translate.v3.TranslateTextGlossaryConfig>
        glossaries_;

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.translate.v3.TranslateTextGlossaryConfig>
        internalGetGlossaries() {
      if (glossaries_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            GlossariesDefaultEntryHolder.defaultEntry);
      }
      return glossaries_;
    }

    private com.google.protobuf.MapField<
            java.lang.String, com.google.cloud.translate.v3.TranslateTextGlossaryConfig>
        internalGetMutableGlossaries() {
      onChanged();
      ;
      if (glossaries_ == null) {
        glossaries_ =
            com.google.protobuf.MapField.newMapField(GlossariesDefaultEntryHolder.defaultEntry);
      }
      if (!glossaries_.isMutable()) {
        glossaries_ = glossaries_.copy();
      }
      return glossaries_;
    }

    public int getGlossariesCount() {
      return internalGetGlossaries().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. Glossaries to be applied. It's keyed by target language code.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.translation.v3.TranslateTextGlossaryConfig&gt; glossaries = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsGlossaries(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetGlossaries().getMap().containsKey(key);
    }
    /** Use {@link #getGlossariesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.translate.v3.TranslateTextGlossaryConfig>
        getGlossaries() {
      return getGlossariesMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Glossaries to be applied. It's keyed by target language code.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.translation.v3.TranslateTextGlossaryConfig&gt; glossaries = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.translate.v3.TranslateTextGlossaryConfig>
        getGlossariesMap() {
      return internalGetGlossaries().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Glossaries to be applied. It's keyed by target language code.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.translation.v3.TranslateTextGlossaryConfig&gt; glossaries = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.translate.v3.TranslateTextGlossaryConfig getGlossariesOrDefault(
        java.lang.String key,
        com.google.cloud.translate.v3.TranslateTextGlossaryConfig defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.translate.v3.TranslateTextGlossaryConfig>
          map = internalGetGlossaries().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. Glossaries to be applied. It's keyed by target language code.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.translation.v3.TranslateTextGlossaryConfig&gt; glossaries = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.translate.v3.TranslateTextGlossaryConfig getGlossariesOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, com.google.cloud.translate.v3.TranslateTextGlossaryConfig>
          map = internalGetGlossaries().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearGlossaries() {
      internalGetMutableGlossaries().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Glossaries to be applied. It's keyed by target language code.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.translation.v3.TranslateTextGlossaryConfig&gt; glossaries = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeGlossaries(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableGlossaries().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.translate.v3.TranslateTextGlossaryConfig>
        getMutableGlossaries() {
      return internalGetMutableGlossaries().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. Glossaries to be applied. It's keyed by target language code.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.translation.v3.TranslateTextGlossaryConfig&gt; glossaries = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putGlossaries(
        java.lang.String key, com.google.cloud.translate.v3.TranslateTextGlossaryConfig value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableGlossaries().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. Glossaries to be applied. It's keyed by target language code.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.translation.v3.TranslateTextGlossaryConfig&gt; glossaries = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllGlossaries(
        java.util.Map<java.lang.String, com.google.cloud.translate.v3.TranslateTextGlossaryConfig>
            values) {
      internalGetMutableGlossaries().getMutableMap().putAll(values);
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> formatConversions_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetFormatConversions() {
      if (formatConversions_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            FormatConversionsDefaultEntryHolder.defaultEntry);
      }
      return formatConversions_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableFormatConversions() {
      onChanged();
      ;
      if (formatConversions_ == null) {
        formatConversions_ =
            com.google.protobuf.MapField.newMapField(
                FormatConversionsDefaultEntryHolder.defaultEntry);
      }
      if (!formatConversions_.isMutable()) {
        formatConversions_ = formatConversions_.copy();
      }
      return formatConversions_;
    }

    public int getFormatConversionsCount() {
      return internalGetFormatConversions().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * Optional. File format conversion map to be applied to all input files.
     * Map's key is the original mime_type. Map's value is the target mime_type of
     * translated documents.
     * Supported file format conversion includes:
     * - `application/pdf` to
     *   `application/vnd.openxmlformats-officedocument.wordprocessingml.document`
     * If nothing specified, output files will be in the same format as the
     * original file.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; format_conversions = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsFormatConversions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetFormatConversions().getMap().containsKey(key);
    }
    /** Use {@link #getFormatConversionsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getFormatConversions() {
      return getFormatConversionsMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. File format conversion map to be applied to all input files.
     * Map's key is the original mime_type. Map's value is the target mime_type of
     * translated documents.
     * Supported file format conversion includes:
     * - `application/pdf` to
     *   `application/vnd.openxmlformats-officedocument.wordprocessingml.document`
     * If nothing specified, output files will be in the same format as the
     * original file.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; format_conversions = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getFormatConversionsMap() {
      return internalGetFormatConversions().getMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. File format conversion map to be applied to all input files.
     * Map's key is the original mime_type. Map's value is the target mime_type of
     * translated documents.
     * Supported file format conversion includes:
     * - `application/pdf` to
     *   `application/vnd.openxmlformats-officedocument.wordprocessingml.document`
     * If nothing specified, output files will be in the same format as the
     * original file.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; format_conversions = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getFormatConversionsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetFormatConversions().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * Optional. File format conversion map to be applied to all input files.
     * Map's key is the original mime_type. Map's value is the target mime_type of
     * translated documents.
     * Supported file format conversion includes:
     * - `application/pdf` to
     *   `application/vnd.openxmlformats-officedocument.wordprocessingml.document`
     * If nothing specified, output files will be in the same format as the
     * original file.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; format_conversions = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getFormatConversionsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetFormatConversions().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearFormatConversions() {
      internalGetMutableFormatConversions().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. File format conversion map to be applied to all input files.
     * Map's key is the original mime_type. Map's value is the target mime_type of
     * translated documents.
     * Supported file format conversion includes:
     * - `application/pdf` to
     *   `application/vnd.openxmlformats-officedocument.wordprocessingml.document`
     * If nothing specified, output files will be in the same format as the
     * original file.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; format_conversions = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeFormatConversions(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableFormatConversions().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableFormatConversions() {
      return internalGetMutableFormatConversions().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * Optional. File format conversion map to be applied to all input files.
     * Map's key is the original mime_type. Map's value is the target mime_type of
     * translated documents.
     * Supported file format conversion includes:
     * - `application/pdf` to
     *   `application/vnd.openxmlformats-officedocument.wordprocessingml.document`
     * If nothing specified, output files will be in the same format as the
     * original file.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; format_conversions = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putFormatConversions(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }

      internalGetMutableFormatConversions().getMutableMap().put(key, value);
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. File format conversion map to be applied to all input files.
     * Map's key is the original mime_type. Map's value is the target mime_type of
     * translated documents.
     * Supported file format conversion includes:
     * - `application/pdf` to
     *   `application/vnd.openxmlformats-officedocument.wordprocessingml.document`
     * If nothing specified, output files will be in the same format as the
     * original file.
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; format_conversions = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllFormatConversions(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableFormatConversions().getMutableMap().putAll(values);
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.translation.v3.BatchTranslateDocumentRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.translation.v3.BatchTranslateDocumentRequest)
  private static final com.google.cloud.translate.v3.BatchTranslateDocumentRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.translate.v3.BatchTranslateDocumentRequest();
  }

  public static com.google.cloud.translate.v3.BatchTranslateDocumentRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchTranslateDocumentRequest> PARSER =
      new com.google.protobuf.AbstractParser<BatchTranslateDocumentRequest>() {
        @java.lang.Override
        public BatchTranslateDocumentRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new BatchTranslateDocumentRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<BatchTranslateDocumentRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchTranslateDocumentRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.translate.v3.BatchTranslateDocumentRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
