/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/translate/v3/adaptive_mt.proto

// Protobuf Java Version: 3.25.2
package com.google.cloud.translate.v3;

/**
 *
 *
 * <pre>
 * The request for sending an AdaptiveMt translation query.
 * </pre>
 *
 * Protobuf type {@code google.cloud.translation.v3.AdaptiveMtTranslateRequest}
 */
public final class AdaptiveMtTranslateRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.translation.v3.AdaptiveMtTranslateRequest)
    AdaptiveMtTranslateRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use AdaptiveMtTranslateRequest.newBuilder() to construct.
  private AdaptiveMtTranslateRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AdaptiveMtTranslateRequest() {
    parent_ = "";
    dataset_ = "";
    content_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AdaptiveMtTranslateRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.translate.v3.AdaptiveMtProto
        .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.translate.v3.AdaptiveMtProto
        .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.class,
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.Builder.class);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. Location to make a regional call.
   *
   * Format: `projects/{project-number-or-id}/locations/{location-id}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. Location to make a regional call.
   *
   * Format: `projects/{project-number-or-id}/locations/{location-id}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATASET_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataset_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name for the dataset to use for adaptive MT.
   * `projects/{project}/locations/{location-id}/adaptiveMtDatasets/{dataset}`
   * </pre>
   *
   * <code>
   * string dataset = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The dataset.
   */
  @java.lang.Override
  public java.lang.String getDataset() {
    java.lang.Object ref = dataset_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataset_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name for the dataset to use for adaptive MT.
   * `projects/{project}/locations/{location-id}/adaptiveMtDatasets/{dataset}`
   * </pre>
   *
   * <code>
   * string dataset = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for dataset.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatasetBytes() {
    java.lang.Object ref = dataset_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataset_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTENT_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList content_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * Required. The content of the input in string format.
   * For now only one sentence per request is supported.
   * </pre>
   *
   * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return A list containing the content.
   */
  public com.google.protobuf.ProtocolStringList getContentList() {
    return content_;
  }
  /**
   *
   *
   * <pre>
   * Required. The content of the input in string format.
   * For now only one sentence per request is supported.
   * </pre>
   *
   * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count of content.
   */
  public int getContentCount() {
    return content_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The content of the input in string format.
   * For now only one sentence per request is supported.
   * </pre>
   *
   * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the element to return.
   * @return The content at the given index.
   */
  public java.lang.String getContent(int index) {
    return content_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The content of the input in string format.
   * For now only one sentence per request is supported.
   * </pre>
   *
   * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the content at the given index.
   */
  public com.google.protobuf.ByteString getContentBytes(int index) {
    return content_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataset_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, dataset_);
    }
    for (int i = 0; i < content_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, content_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataset_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, dataset_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < content_.size(); i++) {
        dataSize += computeStringSizeNoTag(content_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getContentList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.translate.v3.AdaptiveMtTranslateRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.translate.v3.AdaptiveMtTranslateRequest other =
        (com.google.cloud.translate.v3.AdaptiveMtTranslateRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getDataset().equals(other.getDataset())) return false;
    if (!getContentList().equals(other.getContentList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + DATASET_FIELD_NUMBER;
    hash = (53 * hash) + getDataset().hashCode();
    if (getContentCount() > 0) {
      hash = (37 * hash) + CONTENT_FIELD_NUMBER;
      hash = (53 * hash) + getContentList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.translate.v3.AdaptiveMtTranslateRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for sending an AdaptiveMt translation query.
   * </pre>
   *
   * Protobuf type {@code google.cloud.translation.v3.AdaptiveMtTranslateRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.translation.v3.AdaptiveMtTranslateRequest)
      com.google.cloud.translate.v3.AdaptiveMtTranslateRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.translate.v3.AdaptiveMtProto
          .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.translate.v3.AdaptiveMtProto
          .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.class,
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.Builder.class);
    }

    // Construct using com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      dataset_ = "";
      content_ = com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.translate.v3.AdaptiveMtProto
          .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest getDefaultInstanceForType() {
      return com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest build() {
      com.google.cloud.translate.v3.AdaptiveMtTranslateRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest buildPartial() {
      com.google.cloud.translate.v3.AdaptiveMtTranslateRequest result =
          new com.google.cloud.translate.v3.AdaptiveMtTranslateRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.translate.v3.AdaptiveMtTranslateRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.dataset_ = dataset_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        content_.makeImmutable();
        result.content_ = content_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.translate.v3.AdaptiveMtTranslateRequest) {
        return mergeFrom((com.google.cloud.translate.v3.AdaptiveMtTranslateRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.translate.v3.AdaptiveMtTranslateRequest other) {
      if (other == com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDataset().isEmpty()) {
        dataset_ = other.dataset_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.content_.isEmpty()) {
        if (content_.isEmpty()) {
          content_ = other.content_;
          bitField0_ |= 0x00000004;
        } else {
          ensureContentIsMutable();
          content_.addAll(other.content_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                dataset_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureContentIsMutable();
                content_.add(s);
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. Location to make a regional call.
     *
     * Format: `projects/{project-number-or-id}/locations/{location-id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Location to make a regional call.
     *
     * Format: `projects/{project-number-or-id}/locations/{location-id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Location to make a regional call.
     *
     * Format: `projects/{project-number-or-id}/locations/{location-id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Location to make a regional call.
     *
     * Format: `projects/{project-number-or-id}/locations/{location-id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Location to make a regional call.
     *
     * Format: `projects/{project-number-or-id}/locations/{location-id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object dataset_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name for the dataset to use for adaptive MT.
     * `projects/{project}/locations/{location-id}/adaptiveMtDatasets/{dataset}`
     * </pre>
     *
     * <code>
     * string dataset = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataset.
     */
    public java.lang.String getDataset() {
      java.lang.Object ref = dataset_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataset_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name for the dataset to use for adaptive MT.
     * `projects/{project}/locations/{location-id}/adaptiveMtDatasets/{dataset}`
     * </pre>
     *
     * <code>
     * string dataset = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataset.
     */
    public com.google.protobuf.ByteString getDatasetBytes() {
      java.lang.Object ref = dataset_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataset_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name for the dataset to use for adaptive MT.
     * `projects/{project}/locations/{location-id}/adaptiveMtDatasets/{dataset}`
     * </pre>
     *
     * <code>
     * string dataset = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The dataset to set.
     * @return This builder for chaining.
     */
    public Builder setDataset(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataset_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name for the dataset to use for adaptive MT.
     * `projects/{project}/locations/{location-id}/adaptiveMtDatasets/{dataset}`
     * </pre>
     *
     * <code>
     * string dataset = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataset() {
      dataset_ = getDefaultInstance().getDataset();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name for the dataset to use for adaptive MT.
     * `projects/{project}/locations/{location-id}/adaptiveMtDatasets/{dataset}`
     * </pre>
     *
     * <code>
     * string dataset = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for dataset to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataset_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList content_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureContentIsMutable() {
      if (!content_.isModifiable()) {
        content_ = new com.google.protobuf.LazyStringArrayList(content_);
      }
      bitField0_ |= 0x00000004;
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the input in string format.
     * For now only one sentence per request is supported.
     * </pre>
     *
     * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the content.
     */
    public com.google.protobuf.ProtocolStringList getContentList() {
      content_.makeImmutable();
      return content_;
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the input in string format.
     * For now only one sentence per request is supported.
     * </pre>
     *
     * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of content.
     */
    public int getContentCount() {
      return content_.size();
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the input in string format.
     * For now only one sentence per request is supported.
     * </pre>
     *
     * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The content at the given index.
     */
    public java.lang.String getContent(int index) {
      return content_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the input in string format.
     * For now only one sentence per request is supported.
     * </pre>
     *
     * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the content at the given index.
     */
    public com.google.protobuf.ByteString getContentBytes(int index) {
      return content_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the input in string format.
     * For now only one sentence per request is supported.
     * </pre>
     *
     * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index to set the value at.
     * @param value The content to set.
     * @return This builder for chaining.
     */
    public Builder setContent(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureContentIsMutable();
      content_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the input in string format.
     * For now only one sentence per request is supported.
     * </pre>
     *
     * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The content to add.
     * @return This builder for chaining.
     */
    public Builder addContent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureContentIsMutable();
      content_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the input in string format.
     * For now only one sentence per request is supported.
     * </pre>
     *
     * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param values The content to add.
     * @return This builder for chaining.
     */
    public Builder addAllContent(java.lang.Iterable<java.lang.String> values) {
      ensureContentIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, content_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the input in string format.
     * For now only one sentence per request is supported.
     * </pre>
     *
     * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContent() {
      content_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The content of the input in string format.
     * For now only one sentence per request is supported.
     * </pre>
     *
     * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes of the content to add.
     * @return This builder for chaining.
     */
    public Builder addContentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureContentIsMutable();
      content_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.translation.v3.AdaptiveMtTranslateRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.translation.v3.AdaptiveMtTranslateRequest)
  private static final com.google.cloud.translate.v3.AdaptiveMtTranslateRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.translate.v3.AdaptiveMtTranslateRequest();
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AdaptiveMtTranslateRequest> PARSER =
      new com.google.protobuf.AbstractParser<AdaptiveMtTranslateRequest>() {
        @java.lang.Override
        public AdaptiveMtTranslateRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AdaptiveMtTranslateRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AdaptiveMtTranslateRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
