/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/translate/v3/automl_translation.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.translate.v3;

/**
 *
 *
 * <pre>
 * Response message for BatchTransferResources.
 * </pre>
 *
 * Protobuf type {@code google.cloud.translation.v3.BatchTransferResourcesResponse}
 */
public final class BatchTransferResourcesResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.translation.v3.BatchTransferResourcesResponse)
    BatchTransferResourcesResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use BatchTransferResourcesResponse.newBuilder() to construct.
  private BatchTransferResourcesResponse(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private BatchTransferResourcesResponse() {
    responses_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new BatchTransferResourcesResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.translate.v3.AutoMLTranslationProto
        .internal_static_google_cloud_translation_v3_BatchTransferResourcesResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.translate.v3.AutoMLTranslationProto
        .internal_static_google_cloud_translation_v3_BatchTransferResourcesResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.translate.v3.BatchTransferResourcesResponse.class,
            com.google.cloud.translate.v3.BatchTransferResourcesResponse.Builder.class);
  }

  public interface TransferResourceResponseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Full name of the resource to transfer as specified in the request.
     * </pre>
     *
     * <code>string source = 1;</code>
     *
     * @return The source.
     */
    java.lang.String getSource();
    /**
     *
     *
     * <pre>
     * Full name of the resource to transfer as specified in the request.
     * </pre>
     *
     * <code>string source = 1;</code>
     *
     * @return The bytes for source.
     */
    com.google.protobuf.ByteString getSourceBytes();

    /**
     *
     *
     * <pre>
     * Full name of the new resource successfully transferred from the source
     * hosted by Translation API. Target will be empty if the transfer failed.
     * </pre>
     *
     * <code>string target = 2;</code>
     *
     * @return The target.
     */
    java.lang.String getTarget();
    /**
     *
     *
     * <pre>
     * Full name of the new resource successfully transferred from the source
     * hosted by Translation API. Target will be empty if the transfer failed.
     * </pre>
     *
     * <code>string target = 2;</code>
     *
     * @return The bytes for target.
     */
    com.google.protobuf.ByteString getTargetBytes();

    /**
     *
     *
     * <pre>
     * The error result in case of failure.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     *
     * @return Whether the error field is set.
     */
    boolean hasError();
    /**
     *
     *
     * <pre>
     * The error result in case of failure.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     *
     * @return The error.
     */
    com.google.rpc.Status getError();
    /**
     *
     *
     * <pre>
     * The error result in case of failure.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     */
    com.google.rpc.StatusOrBuilder getErrorOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Transfer response for a single resource.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse}
   */
  public static final class TransferResourceResponse extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse)
      TransferResourceResponseOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use TransferResourceResponse.newBuilder() to construct.
    private TransferResourceResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private TransferResourceResponse() {
      source_ = "";
      target_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new TransferResourceResponse();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.translate.v3.AutoMLTranslationProto
          .internal_static_google_cloud_translation_v3_BatchTransferResourcesResponse_TransferResourceResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.translate.v3.AutoMLTranslationProto
          .internal_static_google_cloud_translation_v3_BatchTransferResourcesResponse_TransferResourceResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
                  .class,
              com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
                  .Builder.class);
    }

    private int bitField0_;
    public static final int SOURCE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object source_ = "";
    /**
     *
     *
     * <pre>
     * Full name of the resource to transfer as specified in the request.
     * </pre>
     *
     * <code>string source = 1;</code>
     *
     * @return The source.
     */
    @java.lang.Override
    public java.lang.String getSource() {
      java.lang.Object ref = source_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        source_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Full name of the resource to transfer as specified in the request.
     * </pre>
     *
     * <code>string source = 1;</code>
     *
     * @return The bytes for source.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSourceBytes() {
      java.lang.Object ref = source_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        source_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TARGET_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object target_ = "";
    /**
     *
     *
     * <pre>
     * Full name of the new resource successfully transferred from the source
     * hosted by Translation API. Target will be empty if the transfer failed.
     * </pre>
     *
     * <code>string target = 2;</code>
     *
     * @return The target.
     */
    @java.lang.Override
    public java.lang.String getTarget() {
      java.lang.Object ref = target_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        target_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Full name of the new resource successfully transferred from the source
     * hosted by Translation API. Target will be empty if the transfer failed.
     * </pre>
     *
     * <code>string target = 2;</code>
     *
     * @return The bytes for target.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTargetBytes() {
      java.lang.Object ref = target_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        target_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ERROR_FIELD_NUMBER = 3;
    private com.google.rpc.Status error_;
    /**
     *
     *
     * <pre>
     * The error result in case of failure.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     *
     * @return Whether the error field is set.
     */
    @java.lang.Override
    public boolean hasError() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * The error result in case of failure.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     *
     * @return The error.
     */
    @java.lang.Override
    public com.google.rpc.Status getError() {
      return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
    }
    /**
     *
     *
     * <pre>
     * The error result in case of failure.
     * </pre>
     *
     * <code>.google.rpc.Status error = 3;</code>
     */
    @java.lang.Override
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(source_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, source_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(target_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, target_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getError());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(source_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, source_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(target_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, target_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getError());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse)) {
        return super.equals(obj);
      }
      com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse other =
          (com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse)
              obj;

      if (!getSource().equals(other.getSource())) return false;
      if (!getTarget().equals(other.getTarget())) return false;
      if (hasError() != other.hasError()) return false;
      if (hasError()) {
        if (!getError().equals(other.getError())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getSource().hashCode();
      hash = (37 * hash) + TARGET_FIELD_NUMBER;
      hash = (53 * hash) + getTarget().hashCode();
      if (hasError()) {
        hash = (37 * hash) + ERROR_FIELD_NUMBER;
        hash = (53 * hash) + getError().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.translate.v3.BatchTransferResourcesResponse
            .TransferResourceResponse
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3.BatchTransferResourcesResponse
            .TransferResourceResponse
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.BatchTransferResourcesResponse
            .TransferResourceResponse
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3.BatchTransferResourcesResponse
            .TransferResourceResponse
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.BatchTransferResourcesResponse
            .TransferResourceResponse
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3.BatchTransferResourcesResponse
            .TransferResourceResponse
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.BatchTransferResourcesResponse
            .TransferResourceResponse
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3.BatchTransferResourcesResponse
            .TransferResourceResponse
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.BatchTransferResourcesResponse
            .TransferResourceResponse
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3.BatchTransferResourcesResponse
            .TransferResourceResponse
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.BatchTransferResourcesResponse
            .TransferResourceResponse
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3.BatchTransferResourcesResponse
            .TransferResourceResponse
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Transfer response for a single resource.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse)
        com.google.cloud.translate.v3.BatchTransferResourcesResponse
            .TransferResourceResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.translate.v3.AutoMLTranslationProto
            .internal_static_google_cloud_translation_v3_BatchTransferResourcesResponse_TransferResourceResponse_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.translate.v3.AutoMLTranslationProto
            .internal_static_google_cloud_translation_v3_BatchTransferResourcesResponse_TransferResourceResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.translate.v3.BatchTransferResourcesResponse
                    .TransferResourceResponse.class,
                com.google.cloud.translate.v3.BatchTransferResourcesResponse
                    .TransferResourceResponse.Builder.class);
      }

      // Construct using
      // com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getErrorFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        source_ = "";
        target_ = "";
        error_ = null;
        if (errorBuilder_ != null) {
          errorBuilder_.dispose();
          errorBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.translate.v3.AutoMLTranslationProto
            .internal_static_google_cloud_translation_v3_BatchTransferResourcesResponse_TransferResourceResponse_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
          getDefaultInstanceForType() {
        return com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
          build() {
        com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
            result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
          buildPartial() {
        com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
            result =
                new com.google.cloud.translate.v3.BatchTransferResourcesResponse
                    .TransferResourceResponse(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.source_ = source_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.target_ = target_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse) {
          return mergeFrom(
              (com.google.cloud.translate.v3.BatchTransferResourcesResponse
                      .TransferResourceResponse)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
              other) {
        if (other
            == com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
                .getDefaultInstance()) return this;
        if (!other.getSource().isEmpty()) {
          source_ = other.source_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getTarget().isEmpty()) {
          target_ = other.target_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (other.hasError()) {
          mergeError(other.getError());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  source_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  target_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object source_ = "";
      /**
       *
       *
       * <pre>
       * Full name of the resource to transfer as specified in the request.
       * </pre>
       *
       * <code>string source = 1;</code>
       *
       * @return The source.
       */
      public java.lang.String getSource() {
        java.lang.Object ref = source_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          source_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Full name of the resource to transfer as specified in the request.
       * </pre>
       *
       * <code>string source = 1;</code>
       *
       * @return The bytes for source.
       */
      public com.google.protobuf.ByteString getSourceBytes() {
        java.lang.Object ref = source_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          source_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Full name of the resource to transfer as specified in the request.
       * </pre>
       *
       * <code>string source = 1;</code>
       *
       * @param value The source to set.
       * @return This builder for chaining.
       */
      public Builder setSource(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Full name of the resource to transfer as specified in the request.
       * </pre>
       *
       * <code>string source = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSource() {
        source_ = getDefaultInstance().getSource();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Full name of the resource to transfer as specified in the request.
       * </pre>
       *
       * <code>string source = 1;</code>
       *
       * @param value The bytes for source to set.
       * @return This builder for chaining.
       */
      public Builder setSourceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        source_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object target_ = "";
      /**
       *
       *
       * <pre>
       * Full name of the new resource successfully transferred from the source
       * hosted by Translation API. Target will be empty if the transfer failed.
       * </pre>
       *
       * <code>string target = 2;</code>
       *
       * @return The target.
       */
      public java.lang.String getTarget() {
        java.lang.Object ref = target_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          target_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Full name of the new resource successfully transferred from the source
       * hosted by Translation API. Target will be empty if the transfer failed.
       * </pre>
       *
       * <code>string target = 2;</code>
       *
       * @return The bytes for target.
       */
      public com.google.protobuf.ByteString getTargetBytes() {
        java.lang.Object ref = target_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          target_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Full name of the new resource successfully transferred from the source
       * hosted by Translation API. Target will be empty if the transfer failed.
       * </pre>
       *
       * <code>string target = 2;</code>
       *
       * @param value The target to set.
       * @return This builder for chaining.
       */
      public Builder setTarget(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        target_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Full name of the new resource successfully transferred from the source
       * hosted by Translation API. Target will be empty if the transfer failed.
       * </pre>
       *
       * <code>string target = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTarget() {
        target_ = getDefaultInstance().getTarget();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Full name of the new resource successfully transferred from the source
       * hosted by Translation API. Target will be empty if the transfer failed.
       * </pre>
       *
       * <code>string target = 2;</code>
       *
       * @param value The bytes for target to set.
       * @return This builder for chaining.
       */
      public Builder setTargetBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        target_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.rpc.Status error_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          errorBuilder_;
      /**
       *
       *
       * <pre>
       * The error result in case of failure.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3;</code>
       *
       * @return Whether the error field is set.
       */
      public boolean hasError() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * The error result in case of failure.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3;</code>
       *
       * @return The error.
       */
      public com.google.rpc.Status getError() {
        if (errorBuilder_ == null) {
          return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
        } else {
          return errorBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The error result in case of failure.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3;</code>
       */
      public Builder setError(com.google.rpc.Status value) {
        if (errorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          error_ = value;
        } else {
          errorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The error result in case of failure.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3;</code>
       */
      public Builder setError(com.google.rpc.Status.Builder builderForValue) {
        if (errorBuilder_ == null) {
          error_ = builderForValue.build();
        } else {
          errorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The error result in case of failure.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3;</code>
       */
      public Builder mergeError(com.google.rpc.Status value) {
        if (errorBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && error_ != null
              && error_ != com.google.rpc.Status.getDefaultInstance()) {
            getErrorBuilder().mergeFrom(value);
          } else {
            error_ = value;
          }
        } else {
          errorBuilder_.mergeFrom(value);
        }
        if (error_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The error result in case of failure.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3;</code>
       */
      public Builder clearError() {
        bitField0_ = (bitField0_ & ~0x00000004);
        error_ = null;
        if (errorBuilder_ != null) {
          errorBuilder_.dispose();
          errorBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The error result in case of failure.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3;</code>
       */
      public com.google.rpc.Status.Builder getErrorBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getErrorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The error result in case of failure.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3;</code>
       */
      public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
        if (errorBuilder_ != null) {
          return errorBuilder_.getMessageOrBuilder();
        } else {
          return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
        }
      }
      /**
       *
       *
       * <pre>
       * The error result in case of failure.
       * </pre>
       *
       * <code>.google.rpc.Status error = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
          getErrorFieldBuilder() {
        if (errorBuilder_ == null) {
          errorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.rpc.Status,
                  com.google.rpc.Status.Builder,
                  com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
          error_ = null;
        }
        return errorBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse)
    private static final com.google.cloud.translate.v3.BatchTransferResourcesResponse
            .TransferResourceResponse
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.translate.v3.BatchTransferResourcesResponse
              .TransferResourceResponse();
    }

    public static com.google.cloud.translate.v3.BatchTransferResourcesResponse
            .TransferResourceResponse
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TransferResourceResponse> PARSER =
        new com.google.protobuf.AbstractParser<TransferResourceResponse>() {
          @java.lang.Override
          public TransferResourceResponse parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<TransferResourceResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TransferResourceResponse> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int RESPONSES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse>
      responses_;
  /**
   *
   *
   * <pre>
   * Responses of the transfer for individual resources.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse>
      getResponsesList() {
    return responses_;
  }
  /**
   *
   *
   * <pre>
   * Responses of the transfer for individual resources.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.translate.v3.BatchTransferResourcesResponse
                  .TransferResourceResponseOrBuilder>
      getResponsesOrBuilderList() {
    return responses_;
  }
  /**
   *
   *
   * <pre>
   * Responses of the transfer for individual resources.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
   * </code>
   */
  @java.lang.Override
  public int getResponsesCount() {
    return responses_.size();
  }
  /**
   *
   *
   * <pre>
   * Responses of the transfer for individual resources.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
      getResponses(int index) {
    return responses_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Responses of the transfer for individual resources.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3.BatchTransferResourcesResponse
          .TransferResourceResponseOrBuilder
      getResponsesOrBuilder(int index) {
    return responses_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < responses_.size(); i++) {
      output.writeMessage(1, responses_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < responses_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, responses_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.translate.v3.BatchTransferResourcesResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.translate.v3.BatchTransferResourcesResponse other =
        (com.google.cloud.translate.v3.BatchTransferResourcesResponse) obj;

    if (!getResponsesList().equals(other.getResponsesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getResponsesCount() > 0) {
      hash = (37 * hash) + RESPONSES_FIELD_NUMBER;
      hash = (53 * hash) + getResponsesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.translate.v3.BatchTransferResourcesResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.BatchTransferResourcesResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.BatchTransferResourcesResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.BatchTransferResourcesResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.BatchTransferResourcesResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.BatchTransferResourcesResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.BatchTransferResourcesResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.BatchTransferResourcesResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.BatchTransferResourcesResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.BatchTransferResourcesResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.BatchTransferResourcesResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.BatchTransferResourcesResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.translate.v3.BatchTransferResourcesResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for BatchTransferResources.
   * </pre>
   *
   * Protobuf type {@code google.cloud.translation.v3.BatchTransferResourcesResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.translation.v3.BatchTransferResourcesResponse)
      com.google.cloud.translate.v3.BatchTransferResourcesResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.translate.v3.AutoMLTranslationProto
          .internal_static_google_cloud_translation_v3_BatchTransferResourcesResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.translate.v3.AutoMLTranslationProto
          .internal_static_google_cloud_translation_v3_BatchTransferResourcesResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.translate.v3.BatchTransferResourcesResponse.class,
              com.google.cloud.translate.v3.BatchTransferResourcesResponse.Builder.class);
    }

    // Construct using com.google.cloud.translate.v3.BatchTransferResourcesResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (responsesBuilder_ == null) {
        responses_ = java.util.Collections.emptyList();
      } else {
        responses_ = null;
        responsesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.translate.v3.AutoMLTranslationProto
          .internal_static_google_cloud_translation_v3_BatchTransferResourcesResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.BatchTransferResourcesResponse
        getDefaultInstanceForType() {
      return com.google.cloud.translate.v3.BatchTransferResourcesResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.BatchTransferResourcesResponse build() {
      com.google.cloud.translate.v3.BatchTransferResourcesResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.BatchTransferResourcesResponse buildPartial() {
      com.google.cloud.translate.v3.BatchTransferResourcesResponse result =
          new com.google.cloud.translate.v3.BatchTransferResourcesResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.translate.v3.BatchTransferResourcesResponse result) {
      if (responsesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          responses_ = java.util.Collections.unmodifiableList(responses_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.responses_ = responses_;
      } else {
        result.responses_ = responsesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.translate.v3.BatchTransferResourcesResponse result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.translate.v3.BatchTransferResourcesResponse) {
        return mergeFrom((com.google.cloud.translate.v3.BatchTransferResourcesResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.translate.v3.BatchTransferResourcesResponse other) {
      if (other
          == com.google.cloud.translate.v3.BatchTransferResourcesResponse.getDefaultInstance())
        return this;
      if (responsesBuilder_ == null) {
        if (!other.responses_.isEmpty()) {
          if (responses_.isEmpty()) {
            responses_ = other.responses_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureResponsesIsMutable();
            responses_.addAll(other.responses_);
          }
          onChanged();
        }
      } else {
        if (!other.responses_.isEmpty()) {
          if (responsesBuilder_.isEmpty()) {
            responsesBuilder_.dispose();
            responsesBuilder_ = null;
            responses_ = other.responses_;
            bitField0_ = (bitField0_ & ~0x00000001);
            responsesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getResponsesFieldBuilder()
                    : null;
          } else {
            responsesBuilder_.addAllMessages(other.responses_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.translate.v3.BatchTransferResourcesResponse
                        .TransferResourceResponse
                    m =
                        input.readMessage(
                            com.google.cloud.translate.v3.BatchTransferResourcesResponse
                                .TransferResourceResponse.parser(),
                            extensionRegistry);
                if (responsesBuilder_ == null) {
                  ensureResponsesIsMutable();
                  responses_.add(m);
                } else {
                  responsesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<
            com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse>
        responses_ = java.util.Collections.emptyList();

    private void ensureResponsesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        responses_ =
            new java.util.ArrayList<
                com.google.cloud.translate.v3.BatchTransferResourcesResponse
                    .TransferResourceResponse>(responses_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse,
            com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
                .Builder,
            com.google.cloud.translate.v3.BatchTransferResourcesResponse
                .TransferResourceResponseOrBuilder>
        responsesBuilder_;

    /**
     *
     *
     * <pre>
     * Responses of the transfer for individual resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse>
        getResponsesList() {
      if (responsesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(responses_);
      } else {
        return responsesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Responses of the transfer for individual resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
     * </code>
     */
    public int getResponsesCount() {
      if (responsesBuilder_ == null) {
        return responses_.size();
      } else {
        return responsesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Responses of the transfer for individual resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
     * </code>
     */
    public com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
        getResponses(int index) {
      if (responsesBuilder_ == null) {
        return responses_.get(index);
      } else {
        return responsesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Responses of the transfer for individual resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
     * </code>
     */
    public Builder setResponses(
        int index,
        com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
            value) {
      if (responsesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResponsesIsMutable();
        responses_.set(index, value);
        onChanged();
      } else {
        responsesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Responses of the transfer for individual resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
     * </code>
     */
    public Builder setResponses(
        int index,
        com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
                .Builder
            builderForValue) {
      if (responsesBuilder_ == null) {
        ensureResponsesIsMutable();
        responses_.set(index, builderForValue.build());
        onChanged();
      } else {
        responsesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Responses of the transfer for individual resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
     * </code>
     */
    public Builder addResponses(
        com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
            value) {
      if (responsesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResponsesIsMutable();
        responses_.add(value);
        onChanged();
      } else {
        responsesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Responses of the transfer for individual resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
     * </code>
     */
    public Builder addResponses(
        int index,
        com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
            value) {
      if (responsesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResponsesIsMutable();
        responses_.add(index, value);
        onChanged();
      } else {
        responsesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Responses of the transfer for individual resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
     * </code>
     */
    public Builder addResponses(
        com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
                .Builder
            builderForValue) {
      if (responsesBuilder_ == null) {
        ensureResponsesIsMutable();
        responses_.add(builderForValue.build());
        onChanged();
      } else {
        responsesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Responses of the transfer for individual resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
     * </code>
     */
    public Builder addResponses(
        int index,
        com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
                .Builder
            builderForValue) {
      if (responsesBuilder_ == null) {
        ensureResponsesIsMutable();
        responses_.add(index, builderForValue.build());
        onChanged();
      } else {
        responsesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Responses of the transfer for individual resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
     * </code>
     */
    public Builder addAllResponses(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.translate.v3.BatchTransferResourcesResponse
                        .TransferResourceResponse>
            values) {
      if (responsesBuilder_ == null) {
        ensureResponsesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, responses_);
        onChanged();
      } else {
        responsesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Responses of the transfer for individual resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
     * </code>
     */
    public Builder clearResponses() {
      if (responsesBuilder_ == null) {
        responses_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        responsesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Responses of the transfer for individual resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
     * </code>
     */
    public Builder removeResponses(int index) {
      if (responsesBuilder_ == null) {
        ensureResponsesIsMutable();
        responses_.remove(index);
        onChanged();
      } else {
        responsesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Responses of the transfer for individual resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
     * </code>
     */
    public com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
            .Builder
        getResponsesBuilder(int index) {
      return getResponsesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Responses of the transfer for individual resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
     * </code>
     */
    public com.google.cloud.translate.v3.BatchTransferResourcesResponse
            .TransferResourceResponseOrBuilder
        getResponsesOrBuilder(int index) {
      if (responsesBuilder_ == null) {
        return responses_.get(index);
      } else {
        return responsesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Responses of the transfer for individual resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.translate.v3.BatchTransferResourcesResponse
                    .TransferResourceResponseOrBuilder>
        getResponsesOrBuilderList() {
      if (responsesBuilder_ != null) {
        return responsesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(responses_);
      }
    }
    /**
     *
     *
     * <pre>
     * Responses of the transfer for individual resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
     * </code>
     */
    public com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
            .Builder
        addResponsesBuilder() {
      return getResponsesFieldBuilder()
          .addBuilder(
              com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Responses of the transfer for individual resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
     * </code>
     */
    public com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
            .Builder
        addResponsesBuilder(int index) {
      return getResponsesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
                  .getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Responses of the transfer for individual resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.BatchTransferResourcesResponse.TransferResourceResponse responses = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
                .Builder>
        getResponsesBuilderList() {
      return getResponsesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse,
            com.google.cloud.translate.v3.BatchTransferResourcesResponse.TransferResourceResponse
                .Builder,
            com.google.cloud.translate.v3.BatchTransferResourcesResponse
                .TransferResourceResponseOrBuilder>
        getResponsesFieldBuilder() {
      if (responsesBuilder_ == null) {
        responsesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.translate.v3.BatchTransferResourcesResponse
                    .TransferResourceResponse,
                com.google.cloud.translate.v3.BatchTransferResourcesResponse
                    .TransferResourceResponse.Builder,
                com.google.cloud.translate.v3.BatchTransferResourcesResponse
                    .TransferResourceResponseOrBuilder>(
                responses_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        responses_ = null;
      }
      return responsesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.translation.v3.BatchTransferResourcesResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.translation.v3.BatchTransferResourcesResponse)
  private static final com.google.cloud.translate.v3.BatchTransferResourcesResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.translate.v3.BatchTransferResourcesResponse();
  }

  public static com.google.cloud.translate.v3.BatchTransferResourcesResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<BatchTransferResourcesResponse> PARSER =
      new com.google.protobuf.AbstractParser<BatchTransferResourcesResponse>() {
        @java.lang.Override
        public BatchTransferResourcesResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<BatchTransferResourcesResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<BatchTransferResourcesResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.translate.v3.BatchTransferResourcesResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
