/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/translate/v3/adaptive_mt.proto

// Protobuf Java Version: 3.25.4
package com.google.cloud.translate.v3;

/**
 *
 *
 * <pre>
 * The request for importing an AdaptiveMt file along with its sentences.
 * </pre>
 *
 * Protobuf type {@code google.cloud.translation.v3.ImportAdaptiveMtFileRequest}
 */
public final class ImportAdaptiveMtFileRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.translation.v3.ImportAdaptiveMtFileRequest)
    ImportAdaptiveMtFileRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportAdaptiveMtFileRequest.newBuilder() to construct.
  private ImportAdaptiveMtFileRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportAdaptiveMtFileRequest() {
    parent_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportAdaptiveMtFileRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.translate.v3.AdaptiveMtProto
        .internal_static_google_cloud_translation_v3_ImportAdaptiveMtFileRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.translate.v3.AdaptiveMtProto
        .internal_static_google_cloud_translation_v3_ImportAdaptiveMtFileRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest.class,
            com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest.Builder.class);
  }

  private int sourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object source_;

  public enum SourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    FILE_INPUT_SOURCE(2),
    GCS_INPUT_SOURCE(3),
    SOURCE_NOT_SET(0);
    private final int value;

    private SourceCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static SourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static SourceCase forNumber(int value) {
      switch (value) {
        case 2:
          return FILE_INPUT_SOURCE;
        case 3:
          return GCS_INPUT_SOURCE;
        case 0:
          return SOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public SourceCase getSourceCase() {
    return SourceCase.forNumber(sourceCase_);
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of the file, in form of
   * `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets/{dataset}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of the file, in form of
   * `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets/{dataset}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FILE_INPUT_SOURCE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Inline file source.
   * </pre>
   *
   * <code>.google.cloud.translation.v3.FileInputSource file_input_source = 2;</code>
   *
   * @return Whether the fileInputSource field is set.
   */
  @java.lang.Override
  public boolean hasFileInputSource() {
    return sourceCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Inline file source.
   * </pre>
   *
   * <code>.google.cloud.translation.v3.FileInputSource file_input_source = 2;</code>
   *
   * @return The fileInputSource.
   */
  @java.lang.Override
  public com.google.cloud.translate.v3.FileInputSource getFileInputSource() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.translate.v3.FileInputSource) source_;
    }
    return com.google.cloud.translate.v3.FileInputSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Inline file source.
   * </pre>
   *
   * <code>.google.cloud.translation.v3.FileInputSource file_input_source = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3.FileInputSourceOrBuilder getFileInputSourceOrBuilder() {
    if (sourceCase_ == 2) {
      return (com.google.cloud.translate.v3.FileInputSource) source_;
    }
    return com.google.cloud.translate.v3.FileInputSource.getDefaultInstance();
  }

  public static final int GCS_INPUT_SOURCE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Google Cloud Storage file source.
   * </pre>
   *
   * <code>.google.cloud.translation.v3.GcsInputSource gcs_input_source = 3;</code>
   *
   * @return Whether the gcsInputSource field is set.
   */
  @java.lang.Override
  public boolean hasGcsInputSource() {
    return sourceCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Google Cloud Storage file source.
   * </pre>
   *
   * <code>.google.cloud.translation.v3.GcsInputSource gcs_input_source = 3;</code>
   *
   * @return The gcsInputSource.
   */
  @java.lang.Override
  public com.google.cloud.translate.v3.GcsInputSource getGcsInputSource() {
    if (sourceCase_ == 3) {
      return (com.google.cloud.translate.v3.GcsInputSource) source_;
    }
    return com.google.cloud.translate.v3.GcsInputSource.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Google Cloud Storage file source.
   * </pre>
   *
   * <code>.google.cloud.translation.v3.GcsInputSource gcs_input_source = 3;</code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3.GcsInputSourceOrBuilder getGcsInputSourceOrBuilder() {
    if (sourceCase_ == 3) {
      return (com.google.cloud.translate.v3.GcsInputSource) source_;
    }
    return com.google.cloud.translate.v3.GcsInputSource.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (sourceCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.translate.v3.FileInputSource) source_);
    }
    if (sourceCase_ == 3) {
      output.writeMessage(3, (com.google.cloud.translate.v3.GcsInputSource) source_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (sourceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.translate.v3.FileInputSource) source_);
    }
    if (sourceCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.translate.v3.GcsInputSource) source_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest other =
        (com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getSourceCase().equals(other.getSourceCase())) return false;
    switch (sourceCase_) {
      case 2:
        if (!getFileInputSource().equals(other.getFileInputSource())) return false;
        break;
      case 3:
        if (!getGcsInputSource().equals(other.getGcsInputSource())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    switch (sourceCase_) {
      case 2:
        hash = (37 * hash) + FILE_INPUT_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getFileInputSource().hashCode();
        break;
      case 3:
        hash = (37 * hash) + GCS_INPUT_SOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getGcsInputSource().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for importing an AdaptiveMt file along with its sentences.
   * </pre>
   *
   * Protobuf type {@code google.cloud.translation.v3.ImportAdaptiveMtFileRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.translation.v3.ImportAdaptiveMtFileRequest)
      com.google.cloud.translate.v3.ImportAdaptiveMtFileRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.translate.v3.AdaptiveMtProto
          .internal_static_google_cloud_translation_v3_ImportAdaptiveMtFileRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.translate.v3.AdaptiveMtProto
          .internal_static_google_cloud_translation_v3_ImportAdaptiveMtFileRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest.class,
              com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest.Builder.class);
    }

    // Construct using com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      if (fileInputSourceBuilder_ != null) {
        fileInputSourceBuilder_.clear();
      }
      if (gcsInputSourceBuilder_ != null) {
        gcsInputSourceBuilder_.clear();
      }
      sourceCase_ = 0;
      source_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.translate.v3.AdaptiveMtProto
          .internal_static_google_cloud_translation_v3_ImportAdaptiveMtFileRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest getDefaultInstanceForType() {
      return com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest build() {
      com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest buildPartial() {
      com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest result =
          new com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest result) {
      result.sourceCase_ = sourceCase_;
      result.source_ = this.source_;
      if (sourceCase_ == 2 && fileInputSourceBuilder_ != null) {
        result.source_ = fileInputSourceBuilder_.build();
      }
      if (sourceCase_ == 3 && gcsInputSourceBuilder_ != null) {
        result.source_ = gcsInputSourceBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest) {
        return mergeFrom((com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest other) {
      if (other == com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      switch (other.getSourceCase()) {
        case FILE_INPUT_SOURCE:
          {
            mergeFileInputSource(other.getFileInputSource());
            break;
          }
        case GCS_INPUT_SOURCE:
          {
            mergeGcsInputSource(other.getGcsInputSource());
            break;
          }
        case SOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getFileInputSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getGcsInputSourceFieldBuilder().getBuilder(), extensionRegistry);
                sourceCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int sourceCase_ = 0;
    private java.lang.Object source_;

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public Builder clearSource() {
      sourceCase_ = 0;
      source_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of the file, in form of
     * `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets/{dataset}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the file, in form of
     * `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets/{dataset}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the file, in form of
     * `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets/{dataset}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the file, in form of
     * `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets/{dataset}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of the file, in form of
     * `projects/{project-number-or-id}/locations/{location_id}/adaptiveMtDatasets/{dataset}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3.FileInputSource,
            com.google.cloud.translate.v3.FileInputSource.Builder,
            com.google.cloud.translate.v3.FileInputSourceOrBuilder>
        fileInputSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Inline file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.FileInputSource file_input_source = 2;</code>
     *
     * @return Whether the fileInputSource field is set.
     */
    @java.lang.Override
    public boolean hasFileInputSource() {
      return sourceCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Inline file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.FileInputSource file_input_source = 2;</code>
     *
     * @return The fileInputSource.
     */
    @java.lang.Override
    public com.google.cloud.translate.v3.FileInputSource getFileInputSource() {
      if (fileInputSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          return (com.google.cloud.translate.v3.FileInputSource) source_;
        }
        return com.google.cloud.translate.v3.FileInputSource.getDefaultInstance();
      } else {
        if (sourceCase_ == 2) {
          return fileInputSourceBuilder_.getMessage();
        }
        return com.google.cloud.translate.v3.FileInputSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Inline file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.FileInputSource file_input_source = 2;</code>
     */
    public Builder setFileInputSource(com.google.cloud.translate.v3.FileInputSource value) {
      if (fileInputSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        fileInputSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inline file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.FileInputSource file_input_source = 2;</code>
     */
    public Builder setFileInputSource(
        com.google.cloud.translate.v3.FileInputSource.Builder builderForValue) {
      if (fileInputSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        fileInputSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inline file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.FileInputSource file_input_source = 2;</code>
     */
    public Builder mergeFileInputSource(com.google.cloud.translate.v3.FileInputSource value) {
      if (fileInputSourceBuilder_ == null) {
        if (sourceCase_ == 2
            && source_ != com.google.cloud.translate.v3.FileInputSource.getDefaultInstance()) {
          source_ =
              com.google.cloud.translate.v3.FileInputSource.newBuilder(
                      (com.google.cloud.translate.v3.FileInputSource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 2) {
          fileInputSourceBuilder_.mergeFrom(value);
        } else {
          fileInputSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inline file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.FileInputSource file_input_source = 2;</code>
     */
    public Builder clearFileInputSource() {
      if (fileInputSourceBuilder_ == null) {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 2) {
          sourceCase_ = 0;
          source_ = null;
        }
        fileInputSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Inline file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.FileInputSource file_input_source = 2;</code>
     */
    public com.google.cloud.translate.v3.FileInputSource.Builder getFileInputSourceBuilder() {
      return getFileInputSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Inline file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.FileInputSource file_input_source = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.translate.v3.FileInputSourceOrBuilder getFileInputSourceOrBuilder() {
      if ((sourceCase_ == 2) && (fileInputSourceBuilder_ != null)) {
        return fileInputSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 2) {
          return (com.google.cloud.translate.v3.FileInputSource) source_;
        }
        return com.google.cloud.translate.v3.FileInputSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Inline file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.FileInputSource file_input_source = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3.FileInputSource,
            com.google.cloud.translate.v3.FileInputSource.Builder,
            com.google.cloud.translate.v3.FileInputSourceOrBuilder>
        getFileInputSourceFieldBuilder() {
      if (fileInputSourceBuilder_ == null) {
        if (!(sourceCase_ == 2)) {
          source_ = com.google.cloud.translate.v3.FileInputSource.getDefaultInstance();
        }
        fileInputSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.translate.v3.FileInputSource,
                com.google.cloud.translate.v3.FileInputSource.Builder,
                com.google.cloud.translate.v3.FileInputSourceOrBuilder>(
                (com.google.cloud.translate.v3.FileInputSource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 2;
      onChanged();
      return fileInputSourceBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3.GcsInputSource,
            com.google.cloud.translate.v3.GcsInputSource.Builder,
            com.google.cloud.translate.v3.GcsInputSourceOrBuilder>
        gcsInputSourceBuilder_;
    /**
     *
     *
     * <pre>
     * Google Cloud Storage file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.GcsInputSource gcs_input_source = 3;</code>
     *
     * @return Whether the gcsInputSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsInputSource() {
      return sourceCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.GcsInputSource gcs_input_source = 3;</code>
     *
     * @return The gcsInputSource.
     */
    @java.lang.Override
    public com.google.cloud.translate.v3.GcsInputSource getGcsInputSource() {
      if (gcsInputSourceBuilder_ == null) {
        if (sourceCase_ == 3) {
          return (com.google.cloud.translate.v3.GcsInputSource) source_;
        }
        return com.google.cloud.translate.v3.GcsInputSource.getDefaultInstance();
      } else {
        if (sourceCase_ == 3) {
          return gcsInputSourceBuilder_.getMessage();
        }
        return com.google.cloud.translate.v3.GcsInputSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.GcsInputSource gcs_input_source = 3;</code>
     */
    public Builder setGcsInputSource(com.google.cloud.translate.v3.GcsInputSource value) {
      if (gcsInputSourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        source_ = value;
        onChanged();
      } else {
        gcsInputSourceBuilder_.setMessage(value);
      }
      sourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.GcsInputSource gcs_input_source = 3;</code>
     */
    public Builder setGcsInputSource(
        com.google.cloud.translate.v3.GcsInputSource.Builder builderForValue) {
      if (gcsInputSourceBuilder_ == null) {
        source_ = builderForValue.build();
        onChanged();
      } else {
        gcsInputSourceBuilder_.setMessage(builderForValue.build());
      }
      sourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.GcsInputSource gcs_input_source = 3;</code>
     */
    public Builder mergeGcsInputSource(com.google.cloud.translate.v3.GcsInputSource value) {
      if (gcsInputSourceBuilder_ == null) {
        if (sourceCase_ == 3
            && source_ != com.google.cloud.translate.v3.GcsInputSource.getDefaultInstance()) {
          source_ =
              com.google.cloud.translate.v3.GcsInputSource.newBuilder(
                      (com.google.cloud.translate.v3.GcsInputSource) source_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          source_ = value;
        }
        onChanged();
      } else {
        if (sourceCase_ == 3) {
          gcsInputSourceBuilder_.mergeFrom(value);
        } else {
          gcsInputSourceBuilder_.setMessage(value);
        }
      }
      sourceCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.GcsInputSource gcs_input_source = 3;</code>
     */
    public Builder clearGcsInputSource() {
      if (gcsInputSourceBuilder_ == null) {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
          onChanged();
        }
      } else {
        if (sourceCase_ == 3) {
          sourceCase_ = 0;
          source_ = null;
        }
        gcsInputSourceBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.GcsInputSource gcs_input_source = 3;</code>
     */
    public com.google.cloud.translate.v3.GcsInputSource.Builder getGcsInputSourceBuilder() {
      return getGcsInputSourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.GcsInputSource gcs_input_source = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.translate.v3.GcsInputSourceOrBuilder getGcsInputSourceOrBuilder() {
      if ((sourceCase_ == 3) && (gcsInputSourceBuilder_ != null)) {
        return gcsInputSourceBuilder_.getMessageOrBuilder();
      } else {
        if (sourceCase_ == 3) {
          return (com.google.cloud.translate.v3.GcsInputSource) source_;
        }
        return com.google.cloud.translate.v3.GcsInputSource.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Google Cloud Storage file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.GcsInputSource gcs_input_source = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3.GcsInputSource,
            com.google.cloud.translate.v3.GcsInputSource.Builder,
            com.google.cloud.translate.v3.GcsInputSourceOrBuilder>
        getGcsInputSourceFieldBuilder() {
      if (gcsInputSourceBuilder_ == null) {
        if (!(sourceCase_ == 3)) {
          source_ = com.google.cloud.translate.v3.GcsInputSource.getDefaultInstance();
        }
        gcsInputSourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.translate.v3.GcsInputSource,
                com.google.cloud.translate.v3.GcsInputSource.Builder,
                com.google.cloud.translate.v3.GcsInputSourceOrBuilder>(
                (com.google.cloud.translate.v3.GcsInputSource) source_,
                getParentForChildren(),
                isClean());
        source_ = null;
      }
      sourceCase_ = 3;
      onChanged();
      return gcsInputSourceBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.translation.v3.ImportAdaptiveMtFileRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.translation.v3.ImportAdaptiveMtFileRequest)
  private static final com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest();
  }

  public static com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportAdaptiveMtFileRequest> PARSER =
      new com.google.protobuf.AbstractParser<ImportAdaptiveMtFileRequest>() {
        @java.lang.Override
        public ImportAdaptiveMtFileRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ImportAdaptiveMtFileRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportAdaptiveMtFileRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.translate.v3.ImportAdaptiveMtFileRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
