/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/translate/v3/adaptive_mt.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.translate.v3;

/**
 *
 *
 * <pre>
 * The response for listing all AdaptiveMt files under a given dataset.
 * </pre>
 *
 * Protobuf type {@code google.cloud.translation.v3.ListAdaptiveMtFilesResponse}
 */
public final class ListAdaptiveMtFilesResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.translation.v3.ListAdaptiveMtFilesResponse)
    ListAdaptiveMtFilesResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ListAdaptiveMtFilesResponse.newBuilder() to construct.
  private ListAdaptiveMtFilesResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ListAdaptiveMtFilesResponse() {
    adaptiveMtFiles_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ListAdaptiveMtFilesResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.translate.v3.AdaptiveMtProto
        .internal_static_google_cloud_translation_v3_ListAdaptiveMtFilesResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.translate.v3.AdaptiveMtProto
        .internal_static_google_cloud_translation_v3_ListAdaptiveMtFilesResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse.class,
            com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse.Builder.class);
  }

  public static final int ADAPTIVE_MT_FILES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.translate.v3.AdaptiveMtFile> adaptiveMtFiles_;
  /**
   *
   *
   * <pre>
   * Output only. The Adaptive MT files.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.translate.v3.AdaptiveMtFile> getAdaptiveMtFilesList() {
    return adaptiveMtFiles_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The Adaptive MT files.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.translate.v3.AdaptiveMtFileOrBuilder>
      getAdaptiveMtFilesOrBuilderList() {
    return adaptiveMtFiles_;
  }
  /**
   *
   *
   * <pre>
   * Output only. The Adaptive MT files.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public int getAdaptiveMtFilesCount() {
    return adaptiveMtFiles_.size();
  }
  /**
   *
   *
   * <pre>
   * Output only. The Adaptive MT files.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3.AdaptiveMtFile getAdaptiveMtFiles(int index) {
    return adaptiveMtFiles_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Output only. The Adaptive MT files.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3.AdaptiveMtFileOrBuilder getAdaptiveMtFilesOrBuilder(
      int index) {
    return adaptiveMtFiles_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";
  /**
   *
   *
   * <pre>
   * Optional. A token to retrieve a page of results. Pass this value in the
   * ListAdaptiveMtFilesRequest.page_token field in the subsequent call to
   * `ListAdaptiveMtFiles` method to retrieve the next page of results.
   * </pre>
   *
   * <code>string next_page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Optional. A token to retrieve a page of results. Pass this value in the
   * ListAdaptiveMtFilesRequest.page_token field in the subsequent call to
   * `ListAdaptiveMtFiles` method to retrieve the next page of results.
   * </pre>
   *
   * <code>string next_page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < adaptiveMtFiles_.size(); i++) {
      output.writeMessage(1, adaptiveMtFiles_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, nextPageToken_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < adaptiveMtFiles_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, adaptiveMtFiles_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, nextPageToken_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse other =
        (com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse) obj;

    if (!getAdaptiveMtFilesList().equals(other.getAdaptiveMtFilesList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getAdaptiveMtFilesCount() > 0) {
      hash = (37 * hash) + ADAPTIVE_MT_FILES_FIELD_NUMBER;
      hash = (53 * hash) + getAdaptiveMtFilesList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The response for listing all AdaptiveMt files under a given dataset.
   * </pre>
   *
   * Protobuf type {@code google.cloud.translation.v3.ListAdaptiveMtFilesResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.translation.v3.ListAdaptiveMtFilesResponse)
      com.google.cloud.translate.v3.ListAdaptiveMtFilesResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.translate.v3.AdaptiveMtProto
          .internal_static_google_cloud_translation_v3_ListAdaptiveMtFilesResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.translate.v3.AdaptiveMtProto
          .internal_static_google_cloud_translation_v3_ListAdaptiveMtFilesResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse.class,
              com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse.Builder.class);
    }

    // Construct using com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (adaptiveMtFilesBuilder_ == null) {
        adaptiveMtFiles_ = java.util.Collections.emptyList();
      } else {
        adaptiveMtFiles_ = null;
        adaptiveMtFilesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.translate.v3.AdaptiveMtProto
          .internal_static_google_cloud_translation_v3_ListAdaptiveMtFilesResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse getDefaultInstanceForType() {
      return com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse build() {
      com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse buildPartial() {
      com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse result =
          new com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse result) {
      if (adaptiveMtFilesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          adaptiveMtFiles_ = java.util.Collections.unmodifiableList(adaptiveMtFiles_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.adaptiveMtFiles_ = adaptiveMtFiles_;
      } else {
        result.adaptiveMtFiles_ = adaptiveMtFilesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse) {
        return mergeFrom((com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse other) {
      if (other == com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse.getDefaultInstance())
        return this;
      if (adaptiveMtFilesBuilder_ == null) {
        if (!other.adaptiveMtFiles_.isEmpty()) {
          if (adaptiveMtFiles_.isEmpty()) {
            adaptiveMtFiles_ = other.adaptiveMtFiles_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureAdaptiveMtFilesIsMutable();
            adaptiveMtFiles_.addAll(other.adaptiveMtFiles_);
          }
          onChanged();
        }
      } else {
        if (!other.adaptiveMtFiles_.isEmpty()) {
          if (adaptiveMtFilesBuilder_.isEmpty()) {
            adaptiveMtFilesBuilder_.dispose();
            adaptiveMtFilesBuilder_ = null;
            adaptiveMtFiles_ = other.adaptiveMtFiles_;
            bitField0_ = (bitField0_ & ~0x00000001);
            adaptiveMtFilesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAdaptiveMtFilesFieldBuilder()
                    : null;
          } else {
            adaptiveMtFilesBuilder_.addAllMessages(other.adaptiveMtFiles_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.translate.v3.AdaptiveMtFile m =
                    input.readMessage(
                        com.google.cloud.translate.v3.AdaptiveMtFile.parser(), extensionRegistry);
                if (adaptiveMtFilesBuilder_ == null) {
                  ensureAdaptiveMtFilesIsMutable();
                  adaptiveMtFiles_.add(m);
                } else {
                  adaptiveMtFilesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 26:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.translate.v3.AdaptiveMtFile> adaptiveMtFiles_ =
        java.util.Collections.emptyList();

    private void ensureAdaptiveMtFilesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        adaptiveMtFiles_ =
            new java.util.ArrayList<com.google.cloud.translate.v3.AdaptiveMtFile>(adaptiveMtFiles_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.translate.v3.AdaptiveMtFile,
            com.google.cloud.translate.v3.AdaptiveMtFile.Builder,
            com.google.cloud.translate.v3.AdaptiveMtFileOrBuilder>
        adaptiveMtFilesBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. The Adaptive MT files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.translate.v3.AdaptiveMtFile> getAdaptiveMtFilesList() {
      if (adaptiveMtFilesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(adaptiveMtFiles_);
      } else {
        return adaptiveMtFilesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Adaptive MT files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public int getAdaptiveMtFilesCount() {
      if (adaptiveMtFilesBuilder_ == null) {
        return adaptiveMtFiles_.size();
      } else {
        return adaptiveMtFilesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Adaptive MT files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.translate.v3.AdaptiveMtFile getAdaptiveMtFiles(int index) {
      if (adaptiveMtFilesBuilder_ == null) {
        return adaptiveMtFiles_.get(index);
      } else {
        return adaptiveMtFilesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Adaptive MT files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAdaptiveMtFiles(
        int index, com.google.cloud.translate.v3.AdaptiveMtFile value) {
      if (adaptiveMtFilesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdaptiveMtFilesIsMutable();
        adaptiveMtFiles_.set(index, value);
        onChanged();
      } else {
        adaptiveMtFilesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Adaptive MT files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setAdaptiveMtFiles(
        int index, com.google.cloud.translate.v3.AdaptiveMtFile.Builder builderForValue) {
      if (adaptiveMtFilesBuilder_ == null) {
        ensureAdaptiveMtFilesIsMutable();
        adaptiveMtFiles_.set(index, builderForValue.build());
        onChanged();
      } else {
        adaptiveMtFilesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Adaptive MT files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAdaptiveMtFiles(com.google.cloud.translate.v3.AdaptiveMtFile value) {
      if (adaptiveMtFilesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdaptiveMtFilesIsMutable();
        adaptiveMtFiles_.add(value);
        onChanged();
      } else {
        adaptiveMtFilesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Adaptive MT files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAdaptiveMtFiles(
        int index, com.google.cloud.translate.v3.AdaptiveMtFile value) {
      if (adaptiveMtFilesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAdaptiveMtFilesIsMutable();
        adaptiveMtFiles_.add(index, value);
        onChanged();
      } else {
        adaptiveMtFilesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Adaptive MT files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAdaptiveMtFiles(
        com.google.cloud.translate.v3.AdaptiveMtFile.Builder builderForValue) {
      if (adaptiveMtFilesBuilder_ == null) {
        ensureAdaptiveMtFilesIsMutable();
        adaptiveMtFiles_.add(builderForValue.build());
        onChanged();
      } else {
        adaptiveMtFilesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Adaptive MT files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAdaptiveMtFiles(
        int index, com.google.cloud.translate.v3.AdaptiveMtFile.Builder builderForValue) {
      if (adaptiveMtFilesBuilder_ == null) {
        ensureAdaptiveMtFilesIsMutable();
        adaptiveMtFiles_.add(index, builderForValue.build());
        onChanged();
      } else {
        adaptiveMtFilesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Adaptive MT files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder addAllAdaptiveMtFiles(
        java.lang.Iterable<? extends com.google.cloud.translate.v3.AdaptiveMtFile> values) {
      if (adaptiveMtFilesBuilder_ == null) {
        ensureAdaptiveMtFilesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, adaptiveMtFiles_);
        onChanged();
      } else {
        adaptiveMtFilesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Adaptive MT files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearAdaptiveMtFiles() {
      if (adaptiveMtFilesBuilder_ == null) {
        adaptiveMtFiles_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        adaptiveMtFilesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Adaptive MT files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder removeAdaptiveMtFiles(int index) {
      if (adaptiveMtFilesBuilder_ == null) {
        ensureAdaptiveMtFilesIsMutable();
        adaptiveMtFiles_.remove(index);
        onChanged();
      } else {
        adaptiveMtFilesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Output only. The Adaptive MT files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.translate.v3.AdaptiveMtFile.Builder getAdaptiveMtFilesBuilder(
        int index) {
      return getAdaptiveMtFilesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Output only. The Adaptive MT files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.translate.v3.AdaptiveMtFileOrBuilder getAdaptiveMtFilesOrBuilder(
        int index) {
      if (adaptiveMtFilesBuilder_ == null) {
        return adaptiveMtFiles_.get(index);
      } else {
        return adaptiveMtFilesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Adaptive MT files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.translate.v3.AdaptiveMtFileOrBuilder>
        getAdaptiveMtFilesOrBuilderList() {
      if (adaptiveMtFilesBuilder_ != null) {
        return adaptiveMtFilesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(adaptiveMtFiles_);
      }
    }
    /**
     *
     *
     * <pre>
     * Output only. The Adaptive MT files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.translate.v3.AdaptiveMtFile.Builder addAdaptiveMtFilesBuilder() {
      return getAdaptiveMtFilesFieldBuilder()
          .addBuilder(com.google.cloud.translate.v3.AdaptiveMtFile.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The Adaptive MT files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.translate.v3.AdaptiveMtFile.Builder addAdaptiveMtFilesBuilder(
        int index) {
      return getAdaptiveMtFilesFieldBuilder()
          .addBuilder(index, com.google.cloud.translate.v3.AdaptiveMtFile.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Output only. The Adaptive MT files.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtFile adaptive_mt_files = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public java.util.List<com.google.cloud.translate.v3.AdaptiveMtFile.Builder>
        getAdaptiveMtFilesBuilderList() {
      return getAdaptiveMtFilesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.translate.v3.AdaptiveMtFile,
            com.google.cloud.translate.v3.AdaptiveMtFile.Builder,
            com.google.cloud.translate.v3.AdaptiveMtFileOrBuilder>
        getAdaptiveMtFilesFieldBuilder() {
      if (adaptiveMtFilesBuilder_ == null) {
        adaptiveMtFilesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.translate.v3.AdaptiveMtFile,
                com.google.cloud.translate.v3.AdaptiveMtFile.Builder,
                com.google.cloud.translate.v3.AdaptiveMtFileOrBuilder>(
                adaptiveMtFiles_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        adaptiveMtFiles_ = null;
      }
      return adaptiveMtFilesBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";
    /**
     *
     *
     * <pre>
     * Optional. A token to retrieve a page of results. Pass this value in the
     * ListAdaptiveMtFilesRequest.page_token field in the subsequent call to
     * `ListAdaptiveMtFiles` method to retrieve the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A token to retrieve a page of results. Pass this value in the
     * ListAdaptiveMtFilesRequest.page_token field in the subsequent call to
     * `ListAdaptiveMtFiles` method to retrieve the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. A token to retrieve a page of results. Pass this value in the
     * ListAdaptiveMtFilesRequest.page_token field in the subsequent call to
     * `ListAdaptiveMtFiles` method to retrieve the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A token to retrieve a page of results. Pass this value in the
     * ListAdaptiveMtFilesRequest.page_token field in the subsequent call to
     * `ListAdaptiveMtFiles` method to retrieve the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. A token to retrieve a page of results. Pass this value in the
     * ListAdaptiveMtFilesRequest.page_token field in the subsequent call to
     * `ListAdaptiveMtFiles` method to retrieve the next page of results.
     * </pre>
     *
     * <code>string next_page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.translation.v3.ListAdaptiveMtFilesResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.translation.v3.ListAdaptiveMtFilesResponse)
  private static final com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse();
  }

  public static com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ListAdaptiveMtFilesResponse> PARSER =
      new com.google.protobuf.AbstractParser<ListAdaptiveMtFilesResponse>() {
        @java.lang.Override
        public ListAdaptiveMtFilesResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ListAdaptiveMtFilesResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ListAdaptiveMtFilesResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.translate.v3.ListAdaptiveMtFilesResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
