/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/translate/v3/adaptive_mt.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.translate.v3;

/**
 *
 *
 * <pre>
 * The request for sending an AdaptiveMt translation query.
 * </pre>
 *
 * Protobuf type {@code google.cloud.translation.v3.AdaptiveMtTranslateRequest}
 */
public final class AdaptiveMtTranslateRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.translation.v3.AdaptiveMtTranslateRequest)
    AdaptiveMtTranslateRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use AdaptiveMtTranslateRequest.newBuilder() to construct.
  private AdaptiveMtTranslateRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AdaptiveMtTranslateRequest() {
    parent_ = "";
    dataset_ = "";
    content_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AdaptiveMtTranslateRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.translate.v3.AdaptiveMtProto
        .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.translate.v3.AdaptiveMtProto
        .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.class,
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.Builder.class);
  }

  public interface ReferenceSentencePairOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Source sentence in the sentence pair.
     * </pre>
     *
     * <code>string source_sentence = 1;</code>
     *
     * @return The sourceSentence.
     */
    java.lang.String getSourceSentence();

    /**
     *
     *
     * <pre>
     * Source sentence in the sentence pair.
     * </pre>
     *
     * <code>string source_sentence = 1;</code>
     *
     * @return The bytes for sourceSentence.
     */
    com.google.protobuf.ByteString getSourceSentenceBytes();

    /**
     *
     *
     * <pre>
     * Target sentence in the sentence pair.
     * </pre>
     *
     * <code>string target_sentence = 2;</code>
     *
     * @return The targetSentence.
     */
    java.lang.String getTargetSentence();

    /**
     *
     *
     * <pre>
     * Target sentence in the sentence pair.
     * </pre>
     *
     * <code>string target_sentence = 2;</code>
     *
     * @return The bytes for targetSentence.
     */
    com.google.protobuf.ByteString getTargetSentenceBytes();
  }

  /**
   *
   *
   * <pre>
   * A pair of sentences used as reference in source and target languages.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair}
   */
  public static final class ReferenceSentencePair extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair)
      ReferenceSentencePairOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ReferenceSentencePair.newBuilder() to construct.
    private ReferenceSentencePair(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReferenceSentencePair() {
      sourceSentence_ = "";
      targetSentence_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ReferenceSentencePair();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.translate.v3.AdaptiveMtProto
          .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_ReferenceSentencePair_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.translate.v3.AdaptiveMtProto
          .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_ReferenceSentencePair_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair.class,
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair.Builder
                  .class);
    }

    public static final int SOURCE_SENTENCE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object sourceSentence_ = "";

    /**
     *
     *
     * <pre>
     * Source sentence in the sentence pair.
     * </pre>
     *
     * <code>string source_sentence = 1;</code>
     *
     * @return The sourceSentence.
     */
    @java.lang.Override
    public java.lang.String getSourceSentence() {
      java.lang.Object ref = sourceSentence_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceSentence_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Source sentence in the sentence pair.
     * </pre>
     *
     * <code>string source_sentence = 1;</code>
     *
     * @return The bytes for sourceSentence.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSourceSentenceBytes() {
      java.lang.Object ref = sourceSentence_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceSentence_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TARGET_SENTENCE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object targetSentence_ = "";

    /**
     *
     *
     * <pre>
     * Target sentence in the sentence pair.
     * </pre>
     *
     * <code>string target_sentence = 2;</code>
     *
     * @return The targetSentence.
     */
    @java.lang.Override
    public java.lang.String getTargetSentence() {
      java.lang.Object ref = targetSentence_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetSentence_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Target sentence in the sentence pair.
     * </pre>
     *
     * <code>string target_sentence = 2;</code>
     *
     * @return The bytes for targetSentence.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTargetSentenceBytes() {
      java.lang.Object ref = targetSentence_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetSentence_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceSentence_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, sourceSentence_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetSentence_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, targetSentence_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceSentence_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, sourceSentence_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetSentence_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, targetSentence_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair)) {
        return super.equals(obj);
      }
      com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair other =
          (com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair) obj;

      if (!getSourceSentence().equals(other.getSourceSentence())) return false;
      if (!getTargetSentence().equals(other.getTargetSentence())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SOURCE_SENTENCE_FIELD_NUMBER;
      hash = (53 * hash) + getSourceSentence().hashCode();
      hash = (37 * hash) + TARGET_SENTENCE_FIELD_NUMBER;
      hash = (53 * hash) + getTargetSentence().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A pair of sentences used as reference in source and target languages.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair)
        com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.translate.v3.AdaptiveMtProto
            .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_ReferenceSentencePair_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.translate.v3.AdaptiveMtProto
            .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_ReferenceSentencePair_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
                    .class,
                com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        sourceSentence_ = "";
        targetSentence_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.translate.v3.AdaptiveMtProto
            .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_ReferenceSentencePair_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
          getDefaultInstanceForType() {
        return com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
          build() {
        com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
          buildPartial() {
        com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair result =
            new com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.sourceSentence_ = sourceSentence_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.targetSentence_ = targetSentence_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair) {
          return mergeFrom(
              (com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair other) {
        if (other
            == com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
                .getDefaultInstance()) return this;
        if (!other.getSourceSentence().isEmpty()) {
          sourceSentence_ = other.sourceSentence_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getTargetSentence().isEmpty()) {
          targetSentence_ = other.targetSentence_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  sourceSentence_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  targetSentence_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object sourceSentence_ = "";

      /**
       *
       *
       * <pre>
       * Source sentence in the sentence pair.
       * </pre>
       *
       * <code>string source_sentence = 1;</code>
       *
       * @return The sourceSentence.
       */
      public java.lang.String getSourceSentence() {
        java.lang.Object ref = sourceSentence_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sourceSentence_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Source sentence in the sentence pair.
       * </pre>
       *
       * <code>string source_sentence = 1;</code>
       *
       * @return The bytes for sourceSentence.
       */
      public com.google.protobuf.ByteString getSourceSentenceBytes() {
        java.lang.Object ref = sourceSentence_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          sourceSentence_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Source sentence in the sentence pair.
       * </pre>
       *
       * <code>string source_sentence = 1;</code>
       *
       * @param value The sourceSentence to set.
       * @return This builder for chaining.
       */
      public Builder setSourceSentence(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceSentence_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Source sentence in the sentence pair.
       * </pre>
       *
       * <code>string source_sentence = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSourceSentence() {
        sourceSentence_ = getDefaultInstance().getSourceSentence();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Source sentence in the sentence pair.
       * </pre>
       *
       * <code>string source_sentence = 1;</code>
       *
       * @param value The bytes for sourceSentence to set.
       * @return This builder for chaining.
       */
      public Builder setSourceSentenceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        sourceSentence_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object targetSentence_ = "";

      /**
       *
       *
       * <pre>
       * Target sentence in the sentence pair.
       * </pre>
       *
       * <code>string target_sentence = 2;</code>
       *
       * @return The targetSentence.
       */
      public java.lang.String getTargetSentence() {
        java.lang.Object ref = targetSentence_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          targetSentence_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Target sentence in the sentence pair.
       * </pre>
       *
       * <code>string target_sentence = 2;</code>
       *
       * @return The bytes for targetSentence.
       */
      public com.google.protobuf.ByteString getTargetSentenceBytes() {
        java.lang.Object ref = targetSentence_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          targetSentence_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Target sentence in the sentence pair.
       * </pre>
       *
       * <code>string target_sentence = 2;</code>
       *
       * @param value The targetSentence to set.
       * @return This builder for chaining.
       */
      public Builder setTargetSentence(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        targetSentence_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Target sentence in the sentence pair.
       * </pre>
       *
       * <code>string target_sentence = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTargetSentence() {
        targetSentence_ = getDefaultInstance().getTargetSentence();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Target sentence in the sentence pair.
       * </pre>
       *
       * <code>string target_sentence = 2;</code>
       *
       * @param value The bytes for targetSentence to set.
       * @return This builder for chaining.
       */
      public Builder setTargetSentenceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        targetSentence_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair)
    private static final com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
            .ReferenceSentencePair
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair();
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ReferenceSentencePair> PARSER =
        new com.google.protobuf.AbstractParser<ReferenceSentencePair>() {
          @java.lang.Override
          public ReferenceSentencePair parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ReferenceSentencePair> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReferenceSentencePair> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ReferenceSentencePairListOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Reference sentence pairs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
     * </code>
     */
    java.util.List<com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair>
        getReferenceSentencePairsList();

    /**
     *
     *
     * <pre>
     * Reference sentence pairs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
     * </code>
     */
    com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
        getReferenceSentencePairs(int index);

    /**
     *
     *
     * <pre>
     * Reference sentence pairs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
     * </code>
     */
    int getReferenceSentencePairsCount();

    /**
     *
     *
     * <pre>
     * Reference sentence pairs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
                    .ReferenceSentencePairOrBuilder>
        getReferenceSentencePairsOrBuilderList();

    /**
     *
     *
     * <pre>
     * Reference sentence pairs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
     * </code>
     */
    com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairOrBuilder
        getReferenceSentencePairsOrBuilder(int index);
  }

  /**
   *
   *
   * <pre>
   * A list of reference sentence pairs.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList}
   */
  public static final class ReferenceSentencePairList extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList)
      ReferenceSentencePairListOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ReferenceSentencePairList.newBuilder() to construct.
    private ReferenceSentencePairList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReferenceSentencePairList() {
      referenceSentencePairs_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ReferenceSentencePairList();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.translate.v3.AdaptiveMtProto
          .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_ReferenceSentencePairList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.translate.v3.AdaptiveMtProto
          .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_ReferenceSentencePairList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
                  .class,
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
                  .Builder.class);
    }

    public static final int REFERENCE_SENTENCE_PAIRS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair>
        referenceSentencePairs_;

    /**
     *
     *
     * <pre>
     * Reference sentence pairs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair>
        getReferenceSentencePairsList() {
      return referenceSentencePairs_;
    }

    /**
     *
     *
     * <pre>
     * Reference sentence pairs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
                    .ReferenceSentencePairOrBuilder>
        getReferenceSentencePairsOrBuilderList() {
      return referenceSentencePairs_;
    }

    /**
     *
     *
     * <pre>
     * Reference sentence pairs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
     * </code>
     */
    @java.lang.Override
    public int getReferenceSentencePairsCount() {
      return referenceSentencePairs_.size();
    }

    /**
     *
     *
     * <pre>
     * Reference sentence pairs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
        getReferenceSentencePairs(int index) {
      return referenceSentencePairs_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Reference sentence pairs.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairOrBuilder
        getReferenceSentencePairsOrBuilder(int index) {
      return referenceSentencePairs_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < referenceSentencePairs_.size(); i++) {
        output.writeMessage(1, referenceSentencePairs_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < referenceSentencePairs_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, referenceSentencePairs_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList)) {
        return super.equals(obj);
      }
      com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList other =
          (com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList) obj;

      if (!getReferenceSentencePairsList().equals(other.getReferenceSentencePairsList()))
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getReferenceSentencePairsCount() > 0) {
        hash = (37 * hash) + REFERENCE_SENTENCE_PAIRS_FIELD_NUMBER;
        hash = (53 * hash) + getReferenceSentencePairsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A list of reference sentence pairs.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList)
        com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
            .ReferenceSentencePairListOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.translate.v3.AdaptiveMtProto
            .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_ReferenceSentencePairList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.translate.v3.AdaptiveMtProto
            .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_ReferenceSentencePairList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
                    .class,
                com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (referenceSentencePairsBuilder_ == null) {
          referenceSentencePairs_ = java.util.Collections.emptyList();
        } else {
          referenceSentencePairs_ = null;
          referenceSentencePairsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.translate.v3.AdaptiveMtProto
            .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_ReferenceSentencePairList_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
          getDefaultInstanceForType() {
        return com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
          build() {
        com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
          buildPartial() {
        com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList result =
            new com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList(
                this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
              result) {
        if (referenceSentencePairsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            referenceSentencePairs_ =
                java.util.Collections.unmodifiableList(referenceSentencePairs_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.referenceSentencePairs_ = referenceSentencePairs_;
        } else {
          result.referenceSentencePairs_ = referenceSentencePairsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
              result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList) {
          return mergeFrom(
              (com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
              other) {
        if (other
            == com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
                .getDefaultInstance()) return this;
        if (referenceSentencePairsBuilder_ == null) {
          if (!other.referenceSentencePairs_.isEmpty()) {
            if (referenceSentencePairs_.isEmpty()) {
              referenceSentencePairs_ = other.referenceSentencePairs_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureReferenceSentencePairsIsMutable();
              referenceSentencePairs_.addAll(other.referenceSentencePairs_);
            }
            onChanged();
          }
        } else {
          if (!other.referenceSentencePairs_.isEmpty()) {
            if (referenceSentencePairsBuilder_.isEmpty()) {
              referenceSentencePairsBuilder_.dispose();
              referenceSentencePairsBuilder_ = null;
              referenceSentencePairs_ = other.referenceSentencePairs_;
              bitField0_ = (bitField0_ & ~0x00000001);
              referenceSentencePairsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getReferenceSentencePairsFieldBuilder()
                      : null;
            } else {
              referenceSentencePairsBuilder_.addAllMessages(other.referenceSentencePairs_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair m =
                      input.readMessage(
                          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
                              .ReferenceSentencePair.parser(),
                          extensionRegistry);
                  if (referenceSentencePairsBuilder_ == null) {
                    ensureReferenceSentencePairsIsMutable();
                    referenceSentencePairs_.add(m);
                  } else {
                    referenceSentencePairsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair>
          referenceSentencePairs_ = java.util.Collections.emptyList();

      private void ensureReferenceSentencePairsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          referenceSentencePairs_ =
              new java.util.ArrayList<
                  com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair>(
                  referenceSentencePairs_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair,
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
                  .Builder,
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
                  .ReferenceSentencePairOrBuilder>
          referenceSentencePairsBuilder_;

      /**
       *
       *
       * <pre>
       * Reference sentence pairs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair>
          getReferenceSentencePairsList() {
        if (referenceSentencePairsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(referenceSentencePairs_);
        } else {
          return referenceSentencePairsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Reference sentence pairs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
       * </code>
       */
      public int getReferenceSentencePairsCount() {
        if (referenceSentencePairsBuilder_ == null) {
          return referenceSentencePairs_.size();
        } else {
          return referenceSentencePairsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Reference sentence pairs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
       * </code>
       */
      public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
          getReferenceSentencePairs(int index) {
        if (referenceSentencePairsBuilder_ == null) {
          return referenceSentencePairs_.get(index);
        } else {
          return referenceSentencePairsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Reference sentence pairs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
       * </code>
       */
      public Builder setReferenceSentencePairs(
          int index,
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair value) {
        if (referenceSentencePairsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureReferenceSentencePairsIsMutable();
          referenceSentencePairs_.set(index, value);
          onChanged();
        } else {
          referenceSentencePairsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Reference sentence pairs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
       * </code>
       */
      public Builder setReferenceSentencePairs(
          int index,
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair.Builder
              builderForValue) {
        if (referenceSentencePairsBuilder_ == null) {
          ensureReferenceSentencePairsIsMutable();
          referenceSentencePairs_.set(index, builderForValue.build());
          onChanged();
        } else {
          referenceSentencePairsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Reference sentence pairs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
       * </code>
       */
      public Builder addReferenceSentencePairs(
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair value) {
        if (referenceSentencePairsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureReferenceSentencePairsIsMutable();
          referenceSentencePairs_.add(value);
          onChanged();
        } else {
          referenceSentencePairsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Reference sentence pairs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
       * </code>
       */
      public Builder addReferenceSentencePairs(
          int index,
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair value) {
        if (referenceSentencePairsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureReferenceSentencePairsIsMutable();
          referenceSentencePairs_.add(index, value);
          onChanged();
        } else {
          referenceSentencePairsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Reference sentence pairs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
       * </code>
       */
      public Builder addReferenceSentencePairs(
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair.Builder
              builderForValue) {
        if (referenceSentencePairsBuilder_ == null) {
          ensureReferenceSentencePairsIsMutable();
          referenceSentencePairs_.add(builderForValue.build());
          onChanged();
        } else {
          referenceSentencePairsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Reference sentence pairs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
       * </code>
       */
      public Builder addReferenceSentencePairs(
          int index,
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair.Builder
              builderForValue) {
        if (referenceSentencePairsBuilder_ == null) {
          ensureReferenceSentencePairsIsMutable();
          referenceSentencePairs_.add(index, builderForValue.build());
          onChanged();
        } else {
          referenceSentencePairsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Reference sentence pairs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
       * </code>
       */
      public Builder addAllReferenceSentencePairs(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
                          .ReferenceSentencePair>
              values) {
        if (referenceSentencePairsBuilder_ == null) {
          ensureReferenceSentencePairsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, referenceSentencePairs_);
          onChanged();
        } else {
          referenceSentencePairsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Reference sentence pairs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
       * </code>
       */
      public Builder clearReferenceSentencePairs() {
        if (referenceSentencePairsBuilder_ == null) {
          referenceSentencePairs_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          referenceSentencePairsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Reference sentence pairs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
       * </code>
       */
      public Builder removeReferenceSentencePairs(int index) {
        if (referenceSentencePairsBuilder_ == null) {
          ensureReferenceSentencePairsIsMutable();
          referenceSentencePairs_.remove(index);
          onChanged();
        } else {
          referenceSentencePairsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Reference sentence pairs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
       * </code>
       */
      public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair.Builder
          getReferenceSentencePairsBuilder(int index) {
        return getReferenceSentencePairsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Reference sentence pairs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
       * </code>
       */
      public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairOrBuilder
          getReferenceSentencePairsOrBuilder(int index) {
        if (referenceSentencePairsBuilder_ == null) {
          return referenceSentencePairs_.get(index);
        } else {
          return referenceSentencePairsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Reference sentence pairs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
                      .ReferenceSentencePairOrBuilder>
          getReferenceSentencePairsOrBuilderList() {
        if (referenceSentencePairsBuilder_ != null) {
          return referenceSentencePairsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(referenceSentencePairs_);
        }
      }

      /**
       *
       *
       * <pre>
       * Reference sentence pairs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
       * </code>
       */
      public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair.Builder
          addReferenceSentencePairsBuilder() {
        return getReferenceSentencePairsFieldBuilder()
            .addBuilder(
                com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
                    .getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Reference sentence pairs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
       * </code>
       */
      public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair.Builder
          addReferenceSentencePairsBuilder(int index) {
        return getReferenceSentencePairsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
                    .getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Reference sentence pairs.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair reference_sentence_pairs = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
                  .Builder>
          getReferenceSentencePairsBuilderList() {
        return getReferenceSentencePairsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair,
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
                  .Builder,
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
                  .ReferenceSentencePairOrBuilder>
          getReferenceSentencePairsFieldBuilder() {
        if (referenceSentencePairsBuilder_ == null) {
          referenceSentencePairsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair,
                  com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePair
                      .Builder,
                  com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
                      .ReferenceSentencePairOrBuilder>(
                  referenceSentencePairs_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          referenceSentencePairs_ = null;
        }
        return referenceSentencePairsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList)
    private static final com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
            .ReferenceSentencePairList
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList();
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ReferenceSentencePairList> PARSER =
        new com.google.protobuf.AbstractParser<ReferenceSentencePairList>() {
          @java.lang.Override
          public ReferenceSentencePairList parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ReferenceSentencePairList> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReferenceSentencePairList> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ReferenceSentenceConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Reference sentences pair lists. Each list will be used as the references
     * to translate the sentence under "content" field at the corresponding
     * index. Length of the list is required to be equal to the length of
     * "content" field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
     * </code>
     */
    java.util.List<
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList>
        getReferenceSentencePairListsList();

    /**
     *
     *
     * <pre>
     * Reference sentences pair lists. Each list will be used as the references
     * to translate the sentence under "content" field at the corresponding
     * index. Length of the list is required to be equal to the length of
     * "content" field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
     * </code>
     */
    com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
        getReferenceSentencePairLists(int index);

    /**
     *
     *
     * <pre>
     * Reference sentences pair lists. Each list will be used as the references
     * to translate the sentence under "content" field at the corresponding
     * index. Length of the list is required to be equal to the length of
     * "content" field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
     * </code>
     */
    int getReferenceSentencePairListsCount();

    /**
     *
     *
     * <pre>
     * Reference sentences pair lists. Each list will be used as the references
     * to translate the sentence under "content" field at the corresponding
     * index. Length of the list is required to be equal to the length of
     * "content" field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
                    .ReferenceSentencePairListOrBuilder>
        getReferenceSentencePairListsOrBuilderList();

    /**
     *
     *
     * <pre>
     * Reference sentences pair lists. Each list will be used as the references
     * to translate the sentence under "content" field at the corresponding
     * index. Length of the list is required to be equal to the length of
     * "content" field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
     * </code>
     */
    com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairListOrBuilder
        getReferenceSentencePairListsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Source language code.
     * </pre>
     *
     * <code>string source_language_code = 2;</code>
     *
     * @return The sourceLanguageCode.
     */
    java.lang.String getSourceLanguageCode();

    /**
     *
     *
     * <pre>
     * Source language code.
     * </pre>
     *
     * <code>string source_language_code = 2;</code>
     *
     * @return The bytes for sourceLanguageCode.
     */
    com.google.protobuf.ByteString getSourceLanguageCodeBytes();

    /**
     *
     *
     * <pre>
     * Target language code.
     * </pre>
     *
     * <code>string target_language_code = 3;</code>
     *
     * @return The targetLanguageCode.
     */
    java.lang.String getTargetLanguageCode();

    /**
     *
     *
     * <pre>
     * Target language code.
     * </pre>
     *
     * <code>string target_language_code = 3;</code>
     *
     * @return The bytes for targetLanguageCode.
     */
    com.google.protobuf.ByteString getTargetLanguageCodeBytes();
  }

  /**
   *
   *
   * <pre>
   * Message of caller-provided reference configuration.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig}
   */
  public static final class ReferenceSentenceConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig)
      ReferenceSentenceConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ReferenceSentenceConfig.newBuilder() to construct.
    private ReferenceSentenceConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ReferenceSentenceConfig() {
      referenceSentencePairLists_ = java.util.Collections.emptyList();
      sourceLanguageCode_ = "";
      targetLanguageCode_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ReferenceSentenceConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.translate.v3.AdaptiveMtProto
          .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_ReferenceSentenceConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.translate.v3.AdaptiveMtProto
          .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_ReferenceSentenceConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
                  .class,
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
                  .Builder.class);
    }

    public static final int REFERENCE_SENTENCE_PAIR_LISTS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList>
        referenceSentencePairLists_;

    /**
     *
     *
     * <pre>
     * Reference sentences pair lists. Each list will be used as the references
     * to translate the sentence under "content" field at the corresponding
     * index. Length of the list is required to be equal to the length of
     * "content" field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList>
        getReferenceSentencePairListsList() {
      return referenceSentencePairLists_;
    }

    /**
     *
     *
     * <pre>
     * Reference sentences pair lists. Each list will be used as the references
     * to translate the sentence under "content" field at the corresponding
     * index. Length of the list is required to be equal to the length of
     * "content" field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
                    .ReferenceSentencePairListOrBuilder>
        getReferenceSentencePairListsOrBuilderList() {
      return referenceSentencePairLists_;
    }

    /**
     *
     *
     * <pre>
     * Reference sentences pair lists. Each list will be used as the references
     * to translate the sentence under "content" field at the corresponding
     * index. Length of the list is required to be equal to the length of
     * "content" field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
     * </code>
     */
    @java.lang.Override
    public int getReferenceSentencePairListsCount() {
      return referenceSentencePairLists_.size();
    }

    /**
     *
     *
     * <pre>
     * Reference sentences pair lists. Each list will be used as the references
     * to translate the sentence under "content" field at the corresponding
     * index. Length of the list is required to be equal to the length of
     * "content" field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
        getReferenceSentencePairLists(int index) {
      return referenceSentencePairLists_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Reference sentences pair lists. Each list will be used as the references
     * to translate the sentence under "content" field at the corresponding
     * index. Length of the list is required to be equal to the length of
     * "content" field.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
            .ReferenceSentencePairListOrBuilder
        getReferenceSentencePairListsOrBuilder(int index) {
      return referenceSentencePairLists_.get(index);
    }

    public static final int SOURCE_LANGUAGE_CODE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object sourceLanguageCode_ = "";

    /**
     *
     *
     * <pre>
     * Source language code.
     * </pre>
     *
     * <code>string source_language_code = 2;</code>
     *
     * @return The sourceLanguageCode.
     */
    @java.lang.Override
    public java.lang.String getSourceLanguageCode() {
      java.lang.Object ref = sourceLanguageCode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceLanguageCode_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Source language code.
     * </pre>
     *
     * <code>string source_language_code = 2;</code>
     *
     * @return The bytes for sourceLanguageCode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSourceLanguageCodeBytes() {
      java.lang.Object ref = sourceLanguageCode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceLanguageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TARGET_LANGUAGE_CODE_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object targetLanguageCode_ = "";

    /**
     *
     *
     * <pre>
     * Target language code.
     * </pre>
     *
     * <code>string target_language_code = 3;</code>
     *
     * @return The targetLanguageCode.
     */
    @java.lang.Override
    public java.lang.String getTargetLanguageCode() {
      java.lang.Object ref = targetLanguageCode_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        targetLanguageCode_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Target language code.
     * </pre>
     *
     * <code>string target_language_code = 3;</code>
     *
     * @return The bytes for targetLanguageCode.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTargetLanguageCodeBytes() {
      java.lang.Object ref = targetLanguageCode_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetLanguageCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < referenceSentencePairLists_.size(); i++) {
        output.writeMessage(1, referenceSentencePairLists_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceLanguageCode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, sourceLanguageCode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetLanguageCode_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, targetLanguageCode_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < referenceSentencePairLists_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1, referenceSentencePairLists_.get(i));
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceLanguageCode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, sourceLanguageCode_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(targetLanguageCode_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, targetLanguageCode_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig other =
          (com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig) obj;

      if (!getReferenceSentencePairListsList().equals(other.getReferenceSentencePairListsList()))
        return false;
      if (!getSourceLanguageCode().equals(other.getSourceLanguageCode())) return false;
      if (!getTargetLanguageCode().equals(other.getTargetLanguageCode())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getReferenceSentencePairListsCount() > 0) {
        hash = (37 * hash) + REFERENCE_SENTENCE_PAIR_LISTS_FIELD_NUMBER;
        hash = (53 * hash) + getReferenceSentencePairListsList().hashCode();
      }
      hash = (37 * hash) + SOURCE_LANGUAGE_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getSourceLanguageCode().hashCode();
      hash = (37 * hash) + TARGET_LANGUAGE_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getTargetLanguageCode().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Message of caller-provided reference configuration.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig)
        com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.translate.v3.AdaptiveMtProto
            .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_ReferenceSentenceConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.translate.v3.AdaptiveMtProto
            .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_ReferenceSentenceConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
                    .class,
                com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (referenceSentencePairListsBuilder_ == null) {
          referenceSentencePairLists_ = java.util.Collections.emptyList();
        } else {
          referenceSentencePairLists_ = null;
          referenceSentencePairListsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        sourceLanguageCode_ = "";
        targetLanguageCode_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.translate.v3.AdaptiveMtProto
            .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_ReferenceSentenceConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
          getDefaultInstanceForType() {
        return com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
          build() {
        com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
          buildPartial() {
        com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig result =
            new com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig(
                this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig result) {
        if (referenceSentencePairListsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            referenceSentencePairLists_ =
                java.util.Collections.unmodifiableList(referenceSentencePairLists_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.referenceSentencePairLists_ = referenceSentencePairLists_;
        } else {
          result.referenceSentencePairLists_ = referenceSentencePairListsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.sourceLanguageCode_ = sourceLanguageCode_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.targetLanguageCode_ = targetLanguageCode_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig) {
          return mergeFrom(
              (com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig other) {
        if (other
            == com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
                .getDefaultInstance()) return this;
        if (referenceSentencePairListsBuilder_ == null) {
          if (!other.referenceSentencePairLists_.isEmpty()) {
            if (referenceSentencePairLists_.isEmpty()) {
              referenceSentencePairLists_ = other.referenceSentencePairLists_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureReferenceSentencePairListsIsMutable();
              referenceSentencePairLists_.addAll(other.referenceSentencePairLists_);
            }
            onChanged();
          }
        } else {
          if (!other.referenceSentencePairLists_.isEmpty()) {
            if (referenceSentencePairListsBuilder_.isEmpty()) {
              referenceSentencePairListsBuilder_.dispose();
              referenceSentencePairListsBuilder_ = null;
              referenceSentencePairLists_ = other.referenceSentencePairLists_;
              bitField0_ = (bitField0_ & ~0x00000001);
              referenceSentencePairListsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getReferenceSentencePairListsFieldBuilder()
                      : null;
            } else {
              referenceSentencePairListsBuilder_.addAllMessages(other.referenceSentencePairLists_);
            }
          }
        }
        if (!other.getSourceLanguageCode().isEmpty()) {
          sourceLanguageCode_ = other.sourceLanguageCode_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getTargetLanguageCode().isEmpty()) {
          targetLanguageCode_ = other.targetLanguageCode_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
                      m =
                          input.readMessage(
                              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
                                  .ReferenceSentencePairList.parser(),
                              extensionRegistry);
                  if (referenceSentencePairListsBuilder_ == null) {
                    ensureReferenceSentencePairListsIsMutable();
                    referenceSentencePairLists_.add(m);
                  } else {
                    referenceSentencePairListsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  sourceLanguageCode_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  targetLanguageCode_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList>
          referenceSentencePairLists_ = java.util.Collections.emptyList();

      private void ensureReferenceSentencePairListsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          referenceSentencePairLists_ =
              new java.util.ArrayList<
                  com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
                      .ReferenceSentencePairList>(referenceSentencePairLists_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList,
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
                  .Builder,
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
                  .ReferenceSentencePairListOrBuilder>
          referenceSentencePairListsBuilder_;

      /**
       *
       *
       * <pre>
       * Reference sentences pair lists. Each list will be used as the references
       * to translate the sentence under "content" field at the corresponding
       * index. Length of the list is required to be equal to the length of
       * "content" field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList>
          getReferenceSentencePairListsList() {
        if (referenceSentencePairListsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(referenceSentencePairLists_);
        } else {
          return referenceSentencePairListsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Reference sentences pair lists. Each list will be used as the references
       * to translate the sentence under "content" field at the corresponding
       * index. Length of the list is required to be equal to the length of
       * "content" field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
       * </code>
       */
      public int getReferenceSentencePairListsCount() {
        if (referenceSentencePairListsBuilder_ == null) {
          return referenceSentencePairLists_.size();
        } else {
          return referenceSentencePairListsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Reference sentences pair lists. Each list will be used as the references
       * to translate the sentence under "content" field at the corresponding
       * index. Length of the list is required to be equal to the length of
       * "content" field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
       * </code>
       */
      public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
          getReferenceSentencePairLists(int index) {
        if (referenceSentencePairListsBuilder_ == null) {
          return referenceSentencePairLists_.get(index);
        } else {
          return referenceSentencePairListsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Reference sentences pair lists. Each list will be used as the references
       * to translate the sentence under "content" field at the corresponding
       * index. Length of the list is required to be equal to the length of
       * "content" field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
       * </code>
       */
      public Builder setReferenceSentencePairLists(
          int index,
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
              value) {
        if (referenceSentencePairListsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureReferenceSentencePairListsIsMutable();
          referenceSentencePairLists_.set(index, value);
          onChanged();
        } else {
          referenceSentencePairListsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Reference sentences pair lists. Each list will be used as the references
       * to translate the sentence under "content" field at the corresponding
       * index. Length of the list is required to be equal to the length of
       * "content" field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
       * </code>
       */
      public Builder setReferenceSentencePairLists(
          int index,
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList.Builder
              builderForValue) {
        if (referenceSentencePairListsBuilder_ == null) {
          ensureReferenceSentencePairListsIsMutable();
          referenceSentencePairLists_.set(index, builderForValue.build());
          onChanged();
        } else {
          referenceSentencePairListsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Reference sentences pair lists. Each list will be used as the references
       * to translate the sentence under "content" field at the corresponding
       * index. Length of the list is required to be equal to the length of
       * "content" field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
       * </code>
       */
      public Builder addReferenceSentencePairLists(
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
              value) {
        if (referenceSentencePairListsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureReferenceSentencePairListsIsMutable();
          referenceSentencePairLists_.add(value);
          onChanged();
        } else {
          referenceSentencePairListsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Reference sentences pair lists. Each list will be used as the references
       * to translate the sentence under "content" field at the corresponding
       * index. Length of the list is required to be equal to the length of
       * "content" field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
       * </code>
       */
      public Builder addReferenceSentencePairLists(
          int index,
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
              value) {
        if (referenceSentencePairListsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureReferenceSentencePairListsIsMutable();
          referenceSentencePairLists_.add(index, value);
          onChanged();
        } else {
          referenceSentencePairListsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Reference sentences pair lists. Each list will be used as the references
       * to translate the sentence under "content" field at the corresponding
       * index. Length of the list is required to be equal to the length of
       * "content" field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
       * </code>
       */
      public Builder addReferenceSentencePairLists(
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList.Builder
              builderForValue) {
        if (referenceSentencePairListsBuilder_ == null) {
          ensureReferenceSentencePairListsIsMutable();
          referenceSentencePairLists_.add(builderForValue.build());
          onChanged();
        } else {
          referenceSentencePairListsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Reference sentences pair lists. Each list will be used as the references
       * to translate the sentence under "content" field at the corresponding
       * index. Length of the list is required to be equal to the length of
       * "content" field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
       * </code>
       */
      public Builder addReferenceSentencePairLists(
          int index,
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList.Builder
              builderForValue) {
        if (referenceSentencePairListsBuilder_ == null) {
          ensureReferenceSentencePairListsIsMutable();
          referenceSentencePairLists_.add(index, builderForValue.build());
          onChanged();
        } else {
          referenceSentencePairListsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Reference sentences pair lists. Each list will be used as the references
       * to translate the sentence under "content" field at the corresponding
       * index. Length of the list is required to be equal to the length of
       * "content" field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
       * </code>
       */
      public Builder addAllReferenceSentencePairLists(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
                          .ReferenceSentencePairList>
              values) {
        if (referenceSentencePairListsBuilder_ == null) {
          ensureReferenceSentencePairListsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, referenceSentencePairLists_);
          onChanged();
        } else {
          referenceSentencePairListsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Reference sentences pair lists. Each list will be used as the references
       * to translate the sentence under "content" field at the corresponding
       * index. Length of the list is required to be equal to the length of
       * "content" field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
       * </code>
       */
      public Builder clearReferenceSentencePairLists() {
        if (referenceSentencePairListsBuilder_ == null) {
          referenceSentencePairLists_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          referenceSentencePairListsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Reference sentences pair lists. Each list will be used as the references
       * to translate the sentence under "content" field at the corresponding
       * index. Length of the list is required to be equal to the length of
       * "content" field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
       * </code>
       */
      public Builder removeReferenceSentencePairLists(int index) {
        if (referenceSentencePairListsBuilder_ == null) {
          ensureReferenceSentencePairListsIsMutable();
          referenceSentencePairLists_.remove(index);
          onChanged();
        } else {
          referenceSentencePairListsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Reference sentences pair lists. Each list will be used as the references
       * to translate the sentence under "content" field at the corresponding
       * index. Length of the list is required to be equal to the length of
       * "content" field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
       * </code>
       */
      public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
              .Builder
          getReferenceSentencePairListsBuilder(int index) {
        return getReferenceSentencePairListsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Reference sentences pair lists. Each list will be used as the references
       * to translate the sentence under "content" field at the corresponding
       * index. Length of the list is required to be equal to the length of
       * "content" field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
       * </code>
       */
      public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
              .ReferenceSentencePairListOrBuilder
          getReferenceSentencePairListsOrBuilder(int index) {
        if (referenceSentencePairListsBuilder_ == null) {
          return referenceSentencePairLists_.get(index);
        } else {
          return referenceSentencePairListsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Reference sentences pair lists. Each list will be used as the references
       * to translate the sentence under "content" field at the corresponding
       * index. Length of the list is required to be equal to the length of
       * "content" field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
                      .ReferenceSentencePairListOrBuilder>
          getReferenceSentencePairListsOrBuilderList() {
        if (referenceSentencePairListsBuilder_ != null) {
          return referenceSentencePairListsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(referenceSentencePairLists_);
        }
      }

      /**
       *
       *
       * <pre>
       * Reference sentences pair lists. Each list will be used as the references
       * to translate the sentence under "content" field at the corresponding
       * index. Length of the list is required to be equal to the length of
       * "content" field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
       * </code>
       */
      public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
              .Builder
          addReferenceSentencePairListsBuilder() {
        return getReferenceSentencePairListsFieldBuilder()
            .addBuilder(
                com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
                    .getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Reference sentences pair lists. Each list will be used as the references
       * to translate the sentence under "content" field at the corresponding
       * index. Length of the list is required to be equal to the length of
       * "content" field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
       * </code>
       */
      public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
              .Builder
          addReferenceSentencePairListsBuilder(int index) {
        return getReferenceSentencePairListsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
                    .getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Reference sentences pair lists. Each list will be used as the references
       * to translate the sentence under "content" field at the corresponding
       * index. Length of the list is required to be equal to the length of
       * "content" field.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList reference_sentence_pair_lists = 1;
       * </code>
       */
      public java.util.List<
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
                  .Builder>
          getReferenceSentencePairListsBuilderList() {
        return getReferenceSentencePairListsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList,
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
                  .Builder,
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
                  .ReferenceSentencePairListOrBuilder>
          getReferenceSentencePairListsFieldBuilder() {
        if (referenceSentencePairListsBuilder_ == null) {
          referenceSentencePairListsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
                      .ReferenceSentencePairList,
                  com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentencePairList
                      .Builder,
                  com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
                      .ReferenceSentencePairListOrBuilder>(
                  referenceSentencePairLists_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          referenceSentencePairLists_ = null;
        }
        return referenceSentencePairListsBuilder_;
      }

      private java.lang.Object sourceLanguageCode_ = "";

      /**
       *
       *
       * <pre>
       * Source language code.
       * </pre>
       *
       * <code>string source_language_code = 2;</code>
       *
       * @return The sourceLanguageCode.
       */
      public java.lang.String getSourceLanguageCode() {
        java.lang.Object ref = sourceLanguageCode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sourceLanguageCode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Source language code.
       * </pre>
       *
       * <code>string source_language_code = 2;</code>
       *
       * @return The bytes for sourceLanguageCode.
       */
      public com.google.protobuf.ByteString getSourceLanguageCodeBytes() {
        java.lang.Object ref = sourceLanguageCode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          sourceLanguageCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Source language code.
       * </pre>
       *
       * <code>string source_language_code = 2;</code>
       *
       * @param value The sourceLanguageCode to set.
       * @return This builder for chaining.
       */
      public Builder setSourceLanguageCode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        sourceLanguageCode_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Source language code.
       * </pre>
       *
       * <code>string source_language_code = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSourceLanguageCode() {
        sourceLanguageCode_ = getDefaultInstance().getSourceLanguageCode();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Source language code.
       * </pre>
       *
       * <code>string source_language_code = 2;</code>
       *
       * @param value The bytes for sourceLanguageCode to set.
       * @return This builder for chaining.
       */
      public Builder setSourceLanguageCodeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        sourceLanguageCode_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object targetLanguageCode_ = "";

      /**
       *
       *
       * <pre>
       * Target language code.
       * </pre>
       *
       * <code>string target_language_code = 3;</code>
       *
       * @return The targetLanguageCode.
       */
      public java.lang.String getTargetLanguageCode() {
        java.lang.Object ref = targetLanguageCode_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          targetLanguageCode_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Target language code.
       * </pre>
       *
       * <code>string target_language_code = 3;</code>
       *
       * @return The bytes for targetLanguageCode.
       */
      public com.google.protobuf.ByteString getTargetLanguageCodeBytes() {
        java.lang.Object ref = targetLanguageCode_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          targetLanguageCode_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Target language code.
       * </pre>
       *
       * <code>string target_language_code = 3;</code>
       *
       * @param value The targetLanguageCode to set.
       * @return This builder for chaining.
       */
      public Builder setTargetLanguageCode(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        targetLanguageCode_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Target language code.
       * </pre>
       *
       * <code>string target_language_code = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTargetLanguageCode() {
        targetLanguageCode_ = getDefaultInstance().getTargetLanguageCode();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Target language code.
       * </pre>
       *
       * <code>string target_language_code = 3;</code>
       *
       * @param value The bytes for targetLanguageCode to set.
       * @return This builder for chaining.
       */
      public Builder setTargetLanguageCodeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        targetLanguageCode_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig)
    private static final com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
            .ReferenceSentenceConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig();
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ReferenceSentenceConfig> PARSER =
        new com.google.protobuf.AbstractParser<ReferenceSentenceConfig>() {
          @java.lang.Override
          public ReferenceSentenceConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ReferenceSentenceConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ReferenceSentenceConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface GlossaryConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.translation.v3.AdaptiveMtTranslateRequest.GlossaryConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The `glossary` to be applied for this translation.
     *
     * The format depends on the glossary:
     *
     * - User-provided custom glossary:
     *   `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`
     * </pre>
     *
     * <code>
     * string glossary = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The glossary.
     */
    java.lang.String getGlossary();

    /**
     *
     *
     * <pre>
     * Required. The `glossary` to be applied for this translation.
     *
     * The format depends on the glossary:
     *
     * - User-provided custom glossary:
     *   `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`
     * </pre>
     *
     * <code>
     * string glossary = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for glossary.
     */
    com.google.protobuf.ByteString getGlossaryBytes();

    /**
     *
     *
     * <pre>
     * Optional. Indicates match is case insensitive. The default value is
     * `false` if missing.
     * </pre>
     *
     * <code>bool ignore_case = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The ignoreCase.
     */
    boolean getIgnoreCase();

    /**
     *
     *
     * <pre>
     * Optional. If set to true, the glossary will be used for contextual
     * translation.
     * </pre>
     *
     * <code>bool contextual_translation_enabled = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The contextualTranslationEnabled.
     */
    boolean getContextualTranslationEnabled();
  }

  /**
   *
   *
   * <pre>
   * Configures which glossary is used for a specific target language and
   * defines
   * options for applying that glossary.
   * </pre>
   *
   * Protobuf type {@code google.cloud.translation.v3.AdaptiveMtTranslateRequest.GlossaryConfig}
   */
  public static final class GlossaryConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.translation.v3.AdaptiveMtTranslateRequest.GlossaryConfig)
      GlossaryConfigOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use GlossaryConfig.newBuilder() to construct.
    private GlossaryConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GlossaryConfig() {
      glossary_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GlossaryConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.translate.v3.AdaptiveMtProto
          .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_GlossaryConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.translate.v3.AdaptiveMtProto
          .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_GlossaryConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig.class,
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig.Builder
                  .class);
    }

    public static final int GLOSSARY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object glossary_ = "";

    /**
     *
     *
     * <pre>
     * Required. The `glossary` to be applied for this translation.
     *
     * The format depends on the glossary:
     *
     * - User-provided custom glossary:
     *   `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`
     * </pre>
     *
     * <code>
     * string glossary = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The glossary.
     */
    @java.lang.Override
    public java.lang.String getGlossary() {
      java.lang.Object ref = glossary_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        glossary_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The `glossary` to be applied for this translation.
     *
     * The format depends on the glossary:
     *
     * - User-provided custom glossary:
     *   `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`
     * </pre>
     *
     * <code>
     * string glossary = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for glossary.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getGlossaryBytes() {
      java.lang.Object ref = glossary_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        glossary_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IGNORE_CASE_FIELD_NUMBER = 2;
    private boolean ignoreCase_ = false;

    /**
     *
     *
     * <pre>
     * Optional. Indicates match is case insensitive. The default value is
     * `false` if missing.
     * </pre>
     *
     * <code>bool ignore_case = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The ignoreCase.
     */
    @java.lang.Override
    public boolean getIgnoreCase() {
      return ignoreCase_;
    }

    public static final int CONTEXTUAL_TRANSLATION_ENABLED_FIELD_NUMBER = 4;
    private boolean contextualTranslationEnabled_ = false;

    /**
     *
     *
     * <pre>
     * Optional. If set to true, the glossary will be used for contextual
     * translation.
     * </pre>
     *
     * <code>bool contextual_translation_enabled = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The contextualTranslationEnabled.
     */
    @java.lang.Override
    public boolean getContextualTranslationEnabled() {
      return contextualTranslationEnabled_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(glossary_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, glossary_);
      }
      if (ignoreCase_ != false) {
        output.writeBool(2, ignoreCase_);
      }
      if (contextualTranslationEnabled_ != false) {
        output.writeBool(4, contextualTranslationEnabled_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(glossary_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, glossary_);
      }
      if (ignoreCase_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(2, ignoreCase_);
      }
      if (contextualTranslationEnabled_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(4, contextualTranslationEnabled_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig other =
          (com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig) obj;

      if (!getGlossary().equals(other.getGlossary())) return false;
      if (getIgnoreCase() != other.getIgnoreCase()) return false;
      if (getContextualTranslationEnabled() != other.getContextualTranslationEnabled())
        return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + GLOSSARY_FIELD_NUMBER;
      hash = (53 * hash) + getGlossary().hashCode();
      hash = (37 * hash) + IGNORE_CASE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIgnoreCase());
      hash = (37 * hash) + CONTEXTUAL_TRANSLATION_ENABLED_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashBoolean(getContextualTranslationEnabled());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Configures which glossary is used for a specific target language and
     * defines
     * options for applying that glossary.
     * </pre>
     *
     * Protobuf type {@code google.cloud.translation.v3.AdaptiveMtTranslateRequest.GlossaryConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.translation.v3.AdaptiveMtTranslateRequest.GlossaryConfig)
        com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.translate.v3.AdaptiveMtProto
            .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_GlossaryConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.translate.v3.AdaptiveMtProto
            .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_GlossaryConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig.class,
                com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        glossary_ = "";
        ignoreCase_ = false;
        contextualTranslationEnabled_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.translate.v3.AdaptiveMtProto
            .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_GlossaryConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig
          getDefaultInstanceForType() {
        return com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig build() {
        com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig
          buildPartial() {
        com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig result =
            new com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.glossary_ = glossary_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.ignoreCase_ = ignoreCase_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.contextualTranslationEnabled_ = contextualTranslationEnabled_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig) {
          return mergeFrom(
              (com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig other) {
        if (other
            == com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig
                .getDefaultInstance()) return this;
        if (!other.getGlossary().isEmpty()) {
          glossary_ = other.glossary_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getIgnoreCase() != false) {
          setIgnoreCase(other.getIgnoreCase());
        }
        if (other.getContextualTranslationEnabled() != false) {
          setContextualTranslationEnabled(other.getContextualTranslationEnabled());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  glossary_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  ignoreCase_ = input.readBool();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 32:
                {
                  contextualTranslationEnabled_ = input.readBool();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object glossary_ = "";

      /**
       *
       *
       * <pre>
       * Required. The `glossary` to be applied for this translation.
       *
       * The format depends on the glossary:
       *
       * - User-provided custom glossary:
       *   `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`
       * </pre>
       *
       * <code>
       * string glossary = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The glossary.
       */
      public java.lang.String getGlossary() {
        java.lang.Object ref = glossary_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          glossary_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The `glossary` to be applied for this translation.
       *
       * The format depends on the glossary:
       *
       * - User-provided custom glossary:
       *   `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`
       * </pre>
       *
       * <code>
       * string glossary = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for glossary.
       */
      public com.google.protobuf.ByteString getGlossaryBytes() {
        java.lang.Object ref = glossary_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          glossary_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The `glossary` to be applied for this translation.
       *
       * The format depends on the glossary:
       *
       * - User-provided custom glossary:
       *   `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`
       * </pre>
       *
       * <code>
       * string glossary = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The glossary to set.
       * @return This builder for chaining.
       */
      public Builder setGlossary(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        glossary_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The `glossary` to be applied for this translation.
       *
       * The format depends on the glossary:
       *
       * - User-provided custom glossary:
       *   `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`
       * </pre>
       *
       * <code>
       * string glossary = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGlossary() {
        glossary_ = getDefaultInstance().getGlossary();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The `glossary` to be applied for this translation.
       *
       * The format depends on the glossary:
       *
       * - User-provided custom glossary:
       *   `projects/{project-number-or-id}/locations/{location-id}/glossaries/{glossary-id}`
       * </pre>
       *
       * <code>
       * string glossary = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for glossary to set.
       * @return This builder for chaining.
       */
      public Builder setGlossaryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        glossary_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private boolean ignoreCase_;

      /**
       *
       *
       * <pre>
       * Optional. Indicates match is case insensitive. The default value is
       * `false` if missing.
       * </pre>
       *
       * <code>bool ignore_case = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The ignoreCase.
       */
      @java.lang.Override
      public boolean getIgnoreCase() {
        return ignoreCase_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Indicates match is case insensitive. The default value is
       * `false` if missing.
       * </pre>
       *
       * <code>bool ignore_case = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The ignoreCase to set.
       * @return This builder for chaining.
       */
      public Builder setIgnoreCase(boolean value) {

        ignoreCase_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Indicates match is case insensitive. The default value is
       * `false` if missing.
       * </pre>
       *
       * <code>bool ignore_case = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIgnoreCase() {
        bitField0_ = (bitField0_ & ~0x00000002);
        ignoreCase_ = false;
        onChanged();
        return this;
      }

      private boolean contextualTranslationEnabled_;

      /**
       *
       *
       * <pre>
       * Optional. If set to true, the glossary will be used for contextual
       * translation.
       * </pre>
       *
       * <code>bool contextual_translation_enabled = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The contextualTranslationEnabled.
       */
      @java.lang.Override
      public boolean getContextualTranslationEnabled() {
        return contextualTranslationEnabled_;
      }

      /**
       *
       *
       * <pre>
       * Optional. If set to true, the glossary will be used for contextual
       * translation.
       * </pre>
       *
       * <code>bool contextual_translation_enabled = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The contextualTranslationEnabled to set.
       * @return This builder for chaining.
       */
      public Builder setContextualTranslationEnabled(boolean value) {

        contextualTranslationEnabled_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. If set to true, the glossary will be used for contextual
       * translation.
       * </pre>
       *
       * <code>bool contextual_translation_enabled = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContextualTranslationEnabled() {
        bitField0_ = (bitField0_ & ~0x00000004);
        contextualTranslationEnabled_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.translation.v3.AdaptiveMtTranslateRequest.GlossaryConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.translation.v3.AdaptiveMtTranslateRequest.GlossaryConfig)
    private static final com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig();
    }

    public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GlossaryConfig> PARSER =
        new com.google.protobuf.AbstractParser<GlossaryConfig>() {
          @java.lang.Override
          public GlossaryConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GlossaryConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GlossaryConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. Location to make a regional call.
   *
   * Format: `projects/{project-number-or-id}/locations/{location-id}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Location to make a regional call.
   *
   * Format: `projects/{project-number-or-id}/locations/{location-id}`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATASET_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object dataset_ = "";

  /**
   *
   *
   * <pre>
   * Required. The resource name for the dataset to use for adaptive MT.
   * `projects/{project}/locations/{location-id}/adaptiveMtDatasets/{dataset}`
   * </pre>
   *
   * <code>
   * string dataset = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The dataset.
   */
  @java.lang.Override
  public java.lang.String getDataset() {
    java.lang.Object ref = dataset_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      dataset_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The resource name for the dataset to use for adaptive MT.
   * `projects/{project}/locations/{location-id}/adaptiveMtDatasets/{dataset}`
   * </pre>
   *
   * <code>
   * string dataset = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for dataset.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatasetBytes() {
    java.lang.Object ref = dataset_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      dataset_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONTENT_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList content_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Required. The content of the input in string format.
   * </pre>
   *
   * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return A list containing the content.
   */
  public com.google.protobuf.ProtocolStringList getContentList() {
    return content_;
  }

  /**
   *
   *
   * <pre>
   * Required. The content of the input in string format.
   * </pre>
   *
   * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The count of content.
   */
  public int getContentCount() {
    return content_.size();
  }

  /**
   *
   *
   * <pre>
   * Required. The content of the input in string format.
   * </pre>
   *
   * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the element to return.
   * @return The content at the given index.
   */
  public java.lang.String getContent(int index) {
    return content_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Required. The content of the input in string format.
   * </pre>
   *
   * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the content at the given index.
   */
  public com.google.protobuf.ByteString getContentBytes(int index) {
    return content_.getByteString(index);
  }

  public static final int REFERENCE_SENTENCE_CONFIG_FIELD_NUMBER = 6;
  private com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
      referenceSentenceConfig_;

  /**
   *
   *
   * <pre>
   * Configuration for caller provided reference sentences.
   * </pre>
   *
   * <code>
   * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig reference_sentence_config = 6;
   * </code>
   *
   * @return Whether the referenceSentenceConfig field is set.
   */
  @java.lang.Override
  public boolean hasReferenceSentenceConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Configuration for caller provided reference sentences.
   * </pre>
   *
   * <code>
   * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig reference_sentence_config = 6;
   * </code>
   *
   * @return The referenceSentenceConfig.
   */
  @java.lang.Override
  public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
      getReferenceSentenceConfig() {
    return referenceSentenceConfig_ == null
        ? com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
            .getDefaultInstance()
        : referenceSentenceConfig_;
  }

  /**
   *
   *
   * <pre>
   * Configuration for caller provided reference sentences.
   * </pre>
   *
   * <code>
   * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig reference_sentence_config = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfigOrBuilder
      getReferenceSentenceConfigOrBuilder() {
    return referenceSentenceConfig_ == null
        ? com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
            .getDefaultInstance()
        : referenceSentenceConfig_;
  }

  public static final int GLOSSARY_CONFIG_FIELD_NUMBER = 7;
  private com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig glossaryConfig_;

  /**
   *
   *
   * <pre>
   * Optional. Glossary to be applied. The glossary must be
   * within the same region (have the same location-id) as the model, otherwise
   * an INVALID_ARGUMENT (400) error is returned.
   * </pre>
   *
   * <code>
   * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.GlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the glossaryConfig field is set.
   */
  @java.lang.Override
  public boolean hasGlossaryConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Glossary to be applied. The glossary must be
   * within the same region (have the same location-id) as the model, otherwise
   * an INVALID_ARGUMENT (400) error is returned.
   * </pre>
   *
   * <code>
   * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.GlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The glossaryConfig.
   */
  @java.lang.Override
  public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig
      getGlossaryConfig() {
    return glossaryConfig_ == null
        ? com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig
            .getDefaultInstance()
        : glossaryConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Glossary to be applied. The glossary must be
   * within the same region (have the same location-id) as the model, otherwise
   * an INVALID_ARGUMENT (400) error is returned.
   * </pre>
   *
   * <code>
   * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.GlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfigOrBuilder
      getGlossaryConfigOrBuilder() {
    return glossaryConfig_ == null
        ? com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig
            .getDefaultInstance()
        : glossaryConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataset_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, dataset_);
    }
    for (int i = 0; i < content_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, content_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getReferenceSentenceConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getGlossaryConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataset_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, dataset_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < content_.size(); i++) {
        dataSize += computeStringSizeNoTag(content_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getContentList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(6, getReferenceSentenceConfig());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getGlossaryConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.translate.v3.AdaptiveMtTranslateRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.translate.v3.AdaptiveMtTranslateRequest other =
        (com.google.cloud.translate.v3.AdaptiveMtTranslateRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getDataset().equals(other.getDataset())) return false;
    if (!getContentList().equals(other.getContentList())) return false;
    if (hasReferenceSentenceConfig() != other.hasReferenceSentenceConfig()) return false;
    if (hasReferenceSentenceConfig()) {
      if (!getReferenceSentenceConfig().equals(other.getReferenceSentenceConfig())) return false;
    }
    if (hasGlossaryConfig() != other.hasGlossaryConfig()) return false;
    if (hasGlossaryConfig()) {
      if (!getGlossaryConfig().equals(other.getGlossaryConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + DATASET_FIELD_NUMBER;
    hash = (53 * hash) + getDataset().hashCode();
    if (getContentCount() > 0) {
      hash = (37 * hash) + CONTENT_FIELD_NUMBER;
      hash = (53 * hash) + getContentList().hashCode();
    }
    if (hasReferenceSentenceConfig()) {
      hash = (37 * hash) + REFERENCE_SENTENCE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getReferenceSentenceConfig().hashCode();
    }
    if (hasGlossaryConfig()) {
      hash = (37 * hash) + GLOSSARY_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getGlossaryConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.translate.v3.AdaptiveMtTranslateRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The request for sending an AdaptiveMt translation query.
   * </pre>
   *
   * Protobuf type {@code google.cloud.translation.v3.AdaptiveMtTranslateRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.translation.v3.AdaptiveMtTranslateRequest)
      com.google.cloud.translate.v3.AdaptiveMtTranslateRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.translate.v3.AdaptiveMtProto
          .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.translate.v3.AdaptiveMtProto
          .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.class,
              com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.Builder.class);
    }

    // Construct using com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getReferenceSentenceConfigFieldBuilder();
        getGlossaryConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      dataset_ = "";
      content_ = com.google.protobuf.LazyStringArrayList.emptyList();
      referenceSentenceConfig_ = null;
      if (referenceSentenceConfigBuilder_ != null) {
        referenceSentenceConfigBuilder_.dispose();
        referenceSentenceConfigBuilder_ = null;
      }
      glossaryConfig_ = null;
      if (glossaryConfigBuilder_ != null) {
        glossaryConfigBuilder_.dispose();
        glossaryConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.translate.v3.AdaptiveMtProto
          .internal_static_google_cloud_translation_v3_AdaptiveMtTranslateRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest getDefaultInstanceForType() {
      return com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest build() {
      com.google.cloud.translate.v3.AdaptiveMtTranslateRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest buildPartial() {
      com.google.cloud.translate.v3.AdaptiveMtTranslateRequest result =
          new com.google.cloud.translate.v3.AdaptiveMtTranslateRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.translate.v3.AdaptiveMtTranslateRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.dataset_ = dataset_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        content_.makeImmutable();
        result.content_ = content_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.referenceSentenceConfig_ =
            referenceSentenceConfigBuilder_ == null
                ? referenceSentenceConfig_
                : referenceSentenceConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.glossaryConfig_ =
            glossaryConfigBuilder_ == null ? glossaryConfig_ : glossaryConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.translate.v3.AdaptiveMtTranslateRequest) {
        return mergeFrom((com.google.cloud.translate.v3.AdaptiveMtTranslateRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.translate.v3.AdaptiveMtTranslateRequest other) {
      if (other == com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDataset().isEmpty()) {
        dataset_ = other.dataset_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.content_.isEmpty()) {
        if (content_.isEmpty()) {
          content_ = other.content_;
          bitField0_ |= 0x00000004;
        } else {
          ensureContentIsMutable();
          content_.addAll(other.content_);
        }
        onChanged();
      }
      if (other.hasReferenceSentenceConfig()) {
        mergeReferenceSentenceConfig(other.getReferenceSentenceConfig());
      }
      if (other.hasGlossaryConfig()) {
        mergeGlossaryConfig(other.getGlossaryConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                dataset_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureContentIsMutable();
                content_.add(s);
                break;
              } // case 26
            case 50:
              {
                input.readMessage(
                    getReferenceSentenceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getGlossaryConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. Location to make a regional call.
     *
     * Format: `projects/{project-number-or-id}/locations/{location-id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Location to make a regional call.
     *
     * Format: `projects/{project-number-or-id}/locations/{location-id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Location to make a regional call.
     *
     * Format: `projects/{project-number-or-id}/locations/{location-id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Location to make a regional call.
     *
     * Format: `projects/{project-number-or-id}/locations/{location-id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Location to make a regional call.
     *
     * Format: `projects/{project-number-or-id}/locations/{location-id}`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object dataset_ = "";

    /**
     *
     *
     * <pre>
     * Required. The resource name for the dataset to use for adaptive MT.
     * `projects/{project}/locations/{location-id}/adaptiveMtDatasets/{dataset}`
     * </pre>
     *
     * <code>
     * string dataset = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The dataset.
     */
    public java.lang.String getDataset() {
      java.lang.Object ref = dataset_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataset_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name for the dataset to use for adaptive MT.
     * `projects/{project}/locations/{location-id}/adaptiveMtDatasets/{dataset}`
     * </pre>
     *
     * <code>
     * string dataset = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for dataset.
     */
    public com.google.protobuf.ByteString getDatasetBytes() {
      java.lang.Object ref = dataset_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataset_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name for the dataset to use for adaptive MT.
     * `projects/{project}/locations/{location-id}/adaptiveMtDatasets/{dataset}`
     * </pre>
     *
     * <code>
     * string dataset = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The dataset to set.
     * @return This builder for chaining.
     */
    public Builder setDataset(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      dataset_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name for the dataset to use for adaptive MT.
     * `projects/{project}/locations/{location-id}/adaptiveMtDatasets/{dataset}`
     * </pre>
     *
     * <code>
     * string dataset = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDataset() {
      dataset_ = getDefaultInstance().getDataset();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name for the dataset to use for adaptive MT.
     * `projects/{project}/locations/{location-id}/adaptiveMtDatasets/{dataset}`
     * </pre>
     *
     * <code>
     * string dataset = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for dataset to set.
     * @return This builder for chaining.
     */
    public Builder setDatasetBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      dataset_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList content_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureContentIsMutable() {
      if (!content_.isModifiable()) {
        content_ = new com.google.protobuf.LazyStringArrayList(content_);
      }
      bitField0_ |= 0x00000004;
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the input in string format.
     * </pre>
     *
     * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return A list containing the content.
     */
    public com.google.protobuf.ProtocolStringList getContentList() {
      content_.makeImmutable();
      return content_;
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the input in string format.
     * </pre>
     *
     * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The count of content.
     */
    public int getContentCount() {
      return content_.size();
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the input in string format.
     * </pre>
     *
     * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the element to return.
     * @return The content at the given index.
     */
    public java.lang.String getContent(int index) {
      return content_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the input in string format.
     * </pre>
     *
     * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the content at the given index.
     */
    public com.google.protobuf.ByteString getContentBytes(int index) {
      return content_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the input in string format.
     * </pre>
     *
     * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param index The index to set the value at.
     * @param value The content to set.
     * @return This builder for chaining.
     */
    public Builder setContent(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureContentIsMutable();
      content_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the input in string format.
     * </pre>
     *
     * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The content to add.
     * @return This builder for chaining.
     */
    public Builder addContent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureContentIsMutable();
      content_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the input in string format.
     * </pre>
     *
     * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param values The content to add.
     * @return This builder for chaining.
     */
    public Builder addAllContent(java.lang.Iterable<java.lang.String> values) {
      ensureContentIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, content_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the input in string format.
     * </pre>
     *
     * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearContent() {
      content_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The content of the input in string format.
     * </pre>
     *
     * <code>repeated string content = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes of the content to add.
     * @return This builder for chaining.
     */
    public Builder addContentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureContentIsMutable();
      content_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
        referenceSentenceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig,
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
                .Builder,
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
                .ReferenceSentenceConfigOrBuilder>
        referenceSentenceConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Configuration for caller provided reference sentences.
     * </pre>
     *
     * <code>
     * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig reference_sentence_config = 6;
     * </code>
     *
     * @return Whether the referenceSentenceConfig field is set.
     */
    public boolean hasReferenceSentenceConfig() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Configuration for caller provided reference sentences.
     * </pre>
     *
     * <code>
     * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig reference_sentence_config = 6;
     * </code>
     *
     * @return The referenceSentenceConfig.
     */
    public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
        getReferenceSentenceConfig() {
      if (referenceSentenceConfigBuilder_ == null) {
        return referenceSentenceConfig_ == null
            ? com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
                .getDefaultInstance()
            : referenceSentenceConfig_;
      } else {
        return referenceSentenceConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Configuration for caller provided reference sentences.
     * </pre>
     *
     * <code>
     * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig reference_sentence_config = 6;
     * </code>
     */
    public Builder setReferenceSentenceConfig(
        com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig value) {
      if (referenceSentenceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        referenceSentenceConfig_ = value;
      } else {
        referenceSentenceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configuration for caller provided reference sentences.
     * </pre>
     *
     * <code>
     * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig reference_sentence_config = 6;
     * </code>
     */
    public Builder setReferenceSentenceConfig(
        com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig.Builder
            builderForValue) {
      if (referenceSentenceConfigBuilder_ == null) {
        referenceSentenceConfig_ = builderForValue.build();
      } else {
        referenceSentenceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configuration for caller provided reference sentences.
     * </pre>
     *
     * <code>
     * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig reference_sentence_config = 6;
     * </code>
     */
    public Builder mergeReferenceSentenceConfig(
        com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig value) {
      if (referenceSentenceConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && referenceSentenceConfig_ != null
            && referenceSentenceConfig_
                != com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
                    .getDefaultInstance()) {
          getReferenceSentenceConfigBuilder().mergeFrom(value);
        } else {
          referenceSentenceConfig_ = value;
        }
      } else {
        referenceSentenceConfigBuilder_.mergeFrom(value);
      }
      if (referenceSentenceConfig_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configuration for caller provided reference sentences.
     * </pre>
     *
     * <code>
     * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig reference_sentence_config = 6;
     * </code>
     */
    public Builder clearReferenceSentenceConfig() {
      bitField0_ = (bitField0_ & ~0x00000008);
      referenceSentenceConfig_ = null;
      if (referenceSentenceConfigBuilder_ != null) {
        referenceSentenceConfigBuilder_.dispose();
        referenceSentenceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Configuration for caller provided reference sentences.
     * </pre>
     *
     * <code>
     * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig reference_sentence_config = 6;
     * </code>
     */
    public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig.Builder
        getReferenceSentenceConfigBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getReferenceSentenceConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Configuration for caller provided reference sentences.
     * </pre>
     *
     * <code>
     * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig reference_sentence_config = 6;
     * </code>
     */
    public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfigOrBuilder
        getReferenceSentenceConfigOrBuilder() {
      if (referenceSentenceConfigBuilder_ != null) {
        return referenceSentenceConfigBuilder_.getMessageOrBuilder();
      } else {
        return referenceSentenceConfig_ == null
            ? com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
                .getDefaultInstance()
            : referenceSentenceConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Configuration for caller provided reference sentences.
     * </pre>
     *
     * <code>
     * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig reference_sentence_config = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig,
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
                .Builder,
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
                .ReferenceSentenceConfigOrBuilder>
        getReferenceSentenceConfigFieldBuilder() {
      if (referenceSentenceConfigBuilder_ == null) {
        referenceSentenceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig,
                com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.ReferenceSentenceConfig
                    .Builder,
                com.google.cloud.translate.v3.AdaptiveMtTranslateRequest
                    .ReferenceSentenceConfigOrBuilder>(
                getReferenceSentenceConfig(), getParentForChildren(), isClean());
        referenceSentenceConfig_ = null;
      }
      return referenceSentenceConfigBuilder_;
    }

    private com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig glossaryConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig,
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig.Builder,
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfigOrBuilder>
        glossaryConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Glossary to be applied. The glossary must be
     * within the same region (have the same location-id) as the model, otherwise
     * an INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>
     * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.GlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the glossaryConfig field is set.
     */
    public boolean hasGlossaryConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Glossary to be applied. The glossary must be
     * within the same region (have the same location-id) as the model, otherwise
     * an INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>
     * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.GlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The glossaryConfig.
     */
    public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig
        getGlossaryConfig() {
      if (glossaryConfigBuilder_ == null) {
        return glossaryConfig_ == null
            ? com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig
                .getDefaultInstance()
            : glossaryConfig_;
      } else {
        return glossaryConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Glossary to be applied. The glossary must be
     * within the same region (have the same location-id) as the model, otherwise
     * an INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>
     * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.GlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGlossaryConfig(
        com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig value) {
      if (glossaryConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        glossaryConfig_ = value;
      } else {
        glossaryConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Glossary to be applied. The glossary must be
     * within the same region (have the same location-id) as the model, otherwise
     * an INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>
     * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.GlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGlossaryConfig(
        com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig.Builder
            builderForValue) {
      if (glossaryConfigBuilder_ == null) {
        glossaryConfig_ = builderForValue.build();
      } else {
        glossaryConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Glossary to be applied. The glossary must be
     * within the same region (have the same location-id) as the model, otherwise
     * an INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>
     * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.GlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGlossaryConfig(
        com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig value) {
      if (glossaryConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && glossaryConfig_ != null
            && glossaryConfig_
                != com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig
                    .getDefaultInstance()) {
          getGlossaryConfigBuilder().mergeFrom(value);
        } else {
          glossaryConfig_ = value;
        }
      } else {
        glossaryConfigBuilder_.mergeFrom(value);
      }
      if (glossaryConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Glossary to be applied. The glossary must be
     * within the same region (have the same location-id) as the model, otherwise
     * an INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>
     * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.GlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGlossaryConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      glossaryConfig_ = null;
      if (glossaryConfigBuilder_ != null) {
        glossaryConfigBuilder_.dispose();
        glossaryConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Glossary to be applied. The glossary must be
     * within the same region (have the same location-id) as the model, otherwise
     * an INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>
     * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.GlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig.Builder
        getGlossaryConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getGlossaryConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Glossary to be applied. The glossary must be
     * within the same region (have the same location-id) as the model, otherwise
     * an INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>
     * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.GlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfigOrBuilder
        getGlossaryConfigOrBuilder() {
      if (glossaryConfigBuilder_ != null) {
        return glossaryConfigBuilder_.getMessageOrBuilder();
      } else {
        return glossaryConfig_ == null
            ? com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig
                .getDefaultInstance()
            : glossaryConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Glossary to be applied. The glossary must be
     * within the same region (have the same location-id) as the model, otherwise
     * an INVALID_ARGUMENT (400) error is returned.
     * </pre>
     *
     * <code>
     * optional .google.cloud.translation.v3.AdaptiveMtTranslateRequest.GlossaryConfig glossary_config = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig,
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig.Builder,
            com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfigOrBuilder>
        getGlossaryConfigFieldBuilder() {
      if (glossaryConfigBuilder_ == null) {
        glossaryConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig,
                com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfig.Builder,
                com.google.cloud.translate.v3.AdaptiveMtTranslateRequest.GlossaryConfigOrBuilder>(
                getGlossaryConfig(), getParentForChildren(), isClean());
        glossaryConfig_ = null;
      }
      return glossaryConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.translation.v3.AdaptiveMtTranslateRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.translation.v3.AdaptiveMtTranslateRequest)
  private static final com.google.cloud.translate.v3.AdaptiveMtTranslateRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.translate.v3.AdaptiveMtTranslateRequest();
  }

  public static com.google.cloud.translate.v3.AdaptiveMtTranslateRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AdaptiveMtTranslateRequest> PARSER =
      new com.google.protobuf.AbstractParser<AdaptiveMtTranslateRequest>() {
        @java.lang.Override
        public AdaptiveMtTranslateRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AdaptiveMtTranslateRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AdaptiveMtTranslateRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.translate.v3.AdaptiveMtTranslateRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
