/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/translate/v3/automl_translation.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.translate.v3;

/**
 *
 *
 * <pre>
 * Input configuration for datasets.
 * </pre>
 *
 * Protobuf type {@code google.cloud.translation.v3.DatasetInputConfig}
 */
public final class DatasetInputConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.translation.v3.DatasetInputConfig)
    DatasetInputConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use DatasetInputConfig.newBuilder() to construct.
  private DatasetInputConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DatasetInputConfig() {
    inputFiles_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DatasetInputConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.translate.v3.AutoMLTranslationProto
        .internal_static_google_cloud_translation_v3_DatasetInputConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.translate.v3.AutoMLTranslationProto
        .internal_static_google_cloud_translation_v3_DatasetInputConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.translate.v3.DatasetInputConfig.class,
            com.google.cloud.translate.v3.DatasetInputConfig.Builder.class);
  }

  public interface InputFileOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.translation.v3.DatasetInputConfig.InputFile)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Usage of the file contents. Options are TRAIN|VALIDATION|TEST,
     * or UNASSIGNED (by default) for auto split.
     * </pre>
     *
     * <code>string usage = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The usage.
     */
    java.lang.String getUsage();

    /**
     *
     *
     * <pre>
     * Optional. Usage of the file contents. Options are TRAIN|VALIDATION|TEST,
     * or UNASSIGNED (by default) for auto split.
     * </pre>
     *
     * <code>string usage = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for usage.
     */
    com.google.protobuf.ByteString getUsageBytes();

    /**
     *
     *
     * <pre>
     * Google Cloud Storage file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.GcsInputSource gcs_source = 3;</code>
     *
     * @return Whether the gcsSource field is set.
     */
    boolean hasGcsSource();

    /**
     *
     *
     * <pre>
     * Google Cloud Storage file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.GcsInputSource gcs_source = 3;</code>
     *
     * @return The gcsSource.
     */
    com.google.cloud.translate.v3.GcsInputSource getGcsSource();

    /**
     *
     *
     * <pre>
     * Google Cloud Storage file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.GcsInputSource gcs_source = 3;</code>
     */
    com.google.cloud.translate.v3.GcsInputSourceOrBuilder getGcsSourceOrBuilder();

    com.google.cloud.translate.v3.DatasetInputConfig.InputFile.SourceCase getSourceCase();
  }

  /**
   *
   *
   * <pre>
   * An input file.
   * </pre>
   *
   * Protobuf type {@code google.cloud.translation.v3.DatasetInputConfig.InputFile}
   */
  public static final class InputFile extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.translation.v3.DatasetInputConfig.InputFile)
      InputFileOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use InputFile.newBuilder() to construct.
    private InputFile(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private InputFile() {
      usage_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new InputFile();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.translate.v3.AutoMLTranslationProto
          .internal_static_google_cloud_translation_v3_DatasetInputConfig_InputFile_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.translate.v3.AutoMLTranslationProto
          .internal_static_google_cloud_translation_v3_DatasetInputConfig_InputFile_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.translate.v3.DatasetInputConfig.InputFile.class,
              com.google.cloud.translate.v3.DatasetInputConfig.InputFile.Builder.class);
    }

    private int sourceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object source_;

    public enum SourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      GCS_SOURCE(3),
      SOURCE_NOT_SET(0);
      private final int value;

      private SourceCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static SourceCase forNumber(int value) {
        switch (value) {
          case 3:
            return GCS_SOURCE;
          case 0:
            return SOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public static final int USAGE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object usage_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Usage of the file contents. Options are TRAIN|VALIDATION|TEST,
     * or UNASSIGNED (by default) for auto split.
     * </pre>
     *
     * <code>string usage = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The usage.
     */
    @java.lang.Override
    public java.lang.String getUsage() {
      java.lang.Object ref = usage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        usage_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Usage of the file contents. Options are TRAIN|VALIDATION|TEST,
     * or UNASSIGNED (by default) for auto split.
     * </pre>
     *
     * <code>string usage = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for usage.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getUsageBytes() {
      java.lang.Object ref = usage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        usage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GCS_SOURCE_FIELD_NUMBER = 3;

    /**
     *
     *
     * <pre>
     * Google Cloud Storage file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.GcsInputSource gcs_source = 3;</code>
     *
     * @return Whether the gcsSource field is set.
     */
    @java.lang.Override
    public boolean hasGcsSource() {
      return sourceCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.GcsInputSource gcs_source = 3;</code>
     *
     * @return The gcsSource.
     */
    @java.lang.Override
    public com.google.cloud.translate.v3.GcsInputSource getGcsSource() {
      if (sourceCase_ == 3) {
        return (com.google.cloud.translate.v3.GcsInputSource) source_;
      }
      return com.google.cloud.translate.v3.GcsInputSource.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Google Cloud Storage file source.
     * </pre>
     *
     * <code>.google.cloud.translation.v3.GcsInputSource gcs_source = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.translate.v3.GcsInputSourceOrBuilder getGcsSourceOrBuilder() {
      if (sourceCase_ == 3) {
        return (com.google.cloud.translate.v3.GcsInputSource) source_;
      }
      return com.google.cloud.translate.v3.GcsInputSource.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(usage_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, usage_);
      }
      if (sourceCase_ == 3) {
        output.writeMessage(3, (com.google.cloud.translate.v3.GcsInputSource) source_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(usage_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, usage_);
      }
      if (sourceCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, (com.google.cloud.translate.v3.GcsInputSource) source_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.translate.v3.DatasetInputConfig.InputFile)) {
        return super.equals(obj);
      }
      com.google.cloud.translate.v3.DatasetInputConfig.InputFile other =
          (com.google.cloud.translate.v3.DatasetInputConfig.InputFile) obj;

      if (!getUsage().equals(other.getUsage())) return false;
      if (!getSourceCase().equals(other.getSourceCase())) return false;
      switch (sourceCase_) {
        case 3:
          if (!getGcsSource().equals(other.getGcsSource())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + USAGE_FIELD_NUMBER;
      hash = (53 * hash) + getUsage().hashCode();
      switch (sourceCase_) {
        case 3:
          hash = (37 * hash) + GCS_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getGcsSource().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.translate.v3.DatasetInputConfig.InputFile parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3.DatasetInputConfig.InputFile parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.DatasetInputConfig.InputFile parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3.DatasetInputConfig.InputFile parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.DatasetInputConfig.InputFile parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.translate.v3.DatasetInputConfig.InputFile parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.DatasetInputConfig.InputFile parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3.DatasetInputConfig.InputFile parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.DatasetInputConfig.InputFile parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3.DatasetInputConfig.InputFile parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.translate.v3.DatasetInputConfig.InputFile parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.translate.v3.DatasetInputConfig.InputFile parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.translate.v3.DatasetInputConfig.InputFile prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * An input file.
     * </pre>
     *
     * Protobuf type {@code google.cloud.translation.v3.DatasetInputConfig.InputFile}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.translation.v3.DatasetInputConfig.InputFile)
        com.google.cloud.translate.v3.DatasetInputConfig.InputFileOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.translate.v3.AutoMLTranslationProto
            .internal_static_google_cloud_translation_v3_DatasetInputConfig_InputFile_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.translate.v3.AutoMLTranslationProto
            .internal_static_google_cloud_translation_v3_DatasetInputConfig_InputFile_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.translate.v3.DatasetInputConfig.InputFile.class,
                com.google.cloud.translate.v3.DatasetInputConfig.InputFile.Builder.class);
      }

      // Construct using com.google.cloud.translate.v3.DatasetInputConfig.InputFile.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        usage_ = "";
        if (gcsSourceBuilder_ != null) {
          gcsSourceBuilder_.clear();
        }
        sourceCase_ = 0;
        source_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.translate.v3.AutoMLTranslationProto
            .internal_static_google_cloud_translation_v3_DatasetInputConfig_InputFile_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.translate.v3.DatasetInputConfig.InputFile
          getDefaultInstanceForType() {
        return com.google.cloud.translate.v3.DatasetInputConfig.InputFile.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.translate.v3.DatasetInputConfig.InputFile build() {
        com.google.cloud.translate.v3.DatasetInputConfig.InputFile result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.translate.v3.DatasetInputConfig.InputFile buildPartial() {
        com.google.cloud.translate.v3.DatasetInputConfig.InputFile result =
            new com.google.cloud.translate.v3.DatasetInputConfig.InputFile(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.translate.v3.DatasetInputConfig.InputFile result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.usage_ = usage_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.translate.v3.DatasetInputConfig.InputFile result) {
        result.sourceCase_ = sourceCase_;
        result.source_ = this.source_;
        if (sourceCase_ == 3 && gcsSourceBuilder_ != null) {
          result.source_ = gcsSourceBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.translate.v3.DatasetInputConfig.InputFile) {
          return mergeFrom((com.google.cloud.translate.v3.DatasetInputConfig.InputFile) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.translate.v3.DatasetInputConfig.InputFile other) {
        if (other
            == com.google.cloud.translate.v3.DatasetInputConfig.InputFile.getDefaultInstance())
          return this;
        if (!other.getUsage().isEmpty()) {
          usage_ = other.usage_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        switch (other.getSourceCase()) {
          case GCS_SOURCE:
            {
              mergeGcsSource(other.getGcsSource());
              break;
            }
          case SOURCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 18:
                {
                  usage_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(getGcsSourceFieldBuilder().getBuilder(), extensionRegistry);
                  sourceCase_ = 3;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int sourceCase_ = 0;
      private java.lang.Object source_;

      public SourceCase getSourceCase() {
        return SourceCase.forNumber(sourceCase_);
      }

      public Builder clearSource() {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private java.lang.Object usage_ = "";

      /**
       *
       *
       * <pre>
       * Optional. Usage of the file contents. Options are TRAIN|VALIDATION|TEST,
       * or UNASSIGNED (by default) for auto split.
       * </pre>
       *
       * <code>string usage = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The usage.
       */
      public java.lang.String getUsage() {
        java.lang.Object ref = usage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          usage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Usage of the file contents. Options are TRAIN|VALIDATION|TEST,
       * or UNASSIGNED (by default) for auto split.
       * </pre>
       *
       * <code>string usage = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for usage.
       */
      public com.google.protobuf.ByteString getUsageBytes() {
        java.lang.Object ref = usage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          usage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Usage of the file contents. Options are TRAIN|VALIDATION|TEST,
       * or UNASSIGNED (by default) for auto split.
       * </pre>
       *
       * <code>string usage = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The usage to set.
       * @return This builder for chaining.
       */
      public Builder setUsage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        usage_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Usage of the file contents. Options are TRAIN|VALIDATION|TEST,
       * or UNASSIGNED (by default) for auto split.
       * </pre>
       *
       * <code>string usage = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUsage() {
        usage_ = getDefaultInstance().getUsage();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Usage of the file contents. Options are TRAIN|VALIDATION|TEST,
       * or UNASSIGNED (by default) for auto split.
       * </pre>
       *
       * <code>string usage = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for usage to set.
       * @return This builder for chaining.
       */
      public Builder setUsageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        usage_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.translate.v3.GcsInputSource,
              com.google.cloud.translate.v3.GcsInputSource.Builder,
              com.google.cloud.translate.v3.GcsInputSourceOrBuilder>
          gcsSourceBuilder_;

      /**
       *
       *
       * <pre>
       * Google Cloud Storage file source.
       * </pre>
       *
       * <code>.google.cloud.translation.v3.GcsInputSource gcs_source = 3;</code>
       *
       * @return Whether the gcsSource field is set.
       */
      @java.lang.Override
      public boolean hasGcsSource() {
        return sourceCase_ == 3;
      }

      /**
       *
       *
       * <pre>
       * Google Cloud Storage file source.
       * </pre>
       *
       * <code>.google.cloud.translation.v3.GcsInputSource gcs_source = 3;</code>
       *
       * @return The gcsSource.
       */
      @java.lang.Override
      public com.google.cloud.translate.v3.GcsInputSource getGcsSource() {
        if (gcsSourceBuilder_ == null) {
          if (sourceCase_ == 3) {
            return (com.google.cloud.translate.v3.GcsInputSource) source_;
          }
          return com.google.cloud.translate.v3.GcsInputSource.getDefaultInstance();
        } else {
          if (sourceCase_ == 3) {
            return gcsSourceBuilder_.getMessage();
          }
          return com.google.cloud.translate.v3.GcsInputSource.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Google Cloud Storage file source.
       * </pre>
       *
       * <code>.google.cloud.translation.v3.GcsInputSource gcs_source = 3;</code>
       */
      public Builder setGcsSource(com.google.cloud.translate.v3.GcsInputSource value) {
        if (gcsSourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          source_ = value;
          onChanged();
        } else {
          gcsSourceBuilder_.setMessage(value);
        }
        sourceCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Google Cloud Storage file source.
       * </pre>
       *
       * <code>.google.cloud.translation.v3.GcsInputSource gcs_source = 3;</code>
       */
      public Builder setGcsSource(
          com.google.cloud.translate.v3.GcsInputSource.Builder builderForValue) {
        if (gcsSourceBuilder_ == null) {
          source_ = builderForValue.build();
          onChanged();
        } else {
          gcsSourceBuilder_.setMessage(builderForValue.build());
        }
        sourceCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Google Cloud Storage file source.
       * </pre>
       *
       * <code>.google.cloud.translation.v3.GcsInputSource gcs_source = 3;</code>
       */
      public Builder mergeGcsSource(com.google.cloud.translate.v3.GcsInputSource value) {
        if (gcsSourceBuilder_ == null) {
          if (sourceCase_ == 3
              && source_ != com.google.cloud.translate.v3.GcsInputSource.getDefaultInstance()) {
            source_ =
                com.google.cloud.translate.v3.GcsInputSource.newBuilder(
                        (com.google.cloud.translate.v3.GcsInputSource) source_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            source_ = value;
          }
          onChanged();
        } else {
          if (sourceCase_ == 3) {
            gcsSourceBuilder_.mergeFrom(value);
          } else {
            gcsSourceBuilder_.setMessage(value);
          }
        }
        sourceCase_ = 3;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Google Cloud Storage file source.
       * </pre>
       *
       * <code>.google.cloud.translation.v3.GcsInputSource gcs_source = 3;</code>
       */
      public Builder clearGcsSource() {
        if (gcsSourceBuilder_ == null) {
          if (sourceCase_ == 3) {
            sourceCase_ = 0;
            source_ = null;
            onChanged();
          }
        } else {
          if (sourceCase_ == 3) {
            sourceCase_ = 0;
            source_ = null;
          }
          gcsSourceBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Google Cloud Storage file source.
       * </pre>
       *
       * <code>.google.cloud.translation.v3.GcsInputSource gcs_source = 3;</code>
       */
      public com.google.cloud.translate.v3.GcsInputSource.Builder getGcsSourceBuilder() {
        return getGcsSourceFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Google Cloud Storage file source.
       * </pre>
       *
       * <code>.google.cloud.translation.v3.GcsInputSource gcs_source = 3;</code>
       */
      @java.lang.Override
      public com.google.cloud.translate.v3.GcsInputSourceOrBuilder getGcsSourceOrBuilder() {
        if ((sourceCase_ == 3) && (gcsSourceBuilder_ != null)) {
          return gcsSourceBuilder_.getMessageOrBuilder();
        } else {
          if (sourceCase_ == 3) {
            return (com.google.cloud.translate.v3.GcsInputSource) source_;
          }
          return com.google.cloud.translate.v3.GcsInputSource.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Google Cloud Storage file source.
       * </pre>
       *
       * <code>.google.cloud.translation.v3.GcsInputSource gcs_source = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.translate.v3.GcsInputSource,
              com.google.cloud.translate.v3.GcsInputSource.Builder,
              com.google.cloud.translate.v3.GcsInputSourceOrBuilder>
          getGcsSourceFieldBuilder() {
        if (gcsSourceBuilder_ == null) {
          if (!(sourceCase_ == 3)) {
            source_ = com.google.cloud.translate.v3.GcsInputSource.getDefaultInstance();
          }
          gcsSourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.translate.v3.GcsInputSource,
                  com.google.cloud.translate.v3.GcsInputSource.Builder,
                  com.google.cloud.translate.v3.GcsInputSourceOrBuilder>(
                  (com.google.cloud.translate.v3.GcsInputSource) source_,
                  getParentForChildren(),
                  isClean());
          source_ = null;
        }
        sourceCase_ = 3;
        onChanged();
        return gcsSourceBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.translation.v3.DatasetInputConfig.InputFile)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.translation.v3.DatasetInputConfig.InputFile)
    private static final com.google.cloud.translate.v3.DatasetInputConfig.InputFile
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.translate.v3.DatasetInputConfig.InputFile();
    }

    public static com.google.cloud.translate.v3.DatasetInputConfig.InputFile getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<InputFile> PARSER =
        new com.google.protobuf.AbstractParser<InputFile>() {
          @java.lang.Override
          public InputFile parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<InputFile> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<InputFile> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.DatasetInputConfig.InputFile getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int INPUT_FILES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.translate.v3.DatasetInputConfig.InputFile> inputFiles_;

  /**
   *
   *
   * <pre>
   * Files containing the sentence pairs to be imported to the dataset.
   * </pre>
   *
   * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.translate.v3.DatasetInputConfig.InputFile>
      getInputFilesList() {
    return inputFiles_;
  }

  /**
   *
   *
   * <pre>
   * Files containing the sentence pairs to be imported to the dataset.
   * </pre>
   *
   * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.translate.v3.DatasetInputConfig.InputFileOrBuilder>
      getInputFilesOrBuilderList() {
    return inputFiles_;
  }

  /**
   *
   *
   * <pre>
   * Files containing the sentence pairs to be imported to the dataset.
   * </pre>
   *
   * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
   * </code>
   */
  @java.lang.Override
  public int getInputFilesCount() {
    return inputFiles_.size();
  }

  /**
   *
   *
   * <pre>
   * Files containing the sentence pairs to be imported to the dataset.
   * </pre>
   *
   * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3.DatasetInputConfig.InputFile getInputFiles(int index) {
    return inputFiles_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Files containing the sentence pairs to be imported to the dataset.
   * </pre>
   *
   * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3.DatasetInputConfig.InputFileOrBuilder getInputFilesOrBuilder(
      int index) {
    return inputFiles_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < inputFiles_.size(); i++) {
      output.writeMessage(1, inputFiles_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < inputFiles_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, inputFiles_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.translate.v3.DatasetInputConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.translate.v3.DatasetInputConfig other =
        (com.google.cloud.translate.v3.DatasetInputConfig) obj;

    if (!getInputFilesList().equals(other.getInputFilesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getInputFilesCount() > 0) {
      hash = (37 * hash) + INPUT_FILES_FIELD_NUMBER;
      hash = (53 * hash) + getInputFilesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.translate.v3.DatasetInputConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.DatasetInputConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.DatasetInputConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.DatasetInputConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.DatasetInputConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.DatasetInputConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.DatasetInputConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.DatasetInputConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.DatasetInputConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.DatasetInputConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.DatasetInputConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.DatasetInputConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.translate.v3.DatasetInputConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Input configuration for datasets.
   * </pre>
   *
   * Protobuf type {@code google.cloud.translation.v3.DatasetInputConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.translation.v3.DatasetInputConfig)
      com.google.cloud.translate.v3.DatasetInputConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.translate.v3.AutoMLTranslationProto
          .internal_static_google_cloud_translation_v3_DatasetInputConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.translate.v3.AutoMLTranslationProto
          .internal_static_google_cloud_translation_v3_DatasetInputConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.translate.v3.DatasetInputConfig.class,
              com.google.cloud.translate.v3.DatasetInputConfig.Builder.class);
    }

    // Construct using com.google.cloud.translate.v3.DatasetInputConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (inputFilesBuilder_ == null) {
        inputFiles_ = java.util.Collections.emptyList();
      } else {
        inputFiles_ = null;
        inputFilesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.translate.v3.AutoMLTranslationProto
          .internal_static_google_cloud_translation_v3_DatasetInputConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.DatasetInputConfig getDefaultInstanceForType() {
      return com.google.cloud.translate.v3.DatasetInputConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.DatasetInputConfig build() {
      com.google.cloud.translate.v3.DatasetInputConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.DatasetInputConfig buildPartial() {
      com.google.cloud.translate.v3.DatasetInputConfig result =
          new com.google.cloud.translate.v3.DatasetInputConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.translate.v3.DatasetInputConfig result) {
      if (inputFilesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          inputFiles_ = java.util.Collections.unmodifiableList(inputFiles_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.inputFiles_ = inputFiles_;
      } else {
        result.inputFiles_ = inputFilesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.translate.v3.DatasetInputConfig result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.translate.v3.DatasetInputConfig) {
        return mergeFrom((com.google.cloud.translate.v3.DatasetInputConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.translate.v3.DatasetInputConfig other) {
      if (other == com.google.cloud.translate.v3.DatasetInputConfig.getDefaultInstance())
        return this;
      if (inputFilesBuilder_ == null) {
        if (!other.inputFiles_.isEmpty()) {
          if (inputFiles_.isEmpty()) {
            inputFiles_ = other.inputFiles_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureInputFilesIsMutable();
            inputFiles_.addAll(other.inputFiles_);
          }
          onChanged();
        }
      } else {
        if (!other.inputFiles_.isEmpty()) {
          if (inputFilesBuilder_.isEmpty()) {
            inputFilesBuilder_.dispose();
            inputFilesBuilder_ = null;
            inputFiles_ = other.inputFiles_;
            bitField0_ = (bitField0_ & ~0x00000001);
            inputFilesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getInputFilesFieldBuilder()
                    : null;
          } else {
            inputFilesBuilder_.addAllMessages(other.inputFiles_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.translate.v3.DatasetInputConfig.InputFile m =
                    input.readMessage(
                        com.google.cloud.translate.v3.DatasetInputConfig.InputFile.parser(),
                        extensionRegistry);
                if (inputFilesBuilder_ == null) {
                  ensureInputFilesIsMutable();
                  inputFiles_.add(m);
                } else {
                  inputFilesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.translate.v3.DatasetInputConfig.InputFile> inputFiles_ =
        java.util.Collections.emptyList();

    private void ensureInputFilesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        inputFiles_ =
            new java.util.ArrayList<com.google.cloud.translate.v3.DatasetInputConfig.InputFile>(
                inputFiles_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.translate.v3.DatasetInputConfig.InputFile,
            com.google.cloud.translate.v3.DatasetInputConfig.InputFile.Builder,
            com.google.cloud.translate.v3.DatasetInputConfig.InputFileOrBuilder>
        inputFilesBuilder_;

    /**
     *
     *
     * <pre>
     * Files containing the sentence pairs to be imported to the dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.translate.v3.DatasetInputConfig.InputFile>
        getInputFilesList() {
      if (inputFilesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(inputFiles_);
      } else {
        return inputFilesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Files containing the sentence pairs to be imported to the dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
     * </code>
     */
    public int getInputFilesCount() {
      if (inputFilesBuilder_ == null) {
        return inputFiles_.size();
      } else {
        return inputFilesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Files containing the sentence pairs to be imported to the dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
     * </code>
     */
    public com.google.cloud.translate.v3.DatasetInputConfig.InputFile getInputFiles(int index) {
      if (inputFilesBuilder_ == null) {
        return inputFiles_.get(index);
      } else {
        return inputFilesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Files containing the sentence pairs to be imported to the dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
     * </code>
     */
    public Builder setInputFiles(
        int index, com.google.cloud.translate.v3.DatasetInputConfig.InputFile value) {
      if (inputFilesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputFilesIsMutable();
        inputFiles_.set(index, value);
        onChanged();
      } else {
        inputFilesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Files containing the sentence pairs to be imported to the dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
     * </code>
     */
    public Builder setInputFiles(
        int index,
        com.google.cloud.translate.v3.DatasetInputConfig.InputFile.Builder builderForValue) {
      if (inputFilesBuilder_ == null) {
        ensureInputFilesIsMutable();
        inputFiles_.set(index, builderForValue.build());
        onChanged();
      } else {
        inputFilesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Files containing the sentence pairs to be imported to the dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
     * </code>
     */
    public Builder addInputFiles(com.google.cloud.translate.v3.DatasetInputConfig.InputFile value) {
      if (inputFilesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputFilesIsMutable();
        inputFiles_.add(value);
        onChanged();
      } else {
        inputFilesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Files containing the sentence pairs to be imported to the dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
     * </code>
     */
    public Builder addInputFiles(
        int index, com.google.cloud.translate.v3.DatasetInputConfig.InputFile value) {
      if (inputFilesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureInputFilesIsMutable();
        inputFiles_.add(index, value);
        onChanged();
      } else {
        inputFilesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Files containing the sentence pairs to be imported to the dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
     * </code>
     */
    public Builder addInputFiles(
        com.google.cloud.translate.v3.DatasetInputConfig.InputFile.Builder builderForValue) {
      if (inputFilesBuilder_ == null) {
        ensureInputFilesIsMutable();
        inputFiles_.add(builderForValue.build());
        onChanged();
      } else {
        inputFilesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Files containing the sentence pairs to be imported to the dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
     * </code>
     */
    public Builder addInputFiles(
        int index,
        com.google.cloud.translate.v3.DatasetInputConfig.InputFile.Builder builderForValue) {
      if (inputFilesBuilder_ == null) {
        ensureInputFilesIsMutable();
        inputFiles_.add(index, builderForValue.build());
        onChanged();
      } else {
        inputFilesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Files containing the sentence pairs to be imported to the dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
     * </code>
     */
    public Builder addAllInputFiles(
        java.lang.Iterable<? extends com.google.cloud.translate.v3.DatasetInputConfig.InputFile>
            values) {
      if (inputFilesBuilder_ == null) {
        ensureInputFilesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, inputFiles_);
        onChanged();
      } else {
        inputFilesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Files containing the sentence pairs to be imported to the dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
     * </code>
     */
    public Builder clearInputFiles() {
      if (inputFilesBuilder_ == null) {
        inputFiles_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        inputFilesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Files containing the sentence pairs to be imported to the dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
     * </code>
     */
    public Builder removeInputFiles(int index) {
      if (inputFilesBuilder_ == null) {
        ensureInputFilesIsMutable();
        inputFiles_.remove(index);
        onChanged();
      } else {
        inputFilesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Files containing the sentence pairs to be imported to the dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
     * </code>
     */
    public com.google.cloud.translate.v3.DatasetInputConfig.InputFile.Builder getInputFilesBuilder(
        int index) {
      return getInputFilesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Files containing the sentence pairs to be imported to the dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
     * </code>
     */
    public com.google.cloud.translate.v3.DatasetInputConfig.InputFileOrBuilder
        getInputFilesOrBuilder(int index) {
      if (inputFilesBuilder_ == null) {
        return inputFiles_.get(index);
      } else {
        return inputFilesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Files containing the sentence pairs to be imported to the dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.translate.v3.DatasetInputConfig.InputFileOrBuilder>
        getInputFilesOrBuilderList() {
      if (inputFilesBuilder_ != null) {
        return inputFilesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(inputFiles_);
      }
    }

    /**
     *
     *
     * <pre>
     * Files containing the sentence pairs to be imported to the dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
     * </code>
     */
    public com.google.cloud.translate.v3.DatasetInputConfig.InputFile.Builder
        addInputFilesBuilder() {
      return getInputFilesFieldBuilder()
          .addBuilder(
              com.google.cloud.translate.v3.DatasetInputConfig.InputFile.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Files containing the sentence pairs to be imported to the dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
     * </code>
     */
    public com.google.cloud.translate.v3.DatasetInputConfig.InputFile.Builder addInputFilesBuilder(
        int index) {
      return getInputFilesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.translate.v3.DatasetInputConfig.InputFile.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Files containing the sentence pairs to be imported to the dataset.
     * </pre>
     *
     * <code>repeated .google.cloud.translation.v3.DatasetInputConfig.InputFile input_files = 1;
     * </code>
     */
    public java.util.List<com.google.cloud.translate.v3.DatasetInputConfig.InputFile.Builder>
        getInputFilesBuilderList() {
      return getInputFilesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.translate.v3.DatasetInputConfig.InputFile,
            com.google.cloud.translate.v3.DatasetInputConfig.InputFile.Builder,
            com.google.cloud.translate.v3.DatasetInputConfig.InputFileOrBuilder>
        getInputFilesFieldBuilder() {
      if (inputFilesBuilder_ == null) {
        inputFilesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.translate.v3.DatasetInputConfig.InputFile,
                com.google.cloud.translate.v3.DatasetInputConfig.InputFile.Builder,
                com.google.cloud.translate.v3.DatasetInputConfig.InputFileOrBuilder>(
                inputFiles_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        inputFiles_ = null;
      }
      return inputFilesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.translation.v3.DatasetInputConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.translation.v3.DatasetInputConfig)
  private static final com.google.cloud.translate.v3.DatasetInputConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.translate.v3.DatasetInputConfig();
  }

  public static com.google.cloud.translate.v3.DatasetInputConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DatasetInputConfig> PARSER =
      new com.google.protobuf.AbstractParser<DatasetInputConfig>() {
        @java.lang.Override
        public DatasetInputConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DatasetInputConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DatasetInputConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.translate.v3.DatasetInputConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
