/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/translate/v3/translation_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.translate.v3;

/**
 *
 *
 * <pre>
 * A document translation request output config.
 * </pre>
 *
 * Protobuf type {@code google.cloud.translation.v3.DocumentOutputConfig}
 */
public final class DocumentOutputConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.translation.v3.DocumentOutputConfig)
    DocumentOutputConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use DocumentOutputConfig.newBuilder() to construct.
  private DocumentOutputConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DocumentOutputConfig() {
    mimeType_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DocumentOutputConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.translate.v3.TranslationServiceProto
        .internal_static_google_cloud_translation_v3_DocumentOutputConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.translate.v3.TranslationServiceProto
        .internal_static_google_cloud_translation_v3_DocumentOutputConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.translate.v3.DocumentOutputConfig.class,
            com.google.cloud.translate.v3.DocumentOutputConfig.Builder.class);
  }

  private int destinationCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object destination_;

  public enum DestinationCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GCS_DESTINATION(1),
    DESTINATION_NOT_SET(0);
    private final int value;

    private DestinationCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DestinationCase valueOf(int value) {
      return forNumber(value);
    }

    public static DestinationCase forNumber(int value) {
      switch (value) {
        case 1:
          return GCS_DESTINATION;
        case 0:
          return DESTINATION_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DestinationCase getDestinationCase() {
    return DestinationCase.forNumber(destinationCase_);
  }

  public static final int GCS_DESTINATION_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * Optional. Google Cloud Storage destination for the translation output,
   * e.g., `gs://my_bucket/my_directory/`.
   *
   * The destination directory provided does not have to be empty, but the
   * bucket must exist. If a file with the same name as the output file
   * already exists in the destination an error will be returned.
   *
   * For a DocumentInputConfig.contents provided document, the output file
   * will have the name "output_[trg]_translations.[ext]", where
   * - [trg] corresponds to the translated file's language code,
   * - [ext] corresponds to the translated file's extension according to its
   * mime type.
   *
   *
   * For a DocumentInputConfig.gcs_uri provided document, the output file will
   * have a name according to its URI. For example: an input file with URI:
   * `gs://a/b/c.[extension]` stored in a gcs_destination bucket with name
   * "my_bucket" will have an output URI:
   * `gs://my_bucket/a_b_c_[trg]_translations.[ext]`, where
   * - [trg] corresponds to the translated file's language code,
   * - [ext] corresponds to the translated file's extension according to its
   * mime type.
   *
   *
   * If the document was directly provided through the request, then the
   * output document will have the format:
   * `gs://my_bucket/translated_document_[trg]_translations.[ext]`, where
   * - [trg] corresponds to the translated file's language code,
   * - [ext] corresponds to the translated file's extension according to its
   * mime type.
   *
   * If a glossary was provided, then the output URI for the glossary
   * translation will be equal to the default output URI but have
   * `glossary_translations` instead of `translations`. For the previous
   * example, its glossary URI would be:
   * `gs://my_bucket/a_b_c_[trg]_glossary_translations.[ext]`.
   *
   * Thus the max number of output files will be 2 (Translated document,
   * Glossary translated document).
   *
   * Callers should expect no partial outputs. If there is any error during
   * document translation, no output will be stored in the Cloud Storage
   * bucket.
   * </pre>
   *
   * <code>
   * .google.cloud.translation.v3.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the gcsDestination field is set.
   */
  @java.lang.Override
  public boolean hasGcsDestination() {
    return destinationCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * Optional. Google Cloud Storage destination for the translation output,
   * e.g., `gs://my_bucket/my_directory/`.
   *
   * The destination directory provided does not have to be empty, but the
   * bucket must exist. If a file with the same name as the output file
   * already exists in the destination an error will be returned.
   *
   * For a DocumentInputConfig.contents provided document, the output file
   * will have the name "output_[trg]_translations.[ext]", where
   * - [trg] corresponds to the translated file's language code,
   * - [ext] corresponds to the translated file's extension according to its
   * mime type.
   *
   *
   * For a DocumentInputConfig.gcs_uri provided document, the output file will
   * have a name according to its URI. For example: an input file with URI:
   * `gs://a/b/c.[extension]` stored in a gcs_destination bucket with name
   * "my_bucket" will have an output URI:
   * `gs://my_bucket/a_b_c_[trg]_translations.[ext]`, where
   * - [trg] corresponds to the translated file's language code,
   * - [ext] corresponds to the translated file's extension according to its
   * mime type.
   *
   *
   * If the document was directly provided through the request, then the
   * output document will have the format:
   * `gs://my_bucket/translated_document_[trg]_translations.[ext]`, where
   * - [trg] corresponds to the translated file's language code,
   * - [ext] corresponds to the translated file's extension according to its
   * mime type.
   *
   * If a glossary was provided, then the output URI for the glossary
   * translation will be equal to the default output URI but have
   * `glossary_translations` instead of `translations`. For the previous
   * example, its glossary URI would be:
   * `gs://my_bucket/a_b_c_[trg]_glossary_translations.[ext]`.
   *
   * Thus the max number of output files will be 2 (Translated document,
   * Glossary translated document).
   *
   * Callers should expect no partial outputs. If there is any error during
   * document translation, no output will be stored in the Cloud Storage
   * bucket.
   * </pre>
   *
   * <code>
   * .google.cloud.translation.v3.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The gcsDestination.
   */
  @java.lang.Override
  public com.google.cloud.translate.v3.GcsDestination getGcsDestination() {
    if (destinationCase_ == 1) {
      return (com.google.cloud.translate.v3.GcsDestination) destination_;
    }
    return com.google.cloud.translate.v3.GcsDestination.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. Google Cloud Storage destination for the translation output,
   * e.g., `gs://my_bucket/my_directory/`.
   *
   * The destination directory provided does not have to be empty, but the
   * bucket must exist. If a file with the same name as the output file
   * already exists in the destination an error will be returned.
   *
   * For a DocumentInputConfig.contents provided document, the output file
   * will have the name "output_[trg]_translations.[ext]", where
   * - [trg] corresponds to the translated file's language code,
   * - [ext] corresponds to the translated file's extension according to its
   * mime type.
   *
   *
   * For a DocumentInputConfig.gcs_uri provided document, the output file will
   * have a name according to its URI. For example: an input file with URI:
   * `gs://a/b/c.[extension]` stored in a gcs_destination bucket with name
   * "my_bucket" will have an output URI:
   * `gs://my_bucket/a_b_c_[trg]_translations.[ext]`, where
   * - [trg] corresponds to the translated file's language code,
   * - [ext] corresponds to the translated file's extension according to its
   * mime type.
   *
   *
   * If the document was directly provided through the request, then the
   * output document will have the format:
   * `gs://my_bucket/translated_document_[trg]_translations.[ext]`, where
   * - [trg] corresponds to the translated file's language code,
   * - [ext] corresponds to the translated file's extension according to its
   * mime type.
   *
   * If a glossary was provided, then the output URI for the glossary
   * translation will be equal to the default output URI but have
   * `glossary_translations` instead of `translations`. For the previous
   * example, its glossary URI would be:
   * `gs://my_bucket/a_b_c_[trg]_glossary_translations.[ext]`.
   *
   * Thus the max number of output files will be 2 (Translated document,
   * Glossary translated document).
   *
   * Callers should expect no partial outputs. If there is any error during
   * document translation, no output will be stored in the Cloud Storage
   * bucket.
   * </pre>
   *
   * <code>
   * .google.cloud.translation.v3.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.translate.v3.GcsDestinationOrBuilder getGcsDestinationOrBuilder() {
    if (destinationCase_ == 1) {
      return (com.google.cloud.translate.v3.GcsDestination) destination_;
    }
    return com.google.cloud.translate.v3.GcsDestination.getDefaultInstance();
  }

  public static final int MIME_TYPE_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object mimeType_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Specifies the translated document's mime_type.
   * If not specified, the translated file's mime type will be the same as the
   * input file's mime type.
   * Currently only support the output mime type to be the same as input mime
   * type.
   * - application/pdf
   * - application/vnd.openxmlformats-officedocument.wordprocessingml.document
   * - application/vnd.openxmlformats-officedocument.presentationml.presentation
   * - application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
   * </pre>
   *
   * <code>string mime_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The mimeType.
   */
  @java.lang.Override
  public java.lang.String getMimeType() {
    java.lang.Object ref = mimeType_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      mimeType_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Specifies the translated document's mime_type.
   * If not specified, the translated file's mime type will be the same as the
   * input file's mime type.
   * Currently only support the output mime type to be the same as input mime
   * type.
   * - application/pdf
   * - application/vnd.openxmlformats-officedocument.wordprocessingml.document
   * - application/vnd.openxmlformats-officedocument.presentationml.presentation
   * - application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
   * </pre>
   *
   * <code>string mime_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for mimeType.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMimeTypeBytes() {
    java.lang.Object ref = mimeType_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      mimeType_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (destinationCase_ == 1) {
      output.writeMessage(1, (com.google.cloud.translate.v3.GcsDestination) destination_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mimeType_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, mimeType_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (destinationCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.translate.v3.GcsDestination) destination_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(mimeType_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, mimeType_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.translate.v3.DocumentOutputConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.translate.v3.DocumentOutputConfig other =
        (com.google.cloud.translate.v3.DocumentOutputConfig) obj;

    if (!getMimeType().equals(other.getMimeType())) return false;
    if (!getDestinationCase().equals(other.getDestinationCase())) return false;
    switch (destinationCase_) {
      case 1:
        if (!getGcsDestination().equals(other.getGcsDestination())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + MIME_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getMimeType().hashCode();
    switch (destinationCase_) {
      case 1:
        hash = (37 * hash) + GCS_DESTINATION_FIELD_NUMBER;
        hash = (53 * hash) + getGcsDestination().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.translate.v3.DocumentOutputConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.DocumentOutputConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.DocumentOutputConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.DocumentOutputConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.DocumentOutputConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.translate.v3.DocumentOutputConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.DocumentOutputConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.DocumentOutputConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.DocumentOutputConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.DocumentOutputConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.translate.v3.DocumentOutputConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.translate.v3.DocumentOutputConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.translate.v3.DocumentOutputConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A document translation request output config.
   * </pre>
   *
   * Protobuf type {@code google.cloud.translation.v3.DocumentOutputConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.translation.v3.DocumentOutputConfig)
      com.google.cloud.translate.v3.DocumentOutputConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.translate.v3.TranslationServiceProto
          .internal_static_google_cloud_translation_v3_DocumentOutputConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.translate.v3.TranslationServiceProto
          .internal_static_google_cloud_translation_v3_DocumentOutputConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.translate.v3.DocumentOutputConfig.class,
              com.google.cloud.translate.v3.DocumentOutputConfig.Builder.class);
    }

    // Construct using com.google.cloud.translate.v3.DocumentOutputConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (gcsDestinationBuilder_ != null) {
        gcsDestinationBuilder_.clear();
      }
      mimeType_ = "";
      destinationCase_ = 0;
      destination_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.translate.v3.TranslationServiceProto
          .internal_static_google_cloud_translation_v3_DocumentOutputConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.DocumentOutputConfig getDefaultInstanceForType() {
      return com.google.cloud.translate.v3.DocumentOutputConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.DocumentOutputConfig build() {
      com.google.cloud.translate.v3.DocumentOutputConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.translate.v3.DocumentOutputConfig buildPartial() {
      com.google.cloud.translate.v3.DocumentOutputConfig result =
          new com.google.cloud.translate.v3.DocumentOutputConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.translate.v3.DocumentOutputConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.mimeType_ = mimeType_;
      }
    }

    private void buildPartialOneofs(com.google.cloud.translate.v3.DocumentOutputConfig result) {
      result.destinationCase_ = destinationCase_;
      result.destination_ = this.destination_;
      if (destinationCase_ == 1 && gcsDestinationBuilder_ != null) {
        result.destination_ = gcsDestinationBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.translate.v3.DocumentOutputConfig) {
        return mergeFrom((com.google.cloud.translate.v3.DocumentOutputConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.translate.v3.DocumentOutputConfig other) {
      if (other == com.google.cloud.translate.v3.DocumentOutputConfig.getDefaultInstance())
        return this;
      if (!other.getMimeType().isEmpty()) {
        mimeType_ = other.mimeType_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      switch (other.getDestinationCase()) {
        case GCS_DESTINATION:
          {
            mergeGcsDestination(other.getGcsDestination());
            break;
          }
        case DESTINATION_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getGcsDestinationFieldBuilder().getBuilder(), extensionRegistry);
                destinationCase_ = 1;
                break;
              } // case 10
            case 26:
              {
                mimeType_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int destinationCase_ = 0;
    private java.lang.Object destination_;

    public DestinationCase getDestinationCase() {
      return DestinationCase.forNumber(destinationCase_);
    }

    public Builder clearDestination() {
      destinationCase_ = 0;
      destination_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3.GcsDestination,
            com.google.cloud.translate.v3.GcsDestination.Builder,
            com.google.cloud.translate.v3.GcsDestinationOrBuilder>
        gcsDestinationBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Google Cloud Storage destination for the translation output,
     * e.g., `gs://my_bucket/my_directory/`.
     *
     * The destination directory provided does not have to be empty, but the
     * bucket must exist. If a file with the same name as the output file
     * already exists in the destination an error will be returned.
     *
     * For a DocumentInputConfig.contents provided document, the output file
     * will have the name "output_[trg]_translations.[ext]", where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     *
     * For a DocumentInputConfig.gcs_uri provided document, the output file will
     * have a name according to its URI. For example: an input file with URI:
     * `gs://a/b/c.[extension]` stored in a gcs_destination bucket with name
     * "my_bucket" will have an output URI:
     * `gs://my_bucket/a_b_c_[trg]_translations.[ext]`, where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     *
     * If the document was directly provided through the request, then the
     * output document will have the format:
     * `gs://my_bucket/translated_document_[trg]_translations.[ext]`, where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     * If a glossary was provided, then the output URI for the glossary
     * translation will be equal to the default output URI but have
     * `glossary_translations` instead of `translations`. For the previous
     * example, its glossary URI would be:
     * `gs://my_bucket/a_b_c_[trg]_glossary_translations.[ext]`.
     *
     * Thus the max number of output files will be 2 (Translated document,
     * Glossary translated document).
     *
     * Callers should expect no partial outputs. If there is any error during
     * document translation, no output will be stored in the Cloud Storage
     * bucket.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the gcsDestination field is set.
     */
    @java.lang.Override
    public boolean hasGcsDestination() {
      return destinationCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Optional. Google Cloud Storage destination for the translation output,
     * e.g., `gs://my_bucket/my_directory/`.
     *
     * The destination directory provided does not have to be empty, but the
     * bucket must exist. If a file with the same name as the output file
     * already exists in the destination an error will be returned.
     *
     * For a DocumentInputConfig.contents provided document, the output file
     * will have the name "output_[trg]_translations.[ext]", where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     *
     * For a DocumentInputConfig.gcs_uri provided document, the output file will
     * have a name according to its URI. For example: an input file with URI:
     * `gs://a/b/c.[extension]` stored in a gcs_destination bucket with name
     * "my_bucket" will have an output URI:
     * `gs://my_bucket/a_b_c_[trg]_translations.[ext]`, where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     *
     * If the document was directly provided through the request, then the
     * output document will have the format:
     * `gs://my_bucket/translated_document_[trg]_translations.[ext]`, where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     * If a glossary was provided, then the output URI for the glossary
     * translation will be equal to the default output URI but have
     * `glossary_translations` instead of `translations`. For the previous
     * example, its glossary URI would be:
     * `gs://my_bucket/a_b_c_[trg]_glossary_translations.[ext]`.
     *
     * Thus the max number of output files will be 2 (Translated document,
     * Glossary translated document).
     *
     * Callers should expect no partial outputs. If there is any error during
     * document translation, no output will be stored in the Cloud Storage
     * bucket.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The gcsDestination.
     */
    @java.lang.Override
    public com.google.cloud.translate.v3.GcsDestination getGcsDestination() {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 1) {
          return (com.google.cloud.translate.v3.GcsDestination) destination_;
        }
        return com.google.cloud.translate.v3.GcsDestination.getDefaultInstance();
      } else {
        if (destinationCase_ == 1) {
          return gcsDestinationBuilder_.getMessage();
        }
        return com.google.cloud.translate.v3.GcsDestination.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Google Cloud Storage destination for the translation output,
     * e.g., `gs://my_bucket/my_directory/`.
     *
     * The destination directory provided does not have to be empty, but the
     * bucket must exist. If a file with the same name as the output file
     * already exists in the destination an error will be returned.
     *
     * For a DocumentInputConfig.contents provided document, the output file
     * will have the name "output_[trg]_translations.[ext]", where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     *
     * For a DocumentInputConfig.gcs_uri provided document, the output file will
     * have a name according to its URI. For example: an input file with URI:
     * `gs://a/b/c.[extension]` stored in a gcs_destination bucket with name
     * "my_bucket" will have an output URI:
     * `gs://my_bucket/a_b_c_[trg]_translations.[ext]`, where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     *
     * If the document was directly provided through the request, then the
     * output document will have the format:
     * `gs://my_bucket/translated_document_[trg]_translations.[ext]`, where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     * If a glossary was provided, then the output URI for the glossary
     * translation will be equal to the default output URI but have
     * `glossary_translations` instead of `translations`. For the previous
     * example, its glossary URI would be:
     * `gs://my_bucket/a_b_c_[trg]_glossary_translations.[ext]`.
     *
     * Thus the max number of output files will be 2 (Translated document,
     * Glossary translated document).
     *
     * Callers should expect no partial outputs. If there is any error during
     * document translation, no output will be stored in the Cloud Storage
     * bucket.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGcsDestination(com.google.cloud.translate.v3.GcsDestination value) {
      if (gcsDestinationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        destination_ = value;
        onChanged();
      } else {
        gcsDestinationBuilder_.setMessage(value);
      }
      destinationCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Google Cloud Storage destination for the translation output,
     * e.g., `gs://my_bucket/my_directory/`.
     *
     * The destination directory provided does not have to be empty, but the
     * bucket must exist. If a file with the same name as the output file
     * already exists in the destination an error will be returned.
     *
     * For a DocumentInputConfig.contents provided document, the output file
     * will have the name "output_[trg]_translations.[ext]", where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     *
     * For a DocumentInputConfig.gcs_uri provided document, the output file will
     * have a name according to its URI. For example: an input file with URI:
     * `gs://a/b/c.[extension]` stored in a gcs_destination bucket with name
     * "my_bucket" will have an output URI:
     * `gs://my_bucket/a_b_c_[trg]_translations.[ext]`, where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     *
     * If the document was directly provided through the request, then the
     * output document will have the format:
     * `gs://my_bucket/translated_document_[trg]_translations.[ext]`, where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     * If a glossary was provided, then the output URI for the glossary
     * translation will be equal to the default output URI but have
     * `glossary_translations` instead of `translations`. For the previous
     * example, its glossary URI would be:
     * `gs://my_bucket/a_b_c_[trg]_glossary_translations.[ext]`.
     *
     * Thus the max number of output files will be 2 (Translated document,
     * Glossary translated document).
     *
     * Callers should expect no partial outputs. If there is any error during
     * document translation, no output will be stored in the Cloud Storage
     * bucket.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setGcsDestination(
        com.google.cloud.translate.v3.GcsDestination.Builder builderForValue) {
      if (gcsDestinationBuilder_ == null) {
        destination_ = builderForValue.build();
        onChanged();
      } else {
        gcsDestinationBuilder_.setMessage(builderForValue.build());
      }
      destinationCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Google Cloud Storage destination for the translation output,
     * e.g., `gs://my_bucket/my_directory/`.
     *
     * The destination directory provided does not have to be empty, but the
     * bucket must exist. If a file with the same name as the output file
     * already exists in the destination an error will be returned.
     *
     * For a DocumentInputConfig.contents provided document, the output file
     * will have the name "output_[trg]_translations.[ext]", where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     *
     * For a DocumentInputConfig.gcs_uri provided document, the output file will
     * have a name according to its URI. For example: an input file with URI:
     * `gs://a/b/c.[extension]` stored in a gcs_destination bucket with name
     * "my_bucket" will have an output URI:
     * `gs://my_bucket/a_b_c_[trg]_translations.[ext]`, where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     *
     * If the document was directly provided through the request, then the
     * output document will have the format:
     * `gs://my_bucket/translated_document_[trg]_translations.[ext]`, where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     * If a glossary was provided, then the output URI for the glossary
     * translation will be equal to the default output URI but have
     * `glossary_translations` instead of `translations`. For the previous
     * example, its glossary URI would be:
     * `gs://my_bucket/a_b_c_[trg]_glossary_translations.[ext]`.
     *
     * Thus the max number of output files will be 2 (Translated document,
     * Glossary translated document).
     *
     * Callers should expect no partial outputs. If there is any error during
     * document translation, no output will be stored in the Cloud Storage
     * bucket.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeGcsDestination(com.google.cloud.translate.v3.GcsDestination value) {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 1
            && destination_ != com.google.cloud.translate.v3.GcsDestination.getDefaultInstance()) {
          destination_ =
              com.google.cloud.translate.v3.GcsDestination.newBuilder(
                      (com.google.cloud.translate.v3.GcsDestination) destination_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          destination_ = value;
        }
        onChanged();
      } else {
        if (destinationCase_ == 1) {
          gcsDestinationBuilder_.mergeFrom(value);
        } else {
          gcsDestinationBuilder_.setMessage(value);
        }
      }
      destinationCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Google Cloud Storage destination for the translation output,
     * e.g., `gs://my_bucket/my_directory/`.
     *
     * The destination directory provided does not have to be empty, but the
     * bucket must exist. If a file with the same name as the output file
     * already exists in the destination an error will be returned.
     *
     * For a DocumentInputConfig.contents provided document, the output file
     * will have the name "output_[trg]_translations.[ext]", where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     *
     * For a DocumentInputConfig.gcs_uri provided document, the output file will
     * have a name according to its URI. For example: an input file with URI:
     * `gs://a/b/c.[extension]` stored in a gcs_destination bucket with name
     * "my_bucket" will have an output URI:
     * `gs://my_bucket/a_b_c_[trg]_translations.[ext]`, where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     *
     * If the document was directly provided through the request, then the
     * output document will have the format:
     * `gs://my_bucket/translated_document_[trg]_translations.[ext]`, where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     * If a glossary was provided, then the output URI for the glossary
     * translation will be equal to the default output URI but have
     * `glossary_translations` instead of `translations`. For the previous
     * example, its glossary URI would be:
     * `gs://my_bucket/a_b_c_[trg]_glossary_translations.[ext]`.
     *
     * Thus the max number of output files will be 2 (Translated document,
     * Glossary translated document).
     *
     * Callers should expect no partial outputs. If there is any error during
     * document translation, no output will be stored in the Cloud Storage
     * bucket.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearGcsDestination() {
      if (gcsDestinationBuilder_ == null) {
        if (destinationCase_ == 1) {
          destinationCase_ = 0;
          destination_ = null;
          onChanged();
        }
      } else {
        if (destinationCase_ == 1) {
          destinationCase_ = 0;
          destination_ = null;
        }
        gcsDestinationBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Google Cloud Storage destination for the translation output,
     * e.g., `gs://my_bucket/my_directory/`.
     *
     * The destination directory provided does not have to be empty, but the
     * bucket must exist. If a file with the same name as the output file
     * already exists in the destination an error will be returned.
     *
     * For a DocumentInputConfig.contents provided document, the output file
     * will have the name "output_[trg]_translations.[ext]", where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     *
     * For a DocumentInputConfig.gcs_uri provided document, the output file will
     * have a name according to its URI. For example: an input file with URI:
     * `gs://a/b/c.[extension]` stored in a gcs_destination bucket with name
     * "my_bucket" will have an output URI:
     * `gs://my_bucket/a_b_c_[trg]_translations.[ext]`, where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     *
     * If the document was directly provided through the request, then the
     * output document will have the format:
     * `gs://my_bucket/translated_document_[trg]_translations.[ext]`, where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     * If a glossary was provided, then the output URI for the glossary
     * translation will be equal to the default output URI but have
     * `glossary_translations` instead of `translations`. For the previous
     * example, its glossary URI would be:
     * `gs://my_bucket/a_b_c_[trg]_glossary_translations.[ext]`.
     *
     * Thus the max number of output files will be 2 (Translated document,
     * Glossary translated document).
     *
     * Callers should expect no partial outputs. If there is any error during
     * document translation, no output will be stored in the Cloud Storage
     * bucket.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.translate.v3.GcsDestination.Builder getGcsDestinationBuilder() {
      return getGcsDestinationFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Google Cloud Storage destination for the translation output,
     * e.g., `gs://my_bucket/my_directory/`.
     *
     * The destination directory provided does not have to be empty, but the
     * bucket must exist. If a file with the same name as the output file
     * already exists in the destination an error will be returned.
     *
     * For a DocumentInputConfig.contents provided document, the output file
     * will have the name "output_[trg]_translations.[ext]", where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     *
     * For a DocumentInputConfig.gcs_uri provided document, the output file will
     * have a name according to its URI. For example: an input file with URI:
     * `gs://a/b/c.[extension]` stored in a gcs_destination bucket with name
     * "my_bucket" will have an output URI:
     * `gs://my_bucket/a_b_c_[trg]_translations.[ext]`, where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     *
     * If the document was directly provided through the request, then the
     * output document will have the format:
     * `gs://my_bucket/translated_document_[trg]_translations.[ext]`, where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     * If a glossary was provided, then the output URI for the glossary
     * translation will be equal to the default output URI but have
     * `glossary_translations` instead of `translations`. For the previous
     * example, its glossary URI would be:
     * `gs://my_bucket/a_b_c_[trg]_glossary_translations.[ext]`.
     *
     * Thus the max number of output files will be 2 (Translated document,
     * Glossary translated document).
     *
     * Callers should expect no partial outputs. If there is any error during
     * document translation, no output will be stored in the Cloud Storage
     * bucket.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.translate.v3.GcsDestinationOrBuilder getGcsDestinationOrBuilder() {
      if ((destinationCase_ == 1) && (gcsDestinationBuilder_ != null)) {
        return gcsDestinationBuilder_.getMessageOrBuilder();
      } else {
        if (destinationCase_ == 1) {
          return (com.google.cloud.translate.v3.GcsDestination) destination_;
        }
        return com.google.cloud.translate.v3.GcsDestination.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Google Cloud Storage destination for the translation output,
     * e.g., `gs://my_bucket/my_directory/`.
     *
     * The destination directory provided does not have to be empty, but the
     * bucket must exist. If a file with the same name as the output file
     * already exists in the destination an error will be returned.
     *
     * For a DocumentInputConfig.contents provided document, the output file
     * will have the name "output_[trg]_translations.[ext]", where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     *
     * For a DocumentInputConfig.gcs_uri provided document, the output file will
     * have a name according to its URI. For example: an input file with URI:
     * `gs://a/b/c.[extension]` stored in a gcs_destination bucket with name
     * "my_bucket" will have an output URI:
     * `gs://my_bucket/a_b_c_[trg]_translations.[ext]`, where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     *
     * If the document was directly provided through the request, then the
     * output document will have the format:
     * `gs://my_bucket/translated_document_[trg]_translations.[ext]`, where
     * - [trg] corresponds to the translated file's language code,
     * - [ext] corresponds to the translated file's extension according to its
     * mime type.
     *
     * If a glossary was provided, then the output URI for the glossary
     * translation will be equal to the default output URI but have
     * `glossary_translations` instead of `translations`. For the previous
     * example, its glossary URI would be:
     * `gs://my_bucket/a_b_c_[trg]_glossary_translations.[ext]`.
     *
     * Thus the max number of output files will be 2 (Translated document,
     * Glossary translated document).
     *
     * Callers should expect no partial outputs. If there is any error during
     * document translation, no output will be stored in the Cloud Storage
     * bucket.
     * </pre>
     *
     * <code>
     * .google.cloud.translation.v3.GcsDestination gcs_destination = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.translate.v3.GcsDestination,
            com.google.cloud.translate.v3.GcsDestination.Builder,
            com.google.cloud.translate.v3.GcsDestinationOrBuilder>
        getGcsDestinationFieldBuilder() {
      if (gcsDestinationBuilder_ == null) {
        if (!(destinationCase_ == 1)) {
          destination_ = com.google.cloud.translate.v3.GcsDestination.getDefaultInstance();
        }
        gcsDestinationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.translate.v3.GcsDestination,
                com.google.cloud.translate.v3.GcsDestination.Builder,
                com.google.cloud.translate.v3.GcsDestinationOrBuilder>(
                (com.google.cloud.translate.v3.GcsDestination) destination_,
                getParentForChildren(),
                isClean());
        destination_ = null;
      }
      destinationCase_ = 1;
      onChanged();
      return gcsDestinationBuilder_;
    }

    private java.lang.Object mimeType_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Specifies the translated document's mime_type.
     * If not specified, the translated file's mime type will be the same as the
     * input file's mime type.
     * Currently only support the output mime type to be the same as input mime
     * type.
     * - application/pdf
     * - application/vnd.openxmlformats-officedocument.wordprocessingml.document
     * - application/vnd.openxmlformats-officedocument.presentationml.presentation
     * - application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
     * </pre>
     *
     * <code>string mime_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The mimeType.
     */
    public java.lang.String getMimeType() {
      java.lang.Object ref = mimeType_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        mimeType_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the translated document's mime_type.
     * If not specified, the translated file's mime type will be the same as the
     * input file's mime type.
     * Currently only support the output mime type to be the same as input mime
     * type.
     * - application/pdf
     * - application/vnd.openxmlformats-officedocument.wordprocessingml.document
     * - application/vnd.openxmlformats-officedocument.presentationml.presentation
     * - application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
     * </pre>
     *
     * <code>string mime_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for mimeType.
     */
    public com.google.protobuf.ByteString getMimeTypeBytes() {
      java.lang.Object ref = mimeType_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        mimeType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the translated document's mime_type.
     * If not specified, the translated file's mime type will be the same as the
     * input file's mime type.
     * Currently only support the output mime type to be the same as input mime
     * type.
     * - application/pdf
     * - application/vnd.openxmlformats-officedocument.wordprocessingml.document
     * - application/vnd.openxmlformats-officedocument.presentationml.presentation
     * - application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
     * </pre>
     *
     * <code>string mime_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The mimeType to set.
     * @return This builder for chaining.
     */
    public Builder setMimeType(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      mimeType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the translated document's mime_type.
     * If not specified, the translated file's mime type will be the same as the
     * input file's mime type.
     * Currently only support the output mime type to be the same as input mime
     * type.
     * - application/pdf
     * - application/vnd.openxmlformats-officedocument.wordprocessingml.document
     * - application/vnd.openxmlformats-officedocument.presentationml.presentation
     * - application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
     * </pre>
     *
     * <code>string mime_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMimeType() {
      mimeType_ = getDefaultInstance().getMimeType();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Specifies the translated document's mime_type.
     * If not specified, the translated file's mime type will be the same as the
     * input file's mime type.
     * Currently only support the output mime type to be the same as input mime
     * type.
     * - application/pdf
     * - application/vnd.openxmlformats-officedocument.wordprocessingml.document
     * - application/vnd.openxmlformats-officedocument.presentationml.presentation
     * - application/vnd.openxmlformats-officedocument.spreadsheetml.sheet
     * </pre>
     *
     * <code>string mime_type = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for mimeType to set.
     * @return This builder for chaining.
     */
    public Builder setMimeTypeBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      mimeType_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.translation.v3.DocumentOutputConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.translation.v3.DocumentOutputConfig)
  private static final com.google.cloud.translate.v3.DocumentOutputConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.translate.v3.DocumentOutputConfig();
  }

  public static com.google.cloud.translate.v3.DocumentOutputConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DocumentOutputConfig> PARSER =
      new com.google.protobuf.AbstractParser<DocumentOutputConfig>() {
        @java.lang.Override
        public DocumentOutputConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DocumentOutputConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DocumentOutputConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.translate.v3.DocumentOutputConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
